dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2, or (at your option)
dnl any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
dnl 02111-1307, USA.
dnl
dnl As a special exception, the Free Software Foundation gives unlimited
dnl permission to copy, distribute and modify the configure scripts that
dnl are the output of Autoconf.  You need not follow the terms of the GNU
dnl General Public License when using or distributing such scripts, even
dnl though portions of the text of Autoconf appear in them.  The GNU
dnl General Public License (GPL) does govern all other use of the material
dnl that constitutes the Autoconf program.
dnl
dnl Certain portions of the Autoconf source text are designed to be copied
dnl (in certain cases, depending on the input) into the output of
dnl Autoconf.  We call these the "data" portions.  The rest of the Autoconf
dnl source text consists of comments plus executable code that decides which
dnl of the data portions to output in any given case.  We call these
dnl comments and executable code the "non-data" portions.  Autoconf never
dnl copies any of the non-data portions into its output.
dnl
dnl This special exception to the GPL applies to versions of Autoconf
dnl released by the Free Software Foundation.  When you make and
dnl distribute a modified version of Autoconf, you may extend this special
dnl exception to the GPL to apply to your modified version as well, *unless*
dnl your modified version has the potential to copy into its output some
dnl of the text that was the non-data portion of the version that you started
dnl with.  (In other words, unless your change moves or copies text from
dnl the non-data portions to the data portions.)  If your modification has
dnl such potential, you must delete any notice of this special exception
dnl to the GPL from your modified version.
dnl
dnl Copyright Toby White <tow21@cam.ac.uk>  2004-2006     

dnl A macro to determine which compiler is being used, in order that
dnl different flags can be set

AC_DEFUN([TW_FC_ID], [
AC_REQUIRE([AC_PROG_FC])

FC_ID=

dnl Firstly go by compiler name.

case $FC in 
   
   g77*)
      FC_ID=G77
      ;;

   g95*)
      FC_ID=G95
      ;;

   gfortran*)
      FC_ID=Gfortran
      ;;

   if*)
      FC_ID=Intel
      ;;

   lf9*)
      FC_ID=Lahey
      ;;
   
   path*)
      FC_ID=Pathscale
      ;;

   pgf*)
      FC_ID=Portland
      ;;

   xlf*)
      FC_ID=Xlf 

esac

dnl then try and disambiguate all f77, f90, and f95 types.
dnl We should have a choice between
dnl nag. absoft. sun. sgi. digital. hp. cray. ...?

if test x$FC_ID = x; then
   tw_fc_v_output=$($FC -V 2>&1 )
   if test $?; then
      case $tw_fc_v_output in
         *NAG*)
            FC_ID=Nag
            ;;
         *Sun*)
            FC_ID=Sun # there's more than one compiler here ...
            ;;
         *Absoft*)
            FC_ID=Absoft # there's more than one compiler here ...
            ;;
      esac
   fi
fi
 if test x$FC_ID = x; then
   tw_fc_v_output=$($FC -version 2>&1)
   if test $?; then
      case $tw_fc_v_output in
         *Compaq*)
            FC_ID=Digital
            ;;
         *Digital*)
            FC_ID=Digital
            ;;
         *SGI*)
            FC_ID=SGI
            ;;
      esac
   fi
fi   
   
AS_IF([test x$FC_ID != x],
      [AC_MSG_NOTICE([$FC seems to be a $FC_ID compiler])],
      [FC_ID=unknown; AC_MSG_NOTICE([Could not determine type of compiler])])

dnl for more fun, try and get the version number now ...


])# TW_FC_ID
