// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file TypeIdentifierTypes.cpp
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#include <cstring>
#include <utility>

#include <fastdds/rtps/common/CdrSerialization.hpp>
#include <fastrtps/types/TypeIdentifier.h>
#include <fastrtps/types/TypeIdentifierTypes.h>
#include <fastrtps/qos/QosPolicies.h>

using namespace eprosima::fastcdr::exception;

#include "TypeIdentifierTypesCdrAux.ipp"

namespace eprosima {
namespace fastrtps {
namespace types {



StringSTypeDefn::StringSTypeDefn()
{
    m_bound = 0;
}

StringSTypeDefn::~StringSTypeDefn()
{
}

StringSTypeDefn::StringSTypeDefn(
        const StringSTypeDefn& x)
{
    m_bound = x.m_bound;
}

StringSTypeDefn::StringSTypeDefn(
        StringSTypeDefn&& x)
{
    m_bound = x.m_bound;
}

StringSTypeDefn& StringSTypeDefn::operator =(
        const StringSTypeDefn& x)
{
    m_bound = x.m_bound;

    return *this;
}

StringSTypeDefn& StringSTypeDefn::operator =(
        StringSTypeDefn&& x)
{
    m_bound = x.m_bound;

    return *this;
}

size_t StringSTypeDefn::getCdrSerializedSize(
        const StringSTypeDefn& data,
        size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    eprosima::fastcdr::CdrSizeCalculator calculator(eprosima::fastcdr::CdrVersion::XCDRv1);
    return eprosima::fastcdr::calculate_serialized_size(calculator, data, current_alignment) - initial_alignment;
}

void StringSTypeDefn::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    eprosima::fastcdr::serialize(scdr, *this);
}

void StringSTypeDefn::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    eprosima::fastcdr::deserialize(dcdr, *this);
}

bool StringSTypeDefn::consistent(
        const StringSTypeDefn& x,
        const TypeConsistencyEnforcementQosPolicy& consistency) const
{
    return (consistency.m_kind == ALLOW_TYPE_COERCION && consistency.m_ignore_string_bounds)
           || m_bound >= x.m_bound;
}

bool StringSTypeDefn::consistent(
        const StringLTypeDefn& x,
        const TypeConsistencyEnforcementQosPolicy& consistency) const
{
    return (consistency.m_kind == ALLOW_TYPE_COERCION && consistency.m_ignore_string_bounds)
           || m_bound >= x.bound();
}

StringLTypeDefn::StringLTypeDefn()
{
    m_bound = 0;
}

StringLTypeDefn::~StringLTypeDefn()
{
}

StringLTypeDefn::StringLTypeDefn(
        const StringLTypeDefn& x)
{
    m_bound = x.m_bound;
}

StringLTypeDefn::StringLTypeDefn(
        StringLTypeDefn&& x)
{
    m_bound = x.m_bound;
}

StringLTypeDefn& StringLTypeDefn::operator =(
        const StringLTypeDefn& x)
{
    m_bound = x.m_bound;

    return *this;
}

StringLTypeDefn& StringLTypeDefn::operator =(
        StringLTypeDefn&& x)
{
    m_bound = x.m_bound;

    return *this;
}

size_t StringLTypeDefn::getCdrSerializedSize(
        const StringLTypeDefn& data,
        size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    eprosima::fastcdr::CdrSizeCalculator calculator(eprosima::fastcdr::CdrVersion::XCDRv1);
    return eprosima::fastcdr::calculate_serialized_size(calculator, data, current_alignment) - initial_alignment;
}

void StringLTypeDefn::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    eprosima::fastcdr::serialize(scdr, *this);
}

void StringLTypeDefn::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    eprosima::fastcdr::deserialize(dcdr, *this);
}

bool StringLTypeDefn::consistent(
        const StringLTypeDefn& x,
        const TypeConsistencyEnforcementQosPolicy& consistency) const
{
    return (consistency.m_kind == ALLOW_TYPE_COERCION && consistency.m_ignore_string_bounds)
           || m_bound >= x.m_bound;
}

bool StringLTypeDefn::consistent(
        const StringSTypeDefn& x,
        const TypeConsistencyEnforcementQosPolicy& consistency) const
{
    return (consistency.m_kind == ALLOW_TYPE_COERCION && consistency.m_ignore_string_bounds)
           || m_bound >= x.bound();
}

PlainCollectionHeader::PlainCollectionHeader()
{
    m_equiv_kind = 0;
}

PlainCollectionHeader::~PlainCollectionHeader()
{
}

PlainCollectionHeader::PlainCollectionHeader(
        const PlainCollectionHeader& x)
{
    m_equiv_kind = x.m_equiv_kind;
    m_element_flags = x.m_element_flags;
}

PlainCollectionHeader::PlainCollectionHeader(
        PlainCollectionHeader&& x)
{
    m_equiv_kind = x.m_equiv_kind;
    m_element_flags = x.m_element_flags;
}

PlainCollectionHeader& PlainCollectionHeader::operator =(
        const PlainCollectionHeader& x)
{
    m_equiv_kind = x.m_equiv_kind;
    m_element_flags = x.m_element_flags;

    return *this;
}

PlainCollectionHeader& PlainCollectionHeader::operator =(
        PlainCollectionHeader&& x)
{
    m_equiv_kind = x.m_equiv_kind;
    m_element_flags = x.m_element_flags;

    return *this;
}

size_t PlainCollectionHeader::getCdrSerializedSize(
        const PlainCollectionHeader& data,
        size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    eprosima::fastcdr::CdrSizeCalculator calculator(eprosima::fastcdr::CdrVersion::XCDRv1);
    return eprosima::fastcdr::calculate_serialized_size(calculator, data, current_alignment) - initial_alignment;
}

void PlainCollectionHeader::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    eprosima::fastcdr::serialize(scdr, *this);
}

void PlainCollectionHeader::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    eprosima::fastcdr::deserialize(dcdr, *this);
}

bool PlainCollectionHeader::consistent(
        const PlainCollectionHeader& x,
        const TypeConsistencyEnforcementQosPolicy&) const
{
    return m_equiv_kind == x.m_equiv_kind;
}

PlainSequenceSElemDefn::PlainSequenceSElemDefn()
{

    m_bound = 0;
    m_element_identifier = nullptr;
}

PlainSequenceSElemDefn::~PlainSequenceSElemDefn()
{
    delete m_element_identifier;
}

void PlainSequenceSElemDefn::element_identifier(
        const TypeIdentifier* _element_identifier)
{
    if (_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }
}

PlainSequenceSElemDefn::PlainSequenceSElemDefn(
        const PlainSequenceSElemDefn& x)
{
    m_header = x.m_header;
    m_bound = x.m_bound;
    if (x.m_element_identifier != nullptr)
    {
        m_element_identifier = new TypeIdentifier();
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        m_element_identifier = nullptr;
    }
}

PlainSequenceSElemDefn::PlainSequenceSElemDefn(
        PlainSequenceSElemDefn&& x)
{
    m_header = std::move(x.m_header);
    m_bound = x.m_bound;
    if (x.m_element_identifier != nullptr)
    {
        m_element_identifier = new TypeIdentifier();
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        m_element_identifier = nullptr;
    }
}

PlainSequenceSElemDefn& PlainSequenceSElemDefn::operator =(
        const PlainSequenceSElemDefn& x)
{
    m_header = x.m_header;
    m_bound = x.m_bound;
    if (x.m_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }

    return *this;
}

PlainSequenceSElemDefn& PlainSequenceSElemDefn::operator =(
        PlainSequenceSElemDefn&& x)
{
    m_header = std::move(x.m_header);
    m_bound = x.m_bound;
    if (x.m_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }

    return *this;
}

size_t PlainSequenceSElemDefn::getCdrSerializedSize(
        const PlainSequenceSElemDefn& data,
        size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    eprosima::fastcdr::CdrSizeCalculator calculator(eprosima::fastcdr::CdrVersion::XCDRv1);
    return eprosima::fastcdr::calculate_serialized_size(calculator, data, current_alignment) - initial_alignment;
}

void PlainSequenceSElemDefn::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    eprosima::fastcdr::serialize(scdr, *this);
}

void PlainSequenceSElemDefn::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    eprosima::fastcdr::deserialize(dcdr, *this);
}

bool PlainSequenceSElemDefn::consistent(
        const PlainSequenceSElemDefn& x,
        const TypeConsistencyEnforcementQosPolicy& consistency) const
{
    if (m_header.consistent(x.m_header, consistency))
    {
        if ((consistency.m_kind == ALLOW_TYPE_COERCION && consistency.m_ignore_sequence_bounds)
                || m_bound >= x.m_bound)
        {
            if (m_element_identifier == x.m_element_identifier
                    || (m_element_identifier != nullptr && x.m_element_identifier != nullptr))
            {
                return m_element_identifier->consistent(*x.m_element_identifier, consistency);
            }
        }
    }
    return false;
}

PlainSequenceLElemDefn::PlainSequenceLElemDefn()
{
    m_bound = 0;
    m_element_identifier = nullptr;
}

PlainSequenceLElemDefn::~PlainSequenceLElemDefn()
{
    delete m_element_identifier;
}

void PlainSequenceLElemDefn::element_identifier(
        const TypeIdentifier* _element_identifier)
{
    if (_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }
}

PlainSequenceLElemDefn::PlainSequenceLElemDefn(
        const PlainSequenceLElemDefn& x)
{
    m_header = x.m_header;
    m_bound = x.m_bound;
    if (x.m_element_identifier != nullptr)
    {
        m_element_identifier = new TypeIdentifier();
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        m_element_identifier = nullptr;
    }
}

PlainSequenceLElemDefn::PlainSequenceLElemDefn(
        PlainSequenceLElemDefn&& x)
{
    m_header = std::move(x.m_header);
    m_bound = x.m_bound;
    if (x.m_element_identifier != nullptr)
    {
        m_element_identifier = new TypeIdentifier();
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        m_element_identifier = nullptr;
    }
}

PlainSequenceLElemDefn& PlainSequenceLElemDefn::operator =(
        const PlainSequenceLElemDefn& x)
{
    m_header = x.m_header;
    m_bound = x.m_bound;
    if (x.m_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }

    return *this;
}

PlainSequenceLElemDefn& PlainSequenceLElemDefn::operator =(
        PlainSequenceLElemDefn&& x)
{
    m_header = std::move(x.m_header);
    m_bound = x.m_bound;
    if (x.m_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }

    return *this;
}

size_t PlainSequenceLElemDefn::getCdrSerializedSize(
        const PlainSequenceLElemDefn& data,
        size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    eprosima::fastcdr::CdrSizeCalculator calculator(eprosima::fastcdr::CdrVersion::XCDRv1);
    return eprosima::fastcdr::calculate_serialized_size(calculator, data, current_alignment) - initial_alignment;
}

void PlainSequenceLElemDefn::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    eprosima::fastcdr::serialize(scdr, *this);
}

void PlainSequenceLElemDefn::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    eprosima::fastcdr::deserialize(dcdr, *this);
}

bool PlainSequenceLElemDefn::consistent(
        const PlainSequenceLElemDefn& x,
        const TypeConsistencyEnforcementQosPolicy& consistency) const
{
    if (m_header.consistent(x.m_header, consistency))
    {
        if ((consistency.m_kind == ALLOW_TYPE_COERCION && consistency.m_ignore_sequence_bounds)
                || m_bound >= x.m_bound)
        {
            if (m_element_identifier == x.m_element_identifier
                    || (m_element_identifier != nullptr && x.m_element_identifier != nullptr))
            {
                return m_element_identifier->consistent(*x.m_element_identifier, consistency);
            }
        }
    }
    return false;
}

PlainArraySElemDefn::PlainArraySElemDefn()
{


    m_element_identifier = nullptr;
}

PlainArraySElemDefn::~PlainArraySElemDefn()
{
    delete m_element_identifier;
}

void PlainArraySElemDefn::element_identifier(
        const TypeIdentifier* _element_identifier)
{
    if (_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }
}

PlainArraySElemDefn::PlainArraySElemDefn(
        const PlainArraySElemDefn& x)
{
    m_header = x.m_header;
    m_array_bound_seq = x.m_array_bound_seq;
    if (x.m_element_identifier != nullptr)
    {
        m_element_identifier = new TypeIdentifier();
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        m_element_identifier = nullptr;
    }
}

PlainArraySElemDefn::PlainArraySElemDefn(
        PlainArraySElemDefn&& x)
{
    m_header = std::move(x.m_header);
    m_array_bound_seq = std::move(x.m_array_bound_seq);
    if (x.m_element_identifier != nullptr)
    {
        m_element_identifier = new TypeIdentifier();
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }
}

PlainArraySElemDefn& PlainArraySElemDefn::operator =(
        const PlainArraySElemDefn& x)
{
    m_header = x.m_header;
    m_array_bound_seq = x.m_array_bound_seq;
    if (x.m_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }

    return *this;
}

PlainArraySElemDefn& PlainArraySElemDefn::operator =(
        PlainArraySElemDefn&& x)
{
    m_header = std::move(x.m_header);
    m_array_bound_seq = std::move(x.m_array_bound_seq);
    if (x.m_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }

    return *this;
}

size_t PlainArraySElemDefn::getCdrSerializedSize(
        const PlainArraySElemDefn& data,
        size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    eprosima::fastcdr::CdrSizeCalculator calculator(eprosima::fastcdr::CdrVersion::XCDRv1);
    return eprosima::fastcdr::calculate_serialized_size(calculator, data, current_alignment) - initial_alignment;
}

void PlainArraySElemDefn::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    eprosima::fastcdr::serialize(scdr, *this);
}

void PlainArraySElemDefn::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    eprosima::fastcdr::deserialize(dcdr, *this);
}

bool PlainArraySElemDefn::consistent(
        const PlainArraySElemDefn& x,
        const TypeConsistencyEnforcementQosPolicy& consistency) const
{
    if (m_header.consistent(x.m_header, consistency))
    {
        if (m_array_bound_seq.size() == x.m_array_bound_seq.size())
        {
            auto local_it = m_array_bound_seq.begin();
            auto remote_it = x.m_array_bound_seq.begin();

            while (local_it != m_array_bound_seq.end())
            {
                if (*local_it != *remote_it)
                {
                    return false;
                }
                ++local_it;
                ++remote_it;
            }

            if (m_element_identifier == x.m_element_identifier
                    || (m_element_identifier != nullptr && x.m_element_identifier != nullptr))
            {
                return m_element_identifier->consistent(*x.m_element_identifier, consistency);
            }
        }
    }
    return false;
}

PlainArrayLElemDefn::PlainArrayLElemDefn()
{


    m_element_identifier = nullptr;
}

PlainArrayLElemDefn::~PlainArrayLElemDefn()
{
    delete m_element_identifier;
}

void PlainArrayLElemDefn::element_identifier(
        const TypeIdentifier* _element_identifier)
{
    if (_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }
}

PlainArrayLElemDefn::PlainArrayLElemDefn(
        const PlainArrayLElemDefn& x)
{
    m_header = x.m_header;
    m_array_bound_seq = x.m_array_bound_seq;
    if (x.m_element_identifier != nullptr)
    {
        m_element_identifier = new TypeIdentifier();
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        m_element_identifier = nullptr;
    }
}

PlainArrayLElemDefn::PlainArrayLElemDefn(
        PlainArrayLElemDefn&& x)
{
    m_header = std::move(x.m_header);
    m_array_bound_seq = std::move(x.m_array_bound_seq);
    if (x.m_element_identifier != nullptr)
    {
        m_element_identifier = new TypeIdentifier();
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        m_element_identifier = nullptr;
    }
}

PlainArrayLElemDefn& PlainArrayLElemDefn::operator =(
        const PlainArrayLElemDefn& x)
{
    m_header = x.m_header;
    m_array_bound_seq = x.m_array_bound_seq;
    if (x.m_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }

    return *this;
}

PlainArrayLElemDefn& PlainArrayLElemDefn::operator =(
        PlainArrayLElemDefn&& x)
{
    m_header = std::move(x.m_header);
    m_array_bound_seq = std::move(x.m_array_bound_seq);
    if (x.m_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }

    return *this;
}

size_t PlainArrayLElemDefn::getCdrSerializedSize(
        const PlainArrayLElemDefn& data,
        size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    eprosima::fastcdr::CdrSizeCalculator calculator(eprosima::fastcdr::CdrVersion::XCDRv1);
    return eprosima::fastcdr::calculate_serialized_size(calculator, data, current_alignment) - initial_alignment;
}

void PlainArrayLElemDefn::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    eprosima::fastcdr::serialize(scdr, *this);
}

void PlainArrayLElemDefn::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    eprosima::fastcdr::deserialize(dcdr, *this);
}

bool PlainArrayLElemDefn::consistent(
        const PlainArrayLElemDefn& x,
        const TypeConsistencyEnforcementQosPolicy& consistency) const
{
    if (m_header.consistent(x.m_header, consistency))
    {
        if (m_array_bound_seq.size() == x.m_array_bound_seq.size())
        {
            auto local_it = m_array_bound_seq.begin();
            auto remote_it = x.m_array_bound_seq.begin();

            while (local_it != m_array_bound_seq.end())
            {
                if (*local_it != *remote_it)
                {
                    return false;
                }
                ++local_it;
                ++remote_it;
            }

            if (m_element_identifier == x.m_element_identifier
                    || (m_element_identifier != nullptr && x.m_element_identifier != nullptr))
            {
                return m_element_identifier->consistent(*x.m_element_identifier, consistency);
            }
        }
    }
    return false;
}

PlainMapSTypeDefn::PlainMapSTypeDefn()
{

    m_bound = 0;
    m_element_identifier = nullptr;
    m_key_identifier = nullptr;
}

PlainMapSTypeDefn::~PlainMapSTypeDefn()
{
    delete m_element_identifier;
    delete m_key_identifier;
}

void PlainMapSTypeDefn::element_identifier(
        const TypeIdentifier* _element_identifier)
{
    if (_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }
}

void PlainMapSTypeDefn::key_identifier(
        const TypeIdentifier* _key_identifier)
{
    if (_key_identifier != nullptr)
    {
        if (m_key_identifier == nullptr)
        {
            m_key_identifier = new TypeIdentifier();
        }
        *m_key_identifier = *_key_identifier;
    }
    else
    {
        delete m_key_identifier;
        m_key_identifier = nullptr;
    }
}

PlainMapSTypeDefn::PlainMapSTypeDefn(
        const PlainMapSTypeDefn& x)
{
    m_header = x.m_header;
    m_bound = x.m_bound;
    if (x.m_element_identifier != nullptr)
    {
        m_element_identifier = new TypeIdentifier();
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        m_element_identifier = nullptr;
    }
    m_key_flags = x.m_key_flags;
    if (x.m_key_identifier != nullptr)
    {
        m_key_identifier = new TypeIdentifier();
        *m_key_identifier = *x.m_key_identifier;
    }
    else
    {
        m_key_identifier = nullptr;
    }
}

PlainMapSTypeDefn::PlainMapSTypeDefn(
        PlainMapSTypeDefn&& x)
{
    m_header = std::move(x.m_header);
    m_bound = x.m_bound;
    if (x.m_element_identifier != nullptr)
    {
        m_element_identifier = new TypeIdentifier();
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        m_element_identifier = nullptr;
    }
    m_key_flags = x.m_key_flags;
    if (x.m_key_identifier != nullptr)
    {
        m_key_identifier = new TypeIdentifier();
        *m_key_identifier = *x.m_key_identifier;
    }
    else
    {
        m_key_identifier = nullptr;
    }
}

PlainMapSTypeDefn& PlainMapSTypeDefn::operator =(
        const PlainMapSTypeDefn& x)
{
    m_header = x.m_header;
    m_bound = x.m_bound;
    if (x.m_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }
    m_key_flags = x.m_key_flags;
    if (x.m_key_identifier != nullptr)
    {
        if (m_key_identifier == nullptr)
        {
            m_key_identifier = new TypeIdentifier();
        }
        *m_key_identifier = *x.m_key_identifier;
    }
    else
    {
        delete m_key_identifier;
        m_key_identifier = nullptr;
    }

    return *this;
}

PlainMapSTypeDefn& PlainMapSTypeDefn::operator =(
        PlainMapSTypeDefn&& x)
{
    m_header = std::move(x.m_header);
    m_bound = x.m_bound;
    if (x.m_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }
    m_key_flags = x.m_key_flags;
    if (x.m_key_identifier != nullptr)
    {
        if (m_key_identifier == nullptr)
        {
            m_key_identifier = new TypeIdentifier();
        }
        *m_key_identifier = *x.m_key_identifier;
    }
    else
    {
        delete m_key_identifier;
        m_key_identifier = nullptr;
    }

    return *this;
}

size_t PlainMapSTypeDefn::getCdrSerializedSize(
        const PlainMapSTypeDefn& data,
        size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    eprosima::fastcdr::CdrSizeCalculator calculator(eprosima::fastcdr::CdrVersion::XCDRv1);
    return eprosima::fastcdr::calculate_serialized_size(calculator, data, current_alignment) - initial_alignment;
}

void PlainMapSTypeDefn::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    eprosima::fastcdr::serialize(scdr, *this);
}

void PlainMapSTypeDefn::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    eprosima::fastcdr::deserialize(dcdr, *this);
}

bool PlainMapSTypeDefn::consistent(
        const PlainMapSTypeDefn& x,
        const TypeConsistencyEnforcementQosPolicy& consistency) const
{
    if (m_header.consistent(x.m_header, consistency))
    {
        if ((consistency.m_kind == ALLOW_TYPE_COERCION && consistency.m_ignore_sequence_bounds)
                || m_bound == x.m_bound)
        {
            if (m_element_identifier != x.m_element_identifier)
            {
                if (m_element_identifier != nullptr && x.m_element_identifier != nullptr)
                {
                    if (!m_element_identifier->consistent(*x.m_element_identifier, consistency))
                    {
                        return false; // Elements inconsistent
                    }
                }
                else
                {
                    return false; // One element doesn't exists
                }
            }
            // Elements are consistent

            if (m_key_identifier != x.m_key_identifier)
            {
                if (m_key_identifier != nullptr && x.m_key_identifier != nullptr)
                {
                    if (!m_key_identifier->consistent(*x.m_key_identifier, consistency))
                    {
                        return false; // Keys inconsistent
                    }
                }
                else
                {
                    return false; // One key doesn't exists
                }
            }
            // Both are consistent
            return true;
        }
    }
    return false;
}

PlainMapLTypeDefn::PlainMapLTypeDefn()
{

    m_element_identifier = nullptr;
    m_key_identifier = nullptr;
}

PlainMapLTypeDefn::~PlainMapLTypeDefn()
{
    delete m_element_identifier;
    delete m_key_identifier;
}

void PlainMapLTypeDefn::element_identifier(
        const TypeIdentifier* _element_identifier)
{
    if (_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }
}

void PlainMapLTypeDefn::key_identifier(
        const TypeIdentifier* _key_identifier)
{
    if (_key_identifier != nullptr)
    {
        if (m_key_identifier == nullptr)
        {
            m_key_identifier = new TypeIdentifier();
        }
        *m_key_identifier = *_key_identifier;
    }
    else
    {
        delete m_key_identifier;
        m_key_identifier = nullptr;
    }
}

PlainMapLTypeDefn::PlainMapLTypeDefn(
        const PlainMapLTypeDefn& x)
{
    m_header = x.m_header;
    m_bound = x.m_bound;
    if (x.m_element_identifier != nullptr)
    {
        m_element_identifier = new TypeIdentifier();
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        m_element_identifier = nullptr;
    }
    m_key_flags = x.m_key_flags;
    if (x.m_key_identifier != nullptr)
    {
        m_key_identifier = new TypeIdentifier();
        *m_key_identifier = *x.m_key_identifier;
    }
    else
    {
        m_key_identifier = nullptr;
    }
}

PlainMapLTypeDefn::PlainMapLTypeDefn(
        PlainMapLTypeDefn&& x)
{
    m_header = std::move(x.m_header);
    m_bound = x.m_bound;
    if (x.m_element_identifier != nullptr)
    {
        m_element_identifier = new TypeIdentifier();
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        m_element_identifier = nullptr;
    }
    m_key_flags = x.m_key_flags;
    if (x.m_key_identifier != nullptr)
    {
        m_key_identifier = new TypeIdentifier();
        *m_key_identifier = *x.m_key_identifier;
    }
    else
    {
        m_key_identifier = nullptr;
    }
}

PlainMapLTypeDefn& PlainMapLTypeDefn::operator =(
        const PlainMapLTypeDefn& x)
{
    m_header = x.m_header;
    m_bound = x.m_bound;
    if (x.m_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }
    m_key_flags = x.m_key_flags;
    if (x.m_key_identifier != nullptr)
    {
        if (m_key_identifier == nullptr)
        {
            m_key_identifier = new TypeIdentifier();
        }
        *m_key_identifier = *x.m_key_identifier;
    }
    else
    {
        delete m_key_identifier;
        m_key_identifier = nullptr;
    }

    return *this;
}

PlainMapLTypeDefn& PlainMapLTypeDefn::operator =(
        PlainMapLTypeDefn&& x)
{
    m_header = std::move(x.m_header);
    m_bound = x.m_bound;
    if (x.m_element_identifier != nullptr)
    {
        if (m_element_identifier == nullptr)
        {
            m_element_identifier = new TypeIdentifier();
        }
        *m_element_identifier = *x.m_element_identifier;
    }
    else
    {
        delete m_element_identifier;
        m_element_identifier = nullptr;
    }
    m_key_flags = x.m_key_flags;
    if (x.m_key_identifier != nullptr)
    {
        if (m_key_identifier == nullptr)
        {
            m_key_identifier = new TypeIdentifier();
        }
        *m_key_identifier = *x.m_key_identifier;
    }
    else
    {
        delete m_key_identifier;
        m_key_identifier = nullptr;
    }

    return *this;
}

size_t PlainMapLTypeDefn::getCdrSerializedSize(
        const PlainMapLTypeDefn& data,
        size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    eprosima::fastcdr::CdrSizeCalculator calculator(eprosima::fastcdr::CdrVersion::XCDRv1);
    return eprosima::fastcdr::calculate_serialized_size(calculator, data, current_alignment) - initial_alignment;
}

void PlainMapLTypeDefn::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    eprosima::fastcdr::serialize(scdr, *this);
}

void PlainMapLTypeDefn::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    eprosima::fastcdr::deserialize(dcdr, *this);
}

bool PlainMapLTypeDefn::consistent(
        const PlainMapLTypeDefn& x,
        const TypeConsistencyEnforcementQosPolicy& consistency) const
{
    if (m_header.consistent(x.m_header, consistency))
    {
        if ((consistency.m_kind == ALLOW_TYPE_COERCION && consistency.m_ignore_sequence_bounds)
                || m_bound == x.m_bound)
        {
            if (m_element_identifier != x.m_element_identifier)
            {
                if (m_element_identifier != nullptr && x.m_element_identifier != nullptr)
                {
                    if (!m_element_identifier->consistent(*x.m_element_identifier, consistency))
                    {
                        return false; // Elements inconsistent
                    }
                }
                else
                {
                    return false; // One element doesn't exists
                }
            }
            // Elements are consistent

            if (m_key_identifier != x.m_key_identifier)
            {
                if (m_key_identifier != nullptr && x.m_key_identifier != nullptr)
                {
                    if (!m_key_identifier->consistent(*x.m_key_identifier, consistency))
                    {
                        return false; // Keys inconsistent
                    }
                }
                else
                {
                    return false; // One key doesn't exists
                }
            }
            // Both are consistent
            return true;
        }
    }
    return false;
}

StronglyConnectedComponentId::StronglyConnectedComponentId()
{

    m_scc_length = 0;
    m_scc_index = 0;
}

StronglyConnectedComponentId::~StronglyConnectedComponentId()
{
}

StronglyConnectedComponentId::StronglyConnectedComponentId(
        const StronglyConnectedComponentId& x)
{
    m_sc_component_id = x.m_sc_component_id;
    m_scc_length = x.m_scc_length;
    m_scc_index = x.m_scc_index;
}

StronglyConnectedComponentId::StronglyConnectedComponentId(
        StronglyConnectedComponentId&& x)
{
    m_sc_component_id = std::move(x.m_sc_component_id);
    m_scc_length = x.m_scc_length;
    m_scc_index = x.m_scc_index;
}

StronglyConnectedComponentId& StronglyConnectedComponentId::operator =(
        const StronglyConnectedComponentId& x)
{
    m_sc_component_id = x.m_sc_component_id;
    m_scc_length = x.m_scc_length;
    m_scc_index = x.m_scc_index;

    return *this;
}

StronglyConnectedComponentId& StronglyConnectedComponentId::operator =(
        StronglyConnectedComponentId&& x)
{
    m_sc_component_id = std::move(x.m_sc_component_id);
    m_scc_length = x.m_scc_length;
    m_scc_index = x.m_scc_index;

    return *this;
}

size_t StronglyConnectedComponentId::getCdrSerializedSize(
        const StronglyConnectedComponentId& data,
        size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    eprosima::fastcdr::CdrSizeCalculator calculator(eprosima::fastcdr::CdrVersion::XCDRv1);
    return eprosima::fastcdr::calculate_serialized_size(calculator, data, current_alignment) - initial_alignment;
}

void StronglyConnectedComponentId::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    eprosima::fastcdr::serialize(scdr, *this);
}

void StronglyConnectedComponentId::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    eprosima::fastcdr::deserialize(dcdr, *this);
}

bool StronglyConnectedComponentId::consistent(
        const StronglyConnectedComponentId& x,
        const TypeConsistencyEnforcementQosPolicy&) const
{
    // TODO It is neccessary apply some TypeConsistencyEnforcementQosPolicy?
    return std::memcmp(m_sc_component_id.hash(), x.m_sc_component_id.hash(), 14) == 0
           && m_scc_index == x.m_scc_index
           && m_scc_length == x.m_scc_length;
}

ExtendedTypeDefn::ExtendedTypeDefn()
{
}

ExtendedTypeDefn::~ExtendedTypeDefn()
{
}

ExtendedTypeDefn::ExtendedTypeDefn(
        const ExtendedTypeDefn&)
{
}

ExtendedTypeDefn::ExtendedTypeDefn(
        ExtendedTypeDefn&&)
{
}

ExtendedTypeDefn& ExtendedTypeDefn::operator =(
        const ExtendedTypeDefn&)
{
    return *this;
}

ExtendedTypeDefn& ExtendedTypeDefn::operator =(
        ExtendedTypeDefn&&)
{
    return *this;
}

size_t ExtendedTypeDefn::getCdrSerializedSize(
        const ExtendedTypeDefn& data,
        size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    eprosima::fastcdr::CdrSizeCalculator calculator(eprosima::fastcdr::CdrVersion::XCDRv1);
    return eprosima::fastcdr::calculate_serialized_size(calculator, data, current_alignment) - initial_alignment;
}

void ExtendedTypeDefn::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    eprosima::fastcdr::serialize(scdr, *this);
}

void ExtendedTypeDefn::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    eprosima::fastcdr::deserialize(dcdr, *this);
}

bool ExtendedTypeDefn::consistent(
        const ExtendedTypeDefn&,
        const TypeConsistencyEnforcementQosPolicy&) const
{
    return true;
}

} // namespace types
} // namespace fastrtps
} // namespace eprosima
