// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file monitorservice_types.h
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#include <fastcdr/config.h>

#if FASTCDR_VERSION_MAJOR == 1

#ifndef _FAST_DDS_GENERATED_EPROSIMA_FASTDDS_STATISTICS_MONITORSERVICE_TYPES_H_
#define _FAST_DDS_GENERATED_EPROSIMA_FASTDDS_STATISTICS_MONITORSERVICE_TYPES_H_

#include "types.h"

#include <fastrtps/utils/fixed_size_string.hpp>

#include <array>
#include <bitset>
#include <cstdint>
#include <map>
#include <stdint.h>
#include <string>
#include <vector>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(MONITORSERVICE_TYPES_SOURCE)
#define MONITORSERVICE_TYPES_DllAPI __declspec( dllexport )
#else
#define MONITORSERVICE_TYPES_DllAPI __declspec( dllimport )
#endif // MONITORSERVICE_TYPES_SOURCE
#else
#define MONITORSERVICE_TYPES_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define MONITORSERVICE_TYPES_DllAPI
#endif // _WIN32

namespace eprosima {
namespace fastcdr {
class Cdr;
} // namespace fastcdr
} // namespace eprosima



namespace eprosima {
    namespace fastdds {
        namespace statistics {
            /*!
             * @brief This class represents the enumeration ConnectionMode defined by the user in the IDL file.
             * @ingroup monitorservice_types
             */
            enum ConnectionMode : uint32_t
            {
                DATA_SHARING,
                INTRAPROCESS,
                TRANSPORT
            };




            /*!
             * @brief This class represents the structure Connection defined by the user in the IDL file.
             * @ingroup monitorservice_types
             */
            class Connection
            {
            public:

                /*!
                 * @brief Default constructor.
                 */
                eProsima_user_DllExport Connection();

                /*!
                 * @brief Default destructor.
                 */
                eProsima_user_DllExport ~Connection();

                /*!
                 * @brief Copy constructor.
                 * @param x Reference to the object eprosima::fastdds::statistics::Connection that will be copied.
                 */
                eProsima_user_DllExport Connection(
                        const Connection& x);

                /*!
                 * @brief Move constructor.
                 * @param x Reference to the object eprosima::fastdds::statistics::Connection that will be copied.
                 */
                eProsima_user_DllExport Connection(
                        Connection&& x) noexcept;

                /*!
                 * @brief Copy assignment.
                 * @param x Reference to the object eprosima::fastdds::statistics::Connection that will be copied.
                 */
                eProsima_user_DllExport Connection& operator =(
                        const Connection& x);

                /*!
                 * @brief Move assignment.
                 * @param x Reference to the object eprosima::fastdds::statistics::Connection that will be copied.
                 */
                eProsima_user_DllExport Connection& operator =(
                        Connection&& x) noexcept;

                /*!
                 * @brief Comparison operator.
                 * @param x eprosima::fastdds::statistics::Connection object to compare.
                 */
                eProsima_user_DllExport bool operator ==(
                        const Connection& x) const;

                /*!
                 * @brief Comparison operator.
                 * @param x eprosima::fastdds::statistics::Connection object to compare.
                 */
                eProsima_user_DllExport bool operator !=(
                        const Connection& x) const;

                /*!
                 * @brief This function sets a value in member mode
                 * @param _mode New value for member mode
                 */
                eProsima_user_DllExport void mode(
                        eprosima::fastdds::statistics::ConnectionMode _mode);

                /*!
                 * @brief This function returns the value of member mode
                 * @return Value of member mode
                 */
                eProsima_user_DllExport eprosima::fastdds::statistics::ConnectionMode mode() const;

                /*!
                 * @brief This function returns a reference to member mode
                 * @return Reference to member mode
                 */
                eProsima_user_DllExport eprosima::fastdds::statistics::ConnectionMode& mode();


                /*!
                 * @brief This function copies the value in member guid
                 * @param _guid New value to be copied in member guid
                 */
                eProsima_user_DllExport void guid(
                        const eprosima::fastdds::statistics::detail::GUID_s& _guid);

                /*!
                 * @brief This function moves the value in member guid
                 * @param _guid New value to be moved in member guid
                 */
                eProsima_user_DllExport void guid(
                        eprosima::fastdds::statistics::detail::GUID_s&& _guid);

                /*!
                 * @brief This function returns a constant reference to member guid
                 * @return Constant reference to member guid
                 */
                eProsima_user_DllExport const eprosima::fastdds::statistics::detail::GUID_s& guid() const;

                /*!
                 * @brief This function returns a reference to member guid
                 * @return Reference to member guid
                 */
                eProsima_user_DllExport eprosima::fastdds::statistics::detail::GUID_s& guid();


                /*!
                 * @brief This function copies the value in member announced_locators
                 * @param _announced_locators New value to be copied in member announced_locators
                 */
                eProsima_user_DllExport void announced_locators(
                        const std::vector<eprosima::fastdds::statistics::detail::Locator_s>& _announced_locators);

                /*!
                 * @brief This function moves the value in member announced_locators
                 * @param _announced_locators New value to be moved in member announced_locators
                 */
                eProsima_user_DllExport void announced_locators(
                        std::vector<eprosima::fastdds::statistics::detail::Locator_s>&& _announced_locators);

                /*!
                 * @brief This function returns a constant reference to member announced_locators
                 * @return Constant reference to member announced_locators
                 */
                eProsima_user_DllExport const std::vector<eprosima::fastdds::statistics::detail::Locator_s>& announced_locators() const;

                /*!
                 * @brief This function returns a reference to member announced_locators
                 * @return Reference to member announced_locators
                 */
                eProsima_user_DllExport std::vector<eprosima::fastdds::statistics::detail::Locator_s>& announced_locators();


                /*!
                 * @brief This function copies the value in member used_locators
                 * @param _used_locators New value to be copied in member used_locators
                 */
                eProsima_user_DllExport void used_locators(
                        const std::vector<eprosima::fastdds::statistics::detail::Locator_s>& _used_locators);

                /*!
                 * @brief This function moves the value in member used_locators
                 * @param _used_locators New value to be moved in member used_locators
                 */
                eProsima_user_DllExport void used_locators(
                        std::vector<eprosima::fastdds::statistics::detail::Locator_s>&& _used_locators);

                /*!
                 * @brief This function returns a constant reference to member used_locators
                 * @return Constant reference to member used_locators
                 */
                eProsima_user_DllExport const std::vector<eprosima::fastdds::statistics::detail::Locator_s>& used_locators() const;

                /*!
                 * @brief This function returns a reference to member used_locators
                 * @return Reference to member used_locators
                 */
                eProsima_user_DllExport std::vector<eprosima::fastdds::statistics::detail::Locator_s>& used_locators();


                /*!
                * @brief This function returns the maximum serialized size of an object
                * depending on the buffer alignment.
                * @param current_alignment Buffer alignment.
                * @return Maximum serialized size.
                */
                eProsima_user_DllExport static size_t getMaxCdrSerializedSize(
                        size_t current_alignment = 0);

                /*!
                 * @brief This function returns the serialized size of a data depending on the buffer alignment.
                 * @param data Data which is calculated its serialized size.
                 * @param current_alignment Buffer alignment.
                 * @return Serialized size.
                 */
                eProsima_user_DllExport static size_t getCdrSerializedSize(
                        const eprosima::fastdds::statistics::Connection& data,
                        size_t current_alignment = 0);



                /*!
                 * @brief This function serializes an object using CDR serialization.
                 * @param cdr CDR serialization object.
                 */
                eProsima_user_DllExport void serialize(
                        eprosima::fastcdr::Cdr& cdr) const;

                /*!
                 * @brief This function deserializes an object using CDR serialization.
                 * @param cdr CDR serialization object.
                 */
                eProsima_user_DllExport void deserialize(
                        eprosima::fastcdr::Cdr& cdr);




                /*!
                * @brief This function tells you if the Key has been defined for this type
                */
                eProsima_user_DllExport static bool isKeyDefined();

                /*!
                * @brief This function serializes the key members of an object using CDR serialization.
                * @param cdr CDR serialization object.
                */
                eProsima_user_DllExport void serializeKey(
                        eprosima::fastcdr::Cdr& cdr) const;


            private:

                eprosima::fastdds::statistics::ConnectionMode m_mode;
                eprosima::fastdds::statistics::detail::GUID_s m_guid;
                std::vector<eprosima::fastdds::statistics::detail::Locator_s> m_announced_locators;
                std::vector<eprosima::fastdds::statistics::detail::Locator_s> m_used_locators;

            };



            /*!
             * @brief This class represents the structure QosPolicyCount_s defined by the user in the IDL file.
             * @ingroup monitorservice_types
             */
            class QosPolicyCount_s
            {
            public:

                /*!
                 * @brief Default constructor.
                 */
                eProsima_user_DllExport QosPolicyCount_s();

                /*!
                 * @brief Default destructor.
                 */
                eProsima_user_DllExport ~QosPolicyCount_s();

                /*!
                 * @brief Copy constructor.
                 * @param x Reference to the object eprosima::fastdds::statistics::QosPolicyCount_s that will be copied.
                 */
                eProsima_user_DllExport QosPolicyCount_s(
                        const QosPolicyCount_s& x);

                /*!
                 * @brief Move constructor.
                 * @param x Reference to the object eprosima::fastdds::statistics::QosPolicyCount_s that will be copied.
                 */
                eProsima_user_DllExport QosPolicyCount_s(
                        QosPolicyCount_s&& x) noexcept;

                /*!
                 * @brief Copy assignment.
                 * @param x Reference to the object eprosima::fastdds::statistics::QosPolicyCount_s that will be copied.
                 */
                eProsima_user_DllExport QosPolicyCount_s& operator =(
                        const QosPolicyCount_s& x);

                /*!
                 * @brief Move assignment.
                 * @param x Reference to the object eprosima::fastdds::statistics::QosPolicyCount_s that will be copied.
                 */
                eProsima_user_DllExport QosPolicyCount_s& operator =(
                        QosPolicyCount_s&& x) noexcept;

                /*!
                 * @brief Comparison operator.
                 * @param x eprosima::fastdds::statistics::QosPolicyCount_s object to compare.
                 */
                eProsima_user_DllExport bool operator ==(
                        const QosPolicyCount_s& x) const;

                /*!
                 * @brief Comparison operator.
                 * @param x eprosima::fastdds::statistics::QosPolicyCount_s object to compare.
                 */
                eProsima_user_DllExport bool operator !=(
                        const QosPolicyCount_s& x) const;

                /*!
                 * @brief This function sets a value in member policy_id
                 * @param _policy_id New value for member policy_id
                 */
                eProsima_user_DllExport void policy_id(
                        uint32_t _policy_id);

                /*!
                 * @brief This function returns the value of member policy_id
                 * @return Value of member policy_id
                 */
                eProsima_user_DllExport uint32_t policy_id() const;

                /*!
                 * @brief This function returns a reference to member policy_id
                 * @return Reference to member policy_id
                 */
                eProsima_user_DllExport uint32_t& policy_id();


                /*!
                 * @brief This function sets a value in member count
                 * @param _count New value for member count
                 */
                eProsima_user_DllExport void count(
                        uint32_t _count);

                /*!
                 * @brief This function returns the value of member count
                 * @return Value of member count
                 */
                eProsima_user_DllExport uint32_t count() const;

                /*!
                 * @brief This function returns a reference to member count
                 * @return Reference to member count
                 */
                eProsima_user_DllExport uint32_t& count();


                /*!
                * @brief This function returns the maximum serialized size of an object
                * depending on the buffer alignment.
                * @param current_alignment Buffer alignment.
                * @return Maximum serialized size.
                */
                eProsima_user_DllExport static size_t getMaxCdrSerializedSize(
                        size_t current_alignment = 0);

                /*!
                 * @brief This function returns the serialized size of a data depending on the buffer alignment.
                 * @param data Data which is calculated its serialized size.
                 * @param current_alignment Buffer alignment.
                 * @return Serialized size.
                 */
                eProsima_user_DllExport static size_t getCdrSerializedSize(
                        const eprosima::fastdds::statistics::QosPolicyCount_s& data,
                        size_t current_alignment = 0);



                /*!
                 * @brief This function serializes an object using CDR serialization.
                 * @param cdr CDR serialization object.
                 */
                eProsima_user_DllExport void serialize(
                        eprosima::fastcdr::Cdr& cdr) const;

                /*!
                 * @brief This function deserializes an object using CDR serialization.
                 * @param cdr CDR serialization object.
                 */
                eProsima_user_DllExport void deserialize(
                        eprosima::fastcdr::Cdr& cdr);




                /*!
                * @brief This function tells you if the Key has been defined for this type
                */
                eProsima_user_DllExport static bool isKeyDefined();

                /*!
                * @brief This function serializes the key members of an object using CDR serialization.
                * @param cdr CDR serialization object.
                */
                eProsima_user_DllExport void serializeKey(
                        eprosima::fastcdr::Cdr& cdr) const;


            private:

                uint32_t m_policy_id;
                uint32_t m_count;

            };



            /*!
             * @brief This class represents the structure BaseStatus_s defined by the user in the IDL file.
             * @ingroup monitorservice_types
             */
            class BaseStatus_s
            {
            public:

                /*!
                 * @brief Default constructor.
                 */
                eProsima_user_DllExport BaseStatus_s();

                /*!
                 * @brief Default destructor.
                 */
                eProsima_user_DllExport ~BaseStatus_s();

                /*!
                 * @brief Copy constructor.
                 * @param x Reference to the object eprosima::fastdds::statistics::BaseStatus_s that will be copied.
                 */
                eProsima_user_DllExport BaseStatus_s(
                        const BaseStatus_s& x);

                /*!
                 * @brief Move constructor.
                 * @param x Reference to the object eprosima::fastdds::statistics::BaseStatus_s that will be copied.
                 */
                eProsima_user_DllExport BaseStatus_s(
                        BaseStatus_s&& x) noexcept;

                /*!
                 * @brief Copy assignment.
                 * @param x Reference to the object eprosima::fastdds::statistics::BaseStatus_s that will be copied.
                 */
                eProsima_user_DllExport BaseStatus_s& operator =(
                        const BaseStatus_s& x);

                /*!
                 * @brief Move assignment.
                 * @param x Reference to the object eprosima::fastdds::statistics::BaseStatus_s that will be copied.
                 */
                eProsima_user_DllExport BaseStatus_s& operator =(
                        BaseStatus_s&& x) noexcept;

                /*!
                 * @brief Comparison operator.
                 * @param x eprosima::fastdds::statistics::BaseStatus_s object to compare.
                 */
                eProsima_user_DllExport bool operator ==(
                        const BaseStatus_s& x) const;

                /*!
                 * @brief Comparison operator.
                 * @param x eprosima::fastdds::statistics::BaseStatus_s object to compare.
                 */
                eProsima_user_DllExport bool operator !=(
                        const BaseStatus_s& x) const;

                /*!
                 * @brief This function sets a value in member total_count
                 * @param _total_count New value for member total_count
                 */
                eProsima_user_DllExport void total_count(
                        uint32_t _total_count);

                /*!
                 * @brief This function returns the value of member total_count
                 * @return Value of member total_count
                 */
                eProsima_user_DllExport uint32_t total_count() const;

                /*!
                 * @brief This function returns a reference to member total_count
                 * @return Reference to member total_count
                 */
                eProsima_user_DllExport uint32_t& total_count();


                /*!
                * @brief This function returns the maximum serialized size of an object
                * depending on the buffer alignment.
                * @param current_alignment Buffer alignment.
                * @return Maximum serialized size.
                */
                eProsima_user_DllExport static size_t getMaxCdrSerializedSize(
                        size_t current_alignment = 0);

                /*!
                 * @brief This function returns the serialized size of a data depending on the buffer alignment.
                 * @param data Data which is calculated its serialized size.
                 * @param current_alignment Buffer alignment.
                 * @return Serialized size.
                 */
                eProsima_user_DllExport static size_t getCdrSerializedSize(
                        const eprosima::fastdds::statistics::BaseStatus_s& data,
                        size_t current_alignment = 0);



                /*!
                 * @brief This function serializes an object using CDR serialization.
                 * @param cdr CDR serialization object.
                 */
                eProsima_user_DllExport void serialize(
                        eprosima::fastcdr::Cdr& cdr) const;

                /*!
                 * @brief This function deserializes an object using CDR serialization.
                 * @param cdr CDR serialization object.
                 */
                eProsima_user_DllExport void deserialize(
                        eprosima::fastcdr::Cdr& cdr);




                /*!
                * @brief This function tells you if the Key has been defined for this type
                */
                eProsima_user_DllExport static bool isKeyDefined();

                /*!
                * @brief This function serializes the key members of an object using CDR serialization.
                * @param cdr CDR serialization object.
                */
                eProsima_user_DllExport void serializeKey(
                        eprosima::fastcdr::Cdr& cdr) const;


            private:

                uint32_t m_total_count;

            };



            typedef std::vector<eprosima::fastdds::statistics::QosPolicyCount_s> QosPolicyCountSeq_s;



            /*!
             * @brief This class represents the structure IncompatibleQoSStatus_s defined by the user in the IDL file.
             * @ingroup monitorservice_types
             */
            class IncompatibleQoSStatus_s
            {
            public:

                /*!
                 * @brief Default constructor.
                 */
                eProsima_user_DllExport IncompatibleQoSStatus_s();

                /*!
                 * @brief Default destructor.
                 */
                eProsima_user_DllExport ~IncompatibleQoSStatus_s();

                /*!
                 * @brief Copy constructor.
                 * @param x Reference to the object eprosima::fastdds::statistics::IncompatibleQoSStatus_s that will be copied.
                 */
                eProsima_user_DllExport IncompatibleQoSStatus_s(
                        const IncompatibleQoSStatus_s& x);

                /*!
                 * @brief Move constructor.
                 * @param x Reference to the object eprosima::fastdds::statistics::IncompatibleQoSStatus_s that will be copied.
                 */
                eProsima_user_DllExport IncompatibleQoSStatus_s(
                        IncompatibleQoSStatus_s&& x) noexcept;

                /*!
                 * @brief Copy assignment.
                 * @param x Reference to the object eprosima::fastdds::statistics::IncompatibleQoSStatus_s that will be copied.
                 */
                eProsima_user_DllExport IncompatibleQoSStatus_s& operator =(
                        const IncompatibleQoSStatus_s& x);

                /*!
                 * @brief Move assignment.
                 * @param x Reference to the object eprosima::fastdds::statistics::IncompatibleQoSStatus_s that will be copied.
                 */
                eProsima_user_DllExport IncompatibleQoSStatus_s& operator =(
                        IncompatibleQoSStatus_s&& x) noexcept;

                /*!
                 * @brief Comparison operator.
                 * @param x eprosima::fastdds::statistics::IncompatibleQoSStatus_s object to compare.
                 */
                eProsima_user_DllExport bool operator ==(
                        const IncompatibleQoSStatus_s& x) const;

                /*!
                 * @brief Comparison operator.
                 * @param x eprosima::fastdds::statistics::IncompatibleQoSStatus_s object to compare.
                 */
                eProsima_user_DllExport bool operator !=(
                        const IncompatibleQoSStatus_s& x) const;

                /*!
                 * @brief This function sets a value in member total_count
                 * @param _total_count New value for member total_count
                 */
                eProsima_user_DllExport void total_count(
                        uint32_t _total_count);

                /*!
                 * @brief This function returns the value of member total_count
                 * @return Value of member total_count
                 */
                eProsima_user_DllExport uint32_t total_count() const;

                /*!
                 * @brief This function returns a reference to member total_count
                 * @return Reference to member total_count
                 */
                eProsima_user_DllExport uint32_t& total_count();


                /*!
                 * @brief This function sets a value in member last_policy_id
                 * @param _last_policy_id New value for member last_policy_id
                 */
                eProsima_user_DllExport void last_policy_id(
                        uint32_t _last_policy_id);

                /*!
                 * @brief This function returns the value of member last_policy_id
                 * @return Value of member last_policy_id
                 */
                eProsima_user_DllExport uint32_t last_policy_id() const;

                /*!
                 * @brief This function returns a reference to member last_policy_id
                 * @return Reference to member last_policy_id
                 */
                eProsima_user_DllExport uint32_t& last_policy_id();


                /*!
                 * @brief This function copies the value in member policies
                 * @param _policies New value to be copied in member policies
                 */
                eProsima_user_DllExport void policies(
                        const eprosima::fastdds::statistics::QosPolicyCountSeq_s& _policies);

                /*!
                 * @brief This function moves the value in member policies
                 * @param _policies New value to be moved in member policies
                 */
                eProsima_user_DllExport void policies(
                        eprosima::fastdds::statistics::QosPolicyCountSeq_s&& _policies);

                /*!
                 * @brief This function returns a constant reference to member policies
                 * @return Constant reference to member policies
                 */
                eProsima_user_DllExport const eprosima::fastdds::statistics::QosPolicyCountSeq_s& policies() const;

                /*!
                 * @brief This function returns a reference to member policies
                 * @return Reference to member policies
                 */
                eProsima_user_DllExport eprosima::fastdds::statistics::QosPolicyCountSeq_s& policies();


                /*!
                * @brief This function returns the maximum serialized size of an object
                * depending on the buffer alignment.
                * @param current_alignment Buffer alignment.
                * @return Maximum serialized size.
                */
                eProsima_user_DllExport static size_t getMaxCdrSerializedSize(
                        size_t current_alignment = 0);

                /*!
                 * @brief This function returns the serialized size of a data depending on the buffer alignment.
                 * @param data Data which is calculated its serialized size.
                 * @param current_alignment Buffer alignment.
                 * @return Serialized size.
                 */
                eProsima_user_DllExport static size_t getCdrSerializedSize(
                        const eprosima::fastdds::statistics::IncompatibleQoSStatus_s& data,
                        size_t current_alignment = 0);



                /*!
                 * @brief This function serializes an object using CDR serialization.
                 * @param cdr CDR serialization object.
                 */
                eProsima_user_DllExport void serialize(
                        eprosima::fastcdr::Cdr& cdr) const;

                /*!
                 * @brief This function deserializes an object using CDR serialization.
                 * @param cdr CDR serialization object.
                 */
                eProsima_user_DllExport void deserialize(
                        eprosima::fastcdr::Cdr& cdr);




                /*!
                * @brief This function tells you if the Key has been defined for this type
                */
                eProsima_user_DllExport static bool isKeyDefined();

                /*!
                * @brief This function serializes the key members of an object using CDR serialization.
                * @param cdr CDR serialization object.
                */
                eProsima_user_DllExport void serializeKey(
                        eprosima::fastcdr::Cdr& cdr) const;


            private:

                uint32_t m_total_count;
                uint32_t m_last_policy_id;
                eprosima::fastdds::statistics::QosPolicyCountSeq_s m_policies;

            };



            /*!
             * @brief This class represents the structure LivelinessChangedStatus_s defined by the user in the IDL file.
             * @ingroup monitorservice_types
             */
            class LivelinessChangedStatus_s
            {
            public:

                /*!
                 * @brief Default constructor.
                 */
                eProsima_user_DllExport LivelinessChangedStatus_s();

                /*!
                 * @brief Default destructor.
                 */
                eProsima_user_DllExport ~LivelinessChangedStatus_s();

                /*!
                 * @brief Copy constructor.
                 * @param x Reference to the object eprosima::fastdds::statistics::LivelinessChangedStatus_s that will be copied.
                 */
                eProsima_user_DllExport LivelinessChangedStatus_s(
                        const LivelinessChangedStatus_s& x);

                /*!
                 * @brief Move constructor.
                 * @param x Reference to the object eprosima::fastdds::statistics::LivelinessChangedStatus_s that will be copied.
                 */
                eProsima_user_DllExport LivelinessChangedStatus_s(
                        LivelinessChangedStatus_s&& x) noexcept;

                /*!
                 * @brief Copy assignment.
                 * @param x Reference to the object eprosima::fastdds::statistics::LivelinessChangedStatus_s that will be copied.
                 */
                eProsima_user_DllExport LivelinessChangedStatus_s& operator =(
                        const LivelinessChangedStatus_s& x);

                /*!
                 * @brief Move assignment.
                 * @param x Reference to the object eprosima::fastdds::statistics::LivelinessChangedStatus_s that will be copied.
                 */
                eProsima_user_DllExport LivelinessChangedStatus_s& operator =(
                        LivelinessChangedStatus_s&& x) noexcept;

                /*!
                 * @brief Comparison operator.
                 * @param x eprosima::fastdds::statistics::LivelinessChangedStatus_s object to compare.
                 */
                eProsima_user_DllExport bool operator ==(
                        const LivelinessChangedStatus_s& x) const;

                /*!
                 * @brief Comparison operator.
                 * @param x eprosima::fastdds::statistics::LivelinessChangedStatus_s object to compare.
                 */
                eProsima_user_DllExport bool operator !=(
                        const LivelinessChangedStatus_s& x) const;

                /*!
                 * @brief This function sets a value in member alive_count
                 * @param _alive_count New value for member alive_count
                 */
                eProsima_user_DllExport void alive_count(
                        uint32_t _alive_count);

                /*!
                 * @brief This function returns the value of member alive_count
                 * @return Value of member alive_count
                 */
                eProsima_user_DllExport uint32_t alive_count() const;

                /*!
                 * @brief This function returns a reference to member alive_count
                 * @return Reference to member alive_count
                 */
                eProsima_user_DllExport uint32_t& alive_count();


                /*!
                 * @brief This function sets a value in member not_alive_count
                 * @param _not_alive_count New value for member not_alive_count
                 */
                eProsima_user_DllExport void not_alive_count(
                        uint32_t _not_alive_count);

                /*!
                 * @brief This function returns the value of member not_alive_count
                 * @return Value of member not_alive_count
                 */
                eProsima_user_DllExport uint32_t not_alive_count() const;

                /*!
                 * @brief This function returns a reference to member not_alive_count
                 * @return Reference to member not_alive_count
                 */
                eProsima_user_DllExport uint32_t& not_alive_count();


                /*!
                 * @brief This function copies the value in member last_publication_handle
                 * @param _last_publication_handle New value to be copied in member last_publication_handle
                 */
                eProsima_user_DllExport void last_publication_handle(
                        const std::array<uint8_t, 16>& _last_publication_handle);

                /*!
                 * @brief This function moves the value in member last_publication_handle
                 * @param _last_publication_handle New value to be moved in member last_publication_handle
                 */
                eProsima_user_DllExport void last_publication_handle(
                        std::array<uint8_t, 16>&& _last_publication_handle);

                /*!
                 * @brief This function returns a constant reference to member last_publication_handle
                 * @return Constant reference to member last_publication_handle
                 */
                eProsima_user_DllExport const std::array<uint8_t, 16>& last_publication_handle() const;

                /*!
                 * @brief This function returns a reference to member last_publication_handle
                 * @return Reference to member last_publication_handle
                 */
                eProsima_user_DllExport std::array<uint8_t, 16>& last_publication_handle();


                /*!
                * @brief This function returns the maximum serialized size of an object
                * depending on the buffer alignment.
                * @param current_alignment Buffer alignment.
                * @return Maximum serialized size.
                */
                eProsima_user_DllExport static size_t getMaxCdrSerializedSize(
                        size_t current_alignment = 0);

                /*!
                 * @brief This function returns the serialized size of a data depending on the buffer alignment.
                 * @param data Data which is calculated its serialized size.
                 * @param current_alignment Buffer alignment.
                 * @return Serialized size.
                 */
                eProsima_user_DllExport static size_t getCdrSerializedSize(
                        const eprosima::fastdds::statistics::LivelinessChangedStatus_s& data,
                        size_t current_alignment = 0);



                /*!
                 * @brief This function serializes an object using CDR serialization.
                 * @param cdr CDR serialization object.
                 */
                eProsima_user_DllExport void serialize(
                        eprosima::fastcdr::Cdr& cdr) const;

                /*!
                 * @brief This function deserializes an object using CDR serialization.
                 * @param cdr CDR serialization object.
                 */
                eProsima_user_DllExport void deserialize(
                        eprosima::fastcdr::Cdr& cdr);




                /*!
                * @brief This function tells you if the Key has been defined for this type
                */
                eProsima_user_DllExport static bool isKeyDefined();

                /*!
                * @brief This function serializes the key members of an object using CDR serialization.
                * @param cdr CDR serialization object.
                */
                eProsima_user_DllExport void serializeKey(
                        eprosima::fastcdr::Cdr& cdr) const;


            private:

                uint32_t m_alive_count;
                uint32_t m_not_alive_count;
                std::array<uint8_t, 16> m_last_publication_handle;

            };



            /*!
             * @brief This class represents the structure DeadlineMissedStatus_s defined by the user in the IDL file.
             * @ingroup monitorservice_types
             */
            class DeadlineMissedStatus_s
            {
            public:

                /*!
                 * @brief Default constructor.
                 */
                eProsima_user_DllExport DeadlineMissedStatus_s();

                /*!
                 * @brief Default destructor.
                 */
                eProsima_user_DllExport ~DeadlineMissedStatus_s();

                /*!
                 * @brief Copy constructor.
                 * @param x Reference to the object eprosima::fastdds::statistics::DeadlineMissedStatus_s that will be copied.
                 */
                eProsima_user_DllExport DeadlineMissedStatus_s(
                        const DeadlineMissedStatus_s& x);

                /*!
                 * @brief Move constructor.
                 * @param x Reference to the object eprosima::fastdds::statistics::DeadlineMissedStatus_s that will be copied.
                 */
                eProsima_user_DllExport DeadlineMissedStatus_s(
                        DeadlineMissedStatus_s&& x) noexcept;

                /*!
                 * @brief Copy assignment.
                 * @param x Reference to the object eprosima::fastdds::statistics::DeadlineMissedStatus_s that will be copied.
                 */
                eProsima_user_DllExport DeadlineMissedStatus_s& operator =(
                        const DeadlineMissedStatus_s& x);

                /*!
                 * @brief Move assignment.
                 * @param x Reference to the object eprosima::fastdds::statistics::DeadlineMissedStatus_s that will be copied.
                 */
                eProsima_user_DllExport DeadlineMissedStatus_s& operator =(
                        DeadlineMissedStatus_s&& x) noexcept;

                /*!
                 * @brief Comparison operator.
                 * @param x eprosima::fastdds::statistics::DeadlineMissedStatus_s object to compare.
                 */
                eProsima_user_DllExport bool operator ==(
                        const DeadlineMissedStatus_s& x) const;

                /*!
                 * @brief Comparison operator.
                 * @param x eprosima::fastdds::statistics::DeadlineMissedStatus_s object to compare.
                 */
                eProsima_user_DllExport bool operator !=(
                        const DeadlineMissedStatus_s& x) const;

                /*!
                 * @brief This function sets a value in member total_count
                 * @param _total_count New value for member total_count
                 */
                eProsima_user_DllExport void total_count(
                        uint32_t _total_count);

                /*!
                 * @brief This function returns the value of member total_count
                 * @return Value of member total_count
                 */
                eProsima_user_DllExport uint32_t total_count() const;

                /*!
                 * @brief This function returns a reference to member total_count
                 * @return Reference to member total_count
                 */
                eProsima_user_DllExport uint32_t& total_count();


                /*!
                 * @brief This function copies the value in member last_instance_handle
                 * @param _last_instance_handle New value to be copied in member last_instance_handle
                 */
                eProsima_user_DllExport void last_instance_handle(
                        const std::array<uint8_t, 16>& _last_instance_handle);

                /*!
                 * @brief This function moves the value in member last_instance_handle
                 * @param _last_instance_handle New value to be moved in member last_instance_handle
                 */
                eProsima_user_DllExport void last_instance_handle(
                        std::array<uint8_t, 16>&& _last_instance_handle);

                /*!
                 * @brief This function returns a constant reference to member last_instance_handle
                 * @return Constant reference to member last_instance_handle
                 */
                eProsima_user_DllExport const std::array<uint8_t, 16>& last_instance_handle() const;

                /*!
                 * @brief This function returns a reference to member last_instance_handle
                 * @return Reference to member last_instance_handle
                 */
                eProsima_user_DllExport std::array<uint8_t, 16>& last_instance_handle();


                /*!
                * @brief This function returns the maximum serialized size of an object
                * depending on the buffer alignment.
                * @param current_alignment Buffer alignment.
                * @return Maximum serialized size.
                */
                eProsima_user_DllExport static size_t getMaxCdrSerializedSize(
                        size_t current_alignment = 0);

                /*!
                 * @brief This function returns the serialized size of a data depending on the buffer alignment.
                 * @param data Data which is calculated its serialized size.
                 * @param current_alignment Buffer alignment.
                 * @return Serialized size.
                 */
                eProsima_user_DllExport static size_t getCdrSerializedSize(
                        const eprosima::fastdds::statistics::DeadlineMissedStatus_s& data,
                        size_t current_alignment = 0);



                /*!
                 * @brief This function serializes an object using CDR serialization.
                 * @param cdr CDR serialization object.
                 */
                eProsima_user_DllExport void serialize(
                        eprosima::fastcdr::Cdr& cdr) const;

                /*!
                 * @brief This function deserializes an object using CDR serialization.
                 * @param cdr CDR serialization object.
                 */
                eProsima_user_DllExport void deserialize(
                        eprosima::fastcdr::Cdr& cdr);




                /*!
                * @brief This function tells you if the Key has been defined for this type
                */
                eProsima_user_DllExport static bool isKeyDefined();

                /*!
                * @brief This function serializes the key members of an object using CDR serialization.
                * @param cdr CDR serialization object.
                */
                eProsima_user_DllExport void serializeKey(
                        eprosima::fastcdr::Cdr& cdr) const;


            private:

                uint32_t m_total_count;
                std::array<uint8_t, 16> m_last_instance_handle;

            };

            typedef eprosima::fastdds::statistics::BaseStatus_s LivelinessLostStatus_s;

            typedef eprosima::fastdds::statistics::BaseStatus_s InconsistentTopicStatus_s;

            typedef eprosima::fastdds::statistics::BaseStatus_s SampleLostStatus_s;

            /*!
             * @brief This class represents the enumeration StatusKind defined by the user in the IDL file.
             * @ingroup monitorservice_types
             */
            enum StatusKind : uint32_t
            {
                PROXY,
                CONNECTION_LIST,
                INCOMPATIBLE_QOS,
                INCONSISTENT_TOPIC,
                LIVELINESS_LOST,
                LIVELINESS_CHANGED,
                DEADLINE_MISSED,
                SAMPLE_LOST,
                STATUSES_SIZE
            };


            /*!
             * @brief This class represents the union MonitorServiceData defined by the user in the IDL file.
             * @ingroup monitorservice_types
             */
            class MonitorServiceData
            {
            public:

                /*!
                 * @brief Default constructor.
                 */
                eProsima_user_DllExport MonitorServiceData();

                /*!
                 * @brief Default destructor.
                 */
                eProsima_user_DllExport ~MonitorServiceData();

                /*!
                 * @brief Copy constructor.
                 * @param x Reference to the object eprosima::fastdds::statistics::MonitorServiceData that will be copied.
                 */
                eProsima_user_DllExport MonitorServiceData(
                        const MonitorServiceData& x);

                /*!
                 * @brief Move constructor.
                 * @param x Reference to the object eprosima::fastdds::statistics::MonitorServiceData that will be copied.
                 */
                eProsima_user_DllExport MonitorServiceData(
                        MonitorServiceData&& x) noexcept;

                /*!
                 * @brief Copy assignment.
                 * @param x Reference to the object eprosima::fastdds::statistics::MonitorServiceData that will be copied.
                 */
                eProsima_user_DllExport MonitorServiceData& operator =(
                        const MonitorServiceData& x);

                /*!
                 * @brief Move assignment.
                 * @param x Reference to the object eprosima::fastdds::statistics::MonitorServiceData that will be copied.
                 */
                eProsima_user_DllExport MonitorServiceData& operator =(
                        MonitorServiceData&& x) noexcept;

                /*!
                 * @brief Comparison operator.
                 * @param x eprosima::fastdds::statistics::MonitorServiceData object to compare.
                 */
                eProsima_user_DllExport bool operator ==(
                        const MonitorServiceData& x) const;

                /*!
                 * @brief Comparison operator.
                 * @param x eprosima::fastdds::statistics::MonitorServiceData object to compare.
                 */
                eProsima_user_DllExport bool operator !=(
                        const MonitorServiceData& x) const;

                /*!
                 * @brief This function sets the discriminator value.
                 * @param __d New value for the discriminator.
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
                 */
                eProsima_user_DllExport void _d(
                        eprosima::fastdds::statistics::StatusKind __d);

                /*!
                 * @brief This function returns the value of the discriminator.
                 * @return Value of the discriminator
                 */
                eProsima_user_DllExport eprosima::fastdds::statistics::StatusKind _d() const;

                /*!
                 * @brief This function returns a reference to the discriminator.
                 * @return Reference to the discriminator.
                 */
                eProsima_user_DllExport eprosima::fastdds::statistics::StatusKind& _d();

                /*!
                 * @brief This function copies the value in member entity_proxy
                 * @param _entity_proxy New value to be copied in member entity_proxy
                 */
                eProsima_user_DllExport void entity_proxy(
                        const std::vector<uint8_t>& _entity_proxy);

                /*!
                 * @brief This function moves the value in member entity_proxy
                 * @param _entity_proxy New value to be moved in member entity_proxy
                 */
                eProsima_user_DllExport void entity_proxy(
                        std::vector<uint8_t>&& _entity_proxy);

                /*!
                 * @brief This function returns a constant reference to member entity_proxy
                 * @return Constant reference to member entity_proxy
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport const std::vector<uint8_t>& entity_proxy() const;

                /*!
                 * @brief This function returns a reference to member entity_proxy
                 * @return Reference to member entity_proxy
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport std::vector<uint8_t>& entity_proxy();


                /*!
                 * @brief This function copies the value in member connection_list
                 * @param _connection_list New value to be copied in member connection_list
                 */
                eProsima_user_DllExport void connection_list(
                        const std::vector<eprosima::fastdds::statistics::Connection>& _connection_list);

                /*!
                 * @brief This function moves the value in member connection_list
                 * @param _connection_list New value to be moved in member connection_list
                 */
                eProsima_user_DllExport void connection_list(
                        std::vector<eprosima::fastdds::statistics::Connection>&& _connection_list);

                /*!
                 * @brief This function returns a constant reference to member connection_list
                 * @return Constant reference to member connection_list
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport const std::vector<eprosima::fastdds::statistics::Connection>& connection_list() const;

                /*!
                 * @brief This function returns a reference to member connection_list
                 * @return Reference to member connection_list
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport std::vector<eprosima::fastdds::statistics::Connection>& connection_list();


                /*!
                 * @brief This function copies the value in member incompatible_qos_status
                 * @param _incompatible_qos_status New value to be copied in member incompatible_qos_status
                 */
                eProsima_user_DllExport void incompatible_qos_status(
                        const eprosima::fastdds::statistics::IncompatibleQoSStatus_s& _incompatible_qos_status);

                /*!
                 * @brief This function moves the value in member incompatible_qos_status
                 * @param _incompatible_qos_status New value to be moved in member incompatible_qos_status
                 */
                eProsima_user_DllExport void incompatible_qos_status(
                        eprosima::fastdds::statistics::IncompatibleQoSStatus_s&& _incompatible_qos_status);

                /*!
                 * @brief This function returns a constant reference to member incompatible_qos_status
                 * @return Constant reference to member incompatible_qos_status
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport const eprosima::fastdds::statistics::IncompatibleQoSStatus_s& incompatible_qos_status() const;

                /*!
                 * @brief This function returns a reference to member incompatible_qos_status
                 * @return Reference to member incompatible_qos_status
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport eprosima::fastdds::statistics::IncompatibleQoSStatus_s& incompatible_qos_status();


                /*!
                 * @brief This function copies the value in member inconsistent_topic_status
                 * @param _inconsistent_topic_status New value to be copied in member inconsistent_topic_status
                 */
                eProsima_user_DllExport void inconsistent_topic_status(
                        const eprosima::fastdds::statistics::InconsistentTopicStatus_s& _inconsistent_topic_status);

                /*!
                 * @brief This function moves the value in member inconsistent_topic_status
                 * @param _inconsistent_topic_status New value to be moved in member inconsistent_topic_status
                 */
                eProsima_user_DllExport void inconsistent_topic_status(
                        eprosima::fastdds::statistics::InconsistentTopicStatus_s&& _inconsistent_topic_status);

                /*!
                 * @brief This function returns a constant reference to member inconsistent_topic_status
                 * @return Constant reference to member inconsistent_topic_status
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport const eprosima::fastdds::statistics::InconsistentTopicStatus_s& inconsistent_topic_status() const;

                /*!
                 * @brief This function returns a reference to member inconsistent_topic_status
                 * @return Reference to member inconsistent_topic_status
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport eprosima::fastdds::statistics::InconsistentTopicStatus_s& inconsistent_topic_status();


                /*!
                 * @brief This function copies the value in member liveliness_lost_status
                 * @param _liveliness_lost_status New value to be copied in member liveliness_lost_status
                 */
                eProsima_user_DllExport void liveliness_lost_status(
                        const eprosima::fastdds::statistics::LivelinessLostStatus_s& _liveliness_lost_status);

                /*!
                 * @brief This function moves the value in member liveliness_lost_status
                 * @param _liveliness_lost_status New value to be moved in member liveliness_lost_status
                 */
                eProsima_user_DllExport void liveliness_lost_status(
                        eprosima::fastdds::statistics::LivelinessLostStatus_s&& _liveliness_lost_status);

                /*!
                 * @brief This function returns a constant reference to member liveliness_lost_status
                 * @return Constant reference to member liveliness_lost_status
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport const eprosima::fastdds::statistics::LivelinessLostStatus_s& liveliness_lost_status() const;

                /*!
                 * @brief This function returns a reference to member liveliness_lost_status
                 * @return Reference to member liveliness_lost_status
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport eprosima::fastdds::statistics::LivelinessLostStatus_s& liveliness_lost_status();


                /*!
                 * @brief This function copies the value in member liveliness_changed_status
                 * @param _liveliness_changed_status New value to be copied in member liveliness_changed_status
                 */
                eProsima_user_DllExport void liveliness_changed_status(
                        const eprosima::fastdds::statistics::LivelinessChangedStatus_s& _liveliness_changed_status);

                /*!
                 * @brief This function moves the value in member liveliness_changed_status
                 * @param _liveliness_changed_status New value to be moved in member liveliness_changed_status
                 */
                eProsima_user_DllExport void liveliness_changed_status(
                        eprosima::fastdds::statistics::LivelinessChangedStatus_s&& _liveliness_changed_status);

                /*!
                 * @brief This function returns a constant reference to member liveliness_changed_status
                 * @return Constant reference to member liveliness_changed_status
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport const eprosima::fastdds::statistics::LivelinessChangedStatus_s& liveliness_changed_status() const;

                /*!
                 * @brief This function returns a reference to member liveliness_changed_status
                 * @return Reference to member liveliness_changed_status
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport eprosima::fastdds::statistics::LivelinessChangedStatus_s& liveliness_changed_status();


                /*!
                 * @brief This function copies the value in member deadline_missed_status
                 * @param _deadline_missed_status New value to be copied in member deadline_missed_status
                 */
                eProsima_user_DllExport void deadline_missed_status(
                        const eprosima::fastdds::statistics::DeadlineMissedStatus_s& _deadline_missed_status);

                /*!
                 * @brief This function moves the value in member deadline_missed_status
                 * @param _deadline_missed_status New value to be moved in member deadline_missed_status
                 */
                eProsima_user_DllExport void deadline_missed_status(
                        eprosima::fastdds::statistics::DeadlineMissedStatus_s&& _deadline_missed_status);

                /*!
                 * @brief This function returns a constant reference to member deadline_missed_status
                 * @return Constant reference to member deadline_missed_status
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport const eprosima::fastdds::statistics::DeadlineMissedStatus_s& deadline_missed_status() const;

                /*!
                 * @brief This function returns a reference to member deadline_missed_status
                 * @return Reference to member deadline_missed_status
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport eprosima::fastdds::statistics::DeadlineMissedStatus_s& deadline_missed_status();


                /*!
                 * @brief This function copies the value in member sample_lost_status
                 * @param _sample_lost_status New value to be copied in member sample_lost_status
                 */
                eProsima_user_DllExport void sample_lost_status(
                        const eprosima::fastdds::statistics::SampleLostStatus_s& _sample_lost_status);

                /*!
                 * @brief This function moves the value in member sample_lost_status
                 * @param _sample_lost_status New value to be moved in member sample_lost_status
                 */
                eProsima_user_DllExport void sample_lost_status(
                        eprosima::fastdds::statistics::SampleLostStatus_s&& _sample_lost_status);

                /*!
                 * @brief This function returns a constant reference to member sample_lost_status
                 * @return Constant reference to member sample_lost_status
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport const eprosima::fastdds::statistics::SampleLostStatus_s& sample_lost_status() const;

                /*!
                 * @brief This function returns a reference to member sample_lost_status
                 * @return Reference to member sample_lost_status
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport eprosima::fastdds::statistics::SampleLostStatus_s& sample_lost_status();


                /*!
                 * @brief This function sets a value in member statuses_size
                 * @param _statuses_size New value for member statuses_size
                 */
                eProsima_user_DllExport void statuses_size(
                        uint8_t _statuses_size);

                /*!
                 * @brief This function returns the value of member statuses_size
                 * @return Value of member statuses_size
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport uint8_t statuses_size() const;

                /*!
                 * @brief This function returns a reference to member statuses_size
                 * @return Reference to member statuses_size
                 * @exception eprosima::fastcdr::BadParamException This exception is thrown if the requested union member is not the current selection.
                 */
                eProsima_user_DllExport uint8_t& statuses_size();


                /*!
                 * @brief This function returns the serialized size of a data depending on the buffer alignment.
                 * @param data Data which is calculated its serialized size.
                 * @param current_alignment Buffer alignment.
                 * @return Serialized size.
                 */
                eProsima_user_DllExport static size_t getCdrSerializedSize(
                        const eprosima::fastdds::statistics::MonitorServiceData& data,
                        size_t current_alignment = 0);



                /*!
                 * @brief This function serializes an object using CDR serialization.
                 * @param cdr CDR serialization object.
                 */
                eProsima_user_DllExport void serialize(
                        eprosima::fastcdr::Cdr& cdr) const;

                /*!
                 * @brief This function deserializes an object using CDR serialization.
                 * @param cdr CDR serialization object.
                 */
                eProsima_user_DllExport void deserialize(
                        eprosima::fastcdr::Cdr& cdr);





            private:

                eprosima::fastdds::statistics::StatusKind m__d;

                std::vector<uint8_t> m_entity_proxy;
                std::vector<eprosima::fastdds::statistics::Connection> m_connection_list;
                eprosima::fastdds::statistics::IncompatibleQoSStatus_s m_incompatible_qos_status;
                eprosima::fastdds::statistics::InconsistentTopicStatus_s m_inconsistent_topic_status;
                eprosima::fastdds::statistics::LivelinessLostStatus_s m_liveliness_lost_status;
                eprosima::fastdds::statistics::LivelinessChangedStatus_s m_liveliness_changed_status;
                eprosima::fastdds::statistics::DeadlineMissedStatus_s m_deadline_missed_status;
                eprosima::fastdds::statistics::SampleLostStatus_s m_sample_lost_status;
                uint8_t m_statuses_size;
            };



            /*!
             * @brief This class represents the structure MonitorServiceStatusData defined by the user in the IDL file.
             * @ingroup monitorservice_types
             */
            class MonitorServiceStatusData
            {
            public:

                /*!
                 * @brief Default constructor.
                 */
                eProsima_user_DllExport MonitorServiceStatusData();

                /*!
                 * @brief Default destructor.
                 */
                eProsima_user_DllExport ~MonitorServiceStatusData();

                /*!
                 * @brief Copy constructor.
                 * @param x Reference to the object eprosima::fastdds::statistics::MonitorServiceStatusData that will be copied.
                 */
                eProsima_user_DllExport MonitorServiceStatusData(
                        const MonitorServiceStatusData& x);

                /*!
                 * @brief Move constructor.
                 * @param x Reference to the object eprosima::fastdds::statistics::MonitorServiceStatusData that will be copied.
                 */
                eProsima_user_DllExport MonitorServiceStatusData(
                        MonitorServiceStatusData&& x) noexcept;

                /*!
                 * @brief Copy assignment.
                 * @param x Reference to the object eprosima::fastdds::statistics::MonitorServiceStatusData that will be copied.
                 */
                eProsima_user_DllExport MonitorServiceStatusData& operator =(
                        const MonitorServiceStatusData& x);

                /*!
                 * @brief Move assignment.
                 * @param x Reference to the object eprosima::fastdds::statistics::MonitorServiceStatusData that will be copied.
                 */
                eProsima_user_DllExport MonitorServiceStatusData& operator =(
                        MonitorServiceStatusData&& x) noexcept;

                /*!
                 * @brief Comparison operator.
                 * @param x eprosima::fastdds::statistics::MonitorServiceStatusData object to compare.
                 */
                eProsima_user_DllExport bool operator ==(
                        const MonitorServiceStatusData& x) const;

                /*!
                 * @brief Comparison operator.
                 * @param x eprosima::fastdds::statistics::MonitorServiceStatusData object to compare.
                 */
                eProsima_user_DllExport bool operator !=(
                        const MonitorServiceStatusData& x) const;

                /*!
                 * @brief This function copies the value in member local_entity
                 * @param _local_entity New value to be copied in member local_entity
                 */
                eProsima_user_DllExport void local_entity(
                        const eprosima::fastdds::statistics::detail::GUID_s& _local_entity);

                /*!
                 * @brief This function moves the value in member local_entity
                 * @param _local_entity New value to be moved in member local_entity
                 */
                eProsima_user_DllExport void local_entity(
                        eprosima::fastdds::statistics::detail::GUID_s&& _local_entity);

                /*!
                 * @brief This function returns a constant reference to member local_entity
                 * @return Constant reference to member local_entity
                 */
                eProsima_user_DllExport const eprosima::fastdds::statistics::detail::GUID_s& local_entity() const;

                /*!
                 * @brief This function returns a reference to member local_entity
                 * @return Reference to member local_entity
                 */
                eProsima_user_DllExport eprosima::fastdds::statistics::detail::GUID_s& local_entity();


                /*!
                 * @brief This function sets a value in member status_kind
                 * @param _status_kind New value for member status_kind
                 */
                eProsima_user_DllExport void status_kind(
                        eprosima::fastdds::statistics::StatusKind _status_kind);

                /*!
                 * @brief This function returns the value of member status_kind
                 * @return Value of member status_kind
                 */
                eProsima_user_DllExport eprosima::fastdds::statistics::StatusKind status_kind() const;

                /*!
                 * @brief This function returns a reference to member status_kind
                 * @return Reference to member status_kind
                 */
                eProsima_user_DllExport eprosima::fastdds::statistics::StatusKind& status_kind();


                /*!
                 * @brief This function copies the value in member value
                 * @param _value New value to be copied in member value
                 */
                eProsima_user_DllExport void value(
                        const eprosima::fastdds::statistics::MonitorServiceData& _value);

                /*!
                 * @brief This function moves the value in member value
                 * @param _value New value to be moved in member value
                 */
                eProsima_user_DllExport void value(
                        eprosima::fastdds::statistics::MonitorServiceData&& _value);

                /*!
                 * @brief This function returns a constant reference to member value
                 * @return Constant reference to member value
                 */
                eProsima_user_DllExport const eprosima::fastdds::statistics::MonitorServiceData& value() const;

                /*!
                 * @brief This function returns a reference to member value
                 * @return Reference to member value
                 */
                eProsima_user_DllExport eprosima::fastdds::statistics::MonitorServiceData& value();


                /*!
                * @brief This function returns the maximum serialized size of an object
                * depending on the buffer alignment.
                * @param current_alignment Buffer alignment.
                * @return Maximum serialized size.
                */
                eProsima_user_DllExport static size_t getMaxCdrSerializedSize(
                        size_t current_alignment = 0);

                /*!
                 * @brief This function returns the serialized size of a data depending on the buffer alignment.
                 * @param data Data which is calculated its serialized size.
                 * @param current_alignment Buffer alignment.
                 * @return Serialized size.
                 */
                eProsima_user_DllExport static size_t getCdrSerializedSize(
                        const eprosima::fastdds::statistics::MonitorServiceStatusData& data,
                        size_t current_alignment = 0);



                /*!
                 * @brief This function serializes an object using CDR serialization.
                 * @param cdr CDR serialization object.
                 */
                eProsima_user_DllExport void serialize(
                        eprosima::fastcdr::Cdr& cdr) const;

                /*!
                 * @brief This function deserializes an object using CDR serialization.
                 * @param cdr CDR serialization object.
                 */
                eProsima_user_DllExport void deserialize(
                        eprosima::fastcdr::Cdr& cdr);




                /*!
                * @brief This function tells you if the Key has been defined for this type
                */
                eProsima_user_DllExport static bool isKeyDefined();

                /*!
                * @brief This function serializes the key members of an object using CDR serialization.
                * @param cdr CDR serialization object.
                */
                eProsima_user_DllExport void serializeKey(
                        eprosima::fastcdr::Cdr& cdr) const;


            private:

                eprosima::fastdds::statistics::detail::GUID_s m_local_entity;
                eprosima::fastdds::statistics::StatusKind m_status_kind;
                eprosima::fastdds::statistics::MonitorServiceData m_value;

            };

        } // namespace statistics
    } // namespace fastdds
} // namespace eprosima

#endif // _FAST_DDS_GENERATED_EPROSIMA_FASTDDS_STATISTICS_MONITORSERVICE_TYPES_H_



#endif // FASTCDR_VERSION_MAJOR == 1
