/* $Id: RecordTypeElement.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * RecordTypeElement: one subelement of a Record type.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __RECORD_TYPE_ELEMENT_HPP_INCLUDED
#define __RECORD_TYPE_ELEMENT_HPP_INCLUDED

#include "frontend/ast/SymbolDeclaration.hpp"
#include "frontend/ast/RecordType.hpp"
#include "frontend/ast/SubtypeIndication.hpp"

namespace ast {

//! element of a VHDL Record type.
/** This class represents one element of a VHDL Record type declaration.
 */
class RecordTypeElement : public SymbolDeclaration {
public:
	//! c'tor
	/** @param id identifier of record element.
          * @param subtypeIndic subtype indication.
          * @param loc location of identifier.
          */
	RecordTypeElement(
		std::string *id,
		SubtypeIndication *subtypeIndic,
		Location loc
		) : 	SymbolDeclaration(id, loc),
			subtype(subtypeIndic),
			parent(NULL),
			offset(0) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		assert(this->name);
		stream << *this->name << " : " << this->subtype;
	}

	/** subtype of element */
	SubtypeIndication *subtype;

	/** parent record type. */
	RecordType *parent;

	/** offset of the element (1st == 0, 2nd == 1, etc.) */
	universal_integer offset;

protected:
	/** Destructor */
	virtual ~RecordTypeElement() {
		util::MiscUtil::terminate(subtype);
	}
};

}; /* namespace ast */

#endif /* __RECORD_TYPE_ELEMENT_HPP_INCLUDED */
