	SUBROUTINE COPY_INTO_MAPPED ( src, msrc, cxs,
     .				      sorted_indices, index_map, hilim,
     .				      axis, dst, mdst )

*
*  This software was developed by the Thermal Modeling and Analysis
*  Project(TMAP) of the National Oceanographic and Atmospheric
*  Administration's (NOAA) Pacific Marine Environmental Lab(PMEL),
*  hereafter referred to as NOAA/PMEL/TMAP.
*
*  Access and use of this software shall impose the following
*  obligations and understandings on the user. The user is granted the
*  right, without any fee or cost, to use, copy, modify, alter, enhance
*  and distribute this software, and any derivative works thereof, and
*  its supporting documentation for any purpose whatsoever, provided
*  that this entire notice appears in all copies of the software,
*  derivative works and supporting documentation.  Further, the user
*  agrees to credit NOAA/PMEL/TMAP in any publications that result from
*  the use of this software or in any product that includes this
*  software. The names TMAP, NOAA and/or PMEL, however, may not be used
*  in any advertising or publicity to endorse or promote any products
*  or commercial entity unless specific written permission is obtained
*  from NOAA/PMEL/TMAP. The user also understands that NOAA/PMEL/TMAP
*  is not obligated to provide the user with any support, consulting,
*  training or assistance of any kind with regard to the use, operation
*  and performance of this software nor to provide the user with any
*  updates, revisions, new versions or "bug fixes".
*
*  THIS SOFTWARE IS PROVIDED BY NOAA/PMEL/TMAP "AS IS" AND ANY EXPRESS
*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL NOAA/PMEL/TMAP BE LIABLE FOR ANY SPECIAL,
*  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
*  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
*  CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
*  CONNECTION WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE. 
*
*
* copy data from source grid into dstination grid using sorted_indices
* and index_map to guide the copy subscripts along axis "axis"
* The dstination grid is assumed big enough to hold the data

* programmer - steve hankin
* NOAA/PMEL, Seattle, WA - Tropical Modeling and Analysis Program
*
* V510: 8/99 *sh* - based on COPY_INTO
* V533: 7/01 *sh* - added string support
*       *acm* 3/12 Add E and F dimensions (use nferdims in tmap_dims.parm)

	include 'tmap_dims.parm'
	include 'ferret.parm'
	include	'xcontext.cmn'
	include	'xvariables.cmn'

* calling argument declarations:
	INTEGER msrc, cxs, mdst, axis, hilim
	REAL    sorted_indices( * ), index_map( * ), src( * ), dst( * )

* A typical scenario for the use of this routine might be as follows:
*   requested list of subscripts at which to sample: {17, 13, 15, 13}
*   sorted indices (derived from above):	      13, 13, 15, 17
*   index map -- from sorted to original:	      2, 4, 3, 1  

* The source data might contain VAR[I=13:15]  ("axis" = I)
* with "hilim" equal to 3 -- pointing to the upper limit in the sorted indices
*		and index map of the source data
 
* The job of this routine would be to copy I=15 of source into I=3 of result 
*	then throw away I=14
*	then copy I=13 of source into both I=4 and I=2 or result

	IF (mr_type(msrc) .EQ. ptype_string ) THEN
	  CALL COPY_PTR_INTO_MAPPED_SUB( cxs, axis, hilim,
     .			    sorted_indices, index_map,
     .			    src, mr_lo_s1(msrc), mr_hi_s1(msrc),
     .				 mr_lo_s2(msrc), mr_hi_s2(msrc),
     .				 mr_lo_s3(msrc), mr_hi_s3(msrc),
     .				 mr_lo_s4(msrc), mr_hi_s4(msrc),
     .				 mr_lo_s5(msrc), mr_hi_s5(msrc),
     .				 mr_lo_s6(msrc), mr_hi_s6(msrc),
     .			    dst, mr_lo_s1(mdst), mr_hi_s1(mdst),
     .				 mr_lo_s2(mdst), mr_hi_s2(mdst),
     .				 mr_lo_s3(mdst), mr_hi_s3(mdst),
     .				 mr_lo_s4(mdst), mr_hi_s4(mdst),
     .				 mr_lo_s5(mdst), mr_hi_s5(mdst),
     .				 mr_lo_s6(mdst), mr_hi_s6(mdst) )
	ELSE
	  CALL COPY_INTO_MAPPED_SUB( cxs, axis, hilim,
     .			    sorted_indices, index_map,
     .			    src, mr_lo_s1(msrc), mr_hi_s1(msrc),
     .				 mr_lo_s2(msrc), mr_hi_s2(msrc),
     .				 mr_lo_s3(msrc), mr_hi_s3(msrc),
     .				 mr_lo_s4(msrc), mr_hi_s4(msrc),
     .				 mr_lo_s5(msrc), mr_hi_s5(msrc),
     .				 mr_lo_s6(msrc), mr_hi_s6(msrc),
     .			    dst, mr_lo_s1(mdst), mr_hi_s1(mdst),
     .				 mr_lo_s2(mdst), mr_hi_s2(mdst),
     .				 mr_lo_s3(mdst), mr_hi_s3(mdst),
     .				 mr_lo_s4(mdst), mr_hi_s4(mdst),
     .				 mr_lo_s5(mdst), mr_hi_s5(mdst),
     .				 mr_lo_s6(mdst), mr_hi_s6(mdst) )
	ENDIF

	RETURN
	END 
