      SUBROUTINE POSITN(X,Y)
*
*
*  This software was developed by the Thermal Modeling and Analysis
*  Project(TMAP) of the National Oceanographic and Atmospheric
*  Administration's (NOAA) Pacific Marine Environmental Lab(PMEL),
*  hereafter referred to as NOAA/PMEL/TMAP.
*
*  Access and use of this software shall impose the following
*  obligations and understandings on the user. The user is granted the
*  right, without any fee or cost, to use, copy, modify, alter, enhance
*  and distribute this software, and any derivative works thereof, and
*  its supporting documentation for any purpose whatsoever, provided
*  that this entire notice appears in all copies of the software,
*  derivative works and supporting documentation.  Further, the user
*  agrees to credit NOAA/PMEL/TMAP in any publications that result from
*  the use of this software or in any product that includes this
*  software. The names TMAP, NOAA and/or PMEL, however, may not be used
*  in any advertising or publicity to endorse or promote any products
*  or commercial entity unless specific written permission is obtained
*  from NOAA/PMEL/TMAP. The user also understands that NOAA/PMEL/TMAP
*  is not obligated to provide the user with any support, consulting,
*  training or assistance of any kind with regard to the use, operation
*  and performance of this software nor to provide the user with any
*  updates, revisions, new versions or "bug fixes".
*
*  THIS SOFTWARE IS PROVIDED BY NOAA/PMEL/TMAP "AS IS" AND ANY EXPRESS
*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL NOAA/PMEL/TMAP BE LIABLE FOR ANY SPECIAL,
*  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
*  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
*  CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
*  CONNECTION WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE. 
*
*
C**    @(#)positon.F	1.1    3/10/88
C**
C**
C***********************************************************************
C**
C**                 PLOT+ Scientific Graphics System
C**
C***********************************************************************
C**
C**
C
C     CALL POSITN(X,Y)
C
C     THIS SUBROUTINE DETERMINES THE CURRENT PLOTTING POSITION AND
C     RETURNS THE COORDINATES TO THE USER'S PROGRAM IN USER'S UNITS.
#ifdef unix
C     IF THE PLOTTING DEVICES INCLUDE THE TEKTERMINAL AND IT IS IN
#else
C     IF THE PLOTTING DEVICES INCLUDE THE TEKTERMINAL AND IT IS IN
#endif
C     ALPHAS MODE, THE POSITION RETURNED IS THAT OF THE ALPHA CUR-
C     SOR.
C
C
	CHARACTER*1 IMODE
      DIMENSION IN(7)
C
#ifdef unix
	include 'PLTCOM.DAT'
#else
	include 'pplinc:PLTCOM.DAT'
#endif

CC      Linux port:
        integer octal37

#ifdef FORTRAN_90
        data    octal37/O'37'/
#else
        data    octal37/'37'O/
#endif

C
C     SET ALPHAS MODE.
C
      IMODE = PMODE
      PMODE = ALPHA
C
C     IF THE LAST POINT WAS NOT PLOTTED BECAUSE THE PEN WAS UP,
C     PLOT THE POINT NOW.
C
      IF(SAVEF)CALL XYZPLT
C
C     RESTORE THE CURRENT PLOTTING MODE.
C
      PMODE = IMODE
C
C     CHECK THE PLOT TYPE.
C
      IF(PTYPE .EQ. 0 .OR. PTYPE .EQ. -1.OR.PTYPE.GT.2)GO TO 20
C
C     CHECK THE TEKTERMINAL TYPE.
C
      IF(TTYPE .EQ. 4006)GO TO 20
C
C     WRITE OUT THE CHARACTER BUFFER.
C
      CALL CHDMP
      LHIA = 0
      LHIB = 0
      LLOBA = 0
      IF(TTYPE .EQ. -4662 .OR. TTYPE .EQ. -4663)GO TO 10
C
C     SELECT ALPHA CURSOR ADDRESS INPUT MODE ON THE TEKTERMINAL
C     AND READ THE FIVE CHARACTERS GENERATED BY THE TEKTERMINAL.
C
      CALL CHOUT(ESC,1)
      CALL CHOUT(5,1)
      CALL CHIN(IN,5,0)
C
C     CHECK THE TEKTERMINAL TYPE.
C
      IF(TTYPE .GT. 0)THEN
C
C     CALCULATE THE COORDINATES OF THE POINT.
C
#ifdef unix
# ifdef NEED_IAND
        AOLD = FLOAT(IOR(ISHFT(IAND(IN(2), octal37),5),IAND(IN(3), octal37)
     *   )) / PLTOTA + AMIN
        BOLD = FLOAT(IOR(ISHFT(IAND(IN(4), octal37),5),IAND(IN(5), octal37)
     *   )) / PLTOTB + BMIN
      ELSE
C
C     CALCULATE THE COORDINATES OF THE POINT.
C
        AOLD = FLOAT(IOR(ISHFT(IAND(IN(2), octal37),7),ISHFT(IAND(IN(3),
     *    octal37),2))) / PLTOTA + AMIN
        BOLD = FLOAT(IOR(ISHFT(IAND(IN(4), octal37),7),ISHFT(IAND(IN(5),
     *    octal37),2))) / PLTOTB + BMIN
# else
        AOLD = FLOAT(OR(LSHIFT(AND(IN(2), 31),5),AND(IN(3), 31)
     *   )) / PLTOTA + AMIN
        BOLD = FLOAT(OR(LSHIFT(AND(IN(4), 31),5),AND(IN(5), 31)
     *   )) / PLTOTB + BMIN
      ELSE
C
C     CALCULATE THE COORDINATES OF THE POINT.
C
        AOLD = FLOAT(OR(LSHIFT(AND(IN(2), 31),7),LSHIFT(AND(IN(3),
     *    31),2))) / PLTOTA + AMIN
        BOLD = FLOAT(OR(LSHIFT(AND(IN(4), 31),7),LSHIFT(AND(IN(5),
     *    31),2))) / PLTOTB + BMIN
# endif
#else
        AOLD = FLOAT(IOR(ISHFT(IAND(IN(2), octal37),5),IAND(IN(3), octal37)
     *   )) / PLTOTA + AMIN
        BOLD = FLOAT(IOR(ISHFT(IAND(IN(4), octal37),5),IAND(IN(5), octal37)
     *   )) / PLTOTB + BMIN
      ELSE
C
C     CALCULATE THE COORDINATES OF THE POINT.
C
        AOLD = FLOAT(IOR(ISHFT(IAND(IN(2), octal37),7),ISHFT(IAND(IN(3),
     *    octal37),2))) / PLTOTA + AMIN
        BOLD = FLOAT(IOR(ISHFT(IAND(IN(4), octal37),7),ISHFT(IAND(IN(5),
     *    octal37),2))) / PLTOTB + BMIN
#endif
      ENDIF
      GO TO 20
C
C     CHECK THE GRAPHICS FLAG.
C
   10 IF(GRAPHF)THEN
C
C     SELECT GRAPHICAL INPUT MODE ON THE TEKTRONIX PLOTTER AND
C     READ THE SEVEN CHARACTERS GENERATED BY THE PLOTTER.
C
        CALL CHOUT(ESC,1)
        CALL CHOUT(IDTK,1)
        CALL CHOUT(77,1)
        CALL CHIN(IN,7,0)
C
C     CALCULATE THE COORDINATES OF THE POINT.
C
#ifdef unix
#ifdef sun
        AOLD = FLOAT(OR(OR(LSHIFT(AND(IN(1), 31),7),LSHIFT(AND(
     *IN(3),31),2)),rSHIFT(AND(IN(5), 31),3)))/PLTOTA+AMIN
        BOLD = FLOAT(OR(OR(LSHIFT(AND(IN(2), 31),7),LSHIFT(AND(
     *IN(4),31),2)),rSHIFT(AND(IN(6), 31),3)))/PLTOTB+BMIN
#else
# ifdef NEED_IAND
        AOLD = FLOAT(IOR(IOR(ISHFT(IAND(IN(1), octal37),7),ISHFT(IAND(
     *IN(3),octal37),2)),ISHFT(IAND(IN(5), octal37),-3)))/PLTOTA+AMIN
        BOLD = FLOAT(IOR(IOR(ISHFT(IAND(IN(2), octal37),7),ISHFT(IAND(
     *IN(4),octal37),2)),ISHFT(IAND(IN(6), octal37),-3)))/PLTOTB+BMIN
# else
        AOLD = FLOAT(OR(OR(LSHIFT(AND(IN(1), 31),7),LSHIFT(AND(
     *IN(3),31),2)),LSHIFT(AND(IN(5), 31),-3)))/PLTOTA+AMIN
        BOLD = FLOAT(OR(OR(LSHIFT(AND(IN(2), 31),7),LSHIFT(AND(
     *IN(4),31),2)),LSHIFT(AND(IN(6), 31),-3)))/PLTOTB+BMIN
# endif
#endif
#else
C
        AOLD = FLOAT(IOR(IOR(ISHFT(IAND(IN(1), octal37),7),ISHFT(IAND(
     *IN(3),octal37),2)),ISHFT(IAND(IN(5), octal37),-3)))/PLTOTA+AMIN
        BOLD = FLOAT(IOR(IOR(ISHFT(IAND(IN(2), octal37),7),ISHFT(IAND(
     *IN(4),octal37),2)),ISHFT(IAND(IN(6), octal37),-3)))/PLTOTB+BMIN
#endif
      ENDIF
C
C     TRANSFORM THE POINT TO THE USER'S COORDINATE SYSTEM.
C
   20 CALL TFORMI(XNEW,YNEW,ZNEW)
      X = XNEW / XSCALE
      Y = YNEW / YSCALE
      RETURN
C
      END
