/*
 *      fhist - file history and comparison tools
 *      Copyright (C) 1998, 2002, 2008 Peter Miller
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 3 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program. If not, see
 *      <http://www.gnu.org/licenses/>.
 */

#include <ac/unistd.h>


#ifndef HAVE_RENAME

/*
 * Routine to rename files using link and unlink.
 * Returns -1 on failure.
 */

int
rename(char *oldname, char *newname)
{
    if (link(oldname, newname) < 0)
        return -1;
    if (unlink(oldname) < 0)
    {
        unlink(newname);
        return -1;
    }
    return 0;
}

#endif
