/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 1991-2010 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Description
    Print a summary of the data described by the IOobject (for
    use in erroring, etc.) via the global 'Info' error
    mechanism.

\*---------------------------------------------------------------------------*/

#include "IOobject.H"
#include <OpenFOAM/token.H>

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#if defined (__GNUC__)
template<>
#endif
Foam::Ostream& Foam::operator<<(Ostream& os, const InfoProxy<IOobject>& ip)
{
    const IOobject& io = ip.t_;

    os  << "IOobject: "
        << io.type() << token::SPACE
        << io.name() << token::SPACE
        << io.path() << endl;

    return os;
}


// ************************ vim: set sw=4 sts=4 et: ************************ //
