/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 1991-2010 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::dxSurfaceWriter

Description

SourceFiles
    dxSurfaceWriter.C

\*---------------------------------------------------------------------------*/

#ifndef dxSurfaceWriter_H
#define dxSurfaceWriter_H

#include <sampling/surfaceWriter.H>

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                      Class dxSurfaceWriter Declaration
\*---------------------------------------------------------------------------*/

template<class Type>
class dxSurfaceWriter
:
    public surfaceWriter<Type>
{

    // Private Member Functions

        static void writeGeometry(Ostream&, const pointField&, const faceList&);

        static void writeData(Ostream&, const Field<Type>& values);

        static void writeTrailer(Ostream&);

public:

    //- Runtime type information
    TypeName("dx");


    // Constructors

        //- Construct null
        dxSurfaceWriter();


    // Destructor

        virtual ~dxSurfaceWriter();


    // Member Functions

        // Write

        //- Writes single surface to file.
        virtual void write
        (
            const fileName& outputDir,
            const fileName& surfaceName,
            const pointField& points,
            const faceList& faces,
            const fileName& fieldName,
            const Field<Type>& values,
            const bool verbose = false
        ) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
#   include "dxSurfaceWriter.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************ vim: set sw=4 sts=4 et: ************************ //
