'''OpenGL extension SGI.video_sync

This module customises the behaviour of the 
OpenGL.raw.GLX.SGI.video_sync to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides a means for synchronization with the video 
	frame rate of a monitor.  (In the case of an interlaced monitor, 
	this is typically the rate of displaying both the even and odd 
	fields of a frame.) The kernel maintains a video sync counter for 
	each physical hardware pipe in a system; the counter is incremented 
	upon the completion of the display of each full frame of video data. An
	OpenGL context always corresponds to a pipe.  When an OpenGL process
	has a current context, it can put itself to sleep until the counter of
	that pipe reaches a desired value.  The process can also query the
	value of the counter.
	
	The counter runs as long as the graphics subsystem is running; it is
	initialized via the /usr/gfx/gfxinit command.  However, a process can
	query or sleep on the counter only when a direct context is current.
	Each of the procedures described below will fail and return an error
	code if the current context is not a direct one.
	
	The counter is an unsigned 32-bit integer.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SGI/video_sync.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper

import ctypes
from OpenGL.raw.GLX import _types
from OpenGL.raw.GLX.SGI.video_sync import *
from OpenGL.raw.GLX.SGI.video_sync import _EXTENSION_NAME

def glInitVideoSyncSGI():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION