(declare (extended-bindings) (not constant-fold) (not safe))

(define v1 (##s32vector -2147483648 -111 0 111 2147483647))
(define v2 (##make-s32vector 10 -2147483648))
(define v3 (##make-s32vector 10 -111))
(define v4 (##make-s32vector 10))
(define v5 (##make-s32vector 10 111))
(define v6 (##make-s32vector 10 2147483647))
(define v7 '#s32(-2147483648 -111 0 111 2147483647))

(define (int= x y)
  (if (##fixnum? x)
      (and (##fixnum? y)
           (##fx= x y))
      (and (##bignum? x)
           (##bignum? y)
           (let ((len (##bignum.adigit-length x)))
             (and (##fx= len (##bignum.adigit-length y))
                  (let loop ((i (##fx- len 1)))
                    (if (##fx< i 0)
                        (and (##bignum.adigit-= x y i)
                             (loop (##fx- i 1)))
                        #t)))))))
        
(define (test v i expected)
  (let ((val (##s32vector-ref v i))) 
    (println (if (int= val expected) "good" "bad"))))

(test v1 0 -2147483648)
(test v1 1 -111)
(test v1 2 0)
(test v1 3 111)
(test v1 4 2147483647)

(test v2 9 -2147483648)
(test v3 9 -111)
(test v4 9 0)
(test v5 9 111)
(test v6 9 2147483647)

(test v7 0 -2147483648)
(test v7 1 -111)
(test v7 2 0)
(test v7 3 111)
(test v7 4 2147483647)
