/* do not edit automatically generated by mc from Scan.  */
/* Scan.def Provides a primitive symbol fetching from input.

Copyright (C) 2001-2023 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */


#if !defined (_Scan_H)
#   define _Scan_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif


#   if defined (_Scan_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
 OpenSource - opens a source file for reading.                  */

EXTERN unsigned int Scan_OpenSource (const char *a_, unsigned int _a_high);

/*
 CloseSource - closes the current source file from reading.     */

EXTERN void Scan_CloseSource (void);

/*
 GetNextSymbol gets the next source symbol and returns it in a. */

EXTERN void Scan_GetNextSymbol (char *a, unsigned int _a_high);
EXTERN void Scan_WriteError (const char *a_, unsigned int _a_high);

/*
   TerminateOnError - exits with status 1 if we call WriteError.
*/

EXTERN void Scan_TerminateOnError (void);

/*
   DefineComments - defines the start of comments within the source
                    file.

                    The characters in Start define the comment start
                    and characters in End define the end.
                    The BOOLEAN eoln determine whether the comment
                    is terminated by end of line. If eoln is TRUE
                    then End is ignored.

                    If this procedure is never called then no comments
                    are allowed.
*/

EXTERN void Scan_DefineComments (const char *Start_, unsigned int _Start_high, const char *End_, unsigned int _End_high, unsigned int eoln);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
