static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2007 Øyvind Kolås <oeyvindk@hig.no>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"    /* No properties */                                                       \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_COMPOSER                                                      \n"
"#define GEGL_OP_C_SOURCE hstack.c                                             \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = {0,0,0,0};                                          \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (operation, \n"
"                                                                     \"input\");\n"
"  GeglRectangle *aux_rect = gegl_operation_source_get_bounding_box (operation,\n"
"                                                                      \"aux\");\n"
"                                                                              \n"
"  if (!in_rect || !aux_rect)                                                  \n"
"    return result;                                                            \n"
"                                                                              \n"
"  result = *in_rect;                                                          \n"
"  if (result.width  != 0 &&                                                   \n"
"      result.height != 0)                                                     \n"
"    {                                                                         \n"
"      result.width += aux_rect->width;                                        \n"
"      if (aux_rect->height > result.height)                                   \n"
"        result.height = aux_rect->height;                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *self,                           \n"
"                       const gchar         *input_pad,                        \n"
"                       const GeglRectangle *roi)                              \n"
"{                                                                             \n"
"  GeglRectangle request = *roi;                                               \n"
"                                                                              \n"
"  if (!strcmp (input_pad, \"aux\"))                                           \n"
"    {                                                                         \n"
"      GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (self,  \n"
"                                                                         \"input\");\n"
"      GeglRectangle *aux_rect = gegl_operation_source_get_bounding_box (self, \n"
"                                                                         \"aux\");\n"
"                                                                              \n"
"      if (request.width != 0 &&                                               \n"
"          request.height != 0)                                                \n"
"        {                                                                     \n"
"          request.x -= in_rect->width + aux_rect->x;                          \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return request;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_invalidated_by_change (GeglOperation       *self,                         \n"
"                           const gchar         *input_pad,                    \n"
"                           const GeglRectangle *region)                       \n"
"{                                                                             \n"
"  if (!strcmp (input_pad, \"input\"))                                         \n"
"    {                                                                         \n"
"      return *region;                                                         \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      /*region.x -= radius * 2;*/                                             \n"
"    }                                                                         \n"
"  return *region;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *aux,                                            \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglBuffer            *temp_in;                                             \n"
"  GeglBuffer            *temp_aux;                                            \n"
"                                                                              \n"
"  /* FIXME: just pass the originals buffers if the result rectangle does not  \n"
"   * include both input buffers                                               \n"
"   */                                                                         \n"
"                                                                              \n"
"  temp_in = gegl_buffer_create_sub_buffer (input, result);                    \n"
"  temp_aux = gegl_buffer_create_sub_buffer (aux, result);                     \n"
"                                                                              \n"
"    {                                                                         \n"
"      gfloat *buf  = g_new0 (gfloat, result->width * result->height * 4);     \n"
"      gfloat *bufB = g_new0 (gfloat, result->width * result->height * 4);     \n"
"                                                                              \n"
"      gegl_buffer_get (temp_in,  NULL, 1.0, babl_format (\"RGBA float\"), buf,\n"
"                       GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                 \n"
"      gegl_buffer_get (temp_aux, NULL, 1.0, babl_format (\"RGBA float\"), bufB,\n"
"                       GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                 \n"
"        {                                                                     \n"
"          gint offset=0;                                                      \n"
"          gint x,y;                                                           \n"
"          for (y=0;y<gegl_buffer_get_height (output);y++)                     \n"
"            for (x=0;x<gegl_buffer_get_width (output);x++)                    \n"
"              {                                                               \n"
"                if (x + result->x >= gegl_buffer_get_width (input))           \n"
"                  {                                                           \n"
"                    buf[offset+0]=bufB[offset+0];                             \n"
"                    buf[offset+1]=bufB[offset+1];                             \n"
"                    buf[offset+2]=bufB[offset+2];                             \n"
"                    buf[offset+3]=bufB[offset+3];                             \n"
"                  }                                                           \n"
"                offset+=4;                                                    \n"
"              }                                                               \n"
"        }                                                                     \n"
"      gegl_buffer_set (output, NULL, 0, babl_format (\"RGBA float\"), buf,    \n"
"                       GEGL_AUTO_ROWSTRIDE);                                  \n"
"                                                                              \n"
"      g_free (buf);                                                           \n"
"      g_free (bufB);                                                          \n"
"    }                                                                         \n"
"  g_object_unref (temp_in);                                                   \n"
"  g_object_unref (temp_aux);                                                  \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass         *operation_class;                                \n"
"  GeglOperationComposerClass *composer_class;                                 \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  composer_class  = GEGL_OPERATION_COMPOSER_CLASS (klass);                    \n"
"                                                                              \n"
"  composer_class->process = process;                                          \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_invalidated_by_change = get_invalidated_by_change;     \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"  \"name\"        , \"gegl:hstack\",                                          \n"
"  \"categories\"  , \"misc\",                                                 \n"
"  \"description\" ,                                                           \n"
"        _(\"Horizontally stack inputs, (in \\\"output\\\" \\\"aux\\\" is placed to the right of \\\"input\\\")\"),\n"
"        NULL);                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
