/*
 * Decompiled with CFR 0.152.
 */
package gmonitor.gui;

import gmonitor.gui.RawData;
import gmonitor.gui.RawDataElement;
import java.util.ArrayList;

public class GraphMonitorModel {
    private ArrayList rawdata;
    private boolean sumMode = false;
    private long begin;
    private long term;
    private long prefixFactor = 1L;
    private long maxValue;
    private long maxValueTime;
    private long minValue;
    private long minValueTime;
    private long latestValue;
    private long latestValueTime;
    private double avgValue;
    private long topValue;

    public long getBegin() {
        return this.begin;
    }

    public ArrayList getRawDataSeries() {
        return this.rawdata;
    }

    public boolean isSumMode() {
        return this.sumMode;
    }

    public long getTerm() {
        return this.term;
    }

    public void setBegin(long l) {
        this.begin = l;
    }

    private long findMaxValue(RawDataElement[] rawDataElementArray) {
        long l = 0L;
        for (int i = 0; i < rawDataElementArray.length; ++i) {
            if (rawDataElementArray[i].getValue() <= l || !rawDataElementArray[i].isValid()) continue;
            l = rawDataElementArray[i].getValue();
            this.maxValueTime = rawDataElementArray[i].getTime();
        }
        return l;
    }

    private long findMinValue(RawDataElement[] rawDataElementArray) {
        long l = -1L;
        for (int i = 0; i < rawDataElementArray.length; ++i) {
            if (l != -1L && rawDataElementArray[i].getValue() >= l || !rawDataElementArray[i].isValid()) continue;
            l = rawDataElementArray[i].getValue();
            this.minValueTime = rawDataElementArray[i].getTime();
        }
        return l;
    }

    private double calcAverage(RawDataElement[] rawDataElementArray) {
        double d = 0.0;
        int n = 0;
        for (double d2 = 0.0; d2 < (double)rawDataElementArray.length; d2 += 1.0) {
            if (!rawDataElementArray[(int)d2].isValid()) {
                ++n;
                continue;
            }
            d = (d * (d2 - (double)n) + (double)rawDataElementArray[(int)d2].getValue()) / (d2 + 1.0 - (double)n);
        }
        return d;
    }

    private long findTopValue(long l) {
        long l2;
        for (l2 = 1L; l2 < l && (l2 *= 5L) < l; l2 *= 2L) {
        }
        return l2;
    }

    public void setRawDataSeries(ArrayList arrayList, long l) {
        this.rawdata = arrayList;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = -1L;
        double d = 0.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            long l5;
            RawData rawData = (RawData)arrayList.get(i);
            RawDataElement[] rawDataElementArray = rawData.getData();
            if (rawDataElementArray.length <= 0) continue;
            long l6 = this.findMaxValue(rawDataElementArray);
            if (l3 < l6) {
                l3 = l6;
            }
            if (l2 < (l5 = this.findTopValue(l3))) {
                l2 = l5;
            }
            long l7 = this.findMinValue(rawDataElementArray);
            if (l4 == -1L || l4 > l7) {
                l4 = l7;
            }
            d = this.calcAverage(rawDataElementArray);
            this.latestValue = rawDataElementArray[rawDataElementArray.length - 1].getValue();
            this.latestValueTime = rawDataElementArray[rawDataElementArray.length - 1].getTime();
            this.begin = rawDataElementArray[0].getTime();
        }
        this.term = this.latestValueTime - this.begin;
        this.topValue = l2 / l;
        this.maxValue = l3;
        this.minValue = l4;
        this.avgValue = d;
    }

    public void setSumMode(boolean bl) {
        this.sumMode = bl;
    }

    public void setTerm(long l) {
        this.term = l;
    }

    public long getPrefixFactor() {
        return this.prefixFactor;
    }

    public void setPrefixFactor(long l) {
        this.prefixFactor = l;
    }

    public long getTopValue() {
        return this.topValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public long getMaxValueTime() {
        return this.maxValueTime;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMinValueTime() {
        return this.minValueTime;
    }

    public long getLatestValue() {
        return this.latestValue;
    }

    public long getLatestValueTime() {
        return this.latestValueTime;
    }

    public double getAvgValue() {
        return this.avgValue;
    }
}

