/* GIMP Dimage color plugin
 * Copyright (C) 2002 Laurent HOUDARD <lhoudard@netcourrier.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"

#include <string.h>
#include <gtk/gtk.h>
#include <libgimp/gimp.h>
#include <libgimp/gimpmatrix.h>

#include "dimage_color.h"
#include "transform.h"
#include "preview.h"

static Preview preview;

void
preview_new (GtkWidget *parent)
{
  GtkWidget *preview_frame;
  GtkWidget *prev;

  preview_frame = gtk_frame_new (NULL);
  gtk_widget_show (preview_frame);
  gtk_container_add (GTK_CONTAINER (parent), preview_frame);
  gtk_frame_set_shadow_type (GTK_FRAME(preview_frame), GTK_SHADOW_IN);

  prev = gtk_preview_new (GTK_PREVIEW_COLOR);
  gtk_preview_size (GTK_PREVIEW (prev), preview.width, preview.height);
  gtk_container_add (GTK_CONTAINER (preview_frame), prev);
  gtk_widget_show (prev);
  preview.widget = prev;

  do_preview ();
}

void
build_preview (GimpDrawable *drw)
{
  gint x, y, b;
  GimpPixelRgn pr;
  guchar *bc, *drw_row;

  if (drw->width > drw->height) 
    {
      preview.scale  = (gdouble) drw->width / (gdouble) PREVIEW_SIZE;
      preview.width  = PREVIEW_SIZE;
      preview.height = drw->height / preview.scale;
    }
  else
    {
      preview.scale  = (gdouble) drw->height / (gdouble) PREVIEW_SIZE;
      preview.width  = drw->width / preview.scale;
      preview.height = PREVIEW_SIZE;
    }
  preview.bpp  = 3;
  preview.bits = g_new (guchar, preview.width * preview.height * preview.bpp);
  bc = preview.bits;

  gimp_pixel_rgn_init (&pr, drw, 0, 0, drw->width, drw->height, FALSE, FALSE);

  drw_row = g_new (guchar, drw->width * drw->bpp);

  for (y = 0; y < preview.height; y++)
    {
      gimp_pixel_rgn_get_row (&pr, drw_row, 0, 
			      (int) (y * preview.scale), drw->width);
      for (x = 0; x < preview.width ; x++)
	{
	  for (b = 0; b < preview.bpp; b++)
	    *bc++ = *(drw_row
		      + ((gint) (x * preview.scale) * preview.bpp) 
		      + b % drw->bpp);
	}
    }
  g_free (drw_row);

  preview.widget = NULL;
}

void
do_preview (void)
{
  guchar *src, *dst, *raw;
  gint x, y;

  src = preview.bits;
  raw = g_malloc (preview.width * preview.bpp);

  for (y = 0; y < preview.height; y++) 
    {
      dst = raw;

      for (x = 0; x < preview.width; x++)
	{
	  if (dc_int.do_preview == TRUE)
	    transform_point (src, dst, dc_int.visualize_out);
	  else 
	    memcpy (dst, src, preview.bpp);
	  src += preview.bpp;
	  dst += preview.bpp;
	}

      gtk_preview_draw_row (GTK_PREVIEW (preview.widget),
			    raw, 0, y, preview.width);
    }

  gtk_widget_draw (preview.widget, NULL);
  gdk_flush ();

  g_free (raw);
}

