/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimppattern_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include <string.h>

#include "gimp.h"


/**
 * SECTION: gimppattern
 * @title: gimppattern
 * @short_description: Functions operating on a single pattern.
 *
 * Functions operating on a single pattern.
 **/


/**
 * gimp_pattern_get_info:
 * @name: The pattern name.
 * @width: The pattern width.
 * @height: The pattern height.
 * @bpp: The pattern bpp.
 *
 * Retrieve information about the specified pattern.
 *
 * This procedure retrieves information about the specified pattern.
 * This includes the pattern extents (width and height).
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 **/
gboolean
gimp_pattern_get_info (const gchar *name,
                       gint        *width,
                       gint        *height,
                       gint        *bpp)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-pattern-get-info",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  *width = 0;
  *height = 0;
  *bpp = 0;

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    {
      *width = return_vals[1].data.d_int32;
      *height = return_vals[2].data.d_int32;
      *bpp = return_vals[3].data.d_int32;
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_pattern_get_pixels:
 * @name: The pattern name.
 * @width: The pattern width.
 * @height: The pattern height.
 * @bpp: The pattern bpp.
 * @num_color_bytes: Number of pattern bytes.
 * @color_bytes: The pattern data.
 *
 * Retrieve information about the specified pattern (including pixels).
 *
 * This procedure retrieves information about the specified. This
 * includes the pattern extents (width and height), its bpp and its
 * pixel data.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 **/
gboolean
gimp_pattern_get_pixels (const gchar  *name,
                         gint         *width,
                         gint         *height,
                         gint         *bpp,
                         gint         *num_color_bytes,
                         guint8      **color_bytes)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-pattern-get-pixels",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  *width = 0;
  *height = 0;
  *bpp = 0;
  *num_color_bytes = 0;
  *color_bytes = NULL;

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    {
      *width = return_vals[1].data.d_int32;
      *height = return_vals[2].data.d_int32;
      *bpp = return_vals[3].data.d_int32;
      *num_color_bytes = return_vals[4].data.d_int32;
      *color_bytes = g_new (guint8, *num_color_bytes);
      memcpy (*color_bytes,
              return_vals[5].data.d_int8array,
              *num_color_bytes * sizeof (guint8));
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}
