//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AADConnectivityStateAutoGenerated.
func (a AADConnectivityStateAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "connectivityState", a.ConnectivityState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AADConnectivityStateAutoGenerated.
func (a *AADConnectivityStateAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectivityState":
			err = unpopulate(val, "ConnectivityState", &a.ConnectivityState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AADExternalSecuritySolution.
func (a AADExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AADExternalSecuritySolution.
func (a *AADExternalSecuritySolution) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AADSolutionProperties.
func (a AADSolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "connectivityState", a.ConnectivityState)
	populate(objectMap, "deviceType", a.DeviceType)
	populate(objectMap, "deviceVendor", a.DeviceVendor)
	populate(objectMap, "workspace", a.Workspace)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AADSolutionProperties.
func (a *AADSolutionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectivityState":
			err = unpopulate(val, "ConnectivityState", &a.ConnectivityState)
			delete(rawMsg, key)
		case "deviceType":
			err = unpopulate(val, "DeviceType", &a.DeviceType)
			delete(rawMsg, key)
		case "deviceVendor":
			err = unpopulate(val, "DeviceVendor", &a.DeviceVendor)
			delete(rawMsg, key)
		case "workspace":
			err = unpopulate(val, "Workspace", &a.Workspace)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActiveConnectionsNotInAllowedRange.
func (a ActiveConnectionsNotInAllowedRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "isEnabled", a.IsEnabled)
	populate(objectMap, "maxThreshold", a.MaxThreshold)
	populate(objectMap, "minThreshold", a.MinThreshold)
	objectMap["ruleType"] = "ActiveConnectionsNotInAllowedRange"
	populate(objectMap, "timeWindowSize", a.TimeWindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActiveConnectionsNotInAllowedRange.
func (a *ActiveConnectionsNotInAllowedRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &a.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &a.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &a.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &a.RuleType)
			delete(rawMsg, key)
		case "timeWindowSize":
			err = unpopulate(val, "TimeWindowSize", &a.TimeWindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdaptiveApplicationControlGroup.
func (a AdaptiveApplicationControlGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdaptiveApplicationControlGroup.
func (a *AdaptiveApplicationControlGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdaptiveApplicationControlGroupData.
func (a AdaptiveApplicationControlGroupData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configurationStatus", a.ConfigurationStatus)
	populate(objectMap, "enforcementMode", a.EnforcementMode)
	populate(objectMap, "issues", a.Issues)
	populate(objectMap, "pathRecommendations", a.PathRecommendations)
	populate(objectMap, "protectionMode", a.ProtectionMode)
	populate(objectMap, "recommendationStatus", a.RecommendationStatus)
	populate(objectMap, "sourceSystem", a.SourceSystem)
	populate(objectMap, "vmRecommendations", a.VMRecommendations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdaptiveApplicationControlGroupData.
func (a *AdaptiveApplicationControlGroupData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationStatus":
			err = unpopulate(val, "ConfigurationStatus", &a.ConfigurationStatus)
			delete(rawMsg, key)
		case "enforcementMode":
			err = unpopulate(val, "EnforcementMode", &a.EnforcementMode)
			delete(rawMsg, key)
		case "issues":
			err = unpopulate(val, "Issues", &a.Issues)
			delete(rawMsg, key)
		case "pathRecommendations":
			err = unpopulate(val, "PathRecommendations", &a.PathRecommendations)
			delete(rawMsg, key)
		case "protectionMode":
			err = unpopulate(val, "ProtectionMode", &a.ProtectionMode)
			delete(rawMsg, key)
		case "recommendationStatus":
			err = unpopulate(val, "RecommendationStatus", &a.RecommendationStatus)
			delete(rawMsg, key)
		case "sourceSystem":
			err = unpopulate(val, "SourceSystem", &a.SourceSystem)
			delete(rawMsg, key)
		case "vmRecommendations":
			err = unpopulate(val, "VMRecommendations", &a.VMRecommendations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdaptiveApplicationControlGroups.
func (a AdaptiveApplicationControlGroups) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdaptiveApplicationControlGroups.
func (a *AdaptiveApplicationControlGroups) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdaptiveApplicationControlIssueSummary.
func (a AdaptiveApplicationControlIssueSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "issue", a.Issue)
	populate(objectMap, "numberOfVms", a.NumberOfVMs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdaptiveApplicationControlIssueSummary.
func (a *AdaptiveApplicationControlIssueSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "issue":
			err = unpopulate(val, "Issue", &a.Issue)
			delete(rawMsg, key)
		case "numberOfVms":
			err = unpopulate(val, "NumberOfVMs", &a.NumberOfVMs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdaptiveNetworkHardening.
func (a AdaptiveNetworkHardening) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdaptiveNetworkHardening.
func (a *AdaptiveNetworkHardening) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdaptiveNetworkHardeningEnforceRequest.
func (a AdaptiveNetworkHardeningEnforceRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "networkSecurityGroups", a.NetworkSecurityGroups)
	populate(objectMap, "rules", a.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdaptiveNetworkHardeningEnforceRequest.
func (a *AdaptiveNetworkHardeningEnforceRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkSecurityGroups":
			err = unpopulate(val, "NetworkSecurityGroups", &a.NetworkSecurityGroups)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &a.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdaptiveNetworkHardeningProperties.
func (a AdaptiveNetworkHardeningProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "effectiveNetworkSecurityGroups", a.EffectiveNetworkSecurityGroups)
	populate(objectMap, "rules", a.Rules)
	populateTimeRFC3339(objectMap, "rulesCalculationTime", a.RulesCalculationTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdaptiveNetworkHardeningProperties.
func (a *AdaptiveNetworkHardeningProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "effectiveNetworkSecurityGroups":
			err = unpopulate(val, "EffectiveNetworkSecurityGroups", &a.EffectiveNetworkSecurityGroups)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &a.Rules)
			delete(rawMsg, key)
		case "rulesCalculationTime":
			err = unpopulateTimeRFC3339(val, "RulesCalculationTime", &a.RulesCalculationTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdaptiveNetworkHardeningsList.
func (a AdaptiveNetworkHardeningsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdaptiveNetworkHardeningsList.
func (a *AdaptiveNetworkHardeningsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdditionalData.
func (a AdditionalData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["assessedResourceType"] = a.AssessedResourceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdditionalData.
func (a *AdditionalData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessedResourceType":
			err = unpopulate(val, "AssessedResourceType", &a.AssessedResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdditionalWorkspacesProperties.
func (a AdditionalWorkspacesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataTypes", a.DataTypes)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "workspace", a.Workspace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdditionalWorkspacesProperties.
func (a *AdditionalWorkspacesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataTypes":
			err = unpopulate(val, "DataTypes", &a.DataTypes)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "workspace":
			err = unpopulate(val, "Workspace", &a.Workspace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdvancedThreatProtectionProperties.
func (a AdvancedThreatProtectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isEnabled", a.IsEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdvancedThreatProtectionProperties.
func (a *AdvancedThreatProtectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &a.IsEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdvancedThreatProtectionSetting.
func (a AdvancedThreatProtectionSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdvancedThreatProtectionSetting.
func (a *AdvancedThreatProtectionSetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Alert.
func (a Alert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Alert.
func (a *Alert) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertEntity.
func (a AlertEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "type", a.Type)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertEntity.
func (a *AlertEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertList.
func (a AlertList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertList.
func (a *AlertList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertProperties.
func (a AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alertDisplayName", a.AlertDisplayName)
	populate(objectMap, "alertType", a.AlertType)
	populate(objectMap, "alertUri", a.AlertURI)
	populate(objectMap, "compromisedEntity", a.CompromisedEntity)
	populate(objectMap, "correlationKey", a.CorrelationKey)
	populate(objectMap, "description", a.Description)
	populateTimeRFC3339(objectMap, "endTimeUtc", a.EndTimeUTC)
	populate(objectMap, "entities", a.Entities)
	populate(objectMap, "extendedLinks", a.ExtendedLinks)
	populate(objectMap, "extendedProperties", a.ExtendedProperties)
	populate(objectMap, "intent", a.Intent)
	populate(objectMap, "isIncident", a.IsIncident)
	populateTimeRFC3339(objectMap, "processingEndTimeUtc", a.ProcessingEndTimeUTC)
	populate(objectMap, "productComponentName", a.ProductComponentName)
	populate(objectMap, "productName", a.ProductName)
	populate(objectMap, "remediationSteps", a.RemediationSteps)
	populate(objectMap, "resourceIdentifiers", a.ResourceIdentifiers)
	populate(objectMap, "severity", a.Severity)
	populateTimeRFC3339(objectMap, "startTimeUtc", a.StartTimeUTC)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "subTechniques", a.SubTechniques)
	populate(objectMap, "supportingEvidence", a.SupportingEvidence)
	populate(objectMap, "systemAlertId", a.SystemAlertID)
	populate(objectMap, "techniques", a.Techniques)
	populateTimeRFC3339(objectMap, "timeGeneratedUtc", a.TimeGeneratedUTC)
	populate(objectMap, "vendorName", a.VendorName)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertProperties.
func (a *AlertProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertDisplayName":
			err = unpopulate(val, "AlertDisplayName", &a.AlertDisplayName)
			delete(rawMsg, key)
		case "alertType":
			err = unpopulate(val, "AlertType", &a.AlertType)
			delete(rawMsg, key)
		case "alertUri":
			err = unpopulate(val, "AlertURI", &a.AlertURI)
			delete(rawMsg, key)
		case "compromisedEntity":
			err = unpopulate(val, "CompromisedEntity", &a.CompromisedEntity)
			delete(rawMsg, key)
		case "correlationKey":
			err = unpopulate(val, "CorrelationKey", &a.CorrelationKey)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "endTimeUtc":
			err = unpopulateTimeRFC3339(val, "EndTimeUTC", &a.EndTimeUTC)
			delete(rawMsg, key)
		case "entities":
			err = unpopulate(val, "Entities", &a.Entities)
			delete(rawMsg, key)
		case "extendedLinks":
			err = unpopulate(val, "ExtendedLinks", &a.ExtendedLinks)
			delete(rawMsg, key)
		case "extendedProperties":
			err = unpopulate(val, "ExtendedProperties", &a.ExtendedProperties)
			delete(rawMsg, key)
		case "intent":
			err = unpopulate(val, "Intent", &a.Intent)
			delete(rawMsg, key)
		case "isIncident":
			err = unpopulate(val, "IsIncident", &a.IsIncident)
			delete(rawMsg, key)
		case "processingEndTimeUtc":
			err = unpopulateTimeRFC3339(val, "ProcessingEndTimeUTC", &a.ProcessingEndTimeUTC)
			delete(rawMsg, key)
		case "productComponentName":
			err = unpopulate(val, "ProductComponentName", &a.ProductComponentName)
			delete(rawMsg, key)
		case "productName":
			err = unpopulate(val, "ProductName", &a.ProductName)
			delete(rawMsg, key)
		case "remediationSteps":
			err = unpopulate(val, "RemediationSteps", &a.RemediationSteps)
			delete(rawMsg, key)
		case "resourceIdentifiers":
			a.ResourceIdentifiers, err = unmarshalResourceIdentifierClassificationArray(val)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &a.Severity)
			delete(rawMsg, key)
		case "startTimeUtc":
			err = unpopulateTimeRFC3339(val, "StartTimeUTC", &a.StartTimeUTC)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "subTechniques":
			err = unpopulate(val, "SubTechniques", &a.SubTechniques)
			delete(rawMsg, key)
		case "supportingEvidence":
			err = unpopulate(val, "SupportingEvidence", &a.SupportingEvidence)
			delete(rawMsg, key)
		case "systemAlertId":
			err = unpopulate(val, "SystemAlertID", &a.SystemAlertID)
			delete(rawMsg, key)
		case "techniques":
			err = unpopulate(val, "Techniques", &a.Techniques)
			delete(rawMsg, key)
		case "timeGeneratedUtc":
			err = unpopulateTimeRFC3339(val, "TimeGeneratedUTC", &a.TimeGeneratedUTC)
			delete(rawMsg, key)
		case "vendorName":
			err = unpopulate(val, "VendorName", &a.VendorName)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertPropertiesSupportingEvidence.
func (a AlertPropertiesSupportingEvidence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "type", a.Type)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertPropertiesSupportingEvidence.
func (a *AlertPropertiesSupportingEvidence) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertSimulatorBundlesRequestProperties.
func (a AlertSimulatorBundlesRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bundles", a.Bundles)
	objectMap["kind"] = KindBundles
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertSimulatorBundlesRequestProperties.
func (a *AlertSimulatorBundlesRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bundles":
			err = unpopulate(val, "Bundles", &a.Bundles)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertSimulatorRequestBody.
func (a AlertSimulatorRequestBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertSimulatorRequestBody.
func (a *AlertSimulatorRequestBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			a.Properties, err = unmarshalAlertSimulatorRequestPropertiesClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertSimulatorRequestProperties.
func (a AlertSimulatorRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["kind"] = a.Kind
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertSimulatorRequestProperties.
func (a *AlertSimulatorRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertSyncSettingProperties.
func (a AlertSyncSettingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enabled", a.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertSyncSettingProperties.
func (a *AlertSyncSettingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertSyncSettings.
func (a AlertSyncSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	objectMap["kind"] = SettingKindAlertSyncSettings
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertSyncSettings.
func (a *AlertSyncSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertsSuppressionRule.
func (a AlertsSuppressionRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertsSuppressionRule.
func (a *AlertsSuppressionRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertsSuppressionRuleProperties.
func (a AlertsSuppressionRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alertType", a.AlertType)
	populate(objectMap, "comment", a.Comment)
	populateTimeRFC3339(objectMap, "expirationDateUtc", a.ExpirationDateUTC)
	populateTimeRFC3339(objectMap, "lastModifiedUtc", a.LastModifiedUTC)
	populate(objectMap, "reason", a.Reason)
	populate(objectMap, "state", a.State)
	populate(objectMap, "suppressionAlertsScope", a.SuppressionAlertsScope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertsSuppressionRuleProperties.
func (a *AlertsSuppressionRuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertType":
			err = unpopulate(val, "AlertType", &a.AlertType)
			delete(rawMsg, key)
		case "comment":
			err = unpopulate(val, "Comment", &a.Comment)
			delete(rawMsg, key)
		case "expirationDateUtc":
			err = unpopulateTimeRFC3339(val, "ExpirationDateUTC", &a.ExpirationDateUTC)
			delete(rawMsg, key)
		case "lastModifiedUtc":
			err = unpopulateTimeRFC3339(val, "LastModifiedUTC", &a.LastModifiedUTC)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &a.Reason)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		case "suppressionAlertsScope":
			err = unpopulate(val, "SuppressionAlertsScope", &a.SuppressionAlertsScope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertsSuppressionRulesList.
func (a AlertsSuppressionRulesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertsSuppressionRulesList.
func (a *AlertsSuppressionRulesList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AllowedConnectionsList.
func (a AllowedConnectionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AllowedConnectionsList.
func (a *AllowedConnectionsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AllowedConnectionsResource.
func (a AllowedConnectionsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AllowedConnectionsResource.
func (a *AllowedConnectionsResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AllowedConnectionsResourceProperties.
func (a AllowedConnectionsResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "calculatedDateTime", a.CalculatedDateTime)
	populate(objectMap, "connectableResources", a.ConnectableResources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AllowedConnectionsResourceProperties.
func (a *AllowedConnectionsResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "calculatedDateTime":
			err = unpopulateTimeRFC3339(val, "CalculatedDateTime", &a.CalculatedDateTime)
			delete(rawMsg, key)
		case "connectableResources":
			err = unpopulate(val, "ConnectableResources", &a.ConnectableResources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AllowlistCustomAlertRule.
func (a AllowlistCustomAlertRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowlistValues", a.AllowlistValues)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "isEnabled", a.IsEnabled)
	objectMap["ruleType"] = "AllowlistCustomAlertRule"
	populate(objectMap, "valueType", a.ValueType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AllowlistCustomAlertRule.
func (a *AllowlistCustomAlertRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowlistValues":
			err = unpopulate(val, "AllowlistValues", &a.AllowlistValues)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &a.IsEnabled)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &a.RuleType)
			delete(rawMsg, key)
		case "valueType":
			err = unpopulate(val, "ValueType", &a.ValueType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmqpC2DMessagesNotInAllowedRange.
func (a AmqpC2DMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "isEnabled", a.IsEnabled)
	populate(objectMap, "maxThreshold", a.MaxThreshold)
	populate(objectMap, "minThreshold", a.MinThreshold)
	objectMap["ruleType"] = "AmqpC2DMessagesNotInAllowedRange"
	populate(objectMap, "timeWindowSize", a.TimeWindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmqpC2DMessagesNotInAllowedRange.
func (a *AmqpC2DMessagesNotInAllowedRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &a.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &a.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &a.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &a.RuleType)
			delete(rawMsg, key)
		case "timeWindowSize":
			err = unpopulate(val, "TimeWindowSize", &a.TimeWindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmqpC2DRejectedMessagesNotInAllowedRange.
func (a AmqpC2DRejectedMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "isEnabled", a.IsEnabled)
	populate(objectMap, "maxThreshold", a.MaxThreshold)
	populate(objectMap, "minThreshold", a.MinThreshold)
	objectMap["ruleType"] = "AmqpC2DRejectedMessagesNotInAllowedRange"
	populate(objectMap, "timeWindowSize", a.TimeWindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmqpC2DRejectedMessagesNotInAllowedRange.
func (a *AmqpC2DRejectedMessagesNotInAllowedRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &a.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &a.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &a.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &a.RuleType)
			delete(rawMsg, key)
		case "timeWindowSize":
			err = unpopulate(val, "TimeWindowSize", &a.TimeWindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmqpD2CMessagesNotInAllowedRange.
func (a AmqpD2CMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "isEnabled", a.IsEnabled)
	populate(objectMap, "maxThreshold", a.MaxThreshold)
	populate(objectMap, "minThreshold", a.MinThreshold)
	objectMap["ruleType"] = "AmqpD2CMessagesNotInAllowedRange"
	populate(objectMap, "timeWindowSize", a.TimeWindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmqpD2CMessagesNotInAllowedRange.
func (a *AmqpD2CMessagesNotInAllowedRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &a.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &a.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &a.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &a.RuleType)
			delete(rawMsg, key)
		case "timeWindowSize":
			err = unpopulate(val, "TimeWindowSize", &a.TimeWindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Application.
func (a Application) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Application.
func (a *Application) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationCondition.
func (a ApplicationCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "operator", a.Operator)
	populate(objectMap, "property", a.Property)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationCondition.
func (a *ApplicationCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operator":
			err = unpopulate(val, "Operator", &a.Operator)
			delete(rawMsg, key)
		case "property":
			err = unpopulate(val, "Property", &a.Property)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationProperties.
func (a ApplicationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "conditionSets", a.ConditionSets)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "sourceResourceType", a.SourceResourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationProperties.
func (a *ApplicationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "conditionSets":
			err = unpopulate(val, "ConditionSets", &a.ConditionSets)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "sourceResourceType":
			err = unpopulate(val, "SourceResourceType", &a.SourceResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationsList.
func (a ApplicationsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationsList.
func (a *ApplicationsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AscLocation.
func (a AscLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", &a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AscLocation.
func (a *AscLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AscLocationList.
func (a AscLocationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AscLocationList.
func (a *AscLocationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Assessment.
func (a Assessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Assessment.
func (a *Assessment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentLinks.
func (a AssessmentLinks) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azurePortalUri", a.AzurePortalURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentLinks.
func (a *AssessmentLinks) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azurePortalUri":
			err = unpopulate(val, "AzurePortalURI", &a.AzurePortalURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentList.
func (a AssessmentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentList.
func (a *AssessmentList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentMetadata.
func (a AssessmentMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentMetadata.
func (a *AssessmentMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentMetadataPartnerData.
func (a AssessmentMetadataPartnerData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "partnerName", a.PartnerName)
	populate(objectMap, "productName", a.ProductName)
	populate(objectMap, "secret", a.Secret)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentMetadataPartnerData.
func (a *AssessmentMetadataPartnerData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "partnerName":
			err = unpopulate(val, "PartnerName", &a.PartnerName)
			delete(rawMsg, key)
		case "productName":
			err = unpopulate(val, "ProductName", &a.ProductName)
			delete(rawMsg, key)
		case "secret":
			err = unpopulate(val, "Secret", &a.Secret)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentMetadataProperties.
func (a AssessmentMetadataProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assessmentType", a.AssessmentType)
	populate(objectMap, "categories", a.Categories)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "implementationEffort", a.ImplementationEffort)
	populate(objectMap, "partnerData", a.PartnerData)
	populate(objectMap, "policyDefinitionId", a.PolicyDefinitionID)
	populate(objectMap, "preview", a.Preview)
	populate(objectMap, "remediationDescription", a.RemediationDescription)
	populate(objectMap, "severity", a.Severity)
	populate(objectMap, "threats", a.Threats)
	populate(objectMap, "userImpact", a.UserImpact)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentMetadataProperties.
func (a *AssessmentMetadataProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentType":
			err = unpopulate(val, "AssessmentType", &a.AssessmentType)
			delete(rawMsg, key)
		case "categories":
			err = unpopulate(val, "Categories", &a.Categories)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "implementationEffort":
			err = unpopulate(val, "ImplementationEffort", &a.ImplementationEffort)
			delete(rawMsg, key)
		case "partnerData":
			err = unpopulate(val, "PartnerData", &a.PartnerData)
			delete(rawMsg, key)
		case "policyDefinitionId":
			err = unpopulate(val, "PolicyDefinitionID", &a.PolicyDefinitionID)
			delete(rawMsg, key)
		case "preview":
			err = unpopulate(val, "Preview", &a.Preview)
			delete(rawMsg, key)
		case "remediationDescription":
			err = unpopulate(val, "RemediationDescription", &a.RemediationDescription)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &a.Severity)
			delete(rawMsg, key)
		case "threats":
			err = unpopulate(val, "Threats", &a.Threats)
			delete(rawMsg, key)
		case "userImpact":
			err = unpopulate(val, "UserImpact", &a.UserImpact)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentMetadataPropertiesResponse.
func (a AssessmentMetadataPropertiesResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assessmentType", a.AssessmentType)
	populate(objectMap, "categories", a.Categories)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "implementationEffort", a.ImplementationEffort)
	populate(objectMap, "partnerData", a.PartnerData)
	populate(objectMap, "plannedDeprecationDate", a.PlannedDeprecationDate)
	populate(objectMap, "policyDefinitionId", a.PolicyDefinitionID)
	populate(objectMap, "preview", a.Preview)
	populate(objectMap, "publishDates", a.PublishDates)
	populate(objectMap, "remediationDescription", a.RemediationDescription)
	populate(objectMap, "severity", a.Severity)
	populate(objectMap, "tactics", a.Tactics)
	populate(objectMap, "techniques", a.Techniques)
	populate(objectMap, "threats", a.Threats)
	populate(objectMap, "userImpact", a.UserImpact)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentMetadataPropertiesResponse.
func (a *AssessmentMetadataPropertiesResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentType":
			err = unpopulate(val, "AssessmentType", &a.AssessmentType)
			delete(rawMsg, key)
		case "categories":
			err = unpopulate(val, "Categories", &a.Categories)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "implementationEffort":
			err = unpopulate(val, "ImplementationEffort", &a.ImplementationEffort)
			delete(rawMsg, key)
		case "partnerData":
			err = unpopulate(val, "PartnerData", &a.PartnerData)
			delete(rawMsg, key)
		case "plannedDeprecationDate":
			err = unpopulate(val, "PlannedDeprecationDate", &a.PlannedDeprecationDate)
			delete(rawMsg, key)
		case "policyDefinitionId":
			err = unpopulate(val, "PolicyDefinitionID", &a.PolicyDefinitionID)
			delete(rawMsg, key)
		case "preview":
			err = unpopulate(val, "Preview", &a.Preview)
			delete(rawMsg, key)
		case "publishDates":
			err = unpopulate(val, "PublishDates", &a.PublishDates)
			delete(rawMsg, key)
		case "remediationDescription":
			err = unpopulate(val, "RemediationDescription", &a.RemediationDescription)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &a.Severity)
			delete(rawMsg, key)
		case "tactics":
			err = unpopulate(val, "Tactics", &a.Tactics)
			delete(rawMsg, key)
		case "techniques":
			err = unpopulate(val, "Techniques", &a.Techniques)
			delete(rawMsg, key)
		case "threats":
			err = unpopulate(val, "Threats", &a.Threats)
			delete(rawMsg, key)
		case "userImpact":
			err = unpopulate(val, "UserImpact", &a.UserImpact)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentMetadataPropertiesResponsePublishDates.
func (a AssessmentMetadataPropertiesResponsePublishDates) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "GA", a.GA)
	populate(objectMap, "public", a.Public)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentMetadataPropertiesResponsePublishDates.
func (a *AssessmentMetadataPropertiesResponsePublishDates) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "GA":
			err = unpopulate(val, "GA", &a.GA)
			delete(rawMsg, key)
		case "public":
			err = unpopulate(val, "Public", &a.Public)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentMetadataResponse.
func (a AssessmentMetadataResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentMetadataResponse.
func (a *AssessmentMetadataResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentMetadataResponseList.
func (a AssessmentMetadataResponseList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentMetadataResponseList.
func (a *AssessmentMetadataResponseList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentPartnerData.
func (a AssessmentPartnerData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "partnerName", a.PartnerName)
	populate(objectMap, "secret", a.Secret)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentPartnerData.
func (a *AssessmentPartnerData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "partnerName":
			err = unpopulate(val, "PartnerName", &a.PartnerName)
			delete(rawMsg, key)
		case "secret":
			err = unpopulate(val, "Secret", &a.Secret)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentProperties.
func (a AssessmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalData", a.AdditionalData)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "links", a.Links)
	populate(objectMap, "metadata", a.Metadata)
	populate(objectMap, "partnersData", a.PartnersData)
	populate(objectMap, "resourceDetails", a.ResourceDetails)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentProperties.
func (a *AssessmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &a.AdditionalData)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "links":
			err = unpopulate(val, "Links", &a.Links)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "partnersData":
			err = unpopulate(val, "PartnersData", &a.PartnersData)
			delete(rawMsg, key)
		case "resourceDetails":
			a.ResourceDetails, err = unmarshalResourceDetailsClassification(val)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentPropertiesBase.
func (a AssessmentPropertiesBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalData", a.AdditionalData)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "links", a.Links)
	populate(objectMap, "metadata", a.Metadata)
	populate(objectMap, "partnersData", a.PartnersData)
	populate(objectMap, "resourceDetails", a.ResourceDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentPropertiesBase.
func (a *AssessmentPropertiesBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &a.AdditionalData)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "links":
			err = unpopulate(val, "Links", &a.Links)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "partnersData":
			err = unpopulate(val, "PartnersData", &a.PartnersData)
			delete(rawMsg, key)
		case "resourceDetails":
			a.ResourceDetails, err = unmarshalResourceDetailsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentPropertiesResponse.
func (a AssessmentPropertiesResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalData", a.AdditionalData)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "links", a.Links)
	populate(objectMap, "metadata", a.Metadata)
	populate(objectMap, "partnersData", a.PartnersData)
	populate(objectMap, "resourceDetails", a.ResourceDetails)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentPropertiesResponse.
func (a *AssessmentPropertiesResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &a.AdditionalData)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "links":
			err = unpopulate(val, "Links", &a.Links)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "partnersData":
			err = unpopulate(val, "PartnersData", &a.PartnersData)
			delete(rawMsg, key)
		case "resourceDetails":
			a.ResourceDetails, err = unmarshalResourceDetailsClassification(val)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentResponse.
func (a AssessmentResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentResponse.
func (a *AssessmentResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentStatus.
func (a AssessmentStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cause", a.Cause)
	populate(objectMap, "code", a.Code)
	populate(objectMap, "description", a.Description)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentStatus.
func (a *AssessmentStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cause":
			err = unpopulate(val, "Cause", &a.Cause)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &a.Code)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentStatusResponse.
func (a AssessmentStatusResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cause", a.Cause)
	populate(objectMap, "code", a.Code)
	populate(objectMap, "description", a.Description)
	populateTimeRFC3339(objectMap, "firstEvaluationDate", a.FirstEvaluationDate)
	populateTimeRFC3339(objectMap, "statusChangeDate", a.StatusChangeDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentStatusResponse.
func (a *AssessmentStatusResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cause":
			err = unpopulate(val, "Cause", &a.Cause)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &a.Code)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "firstEvaluationDate":
			err = unpopulateTimeRFC3339(val, "FirstEvaluationDate", &a.FirstEvaluationDate)
			delete(rawMsg, key)
		case "statusChangeDate":
			err = unpopulateTimeRFC3339(val, "StatusChangeDate", &a.StatusChangeDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AtaExternalSecuritySolution.
func (a AtaExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AtaExternalSecuritySolution.
func (a *AtaExternalSecuritySolution) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AtaSolutionProperties.
func (a AtaSolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deviceType", a.DeviceType)
	populate(objectMap, "deviceVendor", a.DeviceVendor)
	populate(objectMap, "lastEventReceived", a.LastEventReceived)
	populate(objectMap, "workspace", a.Workspace)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AtaSolutionProperties.
func (a *AtaSolutionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceType":
			err = unpopulate(val, "DeviceType", &a.DeviceType)
			delete(rawMsg, key)
		case "deviceVendor":
			err = unpopulate(val, "DeviceVendor", &a.DeviceVendor)
			delete(rawMsg, key)
		case "lastEventReceived":
			err = unpopulate(val, "LastEventReceived", &a.LastEventReceived)
			delete(rawMsg, key)
		case "workspace":
			err = unpopulate(val, "Workspace", &a.Workspace)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthenticationDetailsProperties.
func (a AuthenticationDetailsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authenticationProvisioningState", a.AuthenticationProvisioningState)
	objectMap["authenticationType"] = a.AuthenticationType
	populate(objectMap, "grantedPermissions", a.GrantedPermissions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthenticationDetailsProperties.
func (a *AuthenticationDetailsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationProvisioningState":
			err = unpopulate(val, "AuthenticationProvisioningState", &a.AuthenticationProvisioningState)
			delete(rawMsg, key)
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &a.AuthenticationType)
			delete(rawMsg, key)
		case "grantedPermissions":
			err = unpopulate(val, "GrantedPermissions", &a.GrantedPermissions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoProvisioningSetting.
func (a AutoProvisioningSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoProvisioningSetting.
func (a *AutoProvisioningSetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoProvisioningSettingList.
func (a AutoProvisioningSettingList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoProvisioningSettingList.
func (a *AutoProvisioningSettingList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoProvisioningSettingProperties.
func (a AutoProvisioningSettingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoProvision", a.AutoProvision)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoProvisioningSettingProperties.
func (a *AutoProvisioningSettingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoProvision":
			err = unpopulate(val, "AutoProvision", &a.AutoProvision)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Automation.
func (a Automation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Automation.
func (a *Automation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationAction.
func (a AutomationAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["actionType"] = a.ActionType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationAction.
func (a *AutomationAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &a.ActionType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationActionEventHub.
func (a AutomationActionEventHub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["actionType"] = ActionTypeEventHub
	populate(objectMap, "connectionString", a.ConnectionString)
	populate(objectMap, "eventHubResourceId", a.EventHubResourceID)
	populate(objectMap, "sasPolicyName", a.SasPolicyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationActionEventHub.
func (a *AutomationActionEventHub) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &a.ActionType)
			delete(rawMsg, key)
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &a.ConnectionString)
			delete(rawMsg, key)
		case "eventHubResourceId":
			err = unpopulate(val, "EventHubResourceID", &a.EventHubResourceID)
			delete(rawMsg, key)
		case "sasPolicyName":
			err = unpopulate(val, "SasPolicyName", &a.SasPolicyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationActionLogicApp.
func (a AutomationActionLogicApp) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["actionType"] = ActionTypeLogicApp
	populate(objectMap, "logicAppResourceId", a.LogicAppResourceID)
	populate(objectMap, "uri", a.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationActionLogicApp.
func (a *AutomationActionLogicApp) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &a.ActionType)
			delete(rawMsg, key)
		case "logicAppResourceId":
			err = unpopulate(val, "LogicAppResourceID", &a.LogicAppResourceID)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &a.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationActionWorkspace.
func (a AutomationActionWorkspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["actionType"] = ActionTypeWorkspace
	populate(objectMap, "workspaceResourceId", a.WorkspaceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationActionWorkspace.
func (a *AutomationActionWorkspace) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &a.ActionType)
			delete(rawMsg, key)
		case "workspaceResourceId":
			err = unpopulate(val, "WorkspaceResourceID", &a.WorkspaceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationList.
func (a AutomationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationList.
func (a *AutomationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationProperties.
func (a AutomationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", a.Actions)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "isEnabled", a.IsEnabled)
	populate(objectMap, "scopes", a.Scopes)
	populate(objectMap, "sources", a.Sources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationProperties.
func (a *AutomationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			a.Actions, err = unmarshalAutomationActionClassificationArray(val)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &a.IsEnabled)
			delete(rawMsg, key)
		case "scopes":
			err = unpopulate(val, "Scopes", &a.Scopes)
			delete(rawMsg, key)
		case "sources":
			err = unpopulate(val, "Sources", &a.Sources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationRuleSet.
func (a AutomationRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "rules", a.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationRuleSet.
func (a *AutomationRuleSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rules":
			err = unpopulate(val, "Rules", &a.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationScope.
func (a AutomationScope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", a.Description)
	populate(objectMap, "scopePath", a.ScopePath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationScope.
func (a *AutomationScope) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "scopePath":
			err = unpopulate(val, "ScopePath", &a.ScopePath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationSource.
func (a AutomationSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eventSource", a.EventSource)
	populate(objectMap, "ruleSets", a.RuleSets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationSource.
func (a *AutomationSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eventSource":
			err = unpopulate(val, "EventSource", &a.EventSource)
			delete(rawMsg, key)
		case "ruleSets":
			err = unpopulate(val, "RuleSets", &a.RuleSets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationTriggeringRule.
func (a AutomationTriggeringRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "expectedValue", a.ExpectedValue)
	populate(objectMap, "operator", a.Operator)
	populate(objectMap, "propertyJPath", a.PropertyJPath)
	populate(objectMap, "propertyType", a.PropertyType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationTriggeringRule.
func (a *AutomationTriggeringRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expectedValue":
			err = unpopulate(val, "ExpectedValue", &a.ExpectedValue)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &a.Operator)
			delete(rawMsg, key)
		case "propertyJPath":
			err = unpopulate(val, "PropertyJPath", &a.PropertyJPath)
			delete(rawMsg, key)
		case "propertyType":
			err = unpopulate(val, "PropertyType", &a.PropertyType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationValidationStatus.
func (a AutomationValidationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isValid", a.IsValid)
	populate(objectMap, "message", a.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationValidationStatus.
func (a *AutomationValidationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isValid":
			err = unpopulate(val, "IsValid", &a.IsValid)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &a.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AwAssumeRoleAuthenticationDetailsProperties.
func (a AwAssumeRoleAuthenticationDetailsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accountId", a.AccountID)
	populate(objectMap, "authenticationProvisioningState", a.AuthenticationProvisioningState)
	objectMap["authenticationType"] = AuthenticationTypeAwsAssumeRole
	populate(objectMap, "awsAssumeRoleArn", a.AwsAssumeRoleArn)
	populate(objectMap, "awsExternalId", a.AwsExternalID)
	populate(objectMap, "grantedPermissions", a.GrantedPermissions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AwAssumeRoleAuthenticationDetailsProperties.
func (a *AwAssumeRoleAuthenticationDetailsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountId":
			err = unpopulate(val, "AccountID", &a.AccountID)
			delete(rawMsg, key)
		case "authenticationProvisioningState":
			err = unpopulate(val, "AuthenticationProvisioningState", &a.AuthenticationProvisioningState)
			delete(rawMsg, key)
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &a.AuthenticationType)
			delete(rawMsg, key)
		case "awsAssumeRoleArn":
			err = unpopulate(val, "AwsAssumeRoleArn", &a.AwsAssumeRoleArn)
			delete(rawMsg, key)
		case "awsExternalId":
			err = unpopulate(val, "AwsExternalID", &a.AwsExternalID)
			delete(rawMsg, key)
		case "grantedPermissions":
			err = unpopulate(val, "GrantedPermissions", &a.GrantedPermissions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AwsCredsAuthenticationDetailsProperties.
func (a AwsCredsAuthenticationDetailsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accountId", a.AccountID)
	populate(objectMap, "authenticationProvisioningState", a.AuthenticationProvisioningState)
	objectMap["authenticationType"] = AuthenticationTypeAwsCreds
	populate(objectMap, "awsAccessKeyId", a.AwsAccessKeyID)
	populate(objectMap, "awsSecretAccessKey", a.AwsSecretAccessKey)
	populate(objectMap, "grantedPermissions", a.GrantedPermissions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AwsCredsAuthenticationDetailsProperties.
func (a *AwsCredsAuthenticationDetailsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountId":
			err = unpopulate(val, "AccountID", &a.AccountID)
			delete(rawMsg, key)
		case "authenticationProvisioningState":
			err = unpopulate(val, "AuthenticationProvisioningState", &a.AuthenticationProvisioningState)
			delete(rawMsg, key)
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &a.AuthenticationType)
			delete(rawMsg, key)
		case "awsAccessKeyId":
			err = unpopulate(val, "AwsAccessKeyID", &a.AwsAccessKeyID)
			delete(rawMsg, key)
		case "awsSecretAccessKey":
			err = unpopulate(val, "AwsSecretAccessKey", &a.AwsSecretAccessKey)
			delete(rawMsg, key)
		case "grantedPermissions":
			err = unpopulate(val, "GrantedPermissions", &a.GrantedPermissions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AwsEnvironmentData.
func (a AwsEnvironmentData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["environmentType"] = EnvironmentTypeAwsAccount
	populate(objectMap, "organizationalData", a.OrganizationalData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AwsEnvironmentData.
func (a *AwsEnvironmentData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "environmentType":
			err = unpopulate(val, "EnvironmentType", &a.EnvironmentType)
			delete(rawMsg, key)
		case "organizationalData":
			a.OrganizationalData, err = unmarshalAwsOrganizationalDataClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AwsOrganizationalData.
func (a AwsOrganizationalData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["organizationMembershipType"] = a.OrganizationMembershipType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AwsOrganizationalData.
func (a *AwsOrganizationalData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "organizationMembershipType":
			err = unpopulate(val, "OrganizationMembershipType", &a.OrganizationMembershipType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AwsOrganizationalDataMaster.
func (a AwsOrganizationalDataMaster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "excludedAccountIds", a.ExcludedAccountIDs)
	objectMap["organizationMembershipType"] = OrganizationMembershipTypeOrganization
	populate(objectMap, "stacksetName", a.StacksetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AwsOrganizationalDataMaster.
func (a *AwsOrganizationalDataMaster) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "excludedAccountIds":
			err = unpopulate(val, "ExcludedAccountIDs", &a.ExcludedAccountIDs)
			delete(rawMsg, key)
		case "organizationMembershipType":
			err = unpopulate(val, "OrganizationMembershipType", &a.OrganizationMembershipType)
			delete(rawMsg, key)
		case "stacksetName":
			err = unpopulate(val, "StacksetName", &a.StacksetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AwsOrganizationalDataMember.
func (a AwsOrganizationalDataMember) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["organizationMembershipType"] = OrganizationMembershipTypeMember
	populate(objectMap, "parentHierarchyId", a.ParentHierarchyID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AwsOrganizationalDataMember.
func (a *AwsOrganizationalDataMember) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "organizationMembershipType":
			err = unpopulate(val, "OrganizationMembershipType", &a.OrganizationMembershipType)
			delete(rawMsg, key)
		case "parentHierarchyId":
			err = unpopulate(val, "ParentHierarchyID", &a.ParentHierarchyID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDevOpsScopeEnvironmentData.
func (a AzureDevOpsScopeEnvironmentData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["environmentType"] = EnvironmentTypeAzureDevOpsScope
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDevOpsScopeEnvironmentData.
func (a *AzureDevOpsScopeEnvironmentData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "environmentType":
			err = unpopulate(val, "EnvironmentType", &a.EnvironmentType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureResourceDetails.
func (a AzureResourceDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	objectMap["source"] = SourceAzure
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureResourceDetails.
func (a *AzureResourceDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &a.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureResourceIdentifier.
func (a AzureResourceIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureResourceId", a.AzureResourceID)
	objectMap["type"] = ResourceIdentifierTypeAzureResource
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureResourceIdentifier.
func (a *AzureResourceIdentifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureResourceId":
			err = unpopulate(val, "AzureResourceID", &a.AzureResourceID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureResourceLink.
func (a AzureResourceLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureResourceLink.
func (a *AzureResourceLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureTrackedResourceLocation.
func (a AzureTrackedResourceLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", a.Location)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureTrackedResourceLocation.
func (a *AzureTrackedResourceLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Baseline.
func (b Baseline) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "expectedResults", b.ExpectedResults)
	populateTimeRFC3339(objectMap, "updatedTime", b.UpdatedTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Baseline.
func (b *Baseline) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expectedResults":
			err = unpopulate(val, "ExpectedResults", &b.ExpectedResults)
			delete(rawMsg, key)
		case "updatedTime":
			err = unpopulateTimeRFC3339(val, "UpdatedTime", &b.UpdatedTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BaselineAdjustedResult.
func (b BaselineAdjustedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "baseline", b.Baseline)
	populate(objectMap, "resultsNotInBaseline", b.ResultsNotInBaseline)
	populate(objectMap, "resultsOnlyInBaseline", b.ResultsOnlyInBaseline)
	populate(objectMap, "status", b.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BaselineAdjustedResult.
func (b *BaselineAdjustedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "baseline":
			err = unpopulate(val, "Baseline", &b.Baseline)
			delete(rawMsg, key)
		case "resultsNotInBaseline":
			err = unpopulate(val, "ResultsNotInBaseline", &b.ResultsNotInBaseline)
			delete(rawMsg, key)
		case "resultsOnlyInBaseline":
			err = unpopulate(val, "ResultsOnlyInBaseline", &b.ResultsOnlyInBaseline)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &b.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BenchmarkReference.
func (b BenchmarkReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "benchmark", b.Benchmark)
	populate(objectMap, "reference", b.Reference)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BenchmarkReference.
func (b *BenchmarkReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "benchmark":
			err = unpopulate(val, "Benchmark", &b.Benchmark)
			delete(rawMsg, key)
		case "reference":
			err = unpopulate(val, "Reference", &b.Reference)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CVE.
func (c CVE) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "link", c.Link)
	populate(objectMap, "title", c.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CVE.
func (c *CVE) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "link":
			err = unpopulate(val, "Link", &c.Link)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &c.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CVSS.
func (c CVSS) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "base", c.Base)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CVSS.
func (c *CVSS) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "base":
			err = unpopulate(val, "Base", &c.Base)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CefExternalSecuritySolution.
func (c CefExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CefExternalSecuritySolution.
func (c *CefExternalSecuritySolution) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CefSolutionProperties.
func (c CefSolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agent", c.Agent)
	populate(objectMap, "deviceType", c.DeviceType)
	populate(objectMap, "deviceVendor", c.DeviceVendor)
	populate(objectMap, "hostname", c.Hostname)
	populate(objectMap, "lastEventReceived", c.LastEventReceived)
	populate(objectMap, "workspace", c.Workspace)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CefSolutionProperties.
func (c *CefSolutionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agent":
			err = unpopulate(val, "Agent", &c.Agent)
			delete(rawMsg, key)
		case "deviceType":
			err = unpopulate(val, "DeviceType", &c.DeviceType)
			delete(rawMsg, key)
		case "deviceVendor":
			err = unpopulate(val, "DeviceVendor", &c.DeviceVendor)
			delete(rawMsg, key)
		case "hostname":
			err = unpopulate(val, "Hostname", &c.Hostname)
			delete(rawMsg, key)
		case "lastEventReceived":
			err = unpopulate(val, "LastEventReceived", &c.LastEventReceived)
			delete(rawMsg, key)
		case "workspace":
			err = unpopulate(val, "Workspace", &c.Workspace)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudOffering.
func (c CloudOffering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", c.Description)
	objectMap["offeringType"] = c.OfferingType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudOffering.
func (c *CloudOffering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "offeringType":
			err = unpopulate(val, "OfferingType", &c.OfferingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Compliance.
func (c Compliance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Compliance.
func (c *Compliance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComplianceList.
func (c ComplianceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComplianceList.
func (c *ComplianceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComplianceProperties.
func (c ComplianceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assessmentResult", c.AssessmentResult)
	populateTimeRFC3339(objectMap, "assessmentTimestampUtcDate", c.AssessmentTimestampUTCDate)
	populate(objectMap, "resourceCount", c.ResourceCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComplianceProperties.
func (c *ComplianceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentResult":
			err = unpopulate(val, "AssessmentResult", &c.AssessmentResult)
			delete(rawMsg, key)
		case "assessmentTimestampUtcDate":
			err = unpopulateTimeRFC3339(val, "AssessmentTimestampUTCDate", &c.AssessmentTimestampUTCDate)
			delete(rawMsg, key)
		case "resourceCount":
			err = unpopulate(val, "ResourceCount", &c.ResourceCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComplianceResult.
func (c ComplianceResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComplianceResult.
func (c *ComplianceResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComplianceResultList.
func (c ComplianceResultList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComplianceResultList.
func (c *ComplianceResultList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComplianceResultProperties.
func (c ComplianceResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "resourceStatus", c.ResourceStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComplianceResultProperties.
func (c *ComplianceResultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceStatus":
			err = unpopulate(val, "ResourceStatus", &c.ResourceStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComplianceSegment.
func (c ComplianceSegment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "percentage", c.Percentage)
	populate(objectMap, "segmentType", c.SegmentType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComplianceSegment.
func (c *ComplianceSegment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "percentage":
			err = unpopulate(val, "Percentage", &c.Percentage)
			delete(rawMsg, key)
		case "segmentType":
			err = unpopulate(val, "SegmentType", &c.SegmentType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Condition.
func (c Condition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "operator", c.Operator)
	populate(objectMap, "property", c.Property)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Condition.
func (c *Condition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operator":
			err = unpopulate(val, "Operator", &c.Operator)
			delete(rawMsg, key)
		case "property":
			err = unpopulate(val, "Property", &c.Property)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectableResource.
func (c ConnectableResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "inboundConnectedResources", c.InboundConnectedResources)
	populate(objectMap, "outboundConnectedResources", c.OutboundConnectedResources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectableResource.
func (c *ConnectableResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "inboundConnectedResources":
			err = unpopulate(val, "InboundConnectedResources", &c.InboundConnectedResources)
			delete(rawMsg, key)
		case "outboundConnectedResources":
			err = unpopulate(val, "OutboundConnectedResources", &c.OutboundConnectedResources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectedResource.
func (c ConnectedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "connectedResourceId", c.ConnectedResourceID)
	populate(objectMap, "tcpPorts", c.TCPPorts)
	populate(objectMap, "udpPorts", c.UDPPorts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectedResource.
func (c *ConnectedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectedResourceId":
			err = unpopulate(val, "ConnectedResourceID", &c.ConnectedResourceID)
			delete(rawMsg, key)
		case "tcpPorts":
			err = unpopulate(val, "TCPPorts", &c.TCPPorts)
			delete(rawMsg, key)
		case "udpPorts":
			err = unpopulate(val, "UDPPorts", &c.UDPPorts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectedWorkspace.
func (c ConnectedWorkspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectedWorkspace.
func (c *ConnectedWorkspace) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionFromIPNotAllowed.
func (c ConnectionFromIPNotAllowed) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowlistValues", c.AllowlistValues)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "displayName", c.DisplayName)
	populate(objectMap, "isEnabled", c.IsEnabled)
	objectMap["ruleType"] = "ConnectionFromIpNotAllowed"
	populate(objectMap, "valueType", c.ValueType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionFromIPNotAllowed.
func (c *ConnectionFromIPNotAllowed) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowlistValues":
			err = unpopulate(val, "AllowlistValues", &c.AllowlistValues)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &c.IsEnabled)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &c.RuleType)
			delete(rawMsg, key)
		case "valueType":
			err = unpopulate(val, "ValueType", &c.ValueType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionStrings.
func (c ConnectionStrings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionStrings.
func (c *ConnectionStrings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionToIPNotAllowed.
func (c ConnectionToIPNotAllowed) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowlistValues", c.AllowlistValues)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "displayName", c.DisplayName)
	populate(objectMap, "isEnabled", c.IsEnabled)
	objectMap["ruleType"] = "ConnectionToIpNotAllowed"
	populate(objectMap, "valueType", c.ValueType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionToIPNotAllowed.
func (c *ConnectionToIPNotAllowed) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowlistValues":
			err = unpopulate(val, "AllowlistValues", &c.AllowlistValues)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &c.IsEnabled)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &c.RuleType)
			delete(rawMsg, key)
		case "valueType":
			err = unpopulate(val, "ValueType", &c.ValueType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Connector.
func (c Connector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Connector.
func (c *Connector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectorProperties.
func (c ConnectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "environmentData", c.EnvironmentData)
	populate(objectMap, "environmentName", c.EnvironmentName)
	populate(objectMap, "hierarchyIdentifier", c.HierarchyIdentifier)
	populateTimeRFC3339(objectMap, "hierarchyIdentifierTrialEndDate", c.HierarchyIdentifierTrialEndDate)
	populate(objectMap, "offerings", c.Offerings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectorProperties.
func (c *ConnectorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "environmentData":
			c.EnvironmentData, err = unmarshalEnvironmentDataClassification(val)
			delete(rawMsg, key)
		case "environmentName":
			err = unpopulate(val, "EnvironmentName", &c.EnvironmentName)
			delete(rawMsg, key)
		case "hierarchyIdentifier":
			err = unpopulate(val, "HierarchyIdentifier", &c.HierarchyIdentifier)
			delete(rawMsg, key)
		case "hierarchyIdentifierTrialEndDate":
			err = unpopulateTimeRFC3339(val, "HierarchyIdentifierTrialEndDate", &c.HierarchyIdentifierTrialEndDate)
			delete(rawMsg, key)
		case "offerings":
			c.Offerings, err = unmarshalCloudOfferingClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectorSetting.
func (c ConnectorSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectorSetting.
func (c *ConnectorSetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectorSettingList.
func (c ConnectorSettingList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectorSettingList.
func (c *ConnectorSettingList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectorSettingProperties.
func (c ConnectorSettingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authenticationDetails", c.AuthenticationDetails)
	populate(objectMap, "hybridComputeSettings", c.HybridComputeSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectorSettingProperties.
func (c *ConnectorSettingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationDetails":
			c.AuthenticationDetails, err = unmarshalAuthenticationDetailsPropertiesClassification(val)
			delete(rawMsg, key)
		case "hybridComputeSettings":
			err = unpopulate(val, "HybridComputeSettings", &c.HybridComputeSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectorsList.
func (c ConnectorsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectorsList.
func (c *ConnectorsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Contact.
func (c Contact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Contact.
func (c *Contact) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactList.
func (c ContactList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactList.
func (c *ContactList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactProperties.
func (c ContactProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alertNotifications", c.AlertNotifications)
	populate(objectMap, "emails", c.Emails)
	populate(objectMap, "notificationsByRole", c.NotificationsByRole)
	populate(objectMap, "phone", c.Phone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactProperties.
func (c *ContactProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertNotifications":
			err = unpopulate(val, "AlertNotifications", &c.AlertNotifications)
			delete(rawMsg, key)
		case "emails":
			err = unpopulate(val, "Emails", &c.Emails)
			delete(rawMsg, key)
		case "notificationsByRole":
			err = unpopulate(val, "NotificationsByRole", &c.NotificationsByRole)
			delete(rawMsg, key)
		case "phone":
			err = unpopulate(val, "Phone", &c.Phone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactPropertiesAlertNotifications.
func (c ContactPropertiesAlertNotifications) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "minimalSeverity", c.MinimalSeverity)
	populate(objectMap, "state", c.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactPropertiesAlertNotifications.
func (c *ContactPropertiesAlertNotifications) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "minimalSeverity":
			err = unpopulate(val, "MinimalSeverity", &c.MinimalSeverity)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactPropertiesNotificationsByRole.
func (c ContactPropertiesNotificationsByRole) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "roles", c.Roles)
	populate(objectMap, "state", c.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactPropertiesNotificationsByRole.
func (c *ContactPropertiesNotificationsByRole) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "roles":
			err = unpopulate(val, "Roles", &c.Roles)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerRegistryVulnerabilityProperties.
func (c ContainerRegistryVulnerabilityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["assessedResourceType"] = AssessedResourceTypeContainerRegistryVulnerability
	populate(objectMap, "cve", c.Cve)
	populate(objectMap, "cvss", c.Cvss)
	populate(objectMap, "imageDigest", c.ImageDigest)
	populate(objectMap, "patchable", c.Patchable)
	populateTimeRFC3339(objectMap, "publishedTime", c.PublishedTime)
	populate(objectMap, "repositoryName", c.RepositoryName)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "vendorReferences", c.VendorReferences)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerRegistryVulnerabilityProperties.
func (c *ContainerRegistryVulnerabilityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessedResourceType":
			err = unpopulate(val, "AssessedResourceType", &c.AssessedResourceType)
			delete(rawMsg, key)
		case "cve":
			err = unpopulate(val, "Cve", &c.Cve)
			delete(rawMsg, key)
		case "cvss":
			err = unpopulate(val, "Cvss", &c.Cvss)
			delete(rawMsg, key)
		case "imageDigest":
			err = unpopulate(val, "ImageDigest", &c.ImageDigest)
			delete(rawMsg, key)
		case "patchable":
			err = unpopulate(val, "Patchable", &c.Patchable)
			delete(rawMsg, key)
		case "publishedTime":
			err = unpopulateTimeRFC3339(val, "PublishedTime", &c.PublishedTime)
			delete(rawMsg, key)
		case "repositoryName":
			err = unpopulate(val, "RepositoryName", &c.RepositoryName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "vendorReferences":
			err = unpopulate(val, "VendorReferences", &c.VendorReferences)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CspmMonitorAwsOffering.
func (c CspmMonitorAwsOffering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", c.Description)
	populate(objectMap, "nativeCloudConnection", c.NativeCloudConnection)
	objectMap["offeringType"] = OfferingTypeCspmMonitorAws
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CspmMonitorAwsOffering.
func (c *CspmMonitorAwsOffering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "nativeCloudConnection":
			err = unpopulate(val, "NativeCloudConnection", &c.NativeCloudConnection)
			delete(rawMsg, key)
		case "offeringType":
			err = unpopulate(val, "OfferingType", &c.OfferingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CspmMonitorAwsOfferingNativeCloudConnection.
func (c CspmMonitorAwsOfferingNativeCloudConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cloudRoleArn", c.CloudRoleArn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CspmMonitorAwsOfferingNativeCloudConnection.
func (c *CspmMonitorAwsOfferingNativeCloudConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudRoleArn":
			err = unpopulate(val, "CloudRoleArn", &c.CloudRoleArn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CspmMonitorAzureDevOpsOffering.
func (c CspmMonitorAzureDevOpsOffering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", c.Description)
	objectMap["offeringType"] = OfferingTypeCspmMonitorAzureDevOps
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CspmMonitorAzureDevOpsOffering.
func (c *CspmMonitorAzureDevOpsOffering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "offeringType":
			err = unpopulate(val, "OfferingType", &c.OfferingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CspmMonitorGcpOffering.
func (c CspmMonitorGcpOffering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", c.Description)
	populate(objectMap, "nativeCloudConnection", c.NativeCloudConnection)
	objectMap["offeringType"] = OfferingTypeCspmMonitorGcp
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CspmMonitorGcpOffering.
func (c *CspmMonitorGcpOffering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "nativeCloudConnection":
			err = unpopulate(val, "NativeCloudConnection", &c.NativeCloudConnection)
			delete(rawMsg, key)
		case "offeringType":
			err = unpopulate(val, "OfferingType", &c.OfferingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CspmMonitorGcpOfferingNativeCloudConnection.
func (c CspmMonitorGcpOfferingNativeCloudConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "serviceAccountEmailAddress", c.ServiceAccountEmailAddress)
	populate(objectMap, "workloadIdentityProviderId", c.WorkloadIdentityProviderID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CspmMonitorGcpOfferingNativeCloudConnection.
func (c *CspmMonitorGcpOfferingNativeCloudConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceAccountEmailAddress":
			err = unpopulate(val, "ServiceAccountEmailAddress", &c.ServiceAccountEmailAddress)
			delete(rawMsg, key)
		case "workloadIdentityProviderId":
			err = unpopulate(val, "WorkloadIdentityProviderID", &c.WorkloadIdentityProviderID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CspmMonitorGithubOffering.
func (c CspmMonitorGithubOffering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", c.Description)
	objectMap["offeringType"] = OfferingTypeCspmMonitorGithub
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CspmMonitorGithubOffering.
func (c *CspmMonitorGithubOffering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "offeringType":
			err = unpopulate(val, "OfferingType", &c.OfferingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomAlertRule.
func (c CustomAlertRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", c.Description)
	populate(objectMap, "displayName", c.DisplayName)
	populate(objectMap, "isEnabled", c.IsEnabled)
	objectMap["ruleType"] = c.RuleType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomAlertRule.
func (c *CustomAlertRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &c.IsEnabled)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &c.RuleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomAssessmentAutomation.
func (c CustomAssessmentAutomation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomAssessmentAutomation.
func (c *CustomAssessmentAutomation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomAssessmentAutomationProperties.
func (c CustomAssessmentAutomationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assessmentKey", c.AssessmentKey)
	populate(objectMap, "compressedQuery", c.CompressedQuery)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "displayName", c.DisplayName)
	populate(objectMap, "remediationDescription", c.RemediationDescription)
	if c.Severity == nil {
		c.Severity = to.Ptr(SeverityEnumLow)
	}
	populate(objectMap, "severity", c.Severity)
	if c.SupportedCloud == nil {
		c.SupportedCloud = to.Ptr(SupportedCloudEnumAWS)
	}
	populate(objectMap, "supportedCloud", c.SupportedCloud)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomAssessmentAutomationProperties.
func (c *CustomAssessmentAutomationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentKey":
			err = unpopulate(val, "AssessmentKey", &c.AssessmentKey)
			delete(rawMsg, key)
		case "compressedQuery":
			err = unpopulate(val, "CompressedQuery", &c.CompressedQuery)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "remediationDescription":
			err = unpopulate(val, "RemediationDescription", &c.RemediationDescription)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &c.Severity)
			delete(rawMsg, key)
		case "supportedCloud":
			err = unpopulate(val, "SupportedCloud", &c.SupportedCloud)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomAssessmentAutomationRequest.
func (c CustomAssessmentAutomationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomAssessmentAutomationRequest.
func (c *CustomAssessmentAutomationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomAssessmentAutomationRequestProperties.
func (c CustomAssessmentAutomationRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "compressedQuery", c.CompressedQuery)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "displayName", c.DisplayName)
	populate(objectMap, "remediationDescription", c.RemediationDescription)
	if c.Severity == nil {
		c.Severity = to.Ptr(SeverityEnumLow)
	}
	populate(objectMap, "severity", c.Severity)
	if c.SupportedCloud == nil {
		c.SupportedCloud = to.Ptr(SupportedCloudEnumAWS)
	}
	populate(objectMap, "supportedCloud", c.SupportedCloud)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomAssessmentAutomationRequestProperties.
func (c *CustomAssessmentAutomationRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compressedQuery":
			err = unpopulate(val, "CompressedQuery", &c.CompressedQuery)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "remediationDescription":
			err = unpopulate(val, "RemediationDescription", &c.RemediationDescription)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &c.Severity)
			delete(rawMsg, key)
		case "supportedCloud":
			err = unpopulate(val, "SupportedCloud", &c.SupportedCloud)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomAssessmentAutomationsListResult.
func (c CustomAssessmentAutomationsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomAssessmentAutomationsListResult.
func (c *CustomAssessmentAutomationsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomEntityStoreAssignment.
func (c CustomEntityStoreAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomEntityStoreAssignment.
func (c *CustomEntityStoreAssignment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomEntityStoreAssignmentProperties.
func (c CustomEntityStoreAssignmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "entityStoreDatabaseLink", c.EntityStoreDatabaseLink)
	populate(objectMap, "principal", c.Principal)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomEntityStoreAssignmentProperties.
func (c *CustomEntityStoreAssignmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "entityStoreDatabaseLink":
			err = unpopulate(val, "EntityStoreDatabaseLink", &c.EntityStoreDatabaseLink)
			delete(rawMsg, key)
		case "principal":
			err = unpopulate(val, "Principal", &c.Principal)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomEntityStoreAssignmentRequest.
func (c CustomEntityStoreAssignmentRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomEntityStoreAssignmentRequest.
func (c *CustomEntityStoreAssignmentRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomEntityStoreAssignmentRequestProperties.
func (c CustomEntityStoreAssignmentRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principal", c.Principal)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomEntityStoreAssignmentRequestProperties.
func (c *CustomEntityStoreAssignmentRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principal":
			err = unpopulate(val, "Principal", &c.Principal)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomEntityStoreAssignmentsListResult.
func (c CustomEntityStoreAssignmentsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomEntityStoreAssignmentsListResult.
func (c *CustomEntityStoreAssignmentsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataExportSettingProperties.
func (d DataExportSettingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enabled", d.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataExportSettingProperties.
func (d *DataExportSettingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataExportSettings.
func (d DataExportSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	objectMap["kind"] = SettingKindDataExportSettings
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataExportSettings.
func (d *DataExportSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderCspmAwsOffering.
func (d DefenderCspmAwsOffering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", d.Description)
	objectMap["offeringType"] = OfferingTypeDefenderCspmAws
	populate(objectMap, "vmScanners", d.VMScanners)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderCspmAwsOffering.
func (d *DefenderCspmAwsOffering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "offeringType":
			err = unpopulate(val, "OfferingType", &d.OfferingType)
			delete(rawMsg, key)
		case "vmScanners":
			err = unpopulate(val, "VMScanners", &d.VMScanners)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderCspmAwsOfferingVMScanners.
func (d DefenderCspmAwsOfferingVMScanners) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configuration", d.Configuration)
	populate(objectMap, "enabled", d.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderCspmAwsOfferingVMScanners.
func (d *DefenderCspmAwsOfferingVMScanners) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &d.Configuration)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderCspmAwsOfferingVMScannersConfiguration.
func (d DefenderCspmAwsOfferingVMScannersConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cloudRoleArn", d.CloudRoleArn)
	populate(objectMap, "exclusionTags", d.ExclusionTags)
	populate(objectMap, "scanningMode", d.ScanningMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderCspmAwsOfferingVMScannersConfiguration.
func (d *DefenderCspmAwsOfferingVMScannersConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudRoleArn":
			err = unpopulate(val, "CloudRoleArn", &d.CloudRoleArn)
			delete(rawMsg, key)
		case "exclusionTags":
			err = unpopulate(val, "ExclusionTags", &d.ExclusionTags)
			delete(rawMsg, key)
		case "scanningMode":
			err = unpopulate(val, "ScanningMode", &d.ScanningMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderCspmGcpOffering.
func (d DefenderCspmGcpOffering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", d.Description)
	objectMap["offeringType"] = OfferingTypeDefenderCspmGcp
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderCspmGcpOffering.
func (d *DefenderCspmGcpOffering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "offeringType":
			err = unpopulate(val, "OfferingType", &d.OfferingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderFoDatabasesAwsOffering.
func (d DefenderFoDatabasesAwsOffering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "arcAutoProvisioning", d.ArcAutoProvisioning)
	populate(objectMap, "description", d.Description)
	objectMap["offeringType"] = OfferingTypeDefenderForDatabasesAws
	populate(objectMap, "rds", d.Rds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderFoDatabasesAwsOffering.
func (d *DefenderFoDatabasesAwsOffering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arcAutoProvisioning":
			err = unpopulate(val, "ArcAutoProvisioning", &d.ArcAutoProvisioning)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "offeringType":
			err = unpopulate(val, "OfferingType", &d.OfferingType)
			delete(rawMsg, key)
		case "rds":
			err = unpopulate(val, "Rds", &d.Rds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderFoDatabasesAwsOfferingArcAutoProvisioning.
func (d DefenderFoDatabasesAwsOfferingArcAutoProvisioning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cloudRoleArn", d.CloudRoleArn)
	populate(objectMap, "enabled", d.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderFoDatabasesAwsOfferingArcAutoProvisioning.
func (d *DefenderFoDatabasesAwsOfferingArcAutoProvisioning) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudRoleArn":
			err = unpopulate(val, "CloudRoleArn", &d.CloudRoleArn)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderFoDatabasesAwsOfferingRds.
func (d DefenderFoDatabasesAwsOfferingRds) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cloudRoleArn", d.CloudRoleArn)
	populate(objectMap, "enabled", d.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderFoDatabasesAwsOfferingRds.
func (d *DefenderFoDatabasesAwsOfferingRds) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudRoleArn":
			err = unpopulate(val, "CloudRoleArn", &d.CloudRoleArn)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForContainersAwsOffering.
func (d DefenderForContainersAwsOffering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoProvisioning", d.AutoProvisioning)
	populate(objectMap, "cloudWatchToKinesis", d.CloudWatchToKinesis)
	populate(objectMap, "containerVulnerabilityAssessment", d.ContainerVulnerabilityAssessment)
	populate(objectMap, "containerVulnerabilityAssessmentTask", d.ContainerVulnerabilityAssessmentTask)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "enableContainerVulnerabilityAssessment", d.EnableContainerVulnerabilityAssessment)
	populate(objectMap, "kinesisToS3", d.KinesisToS3)
	populate(objectMap, "kubeAuditRetentionTime", d.KubeAuditRetentionTime)
	populate(objectMap, "kubernetesScubaReader", d.KubernetesScubaReader)
	populate(objectMap, "kubernetesService", d.KubernetesService)
	objectMap["offeringType"] = OfferingTypeDefenderForContainersAws
	populate(objectMap, "scubaExternalId", d.ScubaExternalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForContainersAwsOffering.
func (d *DefenderForContainersAwsOffering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoProvisioning":
			err = unpopulate(val, "AutoProvisioning", &d.AutoProvisioning)
			delete(rawMsg, key)
		case "cloudWatchToKinesis":
			err = unpopulate(val, "CloudWatchToKinesis", &d.CloudWatchToKinesis)
			delete(rawMsg, key)
		case "containerVulnerabilityAssessment":
			err = unpopulate(val, "ContainerVulnerabilityAssessment", &d.ContainerVulnerabilityAssessment)
			delete(rawMsg, key)
		case "containerVulnerabilityAssessmentTask":
			err = unpopulate(val, "ContainerVulnerabilityAssessmentTask", &d.ContainerVulnerabilityAssessmentTask)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "enableContainerVulnerabilityAssessment":
			err = unpopulate(val, "EnableContainerVulnerabilityAssessment", &d.EnableContainerVulnerabilityAssessment)
			delete(rawMsg, key)
		case "kinesisToS3":
			err = unpopulate(val, "KinesisToS3", &d.KinesisToS3)
			delete(rawMsg, key)
		case "kubeAuditRetentionTime":
			err = unpopulate(val, "KubeAuditRetentionTime", &d.KubeAuditRetentionTime)
			delete(rawMsg, key)
		case "kubernetesScubaReader":
			err = unpopulate(val, "KubernetesScubaReader", &d.KubernetesScubaReader)
			delete(rawMsg, key)
		case "kubernetesService":
			err = unpopulate(val, "KubernetesService", &d.KubernetesService)
			delete(rawMsg, key)
		case "offeringType":
			err = unpopulate(val, "OfferingType", &d.OfferingType)
			delete(rawMsg, key)
		case "scubaExternalId":
			err = unpopulate(val, "ScubaExternalID", &d.ScubaExternalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForContainersAwsOfferingCloudWatchToKinesis.
func (d DefenderForContainersAwsOfferingCloudWatchToKinesis) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cloudRoleArn", d.CloudRoleArn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForContainersAwsOfferingCloudWatchToKinesis.
func (d *DefenderForContainersAwsOfferingCloudWatchToKinesis) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudRoleArn":
			err = unpopulate(val, "CloudRoleArn", &d.CloudRoleArn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForContainersAwsOfferingContainerVulnerabilityAssessment.
func (d DefenderForContainersAwsOfferingContainerVulnerabilityAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cloudRoleArn", d.CloudRoleArn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForContainersAwsOfferingContainerVulnerabilityAssessment.
func (d *DefenderForContainersAwsOfferingContainerVulnerabilityAssessment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudRoleArn":
			err = unpopulate(val, "CloudRoleArn", &d.CloudRoleArn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask.
func (d DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cloudRoleArn", d.CloudRoleArn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask.
func (d *DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudRoleArn":
			err = unpopulate(val, "CloudRoleArn", &d.CloudRoleArn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForContainersAwsOfferingKinesisToS3.
func (d DefenderForContainersAwsOfferingKinesisToS3) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cloudRoleArn", d.CloudRoleArn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForContainersAwsOfferingKinesisToS3.
func (d *DefenderForContainersAwsOfferingKinesisToS3) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudRoleArn":
			err = unpopulate(val, "CloudRoleArn", &d.CloudRoleArn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForContainersAwsOfferingKubernetesScubaReader.
func (d DefenderForContainersAwsOfferingKubernetesScubaReader) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cloudRoleArn", d.CloudRoleArn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForContainersAwsOfferingKubernetesScubaReader.
func (d *DefenderForContainersAwsOfferingKubernetesScubaReader) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudRoleArn":
			err = unpopulate(val, "CloudRoleArn", &d.CloudRoleArn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForContainersAwsOfferingKubernetesService.
func (d DefenderForContainersAwsOfferingKubernetesService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cloudRoleArn", d.CloudRoleArn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForContainersAwsOfferingKubernetesService.
func (d *DefenderForContainersAwsOfferingKubernetesService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudRoleArn":
			err = unpopulate(val, "CloudRoleArn", &d.CloudRoleArn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForContainersGcpOffering.
func (d DefenderForContainersGcpOffering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "auditLogsAutoProvisioningFlag", d.AuditLogsAutoProvisioningFlag)
	populate(objectMap, "dataPipelineNativeCloudConnection", d.DataPipelineNativeCloudConnection)
	populate(objectMap, "defenderAgentAutoProvisioningFlag", d.DefenderAgentAutoProvisioningFlag)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "nativeCloudConnection", d.NativeCloudConnection)
	objectMap["offeringType"] = OfferingTypeDefenderForContainersGcp
	populate(objectMap, "policyAgentAutoProvisioningFlag", d.PolicyAgentAutoProvisioningFlag)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForContainersGcpOffering.
func (d *DefenderForContainersGcpOffering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auditLogsAutoProvisioningFlag":
			err = unpopulate(val, "AuditLogsAutoProvisioningFlag", &d.AuditLogsAutoProvisioningFlag)
			delete(rawMsg, key)
		case "dataPipelineNativeCloudConnection":
			err = unpopulate(val, "DataPipelineNativeCloudConnection", &d.DataPipelineNativeCloudConnection)
			delete(rawMsg, key)
		case "defenderAgentAutoProvisioningFlag":
			err = unpopulate(val, "DefenderAgentAutoProvisioningFlag", &d.DefenderAgentAutoProvisioningFlag)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "nativeCloudConnection":
			err = unpopulate(val, "NativeCloudConnection", &d.NativeCloudConnection)
			delete(rawMsg, key)
		case "offeringType":
			err = unpopulate(val, "OfferingType", &d.OfferingType)
			delete(rawMsg, key)
		case "policyAgentAutoProvisioningFlag":
			err = unpopulate(val, "PolicyAgentAutoProvisioningFlag", &d.PolicyAgentAutoProvisioningFlag)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection.
func (d DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "serviceAccountEmailAddress", d.ServiceAccountEmailAddress)
	populate(objectMap, "workloadIdentityProviderId", d.WorkloadIdentityProviderID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection.
func (d *DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceAccountEmailAddress":
			err = unpopulate(val, "ServiceAccountEmailAddress", &d.ServiceAccountEmailAddress)
			delete(rawMsg, key)
		case "workloadIdentityProviderId":
			err = unpopulate(val, "WorkloadIdentityProviderID", &d.WorkloadIdentityProviderID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForContainersGcpOfferingNativeCloudConnection.
func (d DefenderForContainersGcpOfferingNativeCloudConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "serviceAccountEmailAddress", d.ServiceAccountEmailAddress)
	populate(objectMap, "workloadIdentityProviderId", d.WorkloadIdentityProviderID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForContainersGcpOfferingNativeCloudConnection.
func (d *DefenderForContainersGcpOfferingNativeCloudConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceAccountEmailAddress":
			err = unpopulate(val, "ServiceAccountEmailAddress", &d.ServiceAccountEmailAddress)
			delete(rawMsg, key)
		case "workloadIdentityProviderId":
			err = unpopulate(val, "WorkloadIdentityProviderID", &d.WorkloadIdentityProviderID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForDatabasesGcpOffering.
func (d DefenderForDatabasesGcpOffering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "arcAutoProvisioning", d.ArcAutoProvisioning)
	populate(objectMap, "defenderForDatabasesArcAutoProvisioning", d.DefenderForDatabasesArcAutoProvisioning)
	populate(objectMap, "description", d.Description)
	objectMap["offeringType"] = OfferingTypeDefenderForDatabasesGcp
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForDatabasesGcpOffering.
func (d *DefenderForDatabasesGcpOffering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arcAutoProvisioning":
			err = unpopulate(val, "ArcAutoProvisioning", &d.ArcAutoProvisioning)
			delete(rawMsg, key)
		case "defenderForDatabasesArcAutoProvisioning":
			err = unpopulate(val, "DefenderForDatabasesArcAutoProvisioning", &d.DefenderForDatabasesArcAutoProvisioning)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "offeringType":
			err = unpopulate(val, "OfferingType", &d.OfferingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForDatabasesGcpOfferingArcAutoProvisioning.
func (d DefenderForDatabasesGcpOfferingArcAutoProvisioning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enabled", d.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForDatabasesGcpOfferingArcAutoProvisioning.
func (d *DefenderForDatabasesGcpOfferingArcAutoProvisioning) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning.
func (d DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "serviceAccountEmailAddress", d.ServiceAccountEmailAddress)
	populate(objectMap, "workloadIdentityProviderId", d.WorkloadIdentityProviderID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning.
func (d *DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceAccountEmailAddress":
			err = unpopulate(val, "ServiceAccountEmailAddress", &d.ServiceAccountEmailAddress)
			delete(rawMsg, key)
		case "workloadIdentityProviderId":
			err = unpopulate(val, "WorkloadIdentityProviderID", &d.WorkloadIdentityProviderID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForDevOpsAzureDevOpsOffering.
func (d DefenderForDevOpsAzureDevOpsOffering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", d.Description)
	objectMap["offeringType"] = OfferingTypeDefenderForDevOpsAzureDevOps
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForDevOpsAzureDevOpsOffering.
func (d *DefenderForDevOpsAzureDevOpsOffering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "offeringType":
			err = unpopulate(val, "OfferingType", &d.OfferingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForDevOpsGithubOffering.
func (d DefenderForDevOpsGithubOffering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", d.Description)
	objectMap["offeringType"] = OfferingTypeDefenderForDevOpsGithub
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForDevOpsGithubOffering.
func (d *DefenderForDevOpsGithubOffering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "offeringType":
			err = unpopulate(val, "OfferingType", &d.OfferingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForServersAwsOffering.
func (d DefenderForServersAwsOffering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "arcAutoProvisioning", d.ArcAutoProvisioning)
	populate(objectMap, "defenderForServers", d.DefenderForServers)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "mdeAutoProvisioning", d.MdeAutoProvisioning)
	objectMap["offeringType"] = OfferingTypeDefenderForServersAws
	populate(objectMap, "subPlan", d.SubPlan)
	populate(objectMap, "vmScanners", d.VMScanners)
	populate(objectMap, "vaAutoProvisioning", d.VaAutoProvisioning)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForServersAwsOffering.
func (d *DefenderForServersAwsOffering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arcAutoProvisioning":
			err = unpopulate(val, "ArcAutoProvisioning", &d.ArcAutoProvisioning)
			delete(rawMsg, key)
		case "defenderForServers":
			err = unpopulate(val, "DefenderForServers", &d.DefenderForServers)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "mdeAutoProvisioning":
			err = unpopulate(val, "MdeAutoProvisioning", &d.MdeAutoProvisioning)
			delete(rawMsg, key)
		case "offeringType":
			err = unpopulate(val, "OfferingType", &d.OfferingType)
			delete(rawMsg, key)
		case "subPlan":
			err = unpopulate(val, "SubPlan", &d.SubPlan)
			delete(rawMsg, key)
		case "vmScanners":
			err = unpopulate(val, "VMScanners", &d.VMScanners)
			delete(rawMsg, key)
		case "vaAutoProvisioning":
			err = unpopulate(val, "VaAutoProvisioning", &d.VaAutoProvisioning)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForServersAwsOfferingArcAutoProvisioning.
func (d DefenderForServersAwsOfferingArcAutoProvisioning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cloudRoleArn", d.CloudRoleArn)
	populate(objectMap, "enabled", d.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForServersAwsOfferingArcAutoProvisioning.
func (d *DefenderForServersAwsOfferingArcAutoProvisioning) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudRoleArn":
			err = unpopulate(val, "CloudRoleArn", &d.CloudRoleArn)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForServersAwsOfferingDefenderForServers.
func (d DefenderForServersAwsOfferingDefenderForServers) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cloudRoleArn", d.CloudRoleArn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForServersAwsOfferingDefenderForServers.
func (d *DefenderForServersAwsOfferingDefenderForServers) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudRoleArn":
			err = unpopulate(val, "CloudRoleArn", &d.CloudRoleArn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForServersAwsOfferingMdeAutoProvisioning.
func (d DefenderForServersAwsOfferingMdeAutoProvisioning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configuration", &d.Configuration)
	populate(objectMap, "enabled", d.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForServersAwsOfferingMdeAutoProvisioning.
func (d *DefenderForServersAwsOfferingMdeAutoProvisioning) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &d.Configuration)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForServersAwsOfferingSubPlan.
func (d DefenderForServersAwsOfferingSubPlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForServersAwsOfferingSubPlan.
func (d *DefenderForServersAwsOfferingSubPlan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForServersAwsOfferingVMScanners.
func (d DefenderForServersAwsOfferingVMScanners) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configuration", d.Configuration)
	populate(objectMap, "enabled", d.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForServersAwsOfferingVMScanners.
func (d *DefenderForServersAwsOfferingVMScanners) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &d.Configuration)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForServersAwsOfferingVMScannersConfiguration.
func (d DefenderForServersAwsOfferingVMScannersConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cloudRoleArn", d.CloudRoleArn)
	populate(objectMap, "exclusionTags", d.ExclusionTags)
	populate(objectMap, "scanningMode", d.ScanningMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForServersAwsOfferingVMScannersConfiguration.
func (d *DefenderForServersAwsOfferingVMScannersConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudRoleArn":
			err = unpopulate(val, "CloudRoleArn", &d.CloudRoleArn)
			delete(rawMsg, key)
		case "exclusionTags":
			err = unpopulate(val, "ExclusionTags", &d.ExclusionTags)
			delete(rawMsg, key)
		case "scanningMode":
			err = unpopulate(val, "ScanningMode", &d.ScanningMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForServersAwsOfferingVaAutoProvisioning.
func (d DefenderForServersAwsOfferingVaAutoProvisioning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configuration", d.Configuration)
	populate(objectMap, "enabled", d.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForServersAwsOfferingVaAutoProvisioning.
func (d *DefenderForServersAwsOfferingVaAutoProvisioning) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &d.Configuration)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForServersAwsOfferingVaAutoProvisioningConfiguration.
func (d DefenderForServersAwsOfferingVaAutoProvisioningConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForServersAwsOfferingVaAutoProvisioningConfiguration.
func (d *DefenderForServersAwsOfferingVaAutoProvisioningConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForServersGcpOffering.
func (d DefenderForServersGcpOffering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "arcAutoProvisioning", d.ArcAutoProvisioning)
	populate(objectMap, "defenderForServers", d.DefenderForServers)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "mdeAutoProvisioning", d.MdeAutoProvisioning)
	objectMap["offeringType"] = OfferingTypeDefenderForServersGcp
	populate(objectMap, "subPlan", d.SubPlan)
	populate(objectMap, "vaAutoProvisioning", d.VaAutoProvisioning)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForServersGcpOffering.
func (d *DefenderForServersGcpOffering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arcAutoProvisioning":
			err = unpopulate(val, "ArcAutoProvisioning", &d.ArcAutoProvisioning)
			delete(rawMsg, key)
		case "defenderForServers":
			err = unpopulate(val, "DefenderForServers", &d.DefenderForServers)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "mdeAutoProvisioning":
			err = unpopulate(val, "MdeAutoProvisioning", &d.MdeAutoProvisioning)
			delete(rawMsg, key)
		case "offeringType":
			err = unpopulate(val, "OfferingType", &d.OfferingType)
			delete(rawMsg, key)
		case "subPlan":
			err = unpopulate(val, "SubPlan", &d.SubPlan)
			delete(rawMsg, key)
		case "vaAutoProvisioning":
			err = unpopulate(val, "VaAutoProvisioning", &d.VaAutoProvisioning)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForServersGcpOfferingArcAutoProvisioning.
func (d DefenderForServersGcpOfferingArcAutoProvisioning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enabled", d.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForServersGcpOfferingArcAutoProvisioning.
func (d *DefenderForServersGcpOfferingArcAutoProvisioning) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForServersGcpOfferingDefenderForServers.
func (d DefenderForServersGcpOfferingDefenderForServers) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "serviceAccountEmailAddress", d.ServiceAccountEmailAddress)
	populate(objectMap, "workloadIdentityProviderId", d.WorkloadIdentityProviderID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForServersGcpOfferingDefenderForServers.
func (d *DefenderForServersGcpOfferingDefenderForServers) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceAccountEmailAddress":
			err = unpopulate(val, "ServiceAccountEmailAddress", &d.ServiceAccountEmailAddress)
			delete(rawMsg, key)
		case "workloadIdentityProviderId":
			err = unpopulate(val, "WorkloadIdentityProviderID", &d.WorkloadIdentityProviderID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForServersGcpOfferingMdeAutoProvisioning.
func (d DefenderForServersGcpOfferingMdeAutoProvisioning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configuration", &d.Configuration)
	populate(objectMap, "enabled", d.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForServersGcpOfferingMdeAutoProvisioning.
func (d *DefenderForServersGcpOfferingMdeAutoProvisioning) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &d.Configuration)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForServersGcpOfferingSubPlan.
func (d DefenderForServersGcpOfferingSubPlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForServersGcpOfferingSubPlan.
func (d *DefenderForServersGcpOfferingSubPlan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForServersGcpOfferingVaAutoProvisioning.
func (d DefenderForServersGcpOfferingVaAutoProvisioning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configuration", d.Configuration)
	populate(objectMap, "enabled", d.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForServersGcpOfferingVaAutoProvisioning.
func (d *DefenderForServersGcpOfferingVaAutoProvisioning) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &d.Configuration)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefenderForServersGcpOfferingVaAutoProvisioningConfiguration.
func (d DefenderForServersGcpOfferingVaAutoProvisioningConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderForServersGcpOfferingVaAutoProvisioningConfiguration.
func (d *DefenderForServersGcpOfferingVaAutoProvisioningConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DenylistCustomAlertRule.
func (d DenylistCustomAlertRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "denylistValues", d.DenylistValues)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "displayName", d.DisplayName)
	populate(objectMap, "isEnabled", d.IsEnabled)
	objectMap["ruleType"] = "DenylistCustomAlertRule"
	populate(objectMap, "valueType", d.ValueType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DenylistCustomAlertRule.
func (d *DenylistCustomAlertRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "denylistValues":
			err = unpopulate(val, "DenylistValues", &d.DenylistValues)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &d.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &d.IsEnabled)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &d.RuleType)
			delete(rawMsg, key)
		case "valueType":
			err = unpopulate(val, "ValueType", &d.ValueType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceSecurityGroup.
func (d DeviceSecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceSecurityGroup.
func (d *DeviceSecurityGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceSecurityGroupList.
func (d DeviceSecurityGroupList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceSecurityGroupList.
func (d *DeviceSecurityGroupList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceSecurityGroupProperties.
func (d DeviceSecurityGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowlistRules", d.AllowlistRules)
	populate(objectMap, "denylistRules", d.DenylistRules)
	populate(objectMap, "thresholdRules", d.ThresholdRules)
	populate(objectMap, "timeWindowRules", d.TimeWindowRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceSecurityGroupProperties.
func (d *DeviceSecurityGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowlistRules":
			d.AllowlistRules, err = unmarshalAllowlistCustomAlertRuleClassificationArray(val)
			delete(rawMsg, key)
		case "denylistRules":
			err = unpopulate(val, "DenylistRules", &d.DenylistRules)
			delete(rawMsg, key)
		case "thresholdRules":
			d.ThresholdRules, err = unmarshalThresholdCustomAlertRuleClassificationArray(val)
			delete(rawMsg, key)
		case "timeWindowRules":
			d.TimeWindowRules, err = unmarshalTimeWindowCustomAlertRuleClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DirectMethodInvokesNotInAllowedRange.
func (d DirectMethodInvokesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", d.Description)
	populate(objectMap, "displayName", d.DisplayName)
	populate(objectMap, "isEnabled", d.IsEnabled)
	populate(objectMap, "maxThreshold", d.MaxThreshold)
	populate(objectMap, "minThreshold", d.MinThreshold)
	objectMap["ruleType"] = "DirectMethodInvokesNotInAllowedRange"
	populate(objectMap, "timeWindowSize", d.TimeWindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DirectMethodInvokesNotInAllowedRange.
func (d *DirectMethodInvokesNotInAllowedRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &d.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &d.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &d.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &d.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &d.RuleType)
			delete(rawMsg, key)
		case "timeWindowSize":
			err = unpopulate(val, "TimeWindowSize", &d.TimeWindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiscoveredSecuritySolution.
func (d DiscoveredSecuritySolution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiscoveredSecuritySolution.
func (d *DiscoveredSecuritySolution) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiscoveredSecuritySolutionList.
func (d DiscoveredSecuritySolutionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiscoveredSecuritySolutionList.
func (d *DiscoveredSecuritySolutionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiscoveredSecuritySolutionProperties.
func (d DiscoveredSecuritySolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "offer", d.Offer)
	populate(objectMap, "publisher", d.Publisher)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "securityFamily", d.SecurityFamily)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiscoveredSecuritySolutionProperties.
func (d *DiscoveredSecuritySolutionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "offer":
			err = unpopulate(val, "Offer", &d.Offer)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &d.Publisher)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &d.SKU)
			delete(rawMsg, key)
		case "securityFamily":
			err = unpopulate(val, "SecurityFamily", &d.SecurityFamily)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ETag.
func (e ETag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", e.Etag)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ETag.
func (e *ETag) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &e.Etag)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveNetworkSecurityGroups.
func (e EffectiveNetworkSecurityGroups) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "networkInterface", e.NetworkInterface)
	populate(objectMap, "networkSecurityGroups", e.NetworkSecurityGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveNetworkSecurityGroups.
func (e *EffectiveNetworkSecurityGroups) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkInterface":
			err = unpopulate(val, "NetworkInterface", &e.NetworkInterface)
			delete(rawMsg, key)
		case "networkSecurityGroups":
			err = unpopulate(val, "NetworkSecurityGroups", &e.NetworkSecurityGroups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentData.
func (e EnvironmentData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["environmentType"] = e.EnvironmentType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentData.
func (e *EnvironmentData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "environmentType":
			err = unpopulate(val, "EnvironmentType", &e.EnvironmentType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorAdditionalInfo.
func (e ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "info", &e.Info)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorAdditionalInfo.
func (e *ErrorAdditionalInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &e.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExecuteGovernanceRuleParams.
func (e ExecuteGovernanceRuleParams) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "override", e.Override)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExecuteGovernanceRuleParams.
func (e *ExecuteGovernanceRuleParams) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "override":
			err = unpopulate(val, "Override", &e.Override)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExecuteRuleStatus.
func (e ExecuteRuleStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "operationId", e.OperationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExecuteRuleStatus.
func (e *ExecuteRuleStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operationId":
			err = unpopulate(val, "OperationID", &e.OperationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExternalSecuritySolution.
func (e ExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", e.ID)
	populate(objectMap, "kind", e.Kind)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExternalSecuritySolution.
func (e *ExternalSecuritySolution) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExternalSecuritySolutionKindAutoGenerated.
func (e ExternalSecuritySolutionKindAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "kind", e.Kind)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExternalSecuritySolutionKindAutoGenerated.
func (e *ExternalSecuritySolutionKindAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExternalSecuritySolutionList.
func (e ExternalSecuritySolutionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExternalSecuritySolutionList.
func (e *ExternalSecuritySolutionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExternalSecuritySolutionProperties.
func (e ExternalSecuritySolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deviceType", e.DeviceType)
	populate(objectMap, "deviceVendor", e.DeviceVendor)
	populate(objectMap, "workspace", e.Workspace)
	if e.AdditionalProperties != nil {
		for key, val := range e.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExternalSecuritySolutionProperties.
func (e *ExternalSecuritySolutionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceType":
			err = unpopulate(val, "DeviceType", &e.DeviceType)
			delete(rawMsg, key)
		case "deviceVendor":
			err = unpopulate(val, "DeviceVendor", &e.DeviceVendor)
			delete(rawMsg, key)
		case "workspace":
			err = unpopulate(val, "Workspace", &e.Workspace)
			delete(rawMsg, key)
		default:
			if e.AdditionalProperties == nil {
				e.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				e.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailedLocalLoginsNotInAllowedRange.
func (f FailedLocalLoginsNotInAllowedRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", f.Description)
	populate(objectMap, "displayName", f.DisplayName)
	populate(objectMap, "isEnabled", f.IsEnabled)
	populate(objectMap, "maxThreshold", f.MaxThreshold)
	populate(objectMap, "minThreshold", f.MinThreshold)
	objectMap["ruleType"] = "FailedLocalLoginsNotInAllowedRange"
	populate(objectMap, "timeWindowSize", f.TimeWindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailedLocalLoginsNotInAllowedRange.
func (f *FailedLocalLoginsNotInAllowedRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &f.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &f.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &f.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &f.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &f.RuleType)
			delete(rawMsg, key)
		case "timeWindowSize":
			err = unpopulate(val, "TimeWindowSize", &f.TimeWindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileUploadsNotInAllowedRange.
func (f FileUploadsNotInAllowedRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", f.Description)
	populate(objectMap, "displayName", f.DisplayName)
	populate(objectMap, "isEnabled", f.IsEnabled)
	populate(objectMap, "maxThreshold", f.MaxThreshold)
	populate(objectMap, "minThreshold", f.MinThreshold)
	objectMap["ruleType"] = "FileUploadsNotInAllowedRange"
	populate(objectMap, "timeWindowSize", f.TimeWindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileUploadsNotInAllowedRange.
func (f *FileUploadsNotInAllowedRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &f.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &f.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &f.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &f.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &f.RuleType)
			delete(rawMsg, key)
		case "timeWindowSize":
			err = unpopulate(val, "TimeWindowSize", &f.TimeWindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GcpCredentialsDetailsProperties.
func (g GcpCredentialsDetailsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authProviderX509CertUrl", g.AuthProviderX509CertURL)
	populate(objectMap, "authUri", g.AuthURI)
	populate(objectMap, "authenticationProvisioningState", g.AuthenticationProvisioningState)
	objectMap["authenticationType"] = AuthenticationTypeGcpCredentials
	populate(objectMap, "clientEmail", g.ClientEmail)
	populate(objectMap, "clientId", g.ClientID)
	populate(objectMap, "clientX509CertUrl", g.ClientX509CertURL)
	populate(objectMap, "grantedPermissions", g.GrantedPermissions)
	populate(objectMap, "organizationId", g.OrganizationID)
	populate(objectMap, "privateKey", g.PrivateKey)
	populate(objectMap, "privateKeyId", g.PrivateKeyID)
	populate(objectMap, "projectId", g.ProjectID)
	populate(objectMap, "tokenUri", g.TokenURI)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GcpCredentialsDetailsProperties.
func (g *GcpCredentialsDetailsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authProviderX509CertUrl":
			err = unpopulate(val, "AuthProviderX509CertURL", &g.AuthProviderX509CertURL)
			delete(rawMsg, key)
		case "authUri":
			err = unpopulate(val, "AuthURI", &g.AuthURI)
			delete(rawMsg, key)
		case "authenticationProvisioningState":
			err = unpopulate(val, "AuthenticationProvisioningState", &g.AuthenticationProvisioningState)
			delete(rawMsg, key)
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &g.AuthenticationType)
			delete(rawMsg, key)
		case "clientEmail":
			err = unpopulate(val, "ClientEmail", &g.ClientEmail)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &g.ClientID)
			delete(rawMsg, key)
		case "clientX509CertUrl":
			err = unpopulate(val, "ClientX509CertURL", &g.ClientX509CertURL)
			delete(rawMsg, key)
		case "grantedPermissions":
			err = unpopulate(val, "GrantedPermissions", &g.GrantedPermissions)
			delete(rawMsg, key)
		case "organizationId":
			err = unpopulate(val, "OrganizationID", &g.OrganizationID)
			delete(rawMsg, key)
		case "privateKey":
			err = unpopulate(val, "PrivateKey", &g.PrivateKey)
			delete(rawMsg, key)
		case "privateKeyId":
			err = unpopulate(val, "PrivateKeyID", &g.PrivateKeyID)
			delete(rawMsg, key)
		case "projectId":
			err = unpopulate(val, "ProjectID", &g.ProjectID)
			delete(rawMsg, key)
		case "tokenUri":
			err = unpopulate(val, "TokenURI", &g.TokenURI)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GcpOrganizationalData.
func (g GcpOrganizationalData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["organizationMembershipType"] = g.OrganizationMembershipType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GcpOrganizationalData.
func (g *GcpOrganizationalData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "organizationMembershipType":
			err = unpopulate(val, "OrganizationMembershipType", &g.OrganizationMembershipType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GcpOrganizationalDataMember.
func (g GcpOrganizationalDataMember) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "managementProjectNumber", g.ManagementProjectNumber)
	objectMap["organizationMembershipType"] = OrganizationMembershipTypeMember
	populate(objectMap, "parentHierarchyId", g.ParentHierarchyID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GcpOrganizationalDataMember.
func (g *GcpOrganizationalDataMember) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "managementProjectNumber":
			err = unpopulate(val, "ManagementProjectNumber", &g.ManagementProjectNumber)
			delete(rawMsg, key)
		case "organizationMembershipType":
			err = unpopulate(val, "OrganizationMembershipType", &g.OrganizationMembershipType)
			delete(rawMsg, key)
		case "parentHierarchyId":
			err = unpopulate(val, "ParentHierarchyID", &g.ParentHierarchyID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GcpOrganizationalDataOrganization.
func (g GcpOrganizationalDataOrganization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "excludedProjectNumbers", g.ExcludedProjectNumbers)
	objectMap["organizationMembershipType"] = OrganizationMembershipTypeOrganization
	populate(objectMap, "serviceAccountEmailAddress", g.ServiceAccountEmailAddress)
	populate(objectMap, "workloadIdentityProviderId", g.WorkloadIdentityProviderID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GcpOrganizationalDataOrganization.
func (g *GcpOrganizationalDataOrganization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "excludedProjectNumbers":
			err = unpopulate(val, "ExcludedProjectNumbers", &g.ExcludedProjectNumbers)
			delete(rawMsg, key)
		case "organizationMembershipType":
			err = unpopulate(val, "OrganizationMembershipType", &g.OrganizationMembershipType)
			delete(rawMsg, key)
		case "serviceAccountEmailAddress":
			err = unpopulate(val, "ServiceAccountEmailAddress", &g.ServiceAccountEmailAddress)
			delete(rawMsg, key)
		case "workloadIdentityProviderId":
			err = unpopulate(val, "WorkloadIdentityProviderID", &g.WorkloadIdentityProviderID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GcpProjectDetails.
func (g GcpProjectDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "projectId", g.ProjectID)
	populate(objectMap, "projectNumber", g.ProjectNumber)
	populate(objectMap, "workloadIdentityPoolId", g.WorkloadIdentityPoolID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GcpProjectDetails.
func (g *GcpProjectDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "projectId":
			err = unpopulate(val, "ProjectID", &g.ProjectID)
			delete(rawMsg, key)
		case "projectNumber":
			err = unpopulate(val, "ProjectNumber", &g.ProjectNumber)
			delete(rawMsg, key)
		case "workloadIdentityPoolId":
			err = unpopulate(val, "WorkloadIdentityPoolID", &g.WorkloadIdentityPoolID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GcpProjectEnvironmentData.
func (g GcpProjectEnvironmentData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["environmentType"] = EnvironmentTypeGcpProject
	populate(objectMap, "organizationalData", g.OrganizationalData)
	populate(objectMap, "projectDetails", g.ProjectDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GcpProjectEnvironmentData.
func (g *GcpProjectEnvironmentData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "environmentType":
			err = unpopulate(val, "EnvironmentType", &g.EnvironmentType)
			delete(rawMsg, key)
		case "organizationalData":
			g.OrganizationalData, err = unmarshalGcpOrganizationalDataClassification(val)
			delete(rawMsg, key)
		case "projectDetails":
			err = unpopulate(val, "ProjectDetails", &g.ProjectDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GithubScopeEnvironmentData.
func (g GithubScopeEnvironmentData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["environmentType"] = EnvironmentTypeGithubScope
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GithubScopeEnvironmentData.
func (g *GithubScopeEnvironmentData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "environmentType":
			err = unpopulate(val, "EnvironmentType", &g.EnvironmentType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GovernanceAssignment.
func (g GovernanceAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GovernanceAssignment.
func (g *GovernanceAssignment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GovernanceAssignmentAdditionalData.
func (g GovernanceAssignmentAdditionalData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ticketLink", g.TicketLink)
	populate(objectMap, "ticketNumber", g.TicketNumber)
	populate(objectMap, "ticketStatus", g.TicketStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GovernanceAssignmentAdditionalData.
func (g *GovernanceAssignmentAdditionalData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ticketLink":
			err = unpopulate(val, "TicketLink", &g.TicketLink)
			delete(rawMsg, key)
		case "ticketNumber":
			err = unpopulate(val, "TicketNumber", &g.TicketNumber)
			delete(rawMsg, key)
		case "ticketStatus":
			err = unpopulate(val, "TicketStatus", &g.TicketStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GovernanceAssignmentProperties.
func (g GovernanceAssignmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalData", g.AdditionalData)
	populate(objectMap, "governanceEmailNotification", g.GovernanceEmailNotification)
	populate(objectMap, "isGracePeriod", g.IsGracePeriod)
	populate(objectMap, "owner", g.Owner)
	populateTimeRFC3339(objectMap, "remediationDueDate", g.RemediationDueDate)
	populate(objectMap, "remediationEta", g.RemediationEta)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GovernanceAssignmentProperties.
func (g *GovernanceAssignmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &g.AdditionalData)
			delete(rawMsg, key)
		case "governanceEmailNotification":
			err = unpopulate(val, "GovernanceEmailNotification", &g.GovernanceEmailNotification)
			delete(rawMsg, key)
		case "isGracePeriod":
			err = unpopulate(val, "IsGracePeriod", &g.IsGracePeriod)
			delete(rawMsg, key)
		case "owner":
			err = unpopulate(val, "Owner", &g.Owner)
			delete(rawMsg, key)
		case "remediationDueDate":
			err = unpopulateTimeRFC3339(val, "RemediationDueDate", &g.RemediationDueDate)
			delete(rawMsg, key)
		case "remediationEta":
			err = unpopulate(val, "RemediationEta", &g.RemediationEta)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GovernanceAssignmentsList.
func (g GovernanceAssignmentsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GovernanceAssignmentsList.
func (g *GovernanceAssignmentsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GovernanceEmailNotification.
func (g GovernanceEmailNotification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "disableManagerEmailNotification", g.DisableManagerEmailNotification)
	populate(objectMap, "disableOwnerEmailNotification", g.DisableOwnerEmailNotification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GovernanceEmailNotification.
func (g *GovernanceEmailNotification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableManagerEmailNotification":
			err = unpopulate(val, "DisableManagerEmailNotification", &g.DisableManagerEmailNotification)
			delete(rawMsg, key)
		case "disableOwnerEmailNotification":
			err = unpopulate(val, "DisableOwnerEmailNotification", &g.DisableOwnerEmailNotification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GovernanceRule.
func (g GovernanceRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GovernanceRule.
func (g *GovernanceRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GovernanceRuleEmailNotification.
func (g GovernanceRuleEmailNotification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "disableManagerEmailNotification", g.DisableManagerEmailNotification)
	populate(objectMap, "disableOwnerEmailNotification", g.DisableOwnerEmailNotification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GovernanceRuleEmailNotification.
func (g *GovernanceRuleEmailNotification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableManagerEmailNotification":
			err = unpopulate(val, "DisableManagerEmailNotification", &g.DisableManagerEmailNotification)
			delete(rawMsg, key)
		case "disableOwnerEmailNotification":
			err = unpopulate(val, "DisableOwnerEmailNotification", &g.DisableOwnerEmailNotification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GovernanceRuleList.
func (g GovernanceRuleList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GovernanceRuleList.
func (g *GovernanceRuleList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GovernanceRuleOwnerSource.
func (g GovernanceRuleOwnerSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "type", g.Type)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GovernanceRuleOwnerSource.
func (g *GovernanceRuleOwnerSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GovernanceRuleProperties.
func (g GovernanceRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "conditionSets", g.ConditionSets)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "displayName", g.DisplayName)
	populate(objectMap, "governanceEmailNotification", g.GovernanceEmailNotification)
	populate(objectMap, "isDisabled", g.IsDisabled)
	populate(objectMap, "isGracePeriod", g.IsGracePeriod)
	populate(objectMap, "ownerSource", g.OwnerSource)
	populate(objectMap, "remediationTimeframe", g.RemediationTimeframe)
	populate(objectMap, "rulePriority", g.RulePriority)
	populate(objectMap, "ruleType", g.RuleType)
	populate(objectMap, "sourceResourceType", g.SourceResourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GovernanceRuleProperties.
func (g *GovernanceRuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "conditionSets":
			err = unpopulate(val, "ConditionSets", &g.ConditionSets)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &g.DisplayName)
			delete(rawMsg, key)
		case "governanceEmailNotification":
			err = unpopulate(val, "GovernanceEmailNotification", &g.GovernanceEmailNotification)
			delete(rawMsg, key)
		case "isDisabled":
			err = unpopulate(val, "IsDisabled", &g.IsDisabled)
			delete(rawMsg, key)
		case "isGracePeriod":
			err = unpopulate(val, "IsGracePeriod", &g.IsGracePeriod)
			delete(rawMsg, key)
		case "ownerSource":
			err = unpopulate(val, "OwnerSource", &g.OwnerSource)
			delete(rawMsg, key)
		case "remediationTimeframe":
			err = unpopulate(val, "RemediationTimeframe", &g.RemediationTimeframe)
			delete(rawMsg, key)
		case "rulePriority":
			err = unpopulate(val, "RulePriority", &g.RulePriority)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &g.RuleType)
			delete(rawMsg, key)
		case "sourceResourceType":
			err = unpopulate(val, "SourceResourceType", &g.SourceResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPC2DMessagesNotInAllowedRange.
func (h HTTPC2DMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", h.Description)
	populate(objectMap, "displayName", h.DisplayName)
	populate(objectMap, "isEnabled", h.IsEnabled)
	populate(objectMap, "maxThreshold", h.MaxThreshold)
	populate(objectMap, "minThreshold", h.MinThreshold)
	objectMap["ruleType"] = "HttpC2DMessagesNotInAllowedRange"
	populate(objectMap, "timeWindowSize", h.TimeWindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPC2DMessagesNotInAllowedRange.
func (h *HTTPC2DMessagesNotInAllowedRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &h.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &h.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &h.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &h.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &h.RuleType)
			delete(rawMsg, key)
		case "timeWindowSize":
			err = unpopulate(val, "TimeWindowSize", &h.TimeWindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPC2DRejectedMessagesNotInAllowedRange.
func (h HTTPC2DRejectedMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", h.Description)
	populate(objectMap, "displayName", h.DisplayName)
	populate(objectMap, "isEnabled", h.IsEnabled)
	populate(objectMap, "maxThreshold", h.MaxThreshold)
	populate(objectMap, "minThreshold", h.MinThreshold)
	objectMap["ruleType"] = "HttpC2DRejectedMessagesNotInAllowedRange"
	populate(objectMap, "timeWindowSize", h.TimeWindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPC2DRejectedMessagesNotInAllowedRange.
func (h *HTTPC2DRejectedMessagesNotInAllowedRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &h.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &h.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &h.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &h.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &h.RuleType)
			delete(rawMsg, key)
		case "timeWindowSize":
			err = unpopulate(val, "TimeWindowSize", &h.TimeWindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPD2CMessagesNotInAllowedRange.
func (h HTTPD2CMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", h.Description)
	populate(objectMap, "displayName", h.DisplayName)
	populate(objectMap, "isEnabled", h.IsEnabled)
	populate(objectMap, "maxThreshold", h.MaxThreshold)
	populate(objectMap, "minThreshold", h.MinThreshold)
	objectMap["ruleType"] = "HttpD2CMessagesNotInAllowedRange"
	populate(objectMap, "timeWindowSize", h.TimeWindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPD2CMessagesNotInAllowedRange.
func (h *HTTPD2CMessagesNotInAllowedRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &h.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &h.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &h.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &h.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &h.RuleType)
			delete(rawMsg, key)
		case "timeWindowSize":
			err = unpopulate(val, "TimeWindowSize", &h.TimeWindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridComputeSettingsProperties.
func (h HybridComputeSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoProvision", h.AutoProvision)
	populate(objectMap, "hybridComputeProvisioningState", h.HybridComputeProvisioningState)
	populate(objectMap, "proxyServer", h.ProxyServer)
	populate(objectMap, "region", h.Region)
	populate(objectMap, "resourceGroupName", h.ResourceGroupName)
	populate(objectMap, "servicePrincipal", h.ServicePrincipal)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridComputeSettingsProperties.
func (h *HybridComputeSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoProvision":
			err = unpopulate(val, "AutoProvision", &h.AutoProvision)
			delete(rawMsg, key)
		case "hybridComputeProvisioningState":
			err = unpopulate(val, "HybridComputeProvisioningState", &h.HybridComputeProvisioningState)
			delete(rawMsg, key)
		case "proxyServer":
			err = unpopulate(val, "ProxyServer", &h.ProxyServer)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &h.Region)
			delete(rawMsg, key)
		case "resourceGroupName":
			err = unpopulate(val, "ResourceGroupName", &h.ResourceGroupName)
			delete(rawMsg, key)
		case "servicePrincipal":
			err = unpopulate(val, "ServicePrincipal", &h.ServicePrincipal)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InformationProtectionAwsOffering.
func (i InformationProtectionAwsOffering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", i.Description)
	populate(objectMap, "informationProtection", i.InformationProtection)
	objectMap["offeringType"] = OfferingTypeInformationProtectionAws
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InformationProtectionAwsOffering.
func (i *InformationProtectionAwsOffering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "informationProtection":
			err = unpopulate(val, "InformationProtection", &i.InformationProtection)
			delete(rawMsg, key)
		case "offeringType":
			err = unpopulate(val, "OfferingType", &i.OfferingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InformationProtectionAwsOfferingInformationProtection.
func (i InformationProtectionAwsOfferingInformationProtection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cloudRoleArn", i.CloudRoleArn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InformationProtectionAwsOfferingInformationProtection.
func (i *InformationProtectionAwsOfferingInformationProtection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudRoleArn":
			err = unpopulate(val, "CloudRoleArn", &i.CloudRoleArn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InformationProtectionKeyword.
func (i InformationProtectionKeyword) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "canBeNumeric", i.CanBeNumeric)
	populate(objectMap, "custom", i.Custom)
	populate(objectMap, "excluded", i.Excluded)
	populate(objectMap, "pattern", i.Pattern)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InformationProtectionKeyword.
func (i *InformationProtectionKeyword) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "canBeNumeric":
			err = unpopulate(val, "CanBeNumeric", &i.CanBeNumeric)
			delete(rawMsg, key)
		case "custom":
			err = unpopulate(val, "Custom", &i.Custom)
			delete(rawMsg, key)
		case "excluded":
			err = unpopulate(val, "Excluded", &i.Excluded)
			delete(rawMsg, key)
		case "pattern":
			err = unpopulate(val, "Pattern", &i.Pattern)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InformationProtectionPolicy.
func (i InformationProtectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InformationProtectionPolicy.
func (i *InformationProtectionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InformationProtectionPolicyList.
func (i InformationProtectionPolicyList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InformationProtectionPolicyList.
func (i *InformationProtectionPolicyList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InformationProtectionPolicyProperties.
func (i InformationProtectionPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "informationTypes", i.InformationTypes)
	populate(objectMap, "labels", i.Labels)
	populateTimeRFC3339(objectMap, "lastModifiedUtc", i.LastModifiedUTC)
	populate(objectMap, "version", i.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InformationProtectionPolicyProperties.
func (i *InformationProtectionPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "informationTypes":
			err = unpopulate(val, "InformationTypes", &i.InformationTypes)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &i.Labels)
			delete(rawMsg, key)
		case "lastModifiedUtc":
			err = unpopulateTimeRFC3339(val, "LastModifiedUTC", &i.LastModifiedUTC)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &i.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InformationType.
func (i InformationType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "custom", i.Custom)
	populate(objectMap, "description", i.Description)
	populate(objectMap, "displayName", i.DisplayName)
	populate(objectMap, "enabled", i.Enabled)
	populate(objectMap, "keywords", i.Keywords)
	populate(objectMap, "order", i.Order)
	populate(objectMap, "recommendedLabelId", i.RecommendedLabelID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InformationType.
func (i *InformationType) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "custom":
			err = unpopulate(val, "Custom", &i.Custom)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &i.DisplayName)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &i.Enabled)
			delete(rawMsg, key)
		case "keywords":
			err = unpopulate(val, "Keywords", &i.Keywords)
			delete(rawMsg, key)
		case "order":
			err = unpopulate(val, "Order", &i.Order)
			delete(rawMsg, key)
		case "recommendedLabelId":
			err = unpopulate(val, "RecommendedLabelID", &i.RecommendedLabelID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IngestionConnectionString.
func (i IngestionConnectionString) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", i.Location)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IngestionConnectionString.
func (i *IngestionConnectionString) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IngestionSetting.
func (i IngestionSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", &i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IngestionSetting.
func (i *IngestionSetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IngestionSettingList.
func (i IngestionSettingList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IngestionSettingList.
func (i *IngestionSettingList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IngestionSettingToken.
func (i IngestionSettingToken) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "token", i.Token)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IngestionSettingToken.
func (i *IngestionSettingToken) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "token":
			err = unpopulate(val, "Token", &i.Token)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSecurityAggregatedAlert.
func (i IoTSecurityAggregatedAlert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSecurityAggregatedAlert.
func (i *IoTSecurityAggregatedAlert) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSecurityAggregatedAlertList.
func (i IoTSecurityAggregatedAlertList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSecurityAggregatedAlertList.
func (i *IoTSecurityAggregatedAlertList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSecurityAggregatedAlertProperties.
func (i IoTSecurityAggregatedAlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionTaken", i.ActionTaken)
	populateDateType(objectMap, "aggregatedDateUtc", i.AggregatedDateUTC)
	populate(objectMap, "alertDisplayName", i.AlertDisplayName)
	populate(objectMap, "alertType", i.AlertType)
	populate(objectMap, "count", i.Count)
	populate(objectMap, "description", i.Description)
	populate(objectMap, "effectedResourceType", i.EffectedResourceType)
	populate(objectMap, "logAnalyticsQuery", i.LogAnalyticsQuery)
	populate(objectMap, "remediationSteps", i.RemediationSteps)
	populate(objectMap, "reportedSeverity", i.ReportedSeverity)
	populate(objectMap, "systemSource", i.SystemSource)
	populate(objectMap, "topDevicesList", i.TopDevicesList)
	populate(objectMap, "vendorName", i.VendorName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSecurityAggregatedAlertProperties.
func (i *IoTSecurityAggregatedAlertProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionTaken":
			err = unpopulate(val, "ActionTaken", &i.ActionTaken)
			delete(rawMsg, key)
		case "aggregatedDateUtc":
			err = unpopulateDateType(val, "AggregatedDateUTC", &i.AggregatedDateUTC)
			delete(rawMsg, key)
		case "alertDisplayName":
			err = unpopulate(val, "AlertDisplayName", &i.AlertDisplayName)
			delete(rawMsg, key)
		case "alertType":
			err = unpopulate(val, "AlertType", &i.AlertType)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &i.Count)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "effectedResourceType":
			err = unpopulate(val, "EffectedResourceType", &i.EffectedResourceType)
			delete(rawMsg, key)
		case "logAnalyticsQuery":
			err = unpopulate(val, "LogAnalyticsQuery", &i.LogAnalyticsQuery)
			delete(rawMsg, key)
		case "remediationSteps":
			err = unpopulate(val, "RemediationSteps", &i.RemediationSteps)
			delete(rawMsg, key)
		case "reportedSeverity":
			err = unpopulate(val, "ReportedSeverity", &i.ReportedSeverity)
			delete(rawMsg, key)
		case "systemSource":
			err = unpopulate(val, "SystemSource", &i.SystemSource)
			delete(rawMsg, key)
		case "topDevicesList":
			err = unpopulate(val, "TopDevicesList", &i.TopDevicesList)
			delete(rawMsg, key)
		case "vendorName":
			err = unpopulate(val, "VendorName", &i.VendorName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSecurityAggregatedAlertPropertiesTopDevicesListItem.
func (i IoTSecurityAggregatedAlertPropertiesTopDevicesListItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alertsCount", i.AlertsCount)
	populate(objectMap, "deviceId", i.DeviceID)
	populate(objectMap, "lastOccurrence", i.LastOccurrence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSecurityAggregatedAlertPropertiesTopDevicesListItem.
func (i *IoTSecurityAggregatedAlertPropertiesTopDevicesListItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertsCount":
			err = unpopulate(val, "AlertsCount", &i.AlertsCount)
			delete(rawMsg, key)
		case "deviceId":
			err = unpopulate(val, "DeviceID", &i.DeviceID)
			delete(rawMsg, key)
		case "lastOccurrence":
			err = unpopulate(val, "LastOccurrence", &i.LastOccurrence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSecurityAggregatedRecommendation.
func (i IoTSecurityAggregatedRecommendation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSecurityAggregatedRecommendation.
func (i *IoTSecurityAggregatedRecommendation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSecurityAggregatedRecommendationList.
func (i IoTSecurityAggregatedRecommendationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSecurityAggregatedRecommendationList.
func (i *IoTSecurityAggregatedRecommendationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSecurityAggregatedRecommendationProperties.
func (i IoTSecurityAggregatedRecommendationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", i.Description)
	populate(objectMap, "detectedBy", i.DetectedBy)
	populate(objectMap, "healthyDevices", i.HealthyDevices)
	populate(objectMap, "logAnalyticsQuery", i.LogAnalyticsQuery)
	populate(objectMap, "recommendationDisplayName", i.RecommendationDisplayName)
	populate(objectMap, "recommendationName", i.RecommendationName)
	populate(objectMap, "recommendationTypeId", i.RecommendationTypeID)
	populate(objectMap, "remediationSteps", i.RemediationSteps)
	populate(objectMap, "reportedSeverity", i.ReportedSeverity)
	populate(objectMap, "unhealthyDeviceCount", i.UnhealthyDeviceCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSecurityAggregatedRecommendationProperties.
func (i *IoTSecurityAggregatedRecommendationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "detectedBy":
			err = unpopulate(val, "DetectedBy", &i.DetectedBy)
			delete(rawMsg, key)
		case "healthyDevices":
			err = unpopulate(val, "HealthyDevices", &i.HealthyDevices)
			delete(rawMsg, key)
		case "logAnalyticsQuery":
			err = unpopulate(val, "LogAnalyticsQuery", &i.LogAnalyticsQuery)
			delete(rawMsg, key)
		case "recommendationDisplayName":
			err = unpopulate(val, "RecommendationDisplayName", &i.RecommendationDisplayName)
			delete(rawMsg, key)
		case "recommendationName":
			err = unpopulate(val, "RecommendationName", &i.RecommendationName)
			delete(rawMsg, key)
		case "recommendationTypeId":
			err = unpopulate(val, "RecommendationTypeID", &i.RecommendationTypeID)
			delete(rawMsg, key)
		case "remediationSteps":
			err = unpopulate(val, "RemediationSteps", &i.RemediationSteps)
			delete(rawMsg, key)
		case "reportedSeverity":
			err = unpopulate(val, "ReportedSeverity", &i.ReportedSeverity)
			delete(rawMsg, key)
		case "unhealthyDeviceCount":
			err = unpopulate(val, "UnhealthyDeviceCount", &i.UnhealthyDeviceCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSecurityAlertedDevice.
func (i IoTSecurityAlertedDevice) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alertsCount", i.AlertsCount)
	populate(objectMap, "deviceId", i.DeviceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSecurityAlertedDevice.
func (i *IoTSecurityAlertedDevice) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertsCount":
			err = unpopulate(val, "AlertsCount", &i.AlertsCount)
			delete(rawMsg, key)
		case "deviceId":
			err = unpopulate(val, "DeviceID", &i.DeviceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSecurityDeviceAlert.
func (i IoTSecurityDeviceAlert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alertDisplayName", i.AlertDisplayName)
	populate(objectMap, "alertsCount", i.AlertsCount)
	populate(objectMap, "reportedSeverity", i.ReportedSeverity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSecurityDeviceAlert.
func (i *IoTSecurityDeviceAlert) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertDisplayName":
			err = unpopulate(val, "AlertDisplayName", &i.AlertDisplayName)
			delete(rawMsg, key)
		case "alertsCount":
			err = unpopulate(val, "AlertsCount", &i.AlertsCount)
			delete(rawMsg, key)
		case "reportedSeverity":
			err = unpopulate(val, "ReportedSeverity", &i.ReportedSeverity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSecurityDeviceRecommendation.
func (i IoTSecurityDeviceRecommendation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "devicesCount", i.DevicesCount)
	populate(objectMap, "recommendationDisplayName", i.RecommendationDisplayName)
	populate(objectMap, "reportedSeverity", i.ReportedSeverity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSecurityDeviceRecommendation.
func (i *IoTSecurityDeviceRecommendation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "devicesCount":
			err = unpopulate(val, "DevicesCount", &i.DevicesCount)
			delete(rawMsg, key)
		case "recommendationDisplayName":
			err = unpopulate(val, "RecommendationDisplayName", &i.RecommendationDisplayName)
			delete(rawMsg, key)
		case "reportedSeverity":
			err = unpopulate(val, "ReportedSeverity", &i.ReportedSeverity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSecuritySolutionAnalyticsModel.
func (i IoTSecuritySolutionAnalyticsModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSecuritySolutionAnalyticsModel.
func (i *IoTSecuritySolutionAnalyticsModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSecuritySolutionAnalyticsModelList.
func (i IoTSecuritySolutionAnalyticsModelList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSecuritySolutionAnalyticsModelList.
func (i *IoTSecuritySolutionAnalyticsModelList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSecuritySolutionAnalyticsModelProperties.
func (i IoTSecuritySolutionAnalyticsModelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "devicesMetrics", i.DevicesMetrics)
	populate(objectMap, "metrics", i.Metrics)
	populate(objectMap, "mostPrevalentDeviceAlerts", i.MostPrevalentDeviceAlerts)
	populate(objectMap, "mostPrevalentDeviceRecommendations", i.MostPrevalentDeviceRecommendations)
	populate(objectMap, "topAlertedDevices", i.TopAlertedDevices)
	populate(objectMap, "unhealthyDeviceCount", i.UnhealthyDeviceCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSecuritySolutionAnalyticsModelProperties.
func (i *IoTSecuritySolutionAnalyticsModelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "devicesMetrics":
			err = unpopulate(val, "DevicesMetrics", &i.DevicesMetrics)
			delete(rawMsg, key)
		case "metrics":
			err = unpopulate(val, "Metrics", &i.Metrics)
			delete(rawMsg, key)
		case "mostPrevalentDeviceAlerts":
			err = unpopulate(val, "MostPrevalentDeviceAlerts", &i.MostPrevalentDeviceAlerts)
			delete(rawMsg, key)
		case "mostPrevalentDeviceRecommendations":
			err = unpopulate(val, "MostPrevalentDeviceRecommendations", &i.MostPrevalentDeviceRecommendations)
			delete(rawMsg, key)
		case "topAlertedDevices":
			err = unpopulate(val, "TopAlertedDevices", &i.TopAlertedDevices)
			delete(rawMsg, key)
		case "unhealthyDeviceCount":
			err = unpopulate(val, "UnhealthyDeviceCount", &i.UnhealthyDeviceCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem.
func (i IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "date", i.Date)
	populate(objectMap, "devicesMetrics", i.DevicesMetrics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem.
func (i *IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "date":
			err = unpopulateTimeRFC3339(val, "Date", &i.Date)
			delete(rawMsg, key)
		case "devicesMetrics":
			err = unpopulate(val, "DevicesMetrics", &i.DevicesMetrics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSecuritySolutionModel.
func (i IoTSecuritySolutionModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSecuritySolutionModel.
func (i *IoTSecuritySolutionModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &i.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSecuritySolutionProperties.
func (i IoTSecuritySolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalWorkspaces", i.AdditionalWorkspaces)
	populate(objectMap, "autoDiscoveredResources", i.AutoDiscoveredResources)
	populate(objectMap, "disabledDataSources", i.DisabledDataSources)
	populate(objectMap, "displayName", i.DisplayName)
	populate(objectMap, "export", i.Export)
	populate(objectMap, "iotHubs", i.IotHubs)
	populate(objectMap, "recommendationsConfiguration", i.RecommendationsConfiguration)
	populate(objectMap, "status", i.Status)
	populate(objectMap, "unmaskedIpLoggingStatus", i.UnmaskedIPLoggingStatus)
	populate(objectMap, "userDefinedResources", i.UserDefinedResources)
	populate(objectMap, "workspace", i.Workspace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSecuritySolutionProperties.
func (i *IoTSecuritySolutionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalWorkspaces":
			err = unpopulate(val, "AdditionalWorkspaces", &i.AdditionalWorkspaces)
			delete(rawMsg, key)
		case "autoDiscoveredResources":
			err = unpopulate(val, "AutoDiscoveredResources", &i.AutoDiscoveredResources)
			delete(rawMsg, key)
		case "disabledDataSources":
			err = unpopulate(val, "DisabledDataSources", &i.DisabledDataSources)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &i.DisplayName)
			delete(rawMsg, key)
		case "export":
			err = unpopulate(val, "Export", &i.Export)
			delete(rawMsg, key)
		case "iotHubs":
			err = unpopulate(val, "IotHubs", &i.IotHubs)
			delete(rawMsg, key)
		case "recommendationsConfiguration":
			err = unpopulate(val, "RecommendationsConfiguration", &i.RecommendationsConfiguration)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &i.Status)
			delete(rawMsg, key)
		case "unmaskedIpLoggingStatus":
			err = unpopulate(val, "UnmaskedIPLoggingStatus", &i.UnmaskedIPLoggingStatus)
			delete(rawMsg, key)
		case "userDefinedResources":
			err = unpopulate(val, "UserDefinedResources", &i.UserDefinedResources)
			delete(rawMsg, key)
		case "workspace":
			err = unpopulate(val, "Workspace", &i.Workspace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSecuritySolutionsList.
func (i IoTSecuritySolutionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSecuritySolutionsList.
func (i *IoTSecuritySolutionsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTSeverityMetrics.
func (i IoTSeverityMetrics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "high", i.High)
	populate(objectMap, "low", i.Low)
	populate(objectMap, "medium", i.Medium)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTSeverityMetrics.
func (i *IoTSeverityMetrics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "high":
			err = unpopulate(val, "High", &i.High)
			delete(rawMsg, key)
		case "low":
			err = unpopulate(val, "Low", &i.Low)
			delete(rawMsg, key)
		case "medium":
			err = unpopulate(val, "Medium", &i.Medium)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JitNetworkAccessPoliciesList.
func (j JitNetworkAccessPoliciesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", j.NextLink)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JitNetworkAccessPoliciesList.
func (j *JitNetworkAccessPoliciesList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &j.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JitNetworkAccessPolicy.
func (j JitNetworkAccessPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", j.ID)
	populate(objectMap, "kind", j.Kind)
	populate(objectMap, "location", j.Location)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JitNetworkAccessPolicy.
func (j *JitNetworkAccessPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &j.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &j.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JitNetworkAccessPolicyInitiatePort.
func (j JitNetworkAccessPolicyInitiatePort) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedSourceAddressPrefix", j.AllowedSourceAddressPrefix)
	populateTimeRFC3339(objectMap, "endTimeUtc", j.EndTimeUTC)
	populate(objectMap, "number", j.Number)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JitNetworkAccessPolicyInitiatePort.
func (j *JitNetworkAccessPolicyInitiatePort) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedSourceAddressPrefix":
			err = unpopulate(val, "AllowedSourceAddressPrefix", &j.AllowedSourceAddressPrefix)
			delete(rawMsg, key)
		case "endTimeUtc":
			err = unpopulateTimeRFC3339(val, "EndTimeUTC", &j.EndTimeUTC)
			delete(rawMsg, key)
		case "number":
			err = unpopulate(val, "Number", &j.Number)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JitNetworkAccessPolicyInitiateRequest.
func (j JitNetworkAccessPolicyInitiateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "justification", j.Justification)
	populate(objectMap, "virtualMachines", j.VirtualMachines)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JitNetworkAccessPolicyInitiateRequest.
func (j *JitNetworkAccessPolicyInitiateRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "justification":
			err = unpopulate(val, "Justification", &j.Justification)
			delete(rawMsg, key)
		case "virtualMachines":
			err = unpopulate(val, "VirtualMachines", &j.VirtualMachines)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JitNetworkAccessPolicyInitiateVirtualMachine.
func (j JitNetworkAccessPolicyInitiateVirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", j.ID)
	populate(objectMap, "ports", j.Ports)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JitNetworkAccessPolicyInitiateVirtualMachine.
func (j *JitNetworkAccessPolicyInitiateVirtualMachine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "ports":
			err = unpopulate(val, "Ports", &j.Ports)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JitNetworkAccessPolicyProperties.
func (j JitNetworkAccessPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "provisioningState", j.ProvisioningState)
	populate(objectMap, "requests", j.Requests)
	populate(objectMap, "virtualMachines", j.VirtualMachines)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JitNetworkAccessPolicyProperties.
func (j *JitNetworkAccessPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &j.ProvisioningState)
			delete(rawMsg, key)
		case "requests":
			err = unpopulate(val, "Requests", &j.Requests)
			delete(rawMsg, key)
		case "virtualMachines":
			err = unpopulate(val, "VirtualMachines", &j.VirtualMachines)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JitNetworkAccessPolicyVirtualMachine.
func (j JitNetworkAccessPolicyVirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", j.ID)
	populate(objectMap, "ports", j.Ports)
	populate(objectMap, "publicIpAddress", j.PublicIPAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JitNetworkAccessPolicyVirtualMachine.
func (j *JitNetworkAccessPolicyVirtualMachine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "ports":
			err = unpopulate(val, "Ports", &j.Ports)
			delete(rawMsg, key)
		case "publicIpAddress":
			err = unpopulate(val, "PublicIPAddress", &j.PublicIPAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JitNetworkAccessPortRule.
func (j JitNetworkAccessPortRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedSourceAddressPrefix", j.AllowedSourceAddressPrefix)
	populate(objectMap, "allowedSourceAddressPrefixes", j.AllowedSourceAddressPrefixes)
	populate(objectMap, "maxRequestAccessDuration", j.MaxRequestAccessDuration)
	populate(objectMap, "number", j.Number)
	populate(objectMap, "protocol", j.Protocol)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JitNetworkAccessPortRule.
func (j *JitNetworkAccessPortRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedSourceAddressPrefix":
			err = unpopulate(val, "AllowedSourceAddressPrefix", &j.AllowedSourceAddressPrefix)
			delete(rawMsg, key)
		case "allowedSourceAddressPrefixes":
			err = unpopulate(val, "AllowedSourceAddressPrefixes", &j.AllowedSourceAddressPrefixes)
			delete(rawMsg, key)
		case "maxRequestAccessDuration":
			err = unpopulate(val, "MaxRequestAccessDuration", &j.MaxRequestAccessDuration)
			delete(rawMsg, key)
		case "number":
			err = unpopulate(val, "Number", &j.Number)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &j.Protocol)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JitNetworkAccessRequest.
func (j JitNetworkAccessRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "justification", j.Justification)
	populate(objectMap, "requestor", j.Requestor)
	populateTimeRFC3339(objectMap, "startTimeUtc", j.StartTimeUTC)
	populate(objectMap, "virtualMachines", j.VirtualMachines)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JitNetworkAccessRequest.
func (j *JitNetworkAccessRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "justification":
			err = unpopulate(val, "Justification", &j.Justification)
			delete(rawMsg, key)
		case "requestor":
			err = unpopulate(val, "Requestor", &j.Requestor)
			delete(rawMsg, key)
		case "startTimeUtc":
			err = unpopulateTimeRFC3339(val, "StartTimeUTC", &j.StartTimeUTC)
			delete(rawMsg, key)
		case "virtualMachines":
			err = unpopulate(val, "VirtualMachines", &j.VirtualMachines)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JitNetworkAccessRequestPort.
func (j JitNetworkAccessRequestPort) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedSourceAddressPrefix", j.AllowedSourceAddressPrefix)
	populate(objectMap, "allowedSourceAddressPrefixes", j.AllowedSourceAddressPrefixes)
	populateTimeRFC3339(objectMap, "endTimeUtc", j.EndTimeUTC)
	populate(objectMap, "mappedPort", j.MappedPort)
	populate(objectMap, "number", j.Number)
	populate(objectMap, "status", j.Status)
	populate(objectMap, "statusReason", j.StatusReason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JitNetworkAccessRequestPort.
func (j *JitNetworkAccessRequestPort) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedSourceAddressPrefix":
			err = unpopulate(val, "AllowedSourceAddressPrefix", &j.AllowedSourceAddressPrefix)
			delete(rawMsg, key)
		case "allowedSourceAddressPrefixes":
			err = unpopulate(val, "AllowedSourceAddressPrefixes", &j.AllowedSourceAddressPrefixes)
			delete(rawMsg, key)
		case "endTimeUtc":
			err = unpopulateTimeRFC3339(val, "EndTimeUTC", &j.EndTimeUTC)
			delete(rawMsg, key)
		case "mappedPort":
			err = unpopulate(val, "MappedPort", &j.MappedPort)
			delete(rawMsg, key)
		case "number":
			err = unpopulate(val, "Number", &j.Number)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		case "statusReason":
			err = unpopulate(val, "StatusReason", &j.StatusReason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JitNetworkAccessRequestVirtualMachine.
func (j JitNetworkAccessRequestVirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", j.ID)
	populate(objectMap, "ports", j.Ports)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JitNetworkAccessRequestVirtualMachine.
func (j *JitNetworkAccessRequestVirtualMachine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "ports":
			err = unpopulate(val, "Ports", &j.Ports)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KindAutoGenerated.
func (k KindAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "kind", k.Kind)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KindAutoGenerated.
func (k *KindAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &k.Kind)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListCustomAlertRule.
func (l ListCustomAlertRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", l.Description)
	populate(objectMap, "displayName", l.DisplayName)
	populate(objectMap, "isEnabled", l.IsEnabled)
	objectMap["ruleType"] = "ListCustomAlertRule"
	populate(objectMap, "valueType", l.ValueType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListCustomAlertRule.
func (l *ListCustomAlertRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &l.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &l.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &l.IsEnabled)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &l.RuleType)
			delete(rawMsg, key)
		case "valueType":
			err = unpopulate(val, "ValueType", &l.ValueType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalUserNotAllowed.
func (l LocalUserNotAllowed) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowlistValues", l.AllowlistValues)
	populate(objectMap, "description", l.Description)
	populate(objectMap, "displayName", l.DisplayName)
	populate(objectMap, "isEnabled", l.IsEnabled)
	objectMap["ruleType"] = "LocalUserNotAllowed"
	populate(objectMap, "valueType", l.ValueType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalUserNotAllowed.
func (l *LocalUserNotAllowed) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowlistValues":
			err = unpopulate(val, "AllowlistValues", &l.AllowlistValues)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &l.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &l.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &l.IsEnabled)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &l.RuleType)
			delete(rawMsg, key)
		case "valueType":
			err = unpopulate(val, "ValueType", &l.ValueType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Location.
func (l Location) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", l.Location)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Location.
func (l *Location) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogAnalyticsIdentifier.
func (l LogAnalyticsIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentId", l.AgentID)
	objectMap["type"] = ResourceIdentifierTypeLogAnalytics
	populate(objectMap, "workspaceId", l.WorkspaceID)
	populate(objectMap, "workspaceResourceGroup", l.WorkspaceResourceGroup)
	populate(objectMap, "workspaceSubscriptionId", l.WorkspaceSubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogAnalyticsIdentifier.
func (l *LogAnalyticsIdentifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentId":
			err = unpopulate(val, "AgentID", &l.AgentID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		case "workspaceId":
			err = unpopulate(val, "WorkspaceID", &l.WorkspaceID)
			delete(rawMsg, key)
		case "workspaceResourceGroup":
			err = unpopulate(val, "WorkspaceResourceGroup", &l.WorkspaceResourceGroup)
			delete(rawMsg, key)
		case "workspaceSubscriptionId":
			err = unpopulate(val, "WorkspaceSubscriptionID", &l.WorkspaceSubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MdeOnboardingData.
func (m MdeOnboardingData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MdeOnboardingData.
func (m *MdeOnboardingData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MdeOnboardingDataList.
func (m MdeOnboardingDataList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MdeOnboardingDataList.
func (m *MdeOnboardingDataList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MdeOnboardingDataProperties.
func (m MdeOnboardingDataProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateByteArray(objectMap, "onboardingPackageLinux", m.OnboardingPackageLinux, runtime.Base64StdFormat)
	populateByteArray(objectMap, "onboardingPackageWindows", m.OnboardingPackageWindows, runtime.Base64StdFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MdeOnboardingDataProperties.
func (m *MdeOnboardingDataProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "onboardingPackageLinux":
			err = runtime.DecodeByteArray(string(val), &m.OnboardingPackageLinux, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "onboardingPackageWindows":
			err = runtime.DecodeByteArray(string(val), &m.OnboardingPackageWindows, runtime.Base64StdFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MqttC2DMessagesNotInAllowedRange.
func (m MqttC2DMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", m.Description)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "isEnabled", m.IsEnabled)
	populate(objectMap, "maxThreshold", m.MaxThreshold)
	populate(objectMap, "minThreshold", m.MinThreshold)
	objectMap["ruleType"] = "MqttC2DMessagesNotInAllowedRange"
	populate(objectMap, "timeWindowSize", m.TimeWindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MqttC2DMessagesNotInAllowedRange.
func (m *MqttC2DMessagesNotInAllowedRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &m.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &m.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &m.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &m.RuleType)
			delete(rawMsg, key)
		case "timeWindowSize":
			err = unpopulate(val, "TimeWindowSize", &m.TimeWindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MqttC2DRejectedMessagesNotInAllowedRange.
func (m MqttC2DRejectedMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", m.Description)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "isEnabled", m.IsEnabled)
	populate(objectMap, "maxThreshold", m.MaxThreshold)
	populate(objectMap, "minThreshold", m.MinThreshold)
	objectMap["ruleType"] = "MqttC2DRejectedMessagesNotInAllowedRange"
	populate(objectMap, "timeWindowSize", m.TimeWindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MqttC2DRejectedMessagesNotInAllowedRange.
func (m *MqttC2DRejectedMessagesNotInAllowedRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &m.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &m.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &m.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &m.RuleType)
			delete(rawMsg, key)
		case "timeWindowSize":
			err = unpopulate(val, "TimeWindowSize", &m.TimeWindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MqttD2CMessagesNotInAllowedRange.
func (m MqttD2CMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", m.Description)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "isEnabled", m.IsEnabled)
	populate(objectMap, "maxThreshold", m.MaxThreshold)
	populate(objectMap, "minThreshold", m.MinThreshold)
	objectMap["ruleType"] = "MqttD2CMessagesNotInAllowedRange"
	populate(objectMap, "timeWindowSize", m.TimeWindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MqttD2CMessagesNotInAllowedRange.
func (m *MqttD2CMessagesNotInAllowedRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &m.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &m.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &m.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &m.RuleType)
			delete(rawMsg, key)
		case "timeWindowSize":
			err = unpopulate(val, "TimeWindowSize", &m.TimeWindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnPremiseResourceDetails.
func (o OnPremiseResourceDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "machineName", o.MachineName)
	objectMap["source"] = SourceOnPremise
	populate(objectMap, "sourceComputerId", o.SourceComputerID)
	populate(objectMap, "vmuuid", o.Vmuuid)
	populate(objectMap, "workspaceId", o.WorkspaceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnPremiseResourceDetails.
func (o *OnPremiseResourceDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "machineName":
			err = unpopulate(val, "MachineName", &o.MachineName)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &o.Source)
			delete(rawMsg, key)
		case "sourceComputerId":
			err = unpopulate(val, "SourceComputerID", &o.SourceComputerID)
			delete(rawMsg, key)
		case "vmuuid":
			err = unpopulate(val, "Vmuuid", &o.Vmuuid)
			delete(rawMsg, key)
		case "workspaceId":
			err = unpopulate(val, "WorkspaceID", &o.WorkspaceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnPremiseSQLResourceDetails.
func (o OnPremiseSQLResourceDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseName", o.DatabaseName)
	populate(objectMap, "machineName", o.MachineName)
	populate(objectMap, "serverName", o.ServerName)
	objectMap["source"] = SourceOnPremiseSQL
	populate(objectMap, "sourceComputerId", o.SourceComputerID)
	populate(objectMap, "vmuuid", o.Vmuuid)
	populate(objectMap, "workspaceId", o.WorkspaceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnPremiseSQLResourceDetails.
func (o *OnPremiseSQLResourceDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &o.DatabaseName)
			delete(rawMsg, key)
		case "machineName":
			err = unpopulate(val, "MachineName", &o.MachineName)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &o.ServerName)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &o.Source)
			delete(rawMsg, key)
		case "sourceComputerId":
			err = unpopulate(val, "SourceComputerID", &o.SourceComputerID)
			delete(rawMsg, key)
		case "vmuuid":
			err = unpopulate(val, "Vmuuid", &o.Vmuuid)
			delete(rawMsg, key)
		case "workspaceId":
			err = unpopulate(val, "WorkspaceID", &o.WorkspaceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationList.
func (o OperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationList.
func (o *OperationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PathRecommendation.
func (p PathRecommendation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "action", p.Action)
	populate(objectMap, "common", p.Common)
	populate(objectMap, "configurationStatus", p.ConfigurationStatus)
	populate(objectMap, "fileType", p.FileType)
	populate(objectMap, "path", p.Path)
	populate(objectMap, "publisherInfo", p.PublisherInfo)
	populate(objectMap, "type", p.Type)
	populate(objectMap, "userSids", p.UserSids)
	populate(objectMap, "usernames", p.Usernames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PathRecommendation.
func (p *PathRecommendation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &p.Action)
			delete(rawMsg, key)
		case "common":
			err = unpopulate(val, "Common", &p.Common)
			delete(rawMsg, key)
		case "configurationStatus":
			err = unpopulate(val, "ConfigurationStatus", &p.ConfigurationStatus)
			delete(rawMsg, key)
		case "fileType":
			err = unpopulate(val, "FileType", &p.FileType)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &p.Path)
			delete(rawMsg, key)
		case "publisherInfo":
			err = unpopulate(val, "PublisherInfo", &p.PublisherInfo)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		case "userSids":
			err = unpopulate(val, "UserSids", &p.UserSids)
			delete(rawMsg, key)
		case "usernames":
			err = unpopulate(val, "Usernames", &p.Usernames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Pricing.
func (p Pricing) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Pricing.
func (p *Pricing) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PricingList.
func (p PricingList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PricingList.
func (p *PricingList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PricingProperties.
func (p PricingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deprecated", p.Deprecated)
	populate(objectMap, "freeTrialRemainingTime", p.FreeTrialRemainingTime)
	populate(objectMap, "pricingTier", p.PricingTier)
	populate(objectMap, "replacedBy", p.ReplacedBy)
	populate(objectMap, "subPlan", p.SubPlan)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PricingProperties.
func (p *PricingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deprecated":
			err = unpopulate(val, "Deprecated", &p.Deprecated)
			delete(rawMsg, key)
		case "freeTrialRemainingTime":
			err = unpopulate(val, "FreeTrialRemainingTime", &p.FreeTrialRemainingTime)
			delete(rawMsg, key)
		case "pricingTier":
			err = unpopulate(val, "PricingTier", &p.PricingTier)
			delete(rawMsg, key)
		case "replacedBy":
			err = unpopulate(val, "ReplacedBy", &p.ReplacedBy)
			delete(rawMsg, key)
		case "subPlan":
			err = unpopulate(val, "SubPlan", &p.SubPlan)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessNotAllowed.
func (p ProcessNotAllowed) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowlistValues", p.AllowlistValues)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "isEnabled", p.IsEnabled)
	objectMap["ruleType"] = "ProcessNotAllowed"
	populate(objectMap, "valueType", p.ValueType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessNotAllowed.
func (p *ProcessNotAllowed) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowlistValues":
			err = unpopulate(val, "AllowlistValues", &p.AllowlistValues)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &p.IsEnabled)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &p.RuleType)
			delete(rawMsg, key)
		case "valueType":
			err = unpopulate(val, "ValueType", &p.ValueType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectionMode.
func (p ProtectionMode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "exe", p.Exe)
	populate(objectMap, "executable", p.Executable)
	populate(objectMap, "msi", p.Msi)
	populate(objectMap, "script", p.Script)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectionMode.
func (p *ProtectionMode) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exe":
			err = unpopulate(val, "Exe", &p.Exe)
			delete(rawMsg, key)
		case "executable":
			err = unpopulate(val, "Executable", &p.Executable)
			delete(rawMsg, key)
		case "msi":
			err = unpopulate(val, "Msi", &p.Msi)
			delete(rawMsg, key)
		case "script":
			err = unpopulate(val, "Script", &p.Script)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyServerProperties.
func (p ProxyServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ip", p.IP)
	populate(objectMap, "port", p.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyServerProperties.
func (p *ProxyServerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ip":
			err = unpopulate(val, "IP", &p.IP)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &p.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublisherInfo.
func (p PublisherInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "binaryName", p.BinaryName)
	populate(objectMap, "productName", p.ProductName)
	populate(objectMap, "publisherName", p.PublisherName)
	populate(objectMap, "version", p.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublisherInfo.
func (p *PublisherInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "binaryName":
			err = unpopulate(val, "BinaryName", &p.BinaryName)
			delete(rawMsg, key)
		case "productName":
			err = unpopulate(val, "ProductName", &p.ProductName)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &p.PublisherName)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &p.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryCheck.
func (q QueryCheck) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "columnNames", q.ColumnNames)
	populate(objectMap, "expectedResult", q.ExpectedResult)
	populate(objectMap, "query", q.Query)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryCheck.
func (q *QueryCheck) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columnNames":
			err = unpopulate(val, "ColumnNames", &q.ColumnNames)
			delete(rawMsg, key)
		case "expectedResult":
			err = unpopulate(val, "ExpectedResult", &q.ExpectedResult)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &q.Query)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueuePurgesNotInAllowedRange.
func (q QueuePurgesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", q.Description)
	populate(objectMap, "displayName", q.DisplayName)
	populate(objectMap, "isEnabled", q.IsEnabled)
	populate(objectMap, "maxThreshold", q.MaxThreshold)
	populate(objectMap, "minThreshold", q.MinThreshold)
	objectMap["ruleType"] = "QueuePurgesNotInAllowedRange"
	populate(objectMap, "timeWindowSize", q.TimeWindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueuePurgesNotInAllowedRange.
func (q *QueuePurgesNotInAllowedRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &q.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &q.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &q.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &q.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &q.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &q.RuleType)
			delete(rawMsg, key)
		case "timeWindowSize":
			err = unpopulate(val, "TimeWindowSize", &q.TimeWindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendationConfigurationProperties.
func (r RecommendationConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", r.Name)
	populate(objectMap, "recommendationType", r.RecommendationType)
	populate(objectMap, "status", r.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendationConfigurationProperties.
func (r *RecommendationConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "recommendationType":
			err = unpopulate(val, "RecommendationType", &r.RecommendationType)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegulatoryComplianceAssessment.
func (r RegulatoryComplianceAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegulatoryComplianceAssessment.
func (r *RegulatoryComplianceAssessment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegulatoryComplianceAssessmentList.
func (r RegulatoryComplianceAssessmentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegulatoryComplianceAssessmentList.
func (r *RegulatoryComplianceAssessmentList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegulatoryComplianceAssessmentProperties.
func (r RegulatoryComplianceAssessmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assessmentDetailsLink", r.AssessmentDetailsLink)
	populate(objectMap, "assessmentType", r.AssessmentType)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "failedResources", r.FailedResources)
	populate(objectMap, "passedResources", r.PassedResources)
	populate(objectMap, "skippedResources", r.SkippedResources)
	populate(objectMap, "state", r.State)
	populate(objectMap, "unsupportedResources", r.UnsupportedResources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegulatoryComplianceAssessmentProperties.
func (r *RegulatoryComplianceAssessmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentDetailsLink":
			err = unpopulate(val, "AssessmentDetailsLink", &r.AssessmentDetailsLink)
			delete(rawMsg, key)
		case "assessmentType":
			err = unpopulate(val, "AssessmentType", &r.AssessmentType)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "failedResources":
			err = unpopulate(val, "FailedResources", &r.FailedResources)
			delete(rawMsg, key)
		case "passedResources":
			err = unpopulate(val, "PassedResources", &r.PassedResources)
			delete(rawMsg, key)
		case "skippedResources":
			err = unpopulate(val, "SkippedResources", &r.SkippedResources)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &r.State)
			delete(rawMsg, key)
		case "unsupportedResources":
			err = unpopulate(val, "UnsupportedResources", &r.UnsupportedResources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegulatoryComplianceControl.
func (r RegulatoryComplianceControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegulatoryComplianceControl.
func (r *RegulatoryComplianceControl) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegulatoryComplianceControlList.
func (r RegulatoryComplianceControlList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegulatoryComplianceControlList.
func (r *RegulatoryComplianceControlList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegulatoryComplianceControlProperties.
func (r RegulatoryComplianceControlProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", r.Description)
	populate(objectMap, "failedAssessments", r.FailedAssessments)
	populate(objectMap, "passedAssessments", r.PassedAssessments)
	populate(objectMap, "skippedAssessments", r.SkippedAssessments)
	populate(objectMap, "state", r.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegulatoryComplianceControlProperties.
func (r *RegulatoryComplianceControlProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "failedAssessments":
			err = unpopulate(val, "FailedAssessments", &r.FailedAssessments)
			delete(rawMsg, key)
		case "passedAssessments":
			err = unpopulate(val, "PassedAssessments", &r.PassedAssessments)
			delete(rawMsg, key)
		case "skippedAssessments":
			err = unpopulate(val, "SkippedAssessments", &r.SkippedAssessments)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &r.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegulatoryComplianceStandard.
func (r RegulatoryComplianceStandard) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegulatoryComplianceStandard.
func (r *RegulatoryComplianceStandard) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegulatoryComplianceStandardList.
func (r RegulatoryComplianceStandardList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegulatoryComplianceStandardList.
func (r *RegulatoryComplianceStandardList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegulatoryComplianceStandardProperties.
func (r RegulatoryComplianceStandardProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "failedControls", r.FailedControls)
	populate(objectMap, "passedControls", r.PassedControls)
	populate(objectMap, "skippedControls", r.SkippedControls)
	populate(objectMap, "state", r.State)
	populate(objectMap, "unsupportedControls", r.UnsupportedControls)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegulatoryComplianceStandardProperties.
func (r *RegulatoryComplianceStandardProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failedControls":
			err = unpopulate(val, "FailedControls", &r.FailedControls)
			delete(rawMsg, key)
		case "passedControls":
			err = unpopulate(val, "PassedControls", &r.PassedControls)
			delete(rawMsg, key)
		case "skippedControls":
			err = unpopulate(val, "SkippedControls", &r.SkippedControls)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &r.State)
			delete(rawMsg, key)
		case "unsupportedControls":
			err = unpopulate(val, "UnsupportedControls", &r.UnsupportedControls)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Remediation.
func (r Remediation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "automated", r.Automated)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "portalLink", r.PortalLink)
	populate(objectMap, "scripts", r.Scripts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Remediation.
func (r *Remediation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "automated":
			err = unpopulate(val, "Automated", &r.Automated)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "portalLink":
			err = unpopulate(val, "PortalLink", &r.PortalLink)
			delete(rawMsg, key)
		case "scripts":
			err = unpopulate(val, "Scripts", &r.Scripts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemediationEta.
func (r RemediationEta) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "eta", r.Eta)
	populate(objectMap, "justification", r.Justification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemediationEta.
func (r *RemediationEta) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eta":
			err = unpopulateTimeRFC3339(val, "Eta", &r.Eta)
			delete(rawMsg, key)
		case "justification":
			err = unpopulate(val, "Justification", &r.Justification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceDetails.
func (r ResourceDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["source"] = r.Source
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceDetails.
func (r *ResourceDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "source":
			err = unpopulate(val, "Source", &r.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceIdentifier.
func (r ResourceIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["type"] = r.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceIdentifier.
func (r *ResourceIdentifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Rule.
func (r Rule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "destinationPort", r.DestinationPort)
	populate(objectMap, "direction", r.Direction)
	populate(objectMap, "ipAddresses", r.IPAddresses)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "protocols", r.Protocols)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Rule.
func (r *Rule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationPort":
			err = unpopulate(val, "DestinationPort", &r.DestinationPort)
			delete(rawMsg, key)
		case "direction":
			err = unpopulate(val, "Direction", &r.Direction)
			delete(rawMsg, key)
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &r.IPAddresses)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "protocols":
			err = unpopulate(val, "Protocols", &r.Protocols)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RuleResults.
func (r RuleResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleResults.
func (r *RuleResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RuleResultsInput.
func (r RuleResultsInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "latestScan", r.LatestScan)
	populate(objectMap, "results", r.Results)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleResultsInput.
func (r *RuleResultsInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "latestScan":
			err = unpopulate(val, "LatestScan", &r.LatestScan)
			delete(rawMsg, key)
		case "results":
			err = unpopulate(val, "Results", &r.Results)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RuleResultsProperties.
func (r RuleResultsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "results", r.Results)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleResultsProperties.
func (r *RuleResultsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "results":
			err = unpopulate(val, "Results", &r.Results)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RulesResults.
func (r RulesResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RulesResults.
func (r *RulesResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RulesResultsInput.
func (r RulesResultsInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "latestScan", r.LatestScan)
	populate(objectMap, "results", r.Results)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RulesResultsInput.
func (r *RulesResultsInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "latestScan":
			err = unpopulate(val, "LatestScan", &r.LatestScan)
			delete(rawMsg, key)
		case "results":
			err = unpopulate(val, "Results", &r.Results)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLServerVulnerabilityProperties.
func (s SQLServerVulnerabilityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["assessedResourceType"] = AssessedResourceTypeSQLServerVulnerability
	populate(objectMap, "query", s.Query)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLServerVulnerabilityProperties.
func (s *SQLServerVulnerabilityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessedResourceType":
			err = unpopulate(val, "AssessedResourceType", &s.AssessedResourceType)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &s.Query)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Scan.
func (s Scan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Scan.
func (s *Scan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScanProperties.
func (s ScanProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "database", s.Database)
	populateTimeRFC3339(objectMap, "endTime", s.EndTime)
	populate(objectMap, "highSeverityFailedRulesCount", s.HighSeverityFailedRulesCount)
	populate(objectMap, "isBaselineApplied", s.IsBaselineApplied)
	populate(objectMap, "lowSeverityFailedRulesCount", s.LowSeverityFailedRulesCount)
	populate(objectMap, "mediumSeverityFailedRulesCount", s.MediumSeverityFailedRulesCount)
	populate(objectMap, "sqlVersion", s.SQLVersion)
	populate(objectMap, "server", s.Server)
	populateTimeRFC3339(objectMap, "startTime", s.StartTime)
	populate(objectMap, "state", s.State)
	populate(objectMap, "totalFailedRulesCount", s.TotalFailedRulesCount)
	populate(objectMap, "totalPassedRulesCount", s.TotalPassedRulesCount)
	populate(objectMap, "totalRulesCount", s.TotalRulesCount)
	populate(objectMap, "triggerType", s.TriggerType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScanProperties.
func (s *ScanProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "database":
			err = unpopulate(val, "Database", &s.Database)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &s.EndTime)
			delete(rawMsg, key)
		case "highSeverityFailedRulesCount":
			err = unpopulate(val, "HighSeverityFailedRulesCount", &s.HighSeverityFailedRulesCount)
			delete(rawMsg, key)
		case "isBaselineApplied":
			err = unpopulate(val, "IsBaselineApplied", &s.IsBaselineApplied)
			delete(rawMsg, key)
		case "lowSeverityFailedRulesCount":
			err = unpopulate(val, "LowSeverityFailedRulesCount", &s.LowSeverityFailedRulesCount)
			delete(rawMsg, key)
		case "mediumSeverityFailedRulesCount":
			err = unpopulate(val, "MediumSeverityFailedRulesCount", &s.MediumSeverityFailedRulesCount)
			delete(rawMsg, key)
		case "sqlVersion":
			err = unpopulate(val, "SQLVersion", &s.SQLVersion)
			delete(rawMsg, key)
		case "server":
			err = unpopulate(val, "Server", &s.Server)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "totalFailedRulesCount":
			err = unpopulate(val, "TotalFailedRulesCount", &s.TotalFailedRulesCount)
			delete(rawMsg, key)
		case "totalPassedRulesCount":
			err = unpopulate(val, "TotalPassedRulesCount", &s.TotalPassedRulesCount)
			delete(rawMsg, key)
		case "totalRulesCount":
			err = unpopulate(val, "TotalRulesCount", &s.TotalRulesCount)
			delete(rawMsg, key)
		case "triggerType":
			err = unpopulate(val, "TriggerType", &s.TriggerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScanResult.
func (s ScanResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScanResult.
func (s *ScanResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScanResultProperties.
func (s ScanResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "baselineAdjustedResult", s.BaselineAdjustedResult)
	populate(objectMap, "isTrimmed", s.IsTrimmed)
	populate(objectMap, "queryResults", s.QueryResults)
	populate(objectMap, "remediation", s.Remediation)
	populate(objectMap, "ruleId", s.RuleID)
	populate(objectMap, "ruleMetadata", s.RuleMetadata)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScanResultProperties.
func (s *ScanResultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "baselineAdjustedResult":
			err = unpopulate(val, "BaselineAdjustedResult", &s.BaselineAdjustedResult)
			delete(rawMsg, key)
		case "isTrimmed":
			err = unpopulate(val, "IsTrimmed", &s.IsTrimmed)
			delete(rawMsg, key)
		case "queryResults":
			err = unpopulate(val, "QueryResults", &s.QueryResults)
			delete(rawMsg, key)
		case "remediation":
			err = unpopulate(val, "Remediation", &s.Remediation)
			delete(rawMsg, key)
		case "ruleId":
			err = unpopulate(val, "RuleID", &s.RuleID)
			delete(rawMsg, key)
		case "ruleMetadata":
			err = unpopulate(val, "RuleMetadata", &s.RuleMetadata)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScanResults.
func (s ScanResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScanResults.
func (s *ScanResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Scans.
func (s Scans) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Scans.
func (s *Scans) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScopeElement.
func (s ScopeElement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "field", s.Field)
	if s.AdditionalProperties != nil {
		for key, val := range s.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScopeElement.
func (s *ScopeElement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "field":
			err = unpopulate(val, "Field", &s.Field)
			delete(rawMsg, key)
		default:
			if s.AdditionalProperties == nil {
				s.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				s.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScoreDetails.
func (s ScoreDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "current", s.Current)
	populate(objectMap, "max", s.Max)
	populate(objectMap, "percentage", s.Percentage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScoreDetails.
func (s *ScoreDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "current":
			err = unpopulate(val, "Current", &s.Current)
			delete(rawMsg, key)
		case "max":
			err = unpopulate(val, "Max", &s.Max)
			delete(rawMsg, key)
		case "percentage":
			err = unpopulate(val, "Percentage", &s.Percentage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecureScoreControlDefinitionItem.
func (s SecureScoreControlDefinitionItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecureScoreControlDefinitionItem.
func (s *SecureScoreControlDefinitionItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecureScoreControlDefinitionItemProperties.
func (s SecureScoreControlDefinitionItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assessmentDefinitions", s.AssessmentDefinitions)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "maxScore", s.MaxScore)
	populate(objectMap, "source", s.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecureScoreControlDefinitionItemProperties.
func (s *SecureScoreControlDefinitionItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentDefinitions":
			err = unpopulate(val, "AssessmentDefinitions", &s.AssessmentDefinitions)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "maxScore":
			err = unpopulate(val, "MaxScore", &s.MaxScore)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &s.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecureScoreControlDefinitionList.
func (s SecureScoreControlDefinitionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecureScoreControlDefinitionList.
func (s *SecureScoreControlDefinitionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecureScoreControlDefinitionSource.
func (s SecureScoreControlDefinitionSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "sourceType", s.SourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecureScoreControlDefinitionSource.
func (s *SecureScoreControlDefinitionSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sourceType":
			err = unpopulate(val, "SourceType", &s.SourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecureScoreControlDetails.
func (s SecureScoreControlDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecureScoreControlDetails.
func (s *SecureScoreControlDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecureScoreControlList.
func (s SecureScoreControlList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecureScoreControlList.
func (s *SecureScoreControlList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecureScoreControlScore.
func (s SecureScoreControlScore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "current", s.Current)
	populate(objectMap, "max", s.Max)
	populate(objectMap, "percentage", s.Percentage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecureScoreControlScore.
func (s *SecureScoreControlScore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "current":
			err = unpopulate(val, "Current", &s.Current)
			delete(rawMsg, key)
		case "max":
			err = unpopulate(val, "Max", &s.Max)
			delete(rawMsg, key)
		case "percentage":
			err = unpopulate(val, "Percentage", &s.Percentage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecureScoreControlScoreDetails.
func (s SecureScoreControlScoreDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "definition", s.Definition)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "healthyResourceCount", s.HealthyResourceCount)
	populate(objectMap, "notApplicableResourceCount", s.NotApplicableResourceCount)
	populate(objectMap, "score", s.Score)
	populate(objectMap, "unhealthyResourceCount", s.UnhealthyResourceCount)
	populate(objectMap, "weight", s.Weight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecureScoreControlScoreDetails.
func (s *SecureScoreControlScoreDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "definition":
			err = unpopulate(val, "Definition", &s.Definition)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "healthyResourceCount":
			err = unpopulate(val, "HealthyResourceCount", &s.HealthyResourceCount)
			delete(rawMsg, key)
		case "notApplicableResourceCount":
			err = unpopulate(val, "NotApplicableResourceCount", &s.NotApplicableResourceCount)
			delete(rawMsg, key)
		case "score":
			err = unpopulate(val, "Score", &s.Score)
			delete(rawMsg, key)
		case "unhealthyResourceCount":
			err = unpopulate(val, "UnhealthyResourceCount", &s.UnhealthyResourceCount)
			delete(rawMsg, key)
		case "weight":
			err = unpopulate(val, "Weight", &s.Weight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecureScoreItem.
func (s SecureScoreItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecureScoreItem.
func (s *SecureScoreItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecureScoreItemProperties.
func (s SecureScoreItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "score", s.Score)
	populate(objectMap, "weight", s.Weight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecureScoreItemProperties.
func (s *SecureScoreItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "score":
			err = unpopulate(val, "Score", &s.Score)
			delete(rawMsg, key)
		case "weight":
			err = unpopulate(val, "Weight", &s.Weight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecureScoresList.
func (s SecureScoresList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecureScoresList.
func (s *SecureScoresList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SensitivityLabel.
func (s SensitivityLabel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", s.Description)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "enabled", s.Enabled)
	populate(objectMap, "order", s.Order)
	populate(objectMap, "rank", s.Rank)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SensitivityLabel.
func (s *SensitivityLabel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &s.Enabled)
			delete(rawMsg, key)
		case "order":
			err = unpopulate(val, "Order", &s.Order)
			delete(rawMsg, key)
		case "rank":
			err = unpopulate(val, "Rank", &s.Rank)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerVulnerabilityAssessment.
func (s ServerVulnerabilityAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerVulnerabilityAssessment.
func (s *ServerVulnerabilityAssessment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerVulnerabilityAssessmentProperties.
func (s ServerVulnerabilityAssessmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "provisioningState", s.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerVulnerabilityAssessmentProperties.
func (s *ServerVulnerabilityAssessmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerVulnerabilityAssessmentsList.
func (s ServerVulnerabilityAssessmentsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerVulnerabilityAssessmentsList.
func (s *ServerVulnerabilityAssessmentsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerVulnerabilityProperties.
func (s ServerVulnerabilityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["assessedResourceType"] = "ServerVulnerabilityAssessment"
	populate(objectMap, "cve", s.Cve)
	populate(objectMap, "cvss", s.Cvss)
	populate(objectMap, "patchable", s.Patchable)
	populateTimeRFC3339(objectMap, "publishedTime", s.PublishedTime)
	populate(objectMap, "threat", s.Threat)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "vendorReferences", s.VendorReferences)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerVulnerabilityProperties.
func (s *ServerVulnerabilityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessedResourceType":
			err = unpopulate(val, "AssessedResourceType", &s.AssessedResourceType)
			delete(rawMsg, key)
		case "cve":
			err = unpopulate(val, "Cve", &s.Cve)
			delete(rawMsg, key)
		case "cvss":
			err = unpopulate(val, "Cvss", &s.Cvss)
			delete(rawMsg, key)
		case "patchable":
			err = unpopulate(val, "Patchable", &s.Patchable)
			delete(rawMsg, key)
		case "publishedTime":
			err = unpopulateTimeRFC3339(val, "PublishedTime", &s.PublishedTime)
			delete(rawMsg, key)
		case "threat":
			err = unpopulate(val, "Threat", &s.Threat)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "vendorReferences":
			err = unpopulate(val, "VendorReferences", &s.VendorReferences)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServicePrincipalProperties.
func (s ServicePrincipalProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "applicationId", s.ApplicationID)
	populate(objectMap, "secret", s.Secret)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServicePrincipalProperties.
func (s *ServicePrincipalProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationId":
			err = unpopulate(val, "ApplicationID", &s.ApplicationID)
			delete(rawMsg, key)
		case "secret":
			err = unpopulate(val, "Secret", &s.Secret)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Setting.
func (s Setting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	objectMap["kind"] = s.Kind
	populate(objectMap, "name", s.Name)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Setting.
func (s *Setting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SettingsList.
func (s SettingsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SettingsList.
func (s *SettingsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			s.Value, err = unmarshalSettingClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Software.
func (s Software) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Software.
func (s *Software) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftwareProperties.
func (s SoftwareProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deviceId", s.DeviceID)
	populate(objectMap, "endOfSupportDate", s.EndOfSupportDate)
	populate(objectMap, "endOfSupportStatus", s.EndOfSupportStatus)
	populate(objectMap, "firstSeenAt", s.FirstSeenAt)
	populate(objectMap, "numberOfKnownVulnerabilities", s.NumberOfKnownVulnerabilities)
	populate(objectMap, "osPlatform", s.OSPlatform)
	populate(objectMap, "softwareName", s.SoftwareName)
	populate(objectMap, "vendor", s.Vendor)
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftwareProperties.
func (s *SoftwareProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceId":
			err = unpopulate(val, "DeviceID", &s.DeviceID)
			delete(rawMsg, key)
		case "endOfSupportDate":
			err = unpopulate(val, "EndOfSupportDate", &s.EndOfSupportDate)
			delete(rawMsg, key)
		case "endOfSupportStatus":
			err = unpopulate(val, "EndOfSupportStatus", &s.EndOfSupportStatus)
			delete(rawMsg, key)
		case "firstSeenAt":
			err = unpopulate(val, "FirstSeenAt", &s.FirstSeenAt)
			delete(rawMsg, key)
		case "numberOfKnownVulnerabilities":
			err = unpopulate(val, "NumberOfKnownVulnerabilities", &s.NumberOfKnownVulnerabilities)
			delete(rawMsg, key)
		case "osPlatform":
			err = unpopulate(val, "OSPlatform", &s.OSPlatform)
			delete(rawMsg, key)
		case "softwareName":
			err = unpopulate(val, "SoftwareName", &s.SoftwareName)
			delete(rawMsg, key)
		case "vendor":
			err = unpopulate(val, "Vendor", &s.Vendor)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftwaresList.
func (s SoftwaresList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftwaresList.
func (s *SoftwaresList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Solution.
func (s Solution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Solution.
func (s *Solution) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SolutionList.
func (s SolutionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SolutionList.
func (s *SolutionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SolutionProperties.
func (s SolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "protectionStatus", s.ProtectionStatus)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "securityFamily", s.SecurityFamily)
	populate(objectMap, "template", s.Template)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SolutionProperties.
func (s *SolutionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "protectionStatus":
			err = unpopulate(val, "ProtectionStatus", &s.ProtectionStatus)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "securityFamily":
			err = unpopulate(val, "SecurityFamily", &s.SecurityFamily)
			delete(rawMsg, key)
		case "template":
			err = unpopulate(val, "Template", &s.Template)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SolutionsReferenceData.
func (s SolutionsReferenceData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SolutionsReferenceData.
func (s *SolutionsReferenceData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SolutionsReferenceDataList.
func (s SolutionsReferenceDataList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SolutionsReferenceDataList.
func (s *SolutionsReferenceDataList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SolutionsReferenceDataProperties.
func (s SolutionsReferenceDataProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alertVendorName", s.AlertVendorName)
	populate(objectMap, "packageInfoUrl", s.PackageInfoURL)
	populate(objectMap, "productName", s.ProductName)
	populate(objectMap, "publisher", s.Publisher)
	populate(objectMap, "publisherDisplayName", s.PublisherDisplayName)
	populate(objectMap, "securityFamily", s.SecurityFamily)
	populate(objectMap, "template", s.Template)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SolutionsReferenceDataProperties.
func (s *SolutionsReferenceDataProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertVendorName":
			err = unpopulate(val, "AlertVendorName", &s.AlertVendorName)
			delete(rawMsg, key)
		case "packageInfoUrl":
			err = unpopulate(val, "PackageInfoURL", &s.PackageInfoURL)
			delete(rawMsg, key)
		case "productName":
			err = unpopulate(val, "ProductName", &s.ProductName)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &s.Publisher)
			delete(rawMsg, key)
		case "publisherDisplayName":
			err = unpopulate(val, "PublisherDisplayName", &s.PublisherDisplayName)
			delete(rawMsg, key)
		case "securityFamily":
			err = unpopulate(val, "SecurityFamily", &s.SecurityFamily)
			delete(rawMsg, key)
		case "template":
			err = unpopulate(val, "Template", &s.Template)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubAssessment.
func (s SubAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubAssessment.
func (s *SubAssessment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubAssessmentList.
func (s SubAssessmentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubAssessmentList.
func (s *SubAssessmentList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubAssessmentProperties.
func (s SubAssessmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalData", s.AdditionalData)
	populate(objectMap, "category", s.Category)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "impact", s.Impact)
	populate(objectMap, "remediation", s.Remediation)
	populate(objectMap, "resourceDetails", s.ResourceDetails)
	populate(objectMap, "status", s.Status)
	populateTimeRFC3339(objectMap, "timeGenerated", s.TimeGenerated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubAssessmentProperties.
func (s *SubAssessmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			s.AdditionalData, err = unmarshalAdditionalDataClassification(val)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &s.Category)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "impact":
			err = unpopulate(val, "Impact", &s.Impact)
			delete(rawMsg, key)
		case "remediation":
			err = unpopulate(val, "Remediation", &s.Remediation)
			delete(rawMsg, key)
		case "resourceDetails":
			s.ResourceDetails, err = unmarshalResourceDetailsClassification(val)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "timeGenerated":
			err = unpopulateTimeRFC3339(val, "TimeGenerated", &s.TimeGenerated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubAssessmentStatus.
func (s SubAssessmentStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cause", s.Cause)
	populate(objectMap, "code", s.Code)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "severity", s.Severity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubAssessmentStatus.
func (s *SubAssessmentStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cause":
			err = unpopulate(val, "Cause", &s.Cause)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &s.Code)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &s.Severity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SuppressionAlertsScope.
func (s SuppressionAlertsScope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allOf", s.AllOf)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SuppressionAlertsScope.
func (s *SuppressionAlertsScope) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allOf":
			err = unpopulate(val, "AllOf", &s.AllOf)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Tags.
func (t Tags) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Tags.
func (t *Tags) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagsResource.
func (t TagsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagsResource.
func (t *TagsResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Task.
func (t Task) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Task.
func (t *Task) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TaskList.
func (t TaskList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TaskList.
func (t *TaskList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TaskParameters.
func (t TaskParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", t.Name)
	if t.AdditionalProperties != nil {
		for key, val := range t.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TaskParameters.
func (t *TaskParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		default:
			if t.AdditionalProperties == nil {
				t.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				t.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TaskProperties.
func (t TaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTimeUtc", t.CreationTimeUTC)
	populateTimeRFC3339(objectMap, "lastStateChangeTimeUtc", t.LastStateChangeTimeUTC)
	populate(objectMap, "securityTaskParameters", t.SecurityTaskParameters)
	populate(objectMap, "state", t.State)
	populate(objectMap, "subState", t.SubState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TaskProperties.
func (t *TaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTimeUtc":
			err = unpopulateTimeRFC3339(val, "CreationTimeUTC", &t.CreationTimeUTC)
			delete(rawMsg, key)
		case "lastStateChangeTimeUtc":
			err = unpopulateTimeRFC3339(val, "LastStateChangeTimeUTC", &t.LastStateChangeTimeUTC)
			delete(rawMsg, key)
		case "securityTaskParameters":
			err = unpopulate(val, "SecurityTaskParameters", &t.SecurityTaskParameters)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &t.State)
			delete(rawMsg, key)
		case "subState":
			err = unpopulate(val, "SubState", &t.SubState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThresholdCustomAlertRule.
func (t ThresholdCustomAlertRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", t.Description)
	populate(objectMap, "displayName", t.DisplayName)
	populate(objectMap, "isEnabled", t.IsEnabled)
	populate(objectMap, "maxThreshold", t.MaxThreshold)
	populate(objectMap, "minThreshold", t.MinThreshold)
	objectMap["ruleType"] = "ThresholdCustomAlertRule"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThresholdCustomAlertRule.
func (t *ThresholdCustomAlertRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &t.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &t.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &t.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &t.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &t.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &t.RuleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TimeWindowCustomAlertRule.
func (t TimeWindowCustomAlertRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", t.Description)
	populate(objectMap, "displayName", t.DisplayName)
	populate(objectMap, "isEnabled", t.IsEnabled)
	populate(objectMap, "maxThreshold", t.MaxThreshold)
	populate(objectMap, "minThreshold", t.MinThreshold)
	objectMap["ruleType"] = "TimeWindowCustomAlertRule"
	populate(objectMap, "timeWindowSize", t.TimeWindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TimeWindowCustomAlertRule.
func (t *TimeWindowCustomAlertRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &t.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &t.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &t.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &t.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &t.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &t.RuleType)
			delete(rawMsg, key)
		case "timeWindowSize":
			err = unpopulate(val, "TimeWindowSize", &t.TimeWindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TopologyList.
func (t TopologyList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TopologyList.
func (t *TopologyList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TopologyResource.
func (t TopologyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TopologyResource.
func (t *TopologyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TopologyResourceProperties.
func (t TopologyResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "calculatedDateTime", t.CalculatedDateTime)
	populate(objectMap, "topologyResources", t.TopologyResources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TopologyResourceProperties.
func (t *TopologyResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "calculatedDateTime":
			err = unpopulateTimeRFC3339(val, "CalculatedDateTime", &t.CalculatedDateTime)
			delete(rawMsg, key)
		case "topologyResources":
			err = unpopulate(val, "TopologyResources", &t.TopologyResources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TopologySingleResource.
func (t TopologySingleResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "children", t.Children)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "networkZones", t.NetworkZones)
	populate(objectMap, "parents", t.Parents)
	populate(objectMap, "recommendationsExist", t.RecommendationsExist)
	populate(objectMap, "resourceId", t.ResourceID)
	populate(objectMap, "severity", t.Severity)
	populate(objectMap, "topologyScore", t.TopologyScore)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TopologySingleResource.
func (t *TopologySingleResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "children":
			err = unpopulate(val, "Children", &t.Children)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "networkZones":
			err = unpopulate(val, "NetworkZones", &t.NetworkZones)
			delete(rawMsg, key)
		case "parents":
			err = unpopulate(val, "Parents", &t.Parents)
			delete(rawMsg, key)
		case "recommendationsExist":
			err = unpopulate(val, "RecommendationsExist", &t.RecommendationsExist)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &t.ResourceID)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &t.Severity)
			delete(rawMsg, key)
		case "topologyScore":
			err = unpopulate(val, "TopologyScore", &t.TopologyScore)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TopologySingleResourceChild.
func (t TopologySingleResourceChild) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "resourceId", t.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TopologySingleResourceChild.
func (t *TopologySingleResourceChild) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceId":
			err = unpopulate(val, "ResourceID", &t.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TopologySingleResourceParent.
func (t TopologySingleResourceParent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "resourceId", t.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TopologySingleResourceParent.
func (t *TopologySingleResourceParent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceId":
			err = unpopulate(val, "ResourceID", &t.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", t.Etag)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "kind", t.Kind)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &t.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &t.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TwinUpdatesNotInAllowedRange.
func (t TwinUpdatesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", t.Description)
	populate(objectMap, "displayName", t.DisplayName)
	populate(objectMap, "isEnabled", t.IsEnabled)
	populate(objectMap, "maxThreshold", t.MaxThreshold)
	populate(objectMap, "minThreshold", t.MinThreshold)
	objectMap["ruleType"] = "TwinUpdatesNotInAllowedRange"
	populate(objectMap, "timeWindowSize", t.TimeWindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TwinUpdatesNotInAllowedRange.
func (t *TwinUpdatesNotInAllowedRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &t.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &t.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &t.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &t.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &t.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &t.RuleType)
			delete(rawMsg, key)
		case "timeWindowSize":
			err = unpopulate(val, "TimeWindowSize", &t.TimeWindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UnauthorizedOperationsNotInAllowedRange.
func (u UnauthorizedOperationsNotInAllowedRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", u.Description)
	populate(objectMap, "displayName", u.DisplayName)
	populate(objectMap, "isEnabled", u.IsEnabled)
	populate(objectMap, "maxThreshold", u.MaxThreshold)
	populate(objectMap, "minThreshold", u.MinThreshold)
	objectMap["ruleType"] = "UnauthorizedOperationsNotInAllowedRange"
	populate(objectMap, "timeWindowSize", u.TimeWindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UnauthorizedOperationsNotInAllowedRange.
func (u *UnauthorizedOperationsNotInAllowedRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &u.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &u.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &u.IsEnabled)
			delete(rawMsg, key)
		case "maxThreshold":
			err = unpopulate(val, "MaxThreshold", &u.MaxThreshold)
			delete(rawMsg, key)
		case "minThreshold":
			err = unpopulate(val, "MinThreshold", &u.MinThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &u.RuleType)
			delete(rawMsg, key)
		case "timeWindowSize":
			err = unpopulate(val, "TimeWindowSize", &u.TimeWindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateIoTSecuritySolutionProperties.
func (u UpdateIoTSecuritySolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "recommendationsConfiguration", u.RecommendationsConfiguration)
	populate(objectMap, "userDefinedResources", u.UserDefinedResources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateIoTSecuritySolutionProperties.
func (u *UpdateIoTSecuritySolutionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recommendationsConfiguration":
			err = unpopulate(val, "RecommendationsConfiguration", &u.RecommendationsConfiguration)
			delete(rawMsg, key)
		case "userDefinedResources":
			err = unpopulate(val, "UserDefinedResources", &u.UserDefinedResources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateIotSecuritySolutionData.
func (u UpdateIotSecuritySolutionData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateIotSecuritySolutionData.
func (u *UpdateIotSecuritySolutionData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserDefinedResourcesProperties.
func (u UserDefinedResourcesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "query", u.Query)
	populate(objectMap, "querySubscriptions", u.QuerySubscriptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserDefinedResourcesProperties.
func (u *UserDefinedResourcesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "query":
			err = unpopulate(val, "Query", &u.Query)
			delete(rawMsg, key)
		case "querySubscriptions":
			err = unpopulate(val, "QuerySubscriptions", &u.QuerySubscriptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserRecommendation.
func (u UserRecommendation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "recommendationAction", u.RecommendationAction)
	populate(objectMap, "username", u.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserRecommendation.
func (u *UserRecommendation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recommendationAction":
			err = unpopulate(val, "RecommendationAction", &u.RecommendationAction)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &u.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMRecommendation.
func (v VMRecommendation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configurationStatus", v.ConfigurationStatus)
	populate(objectMap, "enforcementSupport", v.EnforcementSupport)
	populate(objectMap, "recommendationAction", v.RecommendationAction)
	populate(objectMap, "resourceId", v.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMRecommendation.
func (v *VMRecommendation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationStatus":
			err = unpopulate(val, "ConfigurationStatus", &v.ConfigurationStatus)
			delete(rawMsg, key)
		case "enforcementSupport":
			err = unpopulate(val, "EnforcementSupport", &v.EnforcementSupport)
			delete(rawMsg, key)
		case "recommendationAction":
			err = unpopulate(val, "RecommendationAction", &v.RecommendationAction)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &v.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaRule.
func (v VaRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "benchmarkReferences", v.BenchmarkReferences)
	populate(objectMap, "category", v.Category)
	populate(objectMap, "description", v.Description)
	populate(objectMap, "queryCheck", v.QueryCheck)
	populate(objectMap, "rationale", v.Rationale)
	populate(objectMap, "ruleId", v.RuleID)
	populate(objectMap, "ruleType", v.RuleType)
	populate(objectMap, "severity", v.Severity)
	populate(objectMap, "title", v.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaRule.
func (v *VaRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "benchmarkReferences":
			err = unpopulate(val, "BenchmarkReferences", &v.BenchmarkReferences)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &v.Category)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &v.Description)
			delete(rawMsg, key)
		case "queryCheck":
			err = unpopulate(val, "QueryCheck", &v.QueryCheck)
			delete(rawMsg, key)
		case "rationale":
			err = unpopulate(val, "Rationale", &v.Rationale)
			delete(rawMsg, key)
		case "ruleId":
			err = unpopulate(val, "RuleID", &v.RuleID)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &v.RuleType)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &v.Severity)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &v.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VendorReference.
func (v VendorReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "link", v.Link)
	populate(objectMap, "title", v.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VendorReference.
func (v *VendorReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "link":
			err = unpopulate(val, "Link", &v.Link)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &v.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceSetting.
func (w WorkspaceSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceSetting.
func (w *WorkspaceSetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceSettingList.
func (w WorkspaceSettingList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceSettingList.
func (w *WorkspaceSettingList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceSettingProperties.
func (w WorkspaceSettingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "scope", w.Scope)
	populate(objectMap, "workspaceId", w.WorkspaceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceSettingProperties.
func (w *WorkspaceSettingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scope":
			err = unpopulate(val, "Scope", &w.Scope)
			delete(rawMsg, key)
		case "workspaceId":
			err = unpopulate(val, "WorkspaceID", &w.WorkspaceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateByteArray(m map[string]interface{}, k string, b []byte, f runtime.Base64Encoding) {
	if azcore.IsNullValue(b) {
		m[k] = nil
	} else if len(b) == 0 {
		return
	} else {
		m[k] = runtime.EncodeByteArray(b, f)
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
