// Code generated by smithy-go-codegen DO NOT EDIT.

package appmesh

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/appmesh/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCreateGatewayRoute struct {
}

func (*awsRestjson1_serializeOpCreateGatewayRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateGatewayRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateGatewayRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateGatewayRouteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateGatewayRouteInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateGatewayRouteInput(v *CreateGatewayRouteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.VirtualGatewayName == nil || len(*v.VirtualGatewayName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualGatewayName must not be empty")}
	}
	if v.VirtualGatewayName != nil {
		if err := encoder.SetURI("virtualGatewayName").String(*v.VirtualGatewayName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateGatewayRouteInput(v *CreateGatewayRouteInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.GatewayRouteName != nil {
		ok := object.Key("gatewayRouteName")
		ok.String(*v.GatewayRouteName)
	}

	if v.Spec != nil {
		ok := object.Key("spec")
		if err := awsRestjson1_serializeDocumentGatewayRouteSpec(v.Spec, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateMesh struct {
}

func (*awsRestjson1_serializeOpCreateMesh) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateMesh) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMeshInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateMeshInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateMeshInput(v *CreateMeshInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateMeshInput(v *CreateMeshInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.MeshName != nil {
		ok := object.Key("meshName")
		ok.String(*v.MeshName)
	}

	if v.Spec != nil {
		ok := object.Key("spec")
		if err := awsRestjson1_serializeDocumentMeshSpec(v.Spec, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateRoute struct {
}

func (*awsRestjson1_serializeOpCreateRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateRouteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateRouteInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateRouteInput(v *CreateRouteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.VirtualRouterName == nil || len(*v.VirtualRouterName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualRouterName must not be empty")}
	}
	if v.VirtualRouterName != nil {
		if err := encoder.SetURI("virtualRouterName").String(*v.VirtualRouterName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateRouteInput(v *CreateRouteInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.RouteName != nil {
		ok := object.Key("routeName")
		ok.String(*v.RouteName)
	}

	if v.Spec != nil {
		ok := object.Key("spec")
		if err := awsRestjson1_serializeDocumentRouteSpec(v.Spec, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateVirtualGateway struct {
}

func (*awsRestjson1_serializeOpCreateVirtualGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateVirtualGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVirtualGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualGateways")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateVirtualGatewayInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateVirtualGatewayInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateVirtualGatewayInput(v *CreateVirtualGatewayInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateVirtualGatewayInput(v *CreateVirtualGatewayInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Spec != nil {
		ok := object.Key("spec")
		if err := awsRestjson1_serializeDocumentVirtualGatewaySpec(v.Spec, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VirtualGatewayName != nil {
		ok := object.Key("virtualGatewayName")
		ok.String(*v.VirtualGatewayName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateVirtualNode struct {
}

func (*awsRestjson1_serializeOpCreateVirtualNode) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateVirtualNode) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVirtualNodeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualNodes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateVirtualNodeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateVirtualNodeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateVirtualNodeInput(v *CreateVirtualNodeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateVirtualNodeInput(v *CreateVirtualNodeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Spec != nil {
		ok := object.Key("spec")
		if err := awsRestjson1_serializeDocumentVirtualNodeSpec(v.Spec, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VirtualNodeName != nil {
		ok := object.Key("virtualNodeName")
		ok.String(*v.VirtualNodeName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateVirtualRouter struct {
}

func (*awsRestjson1_serializeOpCreateVirtualRouter) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateVirtualRouter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVirtualRouterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualRouters")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateVirtualRouterInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateVirtualRouterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateVirtualRouterInput(v *CreateVirtualRouterInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateVirtualRouterInput(v *CreateVirtualRouterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Spec != nil {
		ok := object.Key("spec")
		if err := awsRestjson1_serializeDocumentVirtualRouterSpec(v.Spec, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VirtualRouterName != nil {
		ok := object.Key("virtualRouterName")
		ok.String(*v.VirtualRouterName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateVirtualService struct {
}

func (*awsRestjson1_serializeOpCreateVirtualService) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateVirtualService) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVirtualServiceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualServices")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateVirtualServiceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateVirtualServiceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateVirtualServiceInput(v *CreateVirtualServiceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateVirtualServiceInput(v *CreateVirtualServiceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Spec != nil {
		ok := object.Key("spec")
		if err := awsRestjson1_serializeDocumentVirtualServiceSpec(v.Spec, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VirtualServiceName != nil {
		ok := object.Key("virtualServiceName")
		ok.String(*v.VirtualServiceName)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteGatewayRoute struct {
}

func (*awsRestjson1_serializeOpDeleteGatewayRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteGatewayRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteGatewayRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes/{gatewayRouteName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteGatewayRouteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteGatewayRouteInput(v *DeleteGatewayRouteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GatewayRouteName == nil || len(*v.GatewayRouteName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member gatewayRouteName must not be empty")}
	}
	if v.GatewayRouteName != nil {
		if err := encoder.SetURI("gatewayRouteName").String(*v.GatewayRouteName); err != nil {
			return err
		}
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.VirtualGatewayName == nil || len(*v.VirtualGatewayName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualGatewayName must not be empty")}
	}
	if v.VirtualGatewayName != nil {
		if err := encoder.SetURI("virtualGatewayName").String(*v.VirtualGatewayName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteMesh struct {
}

func (*awsRestjson1_serializeOpDeleteMesh) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteMesh) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMeshInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteMeshInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteMeshInput(v *DeleteMeshInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRoute struct {
}

func (*awsRestjson1_serializeOpDeleteRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRouteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRouteInput(v *DeleteRouteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.RouteName == nil || len(*v.RouteName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member routeName must not be empty")}
	}
	if v.RouteName != nil {
		if err := encoder.SetURI("routeName").String(*v.RouteName); err != nil {
			return err
		}
	}

	if v.VirtualRouterName == nil || len(*v.VirtualRouterName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualRouterName must not be empty")}
	}
	if v.VirtualRouterName != nil {
		if err := encoder.SetURI("virtualRouterName").String(*v.VirtualRouterName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteVirtualGateway struct {
}

func (*awsRestjson1_serializeOpDeleteVirtualGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteVirtualGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVirtualGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualGateways/{virtualGatewayName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteVirtualGatewayInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteVirtualGatewayInput(v *DeleteVirtualGatewayInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.VirtualGatewayName == nil || len(*v.VirtualGatewayName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualGatewayName must not be empty")}
	}
	if v.VirtualGatewayName != nil {
		if err := encoder.SetURI("virtualGatewayName").String(*v.VirtualGatewayName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteVirtualNode struct {
}

func (*awsRestjson1_serializeOpDeleteVirtualNode) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteVirtualNode) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVirtualNodeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteVirtualNodeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteVirtualNodeInput(v *DeleteVirtualNodeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.VirtualNodeName == nil || len(*v.VirtualNodeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualNodeName must not be empty")}
	}
	if v.VirtualNodeName != nil {
		if err := encoder.SetURI("virtualNodeName").String(*v.VirtualNodeName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteVirtualRouter struct {
}

func (*awsRestjson1_serializeOpDeleteVirtualRouter) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteVirtualRouter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVirtualRouterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteVirtualRouterInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteVirtualRouterInput(v *DeleteVirtualRouterInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.VirtualRouterName == nil || len(*v.VirtualRouterName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualRouterName must not be empty")}
	}
	if v.VirtualRouterName != nil {
		if err := encoder.SetURI("virtualRouterName").String(*v.VirtualRouterName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteVirtualService struct {
}

func (*awsRestjson1_serializeOpDeleteVirtualService) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteVirtualService) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVirtualServiceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteVirtualServiceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteVirtualServiceInput(v *DeleteVirtualServiceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.VirtualServiceName == nil || len(*v.VirtualServiceName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualServiceName must not be empty")}
	}
	if v.VirtualServiceName != nil {
		if err := encoder.SetURI("virtualServiceName").String(*v.VirtualServiceName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeGatewayRoute struct {
}

func (*awsRestjson1_serializeOpDescribeGatewayRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeGatewayRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGatewayRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes/{gatewayRouteName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeGatewayRouteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeGatewayRouteInput(v *DescribeGatewayRouteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GatewayRouteName == nil || len(*v.GatewayRouteName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member gatewayRouteName must not be empty")}
	}
	if v.GatewayRouteName != nil {
		if err := encoder.SetURI("gatewayRouteName").String(*v.GatewayRouteName); err != nil {
			return err
		}
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.VirtualGatewayName == nil || len(*v.VirtualGatewayName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualGatewayName must not be empty")}
	}
	if v.VirtualGatewayName != nil {
		if err := encoder.SetURI("virtualGatewayName").String(*v.VirtualGatewayName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeMesh struct {
}

func (*awsRestjson1_serializeOpDescribeMesh) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeMesh) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeMeshInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeMeshInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeMeshInput(v *DescribeMeshInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeRoute struct {
}

func (*awsRestjson1_serializeOpDescribeRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeRouteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeRouteInput(v *DescribeRouteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.RouteName == nil || len(*v.RouteName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member routeName must not be empty")}
	}
	if v.RouteName != nil {
		if err := encoder.SetURI("routeName").String(*v.RouteName); err != nil {
			return err
		}
	}

	if v.VirtualRouterName == nil || len(*v.VirtualRouterName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualRouterName must not be empty")}
	}
	if v.VirtualRouterName != nil {
		if err := encoder.SetURI("virtualRouterName").String(*v.VirtualRouterName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeVirtualGateway struct {
}

func (*awsRestjson1_serializeOpDescribeVirtualGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeVirtualGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVirtualGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualGateways/{virtualGatewayName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeVirtualGatewayInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeVirtualGatewayInput(v *DescribeVirtualGatewayInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.VirtualGatewayName == nil || len(*v.VirtualGatewayName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualGatewayName must not be empty")}
	}
	if v.VirtualGatewayName != nil {
		if err := encoder.SetURI("virtualGatewayName").String(*v.VirtualGatewayName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeVirtualNode struct {
}

func (*awsRestjson1_serializeOpDescribeVirtualNode) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeVirtualNode) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVirtualNodeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeVirtualNodeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeVirtualNodeInput(v *DescribeVirtualNodeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.VirtualNodeName == nil || len(*v.VirtualNodeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualNodeName must not be empty")}
	}
	if v.VirtualNodeName != nil {
		if err := encoder.SetURI("virtualNodeName").String(*v.VirtualNodeName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeVirtualRouter struct {
}

func (*awsRestjson1_serializeOpDescribeVirtualRouter) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeVirtualRouter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVirtualRouterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeVirtualRouterInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeVirtualRouterInput(v *DescribeVirtualRouterInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.VirtualRouterName == nil || len(*v.VirtualRouterName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualRouterName must not be empty")}
	}
	if v.VirtualRouterName != nil {
		if err := encoder.SetURI("virtualRouterName").String(*v.VirtualRouterName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeVirtualService struct {
}

func (*awsRestjson1_serializeOpDescribeVirtualService) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeVirtualService) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVirtualServiceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeVirtualServiceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeVirtualServiceInput(v *DescribeVirtualServiceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.VirtualServiceName == nil || len(*v.VirtualServiceName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualServiceName must not be empty")}
	}
	if v.VirtualServiceName != nil {
		if err := encoder.SetURI("virtualServiceName").String(*v.VirtualServiceName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListGatewayRoutes struct {
}

func (*awsRestjson1_serializeOpListGatewayRoutes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListGatewayRoutes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGatewayRoutesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListGatewayRoutesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListGatewayRoutesInput(v *ListGatewayRoutesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Limit != nil {
		encoder.SetQuery("limit").Integer(*v.Limit)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.VirtualGatewayName == nil || len(*v.VirtualGatewayName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualGatewayName must not be empty")}
	}
	if v.VirtualGatewayName != nil {
		if err := encoder.SetURI("virtualGatewayName").String(*v.VirtualGatewayName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListMeshes struct {
}

func (*awsRestjson1_serializeOpListMeshes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMeshes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMeshesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListMeshesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMeshesInput(v *ListMeshesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Limit != nil {
		encoder.SetQuery("limit").Integer(*v.Limit)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListRoutes struct {
}

func (*awsRestjson1_serializeOpListRoutes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRoutes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRoutesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRoutesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRoutesInput(v *ListRoutesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Limit != nil {
		encoder.SetQuery("limit").Integer(*v.Limit)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.VirtualRouterName == nil || len(*v.VirtualRouterName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualRouterName must not be empty")}
	}
	if v.VirtualRouterName != nil {
		if err := encoder.SetURI("virtualRouterName").String(*v.VirtualRouterName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Limit != nil {
		encoder.SetQuery("limit").Integer(*v.Limit)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.ResourceArn != nil {
		encoder.SetQuery("resourceArn").String(*v.ResourceArn)
	}

	return nil
}

type awsRestjson1_serializeOpListVirtualGateways struct {
}

func (*awsRestjson1_serializeOpListVirtualGateways) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListVirtualGateways) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListVirtualGatewaysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualGateways")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListVirtualGatewaysInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListVirtualGatewaysInput(v *ListVirtualGatewaysInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Limit != nil {
		encoder.SetQuery("limit").Integer(*v.Limit)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListVirtualNodes struct {
}

func (*awsRestjson1_serializeOpListVirtualNodes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListVirtualNodes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListVirtualNodesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualNodes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListVirtualNodesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListVirtualNodesInput(v *ListVirtualNodesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Limit != nil {
		encoder.SetQuery("limit").Integer(*v.Limit)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListVirtualRouters struct {
}

func (*awsRestjson1_serializeOpListVirtualRouters) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListVirtualRouters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListVirtualRoutersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualRouters")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListVirtualRoutersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListVirtualRoutersInput(v *ListVirtualRoutersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Limit != nil {
		encoder.SetQuery("limit").Integer(*v.Limit)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListVirtualServices struct {
}

func (*awsRestjson1_serializeOpListVirtualServices) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListVirtualServices) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListVirtualServicesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualServices")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListVirtualServicesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListVirtualServicesInput(v *ListVirtualServicesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Limit != nil {
		encoder.SetQuery("limit").Integer(*v.Limit)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/tag")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn != nil {
		encoder.SetQuery("resourceArn").String(*v.ResourceArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/untag")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn != nil {
		encoder.SetQuery("resourceArn").String(*v.ResourceArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TagKeys != nil {
		ok := object.Key("tagKeys")
		if err := awsRestjson1_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateGatewayRoute struct {
}

func (*awsRestjson1_serializeOpUpdateGatewayRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateGatewayRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateGatewayRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes/{gatewayRouteName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateGatewayRouteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateGatewayRouteInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateGatewayRouteInput(v *UpdateGatewayRouteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GatewayRouteName == nil || len(*v.GatewayRouteName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member gatewayRouteName must not be empty")}
	}
	if v.GatewayRouteName != nil {
		if err := encoder.SetURI("gatewayRouteName").String(*v.GatewayRouteName); err != nil {
			return err
		}
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.VirtualGatewayName == nil || len(*v.VirtualGatewayName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualGatewayName must not be empty")}
	}
	if v.VirtualGatewayName != nil {
		if err := encoder.SetURI("virtualGatewayName").String(*v.VirtualGatewayName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateGatewayRouteInput(v *UpdateGatewayRouteInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Spec != nil {
		ok := object.Key("spec")
		if err := awsRestjson1_serializeDocumentGatewayRouteSpec(v.Spec, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateMesh struct {
}

func (*awsRestjson1_serializeOpUpdateMesh) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateMesh) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateMeshInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateMeshInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateMeshInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateMeshInput(v *UpdateMeshInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateMeshInput(v *UpdateMeshInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Spec != nil {
		ok := object.Key("spec")
		if err := awsRestjson1_serializeDocumentMeshSpec(v.Spec, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRoute struct {
}

func (*awsRestjson1_serializeOpUpdateRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRouteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRouteInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRouteInput(v *UpdateRouteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.RouteName == nil || len(*v.RouteName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member routeName must not be empty")}
	}
	if v.RouteName != nil {
		if err := encoder.SetURI("routeName").String(*v.RouteName); err != nil {
			return err
		}
	}

	if v.VirtualRouterName == nil || len(*v.VirtualRouterName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualRouterName must not be empty")}
	}
	if v.VirtualRouterName != nil {
		if err := encoder.SetURI("virtualRouterName").String(*v.VirtualRouterName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRouteInput(v *UpdateRouteInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Spec != nil {
		ok := object.Key("spec")
		if err := awsRestjson1_serializeDocumentRouteSpec(v.Spec, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateVirtualGateway struct {
}

func (*awsRestjson1_serializeOpUpdateVirtualGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateVirtualGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateVirtualGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualGateways/{virtualGatewayName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateVirtualGatewayInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateVirtualGatewayInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateVirtualGatewayInput(v *UpdateVirtualGatewayInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.VirtualGatewayName == nil || len(*v.VirtualGatewayName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualGatewayName must not be empty")}
	}
	if v.VirtualGatewayName != nil {
		if err := encoder.SetURI("virtualGatewayName").String(*v.VirtualGatewayName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateVirtualGatewayInput(v *UpdateVirtualGatewayInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Spec != nil {
		ok := object.Key("spec")
		if err := awsRestjson1_serializeDocumentVirtualGatewaySpec(v.Spec, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateVirtualNode struct {
}

func (*awsRestjson1_serializeOpUpdateVirtualNode) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateVirtualNode) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateVirtualNodeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateVirtualNodeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateVirtualNodeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateVirtualNodeInput(v *UpdateVirtualNodeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.VirtualNodeName == nil || len(*v.VirtualNodeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualNodeName must not be empty")}
	}
	if v.VirtualNodeName != nil {
		if err := encoder.SetURI("virtualNodeName").String(*v.VirtualNodeName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateVirtualNodeInput(v *UpdateVirtualNodeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Spec != nil {
		ok := object.Key("spec")
		if err := awsRestjson1_serializeDocumentVirtualNodeSpec(v.Spec, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateVirtualRouter struct {
}

func (*awsRestjson1_serializeOpUpdateVirtualRouter) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateVirtualRouter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateVirtualRouterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateVirtualRouterInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateVirtualRouterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateVirtualRouterInput(v *UpdateVirtualRouterInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.VirtualRouterName == nil || len(*v.VirtualRouterName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualRouterName must not be empty")}
	}
	if v.VirtualRouterName != nil {
		if err := encoder.SetURI("virtualRouterName").String(*v.VirtualRouterName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateVirtualRouterInput(v *UpdateVirtualRouterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Spec != nil {
		ok := object.Key("spec")
		if err := awsRestjson1_serializeDocumentVirtualRouterSpec(v.Spec, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateVirtualService struct {
}

func (*awsRestjson1_serializeOpUpdateVirtualService) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateVirtualService) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateVirtualServiceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateVirtualServiceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateVirtualServiceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateVirtualServiceInput(v *UpdateVirtualServiceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MeshName == nil || len(*v.MeshName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member meshName must not be empty")}
	}
	if v.MeshName != nil {
		if err := encoder.SetURI("meshName").String(*v.MeshName); err != nil {
			return err
		}
	}

	if v.MeshOwner != nil {
		encoder.SetQuery("meshOwner").String(*v.MeshOwner)
	}

	if v.VirtualServiceName == nil || len(*v.VirtualServiceName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member virtualServiceName must not be empty")}
	}
	if v.VirtualServiceName != nil {
		if err := encoder.SetURI("virtualServiceName").String(*v.VirtualServiceName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateVirtualServiceInput(v *UpdateVirtualServiceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Spec != nil {
		ok := object.Key("spec")
		if err := awsRestjson1_serializeDocumentVirtualServiceSpec(v.Spec, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAccessLog(v types.AccessLog, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.AccessLogMemberFile:
		av := object.Key("file")
		if err := awsRestjson1_serializeDocumentFileAccessLog(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentAwsCloudMapInstanceAttribute(v *types.AwsCloudMapInstanceAttribute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCloudMapInstanceAttributes(v []types.AwsCloudMapInstanceAttribute, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsCloudMapInstanceAttribute(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsCloudMapServiceDiscovery(v *types.AwsCloudMapServiceDiscovery, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsRestjson1_serializeDocumentAwsCloudMapInstanceAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	if len(v.IpPreference) > 0 {
		ok := object.Key("ipPreference")
		ok.String(string(v.IpPreference))
	}

	if v.NamespaceName != nil {
		ok := object.Key("namespaceName")
		ok.String(*v.NamespaceName)
	}

	if v.ServiceName != nil {
		ok := object.Key("serviceName")
		ok.String(*v.ServiceName)
	}

	return nil
}

func awsRestjson1_serializeDocumentBackend(v types.Backend, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.BackendMemberVirtualService:
		av := object.Key("virtualService")
		if err := awsRestjson1_serializeDocumentVirtualServiceBackend(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentBackendDefaults(v *types.BackendDefaults, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientPolicy != nil {
		ok := object.Key("clientPolicy")
		if err := awsRestjson1_serializeDocumentClientPolicy(v.ClientPolicy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBackends(v []types.Backend, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentBackend(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCertificateAuthorityArns(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentClientPolicy(v *types.ClientPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tls != nil {
		ok := object.Key("tls")
		if err := awsRestjson1_serializeDocumentClientPolicyTls(v.Tls, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentClientPolicyTls(v *types.ClientPolicyTls, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Certificate != nil {
		ok := object.Key("certificate")
		if err := awsRestjson1_serializeDocumentClientTlsCertificate(v.Certificate, ok); err != nil {
			return err
		}
	}

	if v.Enforce != nil {
		ok := object.Key("enforce")
		ok.Boolean(*v.Enforce)
	}

	if v.Ports != nil {
		ok := object.Key("ports")
		if err := awsRestjson1_serializeDocumentPortSet(v.Ports, ok); err != nil {
			return err
		}
	}

	if v.Validation != nil {
		ok := object.Key("validation")
		if err := awsRestjson1_serializeDocumentTlsValidationContext(v.Validation, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentClientTlsCertificate(v types.ClientTlsCertificate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ClientTlsCertificateMemberFile:
		av := object.Key("file")
		if err := awsRestjson1_serializeDocumentListenerTlsFileCertificate(&uv.Value, av); err != nil {
			return err
		}

	case *types.ClientTlsCertificateMemberSds:
		av := object.Key("sds")
		if err := awsRestjson1_serializeDocumentListenerTlsSdsCertificate(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentDnsServiceDiscovery(v *types.DnsServiceDiscovery, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Hostname != nil {
		ok := object.Key("hostname")
		ok.String(*v.Hostname)
	}

	if len(v.IpPreference) > 0 {
		ok := object.Key("ipPreference")
		ok.String(string(v.IpPreference))
	}

	if len(v.ResponseType) > 0 {
		ok := object.Key("responseType")
		ok.String(string(v.ResponseType))
	}

	return nil
}

func awsRestjson1_serializeDocumentDuration(v *types.Duration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Unit) > 0 {
		ok := object.Key("unit")
		ok.String(string(v.Unit))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.Long(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentEgressFilter(v *types.EgressFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentFileAccessLog(v *types.FileAccessLog, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Path != nil {
		ok := object.Key("path")
		ok.String(*v.Path)
	}

	return nil
}

func awsRestjson1_serializeDocumentGatewayRouteHostnameMatch(v *types.GatewayRouteHostnameMatch, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Exact != nil {
		ok := object.Key("exact")
		ok.String(*v.Exact)
	}

	if v.Suffix != nil {
		ok := object.Key("suffix")
		ok.String(*v.Suffix)
	}

	return nil
}

func awsRestjson1_serializeDocumentGatewayRouteHostnameRewrite(v *types.GatewayRouteHostnameRewrite, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DefaultTargetHostname) > 0 {
		ok := object.Key("defaultTargetHostname")
		ok.String(string(v.DefaultTargetHostname))
	}

	return nil
}

func awsRestjson1_serializeDocumentGatewayRouteSpec(v *types.GatewayRouteSpec, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrpcRoute != nil {
		ok := object.Key("grpcRoute")
		if err := awsRestjson1_serializeDocumentGrpcGatewayRoute(v.GrpcRoute, ok); err != nil {
			return err
		}
	}

	if v.Http2Route != nil {
		ok := object.Key("http2Route")
		if err := awsRestjson1_serializeDocumentHttpGatewayRoute(v.Http2Route, ok); err != nil {
			return err
		}
	}

	if v.HttpRoute != nil {
		ok := object.Key("httpRoute")
		if err := awsRestjson1_serializeDocumentHttpGatewayRoute(v.HttpRoute, ok); err != nil {
			return err
		}
	}

	if v.Priority != nil {
		ok := object.Key("priority")
		ok.Integer(*v.Priority)
	}

	return nil
}

func awsRestjson1_serializeDocumentGatewayRouteTarget(v *types.GatewayRouteTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VirtualService != nil {
		ok := object.Key("virtualService")
		if err := awsRestjson1_serializeDocumentGatewayRouteVirtualService(v.VirtualService, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGatewayRouteVirtualService(v *types.GatewayRouteVirtualService, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VirtualServiceName != nil {
		ok := object.Key("virtualServiceName")
		ok.String(*v.VirtualServiceName)
	}

	return nil
}

func awsRestjson1_serializeDocumentGrpcGatewayRoute(v *types.GrpcGatewayRoute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("action")
		if err := awsRestjson1_serializeDocumentGrpcGatewayRouteAction(v.Action, ok); err != nil {
			return err
		}
	}

	if v.Match != nil {
		ok := object.Key("match")
		if err := awsRestjson1_serializeDocumentGrpcGatewayRouteMatch(v.Match, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGrpcGatewayRouteAction(v *types.GrpcGatewayRouteAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Rewrite != nil {
		ok := object.Key("rewrite")
		if err := awsRestjson1_serializeDocumentGrpcGatewayRouteRewrite(v.Rewrite, ok); err != nil {
			return err
		}
	}

	if v.Target != nil {
		ok := object.Key("target")
		if err := awsRestjson1_serializeDocumentGatewayRouteTarget(v.Target, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGrpcGatewayRouteMatch(v *types.GrpcGatewayRouteMatch, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Hostname != nil {
		ok := object.Key("hostname")
		if err := awsRestjson1_serializeDocumentGatewayRouteHostnameMatch(v.Hostname, ok); err != nil {
			return err
		}
	}

	if v.Metadata != nil {
		ok := object.Key("metadata")
		if err := awsRestjson1_serializeDocumentGrpcGatewayRouteMetadataList(v.Metadata, ok); err != nil {
			return err
		}
	}

	if v.ServiceName != nil {
		ok := object.Key("serviceName")
		ok.String(*v.ServiceName)
	}

	return nil
}

func awsRestjson1_serializeDocumentGrpcGatewayRouteMetadata(v *types.GrpcGatewayRouteMetadata, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Invert != nil {
		ok := object.Key("invert")
		ok.Boolean(*v.Invert)
	}

	if v.Match != nil {
		ok := object.Key("match")
		if err := awsRestjson1_serializeDocumentGrpcMetadataMatchMethod(v.Match, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentGrpcGatewayRouteMetadataList(v []types.GrpcGatewayRouteMetadata, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGrpcGatewayRouteMetadata(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGrpcGatewayRouteRewrite(v *types.GrpcGatewayRouteRewrite, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Hostname != nil {
		ok := object.Key("hostname")
		if err := awsRestjson1_serializeDocumentGatewayRouteHostnameRewrite(v.Hostname, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGrpcMetadataMatchMethod(v types.GrpcMetadataMatchMethod, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.GrpcMetadataMatchMethodMemberExact:
		av := object.Key("exact")
		av.String(uv.Value)

	case *types.GrpcMetadataMatchMethodMemberPrefix:
		av := object.Key("prefix")
		av.String(uv.Value)

	case *types.GrpcMetadataMatchMethodMemberRange:
		av := object.Key("range")
		if err := awsRestjson1_serializeDocumentMatchRange(&uv.Value, av); err != nil {
			return err
		}

	case *types.GrpcMetadataMatchMethodMemberRegex:
		av := object.Key("regex")
		av.String(uv.Value)

	case *types.GrpcMetadataMatchMethodMemberSuffix:
		av := object.Key("suffix")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentGrpcRetryPolicy(v *types.GrpcRetryPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrpcRetryEvents != nil {
		ok := object.Key("grpcRetryEvents")
		if err := awsRestjson1_serializeDocumentGrpcRetryPolicyEvents(v.GrpcRetryEvents, ok); err != nil {
			return err
		}
	}

	if v.HttpRetryEvents != nil {
		ok := object.Key("httpRetryEvents")
		if err := awsRestjson1_serializeDocumentHttpRetryPolicyEvents(v.HttpRetryEvents, ok); err != nil {
			return err
		}
	}

	if v.MaxRetries != nil {
		ok := object.Key("maxRetries")
		ok.Long(*v.MaxRetries)
	}

	if v.PerRetryTimeout != nil {
		ok := object.Key("perRetryTimeout")
		if err := awsRestjson1_serializeDocumentDuration(v.PerRetryTimeout, ok); err != nil {
			return err
		}
	}

	if v.TcpRetryEvents != nil {
		ok := object.Key("tcpRetryEvents")
		if err := awsRestjson1_serializeDocumentTcpRetryPolicyEvents(v.TcpRetryEvents, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGrpcRetryPolicyEvents(v []types.GrpcRetryPolicyEvent, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentGrpcRoute(v *types.GrpcRoute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("action")
		if err := awsRestjson1_serializeDocumentGrpcRouteAction(v.Action, ok); err != nil {
			return err
		}
	}

	if v.Match != nil {
		ok := object.Key("match")
		if err := awsRestjson1_serializeDocumentGrpcRouteMatch(v.Match, ok); err != nil {
			return err
		}
	}

	if v.RetryPolicy != nil {
		ok := object.Key("retryPolicy")
		if err := awsRestjson1_serializeDocumentGrpcRetryPolicy(v.RetryPolicy, ok); err != nil {
			return err
		}
	}

	if v.Timeout != nil {
		ok := object.Key("timeout")
		if err := awsRestjson1_serializeDocumentGrpcTimeout(v.Timeout, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGrpcRouteAction(v *types.GrpcRouteAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WeightedTargets != nil {
		ok := object.Key("weightedTargets")
		if err := awsRestjson1_serializeDocumentWeightedTargets(v.WeightedTargets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGrpcRouteMatch(v *types.GrpcRouteMatch, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Metadata != nil {
		ok := object.Key("metadata")
		if err := awsRestjson1_serializeDocumentGrpcRouteMetadataList(v.Metadata, ok); err != nil {
			return err
		}
	}

	if v.MethodName != nil {
		ok := object.Key("methodName")
		ok.String(*v.MethodName)
	}

	if v.ServiceName != nil {
		ok := object.Key("serviceName")
		ok.String(*v.ServiceName)
	}

	return nil
}

func awsRestjson1_serializeDocumentGrpcRouteMetadata(v *types.GrpcRouteMetadata, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Invert != nil {
		ok := object.Key("invert")
		ok.Boolean(*v.Invert)
	}

	if v.Match != nil {
		ok := object.Key("match")
		if err := awsRestjson1_serializeDocumentGrpcRouteMetadataMatchMethod(v.Match, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentGrpcRouteMetadataList(v []types.GrpcRouteMetadata, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGrpcRouteMetadata(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGrpcRouteMetadataMatchMethod(v types.GrpcRouteMetadataMatchMethod, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.GrpcRouteMetadataMatchMethodMemberExact:
		av := object.Key("exact")
		av.String(uv.Value)

	case *types.GrpcRouteMetadataMatchMethodMemberPrefix:
		av := object.Key("prefix")
		av.String(uv.Value)

	case *types.GrpcRouteMetadataMatchMethodMemberRange:
		av := object.Key("range")
		if err := awsRestjson1_serializeDocumentMatchRange(&uv.Value, av); err != nil {
			return err
		}

	case *types.GrpcRouteMetadataMatchMethodMemberRegex:
		av := object.Key("regex")
		av.String(uv.Value)

	case *types.GrpcRouteMetadataMatchMethodMemberSuffix:
		av := object.Key("suffix")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentGrpcTimeout(v *types.GrpcTimeout, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Idle != nil {
		ok := object.Key("idle")
		if err := awsRestjson1_serializeDocumentDuration(v.Idle, ok); err != nil {
			return err
		}
	}

	if v.PerRequest != nil {
		ok := object.Key("perRequest")
		if err := awsRestjson1_serializeDocumentDuration(v.PerRequest, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHeaderMatchMethod(v types.HeaderMatchMethod, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.HeaderMatchMethodMemberExact:
		av := object.Key("exact")
		av.String(uv.Value)

	case *types.HeaderMatchMethodMemberPrefix:
		av := object.Key("prefix")
		av.String(uv.Value)

	case *types.HeaderMatchMethodMemberRange:
		av := object.Key("range")
		if err := awsRestjson1_serializeDocumentMatchRange(&uv.Value, av); err != nil {
			return err
		}

	case *types.HeaderMatchMethodMemberRegex:
		av := object.Key("regex")
		av.String(uv.Value)

	case *types.HeaderMatchMethodMemberSuffix:
		av := object.Key("suffix")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentHealthCheckPolicy(v *types.HealthCheckPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("healthyThreshold")
		ok.Integer(v.HealthyThreshold)
	}

	if v.IntervalMillis != nil {
		ok := object.Key("intervalMillis")
		ok.Long(*v.IntervalMillis)
	}

	if v.Path != nil {
		ok := object.Key("path")
		ok.String(*v.Path)
	}

	if v.Port != 0 {
		ok := object.Key("port")
		ok.Integer(v.Port)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	if v.TimeoutMillis != nil {
		ok := object.Key("timeoutMillis")
		ok.Long(*v.TimeoutMillis)
	}

	{
		ok := object.Key("unhealthyThreshold")
		ok.Integer(v.UnhealthyThreshold)
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpGatewayRoute(v *types.HttpGatewayRoute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("action")
		if err := awsRestjson1_serializeDocumentHttpGatewayRouteAction(v.Action, ok); err != nil {
			return err
		}
	}

	if v.Match != nil {
		ok := object.Key("match")
		if err := awsRestjson1_serializeDocumentHttpGatewayRouteMatch(v.Match, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpGatewayRouteAction(v *types.HttpGatewayRouteAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Rewrite != nil {
		ok := object.Key("rewrite")
		if err := awsRestjson1_serializeDocumentHttpGatewayRouteRewrite(v.Rewrite, ok); err != nil {
			return err
		}
	}

	if v.Target != nil {
		ok := object.Key("target")
		if err := awsRestjson1_serializeDocumentGatewayRouteTarget(v.Target, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpGatewayRouteHeader(v *types.HttpGatewayRouteHeader, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Invert != nil {
		ok := object.Key("invert")
		ok.Boolean(*v.Invert)
	}

	if v.Match != nil {
		ok := object.Key("match")
		if err := awsRestjson1_serializeDocumentHeaderMatchMethod(v.Match, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpGatewayRouteHeaders(v []types.HttpGatewayRouteHeader, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentHttpGatewayRouteHeader(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentHttpGatewayRouteMatch(v *types.HttpGatewayRouteMatch, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Headers != nil {
		ok := object.Key("headers")
		if err := awsRestjson1_serializeDocumentHttpGatewayRouteHeaders(v.Headers, ok); err != nil {
			return err
		}
	}

	if v.Hostname != nil {
		ok := object.Key("hostname")
		if err := awsRestjson1_serializeDocumentGatewayRouteHostnameMatch(v.Hostname, ok); err != nil {
			return err
		}
	}

	if len(v.Method) > 0 {
		ok := object.Key("method")
		ok.String(string(v.Method))
	}

	if v.Path != nil {
		ok := object.Key("path")
		if err := awsRestjson1_serializeDocumentHttpPathMatch(v.Path, ok); err != nil {
			return err
		}
	}

	if v.Prefix != nil {
		ok := object.Key("prefix")
		ok.String(*v.Prefix)
	}

	if v.QueryParameters != nil {
		ok := object.Key("queryParameters")
		if err := awsRestjson1_serializeDocumentHttpQueryParameters(v.QueryParameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpGatewayRoutePathRewrite(v *types.HttpGatewayRoutePathRewrite, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Exact != nil {
		ok := object.Key("exact")
		ok.String(*v.Exact)
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpGatewayRoutePrefixRewrite(v *types.HttpGatewayRoutePrefixRewrite, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DefaultPrefix) > 0 {
		ok := object.Key("defaultPrefix")
		ok.String(string(v.DefaultPrefix))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpGatewayRouteRewrite(v *types.HttpGatewayRouteRewrite, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Hostname != nil {
		ok := object.Key("hostname")
		if err := awsRestjson1_serializeDocumentGatewayRouteHostnameRewrite(v.Hostname, ok); err != nil {
			return err
		}
	}

	if v.Path != nil {
		ok := object.Key("path")
		if err := awsRestjson1_serializeDocumentHttpGatewayRoutePathRewrite(v.Path, ok); err != nil {
			return err
		}
	}

	if v.Prefix != nil {
		ok := object.Key("prefix")
		if err := awsRestjson1_serializeDocumentHttpGatewayRoutePrefixRewrite(v.Prefix, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpPathMatch(v *types.HttpPathMatch, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Exact != nil {
		ok := object.Key("exact")
		ok.String(*v.Exact)
	}

	if v.Regex != nil {
		ok := object.Key("regex")
		ok.String(*v.Regex)
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpQueryParameter(v *types.HttpQueryParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Match != nil {
		ok := object.Key("match")
		if err := awsRestjson1_serializeDocumentQueryParameterMatch(v.Match, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpQueryParameters(v []types.HttpQueryParameter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentHttpQueryParameter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentHttpRetryPolicy(v *types.HttpRetryPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HttpRetryEvents != nil {
		ok := object.Key("httpRetryEvents")
		if err := awsRestjson1_serializeDocumentHttpRetryPolicyEvents(v.HttpRetryEvents, ok); err != nil {
			return err
		}
	}

	if v.MaxRetries != nil {
		ok := object.Key("maxRetries")
		ok.Long(*v.MaxRetries)
	}

	if v.PerRetryTimeout != nil {
		ok := object.Key("perRetryTimeout")
		if err := awsRestjson1_serializeDocumentDuration(v.PerRetryTimeout, ok); err != nil {
			return err
		}
	}

	if v.TcpRetryEvents != nil {
		ok := object.Key("tcpRetryEvents")
		if err := awsRestjson1_serializeDocumentTcpRetryPolicyEvents(v.TcpRetryEvents, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpRetryPolicyEvents(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentHttpRoute(v *types.HttpRoute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("action")
		if err := awsRestjson1_serializeDocumentHttpRouteAction(v.Action, ok); err != nil {
			return err
		}
	}

	if v.Match != nil {
		ok := object.Key("match")
		if err := awsRestjson1_serializeDocumentHttpRouteMatch(v.Match, ok); err != nil {
			return err
		}
	}

	if v.RetryPolicy != nil {
		ok := object.Key("retryPolicy")
		if err := awsRestjson1_serializeDocumentHttpRetryPolicy(v.RetryPolicy, ok); err != nil {
			return err
		}
	}

	if v.Timeout != nil {
		ok := object.Key("timeout")
		if err := awsRestjson1_serializeDocumentHttpTimeout(v.Timeout, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpRouteAction(v *types.HttpRouteAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WeightedTargets != nil {
		ok := object.Key("weightedTargets")
		if err := awsRestjson1_serializeDocumentWeightedTargets(v.WeightedTargets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpRouteHeader(v *types.HttpRouteHeader, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Invert != nil {
		ok := object.Key("invert")
		ok.Boolean(*v.Invert)
	}

	if v.Match != nil {
		ok := object.Key("match")
		if err := awsRestjson1_serializeDocumentHeaderMatchMethod(v.Match, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpRouteHeaders(v []types.HttpRouteHeader, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentHttpRouteHeader(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentHttpRouteMatch(v *types.HttpRouteMatch, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Headers != nil {
		ok := object.Key("headers")
		if err := awsRestjson1_serializeDocumentHttpRouteHeaders(v.Headers, ok); err != nil {
			return err
		}
	}

	if len(v.Method) > 0 {
		ok := object.Key("method")
		ok.String(string(v.Method))
	}

	if v.Path != nil {
		ok := object.Key("path")
		if err := awsRestjson1_serializeDocumentHttpPathMatch(v.Path, ok); err != nil {
			return err
		}
	}

	if v.Prefix != nil {
		ok := object.Key("prefix")
		ok.String(*v.Prefix)
	}

	if v.QueryParameters != nil {
		ok := object.Key("queryParameters")
		if err := awsRestjson1_serializeDocumentHttpQueryParameters(v.QueryParameters, ok); err != nil {
			return err
		}
	}

	if len(v.Scheme) > 0 {
		ok := object.Key("scheme")
		ok.String(string(v.Scheme))
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpTimeout(v *types.HttpTimeout, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Idle != nil {
		ok := object.Key("idle")
		if err := awsRestjson1_serializeDocumentDuration(v.Idle, ok); err != nil {
			return err
		}
	}

	if v.PerRequest != nil {
		ok := object.Key("perRequest")
		if err := awsRestjson1_serializeDocumentDuration(v.PerRequest, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentListener(v *types.Listener, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionPool != nil {
		ok := object.Key("connectionPool")
		if err := awsRestjson1_serializeDocumentVirtualNodeConnectionPool(v.ConnectionPool, ok); err != nil {
			return err
		}
	}

	if v.HealthCheck != nil {
		ok := object.Key("healthCheck")
		if err := awsRestjson1_serializeDocumentHealthCheckPolicy(v.HealthCheck, ok); err != nil {
			return err
		}
	}

	if v.OutlierDetection != nil {
		ok := object.Key("outlierDetection")
		if err := awsRestjson1_serializeDocumentOutlierDetection(v.OutlierDetection, ok); err != nil {
			return err
		}
	}

	if v.PortMapping != nil {
		ok := object.Key("portMapping")
		if err := awsRestjson1_serializeDocumentPortMapping(v.PortMapping, ok); err != nil {
			return err
		}
	}

	if v.Timeout != nil {
		ok := object.Key("timeout")
		if err := awsRestjson1_serializeDocumentListenerTimeout(v.Timeout, ok); err != nil {
			return err
		}
	}

	if v.Tls != nil {
		ok := object.Key("tls")
		if err := awsRestjson1_serializeDocumentListenerTls(v.Tls, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentListeners(v []types.Listener, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentListener(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentListenerTimeout(v types.ListenerTimeout, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ListenerTimeoutMemberGrpc:
		av := object.Key("grpc")
		if err := awsRestjson1_serializeDocumentGrpcTimeout(&uv.Value, av); err != nil {
			return err
		}

	case *types.ListenerTimeoutMemberHttp:
		av := object.Key("http")
		if err := awsRestjson1_serializeDocumentHttpTimeout(&uv.Value, av); err != nil {
			return err
		}

	case *types.ListenerTimeoutMemberHttp2:
		av := object.Key("http2")
		if err := awsRestjson1_serializeDocumentHttpTimeout(&uv.Value, av); err != nil {
			return err
		}

	case *types.ListenerTimeoutMemberTcp:
		av := object.Key("tcp")
		if err := awsRestjson1_serializeDocumentTcpTimeout(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentListenerTls(v *types.ListenerTls, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Certificate != nil {
		ok := object.Key("certificate")
		if err := awsRestjson1_serializeDocumentListenerTlsCertificate(v.Certificate, ok); err != nil {
			return err
		}
	}

	if len(v.Mode) > 0 {
		ok := object.Key("mode")
		ok.String(string(v.Mode))
	}

	if v.Validation != nil {
		ok := object.Key("validation")
		if err := awsRestjson1_serializeDocumentListenerTlsValidationContext(v.Validation, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentListenerTlsAcmCertificate(v *types.ListenerTlsAcmCertificate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateArn != nil {
		ok := object.Key("certificateArn")
		ok.String(*v.CertificateArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentListenerTlsCertificate(v types.ListenerTlsCertificate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ListenerTlsCertificateMemberAcm:
		av := object.Key("acm")
		if err := awsRestjson1_serializeDocumentListenerTlsAcmCertificate(&uv.Value, av); err != nil {
			return err
		}

	case *types.ListenerTlsCertificateMemberFile:
		av := object.Key("file")
		if err := awsRestjson1_serializeDocumentListenerTlsFileCertificate(&uv.Value, av); err != nil {
			return err
		}

	case *types.ListenerTlsCertificateMemberSds:
		av := object.Key("sds")
		if err := awsRestjson1_serializeDocumentListenerTlsSdsCertificate(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentListenerTlsFileCertificate(v *types.ListenerTlsFileCertificate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateChain != nil {
		ok := object.Key("certificateChain")
		ok.String(*v.CertificateChain)
	}

	if v.PrivateKey != nil {
		ok := object.Key("privateKey")
		ok.String(*v.PrivateKey)
	}

	return nil
}

func awsRestjson1_serializeDocumentListenerTlsSdsCertificate(v *types.ListenerTlsSdsCertificate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecretName != nil {
		ok := object.Key("secretName")
		ok.String(*v.SecretName)
	}

	return nil
}

func awsRestjson1_serializeDocumentListenerTlsValidationContext(v *types.ListenerTlsValidationContext, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SubjectAlternativeNames != nil {
		ok := object.Key("subjectAlternativeNames")
		if err := awsRestjson1_serializeDocumentSubjectAlternativeNames(v.SubjectAlternativeNames, ok); err != nil {
			return err
		}
	}

	if v.Trust != nil {
		ok := object.Key("trust")
		if err := awsRestjson1_serializeDocumentListenerTlsValidationContextTrust(v.Trust, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentListenerTlsValidationContextTrust(v types.ListenerTlsValidationContextTrust, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ListenerTlsValidationContextTrustMemberFile:
		av := object.Key("file")
		if err := awsRestjson1_serializeDocumentTlsValidationContextFileTrust(&uv.Value, av); err != nil {
			return err
		}

	case *types.ListenerTlsValidationContextTrustMemberSds:
		av := object.Key("sds")
		if err := awsRestjson1_serializeDocumentTlsValidationContextSdsTrust(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentLogging(v *types.Logging, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessLog != nil {
		ok := object.Key("accessLog")
		if err := awsRestjson1_serializeDocumentAccessLog(v.AccessLog, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMatchRange(v *types.MatchRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.End != nil {
		ok := object.Key("end")
		ok.Long(*v.End)
	}

	if v.Start != nil {
		ok := object.Key("start")
		ok.Long(*v.Start)
	}

	return nil
}

func awsRestjson1_serializeDocumentMeshServiceDiscovery(v *types.MeshServiceDiscovery, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.IpPreference) > 0 {
		ok := object.Key("ipPreference")
		ok.String(string(v.IpPreference))
	}

	return nil
}

func awsRestjson1_serializeDocumentMeshSpec(v *types.MeshSpec, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EgressFilter != nil {
		ok := object.Key("egressFilter")
		if err := awsRestjson1_serializeDocumentEgressFilter(v.EgressFilter, ok); err != nil {
			return err
		}
	}

	if v.ServiceDiscovery != nil {
		ok := object.Key("serviceDiscovery")
		if err := awsRestjson1_serializeDocumentMeshServiceDiscovery(v.ServiceDiscovery, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOutlierDetection(v *types.OutlierDetection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BaseEjectionDuration != nil {
		ok := object.Key("baseEjectionDuration")
		if err := awsRestjson1_serializeDocumentDuration(v.BaseEjectionDuration, ok); err != nil {
			return err
		}
	}

	if v.Interval != nil {
		ok := object.Key("interval")
		if err := awsRestjson1_serializeDocumentDuration(v.Interval, ok); err != nil {
			return err
		}
	}

	if v.MaxEjectionPercent != nil {
		ok := object.Key("maxEjectionPercent")
		ok.Integer(*v.MaxEjectionPercent)
	}

	if v.MaxServerErrors != nil {
		ok := object.Key("maxServerErrors")
		ok.Long(*v.MaxServerErrors)
	}

	return nil
}

func awsRestjson1_serializeDocumentPortMapping(v *types.PortMapping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("port")
		ok.Integer(v.Port)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	return nil
}

func awsRestjson1_serializeDocumentPortSet(v []int32, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentQueryParameterMatch(v *types.QueryParameterMatch, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Exact != nil {
		ok := object.Key("exact")
		ok.String(*v.Exact)
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteSpec(v *types.RouteSpec, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrpcRoute != nil {
		ok := object.Key("grpcRoute")
		if err := awsRestjson1_serializeDocumentGrpcRoute(v.GrpcRoute, ok); err != nil {
			return err
		}
	}

	if v.Http2Route != nil {
		ok := object.Key("http2Route")
		if err := awsRestjson1_serializeDocumentHttpRoute(v.Http2Route, ok); err != nil {
			return err
		}
	}

	if v.HttpRoute != nil {
		ok := object.Key("httpRoute")
		if err := awsRestjson1_serializeDocumentHttpRoute(v.HttpRoute, ok); err != nil {
			return err
		}
	}

	if v.Priority != nil {
		ok := object.Key("priority")
		ok.Integer(*v.Priority)
	}

	if v.TcpRoute != nil {
		ok := object.Key("tcpRoute")
		if err := awsRestjson1_serializeDocumentTcpRoute(v.TcpRoute, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentServiceDiscovery(v types.ServiceDiscovery, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ServiceDiscoveryMemberAwsCloudMap:
		av := object.Key("awsCloudMap")
		if err := awsRestjson1_serializeDocumentAwsCloudMapServiceDiscovery(&uv.Value, av); err != nil {
			return err
		}

	case *types.ServiceDiscoveryMemberDns:
		av := object.Key("dns")
		if err := awsRestjson1_serializeDocumentDnsServiceDiscovery(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentSubjectAlternativeNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSubjectAlternativeNameMatchers(v *types.SubjectAlternativeNameMatchers, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Exact != nil {
		ok := object.Key("exact")
		if err := awsRestjson1_serializeDocumentSubjectAlternativeNameList(v.Exact, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSubjectAlternativeNames(v *types.SubjectAlternativeNames, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Match != nil {
		ok := object.Key("match")
		if err := awsRestjson1_serializeDocumentSubjectAlternativeNameMatchers(v.Match, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagList(v []types.TagRef, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTagRef(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTagRef(v *types.TagRef, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTcpRetryPolicyEvents(v []types.TcpRetryPolicyEvent, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentTcpRoute(v *types.TcpRoute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("action")
		if err := awsRestjson1_serializeDocumentTcpRouteAction(v.Action, ok); err != nil {
			return err
		}
	}

	if v.Timeout != nil {
		ok := object.Key("timeout")
		if err := awsRestjson1_serializeDocumentTcpTimeout(v.Timeout, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTcpRouteAction(v *types.TcpRouteAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WeightedTargets != nil {
		ok := object.Key("weightedTargets")
		if err := awsRestjson1_serializeDocumentWeightedTargets(v.WeightedTargets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTcpTimeout(v *types.TcpTimeout, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Idle != nil {
		ok := object.Key("idle")
		if err := awsRestjson1_serializeDocumentDuration(v.Idle, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTlsValidationContext(v *types.TlsValidationContext, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SubjectAlternativeNames != nil {
		ok := object.Key("subjectAlternativeNames")
		if err := awsRestjson1_serializeDocumentSubjectAlternativeNames(v.SubjectAlternativeNames, ok); err != nil {
			return err
		}
	}

	if v.Trust != nil {
		ok := object.Key("trust")
		if err := awsRestjson1_serializeDocumentTlsValidationContextTrust(v.Trust, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTlsValidationContextAcmTrust(v *types.TlsValidationContextAcmTrust, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArns != nil {
		ok := object.Key("certificateAuthorityArns")
		if err := awsRestjson1_serializeDocumentCertificateAuthorityArns(v.CertificateAuthorityArns, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTlsValidationContextFileTrust(v *types.TlsValidationContextFileTrust, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateChain != nil {
		ok := object.Key("certificateChain")
		ok.String(*v.CertificateChain)
	}

	return nil
}

func awsRestjson1_serializeDocumentTlsValidationContextSdsTrust(v *types.TlsValidationContextSdsTrust, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecretName != nil {
		ok := object.Key("secretName")
		ok.String(*v.SecretName)
	}

	return nil
}

func awsRestjson1_serializeDocumentTlsValidationContextTrust(v types.TlsValidationContextTrust, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.TlsValidationContextTrustMemberAcm:
		av := object.Key("acm")
		if err := awsRestjson1_serializeDocumentTlsValidationContextAcmTrust(&uv.Value, av); err != nil {
			return err
		}

	case *types.TlsValidationContextTrustMemberFile:
		av := object.Key("file")
		if err := awsRestjson1_serializeDocumentTlsValidationContextFileTrust(&uv.Value, av); err != nil {
			return err
		}

	case *types.TlsValidationContextTrustMemberSds:
		av := object.Key("sds")
		if err := awsRestjson1_serializeDocumentTlsValidationContextSdsTrust(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayAccessLog(v types.VirtualGatewayAccessLog, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.VirtualGatewayAccessLogMemberFile:
		av := object.Key("file")
		if err := awsRestjson1_serializeDocumentVirtualGatewayFileAccessLog(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayBackendDefaults(v *types.VirtualGatewayBackendDefaults, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientPolicy != nil {
		ok := object.Key("clientPolicy")
		if err := awsRestjson1_serializeDocumentVirtualGatewayClientPolicy(v.ClientPolicy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayCertificateAuthorityArns(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayClientPolicy(v *types.VirtualGatewayClientPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tls != nil {
		ok := object.Key("tls")
		if err := awsRestjson1_serializeDocumentVirtualGatewayClientPolicyTls(v.Tls, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayClientPolicyTls(v *types.VirtualGatewayClientPolicyTls, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Certificate != nil {
		ok := object.Key("certificate")
		if err := awsRestjson1_serializeDocumentVirtualGatewayClientTlsCertificate(v.Certificate, ok); err != nil {
			return err
		}
	}

	if v.Enforce != nil {
		ok := object.Key("enforce")
		ok.Boolean(*v.Enforce)
	}

	if v.Ports != nil {
		ok := object.Key("ports")
		if err := awsRestjson1_serializeDocumentPortSet(v.Ports, ok); err != nil {
			return err
		}
	}

	if v.Validation != nil {
		ok := object.Key("validation")
		if err := awsRestjson1_serializeDocumentVirtualGatewayTlsValidationContext(v.Validation, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayClientTlsCertificate(v types.VirtualGatewayClientTlsCertificate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.VirtualGatewayClientTlsCertificateMemberFile:
		av := object.Key("file")
		if err := awsRestjson1_serializeDocumentVirtualGatewayListenerTlsFileCertificate(&uv.Value, av); err != nil {
			return err
		}

	case *types.VirtualGatewayClientTlsCertificateMemberSds:
		av := object.Key("sds")
		if err := awsRestjson1_serializeDocumentVirtualGatewayListenerTlsSdsCertificate(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayConnectionPool(v types.VirtualGatewayConnectionPool, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.VirtualGatewayConnectionPoolMemberGrpc:
		av := object.Key("grpc")
		if err := awsRestjson1_serializeDocumentVirtualGatewayGrpcConnectionPool(&uv.Value, av); err != nil {
			return err
		}

	case *types.VirtualGatewayConnectionPoolMemberHttp:
		av := object.Key("http")
		if err := awsRestjson1_serializeDocumentVirtualGatewayHttpConnectionPool(&uv.Value, av); err != nil {
			return err
		}

	case *types.VirtualGatewayConnectionPoolMemberHttp2:
		av := object.Key("http2")
		if err := awsRestjson1_serializeDocumentVirtualGatewayHttp2ConnectionPool(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayFileAccessLog(v *types.VirtualGatewayFileAccessLog, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Path != nil {
		ok := object.Key("path")
		ok.String(*v.Path)
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayGrpcConnectionPool(v *types.VirtualGatewayGrpcConnectionPool, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("maxRequests")
		ok.Integer(v.MaxRequests)
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayHealthCheckPolicy(v *types.VirtualGatewayHealthCheckPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("healthyThreshold")
		ok.Integer(v.HealthyThreshold)
	}

	if v.IntervalMillis != nil {
		ok := object.Key("intervalMillis")
		ok.Long(*v.IntervalMillis)
	}

	if v.Path != nil {
		ok := object.Key("path")
		ok.String(*v.Path)
	}

	if v.Port != 0 {
		ok := object.Key("port")
		ok.Integer(v.Port)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	if v.TimeoutMillis != nil {
		ok := object.Key("timeoutMillis")
		ok.Long(*v.TimeoutMillis)
	}

	{
		ok := object.Key("unhealthyThreshold")
		ok.Integer(v.UnhealthyThreshold)
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayHttp2ConnectionPool(v *types.VirtualGatewayHttp2ConnectionPool, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("maxRequests")
		ok.Integer(v.MaxRequests)
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayHttpConnectionPool(v *types.VirtualGatewayHttpConnectionPool, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("maxConnections")
		ok.Integer(v.MaxConnections)
	}

	if v.MaxPendingRequests != 0 {
		ok := object.Key("maxPendingRequests")
		ok.Integer(v.MaxPendingRequests)
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayListener(v *types.VirtualGatewayListener, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionPool != nil {
		ok := object.Key("connectionPool")
		if err := awsRestjson1_serializeDocumentVirtualGatewayConnectionPool(v.ConnectionPool, ok); err != nil {
			return err
		}
	}

	if v.HealthCheck != nil {
		ok := object.Key("healthCheck")
		if err := awsRestjson1_serializeDocumentVirtualGatewayHealthCheckPolicy(v.HealthCheck, ok); err != nil {
			return err
		}
	}

	if v.PortMapping != nil {
		ok := object.Key("portMapping")
		if err := awsRestjson1_serializeDocumentVirtualGatewayPortMapping(v.PortMapping, ok); err != nil {
			return err
		}
	}

	if v.Tls != nil {
		ok := object.Key("tls")
		if err := awsRestjson1_serializeDocumentVirtualGatewayListenerTls(v.Tls, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayListeners(v []types.VirtualGatewayListener, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentVirtualGatewayListener(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayListenerTls(v *types.VirtualGatewayListenerTls, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Certificate != nil {
		ok := object.Key("certificate")
		if err := awsRestjson1_serializeDocumentVirtualGatewayListenerTlsCertificate(v.Certificate, ok); err != nil {
			return err
		}
	}

	if len(v.Mode) > 0 {
		ok := object.Key("mode")
		ok.String(string(v.Mode))
	}

	if v.Validation != nil {
		ok := object.Key("validation")
		if err := awsRestjson1_serializeDocumentVirtualGatewayListenerTlsValidationContext(v.Validation, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayListenerTlsAcmCertificate(v *types.VirtualGatewayListenerTlsAcmCertificate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateArn != nil {
		ok := object.Key("certificateArn")
		ok.String(*v.CertificateArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayListenerTlsCertificate(v types.VirtualGatewayListenerTlsCertificate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.VirtualGatewayListenerTlsCertificateMemberAcm:
		av := object.Key("acm")
		if err := awsRestjson1_serializeDocumentVirtualGatewayListenerTlsAcmCertificate(&uv.Value, av); err != nil {
			return err
		}

	case *types.VirtualGatewayListenerTlsCertificateMemberFile:
		av := object.Key("file")
		if err := awsRestjson1_serializeDocumentVirtualGatewayListenerTlsFileCertificate(&uv.Value, av); err != nil {
			return err
		}

	case *types.VirtualGatewayListenerTlsCertificateMemberSds:
		av := object.Key("sds")
		if err := awsRestjson1_serializeDocumentVirtualGatewayListenerTlsSdsCertificate(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayListenerTlsFileCertificate(v *types.VirtualGatewayListenerTlsFileCertificate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateChain != nil {
		ok := object.Key("certificateChain")
		ok.String(*v.CertificateChain)
	}

	if v.PrivateKey != nil {
		ok := object.Key("privateKey")
		ok.String(*v.PrivateKey)
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayListenerTlsSdsCertificate(v *types.VirtualGatewayListenerTlsSdsCertificate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecretName != nil {
		ok := object.Key("secretName")
		ok.String(*v.SecretName)
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayListenerTlsValidationContext(v *types.VirtualGatewayListenerTlsValidationContext, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SubjectAlternativeNames != nil {
		ok := object.Key("subjectAlternativeNames")
		if err := awsRestjson1_serializeDocumentSubjectAlternativeNames(v.SubjectAlternativeNames, ok); err != nil {
			return err
		}
	}

	if v.Trust != nil {
		ok := object.Key("trust")
		if err := awsRestjson1_serializeDocumentVirtualGatewayListenerTlsValidationContextTrust(v.Trust, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayListenerTlsValidationContextTrust(v types.VirtualGatewayListenerTlsValidationContextTrust, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.VirtualGatewayListenerTlsValidationContextTrustMemberFile:
		av := object.Key("file")
		if err := awsRestjson1_serializeDocumentVirtualGatewayTlsValidationContextFileTrust(&uv.Value, av); err != nil {
			return err
		}

	case *types.VirtualGatewayListenerTlsValidationContextTrustMemberSds:
		av := object.Key("sds")
		if err := awsRestjson1_serializeDocumentVirtualGatewayTlsValidationContextSdsTrust(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayLogging(v *types.VirtualGatewayLogging, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessLog != nil {
		ok := object.Key("accessLog")
		if err := awsRestjson1_serializeDocumentVirtualGatewayAccessLog(v.AccessLog, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayPortMapping(v *types.VirtualGatewayPortMapping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("port")
		ok.Integer(v.Port)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewaySpec(v *types.VirtualGatewaySpec, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackendDefaults != nil {
		ok := object.Key("backendDefaults")
		if err := awsRestjson1_serializeDocumentVirtualGatewayBackendDefaults(v.BackendDefaults, ok); err != nil {
			return err
		}
	}

	if v.Listeners != nil {
		ok := object.Key("listeners")
		if err := awsRestjson1_serializeDocumentVirtualGatewayListeners(v.Listeners, ok); err != nil {
			return err
		}
	}

	if v.Logging != nil {
		ok := object.Key("logging")
		if err := awsRestjson1_serializeDocumentVirtualGatewayLogging(v.Logging, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayTlsValidationContext(v *types.VirtualGatewayTlsValidationContext, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SubjectAlternativeNames != nil {
		ok := object.Key("subjectAlternativeNames")
		if err := awsRestjson1_serializeDocumentSubjectAlternativeNames(v.SubjectAlternativeNames, ok); err != nil {
			return err
		}
	}

	if v.Trust != nil {
		ok := object.Key("trust")
		if err := awsRestjson1_serializeDocumentVirtualGatewayTlsValidationContextTrust(v.Trust, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayTlsValidationContextAcmTrust(v *types.VirtualGatewayTlsValidationContextAcmTrust, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArns != nil {
		ok := object.Key("certificateAuthorityArns")
		if err := awsRestjson1_serializeDocumentVirtualGatewayCertificateAuthorityArns(v.CertificateAuthorityArns, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayTlsValidationContextFileTrust(v *types.VirtualGatewayTlsValidationContextFileTrust, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateChain != nil {
		ok := object.Key("certificateChain")
		ok.String(*v.CertificateChain)
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayTlsValidationContextSdsTrust(v *types.VirtualGatewayTlsValidationContextSdsTrust, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecretName != nil {
		ok := object.Key("secretName")
		ok.String(*v.SecretName)
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualGatewayTlsValidationContextTrust(v types.VirtualGatewayTlsValidationContextTrust, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.VirtualGatewayTlsValidationContextTrustMemberAcm:
		av := object.Key("acm")
		if err := awsRestjson1_serializeDocumentVirtualGatewayTlsValidationContextAcmTrust(&uv.Value, av); err != nil {
			return err
		}

	case *types.VirtualGatewayTlsValidationContextTrustMemberFile:
		av := object.Key("file")
		if err := awsRestjson1_serializeDocumentVirtualGatewayTlsValidationContextFileTrust(&uv.Value, av); err != nil {
			return err
		}

	case *types.VirtualGatewayTlsValidationContextTrustMemberSds:
		av := object.Key("sds")
		if err := awsRestjson1_serializeDocumentVirtualGatewayTlsValidationContextSdsTrust(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentVirtualNodeConnectionPool(v types.VirtualNodeConnectionPool, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.VirtualNodeConnectionPoolMemberGrpc:
		av := object.Key("grpc")
		if err := awsRestjson1_serializeDocumentVirtualNodeGrpcConnectionPool(&uv.Value, av); err != nil {
			return err
		}

	case *types.VirtualNodeConnectionPoolMemberHttp:
		av := object.Key("http")
		if err := awsRestjson1_serializeDocumentVirtualNodeHttpConnectionPool(&uv.Value, av); err != nil {
			return err
		}

	case *types.VirtualNodeConnectionPoolMemberHttp2:
		av := object.Key("http2")
		if err := awsRestjson1_serializeDocumentVirtualNodeHttp2ConnectionPool(&uv.Value, av); err != nil {
			return err
		}

	case *types.VirtualNodeConnectionPoolMemberTcp:
		av := object.Key("tcp")
		if err := awsRestjson1_serializeDocumentVirtualNodeTcpConnectionPool(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentVirtualNodeGrpcConnectionPool(v *types.VirtualNodeGrpcConnectionPool, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("maxRequests")
		ok.Integer(v.MaxRequests)
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualNodeHttp2ConnectionPool(v *types.VirtualNodeHttp2ConnectionPool, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("maxRequests")
		ok.Integer(v.MaxRequests)
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualNodeHttpConnectionPool(v *types.VirtualNodeHttpConnectionPool, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("maxConnections")
		ok.Integer(v.MaxConnections)
	}

	if v.MaxPendingRequests != 0 {
		ok := object.Key("maxPendingRequests")
		ok.Integer(v.MaxPendingRequests)
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualNodeServiceProvider(v *types.VirtualNodeServiceProvider, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VirtualNodeName != nil {
		ok := object.Key("virtualNodeName")
		ok.String(*v.VirtualNodeName)
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualNodeSpec(v *types.VirtualNodeSpec, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackendDefaults != nil {
		ok := object.Key("backendDefaults")
		if err := awsRestjson1_serializeDocumentBackendDefaults(v.BackendDefaults, ok); err != nil {
			return err
		}
	}

	if v.Backends != nil {
		ok := object.Key("backends")
		if err := awsRestjson1_serializeDocumentBackends(v.Backends, ok); err != nil {
			return err
		}
	}

	if v.Listeners != nil {
		ok := object.Key("listeners")
		if err := awsRestjson1_serializeDocumentListeners(v.Listeners, ok); err != nil {
			return err
		}
	}

	if v.Logging != nil {
		ok := object.Key("logging")
		if err := awsRestjson1_serializeDocumentLogging(v.Logging, ok); err != nil {
			return err
		}
	}

	if v.ServiceDiscovery != nil {
		ok := object.Key("serviceDiscovery")
		if err := awsRestjson1_serializeDocumentServiceDiscovery(v.ServiceDiscovery, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualNodeTcpConnectionPool(v *types.VirtualNodeTcpConnectionPool, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("maxConnections")
		ok.Integer(v.MaxConnections)
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualRouterListener(v *types.VirtualRouterListener, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PortMapping != nil {
		ok := object.Key("portMapping")
		if err := awsRestjson1_serializeDocumentPortMapping(v.PortMapping, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualRouterListeners(v []types.VirtualRouterListener, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentVirtualRouterListener(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentVirtualRouterServiceProvider(v *types.VirtualRouterServiceProvider, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VirtualRouterName != nil {
		ok := object.Key("virtualRouterName")
		ok.String(*v.VirtualRouterName)
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualRouterSpec(v *types.VirtualRouterSpec, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Listeners != nil {
		ok := object.Key("listeners")
		if err := awsRestjson1_serializeDocumentVirtualRouterListeners(v.Listeners, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualServiceBackend(v *types.VirtualServiceBackend, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientPolicy != nil {
		ok := object.Key("clientPolicy")
		if err := awsRestjson1_serializeDocumentClientPolicy(v.ClientPolicy, ok); err != nil {
			return err
		}
	}

	if v.VirtualServiceName != nil {
		ok := object.Key("virtualServiceName")
		ok.String(*v.VirtualServiceName)
	}

	return nil
}

func awsRestjson1_serializeDocumentVirtualServiceProvider(v types.VirtualServiceProvider, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.VirtualServiceProviderMemberVirtualNode:
		av := object.Key("virtualNode")
		if err := awsRestjson1_serializeDocumentVirtualNodeServiceProvider(&uv.Value, av); err != nil {
			return err
		}

	case *types.VirtualServiceProviderMemberVirtualRouter:
		av := object.Key("virtualRouter")
		if err := awsRestjson1_serializeDocumentVirtualRouterServiceProvider(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentVirtualServiceSpec(v *types.VirtualServiceSpec, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Provider != nil {
		ok := object.Key("provider")
		if err := awsRestjson1_serializeDocumentVirtualServiceProvider(v.Provider, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWeightedTarget(v *types.WeightedTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VirtualNode != nil {
		ok := object.Key("virtualNode")
		ok.String(*v.VirtualNode)
	}

	{
		ok := object.Key("weight")
		ok.Integer(v.Weight)
	}

	return nil
}

func awsRestjson1_serializeDocumentWeightedTargets(v []types.WeightedTarget, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentWeightedTarget(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}
