// Code generated by smithy-go-codegen DO NOT EDIT.

package fis

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/fis/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the target resource types.
func (c *Client) ListTargetResourceTypes(ctx context.Context, params *ListTargetResourceTypesInput, optFns ...func(*Options)) (*ListTargetResourceTypesOutput, error) {
	if params == nil {
		params = &ListTargetResourceTypesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTargetResourceTypes", params, optFns, c.addOperationListTargetResourceTypesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTargetResourceTypesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTargetResourceTypesInput struct {

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults int32

	// The token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListTargetResourceTypesOutput struct {

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// The target resource types.
	TargetResourceTypes []types.TargetResourceTypeSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTargetResourceTypesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTargetResourceTypes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTargetResourceTypes{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTargetResourceTypes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTargetResourceTypesAPIClient is a client that implements the
// ListTargetResourceTypes operation.
type ListTargetResourceTypesAPIClient interface {
	ListTargetResourceTypes(context.Context, *ListTargetResourceTypesInput, ...func(*Options)) (*ListTargetResourceTypesOutput, error)
}

var _ ListTargetResourceTypesAPIClient = (*Client)(nil)

// ListTargetResourceTypesPaginatorOptions is the paginator options for
// ListTargetResourceTypes
type ListTargetResourceTypesPaginatorOptions struct {
	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTargetResourceTypesPaginator is a paginator for ListTargetResourceTypes
type ListTargetResourceTypesPaginator struct {
	options   ListTargetResourceTypesPaginatorOptions
	client    ListTargetResourceTypesAPIClient
	params    *ListTargetResourceTypesInput
	nextToken *string
	firstPage bool
}

// NewListTargetResourceTypesPaginator returns a new
// ListTargetResourceTypesPaginator
func NewListTargetResourceTypesPaginator(client ListTargetResourceTypesAPIClient, params *ListTargetResourceTypesInput, optFns ...func(*ListTargetResourceTypesPaginatorOptions)) *ListTargetResourceTypesPaginator {
	if params == nil {
		params = &ListTargetResourceTypesInput{}
	}

	options := ListTargetResourceTypesPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTargetResourceTypesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTargetResourceTypesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTargetResourceTypes page.
func (p *ListTargetResourceTypesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTargetResourceTypesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	result, err := p.client.ListTargetResourceTypes(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListTargetResourceTypes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "fis",
		OperationName: "ListTargetResourceTypes",
	}
}
