// Code generated by smithy-go-codegen DO NOT EDIT.

package lambda

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/lambda/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a Lambda function URL with the specified configuration parameters. A
// function URL is a dedicated HTTP(S) endpoint that you can use to invoke your
// function.
func (c *Client) CreateFunctionUrlConfig(ctx context.Context, params *CreateFunctionUrlConfigInput, optFns ...func(*Options)) (*CreateFunctionUrlConfigOutput, error) {
	if params == nil {
		params = &CreateFunctionUrlConfigInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateFunctionUrlConfig", params, optFns, c.addOperationCreateFunctionUrlConfigMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateFunctionUrlConfigOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateFunctionUrlConfigInput struct {

	// The type of authentication that your function URL uses. Set to AWS_IAM if you
	// want to restrict access to authenticated IAM users only. Set to NONE if you want
	// to bypass IAM authentication to create a public endpoint. For more information,
	// see  Security and auth model for Lambda function URLs
	// (https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html).
	//
	// This member is required.
	AuthType types.FunctionUrlAuthType

	// The name of the Lambda function. Name formats
	//
	// * Function name - my-function.
	//
	// *
	// Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	// *
	// Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies
	// only to the full ARN. If you specify only the function name, it is limited to 64
	// characters in length.
	//
	// This member is required.
	FunctionName *string

	// The cross-origin resource sharing (CORS)
	// (https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for your
	// function URL.
	Cors *types.Cors

	// The alias name.
	Qualifier *string

	noSmithyDocumentSerde
}

type CreateFunctionUrlConfigOutput struct {

	// The type of authentication that your function URL uses. Set to AWS_IAM if you
	// want to restrict access to authenticated IAM users only. Set to NONE if you want
	// to bypass IAM authentication to create a public endpoint. For more information,
	// see  Security and auth model for Lambda function URLs
	// (https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html).
	//
	// This member is required.
	AuthType types.FunctionUrlAuthType

	// When the function URL was created, in ISO-8601 format
	// (https://www.w3.org/TR/NOTE-datetime) (YYYY-MM-DDThh:mm:ss.sTZD).
	//
	// This member is required.
	CreationTime *string

	// The Amazon Resource Name (ARN) of your function.
	//
	// This member is required.
	FunctionArn *string

	// The HTTP URL endpoint for your function.
	//
	// This member is required.
	FunctionUrl *string

	// The cross-origin resource sharing (CORS)
	// (https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for your
	// function URL.
	Cors *types.Cors

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateFunctionUrlConfigMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateFunctionUrlConfig{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateFunctionUrlConfig{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateFunctionUrlConfigValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateFunctionUrlConfig(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateFunctionUrlConfig(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "lambda",
		OperationName: "CreateFunctionUrlConfig",
	}
}
