// Code generated by smithy-go-codegen DO NOT EDIT.

package proton

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/proton/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Create and register a link to a repository that can be used with self-managed
// provisioning (infrastructure or pipelines) or for template sync configurations.
// When you create a repository link, Proton creates a service-linked role
// (https://docs.aws.amazon.com/proton/latest/adminguide/using-service-linked-roles.html)
// for you. For more information, see Self-managed provisioning
// (https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self),
// Template bundles
// (https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-bundles.html),
// and Template sync configurations
// (https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-sync-configs.html)
// in the Proton Administrator Guide.
func (c *Client) CreateRepository(ctx context.Context, params *CreateRepositoryInput, optFns ...func(*Options)) (*CreateRepositoryOutput, error) {
	if params == nil {
		params = &CreateRepositoryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateRepository", params, optFns, c.addOperationCreateRepositoryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateRepositoryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateRepositoryInput struct {

	// The Amazon Resource Name (ARN) of your Amazon Web Services CodeStar connection.
	// For more information, see Setting up for Proton
	// (https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html)
	// in the Proton Administrator Guide.
	//
	// This member is required.
	ConnectionArn *string

	// The repository name (for example, myrepos/myrepo).
	//
	// This member is required.
	Name *string

	// The repository provider.
	//
	// This member is required.
	Provider types.RepositoryProvider

	// The ARN of your customer Amazon Web Services Key Management Service (Amazon Web
	// Services KMS) key.
	EncryptionKey *string

	// An optional list of metadata items that you can associate with the Proton
	// repository. A tag is a key-value pair. For more information, see Proton
	// resources and tagging in the Proton Administrator Guide
	// (https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or Proton
	// User Guide (https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateRepositoryOutput struct {

	// The repository detail data that's returned by Proton.
	//
	// This member is required.
	Repository *types.Repository

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateRepositoryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateRepository{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateRepository{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateRepositoryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateRepository(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateRepository(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "proton",
		OperationName: "CreateRepository",
	}
}
