// Code generated by smithy-go-codegen DO NOT EDIT.

package route53resolver

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/route53resolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Changes the association of a FirewallRuleGroup with a VPC. The association
// enables DNS filtering for the VPC.
func (c *Client) UpdateFirewallRuleGroupAssociation(ctx context.Context, params *UpdateFirewallRuleGroupAssociationInput, optFns ...func(*Options)) (*UpdateFirewallRuleGroupAssociationOutput, error) {
	if params == nil {
		params = &UpdateFirewallRuleGroupAssociationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateFirewallRuleGroupAssociation", params, optFns, c.addOperationUpdateFirewallRuleGroupAssociationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateFirewallRuleGroupAssociationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateFirewallRuleGroupAssociationInput struct {

	// The identifier of the FirewallRuleGroupAssociation.
	//
	// This member is required.
	FirewallRuleGroupAssociationId *string

	// If enabled, this setting disallows modification or removal of the association,
	// to help prevent against accidentally altering DNS firewall protections.
	MutationProtection types.MutationProtectionStatus

	// The name of the rule group association.
	Name *string

	// The setting that determines the processing order of the rule group among the
	// rule groups that you associate with the specified VPC. DNS Firewall filters VPC
	// traffic starting from the rule group with the lowest numeric priority setting.
	// You must specify a unique priority for each rule group that you associate with a
	// single VPC. To make it easier to insert rule groups later, leave space between
	// the numbers, for example, use 100, 200, and so on. You can change the priority
	// setting for a rule group association after you create it.
	Priority *int32

	noSmithyDocumentSerde
}

type UpdateFirewallRuleGroupAssociationOutput struct {

	// The association that you just updated.
	FirewallRuleGroupAssociation *types.FirewallRuleGroupAssociation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateFirewallRuleGroupAssociationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateFirewallRuleGroupAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateFirewallRuleGroupAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateFirewallRuleGroupAssociationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateFirewallRuleGroupAssociation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateFirewallRuleGroupAssociation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "route53resolver",
		OperationName: "UpdateFirewallRuleGroupAssociation",
	}
}
