//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armapimanagement

// APIClientCreateOrUpdateResponse contains the response from method APIClient.CreateOrUpdate.
type APIClientCreateOrUpdateResponse struct {
	APIContract
}

// APIClientDeleteResponse contains the response from method APIClient.Delete.
type APIClientDeleteResponse struct {
	// placeholder for future response values
}

// APIClientGetEntityTagResponse contains the response from method APIClient.GetEntityTag.
type APIClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIClientGetResponse contains the response from method APIClient.Get.
type APIClientGetResponse struct {
	APIContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIClientListByServiceResponse contains the response from method APIClient.ListByService.
type APIClientListByServiceResponse struct {
	APICollection
}

// APIClientListByTagsResponse contains the response from method APIClient.ListByTags.
type APIClientListByTagsResponse struct {
	TagResourceCollection
}

// APIClientUpdateResponse contains the response from method APIClient.Update.
type APIClientUpdateResponse struct {
	APIContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIDiagnosticClientCreateOrUpdateResponse contains the response from method APIDiagnosticClient.CreateOrUpdate.
type APIDiagnosticClientCreateOrUpdateResponse struct {
	DiagnosticContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIDiagnosticClientDeleteResponse contains the response from method APIDiagnosticClient.Delete.
type APIDiagnosticClientDeleteResponse struct {
	// placeholder for future response values
}

// APIDiagnosticClientGetEntityTagResponse contains the response from method APIDiagnosticClient.GetEntityTag.
type APIDiagnosticClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIDiagnosticClientGetResponse contains the response from method APIDiagnosticClient.Get.
type APIDiagnosticClientGetResponse struct {
	DiagnosticContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIDiagnosticClientListByServiceResponse contains the response from method APIDiagnosticClient.ListByService.
type APIDiagnosticClientListByServiceResponse struct {
	DiagnosticCollection
}

// APIDiagnosticClientUpdateResponse contains the response from method APIDiagnosticClient.Update.
type APIDiagnosticClientUpdateResponse struct {
	DiagnosticContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIExportClientGetResponse contains the response from method APIExportClient.Get.
type APIExportClientGetResponse struct {
	APIExportResult
}

// APIIssueAttachmentClientCreateOrUpdateResponse contains the response from method APIIssueAttachmentClient.CreateOrUpdate.
type APIIssueAttachmentClientCreateOrUpdateResponse struct {
	IssueAttachmentContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIIssueAttachmentClientDeleteResponse contains the response from method APIIssueAttachmentClient.Delete.
type APIIssueAttachmentClientDeleteResponse struct {
	// placeholder for future response values
}

// APIIssueAttachmentClientGetEntityTagResponse contains the response from method APIIssueAttachmentClient.GetEntityTag.
type APIIssueAttachmentClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIIssueAttachmentClientGetResponse contains the response from method APIIssueAttachmentClient.Get.
type APIIssueAttachmentClientGetResponse struct {
	IssueAttachmentContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIIssueAttachmentClientListByServiceResponse contains the response from method APIIssueAttachmentClient.ListByService.
type APIIssueAttachmentClientListByServiceResponse struct {
	IssueAttachmentCollection
}

// APIIssueClientCreateOrUpdateResponse contains the response from method APIIssueClient.CreateOrUpdate.
type APIIssueClientCreateOrUpdateResponse struct {
	IssueContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIIssueClientDeleteResponse contains the response from method APIIssueClient.Delete.
type APIIssueClientDeleteResponse struct {
	// placeholder for future response values
}

// APIIssueClientGetEntityTagResponse contains the response from method APIIssueClient.GetEntityTag.
type APIIssueClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIIssueClientGetResponse contains the response from method APIIssueClient.Get.
type APIIssueClientGetResponse struct {
	IssueContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIIssueClientListByServiceResponse contains the response from method APIIssueClient.ListByService.
type APIIssueClientListByServiceResponse struct {
	IssueCollection
}

// APIIssueClientUpdateResponse contains the response from method APIIssueClient.Update.
type APIIssueClientUpdateResponse struct {
	IssueContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIIssueCommentClientCreateOrUpdateResponse contains the response from method APIIssueCommentClient.CreateOrUpdate.
type APIIssueCommentClientCreateOrUpdateResponse struct {
	IssueCommentContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIIssueCommentClientDeleteResponse contains the response from method APIIssueCommentClient.Delete.
type APIIssueCommentClientDeleteResponse struct {
	// placeholder for future response values
}

// APIIssueCommentClientGetEntityTagResponse contains the response from method APIIssueCommentClient.GetEntityTag.
type APIIssueCommentClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIIssueCommentClientGetResponse contains the response from method APIIssueCommentClient.Get.
type APIIssueCommentClientGetResponse struct {
	IssueCommentContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIIssueCommentClientListByServiceResponse contains the response from method APIIssueCommentClient.ListByService.
type APIIssueCommentClientListByServiceResponse struct {
	IssueCommentCollection
}

// APIOperationClientCreateOrUpdateResponse contains the response from method APIOperationClient.CreateOrUpdate.
type APIOperationClientCreateOrUpdateResponse struct {
	OperationContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIOperationClientDeleteResponse contains the response from method APIOperationClient.Delete.
type APIOperationClientDeleteResponse struct {
	// placeholder for future response values
}

// APIOperationClientGetEntityTagResponse contains the response from method APIOperationClient.GetEntityTag.
type APIOperationClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIOperationClientGetResponse contains the response from method APIOperationClient.Get.
type APIOperationClientGetResponse struct {
	OperationContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIOperationClientListByAPIResponse contains the response from method APIOperationClient.ListByAPI.
type APIOperationClientListByAPIResponse struct {
	OperationCollection
}

// APIOperationClientUpdateResponse contains the response from method APIOperationClient.Update.
type APIOperationClientUpdateResponse struct {
	OperationContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIOperationPolicyClientCreateOrUpdateResponse contains the response from method APIOperationPolicyClient.CreateOrUpdate.
type APIOperationPolicyClientCreateOrUpdateResponse struct {
	PolicyContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIOperationPolicyClientDeleteResponse contains the response from method APIOperationPolicyClient.Delete.
type APIOperationPolicyClientDeleteResponse struct {
	// placeholder for future response values
}

// APIOperationPolicyClientGetEntityTagResponse contains the response from method APIOperationPolicyClient.GetEntityTag.
type APIOperationPolicyClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIOperationPolicyClientGetResponse contains the response from method APIOperationPolicyClient.Get.
type APIOperationPolicyClientGetResponse struct {
	PolicyContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIOperationPolicyClientListByOperationResponse contains the response from method APIOperationPolicyClient.ListByOperation.
type APIOperationPolicyClientListByOperationResponse struct {
	PolicyCollection
}

// APIPolicyClientCreateOrUpdateResponse contains the response from method APIPolicyClient.CreateOrUpdate.
type APIPolicyClientCreateOrUpdateResponse struct {
	PolicyContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIPolicyClientDeleteResponse contains the response from method APIPolicyClient.Delete.
type APIPolicyClientDeleteResponse struct {
	// placeholder for future response values
}

// APIPolicyClientGetEntityTagResponse contains the response from method APIPolicyClient.GetEntityTag.
type APIPolicyClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIPolicyClientGetResponse contains the response from method APIPolicyClient.Get.
type APIPolicyClientGetResponse struct {
	PolicyContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIPolicyClientListByAPIResponse contains the response from method APIPolicyClient.ListByAPI.
type APIPolicyClientListByAPIResponse struct {
	PolicyCollection
}

// APIProductClientListByApisResponse contains the response from method APIProductClient.ListByApis.
type APIProductClientListByApisResponse struct {
	ProductCollection
}

// APIReleaseClientCreateOrUpdateResponse contains the response from method APIReleaseClient.CreateOrUpdate.
type APIReleaseClientCreateOrUpdateResponse struct {
	APIReleaseContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIReleaseClientDeleteResponse contains the response from method APIReleaseClient.Delete.
type APIReleaseClientDeleteResponse struct {
	// placeholder for future response values
}

// APIReleaseClientGetEntityTagResponse contains the response from method APIReleaseClient.GetEntityTag.
type APIReleaseClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIReleaseClientGetResponse contains the response from method APIReleaseClient.Get.
type APIReleaseClientGetResponse struct {
	APIReleaseContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIReleaseClientListByServiceResponse contains the response from method APIReleaseClient.ListByService.
type APIReleaseClientListByServiceResponse struct {
	APIReleaseCollection
}

// APIReleaseClientUpdateResponse contains the response from method APIReleaseClient.Update.
type APIReleaseClientUpdateResponse struct {
	APIReleaseContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIRevisionClientListByServiceResponse contains the response from method APIRevisionClient.ListByService.
type APIRevisionClientListByServiceResponse struct {
	APIRevisionCollection
}

// APISchemaClientCreateOrUpdateResponse contains the response from method APISchemaClient.CreateOrUpdate.
type APISchemaClientCreateOrUpdateResponse struct {
	SchemaContract
}

// APISchemaClientDeleteResponse contains the response from method APISchemaClient.Delete.
type APISchemaClientDeleteResponse struct {
	// placeholder for future response values
}

// APISchemaClientGetEntityTagResponse contains the response from method APISchemaClient.GetEntityTag.
type APISchemaClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APISchemaClientGetResponse contains the response from method APISchemaClient.Get.
type APISchemaClientGetResponse struct {
	SchemaContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APISchemaClientListByAPIResponse contains the response from method APISchemaClient.ListByAPI.
type APISchemaClientListByAPIResponse struct {
	SchemaCollection
}

// APITagDescriptionClientCreateOrUpdateResponse contains the response from method APITagDescriptionClient.CreateOrUpdate.
type APITagDescriptionClientCreateOrUpdateResponse struct {
	TagDescriptionContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APITagDescriptionClientDeleteResponse contains the response from method APITagDescriptionClient.Delete.
type APITagDescriptionClientDeleteResponse struct {
	// placeholder for future response values
}

// APITagDescriptionClientGetEntityTagResponse contains the response from method APITagDescriptionClient.GetEntityTag.
type APITagDescriptionClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APITagDescriptionClientGetResponse contains the response from method APITagDescriptionClient.Get.
type APITagDescriptionClientGetResponse struct {
	TagDescriptionContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APITagDescriptionClientListByServiceResponse contains the response from method APITagDescriptionClient.ListByService.
type APITagDescriptionClientListByServiceResponse struct {
	TagDescriptionCollection
}

// APIVersionSetClientCreateOrUpdateResponse contains the response from method APIVersionSetClient.CreateOrUpdate.
type APIVersionSetClientCreateOrUpdateResponse struct {
	APIVersionSetContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIVersionSetClientDeleteResponse contains the response from method APIVersionSetClient.Delete.
type APIVersionSetClientDeleteResponse struct {
	// placeholder for future response values
}

// APIVersionSetClientGetEntityTagResponse contains the response from method APIVersionSetClient.GetEntityTag.
type APIVersionSetClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// APIVersionSetClientGetResponse contains the response from method APIVersionSetClient.Get.
type APIVersionSetClientGetResponse struct {
	APIVersionSetContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// APIVersionSetClientListByServiceResponse contains the response from method APIVersionSetClient.ListByService.
type APIVersionSetClientListByServiceResponse struct {
	APIVersionSetCollection
}

// APIVersionSetClientUpdateResponse contains the response from method APIVersionSetClient.Update.
type APIVersionSetClientUpdateResponse struct {
	APIVersionSetContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// AuthorizationServerClientCreateOrUpdateResponse contains the response from method AuthorizationServerClient.CreateOrUpdate.
type AuthorizationServerClientCreateOrUpdateResponse struct {
	AuthorizationServerContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// AuthorizationServerClientDeleteResponse contains the response from method AuthorizationServerClient.Delete.
type AuthorizationServerClientDeleteResponse struct {
	// placeholder for future response values
}

// AuthorizationServerClientGetEntityTagResponse contains the response from method AuthorizationServerClient.GetEntityTag.
type AuthorizationServerClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// AuthorizationServerClientGetResponse contains the response from method AuthorizationServerClient.Get.
type AuthorizationServerClientGetResponse struct {
	AuthorizationServerContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// AuthorizationServerClientListByServiceResponse contains the response from method AuthorizationServerClient.ListByService.
type AuthorizationServerClientListByServiceResponse struct {
	AuthorizationServerCollection
}

// AuthorizationServerClientListSecretsResponse contains the response from method AuthorizationServerClient.ListSecrets.
type AuthorizationServerClientListSecretsResponse struct {
	AuthorizationServerSecretsContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// AuthorizationServerClientUpdateResponse contains the response from method AuthorizationServerClient.Update.
type AuthorizationServerClientUpdateResponse struct {
	AuthorizationServerContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// BackendClientCreateOrUpdateResponse contains the response from method BackendClient.CreateOrUpdate.
type BackendClientCreateOrUpdateResponse struct {
	BackendContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// BackendClientDeleteResponse contains the response from method BackendClient.Delete.
type BackendClientDeleteResponse struct {
	// placeholder for future response values
}

// BackendClientGetEntityTagResponse contains the response from method BackendClient.GetEntityTag.
type BackendClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// BackendClientGetResponse contains the response from method BackendClient.Get.
type BackendClientGetResponse struct {
	BackendContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// BackendClientListByServiceResponse contains the response from method BackendClient.ListByService.
type BackendClientListByServiceResponse struct {
	BackendCollection
}

// BackendClientReconnectResponse contains the response from method BackendClient.Reconnect.
type BackendClientReconnectResponse struct {
	// placeholder for future response values
}

// BackendClientUpdateResponse contains the response from method BackendClient.Update.
type BackendClientUpdateResponse struct {
	BackendContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// CacheClientCreateOrUpdateResponse contains the response from method CacheClient.CreateOrUpdate.
type CacheClientCreateOrUpdateResponse struct {
	CacheContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// CacheClientDeleteResponse contains the response from method CacheClient.Delete.
type CacheClientDeleteResponse struct {
	// placeholder for future response values
}

// CacheClientGetEntityTagResponse contains the response from method CacheClient.GetEntityTag.
type CacheClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// CacheClientGetResponse contains the response from method CacheClient.Get.
type CacheClientGetResponse struct {
	CacheContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// CacheClientListByServiceResponse contains the response from method CacheClient.ListByService.
type CacheClientListByServiceResponse struct {
	CacheCollection
}

// CacheClientUpdateResponse contains the response from method CacheClient.Update.
type CacheClientUpdateResponse struct {
	CacheContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// CertificateClientCreateOrUpdateResponse contains the response from method CertificateClient.CreateOrUpdate.
type CertificateClientCreateOrUpdateResponse struct {
	CertificateContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// CertificateClientDeleteResponse contains the response from method CertificateClient.Delete.
type CertificateClientDeleteResponse struct {
	// placeholder for future response values
}

// CertificateClientGetEntityTagResponse contains the response from method CertificateClient.GetEntityTag.
type CertificateClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// CertificateClientGetResponse contains the response from method CertificateClient.Get.
type CertificateClientGetResponse struct {
	CertificateContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// CertificateClientListByServiceResponse contains the response from method CertificateClient.ListByService.
type CertificateClientListByServiceResponse struct {
	CertificateCollection
}

// CertificateClientRefreshSecretResponse contains the response from method CertificateClient.RefreshSecret.
type CertificateClientRefreshSecretResponse struct {
	CertificateContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ClientPerformConnectivityCheckAsyncResponse contains the response from method Client.PerformConnectivityCheckAsync.
type ClientPerformConnectivityCheckAsyncResponse struct {
	ConnectivityCheckResponse
}

// ContentItemClientCreateOrUpdateResponse contains the response from method ContentItemClient.CreateOrUpdate.
type ContentItemClientCreateOrUpdateResponse struct {
	ContentItemContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ContentItemClientDeleteResponse contains the response from method ContentItemClient.Delete.
type ContentItemClientDeleteResponse struct {
	// placeholder for future response values
}

// ContentItemClientGetEntityTagResponse contains the response from method ContentItemClient.GetEntityTag.
type ContentItemClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// ContentItemClientGetResponse contains the response from method ContentItemClient.Get.
type ContentItemClientGetResponse struct {
	ContentItemContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ContentItemClientListByServiceResponse contains the response from method ContentItemClient.ListByService.
type ContentItemClientListByServiceResponse struct {
	ContentItemCollection
}

// ContentTypeClientCreateOrUpdateResponse contains the response from method ContentTypeClient.CreateOrUpdate.
type ContentTypeClientCreateOrUpdateResponse struct {
	ContentTypeContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ContentTypeClientDeleteResponse contains the response from method ContentTypeClient.Delete.
type ContentTypeClientDeleteResponse struct {
	// placeholder for future response values
}

// ContentTypeClientGetResponse contains the response from method ContentTypeClient.Get.
type ContentTypeClientGetResponse struct {
	ContentTypeContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ContentTypeClientListByServiceResponse contains the response from method ContentTypeClient.ListByService.
type ContentTypeClientListByServiceResponse struct {
	ContentTypeCollection
}

// DelegationSettingsClientCreateOrUpdateResponse contains the response from method DelegationSettingsClient.CreateOrUpdate.
type DelegationSettingsClientCreateOrUpdateResponse struct {
	PortalDelegationSettings
}

// DelegationSettingsClientGetEntityTagResponse contains the response from method DelegationSettingsClient.GetEntityTag.
type DelegationSettingsClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// DelegationSettingsClientGetResponse contains the response from method DelegationSettingsClient.Get.
type DelegationSettingsClientGetResponse struct {
	PortalDelegationSettings
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// DelegationSettingsClientListSecretsResponse contains the response from method DelegationSettingsClient.ListSecrets.
type DelegationSettingsClientListSecretsResponse struct {
	PortalSettingValidationKeyContract
}

// DelegationSettingsClientUpdateResponse contains the response from method DelegationSettingsClient.Update.
type DelegationSettingsClientUpdateResponse struct {
	// placeholder for future response values
}

// DeletedServicesClientGetByNameResponse contains the response from method DeletedServicesClient.GetByName.
type DeletedServicesClientGetByNameResponse struct {
	DeletedServiceContract
}

// DeletedServicesClientListBySubscriptionResponse contains the response from method DeletedServicesClient.ListBySubscription.
type DeletedServicesClientListBySubscriptionResponse struct {
	DeletedServicesCollection
}

// DeletedServicesClientPurgeResponse contains the response from method DeletedServicesClient.Purge.
type DeletedServicesClientPurgeResponse struct {
	DeletedServiceContract
}

// DiagnosticClientCreateOrUpdateResponse contains the response from method DiagnosticClient.CreateOrUpdate.
type DiagnosticClientCreateOrUpdateResponse struct {
	DiagnosticContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// DiagnosticClientDeleteResponse contains the response from method DiagnosticClient.Delete.
type DiagnosticClientDeleteResponse struct {
	// placeholder for future response values
}

// DiagnosticClientGetEntityTagResponse contains the response from method DiagnosticClient.GetEntityTag.
type DiagnosticClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// DiagnosticClientGetResponse contains the response from method DiagnosticClient.Get.
type DiagnosticClientGetResponse struct {
	DiagnosticContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// DiagnosticClientListByServiceResponse contains the response from method DiagnosticClient.ListByService.
type DiagnosticClientListByServiceResponse struct {
	DiagnosticCollection
}

// DiagnosticClientUpdateResponse contains the response from method DiagnosticClient.Update.
type DiagnosticClientUpdateResponse struct {
	DiagnosticContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// EmailTemplateClientCreateOrUpdateResponse contains the response from method EmailTemplateClient.CreateOrUpdate.
type EmailTemplateClientCreateOrUpdateResponse struct {
	EmailTemplateContract
}

// EmailTemplateClientDeleteResponse contains the response from method EmailTemplateClient.Delete.
type EmailTemplateClientDeleteResponse struct {
	// placeholder for future response values
}

// EmailTemplateClientGetEntityTagResponse contains the response from method EmailTemplateClient.GetEntityTag.
type EmailTemplateClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// EmailTemplateClientGetResponse contains the response from method EmailTemplateClient.Get.
type EmailTemplateClientGetResponse struct {
	EmailTemplateContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// EmailTemplateClientListByServiceResponse contains the response from method EmailTemplateClient.ListByService.
type EmailTemplateClientListByServiceResponse struct {
	EmailTemplateCollection
}

// EmailTemplateClientUpdateResponse contains the response from method EmailTemplateClient.Update.
type EmailTemplateClientUpdateResponse struct {
	EmailTemplateContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayAPIClientCreateOrUpdateResponse contains the response from method GatewayAPIClient.CreateOrUpdate.
type GatewayAPIClientCreateOrUpdateResponse struct {
	APIContract
}

// GatewayAPIClientDeleteResponse contains the response from method GatewayAPIClient.Delete.
type GatewayAPIClientDeleteResponse struct {
	// placeholder for future response values
}

// GatewayAPIClientGetEntityTagResponse contains the response from method GatewayAPIClient.GetEntityTag.
type GatewayAPIClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// GatewayAPIClientListByServiceResponse contains the response from method GatewayAPIClient.ListByService.
type GatewayAPIClientListByServiceResponse struct {
	APICollection
}

// GatewayCertificateAuthorityClientCreateOrUpdateResponse contains the response from method GatewayCertificateAuthorityClient.CreateOrUpdate.
type GatewayCertificateAuthorityClientCreateOrUpdateResponse struct {
	GatewayCertificateAuthorityContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayCertificateAuthorityClientDeleteResponse contains the response from method GatewayCertificateAuthorityClient.Delete.
type GatewayCertificateAuthorityClientDeleteResponse struct {
	// placeholder for future response values
}

// GatewayCertificateAuthorityClientGetEntityTagResponse contains the response from method GatewayCertificateAuthorityClient.GetEntityTag.
type GatewayCertificateAuthorityClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// GatewayCertificateAuthorityClientGetResponse contains the response from method GatewayCertificateAuthorityClient.Get.
type GatewayCertificateAuthorityClientGetResponse struct {
	GatewayCertificateAuthorityContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayCertificateAuthorityClientListByServiceResponse contains the response from method GatewayCertificateAuthorityClient.ListByService.
type GatewayCertificateAuthorityClientListByServiceResponse struct {
	GatewayCertificateAuthorityCollection
}

// GatewayClientCreateOrUpdateResponse contains the response from method GatewayClient.CreateOrUpdate.
type GatewayClientCreateOrUpdateResponse struct {
	GatewayContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayClientDeleteResponse contains the response from method GatewayClient.Delete.
type GatewayClientDeleteResponse struct {
	// placeholder for future response values
}

// GatewayClientGenerateTokenResponse contains the response from method GatewayClient.GenerateToken.
type GatewayClientGenerateTokenResponse struct {
	GatewayTokenContract
}

// GatewayClientGetEntityTagResponse contains the response from method GatewayClient.GetEntityTag.
type GatewayClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// GatewayClientGetResponse contains the response from method GatewayClient.Get.
type GatewayClientGetResponse struct {
	GatewayContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayClientListByServiceResponse contains the response from method GatewayClient.ListByService.
type GatewayClientListByServiceResponse struct {
	GatewayCollection
}

// GatewayClientListKeysResponse contains the response from method GatewayClient.ListKeys.
type GatewayClientListKeysResponse struct {
	GatewayKeysContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayClientRegenerateKeyResponse contains the response from method GatewayClient.RegenerateKey.
type GatewayClientRegenerateKeyResponse struct {
	// placeholder for future response values
}

// GatewayClientUpdateResponse contains the response from method GatewayClient.Update.
type GatewayClientUpdateResponse struct {
	GatewayContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayHostnameConfigurationClientCreateOrUpdateResponse contains the response from method GatewayHostnameConfigurationClient.CreateOrUpdate.
type GatewayHostnameConfigurationClientCreateOrUpdateResponse struct {
	GatewayHostnameConfigurationContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayHostnameConfigurationClientDeleteResponse contains the response from method GatewayHostnameConfigurationClient.Delete.
type GatewayHostnameConfigurationClientDeleteResponse struct {
	// placeholder for future response values
}

// GatewayHostnameConfigurationClientGetEntityTagResponse contains the response from method GatewayHostnameConfigurationClient.GetEntityTag.
type GatewayHostnameConfigurationClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// GatewayHostnameConfigurationClientGetResponse contains the response from method GatewayHostnameConfigurationClient.Get.
type GatewayHostnameConfigurationClientGetResponse struct {
	GatewayHostnameConfigurationContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GatewayHostnameConfigurationClientListByServiceResponse contains the response from method GatewayHostnameConfigurationClient.ListByService.
type GatewayHostnameConfigurationClientListByServiceResponse struct {
	GatewayHostnameConfigurationCollection
}

// GlobalSchemaClientCreateOrUpdateResponse contains the response from method GlobalSchemaClient.CreateOrUpdate.
type GlobalSchemaClientCreateOrUpdateResponse struct {
	GlobalSchemaContract
}

// GlobalSchemaClientDeleteResponse contains the response from method GlobalSchemaClient.Delete.
type GlobalSchemaClientDeleteResponse struct {
	// placeholder for future response values
}

// GlobalSchemaClientGetEntityTagResponse contains the response from method GlobalSchemaClient.GetEntityTag.
type GlobalSchemaClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// GlobalSchemaClientGetResponse contains the response from method GlobalSchemaClient.Get.
type GlobalSchemaClientGetResponse struct {
	GlobalSchemaContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GlobalSchemaClientListByServiceResponse contains the response from method GlobalSchemaClient.ListByService.
type GlobalSchemaClientListByServiceResponse struct {
	GlobalSchemaCollection
}

// GroupClientCreateOrUpdateResponse contains the response from method GroupClient.CreateOrUpdate.
type GroupClientCreateOrUpdateResponse struct {
	GroupContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GroupClientDeleteResponse contains the response from method GroupClient.Delete.
type GroupClientDeleteResponse struct {
	// placeholder for future response values
}

// GroupClientGetEntityTagResponse contains the response from method GroupClient.GetEntityTag.
type GroupClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// GroupClientGetResponse contains the response from method GroupClient.Get.
type GroupClientGetResponse struct {
	GroupContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GroupClientListByServiceResponse contains the response from method GroupClient.ListByService.
type GroupClientListByServiceResponse struct {
	GroupCollection
}

// GroupClientUpdateResponse contains the response from method GroupClient.Update.
type GroupClientUpdateResponse struct {
	GroupContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// GroupUserClientCheckEntityExistsResponse contains the response from method GroupUserClient.CheckEntityExists.
type GroupUserClientCheckEntityExistsResponse struct {
	// Success indicates if the operation succeeded or failed.
	Success bool
}

// GroupUserClientCreateResponse contains the response from method GroupUserClient.Create.
type GroupUserClientCreateResponse struct {
	UserContract
}

// GroupUserClientDeleteResponse contains the response from method GroupUserClient.Delete.
type GroupUserClientDeleteResponse struct {
	// placeholder for future response values
}

// GroupUserClientListResponse contains the response from method GroupUserClient.List.
type GroupUserClientListResponse struct {
	UserCollection
}

// IdentityProviderClientCreateOrUpdateResponse contains the response from method IdentityProviderClient.CreateOrUpdate.
type IdentityProviderClientCreateOrUpdateResponse struct {
	IdentityProviderContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// IdentityProviderClientDeleteResponse contains the response from method IdentityProviderClient.Delete.
type IdentityProviderClientDeleteResponse struct {
	// placeholder for future response values
}

// IdentityProviderClientGetEntityTagResponse contains the response from method IdentityProviderClient.GetEntityTag.
type IdentityProviderClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// IdentityProviderClientGetResponse contains the response from method IdentityProviderClient.Get.
type IdentityProviderClientGetResponse struct {
	IdentityProviderContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// IdentityProviderClientListByServiceResponse contains the response from method IdentityProviderClient.ListByService.
type IdentityProviderClientListByServiceResponse struct {
	IdentityProviderList
}

// IdentityProviderClientListSecretsResponse contains the response from method IdentityProviderClient.ListSecrets.
type IdentityProviderClientListSecretsResponse struct {
	ClientSecretContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// IdentityProviderClientUpdateResponse contains the response from method IdentityProviderClient.Update.
type IdentityProviderClientUpdateResponse struct {
	IdentityProviderContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// IssueClientGetResponse contains the response from method IssueClient.Get.
type IssueClientGetResponse struct {
	IssueContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// IssueClientListByServiceResponse contains the response from method IssueClient.ListByService.
type IssueClientListByServiceResponse struct {
	IssueCollection
}

// LoggerClientCreateOrUpdateResponse contains the response from method LoggerClient.CreateOrUpdate.
type LoggerClientCreateOrUpdateResponse struct {
	LoggerContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// LoggerClientDeleteResponse contains the response from method LoggerClient.Delete.
type LoggerClientDeleteResponse struct {
	// placeholder for future response values
}

// LoggerClientGetEntityTagResponse contains the response from method LoggerClient.GetEntityTag.
type LoggerClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// LoggerClientGetResponse contains the response from method LoggerClient.Get.
type LoggerClientGetResponse struct {
	LoggerContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// LoggerClientListByServiceResponse contains the response from method LoggerClient.ListByService.
type LoggerClientListByServiceResponse struct {
	LoggerCollection
}

// LoggerClientUpdateResponse contains the response from method LoggerClient.Update.
type LoggerClientUpdateResponse struct {
	LoggerContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// NamedValueClientCreateOrUpdateResponse contains the response from method NamedValueClient.CreateOrUpdate.
type NamedValueClientCreateOrUpdateResponse struct {
	NamedValueContract
}

// NamedValueClientDeleteResponse contains the response from method NamedValueClient.Delete.
type NamedValueClientDeleteResponse struct {
	// placeholder for future response values
}

// NamedValueClientGetEntityTagResponse contains the response from method NamedValueClient.GetEntityTag.
type NamedValueClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// NamedValueClientGetResponse contains the response from method NamedValueClient.Get.
type NamedValueClientGetResponse struct {
	NamedValueContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// NamedValueClientListByServiceResponse contains the response from method NamedValueClient.ListByService.
type NamedValueClientListByServiceResponse struct {
	NamedValueCollection
}

// NamedValueClientListValueResponse contains the response from method NamedValueClient.ListValue.
type NamedValueClientListValueResponse struct {
	NamedValueSecretContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// NamedValueClientRefreshSecretResponse contains the response from method NamedValueClient.RefreshSecret.
type NamedValueClientRefreshSecretResponse struct {
	NamedValueContract
}

// NamedValueClientUpdateResponse contains the response from method NamedValueClient.Update.
type NamedValueClientUpdateResponse struct {
	NamedValueContract
}

// NetworkStatusClientListByLocationResponse contains the response from method NetworkStatusClient.ListByLocation.
type NetworkStatusClientListByLocationResponse struct {
	NetworkStatusContract
}

// NetworkStatusClientListByServiceResponse contains the response from method NetworkStatusClient.ListByService.
type NetworkStatusClientListByServiceResponse struct {
	// List of Network Status values.
	NetworkStatusContractByLocationArray []*NetworkStatusContractByLocation
}

// NotificationClientCreateOrUpdateResponse contains the response from method NotificationClient.CreateOrUpdate.
type NotificationClientCreateOrUpdateResponse struct {
	NotificationContract
}

// NotificationClientGetResponse contains the response from method NotificationClient.Get.
type NotificationClientGetResponse struct {
	NotificationContract
}

// NotificationClientListByServiceResponse contains the response from method NotificationClient.ListByService.
type NotificationClientListByServiceResponse struct {
	NotificationCollection
}

// NotificationRecipientEmailClientCheckEntityExistsResponse contains the response from method NotificationRecipientEmailClient.CheckEntityExists.
type NotificationRecipientEmailClientCheckEntityExistsResponse struct {
	// Success indicates if the operation succeeded or failed.
	Success bool
}

// NotificationRecipientEmailClientCreateOrUpdateResponse contains the response from method NotificationRecipientEmailClient.CreateOrUpdate.
type NotificationRecipientEmailClientCreateOrUpdateResponse struct {
	RecipientEmailContract
}

// NotificationRecipientEmailClientDeleteResponse contains the response from method NotificationRecipientEmailClient.Delete.
type NotificationRecipientEmailClientDeleteResponse struct {
	// placeholder for future response values
}

// NotificationRecipientEmailClientListByNotificationResponse contains the response from method NotificationRecipientEmailClient.ListByNotification.
type NotificationRecipientEmailClientListByNotificationResponse struct {
	RecipientEmailCollection
}

// NotificationRecipientUserClientCheckEntityExistsResponse contains the response from method NotificationRecipientUserClient.CheckEntityExists.
type NotificationRecipientUserClientCheckEntityExistsResponse struct {
	// Success indicates if the operation succeeded or failed.
	Success bool
}

// NotificationRecipientUserClientCreateOrUpdateResponse contains the response from method NotificationRecipientUserClient.CreateOrUpdate.
type NotificationRecipientUserClientCreateOrUpdateResponse struct {
	RecipientUserContract
}

// NotificationRecipientUserClientDeleteResponse contains the response from method NotificationRecipientUserClient.Delete.
type NotificationRecipientUserClientDeleteResponse struct {
	// placeholder for future response values
}

// NotificationRecipientUserClientListByNotificationResponse contains the response from method NotificationRecipientUserClient.ListByNotification.
type NotificationRecipientUserClientListByNotificationResponse struct {
	RecipientUserCollection
}

// OpenIDConnectProviderClientCreateOrUpdateResponse contains the response from method OpenIDConnectProviderClient.CreateOrUpdate.
type OpenIDConnectProviderClientCreateOrUpdateResponse struct {
	OpenidConnectProviderContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// OpenIDConnectProviderClientDeleteResponse contains the response from method OpenIDConnectProviderClient.Delete.
type OpenIDConnectProviderClientDeleteResponse struct {
	// placeholder for future response values
}

// OpenIDConnectProviderClientGetEntityTagResponse contains the response from method OpenIDConnectProviderClient.GetEntityTag.
type OpenIDConnectProviderClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// OpenIDConnectProviderClientGetResponse contains the response from method OpenIDConnectProviderClient.Get.
type OpenIDConnectProviderClientGetResponse struct {
	OpenidConnectProviderContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// OpenIDConnectProviderClientListByServiceResponse contains the response from method OpenIDConnectProviderClient.ListByService.
type OpenIDConnectProviderClientListByServiceResponse struct {
	OpenIDConnectProviderCollection
}

// OpenIDConnectProviderClientListSecretsResponse contains the response from method OpenIDConnectProviderClient.ListSecrets.
type OpenIDConnectProviderClientListSecretsResponse struct {
	ClientSecretContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// OpenIDConnectProviderClientUpdateResponse contains the response from method OpenIDConnectProviderClient.Update.
type OpenIDConnectProviderClientUpdateResponse struct {
	OpenidConnectProviderContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// OperationClientListByTagsResponse contains the response from method OperationClient.ListByTags.
type OperationClientListByTagsResponse struct {
	TagResourceCollection
}

// OperationsClientListResponse contains the response from method OperationsClient.List.
type OperationsClientListResponse struct {
	OperationListResult
}

// OutboundNetworkDependenciesEndpointsClientListByServiceResponse contains the response from method OutboundNetworkDependenciesEndpointsClient.ListByService.
type OutboundNetworkDependenciesEndpointsClientListByServiceResponse struct {
	OutboundEnvironmentEndpointList
}

// PolicyClientCreateOrUpdateResponse contains the response from method PolicyClient.CreateOrUpdate.
type PolicyClientCreateOrUpdateResponse struct {
	PolicyContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// PolicyClientDeleteResponse contains the response from method PolicyClient.Delete.
type PolicyClientDeleteResponse struct {
	// placeholder for future response values
}

// PolicyClientGetEntityTagResponse contains the response from method PolicyClient.GetEntityTag.
type PolicyClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// PolicyClientGetResponse contains the response from method PolicyClient.Get.
type PolicyClientGetResponse struct {
	PolicyContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// PolicyClientListByServiceResponse contains the response from method PolicyClient.ListByService.
type PolicyClientListByServiceResponse struct {
	PolicyCollection
}

// PolicyDescriptionClientListByServiceResponse contains the response from method PolicyDescriptionClient.ListByService.
type PolicyDescriptionClientListByServiceResponse struct {
	PolicyDescriptionCollection
}

// PortalRevisionClientCreateOrUpdateResponse contains the response from method PortalRevisionClient.CreateOrUpdate.
type PortalRevisionClientCreateOrUpdateResponse struct {
	PortalRevisionContract
}

// PortalRevisionClientGetEntityTagResponse contains the response from method PortalRevisionClient.GetEntityTag.
type PortalRevisionClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// PortalRevisionClientGetResponse contains the response from method PortalRevisionClient.Get.
type PortalRevisionClientGetResponse struct {
	PortalRevisionContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// PortalRevisionClientListByServiceResponse contains the response from method PortalRevisionClient.ListByService.
type PortalRevisionClientListByServiceResponse struct {
	PortalRevisionCollection
}

// PortalRevisionClientUpdateResponse contains the response from method PortalRevisionClient.Update.
type PortalRevisionClientUpdateResponse struct {
	PortalRevisionContract
}

// PortalSettingsClientListByServiceResponse contains the response from method PortalSettingsClient.ListByService.
type PortalSettingsClientListByServiceResponse struct {
	PortalSettingsCollection
}

// PrivateEndpointConnectionClientCreateOrUpdateResponse contains the response from method PrivateEndpointConnectionClient.CreateOrUpdate.
type PrivateEndpointConnectionClientCreateOrUpdateResponse struct {
	PrivateEndpointConnection
}

// PrivateEndpointConnectionClientDeleteResponse contains the response from method PrivateEndpointConnectionClient.Delete.
type PrivateEndpointConnectionClientDeleteResponse struct {
	// placeholder for future response values
}

// PrivateEndpointConnectionClientGetByNameResponse contains the response from method PrivateEndpointConnectionClient.GetByName.
type PrivateEndpointConnectionClientGetByNameResponse struct {
	PrivateEndpointConnection
}

// PrivateEndpointConnectionClientGetPrivateLinkResourceResponse contains the response from method PrivateEndpointConnectionClient.GetPrivateLinkResource.
type PrivateEndpointConnectionClientGetPrivateLinkResourceResponse struct {
	PrivateLinkResource
}

// PrivateEndpointConnectionClientListByServiceResponse contains the response from method PrivateEndpointConnectionClient.ListByService.
type PrivateEndpointConnectionClientListByServiceResponse struct {
	PrivateEndpointConnectionListResult
}

// PrivateEndpointConnectionClientListPrivateLinkResourcesResponse contains the response from method PrivateEndpointConnectionClient.ListPrivateLinkResources.
type PrivateEndpointConnectionClientListPrivateLinkResourcesResponse struct {
	PrivateLinkResourceListResult
}

// ProductAPIClientCheckEntityExistsResponse contains the response from method ProductAPIClient.CheckEntityExists.
type ProductAPIClientCheckEntityExistsResponse struct {
	// Success indicates if the operation succeeded or failed.
	Success bool
}

// ProductAPIClientCreateOrUpdateResponse contains the response from method ProductAPIClient.CreateOrUpdate.
type ProductAPIClientCreateOrUpdateResponse struct {
	APIContract
}

// ProductAPIClientDeleteResponse contains the response from method ProductAPIClient.Delete.
type ProductAPIClientDeleteResponse struct {
	// placeholder for future response values
}

// ProductAPIClientListByProductResponse contains the response from method ProductAPIClient.ListByProduct.
type ProductAPIClientListByProductResponse struct {
	APICollection
}

// ProductClientCreateOrUpdateResponse contains the response from method ProductClient.CreateOrUpdate.
type ProductClientCreateOrUpdateResponse struct {
	ProductContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ProductClientDeleteResponse contains the response from method ProductClient.Delete.
type ProductClientDeleteResponse struct {
	// placeholder for future response values
}

// ProductClientGetEntityTagResponse contains the response from method ProductClient.GetEntityTag.
type ProductClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// ProductClientGetResponse contains the response from method ProductClient.Get.
type ProductClientGetResponse struct {
	ProductContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ProductClientListByServiceResponse contains the response from method ProductClient.ListByService.
type ProductClientListByServiceResponse struct {
	ProductCollection
}

// ProductClientListByTagsResponse contains the response from method ProductClient.ListByTags.
type ProductClientListByTagsResponse struct {
	TagResourceCollection
}

// ProductClientUpdateResponse contains the response from method ProductClient.Update.
type ProductClientUpdateResponse struct {
	ProductContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ProductGroupClientCheckEntityExistsResponse contains the response from method ProductGroupClient.CheckEntityExists.
type ProductGroupClientCheckEntityExistsResponse struct {
	// Success indicates if the operation succeeded or failed.
	Success bool
}

// ProductGroupClientCreateOrUpdateResponse contains the response from method ProductGroupClient.CreateOrUpdate.
type ProductGroupClientCreateOrUpdateResponse struct {
	GroupContract
}

// ProductGroupClientDeleteResponse contains the response from method ProductGroupClient.Delete.
type ProductGroupClientDeleteResponse struct {
	// placeholder for future response values
}

// ProductGroupClientListByProductResponse contains the response from method ProductGroupClient.ListByProduct.
type ProductGroupClientListByProductResponse struct {
	GroupCollection
}

// ProductPolicyClientCreateOrUpdateResponse contains the response from method ProductPolicyClient.CreateOrUpdate.
type ProductPolicyClientCreateOrUpdateResponse struct {
	PolicyContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ProductPolicyClientDeleteResponse contains the response from method ProductPolicyClient.Delete.
type ProductPolicyClientDeleteResponse struct {
	// placeholder for future response values
}

// ProductPolicyClientGetEntityTagResponse contains the response from method ProductPolicyClient.GetEntityTag.
type ProductPolicyClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// ProductPolicyClientGetResponse contains the response from method ProductPolicyClient.Get.
type ProductPolicyClientGetResponse struct {
	PolicyContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// ProductPolicyClientListByProductResponse contains the response from method ProductPolicyClient.ListByProduct.
type ProductPolicyClientListByProductResponse struct {
	PolicyCollection
}

// ProductSubscriptionsClientListResponse contains the response from method ProductSubscriptionsClient.List.
type ProductSubscriptionsClientListResponse struct {
	SubscriptionCollection
}

// QuotaByCounterKeysClientListByServiceResponse contains the response from method QuotaByCounterKeysClient.ListByService.
type QuotaByCounterKeysClientListByServiceResponse struct {
	QuotaCounterCollection
}

// QuotaByCounterKeysClientUpdateResponse contains the response from method QuotaByCounterKeysClient.Update.
type QuotaByCounterKeysClientUpdateResponse struct {
	QuotaCounterCollection
}

// QuotaByPeriodKeysClientGetResponse contains the response from method QuotaByPeriodKeysClient.Get.
type QuotaByPeriodKeysClientGetResponse struct {
	QuotaCounterContract
}

// QuotaByPeriodKeysClientUpdateResponse contains the response from method QuotaByPeriodKeysClient.Update.
type QuotaByPeriodKeysClientUpdateResponse struct {
	QuotaCounterContract
}

// RegionClientListByServiceResponse contains the response from method RegionClient.ListByService.
type RegionClientListByServiceResponse struct {
	RegionListResult
}

// ReportsClientListByAPIResponse contains the response from method ReportsClient.ListByAPI.
type ReportsClientListByAPIResponse struct {
	ReportCollection
}

// ReportsClientListByGeoResponse contains the response from method ReportsClient.ListByGeo.
type ReportsClientListByGeoResponse struct {
	ReportCollection
}

// ReportsClientListByOperationResponse contains the response from method ReportsClient.ListByOperation.
type ReportsClientListByOperationResponse struct {
	ReportCollection
}

// ReportsClientListByProductResponse contains the response from method ReportsClient.ListByProduct.
type ReportsClientListByProductResponse struct {
	ReportCollection
}

// ReportsClientListByRequestResponse contains the response from method ReportsClient.ListByRequest.
type ReportsClientListByRequestResponse struct {
	RequestReportCollection
}

// ReportsClientListBySubscriptionResponse contains the response from method ReportsClient.ListBySubscription.
type ReportsClientListBySubscriptionResponse struct {
	ReportCollection
}

// ReportsClientListByTimeResponse contains the response from method ReportsClient.ListByTime.
type ReportsClientListByTimeResponse struct {
	ReportCollection
}

// ReportsClientListByUserResponse contains the response from method ReportsClient.ListByUser.
type ReportsClientListByUserResponse struct {
	ReportCollection
}

// SKUsClientListResponse contains the response from method SKUsClient.List.
type SKUsClientListResponse struct {
	SKUsResult
}

// ServiceClientApplyNetworkConfigurationUpdatesResponse contains the response from method ServiceClient.ApplyNetworkConfigurationUpdates.
type ServiceClientApplyNetworkConfigurationUpdatesResponse struct {
	ServiceResource
}

// ServiceClientBackupResponse contains the response from method ServiceClient.Backup.
type ServiceClientBackupResponse struct {
	ServiceResource
}

// ServiceClientCheckNameAvailabilityResponse contains the response from method ServiceClient.CheckNameAvailability.
type ServiceClientCheckNameAvailabilityResponse struct {
	ServiceNameAvailabilityResult
}

// ServiceClientCreateOrUpdateResponse contains the response from method ServiceClient.CreateOrUpdate.
type ServiceClientCreateOrUpdateResponse struct {
	ServiceResource
}

// ServiceClientDeleteResponse contains the response from method ServiceClient.Delete.
type ServiceClientDeleteResponse struct {
	ServiceResource
}

// ServiceClientGetDomainOwnershipIdentifierResponse contains the response from method ServiceClient.GetDomainOwnershipIdentifier.
type ServiceClientGetDomainOwnershipIdentifierResponse struct {
	ServiceGetDomainOwnershipIdentifierResult
}

// ServiceClientGetResponse contains the response from method ServiceClient.Get.
type ServiceClientGetResponse struct {
	ServiceResource
}

// ServiceClientGetSsoTokenResponse contains the response from method ServiceClient.GetSsoToken.
type ServiceClientGetSsoTokenResponse struct {
	ServiceGetSsoTokenResult
}

// ServiceClientListByResourceGroupResponse contains the response from method ServiceClient.ListByResourceGroup.
type ServiceClientListByResourceGroupResponse struct {
	ServiceListResult
}

// ServiceClientListResponse contains the response from method ServiceClient.List.
type ServiceClientListResponse struct {
	ServiceListResult
}

// ServiceClientRestoreResponse contains the response from method ServiceClient.Restore.
type ServiceClientRestoreResponse struct {
	ServiceResource
}

// ServiceClientUpdateResponse contains the response from method ServiceClient.Update.
type ServiceClientUpdateResponse struct {
	ServiceResource
}

// ServiceSKUsClientListAvailableServiceSKUsResponse contains the response from method ServiceSKUsClient.ListAvailableServiceSKUs.
type ServiceSKUsClientListAvailableServiceSKUsResponse struct {
	ResourceSKUResults
}

// SignInSettingsClientCreateOrUpdateResponse contains the response from method SignInSettingsClient.CreateOrUpdate.
type SignInSettingsClientCreateOrUpdateResponse struct {
	PortalSigninSettings
}

// SignInSettingsClientGetEntityTagResponse contains the response from method SignInSettingsClient.GetEntityTag.
type SignInSettingsClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// SignInSettingsClientGetResponse contains the response from method SignInSettingsClient.Get.
type SignInSettingsClientGetResponse struct {
	PortalSigninSettings
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// SignInSettingsClientUpdateResponse contains the response from method SignInSettingsClient.Update.
type SignInSettingsClientUpdateResponse struct {
	// placeholder for future response values
}

// SignUpSettingsClientCreateOrUpdateResponse contains the response from method SignUpSettingsClient.CreateOrUpdate.
type SignUpSettingsClientCreateOrUpdateResponse struct {
	PortalSignupSettings
}

// SignUpSettingsClientGetEntityTagResponse contains the response from method SignUpSettingsClient.GetEntityTag.
type SignUpSettingsClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// SignUpSettingsClientGetResponse contains the response from method SignUpSettingsClient.Get.
type SignUpSettingsClientGetResponse struct {
	PortalSignupSettings
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// SignUpSettingsClientUpdateResponse contains the response from method SignUpSettingsClient.Update.
type SignUpSettingsClientUpdateResponse struct {
	// placeholder for future response values
}

// SubscriptionClientCreateOrUpdateResponse contains the response from method SubscriptionClient.CreateOrUpdate.
type SubscriptionClientCreateOrUpdateResponse struct {
	SubscriptionContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// SubscriptionClientDeleteResponse contains the response from method SubscriptionClient.Delete.
type SubscriptionClientDeleteResponse struct {
	// placeholder for future response values
}

// SubscriptionClientGetEntityTagResponse contains the response from method SubscriptionClient.GetEntityTag.
type SubscriptionClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// SubscriptionClientGetResponse contains the response from method SubscriptionClient.Get.
type SubscriptionClientGetResponse struct {
	SubscriptionContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// SubscriptionClientListResponse contains the response from method SubscriptionClient.List.
type SubscriptionClientListResponse struct {
	SubscriptionCollection
}

// SubscriptionClientListSecretsResponse contains the response from method SubscriptionClient.ListSecrets.
type SubscriptionClientListSecretsResponse struct {
	SubscriptionKeysContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// SubscriptionClientRegeneratePrimaryKeyResponse contains the response from method SubscriptionClient.RegeneratePrimaryKey.
type SubscriptionClientRegeneratePrimaryKeyResponse struct {
	// placeholder for future response values
}

// SubscriptionClientRegenerateSecondaryKeyResponse contains the response from method SubscriptionClient.RegenerateSecondaryKey.
type SubscriptionClientRegenerateSecondaryKeyResponse struct {
	// placeholder for future response values
}

// SubscriptionClientUpdateResponse contains the response from method SubscriptionClient.Update.
type SubscriptionClientUpdateResponse struct {
	SubscriptionContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TagClientAssignToAPIResponse contains the response from method TagClient.AssignToAPI.
type TagClientAssignToAPIResponse struct {
	TagContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TagClientAssignToOperationResponse contains the response from method TagClient.AssignToOperation.
type TagClientAssignToOperationResponse struct {
	TagContract
}

// TagClientAssignToProductResponse contains the response from method TagClient.AssignToProduct.
type TagClientAssignToProductResponse struct {
	TagContract
}

// TagClientCreateOrUpdateResponse contains the response from method TagClient.CreateOrUpdate.
type TagClientCreateOrUpdateResponse struct {
	TagContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TagClientDeleteResponse contains the response from method TagClient.Delete.
type TagClientDeleteResponse struct {
	// placeholder for future response values
}

// TagClientDetachFromAPIResponse contains the response from method TagClient.DetachFromAPI.
type TagClientDetachFromAPIResponse struct {
	// placeholder for future response values
}

// TagClientDetachFromOperationResponse contains the response from method TagClient.DetachFromOperation.
type TagClientDetachFromOperationResponse struct {
	// placeholder for future response values
}

// TagClientDetachFromProductResponse contains the response from method TagClient.DetachFromProduct.
type TagClientDetachFromProductResponse struct {
	// placeholder for future response values
}

// TagClientGetByAPIResponse contains the response from method TagClient.GetByAPI.
type TagClientGetByAPIResponse struct {
	TagContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TagClientGetByOperationResponse contains the response from method TagClient.GetByOperation.
type TagClientGetByOperationResponse struct {
	TagContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TagClientGetByProductResponse contains the response from method TagClient.GetByProduct.
type TagClientGetByProductResponse struct {
	TagContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TagClientGetEntityStateByAPIResponse contains the response from method TagClient.GetEntityStateByAPI.
type TagClientGetEntityStateByAPIResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// TagClientGetEntityStateByOperationResponse contains the response from method TagClient.GetEntityStateByOperation.
type TagClientGetEntityStateByOperationResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// TagClientGetEntityStateByProductResponse contains the response from method TagClient.GetEntityStateByProduct.
type TagClientGetEntityStateByProductResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// TagClientGetEntityStateResponse contains the response from method TagClient.GetEntityState.
type TagClientGetEntityStateResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// TagClientGetResponse contains the response from method TagClient.Get.
type TagClientGetResponse struct {
	TagContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TagClientListByAPIResponse contains the response from method TagClient.ListByAPI.
type TagClientListByAPIResponse struct {
	TagCollection
}

// TagClientListByOperationResponse contains the response from method TagClient.ListByOperation.
type TagClientListByOperationResponse struct {
	TagCollection
}

// TagClientListByProductResponse contains the response from method TagClient.ListByProduct.
type TagClientListByProductResponse struct {
	TagCollection
}

// TagClientListByServiceResponse contains the response from method TagClient.ListByService.
type TagClientListByServiceResponse struct {
	TagCollection
}

// TagClientUpdateResponse contains the response from method TagClient.Update.
type TagClientUpdateResponse struct {
	TagContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TagResourceClientListByServiceResponse contains the response from method TagResourceClient.ListByService.
type TagResourceClientListByServiceResponse struct {
	TagResourceCollection
}

// TenantAccessClientCreateResponse contains the response from method TenantAccessClient.Create.
type TenantAccessClientCreateResponse struct {
	AccessInformationContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TenantAccessClientGetEntityTagResponse contains the response from method TenantAccessClient.GetEntityTag.
type TenantAccessClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// TenantAccessClientGetResponse contains the response from method TenantAccessClient.Get.
type TenantAccessClientGetResponse struct {
	AccessInformationContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TenantAccessClientListByServiceResponse contains the response from method TenantAccessClient.ListByService.
type TenantAccessClientListByServiceResponse struct {
	AccessInformationCollection
}

// TenantAccessClientListSecretsResponse contains the response from method TenantAccessClient.ListSecrets.
type TenantAccessClientListSecretsResponse struct {
	AccessInformationSecretsContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TenantAccessClientRegeneratePrimaryKeyResponse contains the response from method TenantAccessClient.RegeneratePrimaryKey.
type TenantAccessClientRegeneratePrimaryKeyResponse struct {
	// placeholder for future response values
}

// TenantAccessClientRegenerateSecondaryKeyResponse contains the response from method TenantAccessClient.RegenerateSecondaryKey.
type TenantAccessClientRegenerateSecondaryKeyResponse struct {
	// placeholder for future response values
}

// TenantAccessClientUpdateResponse contains the response from method TenantAccessClient.Update.
type TenantAccessClientUpdateResponse struct {
	AccessInformationContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TenantAccessGitClientRegeneratePrimaryKeyResponse contains the response from method TenantAccessGitClient.RegeneratePrimaryKey.
type TenantAccessGitClientRegeneratePrimaryKeyResponse struct {
	// placeholder for future response values
}

// TenantAccessGitClientRegenerateSecondaryKeyResponse contains the response from method TenantAccessGitClient.RegenerateSecondaryKey.
type TenantAccessGitClientRegenerateSecondaryKeyResponse struct {
	// placeholder for future response values
}

// TenantConfigurationClientDeployResponse contains the response from method TenantConfigurationClient.Deploy.
type TenantConfigurationClientDeployResponse struct {
	OperationResultContract
}

// TenantConfigurationClientGetSyncStateResponse contains the response from method TenantConfigurationClient.GetSyncState.
type TenantConfigurationClientGetSyncStateResponse struct {
	TenantConfigurationSyncStateContract
}

// TenantConfigurationClientSaveResponse contains the response from method TenantConfigurationClient.Save.
type TenantConfigurationClientSaveResponse struct {
	OperationResultContract
}

// TenantConfigurationClientValidateResponse contains the response from method TenantConfigurationClient.Validate.
type TenantConfigurationClientValidateResponse struct {
	OperationResultContract
}

// TenantSettingsClientGetResponse contains the response from method TenantSettingsClient.Get.
type TenantSettingsClientGetResponse struct {
	TenantSettingsContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// TenantSettingsClientListByServiceResponse contains the response from method TenantSettingsClient.ListByService.
type TenantSettingsClientListByServiceResponse struct {
	TenantSettingsCollection
}

// UserClientCreateOrUpdateResponse contains the response from method UserClient.CreateOrUpdate.
type UserClientCreateOrUpdateResponse struct {
	UserContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// UserClientDeleteResponse contains the response from method UserClient.Delete.
type UserClientDeleteResponse struct {
	// placeholder for future response values
}

// UserClientGenerateSsoURLResponse contains the response from method UserClient.GenerateSsoURL.
type UserClientGenerateSsoURLResponse struct {
	GenerateSsoURLResult
}

// UserClientGetEntityTagResponse contains the response from method UserClient.GetEntityTag.
type UserClientGetEntityTagResponse struct {
	// ETag contains the information returned from the ETag header response.
	ETag *string

	// Success indicates if the operation succeeded or failed.
	Success bool
}

// UserClientGetResponse contains the response from method UserClient.Get.
type UserClientGetResponse struct {
	UserContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// UserClientGetSharedAccessTokenResponse contains the response from method UserClient.GetSharedAccessToken.
type UserClientGetSharedAccessTokenResponse struct {
	UserTokenResult
}

// UserClientListByServiceResponse contains the response from method UserClient.ListByService.
type UserClientListByServiceResponse struct {
	UserCollection
}

// UserClientUpdateResponse contains the response from method UserClient.Update.
type UserClientUpdateResponse struct {
	UserContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// UserConfirmationPasswordClientSendResponse contains the response from method UserConfirmationPasswordClient.Send.
type UserConfirmationPasswordClientSendResponse struct {
	// placeholder for future response values
}

// UserGroupClientListResponse contains the response from method UserGroupClient.List.
type UserGroupClientListResponse struct {
	GroupCollection
}

// UserIdentitiesClientListResponse contains the response from method UserIdentitiesClient.List.
type UserIdentitiesClientListResponse struct {
	UserIdentityCollection
}

// UserSubscriptionClientGetResponse contains the response from method UserSubscriptionClient.Get.
type UserSubscriptionClientGetResponse struct {
	SubscriptionContract
	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// UserSubscriptionClientListResponse contains the response from method UserSubscriptionClient.List.
type UserSubscriptionClientListResponse struct {
	SubscriptionCollection
}
