//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armengagementfabric

// Account - The EngagementFabric account
type Account struct {
	// REQUIRED; The location of the resource
	Location *string `json:"location,omitempty"`

	// REQUIRED; The SKU of the resource
	SKU *SKU `json:"sku,omitempty"`

	// The tags of the resource
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The ID of the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified type of the resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccountList - The list of the EngagementFabric accounts
type AccountList struct {
	// EngagementFabric accounts
	Value []*Account `json:"value,omitempty"`
}

// AccountPatch - The patch of EngagementFabric account
type AccountPatch struct {
	// The tags of the resource
	Tags map[string]*string `json:"tags,omitempty"`
}

// AccountsClientCreateOrUpdateOptions contains the optional parameters for the AccountsClient.CreateOrUpdate method.
type AccountsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientDeleteOptions contains the optional parameters for the AccountsClient.Delete method.
type AccountsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientGetOptions contains the optional parameters for the AccountsClient.Get method.
type AccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListByResourceGroupOptions contains the optional parameters for the AccountsClient.ListByResourceGroup method.
type AccountsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListChannelTypesOptions contains the optional parameters for the AccountsClient.ListChannelTypes method.
type AccountsClientListChannelTypesOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListKeysOptions contains the optional parameters for the AccountsClient.ListKeys method.
type AccountsClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListOptions contains the optional parameters for the AccountsClient.List method.
type AccountsClientListOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientRegenerateKeyOptions contains the optional parameters for the AccountsClient.RegenerateKey method.
type AccountsClientRegenerateKeyOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientUpdateOptions contains the optional parameters for the AccountsClient.Update method.
type AccountsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// Channel - The EngagementFabric channel
type Channel struct {
	// The properties of the channel
	Properties *ChannelProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified type of the resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ChannelList - The list of the EngagementFabric channels
type ChannelList struct {
	// EngagementFabric channels
	Value []*Channel `json:"value,omitempty"`
}

// ChannelProperties - The EngagementFabric channel properties
type ChannelProperties struct {
	// REQUIRED; The channel type
	ChannelType *string `json:"channelType,omitempty"`

	// The functions to be enabled for the channel
	ChannelFunctions []*string `json:"channelFunctions,omitempty"`

	// The channel credentials
	Credentials map[string]*string `json:"credentials,omitempty"`
}

// ChannelTypeDescription - EngagementFabric channel description
type ChannelTypeDescription struct {
	// Text description for the channel
	ChannelDescription *string `json:"channelDescription,omitempty"`

	// All the available functions for the channel
	ChannelFunctions []*string `json:"channelFunctions,omitempty"`

	// Channel type
	ChannelType *string `json:"channelType,omitempty"`
}

// ChannelTypeDescriptionList - List of the EngagementFabric channel descriptions
type ChannelTypeDescriptionList struct {
	// Channel descriptions
	Value []*ChannelTypeDescription `json:"value,omitempty"`
}

// ChannelsClientCreateOrUpdateOptions contains the optional parameters for the ChannelsClient.CreateOrUpdate method.
type ChannelsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ChannelsClientDeleteOptions contains the optional parameters for the ChannelsClient.Delete method.
type ChannelsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ChannelsClientGetOptions contains the optional parameters for the ChannelsClient.Get method.
type ChannelsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ChannelsClientListByAccountOptions contains the optional parameters for the ChannelsClient.ListByAccount method.
type ChannelsClientListByAccountOptions struct {
	// placeholder for future optional parameters
}

// CheckNameAvailabilityParameter - The parameter for name availability check
type CheckNameAvailabilityParameter struct {
	// REQUIRED; The name to be checked
	Name *string `json:"name,omitempty"`

	// REQUIRED; The fully qualified resource type for the name to be checked
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResult - The result of name availability check
type CheckNameAvailabilityResult struct {
	// READ-ONLY; The message if name is unavailable
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The name to be checked
	NameAvailable *bool `json:"nameAvailable,omitempty" azure:"ro"`

	// READ-ONLY; The reason if name is unavailable
	Reason *CheckNameUnavailableReason `json:"reason,omitempty" azure:"ro"`
}

// ClientCheckNameAvailabilityOptions contains the optional parameters for the Client.CheckNameAvailability method.
type ClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// CloudError - The default error response
type CloudError struct {
	// Content of the error
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - Content of the default error response
type CloudErrorBody struct {
	// The error code
	Code *string `json:"code,omitempty"`

	// The list of additional details
	Details []*CloudErrorBody `json:"details,omitempty"`

	// The error message
	Message *string `json:"message,omitempty"`

	// The target of the particular error
	Target *string `json:"target,omitempty"`
}

// KeyDescription - The description of the EngagementFabric account key
type KeyDescription struct {
	// READ-ONLY; The name of the key
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The rank of the key
	Rank *KeyRank `json:"rank,omitempty" azure:"ro"`

	// READ-ONLY; The value of the key
	Value *string `json:"value,omitempty" azure:"ro"`
}

// KeyDescriptionList - The list of the EngagementFabric account keys
type KeyDescriptionList struct {
	// READ-ONLY; Account keys
	Value []*KeyDescription `json:"value,omitempty" azure:"ro"`
}

// Operation - The EngagementFabric operation
type Operation struct {
	// READ-ONLY; The display content of the EngagementFabric operation
	Display *OperationDisplay `json:"display,omitempty" azure:"ro"`

	// READ-ONLY; The name of the EngagementFabric operation
	Name *string `json:"name,omitempty" azure:"ro"`
}

// OperationDisplay - The display information of the EngagementFabric operation
type OperationDisplay struct {
	// READ-ONLY; The description of the EngagementFabric operation
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The name of the EngagementFabric operation
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The resource provider namespace of the EngagementFabric operation
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The resource type of the EngagementFabric operation
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationList - The list of the EngagementFabric operations
type OperationList struct {
	// READ-ONLY; The EngagementFabric operations
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ProxyOnlyResource - The base model for the proxy-only Azure resource
type ProxyOnlyResource struct {
	// READ-ONLY; The ID of the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified type of the resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegenerateKeyParameter - The parameter to regenerate single EngagementFabric account key
type RegenerateKeyParameter struct {
	// REQUIRED; The name of key to be regenerated
	Name *string `json:"name,omitempty"`

	// REQUIRED; The rank of the key to be regenerated
	Rank *KeyRank `json:"rank,omitempty"`
}

// Resource - The base model for Azure resource
type Resource struct {
	// READ-ONLY; The ID of the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified type of the resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SKU - The EngagementFabric SKU
type SKU struct {
	// REQUIRED; The name of the SKU
	Name *string `json:"name,omitempty"`

	// The price tier of the SKU
	Tier *string `json:"tier,omitempty"`
}

// SKUDescription - The EngagementFabric SKU description of given resource type
type SKUDescription struct {
	// READ-ONLY; Locations and zones
	LocationInfo []*SKULocationInfoItem `json:"locationInfo,omitempty" azure:"ro"`

	// READ-ONLY; The set of locations that the SKU is available
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; The name of the SKU
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified resource type
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; The restrictions because of which SKU cannot be used
	Restrictions []interface{} `json:"restrictions,omitempty" azure:"ro"`

	// READ-ONLY; The price tier of the SKU
	Tier *string `json:"tier,omitempty" azure:"ro"`
}

// SKUDescriptionList - The list of the EngagementFabric SKU descriptions
type SKUDescriptionList struct {
	// READ-ONLY; SKU descriptions
	Value []*SKUDescription `json:"value,omitempty" azure:"ro"`
}

// SKULocationInfoItem - The Locations and zones info for SKU
type SKULocationInfoItem struct {
	// The available location of the SKU
	Location *string `json:"location,omitempty"`

	// The available zone of the SKU
	Zones []*string `json:"zones,omitempty"`
}

// SKUsClientListOptions contains the optional parameters for the SKUsClient.List method.
type SKUsClientListOptions struct {
	// placeholder for future optional parameters
}

// TrackedResource - The base model for the tracked Azure resource
type TrackedResource struct {
	// REQUIRED; The location of the resource
	Location *string `json:"location,omitempty"`

	// REQUIRED; The SKU of the resource
	SKU *SKU `json:"sku,omitempty"`

	// The tags of the resource
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The ID of the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified type of the resource
	Type *string `json:"type,omitempty" azure:"ro"`
}
