//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armeventgrid

import "time"

// AdvancedFilterClassification provides polymorphic access to related types.
// Call the interface's GetAdvancedFilter() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AdvancedFilter, *BoolEqualsAdvancedFilter, *IsNotNullAdvancedFilter, *IsNullOrUndefinedAdvancedFilter, *NumberGreaterThanAdvancedFilter,
// - *NumberGreaterThanOrEqualsAdvancedFilter, *NumberInAdvancedFilter, *NumberInRangeAdvancedFilter, *NumberLessThanAdvancedFilter,
// - *NumberLessThanOrEqualsAdvancedFilter, *NumberNotInAdvancedFilter, *NumberNotInRangeAdvancedFilter, *StringBeginsWithAdvancedFilter,
// - *StringContainsAdvancedFilter, *StringEndsWithAdvancedFilter, *StringInAdvancedFilter, *StringNotBeginsWithAdvancedFilter,
// - *StringNotContainsAdvancedFilter, *StringNotEndsWithAdvancedFilter, *StringNotInAdvancedFilter
type AdvancedFilterClassification interface {
	// GetAdvancedFilter returns the AdvancedFilter content of the underlying type.
	GetAdvancedFilter() *AdvancedFilter
}

// AdvancedFilter - This is the base type that represents an advanced filter. To configure an advanced filter, do not directly
// instantiate an object of this class. Instead, instantiate an object of a derived class such
// as BoolEqualsAdvancedFilter, NumberInAdvancedFilter, StringEqualsAdvancedFilter etc. depending on the type of the key based
// on which you want to filter.
type AdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type AdvancedFilter.
func (a *AdvancedFilter) GetAdvancedFilter() *AdvancedFilter { return a }

// AzureFunctionEventSubscriptionDestination - Information about the azure function destination for an event subscription.
type AzureFunctionEventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType `json:"endpointType,omitempty"`

	// Azure Function Properties of the event subscription destination.
	Properties *AzureFunctionEventSubscriptionDestinationProperties `json:"properties,omitempty"`
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type AzureFunctionEventSubscriptionDestination.
func (a *AzureFunctionEventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return &EventSubscriptionDestination{
		EndpointType: a.EndpointType,
	}
}

// AzureFunctionEventSubscriptionDestinationProperties - The properties that represent the Azure Function destination of an
// event subscription.
type AzureFunctionEventSubscriptionDestinationProperties struct {
	// Delivery attribute details.
	DeliveryAttributeMappings []DeliveryAttributeMappingClassification `json:"deliveryAttributeMappings,omitempty"`

	// Maximum number of events per batch.
	MaxEventsPerBatch *int32 `json:"maxEventsPerBatch,omitempty"`

	// Preferred batch size in Kilobytes.
	PreferredBatchSizeInKilobytes *int32 `json:"preferredBatchSizeInKilobytes,omitempty"`

	// The Azure Resource Id that represents the endpoint of the Azure Function destination of an event subscription.
	ResourceID *string `json:"resourceId,omitempty"`
}

// BoolEqualsAdvancedFilter - BoolEquals Advanced Filter.
type BoolEqualsAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`

	// The boolean filter value.
	Value *bool `json:"value,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type BoolEqualsAdvancedFilter.
func (b *BoolEqualsAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: b.OperatorType,
		Key:          b.Key,
	}
}

// Channel info.
type Channel struct {
	// Properties of the Channel.
	Properties *ChannelProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to Channel resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ChannelProperties - Properties of the Channel.
type ChannelProperties struct {
	// The type of the event channel which represents the direction flow of events.
	ChannelType *ChannelType `json:"channelType,omitempty"`

	// Expiration time of the channel. If this timer expires while the corresponding partner topic is never activated, the channel
	// and corresponding partner topic are deleted.
	ExpirationTimeIfNotActivatedUTC *time.Time `json:"expirationTimeIfNotActivatedUtc,omitempty"`

	// Context or helpful message that can be used during the approval process by the subscriber.
	MessageForActivation *string `json:"messageForActivation,omitempty"`

	// This property should be populated when channelType is PartnerTopic and represents information about the partner topic resource
	// corresponding to the channel.
	PartnerTopicInfo *PartnerTopicInfo `json:"partnerTopicInfo,omitempty"`

	// Provisioning state of the channel.
	ProvisioningState *ChannelProvisioningState `json:"provisioningState,omitempty"`

	// The readiness state of the corresponding partner topic.
	ReadinessState *ReadinessState `json:"readinessState,omitempty"`
}

// ChannelUpdateParameters - Properties of the Channel update.
type ChannelUpdateParameters struct {
	// Properties of the channel update parameters.
	Properties *ChannelUpdateParametersProperties `json:"properties,omitempty"`
}

// ChannelUpdateParametersProperties - Properties of the channel update parameters.
type ChannelUpdateParametersProperties struct {
	// Expiration time of the channel. If this timer expires while the corresponding partner topic or partner destination is never
	// activated, the channel and corresponding partner topic or partner
	// destination are deleted.
	ExpirationTimeIfNotActivatedUTC *time.Time `json:"expirationTimeIfNotActivatedUtc,omitempty"`

	// Partner topic properties which can be updated if the channel is of type PartnerTopic.
	PartnerTopicInfo *PartnerUpdateTopicInfo `json:"partnerTopicInfo,omitempty"`
}

// ChannelsClientBeginDeleteOptions contains the optional parameters for the ChannelsClient.BeginDelete method.
type ChannelsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ChannelsClientCreateOrUpdateOptions contains the optional parameters for the ChannelsClient.CreateOrUpdate method.
type ChannelsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ChannelsClientGetFullURLOptions contains the optional parameters for the ChannelsClient.GetFullURL method.
type ChannelsClientGetFullURLOptions struct {
	// placeholder for future optional parameters
}

// ChannelsClientGetOptions contains the optional parameters for the ChannelsClient.Get method.
type ChannelsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ChannelsClientListByPartnerNamespaceOptions contains the optional parameters for the ChannelsClient.ListByPartnerNamespace
// method.
type ChannelsClientListByPartnerNamespaceOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// ChannelsClientUpdateOptions contains the optional parameters for the ChannelsClient.Update method.
type ChannelsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ChannelsListResult - Result of the List Channels operation
type ChannelsListResult struct {
	// A link for the next page of channels.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of Channels.
	Value []*Channel `json:"value,omitempty"`
}

// ConnectionState information.
type ConnectionState struct {
	// Actions required (if any).
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// Description of the connection state.
	Description *string `json:"description,omitempty"`

	// Status of the connection.
	Status *PersistedConnectionStatus `json:"status,omitempty"`
}

// DeadLetterDestinationClassification provides polymorphic access to related types.
// Call the interface's GetDeadLetterDestination() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DeadLetterDestination, *StorageBlobDeadLetterDestination
type DeadLetterDestinationClassification interface {
	// GetDeadLetterDestination returns the DeadLetterDestination content of the underlying type.
	GetDeadLetterDestination() *DeadLetterDestination
}

// DeadLetterDestination - Information about the dead letter destination for an event subscription. To configure a deadletter
// destination, do not directly instantiate an object of this class. Instead, instantiate an object of a
// derived class. Currently, StorageBlobDeadLetterDestination is the only class that derives from this class.
type DeadLetterDestination struct {
	// REQUIRED; Type of the endpoint for the dead letter destination
	EndpointType *DeadLetterEndPointType `json:"endpointType,omitempty"`
}

// GetDeadLetterDestination implements the DeadLetterDestinationClassification interface for type DeadLetterDestination.
func (d *DeadLetterDestination) GetDeadLetterDestination() *DeadLetterDestination { return d }

// DeadLetterWithResourceIdentity - Information about the deadletter destination with resource identity.
type DeadLetterWithResourceIdentity struct {
	// Information about the destination where events have to be delivered for the event subscription. Uses the managed identity
	// setup on the parent resource (namely, topic or domain) to acquire the
	// authentication tokens being used during delivery / dead-lettering.
	DeadLetterDestination DeadLetterDestinationClassification `json:"deadLetterDestination,omitempty"`

	// The identity to use when dead-lettering events.
	Identity *EventSubscriptionIdentity `json:"identity,omitempty"`
}

// DeliveryAttributeListResult - Result of the Get delivery attributes operation.
type DeliveryAttributeListResult struct {
	// A collection of DeliveryAttributeMapping
	Value []DeliveryAttributeMappingClassification `json:"value,omitempty"`
}

// DeliveryAttributeMappingClassification provides polymorphic access to related types.
// Call the interface's GetDeliveryAttributeMapping() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DeliveryAttributeMapping, *DynamicDeliveryAttributeMapping, *StaticDeliveryAttributeMapping
type DeliveryAttributeMappingClassification interface {
	// GetDeliveryAttributeMapping returns the DeliveryAttributeMapping content of the underlying type.
	GetDeliveryAttributeMapping() *DeliveryAttributeMapping
}

// DeliveryAttributeMapping - Delivery attribute mapping details.
type DeliveryAttributeMapping struct {
	// REQUIRED; Type of the delivery attribute or header name.
	Type *DeliveryAttributeMappingType `json:"type,omitempty"`

	// Name of the delivery attribute or header.
	Name *string `json:"name,omitempty"`
}

// GetDeliveryAttributeMapping implements the DeliveryAttributeMappingClassification interface for type DeliveryAttributeMapping.
func (d *DeliveryAttributeMapping) GetDeliveryAttributeMapping() *DeliveryAttributeMapping { return d }

// DeliveryWithResourceIdentity - Information about the delivery for an event subscription with resource identity.
type DeliveryWithResourceIdentity struct {
	// Information about the destination where events have to be delivered for the event subscription. Uses Azure Event Grid's
	// identity to acquire the authentication tokens being used during delivery /
	// dead-lettering.
	Destination EventSubscriptionDestinationClassification `json:"destination,omitempty"`

	// The identity to use when delivering events.
	Identity *EventSubscriptionIdentity `json:"identity,omitempty"`
}

// Domain - EventGrid Domain.
type Domain struct {
	// REQUIRED; Location of the resource.
	Location *string `json:"location,omitempty"`

	// Identity information for the Event Grid Domain resource.
	Identity *IdentityInfo `json:"identity,omitempty"`

	// Properties of the Event Grid Domain resource.
	Properties *DomainProperties `json:"properties,omitempty"`

	// Tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to the Event Grid Domain resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DomainEventSubscriptionsClientBeginCreateOrUpdateOptions contains the optional parameters for the DomainEventSubscriptionsClient.BeginCreateOrUpdate
// method.
type DomainEventSubscriptionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DomainEventSubscriptionsClientBeginDeleteOptions contains the optional parameters for the DomainEventSubscriptionsClient.BeginDelete
// method.
type DomainEventSubscriptionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DomainEventSubscriptionsClientBeginUpdateOptions contains the optional parameters for the DomainEventSubscriptionsClient.BeginUpdate
// method.
type DomainEventSubscriptionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DomainEventSubscriptionsClientGetDeliveryAttributesOptions contains the optional parameters for the DomainEventSubscriptionsClient.GetDeliveryAttributes
// method.
type DomainEventSubscriptionsClientGetDeliveryAttributesOptions struct {
	// placeholder for future optional parameters
}

// DomainEventSubscriptionsClientGetFullURLOptions contains the optional parameters for the DomainEventSubscriptionsClient.GetFullURL
// method.
type DomainEventSubscriptionsClientGetFullURLOptions struct {
	// placeholder for future optional parameters
}

// DomainEventSubscriptionsClientGetOptions contains the optional parameters for the DomainEventSubscriptionsClient.Get method.
type DomainEventSubscriptionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DomainEventSubscriptionsClientListOptions contains the optional parameters for the DomainEventSubscriptionsClient.List
// method.
type DomainEventSubscriptionsClientListOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// DomainProperties - Properties of the Event Grid Domain Resource.
type DomainProperties struct {
	// This Boolean is used to specify the creation mechanism for 'all' the Event Grid Domain Topics associated with this Event
	// Grid Domain resource. In this context, creation of domain topic can be
	// auto-managed (when true) or self-managed (when false). The default value for this property is true. When this property
	// is null or set to true, Event Grid is responsible of automatically creating the
	// domain topic when the first event subscription is created at the scope of the domain topic. If this property is set to
	// false, then creating the first event subscription will require creating a domain
	// topic by the user. The self-management mode can be used if the user wants full control of when the domain topic is created,
	// while auto-managed mode provides the flexibility to perform less operations
	// and manage fewer resources by the user. Also, note that in auto-managed creation mode, user is allowed to create the domain
	// topic on demand if needed.
	AutoCreateTopicWithFirstSubscription *bool `json:"autoCreateTopicWithFirstSubscription,omitempty"`

	// This Boolean is used to specify the deletion mechanism for 'all' the Event Grid Domain Topics associated with this Event
	// Grid Domain resource. In this context, deletion of domain topic can be
	// auto-managed (when true) or self-managed (when false). The default value for this property is true. When this property
	// is set to true, Event Grid is responsible of automatically deleting the domain
	// topic when the last event subscription at the scope of the domain topic is deleted. If this property is set to false, then
	// the user needs to manually delete the domain topic when it is no longer
	// needed (e.g., when last event subscription is deleted and the resource needs to be cleaned up). The self-management mode
	// can be used if the user wants full control of when the domain topic needs to be
	// deleted, while auto-managed mode provides the flexibility to perform less operations and manage fewer resources by the
	// user.
	AutoDeleteTopicWithLastSubscription *bool `json:"autoDeleteTopicWithLastSubscription,omitempty"`

	// Data Residency Boundary of the resource.
	DataResidencyBoundary *DataResidencyBoundary `json:"dataResidencyBoundary,omitempty"`

	// This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD
	// token will be used to authenticate if user is allowed to publish to the domain.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess
	// is enabled.
	InboundIPRules []*InboundIPRule `json:"inboundIpRules,omitempty"`

	// This determines the format that Event Grid should expect for incoming events published to the Event Grid Domain Resource.
	InputSchema *InputSchema `json:"inputSchema,omitempty"`

	// Information about the InputSchemaMapping which specified the info about mapping event payload.
	InputSchemaMapping InputSchemaMappingClassification `json:"inputSchemaMapping,omitempty"`

	// This determines if traffic is allowed over public network. By default it is enabled. You can further restrict to specific
	// IPs by configuring
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// READ-ONLY; Endpoint for the Event Grid Domain Resource which is used for publishing the events.
	Endpoint *string `json:"endpoint,omitempty" azure:"ro"`

	// READ-ONLY; Metric resource id for the Event Grid Domain Resource.
	MetricResourceID *string `json:"metricResourceId,omitempty" azure:"ro"`

	// READ-ONLY; List of private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Event Grid Domain Resource.
	ProvisioningState *DomainProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// DomainRegenerateKeyRequest - Domain regenerate share access key request.
type DomainRegenerateKeyRequest struct {
	// REQUIRED; Key name to regenerate key1 or key2.
	KeyName *string `json:"keyName,omitempty"`
}

// DomainSharedAccessKeys - Shared access keys of the Domain.
type DomainSharedAccessKeys struct {
	// Shared access key1 for the domain.
	Key1 *string `json:"key1,omitempty"`

	// Shared access key2 for the domain.
	Key2 *string `json:"key2,omitempty"`
}

// DomainTopic - Domain Topic.
type DomainTopic struct {
	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Properties of the Domain Topic.
	Properties *DomainTopicProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to Domain Topic resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DomainTopicEventSubscriptionsClientBeginCreateOrUpdateOptions contains the optional parameters for the DomainTopicEventSubscriptionsClient.BeginCreateOrUpdate
// method.
type DomainTopicEventSubscriptionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DomainTopicEventSubscriptionsClientBeginDeleteOptions contains the optional parameters for the DomainTopicEventSubscriptionsClient.BeginDelete
// method.
type DomainTopicEventSubscriptionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DomainTopicEventSubscriptionsClientBeginUpdateOptions contains the optional parameters for the DomainTopicEventSubscriptionsClient.BeginUpdate
// method.
type DomainTopicEventSubscriptionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DomainTopicEventSubscriptionsClientGetDeliveryAttributesOptions contains the optional parameters for the DomainTopicEventSubscriptionsClient.GetDeliveryAttributes
// method.
type DomainTopicEventSubscriptionsClientGetDeliveryAttributesOptions struct {
	// placeholder for future optional parameters
}

// DomainTopicEventSubscriptionsClientGetFullURLOptions contains the optional parameters for the DomainTopicEventSubscriptionsClient.GetFullURL
// method.
type DomainTopicEventSubscriptionsClientGetFullURLOptions struct {
	// placeholder for future optional parameters
}

// DomainTopicEventSubscriptionsClientGetOptions contains the optional parameters for the DomainTopicEventSubscriptionsClient.Get
// method.
type DomainTopicEventSubscriptionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DomainTopicEventSubscriptionsClientListOptions contains the optional parameters for the DomainTopicEventSubscriptionsClient.List
// method.
type DomainTopicEventSubscriptionsClientListOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// DomainTopicProperties - Properties of the Domain Topic.
type DomainTopicProperties struct {
	// READ-ONLY; Provisioning state of the domain topic.
	ProvisioningState *DomainTopicProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// DomainTopicsClientBeginCreateOrUpdateOptions contains the optional parameters for the DomainTopicsClient.BeginCreateOrUpdate
// method.
type DomainTopicsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DomainTopicsClientBeginDeleteOptions contains the optional parameters for the DomainTopicsClient.BeginDelete method.
type DomainTopicsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DomainTopicsClientGetOptions contains the optional parameters for the DomainTopicsClient.Get method.
type DomainTopicsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DomainTopicsClientListByDomainOptions contains the optional parameters for the DomainTopicsClient.ListByDomain method.
type DomainTopicsClientListByDomainOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// DomainTopicsListResult - Result of the List Domain Topics operation.
type DomainTopicsListResult struct {
	// A link for the next page of domain topics.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of Domain Topics.
	Value []*DomainTopic `json:"value,omitempty"`
}

// DomainUpdateParameterProperties - Information of domain update parameter properties.
type DomainUpdateParameterProperties struct {
	// This Boolean is used to specify the creation mechanism for 'all' the Event Grid Domain Topics associated with this Event
	// Grid Domain resource. In this context, creation of domain topic can be
	// auto-managed (when true) or self-managed (when false). The default value for this property is true. When this property
	// is null or set to true, Event Grid is responsible of automatically creating the
	// domain topic when the first event subscription is created at the scope of the domain topic. If this property is set to
	// false, then creating the first event subscription will require creating a domain
	// topic by the user. The self-management mode can be used if the user wants full control of when the domain topic is created,
	// while auto-managed mode provides the flexibility to perform less operations
	// and manage fewer resources by the user. Also, note that in auto-managed creation mode, user is allowed to create the domain
	// topic on demand if needed.
	AutoCreateTopicWithFirstSubscription *bool `json:"autoCreateTopicWithFirstSubscription,omitempty"`

	// This Boolean is used to specify the deletion mechanism for 'all' the Event Grid Domain Topics associated with this Event
	// Grid Domain resource. In this context, deletion of domain topic can be
	// auto-managed (when true) or self-managed (when false). The default value for this property is true. When this property
	// is set to true, Event Grid is responsible of automatically deleting the domain
	// topic when the last event subscription at the scope of the domain topic is deleted. If this property is set to false, then
	// the user needs to manually delete the domain topic when it is no longer
	// needed (e.g., when last event subscription is deleted and the resource needs to be cleaned up). The self-management mode
	// can be used if the user wants full control of when the domain topic needs to be
	// deleted, while auto-managed mode provides the flexibility to perform less operations and manage fewer resources by the
	// user.
	AutoDeleteTopicWithLastSubscription *bool `json:"autoDeleteTopicWithLastSubscription,omitempty"`

	// The data residency boundary for the domain.
	DataResidencyBoundary *DataResidencyBoundary `json:"dataResidencyBoundary,omitempty"`

	// This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD
	// token will be used to authenticate if user is allowed to publish to the domain.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess
	// is enabled.
	InboundIPRules []*InboundIPRule `json:"inboundIpRules,omitempty"`

	// This determines if traffic is allowed over public network. By default it is enabled. You can further restrict to specific
	// IPs by configuring
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// DomainUpdateParameters - Properties of the Domain update.
type DomainUpdateParameters struct {
	// Identity information for the resource.
	Identity *IdentityInfo `json:"identity,omitempty"`

	// Properties of the resource.
	Properties *DomainUpdateParameterProperties `json:"properties,omitempty"`

	// Tags of the domains resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// DomainsClientBeginCreateOrUpdateOptions contains the optional parameters for the DomainsClient.BeginCreateOrUpdate method.
type DomainsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DomainsClientBeginDeleteOptions contains the optional parameters for the DomainsClient.BeginDelete method.
type DomainsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DomainsClientBeginUpdateOptions contains the optional parameters for the DomainsClient.BeginUpdate method.
type DomainsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DomainsClientGetOptions contains the optional parameters for the DomainsClient.Get method.
type DomainsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DomainsClientListByResourceGroupOptions contains the optional parameters for the DomainsClient.ListByResourceGroup method.
type DomainsClientListByResourceGroupOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// DomainsClientListBySubscriptionOptions contains the optional parameters for the DomainsClient.ListBySubscription method.
type DomainsClientListBySubscriptionOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// DomainsClientListSharedAccessKeysOptions contains the optional parameters for the DomainsClient.ListSharedAccessKeys method.
type DomainsClientListSharedAccessKeysOptions struct {
	// placeholder for future optional parameters
}

// DomainsClientRegenerateKeyOptions contains the optional parameters for the DomainsClient.RegenerateKey method.
type DomainsClientRegenerateKeyOptions struct {
	// placeholder for future optional parameters
}

// DomainsListResult - Result of the List Domains operation.
type DomainsListResult struct {
	// A link for the next page of domains.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of Domains.
	Value []*Domain `json:"value,omitempty"`
}

// DynamicDeliveryAttributeMapping - Dynamic delivery attribute mapping details.
type DynamicDeliveryAttributeMapping struct {
	// REQUIRED; Type of the delivery attribute or header name.
	Type *DeliveryAttributeMappingType `json:"type,omitempty"`

	// Name of the delivery attribute or header.
	Name *string `json:"name,omitempty"`

	// Properties of dynamic delivery attribute mapping.
	Properties *DynamicDeliveryAttributeMappingProperties `json:"properties,omitempty"`
}

// GetDeliveryAttributeMapping implements the DeliveryAttributeMappingClassification interface for type DynamicDeliveryAttributeMapping.
func (d *DynamicDeliveryAttributeMapping) GetDeliveryAttributeMapping() *DeliveryAttributeMapping {
	return &DeliveryAttributeMapping{
		Name: d.Name,
		Type: d.Type,
	}
}

// DynamicDeliveryAttributeMappingProperties - Properties of dynamic delivery attribute mapping.
type DynamicDeliveryAttributeMappingProperties struct {
	// JSON path in the event which contains attribute value.
	SourceField *string `json:"sourceField,omitempty"`
}

// EventHubEventSubscriptionDestination - Information about the event hub destination for an event subscription.
type EventHubEventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType `json:"endpointType,omitempty"`

	// Event Hub Properties of the event subscription destination.
	Properties *EventHubEventSubscriptionDestinationProperties `json:"properties,omitempty"`
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type EventHubEventSubscriptionDestination.
func (e *EventHubEventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return &EventSubscriptionDestination{
		EndpointType: e.EndpointType,
	}
}

// EventHubEventSubscriptionDestinationProperties - The properties for a event hub destination.
type EventHubEventSubscriptionDestinationProperties struct {
	// Delivery attribute details.
	DeliveryAttributeMappings []DeliveryAttributeMappingClassification `json:"deliveryAttributeMappings,omitempty"`

	// The Azure Resource Id that represents the endpoint of an Event Hub destination of an event subscription.
	ResourceID *string `json:"resourceId,omitempty"`
}

// EventSubscription - Event Subscription
type EventSubscription struct {
	// Properties of the event subscription.
	Properties *EventSubscriptionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to Event Subscription resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EventSubscriptionDestinationClassification provides polymorphic access to related types.
// Call the interface's GetEventSubscriptionDestination() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureFunctionEventSubscriptionDestination, *EventHubEventSubscriptionDestination, *EventSubscriptionDestination, *HybridConnectionEventSubscriptionDestination,
// - *ServiceBusQueueEventSubscriptionDestination, *ServiceBusTopicEventSubscriptionDestination, *StorageQueueEventSubscriptionDestination,
// - *WebHookEventSubscriptionDestination
type EventSubscriptionDestinationClassification interface {
	// GetEventSubscriptionDestination returns the EventSubscriptionDestination content of the underlying type.
	GetEventSubscriptionDestination() *EventSubscriptionDestination
}

// EventSubscriptionDestination - Information about the destination for an event subscription.
type EventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType `json:"endpointType,omitempty"`
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type EventSubscriptionDestination.
func (e *EventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return e
}

// EventSubscriptionFilter - Filter for the Event Subscription.
type EventSubscriptionFilter struct {
	// An array of advanced filters that are used for filtering event subscriptions.
	AdvancedFilters []AdvancedFilterClassification `json:"advancedFilters,omitempty"`

	// Allows advanced filters to be evaluated against an array of values instead of expecting a singular value.
	EnableAdvancedFilteringOnArrays *bool `json:"enableAdvancedFilteringOnArrays,omitempty"`

	// A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default
	// event types, set the IncludedEventTypes to null.
	IncludedEventTypes []*string `json:"includedEventTypes,omitempty"`

	// Specifies if the SubjectBeginsWith and SubjectEndsWith properties of the filter should be compared in a case sensitive
	// manner.
	IsSubjectCaseSensitive *bool `json:"isSubjectCaseSensitive,omitempty"`

	// An optional string to filter events for an event subscription based on a resource path prefix. The format of this depends
	// on the publisher of the events. Wildcard characters are not supported in this
	// path.
	SubjectBeginsWith *string `json:"subjectBeginsWith,omitempty"`

	// An optional string to filter events for an event subscription based on a resource path suffix. Wildcard characters are
	// not supported in this path.
	SubjectEndsWith *string `json:"subjectEndsWith,omitempty"`
}

// EventSubscriptionFullURL - Full endpoint url of an event subscription
type EventSubscriptionFullURL struct {
	// The URL that represents the endpoint of the destination of an event subscription.
	EndpointURL *string `json:"endpointUrl,omitempty"`
}

// EventSubscriptionIdentity - The identity information with the event subscription.
type EventSubscriptionIdentity struct {
	// The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity
	// and a set of user-assigned identities. The type 'None' will remove any identity.
	Type *EventSubscriptionIdentityType `json:"type,omitempty"`

	// The user identity associated with the resource.
	UserAssignedIdentity *string `json:"userAssignedIdentity,omitempty"`
}

// EventSubscriptionProperties - Properties of the Event Subscription.
type EventSubscriptionProperties struct {
	// The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to
	// the dead letter destination. Uses Azure Event Grid's identity to acquire the
	// authentication tokens being used during delivery / dead-lettering.
	DeadLetterDestination DeadLetterDestinationClassification `json:"deadLetterDestination,omitempty"`

	// The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to
	// the dead letter destination. Uses the managed identity setup on the parent
	// resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
	DeadLetterWithResourceIdentity *DeadLetterWithResourceIdentity `json:"deadLetterWithResourceIdentity,omitempty"`

	// Information about the destination where events have to be delivered for the event subscription. Uses the managed identity
	// setup on the parent resource (namely, topic or domain) to acquire the
	// authentication tokens being used during delivery / dead-lettering.
	DeliveryWithResourceIdentity *DeliveryWithResourceIdentity `json:"deliveryWithResourceIdentity,omitempty"`

	// Information about the destination where events have to be delivered for the event subscription. Uses Azure Event Grid's
	// identity to acquire the authentication tokens being used during delivery /
	// dead-lettering.
	Destination EventSubscriptionDestinationClassification `json:"destination,omitempty"`

	// The event delivery schema for the event subscription.
	EventDeliverySchema *EventDeliverySchema `json:"eventDeliverySchema,omitempty"`

	// Expiration time of the event subscription.
	ExpirationTimeUTC *time.Time `json:"expirationTimeUtc,omitempty"`

	// Information about the filter for the event subscription.
	Filter *EventSubscriptionFilter `json:"filter,omitempty"`

	// List of user defined labels.
	Labels []*string `json:"labels,omitempty"`

	// The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
	RetryPolicy *RetryPolicy `json:"retryPolicy,omitempty"`

	// READ-ONLY; Provisioning state of the event subscription.
	ProvisioningState *EventSubscriptionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Name of the topic of the event subscription.
	Topic *string `json:"topic,omitempty" azure:"ro"`
}

// EventSubscriptionUpdateParameters - Properties of the Event Subscription update.
type EventSubscriptionUpdateParameters struct {
	// The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to
	// the dead letter destination. Uses Azure Event Grid's identity to acquire the
	// authentication tokens being used during delivery / dead-lettering.
	DeadLetterDestination DeadLetterDestinationClassification `json:"deadLetterDestination,omitempty"`

	// The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to
	// the dead letter destination. Uses the managed identity setup on the parent
	// resource (topic / domain) to acquire the authentication tokens being used during delivery / dead-lettering.
	DeadLetterWithResourceIdentity *DeadLetterWithResourceIdentity `json:"deadLetterWithResourceIdentity,omitempty"`

	// Information about the destination where events have to be delivered for the event subscription. Uses the managed identity
	// setup on the parent resource (topic / domain) to acquire the authentication
	// tokens being used during delivery / dead-lettering.
	DeliveryWithResourceIdentity *DeliveryWithResourceIdentity `json:"deliveryWithResourceIdentity,omitempty"`

	// Information about the destination where events have to be delivered for the event subscription. Uses Azure Event Grid's
	// identity to acquire the authentication tokens being used during delivery /
	// dead-lettering.
	Destination EventSubscriptionDestinationClassification `json:"destination,omitempty"`

	// The event delivery schema for the event subscription.
	EventDeliverySchema *EventDeliverySchema `json:"eventDeliverySchema,omitempty"`

	// Information about the expiration time for the event subscription.
	ExpirationTimeUTC *time.Time `json:"expirationTimeUtc,omitempty"`

	// Information about the filter for the event subscription.
	Filter *EventSubscriptionFilter `json:"filter,omitempty"`

	// List of user defined labels.
	Labels []*string `json:"labels,omitempty"`

	// The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
	RetryPolicy *RetryPolicy `json:"retryPolicy,omitempty"`
}

// EventSubscriptionsClientBeginCreateOrUpdateOptions contains the optional parameters for the EventSubscriptionsClient.BeginCreateOrUpdate
// method.
type EventSubscriptionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EventSubscriptionsClientBeginDeleteOptions contains the optional parameters for the EventSubscriptionsClient.BeginDelete
// method.
type EventSubscriptionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EventSubscriptionsClientBeginUpdateOptions contains the optional parameters for the EventSubscriptionsClient.BeginUpdate
// method.
type EventSubscriptionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EventSubscriptionsClientGetDeliveryAttributesOptions contains the optional parameters for the EventSubscriptionsClient.GetDeliveryAttributes
// method.
type EventSubscriptionsClientGetDeliveryAttributesOptions struct {
	// placeholder for future optional parameters
}

// EventSubscriptionsClientGetFullURLOptions contains the optional parameters for the EventSubscriptionsClient.GetFullURL
// method.
type EventSubscriptionsClientGetFullURLOptions struct {
	// placeholder for future optional parameters
}

// EventSubscriptionsClientGetOptions contains the optional parameters for the EventSubscriptionsClient.Get method.
type EventSubscriptionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// EventSubscriptionsClientListByDomainTopicOptions contains the optional parameters for the EventSubscriptionsClient.ListByDomainTopic
// method.
type EventSubscriptionsClientListByDomainTopicOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// EventSubscriptionsClientListByResourceOptions contains the optional parameters for the EventSubscriptionsClient.ListByResource
// method.
type EventSubscriptionsClientListByResourceOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeOptions contains the optional parameters for the EventSubscriptionsClient.ListGlobalByResourceGroupForTopicType
// method.
type EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// EventSubscriptionsClientListGlobalByResourceGroupOptions contains the optional parameters for the EventSubscriptionsClient.ListGlobalByResourceGroup
// method.
type EventSubscriptionsClientListGlobalByResourceGroupOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeOptions contains the optional parameters for the EventSubscriptionsClient.ListGlobalBySubscriptionForTopicType
// method.
type EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// EventSubscriptionsClientListGlobalBySubscriptionOptions contains the optional parameters for the EventSubscriptionsClient.ListGlobalBySubscription
// method.
type EventSubscriptionsClientListGlobalBySubscriptionOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeOptions contains the optional parameters for the EventSubscriptionsClient.ListRegionalByResourceGroupForTopicType
// method.
type EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// EventSubscriptionsClientListRegionalByResourceGroupOptions contains the optional parameters for the EventSubscriptionsClient.ListRegionalByResourceGroup
// method.
type EventSubscriptionsClientListRegionalByResourceGroupOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeOptions contains the optional parameters for the EventSubscriptionsClient.ListRegionalBySubscriptionForTopicType
// method.
type EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// EventSubscriptionsClientListRegionalBySubscriptionOptions contains the optional parameters for the EventSubscriptionsClient.ListRegionalBySubscription
// method.
type EventSubscriptionsClientListRegionalBySubscriptionOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// EventSubscriptionsListResult - Result of the List EventSubscriptions operation
type EventSubscriptionsListResult struct {
	// A link for the next page of event subscriptions
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of EventSubscriptions
	Value []*EventSubscription `json:"value,omitempty"`
}

// EventType - Event Type for a subject under a topic
type EventType struct {
	// Properties of the event type.
	Properties *EventTypeProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EventTypeInfo - The event type information for Channels.
type EventTypeInfo struct {
	// A collection of inline event types for the resource. The inline event type keys are of type string which represents the
	// name of the event. An example of a valid inline event name is
	// "Contoso.OrderCreated". The inline event type values are of type InlineEventProperties and will contain additional information
	// for every inline event type.
	InlineEventTypes map[string]*InlineEventProperties `json:"inlineEventTypes,omitempty"`

	// The kind of event type used.
	Kind *EventDefinitionKind `json:"kind,omitempty"`
}

// EventTypeProperties - Properties of the event type
type EventTypeProperties struct {
	// Description of the event type.
	Description *string `json:"description,omitempty"`

	// Display name of the event type.
	DisplayName *string `json:"displayName,omitempty"`

	// IsInDefaultSet flag of the event type.
	IsInDefaultSet *bool `json:"isInDefaultSet,omitempty"`

	// Url of the schema for this event type.
	SchemaURL *string `json:"schemaUrl,omitempty"`
}

// EventTypesListResult - Result of the List Event Types operation
type EventTypesListResult struct {
	// A collection of event types
	Value []*EventType `json:"value,omitempty"`
}

// ExtensionTopic - Event grid Extension Topic. This is used for getting Event Grid related metrics for Azure resources.
type ExtensionTopic struct {
	// Properties of the extension topic
	Properties *ExtensionTopicProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to Extension Topic resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExtensionTopicProperties - Properties of the Extension Topic
type ExtensionTopicProperties struct {
	// Description of the extension topic.
	Description *string `json:"description,omitempty"`

	// System topic resource id which is mapped to the source.
	SystemTopic *string `json:"systemTopic,omitempty"`
}

// ExtensionTopicsClientGetOptions contains the optional parameters for the ExtensionTopicsClient.Get method.
type ExtensionTopicsClientGetOptions struct {
	// placeholder for future optional parameters
}

// HybridConnectionEventSubscriptionDestination - Information about the HybridConnection destination for an event subscription.
type HybridConnectionEventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType `json:"endpointType,omitempty"`

	// Hybrid connection Properties of the event subscription destination.
	Properties *HybridConnectionEventSubscriptionDestinationProperties `json:"properties,omitempty"`
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type HybridConnectionEventSubscriptionDestination.
func (h *HybridConnectionEventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return &EventSubscriptionDestination{
		EndpointType: h.EndpointType,
	}
}

// HybridConnectionEventSubscriptionDestinationProperties - The properties for a hybrid connection destination.
type HybridConnectionEventSubscriptionDestinationProperties struct {
	// Delivery attribute details.
	DeliveryAttributeMappings []DeliveryAttributeMappingClassification `json:"deliveryAttributeMappings,omitempty"`

	// The Azure Resource ID of an hybrid connection that is the destination of an event subscription.
	ResourceID *string `json:"resourceId,omitempty"`
}

// IdentityInfo - The identity information for the resource.
type IdentityInfo struct {
	// The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`

	// The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`

	// The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity
	// and a set of user-assigned identities. The type 'None' will remove any identity.
	Type *IdentityType `json:"type,omitempty"`

	// The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	// This property is currently not used and reserved for
	// future usage.
	UserAssignedIdentities map[string]*UserIdentityProperties `json:"userAssignedIdentities,omitempty"`
}

type InboundIPRule struct {
	// Action to perform based on the match or no match of the IpMask.
	Action *IPActionType `json:"action,omitempty"`

	// IP Address in CIDR notation e.g., 10.0.0.0/8.
	IPMask *string `json:"ipMask,omitempty"`
}

// InlineEventProperties - Additional information about every inline event.
type InlineEventProperties struct {
	// The dataSchemaUrl for the inline event.
	DataSchemaURL *string `json:"dataSchemaUrl,omitempty"`

	// The description for the inline event.
	Description *string `json:"description,omitempty"`

	// The displayName for the inline event.
	DisplayName *string `json:"displayName,omitempty"`

	// The documentationUrl for the inline event.
	DocumentationURL *string `json:"documentationUrl,omitempty"`
}

// InputSchemaMappingClassification provides polymorphic access to related types.
// Call the interface's GetInputSchemaMapping() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *InputSchemaMapping, *JSONInputSchemaMapping
type InputSchemaMappingClassification interface {
	// GetInputSchemaMapping returns the InputSchemaMapping content of the underlying type.
	GetInputSchemaMapping() *InputSchemaMapping
}

// InputSchemaMapping - By default, Event Grid expects events to be in the Event Grid event schema. Specifying an input schema
// mapping enables publishing to Event Grid using a custom input schema. Currently, the only
// supported type of InputSchemaMapping is 'JsonInputSchemaMapping'.
type InputSchemaMapping struct {
	// REQUIRED; Type of the custom mapping
	InputSchemaMappingType *InputSchemaMappingType `json:"inputSchemaMappingType,omitempty"`
}

// GetInputSchemaMapping implements the InputSchemaMappingClassification interface for type InputSchemaMapping.
func (i *InputSchemaMapping) GetInputSchemaMapping() *InputSchemaMapping { return i }

// IsNotNullAdvancedFilter - IsNotNull Advanced Filter.
type IsNotNullAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type IsNotNullAdvancedFilter.
func (i *IsNotNullAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: i.OperatorType,
		Key:          i.Key,
	}
}

// IsNullOrUndefinedAdvancedFilter - IsNullOrUndefined Advanced Filter.
type IsNullOrUndefinedAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type IsNullOrUndefinedAdvancedFilter.
func (i *IsNullOrUndefinedAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: i.OperatorType,
		Key:          i.Key,
	}
}

// JSONField - This is used to express the source of an input schema mapping for a single target field in the Event Grid Event
// schema. This is currently used in the mappings for the 'id', 'topic' and 'eventtime'
// properties. This represents a field in the input event schema.
type JSONField struct {
	// Name of a field in the input event schema that's to be used as the source of a mapping.
	SourceField *string `json:"sourceField,omitempty"`
}

// JSONFieldWithDefault - This is used to express the source of an input schema mapping for a single target field in the Event
// Grid Event schema. This is currently used in the mappings for the 'subject', 'eventtype' and
// 'dataversion' properties. This represents a field in the input event schema along with a default value to be used, and
// at least one of these two properties should be provided.
type JSONFieldWithDefault struct {
	// The default value to be used for mapping when a SourceField is not provided or if there's no property with the specified
	// name in the published JSON event payload.
	DefaultValue *string `json:"defaultValue,omitempty"`

	// Name of a field in the input event schema that's to be used as the source of a mapping.
	SourceField *string `json:"sourceField,omitempty"`
}

// JSONInputSchemaMapping - This enables publishing to Event Grid using a custom input schema. This can be used to map properties
// from a custom input JSON schema to the Event Grid event schema.
type JSONInputSchemaMapping struct {
	// REQUIRED; Type of the custom mapping
	InputSchemaMappingType *InputSchemaMappingType `json:"inputSchemaMappingType,omitempty"`

	// JSON Properties of the input schema mapping
	Properties *JSONInputSchemaMappingProperties `json:"properties,omitempty"`
}

// GetInputSchemaMapping implements the InputSchemaMappingClassification interface for type JSONInputSchemaMapping.
func (j *JSONInputSchemaMapping) GetInputSchemaMapping() *InputSchemaMapping {
	return &InputSchemaMapping{
		InputSchemaMappingType: j.InputSchemaMappingType,
	}
}

// JSONInputSchemaMappingProperties - This can be used to map properties of a source schema (or default values, for certain
// supported properties) to properties of the EventGridEvent schema.
type JSONInputSchemaMappingProperties struct {
	// The mapping information for the DataVersion property of the Event Grid Event.
	DataVersion *JSONFieldWithDefault `json:"dataVersion,omitempty"`

	// The mapping information for the EventTime property of the Event Grid Event.
	EventTime *JSONField `json:"eventTime,omitempty"`

	// The mapping information for the EventType property of the Event Grid Event.
	EventType *JSONFieldWithDefault `json:"eventType,omitempty"`

	// The mapping information for the Id property of the Event Grid Event.
	ID *JSONField `json:"id,omitempty"`

	// The mapping information for the Subject property of the Event Grid Event.
	Subject *JSONFieldWithDefault `json:"subject,omitempty"`

	// The mapping information for the Topic property of the Event Grid Event.
	Topic *JSONField `json:"topic,omitempty"`
}

// NumberGreaterThanAdvancedFilter - NumberGreaterThan Advanced Filter.
type NumberGreaterThanAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`

	// The filter value.
	Value *float64 `json:"value,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type NumberGreaterThanAdvancedFilter.
func (n *NumberGreaterThanAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: n.OperatorType,
		Key:          n.Key,
	}
}

// NumberGreaterThanOrEqualsAdvancedFilter - NumberGreaterThanOrEquals Advanced Filter.
type NumberGreaterThanOrEqualsAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`

	// The filter value.
	Value *float64 `json:"value,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type NumberGreaterThanOrEqualsAdvancedFilter.
func (n *NumberGreaterThanOrEqualsAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: n.OperatorType,
		Key:          n.Key,
	}
}

// NumberInAdvancedFilter - NumberIn Advanced Filter.
type NumberInAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`

	// The set of filter values.
	Values []*float64 `json:"values,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type NumberInAdvancedFilter.
func (n *NumberInAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: n.OperatorType,
		Key:          n.Key,
	}
}

// NumberInRangeAdvancedFilter - NumberInRange Advanced Filter.
type NumberInRangeAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`

	// The set of filter values.
	Values [][]*float64 `json:"values,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type NumberInRangeAdvancedFilter.
func (n *NumberInRangeAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: n.OperatorType,
		Key:          n.Key,
	}
}

// NumberLessThanAdvancedFilter - NumberLessThan Advanced Filter.
type NumberLessThanAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`

	// The filter value.
	Value *float64 `json:"value,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type NumberLessThanAdvancedFilter.
func (n *NumberLessThanAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: n.OperatorType,
		Key:          n.Key,
	}
}

// NumberLessThanOrEqualsAdvancedFilter - NumberLessThanOrEquals Advanced Filter.
type NumberLessThanOrEqualsAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`

	// The filter value.
	Value *float64 `json:"value,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type NumberLessThanOrEqualsAdvancedFilter.
func (n *NumberLessThanOrEqualsAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: n.OperatorType,
		Key:          n.Key,
	}
}

// NumberNotInAdvancedFilter - NumberNotIn Advanced Filter.
type NumberNotInAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`

	// The set of filter values.
	Values []*float64 `json:"values,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type NumberNotInAdvancedFilter.
func (n *NumberNotInAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: n.OperatorType,
		Key:          n.Key,
	}
}

// NumberNotInRangeAdvancedFilter - NumberNotInRange Advanced Filter.
type NumberNotInRangeAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`

	// The set of filter values.
	Values [][]*float64 `json:"values,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type NumberNotInRangeAdvancedFilter.
func (n *NumberNotInRangeAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: n.OperatorType,
		Key:          n.Key,
	}
}

// Operation - Represents an operation returned by the GetOperations request.
type Operation struct {
	// Display name of the operation.
	Display *OperationInfo `json:"display,omitempty"`

	// This Boolean is used to determine if the operation is a data plane action or not.
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Name of the operation.
	Name *string `json:"name,omitempty"`

	// Origin of the operation.
	Origin *string `json:"origin,omitempty"`

	// Properties of the operation.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationInfo - Information about an operation
type OperationInfo struct {
	// Description of the operation
	Description *string `json:"description,omitempty"`

	// Name of the operation
	Operation *string `json:"operation,omitempty"`

	// Name of the provider
	Provider *string `json:"provider,omitempty"`

	// Name of the resource type
	Resource *string `json:"resource,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OperationsListResult - Result of the List Operations operation
type OperationsListResult struct {
	// A collection of operations
	Value []*Operation `json:"value,omitempty"`
}

// Partner - Information about the partner.
type Partner struct {
	// Expiration time of the partner authorization. If this timer expires, any request from this partner to create, update or
	// delete resources in subscriber's context will fail. If specified, the allowed
	// values are between 1 to the value of defaultMaximumExpirationTimeInDays specified in PartnerConfiguration. If not specified,
	// the default value will be the value of defaultMaximumExpirationTimeInDays
	// specified in PartnerConfiguration or 7 if this value is not specified.
	AuthorizationExpirationTimeInUTC *time.Time `json:"authorizationExpirationTimeInUtc,omitempty"`

	// The partner name.
	PartnerName *string `json:"partnerName,omitempty"`

	// The immutableId of the corresponding partner registration.
	PartnerRegistrationImmutableID *string `json:"partnerRegistrationImmutableId,omitempty"`
}

// PartnerAuthorization - The partner authorization details.
type PartnerAuthorization struct {
	// The list of authorized partners.
	AuthorizedPartnersList []*Partner `json:"authorizedPartnersList,omitempty"`

	// Time used to validate the authorization expiration time for each authorized partner. If DefaultMaximumExpirationTimeInDays
	// is not specified, the default is 7 days. Otherwise, allowed values are
	// between 1 and 365 days.
	DefaultMaximumExpirationTimeInDays *int32 `json:"defaultMaximumExpirationTimeInDays,omitempty"`
}

// PartnerConfiguration - Partner configuration information
type PartnerConfiguration struct {
	// Location of the resource.
	Location *string `json:"location,omitempty"`

	// Properties of the partner configuration.
	Properties *PartnerConfigurationProperties `json:"properties,omitempty"`

	// Tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to partner configuration resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PartnerConfigurationProperties - Properties of the partner configuration.
type PartnerConfigurationProperties struct {
	// The details of authorized partners.
	PartnerAuthorization *PartnerAuthorization `json:"partnerAuthorization,omitempty"`

	// Provisioning state of the partner configuration.
	ProvisioningState *PartnerConfigurationProvisioningState `json:"provisioningState,omitempty"`
}

// PartnerConfigurationUpdateParameterProperties - Information of partner configuration update parameter properties.
type PartnerConfigurationUpdateParameterProperties struct {
	// The default time used to validate the maximum expiration time for each authorized partners in days. Allowed values ar between
	// 1 and 365 days.
	DefaultMaximumExpirationTimeInDays *int32 `json:"defaultMaximumExpirationTimeInDays,omitempty"`
}

// PartnerConfigurationUpdateParameters - Properties of the partner configuration update.
type PartnerConfigurationUpdateParameters struct {
	// Properties of the Topic resource.
	Properties *PartnerConfigurationUpdateParameterProperties `json:"properties,omitempty"`

	// Tags of the partner configuration resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// PartnerConfigurationsClientAuthorizePartnerOptions contains the optional parameters for the PartnerConfigurationsClient.AuthorizePartner
// method.
type PartnerConfigurationsClientAuthorizePartnerOptions struct {
	// placeholder for future optional parameters
}

// PartnerConfigurationsClientBeginCreateOrUpdateOptions contains the optional parameters for the PartnerConfigurationsClient.BeginCreateOrUpdate
// method.
type PartnerConfigurationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PartnerConfigurationsClientBeginDeleteOptions contains the optional parameters for the PartnerConfigurationsClient.BeginDelete
// method.
type PartnerConfigurationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PartnerConfigurationsClientBeginUpdateOptions contains the optional parameters for the PartnerConfigurationsClient.BeginUpdate
// method.
type PartnerConfigurationsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PartnerConfigurationsClientGetOptions contains the optional parameters for the PartnerConfigurationsClient.Get method.
type PartnerConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PartnerConfigurationsClientListByResourceGroupOptions contains the optional parameters for the PartnerConfigurationsClient.ListByResourceGroup
// method.
type PartnerConfigurationsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PartnerConfigurationsClientListBySubscriptionOptions contains the optional parameters for the PartnerConfigurationsClient.ListBySubscription
// method.
type PartnerConfigurationsClientListBySubscriptionOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// PartnerConfigurationsClientUnauthorizePartnerOptions contains the optional parameters for the PartnerConfigurationsClient.UnauthorizePartner
// method.
type PartnerConfigurationsClientUnauthorizePartnerOptions struct {
	// placeholder for future optional parameters
}

// PartnerConfigurationsListResult - Result of the List partner configurations operation
type PartnerConfigurationsListResult struct {
	// A link for the next page of partner configurations.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of partner configurations.
	Value []*PartnerConfiguration `json:"value,omitempty"`
}

// PartnerDetails - Information about the partner.
type PartnerDetails struct {
	// This is short description about the partner. The length of this description should not exceed 256 characters.
	Description *string `json:"description,omitempty"`

	// Long description for the partner's scenarios and integration.Length of this description should not exceed 2048 characters.
	LongDescription *string `json:"longDescription,omitempty"`

	// URI of the partner website that can be used by Azure customers to setup Event Grid integration on an event source.
	SetupURI *string `json:"setupUri,omitempty"`
}

// PartnerNamespace - EventGrid Partner Namespace.
type PartnerNamespace struct {
	// REQUIRED; Location of the resource.
	Location *string `json:"location,omitempty"`

	// Properties of the Partner Namespace.
	Properties *PartnerNamespaceProperties `json:"properties,omitempty"`

	// Tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to Partner Namespace resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PartnerNamespaceProperties - Properties of the partner namespace.
type PartnerNamespaceProperties struct {
	// This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD
	// token will be used to authenticate if user is allowed to publish to the partner
	// namespace.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess
	// is enabled.
	InboundIPRules []*InboundIPRule `json:"inboundIpRules,omitempty"`

	// The fully qualified ARM Id of the partner registration that should be associated with this partner namespace. This takes
	// the following format:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerRegistrations/{partnerRegistrationName}.
	PartnerRegistrationFullyQualifiedID *string `json:"partnerRegistrationFullyQualifiedId,omitempty"`

	// This determines if events published to this partner namespace should use the source attribute in the event payload or use
	// the channel name in the header when matching to the partner topic. If none is
	// specified, source attribute routing will be used to match the partner topic.
	PartnerTopicRoutingMode *PartnerTopicRoutingMode `json:"partnerTopicRoutingMode,omitempty"`

	// This determines if traffic is allowed over public network. By default it is enabled. You can further restrict to specific
	// IPs by configuring
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// READ-ONLY; Endpoint for the partner namespace.
	Endpoint *string `json:"endpoint,omitempty" azure:"ro"`

	// READ-ONLY
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the partner namespace.
	ProvisioningState *PartnerNamespaceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PartnerNamespaceRegenerateKeyRequest - PartnerNamespace regenerate shared access key request.
type PartnerNamespaceRegenerateKeyRequest struct {
	// REQUIRED; Key name to regenerate (key1 or key2).
	KeyName *string `json:"keyName,omitempty"`
}

// PartnerNamespaceSharedAccessKeys - Shared access keys of the partner namespace.
type PartnerNamespaceSharedAccessKeys struct {
	// Shared access key1 for the partner namespace.
	Key1 *string `json:"key1,omitempty"`

	// Shared access key2 for the partner namespace.
	Key2 *string `json:"key2,omitempty"`
}

// PartnerNamespaceUpdateParameterProperties - Information of Partner Namespace update parameter properties.
type PartnerNamespaceUpdateParameterProperties struct {
	// This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD
	// token will be used to authenticate if user is allowed to publish to the partner
	// namespace.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess
	// is enabled.
	InboundIPRules []*InboundIPRule `json:"inboundIpRules,omitempty"`

	// This determines if traffic is allowed over public network. By default it is enabled. You can further restrict to specific
	// IPs by configuring
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// PartnerNamespaceUpdateParameters - Properties of the Partner Namespace update.
type PartnerNamespaceUpdateParameters struct {
	// Properties of the Partner Namespace.
	Properties *PartnerNamespaceUpdateParameterProperties `json:"properties,omitempty"`

	// Tags of the Partner Namespace.
	Tags map[string]*string `json:"tags,omitempty"`
}

// PartnerNamespacesClientBeginCreateOrUpdateOptions contains the optional parameters for the PartnerNamespacesClient.BeginCreateOrUpdate
// method.
type PartnerNamespacesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PartnerNamespacesClientBeginDeleteOptions contains the optional parameters for the PartnerNamespacesClient.BeginDelete
// method.
type PartnerNamespacesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PartnerNamespacesClientBeginUpdateOptions contains the optional parameters for the PartnerNamespacesClient.BeginUpdate
// method.
type PartnerNamespacesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PartnerNamespacesClientGetOptions contains the optional parameters for the PartnerNamespacesClient.Get method.
type PartnerNamespacesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PartnerNamespacesClientListByResourceGroupOptions contains the optional parameters for the PartnerNamespacesClient.ListByResourceGroup
// method.
type PartnerNamespacesClientListByResourceGroupOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// PartnerNamespacesClientListBySubscriptionOptions contains the optional parameters for the PartnerNamespacesClient.ListBySubscription
// method.
type PartnerNamespacesClientListBySubscriptionOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// PartnerNamespacesClientListSharedAccessKeysOptions contains the optional parameters for the PartnerNamespacesClient.ListSharedAccessKeys
// method.
type PartnerNamespacesClientListSharedAccessKeysOptions struct {
	// placeholder for future optional parameters
}

// PartnerNamespacesClientRegenerateKeyOptions contains the optional parameters for the PartnerNamespacesClient.RegenerateKey
// method.
type PartnerNamespacesClientRegenerateKeyOptions struct {
	// placeholder for future optional parameters
}

// PartnerNamespacesListResult - Result of the List Partner Namespaces operation
type PartnerNamespacesListResult struct {
	// A link for the next page of partner namespaces.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of partner namespaces.
	Value []*PartnerNamespace `json:"value,omitempty"`
}

// PartnerRegistration - Information about a partner registration.
type PartnerRegistration struct {
	// REQUIRED; Location of the resource.
	Location *string `json:"location,omitempty"`

	// Properties of the partner registration.
	Properties *PartnerRegistrationProperties `json:"properties,omitempty"`

	// Tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to Partner Registration resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PartnerRegistrationProperties - Properties of the partner registration.
type PartnerRegistrationProperties struct {
	// The immutableId of the corresponding partner registration. Note: This property is marked for deprecation and is not supported
	// in any future GA API version
	PartnerRegistrationImmutableID *string `json:"partnerRegistrationImmutableId,omitempty"`

	// READ-ONLY; Provisioning state of the partner registration.
	ProvisioningState *PartnerRegistrationProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PartnerRegistrationUpdateParameters - Properties of the Partner Registration update.
type PartnerRegistrationUpdateParameters struct {
	// Tags of the partner registration resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// PartnerRegistrationsClientBeginCreateOrUpdateOptions contains the optional parameters for the PartnerRegistrationsClient.BeginCreateOrUpdate
// method.
type PartnerRegistrationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PartnerRegistrationsClientBeginDeleteOptions contains the optional parameters for the PartnerRegistrationsClient.BeginDelete
// method.
type PartnerRegistrationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PartnerRegistrationsClientBeginUpdateOptions contains the optional parameters for the PartnerRegistrationsClient.BeginUpdate
// method.
type PartnerRegistrationsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PartnerRegistrationsClientGetOptions contains the optional parameters for the PartnerRegistrationsClient.Get method.
type PartnerRegistrationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PartnerRegistrationsClientListByResourceGroupOptions contains the optional parameters for the PartnerRegistrationsClient.ListByResourceGroup
// method.
type PartnerRegistrationsClientListByResourceGroupOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// PartnerRegistrationsClientListBySubscriptionOptions contains the optional parameters for the PartnerRegistrationsClient.ListBySubscription
// method.
type PartnerRegistrationsClientListBySubscriptionOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// PartnerRegistrationsListResult - Result of the List Partner Registrations operation.
type PartnerRegistrationsListResult struct {
	// A link for the next page of partner registrations.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of partner registrations.
	Value []*PartnerRegistration `json:"value,omitempty"`
}

// PartnerTopic - Event Grid Partner Topic.
type PartnerTopic struct {
	// REQUIRED; Location of the resource.
	Location *string `json:"location,omitempty"`

	// Identity information for the Partner Topic resource.
	Identity *IdentityInfo `json:"identity,omitempty"`

	// Properties of the Partner Topic.
	Properties *PartnerTopicProperties `json:"properties,omitempty"`

	// Tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to Partner Topic resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PartnerTopicEventSubscriptionsClientBeginCreateOrUpdateOptions contains the optional parameters for the PartnerTopicEventSubscriptionsClient.BeginCreateOrUpdate
// method.
type PartnerTopicEventSubscriptionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PartnerTopicEventSubscriptionsClientBeginDeleteOptions contains the optional parameters for the PartnerTopicEventSubscriptionsClient.BeginDelete
// method.
type PartnerTopicEventSubscriptionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PartnerTopicEventSubscriptionsClientBeginUpdateOptions contains the optional parameters for the PartnerTopicEventSubscriptionsClient.BeginUpdate
// method.
type PartnerTopicEventSubscriptionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PartnerTopicEventSubscriptionsClientGetDeliveryAttributesOptions contains the optional parameters for the PartnerTopicEventSubscriptionsClient.GetDeliveryAttributes
// method.
type PartnerTopicEventSubscriptionsClientGetDeliveryAttributesOptions struct {
	// placeholder for future optional parameters
}

// PartnerTopicEventSubscriptionsClientGetFullURLOptions contains the optional parameters for the PartnerTopicEventSubscriptionsClient.GetFullURL
// method.
type PartnerTopicEventSubscriptionsClientGetFullURLOptions struct {
	// placeholder for future optional parameters
}

// PartnerTopicEventSubscriptionsClientGetOptions contains the optional parameters for the PartnerTopicEventSubscriptionsClient.Get
// method.
type PartnerTopicEventSubscriptionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PartnerTopicEventSubscriptionsClientListByPartnerTopicOptions contains the optional parameters for the PartnerTopicEventSubscriptionsClient.ListByPartnerTopic
// method.
type PartnerTopicEventSubscriptionsClientListByPartnerTopicOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// PartnerTopicInfo - Properties of the corresponding partner topic of a Channel.
type PartnerTopicInfo struct {
	// Azure subscription ID of the subscriber. The partner topic associated with the channel will be created under this Azure
	// subscription.
	AzureSubscriptionID *string `json:"azureSubscriptionId,omitempty"`

	// Event Type Information for the partner topic. This information is provided by the publisher and can be used by the subscriber
	// to view different types of events that are published.
	EventTypeInfo *EventTypeInfo `json:"eventTypeInfo,omitempty"`

	// Name of the partner topic associated with the channel.
	Name *string `json:"name,omitempty"`

	// Azure Resource Group of the subscriber. The partner topic associated with the channel will be created under this resource
	// group.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`

	// The source information is provided by the publisher to determine the scope or context from which the events are originating.
	// This information can be used by the subscriber during the approval process
	// of the created partner topic.
	Source *string `json:"source,omitempty"`
}

// PartnerTopicProperties - Properties of the Partner Topic.
type PartnerTopicProperties struct {
	// Activation state of the partner topic.
	ActivationState *PartnerTopicActivationState `json:"activationState,omitempty"`

	// Event Type information from the corresponding event channel.
	EventTypeInfo *EventTypeInfo `json:"eventTypeInfo,omitempty"`

	// Expiration time of the partner topic. If this timer expires while the partner topic is still never activated, the partner
	// topic and corresponding event channel are deleted.
	ExpirationTimeIfNotActivatedUTC *time.Time `json:"expirationTimeIfNotActivatedUtc,omitempty"`

	// Context or helpful message that can be used during the approval process by the subscriber.
	MessageForActivation *string `json:"messageForActivation,omitempty"`

	// The immutableId of the corresponding partner registration.
	PartnerRegistrationImmutableID *string `json:"partnerRegistrationImmutableId,omitempty"`

	// Friendly description about the topic. This can be set by the publisher/partner to show custom description for the customer
	// partner topic. This will be helpful to remove any ambiguity of the origin of
	// creation of the partner topic for the customer.
	PartnerTopicFriendlyDescription *string `json:"partnerTopicFriendlyDescription,omitempty"`

	// Source associated with this partner topic. This represents a unique partner resource.
	Source *string `json:"source,omitempty"`

	// READ-ONLY; Provisioning state of the partner topic.
	ProvisioningState *PartnerTopicProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PartnerTopicUpdateParameters - Properties of the Partner Topic update.
type PartnerTopicUpdateParameters struct {
	// Identity information for the Partner Topic resource.
	Identity *IdentityInfo `json:"identity,omitempty"`

	// Tags of the Partner Topic resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// PartnerTopicsClientActivateOptions contains the optional parameters for the PartnerTopicsClient.Activate method.
type PartnerTopicsClientActivateOptions struct {
	// placeholder for future optional parameters
}

// PartnerTopicsClientBeginDeleteOptions contains the optional parameters for the PartnerTopicsClient.BeginDelete method.
type PartnerTopicsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PartnerTopicsClientCreateOrUpdateOptions contains the optional parameters for the PartnerTopicsClient.CreateOrUpdate method.
type PartnerTopicsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PartnerTopicsClientDeactivateOptions contains the optional parameters for the PartnerTopicsClient.Deactivate method.
type PartnerTopicsClientDeactivateOptions struct {
	// placeholder for future optional parameters
}

// PartnerTopicsClientGetOptions contains the optional parameters for the PartnerTopicsClient.Get method.
type PartnerTopicsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PartnerTopicsClientListByResourceGroupOptions contains the optional parameters for the PartnerTopicsClient.ListByResourceGroup
// method.
type PartnerTopicsClientListByResourceGroupOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// PartnerTopicsClientListBySubscriptionOptions contains the optional parameters for the PartnerTopicsClient.ListBySubscription
// method.
type PartnerTopicsClientListBySubscriptionOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// PartnerTopicsClientUpdateOptions contains the optional parameters for the PartnerTopicsClient.Update method.
type PartnerTopicsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// PartnerTopicsListResult - Result of the List Partner Topics operation.
type PartnerTopicsListResult struct {
	// A link for the next page of partner topics.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of partner topics.
	Value []*PartnerTopic `json:"value,omitempty"`
}

// PartnerUpdateTopicInfo - Update properties for the corresponding partner topic of a channel.
type PartnerUpdateTopicInfo struct {
	// Event type info for the partner topic
	EventTypeInfo *EventTypeInfo `json:"eventTypeInfo,omitempty"`
}

// PrivateEndpoint information.
type PrivateEndpoint struct {
	// The ARM identifier for Private Endpoint.
	ID *string `json:"id,omitempty"`
}

type PrivateEndpointConnection struct {
	// Properties of the PrivateEndpointConnection.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - Result of the list of all private endpoint connections operation.
type PrivateEndpointConnectionListResult struct {
	// A link for the next page of private endpoint connection resources.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of private endpoint connection resources.
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the private endpoint connection resource.
type PrivateEndpointConnectionProperties struct {
	// GroupIds from the private link service resource.
	GroupIDs []*string `json:"groupIds,omitempty"`

	// The Private Endpoint resource for this Connection.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// Details about the state of the connection.
	PrivateLinkServiceConnectionState *ConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// Provisioning state of the Private Endpoint Connection.
	ProvisioningState *ResourceProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientBeginUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginUpdate
// method.
type PrivateEndpointConnectionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListByResourceOptions contains the optional parameters for the PrivateEndpointConnectionsClient.ListByResource
// method.
type PrivateEndpointConnectionsClientListByResourceOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// PrivateLinkResource - Information of the private link resource.
type PrivateLinkResource struct {
	// Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`

	// Name of the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the private link resource.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// Type of the resource.
	Type *string `json:"type,omitempty"`
}

type PrivateLinkResourceProperties struct {
	DisplayName       *string   `json:"displayName,omitempty"`
	GroupID           *string   `json:"groupId,omitempty"`
	RequiredMembers   []*string `json:"requiredMembers,omitempty"`
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientListByResourceOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByResource
// method.
type PrivateLinkResourcesClientListByResourceOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// PrivateLinkResourcesListResult - Result of the List private link resources operation.
type PrivateLinkResourcesListResult struct {
	// A link for the next page of private link resources.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// Resource - Definition of a Resource.
type Resource struct {
	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RetryPolicy - Information about the retry policy for an event subscription.
type RetryPolicy struct {
	// Time To Live (in minutes) for events.
	EventTimeToLiveInMinutes *int32 `json:"eventTimeToLiveInMinutes,omitempty"`

	// Maximum number of delivery retry attempts for events.
	MaxDeliveryAttempts *int32 `json:"maxDeliveryAttempts,omitempty"`
}

// ServiceBusQueueEventSubscriptionDestination - Information about the service bus destination for an event subscription.
type ServiceBusQueueEventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType `json:"endpointType,omitempty"`

	// Service Bus Properties of the event subscription destination.
	Properties *ServiceBusQueueEventSubscriptionDestinationProperties `json:"properties,omitempty"`
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type ServiceBusQueueEventSubscriptionDestination.
func (s *ServiceBusQueueEventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return &EventSubscriptionDestination{
		EndpointType: s.EndpointType,
	}
}

// ServiceBusQueueEventSubscriptionDestinationProperties - The properties that represent the Service Bus destination of an
// event subscription.
type ServiceBusQueueEventSubscriptionDestinationProperties struct {
	// Delivery attribute details.
	DeliveryAttributeMappings []DeliveryAttributeMappingClassification `json:"deliveryAttributeMappings,omitempty"`

	// The Azure Resource Id that represents the endpoint of the Service Bus destination of an event subscription.
	ResourceID *string `json:"resourceId,omitempty"`
}

// ServiceBusTopicEventSubscriptionDestination - Information about the service bus topic destination for an event subscription.
type ServiceBusTopicEventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType `json:"endpointType,omitempty"`

	// Service Bus Topic Properties of the event subscription destination.
	Properties *ServiceBusTopicEventSubscriptionDestinationProperties `json:"properties,omitempty"`
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type ServiceBusTopicEventSubscriptionDestination.
func (s *ServiceBusTopicEventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return &EventSubscriptionDestination{
		EndpointType: s.EndpointType,
	}
}

// ServiceBusTopicEventSubscriptionDestinationProperties - The properties that represent the Service Bus Topic destination
// of an event subscription.
type ServiceBusTopicEventSubscriptionDestinationProperties struct {
	// Delivery attribute details.
	DeliveryAttributeMappings []DeliveryAttributeMappingClassification `json:"deliveryAttributeMappings,omitempty"`

	// The Azure Resource Id that represents the endpoint of the Service Bus Topic destination of an event subscription.
	ResourceID *string `json:"resourceId,omitempty"`
}

// StaticDeliveryAttributeMapping - Static delivery attribute mapping details.
type StaticDeliveryAttributeMapping struct {
	// REQUIRED; Type of the delivery attribute or header name.
	Type *DeliveryAttributeMappingType `json:"type,omitempty"`

	// Name of the delivery attribute or header.
	Name *string `json:"name,omitempty"`

	// Properties of static delivery attribute mapping.
	Properties *StaticDeliveryAttributeMappingProperties `json:"properties,omitempty"`
}

// GetDeliveryAttributeMapping implements the DeliveryAttributeMappingClassification interface for type StaticDeliveryAttributeMapping.
func (s *StaticDeliveryAttributeMapping) GetDeliveryAttributeMapping() *DeliveryAttributeMapping {
	return &DeliveryAttributeMapping{
		Name: s.Name,
		Type: s.Type,
	}
}

// StaticDeliveryAttributeMappingProperties - Properties of static delivery attribute mapping.
type StaticDeliveryAttributeMappingProperties struct {
	// Boolean flag to tell if the attribute contains sensitive information .
	IsSecret *bool `json:"isSecret,omitempty"`

	// Value of the delivery attribute.
	Value *string `json:"value,omitempty"`
}

// StorageBlobDeadLetterDestination - Information about the storage blob based dead letter destination.
type StorageBlobDeadLetterDestination struct {
	// REQUIRED; Type of the endpoint for the dead letter destination
	EndpointType *DeadLetterEndPointType `json:"endpointType,omitempty"`

	// The properties of the Storage Blob based deadletter destination
	Properties *StorageBlobDeadLetterDestinationProperties `json:"properties,omitempty"`
}

// GetDeadLetterDestination implements the DeadLetterDestinationClassification interface for type StorageBlobDeadLetterDestination.
func (s *StorageBlobDeadLetterDestination) GetDeadLetterDestination() *DeadLetterDestination {
	return &DeadLetterDestination{
		EndpointType: s.EndpointType,
	}
}

// StorageBlobDeadLetterDestinationProperties - Properties of the storage blob based dead letter destination.
type StorageBlobDeadLetterDestinationProperties struct {
	// The name of the Storage blob container that is the destination of the deadletter events
	BlobContainerName *string `json:"blobContainerName,omitempty"`

	// The Azure Resource ID of the storage account that is the destination of the deadletter events
	ResourceID *string `json:"resourceId,omitempty"`
}

// StorageQueueEventSubscriptionDestination - Information about the storage queue destination for an event subscription.
type StorageQueueEventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType `json:"endpointType,omitempty"`

	// Storage Queue Properties of the event subscription destination.
	Properties *StorageQueueEventSubscriptionDestinationProperties `json:"properties,omitempty"`
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type StorageQueueEventSubscriptionDestination.
func (s *StorageQueueEventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return &EventSubscriptionDestination{
		EndpointType: s.EndpointType,
	}
}

// StorageQueueEventSubscriptionDestinationProperties - The properties for a storage queue destination.
type StorageQueueEventSubscriptionDestinationProperties struct {
	// Storage queue message time to live in seconds.
	QueueMessageTimeToLiveInSeconds *int64 `json:"queueMessageTimeToLiveInSeconds,omitempty"`

	// The name of the Storage queue under a storage account that is the destination of an event subscription.
	QueueName *string `json:"queueName,omitempty"`

	// The Azure Resource ID of the storage account that contains the queue that is the destination of an event subscription.
	ResourceID *string `json:"resourceId,omitempty"`
}

// StringBeginsWithAdvancedFilter - StringBeginsWith Advanced Filter.
type StringBeginsWithAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`

	// The set of filter values.
	Values []*string `json:"values,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type StringBeginsWithAdvancedFilter.
func (s *StringBeginsWithAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: s.OperatorType,
		Key:          s.Key,
	}
}

// StringContainsAdvancedFilter - StringContains Advanced Filter.
type StringContainsAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`

	// The set of filter values.
	Values []*string `json:"values,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type StringContainsAdvancedFilter.
func (s *StringContainsAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: s.OperatorType,
		Key:          s.Key,
	}
}

// StringEndsWithAdvancedFilter - StringEndsWith Advanced Filter.
type StringEndsWithAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`

	// The set of filter values.
	Values []*string `json:"values,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type StringEndsWithAdvancedFilter.
func (s *StringEndsWithAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: s.OperatorType,
		Key:          s.Key,
	}
}

// StringInAdvancedFilter - StringIn Advanced Filter.
type StringInAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`

	// The set of filter values.
	Values []*string `json:"values,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type StringInAdvancedFilter.
func (s *StringInAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: s.OperatorType,
		Key:          s.Key,
	}
}

// StringNotBeginsWithAdvancedFilter - StringNotBeginsWith Advanced Filter.
type StringNotBeginsWithAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`

	// The set of filter values.
	Values []*string `json:"values,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type StringNotBeginsWithAdvancedFilter.
func (s *StringNotBeginsWithAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: s.OperatorType,
		Key:          s.Key,
	}
}

// StringNotContainsAdvancedFilter - StringNotContains Advanced Filter.
type StringNotContainsAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`

	// The set of filter values.
	Values []*string `json:"values,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type StringNotContainsAdvancedFilter.
func (s *StringNotContainsAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: s.OperatorType,
		Key:          s.Key,
	}
}

// StringNotEndsWithAdvancedFilter - StringNotEndsWith Advanced Filter.
type StringNotEndsWithAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`

	// The set of filter values.
	Values []*string `json:"values,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type StringNotEndsWithAdvancedFilter.
func (s *StringNotEndsWithAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: s.OperatorType,
		Key:          s.Key,
	}
}

// StringNotInAdvancedFilter - StringNotIn Advanced Filter.
type StringNotInAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType `json:"operatorType,omitempty"`

	// The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`

	// The set of filter values.
	Values []*string `json:"values,omitempty"`
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type StringNotInAdvancedFilter.
func (s *StringNotInAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		OperatorType: s.OperatorType,
		Key:          s.Key,
	}
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// SystemTopic - EventGrid System Topic.
type SystemTopic struct {
	// REQUIRED; Location of the resource.
	Location *string `json:"location,omitempty"`

	// Identity information for the resource.
	Identity *IdentityInfo `json:"identity,omitempty"`

	// Properties of the system topic.
	Properties *SystemTopicProperties `json:"properties,omitempty"`

	// Tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to System Topic resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SystemTopicEventSubscriptionsClientBeginCreateOrUpdateOptions contains the optional parameters for the SystemTopicEventSubscriptionsClient.BeginCreateOrUpdate
// method.
type SystemTopicEventSubscriptionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SystemTopicEventSubscriptionsClientBeginDeleteOptions contains the optional parameters for the SystemTopicEventSubscriptionsClient.BeginDelete
// method.
type SystemTopicEventSubscriptionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SystemTopicEventSubscriptionsClientBeginUpdateOptions contains the optional parameters for the SystemTopicEventSubscriptionsClient.BeginUpdate
// method.
type SystemTopicEventSubscriptionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SystemTopicEventSubscriptionsClientGetDeliveryAttributesOptions contains the optional parameters for the SystemTopicEventSubscriptionsClient.GetDeliveryAttributes
// method.
type SystemTopicEventSubscriptionsClientGetDeliveryAttributesOptions struct {
	// placeholder for future optional parameters
}

// SystemTopicEventSubscriptionsClientGetFullURLOptions contains the optional parameters for the SystemTopicEventSubscriptionsClient.GetFullURL
// method.
type SystemTopicEventSubscriptionsClientGetFullURLOptions struct {
	// placeholder for future optional parameters
}

// SystemTopicEventSubscriptionsClientGetOptions contains the optional parameters for the SystemTopicEventSubscriptionsClient.Get
// method.
type SystemTopicEventSubscriptionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SystemTopicEventSubscriptionsClientListBySystemTopicOptions contains the optional parameters for the SystemTopicEventSubscriptionsClient.ListBySystemTopic
// method.
type SystemTopicEventSubscriptionsClientListBySystemTopicOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// SystemTopicProperties - Properties of the System Topic.
type SystemTopicProperties struct {
	// Source for the system topic.
	Source *string `json:"source,omitempty"`

	// TopicType for the system topic.
	TopicType *string `json:"topicType,omitempty"`

	// READ-ONLY; Metric resource id for the system topic.
	MetricResourceID *string `json:"metricResourceId,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the system topic.
	ProvisioningState *ResourceProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// SystemTopicUpdateParameters - Properties of the System Topic update.
type SystemTopicUpdateParameters struct {
	// Resource identity information.
	Identity *IdentityInfo `json:"identity,omitempty"`

	// Tags of the system topic.
	Tags map[string]*string `json:"tags,omitempty"`
}

// SystemTopicsClientBeginCreateOrUpdateOptions contains the optional parameters for the SystemTopicsClient.BeginCreateOrUpdate
// method.
type SystemTopicsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SystemTopicsClientBeginDeleteOptions contains the optional parameters for the SystemTopicsClient.BeginDelete method.
type SystemTopicsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SystemTopicsClientBeginUpdateOptions contains the optional parameters for the SystemTopicsClient.BeginUpdate method.
type SystemTopicsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SystemTopicsClientGetOptions contains the optional parameters for the SystemTopicsClient.Get method.
type SystemTopicsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SystemTopicsClientListByResourceGroupOptions contains the optional parameters for the SystemTopicsClient.ListByResourceGroup
// method.
type SystemTopicsClientListByResourceGroupOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// SystemTopicsClientListBySubscriptionOptions contains the optional parameters for the SystemTopicsClient.ListBySubscription
// method.
type SystemTopicsClientListBySubscriptionOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// SystemTopicsListResult - Result of the List System topics operation.
type SystemTopicsListResult struct {
	// A link for the next page of topics.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of system Topics.
	Value []*SystemTopic `json:"value,omitempty"`
}

// Topic - EventGrid Topic
type Topic struct {
	// REQUIRED; Location of the resource.
	Location *string `json:"location,omitempty"`

	// Identity information for the resource.
	Identity *IdentityInfo `json:"identity,omitempty"`

	// Properties of the topic.
	Properties *TopicProperties `json:"properties,omitempty"`

	// Tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to Topic resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TopicEventSubscriptionsClientBeginCreateOrUpdateOptions contains the optional parameters for the TopicEventSubscriptionsClient.BeginCreateOrUpdate
// method.
type TopicEventSubscriptionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TopicEventSubscriptionsClientBeginDeleteOptions contains the optional parameters for the TopicEventSubscriptionsClient.BeginDelete
// method.
type TopicEventSubscriptionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TopicEventSubscriptionsClientBeginUpdateOptions contains the optional parameters for the TopicEventSubscriptionsClient.BeginUpdate
// method.
type TopicEventSubscriptionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TopicEventSubscriptionsClientGetDeliveryAttributesOptions contains the optional parameters for the TopicEventSubscriptionsClient.GetDeliveryAttributes
// method.
type TopicEventSubscriptionsClientGetDeliveryAttributesOptions struct {
	// placeholder for future optional parameters
}

// TopicEventSubscriptionsClientGetFullURLOptions contains the optional parameters for the TopicEventSubscriptionsClient.GetFullURL
// method.
type TopicEventSubscriptionsClientGetFullURLOptions struct {
	// placeholder for future optional parameters
}

// TopicEventSubscriptionsClientGetOptions contains the optional parameters for the TopicEventSubscriptionsClient.Get method.
type TopicEventSubscriptionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// TopicEventSubscriptionsClientListOptions contains the optional parameters for the TopicEventSubscriptionsClient.List method.
type TopicEventSubscriptionsClientListOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// TopicProperties - Properties of the Topic.
type TopicProperties struct {
	// Data Residency Boundary of the resource.
	DataResidencyBoundary *DataResidencyBoundary `json:"dataResidencyBoundary,omitempty"`

	// This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD
	// token will be used to authenticate if user is allowed to publish to the topic.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess
	// is enabled.
	InboundIPRules []*InboundIPRule `json:"inboundIpRules,omitempty"`

	// This determines the format that Event Grid should expect for incoming events published to the topic.
	InputSchema *InputSchema `json:"inputSchema,omitempty"`

	// This enables publishing using custom event schemas. An InputSchemaMapping can be specified to map various properties of
	// a source schema to various required properties of the EventGridEvent schema.
	InputSchemaMapping InputSchemaMappingClassification `json:"inputSchemaMapping,omitempty"`

	// This determines if traffic is allowed over public network. By default it is enabled. You can further restrict to specific
	// IPs by configuring
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// READ-ONLY; Endpoint for the topic.
	Endpoint *string `json:"endpoint,omitempty" azure:"ro"`

	// READ-ONLY; Metric resource id for the topic.
	MetricResourceID *string `json:"metricResourceId,omitempty" azure:"ro"`

	// READ-ONLY
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the topic.
	ProvisioningState *TopicProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// TopicRegenerateKeyRequest - Topic regenerate share access key request
type TopicRegenerateKeyRequest struct {
	// REQUIRED; Key name to regenerate key1 or key2
	KeyName *string `json:"keyName,omitempty"`
}

// TopicSharedAccessKeys - Shared access keys of the Topic
type TopicSharedAccessKeys struct {
	// Shared access key1 for the topic.
	Key1 *string `json:"key1,omitempty"`

	// Shared access key2 for the topic.
	Key2 *string `json:"key2,omitempty"`
}

// TopicTypeInfo - Properties of a topic type info.
type TopicTypeInfo struct {
	// Properties of the topic type info
	Properties *TopicTypeProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TopicTypeProperties - Properties of a topic type.
type TopicTypeProperties struct {
	// Description of the topic type.
	Description *string `json:"description,omitempty"`

	// Display Name for the topic type.
	DisplayName *string `json:"displayName,omitempty"`

	// Namespace of the provider of the topic type.
	Provider *string `json:"provider,omitempty"`

	// Provisioning state of the topic type
	ProvisioningState *TopicTypeProvisioningState `json:"provisioningState,omitempty"`

	// Region type of the resource.
	ResourceRegionType *ResourceRegionType `json:"resourceRegionType,omitempty"`

	// Source resource format.
	SourceResourceFormat *string `json:"sourceResourceFormat,omitempty"`

	// List of locations supported by this topic type.
	SupportedLocations []*string `json:"supportedLocations,omitempty"`

	// Supported source scopes.
	SupportedScopesForSource []*TopicTypeSourceScope `json:"supportedScopesForSource,omitempty"`
}

// TopicTypesClientGetOptions contains the optional parameters for the TopicTypesClient.Get method.
type TopicTypesClientGetOptions struct {
	// placeholder for future optional parameters
}

// TopicTypesClientListEventTypesOptions contains the optional parameters for the TopicTypesClient.ListEventTypes method.
type TopicTypesClientListEventTypesOptions struct {
	// placeholder for future optional parameters
}

// TopicTypesClientListOptions contains the optional parameters for the TopicTypesClient.List method.
type TopicTypesClientListOptions struct {
	// placeholder for future optional parameters
}

// TopicTypesListResult - Result of the List Topic Types operation
type TopicTypesListResult struct {
	// A collection of topic types
	Value []*TopicTypeInfo `json:"value,omitempty"`
}

// TopicUpdateParameterProperties - Information of topic update parameter properties.
type TopicUpdateParameterProperties struct {
	// The data residency boundary for the topic.
	DataResidencyBoundary *DataResidencyBoundary `json:"dataResidencyBoundary,omitempty"`

	// This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD
	// token will be used to authenticate if user is allowed to publish to the topic.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess
	// is enabled.
	InboundIPRules []*InboundIPRule `json:"inboundIpRules,omitempty"`

	// This determines if traffic is allowed over public network. By default it is enabled. You can further restrict to specific
	// IPs by configuring
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// TopicUpdateParameters - Properties of the Topic update
type TopicUpdateParameters struct {
	// Topic resource identity information.
	Identity *IdentityInfo `json:"identity,omitempty"`

	// Properties of the Topic resource.
	Properties *TopicUpdateParameterProperties `json:"properties,omitempty"`

	// Tags of the Topic resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// TopicsClientBeginCreateOrUpdateOptions contains the optional parameters for the TopicsClient.BeginCreateOrUpdate method.
type TopicsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TopicsClientBeginDeleteOptions contains the optional parameters for the TopicsClient.BeginDelete method.
type TopicsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TopicsClientBeginRegenerateKeyOptions contains the optional parameters for the TopicsClient.BeginRegenerateKey method.
type TopicsClientBeginRegenerateKeyOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TopicsClientBeginUpdateOptions contains the optional parameters for the TopicsClient.BeginUpdate method.
type TopicsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TopicsClientGetOptions contains the optional parameters for the TopicsClient.Get method.
type TopicsClientGetOptions struct {
	// placeholder for future optional parameters
}

// TopicsClientListByResourceGroupOptions contains the optional parameters for the TopicsClient.ListByResourceGroup method.
type TopicsClientListByResourceGroupOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// TopicsClientListBySubscriptionOptions contains the optional parameters for the TopicsClient.ListBySubscription method.
type TopicsClientListBySubscriptionOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// TopicsClientListEventTypesOptions contains the optional parameters for the TopicsClient.ListEventTypes method.
type TopicsClientListEventTypesOptions struct {
	// placeholder for future optional parameters
}

// TopicsClientListSharedAccessKeysOptions contains the optional parameters for the TopicsClient.ListSharedAccessKeys method.
type TopicsClientListSharedAccessKeysOptions struct {
	// placeholder for future optional parameters
}

// TopicsListResult - Result of the List Topics operation
type TopicsListResult struct {
	// A link for the next page of topics
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of Topics
	Value []*Topic `json:"value,omitempty"`
}

// TrackedResource - Definition of a Tracked Resource.
type TrackedResource struct {
	// REQUIRED; Location of the resource.
	Location *string `json:"location,omitempty"`

	// Tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UserIdentityProperties - The information about the user identity.
type UserIdentityProperties struct {
	// The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`

	// The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
}

// VerifiedPartner - Verified partner information
type VerifiedPartner struct {
	// Properties of the verified partner.
	Properties *VerifiedPartnerProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to Verified Partner resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VerifiedPartnerProperties - Properties of the verified partner.
type VerifiedPartnerProperties struct {
	// Official name of the Partner.
	OrganizationName *string `json:"organizationName,omitempty"`

	// Display name of the verified partner.
	PartnerDisplayName *string `json:"partnerDisplayName,omitempty"`

	// ImmutableId of the corresponding partner registration.
	PartnerRegistrationImmutableID *string `json:"partnerRegistrationImmutableId,omitempty"`

	// Details of the partner topic scenario.
	PartnerTopicDetails *PartnerDetails `json:"partnerTopicDetails,omitempty"`

	// Provisioning state of the verified partner.
	ProvisioningState *VerifiedPartnerProvisioningState `json:"provisioningState,omitempty"`
}

// VerifiedPartnersClientGetOptions contains the optional parameters for the VerifiedPartnersClient.Get method.
type VerifiedPartnersClientGetOptions struct {
	// placeholder for future optional parameters
}

// VerifiedPartnersClientListOptions contains the optional parameters for the VerifiedPartnersClient.List method.
type VerifiedPartnersClientListOptions struct {
	// The query used to filter the search results using OData syntax. Filtering is permitted on the 'name' property only and
	// with limited number of OData operations. These operations are: the 'contains'
	// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
	// operations are supported. The following is a valid filter example:
	// $filter=contains(namE, 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location
	// eq 'westus'.
	Filter *string
	// The number of results to return per page for the list operation. Valid range for top parameter is 1 to 100. If not specified,
	// the default number of results to be returned is 20 items per page.
	Top *int32
}

// VerifiedPartnersListResult - Result of the List verified partners operation
type VerifiedPartnersListResult struct {
	// A link for the next page of verified partners if any.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of verified partners.
	Value []*VerifiedPartner `json:"value,omitempty"`
}

// WebHookEventSubscriptionDestination - Information about the webhook destination for an event subscription.
type WebHookEventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType `json:"endpointType,omitempty"`

	// WebHook Properties of the event subscription destination.
	Properties *WebHookEventSubscriptionDestinationProperties `json:"properties,omitempty"`
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type WebHookEventSubscriptionDestination.
func (w *WebHookEventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return &EventSubscriptionDestination{
		EndpointType: w.EndpointType,
	}
}

// WebHookEventSubscriptionDestinationProperties - Information about the webhook destination properties for an event subscription.
type WebHookEventSubscriptionDestinationProperties struct {
	// The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery
	// requests.
	AzureActiveDirectoryApplicationIDOrURI *string `json:"azureActiveDirectoryApplicationIdOrUri,omitempty"`

	// The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
	AzureActiveDirectoryTenantID *string `json:"azureActiveDirectoryTenantId,omitempty"`

	// Delivery attribute details.
	DeliveryAttributeMappings []DeliveryAttributeMappingClassification `json:"deliveryAttributeMappings,omitempty"`

	// The URL that represents the endpoint of the destination of an event subscription.
	EndpointURL *string `json:"endpointUrl,omitempty"`

	// Maximum number of events per batch.
	MaxEventsPerBatch *int32 `json:"maxEventsPerBatch,omitempty"`

	// Preferred batch size in Kilobytes.
	PreferredBatchSizeInKilobytes *int32 `json:"preferredBatchSizeInKilobytes,omitempty"`

	// READ-ONLY; The base URL that represents the endpoint of the destination of an event subscription.
	EndpointBaseURL *string `json:"endpointBaseUrl,omitempty" azure:"ro"`
}
