//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armiotsecurity

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type DefenderSettingsProperties.
func (d DefenderSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deviceQuota", d.DeviceQuota)
	populateTimeRFC3339(objectMap, "evaluationEndTime", d.EvaluationEndTime)
	populate(objectMap, "mdeIntegration", d.MdeIntegration)
	populate(objectMap, "onboardingKind", d.OnboardingKind)
	populate(objectMap, "sentinelWorkspaceResourceIds", d.SentinelWorkspaceResourceIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefenderSettingsProperties.
func (d *DefenderSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceQuota":
			err = unpopulate(val, "DeviceQuota", &d.DeviceQuota)
			delete(rawMsg, key)
		case "evaluationEndTime":
			err = unpopulateTimeRFC3339(val, "EvaluationEndTime", &d.EvaluationEndTime)
			delete(rawMsg, key)
		case "mdeIntegration":
			err = unpopulate(val, "MdeIntegration", &d.MdeIntegration)
			delete(rawMsg, key)
		case "onboardingKind":
			err = unpopulate(val, "OnboardingKind", &d.OnboardingKind)
			delete(rawMsg, key)
		case "sentinelWorkspaceResourceIds":
			err = unpopulate(val, "SentinelWorkspaceResourceIDs", &d.SentinelWorkspaceResourceIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceProperties.
func (d DeviceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalFields", &d.AdditionalFields)
	populate(objectMap, "authorizedState", d.AuthorizedState)
	populate(objectMap, "businessFunction", d.BusinessFunction)
	populate(objectMap, "cpes", d.Cpes)
	populate(objectMap, "criticality", d.Criticality)
	populate(objectMap, "deviceCategoryDisplayName", d.DeviceCategoryDisplayName)
	populate(objectMap, "deviceCategoryId", d.DeviceCategoryID)
	populate(objectMap, "deviceDataSource", d.DeviceDataSource)
	populate(objectMap, "deviceName", d.DeviceName)
	populate(objectMap, "deviceStatus", d.DeviceStatus)
	populate(objectMap, "deviceSubTypeDisplayName", d.DeviceSubTypeDisplayName)
	populate(objectMap, "deviceSubTypeId", d.DeviceSubTypeID)
	populate(objectMap, "deviceTags", d.DeviceTags)
	populate(objectMap, "deviceTypeDisplayName", d.DeviceTypeDisplayName)
	populate(objectMap, "deviceTypeId", d.DeviceTypeID)
	populate(objectMap, "firmwares", d.Firmwares)
	populateTimeRFC3339(objectMap, "firstSeen", d.FirstSeen)
	populate(objectMap, "hardware", d.Hardware)
	populateTimeRFC3339(objectMap, "lastProgrammingTime", d.LastProgrammingTime)
	populateTimeRFC3339(objectMap, "lastSeen", d.LastSeen)
	populateTimeRFC3339(objectMap, "lastUpdated", d.LastUpdated)
	populate(objectMap, "mergedDevices", d.MergedDevices)
	populate(objectMap, "mergedToDeviceId", d.MergedToDeviceID)
	populate(objectMap, "nics", d.Nics)
	populate(objectMap, "onboardingStatus", d.OnboardingStatus)
	populate(objectMap, "operatingSystem", d.OperatingSystem)
	populate(objectMap, "packages", d.Packages)
	populate(objectMap, "parentDeviceId", d.ParentDeviceID)
	populate(objectMap, "parentRackNumber", d.ParentRackNumber)
	populate(objectMap, "parentSlotNumber", d.ParentSlotNumber)
	populate(objectMap, "profilingConfidence", d.ProfilingConfidence)
	populate(objectMap, "programmingState", d.ProgrammingState)
	populate(objectMap, "purdueLevel", d.PurdueLevel)
	populate(objectMap, "riskScore", d.RiskScore)
	populate(objectMap, "schemaVersion", d.SchemaVersion)
	populate(objectMap, "sensor", d.Sensor)
	populate(objectMap, "slots", d.Slots)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceProperties.
func (d *DeviceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalFields":
			err = unpopulate(val, "AdditionalFields", &d.AdditionalFields)
			delete(rawMsg, key)
		case "authorizedState":
			err = unpopulate(val, "AuthorizedState", &d.AuthorizedState)
			delete(rawMsg, key)
		case "businessFunction":
			err = unpopulate(val, "BusinessFunction", &d.BusinessFunction)
			delete(rawMsg, key)
		case "cpes":
			err = unpopulate(val, "Cpes", &d.Cpes)
			delete(rawMsg, key)
		case "criticality":
			err = unpopulate(val, "Criticality", &d.Criticality)
			delete(rawMsg, key)
		case "deviceCategoryDisplayName":
			err = unpopulate(val, "DeviceCategoryDisplayName", &d.DeviceCategoryDisplayName)
			delete(rawMsg, key)
		case "deviceCategoryId":
			err = unpopulate(val, "DeviceCategoryID", &d.DeviceCategoryID)
			delete(rawMsg, key)
		case "deviceDataSource":
			err = unpopulate(val, "DeviceDataSource", &d.DeviceDataSource)
			delete(rawMsg, key)
		case "deviceName":
			err = unpopulate(val, "DeviceName", &d.DeviceName)
			delete(rawMsg, key)
		case "deviceStatus":
			err = unpopulate(val, "DeviceStatus", &d.DeviceStatus)
			delete(rawMsg, key)
		case "deviceSubTypeDisplayName":
			err = unpopulate(val, "DeviceSubTypeDisplayName", &d.DeviceSubTypeDisplayName)
			delete(rawMsg, key)
		case "deviceSubTypeId":
			err = unpopulate(val, "DeviceSubTypeID", &d.DeviceSubTypeID)
			delete(rawMsg, key)
		case "deviceTags":
			err = unpopulate(val, "DeviceTags", &d.DeviceTags)
			delete(rawMsg, key)
		case "deviceTypeDisplayName":
			err = unpopulate(val, "DeviceTypeDisplayName", &d.DeviceTypeDisplayName)
			delete(rawMsg, key)
		case "deviceTypeId":
			err = unpopulate(val, "DeviceTypeID", &d.DeviceTypeID)
			delete(rawMsg, key)
		case "firmwares":
			err = unpopulate(val, "Firmwares", &d.Firmwares)
			delete(rawMsg, key)
		case "firstSeen":
			err = unpopulateTimeRFC3339(val, "FirstSeen", &d.FirstSeen)
			delete(rawMsg, key)
		case "hardware":
			err = unpopulate(val, "Hardware", &d.Hardware)
			delete(rawMsg, key)
		case "lastProgrammingTime":
			err = unpopulateTimeRFC3339(val, "LastProgrammingTime", &d.LastProgrammingTime)
			delete(rawMsg, key)
		case "lastSeen":
			err = unpopulateTimeRFC3339(val, "LastSeen", &d.LastSeen)
			delete(rawMsg, key)
		case "lastUpdated":
			err = unpopulateTimeRFC3339(val, "LastUpdated", &d.LastUpdated)
			delete(rawMsg, key)
		case "mergedDevices":
			err = unpopulate(val, "MergedDevices", &d.MergedDevices)
			delete(rawMsg, key)
		case "mergedToDeviceId":
			err = unpopulate(val, "MergedToDeviceID", &d.MergedToDeviceID)
			delete(rawMsg, key)
		case "nics":
			err = unpopulate(val, "Nics", &d.Nics)
			delete(rawMsg, key)
		case "onboardingStatus":
			err = unpopulate(val, "OnboardingStatus", &d.OnboardingStatus)
			delete(rawMsg, key)
		case "operatingSystem":
			err = unpopulate(val, "OperatingSystem", &d.OperatingSystem)
			delete(rawMsg, key)
		case "packages":
			err = unpopulate(val, "Packages", &d.Packages)
			delete(rawMsg, key)
		case "parentDeviceId":
			err = unpopulate(val, "ParentDeviceID", &d.ParentDeviceID)
			delete(rawMsg, key)
		case "parentRackNumber":
			err = unpopulate(val, "ParentRackNumber", &d.ParentRackNumber)
			delete(rawMsg, key)
		case "parentSlotNumber":
			err = unpopulate(val, "ParentSlotNumber", &d.ParentSlotNumber)
			delete(rawMsg, key)
		case "profilingConfidence":
			err = unpopulate(val, "ProfilingConfidence", &d.ProfilingConfidence)
			delete(rawMsg, key)
		case "programmingState":
			err = unpopulate(val, "ProgrammingState", &d.ProgrammingState)
			delete(rawMsg, key)
		case "purdueLevel":
			err = unpopulate(val, "PurdueLevel", &d.PurdueLevel)
			delete(rawMsg, key)
		case "riskScore":
			err = unpopulate(val, "RiskScore", &d.RiskScore)
			delete(rawMsg, key)
		case "schemaVersion":
			err = unpopulate(val, "SchemaVersion", &d.SchemaVersion)
			delete(rawMsg, key)
		case "sensor":
			err = unpopulate(val, "Sensor", &d.Sensor)
			delete(rawMsg, key)
		case "slots":
			err = unpopulate(val, "Slots", &d.Slots)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Nic.
func (n Nic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ipv4Address", n.IPv4Address)
	populate(objectMap, "ipv6Address", n.IPv6Address)
	populateTimeRFC3339(objectMap, "lastSeen", n.LastSeen)
	populate(objectMap, "macAddress", n.MacAddress)
	populate(objectMap, "macCertainty", n.MacCertainty)
	populate(objectMap, "networkAdapterVendor", n.NetworkAdapterVendor)
	populate(objectMap, "vlans", n.Vlans)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Nic.
func (n *Nic) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipv4Address":
			err = unpopulate(val, "IPv4Address", &n.IPv4Address)
			delete(rawMsg, key)
		case "ipv6Address":
			err = unpopulate(val, "IPv6Address", &n.IPv6Address)
			delete(rawMsg, key)
		case "lastSeen":
			err = unpopulateTimeRFC3339(val, "LastSeen", &n.LastSeen)
			delete(rawMsg, key)
		case "macAddress":
			err = unpopulate(val, "MacAddress", &n.MacAddress)
			delete(rawMsg, key)
		case "macCertainty":
			err = unpopulate(val, "MacCertainty", &n.MacCertainty)
			delete(rawMsg, key)
		case "networkAdapterVendor":
			err = unpopulate(val, "NetworkAdapterVendor", &n.NetworkAdapterVendor)
			delete(rawMsg, key)
		case "vlans":
			err = unpopulate(val, "Vlans", &n.Vlans)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteProperties.
func (s SiteProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Slot.
func (s Slot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalData", &s.AdditionalData)
	populate(objectMap, "cpes", s.Cpes)
	populate(objectMap, "firmwareVersion", s.FirmwareVersion)
	populate(objectMap, "hardwareRevision", s.HardwareRevision)
	populate(objectMap, "hardwareVendor", s.HardwareVendor)
	populate(objectMap, "model", s.Model)
	populate(objectMap, "moduleVersion", s.ModuleVersion)
	populate(objectMap, "productCode", s.ProductCode)
	populate(objectMap, "rackNumber", s.RackNumber)
	populate(objectMap, "serialNumber", s.SerialNumber)
	populate(objectMap, "slotNumber", s.SlotNumber)
	populate(objectMap, "slotType", s.SlotType)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
