//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armscheduler

import "encoding/json"

func unmarshalHTTPAuthenticationClassification(rawMsg json.RawMessage) (HTTPAuthenticationClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b HTTPAuthenticationClassification
	switch m["type"] {
	case string(HTTPAuthenticationTypeActiveDirectoryOAuth):
		b = &OAuthAuthentication{}
	case string(HTTPAuthenticationTypeBasic):
		b = &BasicAuthentication{}
	case string(HTTPAuthenticationTypeClientCertificate):
		b = &ClientCertAuthentication{}
	default:
		b = &HTTPAuthentication{}
	}
	return b, json.Unmarshal(rawMsg, b)
}
