//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurityinsights

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// BookmarkClient contains the methods for the Bookmark group.
// Don't use this type directly, use NewBookmarkClient() instead.
type BookmarkClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewBookmarkClient creates a new instance of BookmarkClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewBookmarkClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*BookmarkClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &BookmarkClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Expand - Expand an bookmark
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-09-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// workspaceName - The name of the workspace.
// bookmarkID - Bookmark ID
// parameters - The parameters required to execute an expand operation on the given bookmark.
// options - BookmarkClientExpandOptions contains the optional parameters for the BookmarkClient.Expand method.
func (client *BookmarkClient) Expand(ctx context.Context, resourceGroupName string, workspaceName string, bookmarkID string, parameters BookmarkExpandParameters, options *BookmarkClientExpandOptions) (BookmarkClientExpandResponse, error) {
	req, err := client.expandCreateRequest(ctx, resourceGroupName, workspaceName, bookmarkID, parameters, options)
	if err != nil {
		return BookmarkClientExpandResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return BookmarkClientExpandResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BookmarkClientExpandResponse{}, runtime.NewResponseError(resp)
	}
	return client.expandHandleResponse(resp)
}

// expandCreateRequest creates the Expand request.
func (client *BookmarkClient) expandCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, bookmarkID string, parameters BookmarkExpandParameters, options *BookmarkClientExpandOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/bookmarks/{bookmarkId}/expand"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if bookmarkID == "" {
		return nil, errors.New("parameter bookmarkID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{bookmarkId}", url.PathEscape(bookmarkID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// expandHandleResponse handles the Expand response.
func (client *BookmarkClient) expandHandleResponse(resp *http.Response) (BookmarkClientExpandResponse, error) {
	result := BookmarkClientExpandResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BookmarkExpandResponse); err != nil {
		return BookmarkClientExpandResponse{}, err
	}
	return result, nil
}
