// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Information about an Cloud9 development environment.
type Environment struct {

	// The Amazon Resource Name (ARN) of the environment.
	//
	// This member is required.
	Arn *string

	// The Amazon Resource Name (ARN) of the environment owner.
	//
	// This member is required.
	OwnerArn *string

	// The type of environment. Valid values include the following:
	//
	// * ec2: An Amazon
	// Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
	//
	// * ssh:
	// Your own server connects to the environment.
	//
	// This member is required.
	Type EnvironmentType

	// The connection type used for connecting to an Amazon EC2 environment.
	// CONNECT_SSH is selected by default.
	ConnectionType ConnectionType

	// The description for the environment.
	Description *string

	// The ID of the environment.
	Id *string

	// The state of the environment in its creation or deletion lifecycle.
	Lifecycle *EnvironmentLifecycle

	// Describes the status of Amazon Web Services managed temporary credentials for
	// the Cloud9 environment. Available values are:
	//
	// * ENABLED_ON_CREATE
	//
	// *
	// ENABLED_BY_OWNER
	//
	// * DISABLED_BY_DEFAULT
	//
	// * DISABLED_BY_OWNER
	//
	// *
	// DISABLED_BY_COLLABORATOR
	//
	// * PENDING_REMOVAL_BY_COLLABORATOR
	//
	// *
	// PENDING_REMOVAL_BY_OWNER
	//
	// * FAILED_REMOVAL_BY_COLLABORATOR
	//
	// *
	// ENABLED_BY_OWNER
	//
	// * DISABLED_BY_DEFAULT
	ManagedCredentialsStatus ManagedCredentialsStatus

	// The name of the environment.
	Name *string

	noSmithyDocumentSerde
}

// Information about the current creation or deletion lifecycle state of an Cloud9
// development environment.
type EnvironmentLifecycle struct {

	// If the environment failed to delete, the Amazon Resource Name (ARN) of the
	// related Amazon Web Services resource.
	FailureResource *string

	// Any informational message about the lifecycle state of the environment.
	Reason *string

	// The current creation or deletion lifecycle state of the environment.
	//
	// *
	// CREATING: The environment is in the process of being created.
	//
	// * CREATED: The
	// environment was successfully created.
	//
	// * CREATE_FAILED: The environment failed
	// to be created.
	//
	// * DELETING: The environment is in the process of being
	// deleted.
	//
	// * DELETE_FAILED: The environment failed to delete.
	Status EnvironmentLifecycleStatus

	noSmithyDocumentSerde
}

// Information about an environment member for an Cloud9 development environment.
type EnvironmentMember struct {

	// The ID of the environment for the environment member.
	//
	// This member is required.
	EnvironmentId *string

	// The type of environment member permissions associated with this environment
	// member. Available values include:
	//
	// * owner: Owns the environment.
	//
	// * read-only:
	// Has read-only access to the environment.
	//
	// * read-write: Has read-write access to
	// the environment.
	//
	// This member is required.
	Permissions Permissions

	// The Amazon Resource Name (ARN) of the environment member.
	//
	// This member is required.
	UserArn *string

	// The user ID in Identity and Access Management (IAM) of the environment member.
	//
	// This member is required.
	UserId *string

	// The time, expressed in epoch time format, when the environment member last
	// opened the environment.
	LastAccess *time.Time

	noSmithyDocumentSerde
}

// Metadata that is associated with Amazon Web Services resources. In particular, a
// name-value pair that can be associated with an Cloud9 development environment.
// There are two types of tags: user tags and system tags. A user tag is created by
// the user. A system tag is automatically created by Amazon Web Services services.
// A system tag is prefixed with "aws:" and cannot be modified by the user.
type Tag struct {

	// The name part of a tag.
	//
	// This member is required.
	Key *string

	// The value part of a tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
