
import math

import gobject
import gtk

import glitch, glitch.gtk
from glitch.limbo.lights import LightSwitch, DiffuseLight
from glitch.limbo.material import Material
from glitch.limbo.objects import Cube

def tick():
    if paused:
        return True

    global time
    theta = (3 * time) % 360
    theta2 = (time) % 360
    time += 1

    rotate.angle = theta

    camera.eye[0] = 3 * math.sin(theta2 * (math.pi / 180))
    camera.eye[2] = 3 * math.cos(theta2 * (math.pi / 180))
    camera.refresh()
    return True

def key_press(w, ev):
    global paused
    paused = True

def key_release(w, ev):
    global paused
    paused = False

if __name__ == '__main__':
    """            camera
                    |
                  light
              /     |     \
        material material material
             |      |     |
           trans   trans  trans
              \     |     /
                  rotate
                    |
                   cube
"""

    cube = Cube()

    rotate = glitch.Rotate(y=1, children=[cube])

    (trans1, trans2, trans3) = (
        glitch.Translate(0, 0, math.sqrt(3)/2, children=[rotate]),
        glitch.Translate(-1, 0, -math.sqrt(3)/2, children=[rotate]),
        glitch.Translate(1, 0, -math.sqrt(3)/2, children=[rotate]))

    (mat1, mat2, mat3) = (
        Material(1, 0, 0, children=[trans1]),
        Material(0, 1, 0, children=[trans2]),
        Material(0, 0, 1, children=[trans3]))

    time = 0
    paused = False
    camera = glitch.gtk.GtkCamera(eye=[0, 1, 3], children=[
        LightSwitch(children=[
            DiffuseLight(y=2, children=[mat1, mat2, mat3])])])

    w = gtk.Window()
    w.add(camera)
    w.connect('key-press-event', key_press)
    w.connect('key-release-event', key_release)
    w.show_all()

    gobject.timeout_add(30, tick)

    if '__IP' not in dir():
        w.connect('destroy', lambda w: gtk.main_quit())
        gtk.main()

