/*
  gmorgan - a ryhthm station software

  gmorgan.MIDIIn.C  -  MIDI In functions.
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License
 (version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

/* Alsa sequencer functions  by Matthias Nagorni 
   modified by Josep Andreu
   ...and again in 2010 by Robert Vogel. 
*/

#include "GMorgan.h"
#include "Chord.h"
#include <iostream>
using namespace std;
#include <string>
using std::string;
int topnote;
int numbernotes;
int keynote[128];
int kc;
int nn;

extern CHORD zing;
 
vector<int> midinotes;
vector<int> lastmidinotes;
// ****************************************************************
//  loop for midievents.
// ****************************************************************
void
GMO::miramidi()
{
int midicount = 0;
lastmidinotes.clear();
if (snd_seq_event_input_pending (MidiInPuerto[1].midi_in, 1))
{
    do
    {
        midievents(1);
    }
    while (snd_seq_event_input_pending (MidiInPuerto[1].midi_in, 0));
}
};

void
GMO::midievents (int keIN)
{
  int i;
  int j;
  int k;
  int firstnote;
  int lastnote;
  int modnote;
  snd_seq_event_t *midievent;
  midievent = NULL;
  snd_seq_event_input (MidiInPuerto[1].midi_in, &midievent);
  if (midievent == NULL) return;
  if(midievent->type == 42) return;
  if ((midievent->type == SND_SEQ_EVENT_NOTEON)
      || (midievent->type == SND_SEQ_EVENT_NOTEOFF))
    {
      int cmdtype = midievent->type;	
      int cmdnote = midievent->data.note.note;
      int cmdvelo = midievent->data.note.velocity;
      int cmddur  = midievent->data.note.duration;	
      int cmdchannel = midievent->data.note.channel; 
      globalchannel = cmdchannel;
      snd_seq_ev_set_subs (midievent);
      snd_seq_ev_set_direct (midievent);
      for (i=0; i<POLY; i++)
      {
        if ((midievent->type == SND_SEQ_EVENT_NOTEON) && (cmdvelo != 0))
      	{ 
        	note_active[i] = 1;
		keynote[cmdnote] = cmdnote;
		modnote = cmdnote%12;
                gate[i]=1;
	}
      }
// ***************************************************************************************
// Pack input midi keys pressed into a vector. 
// If you insert a call to Midi2Note it will print letter equivalents to the screen.
// ***************************************************************************************
	midinotes.clear();
	for (j=0; j<128; j++)
		{if (keynote[j] != 0)
			{
			topnote = keynote[j];
			midinotes.push_back(topnote);}
		}
// 
// event from funny keyboard. 
     if (KeybON)
	{
        std::string KBChord;
//	        zing.SetCurrentChordsym(KBChord);

	}
// **************************************************************************************
// If batch play is on, the leadsheet has provided the chord symbol, but, if not,
// determine Chord from midi keys pressed... if recognized. Don't do it if vectors of midinotes are unchanged.
// ***************************************************************************************
	else
	{
	if ((midinotes != lastmidinotes) && (bplay != 1)) 
		{
		std::string chordoutnew = zing.Midi2Chordsym(midinotes);
		lastmidinotes = midinotes;
		if ((chordoutnew != " ") && (bplay == 0))
			{
   			 zing.SetCurrentChordsym(chordoutnew);
		
		        std::string ngchordout = zing.GetCurrentChordsym();
	       		 char *sz;
		        sz = new char[ngchordout.length()+1];
		        strcpy(sz,ngchordout.c_str());
			ChangeChord();
		        delete [] sz;
			}
		}
	}
        if ((midievent->type == SND_SEQ_EVENT_NOTEON) && (cmdvelo == 0))
        {
        keynote[cmdnote] = 0;
        if ((note_active[i]) && (rnote[i]==cmdnote))
              {
               keynote[cmdnote] = 0;
               note_active[i] = 0;
               if (pedal == 0) gate[i]= 0;
              }
        }
        if (midievent->type == SND_SEQ_EVENT_NOTEOFF)
        {
		keynote[cmdnote] = 0;
        }
//  ********************************************************************
      if (OnOff[1]) 
      {
      if (((cmdnote >= v1lowMidi) && (cmdnote <= v1highMidi)) && ((cmdvelo >= v1lowVelocity) && (cmdvelo <= v1highVelocity)) || (cmdvelo == 0))
	{	      
		midievent->data.note.channel=TMch[1];
  		midievent->data.note.note=cmdnote+12+(12*octa[1])+transpose;
    		midievent->data.note.velocity=cmdvelo;
		if (grabacion)
			PonGraba(2,tick,midievent->data.note.note,midievent->data.note.channel,midievent->data.note.velocity,0,0,0,0);
			snd_seq_event_output_direct (MidiOutPuerto[1].midi_out, midievent);
//      if (HMode != 0 ) harmonize(HMode, 0, cmdchannel, cmdnote+(12*octa[3])+transpose, cmdvelo, 0);
	}
      }
  if (OnOff[2]) 
      {
      if (((cmdnote >= v2lowMidi) && (cmdnote <= v2highMidi)) && ((cmdvelo >= v2lowVelocity) && (cmdvelo <= v2highVelocity)) || (cmdvelo == 0))
	{
      midievent->data.note.channel=TMch[2];
      midievent->data.note.note=cmdnote+12+(12*octa[2])+transpose;
      midievent->data.note.velocity=cmdvelo;
      if (grabacion)
      PonGraba(2,tick,midievent->data.note.note,midievent->data.note.channel,midievent->data.note.velocity,0,0,0,0);
      snd_seq_event_output_direct (MidiOutPuerto[1].midi_out, midievent);
	}
      }
  if (OnOff[3])
      {
      if (((cmdnote >= v3lowMidi) && (cmdnote <= v3highMidi)) && ((cmdvelo >= v3lowVelocity) && (cmdvelo <= v3highVelocity)) || (cmdvelo == 0))
	{	      
      midievent->data.note.channel=TMch[3];
      midievent->data.note.note=cmdnote+(12*octa[3])+transpose;
      midievent->data.note.velocity=cmdvelo;
      if (grabacion)
      PonGraba(2,tick,midievent->data.note.note,midievent->data.note.channel,midievent->data.note.velocity,0,0,0,0);
      snd_seq_event_output_direct (MidiOutPuerto[1].midi_out, midievent);
//      if (HMode != 0 ) harmonize(HMode, 0, 2, cmdnote+(12*octa[3])+transpose, cmdvelo, 0);
	}
      }
      if (OnOff[4])
      {
      if (((cmdnote >= v4lowMidi) && (cmdnote <= v4highMidi)) && ((cmdvelo >= v4lowVelocity) && (cmdvelo <= v4highVelocity)) || (cmdvelo == 0))
	{	      
      midievent->data.note.channel=TMch[4];
//      midievent->data.note.channel;
      midievent->data.note.note=cmdnote+(12*octa[4])+transpose;
      midievent->data.note.velocity=cmdvelo;
      if (grabacion)
      PonGraba(2,tick,midievent->data.note.note,midievent->data.note.channel,midievent->data.note.velocity,0,0,0,0);
      snd_seq_event_output_direct (MidiOutPuerto[1].midi_out, midievent);
      if (HMode != 0) harmonize(HMode,0,TMch[3], cmdnote+(12*octa[4])+transpose,cmdvelo, 0);
	}
      }
  snd_seq_free_event(midievent);
  }
 };
// *************************************************************************************
//	harmonize if mode is on and note if 60 or greater.
// *************************************************************************************
void
GMO::harmonize(int hm, int sons, int channel, int note, int velo, int dur)
{
// ****************************************************************
if (note < 60) return;
// ****************************************************************
int i;
int contanota = 0;
// cout << "harmonize hm: " << hm << " sons " << sons << " channel: " << channel << " topnote:" << note << " velo: " << velo << " dur: " << dur << endl;
if (velo == 0)
{
 HarOFF[channel][note].estado = 0;
 for (i=0; i<=HarOFF[channel][note].nnotas; i++)
    suenaev(channel, HarOFF[channel][note].notas[i]+transpose,0);
 return;
}
int actualnote = 0;
int nolimit =1;
int iroot = 0;
int modlead = 0;
int base = 0;
int adjustment = 0;
int harmonypart = 0;
if ((HMode == 1) || (HMode == 2)) 
	{
	if (topnote < 61) return;
	hnotes[0] = topnote;
	vector<int> HarmonyVector = zing.CurrentHarmony;
	modlead = (topnote-zing.iroot)%12;
	hnotes[1] = topnote - HarmonyVector.at(modlead);
	nolimit = 1;
	}
if (HMode == 6) 
	{
	if (topnote < 61) return;
	int bottomnote = topnote -12;
	modlead = topnote%12;
	vector<int> harmonynotes = zing.GetCurrentChordNotes();
	for (int hk=0;hk<harmonynotes.size(); ++hk)
	 {
	 if (hk == 0)
		 {iroot = harmonynotes.at(0); 
		 hnotes[hk] = bottomnote;
		 if (modlead < iroot)
			{adjustment = (modlead - iroot)-12;}
		 else
			{adjustment = (modlead - iroot)-12;}
//		 cout << " adjustment: " << adjustment << endl;
		 // find root between the topnote and the bottomnote.
		 harmonypart = topnote - adjustment;
		 if (harmonypart > topnote) {harmonypart = harmonypart -12;}
		 if (harmonypart > topnote) {harmonypart = harmonypart -12;}
		 }
		else
		 {
		 hnotes[hk] = harmonypart;
		 nolimit = hk;
		 if (harmonynotes.at(hk) == 0) break;
		 cout << " base: " << base << " harmonynotes: " << harmonynotes.at(hk);
		 harmonypart = harmonypart + harmonynotes.at(hk);
		 if (harmonypart > topnote) {harmonypart = harmonypart -12;}
		 if (harmonypart > topnote) {harmonypart = harmonypart -12;}
//     		 cout << "  #" << hk << " " << hnotes[hk] << ": " << harmonynotes.at(hk) << " velo: " << "--> ";
		 Midi2Note(hnotes[hk]);
		 cout << endl;
		}
		}
	}
//	printf("%s%i%s%i%s%i%s","rlv channel: ",channel," note: ",note," nolimit: ",nolimit,"\n");
	HarOFF[channel][note].estado = 1;
	HarOFF[channel][note].nnotas = nolimit;
	HarOFF[channel][note].velo = velo;
	for (i=0; i<=nolimit; i++)
		{	
		  if (sons) sacaev(channel, hnotes[i]+transpose, velo-2, dur);

		 else
		        {
//			cout << " **i: " << i << " hnotes[i] " << hnotes[i] << endl; 
			Midi2Note(hnotes[i]);
		        HarOFF[channel][note].notas[i] = hnotes[i];
		        suenaev(channel, hnotes[i]+transpose, velo-2);
		       if (nolimit > 12) break;
        	}
		cout << endl;
		}
};
     
