#ifndef __GM_WORLD_TEXT_VIEW_H__
#define __GM_WORLD_TEXT_VIEW_H__

#include <gtk/gtk.h>
#include "gm-color-table.h"

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_WORLD_TEXT_VIEW							(gm_world_text_view_get_type())
#define GM_WORLD_TEXT_VIEW(obj)							(G_TYPE_CHECK_INSTANCE_CAST((obj), GM_TYPE_WORLD_TEXT_VIEW, GmWorldTextView))
#define GM_WORLD_TEXT_VIEW_CONST(obj)				(G_TYPE_CHECK_INSTANCE_CAST((obj), GM_TYPE_WORLD_TEXT_VIEW, GmWorldTextView const))
#define GM_WORLD_TEXT_VIEW_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST((klass), GM_TYPE_WORLD_TEXT_VIEW, GmWorldTextViewClass))
#define GM_IS_WORLD_TEXT_VIEW(obj)						(G_TYPE_CHECK_INSTANCE_TYPE((obj), GM_TYPE_WORLD_TEXT_VIEW))
#define GM_IS_WORLD_TEXT_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), GM_TYPE_WORLD_TEXT_VIEW))
#define GM_WORLD_TEXT_VIEW_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), GM_TYPE_WORLD_TEXT_VIEW, GmWorldTextViewClass))

/* Private structure type */
typedef struct _GmWorldTextViewPrivate GmWorldTextViewPrivate;

/*
 * Main object structure
 */
typedef struct _GmWorldTextView GmWorldTextView;
 
struct _GmWorldTextView {
	GtkTextView textview;
	
	/*< private > */
	GmWorldTextViewPrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmWorldTextViewClass 	GmWorldTextViewClass;

struct _GmWorldTextViewClass {
	GtkTextViewClass parent_class;

	/* Signals */
	void (* url_activate) (GmWorldTextView *view, const gchar *url);
	void (* character_size_changed) (GmWorldTextView *view, guint width, 
			guint height);
};

GType gm_world_text_view_get_type(void) G_GNUC_CONST;
GtkWidget *gm_world_text_view_new(void);
GtkWidget *gm_world_text_view_new_with_color_table(GmColorTable *color_table);
gchar *gm_world_text_view_insert(GmWorldTextView *view, const gchar *text);
GmColorTable *gm_world_text_view_color_table(GmWorldTextView *view);
void gm_world_text_view_set_color_table(GmWorldTextView *view, 
		GmColorTable *color_table);
void gm_world_text_view_get_metrics(GmWorldTextView *view, guint *width,
		guint *height);

G_END_DECLS
#endif /* __GM_WORLD_TEXT_VIEW_H__ */

