/* 
 * Copyright (C) 2004, 2005 Jean-Yves Lefort <jylefort@brutele.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include "gt-stock.h"
#include "gt-util.h"

static const GtkStockItem items[] = {
  { GT_STOCK_LEAVE_FULLSCREEN, N_("Leave Fullscreen"), 0, 0, NULL },
  { GT_STOCK_TRANSLATE, N_("_Translate") }
};

void
gt_stock_init (void)
{
  const struct
  {
    const char	*stock_id;
    const char	*icon_name;
    const char	*source_stock_id;
  } icons[] = {
    { GT_STOCK_INSERT_FROM_FILE, "stock_insert-file" },
    { GT_STOCK_LEAVE_FULLSCREEN, NULL, GTK_STOCK_QUIT },
    { GT_STOCK_SWAP_PANES },
    { GT_STOCK_TRANSLATE },
    { GT_STOCK_TRANSLATE_WEB_PAGE }
  };
  GtkIconFactory *factory;
  int i;

  factory = gtk_icon_factory_new();

  for (i = 0; i < G_N_ELEMENTS(icons); i++)
    {
      GtkIconSet *icon_set;

      if (icons[i].source_stock_id)
	{
	  icon_set = gtk_icon_factory_lookup_default(icons[i].source_stock_id);
	  gtk_icon_set_ref(icon_set);
	}
      else
	{
	  GtkIconSource *icon_source;

	  icon_set = gtk_icon_set_new();

	  icon_source = gtk_icon_source_new();
	  gtk_icon_source_set_icon_name(icon_source, icons[i].icon_name ? icons[i].icon_name : icons[i].stock_id);
	  gtk_icon_set_add_source(icon_set, icon_source);
	  gtk_icon_source_free(icon_source);
	}
      
      gtk_icon_factory_add(factory, icons[i].stock_id, icon_set);
      gtk_icon_set_unref(icon_set);
    }
  
  gtk_icon_factory_add_default(factory);
  g_object_unref(factory);

  gtk_stock_add_static(items, G_N_ELEMENTS(items));
}
