// Code generated by smithy-go-codegen DO NOT EDIT.

package sns

import (
	"bytes"
	"context"
	"encoding/xml"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	awsxml "github.com/aws/aws-sdk-go-v2/aws/protocol/xml"
	"github.com/aws/aws-sdk-go-v2/service/sns/types"
	smithy "github.com/aws/smithy-go"
	smithyxml "github.com/aws/smithy-go/encoding/xml"
	smithyio "github.com/aws/smithy-go/io"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
	"io/ioutil"
	"strconv"
	"strings"
)

type awsAwsquery_deserializeOpAddPermission struct {
}

func (*awsAwsquery_deserializeOpAddPermission) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpAddPermission) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorAddPermission(response, &metadata)
	}
	output := &AddPermissionOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorAddPermission(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCheckIfPhoneNumberIsOptedOut struct {
}

func (*awsAwsquery_deserializeOpCheckIfPhoneNumberIsOptedOut) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCheckIfPhoneNumberIsOptedOut) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCheckIfPhoneNumberIsOptedOut(response, &metadata)
	}
	output := &CheckIfPhoneNumberIsOptedOutOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CheckIfPhoneNumberIsOptedOutResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCheckIfPhoneNumberIsOptedOutOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCheckIfPhoneNumberIsOptedOut(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("Throttled", errorCode):
		return awsAwsquery_deserializeErrorThrottledException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpConfirmSubscription struct {
}

func (*awsAwsquery_deserializeOpConfirmSubscription) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpConfirmSubscription) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorConfirmSubscription(response, &metadata)
	}
	output := &ConfirmSubscriptionOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ConfirmSubscriptionResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentConfirmSubscriptionOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorConfirmSubscription(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("FilterPolicyLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorFilterPolicyLimitExceededException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("ReplayLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorReplayLimitExceededException(response, errorBody)

	case strings.EqualFold("SubscriptionLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorSubscriptionLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreatePlatformApplication struct {
}

func (*awsAwsquery_deserializeOpCreatePlatformApplication) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreatePlatformApplication) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreatePlatformApplication(response, &metadata)
	}
	output := &CreatePlatformApplicationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreatePlatformApplicationResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreatePlatformApplicationOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreatePlatformApplication(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreatePlatformEndpoint struct {
}

func (*awsAwsquery_deserializeOpCreatePlatformEndpoint) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreatePlatformEndpoint) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreatePlatformEndpoint(response, &metadata)
	}
	output := &CreatePlatformEndpointOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreatePlatformEndpointResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreatePlatformEndpointOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreatePlatformEndpoint(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateSMSSandboxPhoneNumber struct {
}

func (*awsAwsquery_deserializeOpCreateSMSSandboxPhoneNumber) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateSMSSandboxPhoneNumber) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateSMSSandboxPhoneNumber(response, &metadata)
	}
	output := &CreateSMSSandboxPhoneNumberOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateSMSSandboxPhoneNumberResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateSMSSandboxPhoneNumberOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateSMSSandboxPhoneNumber(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("OptedOut", errorCode):
		return awsAwsquery_deserializeErrorOptedOutException(response, errorBody)

	case strings.EqualFold("Throttled", errorCode):
		return awsAwsquery_deserializeErrorThrottledException(response, errorBody)

	case strings.EqualFold("UserError", errorCode):
		return awsAwsquery_deserializeErrorUserErrorException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateTopic struct {
}

func (*awsAwsquery_deserializeOpCreateTopic) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateTopic) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateTopic(response, &metadata)
	}
	output := &CreateTopicOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateTopicResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateTopicOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateTopic(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("ConcurrentAccess", errorCode):
		return awsAwsquery_deserializeErrorConcurrentAccessException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("InvalidSecurity", errorCode):
		return awsAwsquery_deserializeErrorInvalidSecurityException(response, errorBody)

	case strings.EqualFold("StaleTag", errorCode):
		return awsAwsquery_deserializeErrorStaleTagException(response, errorBody)

	case strings.EqualFold("TagLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorTagLimitExceededException(response, errorBody)

	case strings.EqualFold("TagPolicy", errorCode):
		return awsAwsquery_deserializeErrorTagPolicyException(response, errorBody)

	case strings.EqualFold("TopicLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorTopicLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteEndpoint struct {
}

func (*awsAwsquery_deserializeOpDeleteEndpoint) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteEndpoint) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteEndpoint(response, &metadata)
	}
	output := &DeleteEndpointOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteEndpoint(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeletePlatformApplication struct {
}

func (*awsAwsquery_deserializeOpDeletePlatformApplication) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeletePlatformApplication) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeletePlatformApplication(response, &metadata)
	}
	output := &DeletePlatformApplicationOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeletePlatformApplication(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteSMSSandboxPhoneNumber struct {
}

func (*awsAwsquery_deserializeOpDeleteSMSSandboxPhoneNumber) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteSMSSandboxPhoneNumber) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteSMSSandboxPhoneNumber(response, &metadata)
	}
	output := &DeleteSMSSandboxPhoneNumberOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DeleteSMSSandboxPhoneNumberResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDeleteSMSSandboxPhoneNumberOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteSMSSandboxPhoneNumber(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("ResourceNotFound", errorCode):
		return awsAwsquery_deserializeErrorResourceNotFoundException(response, errorBody)

	case strings.EqualFold("Throttled", errorCode):
		return awsAwsquery_deserializeErrorThrottledException(response, errorBody)

	case strings.EqualFold("UserError", errorCode):
		return awsAwsquery_deserializeErrorUserErrorException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteTopic struct {
}

func (*awsAwsquery_deserializeOpDeleteTopic) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteTopic) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteTopic(response, &metadata)
	}
	output := &DeleteTopicOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteTopic(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("ConcurrentAccess", errorCode):
		return awsAwsquery_deserializeErrorConcurrentAccessException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("InvalidState", errorCode):
		return awsAwsquery_deserializeErrorInvalidStateException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("StaleTag", errorCode):
		return awsAwsquery_deserializeErrorStaleTagException(response, errorBody)

	case strings.EqualFold("TagPolicy", errorCode):
		return awsAwsquery_deserializeErrorTagPolicyException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpGetDataProtectionPolicy struct {
}

func (*awsAwsquery_deserializeOpGetDataProtectionPolicy) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpGetDataProtectionPolicy) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorGetDataProtectionPolicy(response, &metadata)
	}
	output := &GetDataProtectionPolicyOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("GetDataProtectionPolicyResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentGetDataProtectionPolicyOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorGetDataProtectionPolicy(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("InvalidSecurity", errorCode):
		return awsAwsquery_deserializeErrorInvalidSecurityException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpGetEndpointAttributes struct {
}

func (*awsAwsquery_deserializeOpGetEndpointAttributes) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpGetEndpointAttributes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorGetEndpointAttributes(response, &metadata)
	}
	output := &GetEndpointAttributesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("GetEndpointAttributesResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentGetEndpointAttributesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorGetEndpointAttributes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpGetPlatformApplicationAttributes struct {
}

func (*awsAwsquery_deserializeOpGetPlatformApplicationAttributes) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpGetPlatformApplicationAttributes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorGetPlatformApplicationAttributes(response, &metadata)
	}
	output := &GetPlatformApplicationAttributesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("GetPlatformApplicationAttributesResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentGetPlatformApplicationAttributesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorGetPlatformApplicationAttributes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpGetSMSAttributes struct {
}

func (*awsAwsquery_deserializeOpGetSMSAttributes) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpGetSMSAttributes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorGetSMSAttributes(response, &metadata)
	}
	output := &GetSMSAttributesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("GetSMSAttributesResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentGetSMSAttributesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorGetSMSAttributes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("Throttled", errorCode):
		return awsAwsquery_deserializeErrorThrottledException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpGetSMSSandboxAccountStatus struct {
}

func (*awsAwsquery_deserializeOpGetSMSSandboxAccountStatus) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpGetSMSSandboxAccountStatus) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorGetSMSSandboxAccountStatus(response, &metadata)
	}
	output := &GetSMSSandboxAccountStatusOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("GetSMSSandboxAccountStatusResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentGetSMSSandboxAccountStatusOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorGetSMSSandboxAccountStatus(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("Throttled", errorCode):
		return awsAwsquery_deserializeErrorThrottledException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpGetSubscriptionAttributes struct {
}

func (*awsAwsquery_deserializeOpGetSubscriptionAttributes) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpGetSubscriptionAttributes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorGetSubscriptionAttributes(response, &metadata)
	}
	output := &GetSubscriptionAttributesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("GetSubscriptionAttributesResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentGetSubscriptionAttributesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorGetSubscriptionAttributes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpGetTopicAttributes struct {
}

func (*awsAwsquery_deserializeOpGetTopicAttributes) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpGetTopicAttributes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorGetTopicAttributes(response, &metadata)
	}
	output := &GetTopicAttributesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("GetTopicAttributesResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentGetTopicAttributesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorGetTopicAttributes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("InvalidSecurity", errorCode):
		return awsAwsquery_deserializeErrorInvalidSecurityException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpListEndpointsByPlatformApplication struct {
}

func (*awsAwsquery_deserializeOpListEndpointsByPlatformApplication) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpListEndpointsByPlatformApplication) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorListEndpointsByPlatformApplication(response, &metadata)
	}
	output := &ListEndpointsByPlatformApplicationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ListEndpointsByPlatformApplicationResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentListEndpointsByPlatformApplicationOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorListEndpointsByPlatformApplication(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpListOriginationNumbers struct {
}

func (*awsAwsquery_deserializeOpListOriginationNumbers) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpListOriginationNumbers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorListOriginationNumbers(response, &metadata)
	}
	output := &ListOriginationNumbersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ListOriginationNumbersResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentListOriginationNumbersOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorListOriginationNumbers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("Throttled", errorCode):
		return awsAwsquery_deserializeErrorThrottledException(response, errorBody)

	case strings.EqualFold("ValidationException", errorCode):
		return awsAwsquery_deserializeErrorValidationException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpListPhoneNumbersOptedOut struct {
}

func (*awsAwsquery_deserializeOpListPhoneNumbersOptedOut) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpListPhoneNumbersOptedOut) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorListPhoneNumbersOptedOut(response, &metadata)
	}
	output := &ListPhoneNumbersOptedOutOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ListPhoneNumbersOptedOutResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentListPhoneNumbersOptedOutOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorListPhoneNumbersOptedOut(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("Throttled", errorCode):
		return awsAwsquery_deserializeErrorThrottledException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpListPlatformApplications struct {
}

func (*awsAwsquery_deserializeOpListPlatformApplications) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpListPlatformApplications) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorListPlatformApplications(response, &metadata)
	}
	output := &ListPlatformApplicationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ListPlatformApplicationsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentListPlatformApplicationsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorListPlatformApplications(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpListSMSSandboxPhoneNumbers struct {
}

func (*awsAwsquery_deserializeOpListSMSSandboxPhoneNumbers) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpListSMSSandboxPhoneNumbers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorListSMSSandboxPhoneNumbers(response, &metadata)
	}
	output := &ListSMSSandboxPhoneNumbersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ListSMSSandboxPhoneNumbersResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentListSMSSandboxPhoneNumbersOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorListSMSSandboxPhoneNumbers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("ResourceNotFound", errorCode):
		return awsAwsquery_deserializeErrorResourceNotFoundException(response, errorBody)

	case strings.EqualFold("Throttled", errorCode):
		return awsAwsquery_deserializeErrorThrottledException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpListSubscriptions struct {
}

func (*awsAwsquery_deserializeOpListSubscriptions) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpListSubscriptions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorListSubscriptions(response, &metadata)
	}
	output := &ListSubscriptionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ListSubscriptionsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentListSubscriptionsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorListSubscriptions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpListSubscriptionsByTopic struct {
}

func (*awsAwsquery_deserializeOpListSubscriptionsByTopic) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpListSubscriptionsByTopic) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorListSubscriptionsByTopic(response, &metadata)
	}
	output := &ListSubscriptionsByTopicOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ListSubscriptionsByTopicResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentListSubscriptionsByTopicOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorListSubscriptionsByTopic(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpListTagsForResource struct {
}

func (*awsAwsquery_deserializeOpListTagsForResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpListTagsForResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorListTagsForResource(response, &metadata)
	}
	output := &ListTagsForResourceOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ListTagsForResourceResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentListTagsForResourceOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorListTagsForResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("ConcurrentAccess", errorCode):
		return awsAwsquery_deserializeErrorConcurrentAccessException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("ResourceNotFound", errorCode):
		return awsAwsquery_deserializeErrorResourceNotFoundException(response, errorBody)

	case strings.EqualFold("TagPolicy", errorCode):
		return awsAwsquery_deserializeErrorTagPolicyException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpListTopics struct {
}

func (*awsAwsquery_deserializeOpListTopics) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpListTopics) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorListTopics(response, &metadata)
	}
	output := &ListTopicsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ListTopicsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentListTopicsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorListTopics(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpOptInPhoneNumber struct {
}

func (*awsAwsquery_deserializeOpOptInPhoneNumber) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpOptInPhoneNumber) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorOptInPhoneNumber(response, &metadata)
	}
	output := &OptInPhoneNumberOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("OptInPhoneNumberResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentOptInPhoneNumberOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorOptInPhoneNumber(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("Throttled", errorCode):
		return awsAwsquery_deserializeErrorThrottledException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpPublish struct {
}

func (*awsAwsquery_deserializeOpPublish) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpPublish) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorPublish(response, &metadata)
	}
	output := &PublishOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("PublishResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentPublishOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorPublish(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("EndpointDisabled", errorCode):
		return awsAwsquery_deserializeErrorEndpointDisabledException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("InvalidSecurity", errorCode):
		return awsAwsquery_deserializeErrorInvalidSecurityException(response, errorBody)

	case strings.EqualFold("KMSAccessDenied", errorCode):
		return awsAwsquery_deserializeErrorKMSAccessDeniedException(response, errorBody)

	case strings.EqualFold("KMSDisabled", errorCode):
		return awsAwsquery_deserializeErrorKMSDisabledException(response, errorBody)

	case strings.EqualFold("KMSInvalidState", errorCode):
		return awsAwsquery_deserializeErrorKMSInvalidStateException(response, errorBody)

	case strings.EqualFold("KMSNotFound", errorCode):
		return awsAwsquery_deserializeErrorKMSNotFoundException(response, errorBody)

	case strings.EqualFold("KMSOptInRequired", errorCode):
		return awsAwsquery_deserializeErrorKMSOptInRequired(response, errorBody)

	case strings.EqualFold("KMSThrottling", errorCode):
		return awsAwsquery_deserializeErrorKMSThrottlingException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("ParameterValueInvalid", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("PlatformApplicationDisabled", errorCode):
		return awsAwsquery_deserializeErrorPlatformApplicationDisabledException(response, errorBody)

	case strings.EqualFold("ValidationException", errorCode):
		return awsAwsquery_deserializeErrorValidationException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpPublishBatch struct {
}

func (*awsAwsquery_deserializeOpPublishBatch) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpPublishBatch) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorPublishBatch(response, &metadata)
	}
	output := &PublishBatchOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("PublishBatchResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentPublishBatchOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorPublishBatch(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("BatchEntryIdsNotDistinct", errorCode):
		return awsAwsquery_deserializeErrorBatchEntryIdsNotDistinctException(response, errorBody)

	case strings.EqualFold("BatchRequestTooLong", errorCode):
		return awsAwsquery_deserializeErrorBatchRequestTooLongException(response, errorBody)

	case strings.EqualFold("EmptyBatchRequest", errorCode):
		return awsAwsquery_deserializeErrorEmptyBatchRequestException(response, errorBody)

	case strings.EqualFold("EndpointDisabled", errorCode):
		return awsAwsquery_deserializeErrorEndpointDisabledException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidBatchEntryId", errorCode):
		return awsAwsquery_deserializeErrorInvalidBatchEntryIdException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("InvalidSecurity", errorCode):
		return awsAwsquery_deserializeErrorInvalidSecurityException(response, errorBody)

	case strings.EqualFold("KMSAccessDenied", errorCode):
		return awsAwsquery_deserializeErrorKMSAccessDeniedException(response, errorBody)

	case strings.EqualFold("KMSDisabled", errorCode):
		return awsAwsquery_deserializeErrorKMSDisabledException(response, errorBody)

	case strings.EqualFold("KMSInvalidState", errorCode):
		return awsAwsquery_deserializeErrorKMSInvalidStateException(response, errorBody)

	case strings.EqualFold("KMSNotFound", errorCode):
		return awsAwsquery_deserializeErrorKMSNotFoundException(response, errorBody)

	case strings.EqualFold("KMSOptInRequired", errorCode):
		return awsAwsquery_deserializeErrorKMSOptInRequired(response, errorBody)

	case strings.EqualFold("KMSThrottling", errorCode):
		return awsAwsquery_deserializeErrorKMSThrottlingException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("ParameterValueInvalid", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("PlatformApplicationDisabled", errorCode):
		return awsAwsquery_deserializeErrorPlatformApplicationDisabledException(response, errorBody)

	case strings.EqualFold("TooManyEntriesInBatchRequest", errorCode):
		return awsAwsquery_deserializeErrorTooManyEntriesInBatchRequestException(response, errorBody)

	case strings.EqualFold("ValidationException", errorCode):
		return awsAwsquery_deserializeErrorValidationException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpPutDataProtectionPolicy struct {
}

func (*awsAwsquery_deserializeOpPutDataProtectionPolicy) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpPutDataProtectionPolicy) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorPutDataProtectionPolicy(response, &metadata)
	}
	output := &PutDataProtectionPolicyOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorPutDataProtectionPolicy(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("InvalidSecurity", errorCode):
		return awsAwsquery_deserializeErrorInvalidSecurityException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpRemovePermission struct {
}

func (*awsAwsquery_deserializeOpRemovePermission) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpRemovePermission) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorRemovePermission(response, &metadata)
	}
	output := &RemovePermissionOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorRemovePermission(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpSetEndpointAttributes struct {
}

func (*awsAwsquery_deserializeOpSetEndpointAttributes) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpSetEndpointAttributes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorSetEndpointAttributes(response, &metadata)
	}
	output := &SetEndpointAttributesOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorSetEndpointAttributes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpSetPlatformApplicationAttributes struct {
}

func (*awsAwsquery_deserializeOpSetPlatformApplicationAttributes) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpSetPlatformApplicationAttributes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorSetPlatformApplicationAttributes(response, &metadata)
	}
	output := &SetPlatformApplicationAttributesOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorSetPlatformApplicationAttributes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpSetSMSAttributes struct {
}

func (*awsAwsquery_deserializeOpSetSMSAttributes) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpSetSMSAttributes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorSetSMSAttributes(response, &metadata)
	}
	output := &SetSMSAttributesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("SetSMSAttributesResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentSetSMSAttributesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorSetSMSAttributes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("Throttled", errorCode):
		return awsAwsquery_deserializeErrorThrottledException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpSetSubscriptionAttributes struct {
}

func (*awsAwsquery_deserializeOpSetSubscriptionAttributes) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpSetSubscriptionAttributes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorSetSubscriptionAttributes(response, &metadata)
	}
	output := &SetSubscriptionAttributesOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorSetSubscriptionAttributes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("FilterPolicyLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorFilterPolicyLimitExceededException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("ReplayLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorReplayLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpSetTopicAttributes struct {
}

func (*awsAwsquery_deserializeOpSetTopicAttributes) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpSetTopicAttributes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorSetTopicAttributes(response, &metadata)
	}
	output := &SetTopicAttributesOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorSetTopicAttributes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("InvalidSecurity", errorCode):
		return awsAwsquery_deserializeErrorInvalidSecurityException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpSubscribe struct {
}

func (*awsAwsquery_deserializeOpSubscribe) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpSubscribe) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorSubscribe(response, &metadata)
	}
	output := &SubscribeOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("SubscribeResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentSubscribeOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorSubscribe(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("FilterPolicyLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorFilterPolicyLimitExceededException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("InvalidSecurity", errorCode):
		return awsAwsquery_deserializeErrorInvalidSecurityException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("ReplayLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorReplayLimitExceededException(response, errorBody)

	case strings.EqualFold("SubscriptionLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorSubscriptionLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpTagResource struct {
}

func (*awsAwsquery_deserializeOpTagResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpTagResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorTagResource(response, &metadata)
	}
	output := &TagResourceOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("TagResourceResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentTagResourceOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorTagResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("ConcurrentAccess", errorCode):
		return awsAwsquery_deserializeErrorConcurrentAccessException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("ResourceNotFound", errorCode):
		return awsAwsquery_deserializeErrorResourceNotFoundException(response, errorBody)

	case strings.EqualFold("StaleTag", errorCode):
		return awsAwsquery_deserializeErrorStaleTagException(response, errorBody)

	case strings.EqualFold("TagLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorTagLimitExceededException(response, errorBody)

	case strings.EqualFold("TagPolicy", errorCode):
		return awsAwsquery_deserializeErrorTagPolicyException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpUnsubscribe struct {
}

func (*awsAwsquery_deserializeOpUnsubscribe) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpUnsubscribe) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorUnsubscribe(response, &metadata)
	}
	output := &UnsubscribeOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorUnsubscribe(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("InvalidSecurity", errorCode):
		return awsAwsquery_deserializeErrorInvalidSecurityException(response, errorBody)

	case strings.EqualFold("NotFound", errorCode):
		return awsAwsquery_deserializeErrorNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpUntagResource struct {
}

func (*awsAwsquery_deserializeOpUntagResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpUntagResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorUntagResource(response, &metadata)
	}
	output := &UntagResourceOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("UntagResourceResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentUntagResourceOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorUntagResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("ConcurrentAccess", errorCode):
		return awsAwsquery_deserializeErrorConcurrentAccessException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("ResourceNotFound", errorCode):
		return awsAwsquery_deserializeErrorResourceNotFoundException(response, errorBody)

	case strings.EqualFold("StaleTag", errorCode):
		return awsAwsquery_deserializeErrorStaleTagException(response, errorBody)

	case strings.EqualFold("TagLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorTagLimitExceededException(response, errorBody)

	case strings.EqualFold("TagPolicy", errorCode):
		return awsAwsquery_deserializeErrorTagPolicyException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpVerifySMSSandboxPhoneNumber struct {
}

func (*awsAwsquery_deserializeOpVerifySMSSandboxPhoneNumber) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpVerifySMSSandboxPhoneNumber) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorVerifySMSSandboxPhoneNumber(response, &metadata)
	}
	output := &VerifySMSSandboxPhoneNumberOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("VerifySMSSandboxPhoneNumberResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentVerifySMSSandboxPhoneNumberOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorVerifySMSSandboxPhoneNumber(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationError", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationErrorException(response, errorBody)

	case strings.EqualFold("InternalError", errorCode):
		return awsAwsquery_deserializeErrorInternalErrorException(response, errorBody)

	case strings.EqualFold("InvalidParameter", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterException(response, errorBody)

	case strings.EqualFold("ResourceNotFound", errorCode):
		return awsAwsquery_deserializeErrorResourceNotFoundException(response, errorBody)

	case strings.EqualFold("Throttled", errorCode):
		return awsAwsquery_deserializeErrorThrottledException(response, errorBody)

	case strings.EqualFold("VerificationException", errorCode):
		return awsAwsquery_deserializeErrorVerificationException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsAwsquery_deserializeErrorAuthorizationErrorException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.AuthorizationErrorException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentAuthorizationErrorException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorBatchEntryIdsNotDistinctException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.BatchEntryIdsNotDistinctException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentBatchEntryIdsNotDistinctException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorBatchRequestTooLongException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.BatchRequestTooLongException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentBatchRequestTooLongException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorConcurrentAccessException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ConcurrentAccessException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentConcurrentAccessException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorEmptyBatchRequestException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.EmptyBatchRequestException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentEmptyBatchRequestException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorEndpointDisabledException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.EndpointDisabledException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentEndpointDisabledException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorFilterPolicyLimitExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.FilterPolicyLimitExceededException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentFilterPolicyLimitExceededException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInternalErrorException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InternalErrorException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInternalErrorException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidBatchEntryIdException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidBatchEntryIdException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidBatchEntryIdException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidParameterException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidParameterException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidParameterException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidParameterValueException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidParameterValueException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidParameterValueException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidSecurityException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidSecurityException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidSecurityException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidStateException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidStateException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidStateException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorKMSAccessDeniedException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.KMSAccessDeniedException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentKMSAccessDeniedException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorKMSDisabledException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.KMSDisabledException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentKMSDisabledException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorKMSInvalidStateException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.KMSInvalidStateException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentKMSInvalidStateException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorKMSNotFoundException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.KMSNotFoundException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentKMSNotFoundException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorKMSOptInRequired(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.KMSOptInRequired{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentKMSOptInRequired(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorKMSThrottlingException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.KMSThrottlingException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentKMSThrottlingException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorNotFoundException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.NotFoundException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentNotFoundException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorOptedOutException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.OptedOutException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentOptedOutException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorPlatformApplicationDisabledException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.PlatformApplicationDisabledException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentPlatformApplicationDisabledException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorReplayLimitExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ReplayLimitExceededException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentReplayLimitExceededException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorResourceNotFoundException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ResourceNotFoundException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentResourceNotFoundException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorStaleTagException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.StaleTagException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentStaleTagException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSubscriptionLimitExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SubscriptionLimitExceededException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSubscriptionLimitExceededException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorTagLimitExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.TagLimitExceededException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentTagLimitExceededException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorTagPolicyException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.TagPolicyException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentTagPolicyException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorThrottledException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ThrottledException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentThrottledException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorTooManyEntriesInBatchRequestException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.TooManyEntriesInBatchRequestException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentTooManyEntriesInBatchRequestException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorTopicLimitExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.TopicLimitExceededException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentTopicLimitExceededException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorUserErrorException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.UserErrorException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentUserErrorException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorValidationException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ValidationException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentValidationException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorVerificationException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.VerificationException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentVerificationException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeDocumentAuthorizationErrorException(v **types.AuthorizationErrorException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AuthorizationErrorException
	if *v == nil {
		sv = &types.AuthorizationErrorException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentBatchEntryIdsNotDistinctException(v **types.BatchEntryIdsNotDistinctException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.BatchEntryIdsNotDistinctException
	if *v == nil {
		sv = &types.BatchEntryIdsNotDistinctException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentBatchRequestTooLongException(v **types.BatchRequestTooLongException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.BatchRequestTooLongException
	if *v == nil {
		sv = &types.BatchRequestTooLongException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentBatchResultErrorEntry(v **types.BatchResultErrorEntry, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.BatchResultErrorEntry
	if *v == nil {
		sv = &types.BatchResultErrorEntry{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Code", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Code = ptr.String(xtv)
			}

		case strings.EqualFold("Id", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Id = ptr.String(xtv)
			}

		case strings.EqualFold("Message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		case strings.EqualFold("SenderFault", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected boolean to be of type *bool, got %T instead", val)
				}
				sv.SenderFault = xtv
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentBatchResultErrorEntryList(v *[]types.BatchResultErrorEntry, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.BatchResultErrorEntry
	if *v == nil {
		sv = make([]types.BatchResultErrorEntry, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.BatchResultErrorEntry
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentBatchResultErrorEntry(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentBatchResultErrorEntryListUnwrapped(v *[]types.BatchResultErrorEntry, decoder smithyxml.NodeDecoder) error {
	var sv []types.BatchResultErrorEntry
	if *v == nil {
		sv = make([]types.BatchResultErrorEntry, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.BatchResultErrorEntry
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentBatchResultErrorEntry(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentConcurrentAccessException(v **types.ConcurrentAccessException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ConcurrentAccessException
	if *v == nil {
		sv = &types.ConcurrentAccessException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEmptyBatchRequestException(v **types.EmptyBatchRequestException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EmptyBatchRequestException
	if *v == nil {
		sv = &types.EmptyBatchRequestException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEndpoint(v **types.Endpoint, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Endpoint
	if *v == nil {
		sv = &types.Endpoint{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Attributes", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentMapStringToString(&sv.Attributes, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("EndpointArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EndpointArn = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEndpointDisabledException(v **types.EndpointDisabledException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EndpointDisabledException
	if *v == nil {
		sv = &types.EndpointDisabledException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentFilterPolicyLimitExceededException(v **types.FilterPolicyLimitExceededException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.FilterPolicyLimitExceededException
	if *v == nil {
		sv = &types.FilterPolicyLimitExceededException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInternalErrorException(v **types.InternalErrorException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InternalErrorException
	if *v == nil {
		sv = &types.InternalErrorException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidBatchEntryIdException(v **types.InvalidBatchEntryIdException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidBatchEntryIdException
	if *v == nil {
		sv = &types.InvalidBatchEntryIdException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidParameterException(v **types.InvalidParameterException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidParameterException
	if *v == nil {
		sv = &types.InvalidParameterException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidParameterValueException(v **types.InvalidParameterValueException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidParameterValueException
	if *v == nil {
		sv = &types.InvalidParameterValueException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidSecurityException(v **types.InvalidSecurityException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidSecurityException
	if *v == nil {
		sv = &types.InvalidSecurityException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidStateException(v **types.InvalidStateException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidStateException
	if *v == nil {
		sv = &types.InvalidStateException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentKMSAccessDeniedException(v **types.KMSAccessDeniedException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.KMSAccessDeniedException
	if *v == nil {
		sv = &types.KMSAccessDeniedException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentKMSDisabledException(v **types.KMSDisabledException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.KMSDisabledException
	if *v == nil {
		sv = &types.KMSDisabledException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentKMSInvalidStateException(v **types.KMSInvalidStateException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.KMSInvalidStateException
	if *v == nil {
		sv = &types.KMSInvalidStateException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentKMSNotFoundException(v **types.KMSNotFoundException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.KMSNotFoundException
	if *v == nil {
		sv = &types.KMSNotFoundException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentKMSOptInRequired(v **types.KMSOptInRequired, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.KMSOptInRequired
	if *v == nil {
		sv = &types.KMSOptInRequired{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentKMSThrottlingException(v **types.KMSThrottlingException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.KMSThrottlingException
	if *v == nil {
		sv = &types.KMSThrottlingException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentListOfEndpoints(v *[]types.Endpoint, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.Endpoint
	if *v == nil {
		sv = make([]types.Endpoint, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.Endpoint
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentEndpoint(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentListOfEndpointsUnwrapped(v *[]types.Endpoint, decoder smithyxml.NodeDecoder) error {
	var sv []types.Endpoint
	if *v == nil {
		sv = make([]types.Endpoint, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.Endpoint
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentEndpoint(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentListOfPlatformApplications(v *[]types.PlatformApplication, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.PlatformApplication
	if *v == nil {
		sv = make([]types.PlatformApplication, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.PlatformApplication
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentPlatformApplication(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentListOfPlatformApplicationsUnwrapped(v *[]types.PlatformApplication, decoder smithyxml.NodeDecoder) error {
	var sv []types.PlatformApplication
	if *v == nil {
		sv = make([]types.PlatformApplication, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.PlatformApplication
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentPlatformApplication(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentMapStringToString(v *map[string]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv map[string]string
	if *v == nil {
		sv = make(map[string]string, 0)
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("entry", t.Name.Local):
			entryDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentMapStringToStringUnwrapped(&sv, entryDecoder); err != nil {
				return err
			}

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentMapStringToStringUnwrapped(v *map[string]string, decoder smithyxml.NodeDecoder) error {
	var sv map[string]string
	if *v == nil {
		sv = make(map[string]string, 0)
	} else {
		sv = *v
	}

	var ek string
	var ev string
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			sv[ek] = ev
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("key", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				ek = xtv
			}

		case strings.EqualFold("value", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				ev = xtv
			}

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentNotFoundException(v **types.NotFoundException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.NotFoundException
	if *v == nil {
		sv = &types.NotFoundException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNumberCapabilityList(v *[]types.NumberCapability, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.NumberCapability
	if *v == nil {
		sv = make([]types.NumberCapability, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.NumberCapability
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = types.NumberCapability(xtv)
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNumberCapabilityListUnwrapped(v *[]types.NumberCapability, decoder smithyxml.NodeDecoder) error {
	var sv []types.NumberCapability
	if *v == nil {
		sv = make([]types.NumberCapability, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.NumberCapability
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = types.NumberCapability(xtv)
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentOptedOutException(v **types.OptedOutException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.OptedOutException
	if *v == nil {
		sv = &types.OptedOutException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentPhoneNumberInformation(v **types.PhoneNumberInformation, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.PhoneNumberInformation
	if *v == nil {
		sv = &types.PhoneNumberInformation{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CreatedAt", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.CreatedAt = ptr.Time(t)
			}

		case strings.EqualFold("Iso2CountryCode", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Iso2CountryCode = ptr.String(xtv)
			}

		case strings.EqualFold("NumberCapabilities", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentNumberCapabilityList(&sv.NumberCapabilities, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("PhoneNumber", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PhoneNumber = ptr.String(xtv)
			}

		case strings.EqualFold("RouteType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.RouteType = types.RouteType(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentPhoneNumberInformationList(v *[]types.PhoneNumberInformation, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.PhoneNumberInformation
	if *v == nil {
		sv = make([]types.PhoneNumberInformation, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.PhoneNumberInformation
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentPhoneNumberInformation(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentPhoneNumberInformationListUnwrapped(v *[]types.PhoneNumberInformation, decoder smithyxml.NodeDecoder) error {
	var sv []types.PhoneNumberInformation
	if *v == nil {
		sv = make([]types.PhoneNumberInformation, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.PhoneNumberInformation
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentPhoneNumberInformation(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentPhoneNumberList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentPhoneNumberListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentPlatformApplication(v **types.PlatformApplication, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.PlatformApplication
	if *v == nil {
		sv = &types.PlatformApplication{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Attributes", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentMapStringToString(&sv.Attributes, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("PlatformApplicationArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PlatformApplicationArn = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentPlatformApplicationDisabledException(v **types.PlatformApplicationDisabledException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.PlatformApplicationDisabledException
	if *v == nil {
		sv = &types.PlatformApplicationDisabledException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentPublishBatchResultEntry(v **types.PublishBatchResultEntry, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.PublishBatchResultEntry
	if *v == nil {
		sv = &types.PublishBatchResultEntry{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Id", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Id = ptr.String(xtv)
			}

		case strings.EqualFold("MessageId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MessageId = ptr.String(xtv)
			}

		case strings.EqualFold("SequenceNumber", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SequenceNumber = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentPublishBatchResultEntryList(v *[]types.PublishBatchResultEntry, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.PublishBatchResultEntry
	if *v == nil {
		sv = make([]types.PublishBatchResultEntry, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.PublishBatchResultEntry
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentPublishBatchResultEntry(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentPublishBatchResultEntryListUnwrapped(v *[]types.PublishBatchResultEntry, decoder smithyxml.NodeDecoder) error {
	var sv []types.PublishBatchResultEntry
	if *v == nil {
		sv = make([]types.PublishBatchResultEntry, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.PublishBatchResultEntry
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentPublishBatchResultEntry(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentReplayLimitExceededException(v **types.ReplayLimitExceededException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReplayLimitExceededException
	if *v == nil {
		sv = &types.ReplayLimitExceededException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentResourceNotFoundException(v **types.ResourceNotFoundException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ResourceNotFoundException
	if *v == nil {
		sv = &types.ResourceNotFoundException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSMSSandboxPhoneNumber(v **types.SMSSandboxPhoneNumber, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.SMSSandboxPhoneNumber
	if *v == nil {
		sv = &types.SMSSandboxPhoneNumber{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("PhoneNumber", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PhoneNumber = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = types.SMSSandboxPhoneNumberVerificationStatus(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSMSSandboxPhoneNumberList(v *[]types.SMSSandboxPhoneNumber, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.SMSSandboxPhoneNumber
	if *v == nil {
		sv = make([]types.SMSSandboxPhoneNumber, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.SMSSandboxPhoneNumber
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentSMSSandboxPhoneNumber(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSMSSandboxPhoneNumberListUnwrapped(v *[]types.SMSSandboxPhoneNumber, decoder smithyxml.NodeDecoder) error {
	var sv []types.SMSSandboxPhoneNumber
	if *v == nil {
		sv = make([]types.SMSSandboxPhoneNumber, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.SMSSandboxPhoneNumber
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentSMSSandboxPhoneNumber(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentStaleTagException(v **types.StaleTagException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.StaleTagException
	if *v == nil {
		sv = &types.StaleTagException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSubscription(v **types.Subscription, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Subscription
	if *v == nil {
		sv = &types.Subscription{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Endpoint", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Endpoint = ptr.String(xtv)
			}

		case strings.EqualFold("Owner", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Owner = ptr.String(xtv)
			}

		case strings.EqualFold("Protocol", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Protocol = ptr.String(xtv)
			}

		case strings.EqualFold("SubscriptionArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SubscriptionArn = ptr.String(xtv)
			}

		case strings.EqualFold("TopicArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.TopicArn = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSubscriptionAttributesMap(v *map[string]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv map[string]string
	if *v == nil {
		sv = make(map[string]string, 0)
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("entry", t.Name.Local):
			entryDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSubscriptionAttributesMapUnwrapped(&sv, entryDecoder); err != nil {
				return err
			}

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSubscriptionAttributesMapUnwrapped(v *map[string]string, decoder smithyxml.NodeDecoder) error {
	var sv map[string]string
	if *v == nil {
		sv = make(map[string]string, 0)
	} else {
		sv = *v
	}

	var ek string
	var ev string
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			sv[ek] = ev
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("key", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				ek = xtv
			}

		case strings.EqualFold("value", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				ev = xtv
			}

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentSubscriptionLimitExceededException(v **types.SubscriptionLimitExceededException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.SubscriptionLimitExceededException
	if *v == nil {
		sv = &types.SubscriptionLimitExceededException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSubscriptionsList(v *[]types.Subscription, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.Subscription
	if *v == nil {
		sv = make([]types.Subscription, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.Subscription
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentSubscription(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSubscriptionsListUnwrapped(v *[]types.Subscription, decoder smithyxml.NodeDecoder) error {
	var sv []types.Subscription
	if *v == nil {
		sv = make([]types.Subscription, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.Subscription
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentSubscription(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentTag(v **types.Tag, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Tag
	if *v == nil {
		sv = &types.Tag{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Key", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Key = ptr.String(xtv)
			}

		case strings.EqualFold("Value", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Value = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentTagLimitExceededException(v **types.TagLimitExceededException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.TagLimitExceededException
	if *v == nil {
		sv = &types.TagLimitExceededException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentTagList(v *[]types.Tag, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.Tag
	if *v == nil {
		sv = make([]types.Tag, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.Tag
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentTag(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentTagListUnwrapped(v *[]types.Tag, decoder smithyxml.NodeDecoder) error {
	var sv []types.Tag
	if *v == nil {
		sv = make([]types.Tag, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.Tag
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentTag(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentTagPolicyException(v **types.TagPolicyException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.TagPolicyException
	if *v == nil {
		sv = &types.TagPolicyException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentThrottledException(v **types.ThrottledException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ThrottledException
	if *v == nil {
		sv = &types.ThrottledException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentTooManyEntriesInBatchRequestException(v **types.TooManyEntriesInBatchRequestException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.TooManyEntriesInBatchRequestException
	if *v == nil {
		sv = &types.TooManyEntriesInBatchRequestException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentTopic(v **types.Topic, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Topic
	if *v == nil {
		sv = &types.Topic{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("TopicArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.TopicArn = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentTopicAttributesMap(v *map[string]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv map[string]string
	if *v == nil {
		sv = make(map[string]string, 0)
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("entry", t.Name.Local):
			entryDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentTopicAttributesMapUnwrapped(&sv, entryDecoder); err != nil {
				return err
			}

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentTopicAttributesMapUnwrapped(v *map[string]string, decoder smithyxml.NodeDecoder) error {
	var sv map[string]string
	if *v == nil {
		sv = make(map[string]string, 0)
	} else {
		sv = *v
	}

	var ek string
	var ev string
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			sv[ek] = ev
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("key", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				ek = xtv
			}

		case strings.EqualFold("value", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				ev = xtv
			}

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentTopicLimitExceededException(v **types.TopicLimitExceededException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.TopicLimitExceededException
	if *v == nil {
		sv = &types.TopicLimitExceededException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentTopicsList(v *[]types.Topic, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.Topic
	if *v == nil {
		sv = make([]types.Topic, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.Topic
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentTopic(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentTopicsListUnwrapped(v *[]types.Topic, decoder smithyxml.NodeDecoder) error {
	var sv []types.Topic
	if *v == nil {
		sv = make([]types.Topic, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.Topic
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentTopic(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentUserErrorException(v **types.UserErrorException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.UserErrorException
	if *v == nil {
		sv = &types.UserErrorException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentValidationException(v **types.ValidationException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ValidationException
	if *v == nil {
		sv = &types.ValidationException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentVerificationException(v **types.VerificationException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.VerificationException
	if *v == nil {
		sv = &types.VerificationException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCheckIfPhoneNumberIsOptedOutOutput(v **CheckIfPhoneNumberIsOptedOutOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CheckIfPhoneNumberIsOptedOutOutput
	if *v == nil {
		sv = &CheckIfPhoneNumberIsOptedOutOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("isOptedOut", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected boolean to be of type *bool, got %T instead", val)
				}
				sv.IsOptedOut = xtv
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentConfirmSubscriptionOutput(v **ConfirmSubscriptionOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ConfirmSubscriptionOutput
	if *v == nil {
		sv = &ConfirmSubscriptionOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("SubscriptionArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SubscriptionArn = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCreatePlatformApplicationOutput(v **CreatePlatformApplicationOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CreatePlatformApplicationOutput
	if *v == nil {
		sv = &CreatePlatformApplicationOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("PlatformApplicationArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PlatformApplicationArn = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCreatePlatformEndpointOutput(v **CreatePlatformEndpointOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CreatePlatformEndpointOutput
	if *v == nil {
		sv = &CreatePlatformEndpointOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("EndpointArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EndpointArn = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCreateSMSSandboxPhoneNumberOutput(v **CreateSMSSandboxPhoneNumberOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CreateSMSSandboxPhoneNumberOutput
	if *v == nil {
		sv = &CreateSMSSandboxPhoneNumberOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCreateTopicOutput(v **CreateTopicOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CreateTopicOutput
	if *v == nil {
		sv = &CreateTopicOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("TopicArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.TopicArn = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDeleteSMSSandboxPhoneNumberOutput(v **DeleteSMSSandboxPhoneNumberOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DeleteSMSSandboxPhoneNumberOutput
	if *v == nil {
		sv = &DeleteSMSSandboxPhoneNumberOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentGetDataProtectionPolicyOutput(v **GetDataProtectionPolicyOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *GetDataProtectionPolicyOutput
	if *v == nil {
		sv = &GetDataProtectionPolicyOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("DataProtectionPolicy", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DataProtectionPolicy = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentGetEndpointAttributesOutput(v **GetEndpointAttributesOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *GetEndpointAttributesOutput
	if *v == nil {
		sv = &GetEndpointAttributesOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Attributes", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentMapStringToString(&sv.Attributes, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentGetPlatformApplicationAttributesOutput(v **GetPlatformApplicationAttributesOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *GetPlatformApplicationAttributesOutput
	if *v == nil {
		sv = &GetPlatformApplicationAttributesOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Attributes", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentMapStringToString(&sv.Attributes, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentGetSMSAttributesOutput(v **GetSMSAttributesOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *GetSMSAttributesOutput
	if *v == nil {
		sv = &GetSMSAttributesOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("attributes", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentMapStringToString(&sv.Attributes, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentGetSMSSandboxAccountStatusOutput(v **GetSMSSandboxAccountStatusOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *GetSMSSandboxAccountStatusOutput
	if *v == nil {
		sv = &GetSMSSandboxAccountStatusOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("IsInSandbox", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected boolean to be of type *bool, got %T instead", val)
				}
				sv.IsInSandbox = xtv
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentGetSubscriptionAttributesOutput(v **GetSubscriptionAttributesOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *GetSubscriptionAttributesOutput
	if *v == nil {
		sv = &GetSubscriptionAttributesOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Attributes", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSubscriptionAttributesMap(&sv.Attributes, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentGetTopicAttributesOutput(v **GetTopicAttributesOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *GetTopicAttributesOutput
	if *v == nil {
		sv = &GetTopicAttributesOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Attributes", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentTopicAttributesMap(&sv.Attributes, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentListEndpointsByPlatformApplicationOutput(v **ListEndpointsByPlatformApplicationOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ListEndpointsByPlatformApplicationOutput
	if *v == nil {
		sv = &ListEndpointsByPlatformApplicationOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Endpoints", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentListOfEndpoints(&sv.Endpoints, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("NextToken", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NextToken = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentListOriginationNumbersOutput(v **ListOriginationNumbersOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ListOriginationNumbersOutput
	if *v == nil {
		sv = &ListOriginationNumbersOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("NextToken", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NextToken = ptr.String(xtv)
			}

		case strings.EqualFold("PhoneNumbers", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentPhoneNumberInformationList(&sv.PhoneNumbers, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentListPhoneNumbersOptedOutOutput(v **ListPhoneNumbersOptedOutOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ListPhoneNumbersOptedOutOutput
	if *v == nil {
		sv = &ListPhoneNumbersOptedOutOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("nextToken", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NextToken = ptr.String(xtv)
			}

		case strings.EqualFold("phoneNumbers", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentPhoneNumberList(&sv.PhoneNumbers, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentListPlatformApplicationsOutput(v **ListPlatformApplicationsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ListPlatformApplicationsOutput
	if *v == nil {
		sv = &ListPlatformApplicationsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("NextToken", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NextToken = ptr.String(xtv)
			}

		case strings.EqualFold("PlatformApplications", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentListOfPlatformApplications(&sv.PlatformApplications, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentListSMSSandboxPhoneNumbersOutput(v **ListSMSSandboxPhoneNumbersOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ListSMSSandboxPhoneNumbersOutput
	if *v == nil {
		sv = &ListSMSSandboxPhoneNumbersOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("NextToken", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NextToken = ptr.String(xtv)
			}

		case strings.EqualFold("PhoneNumbers", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSMSSandboxPhoneNumberList(&sv.PhoneNumbers, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentListSubscriptionsByTopicOutput(v **ListSubscriptionsByTopicOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ListSubscriptionsByTopicOutput
	if *v == nil {
		sv = &ListSubscriptionsByTopicOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("NextToken", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NextToken = ptr.String(xtv)
			}

		case strings.EqualFold("Subscriptions", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSubscriptionsList(&sv.Subscriptions, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentListSubscriptionsOutput(v **ListSubscriptionsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ListSubscriptionsOutput
	if *v == nil {
		sv = &ListSubscriptionsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("NextToken", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NextToken = ptr.String(xtv)
			}

		case strings.EqualFold("Subscriptions", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSubscriptionsList(&sv.Subscriptions, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentListTagsForResourceOutput(v **ListTagsForResourceOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ListTagsForResourceOutput
	if *v == nil {
		sv = &ListTagsForResourceOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Tags", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentTagList(&sv.Tags, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentListTopicsOutput(v **ListTopicsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ListTopicsOutput
	if *v == nil {
		sv = &ListTopicsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("NextToken", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NextToken = ptr.String(xtv)
			}

		case strings.EqualFold("Topics", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentTopicsList(&sv.Topics, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentOptInPhoneNumberOutput(v **OptInPhoneNumberOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *OptInPhoneNumberOutput
	if *v == nil {
		sv = &OptInPhoneNumberOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentPublishBatchOutput(v **PublishBatchOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *PublishBatchOutput
	if *v == nil {
		sv = &PublishBatchOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Failed", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentBatchResultErrorEntryList(&sv.Failed, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Successful", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentPublishBatchResultEntryList(&sv.Successful, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentPublishOutput(v **PublishOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *PublishOutput
	if *v == nil {
		sv = &PublishOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("MessageId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MessageId = ptr.String(xtv)
			}

		case strings.EqualFold("SequenceNumber", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SequenceNumber = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentSetSMSAttributesOutput(v **SetSMSAttributesOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *SetSMSAttributesOutput
	if *v == nil {
		sv = &SetSMSAttributesOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentSubscribeOutput(v **SubscribeOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *SubscribeOutput
	if *v == nil {
		sv = &SubscribeOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("SubscriptionArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SubscriptionArn = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentTagResourceOutput(v **TagResourceOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *TagResourceOutput
	if *v == nil {
		sv = &TagResourceOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentUntagResourceOutput(v **UntagResourceOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *UntagResourceOutput
	if *v == nil {
		sv = &UntagResourceOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentVerifySMSSandboxPhoneNumberOutput(v **VerifySMSSandboxPhoneNumberOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *VerifySMSSandboxPhoneNumberOutput
	if *v == nil {
		sv = &VerifySMSSandboxPhoneNumberOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}
