# gozerbot/plugs/tell.py
#
#

""" send the output of a command to <nick>. """

# gozerbot imports
from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.plugins import plugins
from gozerbot.plughelp import plughelp
from gozerbot.tests import tests

import copy

plughelp.add('tell', 'the tell command sends the output of a command to another user')

def handle_tell(bot, ievent):

    """ send output of command to another user. """

    try:
        nick, cmnd = ievent.rest.split(' ', 1)
    except ValueError:
        ievent.missing('<nick> <command>')
        return

    event = copy.deepcopy(ievent)
    event.txt = cmnd
    event.onlyqueues = True
    result = plugins.cmnd(bot, event)

    if not result:
        ievent.reply("no result for %s" % cmnd)
        return

    ievent.reply("%s sends your this: " % ievent.nick, result, nick=nick, \
dot=True)
    ievent.reply("%s item(s) send" % len(result))

cmnds.add('tell', handle_tell, 'USER', threaded=True)
examples.add('tell', 'tell <nick> <command> .. send output of command to another user', 'tell dunker version')
tests.add('tell dunker version', 'GOZERBOT')
