/*
 *  Copyright (C) 2021 - This file is part of libecc project
 *
 *  Authors:
 *      Ryad BENADJILA <ryadbenadjila@gmail.com>
 *      Arnaud EBALARD <arnaud.ebalard@ssi.gouv.fr>
 *
 *  This software is licensed under a dual BSD and GPL v2 license.
 *  See LICENSE file at the root folder of the project.
 */
#ifdef WITH_HASH_SHA224
#ifdef WITH_CURVE_SECP192R1
#define DECDSA_SHA224_SECP192R1_SELF_TEST_0
/*** Tests for DECDSA-SHA224/SECP192R1 ***/
static const u8 decdsa_rfc6979_SECP192R1_SHA224_0_test_vector_expected_sig[] = {
	0xa1, 0xf0, 0x0d, 0xad, 0x97, 0xae, 0xec, 0x91,
	0xc9, 0x55, 0x85, 0xf3, 0x62, 0x00, 0xc6, 0x5f,
	0x3c, 0x01, 0x81, 0x2a, 0xa6, 0x03, 0x78, 0xf5,
	0xe0, 0x7e, 0xc1, 0x30, 0x4c, 0x7c, 0x6c, 0x9d,
	0xeb, 0xbe, 0x98, 0x0b, 0x96, 0x92, 0x66, 0x8f,
	0x81, 0xd4, 0xde, 0x79, 0x22, 0xa0, 0xf9, 0x7a
};
static const u8 decdsa_rfc6979_SECP192R1_SHA224_0_test_vector_priv_key[] = {
	0x6f, 0xab, 0x03, 0x49, 0x34, 0xe4, 0xc0, 0xfc,
	0x9a, 0xe6, 0x7f, 0x5b, 0x56, 0x59, 0xa9, 0xd7,
	0xd1, 0xfe, 0xfd, 0x18, 0x7e, 0xe0, 0x9f, 0xd4
};
static const ec_test_case decdsa_rfc6979_SECP192R1_SHA224_0_test_case = {
	.name="DECDSA-SHA224/SECP192R1 0",
	.ec_str_p = &secp192r1_str_params,
	.priv_key = decdsa_rfc6979_SECP192R1_SHA224_0_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP192R1_SHA224_0_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA224,
	.msg = "sample",
	.msglen = 6,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP192R1_SHA224_0_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP192R1_SHA224_0_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP192R1 */
#endif /* WITH_HASH_SHA224 */

#ifdef WITH_HASH_SHA256
#ifdef WITH_CURVE_SECP192R1
#define DECDSA_SHA256_SECP192R1_SELF_TEST_0
/*** Tests for DECDSA-SHA256/SECP192R1 ***/
static const u8 decdsa_rfc6979_SECP192R1_SHA256_0_test_vector_expected_sig[] = {
	0x4b, 0x0b, 0x8c, 0xe9, 0x8a, 0x92, 0x86, 0x6a,
	0x28, 0x20, 0xe2, 0x0a, 0xa6, 0xb7, 0x5b, 0x56,
	0x38, 0x2e, 0x0f, 0x9b, 0xfd, 0x5e, 0xcb, 0x55,
	0xcc, 0xdb, 0x00, 0x69, 0x26, 0xea, 0x95, 0x65,
	0xcb, 0xad, 0xc8, 0x40, 0x82, 0x9d, 0x8c, 0x38,
	0x4e, 0x06, 0xde, 0x1f, 0x1e, 0x38, 0x1b, 0x85
};
static const u8 decdsa_rfc6979_SECP192R1_SHA256_0_test_vector_priv_key[] = {
	0x6f, 0xab, 0x03, 0x49, 0x34, 0xe4, 0xc0, 0xfc,
	0x9a, 0xe6, 0x7f, 0x5b, 0x56, 0x59, 0xa9, 0xd7,
	0xd1, 0xfe, 0xfd, 0x18, 0x7e, 0xe0, 0x9f, 0xd4
};
static const ec_test_case decdsa_rfc6979_SECP192R1_SHA256_0_test_case = {
	.name="DECDSA-SHA256/SECP192R1 0",
	.ec_str_p = &secp192r1_str_params,
	.priv_key = decdsa_rfc6979_SECP192R1_SHA256_0_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP192R1_SHA256_0_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA256,
	.msg = "sample",
	.msglen = 6,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP192R1_SHA256_0_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP192R1_SHA256_0_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP192R1 */
#endif /* WITH_HASH_SHA256 */

#ifdef WITH_HASH_SHA384
#ifdef WITH_CURVE_SECP192R1
#define DECDSA_SHA384_SECP192R1_SELF_TEST_0
/*** Tests for DECDSA-SHA384/SECP192R1 ***/
static const u8 decdsa_rfc6979_SECP192R1_SHA384_0_test_vector_expected_sig[] = {
	0xda, 0x63, 0xbf, 0x0b, 0x9a, 0xbc, 0xf9, 0x48,
	0xfb, 0xb1, 0xe9, 0x16, 0x7f, 0x13, 0x61, 0x45,
	0xf7, 0xa2, 0x04, 0x26, 0xdc, 0xc2, 0x87, 0xd5,
	0xc3, 0xaa, 0x2c, 0x96, 0x09, 0x72, 0xbd, 0x7a,
	0x20, 0x03, 0xa5, 0x7e, 0x1c, 0x4c, 0x77, 0xf0,
	0x57, 0x8f, 0x8a, 0xe9, 0x5e, 0x31, 0xec, 0x5e
};
static const u8 decdsa_rfc6979_SECP192R1_SHA384_0_test_vector_priv_key[] = {
	0x6f, 0xab, 0x03, 0x49, 0x34, 0xe4, 0xc0, 0xfc,
	0x9a, 0xe6, 0x7f, 0x5b, 0x56, 0x59, 0xa9, 0xd7,
	0xd1, 0xfe, 0xfd, 0x18, 0x7e, 0xe0, 0x9f, 0xd4
};
static const ec_test_case decdsa_rfc6979_SECP192R1_SHA384_0_test_case = {
	.name="DECDSA-SHA384/SECP192R1 0",
	.ec_str_p = &secp192r1_str_params,
	.priv_key = decdsa_rfc6979_SECP192R1_SHA384_0_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP192R1_SHA384_0_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA384,
	.msg = "sample",
	.msglen = 6,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP192R1_SHA384_0_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP192R1_SHA384_0_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP192R1 */
#endif /* WITH_HASH_SHA384 */

#ifdef WITH_HASH_SHA512
#ifdef WITH_CURVE_SECP192R1
#define DECDSA_SHA512_SECP192R1_SELF_TEST_0
/*** Tests for DECDSA-SHA512/SECP192R1 ***/
static const u8 decdsa_rfc6979_SECP192R1_SHA512_0_test_vector_expected_sig[] = {
	0x4d, 0x60, 0xc5, 0xab, 0x19, 0x96, 0xbd, 0x84,
	0x83, 0x43, 0xb3, 0x1c, 0x00, 0x85, 0x02, 0x05,
	0xe2, 0xea, 0x69, 0x22, 0xda, 0xc2, 0xe4, 0xb8,
	0x3f, 0x6e, 0x83, 0x74, 0x48, 0xf0, 0x27, 0xa1,
	0xbf, 0x4b, 0x34, 0xe7, 0x96, 0xe3, 0x2a, 0x81,
	0x1c, 0xbb, 0x40, 0x50, 0x90, 0x8d, 0x8f, 0x67
};
static const u8 decdsa_rfc6979_SECP192R1_SHA512_0_test_vector_priv_key[] = {
	0x6f, 0xab, 0x03, 0x49, 0x34, 0xe4, 0xc0, 0xfc,
	0x9a, 0xe6, 0x7f, 0x5b, 0x56, 0x59, 0xa9, 0xd7,
	0xd1, 0xfe, 0xfd, 0x18, 0x7e, 0xe0, 0x9f, 0xd4
};
static const ec_test_case decdsa_rfc6979_SECP192R1_SHA512_0_test_case = {
	.name="DECDSA-SHA512/SECP192R1 0",
	.ec_str_p = &secp192r1_str_params,
	.priv_key = decdsa_rfc6979_SECP192R1_SHA512_0_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP192R1_SHA512_0_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA512,
	.msg = "sample",
	.msglen = 6,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP192R1_SHA512_0_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP192R1_SHA512_0_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP192R1 */
#endif /* WITH_HASH_SHA512 */

#ifdef WITH_HASH_SHA224
#ifdef WITH_CURVE_SECP192R1
#define DECDSA_SHA224_SECP192R1_SELF_TEST_1
/*** Tests for DECDSA-SHA224/SECP192R1 ***/
static const u8 decdsa_rfc6979_SECP192R1_SHA224_1_test_vector_expected_sig[] = {
	0x69, 0x45, 0xa1, 0xc1, 0xd1, 0xb2, 0x20, 0x6b,
	0x81, 0x45, 0x54, 0x8f, 0x63, 0x3b, 0xb6, 0x1c,
	0xef, 0x04, 0x89, 0x1b, 0xaf, 0x26, 0xed, 0x34,
	0xb7, 0xfb, 0x7f, 0xdf, 0xc3, 0x39, 0xc0, 0xb9,
	0xbd, 0x61, 0xa9, 0xf5, 0xa8, 0xea, 0xf9, 0xbe,
	0x58, 0xfc, 0x5c, 0xba, 0x2c, 0xb1, 0x52, 0x93
};
static const u8 decdsa_rfc6979_SECP192R1_SHA224_1_test_vector_priv_key[] = {
	0x6f, 0xab, 0x03, 0x49, 0x34, 0xe4, 0xc0, 0xfc,
	0x9a, 0xe6, 0x7f, 0x5b, 0x56, 0x59, 0xa9, 0xd7,
	0xd1, 0xfe, 0xfd, 0x18, 0x7e, 0xe0, 0x9f, 0xd4
};
static const ec_test_case decdsa_rfc6979_SECP192R1_SHA224_1_test_case = {
	.name="DECDSA-SHA224/SECP192R1 1",
	.ec_str_p = &secp192r1_str_params,
	.priv_key = decdsa_rfc6979_SECP192R1_SHA224_1_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP192R1_SHA224_1_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA224,
	.msg = "test",
	.msglen = 4,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP192R1_SHA224_1_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP192R1_SHA224_1_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP192R1 */
#endif /* WITH_HASH_SHA224 */

#ifdef WITH_HASH_SHA256
#ifdef WITH_CURVE_SECP192R1
#define DECDSA_SHA256_SECP192R1_SELF_TEST_1
/*** Tests for DECDSA-SHA256/SECP192R1 ***/
static const u8 decdsa_rfc6979_SECP192R1_SHA256_1_test_vector_expected_sig[] = {
	0x3a, 0x71, 0x8b, 0xd8, 0xb4, 0x92, 0x6c, 0x3b,
	0x52, 0xee, 0x6b, 0xbe, 0x67, 0xef, 0x79, 0xb1,
	0x8c, 0xb6, 0xeb, 0x62, 0xb1, 0xad, 0x97, 0xae,
	0x56, 0x62, 0xe6, 0x84, 0x8a, 0x4a, 0x19, 0xb1,
	0xf1, 0xae, 0x2f, 0x72, 0xac, 0xd4, 0xb8, 0xbb,
	0xe5, 0x0f, 0x1e, 0xac, 0x65, 0xd9, 0x12, 0x4f
};
static const u8 decdsa_rfc6979_SECP192R1_SHA256_1_test_vector_priv_key[] = {
	0x6f, 0xab, 0x03, 0x49, 0x34, 0xe4, 0xc0, 0xfc,
	0x9a, 0xe6, 0x7f, 0x5b, 0x56, 0x59, 0xa9, 0xd7,
	0xd1, 0xfe, 0xfd, 0x18, 0x7e, 0xe0, 0x9f, 0xd4
};
static const ec_test_case decdsa_rfc6979_SECP192R1_SHA256_1_test_case = {
	.name="DECDSA-SHA256/SECP192R1 1",
	.ec_str_p = &secp192r1_str_params,
	.priv_key = decdsa_rfc6979_SECP192R1_SHA256_1_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP192R1_SHA256_1_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA256,
	.msg = "test",
	.msglen = 4,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP192R1_SHA256_1_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP192R1_SHA256_1_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP192R1 */
#endif /* WITH_HASH_SHA256 */

#ifdef WITH_HASH_SHA384
#ifdef WITH_CURVE_SECP192R1
#define DECDSA_SHA384_SECP192R1_SELF_TEST_1
/*** Tests for DECDSA-SHA384/SECP192R1 ***/
static const u8 decdsa_rfc6979_SECP192R1_SHA384_1_test_vector_expected_sig[] = {
	0xb2, 0x34, 0xb6, 0x0b, 0x4d, 0xb7, 0x5a, 0x73,
	0x3e, 0x19, 0x28, 0x0a, 0x7a, 0x60, 0x34, 0xbd,
	0x6b, 0x1e, 0xe8, 0x8a, 0xf5, 0x33, 0x23, 0x67,
	0x79, 0x94, 0x09, 0x0b, 0x2d, 0x59, 0xbb, 0x78,
	0x2b, 0xe5, 0x7e, 0x74, 0xa4, 0x4c, 0x9a, 0x1c,
	0x70, 0x04, 0x13, 0xf8, 0xab, 0xef, 0xe7, 0x7a
};
static const u8 decdsa_rfc6979_SECP192R1_SHA384_1_test_vector_priv_key[] = {
	0x6f, 0xab, 0x03, 0x49, 0x34, 0xe4, 0xc0, 0xfc,
	0x9a, 0xe6, 0x7f, 0x5b, 0x56, 0x59, 0xa9, 0xd7,
	0xd1, 0xfe, 0xfd, 0x18, 0x7e, 0xe0, 0x9f, 0xd4
};
static const ec_test_case decdsa_rfc6979_SECP192R1_SHA384_1_test_case = {
	.name="DECDSA-SHA384/SECP192R1 1",
	.ec_str_p = &secp192r1_str_params,
	.priv_key = decdsa_rfc6979_SECP192R1_SHA384_1_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP192R1_SHA384_1_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA384,
	.msg = "test",
	.msglen = 4,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP192R1_SHA384_1_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP192R1_SHA384_1_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP192R1 */
#endif /* WITH_HASH_SHA384 */

#ifdef WITH_HASH_SHA512
#ifdef WITH_CURVE_SECP192R1
#define DECDSA_SHA512_SECP192R1_SELF_TEST_1
/*** Tests for DECDSA-SHA512/SECP192R1 ***/
static const u8 decdsa_rfc6979_SECP192R1_SHA512_1_test_vector_expected_sig[] = {
	0xfe, 0x4f, 0x4a, 0xe8, 0x6a, 0x58, 0xb6, 0x50,
	0x79, 0x46, 0x71, 0x59, 0x34, 0xfe, 0x2d, 0x8f,
	0xf9, 0xd9, 0x5b, 0x6b, 0x09, 0x8f, 0xe7, 0x39,
	0x74, 0xcf, 0x56, 0x05, 0xc9, 0x8f, 0xba, 0x0e,
	0x1e, 0xf3, 0x4d, 0x4b, 0x5a, 0x15, 0x77, 0xa7,
	0xdc, 0xf5, 0x94, 0x57, 0xca, 0xe5, 0x22, 0x90
};
static const u8 decdsa_rfc6979_SECP192R1_SHA512_1_test_vector_priv_key[] = {
	0x6f, 0xab, 0x03, 0x49, 0x34, 0xe4, 0xc0, 0xfc,
	0x9a, 0xe6, 0x7f, 0x5b, 0x56, 0x59, 0xa9, 0xd7,
	0xd1, 0xfe, 0xfd, 0x18, 0x7e, 0xe0, 0x9f, 0xd4
};
static const ec_test_case decdsa_rfc6979_SECP192R1_SHA512_1_test_case = {
	.name="DECDSA-SHA512/SECP192R1 1",
	.ec_str_p = &secp192r1_str_params,
	.priv_key = decdsa_rfc6979_SECP192R1_SHA512_1_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP192R1_SHA512_1_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA512,
	.msg = "test",
	.msglen = 4,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP192R1_SHA512_1_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP192R1_SHA512_1_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP192R1 */
#endif /* WITH_HASH_SHA512 */

#ifdef WITH_HASH_SHA224
#ifdef WITH_CURVE_SECP256R1
#define DECDSA_SHA224_SECP256R1_SELF_TEST_0
/*** Tests for DECDSA-SHA224/SECP256R1 ***/
static const u8 decdsa_rfc6979_SECP256R1_SHA224_0_test_vector_expected_sig[] = {
	0x53, 0xb2, 0xff, 0xf5, 0xd1, 0x75, 0x2b, 0x2c,
	0x68, 0x9d, 0xf2, 0x57, 0xc0, 0x4c, 0x40, 0xa5,
	0x87, 0xfa, 0xba, 0xbb, 0x3f, 0x6f, 0xc2, 0x70,
	0x2f, 0x13, 0x43, 0xaf, 0x7c, 0xa9, 0xaa, 0x3f,
	0xb9, 0xaf, 0xb6, 0x4f, 0xdc, 0x03, 0xdc, 0x1a,
	0x13, 0x1c, 0x7d, 0x23, 0x86, 0xd1, 0x1e, 0x34,
	0x9f, 0x07, 0x0a, 0xa4, 0x32, 0xa4, 0xac, 0xc9,
	0x18, 0xbe, 0xa9, 0x88, 0xbf, 0x75, 0xc7, 0x4c
};
static const u8 decdsa_rfc6979_SECP256R1_SHA224_0_test_vector_priv_key[] = {
	0xc9, 0xaf, 0xa9, 0xd8, 0x45, 0xba, 0x75, 0x16,
	0x6b, 0x5c, 0x21, 0x57, 0x67, 0xb1, 0xd6, 0x93,
	0x4e, 0x50, 0xc3, 0xdb, 0x36, 0xe8, 0x9b, 0x12,
	0x7b, 0x8a, 0x62, 0x2b, 0x12, 0x0f, 0x67, 0x21
};
static const ec_test_case decdsa_rfc6979_SECP256R1_SHA224_0_test_case = {
	.name="DECDSA-SHA224/SECP256R1 0",
	.ec_str_p = &secp256r1_str_params,
	.priv_key = decdsa_rfc6979_SECP256R1_SHA224_0_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP256R1_SHA224_0_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA224,
	.msg = "sample",
	.msglen = 6,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP256R1_SHA224_0_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP256R1_SHA224_0_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP256R1 */
#endif /* WITH_HASH_SHA224 */

#ifdef WITH_HASH_SHA256
#ifdef WITH_CURVE_SECP256R1
#define DECDSA_SHA256_SECP256R1_SELF_TEST_0
/*** Tests for DECDSA-SHA256/SECP256R1 ***/
static const u8 decdsa_rfc6979_SECP256R1_SHA256_0_test_vector_expected_sig[] = {
	0xef, 0xd4, 0x8b, 0x2a, 0xac, 0xb6, 0xa8, 0xfd,
	0x11, 0x40, 0xdd, 0x9c, 0xd4, 0x5e, 0x81, 0xd6,
	0x9d, 0x2c, 0x87, 0x7b, 0x56, 0xaa, 0xf9, 0x91,
	0xc3, 0x4d, 0x0e, 0xa8, 0x4e, 0xaf, 0x37, 0x16,
	0xf7, 0xcb, 0x1c, 0x94, 0x2d, 0x65, 0x7c, 0x41,
	0xd4, 0x36, 0xc7, 0xa1, 0xb6, 0xe2, 0x9f, 0x65,
	0xf3, 0xe9, 0x00, 0xdb, 0xb9, 0xaf, 0xf4, 0x06,
	0x4d, 0xc4, 0xab, 0x2f, 0x84, 0x3a, 0xcd, 0xa8
};
static const u8 decdsa_rfc6979_SECP256R1_SHA256_0_test_vector_priv_key[] = {
	0xc9, 0xaf, 0xa9, 0xd8, 0x45, 0xba, 0x75, 0x16,
	0x6b, 0x5c, 0x21, 0x57, 0x67, 0xb1, 0xd6, 0x93,
	0x4e, 0x50, 0xc3, 0xdb, 0x36, 0xe8, 0x9b, 0x12,
	0x7b, 0x8a, 0x62, 0x2b, 0x12, 0x0f, 0x67, 0x21
};
static const ec_test_case decdsa_rfc6979_SECP256R1_SHA256_0_test_case = {
	.name="DECDSA-SHA256/SECP256R1 0",
	.ec_str_p = &secp256r1_str_params,
	.priv_key = decdsa_rfc6979_SECP256R1_SHA256_0_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP256R1_SHA256_0_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA256,
	.msg = "sample",
	.msglen = 6,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP256R1_SHA256_0_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP256R1_SHA256_0_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP256R1 */
#endif /* WITH_HASH_SHA256 */

#ifdef WITH_HASH_SHA384
#ifdef WITH_CURVE_SECP256R1
#define DECDSA_SHA384_SECP256R1_SELF_TEST_0
/*** Tests for DECDSA-SHA384/SECP256R1 ***/
static const u8 decdsa_rfc6979_SECP256R1_SHA384_0_test_vector_expected_sig[] = {
	0x0e, 0xaf, 0xea, 0x03, 0x9b, 0x20, 0xe9, 0xb4,
	0x23, 0x09, 0xfb, 0x1d, 0x89, 0xe2, 0x13, 0x05,
	0x7c, 0xbf, 0x97, 0x3d, 0xc0, 0xcf, 0xc8, 0xf1,
	0x29, 0xed, 0xdd, 0xc8, 0x00, 0xef, 0x77, 0x19,
	0x48, 0x61, 0xf0, 0x49, 0x1e, 0x69, 0x98, 0xb9,
	0x45, 0x51, 0x93, 0xe3, 0x4e, 0x7b, 0x0d, 0x28,
	0x4d, 0xdd, 0x71, 0x49, 0xa7, 0x4b, 0x95, 0xb9,
	0x26, 0x1f, 0x13, 0xab, 0xde, 0x94, 0x09, 0x54
};
static const u8 decdsa_rfc6979_SECP256R1_SHA384_0_test_vector_priv_key[] = {
	0xc9, 0xaf, 0xa9, 0xd8, 0x45, 0xba, 0x75, 0x16,
	0x6b, 0x5c, 0x21, 0x57, 0x67, 0xb1, 0xd6, 0x93,
	0x4e, 0x50, 0xc3, 0xdb, 0x36, 0xe8, 0x9b, 0x12,
	0x7b, 0x8a, 0x62, 0x2b, 0x12, 0x0f, 0x67, 0x21
};
static const ec_test_case decdsa_rfc6979_SECP256R1_SHA384_0_test_case = {
	.name="DECDSA-SHA384/SECP256R1 0",
	.ec_str_p = &secp256r1_str_params,
	.priv_key = decdsa_rfc6979_SECP256R1_SHA384_0_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP256R1_SHA384_0_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA384,
	.msg = "sample",
	.msglen = 6,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP256R1_SHA384_0_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP256R1_SHA384_0_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP256R1 */
#endif /* WITH_HASH_SHA384 */

#ifdef WITH_HASH_SHA512
#ifdef WITH_CURVE_SECP256R1
#define DECDSA_SHA512_SECP256R1_SELF_TEST_0
/*** Tests for DECDSA-SHA512/SECP256R1 ***/
static const u8 decdsa_rfc6979_SECP256R1_SHA512_0_test_vector_expected_sig[] = {
	0x84, 0x96, 0xa6, 0x0b, 0x5e, 0x9b, 0x47, 0xc8,
	0x25, 0x48, 0x88, 0x27, 0xe0, 0x49, 0x5b, 0x0e,
	0x3f, 0xa1, 0x09, 0xec, 0x45, 0x68, 0xfd, 0x3f,
	0x8d, 0x10, 0x97, 0x67, 0x8e, 0xb9, 0x7f, 0x00,
	0x23, 0x62, 0xab, 0x1a, 0xdb, 0xe2, 0xb8, 0xad,
	0xf9, 0xcb, 0x9e, 0xda, 0xb7, 0x40, 0xea, 0x60,
	0x49, 0xc0, 0x28, 0x11, 0x4f, 0x24, 0x60, 0xf9,
	0x65, 0x54, 0xf6, 0x1f, 0xae, 0x33, 0x02, 0xfe
};
static const u8 decdsa_rfc6979_SECP256R1_SHA512_0_test_vector_priv_key[] = {
	0xc9, 0xaf, 0xa9, 0xd8, 0x45, 0xba, 0x75, 0x16,
	0x6b, 0x5c, 0x21, 0x57, 0x67, 0xb1, 0xd6, 0x93,
	0x4e, 0x50, 0xc3, 0xdb, 0x36, 0xe8, 0x9b, 0x12,
	0x7b, 0x8a, 0x62, 0x2b, 0x12, 0x0f, 0x67, 0x21
};
static const ec_test_case decdsa_rfc6979_SECP256R1_SHA512_0_test_case = {
	.name="DECDSA-SHA512/SECP256R1 0",
	.ec_str_p = &secp256r1_str_params,
	.priv_key = decdsa_rfc6979_SECP256R1_SHA512_0_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP256R1_SHA512_0_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA512,
	.msg = "sample",
	.msglen = 6,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP256R1_SHA512_0_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP256R1_SHA512_0_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP256R1 */
#endif /* WITH_HASH_SHA512 */

#ifdef WITH_HASH_SHA224
#ifdef WITH_CURVE_SECP256R1
#define DECDSA_SHA224_SECP256R1_SELF_TEST_1
/*** Tests for DECDSA-SHA224/SECP256R1 ***/
static const u8 decdsa_rfc6979_SECP256R1_SHA224_1_test_vector_expected_sig[] = {
	0xc3, 0x7e, 0xdb, 0x6f, 0x0a, 0xe7, 0x9d, 0x47,
	0xc3, 0xc2, 0x7e, 0x96, 0x2f, 0xa2, 0x69, 0xbb,
	0x4f, 0x44, 0x17, 0x70, 0x35, 0x7e, 0x11, 0x4e,
	0xe5, 0x11, 0xf6, 0x62, 0xec, 0x34, 0xa6, 0x92,
	0xc8, 0x20, 0x05, 0x3a, 0x05, 0x79, 0x1e, 0x52,
	0x1f, 0xca, 0xad, 0x60, 0x42, 0xd4, 0x0a, 0xea,
	0x1d, 0x6b, 0x1a, 0x54, 0x01, 0x38, 0x55, 0x8f,
	0x47, 0xd0, 0x71, 0x98, 0x00, 0xe1, 0x8f, 0x2d
};
static const u8 decdsa_rfc6979_SECP256R1_SHA224_1_test_vector_priv_key[] = {
	0xc9, 0xaf, 0xa9, 0xd8, 0x45, 0xba, 0x75, 0x16,
	0x6b, 0x5c, 0x21, 0x57, 0x67, 0xb1, 0xd6, 0x93,
	0x4e, 0x50, 0xc3, 0xdb, 0x36, 0xe8, 0x9b, 0x12,
	0x7b, 0x8a, 0x62, 0x2b, 0x12, 0x0f, 0x67, 0x21
};
static const ec_test_case decdsa_rfc6979_SECP256R1_SHA224_1_test_case = {
	.name="DECDSA-SHA224/SECP256R1 1",
	.ec_str_p = &secp256r1_str_params,
	.priv_key = decdsa_rfc6979_SECP256R1_SHA224_1_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP256R1_SHA224_1_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA224,
	.msg = "test",
	.msglen = 4,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP256R1_SHA224_1_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP256R1_SHA224_1_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP256R1 */
#endif /* WITH_HASH_SHA224 */

#ifdef WITH_HASH_SHA256
#ifdef WITH_CURVE_SECP256R1
#define DECDSA_SHA256_SECP256R1_SELF_TEST_1
/*** Tests for DECDSA-SHA256/SECP256R1 ***/
static const u8 decdsa_rfc6979_SECP256R1_SHA256_1_test_vector_expected_sig[] = {
	0xf1, 0xab, 0xb0, 0x23, 0x51, 0x83, 0x51, 0xcd,
	0x71, 0xd8, 0x81, 0x56, 0x7b, 0x1e, 0xa6, 0x63,
	0xed, 0x3e, 0xfc, 0xf6, 0xc5, 0x13, 0x2b, 0x35,
	0x4f, 0x28, 0xd3, 0xb0, 0xb7, 0xd3, 0x83, 0x67,
	0x01, 0x9f, 0x41, 0x13, 0x74, 0x2a, 0x2b, 0x14,
	0xbd, 0x25, 0x92, 0x6b, 0x49, 0xc6, 0x49, 0x15,
	0x5f, 0x26, 0x7e, 0x60, 0xd3, 0x81, 0x4b, 0x4c,
	0x0c, 0xc8, 0x42, 0x50, 0xe4, 0x6f, 0x00, 0x83
};
static const u8 decdsa_rfc6979_SECP256R1_SHA256_1_test_vector_priv_key[] = {
	0xc9, 0xaf, 0xa9, 0xd8, 0x45, 0xba, 0x75, 0x16,
	0x6b, 0x5c, 0x21, 0x57, 0x67, 0xb1, 0xd6, 0x93,
	0x4e, 0x50, 0xc3, 0xdb, 0x36, 0xe8, 0x9b, 0x12,
	0x7b, 0x8a, 0x62, 0x2b, 0x12, 0x0f, 0x67, 0x21
};
static const ec_test_case decdsa_rfc6979_SECP256R1_SHA256_1_test_case = {
	.name="DECDSA-SHA256/SECP256R1 1",
	.ec_str_p = &secp256r1_str_params,
	.priv_key = decdsa_rfc6979_SECP256R1_SHA256_1_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP256R1_SHA256_1_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA256,
	.msg = "test",
	.msglen = 4,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP256R1_SHA256_1_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP256R1_SHA256_1_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP256R1 */
#endif /* WITH_HASH_SHA256 */

#ifdef WITH_HASH_SHA384
#ifdef WITH_CURVE_SECP256R1
#define DECDSA_SHA384_SECP256R1_SELF_TEST_1
/*** Tests for DECDSA-SHA384/SECP256R1 ***/
static const u8 decdsa_rfc6979_SECP256R1_SHA384_1_test_vector_expected_sig[] = {
	0x83, 0x91, 0x0e, 0x8b, 0x48, 0xbb, 0x0c, 0x74,
	0x24, 0x4e, 0xbd, 0xf7, 0xf0, 0x7a, 0x1c, 0x54,
	0x13, 0xd6, 0x14, 0x72, 0xbd, 0x94, 0x1e, 0xf3,
	0x92, 0x0e, 0x62, 0x3f, 0xbc, 0xce, 0xbe, 0xb6,
	0x8d, 0xdb, 0xec, 0x54, 0xcf, 0x8c, 0xd5, 0x87,
	0x48, 0x83, 0x84, 0x1d, 0x71, 0x21, 0x42, 0xa5,
	0x6a, 0x8d, 0x0f, 0x21, 0x8f, 0x50, 0x03, 0xcb,
	0x02, 0x96, 0xb6, 0xb5, 0x09, 0x61, 0x9f, 0x2c
};
static const u8 decdsa_rfc6979_SECP256R1_SHA384_1_test_vector_priv_key[] = {
	0xc9, 0xaf, 0xa9, 0xd8, 0x45, 0xba, 0x75, 0x16,
	0x6b, 0x5c, 0x21, 0x57, 0x67, 0xb1, 0xd6, 0x93,
	0x4e, 0x50, 0xc3, 0xdb, 0x36, 0xe8, 0x9b, 0x12,
	0x7b, 0x8a, 0x62, 0x2b, 0x12, 0x0f, 0x67, 0x21
};
static const ec_test_case decdsa_rfc6979_SECP256R1_SHA384_1_test_case = {
	.name="DECDSA-SHA384/SECP256R1 1",
	.ec_str_p = &secp256r1_str_params,
	.priv_key = decdsa_rfc6979_SECP256R1_SHA384_1_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP256R1_SHA384_1_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA384,
	.msg = "test",
	.msglen = 4,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP256R1_SHA384_1_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP256R1_SHA384_1_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP256R1 */
#endif /* WITH_HASH_SHA384 */

#ifdef WITH_HASH_SHA512
#ifdef WITH_CURVE_SECP256R1
#define DECDSA_SHA512_SECP256R1_SELF_TEST_1
/*** Tests for DECDSA-SHA512/SECP256R1 ***/
static const u8 decdsa_rfc6979_SECP256R1_SHA512_1_test_vector_expected_sig[] = {
	0x46, 0x1d, 0x93, 0xf3, 0x1b, 0x65, 0x40, 0x89,
	0x47, 0x88, 0xfd, 0x20, 0x6c, 0x07, 0xcf, 0xa0,
	0xcc, 0x35, 0xf4, 0x6f, 0xa3, 0xc9, 0x18, 0x16,
	0xff, 0xf1, 0x04, 0x0a, 0xd1, 0x58, 0x1a, 0x04,
	0x39, 0xaf, 0x9f, 0x15, 0xde, 0x0d, 0xb8, 0xd9,
	0x7e, 0x72, 0x71, 0x9c, 0x74, 0x82, 0x0d, 0x30,
	0x4c, 0xe5, 0x22, 0x6e, 0x32, 0xde, 0xda, 0xe6,
	0x75, 0x19, 0xe8, 0x40, 0xd1, 0x19, 0x4e, 0x55
};
static const u8 decdsa_rfc6979_SECP256R1_SHA512_1_test_vector_priv_key[] = {
	0xc9, 0xaf, 0xa9, 0xd8, 0x45, 0xba, 0x75, 0x16,
	0x6b, 0x5c, 0x21, 0x57, 0x67, 0xb1, 0xd6, 0x93,
	0x4e, 0x50, 0xc3, 0xdb, 0x36, 0xe8, 0x9b, 0x12,
	0x7b, 0x8a, 0x62, 0x2b, 0x12, 0x0f, 0x67, 0x21
};
static const ec_test_case decdsa_rfc6979_SECP256R1_SHA512_1_test_case = {
	.name="DECDSA-SHA512/SECP256R1 1",
	.ec_str_p = &secp256r1_str_params,
	.priv_key = decdsa_rfc6979_SECP256R1_SHA512_1_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP256R1_SHA512_1_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA512,
	.msg = "test",
	.msglen = 4,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP256R1_SHA512_1_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP256R1_SHA512_1_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP256R1 */
#endif /* WITH_HASH_SHA512 */

#ifdef WITH_HASH_SHA224
#ifdef WITH_CURVE_SECP384R1
#define DECDSA_SHA224_SECP384R1_SELF_TEST_0
/*** Tests for DECDSA-SHA224/SECP384R1 ***/
static const u8 decdsa_rfc6979_SECP384R1_SHA224_0_test_vector_expected_sig[] = {
	0x42, 0x35, 0x6e, 0x76, 0xb5, 0x5a, 0x6d, 0x9b,
	0x46, 0x31, 0xc8, 0x65, 0x44, 0x5d, 0xbe, 0x54,
	0xe0, 0x56, 0xd3, 0xb3, 0x43, 0x17, 0x66, 0xd0,
	0x50, 0x92, 0x44, 0x79, 0x3c, 0x3f, 0x93, 0x66,
	0x45, 0x0f, 0x76, 0xee, 0x3d, 0xe4, 0x3f, 0x5a,
	0x12, 0x53, 0x33, 0xa6, 0xbe, 0x06, 0x01, 0x22,
	0x9d, 0xa0, 0xc8, 0x17, 0x87, 0x06, 0x40, 0x21,
	0xe7, 0x8d, 0xf6, 0x58, 0xf2, 0xfb, 0xb0, 0xb0,
	0x42, 0xbf, 0x30, 0x46, 0x65, 0xdb, 0x72, 0x1f,
	0x07, 0x7a, 0x42, 0x98, 0xb0, 0x95, 0xe4, 0x83,
	0x4c, 0x08, 0x2c, 0x03, 0xd8, 0x30, 0x28, 0xef,
	0xbf, 0x93, 0xa3, 0xc2, 0x39, 0x40, 0xca, 0x8d
};
static const u8 decdsa_rfc6979_SECP384R1_SHA224_0_test_vector_priv_key[] = {
	0x6b, 0x9d, 0x3d, 0xad, 0x2e, 0x1b, 0x8c, 0x1c,
	0x05, 0xb1, 0x98, 0x75, 0xb6, 0x65, 0x9f, 0x4d,
	0xe2, 0x3c, 0x3b, 0x66, 0x7b, 0xf2, 0x97, 0xba,
	0x9a, 0xa4, 0x77, 0x40, 0x78, 0x71, 0x37, 0xd8,
	0x96, 0xd5, 0x72, 0x4e, 0x4c, 0x70, 0xa8, 0x25,
	0xf8, 0x72, 0xc9, 0xea, 0x60, 0xd2, 0xed, 0xf5
};
static const ec_test_case decdsa_rfc6979_SECP384R1_SHA224_0_test_case = {
	.name="DECDSA-SHA224/SECP384R1 0",
	.ec_str_p = &secp384r1_str_params,
	.priv_key = decdsa_rfc6979_SECP384R1_SHA224_0_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP384R1_SHA224_0_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA224,
	.msg = "sample",
	.msglen = 6,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP384R1_SHA224_0_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP384R1_SHA224_0_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP384R1 */
#endif /* WITH_HASH_SHA224 */

#ifdef WITH_HASH_SHA256
#ifdef WITH_CURVE_SECP384R1
#define DECDSA_SHA256_SECP384R1_SELF_TEST_0
/*** Tests for DECDSA-SHA256/SECP384R1 ***/
static const u8 decdsa_rfc6979_SECP384R1_SHA256_0_test_vector_expected_sig[] = {
	0x21, 0xb1, 0x3d, 0x1e, 0x01, 0x3c, 0x7f, 0xa1,
	0x39, 0x2d, 0x03, 0xc5, 0xf9, 0x9a, 0xf8, 0xb3,
	0x0c, 0x57, 0x0c, 0x6f, 0x98, 0xd4, 0xea, 0x8e,
	0x35, 0x4b, 0x63, 0xa2, 0x1d, 0x3d, 0xaa, 0x33,
	0xbd, 0xe1, 0xe8, 0x88, 0xe6, 0x33, 0x55, 0xd9,
	0x2f, 0xa2, 0xb3, 0xc3, 0x6d, 0x8f, 0xb2, 0xcd,
	0xf3, 0xaa, 0x44, 0x3f, 0xb1, 0x07, 0x74, 0x5b,
	0xf4, 0xbd, 0x77, 0xcb, 0x38, 0x91, 0x67, 0x46,
	0x32, 0x06, 0x8a, 0x10, 0xca, 0x67, 0xe3, 0xd4,
	0x5d, 0xb2, 0x26, 0x6f, 0xa7, 0xd1, 0xfe, 0xeb,
	0xef, 0xdc, 0x63, 0xec, 0xcd, 0x1a, 0xc4, 0x2e,
	0xc0, 0xcb, 0x86, 0x68, 0xa4, 0xfa, 0x0a, 0xb0
};
static const u8 decdsa_rfc6979_SECP384R1_SHA256_0_test_vector_priv_key[] = {
	0x6b, 0x9d, 0x3d, 0xad, 0x2e, 0x1b, 0x8c, 0x1c,
	0x05, 0xb1, 0x98, 0x75, 0xb6, 0x65, 0x9f, 0x4d,
	0xe2, 0x3c, 0x3b, 0x66, 0x7b, 0xf2, 0x97, 0xba,
	0x9a, 0xa4, 0x77, 0x40, 0x78, 0x71, 0x37, 0xd8,
	0x96, 0xd5, 0x72, 0x4e, 0x4c, 0x70, 0xa8, 0x25,
	0xf8, 0x72, 0xc9, 0xea, 0x60, 0xd2, 0xed, 0xf5
};
static const ec_test_case decdsa_rfc6979_SECP384R1_SHA256_0_test_case = {
	.name="DECDSA-SHA256/SECP384R1 0",
	.ec_str_p = &secp384r1_str_params,
	.priv_key = decdsa_rfc6979_SECP384R1_SHA256_0_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP384R1_SHA256_0_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA256,
	.msg = "sample",
	.msglen = 6,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP384R1_SHA256_0_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP384R1_SHA256_0_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP384R1 */
#endif /* WITH_HASH_SHA256 */

#ifdef WITH_HASH_SHA384
#ifdef WITH_CURVE_SECP384R1
#define DECDSA_SHA384_SECP384R1_SELF_TEST_0
/*** Tests for DECDSA-SHA384/SECP384R1 ***/
static const u8 decdsa_rfc6979_SECP384R1_SHA384_0_test_vector_expected_sig[] = {
	0x94, 0xed, 0xbb, 0x92, 0xa5, 0xec, 0xb8, 0xaa,
	0xd4, 0x73, 0x6e, 0x56, 0xc6, 0x91, 0x91, 0x6b,
	0x3f, 0x88, 0x14, 0x06, 0x66, 0xce, 0x9f, 0xa7,
	0x3d, 0x64, 0xc4, 0xea, 0x95, 0xad, 0x13, 0x3c,
	0x81, 0xa6, 0x48, 0x15, 0x2e, 0x44, 0xac, 0xf9,
	0x6e, 0x36, 0xdd, 0x1e, 0x80, 0xfa, 0xbe, 0x46,
	0x99, 0xef, 0x4a, 0xeb, 0x15, 0xf1, 0x78, 0xce,
	0xa1, 0xfe, 0x40, 0xdb, 0x26, 0x03, 0x13, 0x8f,
	0x13, 0x0e, 0x74, 0x0a, 0x19, 0x62, 0x45, 0x26,
	0x20, 0x3b, 0x63, 0x51, 0xd0, 0xa3, 0xa9, 0x4f,
	0xa3, 0x29, 0xc1, 0x45, 0x78, 0x6e, 0x67, 0x9e,
	0x7b, 0x82, 0xc7, 0x1a, 0x38, 0x62, 0x8a, 0xc8
};
static const u8 decdsa_rfc6979_SECP384R1_SHA384_0_test_vector_priv_key[] = {
	0x6b, 0x9d, 0x3d, 0xad, 0x2e, 0x1b, 0x8c, 0x1c,
	0x05, 0xb1, 0x98, 0x75, 0xb6, 0x65, 0x9f, 0x4d,
	0xe2, 0x3c, 0x3b, 0x66, 0x7b, 0xf2, 0x97, 0xba,
	0x9a, 0xa4, 0x77, 0x40, 0x78, 0x71, 0x37, 0xd8,
	0x96, 0xd5, 0x72, 0x4e, 0x4c, 0x70, 0xa8, 0x25,
	0xf8, 0x72, 0xc9, 0xea, 0x60, 0xd2, 0xed, 0xf5
};
static const ec_test_case decdsa_rfc6979_SECP384R1_SHA384_0_test_case = {
	.name="DECDSA-SHA384/SECP384R1 0",
	.ec_str_p = &secp384r1_str_params,
	.priv_key = decdsa_rfc6979_SECP384R1_SHA384_0_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP384R1_SHA384_0_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA384,
	.msg = "sample",
	.msglen = 6,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP384R1_SHA384_0_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP384R1_SHA384_0_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP384R1 */
#endif /* WITH_HASH_SHA384 */

#ifdef WITH_HASH_SHA512
#ifdef WITH_CURVE_SECP384R1
#define DECDSA_SHA512_SECP384R1_SELF_TEST_0
/*** Tests for DECDSA-SHA512/SECP384R1 ***/
static const u8 decdsa_rfc6979_SECP384R1_SHA512_0_test_vector_expected_sig[] = {
	0xed, 0x09, 0x59, 0xd5, 0x88, 0x0a, 0xb2, 0xd8,
	0x69, 0xae, 0x7f, 0x6c, 0x29, 0x15, 0xc6, 0xd6,
	0x0f, 0x96, 0x50, 0x7f, 0x9c, 0xb3, 0xe0, 0x47,
	0xc0, 0x04, 0x68, 0x61, 0xda, 0x4a, 0x79, 0x9c,
	0xfe, 0x30, 0xf3, 0x5c, 0xc9, 0x00, 0x05, 0x6d,
	0x7c, 0x99, 0xcd, 0x78, 0x82, 0x43, 0x37, 0x09,
	0x51, 0x2c, 0x8c, 0xce, 0xee, 0x38, 0x90, 0xa8,
	0x40, 0x58, 0xce, 0x1e, 0x22, 0xdb, 0xc2, 0x19,
	0x8f, 0x42, 0x32, 0x3c, 0xe8, 0xac, 0xa9, 0x13,
	0x53, 0x29, 0xf0, 0x3c, 0x06, 0x8e, 0x51, 0x12,
	0xdc, 0x7c, 0xc3, 0xef, 0x34, 0x46, 0xde, 0xfc,
	0xeb, 0x01, 0xa4, 0x5c, 0x26, 0x67, 0xfd, 0xd5
};
static const u8 decdsa_rfc6979_SECP384R1_SHA512_0_test_vector_priv_key[] = {
	0x6b, 0x9d, 0x3d, 0xad, 0x2e, 0x1b, 0x8c, 0x1c,
	0x05, 0xb1, 0x98, 0x75, 0xb6, 0x65, 0x9f, 0x4d,
	0xe2, 0x3c, 0x3b, 0x66, 0x7b, 0xf2, 0x97, 0xba,
	0x9a, 0xa4, 0x77, 0x40, 0x78, 0x71, 0x37, 0xd8,
	0x96, 0xd5, 0x72, 0x4e, 0x4c, 0x70, 0xa8, 0x25,
	0xf8, 0x72, 0xc9, 0xea, 0x60, 0xd2, 0xed, 0xf5
};
static const ec_test_case decdsa_rfc6979_SECP384R1_SHA512_0_test_case = {
	.name="DECDSA-SHA512/SECP384R1 0",
	.ec_str_p = &secp384r1_str_params,
	.priv_key = decdsa_rfc6979_SECP384R1_SHA512_0_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP384R1_SHA512_0_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA512,
	.msg = "sample",
	.msglen = 6,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP384R1_SHA512_0_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP384R1_SHA512_0_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP384R1 */
#endif /* WITH_HASH_SHA512 */

#ifdef WITH_HASH_SHA224
#ifdef WITH_CURVE_SECP384R1
#define DECDSA_SHA224_SECP384R1_SELF_TEST_1
/*** Tests for DECDSA-SHA224/SECP384R1 ***/
static const u8 decdsa_rfc6979_SECP384R1_SHA224_1_test_vector_expected_sig[] = {
	0xe8, 0xc9, 0xd0, 0xb6, 0xea, 0x72, 0xa0, 0xe7,
	0x83, 0x7f, 0xea, 0x1d, 0x14, 0xa1, 0xa9, 0x55,
	0x7f, 0x29, 0xfa, 0xa4, 0x5d, 0x3e, 0x7e, 0xe8,
	0x88, 0xfc, 0x5b, 0xf9, 0x54, 0xb5, 0xe6, 0x24,
	0x64, 0xa9, 0xa8, 0x17, 0xc4, 0x7f, 0xf7, 0x8b,
	0x8c, 0x11, 0x06, 0x6b, 0x24, 0x08, 0x0e, 0x72,
	0x07, 0x04, 0x1d, 0x4a, 0x7a, 0x03, 0x79, 0xac,
	0x72, 0x32, 0xff, 0x72, 0xe6, 0xf7, 0x7b, 0x6d,
	0xdb, 0x8f, 0x09, 0xb1, 0x6c, 0xce, 0x0e, 0xc3,
	0x28, 0x6b, 0x2b, 0xd4, 0x3f, 0xa8, 0xc6, 0x14,
	0x1c, 0x53, 0xea, 0x5a, 0xbe, 0xf0, 0xd8, 0x23,
	0x10, 0x77, 0xa0, 0x45, 0x40, 0xa9, 0x6b, 0x66
};
static const u8 decdsa_rfc6979_SECP384R1_SHA224_1_test_vector_priv_key[] = {
	0x6b, 0x9d, 0x3d, 0xad, 0x2e, 0x1b, 0x8c, 0x1c,
	0x05, 0xb1, 0x98, 0x75, 0xb6, 0x65, 0x9f, 0x4d,
	0xe2, 0x3c, 0x3b, 0x66, 0x7b, 0xf2, 0x97, 0xba,
	0x9a, 0xa4, 0x77, 0x40, 0x78, 0x71, 0x37, 0xd8,
	0x96, 0xd5, 0x72, 0x4e, 0x4c, 0x70, 0xa8, 0x25,
	0xf8, 0x72, 0xc9, 0xea, 0x60, 0xd2, 0xed, 0xf5
};
static const ec_test_case decdsa_rfc6979_SECP384R1_SHA224_1_test_case = {
	.name="DECDSA-SHA224/SECP384R1 1",
	.ec_str_p = &secp384r1_str_params,
	.priv_key = decdsa_rfc6979_SECP384R1_SHA224_1_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP384R1_SHA224_1_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA224,
	.msg = "test",
	.msglen = 4,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP384R1_SHA224_1_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP384R1_SHA224_1_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP384R1 */
#endif /* WITH_HASH_SHA224 */

#ifdef WITH_HASH_SHA256
#ifdef WITH_CURVE_SECP384R1
#define DECDSA_SHA256_SECP384R1_SELF_TEST_1
/*** Tests for DECDSA-SHA256/SECP384R1 ***/
static const u8 decdsa_rfc6979_SECP384R1_SHA256_1_test_vector_expected_sig[] = {
	0x6d, 0x6d, 0xef, 0xac, 0x9a, 0xb6, 0x4d, 0xab,
	0xaf, 0xe3, 0x6c, 0x6b, 0xf5, 0x10, 0x35, 0x2a,
	0x4c, 0xc2, 0x70, 0x01, 0x26, 0x36, 0x38, 0xe5,
	0xb1, 0x6d, 0x9b, 0xb5, 0x1d, 0x45, 0x15, 0x59,
	0xf9, 0x18, 0xee, 0xda, 0xf2, 0x29, 0x3b, 0xe5,
	0xb4, 0x75, 0xcc, 0x8f, 0x01, 0x88, 0x63, 0x6b,
	0x2d, 0x46, 0xf3, 0xbe, 0xcb, 0xcc, 0x52, 0x3d,
	0x5f, 0x1a, 0x12, 0x56, 0xbf, 0x0c, 0x9b, 0x02,
	0x4d, 0x87, 0x9b, 0xa9, 0xe8, 0x38, 0x14, 0x4c,
	0x8b, 0xa6, 0xba, 0xeb, 0x4b, 0x53, 0xb4, 0x7d,
	0x51, 0xab, 0x37, 0x3f, 0x98, 0x45, 0xc0, 0x51,
	0x4e, 0xef, 0xb1, 0x40, 0x24, 0x78, 0x72, 0x65
};
static const u8 decdsa_rfc6979_SECP384R1_SHA256_1_test_vector_priv_key[] = {
	0x6b, 0x9d, 0x3d, 0xad, 0x2e, 0x1b, 0x8c, 0x1c,
	0x05, 0xb1, 0x98, 0x75, 0xb6, 0x65, 0x9f, 0x4d,
	0xe2, 0x3c, 0x3b, 0x66, 0x7b, 0xf2, 0x97, 0xba,
	0x9a, 0xa4, 0x77, 0x40, 0x78, 0x71, 0x37, 0xd8,
	0x96, 0xd5, 0x72, 0x4e, 0x4c, 0x70, 0xa8, 0x25,
	0xf8, 0x72, 0xc9, 0xea, 0x60, 0xd2, 0xed, 0xf5
};
static const ec_test_case decdsa_rfc6979_SECP384R1_SHA256_1_test_case = {
	.name="DECDSA-SHA256/SECP384R1 1",
	.ec_str_p = &secp384r1_str_params,
	.priv_key = decdsa_rfc6979_SECP384R1_SHA256_1_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP384R1_SHA256_1_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA256,
	.msg = "test",
	.msglen = 4,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP384R1_SHA256_1_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP384R1_SHA256_1_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP384R1 */
#endif /* WITH_HASH_SHA256 */

#ifdef WITH_HASH_SHA384
#ifdef WITH_CURVE_SECP384R1
#define DECDSA_SHA384_SECP384R1_SELF_TEST_1
/*** Tests for DECDSA-SHA384/SECP384R1 ***/
static const u8 decdsa_rfc6979_SECP384R1_SHA384_1_test_vector_expected_sig[] = {
	0x82, 0x03, 0xb6, 0x3d, 0x3c, 0x85, 0x3e, 0x8d,
	0x77, 0x22, 0x7f, 0xb3, 0x77, 0xbc, 0xf7, 0xb7,
	0xb7, 0x72, 0xe9, 0x78, 0x92, 0xa8, 0x0f, 0x36,
	0xab, 0x77, 0x5d, 0x50, 0x9d, 0x7a, 0x5f, 0xeb,
	0x05, 0x42, 0xa7, 0xf0, 0x81, 0x29, 0x98, 0xda,
	0x8f, 0x1d, 0xd3, 0xca, 0x3c, 0xf0, 0x23, 0xdb,
	0xdd, 0xd0, 0x76, 0x04, 0x48, 0xd4, 0x2d, 0x8a,
	0x43, 0xaf, 0x45, 0xaf, 0x83, 0x6f, 0xce, 0x4d,
	0xe8, 0xbe, 0x06, 0xb4, 0x85, 0xe9, 0xb6, 0x1b,
	0x82, 0x7c, 0x2f, 0x13, 0x17, 0x39, 0x23, 0xe0,
	0x6a, 0x73, 0x9f, 0x04, 0x06, 0x49, 0xa6, 0x67,
	0xbf, 0x3b, 0x82, 0x82, 0x46, 0xba, 0xa5, 0xa5
};
static const u8 decdsa_rfc6979_SECP384R1_SHA384_1_test_vector_priv_key[] = {
	0x6b, 0x9d, 0x3d, 0xad, 0x2e, 0x1b, 0x8c, 0x1c,
	0x05, 0xb1, 0x98, 0x75, 0xb6, 0x65, 0x9f, 0x4d,
	0xe2, 0x3c, 0x3b, 0x66, 0x7b, 0xf2, 0x97, 0xba,
	0x9a, 0xa4, 0x77, 0x40, 0x78, 0x71, 0x37, 0xd8,
	0x96, 0xd5, 0x72, 0x4e, 0x4c, 0x70, 0xa8, 0x25,
	0xf8, 0x72, 0xc9, 0xea, 0x60, 0xd2, 0xed, 0xf5
};
static const ec_test_case decdsa_rfc6979_SECP384R1_SHA384_1_test_case = {
	.name="DECDSA-SHA384/SECP384R1 1",
	.ec_str_p = &secp384r1_str_params,
	.priv_key = decdsa_rfc6979_SECP384R1_SHA384_1_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP384R1_SHA384_1_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA384,
	.msg = "test",
	.msglen = 4,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP384R1_SHA384_1_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP384R1_SHA384_1_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP384R1 */
#endif /* WITH_HASH_SHA384 */

#ifdef WITH_HASH_SHA512
#ifdef WITH_CURVE_SECP384R1
#define DECDSA_SHA512_SECP384R1_SELF_TEST_1
/*** Tests for DECDSA-SHA512/SECP384R1 ***/
static const u8 decdsa_rfc6979_SECP384R1_SHA512_1_test_vector_expected_sig[] = {
	0xa0, 0xd5, 0xd0, 0x90, 0xc9, 0x98, 0x0f, 0xaf,
	0x3c, 0x2c, 0xe5, 0x7b, 0x7a, 0xe9, 0x51, 0xd3,
	0x19, 0x77, 0xdd, 0x11, 0xc7, 0x75, 0xd3, 0x14,
	0xaf, 0x55, 0xf7, 0x6c, 0x67, 0x64, 0x47, 0xd0,
	0x6f, 0xb6, 0x49, 0x5c, 0xd2, 0x1b, 0x4b, 0x6e,
	0x34, 0x0f, 0xc2, 0x36, 0x58, 0x4f, 0xb2, 0x77,
	0x97, 0x69, 0x84, 0xe5, 0x9b, 0x4c, 0x77, 0xb0,
	0xe8, 0xe4, 0x46, 0x0d, 0xca, 0x3d, 0x9f, 0x20,
	0xe0, 0x7b, 0x9b, 0xb1, 0xf6, 0x3b, 0xee, 0xfa,
	0xf5, 0x76, 0xf6, 0xb2, 0xe8, 0xb2, 0x24, 0x63,
	0x4a, 0x20, 0x92, 0xcd, 0x37, 0x92, 0xe0, 0x15,
	0x9a, 0xd9, 0xce, 0xe3, 0x76, 0x59, 0xc7, 0x36
};
static const u8 decdsa_rfc6979_SECP384R1_SHA512_1_test_vector_priv_key[] = {
	0x6b, 0x9d, 0x3d, 0xad, 0x2e, 0x1b, 0x8c, 0x1c,
	0x05, 0xb1, 0x98, 0x75, 0xb6, 0x65, 0x9f, 0x4d,
	0xe2, 0x3c, 0x3b, 0x66, 0x7b, 0xf2, 0x97, 0xba,
	0x9a, 0xa4, 0x77, 0x40, 0x78, 0x71, 0x37, 0xd8,
	0x96, 0xd5, 0x72, 0x4e, 0x4c, 0x70, 0xa8, 0x25,
	0xf8, 0x72, 0xc9, 0xea, 0x60, 0xd2, 0xed, 0xf5
};
static const ec_test_case decdsa_rfc6979_SECP384R1_SHA512_1_test_case = {
	.name="DECDSA-SHA512/SECP384R1 1",
	.ec_str_p = &secp384r1_str_params,
	.priv_key = decdsa_rfc6979_SECP384R1_SHA512_1_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP384R1_SHA512_1_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA512,
	.msg = "test",
	.msglen = 4,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP384R1_SHA512_1_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP384R1_SHA512_1_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP384R1 */
#endif /* WITH_HASH_SHA512 */

#ifdef WITH_HASH_SHA224
#ifdef WITH_CURVE_SECP521R1
#define DECDSA_SHA224_SECP521R1_SELF_TEST_0
/*** Tests for DECDSA-SHA224/SECP521R1 ***/
static const u8 decdsa_rfc6979_SECP521R1_SHA224_0_test_vector_expected_sig[] = {
	0x01, 0x77, 0x63, 0x31, 0xcf, 0xcd, 0xf9, 0x27,
	0xd6, 0x66, 0xe0, 0x32, 0xe0, 0x0c, 0xf7, 0x76,
	0x18, 0x7b, 0xc9, 0xfd, 0xd8, 0xe6, 0x9d, 0x0d,
	0xab, 0xb4, 0x10, 0x9f, 0xfe, 0x1b, 0x5e, 0x2a,
	0x30, 0x71, 0x5f, 0x4c, 0xc9, 0x23, 0xa4, 0xa5,
	0xe9, 0x4d, 0x25, 0x03, 0xe9, 0xac, 0xfe, 0xd9,
	0x28, 0x57, 0xb7, 0xf3, 0x1d, 0x71, 0x52, 0xe0,
	0xf8, 0xc0, 0x0c, 0x15, 0xff, 0x3d, 0x87, 0xe2,
	0xed, 0x2e, 0x00, 0x50, 0xcb, 0x52, 0x65, 0x41,
	0x7f, 0xe2, 0x32, 0x0b, 0xbb, 0x5a, 0x12, 0x2b,
	0x8e, 0x1a, 0x32, 0xbd, 0x69, 0x90, 0x89, 0x85,
	0x11, 0x28, 0xe3, 0x60, 0xe6, 0x20, 0xa3, 0x0c,
	0x7e, 0x17, 0xba, 0x41, 0xa6, 0x66, 0xaf, 0x12,
	0x6c, 0xe1, 0x00, 0xe5, 0x79, 0x9b, 0x15, 0x3b,
	0x60, 0x52, 0x8d, 0x53, 0x00, 0xd0, 0x84, 0x89,
	0xca, 0x91, 0x78, 0xfb, 0x61, 0x0a, 0x20, 0x06,
	0xc2, 0x54, 0xb4, 0x1f
};
static const u8 decdsa_rfc6979_SECP521R1_SHA224_0_test_vector_priv_key[] = {
	0x00, 0xfa, 0xd0, 0x6d, 0xaa, 0x62, 0xba, 0x3b,
	0x25, 0xd2, 0xfb, 0x40, 0x13, 0x3d, 0xa7, 0x57,
	0x20, 0x5d, 0xe6, 0x7f, 0x5b, 0xb0, 0x01, 0x8f,
	0xee, 0x8c, 0x86, 0xe1, 0xb6, 0x8c, 0x7e, 0x75,
	0xca, 0xa8, 0x96, 0xeb, 0x32, 0xf1, 0xf4, 0x7c,
	0x70, 0x85, 0x58, 0x36, 0xa6, 0xd1, 0x6f, 0xcc,
	0x14, 0x66, 0xf6, 0xd8, 0xfb, 0xec, 0x67, 0xdb,
	0x89, 0xec, 0x0c, 0x08, 0xb0, 0xe9, 0x96, 0xb8,
	0x35, 0x38
};
static const ec_test_case decdsa_rfc6979_SECP521R1_SHA224_0_test_case = {
	.name="DECDSA-SHA224/SECP521R1 0",
	.ec_str_p = &secp521r1_str_params,
	.priv_key = decdsa_rfc6979_SECP521R1_SHA224_0_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP521R1_SHA224_0_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA224,
	.msg = "sample",
	.msglen = 6,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP521R1_SHA224_0_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP521R1_SHA224_0_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP521R1 */
#endif /* WITH_HASH_SHA224 */

#ifdef WITH_HASH_SHA256
#ifdef WITH_CURVE_SECP521R1
#define DECDSA_SHA256_SECP521R1_SELF_TEST_0
/*** Tests for DECDSA-SHA256/SECP521R1 ***/
static const u8 decdsa_rfc6979_SECP521R1_SHA256_0_test_vector_expected_sig[] = {
	0x01, 0x51, 0x1b, 0xb4, 0xd6, 0x75, 0x11, 0x4f,
	0xe2, 0x66, 0xfc, 0x43, 0x72, 0xb8, 0x76, 0x82,
	0xba, 0xec, 0xc0, 0x1d, 0x3c, 0xc6, 0x2c, 0xf2,
	0x30, 0x3c, 0x92, 0xb3, 0x52, 0x60, 0x12, 0x65,
	0x9d, 0x16, 0x87, 0x6e, 0x25, 0xc7, 0xc1, 0xe5,
	0x76, 0x48, 0xf2, 0x3b, 0x73, 0x56, 0x4d, 0x67,
	0xf6, 0x1c, 0x6f, 0x14, 0xd5, 0x27, 0xd5, 0x49,
	0x72, 0x81, 0x04, 0x21, 0xe7, 0xd8, 0x75, 0x89,
	0xe1, 0xa7, 0x00, 0x4a, 0x17, 0x11, 0x43, 0xa8,
	0x31, 0x63, 0xd6, 0xdf, 0x46, 0x0a, 0xaf, 0x61,
	0x52, 0x26, 0x95, 0xf2, 0x07, 0xa5, 0x8b, 0x95,
	0xc0, 0x64, 0x4d, 0x87, 0xe5, 0x2a, 0xa1, 0xa3,
	0x47, 0x91, 0x6e, 0x4f, 0x7a, 0x72, 0x93, 0x0b,
	0x1b, 0xc0, 0x6d, 0xbe, 0x22, 0xce, 0x3f, 0x58,
	0x26, 0x4a, 0xfd, 0x23, 0x70, 0x4c, 0xbb, 0x63,
	0xb2, 0x9b, 0x93, 0x1f, 0x7d, 0xe6, 0xc9, 0xd9,
	0x49, 0xa7, 0xec, 0xfc
};
static const u8 decdsa_rfc6979_SECP521R1_SHA256_0_test_vector_priv_key[] = {
	0x00, 0xfa, 0xd0, 0x6d, 0xaa, 0x62, 0xba, 0x3b,
	0x25, 0xd2, 0xfb, 0x40, 0x13, 0x3d, 0xa7, 0x57,
	0x20, 0x5d, 0xe6, 0x7f, 0x5b, 0xb0, 0x01, 0x8f,
	0xee, 0x8c, 0x86, 0xe1, 0xb6, 0x8c, 0x7e, 0x75,
	0xca, 0xa8, 0x96, 0xeb, 0x32, 0xf1, 0xf4, 0x7c,
	0x70, 0x85, 0x58, 0x36, 0xa6, 0xd1, 0x6f, 0xcc,
	0x14, 0x66, 0xf6, 0xd8, 0xfb, 0xec, 0x67, 0xdb,
	0x89, 0xec, 0x0c, 0x08, 0xb0, 0xe9, 0x96, 0xb8,
	0x35, 0x38
};
static const ec_test_case decdsa_rfc6979_SECP521R1_SHA256_0_test_case = {
	.name="DECDSA-SHA256/SECP521R1 0",
	.ec_str_p = &secp521r1_str_params,
	.priv_key = decdsa_rfc6979_SECP521R1_SHA256_0_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP521R1_SHA256_0_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA256,
	.msg = "sample",
	.msglen = 6,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP521R1_SHA256_0_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP521R1_SHA256_0_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP521R1 */
#endif /* WITH_HASH_SHA256 */

#ifdef WITH_HASH_SHA384
#ifdef WITH_CURVE_SECP521R1
#define DECDSA_SHA384_SECP521R1_SELF_TEST_0
/*** Tests for DECDSA-SHA384/SECP521R1 ***/
static const u8 decdsa_rfc6979_SECP521R1_SHA384_0_test_vector_expected_sig[] = {
	0x01, 0xea, 0x84, 0x2a, 0x0e, 0x17, 0xd2, 0xde,
	0x4f, 0x92, 0xc1, 0x53, 0x15, 0xc6, 0x3d, 0xdf,
	0x72, 0x68, 0x5c, 0x18, 0x19, 0x5c, 0x2b, 0xb9,
	0x5e, 0x57, 0x2b, 0x9c, 0x51, 0x36, 0xca, 0x4b,
	0x4b, 0x57, 0x6a, 0xd7, 0x12, 0xa5, 0x2b, 0xe9,
	0x73, 0x06, 0x27, 0xd1, 0x60, 0x54, 0xba, 0x40,
	0xcc, 0x0b, 0x8d, 0x3f, 0xf0, 0x35, 0xb1, 0x2a,
	0xe7, 0x51, 0x68, 0x39, 0x7f, 0x5d, 0x50, 0xc6,
	0x74, 0x51, 0x01, 0xf2, 0x1a, 0x3c, 0xee, 0x06,
	0x6e, 0x19, 0x61, 0x02, 0x5f, 0xb0, 0x48, 0xbd,
	0x5f, 0xe2, 0xb7, 0x92, 0x4d, 0x0c, 0xd7, 0x97,
	0xba, 0xbe, 0x0a, 0x83, 0xb6, 0x6f, 0x1e, 0x35,
	0xee, 0xaf, 0x5f, 0xde, 0x14, 0x3f, 0xa8, 0x5d,
	0xc3, 0x94, 0xa7, 0xde, 0xe7, 0x66, 0x52, 0x33,
	0x93, 0x78, 0x44, 0x84, 0xbd, 0xf3, 0xe0, 0x01,
	0x14, 0xa1, 0xc8, 0x57, 0xcd, 0xe1, 0xaa, 0x20,
	0x3d, 0xb6, 0x5d, 0x61
};
static const u8 decdsa_rfc6979_SECP521R1_SHA384_0_test_vector_priv_key[] = {
	0x00, 0xfa, 0xd0, 0x6d, 0xaa, 0x62, 0xba, 0x3b,
	0x25, 0xd2, 0xfb, 0x40, 0x13, 0x3d, 0xa7, 0x57,
	0x20, 0x5d, 0xe6, 0x7f, 0x5b, 0xb0, 0x01, 0x8f,
	0xee, 0x8c, 0x86, 0xe1, 0xb6, 0x8c, 0x7e, 0x75,
	0xca, 0xa8, 0x96, 0xeb, 0x32, 0xf1, 0xf4, 0x7c,
	0x70, 0x85, 0x58, 0x36, 0xa6, 0xd1, 0x6f, 0xcc,
	0x14, 0x66, 0xf6, 0xd8, 0xfb, 0xec, 0x67, 0xdb,
	0x89, 0xec, 0x0c, 0x08, 0xb0, 0xe9, 0x96, 0xb8,
	0x35, 0x38
};
static const ec_test_case decdsa_rfc6979_SECP521R1_SHA384_0_test_case = {
	.name="DECDSA-SHA384/SECP521R1 0",
	.ec_str_p = &secp521r1_str_params,
	.priv_key = decdsa_rfc6979_SECP521R1_SHA384_0_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP521R1_SHA384_0_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA384,
	.msg = "sample",
	.msglen = 6,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP521R1_SHA384_0_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP521R1_SHA384_0_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP521R1 */
#endif /* WITH_HASH_SHA384 */

#ifdef WITH_HASH_SHA512
#ifdef WITH_CURVE_SECP521R1
#define DECDSA_SHA512_SECP521R1_SELF_TEST_0
/*** Tests for DECDSA-SHA512/SECP521R1 ***/
static const u8 decdsa_rfc6979_SECP521R1_SHA512_0_test_vector_expected_sig[] = {
	0x00, 0xc3, 0x28, 0xfa, 0xfc, 0xbd, 0x79, 0xdd,
	0x77, 0x85, 0x03, 0x70, 0xc4, 0x63, 0x25, 0xd9,
	0x87, 0xcb, 0x52, 0x55, 0x69, 0xfb, 0x63, 0xc5,
	0xd3, 0xbc, 0x53, 0x95, 0x0e, 0x6d, 0x4c, 0x5f,
	0x17, 0x4e, 0x25, 0xa1, 0xee, 0x90, 0x17, 0xb5,
	0xd4, 0x50, 0x60, 0x6a, 0xdd, 0x15, 0x2b, 0x53,
	0x49, 0x31, 0xd7, 0xd4, 0xe8, 0x45, 0x5c, 0xc9,
	0x1f, 0x9b, 0x15, 0xbf, 0x05, 0xec, 0x36, 0xe3,
	0x77, 0xfa, 0x00, 0x61, 0x7c, 0xce, 0x7c, 0xf5,
	0x06, 0x48, 0x06, 0xc4, 0x67, 0xf6, 0x78, 0xd3,
	0xb4, 0x08, 0x0d, 0x6f, 0x1c, 0xc5, 0x0a, 0xf2,
	0x6c, 0xa2, 0x09, 0x41, 0x73, 0x08, 0x28, 0x1b,
	0x68, 0xaf, 0x28, 0x26, 0x23, 0xea, 0xa6, 0x3e,
	0x5b, 0x5c, 0x07, 0x23, 0xd8, 0xb8, 0xc3, 0x7f,
	0xf0, 0x77, 0x7b, 0x1a, 0x20, 0xf8, 0xcc, 0xb1,
	0xdc, 0xcc, 0x43, 0x99, 0x7f, 0x1e, 0xe0, 0xe4,
	0x4d, 0xa4, 0xa6, 0x7a
};
static const u8 decdsa_rfc6979_SECP521R1_SHA512_0_test_vector_priv_key[] = {
	0x00, 0xfa, 0xd0, 0x6d, 0xaa, 0x62, 0xba, 0x3b,
	0x25, 0xd2, 0xfb, 0x40, 0x13, 0x3d, 0xa7, 0x57,
	0x20, 0x5d, 0xe6, 0x7f, 0x5b, 0xb0, 0x01, 0x8f,
	0xee, 0x8c, 0x86, 0xe1, 0xb6, 0x8c, 0x7e, 0x75,
	0xca, 0xa8, 0x96, 0xeb, 0x32, 0xf1, 0xf4, 0x7c,
	0x70, 0x85, 0x58, 0x36, 0xa6, 0xd1, 0x6f, 0xcc,
	0x14, 0x66, 0xf6, 0xd8, 0xfb, 0xec, 0x67, 0xdb,
	0x89, 0xec, 0x0c, 0x08, 0xb0, 0xe9, 0x96, 0xb8,
	0x35, 0x38
};
static const ec_test_case decdsa_rfc6979_SECP521R1_SHA512_0_test_case = {
	.name="DECDSA-SHA512/SECP521R1 0",
	.ec_str_p = &secp521r1_str_params,
	.priv_key = decdsa_rfc6979_SECP521R1_SHA512_0_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP521R1_SHA512_0_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA512,
	.msg = "sample",
	.msglen = 6,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP521R1_SHA512_0_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP521R1_SHA512_0_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP521R1 */
#endif /* WITH_HASH_SHA512 */

#ifdef WITH_HASH_SHA224
#ifdef WITH_CURVE_SECP521R1
#define DECDSA_SHA224_SECP521R1_SELF_TEST_1
/*** Tests for DECDSA-SHA224/SECP521R1 ***/
static const u8 decdsa_rfc6979_SECP521R1_SHA224_1_test_vector_expected_sig[] = {
	0x01, 0xc7, 0xed, 0x90, 0x2e, 0x12, 0x3e, 0x68,
	0x15, 0x54, 0x60, 0x65, 0xa2, 0xc4, 0xaf, 0x97,
	0x7b, 0x22, 0xaa, 0x8e, 0xad, 0xdb, 0x68, 0xb2,
	0xc1, 0x11, 0x0e, 0x7e, 0xa4, 0x4d, 0x42, 0x08,
	0x6b, 0xfe, 0x4a, 0x34, 0xb6, 0x7d, 0xdc, 0x0e,
	0x17, 0xe9, 0x65, 0x36, 0xe3, 0x58, 0x21, 0x9b,
	0x23, 0xa7, 0x06, 0xc6, 0xa6, 0xe1, 0x6b, 0xa7,
	0x7b, 0x65, 0xe1, 0xc5, 0x95, 0xd4, 0x3c, 0xae,
	0x17, 0xfb, 0x01, 0x77, 0x33, 0x66, 0x76, 0x30,
	0x4f, 0xcb, 0x34, 0x3c, 0xe0, 0x28, 0xb3, 0x8e,
	0x7b, 0x4f, 0xba, 0x76, 0xc1, 0xc1, 0xb2, 0x77,
	0xda, 0x18, 0xca, 0xd2, 0xa8, 0x47, 0x8b, 0x2a,
	0x9a, 0x9f, 0x5b, 0xec, 0x0f, 0x3b, 0xa0, 0x4f,
	0x35, 0xdb, 0x3e, 0x42, 0x63, 0x56, 0x9e, 0xc6,
	0xaa, 0xde, 0x8c, 0x92, 0x74, 0x6e, 0x4c, 0x82,
	0xf8, 0x29, 0x9a, 0xe1, 0xb8, 0xf1, 0x73, 0x9f,
	0x8f, 0xd5, 0x19, 0xa4
};
static const u8 decdsa_rfc6979_SECP521R1_SHA224_1_test_vector_priv_key[] = {
	0x00, 0xfa, 0xd0, 0x6d, 0xaa, 0x62, 0xba, 0x3b,
	0x25, 0xd2, 0xfb, 0x40, 0x13, 0x3d, 0xa7, 0x57,
	0x20, 0x5d, 0xe6, 0x7f, 0x5b, 0xb0, 0x01, 0x8f,
	0xee, 0x8c, 0x86, 0xe1, 0xb6, 0x8c, 0x7e, 0x75,
	0xca, 0xa8, 0x96, 0xeb, 0x32, 0xf1, 0xf4, 0x7c,
	0x70, 0x85, 0x58, 0x36, 0xa6, 0xd1, 0x6f, 0xcc,
	0x14, 0x66, 0xf6, 0xd8, 0xfb, 0xec, 0x67, 0xdb,
	0x89, 0xec, 0x0c, 0x08, 0xb0, 0xe9, 0x96, 0xb8,
	0x35, 0x38
};
static const ec_test_case decdsa_rfc6979_SECP521R1_SHA224_1_test_case = {
	.name="DECDSA-SHA224/SECP521R1 1",
	.ec_str_p = &secp521r1_str_params,
	.priv_key = decdsa_rfc6979_SECP521R1_SHA224_1_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP521R1_SHA224_1_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA224,
	.msg = "test",
	.msglen = 4,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP521R1_SHA224_1_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP521R1_SHA224_1_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP521R1 */
#endif /* WITH_HASH_SHA224 */

#ifdef WITH_HASH_SHA256
#ifdef WITH_CURVE_SECP521R1
#define DECDSA_SHA256_SECP521R1_SELF_TEST_1
/*** Tests for DECDSA-SHA256/SECP521R1 ***/
static const u8 decdsa_rfc6979_SECP521R1_SHA256_1_test_vector_expected_sig[] = {
	0x00, 0x0e, 0x87, 0x1c, 0x4a, 0x14, 0xf9, 0x93,
	0xc6, 0xc7, 0x36, 0x95, 0x01, 0x90, 0x0c, 0x4b,
	0xc1, 0xe9, 0xc7, 0xb0, 0xb4, 0xba, 0x44, 0xe0,
	0x48, 0x68, 0xb3, 0x0b, 0x41, 0xd8, 0x07, 0x10,
	0x42, 0xeb, 0x28, 0xc4, 0xc2, 0x50, 0x41, 0x1d,
	0x0c, 0xe0, 0x8c, 0xd1, 0x97, 0xe4, 0x18, 0x8e,
	0xa4, 0x87, 0x6f, 0x27, 0x9f, 0x90, 0xb3, 0xd8,
	0xd7, 0x4a, 0x3c, 0x76, 0xe6, 0xf1, 0xe4, 0x65,
	0x6a, 0xa8, 0x00, 0xcd, 0x52, 0xdb, 0xaa, 0x33,
	0xb0, 0x63, 0xc3, 0xa6, 0xcd, 0x80, 0x58, 0xa1,
	0xfb, 0x0a, 0x46, 0xa4, 0x75, 0x4b, 0x03, 0x4f,
	0xcc, 0x64, 0x47, 0x66, 0xca, 0x14, 0xda, 0x8c,
	0xa5, 0xca, 0x9f, 0xde, 0x00, 0xe8, 0x8c, 0x1a,
	0xd6, 0x0c, 0xcb, 0xa7, 0x59, 0x02, 0x52, 0x99,
	0x07, 0x9d, 0x7a, 0x42, 0x7e, 0xc3, 0xcc, 0x5b,
	0x61, 0x9b, 0xfb, 0xc8, 0x28, 0xe7, 0x76, 0x9b,
	0xcd, 0x69, 0x4e, 0x86
};
static const u8 decdsa_rfc6979_SECP521R1_SHA256_1_test_vector_priv_key[] = {
	0x00, 0xfa, 0xd0, 0x6d, 0xaa, 0x62, 0xba, 0x3b,
	0x25, 0xd2, 0xfb, 0x40, 0x13, 0x3d, 0xa7, 0x57,
	0x20, 0x5d, 0xe6, 0x7f, 0x5b, 0xb0, 0x01, 0x8f,
	0xee, 0x8c, 0x86, 0xe1, 0xb6, 0x8c, 0x7e, 0x75,
	0xca, 0xa8, 0x96, 0xeb, 0x32, 0xf1, 0xf4, 0x7c,
	0x70, 0x85, 0x58, 0x36, 0xa6, 0xd1, 0x6f, 0xcc,
	0x14, 0x66, 0xf6, 0xd8, 0xfb, 0xec, 0x67, 0xdb,
	0x89, 0xec, 0x0c, 0x08, 0xb0, 0xe9, 0x96, 0xb8,
	0x35, 0x38
};
static const ec_test_case decdsa_rfc6979_SECP521R1_SHA256_1_test_case = {
	.name="DECDSA-SHA256/SECP521R1 1",
	.ec_str_p = &secp521r1_str_params,
	.priv_key = decdsa_rfc6979_SECP521R1_SHA256_1_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP521R1_SHA256_1_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA256,
	.msg = "test",
	.msglen = 4,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP521R1_SHA256_1_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP521R1_SHA256_1_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP521R1 */
#endif /* WITH_HASH_SHA256 */

#ifdef WITH_HASH_SHA384
#ifdef WITH_CURVE_SECP521R1
#define DECDSA_SHA384_SECP521R1_SELF_TEST_1
/*** Tests for DECDSA-SHA384/SECP521R1 ***/
static const u8 decdsa_rfc6979_SECP521R1_SHA384_1_test_vector_expected_sig[] = {
	0x01, 0x4b, 0xee, 0x21, 0xa1, 0x8b, 0x6d, 0x8b,
	0x3c, 0x93, 0xfa, 0xb0, 0x8d, 0x43, 0xe7, 0x39,
	0x70, 0x79, 0x53, 0x24, 0x4f, 0xdb, 0xe9, 0x24,
	0xfa, 0x92, 0x6d, 0x76, 0x66, 0x9e, 0x7a, 0xc8,
	0xc8, 0x9d, 0xf6, 0x2e, 0xd8, 0x97, 0x5c, 0x2d,
	0x83, 0x97, 0xa6, 0x5a, 0x49, 0xdc, 0xc0, 0x9f,
	0x6b, 0x0a, 0xc6, 0x22, 0x72, 0x74, 0x19, 0x24,
	0xd4, 0x79, 0x35, 0x4d, 0x74, 0xff, 0x60, 0x75,
	0x57, 0x8c, 0x01, 0x33, 0x33, 0x08, 0x65, 0xc0,
	0x67, 0xa0, 0xea, 0xf7, 0x23, 0x62, 0xa6, 0x5e,
	0x2d, 0x7b, 0xc4, 0xe4, 0x61, 0xe8, 0xc8, 0x99,
	0x5c, 0x3b, 0x62, 0x26, 0xa2, 0x1b, 0xd1, 0xaa,
	0x78, 0xf0, 0xed, 0x94, 0xfe, 0x53, 0x6a, 0x0d,
	0xca, 0x35, 0x53, 0x4f, 0x0c, 0xd1, 0x51, 0x0c,
	0x41, 0x52, 0x5d, 0x16, 0x3f, 0xe9, 0xd7, 0x4d,
	0x13, 0x48, 0x81, 0xe3, 0x51, 0x41, 0xed, 0x5e,
	0x8e, 0x95, 0xb9, 0x79
};
static const u8 decdsa_rfc6979_SECP521R1_SHA384_1_test_vector_priv_key[] = {
	0x00, 0xfa, 0xd0, 0x6d, 0xaa, 0x62, 0xba, 0x3b,
	0x25, 0xd2, 0xfb, 0x40, 0x13, 0x3d, 0xa7, 0x57,
	0x20, 0x5d, 0xe6, 0x7f, 0x5b, 0xb0, 0x01, 0x8f,
	0xee, 0x8c, 0x86, 0xe1, 0xb6, 0x8c, 0x7e, 0x75,
	0xca, 0xa8, 0x96, 0xeb, 0x32, 0xf1, 0xf4, 0x7c,
	0x70, 0x85, 0x58, 0x36, 0xa6, 0xd1, 0x6f, 0xcc,
	0x14, 0x66, 0xf6, 0xd8, 0xfb, 0xec, 0x67, 0xdb,
	0x89, 0xec, 0x0c, 0x08, 0xb0, 0xe9, 0x96, 0xb8,
	0x35, 0x38
};
static const ec_test_case decdsa_rfc6979_SECP521R1_SHA384_1_test_case = {
	.name="DECDSA-SHA384/SECP521R1 1",
	.ec_str_p = &secp521r1_str_params,
	.priv_key = decdsa_rfc6979_SECP521R1_SHA384_1_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP521R1_SHA384_1_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA384,
	.msg = "test",
	.msglen = 4,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP521R1_SHA384_1_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP521R1_SHA384_1_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP521R1 */
#endif /* WITH_HASH_SHA384 */

#ifdef WITH_HASH_SHA512
#ifdef WITH_CURVE_SECP521R1
#define DECDSA_SHA512_SECP521R1_SELF_TEST_1
/*** Tests for DECDSA-SHA512/SECP521R1 ***/
static const u8 decdsa_rfc6979_SECP521R1_SHA512_1_test_vector_expected_sig[] = {
	0x01, 0x3e, 0x99, 0x02, 0x0a, 0xbf, 0x5c, 0xee,
	0x75, 0x25, 0xd1, 0x6b, 0x69, 0xb2, 0x29, 0x65,
	0x2a, 0xb6, 0xbd, 0xf2, 0xaf, 0xfc, 0xae, 0xf3,
	0x87, 0x73, 0xb4, 0xb7, 0xd0, 0x87, 0x25, 0xf1,
	0x0c, 0xdb, 0x93, 0x48, 0x2f, 0xdc, 0xc5, 0x4e,
	0xdc, 0xee, 0x91, 0xec, 0xa4, 0x16, 0x6b, 0x2a,
	0x7c, 0x62, 0x65, 0xef, 0x0c, 0xe2, 0xbd, 0x70,
	0x51, 0xb7, 0xce, 0xf9, 0x45, 0xba, 0xbd, 0x47,
	0xee, 0x6d, 0x01, 0xfb, 0xd0, 0x01, 0x3c, 0x67,
	0x4a, 0xa7, 0x9c, 0xb3, 0x98, 0x49, 0x52, 0x79,
	0x16, 0xce, 0x30, 0x1c, 0x66, 0xea, 0x7c, 0xe8,
	0xb8, 0x06, 0x82, 0x78, 0x6a, 0xd6, 0x0f, 0x98,
	0xf7, 0xe7, 0x8a, 0x19, 0xca, 0x69, 0xef, 0xf5,
	0xc5, 0x74, 0x00, 0xe3, 0xb3, 0xa0, 0xad, 0x66,
	0xce, 0x09, 0x78, 0x21, 0x4d, 0x13, 0xba, 0xf4,
	0xe9, 0xac, 0x60, 0x75, 0x2f, 0x7b, 0x15, 0x5e,
	0x2d, 0xe4, 0xdc, 0xe3
};
static const u8 decdsa_rfc6979_SECP521R1_SHA512_1_test_vector_priv_key[] = {
	0x00, 0xfa, 0xd0, 0x6d, 0xaa, 0x62, 0xba, 0x3b,
	0x25, 0xd2, 0xfb, 0x40, 0x13, 0x3d, 0xa7, 0x57,
	0x20, 0x5d, 0xe6, 0x7f, 0x5b, 0xb0, 0x01, 0x8f,
	0xee, 0x8c, 0x86, 0xe1, 0xb6, 0x8c, 0x7e, 0x75,
	0xca, 0xa8, 0x96, 0xeb, 0x32, 0xf1, 0xf4, 0x7c,
	0x70, 0x85, 0x58, 0x36, 0xa6, 0xd1, 0x6f, 0xcc,
	0x14, 0x66, 0xf6, 0xd8, 0xfb, 0xec, 0x67, 0xdb,
	0x89, 0xec, 0x0c, 0x08, 0xb0, 0xe9, 0x96, 0xb8,
	0x35, 0x38
};
static const ec_test_case decdsa_rfc6979_SECP521R1_SHA512_1_test_case = {
	.name="DECDSA-SHA512/SECP521R1 1",
	.ec_str_p = &secp521r1_str_params,
	.priv_key = decdsa_rfc6979_SECP521R1_SHA512_1_test_vector_priv_key,
	.priv_key_len = sizeof(decdsa_rfc6979_SECP521R1_SHA512_1_test_vector_priv_key),
	.nn_random = NULL,
	.hash_type = SHA512,
	.msg = "test",
	.msglen = 4,
	.sig_type = DECDSA,
	.exp_sig = decdsa_rfc6979_SECP521R1_SHA512_1_test_vector_expected_sig,
	.exp_siglen = sizeof(decdsa_rfc6979_SECP521R1_SHA512_1_test_vector_expected_sig),
};
#endif /* WITH_CURVE_SECP521R1 */
#endif /* WITH_HASH_SHA512 */

