module Main where

import Text.XML.Light
import Text.Feed.Types
import Text.Feed.Import
import Text.Feed.Export

import System.Environment

pFromFile :: FilePath -> IO Feed
pFromFile fp = do
  ls <- readFile fp
  case parseFeedString ls of
    Nothing -> fail ("parseFeedFromFile: not a well-formed XML content in: " ++ fp)
    Just f  -> return f

main :: IO ()
main = do
  (x:_) <- getArgs
  feed  <- pFromFile x
  putStrLn (ppTopElement $ xmlFeed feed)
