{-# Language FlexibleContexts, FlexibleInstances, MultiParamTypeClasses, UndecidableInstances #-}
{-# OPTIONS_GHC -fno-warn-orphans #-}
module Data.Generics.SYB.WithClass.Instances.Text where

import Data.Generics.SYB.WithClass.Basics
import qualified Data.Text      as S
import qualified Data.Text.Lazy as L

instance (Data ctx String, Sat (ctx S.Text)) =>
         Data ctx S.Text where
  gfoldl _ f z txt = z S.pack `f` (S.unpack txt)           
  toConstr _ _     = error "Data.Generics.SYB.WithClass.Instances.Text:toConstr S.Text"
  gunfold _ _      = error "Data.Generics.SYB.WithClass.Instances.Text:gunfold S.Text"
  dataTypeOf _ _   = mkNorepType "Data.Text.Text"  
  
instance (Data ctx String, Sat (ctx L.Text)) =>
         Data ctx L.Text where
  gfoldl _ f z txt = z L.pack `f` (L.unpack txt)           
  toConstr _ _     = error "Data.Generics.SYB.WithClass.Instances.Text:toConstr L.Text"
  gunfold _ _      = error "Data.Generics.SYB.WithClass.Instances.Text:gunfold L.Text"
  dataTypeOf _ _   = mkNorepType "Data.Text.Lazy.Text"
