#!/bin/csh -f
#-----------------------------------------------------------------------------
# file:         cleanup.csh
#
# description:
#       Shell script to cleanup all the files produced by testing (these files
#       include driver output files, difference files and old binaries).
#
# usage:
#       cleanup.csh [GROUP1 GROUP2]  (ex. cleanup.csh point grid)
#
# author:
#       Jason R. Watts / Hughes Applied Information Systems
#       Abe Taaheri / Raytheon IIS
# history:
#       26-Jul-1995 JRW Initial version
#       11-Jul-2014 AT  Initial version for hdfeos2
#----------------------------------------------------------------------------

# set the tool group directories to be cleaned
# If no tool groups are input on the command line,
# then clean all of the groups.

if ($#argv > 0) then
    set TOOL_GRPS = ($argv)
else
    set TOOL_GRPS = (point grid swath)
endif


# loop through each group and cleanup that directory

foreach group ($TOOL_GRPS)

        if (-d $HDFEOS2_TST_SRC/$group) then

            echo ""; echo "Removing test files in $HDFEOS2_TST_SRC/$group ..."; echo ""
            cd $HDFEOS2_TST_SRC/$group
            \rm -f *.txtout *.diff *out *out.* *_f *_c core *.o
        endif
end

