# Copyright (c) 2008, 2012 Oracle and/or its affiliates. All rights reserved.
# Use is subject to license terms.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301
# USA

# Suggested use:
# 1. Use this grammar (current_timestamp_6.yy) in combination with current_timestamp_6.zz as gendata file
# 2. Use a duration of 300 to 600 seconds. Short durations ensure fresh/plenty data in the tables
# 3. For use with combinations.pl (assuming a high-end testing server):
#    - 10 RQG threads (--parallel=10) with one SQL thread (--threads=1) for single threaded testing
#    - 8 RQG threads (--parallel=8) with 2-3 SQL threads (--threads=3) for multi threaded testing
#    - Both these over many (400+) trials, both in normal and Valgrind mode, to catch most issues
# 4. Make sure to use --freeze-time option to RQG when using this grammar for Transformer checking
# 5. Make sure to use --strict_fields option to RQG to allow for advanced syntax in current_timestamp_6.zz
# 6. Make sure to use --short_column_names option to RQG to avoid overly long column names generated by
#    current_timestamp_6.zz
# 7. Make sure to use --mysqld=--default-time-zone=UTC option to RQG
# 8. Do not use the --engines option, storage engine assignent is done in current_timestamp_6.zz

query:
	select | insert | insert | insert | delete | replace | update | transaction | 
	wl_query | wl_query | wl_query | wl_query | wl_query | wl_query | wl_query |
	wl_query | wl_query | wl_query | wl_query | wl_query | wl_query | wl_query ;
	
wl_query:
	alter | proc_func | views | outfile_infile | insert_delayed | insert_on_dup | update_multi | create_table ;

transaction:
	| | START TRANSACTION | COMMIT | ROLLBACK | SAVEPOINT A | ROLLBACK TO SAVEPOINT A | FLUSH TABLES ;

select:
	SELECT select_item FROM _table where order_by limit ;
	
select_item:
	_field | _field null | _field op _field | _field sign _field | select_item, _field ;
	
where:
	| WHERE _field sign value ;

order_by:
	| ORDER BY _field ;

limit:
	| LIMIT _digit ;
	
null:
	IS NULL | IS NOT NULL ;

op:
	+ | / | DIV ;   # - | * | removed due to BIGINT bug (ERROR 1690 (22003): BIGINT UNSIGNED value is out of range)
	
sign:
	< | > | = | >= | <= | <> | != ;

insert:
	INSERT IGNORE INTO _table ( _field , _field , _field ) VALUES ( value , value , value ) |
	INSERT IGNORE INTO _table ( _field_no_pk , _field_no_pk , _field_no_pk ) VALUES ( value , value , value ) ;

insert_delayed:
	INSERT priority_insert ign INTO _table ( _field , _field , _field ) VALUES ( value , value , value ) |
	INSERT priority_insert ign INTO _table ( _field_no_pk , _field_no_pk , _field_no_pk ) VALUES ( value , value , value ) ;
	
insert_on_dup:
	INSERT priority_insert ign INTO _table ( _field ) VALUES ( value ) ON DUPLICATE KEY UPDATE _field_no_pk = value |
	INSERT ign INTO _table ( _field ) VALUES ( value ) ON DUPLICATE KEY UPDATE _field_no_pk = value |
	INSERT priority_insert ign INTO _table ( _field ) VALUES ( value ) ON DUPLICATE KEY UPDATE _field = value ;
	
priority_insert:
	LOW_PRIORITY | DELAYED | DELAYED | DELAYED | DELAYED | DELAYED | DELAYED | DELAYED | DELAYED | DELAYED | HIGH_PRIORITY ;

ign:
	| | | | | | IGNORE ;

update:
	UPDATE priority_update ign _table SET _field_no_pk = value where order_by limit ;
	
update_multi:
	UPDATE priority_update ign _table t1, _table t2 SET t1._field_no_pk = value WHERE t1._field sign value ;

priority_update:
	| LOW_PRIORITY ; 

delete:
	| | | | | | | | DELETE FROM _table where order_by limit ;
	
replace:
	REPLACE INTO _table ( _field_no_pk ) VALUES ( value ) ;
	
create_table:
	DROP TABLE IF EXISTS _letter[invariant] ; DROP VIEW IF EXISTS _letter[invariant] ; CREATE temp TABLE _letter[invariant] LIKE _table[invariant] ; INSERT INTO _letter[invariant] SELECT * FROM _table[invariant] |
	DROP TABLE IF EXISTS _letter[invariant] ; DROP VIEW IF EXISTS _letter[invariant] ; CREATE temp TABLE _letter[invariant] SELECT * FROM _table ;
	
temp:
	| | | | | | TEMPORARY ;

alter:
	ALTER TABLE _table MODIFY _field DATETIME(6) NULL AFTER _field |
	ALTER TABLE _table MODIFY _field DATETIME(6) NOT NULL FIRST |
	ALTER TABLE _table MODIFY _field DATETIME(6) NULL DEFAULT 0 AFTER _field |
	ALTER TABLE _table MODIFY _field DATETIME(6) NOT NULL DEFAULT 0 FIRST |
	ALTER TABLE _table MODIFY _field DATETIME(6) NULL DEFAULT CURRENT_TIMESTAMP(6) AFTER _field |
	ALTER TABLE _table MODIFY _field DATETIME(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) FIRST |
	ALTER TABLE _table MODIFY _field DATETIME(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6) AFTER _field |
	ALTER TABLE _table MODIFY _field DATETIME(6) NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6) FIRST |
	ALTER TABLE _table MODIFY _field DATETIME(6) NULL ON UPDATE CURRENT_TIMESTAMP(6) AFTER _field |
	ALTER TABLE _table MODIFY _field DATETIME(6) NOT NULL ON UPDATE CURRENT_TIMESTAMP(6) FIRST |
	ALTER TABLE _table MODIFY _field DATETIME(6) NOT NULL DEFAULT '2000-01-01 00:00:00' AFTER _field |
	ALTER TABLE _table MODIFY _field DATETIME(6) NULL DEFAULT '2000-01-01 00:00:00' FIRST |
	ALTER TABLE _table MODIFY _field DATETIME(6) NOT NULL DEFAULT '2000-01-01 00:00:00' ON UPDATE CURRENT_TIMESTAMP(6) AFTER _field |
	ALTER TABLE _table MODIFY _field DATETIME(6) NULL DEFAULT '2000-01-01 00:00:00' ON UPDATE CURRENT_TIMESTAMP(6) FIRST |
	ALTER TABLE _table MODIFY _field TIMESTAMP(6) AFTER _field |
	ALTER TABLE _table MODIFY _field TIMESTAMP(6) NULL FIRST |
	ALTER TABLE _table MODIFY _field TIMESTAMP(6) NULL DEFAULT 0 AFTER _field |
	ALTER TABLE _table MODIFY _field TIMESTAMP(6) NOT NULL DEFAULT 0 FIRST |
	ALTER TABLE _table MODIFY _field TIMESTAMP(6) NULL DEFAULT CURRENT_TIMESTAMP(6) AFTER _field |
	ALTER TABLE _table MODIFY _field TIMESTAMP(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) FIRST |
	ALTER TABLE _table MODIFY _field TIMESTAMP(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6) AFTER _field |
	ALTER TABLE _table MODIFY _field TIMESTAMP(6) NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6) FIRST |
	ALTER TABLE _table MODIFY _field TIMESTAMP(6) NULL ON UPDATE CURRENT_TIMESTAMP(6) AFTER _field |
	ALTER TABLE _table MODIFY _field TIMESTAMP(6) NOT NULL ON UPDATE CURRENT_TIMESTAMP(6) FIRST |
	ALTER TABLE _table MODIFY _field TIMESTAMP(6) NOT NULL DEFAULT '2000-01-01 00:00:00' AFTER _field |
	ALTER TABLE _table MODIFY _field TIMESTAMP(6) NULL DEFAULT '2000-01-01 00:00:00' FIRST |
	ALTER TABLE _table MODIFY _field TIMESTAMP(6) NOT NULL DEFAULT '2000-01-01 00:00:00' ON UPDATE CURRENT_TIMESTAMP(6) AFTER _field |
	ALTER TABLE _table MODIFY _field TIMESTAMP(6) NULL DEFAULT '2000-01-01 00:00:00' ON UPDATE CURRENT_TIMESTAMP(6) FIRST ;

proc_func:
	DROP PROCEDURE IF EXISTS _letter[invariant] ; CREATE PROCEDURE _letter[invariant] ( proc_param ) BEGIN SELECT COUNT( _field ) INTO @a FROM _table ; END ; CALL _letter[invariant](@a); |
	DROP FUNCTION IF EXISTS _letter[invariant] ; CREATE FUNCTION _letter[invariant] ( func_param ) RETURNS time_field DETERMINISTIC READS SQL DATA BEGIN DECLARE out1 time_field ; SELECT _table._field INTO out1 FROM _table ; RETURN out1 ;
		
proc_param:
	IN _letter time_field | OUT _letter time_field | IN _letter time_field , proc_param | OUT _letter time_field , proc_param ;
	
func_param:
	_letter time_field | _letter time_field , func_param ;
	
time_field:
	DATETIME(6) | DATETIME(6) | TIMESTAMP(6) | TIMESTAMP(6) | DATE(6) | TIME(6) ;
	
views:
	DROP TABLE IF EXISTS _letter[invariant] ; DROP VIEW IF EXISTS _letter[invariant] ; CREATE VIEW _letter[invariant] AS SELECT * FROM _table ; INSERT INTO _letter[invariant] ( _field ) VALUES ( value ) ;
	
outfile_infile:
	SELECT * FROM _table[invariant] INTO OUTFILE _tmpnam ; TRUNCATE _table[invariant] ; LOAD DATA INFILE _tmpnam INTO TABLE _table[invariant] ;

value:
        _year | _date(6) | _time(6) | _datetime(6) | _datetime(6) | _datetime(6) | _timestamp(6) | _timestamp(6) | _timestamp(6) | NULL | NULL | NULL |
	_digit | 0 | 1 | -1 | _data | _bigint_unsigned | _bigint | _mediumint | _english | _letter | _char(64) | _varchar(8) ;
