USE test;
CREATE TABLE IF NOT EXISTS `changesets` (  `id` bigint(20) NOT NULL auto_increment,  `user_id` bigint(20) NOT NULL,  `created_at` datetime NOT NULL,  `min_lat` int(11) default NULL,  `max_lat` int(11) default NULL,  `min_lon` int(11) default NULL,  `max_lon` int(11) default NULL,  `closed_at` datetime NOT NULL,  `num_changes` int(11) NOT NULL default '0',  PRIMARY KEY  (`id`))  DEFAULT CHARSET=utf8 ;
CREATE TABLE IF NOT EXISTS `changeset_tags` (  `id` bigint(64) NOT NULL,  `k` varchar(255) NOT NULL default '',  `v` varchar(255) NOT NULL default '',  KEY `changeset_tags_id_idx` (`id`)) DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `current_nodes` (  `id` bigint(64) NOT NULL auto_increment,  `latitude` int(11) NOT NULL,  `longitude` int(11) NOT NULL,  `changeset_id` bigint(20) NOT NULL,  `visible` tinyint(1) NOT NULL,  `timestamp` datetime NOT NULL,  `tile` int(10) unsigned NOT NULL,  `version` bigint(20) NOT NULL,  PRIMARY KEY  (`id`),  KEY `current_nodes_timestamp_idx` (`timestamp`),  KEY `current_nodes_tile_idx` (`tile`),  KEY `changeset_id` (`changeset_id`))  DEFAULT CHARSET=utf8 ;
CREATE TABLE IF NOT EXISTS `current_node_tags` (  `id` bigint(64) NOT NULL,  `k` varchar(255) NOT NULL default '',  `v` varchar(255) NOT NULL default '',  PRIMARY KEY  (`id`,`k`)) DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `current_relations` (  `id` bigint(64) NOT NULL auto_increment,  `changeset_id` bigint(20) NOT NULL,  `timestamp` datetime NOT NULL,  `visible` tinyint(1) NOT NULL,  `version` bigint(20) NOT NULL,  PRIMARY KEY  (`id`),  KEY `current_relations_timestamp_idx` (`timestamp`),  KEY `changeset_id` (`changeset_id`))  DEFAULT CHARSET=utf8 ;
CREATE TABLE IF NOT EXISTS `current_relation_members` (  `id` bigint(64) NOT NULL,  `member_type` enum('node','way','relation') NOT NULL default 'node',  `member_id` bigint(11) NOT NULL,  `member_role` varchar(255) NOT NULL default '',  `sequence_id` int(11) NOT NULL default '0',  PRIMARY KEY  (`id`,`member_type`,`member_id`,`member_role`,`sequence_id`),  KEY `current_relation_members_member_idx` (`member_type`,`member_id`)) DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `current_relation_tags` (  `id` bigint(64) NOT NULL,  `k` varchar(255) NOT NULL default '',  `v` varchar(255) NOT NULL default '',  PRIMARY KEY  (`id`,`k`)) DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `current_ways` (  `id` bigint(64) NOT NULL auto_increment,  `changeset_id` bigint(20) NOT NULL,  `timestamp` datetime NOT NULL,  `visible` tinyint(1) NOT NULL,  `version` bigint(20) NOT NULL,  PRIMARY KEY  (`id`),  KEY `current_ways_timestamp_idx` (`timestamp`),  KEY `changeset_id` (`changeset_id`))  DEFAULT CHARSET=utf8 ;
CREATE TABLE IF NOT EXISTS `current_way_nodes` (  `id` bigint(64) NOT NULL,  `node_id` bigint(64) NOT NULL,  `sequence_id` bigint(11) NOT NULL,  PRIMARY KEY  (`id`,`sequence_id`),  KEY `current_way_nodes_node_idx` (`node_id`)) DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `current_way_tags` (  `id` bigint(64) NOT NULL,  `k` varchar(255) NOT NULL default '',  `v` varchar(255) NOT NULL default '',  PRIMARY KEY  (`id`,`k`)) DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `diary_comments` (  `id` bigint(20) NOT NULL auto_increment,  `diary_entry_id` bigint(20) NOT NULL,  `user_id` bigint(20) NOT NULL,  `body` text NOT NULL,  `created_at` datetime NOT NULL,  `updated_at` datetime NOT NULL,  PRIMARY KEY  (`id`),  UNIQUE KEY `diary_comments_entry_id_idx` (`diary_entry_id`,`id`)) DEFAULT CHARSET=utf8 ;
CREATE TABLE IF NOT EXISTS `diary_entries` (  `id` bigint(20) NOT NULL auto_increment,  `user_id` bigint(20) NOT NULL,  `title` varchar(255) NOT NULL,  `body` text NOT NULL,  `created_at` datetime NOT NULL,  `updated_at` datetime NOT NULL,  `latitude` double default NULL,  `longitude` double default NULL,  `language` varchar(3) default NULL,  PRIMARY KEY  (`id`)) DEFAULT CHARSET=utf8 ;
CREATE TABLE IF NOT EXISTS `friends` (  `id` bigint(20) NOT NULL auto_increment,  `user_id` bigint(20) NOT NULL,  `friend_user_id` bigint(20) NOT NULL,  PRIMARY KEY  (`id`),  KEY `user_id_idx` (`friend_user_id`),  KEY `friends_user_id_idx` (`user_id`)) DEFAULT CHARSET=utf8 ;
CREATE TABLE IF NOT EXISTS `gps_points` (  `altitude` float default NULL,  `trackid` int(11) NOT NULL,  `latitude` int(11) NOT NULL,  `longitude` int(11) NOT NULL,  `gpx_id` bigint(64) NOT NULL,  `timestamp` datetime default NULL,  `tile` int(10) unsigned NOT NULL,  KEY `points_gpxid_idx` (`gpx_id`),  KEY `points_tile_idx` (`tile`)) DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `gpx_files` (  `id` bigint(64) NOT NULL auto_increment,  `user_id` bigint(20) NOT NULL,  `visible` tinyint(1) NOT NULL default '1',  `name` varchar(255) NOT NULL default '',  `size` bigint(20) default NULL,  `latitude` double default NULL,  `longitude` double default NULL,  `timestamp` datetime NOT NULL,  `public` tinyint(1) NOT NULL default '1',  `description` varchar(255) NOT NULL default '',  `inserted` tinyint(1) NOT NULL,  PRIMARY KEY  (`id`),  KEY `gpx_files_timestamp_idx` (`timestamp`),  KEY `gpx_files_visible_public_idx` (`visible`,`public`),  KEY `gpx_files_user_id_idx` (`user_id`)) DEFAULT CHARSET=utf8 ;
CREATE TABLE IF NOT EXISTS `gpx_file_tags` (  `gpx_id` bigint(64) NOT NULL default '0',  `tag` varchar(255) NOT NULL,  `id` bigint(20) NOT NULL auto_increment,  PRIMARY KEY  (`id`),  KEY `gpx_file_tags_gpxid_idx` (`gpx_id`),  KEY `gpx_file_tags_tag_idx` (`tag`)) DEFAULT CHARSET=utf8 ;
CREATE TABLE IF NOT EXISTS `messages` (  `id` bigint(20) NOT NULL auto_increment,  `from_user_id` bigint(20) NOT NULL,  `title` varchar(255) NOT NULL,  `body` text NOT NULL,  `sent_on` datetime NOT NULL,  `message_read` tinyint(1) NOT NULL default '0',  `to_user_id` bigint(20) NOT NULL,  PRIMARY KEY  (`id`),  KEY `messages_to_user_id_idx` (`to_user_id`)) DEFAULT CHARSET=utf8 ;
CREATE TABLE IF NOT EXISTS `nodes` (  `id` bigint(64) NOT NULL,  `latitude` int(11) NOT NULL,  `longitude` int(11) NOT NULL,  `changeset_id` bigint(20) NOT NULL,  `visible` tinyint(1) NOT NULL,  `timestamp` datetime NOT NULL,  `tile` int(10) unsigned NOT NULL,  `version` bigint(20) NOT NULL,  PRIMARY KEY  (`id`,`version`),  KEY `nodes_timestamp_idx` (`timestamp`),  KEY `nodes_tile_idx` (`tile`),  KEY `changeset_id` (`changeset_id`)) DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `node_tags` (  `id` bigint(64) NOT NULL,  `version` bigint(20) NOT NULL,  `k` varchar(255) NOT NULL default '',  `v` varchar(255) NOT NULL default '',  PRIMARY KEY  (`id`,`version`,`k`)) DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `relations` (  `id` bigint(64) NOT NULL default '0',  `changeset_id` bigint(20) NOT NULL,  `timestamp` datetime NOT NULL,  `version` bigint(20) NOT NULL,  `visible` tinyint(1) NOT NULL default '1',  PRIMARY KEY  (`id`,`version`),  KEY `relations_timestamp_idx` (`timestamp`),  KEY `changeset_id` (`changeset_id`)) DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `relation_members` (  `id` bigint(64) NOT NULL default '0',  `member_type` enum('node','way','relation') NOT NULL default 'node',  `member_id` bigint(11) NOT NULL,  `member_role` varchar(255) NOT NULL default '',  `version` bigint(20) NOT NULL default '0',  `sequence_id` int(11) NOT NULL default '0',  PRIMARY KEY  (`id`,`version`,`member_type`,`member_id`,`member_role`,`sequence_id`),  KEY `relation_members_member_idx` (`member_type`,`member_id`)) DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `relation_tags` (  `id` bigint(64) NOT NULL default '0',  `k` varchar(255) NOT NULL default '',  `v` varchar(255) NOT NULL default '',  `version` bigint(20) NOT NULL,  PRIMARY KEY  (`id`,`version`,`k`)) DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `schema_migrations` (  `version` varchar(255) NOT NULL,  UNIQUE KEY `unique_schema_migrations` (`version`)) DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `sessions` (  `id` int(11) NOT NULL auto_increment,  `session_id` varchar(255) default NULL,  `data` text,  `created_at` datetime default NULL,  `updated_at` datetime default NULL,  PRIMARY KEY  (`id`),  UNIQUE KEY `sessions_session_id_idx` (`session_id`))  DEFAULT CHARSET=utf8 ;
CREATE TABLE IF NOT EXISTS `users` (  `email` varchar(255) NOT NULL,  `id` bigint(20) NOT NULL auto_increment,  `active` int(11) NOT NULL default '0',  `pass_crypt` varchar(255) NOT NULL,  `creation_time` datetime NOT NULL,  `display_name` varchar(255) NOT NULL default '',  `data_public` tinyint(1) NOT NULL default '0',  `description` text NOT NULL,  `home_lat` double default NULL,  `home_lon` double default NULL,  `home_zoom` smallint(6) default '3',  `nearby` int(11) default '50',  `pass_salt` varchar(255) default NULL,  `image` text,  `administrator` tinyint(1) NOT NULL default '0',  `email_valid` tinyint(1) NOT NULL default '0',  `new_email` varchar(255) default NULL,  `visible` tinyint(1) NOT NULL default '1',  `creation_ip` varchar(255) default NULL,  PRIMARY KEY  (`id`),  UNIQUE KEY `users_email_idx` (`email`),  UNIQUE KEY `users_display_name_idx` (`display_name`))  DEFAULT CHARSET=utf8 ;
CREATE TABLE IF NOT EXISTS `user_preferences` (  `user_id` bigint(20) NOT NULL,  `k` varchar(255) NOT NULL,  `v` varchar(255) NOT NULL,  PRIMARY KEY  (`user_id`,`k`)) DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `user_tokens` (  `id` bigint(20) NOT NULL auto_increment,  `user_id` bigint(20) NOT NULL,  `token` varchar(255) NOT NULL,  `expiry` datetime NOT NULL,  PRIMARY KEY  (`id`),  UNIQUE KEY `user_tokens_token_idx` (`token`),  KEY `user_tokens_user_id_idx` (`user_id`)) DEFAULT CHARSET=utf8 ;
CREATE TABLE IF NOT EXISTS `ways` (  `id` bigint(64) NOT NULL default '0',  `changeset_id` bigint(20) NOT NULL,  `timestamp` datetime NOT NULL,  `version` bigint(20) NOT NULL,  `visible` tinyint(1) NOT NULL default '1',  PRIMARY KEY  (`id`,`version`),  KEY `ways_timestamp_idx` (`timestamp`),  KEY `changeset_id` (`changeset_id`)) DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `way_nodes` (  `id` bigint(64) NOT NULL,  `node_id` bigint(64) NOT NULL,  `version` bigint(20) NOT NULL,  `sequence_id` bigint(11) NOT NULL,  PRIMARY KEY  (`id`,`version`,`sequence_id`),  KEY `way_nodes_node_idx` (`node_id`)) DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `way_tags` (  `id` bigint(64) NOT NULL default '0',  `k` varchar(255) NOT NULL,  `v` varchar(255) NOT NULL,  `version` bigint(20) NOT NULL,  PRIMARY KEY  (`id`,`version`,`k`)) DEFAULT CHARSET=utf8;
INSERT INTO `changeset_tags` VALUES (0,'created_by','Osmosis 0.36'),(0,'replication','true'),(232546,'created_by','Osmosis 0.36'),(232546,'replication','true'),(427965,'created_by','Osmosis 0.36'),(427965,'replication','true'),(2762,'created_by','Osmosis 0.36'),(2762,'replication','true'),(2895121,'created_by','Osmosis 0.36'),(2895121,'replication','true'),(188228,'created_by','Osmosis 0.36'),(188228,'replication','true'),(5671401,'created_by','Osmosis 0.36'),(5671401,'replication','true'),(2774,'created_by','Osmosis 0.36'),(2774,'replication','true'),(426786,'created_by','Osmosis 0.36'),(426786,'replication','true'),(454632,'created_by','Osmosis 0.36'),(454632,'replication','true'),(495907,'created_by','Osmosis 0.36'),(495907,'replication','true'),(434787,'created_by','Osmosis 0.36'),(434787,'replication','true'),(110477,'created_by','Osmosis 0.36'),(110477,'replication','true'),(784366,'created_by','Osmosis 0.36'),(784366,'replication','true'),(4133451,'created_by','Osmosis 0.36'),(4133451,'replication','true'),(592895,'created_by','Osmosis 0.36'),(592895,'replication','true'),(508959,'created_by','Osmosis 0.36'),(508959,'replication','true'),(206510,'created_by','Osmosis 0.36'),(206510,'replication','true'),(198831,'created_by','Osmosis 0.36'),(198831,'replication','true'),(443749,'created_by','Osmosis 0.36'),(443749,'replication','true'),(4963967,'created_by','Osmosis 0.36'),(4963967,'replication','true'),(4963942,'created_by','Osmosis 0.36'),(4963942,'replication','true'),(5107412,'created_by','Osmosis 0.36'),(5107412,'replication','true'),(437032,'created_by','Osmosis 0.36'),(437032,'replication','true'),(840745,'created_by','Osmosis 0.36'),(840745,'replication','true'),(3916355,'created_by','Osmosis 0.36'),(3916355,'replication','true'),(462689,'created_by','Osmosis 0.36'),(462689,'replication','true'),(439281,'created_by','Osmosis 0.36'),(439281,'replication','true'),(305941,'created_by','Osmosis 0.36'),(305941,'replication','true'),(443527,'created_by','Osmosis 0.36'),(443527,'replication','true'),(104780,'created_by','Osmosis 0.36'),(104780,'replication','true'),(820251,'created_by','Osmosis 0.36'),(820251,'replication','true'),(56648,'created_by','Osmosis 0.36'),(56648,'replication','true'),(462438,'created_by','Osmosis 0.36'),(462438,'replication','true'),(432736,'created_by','Osmosis 0.36'),(432736,'replication','true'),(258874,'created_by','Osmosis 0.36'),(258874,'replication','true'),(697263,'created_by','Osmosis 0.36'),(697263,'replication','true'),(978767,'created_by','Osmosis 0.36'),(978767,'replication','true'),(91018,'created_by','Osmosis 0.36'),(91018,'replication','true'),(981792,'created_by','Osmosis 0.36'),(981792,'replication','true'),(461502,'created_by','Osmosis 0.36'),(461502,'replication','true'),(463410,'created_by','Osmosis 0.36'),(463410,'replication','true'),(370566,'created_by','Osmosis 0.36'),(370566,'replication','true'),(435967,'created_by','Osmosis 0.36'),(435967,'replication','true'),(174860,'created_by','Osmosis 0.36'),(174860,'replication','true'),(210114,'created_by','Osmosis 0.36'),(210114,'replication','true'),(448710,'created_by','Osmosis 0.36'),(448710,'replication','true'),(306164,'created_by','Osmosis 0.36'),(306164,'replication','true'),(183661,'created_by','Osmosis 0.36'),(183661,'replication','true'),(501202,'created_by','Osmosis 0.36'),(501202,'replication','true'),(498434,'created_by','Osmosis 0.36'),(498434,'replication','true'),(4804396,'created_by','Osmosis 0.36'),(4804396,'replication','true'),(725665,'created_by','Osmosis 0.36'),(725665,'replication','true'),(1684788,'created_by','Osmosis 0.36'),(1684788,'replication','true'),(615859,'created_by','Osmosis 0.36'),(615859,'replication','true'),(440632,'created_by','Osmosis 0.36'),(440632,'replication','true'),(513066,'created_by','Osmosis 0.36'),(513066,'replication','true'),(352026,'created_by','Osmosis 0.36'),(352026,'replication','true'),(864892,'created_by','Osmosis 0.36'),(864892,'replication','true'),(1258067,'created_by','Osmosis 0.36'),(1258067,'replication','true'),(538211,'created_by','Osmosis 0.36'),(538211,'replication','true'),(1882243,'created_by','Osmosis 0.36'),(1882243,'replication','true'),(72964,'created_by','Osmosis 0.36'),(72964,'replication','true'),(2836771,'created_by','Osmosis 0.36'),(2836771,'replication','true'),(373445,'created_by','Osmosis 0.36'),(373445,'replication','true'),(446582,'created_by','Osmosis 0.36'),(446582,'replication','true'),(19873,'created_by','Osmosis 0.36'),(19873,'replication','true'),(501218,'created_by','Osmosis 0.36'),(501218,'replication','true'),(25362,'created_by','Osmosis 0.36'),(25362,'replication','true'),(21109,'created_by','Osmosis 0.36'),(21109,'replication','true'),(863220,'created_by','Osmosis 0.36'),(863220,'replication','true'),(27626,'created_by','Osmosis 0.36'),(27626,'replication','true'),(372139,'created_by','Osmosis 0.36'),(372139,'replication','true'),(1165666,'created_by','Osmosis 0.36'),(1165666,'replication','true'),(1165813,'created_by','Osmosis 0.36'),(1165813,'replication','true'),(557925,'created_by','Osmosis 0.36'),(557925,'replication','true'),(4652669,'created_by','Osmosis 0.36'),(4652669,'replication','true'),(363778,'created_by','Osmosis 0.36'),(363778,'replication','true'),(4106774,'created_by','Osmosis 0.36'),(4106774,'replication','true'),(320551,'created_by','Osmosis 0.36'),(320551,'replication','true'),(502899,'created_by','Osmosis 0.36'),(502899,'replication','true'),(327248,'created_by','Osmosis 0.36'),(327248,'replication','true'),(226881,'created_by','Osmosis 0.36'),(226881,'replication','true'),(1074615,'created_by','Osmosis 0.36'),(1074615,'replication','true'),(423843,'created_by','Osmosis 0.36'),(423843,'replication','true'),(427200,'created_by','Osmosis 0.36'),(427200,'replication','true'),(439103,'created_by','Osmosis 0.36'),(439103,'replication','true'),(844916,'created_by','Osmosis 0.36'),(844916,'replication','true'),(787878,'created_by','Osmosis 0.36'),(787878,'replication','true'),(181856,'created_by','Osmosis 0.36'),(181856,'replication','true'),(708302,'created_by','Osmosis 0.36'),(708302,'replication','true'),(494030,'created_by','Osmosis 0.36'),(494030,'replication','true'),(2395774,'created_by','Osmosis 0.36'),(2395774,'replication','true'),(225225,'created_by','Osmosis 0.36'),(225225,'replication','true'),(104599,'created_by','Osmosis 0.36'),(104599,'replication','true'),(263367,'created_by','Osmosis 0.36'),(263367,'replication','true'),(312325,'created_by','Osmosis 0.36'),(312325,'replication','true'),(2191272,'created_by','Osmosis 0.36'),(2191272,'replication','true'),(653218,'created_by','Osmosis 0.36'),(653218,'replication','true'),(5077512,'created_by','Osmosis 0.36'),(5077512,'replication','true'),(4055320,'created_by','Osmosis 0.36'),(4055320,'replication','true'),(197512,'created_by','Osmosis 0.36'),(197512,'replication','true'),(91631,'created_by','Osmosis 0.36'),(91631,'replication','true'),(239859,'created_by','Osmosis 0.36'),(239859,'replication','true'),(1075389,'created_by','Osmosis 0.36'),(1075389,'replication','true'),(329152,'created_by','Osmosis 0.36'),(329152,'replication','true'),(441038,'created_by','Osmosis 0.36'),(441038,'replication','true'),(362976,'created_by','Osmosis 0.36'),(362976,'replication','true'),(1293006,'created_by','Osmosis 0.36'),(1293006,'replication','true'),(426052,'created_by','Osmosis 0.36'),(426052,'replication','true'),(459604,'created_by','Osmosis 0.36'),(459604,'replication','true'),(862435,'created_by','Osmosis 0.36'),(862435,'replication','true'),(470312,'created_by','Osmosis 0.36'),(470312,'replication','true'),(2369737,'created_by','Osmosis 0.36'),(2369737,'replication','true'),(675187,'created_by','Osmosis 0.36'),(675187,'replication','true'),(2369619,'created_by','Osmosis 0.36'),(2369619,'replication','true'),(33354,'created_by','Osmosis 0.36'),(33354,'replication','true'),(2191328,'created_by','Osmosis 0.36'),(2191328,'replication','true'),(258909,'created_by','Osmosis 0.36'),(258909,'replication','true'),(3475126,'created_by','Osmosis 0.36'),(3475126,'replication','true'),(4114763,'created_by','Osmosis 0.36'),(4114763,'replication','true'),(404186,'created_by','Osmosis 0.36'),(404186,'replication','true'),(478731,'created_by','Osmosis 0.36'),(478731,'replication','true'),(437534,'created_by','Osmosis 0.36'),(437534,'replication','true'),(599374,'created_by','Osmosis 0.36'),(599374,'replication','true'),(621592,'created_by','Osmosis 0.36'),(621592,'replication','true'),(4161539,'created_by','Osmosis 0.36'),(4161539,'replication','true'),(854025,'created_by','Osmosis 0.36'),(854025,'replication','true'),(609884,'created_by','Osmosis 0.36'),(609884,'replication','true'),(837556,'created_by','Osmosis 0.36'),(837556,'replication','true'),(216961,'created_by','Osmosis 0.36'),(216961,'replication','true'),(870814,'created_by','Osmosis 0.36'),(870814,'replication','true'),(1111251,'created_by','Osmosis 0.36'),(1111251,'replication','true'),(986514,'created_by','Osmosis 0.36'),(986514,'replication','true'),(1075282,'created_by','Osmosis 0.36'),(1075282,'replication','true'),(1423654,'created_by','Osmosis 0.36'),(1423654,'replication','true'),(1074360,'created_by','Osmosis 0.36'),(1074360,'replication','true'),(1074995,'created_by','Osmosis 0.36'),(1074995,'replication','true'),(1075171,'created_by','Osmosis 0.36'),(1075171,'replication','true'),(1075235,'created_by','Osmosis 0.36'),(1075235,'replication','true'),(1165753,'created_by','Osmosis 0.36'),(1165753,'replication','true'),(1166143,'created_by','Osmosis 0.36'),(1166143,'replication','true'),(1166091,'created_by','Osmosis 0.36'),(1166091,'replication','true'),(1166268,'created_by','Osmosis 0.36'),(1166268,'replication','true'),(2138435,'created_by','Osmosis 0.36'),(2138435,'replication','true'),(1166650,'created_by','Osmosis 0.36'),(1166650,'replication','true'),(1166792,'created_by','Osmosis 0.36'),(1166792,'replication','true'),(1276166,'created_by','Osmosis 0.36'),(1276166,'replication','true'),(1816099,'created_by','Osmosis 0.36'),(1816099,'replication','true'),(1816161,'created_by','Osmosis 0.36'),(1816161,'replication','true'),(1816208,'created_by','Osmosis 0.36'),(1816208,'replication','true'),(1851615,'created_by','Osmosis 0.36'),(1851615,'replication','true'),(2074125,'created_by','Osmosis 0.36'),(2074125,'replication','true'),(2190495,'created_by','Osmosis 0.36'),(2190495,'replication','true'),(2074345,'created_by','Osmosis 0.36'),(2074345,'replication','true'),(2074369,'created_by','Osmosis 0.36'),(2074369,'replication','true'),(2190404,'created_by','Osmosis 0.36'),(2190404,'replication','true'),(2190594,'created_by','Osmosis 0.36'),(2190594,'replication','true'),(2190782,'created_by','Osmosis 0.36'),(2190782,'replication','true'),(2190826,'created_by','Osmosis 0.36'),(2190826,'replication','true'),(2191053,'created_by','Osmosis 0.36'),(2191053,'replication','true'),(2191112,'created_by','Osmosis 0.36'),(2191112,'replication','true'),(2357704,'created_by','Osmosis 0.36'),(2357704,'replication','true'),(2357182,'created_by','Osmosis 0.36'),(2357182,'replication','true'),(2357481,'created_by','Osmosis 0.36'),(2357481,'replication','true'),(2387382,'created_by','Osmosis 0.36'),(2387382,'replication','true'),(2695454,'created_by','Osmosis 0.36'),(2695454,'replication','true'),(2730324,'created_by','Osmosis 0.36'),(2730324,'replication','true'),(2746094,'created_by','Osmosis 0.36'),(2746094,'replication','true'),(2746135,'created_by','Osmosis 0.36'),(2746135,'replication','true'),(4101446,'created_by','Osmosis 0.36'),(4101446,'replication','true'),(2747796,'created_by','Osmosis 0.36'),(2747796,'replication','true'),(2756081,'created_by','Osmosis 0.36'),(2756081,'replication','true'),(2756091,'created_by','Osmosis 0.36'),(2756091,'replication','true'),(2759915,'created_by','Osmosis 0.36'),(2759915,'replication','true'),(3388565,'created_by','Osmosis 0.36'),(3388565,'replication','true'),(2760016,'created_by','Osmosis 0.36'),(2760016,'replication','true'),(2788590,'created_by','Osmosis 0.36'),(2788590,'replication','true'),(2788599,'created_by','Osmosis 0.36'),(2788599,'replication','true'),(2788603,'created_by','Osmosis 0.36'),(2788603,'replication','true'),(2788608,'created_by','Osmosis 0.36'),(2788608,'replication','true'),(2788613,'created_by','Osmosis 0.36'),(2788613,'replication','true'),(2788623,'created_by','Osmosis 0.36'),(2788623,'replication','true'),(2788624,'created_by','Osmosis 0.36'),(2788624,'replication','true'),(2791232,'created_by','Osmosis 0.36'),(2791232,'replication','true'),(2791237,'created_by','Osmosis 0.36'),(2791237,'replication','true'),(2791248,'created_by','Osmosis 0.36'),(2791248,'replication','true'),(5709666,'created_by','Osmosis 0.36'),(5709666,'replication','true'),(2791251,'created_by','Osmosis 0.36'),(2791251,'replication','true'),(2791253,'created_by','Osmosis 0.36'),(2791253,'replication','true'),(2791257,'created_by','Osmosis 0.36'),(2791257,'replication','true'),(2791267,'created_by','Osmosis 0.36'),(2791267,'replication','true'),(4108069,'created_by','Osmosis 0.36'),(4108069,'replication','true'),(3283462,'created_by','Osmosis 0.36'),(3283462,'replication','true'),(3373117,'created_by','Osmosis 0.36'),(3373117,'replication','true'),(3373535,'created_by','Osmosis 0.36'),(3373535,'replication','true'),(3373181,'created_by','Osmosis 0.36'),(3373181,'replication','true'),(5833623,'created_by','Osmosis 0.36'),(5833623,'replication','true'),(4092807,'created_by','Osmosis 0.36'),(4092807,'replication','true'),(4161868,'created_by','Osmosis 0.36'),(4161868,'replication','true'),(4092743,'created_by','Osmosis 0.36'),(4092743,'replication','true'),(4083024,'created_by','Osmosis 0.36'),(4083024,'replication','true'),(3724172,'created_by','Osmosis 0.36'),(3724172,'replication','true'),(4107810,'created_by','Osmosis 0.36'),(4107810,'replication','true'),(4133447,'created_by','Osmosis 0.36'),(4133447,'replication','true'),(3731851,'created_by','Osmosis 0.36'),(3731851,'replication','true'),(3727238,'created_by','Osmosis 0.36'),(3727238,'replication','true'),(3730430,'created_by','Osmosis 0.36'),(3730430,'replication','true'),(3731738,'created_by','Osmosis 0.36'),(3731738,'replication','true'),(4763364,'created_by','Osmosis 0.36'),(4763364,'replication','true'),(3903073,'created_by','Osmosis 0.36'),(3903073,'replication','true'),(4076773,'created_by','Osmosis 0.36'),(4076773,'replication','true'),(4099383,'created_by','Osmosis 0.36'),(4099383,'replication','true'),(4076872,'created_by','Osmosis 0.36'),(4076872,'replication','true'),(4076934,'created_by','Osmosis 0.36'),(4076934,'replication','true'),(4077060,'created_by','Osmosis 0.36'),(4077060,'replication','true'),(4077132,'created_by','Osmosis 0.36'),(4077132,'replication','true'),(4161911,'created_by','Osmosis 0.36'),(4161911,'replication','true'),(4077213,'created_by','Osmosis 0.36'),(4077213,'replication','true'),(4082908,'created_by','Osmosis 0.36'),(4082908,'replication','true'),(4083006,'created_by','Osmosis 0.36'),(4083006,'replication','true'),(4101592,'created_by','Osmosis 0.36'),(4101592,'replication','true'),(4092770,'created_by','Osmosis 0.36'),(4092770,'replication','true'),(4092963,'created_by','Osmosis 0.36'),(4092963,'replication','true'),(4096040,'created_by','Osmosis 0.36'),(4096040,'replication','true'),(4096072,'created_by','Osmosis 0.36'),(4096072,'replication','true'),(4096095,'created_by','Osmosis 0.36'),(4096095,'replication','true'),(4096166,'created_by','Osmosis 0.36'),(4096166,'replication','true'),(4096186,'created_by','Osmosis 0.36'),(4096186,'replication','true'),(4096227,'created_by','Osmosis 0.36'),(4096227,'replication','true'),(4098619,'created_by','Osmosis 0.36'),(4098619,'replication','true'),(4098931,'created_by','Osmosis 0.36'),(4098931,'replication','true'),(4100909,'created_by','Osmosis 0.36'),(4100909,'replication','true'),(4100978,'created_by','Osmosis 0.36'),(4100978,'replication','true'),(4101078,'created_by','Osmosis 0.36'),(4101078,'replication','true'),(4101245,'created_by','Osmosis 0.36'),(4101245,'replication','true'),(4101313,'created_by','Osmosis 0.36'),(4101313,'replication','true'),(4108991,'created_by','Osmosis 0.36'),(4108991,'replication','true'),(4115604,'created_by','Osmosis 0.36'),(4115604,'replication','true'),(4115657,'created_by','Osmosis 0.36'),(4115657,'replication','true'),(4159615,'created_by','Osmosis 0.36'),(4159615,'replication','true'),(4184201,'created_by','Osmosis 0.36'),(4184201,'replication','true'),(4174714,'created_by','Osmosis 0.36'),(4174714,'replication','true'),(4375683,'created_by','Osmosis 0.36'),(4375683,'replication','true'),(5043123,'created_by','Osmosis 0.36'),(5043123,'replication','true'),(5107450,'created_by','Osmosis 0.36'),(5107450,'replication','true'),(5236475,'created_by','Osmosis 0.36'),(5236475,'replication','true'),(5236785,'created_by','Osmosis 0.36'),(5236785,'replication','true'),(5363414,'created_by','Osmosis 0.36'),(5363414,'replication','true'),(5671193,'created_by','Osmosis 0.36'),(5671193,'replication','true'),(5678739,'created_by','Osmosis 0.36'),(5678739,'replication','true'),(5671416,'created_by','Osmosis 0.36'),(5671416,'replication','true'),(5674807,'created_by','Osmosis 0.36'),(5674807,'replication','true'),(5689624,'created_by','Osmosis 0.36'),(5689624,'replication','true'),(5678757,'created_by','Osmosis 0.36'),(5678757,'replication','true'),(5702328,'created_by','Osmosis 0.36'),(5702328,'replication','true'),(5710014,'created_by','Osmosis 0.36'),(5710014,'replication','true'),(5806005,'created_by','Osmosis 0.36'),(5806005,'replication','true'),(5866082,'created_by','Osmosis 0.36'),(5866082,'replication','true'),(531541,'created_by','Osmosis 0.36'),(531541,'replication','true'),(189418,'created_by','Osmosis 0.36'),(189418,'replication','true'),(553642,'created_by','Osmosis 0.36'),(553642,'replication','true'),(3878347,'created_by','Osmosis 0.36'),(3878347,'replication','true'),(3100730,'created_by','Osmosis 0.36'),(3100730,'replication','true'),(981922,'created_by','Osmosis 0.36'),(981922,'replication','true'),(2369688,'created_by','Osmosis 0.36'),(2369688,'replication','true'),(951833,'created_by','Osmosis 0.36'),(951833,'replication','true'),(5025308,'created_by','Osmosis 0.36'),(5025308,'replication','true'),(433922,'created_by','Osmosis 0.36'),(433922,'replication','true'),(3132766,'created_by','Osmosis 0.36'),(3132766,'replication','true'),(4312140,'created_by','Osmosis 0.36'),(4312140,'replication','true'),(307506,'created_by','Osmosis 0.36'),(307506,'replication','true'),(3936411,'created_by','Osmosis 0.36'),(3936411,'replication','true'),(353783,'created_by','Osmosis 0.36'),(353783,'replication','true'),(369842,'created_by','Osmosis 0.36'),(369842,'replication','true'),(441677,'created_by','Osmosis 0.36'),(441677,'replication','true'),(5694915,'created_by','Osmosis 0.36'),(5694915,'replication','true'),(3882859,'created_by','Osmosis 0.36'),(3882859,'replication','true'),(3916410,'created_by','Osmosis 0.36'),(3916410,'replication','true'),(73843,'created_by','Osmosis 0.36'),(73843,'replication','true'),(3124867,'created_by','Osmosis 0.36'),(3124867,'replication','true'),(4159744,'created_by','Osmosis 0.36'),(4159744,'replication','true'),(3373175,'created_by','Osmosis 0.36'),(3373175,'replication','true'),(412437,'created_by','Osmosis 0.36'),(412437,'replication','true'),(5025265,'created_by','Osmosis 0.36'),(5025265,'replication','true'),(5430086,'created_by','Osmosis 0.36'),(5430086,'replication','true'),(3956455,'created_by','Osmosis 0.36'),(3956455,'replication','true'),(2736717,'created_by','Osmosis 0.36'),(2736717,'replication','true'),(502306,'created_by','Osmosis 0.36'),(502306,'replication','true'),(508355,'created_by','Osmosis 0.36'),(508355,'replication','true'),(2213421,'created_by','Osmosis 0.36'),(2213421,'replication','true'),(2191249,'created_by','Osmosis 0.36'),(2191249,'replication','true'),(2191215,'created_by','Osmosis 0.36'),(2191215,'replication','true'),(2318266,'created_by','Osmosis 0.36'),(2318266,'replication','true'),(3933161,'created_by','Osmosis 0.36'),(3933161,'replication','true'),(565034,'created_by','Osmosis 0.36'),(565034,'replication','true'),(537461,'created_by','Osmosis 0.36'),(537461,'replication','true'),(4099888,'created_by','Osmosis 0.36'),(4099888,'replication','true'),(4083396,'created_by','Osmosis 0.36'),(4083396,'replication','true'),(2688289,'created_by','Osmosis 0.36'),(2688289,'replication','true'),(2788592,'created_by','Osmosis 0.36'),(2788592,'replication','true'),(2788617,'created_by','Osmosis 0.36'),(2788617,'replication','true'),(4083044,'created_by','Osmosis 0.36'),(4083044,'replication','true'),(4138831,'created_by','Osmosis 0.36'),(4138831,'replication','true'),(3831437,'created_by','Osmosis 0.36'),(3831437,'replication','true'),(4077244,'created_by','Osmosis 0.36'),(4077244,'replication','true'),(4077310,'created_by','Osmosis 0.36'),(4077310,'replication','true'),(4083737,'created_by','Osmosis 0.36'),(4083737,'replication','true'),(4083476,'created_by','Osmosis 0.36'),(4083476,'replication','true'),(5866046,'created_by','Osmosis 0.36'),(5866046,'replication','true'),(4091122,'created_by','Osmosis 0.36'),(4091122,'replication','true'),(5860604,'created_by','Osmosis 0.36'),(5860604,'replication','true'),(5061350,'created_by','Osmosis 0.36'),(5061350,'replication','true'),(5641978,'created_by','Osmosis 0.36'),(5641978,'replication','true'),(3612902,'created_by','Osmosis 0.36'),(3612902,'replication','true'),(4072906,'created_by','Osmosis 0.36'),(4072906,'replication','true'),(5636480,'created_by','Osmosis 0.36'),(5636480,'replication','true'),(4475595,'created_by','Osmosis 0.36'),(4475595,'replication','true'),(5808039,'created_by','Osmosis 0.36'),(5808039,'replication','true');
INSERT INTO `changesets` VALUES (1,-1,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(232546,10927,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(427965,10927,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(2762,1297,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(2895121,34536,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(188228,34536,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(5671401,213594,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(2774,1297,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(426786,10927,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(454632,10927,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(495907,34536,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(434787,10927,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(110477,29084,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(784366,10927,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(4133451,246989,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(592895,34536,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(508959,10927,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(206510,34536,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(198831,10927,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(443749,10927,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(4963967,93506,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(4963942,93506,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(5107412,93506,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(437032,34536,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(840745,34536,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(3916355,93506,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(462689,10927,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(439281,10927,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(305941,34536,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(443527,10927,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(104780,34536,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(820251,34536,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(56648,34536,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(462438,34536,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(432736,10927,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(258874,25804,'2010-09-28 10:22:40',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:40',0),(697263,84859,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(978767,119803,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(91018,43280,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(981792,119803,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(461502,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(463410,10927,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(370566,10927,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(435967,10927,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(174860,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(210114,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(448710,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(306164,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(183661,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(501202,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(498434,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(4804396,275821,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(725665,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(1684788,90394,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(615859,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(440632,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(513066,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(352026,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(864892,22398,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(1258067,70696,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(538211,10927,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(1882243,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(72964,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(2836771,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(373445,4363,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(446582,10091,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(19873,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(501218,10927,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(25362,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(21109,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(863220,22398,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(27626,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(372139,22398,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(1165666,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(1165813,34536,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(557925,10927,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(4652669,56597,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(363778,10927,'2010-09-28 10:22:41',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:41',0),(4106774,241566,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(320551,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(502899,10927,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(327248,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(226881,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(1074615,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(423843,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(427200,10091,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(439103,10091,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(844916,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(787878,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(181856,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(708302,10927,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(494030,10927,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(2395774,24965,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(225225,10927,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(104599,10927,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(263367,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(312325,70696,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(2191272,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(653218,20502,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(5077512,210115,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(4055320,6975,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(197512,10927,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(91631,10927,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(239859,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(1075389,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(329152,10927,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(441038,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(362976,10927,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(1293006,70696,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(426052,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(459604,10927,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(862435,22398,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(470312,10927,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(2369737,115019,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(675187,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(2369619,115019,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(33354,10927,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(2191328,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(258909,29717,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(3475126,5657,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(4114763,25762,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(404186,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(478731,53957,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(437534,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(599374,86654,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(621592,86654,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(4161539,241566,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(854025,17497,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(609884,22398,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(837556,91785,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(216961,22398,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(870814,86654,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(1111251,70696,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(986514,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(1075282,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(1423654,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(1074360,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(1074995,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(1075171,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(1075235,34536,'2010-09-28 10:22:42',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:42',0),(1165753,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(1166143,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(1166091,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(1166268,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2138435,152289,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(1166650,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(1166792,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(1276166,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(1816099,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(1816161,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(1816208,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(1851615,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2074125,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2190495,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2074345,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2074369,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2190404,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2190594,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2190782,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2190826,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2191053,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2191112,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2357704,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2357182,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2357481,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2387382,26868,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2695454,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2730324,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2746094,18149,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2746135,18149,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4101446,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2747796,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2756081,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2756091,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2759915,18149,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(3388565,6367,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2760016,18149,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2788590,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2788599,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2788603,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2788608,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2788613,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2788623,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2788624,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2791232,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2791237,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2791248,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5709666,306172,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2791251,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2791253,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2791257,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2791267,143308,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4108069,241566,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(3283462,10927,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(3373117,6367,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(3373535,6367,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(3373181,6367,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5833623,65148,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4092807,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4161868,241566,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4092743,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4083024,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(3724172,148173,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4107810,241566,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4133447,241566,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(3731851,148173,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(3727238,148173,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(3730430,148173,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(3731738,148173,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4763364,6975,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(3903073,90394,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4076773,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4099383,241566,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4076872,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4076934,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4077060,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4077132,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4161911,241566,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4077213,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4082908,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4083006,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4101592,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4092770,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4092963,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4096040,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4096072,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4096095,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4096166,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4096186,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4096227,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4098619,241566,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4098931,241566,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4100909,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4100978,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4101078,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4101245,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4101313,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4108991,241566,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4115604,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4115657,103244,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4159615,241566,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4184201,70696,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4174714,45284,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4375683,13409,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5043123,93506,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5107450,93506,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5236475,682,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5236785,682,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5363414,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5671193,213594,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5678739,213594,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5671416,213594,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5674807,213594,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5689624,213594,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5678757,213594,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5702328,306172,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5710014,306172,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5806005,120406,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5866082,213594,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(531541,10927,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(189418,10927,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(553642,10927,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(3878347,233341,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(3100730,6367,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(981922,119803,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(2369688,115019,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(951833,13324,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5025308,93506,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(433922,12841,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(3132766,6367,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(4312140,33377,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(307506,45027,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(3936411,134812,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(353783,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(369842,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(441677,34536,'2010-09-28 10:22:43',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:43',0),(5694915,231539,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(3882859,10927,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(3916410,93506,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(73843,3234,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(3124867,45027,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(4159744,247520,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(3373175,6367,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(412437,26299,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(5025265,93506,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(5430086,115995,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(3956455,185976,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(2736717,118014,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(502306,10927,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(508355,10927,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(2213421,34536,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(2191249,34536,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(2191215,34536,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(2318266,61891,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(3933161,134812,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(565034,29084,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(537461,86654,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(4099888,241566,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(4083396,103244,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(2688289,97036,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(2788592,143308,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(2788617,143308,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(4083044,103244,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(4138831,83365,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(3831437,148173,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(4077244,103244,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(4077310,103244,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(4083737,103244,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(4083476,103244,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(5866046,213594,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(4091122,92075,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(5860604,4363,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(5061350,276785,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(5641978,5265,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(3612902,107257,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(4072906,35074,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(5636480,5265,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(4475595,183561,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0),(5808039,235264,'2010-09-28 10:22:44',-900000000,900000000,-1800000000,1800000000,'2010-09-28 10:22:44',0);
INSERT INTO `current_node_tags` VALUES (625039,'highway','mini_roundabout'),(26609114,'aeroway','helipad'),(26609114,'created_by','Potlatch alpha'),(26609114,'iata','ALV'),(26609114,'icao','----'),(26609114,'is_in','Andorra la Vella,,Andorra'),(26609114,'place','airport'),(26609114,'source','Gagravarr_Airports'),(26609114,'type','civil'),(51344677,'barrier','toll_booth'),(51366154,'highway','speed_camera'),(51404282,'highway','traffic_signals'),(51448830,'source','yahoo'),(51552405,'created_by','JOSM'),(51552408,'created_by','JOSM'),(51552410,'created_by','JOSM'),(51552413,'created_by','JOSM'),(51552416,'created_by','JOSM'),(51552419,'created_by','JOSM'),(51552422,'created_by','JOSM'),(51552429,'created_by','JOSM'),(51552432,'created_by','JOSM'),(51552434,'created_by','JOSM'),(51552437,'created_by','JOSM'),(51552440,'created_by','JOSM'),(51552442,'created_by','JOSM'),(51552444,'created_by','JOSM'),(51552445,'created_by','JOSM'),(51552447,'created_by','JOSM'),(51552451,'created_by','JOSM'),(51552453,'created_by','JOSM'),(51552456,'created_by','JOSM'),(51552459,'created_by','JOSM'),(51552462,'created_by','JOSM'),(51552468,'created_by','JOSM'),(51552471,'created_by','JOSM'),(51552483,'highway','speed_camera'),(51552504,'created_by','JOSM'),(51552507,'created_by','JOSM'),(51552509,'created_by','JOSM'),(51552513,'created_by','JOSM'),(51552516,'created_by','JOSM'),(51552518,'created_by','JOSM'),(51552546,'created_by','JOSM'),(51552549,'created_by','JOSM'),(51552550,'created_by','JOSM'),(51552553,'created_by','JOSM'),(51552555,'created_by','JOSM'),(51552557,'created_by','JOSM'),(51552559,'created_by','JOSM'),(51552562,'created_by','JOSM'),(51552565,'created_by','JOSM'),(51552569,'created_by','JOSM'),(51552572,'created_by','JOSM'),(51552575,'created_by','JOSM'),(51552589,'created_by','JOSM'),(51552592,'created_by','JOSM'),(51552602,'created_by','JOSM'),(51552608,'created_by','JOSM'),(51552651,'created_by','JOSM'),(51552651,'highway','mini_roundabout'),(51552736,'created_by','JOSM'),(51552737,'created_by','JOSM'),(51552740,'created_by','JOSM'),(51552744,'created_by','JOSM'),(51552747,'created_by','JOSM'),(51552750,'created_by','JOSM'),(51552755,'created_by','JOSM'),(51552758,'created_by','JOSM'),(51552761,'created_by','JOSM'),(51552762,'created_by','JOSM'),(51552764,'created_by','JOSM'),(51552766,'created_by','JOSM'),(51552768,'created_by','JOSM'),(51552770,'created_by','JOSM'),(51552773,'created_by','JOSM'),(51552774,'created_by','JOSM'),(51552777,'created_by','JOSM'),(51552779,'created_by','JOSM'),(51552782,'created_by','JOSM'),(51552785,'created_by','JOSM'),(51552787,'created_by','JOSM'),(51552789,'created_by','JOSM'),(51552791,'created_by','JOSM'),(51552793,'created_by','JOSM'),(51552797,'created_by','JOSM'),(51552800,'created_by','JOSM'),(51552802,'created_by','JOSM'),(51552806,'created_by','JOSM'),(51552807,'created_by','JOSM'),(51552811,'created_by','JOSM'),(51552814,'created_by','JOSM'),(51552815,'created_by','JOSM'),(51552818,'created_by','JOSM'),(51552821,'created_by','JOSM'),(51552823,'created_by','JOSM'),(51552824,'created_by','JOSM'),(51552825,'created_by','JOSM'),(51552828,'created_by','JOSM'),(51552830,'created_by','JOSM'),(51552832,'created_by','JOSM'),(51552835,'created_by','JOSM'),(51552838,'created_by','JOSM'),(51552841,'created_by','JOSM'),(51552844,'created_by','JOSM'),(51552847,'created_by','JOSM'),(51552849,'created_by','JOSM'),(51552851,'created_by','JOSM'),(51552852,'created_by','JOSM'),(51552854,'created_by','JOSM'),(51552856,'created_by','JOSM'),(51552859,'created_by','JOSM'),(51552861,'created_by','JOSM'),(51552863,'created_by','JOSM'),(51552865,'created_by','JOSM'),(51552868,'created_by','JOSM'),(51552871,'created_by','JOSM'),(51552873,'created_by','JOSM'),(51552875,'created_by','JOSM'),(51554685,'created_by','JOSM'),(51554688,'created_by','JOSM'),(51554691,'created_by','JOSM'),(51554693,'created_by','JOSM'),(51554694,'created_by','JOSM'),(51554697,'created_by','JOSM'),(51554700,'created_by','JOSM'),(51554703,'created_by','JOSM'),(51554705,'created_by','JOSM'),(51554707,'created_by','JOSM'),(51554710,'created_by','JOSM'),(51554712,'created_by','JOSM'),(51554715,'created_by','JOSM'),(51554716,'created_by','JOSM'),(51557999,'created_by','JOSM'),(51558001,'created_by','JOSM'),(51558003,'created_by','JOSM'),(51558005,'created_by','JOSM'),(51558007,'created_by','JOSM'),(51558010,'created_by','JOSM'),(51558014,'created_by','JOSM'),(51558017,'created_by','JOSM'),(51558021,'created_by','JOSM'),(51558024,'created_by','JOSM'),(51558026,'created_by','JOSM'),(51558029,'created_by','JOSM'),(51558031,'created_by','JOSM'),(51558033,'created_by','JOSM'),(51558036,'created_by','JOSM'),(51558038,'created_by','JOSM'),(51558040,'created_by','JOSM'),(51558041,'created_by','JOSM'),(51558043,'created_by','JOSM'),(51558045,'created_by','JOSM'),(51558047,'created_by','JOSM'),(51558051,'created_by','JOSM'),(51558054,'created_by','JOSM'),(51558057,'created_by','JOSM'),(51558059,'created_by','JOSM'),(51558060,'created_by','JOSM'),(51558063,'created_by','JOSM'),(51558064,'created_by','JOSM'),(51558067,'created_by','JOSM'),(51558070,'created_by','JOSM'),(51558071,'created_by','JOSM'),(51558074,'created_by','JOSM'),(51558075,'created_by','JOSM'),(51558078,'created_by','JOSM'),(51558083,'created_by','JOSM'),(51558085,'created_by','JOSM'),(51558086,'created_by','JOSM'),(51558089,'created_by','JOSM'),(51558091,'created_by','JOSM'),(51558093,'created_by','JOSM'),(51558095,'created_by','JOSM'),(51558097,'created_by','JOSM'),(51558099,'created_by','JOSM'),(51558103,'created_by','JOSM'),(51558105,'created_by','JOSM'),(51558108,'created_by','JOSM'),(51558111,'created_by','JOSM'),(51558113,'created_by','JOSM'),(51558115,'created_by','JOSM'),(51558118,'created_by','JOSM'),(51558121,'created_by','JOSM'),(51558124,'created_by','JOSM'),(51558125,'created_by','JOSM'),(51558128,'created_by','JOSM'),(51558131,'created_by','JOSM'),(51558246,'created_by','JOSM'),(51558248,'created_by','JOSM'),(51558253,'created_by','JOSM'),(51558257,'created_by','JOSM'),(51558260,'created_by','JOSM'),(51558262,'created_by','JOSM'),(51558265,'created_by','JOSM'),(51558268,'created_by','JOSM'),(51558271,'created_by','JOSM'),(51558273,'created_by','JOSM'),(51558276,'created_by','JOSM'),(51558279,'created_by','JOSM'),(51558282,'created_by','JOSM'),(51558284,'created_by','JOSM'),(51558287,'created_by','JOSM'),(51558293,'created_by','JOSM'),(51558295,'created_by','JOSM'),(51558298,'created_by','JOSM'),(51558301,'created_by','JOSM'),(51558304,'created_by','JOSM'),(51558305,'created_by','JOSM'),(51563059,'created_by','JOSM'),(51563061,'created_by','JOSM'),(51563063,'created_by','JOSM'),(51563066,'created_by','JOSM'),(51563071,'created_by','JOSM'),(51563075,'created_by','JOSM'),(51563076,'created_by','JOSM'),(51563080,'created_by','JOSM'),(51563083,'created_by','JOSM'),(51563087,'created_by','JOSM'),(51563090,'created_by','JOSM'),(51563094,'created_by','JOSM'),(51563098,'created_by','JOSM'),(51563100,'created_by','JOSM'),(51563103,'created_by','JOSM'),(51563105,'created_by','JOSM'),(51563108,'created_by','JOSM'),(51563110,'created_by','JOSM'),(51563113,'created_by','JOSM'),(51563115,'created_by','JOSM'),(51563118,'created_by','JOSM'),(51563120,'created_by','JOSM'),(51563122,'created_by','JOSM'),(51563124,'created_by','JOSM'),(51563127,'created_by','JOSM'),(51563130,'created_by','JOSM'),(51563134,'created_by','JOSM'),(51563137,'created_by','JOSM'),(51563140,'created_by','JOSM'),(51563141,'created_by','JOSM'),(51563145,'created_by','JOSM'),(51563148,'created_by','JOSM'),(51563152,'created_by','JOSM'),(51563155,'created_by','JOSM'),(51563159,'created_by','JOSM'),(51563162,'created_by','JOSM'),(51563164,'created_by','JOSM'),(51563168,'created_by','JOSM'),(51563170,'created_by','JOSM'),(51563173,'created_by','JOSM'),(51563176,'created_by','JOSM'),(51563177,'created_by','JOSM'),(51563179,'created_by','JOSM'),(51563181,'created_by','JOSM'),(51563185,'created_by','JOSM'),(51563189,'created_by','JOSM'),(51563192,'created_by','JOSM'),(51563195,'created_by','JOSM'),(51563197,'created_by','JOSM'),(51563199,'created_by','JOSM'),(51563200,'created_by','JOSM'),(51563202,'created_by','JOSM'),(51563205,'created_by','JOSM'),(51563210,'created_by','JOSM'),(51563214,'created_by','JOSM'),(51563216,'created_by','JOSM'),(51563224,'created_by','JOSM'),(51563226,'created_by','JOSM'),(51563230,'created_by','JOSM'),(51563233,'created_by','JOSM'),(51563236,'created_by','JOSM'),(51563238,'created_by','JOSM'),(51563242,'created_by','JOSM'),(51563244,'created_by','JOSM'),(51563247,'created_by','JOSM'),(51563252,'created_by','JOSM'),(51563255,'created_by','JOSM'),(51563257,'created_by','JOSM'),(51563261,'created_by','JOSM'),(51563266,'created_by','JOSM'),(51563268,'created_by','JOSM'),(51563272,'created_by','JOSM'),(51563276,'created_by','JOSM'),(51563279,'created_by','JOSM'),(51563281,'created_by','JOSM'),(51563284,'created_by','JOSM'),(51563374,'created_by','JOSM'),(51563375,'created_by','JOSM'),(51563437,'created_by','JOSM'),(51563439,'created_by','JOSM'),(51563440,'created_by','JOSM'),(51563441,'created_by','JOSM'),(51563442,'created_by','JOSM'),(51563443,'created_by','JOSM'),(51563447,'created_by','JOSM'),(51563450,'created_by','JOSM'),(51563451,'created_by','JOSM'),(51563453,'created_by','JOSM'),(51563454,'created_by','JOSM'),(51563456,'created_by','JOSM'),(51563458,'created_by','JOSM'),(51563460,'created_by','JOSM'),(51563462,'created_by','JOSM'),(51563463,'created_by','JOSM'),(51563466,'created_by','JOSM'),(51563470,'created_by','JOSM'),(51563472,'created_by','JOSM'),(51563474,'created_by','JOSM'),(51563477,'created_by','JOSM'),(51563480,'created_by','JOSM'),(51563481,'created_by','JOSM'),(51563484,'created_by','JOSM'),(51563485,'created_by','JOSM'),(51563488,'created_by','JOSM'),(51563490,'created_by','JOSM'),(51563492,'created_by','JOSM'),(51563494,'created_by','JOSM'),(51563496,'created_by','JOSM'),(51563499,'created_by','JOSM'),(51581574,'created_by','JOSM'),(51581577,'created_by','JOSM'),(51581580,'created_by','JOSM'),(51581582,'created_by','JOSM'),(51581587,'created_by','JOSM'),(51581590,'created_by','JOSM'),(51581593,'created_by','JOSM'),(51581596,'created_by','JOSM'),(51581598,'created_by','JOSM'),(51581602,'created_by','JOSM'),(51581607,'created_by','JOSM'),(51581611,'created_by','JOSM'),(51581613,'created_by','JOSM'),(51581617,'created_by','JOSM'),(51581620,'created_by','JOSM'),(51581622,'created_by','JOSM'),(51581625,'created_by','JOSM'),(51581628,'created_by','JOSM'),(51581633,'created_by','JOSM'),(51581643,'created_by','JOSM'),(51581645,'created_by','JOSM'),(51581650,'created_by','JOSM'),(51581654,'created_by','JOSM'),(51581657,'created_by','JOSM'),(51581661,'created_by','JOSM'),(51581663,'created_by','JOSM'),(51581667,'created_by','JOSM'),(51581670,'created_by','JOSM'),(51581751,'created_by','JOSM'),(51581754,'created_by','JOSM'),(51581757,'created_by','JOSM'),(51581759,'created_by','JOSM'),(51581762,'created_by','JOSM'),(51581766,'created_by','JOSM'),(51581769,'created_by','JOSM'),(51581772,'created_by','JOSM'),(51581776,'created_by','JOSM'),(51581783,'created_by','JOSM'),(51581786,'created_by','JOSM'),(51581788,'created_by','JOSM'),(51581791,'created_by','JOSM'),(51581795,'created_by','JOSM'),(51581796,'created_by','JOSM'),(51581799,'created_by','JOSM'),(51581803,'created_by','JOSM'),(51581807,'created_by','JOSM'),(51581810,'created_by','JOSM'),(51581813,'created_by','JOSM'),(51581814,'created_by','JOSM'),(51581818,'created_by','JOSM'),(51581821,'created_by','JOSM'),(51581823,'created_by','JOSM'),(51581826,'created_by','JOSM'),(51581828,'created_by','JOSM'),(51581829,'created_by','JOSM'),(51581832,'created_by','JOSM'),(51581835,'created_by','JOSM'),(51581837,'created_by','JOSM'),(51581840,'created_by','JOSM'),(51581843,'created_by','JOSM'),(51581846,'created_by','JOSM'),(51581849,'created_by','JOSM'),(51581852,'created_by','JOSM'),(51581854,'created_by','JOSM'),(51581857,'created_by','JOSM'),(51581861,'created_by','JOSM'),(51581863,'created_by','JOSM'),(51581868,'created_by','JOSM'),(51581874,'created_by','JOSM'),(51581876,'created_by','JOSM'),(51581877,'created_by','JOSM'),(51581881,'created_by','JOSM'),(51581883,'created_by','JOSM'),(51581886,'created_by','JOSM'),(51581888,'created_by','JOSM'),(51581890,'created_by','JOSM'),(51581895,'created_by','JOSM'),(51581898,'created_by','JOSM'),(51581902,'created_by','JOSM'),(51581904,'created_by','JOSM'),(51581906,'created_by','JOSM'),(51581910,'created_by','JOSM'),(51581912,'created_by','JOSM'),(51581914,'created_by','JOSM'),(51581916,'created_by','JOSM'),(51581922,'created_by','JOSM'),(51581923,'created_by','JOSM'),(51581926,'created_by','JOSM'),(51581928,'created_by','JOSM'),(51581931,'created_by','JOSM'),(51581932,'created_by','JOSM'),(51581936,'created_by','JOSM'),(51581939,'created_by','JOSM'),(51581941,'created_by','JOSM'),(51581944,'created_by','JOSM'),(51581946,'created_by','JOSM'),(51581951,'created_by','JOSM'),(51581955,'created_by','JOSM'),(51581958,'created_by','JOSM'),(51581960,'created_by','JOSM'),(51581962,'created_by','JOSM'),(51581964,'created_by','JOSM'),(51581967,'created_by','JOSM'),(51581970,'created_by','JOSM'),(51581973,'created_by','JOSM'),(51581976,'created_by','JOSM'),(51581979,'created_by','JOSM'),(51581980,'created_by','JOSM'),(51581983,'created_by','JOSM'),(51581986,'created_by','JOSM'),(51581990,'created_by','JOSM'),(51581993,'created_by','JOSM'),(51581995,'created_by','JOSM'),(51581997,'created_by','JOSM'),(51582003,'created_by','JOSM'),(51582007,'created_by','JOSM'),(51582009,'created_by','JOSM'),(51582013,'created_by','JOSM'),(51582019,'created_by','JOSM'),(51582023,'created_by','JOSM'),(51582027,'created_by','JOSM'),(51582031,'created_by','JOSM'),(51582034,'created_by','JOSM'),(51582038,'created_by','JOSM'),(51582045,'created_by','JOSM'),(51582060,'created_by','JOSM'),(51582066,'created_by','JOSM'),(51582074,'created_by','JOSM'),(51582077,'created_by','JOSM'),(51582082,'created_by','JOSM'),(51582085,'created_by','JOSM'),(51582086,'created_by','JOSM'),(51582089,'created_by','JOSM'),(51582090,'created_by','JOSM'),(51582091,'created_by','JOSM'),(51582093,'created_by','JOSM'),(51582096,'created_by','JOSM'),(51582098,'created_by','JOSM'),(51582101,'created_by','JOSM'),(51582102,'created_by','JOSM'),(51582105,'created_by','JOSM'),(51582107,'created_by','JOSM'),(51582110,'created_by','JOSM'),(51582111,'created_by','JOSM'),(51582113,'created_by','JOSM'),(51582116,'created_by','JOSM'),(51582118,'created_by','JOSM'),(51582121,'created_by','JOSM'),(51582123,'created_by','JOSM'),(51582125,'created_by','JOSM'),(51582128,'created_by','JOSM'),(51582132,'created_by','JOSM'),(51582133,'created_by','JOSM'),(51582135,'created_by','JOSM'),(51582137,'created_by','JOSM'),(51582139,'created_by','JOSM'),(51582143,'created_by','JOSM'),(51582146,'created_by','JOSM'),(51582148,'created_by','JOSM'),(51582150,'created_by','JOSM'),(51582153,'created_by','JOSM'),(51582156,'created_by','JOSM'),(51582159,'created_by','JOSM'),(51582162,'created_by','JOSM'),(51582166,'created_by','JOSM'),(51582167,'created_by','JOSM'),(51582170,'created_by','JOSM'),(51582173,'created_by','JOSM'),(51582175,'created_by','JOSM'),(51582178,'created_by','JOSM'),(51582181,'created_by','JOSM'),(51582184,'created_by','JOSM'),(51582186,'created_by','JOSM'),(51582188,'created_by','JOSM'),(51582191,'created_by','JOSM'),(51582194,'created_by','JOSM'),(51582198,'created_by','JOSM'),(51582201,'created_by','JOSM'),(51582204,'created_by','JOSM'),(51582207,'created_by','JOSM'),(51582209,'created_by','JOSM'),(51582211,'created_by','JOSM'),(51587693,'created_by','JOSM'),(51587703,'created_by','JOSM'),(51587705,'created_by','JOSM'),(51587707,'created_by','JOSM'),(51587715,'created_by','JOSM'),(51587721,'created_by','JOSM'),(51587723,'created_by','JOSM'),(51587729,'created_by','JOSM'),(51587732,'created_by','JOSM'),(51589112,'created_by','JOSM'),(51589115,'created_by','JOSM'),(51589117,'created_by','JOSM'),(51589119,'created_by','JOSM'),(51589122,'created_by','JOSM'),(51589125,'created_by','JOSM'),(51589128,'created_by','JOSM'),(51589130,'created_by','JOSM'),(51589133,'created_by','JOSM'),(51589136,'created_by','JOSM'),(51589138,'created_by','JOSM'),(51589142,'created_by','JOSM'),(51589144,'created_by','JOSM'),(51589146,'created_by','JOSM'),(51589149,'created_by','JOSM'),(51589152,'created_by','JOSM'),(51589155,'created_by','JOSM'),(51589157,'created_by','JOSM'),(51589158,'created_by','JOSM'),(51589160,'created_by','JOSM'),(51589161,'created_by','JOSM'),(51589162,'created_by','JOSM'),(51589163,'created_by','JOSM'),(51589165,'created_by','JOSM'),(51589169,'created_by','JOSM'),(51589172,'created_by','JOSM'),(51589174,'created_by','JOSM'),(51589177,'created_by','JOSM'),(51589180,'created_by','JOSM'),(51589183,'created_by','JOSM'),(51589185,'created_by','JOSM'),(51589187,'created_by','JOSM'),(51589190,'created_by','JOSM'),(51589192,'created_by','JOSM'),(51589194,'created_by','JOSM'),(51589196,'created_by','JOSM'),(51589198,'created_by','JOSM'),(51589201,'created_by','JOSM'),(51589203,'created_by','JOSM'),(51589205,'created_by','JOSM'),(51589208,'created_by','JOSM'),(51589210,'created_by','JOSM'),(51589213,'created_by','JOSM'),(51589215,'created_by','JOSM'),(51589217,'created_by','JOSM'),(51589220,'created_by','JOSM'),(51589223,'created_by','JOSM'),(51589226,'created_by','JOSM'),(51589229,'created_by','JOSM'),(51589230,'created_by','JOSM'),(51589233,'created_by','JOSM'),(51589236,'created_by','JOSM'),(51589238,'created_by','JOSM'),(51589243,'created_by','JOSM'),(51589247,'created_by','JOSM'),(51589249,'created_by','JOSM'),(51589252,'created_by','JOSM'),(51589254,'created_by','JOSM'),(51589256,'created_by','JOSM'),(51589259,'created_by','JOSM'),(51589262,'created_by','JOSM'),(51589263,'created_by','JOSM'),(51589267,'created_by','JOSM'),(51589270,'created_by','JOSM'),(51589273,'created_by','JOSM'),(51589275,'created_by','JOSM'),(51589278,'created_by','JOSM'),(51589281,'created_by','JOSM'),(51589284,'created_by','JOSM'),(51589288,'created_by','JOSM'),(51589290,'created_by','JOSM'),(51589293,'created_by','JOSM'),(51589296,'created_by','JOSM'),(51589297,'created_by','JOSM'),(51589299,'created_by','JOSM'),(51589302,'created_by','JOSM'),(51589304,'created_by','JOSM'),(51589307,'created_by','JOSM'),(51589310,'created_by','JOSM'),(51589313,'created_by','JOSM'),(51589315,'created_by','JOSM'),(51589320,'created_by','JOSM'),(51589325,'created_by','JOSM'),(51589328,'created_by','JOSM'),(51589334,'created_by','JOSM'),(51589337,'created_by','JOSM'),(51589338,'created_by','JOSM'),(51589340,'created_by','JOSM'),(51589342,'created_by','JOSM'),(51589344,'created_by','JOSM'),(51589348,'created_by','JOSM'),(51589352,'created_by','JOSM'),(51589354,'created_by','JOSM'),(51589357,'created_by','JOSM'),(51589360,'created_by','JOSM'),(51589363,'created_by','JOSM'),(51589366,'created_by','JOSM'),(51589368,'created_by','JOSM'),(51589370,'created_by','JOSM'),(51590535,'created_by','JOSM'),(51590538,'created_by','JOSM'),(51590542,'created_by','JOSM'),(51590544,'created_by','JOSM'),(51590546,'created_by','JOSM'),(51590549,'created_by','JOSM'),(51590551,'created_by','JOSM'),(51590553,'created_by','JOSM'),(51590557,'created_by','JOSM'),(51590560,'created_by','JOSM'),(51590563,'created_by','JOSM'),(51590564,'created_by','JOSM'),(51590567,'created_by','JOSM'),(51590572,'created_by','JOSM'),(51590575,'created_by','JOSM'),(51590578,'created_by','JOSM'),(51590580,'created_by','JOSM'),(51590582,'created_by','JOSM'),(51590585,'created_by','JOSM'),(51590588,'created_by','JOSM'),(51590589,'created_by','JOSM'),(51590592,'created_by','JOSM'),(51590595,'created_by','JOSM'),(51590598,'created_by','JOSM'),(51590600,'created_by','JOSM'),(51590603,'created_by','JOSM'),(51590606,'created_by','JOSM'),(51590608,'created_by','JOSM'),(51590611,'created_by','JOSM'),(51590613,'created_by','JOSM'),(51590616,'created_by','JOSM'),(51590619,'created_by','JOSM'),(51590622,'created_by','JOSM'),(51590623,'created_by','JOSM'),(51590626,'created_by','JOSM'),(51590630,'created_by','JOSM'),(51590631,'created_by','JOSM'),(51590633,'created_by','JOSM'),(51590634,'created_by','JOSM'),(51590635,'created_by','JOSM'),(51590636,'created_by','JOSM'),(51590637,'created_by','JOSM'),(51590638,'created_by','JOSM'),(51590643,'created_by','JOSM'),(51590645,'created_by','JOSM'),(51590646,'created_by','JOSM'),(51590648,'created_by','JOSM'),(51590650,'created_by','JOSM'),(51590653,'created_by','JOSM'),(51590654,'created_by','JOSM'),(51590657,'created_by','JOSM'),(51590660,'created_by','JOSM'),(51590663,'created_by','JOSM'),(51590665,'created_by','JOSM'),(51590668,'created_by','JOSM'),(51590669,'created_by','JOSM'),(51590671,'created_by','JOSM'),(51590673,'created_by','JOSM'),(51590676,'created_by','JOSM'),(51590679,'created_by','JOSM'),(51590680,'created_by','JOSM'),(51590683,'created_by','JOSM'),(51590686,'created_by','JOSM'),(51590687,'created_by','JOSM'),(51590690,'created_by','JOSM'),(51590691,'created_by','JOSM'),(51590693,'created_by','JOSM'),(51590695,'created_by','JOSM'),(51590699,'created_by','JOSM'),(51590702,'created_by','JOSM'),(51590705,'created_by','JOSM'),(51590707,'created_by','JOSM'),(51590708,'created_by','JOSM'),(51590711,'created_by','JOSM'),(51590714,'created_by','JOSM'),(51590716,'created_by','JOSM'),(51590719,'created_by','JOSM'),(51590722,'created_by','JOSM'),(51590725,'created_by','JOSM'),(51590728,'created_by','JOSM'),(51590730,'created_by','JOSM'),(51929590,'created_by','JOSM'),(51929593,'created_by','JOSM'),(51929595,'created_by','JOSM'),(51929598,'created_by','JOSM'),(51929600,'created_by','JOSM'),(51929603,'created_by','JOSM'),(51929607,'created_by','JOSM'),(51929610,'created_by','JOSM'),(51929614,'created_by','JOSM'),(51929617,'created_by','JOSM'),(51929619,'created_by','JOSM'),(51929620,'created_by','JOSM'),(51929623,'created_by','JOSM'),(51929625,'created_by','JOSM'),(51929626,'created_by','JOSM'),(51929628,'created_by','JOSM'),(51929630,'created_by','JOSM'),(51929632,'created_by','JOSM'),(51929634,'created_by','JOSM'),(51929636,'created_by','JOSM'),(51929638,'created_by','JOSM'),(51929640,'created_by','JOSM'),(51929642,'created_by','JOSM'),(51929644,'created_by','JOSM'),(51929645,'created_by','JOSM'),(51929647,'created_by','JOSM'),(51929649,'created_by','JOSM'),(51929650,'created_by','JOSM'),(51929653,'created_by','JOSM'),(51929656,'created_by','JOSM'),(51929657,'created_by','JOSM'),(51929660,'created_by','JOSM'),(51929661,'created_by','JOSM'),(51929663,'created_by','JOSM'),(51929665,'created_by','JOSM'),(51929667,'created_by','JOSM'),(51929670,'created_by','JOSM'),(51929671,'created_by','JOSM'),(51929673,'created_by','JOSM'),(51929675,'created_by','JOSM'),(51929677,'created_by','JOSM'),(51929678,'created_by','JOSM'),(51929680,'created_by','JOSM'),(51929682,'created_by','JOSM'),(51929684,'created_by','JOSM'),(51929687,'created_by','JOSM'),(51929689,'created_by','JOSM'),(51929690,'created_by','JOSM'),(51929693,'created_by','JOSM'),(51929696,'created_by','JOSM'),(51929700,'created_by','JOSM'),(51929702,'created_by','JOSM'),(51929704,'created_by','JOSM'),(51929707,'created_by','JOSM'),(51929709,'created_by','JOSM'),(51929711,'created_by','JOSM'),(51929713,'created_by','JOSM'),(51929715,'created_by','JOSM'),(51929717,'created_by','JOSM'),(51929720,'created_by','JOSM'),(51929722,'created_by','JOSM'),(51929725,'created_by','JOSM'),(51929728,'created_by','JOSM'),(51929731,'created_by','JOSM'),(51929734,'created_by','JOSM'),(51929736,'created_by','JOSM'),(51929739,'created_by','JOSM'),(51929741,'created_by','JOSM'),(51929743,'created_by','JOSM'),(51929746,'created_by','JOSM'),(51929749,'created_by','JOSM'),(51929752,'created_by','JOSM'),(51929754,'created_by','JOSM'),(51929757,'created_by','JOSM'),(51929760,'created_by','JOSM'),(51929762,'created_by','JOSM'),(51929764,'created_by','JOSM'),(51929767,'created_by','JOSM'),(51929770,'created_by','JOSM'),(51929771,'created_by','JOSM'),(51929773,'created_by','JOSM'),(51929775,'created_by','JOSM'),(51929777,'created_by','JOSM'),(51929780,'created_by','JOSM'),(51929782,'created_by','JOSM'),(51929784,'created_by','JOSM'),(51929785,'created_by','JOSM'),(51929786,'created_by','JOSM'),(51929788,'created_by','JOSM'),(51929790,'created_by','JOSM'),(51929793,'created_by','JOSM'),(51929796,'created_by','JOSM'),(51929797,'created_by','JOSM'),(51929800,'created_by','JOSM'),(51929802,'created_by','JOSM'),(51929805,'created_by','JOSM'),(51929807,'created_by','JOSM'),(51929810,'created_by','JOSM'),(51929812,'created_by','JOSM'),(51929814,'created_by','JOSM'),(51929818,'created_by','JOSM'),(51929820,'created_by','JOSM'),(51929823,'created_by','JOSM'),(51929825,'created_by','JOSM'),(51929827,'created_by','JOSM'),(51929829,'created_by','JOSM'),(51929833,'created_by','JOSM'),(51929834,'created_by','JOSM'),(51929837,'created_by','JOSM'),(51929840,'created_by','JOSM'),(51929842,'created_by','JOSM'),(51929844,'created_by','JOSM'),(51929846,'created_by','JOSM'),(51929848,'created_by','JOSM'),(51929852,'created_by','JOSM'),(51929854,'created_by','JOSM'),(51929858,'created_by','JOSM'),(51929860,'created_by','JOSM'),(51929862,'created_by','JOSM'),(51929864,'created_by','JOSM'),(51929866,'created_by','JOSM'),(51929869,'created_by','JOSM'),(51929872,'created_by','JOSM'),(51929873,'created_by','JOSM'),(51929875,'created_by','JOSM'),(51929878,'created_by','JOSM'),(51929880,'created_by','JOSM'),(51929883,'created_by','JOSM'),(51929886,'created_by','JOSM'),(51929889,'created_by','JOSM'),(51929892,'created_by','JOSM'),(51929893,'created_by','JOSM'),(51929896,'created_by','JOSM'),(51929899,'created_by','JOSM'),(51929902,'created_by','JOSM'),(51929905,'created_by','JOSM'),(51929907,'created_by','JOSM'),(51929909,'created_by','JOSM'),(51929910,'created_by','JOSM'),(51929913,'created_by','JOSM'),(51929915,'created_by','JOSM'),(51929916,'created_by','JOSM'),(51929918,'created_by','JOSM'),(51929920,'created_by','JOSM'),(51929922,'created_by','JOSM'),(51929923,'created_by','JOSM'),(51929925,'created_by','JOSM'),(51929927,'created_by','JOSM'),(51929930,'created_by','JOSM'),(51929933,'created_by','JOSM'),(51929936,'created_by','JOSM'),(51929938,'created_by','JOSM'),(51929939,'created_by','JOSM'),(51929942,'created_by','JOSM'),(51929943,'created_by','JOSM'),(51929946,'created_by','JOSM'),(51929949,'created_by','JOSM'),(51929950,'created_by','JOSM'),(51929953,'created_by','JOSM'),(51929955,'created_by','JOSM'),(51929957,'created_by','JOSM'),(51929960,'created_by','JOSM'),(51929964,'created_by','JOSM'),(51929966,'created_by','JOSM'),(51929968,'created_by','JOSM'),(51929971,'created_by','JOSM'),(51929974,'created_by','JOSM'),(51929975,'created_by','JOSM'),(51929978,'created_by','JOSM'),(51929980,'created_by','JOSM'),(51929983,'created_by','JOSM'),(51929986,'created_by','JOSM'),(51929988,'created_by','JOSM'),(51929990,'created_by','JOSM'),(51929993,'created_by','JOSM'),(51929999,'created_by','JOSM'),(51930002,'created_by','JOSM'),(51930009,'created_by','JOSM'),(51930014,'created_by','JOSM'),(51930018,'created_by','JOSM'),(51930020,'created_by','JOSM'),(51930022,'created_by','JOSM'),(51930024,'created_by','JOSM'),(51930026,'created_by','JOSM'),(51930029,'created_by','JOSM'),(51930031,'created_by','JOSM'),(51930033,'created_by','JOSM'),(51930035,'created_by','JOSM'),(51930037,'created_by','JOSM'),(51930040,'created_by','JOSM'),(51930043,'created_by','JOSM'),(51930044,'created_by','JOSM'),(51930047,'created_by','JOSM'),(51930048,'created_by','JOSM'),(51930050,'created_by','JOSM'),(51930052,'created_by','JOSM'),(51930053,'created_by','JOSM'),(51930055,'created_by','JOSM'),(51930058,'created_by','JOSM'),(51930062,'created_by','JOSM'),(51930063,'created_by','JOSM'),(51930066,'created_by','JOSM'),(51930068,'created_by','JOSM'),(51930071,'created_by','JOSM'),(51930073,'created_by','JOSM'),(51930076,'created_by','JOSM'),(51930079,'created_by','JOSM'),(51930080,'created_by','JOSM'),(51930082,'created_by','JOSM'),(51930085,'created_by','JOSM'),(51930088,'created_by','JOSM'),(51930092,'created_by','JOSM'),(51930094,'created_by','JOSM'),(51930096,'created_by','JOSM'),(51930098,'created_by','JOSM'),(51930099,'created_by','JOSM'),(51930102,'created_by','JOSM'),(51930104,'created_by','JOSM'),(51930107,'created_by','JOSM'),(51930108,'created_by','JOSM'),(51930110,'created_by','JOSM'),(51930112,'created_by','JOSM'),(51930113,'created_by','JOSM'),(51930115,'created_by','JOSM'),(51930118,'created_by','JOSM'),(51930119,'created_by','JOSM'),(51930121,'created_by','JOSM'),(51930124,'created_by','JOSM'),(51930125,'created_by','JOSM'),(51930127,'created_by','JOSM'),(51930129,'created_by','JOSM'),(51930132,'created_by','JOSM'),(51930134,'created_by','JOSM'),(51930136,'created_by','JOSM'),(51930138,'created_by','JOSM'),(51930141,'created_by','JOSM'),(51930143,'created_by','JOSM'),(51930145,'created_by','JOSM'),(51930148,'created_by','JOSM'),(51930149,'created_by','JOSM'),(51930152,'created_by','JOSM'),(51930153,'created_by','JOSM'),(51930156,'created_by','JOSM'),(51930158,'created_by','JOSM'),(51930160,'created_by','JOSM'),(51930163,'created_by','JOSM'),(51930165,'created_by','JOSM'),(51930167,'created_by','JOSM'),(51930171,'created_by','JOSM'),(51930173,'created_by','JOSM'),(51930175,'created_by','JOSM'),(51930178,'created_by','JOSM'),(51930181,'created_by','JOSM'),(51930184,'created_by','JOSM'),(51930186,'ele','1987'),(51930186,'mountain_pass','yes'),(51930186,'name','Col d\'Ordino'),(51930188,'created_by','JOSM'),(51930191,'created_by','JOSM'),(51930193,'created_by','JOSM'),(51930195,'created_by','JOSM'),(51930198,'created_by','JOSM'),(51930199,'created_by','JOSM'),(51930202,'created_by','JOSM'),(51930206,'created_by','JOSM'),(51930208,'created_by','JOSM'),(51930211,'created_by','JOSM'),(51930213,'created_by','JOSM'),(51930216,'created_by','JOSM'),(51930219,'created_by','JOSM'),(51930222,'created_by','JOSM'),(51930223,'created_by','JOSM'),(51930226,'created_by','JOSM'),(51930228,'created_by','JOSM'),(51930230,'created_by','JOSM'),(51930232,'created_by','JOSM'),(51930235,'created_by','JOSM'),(51930238,'created_by','JOSM'),(51930241,'created_by','JOSM'),(51930242,'created_by','JOSM'),(51930245,'created_by','JOSM'),(51930247,'created_by','JOSM'),(51930250,'created_by','JOSM'),(51930252,'created_by','JOSM'),(51930253,'created_by','JOSM'),(51930255,'created_by','JOSM'),(51930257,'created_by','JOSM'),(51930259,'created_by','JOSM'),(51930262,'created_by','JOSM'),(51930264,'created_by','JOSM'),(51930267,'created_by','JOSM'),(51930270,'created_by','JOSM'),(51930272,'created_by','JOSM'),(51930275,'created_by','JOSM'),(51930278,'created_by','JOSM'),(51930280,'created_by','JOSM'),(51930282,'created_by','JOSM'),(51930284,'created_by','JOSM'),(51930288,'created_by','JOSM'),(51930291,'created_by','JOSM'),(51930293,'created_by','JOSM'),(51930297,'created_by','JOSM'),(51930299,'created_by','JOSM'),(51930302,'created_by','JOSM'),(51930305,'created_by','JOSM'),(51930307,'created_by','JOSM'),(51930309,'created_by','JOSM'),(51930311,'created_by','JOSM'),(51930312,'created_by','JOSM'),(51930313,'created_by','JOSM'),(51930314,'created_by','JOSM'),(51930315,'created_by','JOSM'),(51930319,'created_by','JOSM'),(51930321,'created_by','JOSM'),(51930324,'created_by','JOSM'),(51930326,'created_by','JOSM'),(51930328,'created_by','JOSM'),(51930331,'created_by','JOSM'),(51930332,'created_by','JOSM'),(51930334,'created_by','JOSM'),(51930336,'created_by','JOSM'),(51930338,'created_by','JOSM'),(51930340,'created_by','JOSM'),(51930343,'created_by','JOSM'),(51930345,'created_by','JOSM'),(51930348,'created_by','JOSM'),(51930349,'created_by','JOSM'),(51930352,'created_by','JOSM'),(51930354,'created_by','JOSM'),(51930357,'created_by','JOSM'),(51930359,'created_by','JOSM'),(51930360,'created_by','JOSM'),(51930362,'created_by','JOSM'),(51930364,'created_by','JOSM'),(51930365,'created_by','JOSM'),(51930368,'created_by','JOSM'),(51930371,'created_by','JOSM'),(51930373,'created_by','JOSM'),(51930376,'created_by','JOSM'),(51930378,'created_by','JOSM'),(51930380,'created_by','JOSM'),(51930382,'created_by','JOSM'),(51930384,'created_by','JOSM'),(51930386,'created_by','JOSM'),(51930388,'created_by','JOSM'),(51930390,'created_by','JOSM'),(51930396,'created_by','JOSM'),(51930403,'created_by','JOSM'),(51930405,'created_by','JOSM'),(51930408,'created_by','JOSM'),(51930410,'created_by','JOSM'),(51930412,'created_by','JOSM'),(51930413,'created_by','JOSM'),(51930415,'created_by','JOSM'),(51930416,'created_by','JOSM'),(51930417,'created_by','JOSM'),(51930418,'created_by','JOSM'),(51930420,'created_by','JOSM'),(51930422,'created_by','JOSM'),(51930424,'created_by','JOSM'),(51930426,'created_by','JOSM'),(51930428,'created_by','JOSM'),(51930429,'created_by','JOSM'),(51930433,'created_by','JOSM'),(51930437,'created_by','JOSM'),(51930439,'created_by','JOSM'),(51930441,'created_by','JOSM'),(51930443,'created_by','JOSM'),(51930445,'created_by','JOSM'),(51930447,'created_by','JOSM'),(51930447,'ele','1952'),(51930447,'mountain_pass','yes'),(51930447,'name','Collet de Montaup'),(51930448,'created_by','JOSM'),(51930449,'created_by','JOSM'),(51930450,'created_by','JOSM'),(51930453,'created_by','JOSM'),(51930455,'created_by','JOSM'),(51930457,'created_by','JOSM'),(51930458,'created_by','JOSM'),(51930461,'created_by','JOSM'),(51930462,'created_by','JOSM'),(51930465,'created_by','JOSM'),(51930467,'created_by','JOSM'),(51930469,'created_by','JOSM'),(51930470,'created_by','JOSM'),(51930473,'created_by','JOSM'),(51930475,'created_by','JOSM'),(51930478,'created_by','JOSM'),(51930481,'created_by','JOSM'),(51930483,'created_by','JOSM'),(51930485,'created_by','JOSM'),(51930488,'created_by','JOSM'),(51930492,'created_by','JOSM'),(51930495,'created_by','JOSM'),(51930497,'created_by','JOSM'),(51930500,'created_by','JOSM'),(51930503,'created_by','JOSM'),(51930505,'created_by','JOSM'),(51930507,'created_by','JOSM'),(51930509,'created_by','JOSM'),(51930511,'created_by','JOSM'),(51930513,'created_by','JOSM'),(51930517,'created_by','JOSM'),(51930519,'created_by','JOSM'),(51930521,'created_by','JOSM'),(51930524,'created_by','JOSM'),(51930527,'created_by','JOSM'),(51930531,'created_by','JOSM'),(51930534,'created_by','JOSM'),(51930537,'created_by','JOSM'),(51930540,'created_by','JOSM'),(51930542,'created_by','JOSM'),(51930544,'created_by','JOSM'),(51930548,'created_by','JOSM'),(51930553,'created_by','JOSM'),(51930556,'created_by','JOSM'),(51930560,'created_by','JOSM'),(51930563,'created_by','JOSM'),(51930565,'created_by','JOSM'),(51930567,'created_by','JOSM'),(51930569,'created_by','JOSM'),(51930572,'created_by','JOSM'),(51930573,'created_by','JOSM'),(51930576,'created_by','JOSM'),(51930579,'created_by','JOSM'),(51930582,'created_by','JOSM'),(51930583,'created_by','JOSM'),(51930586,'created_by','JOSM'),(51930588,'created_by','JOSM'),(51930590,'created_by','JOSM'),(51930593,'created_by','JOSM'),(51930595,'created_by','JOSM'),(51930597,'created_by','JOSM'),(51930599,'created_by','JOSM'),(51930602,'created_by','JOSM'),(51930604,'created_by','JOSM'),(51930606,'created_by','JOSM'),(51930609,'created_by','JOSM'),(51930611,'created_by','JOSM'),(51930614,'created_by','JOSM'),(51930616,'created_by','JOSM'),(51930619,'created_by','JOSM'),(51930621,'created_by','JOSM'),(51930623,'created_by','JOSM'),(51930626,'created_by','JOSM'),(51930628,'created_by','JOSM'),(51930630,'created_by','JOSM'),(51930633,'created_by','JOSM'),(51930636,'created_by','JOSM'),(51930638,'created_by','JOSM'),(51930640,'created_by','JOSM'),(51930641,'created_by','JOSM'),(51930643,'created_by','JOSM'),(51930645,'created_by','JOSM'),(51930648,'created_by','JOSM'),(51930650,'created_by','JOSM'),(51930652,'created_by','JOSM'),(51930653,'created_by','JOSM'),(51930656,'created_by','JOSM'),(51930657,'created_by','JOSM'),(51930661,'created_by','JOSM'),(51930663,'created_by','JOSM'),(51930665,'created_by','JOSM'),(51930668,'created_by','JOSM'),(51930671,'created_by','JOSM'),(51930674,'created_by','JOSM'),(51930676,'created_by','JOSM'),(51930680,'created_by','JOSM'),(51930682,'created_by','JOSM'),(51930684,'created_by','JOSM'),(51930686,'created_by','JOSM'),(51930687,'created_by','JOSM'),(51930689,'created_by','JOSM'),(51930691,'created_by','JOSM'),(51930692,'created_by','JOSM'),(51930695,'created_by','JOSM'),(51930697,'created_by','JOSM'),(51930699,'created_by','JOSM'),(51930702,'created_by','JOSM'),(51930705,'created_by','JOSM'),(51930706,'created_by','JOSM'),(51930709,'created_by','JOSM'),(51930712,'created_by','JOSM'),(51930713,'created_by','JOSM'),(51930716,'created_by','JOSM'),(51930718,'created_by','JOSM'),(51930721,'created_by','JOSM'),(51930723,'created_by','JOSM'),(51930726,'created_by','JOSM'),(51930727,'created_by','JOSM'),(51930729,'created_by','JOSM'),(51930731,'created_by','JOSM'),(51930732,'created_by','JOSM'),(51930734,'created_by','JOSM'),(51930736,'created_by','JOSM'),(51930738,'created_by','JOSM'),(51930741,'created_by','JOSM'),(51930743,'created_by','JOSM'),(51930745,'created_by','JOSM'),(51930748,'created_by','JOSM'),(51930750,'created_by','JOSM'),(51930751,'created_by','JOSM'),(51930754,'created_by','JOSM'),(51930756,'created_by','JOSM'),(51930758,'created_by','JOSM'),(51930761,'created_by','JOSM'),(51930762,'created_by','JOSM'),(51930765,'created_by','JOSM'),(51930768,'created_by','JOSM'),(51930769,'created_by','JOSM'),(51930771,'created_by','JOSM'),(51930775,'created_by','JOSM'),(51930777,'created_by','JOSM'),(51930779,'created_by','JOSM'),(51930781,'created_by','JOSM'),(51930783,'created_by','JOSM'),(51930786,'created_by','JOSM'),(51930788,'created_by','JOSM'),(51930790,'created_by','JOSM'),(51930793,'created_by','JOSM'),(51930794,'created_by','JOSM'),(51930797,'created_by','JOSM'),(51930800,'created_by','JOSM'),(51930802,'created_by','JOSM'),(51930806,'created_by','JOSM'),(51930807,'created_by','JOSM'),(51930808,'created_by','JOSM'),(51930809,'created_by','JOSM'),(51930812,'created_by','JOSM'),(51930814,'created_by','JOSM'),(51930815,'created_by','JOSM'),(51930816,'created_by','JOSM'),(51930818,'created_by','JOSM'),(51930821,'created_by','JOSM'),(51930823,'created_by','JOSM'),(51930826,'created_by','JOSM'),(51930828,'created_by','JOSM'),(51930830,'created_by','JOSM'),(51930831,'created_by','JOSM'),(51930834,'created_by','JOSM'),(51930836,'created_by','JOSM'),(51930839,'created_by','JOSM'),(51930840,'created_by','JOSM'),(51930843,'created_by','JOSM'),(51930844,'created_by','JOSM'),(51930847,'created_by','JOSM'),(51930850,'created_by','JOSM'),(51930851,'created_by','JOSM'),(51930854,'created_by','JOSM'),(51930855,'created_by','JOSM'),(51930858,'created_by','JOSM'),(51930859,'created_by','JOSM'),(51930862,'created_by','JOSM'),(51930864,'created_by','JOSM'),(51930865,'created_by','JOSM'),(51930866,'created_by','JOSM'),(51930867,'created_by','JOSM'),(51930869,'created_by','JOSM'),(51930871,'created_by','JOSM'),(51930873,'created_by','JOSM'),(51930876,'created_by','JOSM'),(51930879,'created_by','JOSM'),(51930882,'created_by','JOSM'),(51930883,'created_by','JOSM'),(51930885,'created_by','JOSM'),(51930887,'created_by','JOSM'),(51930889,'created_by','JOSM'),(51930891,'created_by','JOSM'),(51930893,'created_by','JOSM'),(51930895,'created_by','JOSM'),(51930896,'created_by','JOSM'),(51930898,'created_by','JOSM'),(51930900,'created_by','JOSM'),(51930901,'created_by','JOSM'),(51930905,'created_by','JOSM'),(51930907,'created_by','JOSM'),(51930908,'created_by','JOSM'),(51930909,'created_by','JOSM'),(51930911,'created_by','JOSM'),(51930913,'created_by','JOSM'),(51930915,'created_by','JOSM'),(51930918,'created_by','JOSM'),(51930920,'created_by','JOSM'),(51930923,'created_by','JOSM'),(51930926,'created_by','JOSM'),(51930928,'created_by','JOSM'),(51930930,'created_by','JOSM'),(51930932,'created_by','JOSM'),(51930935,'created_by','JOSM'),(51930937,'created_by','JOSM'),(51930940,'created_by','JOSM'),(51930942,'created_by','JOSM'),(51930944,'created_by','JOSM'),(51930947,'created_by','JOSM'),(51930950,'created_by','JOSM'),(51930952,'created_by','JOSM'),(51930953,'created_by','JOSM'),(51930954,'created_by','JOSM'),(51930956,'created_by','JOSM'),(51930958,'created_by','JOSM'),(51930961,'created_by','JOSM'),(51930962,'created_by','JOSM'),(51930965,'created_by','JOSM'),(51930967,'created_by','JOSM'),(51930968,'created_by','JOSM'),(51930971,'created_by','JOSM'),(51930973,'created_by','JOSM'),(51930974,'created_by','JOSM'),(51930975,'created_by','JOSM'),(51930976,'created_by','JOSM'),(51930978,'created_by','JOSM'),(51930981,'created_by','JOSM'),(51930983,'created_by','JOSM'),(51930984,'created_by','JOSM'),(51930985,'created_by','JOSM'),(51930986,'created_by','JOSM'),(51930987,'created_by','JOSM'),(51930990,'created_by','JOSM'),(51930992,'created_by','JOSM'),(51930995,'created_by','JOSM'),(51930998,'created_by','JOSM'),(51930999,'created_by','JOSM'),(51931002,'created_by','JOSM'),(51931005,'created_by','JOSM'),(51931006,'created_by','JOSM'),(51931009,'created_by','JOSM'),(51931012,'created_by','JOSM'),(51931014,'created_by','JOSM'),(51931018,'created_by','JOSM'),(51931020,'created_by','JOSM'),(51931023,'created_by','JOSM'),(51931025,'created_by','JOSM'),(51931026,'created_by','JOSM'),(51931029,'created_by','JOSM'),(51931032,'created_by','JOSM'),(51931036,'created_by','JOSM'),(51931037,'created_by','JOSM'),(51931040,'created_by','JOSM'),(51931043,'created_by','JOSM'),(51931045,'created_by','JOSM'),(51931047,'created_by','JOSM'),(51931050,'created_by','JOSM'),(51931053,'created_by','JOSM'),(51931055,'created_by','JOSM'),(51931057,'created_by','JOSM'),(51931060,'created_by','JOSM'),(51931062,'created_by','JOSM'),(51931065,'created_by','JOSM'),(51931066,'created_by','JOSM'),(51931069,'created_by','JOSM'),(51931070,'created_by','JOSM'),(51931073,'created_by','JOSM'),(51931076,'created_by','JOSM'),(51931077,'created_by','JOSM'),(51931080,'created_by','JOSM'),(51931084,'created_by','JOSM'),(51931087,'created_by','JOSM'),(51931090,'created_by','JOSM'),(51931093,'created_by','JOSM'),(51931095,'created_by','JOSM'),(51931097,'created_by','JOSM'),(51931099,'created_by','JOSM'),(51931101,'created_by','JOSM'),(51931103,'created_by','JOSM'),(51931105,'created_by','JOSM'),(51951640,'created_by','JOSM'),(51951645,'created_by','JOSM'),(51951647,'created_by','JOSM'),(51951648,'created_by','JOSM'),(51951650,'created_by','JOSM'),(51951652,'created_by','JOSM'),(51951654,'created_by','JOSM'),(51951657,'created_by','JOSM'),(51951658,'created_by','JOSM'),(51951661,'created_by','JOSM'),(51951665,'created_by','JOSM'),(51951667,'created_by','JOSM'),(51951670,'created_by','JOSM'),(51951673,'created_by','JOSM'),(51951676,'created_by','JOSM'),(51951678,'created_by','JOSM'),(51951680,'created_by','JOSM'),(51951682,'created_by','JOSM'),(51951684,'created_by','JOSM'),(51951686,'created_by','JOSM'),(51951689,'created_by','JOSM'),(51951690,'created_by','JOSM'),(51951692,'created_by','JOSM'),(51951694,'created_by','JOSM'),(51951696,'created_by','JOSM'),(51951700,'created_by','JOSM'),(51951701,'created_by','JOSM'),(51951703,'created_by','JOSM'),(51951706,'created_by','JOSM'),(51951709,'created_by','JOSM'),(51951711,'created_by','JOSM'),(51951713,'created_by','JOSM'),(51951716,'created_by','JOSM'),(51951719,'created_by','JOSM'),(51951723,'created_by','JOSM'),(51951726,'created_by','JOSM'),(51951729,'created_by','JOSM'),(51951731,'created_by','JOSM'),(51951734,'created_by','JOSM'),(51951736,'created_by','JOSM'),(51951739,'created_by','JOSM'),(51951741,'created_by','JOSM'),(51951744,'created_by','JOSM'),(51951747,'created_by','JOSM'),(51951748,'created_by','JOSM'),(51951751,'created_by','JOSM'),(51951755,'created_by','JOSM'),(51951758,'created_by','JOSM'),(51951761,'created_by','JOSM'),(51951763,'created_by','JOSM'),(51951766,'created_by','JOSM'),(51951769,'created_by','JOSM'),(51951772,'created_by','JOSM'),(51951775,'created_by','JOSM'),(51951777,'created_by','JOSM'),(51951780,'created_by','JOSM'),(51951784,'created_by','JOSM'),(51951785,'created_by','JOSM'),(51951788,'created_by','JOSM'),(51951790,'created_by','JOSM'),(51951793,'created_by','JOSM'),(51951796,'created_by','JOSM'),(51951799,'created_by','JOSM'),(51951801,'created_by','JOSM'),(51951805,'created_by','JOSM'),(51951808,'created_by','JOSM'),(51951810,'created_by','JOSM'),(51951813,'created_by','JOSM'),(51951816,'created_by','JOSM'),(51951817,'created_by','JOSM'),(51951819,'created_by','JOSM'),(51951821,'created_by','JOSM'),(51951824,'created_by','JOSM'),(51951827,'created_by','JOSM'),(51951830,'created_by','JOSM'),(51951833,'created_by','JOSM'),(51951836,'created_by','JOSM'),(51951838,'created_by','JOSM'),(51951840,'created_by','JOSM'),(51951843,'created_by','JOSM'),(51951846,'created_by','JOSM'),(51951848,'created_by','JOSM'),(51951851,'created_by','JOSM'),(51951854,'created_by','JOSM'),(51951857,'created_by','JOSM'),(51951858,'created_by','JOSM'),(51951859,'created_by','JOSM'),(51951861,'created_by','JOSM'),(51951864,'created_by','JOSM'),(51951865,'created_by','JOSM'),(51951868,'created_by','JOSM'),(51951872,'created_by','JOSM'),(51951874,'created_by','JOSM'),(51951876,'created_by','JOSM'),(51951879,'created_by','JOSM'),(51951882,'created_by','JOSM'),(51951885,'created_by','JOSM'),(51951886,'created_by','JOSM'),(51951889,'created_by','JOSM'),(51951892,'created_by','JOSM'),(51951895,'created_by','JOSM'),(51951898,'created_by','JOSM'),(51951900,'created_by','JOSM'),(51951903,'created_by','JOSM'),(51951905,'created_by','JOSM'),(51951908,'created_by','JOSM'),(51951911,'created_by','JOSM'),(51951914,'created_by','JOSM'),(51951917,'created_by','JOSM'),(51951920,'created_by','JOSM'),(51951922,'created_by','JOSM'),(51951924,'created_by','JOSM'),(51951927,'created_by','JOSM'),(51951930,'created_by','JOSM'),(51951933,'created_by','JOSM'),(51951935,'created_by','JOSM'),(51951937,'created_by','JOSM'),(51951938,'created_by','JOSM'),(51951941,'created_by','JOSM'),(51951944,'created_by','JOSM'),(51951947,'created_by','JOSM'),(51951950,'created_by','JOSM'),(51951953,'created_by','JOSM'),(51951956,'created_by','JOSM'),(51951957,'created_by','JOSM'),(51951960,'created_by','JOSM'),(51951963,'created_by','JOSM'),(51951965,'created_by','JOSM'),(51951966,'created_by','JOSM'),(51951969,'created_by','JOSM'),(51951970,'created_by','JOSM'),(51951973,'created_by','JOSM'),(51951975,'created_by','JOSM'),(51951978,'created_by','JOSM'),(51951980,'created_by','JOSM'),(51951983,'created_by','JOSM'),(51951985,'created_by','JOSM'),(51951988,'created_by','JOSM'),(51951989,'created_by','JOSM'),(51951992,'created_by','JOSM'),(51951995,'created_by','JOSM'),(51951999,'created_by','JOSM'),(51952002,'created_by','JOSM'),(51952005,'created_by','JOSM'),(51952009,'created_by','JOSM'),(51952013,'created_by','JOSM'),(51952014,'created_by','JOSM'),(51952017,'created_by','JOSM'),(51952019,'created_by','JOSM'),(51952022,'created_by','JOSM'),(51952025,'created_by','JOSM'),(51952028,'created_by','JOSM'),(51952029,'created_by','JOSM'),(51952031,'created_by','JOSM'),(51952034,'created_by','JOSM'),(51952037,'created_by','JOSM'),(51952039,'created_by','JOSM'),(51952042,'created_by','JOSM'),(51952045,'created_by','JOSM'),(51952046,'created_by','JOSM'),(51952048,'created_by','JOSM'),(51952050,'created_by','JOSM'),(51952053,'created_by','JOSM'),(51952055,'created_by','JOSM'),(51952058,'created_by','JOSM'),(51952060,'created_by','JOSM'),(51952063,'created_by','JOSM'),(51952065,'created_by','JOSM'),(51952068,'created_by','JOSM'),(51952069,'created_by','JOSM'),(51952073,'created_by','JOSM'),(51952075,'created_by','JOSM'),(51952078,'created_by','JOSM'),(51952080,'created_by','JOSM'),(51952083,'created_by','JOSM'),(51952084,'created_by','JOSM'),(51952087,'created_by','JOSM'),(51952090,'created_by','JOSM'),(51952093,'created_by','JOSM'),(51952096,'created_by','JOSM'),(51952099,'created_by','JOSM'),(51952101,'created_by','JOSM'),(51952103,'created_by','JOSM'),(51952105,'created_by','JOSM'),(51952107,'created_by','JOSM'),(51952110,'created_by','JOSM'),(51952111,'created_by','JOSM'),(51952113,'created_by','JOSM'),(51952115,'created_by','JOSM'),(51952118,'created_by','JOSM'),(51952120,'created_by','JOSM'),(51952122,'created_by','JOSM'),(51952125,'created_by','JOSM'),(51952126,'created_by','JOSM'),(51952128,'created_by','JOSM'),(51952132,'created_by','JOSM'),(51952136,'created_by','JOSM'),(51952139,'created_by','JOSM'),(51952141,'created_by','JOSM'),(51952145,'created_by','JOSM'),(51952148,'created_by','JOSM'),(51952150,'created_by','JOSM'),(51952152,'created_by','JOSM'),(51952155,'created_by','JOSM'),(51952157,'created_by','JOSM'),(51952159,'created_by','JOSM'),(51952161,'created_by','JOSM'),(51952163,'created_by','JOSM'),(51952167,'created_by','JOSM'),(51952170,'created_by','JOSM'),(51952172,'created_by','JOSM'),(51952176,'created_by','JOSM'),(51952177,'created_by','JOSM'),(51952180,'created_by','JOSM'),(51952183,'created_by','JOSM'),(51952185,'created_by','JOSM'),(51952187,'created_by','JOSM'),(51952190,'created_by','JOSM'),(51952192,'created_by','JOSM'),(51952193,'created_by','JOSM'),(51952195,'created_by','JOSM'),(51952196,'created_by','JOSM'),(51952199,'created_by','JOSM'),(51952201,'created_by','JOSM'),(51952204,'created_by','JOSM'),(51952205,'created_by','JOSM'),(51952207,'created_by','JOSM'),(51952210,'created_by','JOSM'),(51952213,'created_by','JOSM'),(51952215,'created_by','JOSM'),(51952217,'created_by','JOSM'),(51952220,'created_by','JOSM'),(51952223,'created_by','JOSM'),(51952226,'created_by','JOSM'),(51952230,'created_by','JOSM'),(51952233,'created_by','JOSM'),(51952236,'created_by','JOSM'),(51952238,'created_by','JOSM'),(51952240,'created_by','JOSM'),(51952243,'created_by','JOSM'),(51952246,'created_by','JOSM'),(51952248,'created_by','JOSM'),(51952250,'created_by','JOSM'),(51952252,'created_by','JOSM'),(51952255,'created_by','JOSM'),(51952256,'created_by','JOSM'),(51952259,'created_by','JOSM'),(51952530,'created_by','JOSM'),(51952532,'created_by','JOSM'),(51952534,'created_by','JOSM'),(51952536,'created_by','JOSM'),(51952539,'created_by','JOSM'),(51952542,'created_by','JOSM'),(51952545,'created_by','JOSM'),(51952546,'created_by','JOSM'),(51952549,'created_by','JOSM'),(51952552,'created_by','JOSM'),(51952556,'created_by','JOSM'),(51952559,'created_by','JOSM'),(51952562,'created_by','JOSM'),(51952566,'created_by','JOSM'),(51952570,'created_by','JOSM'),(51952573,'created_by','JOSM'),(51952575,'created_by','JOSM'),(51952578,'created_by','JOSM'),(51952580,'created_by','JOSM'),(51952583,'created_by','JOSM'),(51952584,'created_by','JOSM'),(51952586,'created_by','JOSM'),(51952590,'created_by','JOSM'),(51952594,'created_by','JOSM'),(51952597,'created_by','JOSM'),(51952599,'created_by','JOSM'),(51952601,'created_by','JOSM'),(51952604,'created_by','JOSM'),(51952605,'created_by','JOSM'),(51952608,'created_by','JOSM'),(51952610,'created_by','JOSM'),(51952613,'created_by','JOSM'),(51952615,'created_by','JOSM'),(51952618,'created_by','JOSM'),(51952620,'created_by','JOSM'),(51952623,'created_by','JOSM'),(51952627,'created_by','JOSM'),(51952630,'created_by','JOSM'),(51952632,'created_by','JOSM'),(51952634,'created_by','JOSM'),(51952635,'created_by','JOSM'),(51952638,'created_by','JOSM'),(51952640,'created_by','JOSM'),(51952643,'created_by','JOSM'),(51952647,'created_by','JOSM'),(51952649,'created_by','JOSM'),(51952652,'created_by','JOSM'),(51952653,'created_by','JOSM'),(51952656,'created_by','JOSM'),(51952659,'created_by','JOSM'),(51952662,'created_by','JOSM'),(51952665,'created_by','JOSM'),(51952667,'created_by','JOSM'),(51952668,'created_by','JOSM'),(51952671,'created_by','JOSM'),(51952672,'created_by','JOSM'),(51952675,'created_by','JOSM'),(51952677,'created_by','JOSM'),(51952682,'created_by','JOSM'),(51952684,'created_by','JOSM'),(51952686,'created_by','JOSM'),(51952689,'created_by','JOSM'),(51952690,'created_by','JOSM'),(51952692,'created_by','JOSM'),(51952694,'created_by','JOSM'),(51952695,'created_by','JOSM'),(51952699,'created_by','JOSM'),(51952701,'created_by','JOSM'),(51952702,'created_by','JOSM'),(51952705,'created_by','JOSM'),(51952706,'created_by','JOSM'),(51952709,'created_by','JOSM'),(51952712,'created_by','JOSM'),(51952714,'created_by','JOSM'),(51952715,'created_by','JOSM'),(51952717,'created_by','JOSM'),(51952719,'created_by','JOSM'),(51952722,'created_by','JOSM'),(51952724,'created_by','JOSM'),(51952727,'created_by','JOSM'),(51952729,'created_by','JOSM'),(51952732,'created_by','JOSM'),(51952733,'created_by','JOSM'),(51952737,'created_by','JOSM'),(51952740,'created_by','JOSM'),(51952742,'created_by','JOSM'),(51952745,'created_by','JOSM'),(51952748,'created_by','JOSM'),(51952751,'created_by','JOSM'),(51952754,'created_by','JOSM'),(51952756,'created_by','JOSM'),(51952758,'created_by','JOSM'),(51952761,'created_by','JOSM'),(51952764,'created_by','JOSM'),(51952767,'created_by','JOSM'),(51952770,'created_by','JOSM'),(51952772,'created_by','JOSM'),(51952775,'created_by','JOSM'),(51952777,'created_by','JOSM'),(51952780,'created_by','JOSM'),(51952782,'created_by','JOSM'),(51952784,'created_by','JOSM'),(51952786,'created_by','JOSM'),(51952788,'created_by','JOSM'),(51952790,'created_by','JOSM'),(51952792,'created_by','JOSM'),(51952795,'created_by','JOSM'),(51952797,'created_by','JOSM'),(51952800,'created_by','JOSM'),(51952802,'created_by','JOSM'),(51952804,'created_by','JOSM'),(51952807,'created_by','JOSM'),(51952811,'created_by','JOSM'),(51952813,'created_by','JOSM'),(51952815,'created_by','JOSM'),(51952818,'created_by','JOSM'),(51952820,'created_by','JOSM'),(51952824,'created_by','JOSM'),(51952827,'created_by','JOSM'),(51952829,'created_by','JOSM'),(51952831,'created_by','JOSM'),(51952832,'created_by','JOSM'),(51952834,'created_by','JOSM'),(51952837,'created_by','JOSM'),(51952840,'created_by','JOSM'),(51952842,'created_by','JOSM'),(51956993,'created_by','JOSM'),(51956997,'created_by','JOSM'),(51956999,'created_by','JOSM'),(51957002,'created_by','JOSM'),(51957005,'created_by','JOSM'),(51957008,'created_by','JOSM'),(51957009,'created_by','JOSM'),(51957013,'created_by','JOSM'),(51957016,'created_by','JOSM'),(51957020,'created_by','JOSM'),(51957022,'created_by','JOSM'),(51957024,'created_by','JOSM'),(51957025,'created_by','JOSM'),(51957027,'created_by','JOSM'),(51957030,'created_by','JOSM'),(51957031,'created_by','JOSM'),(51957034,'created_by','JOSM'),(51957037,'created_by','JOSM'),(51957040,'created_by','JOSM'),(51957042,'created_by','JOSM'),(51957045,'created_by','JOSM'),(51957048,'created_by','JOSM'),(51957050,'created_by','JOSM'),(51957052,'created_by','JOSM'),(51957055,'created_by','JOSM'),(51957057,'created_by','JOSM'),(51957060,'created_by','JOSM'),(51957063,'created_by','JOSM'),(51957064,'created_by','JOSM'),(51957066,'created_by','JOSM'),(51957069,'created_by','JOSM'),(51957072,'created_by','JOSM'),(51957075,'created_by','JOSM'),(51957077,'created_by','JOSM'),(51957080,'created_by','JOSM'),(51957082,'created_by','JOSM'),(51957085,'created_by','JOSM'),(51957087,'created_by','JOSM'),(51957090,'created_by','JOSM'),(51957092,'created_by','JOSM'),(51957094,'created_by','JOSM'),(51957098,'created_by','JOSM'),(51957101,'created_by','JOSM'),(51957103,'created_by','JOSM'),(51957105,'created_by','JOSM'),(51957110,'created_by','JOSM'),(51957112,'created_by','JOSM'),(51957115,'created_by','JOSM'),(51957117,'created_by','JOSM'),(51957119,'created_by','JOSM'),(51957121,'created_by','JOSM'),(51957125,'created_by','JOSM'),(51957128,'created_by','JOSM'),(51957131,'created_by','JOSM'),(51957134,'created_by','JOSM'),(51957135,'created_by','JOSM'),(51957138,'created_by','JOSM'),(51957141,'created_by','JOSM'),(51957143,'created_by','JOSM'),(51957144,'created_by','JOSM'),(51957146,'created_by','JOSM'),(51957147,'created_by','JOSM'),(51957151,'created_by','JOSM'),(51957153,'created_by','JOSM'),(51957155,'created_by','JOSM'),(51957157,'created_by','JOSM'),(51957160,'created_by','JOSM'),(51957162,'created_by','JOSM'),(51957164,'created_by','JOSM'),(51957166,'created_by','JOSM'),(51957168,'created_by','JOSM'),(51957170,'created_by','JOSM'),(51957172,'created_by','JOSM'),(51957174,'created_by','JOSM'),(51972980,'created_by','JOSM'),(51972984,'created_by','JOSM'),(51972990,'created_by','JOSM'),(51972993,'created_by','JOSM'),(51972999,'created_by','JOSM'),(51973000,'created_by','JOSM'),(51973004,'created_by','JOSM'),(51973007,'created_by','JOSM'),(51973010,'created_by','JOSM'),(51973014,'created_by','JOSM'),(51973017,'created_by','JOSM'),(51973021,'created_by','JOSM'),(51973026,'created_by','JOSM'),(51973027,'created_by','JOSM'),(51973030,'created_by','JOSM'),(51973033,'created_by','JOSM'),(51973038,'created_by','JOSM'),(51973045,'created_by','JOSM'),(51973049,'created_by','JOSM'),(51973052,'created_by','JOSM'),(51973055,'created_by','JOSM'),(51973058,'created_by','JOSM'),(51973061,'created_by','JOSM'),(51973066,'created_by','JOSM'),(51973069,'created_by','JOSM'),(51973073,'created_by','JOSM'),(51973078,'created_by','JOSM'),(51973082,'created_by','JOSM'),(51973084,'created_by','JOSM'),(51973088,'created_by','JOSM'),(51973091,'created_by','JOSM'),(51973096,'created_by','JOSM'),(51973099,'created_by','JOSM'),(51973102,'created_by','JOSM'),(51973105,'created_by','JOSM'),(51973108,'created_by','JOSM'),(51973112,'created_by','JOSM'),(51973113,'created_by','JOSM'),(51973117,'created_by','JOSM'),(51973120,'created_by','JOSM'),(51973122,'created_by','JOSM'),(51973128,'created_by','JOSM'),(51973131,'created_by','JOSM'),(51973135,'created_by','JOSM'),(51973138,'created_by','JOSM'),(51973141,'created_by','JOSM'),(51973144,'created_by','JOSM'),(51973147,'created_by','JOSM'),(51973150,'created_by','JOSM'),(51973154,'created_by','JOSM'),(51973156,'created_by','JOSM'),(51973158,'created_by','JOSM'),(51973161,'created_by','JOSM'),(51973163,'created_by','JOSM'),(51973166,'created_by','JOSM'),(51973170,'created_by','JOSM'),(51973172,'created_by','JOSM'),(51973175,'created_by','JOSM'),(51973177,'created_by','JOSM'),(51973179,'created_by','JOSM'),(51973183,'created_by','JOSM'),(51973186,'created_by','JOSM'),(51973190,'created_by','JOSM'),(51973193,'created_by','JOSM'),(51973196,'created_by','JOSM'),(51973198,'created_by','JOSM'),(51973201,'created_by','JOSM'),(51973203,'created_by','JOSM'),(51973206,'created_by','JOSM'),(51973208,'created_by','JOSM'),(51973210,'created_by','JOSM'),(51973213,'created_by','JOSM'),(51973215,'created_by','JOSM'),(51973219,'created_by','JOSM'),(51973221,'created_by','JOSM'),(51973223,'created_by','JOSM'),(51973225,'created_by','JOSM'),(51973228,'created_by','JOSM'),(51973234,'created_by','JOSM'),(51973237,'created_by','JOSM'),(51973241,'created_by','JOSM'),(51973243,'created_by','JOSM'),(51973247,'created_by','JOSM'),(51973249,'created_by','JOSM'),(51973253,'created_by','JOSM'),(51973256,'created_by','JOSM'),(51973260,'created_by','JOSM'),(51973264,'created_by','JOSM'),(51973268,'created_by','JOSM'),(51973269,'created_by','JOSM'),(51973273,'created_by','JOSM'),(51973276,'created_by','JOSM'),(51973278,'created_by','JOSM'),(51973281,'created_by','JOSM'),(51973284,'created_by','JOSM'),(51973287,'created_by','JOSM'),(51973290,'created_by','JOSM'),(51973293,'created_by','JOSM'),(51973296,'created_by','JOSM'),(51973300,'created_by','JOSM'),(51973302,'created_by','JOSM'),(51973306,'created_by','JOSM'),(51973310,'created_by','JOSM'),(51973313,'created_by','JOSM'),(51973316,'created_by','JOSM'),(51973320,'created_by','JOSM'),(51973324,'created_by','JOSM'),(51973326,'created_by','JOSM'),(51973327,'created_by','JOSM'),(51973329,'created_by','JOSM'),(51973334,'created_by','JOSM'),(51973336,'created_by','JOSM'),(51973339,'created_by','JOSM'),(51973341,'created_by','JOSM'),(51973344,'created_by','JOSM'),(51973346,'created_by','JOSM'),(51973348,'created_by','JOSM'),(51973351,'created_by','JOSM'),(51973352,'created_by','JOSM'),(51973353,'created_by','JOSM'),(51973354,'created_by','JOSM'),(51973356,'created_by','JOSM'),(51973357,'created_by','JOSM'),(51973359,'created_by','JOSM'),(51973361,'created_by','JOSM'),(51973362,'created_by','JOSM'),(51973363,'created_by','JOSM'),(51973364,'created_by','JOSM'),(51973366,'created_by','JOSM'),(51973369,'created_by','JOSM'),(51973370,'created_by','JOSM'),(51973373,'created_by','JOSM'),(51973375,'created_by','JOSM'),(51973378,'created_by','JOSM'),(51973380,'created_by','JOSM'),(51973384,'created_by','JOSM'),(51973387,'created_by','JOSM'),(51973390,'created_by','JOSM'),(51973394,'created_by','JOSM'),(51973396,'created_by','JOSM'),(51973398,'created_by','JOSM'),(51973400,'created_by','JOSM'),(51973403,'created_by','JOSM'),(51973405,'created_by','JOSM'),(51973407,'created_by','JOSM'),(51973409,'created_by','JOSM'),(51973413,'created_by','JOSM'),(51973416,'created_by','JOSM'),(51973417,'created_by','JOSM'),(51973419,'created_by','JOSM'),(51973424,'created_by','JOSM'),(51973426,'created_by','JOSM'),(51973428,'created_by','JOSM'),(51973430,'created_by','JOSM'),(51973432,'created_by','JOSM'),(51973436,'created_by','JOSM'),(51973439,'created_by','JOSM'),(51973441,'created_by','JOSM'),(51973444,'created_by','JOSM'),(51973448,'created_by','JOSM'),(51973451,'created_by','JOSM'),(51973454,'created_by','JOSM'),(51973456,'created_by','JOSM'),(51973459,'created_by','JOSM'),(51973462,'created_by','JOSM'),(51973467,'created_by','JOSM'),(51973470,'created_by','JOSM'),(51973471,'created_by','JOSM'),(51973475,'created_by','JOSM'),(51973478,'created_by','JOSM'),(51973481,'created_by','JOSM'),(51973484,'created_by','JOSM'),(51973487,'created_by','JOSM'),(51973489,'created_by','JOSM'),(51973491,'created_by','JOSM'),(51973494,'created_by','JOSM'),(51973497,'created_by','JOSM'),(51973499,'created_by','JOSM'),(51973504,'created_by','JOSM'),(51973507,'created_by','JOSM'),(51973511,'created_by','JOSM'),(51973514,'created_by','JOSM'),(51973516,'created_by','JOSM'),(51973519,'created_by','JOSM'),(51973521,'created_by','JOSM'),(51973523,'created_by','JOSM'),(51973526,'created_by','JOSM'),(51973528,'created_by','JOSM'),(51973529,'created_by','JOSM'),(51973532,'created_by','JOSM'),(51973534,'created_by','JOSM'),(51973538,'created_by','JOSM'),(51973541,'created_by','JOSM'),(51973544,'created_by','JOSM'),(51973546,'created_by','JOSM'),(51973548,'created_by','JOSM'),(51973550,'created_by','JOSM'),(51973554,'created_by','JOSM'),(51973557,'created_by','JOSM'),(51973559,'created_by','JOSM'),(51973561,'created_by','JOSM'),(51973562,'created_by','JOSM'),(51973564,'created_by','JOSM'),(51973567,'created_by','JOSM'),(51973570,'created_by','JOSM'),(51973571,'created_by','JOSM'),(51973575,'created_by','JOSM'),(51973577,'created_by','JOSM'),(51973579,'created_by','JOSM'),(51973582,'created_by','JOSM'),(51973587,'created_by','JOSM'),(51973590,'created_by','JOSM'),(51973591,'created_by','JOSM'),(51973594,'created_by','JOSM'),(51973596,'created_by','JOSM'),(51973598,'created_by','JOSM'),(51973599,'created_by','JOSM'),(51973602,'created_by','JOSM'),(51973604,'created_by','JOSM'),(51973606,'created_by','JOSM'),(51973608,'created_by','JOSM'),(51973611,'created_by','JOSM'),(51973614,'created_by','JOSM'),(51973617,'created_by','JOSM'),(51973619,'created_by','JOSM'),(51973621,'created_by','JOSM'),(51973622,'created_by','JOSM'),(51973624,'created_by','JOSM'),(51973627,'created_by','JOSM'),(51973631,'created_by','JOSM'),(51973633,'created_by','JOSM'),(51973636,'created_by','JOSM'),(51973639,'created_by','JOSM'),(51973643,'created_by','JOSM'),(51973646,'created_by','JOSM'),(51973648,'created_by','JOSM'),(51973651,'created_by','JOSM'),(51973653,'created_by','JOSM'),(51973657,'created_by','JOSM'),(51973660,'created_by','JOSM'),(51973663,'created_by','JOSM'),(51973667,'created_by','JOSM'),(51973669,'created_by','JOSM');
INSERT INTO `current_node_tags` VALUES (51973673,'created_by','JOSM'),(51973676,'created_by','JOSM'),(51973679,'created_by','JOSM'),(51973681,'created_by','JOSM'),(51973683,'created_by','JOSM'),(51973686,'created_by','JOSM'),(51973688,'created_by','JOSM'),(51973691,'created_by','JOSM'),(51973694,'created_by','JOSM'),(51973696,'created_by','JOSM'),(51973699,'created_by','JOSM'),(51973703,'created_by','JOSM'),(51973705,'created_by','JOSM'),(51973708,'created_by','JOSM'),(51973711,'created_by','JOSM'),(51973714,'created_by','JOSM'),(51973717,'created_by','JOSM'),(51973720,'created_by','JOSM'),(51973722,'created_by','JOSM'),(51973725,'created_by','JOSM'),(51973728,'created_by','JOSM'),(51973730,'created_by','JOSM'),(51973731,'created_by','JOSM'),(51973733,'created_by','JOSM'),(51973736,'created_by','JOSM'),(51973739,'created_by','JOSM'),(51973741,'created_by','JOSM'),(51973744,'created_by','JOSM'),(51973747,'created_by','JOSM'),(51973749,'created_by','JOSM'),(51973751,'created_by','JOSM'),(51973753,'created_by','JOSM'),(51973755,'created_by','JOSM'),(51973757,'created_by','JOSM'),(51973759,'created_by','JOSM'),(51973764,'created_by','JOSM'),(51973766,'created_by','JOSM'),(51973769,'created_by','JOSM'),(51973770,'created_by','JOSM'),(51973771,'created_by','JOSM'),(51973777,'created_by','JOSM'),(51973782,'created_by','JOSM'),(51973784,'created_by','JOSM'),(51973786,'created_by','JOSM'),(51973790,'created_by','JOSM'),(51973792,'created_by','JOSM'),(51973796,'created_by','JOSM'),(51973799,'created_by','JOSM'),(51973802,'created_by','JOSM'),(51973803,'created_by','JOSM'),(51973807,'created_by','JOSM'),(51973809,'created_by','JOSM'),(51973812,'created_by','JOSM'),(51973815,'created_by','JOSM'),(51973817,'created_by','JOSM'),(51973818,'created_by','JOSM'),(51973820,'created_by','JOSM'),(51973831,'created_by','JOSM'),(51973834,'created_by','JOSM'),(51973836,'created_by','JOSM'),(51973839,'created_by','JOSM'),(51973842,'created_by','JOSM'),(51973844,'created_by','JOSM'),(51973846,'created_by','JOSM'),(51973848,'created_by','JOSM'),(51973849,'created_by','JOSM'),(51973851,'created_by','JOSM'),(51973852,'created_by','JOSM'),(51973855,'created_by','JOSM'),(51973858,'created_by','JOSM'),(51973860,'created_by','JOSM'),(51973862,'created_by','JOSM'),(51973865,'created_by','JOSM'),(51973868,'created_by','JOSM'),(51973871,'created_by','JOSM'),(51973874,'created_by','JOSM'),(51973877,'created_by','JOSM'),(51973878,'created_by','JOSM'),(51973881,'created_by','JOSM'),(51973883,'created_by','JOSM'),(51973884,'created_by','JOSM'),(51973887,'created_by','JOSM'),(51973890,'created_by','JOSM'),(51973891,'created_by','JOSM'),(51973894,'created_by','JOSM'),(51973897,'created_by','JOSM'),(51973898,'created_by','JOSM'),(51973901,'created_by','JOSM'),(51973903,'created_by','JOSM'),(51973905,'created_by','JOSM'),(51973907,'created_by','JOSM'),(51973910,'created_by','JOSM'),(51973913,'created_by','JOSM'),(51973915,'created_by','JOSM'),(51973917,'created_by','JOSM'),(51973920,'created_by','JOSM'),(51973922,'created_by','JOSM'),(51973924,'created_by','JOSM'),(51973927,'created_by','JOSM'),(51973929,'created_by','JOSM'),(51973931,'created_by','JOSM'),(51973934,'created_by','JOSM'),(51973937,'created_by','JOSM'),(51973939,'created_by','JOSM'),(51973941,'created_by','JOSM'),(51973942,'created_by','JOSM'),(51973947,'created_by','JOSM'),(51973950,'created_by','JOSM'),(51973952,'created_by','JOSM'),(51973953,'created_by','JOSM'),(51973955,'created_by','JOSM'),(51973958,'created_by','JOSM'),(51973962,'created_by','JOSM'),(51973963,'created_by','JOSM'),(51973967,'created_by','JOSM'),(51973968,'created_by','JOSM'),(51973972,'created_by','JOSM'),(51973975,'created_by','JOSM'),(51973977,'created_by','JOSM'),(51973981,'created_by','JOSM'),(51973983,'created_by','JOSM'),(51973986,'created_by','JOSM'),(51973989,'created_by','JOSM'),(51973992,'created_by','JOSM'),(51973995,'created_by','JOSM'),(51973998,'created_by','JOSM'),(51974002,'created_by','JOSM'),(51974005,'created_by','JOSM'),(51974008,'created_by','JOSM'),(51974011,'created_by','JOSM'),(51974013,'created_by','JOSM'),(51974015,'created_by','JOSM'),(51974019,'created_by','JOSM'),(51974023,'created_by','JOSM'),(51974024,'created_by','JOSM'),(51974028,'created_by','JOSM'),(51974031,'created_by','JOSM'),(51974035,'created_by','JOSM'),(51974039,'created_by','JOSM'),(51974040,'created_by','JOSM'),(51974042,'created_by','JOSM'),(51974044,'created_by','JOSM'),(51974046,'created_by','JOSM'),(51974049,'created_by','JOSM'),(51974050,'created_by','JOSM'),(51974053,'created_by','JOSM'),(51974055,'created_by','JOSM'),(51974057,'created_by','JOSM'),(51974059,'created_by','JOSM'),(51974060,'created_by','JOSM'),(51974065,'created_by','JOSM'),(51974068,'created_by','JOSM'),(51974072,'created_by','JOSM'),(51974074,'created_by','JOSM'),(51974078,'created_by','JOSM'),(51974083,'created_by','JOSM'),(51974085,'created_by','JOSM'),(51974086,'created_by','JOSM'),(51974088,'created_by','JOSM'),(51974089,'created_by','JOSM'),(51974090,'created_by','JOSM'),(51974095,'created_by','JOSM'),(51974097,'created_by','JOSM'),(51974100,'created_by','JOSM'),(51974103,'created_by','JOSM'),(51974107,'created_by','JOSM'),(51974108,'created_by','JOSM'),(51974112,'created_by','JOSM'),(51974115,'created_by','JOSM'),(51974119,'created_by','JOSM'),(51974122,'created_by','JOSM'),(51974126,'created_by','JOSM'),(51974129,'created_by','JOSM'),(51974131,'created_by','JOSM'),(51974133,'created_by','JOSM'),(51974134,'created_by','JOSM'),(51974137,'created_by','JOSM'),(51974140,'created_by','JOSM'),(51974143,'created_by','JOSM'),(51974147,'created_by','JOSM'),(51974149,'created_by','JOSM'),(51974152,'created_by','JOSM'),(51974153,'created_by','JOSM'),(51974155,'created_by','JOSM'),(51974158,'created_by','JOSM'),(51974161,'created_by','JOSM'),(51974164,'created_by','JOSM'),(51974165,'created_by','JOSM'),(51974167,'created_by','JOSM'),(51974169,'created_by','JOSM'),(51974172,'created_by','JOSM'),(51974174,'created_by','JOSM'),(51974176,'created_by','JOSM'),(51974181,'created_by','JOSM'),(51974183,'created_by','JOSM'),(51974185,'created_by','JOSM'),(51974187,'created_by','JOSM'),(51974190,'created_by','JOSM'),(51974191,'created_by','JOSM'),(51974193,'created_by','JOSM'),(51974195,'created_by','JOSM'),(51974197,'created_by','JOSM'),(51974199,'created_by','JOSM'),(51974202,'created_by','JOSM'),(51974204,'created_by','JOSM'),(51974206,'created_by','JOSM'),(51974208,'created_by','JOSM'),(51974211,'created_by','JOSM'),(51974213,'created_by','JOSM'),(51974215,'created_by','JOSM'),(51974217,'created_by','JOSM'),(51974220,'created_by','JOSM'),(51974223,'created_by','JOSM'),(51974226,'created_by','JOSM'),(51974229,'created_by','JOSM'),(51974231,'created_by','JOSM'),(51974233,'created_by','JOSM'),(51974236,'created_by','JOSM'),(51974239,'created_by','JOSM'),(51974242,'created_by','JOSM'),(51974244,'created_by','JOSM'),(51974247,'created_by','JOSM'),(51974249,'created_by','JOSM'),(51974251,'created_by','JOSM'),(51974253,'created_by','JOSM'),(51974256,'created_by','JOSM'),(51974258,'created_by','JOSM'),(51974261,'created_by','JOSM'),(51974264,'created_by','JOSM'),(51974266,'created_by','JOSM'),(51974275,'created_by','JOSM'),(51974278,'created_by','JOSM'),(51974279,'created_by','JOSM'),(51974281,'created_by','JOSM'),(51974284,'created_by','JOSM'),(51974286,'created_by','JOSM'),(51974289,'created_by','JOSM'),(51974291,'created_by','JOSM'),(51974292,'created_by','JOSM'),(51974293,'created_by','JOSM'),(51974296,'created_by','JOSM'),(51974298,'created_by','JOSM'),(51974300,'created_by','JOSM'),(51974301,'created_by','JOSM'),(51974305,'created_by','JOSM'),(51974308,'created_by','JOSM'),(51974309,'created_by','JOSM'),(51974313,'created_by','JOSM'),(51974316,'created_by','JOSM'),(51974319,'created_by','JOSM'),(51974321,'created_by','JOSM'),(51974323,'created_by','JOSM'),(51974326,'created_by','JOSM'),(51974328,'created_by','JOSM'),(51974331,'created_by','JOSM'),(51974334,'created_by','JOSM'),(51974337,'created_by','JOSM'),(51974339,'created_by','JOSM'),(51974341,'created_by','JOSM'),(51974345,'created_by','JOSM'),(51974349,'created_by','JOSM'),(51974353,'created_by','JOSM'),(51974357,'created_by','JOSM'),(51974360,'created_by','JOSM'),(51974363,'created_by','JOSM'),(51974365,'created_by','JOSM'),(51974368,'created_by','JOSM'),(51974371,'created_by','JOSM'),(51974373,'created_by','JOSM'),(51974374,'created_by','JOSM'),(51974376,'created_by','JOSM'),(51974378,'created_by','JOSM'),(51974383,'created_by','JOSM'),(51974385,'created_by','JOSM'),(51974388,'created_by','JOSM'),(51974391,'created_by','JOSM'),(51974394,'created_by','JOSM'),(51974395,'created_by','JOSM'),(51974397,'created_by','JOSM'),(51974400,'created_by','JOSM'),(51974402,'created_by','JOSM'),(51974404,'created_by','JOSM'),(51974405,'created_by','JOSM'),(51974408,'created_by','JOSM'),(51974411,'created_by','JOSM'),(51974414,'created_by','JOSM'),(51974416,'created_by','JOSM'),(51974419,'created_by','JOSM'),(51974422,'created_by','JOSM'),(51974424,'created_by','JOSM'),(51974428,'created_by','JOSM'),(51974430,'created_by','JOSM'),(51974432,'created_by','JOSM'),(51974436,'created_by','JOSM'),(51974439,'created_by','JOSM'),(51974442,'created_by','JOSM'),(51974445,'created_by','JOSM'),(51974446,'created_by','JOSM'),(51974451,'created_by','JOSM'),(51974452,'created_by','JOSM'),(51974454,'created_by','JOSM'),(51974455,'created_by','JOSM'),(51974456,'created_by','JOSM'),(51974458,'created_by','JOSM'),(51974462,'created_by','JOSM'),(51974466,'created_by','JOSM'),(51974469,'created_by','JOSM'),(51974472,'created_by','JOSM'),(51974475,'created_by','JOSM'),(51974478,'created_by','JOSM'),(51974481,'created_by','JOSM'),(51974484,'created_by','JOSM'),(52002189,'created_by','JOSM'),(52002192,'created_by','JOSM'),(52002196,'created_by','JOSM'),(52002198,'created_by','JOSM'),(52002202,'created_by','JOSM'),(52002204,'created_by','JOSM'),(52002206,'created_by','JOSM'),(52002209,'created_by','JOSM'),(52002211,'created_by','JOSM'),(52002212,'created_by','JOSM'),(52002214,'created_by','JOSM'),(52002216,'created_by','JOSM'),(52002219,'created_by','JOSM'),(52002220,'created_by','JOSM'),(52002222,'created_by','JOSM'),(52002223,'created_by','JOSM'),(52002226,'created_by','JOSM'),(52002229,'created_by','JOSM'),(52002231,'created_by','JOSM'),(52002235,'created_by','JOSM'),(52002238,'created_by','JOSM'),(52002241,'created_by','JOSM'),(52002244,'created_by','JOSM'),(52002247,'created_by','JOSM'),(52002248,'created_by','JOSM'),(52002251,'created_by','JOSM'),(52002253,'created_by','JOSM'),(52002256,'created_by','JOSM'),(52002258,'created_by','JOSM'),(52002259,'created_by','JOSM'),(52002261,'created_by','JOSM'),(52002264,'created_by','JOSM'),(52002266,'created_by','JOSM'),(52002269,'created_by','JOSM'),(52002272,'created_by','JOSM'),(52002275,'created_by','JOSM'),(52002278,'created_by','JOSM'),(52002281,'created_by','JOSM'),(52009103,'created_by','JOSM'),(52009105,'created_by','JOSM'),(52009107,'created_by','JOSM'),(52009108,'created_by','JOSM'),(52009109,'created_by','JOSM'),(52009111,'created_by','JOSM'),(52009114,'created_by','JOSM'),(52009117,'created_by','JOSM'),(52009118,'created_by','JOSM'),(52009120,'created_by','JOSM'),(52009122,'created_by','JOSM'),(52009124,'created_by','JOSM'),(52009126,'created_by','JOSM'),(52009127,'created_by','JOSM'),(52009129,'created_by','JOSM'),(52009130,'created_by','JOSM'),(52009134,'created_by','JOSM'),(52009137,'created_by','JOSM'),(52009140,'created_by','JOSM'),(52009143,'created_by','JOSM'),(52009144,'created_by','JOSM'),(52009147,'created_by','JOSM'),(52009150,'created_by','JOSM'),(52009151,'created_by','JOSM'),(52009154,'created_by','JOSM'),(52009156,'created_by','JOSM'),(52009157,'created_by','JOSM'),(52009159,'created_by','JOSM'),(52009161,'created_by','JOSM'),(52009164,'created_by','JOSM'),(52009168,'created_by','JOSM'),(52009171,'created_by','JOSM'),(52009174,'created_by','JOSM'),(52009176,'created_by','JOSM'),(52009179,'created_by','JOSM'),(52009182,'created_by','JOSM'),(52009184,'created_by','JOSM'),(52009186,'created_by','JOSM'),(52009189,'created_by','JOSM'),(52009192,'created_by','JOSM'),(52009194,'created_by','JOSM'),(52009196,'created_by','JOSM'),(52009197,'created_by','JOSM'),(52011225,'created_by','JOSM'),(52011227,'created_by','JOSM'),(52011231,'created_by','JOSM'),(52011234,'created_by','JOSM'),(52011238,'created_by','JOSM'),(52011242,'created_by','JOSM'),(52011244,'created_by','JOSM'),(52011249,'created_by','JOSM'),(52011253,'created_by','JOSM'),(52011256,'created_by','JOSM'),(52011259,'created_by','JOSM'),(52031003,'created_by','JOSM'),(52031013,'created_by','JOSM'),(52031030,'created_by','JOSM'),(52031034,'created_by','JOSM'),(52031036,'created_by','JOSM'),(52031039,'created_by','JOSM'),(52031041,'created_by','JOSM'),(52031043,'created_by','JOSM'),(52031046,'created_by','JOSM'),(52031050,'created_by','JOSM'),(52031054,'created_by','JOSM'),(52031056,'created_by','JOSM'),(52031059,'created_by','JOSM'),(52031076,'created_by','JOSM'),(52031077,'created_by','JOSM'),(52031080,'created_by','JOSM'),(52031082,'created_by','JOSM'),(52031084,'created_by','JOSM'),(52031086,'created_by','JOSM'),(52031089,'created_by','JOSM'),(52031092,'created_by','JOSM'),(52031095,'created_by','JOSM'),(52031099,'created_by','JOSM'),(52031100,'created_by','JOSM'),(52031105,'created_by','JOSM'),(52031109,'created_by','JOSM'),(52031114,'created_by','JOSM'),(52031117,'created_by','JOSM'),(52031121,'created_by','JOSM'),(52031125,'created_by','JOSM'),(52031129,'created_by','JOSM'),(52031131,'created_by','JOSM'),(52031136,'created_by','JOSM'),(52031141,'created_by','JOSM'),(52031147,'created_by','JOSM'),(52031151,'created_by','JOSM'),(52031153,'created_by','JOSM'),(52031156,'created_by','JOSM'),(52031158,'created_by','JOSM'),(52031164,'created_by','JOSM'),(52031171,'created_by','JOSM'),(52031174,'created_by','JOSM'),(52031178,'created_by','JOSM'),(52031186,'created_by','JOSM'),(52031190,'created_by','JOSM'),(52031198,'created_by','JOSM'),(52031205,'created_by','JOSM'),(52031212,'created_by','JOSM'),(52031218,'created_by','JOSM'),(52031221,'created_by','JOSM'),(52031224,'created_by','JOSM'),(52031227,'created_by','JOSM'),(52031232,'created_by','JOSM'),(52031235,'created_by','JOSM'),(52031240,'created_by','JOSM'),(52031244,'created_by','JOSM'),(52031247,'created_by','JOSM'),(52031250,'created_by','JOSM'),(52031255,'created_by','JOSM'),(52031260,'created_by','JOSM'),(52031262,'created_by','JOSM'),(52031267,'created_by','JOSM'),(52031272,'created_by','JOSM'),(52031275,'created_by','JOSM'),(52031281,'created_by','JOSM'),(52031285,'created_by','JOSM'),(52031290,'created_by','JOSM'),(52031295,'created_by','JOSM'),(52031299,'created_by','JOSM'),(52031307,'created_by','JOSM'),(52031309,'created_by','JOSM'),(52031314,'created_by','JOSM'),(52031320,'created_by','JOSM'),(52031325,'created_by','JOSM'),(52031329,'created_by','JOSM'),(52031335,'created_by','JOSM'),(52031340,'created_by','JOSM'),(52031346,'created_by','JOSM'),(52031351,'created_by','JOSM'),(52031355,'created_by','JOSM'),(52031357,'created_by','JOSM'),(52031361,'created_by','JOSM'),(52031364,'created_by','JOSM'),(52031367,'created_by','JOSM'),(52031369,'created_by','JOSM'),(52031373,'created_by','JOSM'),(52031381,'created_by','JOSM'),(52031384,'created_by','JOSM'),(52031410,'created_by','JOSM'),(52031414,'created_by','JOSM'),(52031418,'created_by','JOSM'),(52031424,'created_by','JOSM'),(52031426,'created_by','JOSM'),(52031429,'created_by','JOSM'),(52031433,'created_by','JOSM'),(52031438,'created_by','JOSM'),(52031441,'created_by','JOSM'),(52031446,'created_by','JOSM'),(52031449,'created_by','JOSM'),(52031456,'created_by','JOSM'),(52031461,'created_by','JOSM'),(52031464,'created_by','JOSM'),(52031467,'created_by','JOSM'),(52031471,'created_by','JOSM'),(52031477,'created_by','JOSM'),(52031481,'created_by','JOSM'),(52031483,'created_by','JOSM'),(52031486,'created_by','JOSM'),(52031491,'created_by','JOSM'),(52031494,'created_by','JOSM'),(52031498,'created_by','JOSM'),(52031500,'created_by','JOSM'),(52031504,'created_by','JOSM'),(52031507,'created_by','JOSM'),(52031512,'created_by','JOSM'),(52031514,'created_by','JOSM'),(52031517,'created_by','JOSM'),(52031521,'created_by','JOSM'),(52031523,'created_by','JOSM'),(52031527,'created_by','JOSM'),(52031529,'created_by','JOSM'),(52031532,'created_by','JOSM'),(52031535,'created_by','JOSM'),(52031540,'created_by','JOSM'),(52031545,'created_by','JOSM'),(52031550,'created_by','JOSM'),(52031552,'created_by','JOSM'),(52031554,'created_by','JOSM'),(52031560,'created_by','JOSM'),(52031562,'created_by','JOSM'),(52031567,'created_by','JOSM'),(52031572,'created_by','JOSM'),(52031576,'created_by','JOSM'),(52031580,'created_by','JOSM'),(52031581,'created_by','JOSM'),(52031587,'created_by','JOSM'),(52031590,'created_by','JOSM'),(52031592,'created_by','JOSM'),(52031595,'created_by','JOSM'),(52031600,'created_by','JOSM'),(52031604,'created_by','JOSM'),(52031608,'created_by','JOSM'),(52031611,'created_by','JOSM'),(52031614,'created_by','JOSM'),(52031616,'created_by','JOSM'),(52031617,'created_by','JOSM'),(52031620,'created_by','JOSM'),(52031621,'created_by','JOSM'),(52031626,'created_by','JOSM'),(52031627,'created_by','JOSM'),(52031631,'created_by','JOSM'),(52031634,'created_by','JOSM'),(52031636,'created_by','JOSM'),(52031642,'created_by','JOSM'),(52031645,'created_by','JOSM'),(52031648,'created_by','JOSM'),(52031652,'created_by','JOSM'),(52031656,'created_by','JOSM'),(52031658,'created_by','JOSM'),(52031660,'created_by','JOSM'),(52031665,'created_by','JOSM'),(52031668,'created_by','JOSM'),(52031671,'created_by','JOSM'),(52031676,'created_by','JOSM'),(52031678,'created_by','JOSM'),(52031681,'created_by','JOSM'),(52031686,'created_by','JOSM'),(52031688,'created_by','JOSM'),(52031691,'created_by','JOSM'),(52031695,'created_by','JOSM'),(52031700,'created_by','JOSM'),(52031702,'created_by','JOSM'),(52031705,'created_by','JOSM'),(52031709,'created_by','JOSM'),(52031712,'created_by','JOSM'),(52031715,'created_by','JOSM'),(52031717,'created_by','JOSM'),(52031720,'created_by','JOSM'),(52031723,'created_by','JOSM'),(52031726,'created_by','JOSM'),(52031730,'created_by','JOSM'),(52031732,'created_by','JOSM'),(52031736,'created_by','JOSM'),(52031739,'created_by','JOSM'),(52031742,'created_by','JOSM'),(52031744,'created_by','JOSM'),(52031746,'created_by','JOSM'),(52031747,'created_by','JOSM'),(52031749,'created_by','JOSM'),(52031751,'created_by','JOSM'),(52031756,'created_by','JOSM'),(52031758,'created_by','JOSM'),(52031761,'created_by','JOSM'),(52031764,'created_by','JOSM'),(52031767,'created_by','JOSM'),(52031771,'created_by','JOSM'),(52031774,'created_by','JOSM'),(52031777,'created_by','JOSM'),(52031782,'created_by','JOSM'),(52031785,'created_by','JOSM'),(52031789,'created_by','JOSM'),(52031794,'created_by','JOSM'),(52031798,'created_by','JOSM'),(52031803,'created_by','JOSM'),(52031805,'created_by','JOSM'),(52031809,'created_by','JOSM'),(52031811,'created_by','JOSM'),(52031813,'created_by','JOSM'),(52031815,'created_by','JOSM'),(52031821,'created_by','JOSM'),(52031823,'created_by','JOSM'),(52031827,'created_by','JOSM'),(52031830,'created_by','JOSM'),(52031832,'created_by','JOSM'),(52031834,'created_by','JOSM'),(52031838,'created_by','JOSM'),(52031840,'created_by','JOSM'),(52031844,'created_by','JOSM'),(52031847,'created_by','JOSM'),(52031850,'created_by','JOSM'),(52031855,'created_by','JOSM'),(52031858,'created_by','JOSM'),(52031861,'created_by','JOSM'),(52031865,'created_by','JOSM'),(52031866,'created_by','JOSM'),(52031868,'created_by','JOSM'),(52031871,'created_by','JOSM'),(52031872,'created_by','JOSM'),(52031874,'created_by','JOSM'),(52031876,'created_by','JOSM'),(52031881,'created_by','JOSM'),(52031884,'created_by','JOSM'),(52031886,'created_by','JOSM'),(52031888,'created_by','JOSM'),(52031889,'created_by','JOSM'),(52031893,'created_by','JOSM'),(52031894,'created_by','JOSM'),(52031899,'created_by','JOSM'),(52031901,'created_by','JOSM'),(52031906,'created_by','JOSM'),(52031908,'created_by','JOSM'),(52031911,'created_by','JOSM'),(52031913,'created_by','JOSM'),(52031915,'created_by','JOSM'),(52031919,'created_by','JOSM'),(52031921,'created_by','JOSM'),(52031925,'created_by','JOSM'),(52031927,'created_by','JOSM'),(52031930,'created_by','JOSM'),(52031933,'created_by','JOSM'),(52031936,'created_by','JOSM'),(52031938,'created_by','JOSM'),(52031943,'created_by','JOSM'),(52031946,'created_by','JOSM'),(52031948,'created_by','JOSM'),(52031953,'created_by','JOSM'),(52031956,'created_by','JOSM'),(52031958,'created_by','JOSM'),(52031962,'created_by','JOSM'),(52031966,'created_by','JOSM'),(52031968,'created_by','JOSM'),(52031973,'created_by','JOSM'),(52031976,'created_by','JOSM'),(52031980,'created_by','JOSM'),(52031984,'created_by','JOSM'),(52031987,'created_by','JOSM'),(52031990,'created_by','JOSM'),(52031992,'created_by','JOSM'),(52031995,'created_by','JOSM'),(52031998,'created_by','JOSM'),(52032000,'created_by','JOSM'),(52032003,'created_by','JOSM'),(52032007,'created_by','JOSM'),(52032010,'created_by','JOSM'),(52032012,'created_by','JOSM'),(52032017,'created_by','JOSM'),(52032018,'created_by','JOSM'),(52032021,'created_by','JOSM'),(52032022,'created_by','JOSM'),(52032026,'created_by','JOSM'),(52032029,'created_by','JOSM'),(52032033,'created_by','JOSM'),(52032035,'created_by','JOSM'),(52032039,'created_by','JOSM'),(52032041,'created_by','JOSM'),(52032044,'created_by','JOSM'),(52032047,'created_by','JOSM'),(52032048,'created_by','JOSM'),(52032051,'created_by','JOSM'),(52032054,'created_by','JOSM'),(52032057,'created_by','JOSM'),(52032060,'created_by','JOSM'),(52032064,'created_by','JOSM'),(52032067,'created_by','JOSM'),(52032070,'created_by','JOSM'),(52032071,'created_by','JOSM'),(52032075,'created_by','JOSM'),(52032076,'created_by','JOSM'),(52032078,'created_by','JOSM'),(52032081,'created_by','JOSM'),(52032085,'created_by','JOSM'),(52032087,'created_by','JOSM'),(52032090,'created_by','JOSM'),(52032092,'created_by','JOSM'),(52032093,'created_by','JOSM'),(52032098,'created_by','JOSM'),(52032100,'created_by','JOSM'),(52032103,'created_by','JOSM'),(52032107,'created_by','JOSM'),(52032109,'created_by','JOSM'),(52032112,'created_by','JOSM'),(52032113,'created_by','JOSM'),(52032116,'created_by','JOSM'),(52032119,'created_by','JOSM'),(52032122,'created_by','JOSM'),(52032125,'created_by','JOSM'),(52032127,'created_by','JOSM'),(52032130,'created_by','JOSM'),(52032133,'created_by','JOSM'),(52032135,'created_by','JOSM'),(52032137,'created_by','JOSM'),(52032141,'created_by','JOSM'),(52032145,'created_by','JOSM'),(52032147,'created_by','JOSM'),(52032150,'created_by','JOSM'),(52032153,'created_by','JOSM'),(52032158,'created_by','JOSM'),(52032160,'created_by','JOSM'),(52032162,'created_by','JOSM'),(52032165,'created_by','JOSM'),(52032168,'created_by','JOSM'),(52032171,'created_by','JOSM'),(52032174,'created_by','JOSM'),(52032176,'created_by','JOSM'),(52032179,'created_by','JOSM'),(52032182,'created_by','JOSM'),(52032183,'created_by','JOSM'),(52032186,'created_by','JOSM'),(52032187,'created_by','JOSM'),(52032190,'created_by','JOSM'),(52032192,'created_by','JOSM'),(52032195,'created_by','JOSM'),(52032197,'created_by','JOSM'),(52032200,'created_by','JOSM'),(52032204,'created_by','JOSM'),(52032205,'created_by','JOSM'),(52032208,'created_by','JOSM'),(52032211,'created_by','JOSM'),(52032212,'created_by','JOSM'),(52032216,'created_by','JOSM'),(52032219,'created_by','JOSM'),(52032222,'created_by','JOSM'),(52032225,'created_by','JOSM'),(52032228,'created_by','JOSM'),(52032233,'created_by','JOSM'),(52032238,'created_by','JOSM'),(52032241,'created_by','JOSM'),(52032243,'created_by','JOSM'),(52032246,'created_by','JOSM'),(52032249,'created_by','JOSM'),(52032250,'created_by','JOSM'),(52163550,'created_by','JOSM'),(52163556,'created_by','JOSM'),(52163563,'created_by','JOSM'),(52163574,'created_by','JOSM'),(52163581,'created_by','JOSM'),(52163588,'created_by','JOSM'),(52163595,'created_by','JOSM'),(52163602,'created_by','JOSM'),(52163609,'created_by','JOSM'),(52163613,'created_by','JOSM'),(52163621,'created_by','JOSM'),(52163631,'created_by','JOSM'),(52163644,'created_by','JOSM'),(52163664,'created_by','JOSM'),(52164958,'created_by','JOSM'),(52166749,'created_by','JOSM'),(52166950,'highway','mini_roundabout'),(52166959,'created_by','JOSM'),(52166976,'created_by','JOSM'),(52166980,'created_by','JOSM'),(52167010,'created_by','JOSM'),(52167017,'created_by','JOSM'),(52167025,'created_by','JOSM'),(52167030,'created_by','JOSM'),(52167039,'created_by','JOSM'),(52167045,'created_by','JOSM'),(52167049,'created_by','JOSM'),(52167052,'created_by','JOSM'),(52167062,'created_by','JOSM'),(52167066,'created_by','JOSM'),(52167070,'created_by','JOSM'),(52167076,'created_by','JOSM'),(52167082,'created_by','JOSM'),(52167086,'created_by','JOSM'),(52167105,'created_by','JOSM'),(52167111,'created_by','JOSM'),(52167122,'created_by','JOSM'),(52167128,'created_by','JOSM'),(52167136,'created_by','JOSM'),(52167142,'created_by','JOSM'),(52167150,'created_by','JOSM'),(52167155,'created_by','JOSM'),(52167165,'created_by','JOSM'),(52167175,'created_by','JOSM'),(52167179,'created_by','JOSM'),(52167183,'created_by','JOSM'),(52167190,'created_by','JOSM'),(52167198,'created_by','JOSM'),(52167208,'created_by','JOSM'),(52167211,'created_by','JOSM'),(52167218,'created_by','JOSM'),(52167223,'created_by','JOSM'),(52167232,'created_by','JOSM'),(52167248,'created_by','JOSM'),(52167254,'created_by','JOSM'),(52167257,'created_by','JOSM'),(52167262,'created_by','JOSM'),(52167277,'created_by','JOSM'),(52167279,'created_by','JOSM'),(52167284,'created_by','JOSM'),(52167289,'created_by','JOSM'),(52167293,'created_by','JOSM'),(52167300,'created_by','JOSM'),(52167307,'created_by','JOSM'),(52167309,'created_by','JOSM'),(52167315,'created_by','JOSM'),(52167320,'created_by','JOSM'),(52167323,'created_by','JOSM'),(52167329,'created_by','JOSM'),(52167336,'created_by','JOSM'),(52167345,'created_by','JOSM'),(52167349,'created_by','JOSM'),(52167353,'created_by','JOSM'),(52167358,'created_by','JOSM'),(52167363,'created_by','JOSM'),(52167368,'created_by','JOSM'),(52167372,'created_by','JOSM'),(52167380,'created_by','JOSM'),(52167387,'created_by','JOSM'),(52167389,'created_by','JOSM'),(52167390,'created_by','JOSM'),(52167393,'created_by','JOSM'),(52167396,'created_by','JOSM'),(52167398,'created_by','JOSM'),(52167402,'created_by','JOSM'),(52167406,'created_by','JOSM'),(52167421,'created_by','JOSM'),(52167425,'created_by','JOSM'),(52167428,'created_by','JOSM'),(52167430,'created_by','JOSM'),(52167433,'created_by','JOSM'),(52167436,'created_by','JOSM'),(52167438,'created_by','JOSM'),(52167439,'created_by','JOSM'),(52167444,'created_by','JOSM'),(52167446,'created_by','JOSM'),(52167453,'created_by','JOSM'),(52167457,'created_by','JOSM'),(52167470,'created_by','JOSM'),(52167473,'created_by','JOSM'),(52167477,'created_by','JOSM'),(52167484,'created_by','JOSM'),(52167487,'created_by','JOSM'),(52167490,'created_by','JOSM'),(52167496,'created_by','JOSM'),(52167500,'created_by','JOSM'),(52167503,'created_by','JOSM'),(52167507,'created_by','JOSM'),(52167511,'created_by','JOSM'),(52167513,'created_by','JOSM'),(52167517,'created_by','JOSM'),(52167521,'created_by','JOSM'),(52167525,'created_by','JOSM'),(52167528,'created_by','JOSM'),(52167530,'created_by','JOSM'),(52167534,'created_by','JOSM'),(52167535,'created_by','JOSM'),(52167538,'created_by','JOSM'),(52167540,'created_by','JOSM'),(52167544,'created_by','JOSM'),(52167547,'created_by','JOSM'),(52167551,'created_by','JOSM'),(52167557,'created_by','JOSM'),(52167562,'created_by','JOSM'),(52167568,'created_by','JOSM'),(52167574,'created_by','JOSM'),(52167579,'created_by','JOSM'),(52167581,'created_by','JOSM'),(52167585,'created_by','JOSM'),(52167590,'created_by','JOSM'),(52167593,'created_by','JOSM'),(52167599,'created_by','JOSM'),(52167604,'created_by','JOSM'),(52167607,'created_by','JOSM'),(52167614,'created_by','JOSM'),(52167615,'created_by','JOSM'),(52167619,'created_by','JOSM'),(52167622,'created_by','JOSM'),(52167627,'created_by','JOSM'),(52167632,'created_by','JOSM'),(52167636,'created_by','JOSM'),(52167641,'created_by','JOSM'),(52167645,'created_by','JOSM'),(52167650,'created_by','JOSM'),(52167655,'created_by','JOSM'),(52167660,'created_by','JOSM'),(52167664,'created_by','JOSM'),(52167666,'created_by','JOSM'),(52167669,'created_by','JOSM'),(52167673,'created_by','JOSM'),(52167677,'created_by','JOSM'),(52167683,'created_by','JOSM'),(52167687,'created_by','JOSM'),(52167691,'created_by','JOSM'),(52167695,'created_by','JOSM'),(52167700,'created_by','JOSM'),(52167702,'created_by','JOSM'),(52167707,'created_by','JOSM'),(52167710,'created_by','JOSM'),(52167713,'created_by','JOSM'),(52167714,'created_by','JOSM'),(52167718,'created_by','JOSM'),(52167721,'created_by','JOSM'),(52167725,'created_by','JOSM'),(52167727,'created_by','JOSM'),(52167732,'created_by','JOSM'),(52167736,'created_by','JOSM'),(52167740,'created_by','JOSM'),(52167744,'created_by','JOSM'),(52167747,'created_by','JOSM'),(52167752,'created_by','JOSM'),(52167756,'created_by','JOSM'),(52167758,'created_by','JOSM'),(52167761,'created_by','JOSM'),(52167765,'created_by','JOSM'),(52167769,'created_by','JOSM'),(52167773,'created_by','JOSM'),(52167777,'created_by','JOSM'),(52167781,'created_by','JOSM'),(52167784,'created_by','JOSM'),(52167787,'created_by','JOSM'),(52167790,'created_by','JOSM'),(52167795,'created_by','JOSM'),(52167796,'created_by','JOSM'),(52167799,'created_by','JOSM'),(52167802,'created_by','JOSM'),(52167805,'created_by','JOSM'),(52167807,'created_by','JOSM'),(52167811,'created_by','JOSM'),(52167812,'created_by','JOSM'),(52167815,'created_by','JOSM'),(52167820,'created_by','JOSM'),(52167825,'created_by','JOSM'),(52167828,'created_by','JOSM'),(52167834,'created_by','JOSM'),(52167836,'created_by','JOSM'),(52167839,'created_by','JOSM'),(52167843,'created_by','JOSM'),(52167847,'created_by','JOSM'),(52167849,'created_by','JOSM'),(52167853,'created_by','JOSM'),(52167859,'created_by','JOSM'),(52167860,'created_by','JOSM'),(52167867,'created_by','JOSM'),(52167872,'created_by','JOSM'),(52167883,'created_by','JOSM'),(52167887,'created_by','JOSM'),(52167891,'created_by','JOSM'),(52167896,'created_by','JOSM'),(52167900,'created_by','JOSM'),(52167906,'created_by','JOSM'),(52167911,'created_by','JOSM'),(52167916,'created_by','JOSM'),(52167922,'created_by','JOSM'),(52167924,'created_by','JOSM'),(52167927,'created_by','JOSM'),(52167930,'created_by','JOSM'),(52167932,'created_by','JOSM'),(52167937,'created_by','JOSM'),(52167944,'created_by','JOSM'),(52167948,'created_by','JOSM'),(52167953,'created_by','JOSM'),(52167958,'created_by','JOSM'),(52167963,'created_by','JOSM'),(52167967,'created_by','JOSM'),(52167969,'created_by','JOSM'),(52167970,'created_by','JOSM'),(52167973,'created_by','JOSM'),(52167977,'created_by','JOSM'),(52167981,'created_by','JOSM'),(52167986,'created_by','JOSM'),(52167991,'created_by','JOSM'),(52167995,'created_by','JOSM'),(52168000,'created_by','JOSM'),(52168004,'created_by','JOSM'),(52168009,'created_by','JOSM'),(52168013,'created_by','JOSM'),(52168015,'created_by','JOSM'),(52168018,'created_by','JOSM'),(52168021,'created_by','JOSM'),(52168025,'created_by','JOSM'),(52168028,'created_by','JOSM'),(52168033,'created_by','JOSM'),(52168034,'created_by','JOSM'),(52168038,'created_by','JOSM'),(52168039,'created_by','JOSM'),(52168043,'created_by','JOSM'),(52168046,'created_by','JOSM'),(52168049,'created_by','JOSM'),(52168053,'created_by','JOSM'),(52168055,'created_by','JOSM'),(52168056,'created_by','JOSM'),(52168060,'created_by','JOSM'),(52168063,'created_by','JOSM'),(52168065,'created_by','JOSM'),(52168070,'created_by','JOSM'),(52168071,'created_by','JOSM'),(52168073,'created_by','JOSM'),(52168077,'created_by','JOSM'),(52168080,'created_by','JOSM'),(52168084,'created_by','JOSM'),(52168086,'created_by','JOSM'),(52168090,'created_by','JOSM'),(52168094,'created_by','JOSM'),(52168096,'created_by','JOSM'),(52168100,'created_by','JOSM'),(52168101,'created_by','JOSM'),(52168104,'created_by','JOSM'),(52168108,'created_by','JOSM'),(52168111,'created_by','JOSM'),(52168115,'created_by','JOSM'),(52168118,'created_by','JOSM'),(52168121,'created_by','JOSM'),(52168124,'created_by','JOSM'),(52168127,'created_by','JOSM'),(52168130,'created_by','JOSM'),(52168135,'created_by','JOSM'),(52168138,'created_by','JOSM'),(52168143,'created_by','JOSM'),(52168146,'created_by','JOSM'),(52168149,'created_by','JOSM'),(52168152,'created_by','JOSM'),(52168156,'created_by','JOSM'),(52168160,'created_by','JOSM'),(52168163,'created_by','JOSM'),(52168167,'created_by','JOSM'),(52168171,'created_by','JOSM'),(52168175,'created_by','JOSM'),(52168178,'created_by','JOSM'),(52168181,'created_by','JOSM'),(52168186,'created_by','JOSM'),(52168188,'created_by','JOSM'),(52168191,'created_by','JOSM'),(52168195,'created_by','JOSM'),(52168198,'created_by','JOSM'),(52168203,'created_by','JOSM'),(52168207,'created_by','JOSM'),(52168214,'created_by','JOSM'),(52168217,'created_by','JOSM'),(52168220,'created_by','JOSM'),(52168225,'created_by','JOSM'),(52168231,'created_by','JOSM'),(52168235,'created_by','JOSM'),(52168237,'created_by','JOSM'),(52168240,'created_by','JOSM'),(52168243,'created_by','JOSM'),(52168247,'created_by','JOSM'),(52168248,'created_by','JOSM'),(52168249,'created_by','JOSM'),(52168251,'created_by','JOSM'),(52168254,'created_by','JOSM'),(52168256,'created_by','JOSM'),(52168258,'created_by','JOSM'),(52168261,'created_by','JOSM'),(52168265,'created_by','JOSM'),(52168270,'created_by','JOSM'),(52168274,'created_by','JOSM'),(52168278,'created_by','JOSM'),(52168283,'created_by','JOSM'),(52168286,'created_by','JOSM'),(52168287,'created_by','JOSM'),(52168291,'created_by','JOSM'),(52168296,'created_by','JOSM'),(52168298,'created_by','JOSM'),(52168302,'created_by','JOSM'),(52168305,'created_by','JOSM'),(52168308,'created_by','JOSM'),(52168309,'created_by','JOSM'),(52168314,'created_by','JOSM'),(52168316,'created_by','JOSM'),(52168318,'created_by','JOSM'),(52168321,'created_by','JOSM'),(52168325,'created_by','JOSM'),(52168326,'created_by','JOSM'),(52168329,'created_by','JOSM'),(52168333,'created_by','JOSM'),(52168336,'created_by','JOSM'),(52168338,'created_by','JOSM'),(52168342,'created_by','JOSM'),(52168346,'created_by','JOSM'),(52168347,'created_by','JOSM'),(52168348,'created_by','JOSM'),(52168350,'created_by','JOSM'),(52168356,'created_by','JOSM'),(52168360,'created_by','JOSM'),(52168362,'created_by','JOSM'),(52168414,'created_by','JOSM'),(52168416,'created_by','JOSM'),(52168419,'created_by','JOSM'),(52168423,'created_by','JOSM'),(52168427,'created_by','JOSM'),(52168429,'created_by','JOSM'),(52168432,'created_by','JOSM'),(52168436,'created_by','JOSM'),(52168440,'created_by','JOSM'),(52168442,'created_by','JOSM'),(52168445,'created_by','JOSM'),(52168447,'created_by','JOSM'),(52168452,'created_by','JOSM'),(52168455,'created_by','JOSM'),(52168459,'created_by','JOSM'),(52168461,'created_by','JOSM'),(52168464,'created_by','JOSM'),(52168468,'created_by','JOSM'),(52168470,'created_by','JOSM'),(52168474,'created_by','JOSM'),(52168476,'created_by','JOSM'),(52168479,'created_by','JOSM'),(52168481,'created_by','JOSM'),(52168484,'created_by','JOSM'),(52168486,'created_by','JOSM'),(52168489,'created_by','JOSM'),(52168492,'created_by','JOSM'),(52168495,'created_by','JOSM'),(52168497,'created_by','JOSM'),(52168502,'created_by','JOSM'),(52168506,'created_by','JOSM'),(52168509,'created_by','JOSM'),(52168512,'created_by','JOSM'),(52168516,'created_by','JOSM'),(52168519,'created_by','JOSM'),(52168521,'created_by','JOSM'),(52168523,'created_by','JOSM'),(52168529,'created_by','JOSM'),(52168531,'created_by','JOSM'),(52168534,'created_by','JOSM'),(52168537,'created_by','JOSM'),(52168541,'created_by','JOSM'),(52168543,'created_by','JOSM'),(52168547,'created_by','JOSM'),(52168549,'created_by','JOSM'),(52168553,'created_by','JOSM'),(52168555,'created_by','JOSM'),(52168558,'created_by','JOSM'),(52168561,'created_by','JOSM'),(52168565,'created_by','JOSM'),(52168568,'created_by','JOSM'),(52168569,'created_by','JOSM'),(52168572,'created_by','JOSM'),(52168576,'created_by','JOSM'),(52168579,'created_by','JOSM'),(52168582,'created_by','JOSM'),(52168586,'created_by','JOSM'),(52168589,'created_by','JOSM'),(52168592,'created_by','JOSM'),(52168595,'created_by','JOSM'),(52168596,'created_by','JOSM'),(52168600,'created_by','JOSM'),(52168604,'created_by','JOSM'),(52168607,'created_by','JOSM'),(52168612,'created_by','JOSM'),(52168613,'created_by','JOSM'),(52168616,'created_by','JOSM'),(52168622,'created_by','JOSM'),(52168626,'created_by','JOSM'),(52168631,'created_by','JOSM'),(52168635,'created_by','JOSM'),(52168638,'created_by','JOSM'),(52168640,'created_by','JOSM'),(52168644,'created_by','JOSM'),(52168648,'created_by','JOSM'),(52168654,'created_by','JOSM'),(52168657,'created_by','JOSM'),(52168660,'created_by','JOSM'),(52168663,'created_by','JOSM'),(52168665,'created_by','JOSM'),(52168668,'created_by','JOSM'),(52168671,'created_by','JOSM'),(52168674,'created_by','JOSM'),(52168676,'created_by','JOSM'),(52168679,'created_by','JOSM'),(52168682,'created_by','JOSM'),(52168686,'created_by','JOSM'),(52168687,'created_by','JOSM'),(52168690,'created_by','JOSM'),(52168693,'created_by','JOSM'),(52168695,'created_by','JOSM'),(52168698,'created_by','JOSM'),(52168700,'created_by','JOSM'),(52168702,'created_by','JOSM'),(52168703,'created_by','JOSM'),(52168705,'created_by','JOSM'),(52168708,'created_by','JOSM'),(52168710,'created_by','JOSM'),(52168712,'created_by','JOSM'),(52168714,'created_by','JOSM'),(52168717,'created_by','JOSM'),(52168720,'created_by','JOSM'),(52168722,'created_by','JOSM'),(52168725,'created_by','JOSM'),(52168727,'created_by','JOSM'),(52168729,'created_by','JOSM'),(52168732,'created_by','JOSM'),(52168734,'created_by','JOSM'),(52168736,'created_by','JOSM'),(52168739,'created_by','JOSM'),(52168741,'created_by','JOSM'),(52168744,'created_by','JOSM'),(52168745,'created_by','JOSM'),(52168747,'created_by','JOSM'),(52168750,'created_by','JOSM'),(52168770,'created_by','JOSM'),(52168772,'created_by','JOSM'),(52168773,'created_by','JOSM'),(52168774,'created_by','JOSM'),(52168777,'created_by','JOSM'),(52168779,'created_by','JOSM'),(52168782,'created_by','JOSM'),(52168786,'created_by','JOSM'),(52168788,'created_by','JOSM'),(52168789,'created_by','JOSM'),(52168790,'created_by','JOSM'),(52168794,'created_by','JOSM'),(52168796,'created_by','JOSM'),(52168799,'created_by','JOSM'),(52168802,'created_by','JOSM'),(52168805,'created_by','JOSM'),(52168808,'created_by','JOSM'),(52168810,'created_by','JOSM'),(52168813,'created_by','JOSM'),(52168816,'created_by','JOSM'),(52168819,'created_by','JOSM'),(52168821,'created_by','JOSM'),(52168824,'created_by','JOSM'),(52168828,'created_by','JOSM'),(52168829,'created_by','JOSM'),(52168830,'created_by','JOSM'),(52168834,'created_by','JOSM'),(52168836,'created_by','JOSM'),(52168838,'created_by','JOSM'),(52168842,'created_by','JOSM'),(52168845,'created_by','JOSM'),(52168846,'created_by','JOSM'),(52168849,'created_by','JOSM'),(52168851,'created_by','JOSM'),(52168854,'created_by','JOSM'),(52168856,'created_by','JOSM'),(52168858,'created_by','JOSM'),(52168859,'created_by','JOSM'),(52168862,'created_by','JOSM'),(52168865,'created_by','JOSM'),(52168866,'created_by','JOSM'),(52168867,'created_by','JOSM'),(52168870,'created_by','JOSM'),(52168873,'created_by','JOSM'),(52168875,'created_by','JOSM'),(52168878,'created_by','JOSM'),(52168881,'created_by','JOSM'),(52168883,'created_by','JOSM'),(52168886,'created_by','JOSM'),(52168889,'created_by','JOSM'),(52168892,'created_by','JOSM'),(52168895,'created_by','JOSM'),(52168899,'created_by','JOSM'),(52168901,'created_by','JOSM'),(52168904,'created_by','JOSM'),(52168905,'created_by','JOSM'),(52168909,'created_by','JOSM'),(52168912,'created_by','JOSM'),(52168914,'created_by','JOSM'),(52168917,'created_by','JOSM'),(52168919,'created_by','JOSM'),(52168920,'created_by','JOSM'),(52168921,'created_by','JOSM'),(52168924,'created_by','JOSM'),(52168926,'created_by','JOSM'),(52168929,'created_by','JOSM'),(52168931,'created_by','JOSM'),(52168933,'created_by','JOSM'),(52168936,'created_by','JOSM'),(52168939,'created_by','JOSM'),(52168943,'created_by','JOSM'),(52168945,'created_by','JOSM'),(52168946,'created_by','JOSM'),(52168948,'created_by','JOSM'),(52168952,'created_by','JOSM'),(52168955,'created_by','JOSM'),(52168959,'created_by','JOSM'),(52168961,'created_by','JOSM'),(52168964,'created_by','JOSM'),(52168965,'created_by','JOSM'),(52168967,'created_by','JOSM'),(52168969,'created_by','JOSM'),(52168972,'created_by','JOSM'),(52168974,'created_by','JOSM'),(52168976,'created_by','JOSM'),(52168981,'created_by','JOSM'),(52168984,'created_by','JOSM'),(52168987,'created_by','JOSM'),(52168989,'created_by','JOSM'),(52168992,'created_by','JOSM'),(52168995,'created_by','JOSM'),(52169000,'created_by','JOSM'),(52169003,'created_by','JOSM'),(52169006,'created_by','JOSM'),(52169008,'created_by','JOSM'),(52169011,'created_by','JOSM'),(52169014,'created_by','JOSM'),(52169016,'created_by','JOSM'),(52169018,'created_by','JOSM'),(52169021,'created_by','JOSM'),(52169022,'created_by','JOSM'),(52169024,'created_by','JOSM'),(52169028,'created_by','JOSM'),(52169032,'created_by','JOSM'),(52169034,'created_by','JOSM'),(52169036,'created_by','JOSM'),(52169041,'created_by','JOSM'),(52169044,'created_by','JOSM'),(52169045,'created_by','JOSM'),(52169048,'created_by','JOSM'),(52169052,'created_by','JOSM'),(52169054,'created_by','JOSM'),(52169055,'created_by','JOSM'),(52169058,'created_by','JOSM'),(52169060,'created_by','JOSM'),(52169061,'created_by','JOSM'),(52169064,'created_by','JOSM'),(52169067,'created_by','JOSM'),(52169070,'created_by','JOSM'),(52169073,'created_by','JOSM'),(52169075,'created_by','JOSM'),(52169076,'created_by','JOSM'),(52169078,'created_by','JOSM'),(52169080,'created_by','JOSM'),(52169083,'created_by','JOSM'),(52169088,'created_by','JOSM'),(52169089,'created_by','JOSM'),(52169092,'created_by','JOSM'),(52169094,'created_by','JOSM'),(52169097,'created_by','JOSM'),(52169100,'created_by','JOSM'),(52169103,'created_by','JOSM'),(52169105,'created_by','JOSM'),(52169109,'created_by','JOSM'),(52169111,'created_by','JOSM'),(52169113,'created_by','JOSM'),(52169115,'created_by','JOSM'),(52169117,'created_by','JOSM'),(52169119,'created_by','JOSM'),(52169121,'created_by','JOSM'),(52169123,'created_by','JOSM'),(52169124,'created_by','JOSM'),(52169125,'created_by','JOSM'),(52169126,'created_by','JOSM'),(52169127,'created_by','JOSM'),(52170031,'created_by','JOSM'),(52170032,'created_by','JOSM'),(52170036,'created_by','JOSM'),(52170040,'created_by','JOSM'),(52170042,'created_by','JOSM'),(52170044,'created_by','JOSM'),(52170048,'created_by','JOSM'),(52170056,'created_by','JOSM'),(52170061,'created_by','JOSM'),(52170065,'created_by','JOSM'),(52170071,'created_by','JOSM'),(52170076,'created_by','JOSM'),(52170080,'created_by','JOSM'),(52170088,'created_by','JOSM'),(52170090,'created_by','JOSM'),(52170096,'created_by','JOSM'),(52170099,'created_by','JOSM'),(52170371,'created_by','JOSM'),(52170374,'created_by','JOSM'),(52170377,'created_by','JOSM'),(52170378,'created_by','JOSM'),(52170381,'created_by','JOSM'),(52170384,'created_by','JOSM'),(52170386,'created_by','JOSM'),(52170388,'created_by','JOSM'),(52170391,'created_by','JOSM'),(52170394,'created_by','JOSM'),(52170397,'created_by','JOSM'),(52170400,'created_by','JOSM'),(52170401,'created_by','JOSM'),(52170406,'created_by','JOSM'),(52170410,'created_by','JOSM'),(52170411,'created_by','JOSM'),(52170415,'created_by','JOSM'),(52170416,'created_by','JOSM'),(52170417,'created_by','JOSM'),(52170418,'created_by','JOSM'),(52170423,'created_by','JOSM'),(52170440,'created_by','JOSM'),(52170441,'created_by','JOSM'),(52170496,'created_by','JOSM'),(52170512,'created_by','JOSM'),(52170525,'created_by','JOSM'),(52170533,'created_by','JOSM'),(52170540,'created_by','JOSM'),(52170544,'created_by','JOSM'),(52170561,'created_by','JOSM'),(52171046,'created_by','JOSM'),(52171050,'created_by','JOSM'),(52171054,'created_by','JOSM'),(52171057,'created_by','JOSM'),(52171060,'created_by','JOSM'),(52171070,'created_by','JOSM'),(52171073,'created_by','JOSM'),(52171075,'created_by','JOSM'),(52171078,'created_by','JOSM'),(52171081,'created_by','JOSM'),(52171084,'created_by','JOSM'),(52171088,'created_by','JOSM'),(52171092,'created_by','JOSM'),(52171100,'created_by','JOSM'),(52171107,'created_by','JOSM'),(52171112,'created_by','JOSM'),(52171114,'created_by','JOSM'),(52171118,'created_by','JOSM'),(52171120,'created_by','JOSM'),(52171121,'created_by','JOSM'),(52171125,'created_by','JOSM'),(52171127,'created_by','JOSM'),(52171129,'created_by','JOSM'),(52171131,'created_by','JOSM'),(52171136,'created_by','JOSM'),(52171140,'created_by','JOSM'),(52171146,'created_by','JOSM'),(52171151,'created_by','JOSM'),(52171156,'created_by','JOSM'),(52171165,'created_by','JOSM'),(52171167,'created_by','JOSM'),(52171173,'created_by','JOSM'),(52171179,'created_by','JOSM'),(52171184,'created_by','JOSM'),(52171188,'created_by','JOSM'),(52171247,'created_by','JOSM'),(52171251,'created_by','JOSM'),(52171256,'created_by','JOSM'),(52171259,'created_by','JOSM'),(52171263,'created_by','JOSM'),(52171280,'created_by','JOSM'),(52171284,'created_by','JOSM'),(52171289,'created_by','JOSM'),(52171295,'created_by','JOSM'),(52171297,'created_by','JOSM'),(52171300,'created_by','JOSM'),(52171305,'created_by','JOSM'),(52171307,'created_by','JOSM'),(52171311,'created_by','JOSM'),(52171317,'created_by','JOSM'),(52171321,'created_by','JOSM'),(52171324,'created_by','JOSM'),(52171330,'created_by','JOSM'),(52171338,'created_by','JOSM'),(52171344,'created_by','JOSM'),(52171351,'created_by','JOSM'),(52171364,'created_by','JOSM'),(52171370,'created_by','JOSM'),(52171373,'created_by','JOSM'),(52171378,'created_by','JOSM'),(52171382,'created_by','JOSM'),(52171385,'created_by','JOSM'),(52171391,'created_by','JOSM'),(52171407,'created_by','JOSM'),(52171413,'created_by','JOSM'),(52171417,'created_by','JOSM'),(52171422,'created_by','JOSM'),(52171426,'created_by','JOSM'),(52171432,'created_by','JOSM'),(52171437,'created_by','JOSM'),(52171443,'created_by','JOSM'),(52171444,'created_by','JOSM'),(52171447,'created_by','JOSM'),(52171449,'created_by','JOSM'),(52171451,'created_by','JOSM'),(52171454,'created_by','JOSM'),(52171458,'created_by','JOSM'),(52171465,'created_by','JOSM'),(52171467,'created_by','JOSM'),(52171474,'created_by','JOSM'),(52171479,'created_by','JOSM'),(52171481,'created_by','JOSM'),(52171485,'created_by','JOSM'),(52171487,'created_by','JOSM'),(52171491,'created_by','JOSM'),(52171494,'created_by','JOSM'),(52171498,'created_by','JOSM'),(52171503,'created_by','JOSM'),(52171506,'created_by','JOSM'),(52171511,'created_by','JOSM'),(52171515,'created_by','JOSM'),(52171521,'created_by','JOSM'),(52171525,'created_by','JOSM'),(52171528,'created_by','JOSM'),(52171531,'created_by','JOSM'),(52171534,'created_by','JOSM'),(52171537,'created_by','JOSM'),(52171542,'created_by','JOSM'),(52171547,'created_by','JOSM'),(52171553,'created_by','JOSM'),(52171557,'created_by','JOSM'),(52171562,'created_by','JOSM'),(52171569,'created_by','JOSM'),(52171574,'created_by','JOSM'),(52171579,'created_by','JOSM'),(52171585,'created_by','JOSM'),(52171590,'created_by','JOSM'),(52171594,'created_by','JOSM'),(52171595,'created_by','JOSM'),(52171601,'created_by','JOSM'),(52171606,'created_by','JOSM'),(52171610,'created_by','JOSM'),(52171616,'created_by','JOSM'),(52171622,'created_by','JOSM'),(52171628,'created_by','JOSM'),(52171633,'created_by','JOSM'),(52171636,'created_by','JOSM'),(52171644,'created_by','JOSM'),(52171649,'created_by','JOSM'),(52171653,'created_by','JOSM'),(52171656,'created_by','JOSM'),(52171659,'created_by','JOSM'),(52171662,'created_by','JOSM'),(52171665,'created_by','JOSM'),(52171764,'created_by','JOSM'),(52171771,'created_by','JOSM'),(52171775,'created_by','JOSM'),(52171777,'created_by','JOSM'),(52171781,'created_by','JOSM'),(52171785,'created_by','JOSM'),(52171787,'created_by','JOSM'),(52171790,'created_by','JOSM'),(52171795,'created_by','JOSM'),(52171797,'created_by','JOSM'),(52171801,'created_by','JOSM'),(52171805,'created_by','JOSM'),(52171808,'created_by','JOSM'),(52171810,'created_by','JOSM'),(52171811,'created_by','JOSM'),(52171814,'created_by','JOSM'),(52171815,'created_by','JOSM'),(52171818,'created_by','JOSM'),(52171820,'created_by','JOSM'),(52171822,'created_by','JOSM'),(52171825,'created_by','JOSM'),(52171858,'created_by','JOSM'),(52171863,'created_by','JOSM'),(52171867,'created_by','JOSM'),(52171885,'created_by','JOSM'),(52171888,'created_by','JOSM'),(52171892,'created_by','JOSM'),(52171895,'created_by','JOSM'),(52171932,'created_by','JOSM'),(52171934,'created_by','JOSM'),(52171940,'created_by','JOSM'),(52171942,'created_by','JOSM'),(52171945,'created_by','JOSM'),(52171948,'created_by','JOSM'),(52171949,'created_by','JOSM'),(52171952,'created_by','JOSM'),(52171963,'created_by','JOSM'),(52171972,'created_by','JOSM'),(52171975,'created_by','JOSM'),(52171977,'created_by','JOSM'),(52171979,'created_by','JOSM'),(52171981,'created_by','JOSM'),(52171985,'created_by','JOSM'),(52171988,'created_by','JOSM'),(52171989,'created_by','JOSM'),(52171991,'created_by','JOSM'),(52171995,'created_by','JOSM'),(52171996,'created_by','JOSM'),(52171997,'created_by','JOSM'),(52172001,'created_by','JOSM'),(52172006,'created_by','JOSM'),(52172008,'created_by','JOSM'),(52172012,'created_by','JOSM'),(52172014,'created_by','JOSM'),(52172016,'created_by','JOSM'),(52172033,'created_by','JOSM'),(52172036,'created_by','JOSM'),(52172049,'created_by','JOSM'),(52172050,'created_by','JOSM'),(52172086,'created_by','JOSM'),(52172090,'created_by','JOSM'),(52172092,'created_by','JOSM'),(52172096,'created_by','JOSM'),(52172099,'created_by','JOSM'),(52172102,'created_by','JOSM'),(52172104,'created_by','JOSM'),(52172105,'created_by','JOSM'),(52172106,'created_by','JOSM'),(52172107,'created_by','JOSM'),(52172109,'created_by','JOSM'),(52172111,'created_by','JOSM'),(52172122,'created_by','JOSM'),(52172124,'created_by','JOSM'),(52172128,'created_by','JOSM'),(52172129,'created_by','JOSM'),(52172131,'created_by','JOSM'),(52172133,'created_by','JOSM'),(52172135,'created_by','JOSM'),(52172139,'created_by','JOSM'),(52172141,'created_by','JOSM'),(52172144,'created_by','JOSM'),(52172147,'created_by','JOSM'),(52172150,'created_by','JOSM'),(52172153,'created_by','JOSM'),(52172156,'created_by','JOSM'),(52172158,'created_by','JOSM'),(52172161,'created_by','JOSM'),(52172164,'created_by','JOSM'),(52172166,'created_by','JOSM'),(52172168,'created_by','JOSM'),(52172170,'created_by','JOSM'),(52172172,'created_by','JOSM'),(52172175,'created_by','JOSM'),(52172178,'created_by','JOSM'),(52172181,'created_by','JOSM'),(52202283,'created_by','JOSM'),(52202293,'created_by','JOSM'),(52202298,'created_by','JOSM'),(52202362,'created_by','JOSM'),(52202389,'created_by','JOSM'),(52202451,'created_by','JOSM'),(52202455,'created_by','JOSM'),(52202460,'created_by','JOSM'),(52202465,'created_by','JOSM'),(52202468,'created_by','JOSM'),(52202473,'created_by','JOSM'),(52202476,'created_by','JOSM'),(52202485,'created_by','JOSM'),(52202488,'created_by','JOSM'),(52202493,'created_by','JOSM'),(52202499,'created_by','JOSM'),(52202507,'created_by','JOSM'),(52202511,'created_by','JOSM'),(52202517,'created_by','JOSM'),(52202521,'created_by','JOSM'),(52202523,'created_by','JOSM'),(52202526,'created_by','JOSM'),(52202528,'created_by','JOSM'),(52202533,'created_by','JOSM'),(52202534,'created_by','JOSM'),(52202539,'created_by','JOSM'),(52202541,'created_by','JOSM'),(52202545,'created_by','JOSM'),(52202549,'created_by','JOSM'),(52202552,'created_by','JOSM'),(52202553,'created_by','JOSM'),(52202560,'created_by','JOSM'),(52202566,'created_by','JOSM'),(52202571,'created_by','JOSM'),(52202579,'created_by','JOSM'),(52203066,'created_by','JOSM'),(52204239,'created_by','JOSM'),(52204243,'created_by','JOSM'),(52204246,'created_by','JOSM'),(52204248,'created_by','JOSM'),(52204251,'created_by','JOSM'),(52204254,'created_by','JOSM'),(52204258,'created_by','JOSM'),(52204261,'created_by','JOSM'),(52204265,'created_by','JOSM'),(52204267,'created_by','JOSM'),(52204269,'created_by','JOSM'),(52204275,'created_by','JOSM'),(52204280,'created_by','JOSM'),(52204284,'created_by','JOSM'),(52204288,'created_by','JOSM'),(52204292,'created_by','JOSM'),(52204294,'created_by','JOSM'),(52204296,'created_by','JOSM'),(52204307,'created_by','JOSM'),(52204324,'created_by','JOSM'),(52204328,'created_by','JOSM'),(52204344,'created_by','JOSM'),(52204350,'created_by','JOSM'),(52204353,'created_by','JOSM'),(52204354,'created_by','JOSM'),(52204363,'created_by','JOSM'),(52204366,'created_by','JOSM'),(52204368,'created_by','JOSM'),(52204371,'created_by','JOSM'),(52204375,'created_by','JOSM'),(52204377,'created_by','JOSM'),(52204380,'created_by','JOSM'),(52204383,'created_by','JOSM'),(52204386,'created_by','JOSM'),(52204388,'created_by','JOSM'),(52204391,'created_by','JOSM'),(52204394,'created_by','JOSM'),(52204397,'created_by','JOSM'),(52204401,'created_by','JOSM'),(52204404,'created_by','JOSM'),(52204407,'created_by','JOSM'),(52204415,'created_by','JOSM'),(52204417,'created_by','JOSM'),(52204420,'created_by','JOSM'),(52204423,'created_by','JOSM'),(52204425,'created_by','JOSM'),(52204428,'created_by','JOSM'),(52204431,'created_by','JOSM'),(52204434,'created_by','JOSM'),(52204436,'created_by','JOSM'),(52204439,'created_by','JOSM'),(52204442,'created_by','JOSM'),(52204445,'created_by','JOSM'),(52204446,'created_by','JOSM'),(52204450,'created_by','JOSM'),(52204453,'created_by','JOSM'),(52204456,'created_by','JOSM'),(52204459,'created_by','JOSM'),(52204462,'created_by','JOSM'),(52204465,'created_by','JOSM'),(52204467,'created_by','JOSM'),(52204470,'created_by','JOSM'),(52204473,'created_by','JOSM'),(52204476,'created_by','JOSM'),(52204478,'created_by','JOSM'),(52204480,'created_by','JOSM'),(52204483,'created_by','JOSM'),(52204485,'created_by','JOSM'),(52204488,'created_by','JOSM'),(52204492,'created_by','JOSM'),(52204495,'created_by','JOSM'),(52204498,'created_by','JOSM'),(52204501,'created_by','JOSM'),(52204504,'created_by','JOSM'),(52204505,'created_by','JOSM'),(52204513,'created_by','JOSM'),(52204516,'created_by','JOSM'),(52204520,'created_by','JOSM'),(52204523,'created_by','JOSM'),(52204525,'created_by','JOSM'),(52204528,'created_by','JOSM'),(52204531,'created_by','JOSM'),(52204534,'created_by','JOSM'),(52204536,'created_by','JOSM'),(52204541,'created_by','JOSM'),(52204544,'created_by','JOSM'),(52204547,'created_by','JOSM'),(52204549,'created_by','JOSM'),(52204553,'created_by','JOSM'),(52204565,'created_by','JOSM'),(52204568,'created_by','JOSM'),(52204624,'created_by','JOSM'),(52204627,'created_by','JOSM'),(52204664,'created_by','JOSM'),(52204665,'created_by','JOSM'),(52204668,'created_by','JOSM'),(52204669,'created_by','JOSM'),(52204670,'created_by','JOSM'),(52204747,'created_by','JOSM'),(52204750,'created_by','JOSM'),(52204798,'created_by','JOSM'),(52204800,'created_by','JOSM'),(52204903,'created_by','JOSM'),(52204912,'created_by','JOSM'),(52204916,'created_by','JOSM'),(52204922,'created_by','JOSM'),(52204983,'created_by','JOSM'),(52205002,'created_by','JOSM'),(52205008,'created_by','JOSM'),(52205014,'created_by','JOSM'),(52205020,'created_by','JOSM'),(52205022,'created_by','JOSM'),(52205029,'created_by','JOSM'),(52205032,'created_by','JOSM'),(52205035,'created_by','JOSM'),(52205038,'created_by','JOSM'),(52205041,'created_by','JOSM'),(52205043,'created_by','JOSM'),(52205046,'created_by','JOSM'),(52205050,'created_by','JOSM'),(52205053,'created_by','JOSM'),(52205055,'created_by','JOSM'),(52205059,'created_by','JOSM'),(52205063,'created_by','JOSM'),(52205065,'created_by','JOSM'),(52205070,'created_by','JOSM'),(52205073,'created_by','JOSM'),(52205075,'created_by','JOSM'),(52205077,'created_by','JOSM'),(52205079,'created_by','JOSM'),(52205080,'created_by','JOSM'),(52205082,'created_by','JOSM'),(52205084,'created_by','JOSM'),(52205086,'created_by','JOSM'),(52205087,'created_by','JOSM'),(52205089,'created_by','JOSM'),(52205090,'created_by','JOSM'),(52205091,'created_by','JOSM'),(52205092,'created_by','JOSM'),(52205093,'created_by','JOSM'),(52205094,'created_by','JOSM'),(52205095,'created_by','JOSM'),(52205096,'created_by','JOSM'),(52205099,'created_by','JOSM'),(52205101,'created_by','JOSM'),(52205105,'created_by','JOSM'),(52205107,'created_by','JOSM'),(52205110,'created_by','JOSM'),(52205113,'created_by','JOSM'),(52205116,'created_by','JOSM'),(52205122,'created_by','JOSM'),(52205123,'created_by','JOSM'),(52205126,'created_by','JOSM'),(52205131,'created_by','JOSM'),(52205132,'created_by','JOSM'),(52205135,'created_by','JOSM'),(52205138,'created_by','JOSM'),(52205141,'created_by','JOSM'),(52205144,'created_by','JOSM'),(52205148,'created_by','JOSM'),(52205150,'created_by','JOSM'),(52205154,'created_by','JOSM'),(52205161,'created_by','JOSM'),(52205166,'created_by','JOSM'),(52205171,'created_by','JOSM'),(52205175,'created_by','JOSM'),(52205176,'created_by','JOSM'),(52205177,'created_by','JOSM'),(52205182,'created_by','JOSM'),(52205186,'created_by','JOSM'),(52205188,'created_by','JOSM'),(52205196,'created_by','JOSM'),(52205200,'created_by','JOSM'),(52205206,'created_by','JOSM'),(52205212,'created_by','JOSM'),(52205218,'created_by','JOSM'),(52205222,'created_by','JOSM'),(52205225,'created_by','JOSM'),(52205230,'created_by','JOSM'),(52205232,'created_by','JOSM'),(52205239,'created_by','JOSM'),(52205242,'created_by','JOSM'),(52205244,'created_by','JOSM'),(52205248,'created_by','JOSM'),(52205252,'created_by','JOSM'),(52205257,'created_by','JOSM'),(52205261,'created_by','JOSM'),(52205266,'created_by','JOSM'),(52205269,'created_by','JOSM'),(52205274,'created_by','JOSM'),(52205280,'created_by','JOSM'),(52205284,'created_by','JOSM'),(52205286,'created_by','JOSM'),(52205290,'created_by','JOSM'),(52205296,'created_by','JOSM'),(52205298,'created_by','JOSM'),(52205301,'created_by','JOSM'),(52205304,'created_by','JOSM'),(52205306,'created_by','JOSM'),(52205309,'created_by','JOSM'),(52205311,'created_by','JOSM'),(52205317,'created_by','JOSM'),(52205404,'created_by','JOSM'),(52205416,'created_by','JOSM'),(52205422,'created_by','JOSM'),(52205427,'created_by','JOSM'),(52205431,'created_by','JOSM'),(52205434,'created_by','JOSM'),(52205438,'created_by','JOSM'),(52205450,'created_by','JOSM'),(52205456,'created_by','JOSM'),(52205461,'created_by','JOSM'),(52205464,'created_by','JOSM'),(52205469,'created_by','JOSM'),(52205473,'created_by','JOSM'),(52205475,'created_by','JOSM'),(52205480,'created_by','JOSM'),(52205485,'created_by','JOSM'),(52205489,'created_by','JOSM'),(52205492,'created_by','JOSM'),(52205496,'created_by','JOSM'),(52205622,'created_by','JOSM'),(52205637,'created_by','JOSM'),(52205641,'created_by','JOSM'),(52205671,'created_by','JOSM'),(52205676,'created_by','JOSM'),(52205678,'created_by','JOSM'),(52205679,'created_by','JOSM'),(52205681,'created_by','JOSM'),(52205685,'created_by','JOSM'),(52205687,'created_by','JOSM'),(52205690,'created_by','JOSM'),(52205693,'created_by','JOSM'),(52205695,'created_by','JOSM'),(52205699,'created_by','JOSM'),(52205703,'created_by','JOSM'),(52205707,'created_by','JOSM'),(52205709,'created_by','JOSM'),(52205712,'created_by','JOSM'),(52205713,'created_by','JOSM'),(52205715,'created_by','JOSM'),(52205774,'created_by','JOSM'),(52205782,'created_by','JOSM'),(52205785,'created_by','JOSM'),(52205813,'created_by','JOSM'),(52205820,'created_by','JOSM'),(52205823,'created_by','JOSM'),(52205828,'created_by','JOSM'),(52205830,'created_by','JOSM'),(52205836,'created_by','JOSM'),(52205839,'created_by','JOSM'),(52205843,'created_by','JOSM'),(52205846,'created_by','JOSM'),(52205849,'created_by','JOSM'),(52205852,'created_by','JOSM'),(52205855,'created_by','JOSM'),(52205859,'created_by','JOSM'),(52205863,'created_by','JOSM'),(52205865,'created_by','JOSM'),(52205869,'created_by','JOSM'),(52205873,'created_by','JOSM'),(52205876,'created_by','JOSM'),(52205880,'created_by','JOSM'),(52205882,'created_by','JOSM'),(52205885,'created_by','JOSM'),(52205888,'created_by','JOSM'),(52205891,'created_by','JOSM'),(52205893,'created_by','JOSM'),(52205896,'created_by','JOSM'),(52205898,'created_by','JOSM'),(52205901,'created_by','JOSM'),(52205904,'created_by','JOSM'),(52205907,'created_by','JOSM'),(52205910,'created_by','JOSM'),(52205913,'created_by','JOSM'),(52205915,'created_by','JOSM'),(52205924,'created_by','JOSM'),(52205929,'created_by','JOSM'),(52205930,'created_by','JOSM'),(52205935,'created_by','JOSM'),(52205937,'created_by','JOSM'),(52205938,'created_by','JOSM'),(52205941,'created_by','JOSM'),(52205945,'created_by','JOSM'),(52205948,'created_by','JOSM'),(52205951,'created_by','JOSM'),(52205955,'created_by','JOSM'),(52205959,'created_by','JOSM'),(52205964,'created_by','JOSM'),(52205967,'created_by','JOSM'),(52205972,'created_by','JOSM'),(52205973,'created_by','JOSM'),(52205977,'created_by','JOSM'),(52205980,'created_by','JOSM'),(52205983,'created_by','JOSM'),(52205985,'created_by','JOSM'),(52205987,'created_by','JOSM'),(52205990,'created_by','JOSM'),(52205992,'created_by','JOSM'),(52205994,'created_by','JOSM'),(52205996,'created_by','JOSM'),(52205998,'created_by','JOSM'),(52206000,'created_by','JOSM'),(52206003,'created_by','JOSM'),(52206005,'created_by','JOSM'),(52206007,'created_by','JOSM'),(52206009,'created_by','JOSM'),(52206010,'created_by','JOSM'),(52206014,'created_by','JOSM'),(52206016,'created_by','JOSM'),(52206018,'created_by','JOSM'),(52206020,'created_by','JOSM'),(52206023,'created_by','JOSM'),(52206025,'created_by','JOSM'),(52206031,'created_by','JOSM'),(52206033,'created_by','JOSM'),(52206036,'created_by','JOSM'),(52206040,'created_by','JOSM'),(52206041,'created_by','JOSM'),(52206044,'created_by','JOSM'),(52206048,'created_by','JOSM'),(52206051,'created_by','JOSM'),(52206054,'created_by','JOSM'),(52206057,'created_by','JOSM'),(52206060,'created_by','JOSM'),(52206063,'created_by','JOSM'),(52206068,'created_by','JOSM'),(52206069,'created_by','JOSM'),(52206072,'created_by','JOSM'),(52206076,'created_by','JOSM'),(52206078,'created_by','JOSM'),(52206165,'created_by','JOSM'),(52206177,'created_by','JOSM'),(52206181,'created_by','JOSM'),(52206185,'created_by','JOSM'),(52206187,'created_by','JOSM'),(52206189,'created_by','JOSM'),(52206193,'created_by','JOSM'),(52206195,'created_by','JOSM'),(52206198,'created_by','JOSM'),(52206202,'created_by','JOSM'),(52206203,'created_by','JOSM'),(52206207,'created_by','JOSM'),(52206209,'created_by','JOSM'),(52206212,'created_by','JOSM'),(52206215,'created_by','JOSM'),(52206218,'created_by','JOSM'),(52206221,'created_by','JOSM'),(52206225,'created_by','JOSM'),(52206228,'created_by','JOSM'),(52206231,'created_by','JOSM'),(52206234,'created_by','JOSM'),(52206238,'created_by','JOSM'),(52206240,'created_by','JOSM'),(52206242,'created_by','JOSM'),(52206244,'created_by','JOSM'),(52206250,'created_by','JOSM'),(52206252,'created_by','JOSM'),(52206254,'created_by','JOSM'),(52206256,'created_by','JOSM'),(52206259,'created_by','JOSM'),(52206262,'created_by','JOSM'),(52206266,'created_by','JOSM'),(52206268,'created_by','JOSM'),(52206271,'created_by','JOSM'),(52206274,'created_by','JOSM'),(52206277,'created_by','JOSM'),(52206280,'created_by','JOSM'),(52206283,'created_by','JOSM'),(52206286,'created_by','JOSM'),(52206290,'created_by','JOSM'),(52206293,'created_by','JOSM'),(52206294,'created_by','JOSM');
INSERT INTO `current_node_tags` VALUES (52206299,'created_by','JOSM'),(52206302,'created_by','JOSM'),(52206304,'created_by','JOSM'),(52206306,'created_by','JOSM'),(52206310,'created_by','JOSM'),(52206312,'created_by','JOSM'),(52206315,'created_by','JOSM'),(52206317,'created_by','JOSM'),(52206320,'created_by','JOSM'),(52206321,'created_by','JOSM'),(52206324,'created_by','JOSM'),(52206327,'created_by','JOSM'),(52206333,'created_by','JOSM'),(52206336,'created_by','JOSM'),(52206337,'created_by','JOSM'),(52206340,'created_by','JOSM'),(52206343,'created_by','JOSM'),(52206344,'created_by','JOSM'),(52206347,'created_by','JOSM'),(52206349,'created_by','JOSM'),(52206352,'created_by','JOSM'),(52206354,'created_by','JOSM'),(52206356,'created_by','JOSM'),(52206358,'created_by','JOSM'),(52206359,'created_by','JOSM'),(52206360,'created_by','JOSM'),(52206364,'created_by','JOSM'),(52206366,'created_by','JOSM'),(52206374,'created_by','JOSM'),(52206379,'created_by','JOSM'),(52206383,'created_by','JOSM'),(52206385,'created_by','JOSM'),(52206389,'created_by','JOSM'),(52206395,'created_by','JOSM'),(52206400,'created_by','JOSM'),(52206404,'created_by','JOSM'),(52206407,'created_by','JOSM'),(52206410,'created_by','JOSM'),(52206414,'created_by','JOSM'),(52206419,'created_by','JOSM'),(52206420,'created_by','JOSM'),(52206422,'created_by','JOSM'),(52206425,'created_by','JOSM'),(52206429,'created_by','JOSM'),(52206433,'created_by','JOSM'),(52206435,'created_by','JOSM'),(52206439,'created_by','JOSM'),(52206442,'created_by','JOSM'),(52206446,'created_by','JOSM'),(52206447,'created_by','JOSM'),(52206449,'created_by','JOSM'),(52206453,'created_by','JOSM'),(52206457,'created_by','JOSM'),(52206461,'created_by','JOSM'),(52206468,'created_by','JOSM'),(52206471,'created_by','JOSM'),(52206472,'created_by','JOSM'),(52206476,'created_by','JOSM'),(52206479,'created_by','JOSM'),(52206483,'created_by','JOSM'),(52206486,'created_by','JOSM'),(52206488,'created_by','JOSM'),(52206491,'created_by','JOSM'),(52206495,'created_by','JOSM'),(52206498,'created_by','JOSM'),(52206502,'created_by','JOSM'),(52206505,'created_by','JOSM'),(52206508,'created_by','JOSM'),(52206512,'created_by','JOSM'),(52206580,'created_by','JOSM'),(52206583,'created_by','JOSM'),(52206585,'created_by','JOSM'),(52206588,'created_by','JOSM'),(52206591,'created_by','JOSM'),(52206601,'created_by','JOSM'),(52206604,'created_by','JOSM'),(52206607,'created_by','JOSM'),(52206609,'created_by','JOSM'),(52206611,'created_by','JOSM'),(52206615,'created_by','JOSM'),(52206617,'created_by','JOSM'),(52206619,'created_by','JOSM'),(52206620,'created_by','JOSM'),(52206622,'created_by','JOSM'),(52206625,'created_by','JOSM'),(52206627,'created_by','JOSM'),(52206628,'created_by','JOSM'),(52206632,'created_by','JOSM'),(52206635,'created_by','JOSM'),(52206639,'created_by','JOSM'),(52206643,'created_by','JOSM'),(52206645,'created_by','JOSM'),(52206647,'created_by','JOSM'),(52206650,'created_by','JOSM'),(52206653,'created_by','JOSM'),(52206655,'created_by','JOSM'),(52206657,'created_by','JOSM'),(52206661,'created_by','JOSM'),(52206663,'created_by','JOSM'),(52206666,'created_by','JOSM'),(52206669,'created_by','JOSM'),(52206671,'created_by','JOSM'),(52206673,'created_by','JOSM'),(52206676,'created_by','JOSM'),(52206679,'created_by','JOSM'),(52206681,'created_by','JOSM'),(52206684,'created_by','JOSM'),(52206686,'created_by','JOSM'),(52206688,'created_by','JOSM'),(52206694,'created_by','JOSM'),(52206698,'created_by','JOSM'),(52206701,'created_by','JOSM'),(52206703,'created_by','JOSM'),(52206706,'created_by','JOSM'),(52206708,'created_by','JOSM'),(52206710,'created_by','JOSM'),(52206714,'created_by','JOSM'),(52212234,'created_by','JOSM'),(52212307,'created_by','JOSM'),(52212628,'created_by','JOSM'),(52212746,'created_by','JOSM'),(52212871,'created_by','JOSM'),(52212893,'created_by','JOSM'),(52212906,'created_by','JOSM'),(52212916,'created_by','JOSM'),(52212920,'created_by','JOSM'),(52252247,'created_by','JOSM'),(52252315,'created_by','JOSM'),(52252320,'created_by','JOSM'),(52252322,'created_by','JOSM'),(52252325,'created_by','JOSM'),(52252326,'created_by','JOSM'),(52252328,'created_by','JOSM'),(52252330,'created_by','JOSM'),(52252331,'created_by','JOSM'),(52252333,'created_by','JOSM'),(52252336,'created_by','JOSM'),(52252404,'created_by','JOSM'),(52252405,'created_by','JOSM'),(52252407,'created_by','JOSM'),(52252411,'created_by','JOSM'),(52252412,'created_by','JOSM'),(52252414,'created_by','JOSM'),(52252416,'created_by','JOSM'),(52252417,'created_by','JOSM'),(52252420,'created_by','JOSM'),(52252422,'created_by','JOSM'),(52252423,'created_by','JOSM'),(52252424,'created_by','JOSM'),(52252426,'created_by','JOSM'),(52252427,'created_by','JOSM'),(52252429,'created_by','JOSM'),(52252430,'created_by','JOSM'),(52252431,'created_by','JOSM'),(52252433,'created_by','JOSM'),(52252434,'created_by','JOSM'),(52252435,'created_by','JOSM'),(52252437,'created_by','JOSM'),(52252452,'created_by','JOSM'),(52252472,'created_by','JOSM'),(52252473,'created_by','JOSM'),(52252474,'created_by','JOSM'),(52252475,'created_by','JOSM'),(52252476,'created_by','JOSM'),(52252477,'created_by','JOSM'),(52252478,'created_by','JOSM'),(52252479,'created_by','JOSM'),(52252480,'created_by','JOSM'),(52261829,'created_by','JOSM'),(52261834,'created_by','JOSM'),(52261835,'created_by','JOSM'),(52261839,'created_by','JOSM'),(52261842,'created_by','JOSM'),(52261846,'created_by','JOSM'),(52261850,'created_by','JOSM'),(52261853,'created_by','JOSM'),(52261857,'created_by','JOSM'),(52261860,'created_by','JOSM'),(52261864,'created_by','JOSM'),(52261866,'created_by','JOSM'),(52261869,'created_by','JOSM'),(52261872,'created_by','JOSM'),(52261874,'created_by','JOSM'),(52261878,'created_by','JOSM'),(52261880,'created_by','JOSM'),(52261883,'created_by','JOSM'),(52261999,'created_by','JOSM'),(52262003,'created_by','JOSM'),(52262006,'created_by','JOSM'),(52262010,'created_by','JOSM'),(52262016,'created_by','JOSM'),(52262020,'created_by','JOSM'),(52262166,'name','Pont de Faucellers'),(52262538,'created_by','JOSM'),(52262541,'created_by','JOSM'),(52262544,'created_by','JOSM'),(52262546,'created_by','JOSM'),(52262550,'created_by','JOSM'),(52262552,'created_by','JOSM'),(52262556,'created_by','JOSM'),(52262560,'created_by','JOSM'),(52262563,'created_by','JOSM'),(52262910,'created_by','JOSM'),(52262913,'created_by','JOSM'),(52262916,'created_by','JOSM'),(52262919,'created_by','JOSM'),(52262921,'created_by','JOSM'),(52262925,'created_by','JOSM'),(52262930,'created_by','JOSM'),(52262934,'created_by','JOSM'),(52262941,'created_by','JOSM'),(52262944,'created_by','JOSM'),(52262946,'created_by','JOSM'),(52262949,'created_by','JOSM'),(52262954,'created_by','JOSM'),(52262957,'created_by','JOSM'),(52262961,'created_by','JOSM'),(52262963,'created_by','JOSM'),(52262970,'created_by','JOSM'),(52262973,'created_by','JOSM'),(52262977,'created_by','JOSM'),(52262979,'created_by','JOSM'),(52262981,'created_by','JOSM'),(52263076,'created_by','JOSM'),(52263079,'created_by','JOSM'),(52263083,'created_by','JOSM'),(52263091,'created_by','JOSM'),(52263095,'created_by','JOSM'),(52263098,'created_by','JOSM'),(52263100,'created_by','JOSM'),(52263106,'created_by','JOSM'),(52263109,'created_by','JOSM'),(52263111,'created_by','JOSM'),(52263113,'created_by','JOSM'),(52263117,'created_by','JOSM'),(52263119,'created_by','JOSM'),(52263162,'created_by','JOSM'),(52263166,'created_by','JOSM'),(52263168,'created_by','JOSM'),(52263171,'created_by','JOSM'),(52263173,'created_by','JOSM'),(52263177,'created_by','JOSM'),(52263180,'created_by','JOSM'),(52263183,'created_by','JOSM'),(52263186,'created_by','JOSM'),(52263190,'created_by','JOSM'),(52263191,'created_by','JOSM'),(52263549,'created_by','JOSM'),(52263553,'created_by','JOSM'),(52263554,'created_by','JOSM'),(52263556,'created_by','JOSM'),(52263559,'created_by','JOSM'),(52263560,'created_by','JOSM'),(52263563,'created_by','JOSM'),(52263566,'created_by','JOSM'),(52263570,'created_by','JOSM'),(52263573,'created_by','JOSM'),(52263575,'created_by','JOSM'),(52263577,'created_by','JOSM'),(52263579,'created_by','JOSM'),(52263581,'created_by','JOSM'),(52263584,'created_by','JOSM'),(52263586,'created_by','JOSM'),(52263588,'created_by','JOSM'),(52263593,'created_by','JOSM'),(52263595,'created_by','JOSM'),(52263598,'created_by','JOSM'),(52263602,'created_by','JOSM'),(52263605,'created_by','JOSM'),(52263608,'created_by','JOSM'),(52263611,'created_by','JOSM'),(52263615,'created_by','JOSM'),(52263617,'created_by','JOSM'),(52263618,'created_by','JOSM'),(52263623,'created_by','JOSM'),(52263625,'created_by','JOSM'),(52263628,'created_by','JOSM'),(52263629,'created_by','JOSM'),(52263632,'created_by','JOSM'),(52263634,'created_by','JOSM'),(52263637,'created_by','JOSM'),(52263639,'created_by','JOSM'),(52263641,'created_by','JOSM'),(52263644,'created_by','JOSM'),(52263646,'created_by','JOSM'),(52263649,'created_by','JOSM'),(52263650,'created_by','JOSM'),(52263652,'created_by','JOSM'),(52263655,'created_by','JOSM'),(52263657,'created_by','JOSM'),(52263660,'created_by','JOSM'),(52263662,'created_by','JOSM'),(52263665,'created_by','JOSM'),(52263667,'created_by','JOSM'),(52263669,'created_by','JOSM'),(52263670,'created_by','JOSM'),(52263672,'created_by','JOSM'),(52263674,'created_by','JOSM'),(52263677,'created_by','JOSM'),(52263678,'created_by','JOSM'),(52263681,'created_by','JOSM'),(52263683,'created_by','JOSM'),(52263686,'created_by','JOSM'),(52263687,'created_by','JOSM'),(52263688,'created_by','JOSM'),(52263691,'created_by','JOSM'),(52263693,'created_by','JOSM'),(52263696,'created_by','JOSM'),(52263698,'created_by','JOSM'),(52263700,'created_by','JOSM'),(52263702,'created_by','JOSM'),(52263704,'created_by','JOSM'),(52263706,'created_by','JOSM'),(52263708,'created_by','JOSM'),(52263711,'created_by','JOSM'),(52263712,'created_by','JOSM'),(52263713,'created_by','JOSM'),(52263716,'created_by','JOSM'),(52263717,'created_by','JOSM'),(52263718,'created_by','JOSM'),(52263721,'created_by','JOSM'),(52263722,'created_by','JOSM'),(52263724,'created_by','JOSM'),(52263726,'created_by','JOSM'),(52263727,'created_by','JOSM'),(52263854,'created_by','JOSM'),(52263857,'created_by','JOSM'),(52263858,'created_by','JOSM'),(52263860,'created_by','JOSM'),(52263863,'created_by','JOSM'),(52263865,'created_by','JOSM'),(52263870,'created_by','JOSM'),(52263873,'created_by','JOSM'),(52263875,'created_by','JOSM'),(52263876,'created_by','JOSM'),(52263877,'created_by','JOSM'),(52286947,'created_by','JOSM'),(52286950,'created_by','JOSM'),(52286951,'created_by','JOSM'),(52286954,'created_by','JOSM'),(52286967,'created_by','JOSM'),(52286970,'created_by','JOSM'),(52286971,'created_by','JOSM'),(52286973,'created_by','JOSM'),(52286974,'created_by','JOSM'),(52287059,'created_by','JOSM'),(52287062,'created_by','JOSM'),(52287063,'created_by','JOSM'),(52296455,'created_by','JOSM'),(52296457,'created_by','JOSM'),(52296459,'created_by','JOSM'),(52296460,'created_by','JOSM'),(52296461,'created_by','JOSM'),(52296462,'created_by','JOSM'),(52296464,'created_by','JOSM'),(52296465,'created_by','JOSM'),(52296467,'created_by','JOSM'),(52296469,'created_by','JOSM'),(52296471,'created_by','JOSM'),(52296472,'created_by','JOSM'),(52296476,'created_by','JOSM'),(52296478,'created_by','JOSM'),(52296481,'created_by','JOSM'),(52296483,'created_by','JOSM'),(52296485,'created_by','JOSM'),(52296486,'created_by','JOSM'),(52296489,'created_by','JOSM'),(52296490,'created_by','JOSM'),(52296492,'created_by','JOSM'),(52296494,'created_by','JOSM'),(52296495,'created_by','JOSM'),(52296497,'created_by','JOSM'),(52296975,'created_by','JOSM'),(52296977,'created_by','JOSM'),(52296978,'created_by','JOSM'),(52296979,'created_by','JOSM'),(52296981,'created_by','JOSM'),(52296982,'created_by','JOSM'),(52296984,'created_by','JOSM'),(52296985,'created_by','JOSM'),(52296987,'created_by','JOSM'),(52296990,'created_by','JOSM'),(52296992,'created_by','JOSM'),(52296994,'created_by','JOSM'),(52296996,'created_by','JOSM'),(52296999,'created_by','JOSM'),(52297002,'created_by','JOSM'),(52297004,'created_by','JOSM'),(52297007,'created_by','JOSM'),(52297010,'created_by','JOSM'),(52297013,'created_by','JOSM'),(52297015,'created_by','JOSM'),(52297018,'created_by','JOSM'),(52297038,'created_by','JOSM'),(52297041,'created_by','JOSM'),(52297063,'created_by','JOSM'),(52297071,'created_by','JOSM'),(52297255,'created_by','JOSM'),(52297266,'created_by','JOSM'),(52297268,'created_by','JOSM'),(52297272,'created_by','JOSM'),(52297276,'created_by','JOSM'),(52297279,'created_by','JOSM'),(52297281,'created_by','JOSM'),(52297285,'created_by','JOSM'),(52297288,'created_by','JOSM'),(52297290,'created_by','JOSM'),(52297294,'created_by','JOSM'),(52297297,'created_by','JOSM'),(52297300,'created_by','JOSM'),(52297305,'created_by','JOSM'),(52297309,'created_by','JOSM'),(52297312,'created_by','JOSM'),(52297314,'created_by','JOSM'),(52297317,'created_by','JOSM'),(52297320,'created_by','JOSM'),(52297324,'created_by','JOSM'),(52297328,'created_by','JOSM'),(52297333,'created_by','JOSM'),(52297339,'created_by','JOSM'),(52297344,'created_by','JOSM'),(52297349,'created_by','JOSM'),(52297354,'created_by','JOSM'),(52297358,'created_by','JOSM'),(52297362,'created_by','JOSM'),(52297366,'created_by','JOSM'),(52297369,'created_by','JOSM'),(52297373,'created_by','JOSM'),(52297375,'created_by','JOSM'),(52297380,'created_by','JOSM'),(52297383,'created_by','JOSM'),(52297386,'created_by','JOSM'),(52297390,'created_by','JOSM'),(52297393,'created_by','JOSM'),(52297402,'created_by','JOSM'),(52297405,'created_by','JOSM'),(52297410,'created_by','JOSM'),(52297412,'created_by','JOSM'),(52297418,'created_by','JOSM'),(52297422,'created_by','JOSM'),(52297424,'created_by','JOSM'),(52297427,'created_by','JOSM'),(52297432,'created_by','JOSM'),(52297435,'created_by','JOSM'),(52297437,'created_by','JOSM'),(52297440,'created_by','JOSM'),(52297442,'created_by','JOSM'),(52297447,'created_by','JOSM'),(52297450,'created_by','JOSM'),(52297455,'created_by','JOSM'),(52297459,'created_by','JOSM'),(52297462,'created_by','JOSM'),(52297465,'created_by','JOSM'),(52297469,'created_by','JOSM'),(52297470,'created_by','JOSM'),(52297474,'created_by','JOSM'),(52297478,'created_by','JOSM'),(52297482,'created_by','JOSM'),(52297484,'created_by','JOSM'),(52297488,'created_by','JOSM'),(52297492,'created_by','JOSM'),(52297494,'created_by','JOSM'),(52297498,'created_by','JOSM'),(52297507,'created_by','JOSM'),(52297509,'created_by','JOSM'),(52297515,'created_by','JOSM'),(52297517,'created_by','JOSM'),(52297520,'created_by','JOSM'),(52297521,'created_by','JOSM'),(52297525,'created_by','JOSM'),(52297528,'created_by','JOSM'),(52297532,'created_by','JOSM'),(52297535,'created_by','JOSM'),(52297537,'created_by','JOSM'),(52297540,'created_by','JOSM'),(52297542,'created_by','JOSM'),(52297545,'created_by','JOSM'),(52297547,'created_by','JOSM'),(52297550,'created_by','JOSM'),(52297554,'created_by','JOSM'),(52297558,'created_by','JOSM'),(52297560,'created_by','JOSM'),(52297563,'created_by','JOSM'),(52297565,'created_by','JOSM'),(52297567,'created_by','JOSM'),(52297571,'created_by','JOSM'),(52297573,'created_by','JOSM'),(52297576,'created_by','JOSM'),(52297580,'created_by','JOSM'),(52297584,'created_by','JOSM'),(52297587,'created_by','JOSM'),(52297590,'created_by','JOSM'),(52297592,'created_by','JOSM'),(52297595,'created_by','JOSM'),(52297599,'created_by','JOSM'),(52297602,'created_by','JOSM'),(52297606,'created_by','JOSM'),(52297609,'created_by','JOSM'),(52297612,'created_by','JOSM'),(52297615,'created_by','JOSM'),(52297617,'created_by','JOSM'),(52297621,'created_by','JOSM'),(52297623,'created_by','JOSM'),(52297626,'created_by','JOSM'),(52297629,'created_by','JOSM'),(52297633,'created_by','JOSM'),(52297638,'created_by','JOSM'),(52297640,'created_by','JOSM'),(52297643,'created_by','JOSM'),(52297646,'created_by','JOSM'),(52322112,'created_by','JOSM'),(52322115,'created_by','JOSM'),(52322119,'created_by','JOSM'),(52322122,'created_by','JOSM'),(52322125,'created_by','JOSM'),(52322137,'created_by','JOSM'),(52322143,'created_by','JOSM'),(52322151,'created_by','JOSM'),(52322153,'created_by','JOSM'),(52322155,'created_by','JOSM'),(52322156,'created_by','JOSM'),(52322157,'created_by','JOSM'),(52322159,'created_by','JOSM'),(52322163,'created_by','JOSM'),(52322165,'created_by','JOSM'),(52322167,'created_by','JOSM'),(52322170,'created_by','JOSM'),(52322171,'created_by','JOSM'),(52322174,'created_by','JOSM'),(52322177,'created_by','JOSM'),(52322180,'created_by','JOSM'),(52322184,'created_by','JOSM'),(52322185,'created_by','JOSM'),(52322190,'created_by','JOSM'),(52322193,'created_by','JOSM'),(52322196,'created_by','JOSM'),(52322198,'created_by','JOSM'),(52322200,'created_by','JOSM'),(52322203,'created_by','JOSM'),(52322207,'created_by','JOSM'),(52322210,'created_by','JOSM'),(52322213,'created_by','JOSM'),(52322216,'created_by','JOSM'),(52322219,'created_by','JOSM'),(52322222,'created_by','JOSM'),(52322223,'created_by','JOSM'),(52322225,'created_by','JOSM'),(52322228,'created_by','JOSM'),(52322231,'created_by','JOSM'),(52322235,'created_by','JOSM'),(52322237,'created_by','JOSM'),(52322240,'created_by','JOSM'),(52322242,'created_by','JOSM'),(52322244,'created_by','JOSM'),(52322245,'created_by','JOSM'),(52322247,'created_by','JOSM'),(52322249,'created_by','JOSM'),(52322252,'created_by','JOSM'),(52322255,'created_by','JOSM'),(52322256,'created_by','JOSM'),(52322259,'created_by','JOSM'),(52322262,'created_by','JOSM'),(52322266,'created_by','JOSM'),(52322268,'created_by','JOSM'),(52322271,'created_by','JOSM'),(52322273,'created_by','JOSM'),(52322277,'created_by','JOSM'),(52322278,'created_by','JOSM'),(52322279,'created_by','JOSM'),(52322282,'created_by','JOSM'),(52322285,'created_by','JOSM'),(52322286,'created_by','JOSM'),(52322289,'created_by','JOSM'),(52322292,'created_by','JOSM'),(52322293,'created_by','JOSM'),(52322295,'created_by','JOSM'),(52322298,'created_by','JOSM'),(52322299,'created_by','JOSM'),(52322302,'created_by','JOSM'),(52322305,'created_by','JOSM'),(52322308,'created_by','JOSM'),(52322309,'created_by','JOSM'),(52322311,'created_by','JOSM'),(52322313,'created_by','JOSM'),(52322315,'created_by','JOSM'),(52322316,'created_by','JOSM'),(52322318,'created_by','JOSM'),(52322320,'created_by','JOSM'),(52322322,'created_by','JOSM'),(52322324,'created_by','JOSM'),(52322327,'created_by','JOSM'),(52322329,'created_by','JOSM'),(52322331,'created_by','JOSM'),(52322333,'created_by','JOSM'),(52322335,'created_by','JOSM'),(52322336,'created_by','JOSM'),(52322337,'created_by','JOSM'),(52322339,'created_by','JOSM'),(52322341,'created_by','JOSM'),(52322342,'created_by','JOSM'),(52322344,'created_by','JOSM'),(52322345,'created_by','JOSM'),(52322347,'created_by','JOSM'),(52322349,'created_by','JOSM'),(52322351,'created_by','JOSM'),(52322353,'created_by','JOSM'),(52322355,'created_by','JOSM'),(52322357,'created_by','JOSM'),(52322358,'created_by','JOSM'),(52322359,'created_by','JOSM'),(52322361,'created_by','JOSM'),(52322363,'created_by','JOSM'),(52322364,'created_by','JOSM'),(52322365,'created_by','JOSM'),(52322366,'created_by','JOSM'),(52322368,'created_by','JOSM'),(52322370,'created_by','JOSM'),(52322372,'created_by','JOSM'),(52322374,'created_by','JOSM'),(52322376,'created_by','JOSM'),(52322378,'created_by','JOSM'),(52322380,'created_by','JOSM'),(52322382,'created_by','JOSM'),(52322384,'created_by','JOSM'),(52322386,'created_by','JOSM'),(52322388,'created_by','JOSM'),(52322390,'created_by','JOSM'),(52322392,'created_by','JOSM'),(52322395,'created_by','JOSM'),(52322398,'created_by','JOSM'),(52322400,'created_by','JOSM'),(52322402,'created_by','JOSM'),(52322405,'created_by','JOSM'),(52322408,'created_by','JOSM'),(52322411,'created_by','JOSM'),(52322413,'created_by','JOSM'),(52322415,'created_by','JOSM'),(52322419,'created_by','JOSM'),(52322422,'created_by','JOSM'),(52322424,'created_by','JOSM'),(52322429,'created_by','JOSM'),(52322432,'created_by','JOSM'),(52322434,'created_by','JOSM'),(52322437,'created_by','JOSM'),(52322440,'created_by','JOSM'),(52322441,'created_by','JOSM'),(52322443,'created_by','JOSM'),(52322446,'created_by','JOSM'),(52322449,'created_by','JOSM'),(52322451,'created_by','JOSM'),(52322453,'created_by','JOSM'),(52322455,'created_by','JOSM'),(52322458,'created_by','JOSM'),(52322461,'created_by','JOSM'),(52322463,'created_by','JOSM'),(52322465,'created_by','JOSM'),(52322467,'created_by','JOSM'),(52322470,'created_by','JOSM'),(52322473,'created_by','JOSM'),(52322475,'created_by','JOSM'),(52322478,'created_by','JOSM'),(52322481,'created_by','JOSM'),(52322484,'created_by','JOSM'),(52322486,'created_by','JOSM'),(52322488,'created_by','JOSM'),(52322492,'created_by','JOSM'),(52322493,'created_by','JOSM'),(52322496,'created_by','JOSM'),(52322497,'created_by','JOSM'),(52322500,'created_by','JOSM'),(52322502,'created_by','JOSM'),(52322504,'created_by','JOSM'),(52322508,'created_by','JOSM'),(52322510,'created_by','JOSM'),(52322512,'created_by','JOSM'),(52322515,'created_by','JOSM'),(52322516,'created_by','JOSM'),(52322518,'created_by','JOSM'),(52322520,'created_by','JOSM'),(52322523,'created_by','JOSM'),(52322526,'created_by','JOSM'),(52322528,'created_by','JOSM'),(52322530,'created_by','JOSM'),(52322533,'created_by','JOSM'),(52322534,'created_by','JOSM'),(52322537,'created_by','JOSM'),(52322540,'created_by','JOSM'),(52322542,'created_by','JOSM'),(52322544,'created_by','JOSM'),(52322545,'created_by','JOSM'),(52322548,'created_by','JOSM'),(52322551,'created_by','JOSM'),(52322552,'created_by','JOSM'),(52322554,'created_by','JOSM'),(52322557,'created_by','JOSM'),(52322558,'created_by','JOSM'),(52322561,'created_by','JOSM'),(52322562,'created_by','JOSM'),(52322564,'created_by','JOSM'),(52322567,'created_by','JOSM'),(52322570,'created_by','JOSM'),(52322571,'created_by','JOSM'),(52322574,'created_by','JOSM'),(52322578,'created_by','JOSM'),(52322579,'created_by','JOSM'),(52322581,'created_by','JOSM'),(52322583,'created_by','JOSM'),(52322585,'created_by','JOSM'),(52322587,'created_by','JOSM'),(52322589,'created_by','JOSM'),(52322591,'created_by','JOSM'),(52322593,'created_by','JOSM'),(52322595,'created_by','JOSM'),(52322598,'created_by','JOSM'),(52322601,'created_by','JOSM'),(52322602,'created_by','JOSM'),(52322604,'created_by','JOSM'),(52322606,'created_by','JOSM'),(52322611,'created_by','JOSM'),(52322613,'created_by','JOSM'),(52322615,'created_by','JOSM'),(52322617,'created_by','JOSM'),(52322618,'created_by','JOSM'),(52322623,'created_by','JOSM'),(52322626,'created_by','JOSM'),(52322627,'created_by','JOSM'),(52322630,'created_by','JOSM'),(52322632,'created_by','JOSM'),(52322634,'created_by','JOSM'),(52322636,'created_by','JOSM'),(52322639,'created_by','JOSM'),(52322641,'created_by','JOSM'),(52322644,'created_by','JOSM'),(52322646,'created_by','JOSM'),(52322648,'created_by','JOSM'),(52322651,'created_by','JOSM'),(52322654,'created_by','JOSM'),(52322656,'created_by','JOSM'),(52322657,'created_by','JOSM'),(52322660,'created_by','JOSM'),(52322663,'created_by','JOSM'),(52322665,'created_by','JOSM'),(52322667,'created_by','JOSM'),(52322670,'created_by','JOSM'),(52322673,'created_by','JOSM'),(52322675,'created_by','JOSM'),(52322677,'created_by','JOSM'),(52322678,'created_by','JOSM'),(52322681,'created_by','JOSM'),(52322684,'created_by','JOSM'),(52322685,'created_by','JOSM'),(52322687,'created_by','JOSM'),(52322690,'created_by','JOSM'),(52322692,'created_by','JOSM'),(52322695,'created_by','JOSM'),(52322697,'created_by','JOSM'),(52322698,'created_by','JOSM'),(52322700,'created_by','JOSM'),(52322701,'created_by','JOSM'),(52322704,'created_by','JOSM'),(52322706,'created_by','JOSM'),(52322709,'created_by','JOSM'),(52322712,'created_by','JOSM'),(52322713,'created_by','JOSM'),(52322716,'created_by','JOSM'),(52322719,'created_by','JOSM'),(52322722,'created_by','JOSM'),(52322725,'created_by','JOSM'),(52322727,'created_by','JOSM'),(52322729,'created_by','JOSM'),(52322731,'created_by','JOSM'),(52322733,'created_by','JOSM'),(52322736,'created_by','JOSM'),(52322738,'created_by','JOSM'),(52322739,'created_by','JOSM'),(52322741,'created_by','JOSM'),(52322753,'created_by','JOSM'),(52322755,'created_by','JOSM'),(52322758,'created_by','JOSM'),(52322761,'created_by','JOSM'),(52322764,'created_by','JOSM'),(52322765,'created_by','JOSM'),(52322768,'created_by','JOSM'),(52322770,'created_by','JOSM'),(52322773,'created_by','JOSM'),(52322774,'created_by','JOSM'),(52322777,'created_by','JOSM'),(52322780,'created_by','JOSM'),(52322782,'created_by','JOSM'),(52322785,'created_by','JOSM'),(52322787,'created_by','JOSM'),(52322789,'created_by','JOSM'),(52322791,'created_by','JOSM'),(52322793,'created_by','JOSM'),(52322795,'created_by','JOSM'),(52322796,'created_by','JOSM'),(52322799,'created_by','JOSM'),(52322800,'created_by','JOSM'),(52322802,'created_by','JOSM'),(52322804,'created_by','JOSM'),(52322806,'created_by','JOSM'),(52322809,'created_by','JOSM'),(52322810,'created_by','JOSM'),(52322815,'created_by','JOSM'),(52322816,'created_by','JOSM'),(52322819,'created_by','JOSM'),(52322823,'created_by','JOSM'),(52322826,'created_by','JOSM'),(52322827,'created_by','JOSM'),(52322830,'created_by','JOSM'),(52322833,'created_by','JOSM'),(52322836,'created_by','JOSM'),(52322837,'created_by','JOSM'),(52322840,'created_by','JOSM'),(52322842,'created_by','JOSM'),(52322844,'created_by','JOSM'),(52322846,'created_by','JOSM'),(52322847,'created_by','JOSM'),(52322850,'created_by','JOSM'),(52322851,'created_by','JOSM'),(52322855,'created_by','JOSM'),(52322858,'created_by','JOSM'),(52322859,'created_by','JOSM'),(52322863,'created_by','JOSM'),(52322865,'created_by','JOSM'),(52322867,'created_by','JOSM'),(52322871,'created_by','JOSM'),(52322874,'created_by','JOSM'),(52322877,'created_by','JOSM'),(52322879,'created_by','JOSM'),(52322880,'created_by','JOSM'),(52322883,'created_by','JOSM'),(52322887,'created_by','JOSM'),(52322889,'created_by','JOSM'),(52322891,'created_by','JOSM'),(52322893,'created_by','JOSM'),(52322896,'created_by','JOSM'),(52322898,'created_by','JOSM'),(52322902,'created_by','JOSM'),(52322903,'created_by','JOSM'),(52322904,'created_by','JOSM'),(52322907,'created_by','JOSM'),(52322910,'created_by','JOSM'),(52322911,'created_by','JOSM'),(52322915,'created_by','JOSM'),(52322917,'created_by','JOSM'),(52322919,'created_by','JOSM'),(52322921,'created_by','JOSM'),(52322924,'created_by','JOSM'),(52322927,'created_by','JOSM'),(52322929,'created_by','JOSM'),(52322931,'created_by','JOSM'),(52322934,'created_by','JOSM'),(52322937,'created_by','JOSM'),(52322940,'created_by','JOSM'),(52322942,'created_by','JOSM'),(52322945,'created_by','JOSM'),(52322947,'created_by','JOSM'),(52322950,'created_by','JOSM'),(52322953,'created_by','JOSM'),(52322955,'created_by','JOSM'),(52322957,'created_by','JOSM'),(52322959,'created_by','JOSM'),(52322962,'created_by','JOSM'),(52322964,'created_by','JOSM'),(52322966,'created_by','JOSM'),(52322969,'created_by','JOSM'),(52322972,'created_by','JOSM'),(52322974,'created_by','JOSM'),(52322976,'created_by','JOSM'),(52322977,'created_by','JOSM'),(52322979,'created_by','JOSM'),(52322982,'created_by','JOSM'),(52327233,'created_by','JOSM'),(52327235,'created_by','JOSM'),(52327238,'created_by','JOSM'),(52327241,'created_by','JOSM'),(52327243,'created_by','JOSM'),(52327246,'created_by','JOSM'),(52327247,'created_by','JOSM'),(52327250,'created_by','JOSM'),(52327252,'created_by','JOSM'),(52327263,'created_by','JOSM'),(52327265,'created_by','JOSM'),(52327268,'created_by','JOSM'),(52327271,'created_by','JOSM'),(52327274,'created_by','JOSM'),(52327277,'created_by','JOSM'),(52327279,'created_by','JOSM'),(52327281,'created_by','JOSM'),(52327282,'created_by','JOSM'),(52327285,'created_by','JOSM'),(52327287,'created_by','JOSM'),(52327288,'created_by','JOSM'),(52327290,'created_by','JOSM'),(52327292,'created_by','JOSM'),(52327295,'created_by','JOSM'),(52327298,'created_by','JOSM'),(52327300,'created_by','JOSM'),(52327302,'created_by','JOSM'),(52327303,'created_by','JOSM'),(52327306,'created_by','JOSM'),(52327309,'created_by','JOSM'),(52327310,'created_by','JOSM'),(52327313,'created_by','JOSM'),(52327316,'created_by','JOSM'),(52327317,'created_by','JOSM'),(52327321,'created_by','JOSM'),(52327325,'created_by','JOSM'),(52327328,'created_by','JOSM'),(52327329,'created_by','JOSM'),(52327331,'created_by','JOSM'),(52327333,'created_by','JOSM'),(52327337,'created_by','JOSM'),(52327339,'created_by','JOSM'),(52327341,'created_by','JOSM'),(52327342,'created_by','JOSM'),(52327345,'created_by','JOSM'),(52327347,'created_by','JOSM'),(52327351,'created_by','JOSM'),(52327354,'created_by','JOSM'),(52327358,'created_by','JOSM'),(52327359,'created_by','JOSM'),(52327361,'created_by','JOSM'),(52327362,'created_by','JOSM'),(52327365,'created_by','JOSM'),(52327368,'created_by','JOSM'),(52327371,'created_by','JOSM'),(52327372,'created_by','JOSM'),(52327375,'created_by','JOSM'),(52327378,'created_by','JOSM'),(52327379,'created_by','JOSM'),(52327381,'created_by','JOSM'),(52327383,'created_by','JOSM'),(52327384,'created_by','JOSM'),(52327387,'created_by','JOSM'),(52327388,'created_by','JOSM'),(52327390,'created_by','JOSM'),(52327392,'created_by','JOSM'),(52327393,'created_by','JOSM'),(52327398,'created_by','JOSM'),(52327401,'created_by','JOSM'),(52327403,'created_by','JOSM'),(52327406,'created_by','JOSM'),(52327408,'created_by','JOSM'),(52327411,'created_by','JOSM'),(52327413,'created_by','JOSM'),(52327417,'created_by','JOSM'),(52327418,'created_by','JOSM'),(52327421,'created_by','JOSM'),(52327423,'created_by','JOSM'),(52327427,'created_by','JOSM'),(52327429,'created_by','JOSM'),(52327432,'created_by','JOSM'),(52327434,'created_by','JOSM'),(52328346,'created_by','JOSM'),(52328347,'created_by','JOSM'),(52328348,'created_by','JOSM'),(52328350,'created_by','JOSM'),(52328353,'created_by','JOSM'),(52328354,'created_by','JOSM'),(52328357,'created_by','JOSM'),(52328358,'created_by','JOSM'),(52328360,'created_by','JOSM'),(52328362,'created_by','JOSM'),(52328364,'created_by','JOSM'),(52328365,'created_by','JOSM'),(52328367,'created_by','JOSM'),(52328370,'created_by','JOSM'),(52328373,'created_by','JOSM'),(52329934,'created_by','JOSM'),(52329937,'created_by','JOSM'),(52329940,'created_by','JOSM'),(52329942,'created_by','JOSM'),(52329943,'created_by','JOSM'),(52329946,'created_by','JOSM'),(52329948,'created_by','JOSM'),(52329951,'created_by','JOSM'),(52329953,'created_by','JOSM'),(52329956,'created_by','JOSM'),(52329957,'created_by','JOSM'),(52329960,'created_by','JOSM'),(52329962,'created_by','JOSM'),(52329964,'created_by','JOSM'),(52329967,'created_by','JOSM'),(52329968,'created_by','JOSM'),(52329970,'created_by','JOSM'),(52329972,'created_by','JOSM'),(52329974,'created_by','JOSM'),(52329978,'created_by','JOSM'),(52329981,'created_by','JOSM'),(52330668,'created_by','JOSM'),(52330669,'created_by','JOSM'),(52330670,'created_by','JOSM'),(52330671,'created_by','JOSM'),(52330672,'created_by','JOSM'),(52330673,'created_by','JOSM'),(52330674,'created_by','JOSM'),(52330675,'created_by','JOSM'),(52330676,'created_by','JOSM'),(52330677,'created_by','JOSM'),(52330678,'created_by','JOSM'),(52578637,'created_by','JOSM'),(52578801,'created_by','JOSM'),(52578802,'created_by','JOSM'),(52578805,'created_by','JOSM'),(52596149,'created_by','JOSM'),(52596154,'created_by','JOSM'),(52596158,'created_by','JOSM'),(52596161,'created_by','JOSM'),(52596163,'created_by','JOSM'),(52596167,'created_by','JOSM'),(52596171,'created_by','JOSM'),(52596178,'created_by','JOSM'),(52596180,'created_by','JOSM'),(52596184,'created_by','JOSM'),(52596186,'created_by','JOSM'),(52596191,'created_by','JOSM'),(52596195,'created_by','JOSM'),(52596197,'created_by','JOSM'),(52596200,'created_by','JOSM'),(52596204,'created_by','JOSM'),(52596208,'created_by','JOSM'),(52596212,'created_by','JOSM'),(52596213,'created_by','JOSM'),(52596216,'created_by','JOSM'),(52596219,'created_by','JOSM'),(52596222,'created_by','JOSM'),(52596226,'created_by','JOSM'),(52596228,'created_by','JOSM'),(52596231,'created_by','JOSM'),(52596234,'created_by','JOSM'),(52596236,'created_by','JOSM'),(52596238,'created_by','JOSM'),(52596241,'created_by','JOSM'),(52596243,'created_by','JOSM'),(52596246,'created_by','JOSM'),(52596249,'created_by','JOSM'),(52596271,'created_by','JOSM'),(52596274,'created_by','JOSM'),(52596277,'created_by','JOSM'),(52596280,'created_by','JOSM'),(52596283,'created_by','JOSM'),(52596285,'created_by','JOSM'),(52596288,'created_by','JOSM'),(52596291,'created_by','JOSM'),(52596295,'created_by','JOSM'),(52596297,'created_by','JOSM'),(52596299,'created_by','JOSM'),(52596300,'created_by','JOSM'),(52596303,'created_by','JOSM'),(52596305,'created_by','JOSM'),(52596308,'created_by','JOSM'),(52596310,'created_by','JOSM'),(52596312,'created_by','JOSM'),(52596314,'created_by','JOSM'),(52596318,'created_by','JOSM'),(52596320,'created_by','JOSM'),(52596326,'created_by','JOSM'),(52596331,'created_by','JOSM'),(52596335,'created_by','JOSM'),(52596339,'created_by','JOSM'),(52596343,'created_by','JOSM'),(52596346,'created_by','JOSM'),(52596351,'created_by','JOSM'),(52603531,'created_by','JOSM'),(52603533,'created_by','JOSM'),(52603536,'created_by','JOSM'),(52603537,'created_by','JOSM'),(52603540,'created_by','JOSM'),(52603542,'created_by','JOSM'),(52612605,'created_by','JOSM'),(52612609,'created_by','JOSM'),(52612612,'created_by','JOSM'),(52612615,'created_by','JOSM'),(52612616,'created_by','JOSM'),(52612619,'created_by','JOSM'),(52612622,'created_by','JOSM'),(52612624,'created_by','JOSM'),(52612626,'created_by','JOSM'),(52612629,'created_by','JOSM'),(52612634,'created_by','JOSM'),(52612635,'created_by','JOSM'),(52612638,'created_by','JOSM'),(52612640,'created_by','JOSM'),(52612642,'created_by','JOSM'),(52612645,'created_by','JOSM'),(52612646,'created_by','JOSM'),(52612649,'created_by','JOSM'),(52612651,'created_by','JOSM'),(52612653,'created_by','JOSM'),(52612656,'created_by','JOSM'),(52612658,'created_by','JOSM'),(52612660,'created_by','JOSM'),(52612661,'created_by','JOSM'),(52612664,'created_by','JOSM'),(52612665,'created_by','JOSM'),(52612667,'created_by','JOSM'),(52612670,'created_by','JOSM'),(52612672,'created_by','JOSM'),(52612675,'created_by','JOSM'),(52612677,'created_by','JOSM'),(52612678,'created_by','JOSM'),(52612681,'created_by','JOSM'),(52612684,'created_by','JOSM'),(52612686,'created_by','JOSM'),(52612688,'created_by','JOSM'),(52612691,'created_by','JOSM'),(52612692,'created_by','JOSM'),(52612694,'created_by','JOSM'),(52612696,'created_by','JOSM'),(52612699,'created_by','JOSM'),(52612701,'created_by','JOSM'),(52612704,'created_by','JOSM'),(52612708,'created_by','JOSM'),(52612710,'created_by','JOSM'),(52612712,'created_by','JOSM'),(52612716,'created_by','JOSM'),(52612717,'created_by','JOSM'),(52612719,'created_by','JOSM'),(52612720,'created_by','JOSM'),(52612722,'created_by','JOSM'),(52612725,'created_by','JOSM'),(52612728,'created_by','JOSM'),(52612732,'created_by','JOSM'),(52612735,'created_by','JOSM'),(52612738,'created_by','JOSM'),(52612740,'created_by','JOSM'),(52612742,'created_by','JOSM'),(52612744,'created_by','JOSM'),(52612746,'created_by','JOSM'),(52612748,'created_by','JOSM'),(52612750,'created_by','JOSM'),(52612752,'created_by','JOSM'),(52612754,'created_by','JOSM'),(52612756,'created_by','JOSM'),(52612758,'created_by','JOSM'),(52612760,'created_by','JOSM'),(52612761,'created_by','JOSM'),(52612763,'created_by','JOSM'),(52612765,'created_by','JOSM'),(52612768,'created_by','JOSM'),(52612770,'created_by','JOSM'),(52612773,'created_by','JOSM'),(52612776,'created_by','JOSM'),(52612779,'created_by','JOSM'),(52612782,'created_by','JOSM'),(52612786,'created_by','JOSM'),(52612789,'created_by','JOSM'),(52612791,'created_by','JOSM'),(52612794,'created_by','JOSM'),(52612796,'created_by','JOSM'),(52612800,'created_by','JOSM'),(52612803,'created_by','JOSM'),(52612804,'created_by','JOSM'),(52612807,'created_by','JOSM'),(52612810,'created_by','JOSM'),(52612813,'created_by','JOSM'),(52612815,'created_by','JOSM'),(52612817,'created_by','JOSM'),(52612820,'created_by','JOSM'),(52612824,'created_by','JOSM'),(52612827,'created_by','JOSM'),(52612831,'created_by','JOSM'),(52612835,'created_by','JOSM'),(52612840,'created_by','JOSM'),(52612843,'created_by','JOSM'),(52612845,'created_by','JOSM'),(52612849,'created_by','JOSM'),(52612853,'created_by','JOSM'),(52612855,'created_by','JOSM'),(52612859,'created_by','JOSM'),(52612862,'created_by','JOSM'),(52612864,'created_by','JOSM'),(52612867,'created_by','JOSM'),(52612870,'created_by','JOSM'),(52612873,'created_by','JOSM'),(52612877,'created_by','JOSM'),(52612882,'created_by','JOSM'),(52612885,'created_by','JOSM'),(52612888,'created_by','JOSM'),(52612892,'created_by','JOSM'),(52612893,'created_by','JOSM'),(52612895,'created_by','JOSM'),(52612897,'created_by','JOSM'),(52612899,'created_by','JOSM'),(52612900,'created_by','JOSM'),(52612902,'created_by','JOSM'),(52612907,'created_by','JOSM'),(52612909,'created_by','JOSM'),(52612911,'created_by','JOSM'),(52612913,'created_by','JOSM'),(52612916,'created_by','JOSM'),(52612918,'created_by','JOSM'),(52612920,'created_by','JOSM'),(52612923,'created_by','JOSM'),(52612927,'created_by','JOSM'),(52612929,'created_by','JOSM'),(52612932,'created_by','JOSM'),(52612935,'created_by','JOSM'),(52612936,'created_by','JOSM'),(52612939,'created_by','JOSM'),(52612941,'created_by','JOSM'),(52612943,'created_by','JOSM'),(52612946,'created_by','JOSM'),(52612948,'created_by','JOSM'),(52612951,'created_by','JOSM'),(52612954,'created_by','JOSM'),(52612957,'created_by','JOSM'),(52612958,'created_by','JOSM'),(52612962,'created_by','JOSM'),(52612967,'created_by','JOSM'),(52612973,'created_by','JOSM'),(52612976,'created_by','JOSM'),(52612978,'created_by','JOSM'),(52612981,'created_by','JOSM'),(52612983,'created_by','JOSM'),(52612986,'created_by','JOSM'),(52612989,'created_by','JOSM'),(52612992,'created_by','JOSM'),(52612994,'created_by','JOSM'),(52612996,'created_by','JOSM'),(52612998,'created_by','JOSM'),(52613000,'created_by','JOSM'),(52613003,'created_by','JOSM'),(52613006,'created_by','JOSM'),(52613008,'created_by','JOSM'),(52613010,'created_by','JOSM'),(52613013,'created_by','JOSM'),(52613016,'created_by','JOSM'),(52613017,'created_by','JOSM'),(52613020,'created_by','JOSM'),(52613021,'created_by','JOSM'),(52613024,'created_by','JOSM'),(52613027,'created_by','JOSM'),(52613030,'created_by','JOSM'),(52613032,'created_by','JOSM'),(52613034,'created_by','JOSM'),(52613037,'created_by','JOSM'),(52613039,'created_by','JOSM'),(52613041,'created_by','JOSM'),(52613044,'created_by','JOSM'),(52613047,'created_by','JOSM'),(52613049,'created_by','JOSM'),(52613052,'created_by','JOSM'),(52613054,'created_by','JOSM'),(52613056,'created_by','JOSM'),(52613058,'created_by','JOSM'),(52613061,'created_by','JOSM'),(52613062,'created_by','JOSM'),(52613065,'created_by','JOSM'),(52613067,'created_by','JOSM'),(52613070,'created_by','JOSM'),(52613072,'created_by','JOSM'),(52613074,'created_by','JOSM'),(52613076,'created_by','JOSM'),(52613080,'created_by','JOSM'),(52613083,'created_by','JOSM'),(52613086,'created_by','JOSM'),(52613088,'created_by','JOSM'),(52613091,'created_by','JOSM'),(52613092,'created_by','JOSM'),(52613094,'created_by','JOSM'),(52613097,'created_by','JOSM'),(52613099,'created_by','JOSM'),(52613101,'created_by','JOSM'),(52613104,'created_by','JOSM'),(52613107,'created_by','JOSM'),(52613110,'created_by','JOSM'),(52613113,'created_by','JOSM'),(52613115,'created_by','JOSM'),(52613117,'created_by','JOSM'),(52613119,'created_by','JOSM'),(52613121,'created_by','JOSM'),(52613124,'created_by','JOSM'),(52613126,'created_by','JOSM'),(52613129,'created_by','JOSM'),(52613132,'created_by','JOSM'),(52613135,'created_by','JOSM'),(52613139,'created_by','JOSM'),(52613142,'created_by','JOSM'),(52613145,'created_by','JOSM'),(52613148,'created_by','JOSM'),(52613149,'created_by','JOSM'),(52613151,'created_by','JOSM'),(52613154,'created_by','JOSM'),(52613157,'created_by','JOSM'),(52613159,'created_by','JOSM'),(52613162,'created_by','JOSM'),(52613163,'created_by','JOSM'),(52613166,'created_by','JOSM'),(52613167,'created_by','JOSM'),(52613170,'created_by','JOSM'),(52613172,'created_by','JOSM'),(52613173,'created_by','JOSM'),(52613175,'created_by','JOSM'),(52613176,'created_by','JOSM'),(52613178,'created_by','JOSM'),(52613179,'created_by','JOSM'),(52613182,'created_by','JOSM'),(52613184,'created_by','JOSM'),(52613186,'created_by','JOSM'),(52613189,'created_by','JOSM'),(52613192,'created_by','JOSM'),(52613196,'created_by','JOSM'),(52613199,'created_by','JOSM'),(52613201,'created_by','JOSM'),(52613204,'created_by','JOSM'),(52613212,'created_by','JOSM'),(52613214,'created_by','JOSM'),(52613217,'created_by','JOSM'),(52613221,'created_by','JOSM'),(52613223,'created_by','JOSM'),(52613224,'created_by','JOSM'),(52613226,'created_by','JOSM'),(52613228,'created_by','JOSM'),(52613231,'created_by','JOSM'),(52613233,'created_by','JOSM'),(52613235,'created_by','JOSM'),(52613237,'created_by','JOSM'),(52613238,'created_by','JOSM'),(52613244,'created_by','JOSM'),(52613246,'created_by','JOSM'),(52613249,'created_by','JOSM'),(52613252,'created_by','JOSM'),(52613256,'created_by','JOSM'),(52613258,'created_by','JOSM'),(52613260,'created_by','JOSM'),(52613262,'created_by','JOSM'),(52613264,'created_by','JOSM'),(52613267,'created_by','JOSM'),(52613270,'created_by','JOSM'),(52613272,'created_by','JOSM'),(52613274,'created_by','JOSM'),(52613277,'created_by','JOSM'),(52613279,'created_by','JOSM'),(52613282,'created_by','JOSM'),(52613285,'created_by','JOSM'),(52613288,'created_by','JOSM'),(52613289,'created_by','JOSM'),(52613292,'created_by','JOSM'),(52613295,'created_by','JOSM'),(52613297,'created_by','JOSM'),(52613300,'created_by','JOSM'),(52613301,'created_by','JOSM'),(52613303,'created_by','JOSM'),(52613304,'created_by','JOSM'),(52613306,'created_by','JOSM'),(52613309,'created_by','JOSM'),(52613310,'created_by','JOSM'),(52613312,'created_by','JOSM'),(52613314,'created_by','JOSM'),(52613317,'created_by','JOSM'),(52613318,'created_by','JOSM'),(52613320,'created_by','JOSM'),(52613323,'created_by','JOSM'),(52613325,'created_by','JOSM'),(52613330,'created_by','JOSM'),(52613332,'created_by','JOSM'),(52623167,'created_by','JOSM'),(52623169,'created_by','JOSM'),(52623170,'created_by','JOSM'),(52623173,'created_by','JOSM'),(52623176,'created_by','JOSM'),(52623178,'created_by','JOSM'),(52623180,'created_by','JOSM'),(52623182,'created_by','JOSM'),(52623185,'created_by','JOSM'),(52623187,'created_by','JOSM'),(52623190,'created_by','JOSM'),(52623193,'created_by','JOSM'),(52623196,'created_by','JOSM'),(52623199,'created_by','JOSM'),(52623201,'created_by','JOSM'),(52623203,'created_by','JOSM'),(52623205,'created_by','JOSM'),(52623207,'created_by','JOSM'),(52623209,'created_by','JOSM'),(52623212,'created_by','JOSM'),(52623215,'created_by','JOSM'),(52623218,'created_by','JOSM'),(52623226,'created_by','JOSM'),(52623229,'created_by','JOSM'),(52623231,'created_by','JOSM'),(52623233,'created_by','JOSM'),(52623236,'created_by','JOSM'),(52623240,'created_by','JOSM'),(52623242,'created_by','JOSM'),(52623245,'created_by','JOSM'),(52623247,'created_by','JOSM'),(52623250,'created_by','JOSM'),(52623252,'created_by','JOSM'),(52623255,'created_by','JOSM'),(52623259,'created_by','JOSM'),(52623261,'created_by','JOSM'),(52623265,'created_by','JOSM'),(52623268,'created_by','JOSM'),(52623273,'created_by','JOSM'),(52623276,'created_by','JOSM'),(52623278,'created_by','JOSM'),(52623282,'created_by','JOSM'),(52623285,'created_by','JOSM'),(52623287,'created_by','JOSM'),(52623290,'created_by','JOSM'),(52623294,'created_by','JOSM'),(52623296,'created_by','JOSM'),(52623299,'created_by','JOSM'),(52623301,'created_by','JOSM'),(52623303,'created_by','JOSM'),(52623305,'created_by','JOSM'),(52623308,'created_by','JOSM'),(52623310,'created_by','JOSM'),(52623315,'created_by','JOSM'),(52623317,'created_by','JOSM'),(52623321,'created_by','JOSM'),(52623324,'created_by','JOSM'),(52623329,'created_by','JOSM'),(52623333,'created_by','JOSM'),(52623334,'created_by','JOSM'),(52623339,'created_by','JOSM'),(52623344,'created_by','JOSM'),(52623348,'created_by','JOSM'),(52623351,'created_by','JOSM'),(52623354,'created_by','JOSM'),(52623358,'created_by','JOSM'),(52623360,'created_by','JOSM'),(52623363,'created_by','JOSM'),(52623364,'created_by','JOSM'),(52623367,'created_by','JOSM'),(52623371,'created_by','JOSM'),(52623373,'created_by','JOSM'),(52623375,'created_by','JOSM'),(52623378,'created_by','JOSM'),(52623383,'created_by','JOSM'),(52623385,'created_by','JOSM'),(52623389,'created_by','JOSM'),(52623392,'created_by','JOSM'),(52623394,'created_by','JOSM'),(52623398,'created_by','JOSM'),(52623402,'created_by','JOSM'),(52623403,'created_by','JOSM'),(52623407,'created_by','JOSM'),(52623413,'created_by','JOSM'),(52623416,'created_by','JOSM'),(52623417,'created_by','JOSM'),(52623420,'created_by','JOSM'),(52623424,'created_by','JOSM'),(52623427,'created_by','JOSM'),(52623431,'created_by','JOSM'),(52623434,'created_by','JOSM'),(52623436,'created_by','JOSM'),(52623438,'created_by','JOSM'),(52623441,'created_by','JOSM'),(52623444,'created_by','JOSM'),(52623446,'created_by','JOSM'),(52623449,'created_by','JOSM'),(52623453,'created_by','JOSM'),(52623457,'created_by','JOSM'),(52623463,'created_by','JOSM'),(52623465,'created_by','JOSM'),(52623471,'created_by','JOSM'),(52623475,'created_by','JOSM'),(52623478,'created_by','JOSM'),(52623482,'created_by','JOSM'),(52623485,'created_by','JOSM'),(52623487,'created_by','JOSM'),(52623489,'created_by','JOSM'),(52623492,'created_by','JOSM'),(52623494,'created_by','JOSM'),(52623497,'created_by','JOSM'),(52623500,'created_by','JOSM'),(52623503,'created_by','JOSM'),(52623506,'created_by','JOSM'),(52623509,'created_by','JOSM'),(52623513,'created_by','JOSM'),(52623516,'created_by','JOSM'),(52623517,'created_by','JOSM'),(52623522,'created_by','JOSM'),(52623526,'created_by','JOSM'),(52623530,'created_by','JOSM'),(52623533,'created_by','JOSM'),(52623535,'created_by','JOSM'),(52623538,'created_by','JOSM'),(52623541,'created_by','JOSM'),(52623543,'created_by','JOSM'),(52623545,'created_by','JOSM'),(52623548,'created_by','JOSM'),(52623550,'created_by','JOSM'),(52623553,'created_by','JOSM'),(52623556,'created_by','JOSM'),(52623559,'created_by','JOSM'),(52623562,'created_by','JOSM'),(52623565,'created_by','JOSM'),(52623567,'created_by','JOSM'),(52623570,'created_by','JOSM'),(52623573,'created_by','JOSM'),(52623576,'created_by','JOSM'),(52623578,'created_by','JOSM'),(52623581,'created_by','JOSM'),(52623584,'created_by','JOSM'),(52623587,'created_by','JOSM'),(52623589,'created_by','JOSM'),(52623590,'created_by','JOSM'),(52623593,'created_by','JOSM'),(52623597,'created_by','JOSM'),(52623599,'created_by','JOSM'),(52623602,'created_by','JOSM'),(52623605,'created_by','JOSM'),(52623610,'created_by','JOSM'),(52623613,'created_by','JOSM'),(52623617,'created_by','JOSM'),(52623618,'created_by','JOSM'),(52623621,'created_by','JOSM'),(52623624,'created_by','JOSM'),(52623627,'created_by','JOSM'),(52623630,'created_by','JOSM'),(52623633,'created_by','JOSM'),(52623636,'created_by','JOSM'),(52623638,'created_by','JOSM'),(52623641,'created_by','JOSM'),(52623644,'created_by','JOSM'),(52623647,'created_by','JOSM'),(52623649,'created_by','JOSM'),(52623653,'created_by','JOSM'),(52623655,'created_by','JOSM'),(52623657,'created_by','JOSM'),(52623660,'created_by','JOSM'),(52623664,'created_by','JOSM'),(52623667,'created_by','JOSM'),(52623670,'created_by','JOSM'),(52623674,'created_by','JOSM'),(52623675,'created_by','JOSM'),(52623679,'created_by','JOSM'),(52623684,'created_by','JOSM'),(52623687,'created_by','JOSM'),(52623690,'created_by','JOSM'),(52623692,'created_by','JOSM'),(52623694,'created_by','JOSM'),(52623698,'created_by','JOSM'),(52623701,'created_by','JOSM'),(52623702,'created_by','JOSM'),(52623705,'created_by','JOSM'),(52623707,'created_by','JOSM'),(52623712,'created_by','JOSM'),(52623713,'created_by','JOSM'),(52623715,'created_by','JOSM'),(52623717,'created_by','JOSM'),(52623719,'created_by','JOSM'),(52623720,'created_by','JOSM'),(52623722,'created_by','JOSM'),(52623725,'created_by','JOSM'),(52623726,'created_by','JOSM'),(52623728,'created_by','JOSM'),(52623730,'created_by','JOSM'),(52623732,'created_by','JOSM'),(52623733,'created_by','JOSM'),(52623736,'created_by','JOSM'),(52623739,'created_by','JOSM'),(52623741,'created_by','JOSM'),(52623743,'created_by','JOSM'),(52623746,'created_by','JOSM'),(52623749,'created_by','JOSM'),(52623750,'created_by','JOSM'),(52623752,'created_by','JOSM'),(52623753,'created_by','JOSM'),(52623755,'created_by','JOSM'),(52623757,'created_by','JOSM'),(52623758,'created_by','JOSM'),(52623759,'created_by','JOSM'),(52623760,'created_by','JOSM'),(52623762,'created_by','JOSM'),(52623763,'created_by','JOSM'),(52623765,'created_by','JOSM'),(52623767,'created_by','JOSM'),(52623768,'created_by','JOSM'),(52623769,'created_by','JOSM'),(52623771,'created_by','JOSM'),(52623772,'created_by','JOSM'),(52623773,'created_by','JOSM'),(52623776,'created_by','JOSM'),(52623777,'created_by','JOSM'),(52623778,'created_by','JOSM'),(52623779,'created_by','JOSM'),(52623780,'created_by','JOSM'),(52623781,'created_by','JOSM'),(52623782,'created_by','JOSM'),(52623783,'created_by','JOSM'),(52623784,'created_by','JOSM'),(52623785,'created_by','JOSM'),(52623786,'created_by','JOSM'),(52623788,'created_by','JOSM'),(52623791,'created_by','JOSM'),(52623792,'created_by','JOSM'),(52623795,'created_by','JOSM'),(52623798,'created_by','JOSM'),(52623800,'created_by','JOSM'),(52623802,'created_by','JOSM'),(52623805,'created_by','JOSM'),(52623806,'created_by','JOSM'),(52623808,'created_by','JOSM'),(52623809,'created_by','JOSM'),(52623811,'created_by','JOSM'),(52623814,'created_by','JOSM'),(52623816,'created_by','JOSM'),(52623819,'created_by','JOSM'),(52623823,'created_by','JOSM'),(52623844,'created_by','JOSM'),(52623846,'created_by','JOSM'),(52623849,'created_by','JOSM'),(52648095,'created_by','JOSM'),(52648138,'created_by','JOSM'),(52648149,'created_by','JOSM'),(52648164,'created_by','JOSM'),(52650158,'source','yahoo'),(52650659,'source','yahoo'),(52652127,'source','yahoo'),(52652273,'source','yahoo'),(52652319,'created_by','JOSM'),(52652351,'created_by','JOSM'),(52652477,'created_by','JOSM'),(52652555,'created_by','JOSM'),(52661498,'created_by','JOSM'),(52672004,'created_by','JOSM'),(52672499,'created_by','JOSM'),(52675912,'created_by','JOSM'),(52676235,'created_by','JOSM'),(52676253,'created_by','JOSM'),(52676260,'created_by','JOSM'),(52676267,'created_by','JOSM'),(52676295,'created_by','JOSM'),(52676338,'created_by','JOSM'),(52676349,'created_by','JOSM'),(52676434,'created_by','JOSM'),(52676891,'created_by','JOSM'),(52676911,'created_by','JOSM'),(52677089,'created_by','JOSM'),(52677154,'created_by','JOSM'),(52677211,'created_by','JOSM'),(52677635,'created_by','JOSM'),(52677662,'created_by','JOSM'),(52677757,'created_by','JOSM'),(52677811,'created_by','JOSM'),(52677844,'created_by','JOSM'),(52677862,'created_by','JOSM'),(52677872,'created_by','JOSM'),(52677878,'created_by','JOSM'),(52677908,'created_by','JOSM'),(52677912,'created_by','JOSM'),(52677918,'created_by','JOSM'),(52677922,'created_by','JOSM'),(52677929,'created_by','JOSM'),(52677934,'created_by','JOSM'),(52677939,'created_by','JOSM'),(52677945,'created_by','JOSM'),(52677993,'created_by','JOSM'),(52678005,'created_by','JOSM'),(52678200,'created_by','JOSM'),(52678225,'created_by','JOSM'),(52678243,'created_by','JOSM'),(52678266,'created_by','JOSM'),(52678278,'created_by','JOSM'),(52678285,'created_by','JOSM'),(52678294,'created_by','JOSM'),(52678450,'created_by','JOSM'),(52678519,'created_by','JOSM'),(52678582,'created_by','JOSM'),(52678634,'created_by','JOSM'),(52678741,'created_by','JOSM'),(52678786,'created_by','JOSM'),(52678860,'created_by','JOSM'),(52679237,'created_by','JOSM'),(52679255,'created_by','JOSM'),(52679261,'created_by','JOSM'),(52679265,'created_by','JOSM'),(52679271,'created_by','JOSM'),(52679365,'created_by','JOSM'),(52679445,'created_by','JOSM'),(52679499,'created_by','JOSM'),(52679531,'created_by','JOSM'),(52679731,'created_by','JOSM'),(52679744,'created_by','JOSM'),(52679804,'created_by','JOSM'),(52679809,'created_by','JOSM'),(52679815,'created_by','JOSM'),(52679821,'created_by','JOSM'),(52679879,'created_by','JOSM'),(52679882,'created_by','JOSM'),(52679888,'created_by','JOSM'),(52679894,'created_by','JOSM'),(52679900,'created_by','JOSM'),(52679906,'created_by','JOSM'),(52679911,'created_by','JOSM'),(52679979,'created_by','JOSM'),(52679994,'created_by','JOSM'),(52680005,'created_by','JOSM'),(52680012,'created_by','JOSM'),(52680017,'created_by','JOSM'),(52680024,'created_by','JOSM'),(52680029,'created_by','JOSM'),(52680039,'created_by','JOSM'),(52680048,'created_by','JOSM'),(52680059,'created_by','JOSM'),(52680077,'created_by','JOSM'),(52680086,'created_by','JOSM'),(52680095,'created_by','JOSM'),(52680105,'created_by','JOSM'),(52680117,'created_by','JOSM'),(52680128,'created_by','JOSM'),(52680141,'created_by','JOSM'),(52680157,'created_by','JOSM'),(52680171,'created_by','JOSM'),(52680195,'created_by','JOSM'),(52680202,'created_by','JOSM'),(52680255,'created_by','JOSM'),(52680269,'created_by','JOSM'),(52680280,'created_by','JOSM'),(52680289,'created_by','JOSM'),(52680402,'created_by','JOSM'),(52680426,'created_by','JOSM'),(52680437,'created_by','JOSM'),(52680448,'created_by','JOSM'),(52680465,'created_by','JOSM'),(52680561,'created_by','JOSM'),(52680566,'created_by','JOSM'),(52680570,'created_by','JOSM'),(52680574,'created_by','JOSM'),(52680577,'created_by','JOSM'),(52680579,'created_by','JOSM'),(52680583,'created_by','JOSM'),(52680592,'created_by','JOSM'),(52680597,'created_by','JOSM'),(52680599,'created_by','JOSM'),(52680606,'created_by','JOSM'),(52680610,'created_by','JOSM'),(52680616,'created_by','JOSM'),(52680618,'created_by','JOSM'),(52680624,'created_by','JOSM'),(52680637,'created_by','JOSM'),(52680643,'created_by','JOSM'),(52680648,'created_by','JOSM'),(52680653,'created_by','JOSM'),(52680657,'created_by','JOSM'),(52680660,'created_by','JOSM'),(52680663,'created_by','JOSM'),(52680674,'created_by','JOSM'),(52680676,'created_by','JOSM'),(52680679,'created_by','JOSM'),(52680683,'created_by','JOSM'),(52680692,'created_by','JOSM'),(52680695,'created_by','JOSM'),(52680698,'created_by','JOSM'),(52680703,'created_by','JOSM'),(52680706,'created_by','JOSM'),(52680712,'created_by','JOSM'),(52680715,'created_by','JOSM'),(52680717,'created_by','JOSM'),(52680719,'created_by','JOSM'),(52680722,'created_by','JOSM'),(52680727,'created_by','JOSM'),(52680731,'created_by','JOSM'),(52680735,'created_by','JOSM'),(52680736,'created_by','JOSM'),(52680739,'created_by','JOSM'),(52680744,'created_by','JOSM'),(52680747,'created_by','JOSM'),(52680751,'created_by','JOSM'),(52680753,'created_by','JOSM'),(52680755,'created_by','JOSM'),(52680757,'created_by','JOSM'),(52680759,'created_by','JOSM'),(52680760,'created_by','JOSM'),(52680763,'created_by','JOSM'),(52680767,'created_by','JOSM'),(52680769,'created_by','JOSM'),(52680773,'created_by','JOSM'),(52680776,'created_by','JOSM'),(52680780,'created_by','JOSM'),(52680782,'created_by','JOSM'),(52680784,'created_by','JOSM'),(52680787,'created_by','JOSM'),(52680789,'created_by','JOSM'),(52680794,'created_by','JOSM'),(52680797,'created_by','JOSM'),(52680799,'created_by','JOSM'),(52680803,'created_by','JOSM'),(52680806,'created_by','JOSM'),(52680810,'created_by','JOSM'),(52680813,'created_by','JOSM'),(52680815,'created_by','JOSM'),(52680818,'created_by','JOSM'),(52680820,'created_by','JOSM'),(52680823,'created_by','JOSM'),(52680825,'created_by','JOSM'),(52680828,'created_by','JOSM'),(52680830,'created_by','JOSM'),(52680832,'created_by','JOSM'),(52680836,'created_by','JOSM'),(52680838,'created_by','JOSM'),(52680839,'created_by','JOSM'),(52680842,'created_by','JOSM'),(52680844,'created_by','JOSM'),(52680847,'created_by','JOSM'),(52680850,'created_by','JOSM'),(52680852,'created_by','JOSM'),(52680855,'created_by','JOSM'),(52680858,'created_by','JOSM'),(52680860,'created_by','JOSM'),(52680866,'created_by','JOSM'),(52680869,'created_by','JOSM'),(52680871,'created_by','JOSM'),(52680874,'created_by','JOSM'),(52680877,'created_by','JOSM'),(52680879,'created_by','JOSM'),(52680883,'created_by','JOSM'),(52680913,'created_by','JOSM'),(52680960,'created_by','JOSM'),(52681009,'created_by','JOSM'),(52681026,'created_by','JOSM'),(52681028,'created_by','JOSM'),(52681343,'created_by','JOSM'),(52681347,'created_by','JOSM'),(52681350,'created_by','JOSM'),(52681355,'created_by','JOSM'),(52681357,'created_by','JOSM'),(52681361,'created_by','JOSM'),(52681362,'created_by','JOSM'),(52681366,'created_by','JOSM'),(52681368,'created_by','JOSM'),(52681372,'created_by','JOSM'),(52681374,'created_by','JOSM'),(52681375,'created_by','JOSM'),(52681378,'created_by','JOSM'),(52681380,'created_by','JOSM'),(52681382,'created_by','JOSM'),(52681384,'created_by','JOSM'),(52681386,'created_by','JOSM'),(52681390,'created_by','JOSM'),(52681392,'created_by','JOSM'),(52681393,'created_by','JOSM'),(52681394,'created_by','JOSM'),(52681395,'created_by','JOSM'),(52681398,'created_by','JOSM'),(52681400,'created_by','JOSM'),(52681405,'created_by','JOSM'),(52681407,'created_by','JOSM'),(52681409,'created_by','JOSM'),(52681412,'created_by','JOSM'),(52681414,'created_by','JOSM'),(52681416,'created_by','JOSM'),(52681417,'created_by','JOSM'),(52681420,'created_by','JOSM'),(52681422,'created_by','JOSM'),(52681423,'created_by','JOSM'),(52681425,'created_by','JOSM'),(52681427,'created_by','JOSM'),(52681429,'created_by','JOSM'),(52681431,'created_by','JOSM'),(52681432,'created_by','JOSM'),(52681434,'created_by','JOSM'),(52681439,'created_by','JOSM'),(52681462,'created_by','JOSM'),(52681464,'created_by','JOSM'),(52681465,'created_by','JOSM'),(52681466,'created_by','JOSM'),(52681468,'created_by','JOSM'),(52681471,'created_by','JOSM'),(52681474,'created_by','JOSM'),(52681476,'created_by','JOSM'),(52681478,'created_by','JOSM'),(52681481,'created_by','JOSM'),(52681484,'created_by','JOSM'),(52681487,'created_by','JOSM'),(52681492,'created_by','JOSM'),(52681493,'created_by','JOSM'),(52681496,'created_by','JOSM'),(52681499,'created_by','JOSM'),(52681500,'created_by','JOSM'),(52681503,'created_by','JOSM'),(52681508,'created_by','JOSM'),(52681510,'created_by','JOSM'),(52681511,'created_by','JOSM'),(52681514,'created_by','JOSM'),(52681516,'created_by','JOSM'),(52681518,'created_by','JOSM'),(52681521,'created_by','JOSM'),(52681526,'created_by','JOSM'),(52681528,'created_by','JOSM'),(52681531,'created_by','JOSM'),(52681533,'created_by','JOSM'),(52681535,'created_by','JOSM'),(52681537,'created_by','JOSM'),(52681539,'created_by','JOSM'),(52681541,'created_by','JOSM'),(52681544,'created_by','JOSM'),(52681547,'created_by','JOSM'),(52681551,'created_by','JOSM'),(52681553,'created_by','JOSM'),(52681557,'created_by','JOSM'),(52681568,'created_by','JOSM'),(52681571,'created_by','JOSM'),(52681576,'created_by','JOSM'),(52681578,'created_by','JOSM'),(52681582,'created_by','JOSM'),(52681586,'created_by','JOSM'),(52681589,'created_by','JOSM'),(52681593,'created_by','JOSM'),(52681596,'created_by','JOSM'),(52681598,'created_by','JOSM'),(52681600,'created_by','JOSM'),(52681603,'created_by','JOSM'),(52681605,'created_by','JOSM'),(52681608,'created_by','JOSM'),(52681610,'created_by','JOSM'),(52681613,'created_by','JOSM'),(52681615,'created_by','JOSM'),(52681619,'created_by','JOSM'),(52681648,'created_by','JOSM'),(52681683,'created_by','JOSM'),(52681949,'created_by','JOSM'),(52682039,'created_by','JOSM'),(52682044,'created_by','JOSM'),(52682047,'created_by','JOSM'),(52682050,'created_by','JOSM'),(52682055,'created_by','JOSM'),(52682060,'created_by','JOSM'),(52682065,'created_by','JOSM'),(52682068,'created_by','JOSM'),(52682070,'created_by','JOSM'),(52682072,'created_by','JOSM'),(52682091,'created_by','JOSM'),(52682096,'created_by','JOSM'),(52682101,'created_by','JOSM'),(52682123,'created_by','JOSM'),(52682126,'created_by','JOSM'),(52682128,'created_by','JOSM'),(52682132,'created_by','JOSM'),(52682135,'created_by','JOSM'),(52682140,'created_by','JOSM'),(52682143,'created_by','JOSM'),(52682146,'created_by','JOSM'),(52682150,'created_by','JOSM'),(52682152,'created_by','JOSM'),(52682156,'created_by','JOSM'),(52682160,'created_by','JOSM'),(52682164,'created_by','JOSM'),(52682168,'created_by','JOSM'),(52682170,'created_by','JOSM'),(52682174,'created_by','JOSM'),(52682178,'created_by','JOSM'),(52682180,'created_by','JOSM'),(52682184,'created_by','JOSM'),(52682186,'created_by','JOSM'),(52682190,'created_by','JOSM'),(52682195,'created_by','JOSM'),(52682197,'created_by','JOSM'),(52682200,'created_by','JOSM'),(52682202,'created_by','JOSM'),(52682204,'created_by','JOSM'),(52682207,'created_by','JOSM'),(52682210,'created_by','JOSM'),(52682212,'created_by','JOSM'),(52682215,'created_by','JOSM'),(52682216,'created_by','JOSM'),(52682221,'created_by','JOSM'),(52682224,'created_by','JOSM'),(52682227,'created_by','JOSM'),(52682231,'created_by','JOSM'),(52682235,'created_by','JOSM'),(52682238,'created_by','JOSM'),(52682240,'created_by','JOSM'),(52682243,'created_by','JOSM'),(52682244,'created_by','JOSM'),(52682247,'created_by','JOSM'),(52682250,'created_by','JOSM'),(52682253,'created_by','JOSM'),(52682255,'created_by','JOSM'),(52682257,'created_by','JOSM'),(52682259,'created_by','JOSM'),(52682262,'created_by','JOSM'),(52682265,'created_by','JOSM'),(52682270,'created_by','JOSM'),(52682272,'created_by','JOSM'),(52682274,'created_by','JOSM'),(52682277,'created_by','JOSM'),(52682524,'created_by','JOSM'),(52682546,'created_by','JOSM'),(52682558,'created_by','JOSM'),(52682617,'created_by','JOSM'),(52682663,'created_by','JOSM'),(52682673,'created_by','JOSM'),(52685135,'created_by','JOSM'),(52685138,'created_by','JOSM'),(52685142,'created_by','JOSM'),(52685145,'created_by','JOSM'),(52685147,'created_by','JOSM'),(52685151,'created_by','JOSM'),(52685154,'created_by','JOSM'),(52685157,'created_by','JOSM'),(52685160,'created_by','JOSM'),(52685162,'created_by','JOSM'),(52685166,'created_by','JOSM'),(52685169,'created_by','JOSM'),(52685171,'created_by','JOSM'),(52685184,'created_by','JOSM'),(52685190,'created_by','JOSM'),(52685195,'created_by','JOSM'),(52685199,'created_by','JOSM'),(52685202,'created_by','JOSM'),(52685204,'created_by','JOSM'),(52685207,'created_by','JOSM'),(52685211,'created_by','JOSM'),(52685217,'created_by','JOSM'),(52685220,'created_by','JOSM'),(52685226,'created_by','JOSM'),(52685229,'created_by','JOSM'),(52685232,'created_by','JOSM'),(52685236,'created_by','JOSM'),(52685238,'created_by','JOSM'),(52685243,'created_by','JOSM'),(52685247,'created_by','JOSM'),(52685258,'created_by','JOSM'),(52685262,'created_by','JOSM'),(52685269,'created_by','JOSM'),(52685275,'created_by','JOSM'),(52685277,'created_by','JOSM'),(52685282,'created_by','JOSM'),(52685296,'created_by','JOSM'),(52685299,'created_by','JOSM'),(52685307,'created_by','JOSM'),(52685313,'created_by','JOSM'),(52685696,'created_by','JOSM'),(52685701,'created_by','JOSM'),(52685707,'created_by','JOSM'),(52685710,'created_by','JOSM'),(52685714,'created_by','JOSM'),(52685717,'created_by','JOSM'),(52685723,'created_by','JOSM'),(52685727,'created_by','JOSM'),(52685732,'created_by','JOSM'),(52685739,'created_by','JOSM'),(52685761,'created_by','JOSM'),(52685764,'created_by','JOSM'),(52685771,'created_by','JOSM'),(52685779,'created_by','JOSM'),(52685789,'created_by','JOSM'),(52685802,'created_by','JOSM');
INSERT INTO `current_node_tags` VALUES (52685814,'created_by','JOSM'),(52685832,'created_by','JOSM'),(52685840,'created_by','JOSM'),(52685847,'created_by','JOSM'),(52685851,'created_by','JOSM'),(52685859,'created_by','JOSM'),(52685862,'created_by','JOSM'),(52685869,'created_by','JOSM'),(52685873,'created_by','JOSM'),(52685877,'created_by','JOSM'),(52685881,'created_by','JOSM'),(52685886,'created_by','JOSM'),(52685894,'created_by','JOSM'),(52685905,'created_by','JOSM'),(52685911,'created_by','JOSM'),(52685917,'created_by','JOSM'),(52685920,'created_by','JOSM'),(52685923,'created_by','JOSM'),(52685926,'created_by','JOSM'),(52685929,'created_by','JOSM'),(52685931,'created_by','JOSM'),(52685934,'created_by','JOSM'),(52685939,'created_by','JOSM'),(52685943,'created_by','JOSM'),(52685946,'created_by','JOSM'),(52685950,'created_by','JOSM'),(52685966,'created_by','JOSM'),(52685971,'created_by','JOSM'),(52685975,'created_by','JOSM'),(52685978,'created_by','JOSM'),(52685980,'created_by','JOSM'),(52685982,'created_by','JOSM'),(52685986,'created_by','JOSM'),(52685990,'created_by','JOSM'),(52685993,'created_by','JOSM'),(52685996,'created_by','JOSM'),(52686002,'created_by','JOSM'),(52686474,'created_by','JOSM'),(52686478,'created_by','JOSM'),(52686480,'created_by','JOSM'),(52686486,'created_by','JOSM'),(52686490,'created_by','JOSM'),(52686495,'created_by','JOSM'),(52686501,'created_by','JOSM'),(52686505,'created_by','JOSM'),(52686510,'created_by','JOSM'),(52686511,'created_by','JOSM'),(52686514,'created_by','JOSM'),(52686517,'created_by','JOSM'),(52686518,'created_by','JOSM'),(52686521,'created_by','JOSM'),(52686524,'created_by','JOSM'),(52686527,'created_by','JOSM'),(52686533,'created_by','JOSM'),(52686537,'created_by','JOSM'),(52686542,'created_by','JOSM'),(52686544,'created_by','JOSM'),(52686547,'created_by','JOSM'),(52686551,'created_by','JOSM'),(52686555,'created_by','JOSM'),(52686561,'created_by','JOSM'),(52686569,'created_by','JOSM'),(52686574,'created_by','JOSM'),(52686579,'created_by','JOSM'),(52686586,'created_by','JOSM'),(52686593,'created_by','JOSM'),(52686598,'created_by','JOSM'),(52686601,'created_by','JOSM'),(52686604,'created_by','JOSM'),(52686607,'created_by','JOSM'),(52686610,'created_by','JOSM'),(52686622,'created_by','JOSM'),(52686626,'created_by','JOSM'),(52686632,'created_by','JOSM'),(52686637,'created_by','JOSM'),(52686639,'created_by','JOSM'),(52686644,'created_by','JOSM'),(52686648,'created_by','JOSM'),(52686651,'created_by','JOSM'),(52686654,'created_by','JOSM'),(52686655,'created_by','JOSM'),(52686659,'created_by','JOSM'),(52686660,'created_by','JOSM'),(52686663,'created_by','JOSM'),(52686666,'created_by','JOSM'),(52686668,'created_by','JOSM'),(52686674,'created_by','JOSM'),(52686680,'created_by','JOSM'),(52686682,'created_by','JOSM'),(52686683,'created_by','JOSM'),(52686687,'created_by','JOSM'),(52688384,'created_by','JOSM'),(52688387,'created_by','JOSM'),(52688389,'created_by','JOSM'),(52688391,'created_by','JOSM'),(52688393,'created_by','JOSM'),(52688398,'created_by','JOSM'),(52688401,'created_by','JOSM'),(52688431,'created_by','JOSM'),(52688438,'created_by','JOSM'),(52688454,'created_by','JOSM'),(52688455,'created_by','JOSM'),(52688458,'created_by','JOSM'),(52688531,'created_by','JOSM'),(52688570,'created_by','JOSM'),(52688574,'created_by','JOSM'),(52688576,'created_by','JOSM'),(52688577,'created_by','JOSM'),(52688580,'created_by','JOSM'),(52688582,'created_by','JOSM'),(52688584,'created_by','JOSM'),(52688608,'created_by','JOSM'),(52688609,'created_by','JOSM'),(52688628,'created_by','JOSM'),(52688632,'created_by','JOSM'),(52688633,'created_by','JOSM'),(52688637,'created_by','JOSM'),(52688639,'created_by','JOSM'),(52688642,'created_by','JOSM'),(52688644,'created_by','JOSM'),(52688646,'created_by','JOSM'),(52688648,'created_by','JOSM'),(52688652,'created_by','JOSM'),(52688654,'created_by','JOSM'),(52688655,'created_by','JOSM'),(52688662,'created_by','JOSM'),(52688663,'created_by','JOSM'),(52688667,'created_by','JOSM'),(52688669,'created_by','JOSM'),(52688876,'created_by','JOSM'),(52688936,'created_by','JOSM'),(52688938,'created_by','JOSM'),(52688942,'created_by','JOSM'),(52688945,'created_by','JOSM'),(52688948,'created_by','JOSM'),(52688951,'created_by','JOSM'),(52688953,'created_by','JOSM'),(52688956,'created_by','JOSM'),(52688958,'created_by','JOSM'),(52688962,'created_by','JOSM'),(52688963,'created_by','JOSM'),(52688967,'created_by','JOSM'),(52688969,'created_by','JOSM'),(52688973,'created_by','JOSM'),(52688975,'created_by','JOSM'),(52688978,'created_by','JOSM'),(52688981,'created_by','JOSM'),(52689010,'created_by','JOSM'),(52689011,'created_by','JOSM'),(52689013,'created_by','JOSM'),(52689016,'created_by','JOSM'),(52689017,'created_by','JOSM'),(52689019,'created_by','JOSM'),(52689020,'created_by','JOSM'),(52689024,'created_by','JOSM'),(52689026,'created_by','JOSM'),(52689028,'created_by','JOSM'),(52689032,'created_by','JOSM'),(52689035,'created_by','JOSM'),(52689036,'created_by','JOSM'),(52689039,'created_by','JOSM'),(52689041,'created_by','JOSM'),(52689048,'created_by','JOSM'),(52689081,'created_by','JOSM'),(52689083,'created_by','JOSM'),(52689086,'created_by','JOSM'),(52689090,'created_by','JOSM'),(52689092,'created_by','JOSM'),(52689094,'created_by','JOSM'),(52689095,'created_by','JOSM'),(52689097,'created_by','JOSM'),(52689102,'created_by','JOSM'),(52689104,'created_by','JOSM'),(52689106,'created_by','JOSM'),(52689107,'created_by','JOSM'),(52689110,'created_by','JOSM'),(52689111,'created_by','JOSM'),(52689114,'created_by','JOSM'),(52689115,'created_by','JOSM'),(52689118,'created_by','JOSM'),(52689120,'created_by','JOSM'),(52689141,'created_by','JOSM'),(52689142,'created_by','JOSM'),(52689145,'created_by','JOSM'),(52689148,'created_by','JOSM'),(52689150,'created_by','JOSM'),(52689154,'created_by','JOSM'),(52689156,'created_by','JOSM'),(52689157,'created_by','JOSM'),(52689160,'created_by','JOSM'),(52689162,'created_by','JOSM'),(52689165,'created_by','JOSM'),(52689167,'created_by','JOSM'),(52689173,'created_by','JOSM'),(52689178,'created_by','JOSM'),(52689180,'created_by','JOSM'),(52689184,'created_by','JOSM'),(52689187,'created_by','JOSM'),(52689189,'created_by','JOSM'),(52689194,'created_by','JOSM'),(52689197,'created_by','JOSM'),(52689201,'created_by','JOSM'),(52689204,'created_by','JOSM'),(52689208,'created_by','JOSM'),(52689210,'created_by','JOSM'),(52689214,'created_by','JOSM'),(52689217,'created_by','JOSM'),(52689218,'created_by','JOSM'),(52689230,'created_by','JOSM'),(52689232,'created_by','JOSM'),(52689236,'created_by','JOSM'),(52689239,'created_by','JOSM'),(52689242,'created_by','JOSM'),(52689243,'created_by','JOSM'),(52689245,'created_by','JOSM'),(52689248,'created_by','JOSM'),(52689249,'created_by','JOSM'),(52689251,'created_by','JOSM'),(52689253,'created_by','JOSM'),(52689255,'created_by','JOSM'),(52689257,'created_by','JOSM'),(52689259,'created_by','JOSM'),(52689262,'created_by','JOSM'),(52689263,'created_by','JOSM'),(52689265,'created_by','JOSM'),(52689267,'created_by','JOSM'),(52689270,'created_by','JOSM'),(52689273,'created_by','JOSM'),(52689275,'created_by','JOSM'),(52689278,'created_by','JOSM'),(52689279,'created_by','JOSM'),(52689280,'created_by','JOSM'),(52689282,'created_by','JOSM'),(52689285,'created_by','JOSM'),(52689288,'created_by','JOSM'),(52689290,'created_by','JOSM'),(52689292,'created_by','JOSM'),(52689294,'created_by','JOSM'),(52689295,'created_by','JOSM'),(52689303,'created_by','JOSM'),(52689304,'created_by','JOSM'),(52689308,'created_by','JOSM'),(52689311,'created_by','JOSM'),(52689316,'created_by','JOSM'),(52689319,'created_by','JOSM'),(52689321,'created_by','JOSM'),(52689323,'created_by','JOSM'),(52689326,'created_by','JOSM'),(52689328,'created_by','JOSM'),(52689330,'created_by','JOSM'),(52689333,'created_by','JOSM'),(52689336,'created_by','JOSM'),(52689338,'created_by','JOSM'),(52689340,'created_by','JOSM'),(52689343,'created_by','JOSM'),(52689345,'created_by','JOSM'),(52689348,'created_by','JOSM'),(52689350,'created_by','JOSM'),(52689351,'created_by','JOSM'),(52689353,'created_by','JOSM'),(52689355,'created_by','JOSM'),(52689358,'created_by','JOSM'),(52689359,'created_by','JOSM'),(52689361,'created_by','JOSM'),(52689363,'created_by','JOSM'),(52689365,'created_by','JOSM'),(52689366,'created_by','JOSM'),(52689367,'created_by','JOSM'),(52689371,'created_by','JOSM'),(52689372,'created_by','JOSM'),(52689375,'created_by','JOSM'),(52689377,'created_by','JOSM'),(52689379,'created_by','JOSM'),(52689382,'created_by','JOSM'),(52689385,'created_by','JOSM'),(52689387,'created_by','JOSM'),(52689390,'created_by','JOSM'),(52689392,'created_by','JOSM'),(52689394,'created_by','JOSM'),(52689396,'created_by','JOSM'),(52689398,'created_by','JOSM'),(52689402,'created_by','JOSM'),(52689405,'created_by','JOSM'),(52689406,'created_by','JOSM'),(52689409,'created_by','JOSM'),(52689410,'created_by','JOSM'),(52689412,'created_by','JOSM'),(52689414,'created_by','JOSM'),(52689416,'created_by','JOSM'),(52689419,'created_by','JOSM'),(52689420,'created_by','JOSM'),(52689423,'created_by','JOSM'),(52689425,'created_by','JOSM'),(52689427,'created_by','JOSM'),(52689429,'created_by','JOSM'),(52689432,'created_by','JOSM'),(52689433,'created_by','JOSM'),(52689436,'created_by','JOSM'),(52689437,'created_by','JOSM'),(52689440,'created_by','JOSM'),(52689443,'created_by','JOSM'),(52689445,'created_by','JOSM'),(52689447,'created_by','JOSM'),(52689450,'created_by','JOSM'),(52689451,'created_by','JOSM'),(52689452,'created_by','JOSM'),(52689455,'created_by','JOSM'),(52689456,'created_by','JOSM'),(52689459,'created_by','JOSM'),(52689461,'created_by','JOSM'),(52689464,'created_by','JOSM'),(52689484,'created_by','JOSM'),(52689486,'created_by','JOSM'),(52689488,'created_by','JOSM'),(52689491,'created_by','JOSM'),(52689493,'created_by','JOSM'),(52689494,'created_by','JOSM'),(52689496,'created_by','JOSM'),(52689497,'created_by','JOSM'),(52689499,'created_by','JOSM'),(52689501,'created_by','JOSM'),(52689503,'created_by','JOSM'),(52689505,'created_by','JOSM'),(52689508,'created_by','JOSM'),(52689513,'created_by','JOSM'),(52689516,'created_by','JOSM'),(52689518,'created_by','JOSM'),(52689522,'created_by','JOSM'),(52689524,'created_by','JOSM'),(52689527,'created_by','JOSM'),(52689528,'created_by','JOSM'),(52689532,'created_by','JOSM'),(52689534,'created_by','JOSM'),(52689537,'created_by','JOSM'),(52689538,'created_by','JOSM'),(52689540,'created_by','JOSM'),(52689545,'created_by','JOSM'),(52689549,'created_by','JOSM'),(52689552,'created_by','JOSM'),(52689553,'created_by','JOSM'),(52689556,'created_by','JOSM'),(52689558,'created_by','JOSM'),(52689560,'created_by','JOSM'),(52689562,'created_by','JOSM'),(52689565,'created_by','JOSM'),(52689567,'created_by','JOSM'),(52689570,'created_by','JOSM'),(52689572,'created_by','JOSM'),(52689573,'created_by','JOSM'),(52689576,'created_by','JOSM'),(52689579,'created_by','JOSM'),(52689580,'created_by','JOSM'),(52689583,'created_by','JOSM'),(52689584,'created_by','JOSM'),(52689585,'created_by','JOSM'),(52689586,'created_by','JOSM'),(52689589,'created_by','JOSM'),(52689591,'created_by','JOSM'),(52689593,'created_by','JOSM'),(52689594,'created_by','JOSM'),(52689596,'created_by','JOSM'),(52689600,'created_by','JOSM'),(52689603,'created_by','JOSM'),(52689604,'created_by','JOSM'),(52689607,'created_by','JOSM'),(52689608,'created_by','JOSM'),(52689609,'created_by','JOSM'),(52689610,'created_by','JOSM'),(52689612,'created_by','JOSM'),(52689613,'created_by','JOSM'),(52689615,'created_by','JOSM'),(52689617,'created_by','JOSM'),(52689618,'created_by','JOSM'),(52689619,'created_by','JOSM'),(52689621,'created_by','JOSM'),(52689624,'created_by','JOSM'),(52689627,'created_by','JOSM'),(52689629,'created_by','JOSM'),(52689631,'created_by','JOSM'),(52689635,'created_by','JOSM'),(52689639,'created_by','JOSM'),(52689643,'created_by','JOSM'),(52689647,'created_by','JOSM'),(52689650,'created_by','JOSM'),(52689653,'created_by','JOSM'),(52689656,'created_by','JOSM'),(52689659,'created_by','JOSM'),(52689661,'created_by','JOSM'),(52689663,'created_by','JOSM'),(52689665,'created_by','JOSM'),(52689666,'created_by','JOSM'),(52689670,'created_by','JOSM'),(52689673,'created_by','JOSM'),(52689676,'created_by','JOSM'),(52689679,'created_by','JOSM'),(52689681,'created_by','JOSM'),(52689684,'created_by','JOSM'),(52689687,'created_by','JOSM'),(52689689,'created_by','JOSM'),(52689692,'created_by','JOSM'),(52689696,'created_by','JOSM'),(52689699,'created_by','JOSM'),(52689701,'created_by','JOSM'),(52689705,'created_by','JOSM'),(52689707,'created_by','JOSM'),(52689709,'created_by','JOSM'),(52689713,'created_by','JOSM'),(52689714,'created_by','JOSM'),(52689718,'created_by','JOSM'),(52689720,'created_by','JOSM'),(52689723,'created_by','JOSM'),(52689724,'created_by','JOSM'),(52689728,'created_by','JOSM'),(52689731,'created_by','JOSM'),(52689733,'created_by','JOSM'),(52689737,'created_by','JOSM'),(52689739,'created_by','JOSM'),(52689742,'created_by','JOSM'),(52689743,'created_by','JOSM'),(52689747,'created_by','JOSM'),(52689748,'created_by','JOSM'),(52689751,'created_by','JOSM'),(52689755,'created_by','JOSM'),(52733171,'created_by','JOSM'),(52733173,'created_by','JOSM'),(52733177,'created_by','JOSM'),(52733181,'created_by','JOSM'),(52733186,'created_by','JOSM'),(52733193,'created_by','JOSM'),(52733201,'created_by','JOSM'),(52733204,'created_by','JOSM'),(52733206,'created_by','JOSM'),(52733209,'created_by','JOSM'),(52733212,'created_by','JOSM'),(52733215,'created_by','JOSM'),(52733218,'created_by','JOSM'),(52733223,'created_by','JOSM'),(52743859,'created_by','JOSM'),(52743862,'created_by','JOSM'),(52743866,'created_by','JOSM'),(52743871,'created_by','JOSM'),(52743874,'created_by','JOSM'),(52743875,'created_by','JOSM'),(52743878,'created_by','JOSM'),(52743880,'created_by','JOSM'),(52743882,'created_by','JOSM'),(52743884,'created_by','JOSM'),(52743887,'created_by','JOSM'),(52743889,'created_by','JOSM'),(52743892,'created_by','JOSM'),(52743895,'created_by','JOSM'),(52743896,'created_by','JOSM'),(52743899,'created_by','JOSM'),(52743900,'created_by','JOSM'),(52743901,'created_by','JOSM'),(52743902,'created_by','JOSM'),(52743904,'created_by','JOSM'),(52743907,'created_by','JOSM'),(52743909,'created_by','JOSM'),(52743910,'created_by','JOSM'),(52743913,'created_by','JOSM'),(52743916,'created_by','JOSM'),(52743919,'created_by','JOSM'),(52743921,'created_by','JOSM'),(52743924,'created_by','JOSM'),(52743925,'created_by','JOSM'),(52743927,'created_by','JOSM'),(52743928,'created_by','JOSM'),(52743930,'created_by','JOSM'),(52743933,'created_by','JOSM'),(52743936,'created_by','JOSM'),(52743937,'created_by','JOSM'),(52743940,'created_by','JOSM'),(52743941,'created_by','JOSM'),(52743943,'created_by','JOSM'),(52743946,'created_by','JOSM'),(52743947,'created_by','JOSM'),(52743950,'created_by','JOSM'),(52743951,'created_by','JOSM'),(52743954,'created_by','JOSM'),(52743955,'created_by','JOSM'),(52743958,'created_by','JOSM'),(52743959,'created_by','JOSM'),(52743961,'created_by','JOSM'),(52743964,'created_by','JOSM'),(52743966,'created_by','JOSM'),(52743967,'created_by','JOSM'),(52743969,'created_by','JOSM'),(52743971,'created_by','JOSM'),(52743972,'created_by','JOSM'),(52743973,'created_by','JOSM'),(52743976,'created_by','JOSM'),(52743980,'created_by','JOSM'),(52743981,'created_by','JOSM'),(52743984,'created_by','JOSM'),(52743986,'created_by','JOSM'),(52743987,'created_by','JOSM'),(52743988,'created_by','JOSM'),(52743991,'created_by','JOSM'),(52743992,'created_by','JOSM'),(52743995,'created_by','JOSM'),(52743997,'created_by','JOSM'),(52744001,'created_by','JOSM'),(52744002,'created_by','JOSM'),(52744005,'created_by','JOSM'),(52744007,'created_by','JOSM'),(52744009,'created_by','JOSM'),(52744012,'created_by','JOSM'),(52744014,'created_by','JOSM'),(52744016,'created_by','JOSM'),(52744019,'created_by','JOSM'),(52744021,'created_by','JOSM'),(52744022,'created_by','JOSM'),(52744025,'created_by','JOSM'),(52744028,'created_by','JOSM'),(52744030,'created_by','JOSM'),(52744032,'created_by','JOSM'),(52744035,'created_by','JOSM'),(52744036,'created_by','JOSM'),(52744038,'created_by','JOSM'),(52744042,'created_by','JOSM'),(52744043,'created_by','JOSM'),(52744046,'created_by','JOSM'),(52744049,'created_by','JOSM'),(52744050,'created_by','JOSM'),(52744052,'created_by','JOSM'),(52744053,'created_by','JOSM'),(52744054,'created_by','JOSM'),(52744056,'created_by','JOSM'),(52744057,'created_by','JOSM'),(52744059,'created_by','JOSM'),(52744062,'created_by','JOSM'),(52744064,'created_by','JOSM'),(52744066,'created_by','JOSM'),(52744067,'created_by','JOSM'),(52744070,'created_by','JOSM'),(52744072,'created_by','JOSM'),(52744073,'created_by','JOSM'),(52744074,'created_by','JOSM'),(52744075,'created_by','JOSM'),(52744078,'created_by','JOSM'),(52744081,'created_by','JOSM'),(52744082,'created_by','JOSM'),(52744084,'created_by','JOSM'),(52744086,'created_by','JOSM'),(52744087,'created_by','JOSM'),(52744089,'created_by','JOSM'),(52744091,'created_by','JOSM'),(52744093,'created_by','JOSM'),(52744094,'created_by','JOSM'),(52744096,'created_by','JOSM'),(52744097,'created_by','JOSM'),(52744099,'created_by','JOSM'),(52744100,'created_by','JOSM'),(52744101,'created_by','JOSM'),(52744102,'created_by','JOSM'),(52744104,'created_by','JOSM'),(52744106,'created_by','JOSM'),(52744108,'created_by','JOSM'),(52744110,'created_by','JOSM'),(52744111,'created_by','JOSM'),(52744114,'created_by','JOSM'),(52744116,'created_by','JOSM'),(52744118,'created_by','JOSM'),(52744120,'created_by','JOSM'),(52744122,'created_by','JOSM'),(52744124,'created_by','JOSM'),(52744126,'created_by','JOSM'),(52744128,'created_by','JOSM'),(52744130,'created_by','JOSM'),(52744133,'created_by','JOSM'),(52744134,'created_by','JOSM'),(52744136,'created_by','JOSM'),(52744138,'created_by','JOSM'),(52744141,'created_by','JOSM'),(52744144,'created_by','JOSM'),(52744147,'created_by','JOSM'),(52744149,'created_by','JOSM'),(52744152,'created_by','JOSM'),(52744155,'created_by','JOSM'),(52744158,'created_by','JOSM'),(52744159,'created_by','JOSM'),(52744161,'created_by','JOSM'),(52744163,'created_by','JOSM'),(52744165,'created_by','JOSM'),(52744166,'created_by','JOSM'),(52744172,'created_by','JOSM'),(52744174,'created_by','JOSM'),(52744177,'created_by','JOSM'),(52744180,'created_by','JOSM'),(52744181,'created_by','JOSM'),(52744184,'created_by','JOSM'),(52744187,'created_by','JOSM'),(52744189,'created_by','JOSM'),(52744190,'created_by','JOSM'),(52744193,'created_by','JOSM'),(52744196,'created_by','JOSM'),(52744198,'created_by','JOSM'),(52744201,'created_by','JOSM'),(52744202,'created_by','JOSM'),(52744205,'created_by','JOSM'),(52744206,'created_by','JOSM'),(52744209,'created_by','JOSM'),(52744212,'created_by','JOSM'),(52744213,'created_by','JOSM'),(52744214,'created_by','JOSM'),(52744218,'created_by','JOSM'),(52744219,'created_by','JOSM'),(52744222,'created_by','JOSM'),(52744223,'created_by','JOSM'),(52744227,'created_by','JOSM'),(52744228,'created_by','JOSM'),(52744231,'created_by','JOSM'),(52744232,'created_by','JOSM'),(52744236,'created_by','JOSM'),(52744237,'created_by','JOSM'),(52744238,'created_by','JOSM'),(52744240,'created_by','JOSM'),(52744241,'created_by','JOSM'),(52744245,'created_by','JOSM'),(52744246,'created_by','JOSM'),(52744249,'created_by','JOSM'),(52744250,'created_by','JOSM'),(52744253,'created_by','JOSM'),(52744254,'created_by','JOSM'),(52744257,'created_by','JOSM'),(52744259,'created_by','JOSM'),(52744260,'created_by','JOSM'),(52744262,'created_by','JOSM'),(52744264,'created_by','JOSM'),(52744265,'created_by','JOSM'),(52744268,'created_by','JOSM'),(52744270,'created_by','JOSM'),(52744272,'created_by','JOSM'),(52744274,'created_by','JOSM'),(52744277,'created_by','JOSM'),(52744279,'created_by','JOSM'),(52744281,'created_by','JOSM'),(52744284,'created_by','JOSM'),(52744286,'created_by','JOSM'),(52744289,'created_by','JOSM'),(52744292,'created_by','JOSM'),(52744294,'created_by','JOSM'),(52744296,'created_by','JOSM'),(52744298,'created_by','JOSM'),(52744301,'created_by','JOSM'),(52744303,'created_by','JOSM'),(52744306,'created_by','JOSM'),(52744308,'created_by','JOSM'),(52744309,'created_by','JOSM'),(52744312,'created_by','JOSM'),(52744313,'created_by','JOSM'),(52744315,'created_by','JOSM'),(52744318,'created_by','JOSM'),(52744320,'created_by','JOSM'),(52744323,'created_by','JOSM'),(52744326,'created_by','JOSM'),(52744329,'created_by','JOSM'),(52744330,'created_by','JOSM'),(52744333,'created_by','JOSM'),(52744334,'created_by','JOSM'),(52744337,'created_by','JOSM'),(52744339,'created_by','JOSM'),(52744342,'created_by','JOSM'),(52744344,'created_by','JOSM'),(52744346,'created_by','JOSM'),(52744349,'created_by','JOSM'),(52744350,'created_by','JOSM'),(52744352,'created_by','JOSM'),(52744356,'created_by','JOSM'),(52744359,'created_by','JOSM'),(52744360,'created_by','JOSM'),(52744364,'created_by','JOSM'),(52744365,'created_by','JOSM'),(52744368,'created_by','JOSM'),(52744370,'created_by','JOSM'),(52744372,'created_by','JOSM'),(52744375,'created_by','JOSM'),(52744378,'created_by','JOSM'),(52744379,'created_by','JOSM'),(52744383,'created_by','JOSM'),(52744385,'created_by','JOSM'),(52744387,'created_by','JOSM'),(52744390,'created_by','JOSM'),(52744392,'created_by','JOSM'),(52744394,'created_by','JOSM'),(52744396,'created_by','JOSM'),(52744399,'created_by','JOSM'),(52744400,'created_by','JOSM'),(52744402,'created_by','JOSM'),(52744405,'created_by','JOSM'),(52744409,'created_by','JOSM'),(52744411,'created_by','JOSM'),(52744413,'created_by','JOSM'),(52744416,'created_by','JOSM'),(52744418,'created_by','JOSM'),(52744420,'created_by','JOSM'),(52744423,'created_by','JOSM'),(52744426,'created_by','JOSM'),(52744429,'created_by','JOSM'),(52744432,'created_by','JOSM'),(52744434,'created_by','JOSM'),(52744437,'created_by','JOSM'),(52744439,'created_by','JOSM'),(52744440,'created_by','JOSM'),(52744443,'created_by','JOSM'),(52744446,'created_by','JOSM'),(52744447,'created_by','JOSM'),(52744450,'created_by','JOSM'),(52744452,'created_by','JOSM'),(52744455,'created_by','JOSM'),(52744457,'created_by','JOSM'),(52744460,'created_by','JOSM'),(52744462,'created_by','JOSM'),(52744464,'created_by','JOSM'),(52744468,'created_by','JOSM'),(52744471,'created_by','JOSM'),(52744473,'created_by','JOSM'),(52744475,'created_by','JOSM'),(52747815,'created_by','JOSM'),(52747820,'created_by','JOSM'),(52747826,'created_by','JOSM'),(52747832,'created_by','JOSM'),(52747838,'created_by','JOSM'),(52747841,'created_by','JOSM'),(52747846,'created_by','JOSM'),(52747849,'created_by','JOSM'),(52747852,'created_by','JOSM'),(52747855,'created_by','JOSM'),(52747857,'created_by','JOSM'),(52747861,'created_by','JOSM'),(52747863,'created_by','JOSM'),(52747865,'created_by','JOSM'),(52747867,'created_by','JOSM'),(52747869,'created_by','JOSM'),(52747872,'created_by','JOSM'),(52747876,'created_by','JOSM'),(52747878,'created_by','JOSM'),(52747881,'created_by','JOSM'),(52747884,'created_by','JOSM'),(52747885,'created_by','JOSM'),(52747888,'created_by','JOSM'),(52747890,'created_by','JOSM'),(52747893,'created_by','JOSM'),(52747898,'created_by','JOSM'),(52747901,'created_by','JOSM'),(52748785,'created_by','JOSM'),(52748790,'created_by','JOSM'),(52748831,'created_by','JOSM'),(52748833,'created_by','JOSM'),(52748835,'created_by','JOSM'),(52748837,'created_by','JOSM'),(52749087,'created_by','JOSM'),(52749143,'created_by','JOSM'),(52749145,'created_by','JOSM'),(52749150,'created_by','JOSM'),(52749155,'created_by','JOSM'),(52749158,'created_by','JOSM'),(52749159,'created_by','JOSM'),(52749162,'created_by','JOSM'),(52749165,'created_by','JOSM'),(52749169,'created_by','JOSM'),(52749171,'created_by','JOSM'),(52749174,'created_by','JOSM'),(52749175,'created_by','JOSM'),(52749183,'created_by','JOSM'),(52749184,'created_by','JOSM'),(52749185,'created_by','JOSM'),(52749189,'created_by','JOSM'),(52749191,'created_by','JOSM'),(52749208,'created_by','JOSM'),(52749211,'created_by','JOSM'),(52749214,'created_by','JOSM'),(52749218,'created_by','JOSM'),(52749220,'created_by','JOSM'),(52749224,'created_by','JOSM'),(52749225,'created_by','JOSM'),(52749228,'created_by','JOSM'),(52749231,'created_by','JOSM'),(52749233,'created_by','JOSM'),(52749238,'created_by','JOSM'),(52749240,'created_by','JOSM'),(52749243,'created_by','JOSM'),(52749244,'created_by','JOSM'),(52749247,'created_by','JOSM'),(52749251,'created_by','JOSM'),(52749255,'created_by','JOSM'),(52749256,'created_by','JOSM'),(52749259,'created_by','JOSM'),(52749261,'created_by','JOSM'),(52749263,'created_by','JOSM'),(52749266,'created_by','JOSM'),(52749268,'created_by','JOSM'),(52749271,'created_by','JOSM'),(52749275,'created_by','JOSM'),(52749276,'created_by','JOSM'),(52749280,'created_by','JOSM'),(52749282,'created_by','JOSM'),(52749284,'created_by','JOSM'),(52749285,'created_by','JOSM'),(52749288,'created_by','JOSM'),(52749289,'created_by','JOSM'),(52749309,'created_by','JOSM'),(52749310,'created_by','JOSM'),(52749312,'created_by','JOSM'),(52749314,'created_by','JOSM'),(52749316,'created_by','JOSM'),(52749321,'created_by','JOSM'),(52749324,'created_by','JOSM'),(52749326,'created_by','JOSM'),(52749328,'created_by','JOSM'),(52749331,'created_by','JOSM'),(52749334,'created_by','JOSM'),(52749340,'created_by','JOSM'),(52749341,'created_by','JOSM'),(52749343,'created_by','JOSM'),(52749347,'created_by','JOSM'),(52749349,'created_by','JOSM'),(52749352,'created_by','JOSM'),(52749354,'created_by','JOSM'),(52749357,'created_by','JOSM'),(52749359,'created_by','JOSM'),(52749363,'created_by','JOSM'),(52749366,'created_by','JOSM'),(52749368,'created_by','JOSM'),(52749371,'created_by','JOSM'),(52749376,'created_by','JOSM'),(52749379,'created_by','JOSM'),(52749381,'created_by','JOSM'),(52749385,'created_by','JOSM'),(52749386,'created_by','JOSM'),(52749387,'created_by','JOSM'),(52749389,'created_by','JOSM'),(52749391,'created_by','JOSM'),(52749393,'created_by','JOSM'),(52749396,'created_by','JOSM'),(52749398,'created_by','JOSM'),(52749400,'created_by','JOSM'),(52749402,'created_by','JOSM'),(52749404,'created_by','JOSM'),(52749407,'created_by','JOSM'),(52749410,'created_by','JOSM'),(52749412,'created_by','JOSM'),(52749414,'created_by','JOSM'),(52749416,'created_by','JOSM'),(52749419,'created_by','JOSM'),(52749421,'created_by','JOSM'),(52749424,'created_by','JOSM'),(52749428,'created_by','JOSM'),(52749430,'created_by','JOSM'),(52749433,'created_by','JOSM'),(52749436,'created_by','JOSM'),(52749439,'created_by','JOSM'),(52749441,'created_by','JOSM'),(52749443,'created_by','JOSM'),(52749448,'created_by','JOSM'),(52749451,'created_by','JOSM'),(52749455,'created_by','JOSM'),(52749458,'created_by','JOSM'),(52749460,'created_by','JOSM'),(52749462,'created_by','JOSM'),(52749465,'created_by','JOSM'),(52749469,'created_by','JOSM'),(52749472,'created_by','JOSM'),(52749474,'created_by','JOSM'),(52749475,'created_by','JOSM'),(52749479,'created_by','JOSM'),(52749482,'created_by','JOSM'),(52749485,'created_by','JOSM'),(52749487,'created_by','JOSM'),(52749490,'created_by','JOSM'),(52749491,'created_by','JOSM'),(52749492,'created_by','JOSM'),(52749496,'created_by','JOSM'),(52749497,'created_by','JOSM'),(52749499,'created_by','JOSM'),(52749502,'created_by','JOSM'),(52749503,'created_by','JOSM'),(52749505,'created_by','JOSM'),(52749508,'created_by','JOSM'),(52749509,'created_by','JOSM'),(52749511,'created_by','JOSM'),(52749514,'created_by','JOSM'),(52749517,'created_by','JOSM'),(52769332,'created_by','JOSM'),(52769338,'created_by','JOSM'),(52769340,'created_by','JOSM'),(52769343,'created_by','JOSM'),(52769346,'created_by','JOSM'),(52769349,'created_by','JOSM'),(52769352,'created_by','JOSM'),(52769355,'created_by','JOSM'),(52769357,'created_by','JOSM'),(52769358,'created_by','JOSM'),(52769361,'created_by','JOSM'),(52769364,'created_by','JOSM'),(52769366,'created_by','JOSM'),(52769367,'created_by','JOSM'),(52769369,'created_by','JOSM'),(52769371,'created_by','JOSM'),(52769373,'created_by','JOSM'),(52769374,'created_by','JOSM'),(52769377,'created_by','JOSM'),(52769380,'created_by','JOSM'),(52769381,'created_by','JOSM'),(52769384,'created_by','JOSM'),(52769387,'created_by','JOSM'),(52769389,'created_by','JOSM'),(52769392,'created_by','JOSM'),(52769395,'created_by','JOSM'),(52769397,'created_by','JOSM'),(52769401,'created_by','JOSM'),(52769406,'created_by','JOSM'),(52769411,'created_by','JOSM'),(52769413,'created_by','JOSM'),(52769415,'created_by','JOSM'),(52769418,'created_by','JOSM'),(52769419,'created_by','JOSM'),(52769420,'created_by','JOSM'),(52769423,'created_by','JOSM'),(52769425,'created_by','JOSM'),(52769427,'created_by','JOSM'),(52769431,'created_by','JOSM'),(52769436,'created_by','JOSM'),(52769439,'created_by','JOSM'),(52769441,'created_by','JOSM'),(52769444,'created_by','JOSM'),(52769447,'created_by','JOSM'),(52769450,'created_by','JOSM'),(52769452,'created_by','JOSM'),(52769456,'created_by','JOSM'),(52769457,'created_by','JOSM'),(52769460,'created_by','JOSM'),(52769465,'created_by','JOSM'),(52769471,'created_by','JOSM'),(52769477,'created_by','JOSM'),(52769479,'created_by','JOSM'),(52769482,'created_by','JOSM'),(52769485,'created_by','JOSM'),(52769488,'created_by','JOSM'),(52769491,'created_by','JOSM'),(52769493,'created_by','JOSM'),(52792095,'created_by','JOSM'),(52792098,'created_by','JOSM'),(52792102,'created_by','JOSM'),(52792111,'created_by','JOSM'),(52792113,'created_by','JOSM'),(52792114,'created_by','JOSM'),(52792117,'created_by','JOSM'),(52792122,'created_by','JOSM'),(52792158,'created_by','JOSM'),(52792159,'created_by','JOSM'),(52792177,'created_by','JOSM'),(52792180,'created_by','JOSM'),(52792182,'created_by','JOSM'),(52792185,'created_by','JOSM'),(52792187,'created_by','JOSM'),(52792189,'created_by','JOSM'),(52792192,'created_by','JOSM'),(52792194,'created_by','JOSM'),(52792196,'created_by','JOSM'),(52792199,'created_by','JOSM'),(52792202,'created_by','JOSM'),(52792205,'created_by','JOSM'),(52792210,'created_by','JOSM'),(52796991,'created_by','JOSM'),(52797049,'created_by','JOSM'),(52797051,'created_by','JOSM'),(52797069,'created_by','JOSM'),(52797105,'created_by','JOSM'),(52797267,'created_by','JOSM'),(52797268,'created_by','JOSM'),(52797269,'created_by','JOSM'),(52797270,'created_by','JOSM'),(52797275,'created_by','JOSM'),(52797278,'created_by','JOSM'),(52797286,'created_by','JOSM'),(52797303,'created_by','JOSM'),(52797555,'created_by','JOSM'),(52798676,'created_by','JOSM'),(52799709,'created_by','JOSM'),(52799985,'created_by','JOSM'),(52800033,'created_by','JOSM'),(52800211,'created_by','JOSM'),(52800388,'created_by','JOSM'),(52800400,'created_by','JOSM'),(52800405,'created_by','JOSM'),(52800416,'created_by','JOSM'),(52800529,'created_by','JOSM'),(52800536,'created_by','JOSM'),(52800580,'created_by','JOSM'),(52800584,'created_by','JOSM'),(52800586,'created_by','JOSM'),(52800590,'created_by','JOSM'),(52800592,'created_by','JOSM'),(52800596,'created_by','JOSM'),(52800599,'created_by','JOSM'),(52800602,'created_by','JOSM'),(52800606,'created_by','JOSM'),(52800608,'created_by','JOSM'),(52800610,'created_by','JOSM'),(52800614,'created_by','JOSM'),(52800618,'created_by','JOSM'),(52800619,'created_by','JOSM'),(52800622,'created_by','JOSM'),(52800623,'created_by','JOSM'),(52800625,'created_by','JOSM'),(52800626,'created_by','JOSM'),(52800628,'created_by','JOSM'),(52800630,'created_by','JOSM'),(52800634,'created_by','JOSM'),(52800638,'created_by','JOSM'),(52800642,'created_by','JOSM'),(52800645,'created_by','JOSM'),(52800647,'created_by','JOSM'),(52800651,'created_by','JOSM'),(52800652,'created_by','JOSM'),(52800656,'created_by','JOSM'),(52800661,'created_by','JOSM'),(52800664,'created_by','JOSM'),(52800665,'created_by','JOSM'),(52800667,'created_by','JOSM'),(52800668,'created_by','JOSM'),(52800670,'created_by','JOSM'),(52800673,'created_by','JOSM'),(52800677,'created_by','JOSM'),(52800681,'created_by','JOSM'),(52800683,'created_by','JOSM'),(52800686,'created_by','JOSM'),(52800691,'created_by','JOSM'),(52800794,'created_by','JOSM'),(52800813,'created_by','JOSM'),(52800821,'created_by','JOSM'),(52800828,'created_by','JOSM'),(52800845,'created_by','JOSM'),(52800909,'created_by','JOSM'),(52800938,'created_by','JOSM'),(52800944,'created_by','JOSM'),(52800948,'created_by','JOSM'),(52800952,'created_by','JOSM'),(52800957,'created_by','JOSM'),(52800960,'created_by','JOSM'),(52800964,'created_by','JOSM'),(52800967,'created_by','JOSM'),(52800970,'created_by','JOSM'),(52800974,'created_by','JOSM'),(52800978,'created_by','JOSM'),(52800981,'created_by','JOSM'),(52800985,'created_by','JOSM'),(52800987,'created_by','JOSM'),(52800990,'created_by','JOSM'),(52800993,'created_by','JOSM'),(52800995,'created_by','JOSM'),(52800998,'created_by','JOSM'),(52801001,'created_by','JOSM'),(52801004,'created_by','JOSM'),(52801007,'created_by','JOSM'),(52801010,'created_by','JOSM'),(52801153,'created_by','JOSM'),(52801157,'created_by','JOSM'),(52801158,'created_by','JOSM'),(52801164,'created_by','JOSM'),(52801166,'created_by','JOSM'),(52801167,'created_by','JOSM'),(52801168,'created_by','JOSM'),(52801170,'created_by','JOSM'),(52801172,'created_by','JOSM'),(52801173,'created_by','JOSM'),(52801175,'created_by','JOSM'),(52801176,'created_by','JOSM'),(52801178,'created_by','JOSM'),(52801181,'created_by','JOSM'),(52801182,'created_by','JOSM'),(52801184,'created_by','JOSM'),(52801190,'created_by','JOSM'),(52801192,'created_by','JOSM'),(52801195,'created_by','JOSM'),(52801198,'created_by','JOSM'),(52801203,'created_by','JOSM'),(52801207,'created_by','JOSM'),(52801209,'created_by','JOSM'),(52801212,'created_by','JOSM'),(52801215,'created_by','JOSM'),(52801217,'created_by','JOSM'),(52801218,'created_by','JOSM'),(52801220,'created_by','JOSM'),(52801221,'created_by','JOSM'),(52801223,'created_by','JOSM'),(52801226,'created_by','JOSM'),(52801228,'created_by','JOSM'),(52801231,'created_by','JOSM'),(52801233,'created_by','JOSM'),(52801234,'created_by','JOSM'),(52801247,'created_by','JOSM'),(52801248,'created_by','JOSM'),(52801251,'created_by','JOSM'),(52801254,'created_by','JOSM'),(52801258,'created_by','JOSM'),(52801262,'created_by','JOSM'),(52801265,'created_by','JOSM'),(52801269,'created_by','JOSM'),(52801273,'created_by','JOSM'),(52801274,'created_by','JOSM'),(52801279,'created_by','JOSM'),(52801283,'created_by','JOSM'),(52801284,'created_by','JOSM'),(52801287,'created_by','JOSM'),(52801289,'created_by','JOSM'),(52801291,'created_by','JOSM'),(52801293,'created_by','JOSM'),(52801295,'created_by','JOSM'),(52801298,'created_by','JOSM'),(52801299,'created_by','JOSM'),(52801301,'created_by','JOSM'),(52801303,'created_by','JOSM'),(52801305,'created_by','JOSM'),(52801307,'created_by','JOSM'),(52801309,'created_by','JOSM'),(52801311,'created_by','JOSM'),(52801313,'created_by','JOSM'),(52801314,'created_by','JOSM'),(52801316,'created_by','JOSM'),(52801317,'created_by','JOSM'),(52801319,'created_by','JOSM'),(52801321,'created_by','JOSM'),(52801323,'created_by','JOSM'),(52801324,'created_by','JOSM'),(52801326,'created_by','JOSM'),(52801328,'created_by','JOSM'),(52801330,'created_by','JOSM'),(52801331,'created_by','JOSM'),(52801333,'created_by','JOSM'),(52801336,'created_by','JOSM'),(52801339,'created_by','JOSM'),(52801341,'created_by','JOSM'),(52801344,'created_by','JOSM'),(52801345,'created_by','JOSM'),(52801348,'created_by','JOSM'),(52801350,'created_by','JOSM'),(52801352,'created_by','JOSM'),(52801353,'created_by','JOSM'),(52801354,'created_by','JOSM'),(52801355,'created_by','JOSM'),(52801356,'created_by','JOSM'),(52801357,'created_by','JOSM'),(52801358,'created_by','JOSM'),(52801359,'created_by','JOSM'),(52801360,'created_by','JOSM'),(52801361,'created_by','JOSM'),(52801362,'created_by','JOSM'),(52801363,'created_by','JOSM'),(52801364,'created_by','JOSM'),(52801366,'created_by','JOSM'),(52801368,'created_by','JOSM'),(52801370,'created_by','JOSM'),(52801372,'created_by','JOSM'),(52801374,'created_by','JOSM'),(52801376,'created_by','JOSM'),(52801380,'created_by','JOSM'),(52801384,'created_by','JOSM'),(52801389,'created_by','JOSM'),(52801392,'created_by','JOSM'),(52801396,'created_by','JOSM'),(52801397,'created_by','JOSM'),(52801402,'created_by','JOSM'),(52801404,'created_by','JOSM'),(52801407,'created_by','JOSM'),(52801413,'created_by','JOSM'),(52801417,'created_by','JOSM'),(52801418,'created_by','JOSM'),(52801422,'created_by','JOSM'),(52801425,'created_by','JOSM'),(52801427,'created_by','JOSM'),(52801429,'created_by','JOSM'),(52801431,'created_by','JOSM'),(52801433,'created_by','JOSM'),(52801435,'created_by','JOSM'),(52801437,'created_by','JOSM'),(52801439,'created_by','JOSM'),(52801441,'created_by','JOSM'),(52801444,'created_by','JOSM'),(52801446,'created_by','JOSM'),(52801447,'created_by','JOSM'),(52801451,'created_by','JOSM'),(52801453,'created_by','JOSM'),(52801456,'created_by','JOSM'),(52801461,'created_by','JOSM'),(52801462,'created_by','JOSM'),(52801465,'created_by','JOSM'),(52801468,'created_by','JOSM'),(52801469,'created_by','JOSM'),(52801475,'created_by','JOSM'),(52801477,'created_by','JOSM'),(52801480,'created_by','JOSM'),(52801487,'created_by','JOSM'),(52801494,'created_by','JOSM'),(52801506,'created_by','JOSM'),(52801514,'created_by','JOSM'),(52801516,'created_by','JOSM'),(52801518,'created_by','JOSM'),(52801520,'created_by','JOSM'),(52801522,'created_by','JOSM'),(52801524,'created_by','JOSM'),(52801526,'created_by','JOSM'),(52801527,'created_by','JOSM'),(52801531,'created_by','JOSM'),(52801534,'created_by','JOSM'),(52801538,'created_by','JOSM'),(52801542,'created_by','JOSM'),(52801545,'created_by','JOSM'),(52801548,'created_by','JOSM'),(52801551,'created_by','JOSM'),(52801555,'created_by','JOSM'),(52801558,'created_by','JOSM'),(52801561,'created_by','JOSM'),(52801566,'created_by','JOSM'),(52801569,'created_by','JOSM'),(52801571,'created_by','JOSM'),(52801573,'created_by','JOSM'),(52801576,'created_by','JOSM'),(52801578,'created_by','JOSM'),(52801581,'created_by','JOSM'),(52801584,'created_by','JOSM'),(52801585,'created_by','JOSM'),(52801587,'created_by','JOSM'),(52801618,'created_by','JOSM'),(52801640,'created_by','JOSM'),(52801643,'created_by','JOSM'),(52801648,'created_by','JOSM'),(52801652,'created_by','JOSM'),(52801654,'created_by','JOSM'),(52801657,'created_by','JOSM'),(52801660,'created_by','JOSM'),(52801663,'created_by','JOSM'),(52801664,'created_by','JOSM'),(52801668,'created_by','JOSM'),(52801672,'created_by','JOSM'),(52801674,'created_by','JOSM'),(52801679,'created_by','JOSM'),(52801683,'created_by','JOSM'),(52801684,'created_by','JOSM'),(52801688,'created_by','JOSM'),(52801691,'created_by','JOSM'),(52801695,'created_by','JOSM'),(52801699,'created_by','JOSM'),(52801701,'created_by','JOSM'),(52801704,'created_by','JOSM'),(52801707,'created_by','JOSM'),(52801710,'created_by','JOSM'),(52801715,'created_by','JOSM'),(52801719,'created_by','JOSM'),(52801722,'created_by','JOSM'),(52801725,'created_by','JOSM'),(52801729,'created_by','JOSM'),(52801733,'created_by','JOSM'),(52801737,'created_by','JOSM'),(52801741,'created_by','JOSM'),(52801744,'created_by','JOSM'),(52801747,'created_by','JOSM'),(52801749,'created_by','JOSM'),(52801750,'created_by','JOSM'),(52801752,'created_by','JOSM'),(52801754,'created_by','JOSM'),(52801756,'created_by','JOSM'),(52801757,'created_by','JOSM'),(52801758,'created_by','JOSM'),(52801759,'created_by','JOSM'),(52801760,'created_by','JOSM'),(52801761,'created_by','JOSM'),(52801762,'created_by','JOSM'),(52801764,'created_by','JOSM'),(52801765,'created_by','JOSM'),(52801768,'created_by','JOSM'),(52801769,'created_by','JOSM'),(52801771,'created_by','JOSM'),(52801772,'created_by','JOSM'),(52801774,'created_by','JOSM'),(52801776,'created_by','JOSM'),(52801777,'created_by','JOSM'),(52801780,'created_by','JOSM'),(52801781,'created_by','JOSM'),(52801783,'created_by','JOSM'),(52801785,'created_by','JOSM'),(52801787,'created_by','JOSM'),(52801788,'created_by','JOSM'),(52801791,'created_by','JOSM'),(52801792,'created_by','JOSM'),(52801794,'created_by','JOSM'),(52801796,'created_by','JOSM'),(52801807,'created_by','JOSM'),(52801809,'created_by','JOSM'),(52801813,'created_by','JOSM'),(52801816,'created_by','JOSM'),(52801819,'created_by','JOSM'),(52801824,'created_by','JOSM'),(52801827,'created_by','JOSM'),(52801876,'created_by','JOSM'),(52802034,'created_by','JOSM'),(52802158,'created_by','JOSM'),(52802159,'created_by','JOSM'),(52802160,'created_by','JOSM'),(52802161,'created_by','JOSM'),(52802162,'created_by','JOSM'),(52802163,'created_by','JOSM'),(52802164,'created_by','JOSM'),(52802165,'created_by','JOSM'),(52802166,'created_by','JOSM'),(52802167,'created_by','JOSM'),(52802168,'created_by','JOSM'),(52802169,'created_by','JOSM'),(52802170,'created_by','JOSM'),(52802171,'created_by','JOSM'),(52802172,'created_by','JOSM'),(52802173,'created_by','JOSM'),(52802183,'created_by','JOSM'),(52802197,'created_by','JOSM'),(52802210,'created_by','JOSM'),(52802216,'created_by','JOSM'),(52802218,'created_by','JOSM'),(52802229,'created_by','JOSM'),(52802260,'created_by','JOSM'),(52803163,'created_by','JOSM'),(52803175,'created_by','JOSM'),(52803179,'created_by','JOSM'),(52803182,'created_by','JOSM'),(52803183,'created_by','JOSM'),(52803186,'created_by','JOSM'),(52803189,'created_by','JOSM'),(52803191,'created_by','JOSM'),(52803194,'created_by','JOSM'),(52803195,'created_by','JOSM'),(52803196,'created_by','JOSM'),(52803197,'created_by','JOSM'),(52803198,'created_by','JOSM'),(52803200,'created_by','JOSM'),(52803201,'created_by','JOSM'),(52803202,'created_by','JOSM'),(52803205,'created_by','JOSM'),(52803207,'created_by','JOSM'),(52803211,'created_by','JOSM'),(52803214,'created_by','JOSM'),(52803216,'created_by','JOSM'),(52803218,'created_by','JOSM'),(52803220,'created_by','JOSM'),(52803222,'created_by','JOSM'),(52803224,'created_by','JOSM'),(52803225,'created_by','JOSM'),(52803228,'created_by','JOSM'),(52803229,'created_by','JOSM'),(52803233,'created_by','JOSM'),(52803235,'created_by','JOSM'),(52803237,'created_by','JOSM'),(52803239,'created_by','JOSM'),(52803241,'created_by','JOSM'),(52803243,'created_by','JOSM'),(52803247,'created_by','JOSM'),(52803251,'created_by','JOSM'),(52803254,'created_by','JOSM'),(52803255,'created_by','JOSM'),(52803259,'created_by','JOSM'),(52803263,'created_by','JOSM'),(52803266,'created_by','JOSM'),(52803269,'created_by','JOSM'),(52803271,'created_by','JOSM'),(52803273,'created_by','JOSM'),(52803277,'created_by','JOSM'),(52803280,'created_by','JOSM'),(52803283,'created_by','JOSM'),(52803285,'created_by','JOSM'),(52803289,'created_by','JOSM'),(52803297,'created_by','JOSM'),(52803300,'created_by','JOSM'),(52803304,'created_by','JOSM'),(52803309,'created_by','JOSM'),(52803311,'created_by','JOSM'),(52803313,'created_by','JOSM'),(52803316,'created_by','JOSM'),(52803319,'created_by','JOSM'),(52803320,'created_by','JOSM'),(52803323,'created_by','JOSM'),(52803325,'created_by','JOSM'),(52803327,'created_by','JOSM'),(52803328,'created_by','JOSM'),(52803331,'created_by','JOSM'),(52803333,'created_by','JOSM'),(52803336,'created_by','JOSM'),(52803337,'created_by','JOSM'),(52803338,'created_by','JOSM'),(52803340,'created_by','JOSM'),(52803343,'created_by','JOSM'),(52803346,'created_by','JOSM'),(52803349,'created_by','JOSM'),(52803351,'created_by','JOSM'),(52803353,'created_by','JOSM'),(52803358,'created_by','JOSM'),(52803363,'created_by','JOSM'),(52803365,'created_by','JOSM'),(52803368,'created_by','JOSM'),(52803370,'created_by','JOSM'),(52803372,'created_by','JOSM'),(52803374,'created_by','JOSM'),(52803378,'created_by','JOSM'),(52803382,'created_by','JOSM'),(52803385,'created_by','JOSM'),(52803388,'created_by','JOSM'),(52803391,'created_by','JOSM'),(52803393,'created_by','JOSM'),(52803396,'created_by','JOSM'),(52803399,'created_by','JOSM'),(52803402,'created_by','JOSM'),(52803405,'created_by','JOSM'),(52803937,'created_by','JOSM'),(52803938,'created_by','JOSM'),(52803940,'created_by','JOSM'),(52803941,'created_by','JOSM'),(52803943,'created_by','JOSM'),(52803944,'created_by','JOSM'),(52803954,'created_by','JOSM'),(52803955,'created_by','JOSM'),(52803956,'created_by','JOSM'),(52803958,'created_by','JOSM'),(52803959,'created_by','JOSM'),(52803961,'created_by','JOSM'),(52803962,'created_by','JOSM'),(52803965,'created_by','JOSM'),(52803969,'created_by','JOSM'),(52803973,'created_by','JOSM'),(52803976,'created_by','JOSM'),(52803980,'created_by','JOSM'),(52803983,'created_by','JOSM'),(52803988,'created_by','JOSM'),(52803992,'created_by','JOSM'),(52803995,'created_by','JOSM'),(52803998,'created_by','JOSM'),(52804002,'created_by','JOSM'),(52804005,'created_by','JOSM'),(52804010,'created_by','JOSM'),(52804014,'created_by','JOSM'),(52804018,'created_by','JOSM'),(52804021,'created_by','JOSM'),(52804024,'created_by','JOSM'),(52804026,'created_by','JOSM'),(52804028,'created_by','JOSM'),(52804030,'created_by','JOSM'),(52804033,'created_by','JOSM'),(52804036,'created_by','JOSM'),(52804038,'created_by','JOSM'),(52804041,'created_by','JOSM'),(52804043,'created_by','JOSM'),(52804046,'created_by','JOSM'),(52804050,'created_by','JOSM'),(52804052,'created_by','JOSM'),(52804055,'created_by','JOSM'),(52804060,'created_by','JOSM'),(52804062,'created_by','JOSM'),(52804065,'created_by','JOSM'),(52804069,'created_by','JOSM'),(52804073,'created_by','JOSM'),(52804077,'created_by','JOSM'),(52804081,'created_by','JOSM'),(52804084,'created_by','JOSM'),(52804087,'created_by','JOSM'),(52804090,'created_by','JOSM'),(52804091,'created_by','JOSM'),(52804093,'created_by','JOSM'),(52804096,'created_by','JOSM'),(52804100,'created_by','JOSM'),(52804101,'created_by','JOSM'),(52804106,'created_by','JOSM'),(52804109,'created_by','JOSM'),(52804112,'created_by','JOSM'),(52804114,'created_by','JOSM'),(52804117,'created_by','JOSM'),(52804118,'created_by','JOSM'),(52804119,'created_by','JOSM'),(52804120,'created_by','JOSM'),(52804121,'created_by','JOSM'),(52804122,'created_by','JOSM'),(52804123,'created_by','JOSM'),(52804124,'created_by','JOSM'),(52804125,'created_by','JOSM'),(52804126,'created_by','JOSM'),(52804127,'created_by','JOSM'),(52804128,'created_by','JOSM'),(52804129,'created_by','JOSM'),(52804130,'created_by','JOSM'),(52804131,'created_by','JOSM'),(52804132,'created_by','JOSM'),(52804133,'created_by','JOSM'),(52804134,'created_by','JOSM'),(52804135,'created_by','JOSM'),(52804136,'created_by','JOSM'),(52804137,'created_by','JOSM'),(52804138,'created_by','JOSM'),(52804139,'created_by','JOSM'),(52804140,'created_by','JOSM'),(52804141,'created_by','JOSM'),(52804142,'created_by','JOSM'),(52804143,'created_by','JOSM'),(52804145,'created_by','JOSM'),(52804150,'created_by','JOSM'),(52804160,'created_by','JOSM'),(52804163,'created_by','JOSM'),(52804167,'created_by','JOSM'),(52804172,'created_by','JOSM'),(52804173,'created_by','JOSM'),(52804176,'created_by','JOSM'),(52804216,'created_by','JOSM'),(52804228,'created_by','JOSM'),(52804233,'created_by','JOSM'),(52804235,'created_by','JOSM'),(52804237,'created_by','JOSM'),(52804272,'created_by','JOSM'),(52804275,'created_by','JOSM'),(52804279,'created_by','JOSM'),(52804292,'created_by','JOSM'),(52804295,'created_by','JOSM'),(52804297,'created_by','JOSM'),(52804298,'created_by','JOSM'),(52804299,'created_by','JOSM'),(52804736,'created_by','JOSM'),(52804739,'created_by','JOSM'),(52804766,'created_by','JOSM'),(52804772,'created_by','JOSM'),(52804776,'created_by','JOSM'),(52804777,'created_by','JOSM'),(52804778,'created_by','JOSM'),(52804779,'created_by','JOSM'),(52804780,'created_by','JOSM'),(52804788,'created_by','JOSM'),(52804791,'created_by','JOSM'),(52804795,'created_by','JOSM'),(52804796,'created_by','JOSM'),(52804798,'created_by','JOSM'),(52804801,'created_by','JOSM'),(52804803,'created_by','JOSM'),(52804805,'created_by','JOSM'),(52804807,'created_by','JOSM'),(52804809,'created_by','JOSM'),(52804811,'created_by','JOSM'),(52804813,'created_by','JOSM'),(52804815,'created_by','JOSM'),(52812261,'created_by','JOSM'),(52812263,'created_by','JOSM'),(52812266,'created_by','JOSM'),(52812268,'created_by','JOSM'),(52812270,'created_by','JOSM'),(52812274,'created_by','JOSM'),(52812277,'created_by','JOSM'),(52812281,'created_by','JOSM'),(52812284,'created_by','JOSM'),(52812288,'created_by','JOSM'),(52812291,'created_by','JOSM'),(52812295,'created_by','JOSM'),(52812296,'created_by','JOSM'),(52812299,'created_by','JOSM'),(52812303,'created_by','JOSM'),(52812305,'created_by','JOSM'),(52812309,'created_by','JOSM'),(52812311,'created_by','JOSM'),(52812315,'created_by','JOSM'),(52812318,'created_by','JOSM'),(52812321,'created_by','JOSM'),(52812323,'created_by','JOSM'),(52812326,'created_by','JOSM'),(52812329,'created_by','JOSM'),(52812331,'created_by','JOSM'),(52812333,'created_by','JOSM'),(52812335,'created_by','JOSM'),(52812338,'created_by','JOSM'),(52812341,'created_by','JOSM'),(52812343,'created_by','JOSM'),(52812347,'created_by','JOSM'),(52812350,'created_by','JOSM'),(52812353,'created_by','JOSM'),(52812356,'created_by','JOSM'),(52812360,'created_by','JOSM'),(52812363,'created_by','JOSM'),(52812365,'created_by','JOSM'),(52812366,'created_by','JOSM'),(52812367,'created_by','JOSM'),(52812369,'created_by','JOSM'),(52812372,'created_by','JOSM'),(52812376,'created_by','JOSM'),(52812379,'created_by','JOSM'),(52812380,'created_by','JOSM'),(52812383,'created_by','JOSM'),(52812385,'created_by','JOSM'),(52812387,'created_by','JOSM'),(52812389,'created_by','JOSM'),(52812391,'created_by','JOSM'),(52812395,'created_by','JOSM'),(52812397,'created_by','JOSM'),(52812399,'created_by','JOSM'),(52812403,'created_by','JOSM'),(52812405,'created_by','JOSM'),(52812406,'created_by','JOSM'),(52812407,'created_by','JOSM'),(52812409,'created_by','JOSM'),(52812410,'created_by','JOSM'),(52812411,'created_by','JOSM'),(52812413,'created_by','JOSM'),(52812414,'created_by','JOSM'),(52812415,'created_by','JOSM'),(52812417,'created_by','JOSM'),(52812418,'created_by','JOSM'),(52812421,'created_by','JOSM'),(52812425,'created_by','JOSM'),(52812428,'created_by','JOSM'),(52812440,'created_by','JOSM'),(52812444,'created_by','JOSM'),(52812447,'created_by','JOSM'),(52812450,'created_by','JOSM'),(52812453,'created_by','JOSM'),(52812457,'created_by','JOSM'),(52812460,'created_by','JOSM'),(52812464,'created_by','JOSM'),(52812468,'created_by','JOSM'),(52812472,'created_by','JOSM'),(52812475,'created_by','JOSM'),(52812478,'created_by','JOSM'),(52812481,'created_by','JOSM'),(52812485,'created_by','JOSM'),(52812487,'created_by','JOSM'),(52812491,'created_by','JOSM'),(52812494,'created_by','JOSM'),(52812497,'created_by','JOSM'),(52812501,'created_by','JOSM'),(52812505,'created_by','JOSM'),(52812507,'created_by','JOSM'),(52812511,'created_by','JOSM'),(52812514,'created_by','JOSM'),(52812517,'created_by','JOSM'),(52812520,'created_by','JOSM'),(52812522,'created_by','JOSM'),(52812526,'created_by','JOSM'),(52812530,'created_by','JOSM'),(52812531,'created_by','JOSM'),(52812534,'created_by','JOSM'),(52812536,'created_by','JOSM'),(52812537,'created_by','JOSM'),(52812540,'created_by','JOSM'),(52812541,'created_by','JOSM'),(52812543,'created_by','JOSM'),(52812545,'created_by','JOSM'),(52812547,'created_by','JOSM'),(52812549,'created_by','JOSM'),(52812551,'created_by','JOSM'),(52812553,'created_by','JOSM'),(52812555,'created_by','JOSM'),(52812558,'created_by','JOSM'),(52812562,'created_by','JOSM'),(52812564,'created_by','JOSM'),(52812566,'created_by','JOSM'),(52812569,'created_by','JOSM'),(52812572,'created_by','JOSM'),(52812574,'created_by','JOSM'),(52812577,'created_by','JOSM'),(52812580,'created_by','JOSM'),(52812582,'created_by','JOSM'),(52812585,'created_by','JOSM'),(52812587,'created_by','JOSM'),(52812590,'created_by','JOSM'),(52812592,'created_by','JOSM'),(52812595,'created_by','JOSM'),(52812597,'created_by','JOSM'),(52812598,'created_by','JOSM'),(52818308,'created_by','JOSM'),(52818311,'created_by','JOSM'),(52818312,'created_by','JOSM'),(52818315,'created_by','JOSM'),(52818317,'created_by','JOSM'),(52818320,'created_by','JOSM'),(52818322,'created_by','JOSM'),(52818324,'created_by','JOSM'),(52818326,'created_by','JOSM'),(52818330,'created_by','JOSM'),(52818332,'created_by','JOSM'),(52818334,'created_by','JOSM'),(52818337,'created_by','JOSM'),(52818340,'created_by','JOSM'),(52818343,'created_by','JOSM'),(52818346,'created_by','JOSM'),(52818348,'created_by','JOSM'),(52818350,'created_by','JOSM'),(52818352,'created_by','JOSM'),(52818355,'created_by','JOSM'),(52818358,'created_by','JOSM'),(52818362,'created_by','JOSM'),(52818365,'created_by','JOSM'),(52818368,'created_by','JOSM'),(52818370,'created_by','JOSM'),(52818373,'created_by','JOSM'),(52818377,'created_by','JOSM'),(52818379,'created_by','JOSM'),(52818382,'created_by','JOSM'),(52818384,'created_by','JOSM'),(52818385,'created_by','JOSM'),(52818387,'created_by','JOSM'),(52818389,'created_by','JOSM'),(52818390,'created_by','JOSM'),(52818391,'created_by','JOSM'),(52818392,'created_by','JOSM'),(52818393,'created_by','JOSM'),(52818394,'created_by','JOSM'),(52818396,'created_by','JOSM'),(52818397,'created_by','JOSM'),(52818398,'created_by','JOSM'),(52818399,'created_by','JOSM'),(52818402,'created_by','JOSM'),(52818404,'created_by','JOSM'),(52818405,'created_by','JOSM'),(52818406,'created_by','JOSM'),(52818407,'created_by','JOSM'),(52818409,'created_by','JOSM'),(52818413,'created_by','JOSM'),(52818415,'created_by','JOSM'),(52818417,'created_by','JOSM'),(52818420,'created_by','JOSM'),(52818424,'created_by','JOSM'),(52818427,'created_by','JOSM'),(52818428,'created_by','JOSM'),(52818432,'created_by','JOSM'),(52818434,'created_by','JOSM'),(52818437,'created_by','JOSM'),(52818440,'created_by','JOSM'),(52818441,'created_by','JOSM'),(52818445,'created_by','JOSM'),(52818446,'created_by','JOSM'),(52818448,'created_by','JOSM'),(52818450,'created_by','JOSM'),(52818451,'created_by','JOSM'),(52818452,'created_by','JOSM'),(52818453,'created_by','JOSM'),(52818454,'created_by','JOSM'),(52818455,'created_by','JOSM'),(52818456,'created_by','JOSM'),(52818457,'created_by','JOSM'),(52818458,'created_by','JOSM'),(52818461,'created_by','JOSM'),(52818463,'created_by','JOSM'),(52818465,'created_by','JOSM'),(52818470,'created_by','JOSM'),(52818472,'created_by','JOSM'),(52818475,'created_by','JOSM'),(52818478,'created_by','JOSM'),(52818479,'created_by','JOSM'),(52818483,'created_by','JOSM'),(52818485,'created_by','JOSM'),(52818487,'created_by','JOSM'),(52818489,'created_by','JOSM'),(52818490,'created_by','JOSM'),(52818491,'created_by','JOSM'),(52818493,'created_by','JOSM'),(52818495,'created_by','JOSM'),(52818498,'created_by','JOSM'),(52818501,'created_by','JOSM'),(52818503,'created_by','JOSM'),(52818505,'created_by','JOSM'),(52818508,'created_by','JOSM'),(52818511,'created_by','JOSM'),(52818514,'created_by','JOSM'),(52818516,'created_by','JOSM'),(52818518,'created_by','JOSM'),(52818520,'created_by','JOSM'),(52818522,'created_by','JOSM'),(52818524,'created_by','JOSM'),(52818527,'created_by','JOSM'),(52818529,'created_by','JOSM'),(52818533,'created_by','JOSM'),(52818536,'created_by','JOSM'),(52818538,'created_by','JOSM'),(52818539,'created_by','JOSM'),(52818542,'created_by','JOSM'),(52818550,'created_by','JOSM'),(52818553,'created_by','JOSM'),(52818555,'created_by','JOSM'),(52818557,'created_by','JOSM'),(52818561,'created_by','JOSM'),(52818563,'created_by','JOSM'),(52818564,'created_by','JOSM'),(52818566,'created_by','JOSM'),(52818567,'created_by','JOSM'),(52818569,'created_by','JOSM'),(52818572,'created_by','JOSM'),(52818574,'created_by','JOSM'),(52818577,'created_by','JOSM'),(52818581,'created_by','JOSM'),(52818582,'created_by','JOSM'),(52818585,'created_by','JOSM'),(52818587,'created_by','JOSM'),(52818590,'created_by','JOSM'),(52818592,'created_by','JOSM'),(52818594,'created_by','JOSM'),(52818598,'created_by','JOSM'),(52818600,'created_by','JOSM'),(52818603,'created_by','JOSM'),(52818605,'created_by','JOSM'),(52818609,'created_by','JOSM'),(52818612,'created_by','JOSM'),(52818615,'created_by','JOSM'),(52818618,'created_by','JOSM'),(52818620,'created_by','JOSM'),(52818622,'created_by','JOSM'),(52818623,'created_by','JOSM'),(52818627,'created_by','JOSM'),(52818629,'created_by','JOSM'),(52818631,'created_by','JOSM'),(52818633,'created_by','JOSM'),(52818635,'created_by','JOSM'),(52818636,'created_by','JOSM'),(52818639,'created_by','JOSM'),(52818641,'created_by','JOSM'),(52818642,'created_by','JOSM'),(52818644,'created_by','JOSM'),(52818647,'created_by','JOSM'),(52818648,'created_by','JOSM'),(52818651,'created_by','JOSM'),(52818652,'created_by','JOSM'),(52818655,'created_by','JOSM'),(52818657,'created_by','JOSM'),(52818659,'created_by','JOSM'),(52818661,'created_by','JOSM'),(52818663,'created_by','JOSM'),(52818669,'created_by','JOSM'),(52818671,'created_by','JOSM'),(52818673,'created_by','JOSM'),(52818675,'created_by','JOSM'),(52818677,'created_by','JOSM'),(52818679,'created_by','JOSM'),(52818681,'created_by','JOSM'),(52818685,'created_by','JOSM'),(52818687,'created_by','JOSM'),(52818690,'created_by','JOSM'),(52818692,'created_by','JOSM'),(52818694,'created_by','JOSM'),(52818720,'created_by','JOSM'),(52818722,'created_by','JOSM'),(52818724,'created_by','JOSM'),(52818727,'created_by','JOSM'),(52818729,'created_by','JOSM'),(52818731,'created_by','JOSM'),(52818733,'created_by','JOSM'),(52818747,'created_by','JOSM'),(52818757,'created_by','JOSM'),(52818771,'created_by','JOSM'),(52818775,'created_by','JOSM'),(52818781,'created_by','JOSM'),(52818791,'created_by','JOSM'),(52818794,'created_by','JOSM'),(52818796,'created_by','JOSM'),(52818800,'created_by','JOSM'),(52818803,'created_by','JOSM'),(52818808,'created_by','JOSM'),(52818809,'created_by','JOSM'),(52818810,'created_by','JOSM'),(52818812,'created_by','JOSM'),(52818813,'created_by','JOSM'),(52818824,'created_by','JOSM'),(52818840,'created_by','JOSM'),(52818846,'created_by','JOSM'),(52818850,'created_by','JOSM'),(52818853,'created_by','JOSM'),(52818857,'created_by','JOSM'),(52818862,'created_by','JOSM'),(52818864,'created_by','JOSM'),(52818867,'created_by','JOSM'),(52818870,'created_by','JOSM'),(52818872,'created_by','JOSM'),(52818874,'created_by','JOSM'),(52818876,'created_by','JOSM'),(52818878,'created_by','JOSM'),(52818879,'created_by','JOSM'),(52818881,'created_by','JOSM'),(52818884,'created_by','JOSM'),(52824397,'created_by','JOSM'),(52824401,'created_by','JOSM'),(52824404,'created_by','JOSM'),(52824407,'created_by','JOSM'),(52824410,'created_by','JOSM'),(52824414,'created_by','JOSM'),(52824418,'created_by','JOSM'),(52824420,'created_by','JOSM'),(52824423,'created_by','JOSM'),(52824433,'created_by','JOSM'),(52824446,'created_by','JOSM'),(52824449,'created_by','JOSM'),(52824464,'created_by','JOSM'),(52824474,'created_by','JOSM'),(52824478,'created_by','JOSM'),(52824483,'created_by','JOSM'),(52824486,'created_by','JOSM'),(52824489,'created_by','JOSM'),(52824491,'created_by','JOSM'),(52824494,'created_by','JOSM'),(52824496,'created_by','JOSM'),(52824499,'created_by','JOSM'),(52824502,'created_by','JOSM'),(52824509,'created_by','JOSM'),(52824529,'created_by','JOSM'),(52824530,'created_by','JOSM'),(52824533,'created_by','JOSM'),(52824535,'created_by','JOSM'),(52824538,'created_by','JOSM'),(52824541,'created_by','JOSM'),(52824544,'created_by','JOSM'),(52824546,'created_by','JOSM'),(52824548,'created_by','JOSM'),(52824552,'created_by','JOSM'),(52824553,'created_by','JOSM'),(52824558,'created_by','JOSM'),(52824561,'created_by','JOSM'),(52824564,'created_by','JOSM'),(52824567,'created_by','JOSM'),(52824569,'created_by','JOSM'),(52824574,'created_by','JOSM'),(52824576,'created_by','JOSM'),(52824579,'created_by','JOSM'),(52824581,'created_by','JOSM'),(52824584,'created_by','JOSM'),(52824586,'created_by','JOSM'),(52824949,'created_by','JOSM'),(52824952,'created_by','JOSM'),(52824953,'created_by','JOSM'),(52824954,'created_by','JOSM'),(52824955,'created_by','JOSM'),(52831541,'created_by','JOSM'),(52831545,'created_by','JOSM'),(52831548,'created_by','JOSM'),(52831550,'created_by','JOSM'),(52831552,'created_by','JOSM'),(52831554,'created_by','JOSM'),(52831559,'created_by','JOSM'),(52831563,'created_by','JOSM'),(52831566,'created_by','JOSM'),(52831569,'created_by','JOSM'),(52831574,'created_by','JOSM'),(52831577,'created_by','JOSM'),(52831582,'created_by','JOSM'),(52831585,'created_by','JOSM'),(52831588,'created_by','JOSM'),(52831590,'created_by','JOSM'),(52831593,'created_by','JOSM'),(52831595,'created_by','JOSM'),(52831598,'created_by','JOSM'),(52831601,'created_by','JOSM'),(52831603,'created_by','JOSM'),(52831605,'created_by','JOSM'),(52831608,'created_by','JOSM'),(52831611,'created_by','JOSM'),(52831613,'created_by','JOSM'),(52831614,'created_by','JOSM'),(52831615,'created_by','JOSM'),(52831616,'created_by','JOSM'),(52831617,'created_by','JOSM'),(52831618,'created_by','JOSM'),(52831619,'created_by','JOSM'),(52831621,'created_by','JOSM'),(52831641,'created_by','JOSM'),(52831644,'created_by','JOSM'),(52832041,'created_by','JOSM'),(52832042,'created_by','JOSM'),(52832043,'created_by','JOSM'),(52832044,'created_by','JOSM'),(52832045,'created_by','JOSM'),(52832046,'created_by','JOSM'),(52832047,'created_by','JOSM'),(52832471,'created_by','JOSM'),(52834371,'created_by','JOSM'),(52834531,'created_by','JOSM'),(52834678,'created_by','JOSM'),(52834735,'created_by','JOSM'),(52834737,'created_by','JOSM'),(52834749,'created_by','JOSM'),(52834758,'created_by','JOSM'),(52834763,'created_by','JOSM'),(52834768,'created_by','JOSM'),(52834775,'created_by','JOSM'),(52834778,'created_by','JOSM'),(52834779,'created_by','JOSM'),(52834783,'created_by','JOSM'),(52834784,'created_by','JOSM'),(52834785,'created_by','JOSM'),(52834786,'created_by','JOSM'),(52834787,'created_by','JOSM'),(52834788,'created_by','JOSM'),(52834790,'created_by','JOSM'),(52834792,'created_by','JOSM'),(52834794,'created_by','JOSM'),(52834795,'created_by','JOSM'),(52834797,'created_by','JOSM'),(52834799,'created_by','JOSM'),(52834802,'created_by','JOSM'),(52834805,'created_by','JOSM'),(52834808,'created_by','JOSM'),(52834811,'created_by','JOSM'),(52834813,'created_by','JOSM'),(52834816,'created_by','JOSM'),(52834819,'created_by','JOSM'),(52834822,'created_by','JOSM'),(52834825,'created_by','JOSM'),(52835977,'created_by','JOSM'),(52835980,'created_by','JOSM'),(52835984,'created_by','JOSM'),(52835987,'created_by','JOSM'),(52836001,'created_by','JOSM'),(52836004,'created_by','JOSM'),(52836007,'created_by','JOSM'),(52836010,'created_by','JOSM'),(52836012,'created_by','JOSM'),(52836016,'created_by','JOSM'),(52836020,'created_by','JOSM'),(52836023,'created_by','JOSM'),(52836027,'created_by','JOSM'),(52836030,'created_by','JOSM'),(52836034,'created_by','JOSM'),(52836036,'created_by','JOSM'),(52836038,'created_by','JOSM'),(52836042,'created_by','JOSM'),(52836044,'created_by','JOSM'),(52836048,'created_by','JOSM'),(52836052,'created_by','JOSM'),(52836056,'created_by','JOSM'),(52836058,'created_by','JOSM'),(52836061,'created_by','JOSM'),(52836065,'created_by','JOSM'),(52836069,'created_by','JOSM'),(52836073,'created_by','JOSM'),(53273667,'created_by','JOSM'),(53273668,'created_by','JOSM'),(53273669,'created_by','JOSM'),(53273670,'created_by','JOSM'),(53273671,'created_by','JOSM'),(53273672,'created_by','JOSM'),(53273673,'created_by','JOSM'),(53273674,'created_by','JOSM'),(53273675,'created_by','JOSM'),(53273676,'created_by','JOSM'),(53273677,'created_by','JOSM'),(53273678,'created_by','JOSM'),(53273679,'created_by','JOSM'),(53273680,'created_by','JOSM'),(53273681,'created_by','JOSM'),(53273682,'created_by','JOSM'),(53273683,'created_by','JOSM'),(53273684,'created_by','JOSM');
INSERT INTO `current_node_tags` VALUES (53273685,'created_by','JOSM'),(53273686,'created_by','JOSM'),(53273687,'created_by','JOSM'),(53273688,'created_by','JOSM'),(53273689,'created_by','JOSM'),(53273690,'created_by','JOSM'),(53273691,'created_by','JOSM'),(53273692,'created_by','JOSM'),(53273693,'created_by','JOSM'),(53273694,'created_by','JOSM'),(53273695,'created_by','JOSM'),(53273696,'created_by','JOSM'),(53273697,'created_by','JOSM'),(53273698,'created_by','JOSM'),(53273699,'created_by','JOSM'),(53273700,'created_by','JOSM'),(53273701,'created_by','JOSM'),(53273702,'created_by','JOSM'),(53273703,'created_by','JOSM'),(53273704,'created_by','JOSM'),(53273705,'created_by','JOSM'),(53273706,'created_by','JOSM'),(53273707,'created_by','JOSM'),(53273708,'created_by','JOSM'),(53273709,'created_by','JOSM'),(53273710,'created_by','JOSM'),(53273711,'created_by','JOSM'),(53273712,'created_by','JOSM'),(53273713,'created_by','JOSM'),(53273714,'created_by','JOSM'),(53273715,'created_by','JOSM'),(53273716,'created_by','JOSM'),(53273719,'created_by','JOSM'),(53273723,'created_by','JOSM'),(53273724,'created_by','JOSM'),(53273725,'created_by','JOSM'),(53273726,'created_by','JOSM'),(53273727,'created_by','JOSM'),(53273728,'created_by','JOSM'),(53273729,'created_by','JOSM'),(53273730,'created_by','JOSM'),(53273731,'created_by','JOSM'),(53273732,'created_by','JOSM'),(53273733,'created_by','JOSM'),(53273734,'created_by','JOSM'),(53273735,'created_by','JOSM'),(53273736,'created_by','JOSM'),(53273737,'created_by','JOSM'),(53273738,'created_by','JOSM'),(53273739,'created_by','JOSM'),(53273740,'created_by','JOSM'),(53273741,'created_by','JOSM'),(53273742,'created_by','JOSM'),(53273743,'created_by','JOSM'),(53273744,'created_by','JOSM'),(53273745,'created_by','JOSM'),(53273746,'created_by','JOSM'),(53273747,'created_by','JOSM'),(53273748,'created_by','JOSM'),(53273749,'created_by','JOSM'),(53273750,'created_by','JOSM'),(53273751,'created_by','JOSM'),(53273752,'created_by','JOSM'),(53273753,'created_by','JOSM'),(53273754,'created_by','JOSM'),(53273755,'created_by','JOSM'),(53273756,'created_by','JOSM'),(53273757,'created_by','JOSM'),(53273758,'created_by','JOSM'),(53273759,'created_by','JOSM'),(53273760,'created_by','JOSM'),(53273761,'created_by','JOSM'),(53273762,'created_by','JOSM'),(53273763,'created_by','JOSM'),(53273764,'created_by','JOSM'),(53273765,'created_by','JOSM'),(53273766,'created_by','JOSM'),(53273767,'created_by','JOSM'),(53273768,'created_by','JOSM'),(53273769,'created_by','JOSM'),(53273770,'created_by','JOSM'),(53273771,'created_by','JOSM'),(53273772,'created_by','JOSM'),(53273773,'created_by','JOSM'),(53273774,'created_by','JOSM'),(53273775,'created_by','JOSM'),(53273776,'created_by','JOSM'),(53273777,'created_by','JOSM'),(53273778,'created_by','JOSM'),(53273779,'created_by','JOSM'),(53273780,'created_by','JOSM'),(53273781,'created_by','JOSM'),(53273782,'created_by','JOSM'),(53273783,'created_by','JOSM'),(53273784,'created_by','JOSM'),(53273785,'created_by','JOSM'),(53273786,'created_by','JOSM'),(53273787,'created_by','JOSM'),(53273788,'created_by','JOSM'),(53273789,'created_by','JOSM'),(53273790,'created_by','JOSM'),(53273791,'created_by','JOSM'),(53273792,'created_by','JOSM'),(53273793,'created_by','JOSM'),(53273794,'created_by','JOSM'),(53273795,'created_by','JOSM'),(53273796,'created_by','JOSM'),(53273797,'created_by','JOSM'),(53273798,'created_by','JOSM'),(53273799,'created_by','JOSM'),(53273800,'created_by','JOSM'),(53273801,'created_by','JOSM'),(53273802,'created_by','JOSM'),(53273803,'created_by','JOSM'),(53273804,'created_by','JOSM'),(53273805,'created_by','JOSM'),(53273806,'created_by','JOSM'),(53273807,'created_by','JOSM'),(53273808,'created_by','JOSM'),(53273810,'created_by','JOSM'),(53273811,'created_by','JOSM'),(53273812,'created_by','JOSM'),(53273813,'created_by','JOSM'),(53273814,'created_by','JOSM'),(53273815,'created_by','JOSM'),(53273816,'created_by','JOSM'),(53273817,'created_by','JOSM'),(53273818,'created_by','JOSM'),(53273819,'created_by','JOSM'),(53273820,'created_by','JOSM'),(53273821,'created_by','JOSM'),(53273822,'created_by','JOSM'),(53273823,'created_by','JOSM'),(53273824,'created_by','JOSM'),(53273825,'created_by','JOSM'),(53273826,'created_by','JOSM'),(53273827,'created_by','JOSM'),(53273828,'created_by','JOSM'),(53273829,'created_by','JOSM'),(53273830,'created_by','JOSM'),(53273831,'created_by','JOSM'),(53273832,'created_by','JOSM'),(53273833,'created_by','JOSM'),(53273834,'created_by','JOSM'),(53273836,'created_by','JOSM'),(53273838,'created_by','JOSM'),(53273839,'created_by','JOSM'),(53273841,'created_by','JOSM'),(53273843,'created_by','JOSM'),(53273844,'created_by','JOSM'),(53273846,'created_by','JOSM'),(53273848,'created_by','JOSM'),(53273849,'created_by','JOSM'),(53273851,'created_by','JOSM'),(53273852,'created_by','JOSM'),(53273853,'created_by','JOSM'),(53273854,'created_by','JOSM'),(53273855,'created_by','JOSM'),(53273856,'created_by','JOSM'),(53273857,'created_by','JOSM'),(53273858,'created_by','JOSM'),(53273859,'created_by','JOSM'),(53273860,'created_by','JOSM'),(53273861,'created_by','JOSM'),(53273862,'created_by','JOSM'),(53273863,'created_by','JOSM'),(53273864,'created_by','JOSM'),(53273865,'created_by','JOSM'),(53273866,'created_by','JOSM'),(53273867,'created_by','JOSM'),(53273868,'created_by','JOSM'),(53273869,'created_by','JOSM'),(53273870,'created_by','JOSM'),(53273871,'created_by','JOSM'),(53273872,'created_by','JOSM'),(53273873,'created_by','JOSM'),(53273874,'created_by','JOSM'),(53273875,'created_by','JOSM'),(53273876,'created_by','JOSM'),(53273877,'created_by','JOSM'),(53273878,'created_by','JOSM'),(53273879,'created_by','JOSM'),(53273880,'created_by','JOSM'),(53273881,'created_by','JOSM'),(53273882,'created_by','JOSM'),(53273883,'created_by','JOSM'),(53273884,'created_by','JOSM'),(53273885,'created_by','JOSM'),(53273886,'created_by','JOSM'),(53273887,'created_by','JOSM'),(53273888,'created_by','JOSM'),(53273889,'created_by','JOSM'),(53273890,'created_by','JOSM'),(53273891,'created_by','JOSM'),(53273892,'created_by','JOSM'),(53273893,'created_by','JOSM'),(53273894,'created_by','JOSM'),(53273895,'created_by','JOSM'),(53273896,'created_by','JOSM'),(53273897,'created_by','JOSM'),(53273898,'created_by','JOSM'),(53273899,'created_by','JOSM'),(53273900,'created_by','JOSM'),(53273901,'created_by','JOSM'),(53273902,'created_by','JOSM'),(53273903,'created_by','JOSM'),(53273904,'created_by','JOSM'),(53273905,'created_by','JOSM'),(53273906,'created_by','JOSM'),(53273907,'created_by','JOSM'),(53273908,'created_by','JOSM'),(53273909,'created_by','JOSM'),(53273910,'created_by','JOSM'),(53273911,'created_by','JOSM'),(53273912,'created_by','JOSM'),(53273913,'created_by','JOSM'),(53273914,'created_by','JOSM'),(53273915,'created_by','JOSM'),(53273916,'created_by','JOSM'),(53273917,'created_by','JOSM'),(53273918,'created_by','JOSM'),(53273919,'created_by','JOSM'),(53273920,'created_by','JOSM'),(53273921,'created_by','JOSM'),(53273922,'created_by','JOSM'),(53273923,'created_by','JOSM'),(53273924,'created_by','JOSM'),(53273925,'created_by','JOSM'),(53273926,'created_by','JOSM'),(53273927,'created_by','JOSM'),(53273928,'created_by','JOSM'),(53273929,'created_by','JOSM'),(53273930,'created_by','JOSM'),(53273931,'created_by','JOSM'),(53273932,'created_by','JOSM'),(53273933,'created_by','JOSM'),(53273934,'created_by','JOSM'),(53273935,'created_by','JOSM'),(53273936,'created_by','JOSM'),(53273937,'created_by','JOSM'),(53273938,'created_by','JOSM'),(53273939,'created_by','JOSM'),(53273940,'created_by','JOSM'),(53273941,'created_by','JOSM'),(53273942,'created_by','JOSM'),(53273943,'created_by','JOSM'),(53273944,'created_by','JOSM'),(53273945,'created_by','JOSM'),(53273946,'created_by','JOSM'),(53273947,'created_by','JOSM'),(53273948,'created_by','JOSM'),(53273949,'created_by','JOSM'),(53273950,'created_by','JOSM'),(53273951,'created_by','JOSM'),(53273952,'created_by','JOSM'),(53273953,'created_by','JOSM'),(53273954,'created_by','JOSM'),(53273955,'created_by','JOSM'),(53273956,'created_by','JOSM'),(53273957,'created_by','JOSM'),(53273958,'created_by','JOSM'),(53273959,'created_by','JOSM'),(53273960,'created_by','JOSM'),(53273961,'created_by','JOSM'),(53273962,'created_by','JOSM'),(53273963,'created_by','JOSM'),(53273964,'created_by','JOSM'),(53273965,'created_by','JOSM'),(53273966,'created_by','JOSM'),(53273967,'created_by','JOSM'),(53273968,'created_by','JOSM'),(53273969,'created_by','JOSM'),(53273970,'created_by','JOSM'),(53273971,'created_by','JOSM'),(53273972,'created_by','JOSM'),(53273973,'created_by','JOSM'),(53273974,'created_by','JOSM'),(53273975,'created_by','JOSM'),(53273976,'created_by','JOSM'),(53273977,'created_by','JOSM'),(53273978,'created_by','JOSM'),(53273979,'created_by','JOSM'),(53273980,'created_by','JOSM'),(53273981,'created_by','JOSM'),(53273982,'created_by','JOSM'),(53273983,'created_by','JOSM'),(53273984,'created_by','JOSM'),(53273985,'created_by','JOSM'),(53273986,'created_by','JOSM'),(53273987,'created_by','JOSM'),(53273988,'created_by','JOSM'),(53273989,'created_by','JOSM'),(53273990,'created_by','JOSM'),(53273991,'created_by','JOSM'),(53273992,'created_by','JOSM'),(53273993,'created_by','JOSM'),(53273994,'created_by','JOSM'),(53273995,'created_by','JOSM'),(53273996,'created_by','JOSM'),(53273997,'created_by','JOSM'),(53273998,'created_by','JOSM'),(53274000,'created_by','JOSM'),(53274002,'created_by','JOSM'),(53274003,'created_by','JOSM'),(53274004,'created_by','JOSM'),(53274005,'created_by','JOSM'),(53274006,'created_by','JOSM'),(53274007,'created_by','JOSM'),(53274008,'created_by','JOSM'),(53274009,'created_by','JOSM'),(53274010,'created_by','JOSM'),(53274011,'created_by','JOSM'),(53274012,'created_by','JOSM'),(53274013,'created_by','JOSM'),(53274014,'created_by','JOSM'),(53274015,'created_by','JOSM'),(53274016,'created_by','JOSM'),(53274017,'created_by','JOSM'),(53274018,'created_by','JOSM'),(53274019,'created_by','JOSM'),(53274020,'created_by','JOSM'),(53274021,'created_by','JOSM'),(53274022,'created_by','JOSM'),(53274023,'created_by','JOSM'),(53274024,'created_by','JOSM'),(53274025,'created_by','JOSM'),(53274026,'created_by','JOSM'),(53274027,'created_by','JOSM'),(53274028,'created_by','JOSM'),(53274029,'created_by','JOSM'),(53274030,'created_by','JOSM'),(53274031,'created_by','JOSM'),(53274883,'created_by','JOSM'),(53274884,'created_by','JOSM'),(53274885,'created_by','JOSM'),(53274886,'created_by','JOSM'),(53274888,'created_by','JOSM'),(53274890,'created_by','JOSM'),(53274891,'created_by','JOSM'),(53274892,'created_by','JOSM'),(53274893,'created_by','JOSM'),(53274894,'created_by','JOSM'),(53274895,'created_by','JOSM'),(53274896,'created_by','JOSM'),(53274898,'created_by','JOSM'),(53274899,'created_by','JOSM'),(53274900,'created_by','JOSM'),(53274901,'created_by','JOSM'),(53274902,'created_by','JOSM'),(53274903,'created_by','JOSM'),(53274904,'created_by','JOSM'),(53274906,'created_by','JOSM'),(53274907,'created_by','JOSM'),(53274908,'created_by','JOSM'),(53274909,'created_by','JOSM'),(53274910,'created_by','JOSM'),(53274911,'created_by','JOSM'),(53274912,'created_by','JOSM'),(53274913,'created_by','JOSM'),(53274915,'created_by','JOSM'),(53274916,'created_by','JOSM'),(53274917,'created_by','JOSM'),(53274918,'created_by','JOSM'),(53274919,'created_by','JOSM'),(53274920,'created_by','JOSM'),(53274921,'created_by','JOSM'),(53274922,'created_by','JOSM'),(53274924,'created_by','JOSM'),(53274925,'created_by','JOSM'),(53274926,'created_by','JOSM'),(53274927,'created_by','JOSM'),(53274928,'created_by','JOSM'),(53274929,'created_by','JOSM'),(53274931,'created_by','JOSM'),(53274932,'created_by','JOSM'),(53274933,'created_by','JOSM'),(53274934,'created_by','JOSM'),(53274935,'created_by','JOSM'),(53274936,'created_by','JOSM'),(53274937,'created_by','JOSM'),(53274939,'created_by','JOSM'),(53274940,'created_by','JOSM'),(53274941,'created_by','JOSM'),(53274942,'created_by','JOSM'),(53274943,'created_by','JOSM'),(53274944,'created_by','JOSM'),(53274946,'created_by','JOSM'),(53274947,'created_by','JOSM'),(53274948,'created_by','JOSM'),(53274949,'created_by','JOSM'),(53274950,'created_by','JOSM'),(53274951,'created_by','JOSM'),(53274952,'created_by','JOSM'),(53274954,'created_by','JOSM'),(53274955,'created_by','JOSM'),(53274956,'created_by','JOSM'),(53274957,'created_by','JOSM'),(53274958,'created_by','JOSM'),(53274959,'created_by','JOSM'),(53274960,'created_by','JOSM'),(53274961,'created_by','JOSM'),(53274963,'created_by','JOSM'),(53274964,'created_by','JOSM'),(53274965,'created_by','JOSM'),(53274966,'created_by','JOSM'),(53274967,'created_by','JOSM'),(53274972,'created_by','JOSM'),(53274973,'created_by','JOSM'),(53274974,'created_by','JOSM'),(53274976,'created_by','JOSM'),(53274977,'created_by','JOSM'),(53274978,'created_by','JOSM'),(53274979,'created_by','JOSM'),(53274980,'created_by','JOSM'),(53274981,'created_by','JOSM'),(53274983,'created_by','JOSM'),(53274984,'created_by','JOSM'),(53274985,'created_by','JOSM'),(53274986,'created_by','JOSM'),(53274987,'created_by','JOSM'),(53274988,'created_by','JOSM'),(53274989,'created_by','JOSM'),(53274990,'created_by','JOSM'),(53274991,'created_by','JOSM'),(53274992,'created_by','JOSM'),(53274993,'created_by','JOSM'),(53274995,'created_by','JOSM'),(53274996,'created_by','JOSM'),(53274997,'created_by','JOSM'),(53274998,'created_by','JOSM'),(53274999,'created_by','JOSM'),(53275001,'created_by','JOSM'),(53275002,'created_by','JOSM'),(53275003,'created_by','JOSM'),(53275004,'created_by','JOSM'),(53275005,'created_by','JOSM'),(53275006,'created_by','JOSM'),(53275008,'created_by','JOSM'),(53275009,'created_by','JOSM'),(53275010,'created_by','JOSM'),(53275011,'created_by','JOSM'),(53275012,'created_by','JOSM'),(53275014,'created_by','JOSM'),(53275015,'created_by','JOSM'),(53275016,'created_by','JOSM'),(53275017,'created_by','JOSM'),(53275018,'created_by','JOSM'),(53275019,'created_by','JOSM'),(53275020,'created_by','JOSM'),(53275022,'created_by','JOSM'),(53275023,'created_by','JOSM'),(53275024,'created_by','JOSM'),(53275034,'created_by','JOSM'),(53275035,'created_by','JOSM'),(53275036,'created_by','JOSM'),(53275038,'created_by','JOSM'),(53275039,'created_by','JOSM'),(53275040,'created_by','JOSM'),(53275506,'created_by','JOSM'),(53275507,'created_by','JOSM'),(53275508,'created_by','JOSM'),(53275510,'created_by','JOSM'),(53275511,'created_by','JOSM'),(53275512,'created_by','JOSM'),(53275514,'created_by','JOSM'),(53275515,'created_by','JOSM'),(53275516,'created_by','JOSM'),(53275517,'created_by','JOSM'),(53275518,'created_by','JOSM'),(53275519,'created_by','JOSM'),(53275520,'created_by','JOSM'),(53275521,'created_by','JOSM'),(53275522,'created_by','JOSM'),(53275523,'created_by','JOSM'),(53275524,'created_by','JOSM'),(53275525,'created_by','JOSM'),(53275526,'created_by','JOSM'),(53275527,'created_by','JOSM'),(53275528,'created_by','JOSM'),(53275529,'created_by','JOSM'),(53275530,'created_by','JOSM'),(53275531,'created_by','JOSM'),(53275533,'created_by','JOSM'),(53275534,'created_by','JOSM'),(53275535,'created_by','JOSM'),(53275536,'created_by','JOSM'),(53275537,'created_by','JOSM'),(53275538,'created_by','JOSM'),(53275539,'created_by','JOSM'),(53275540,'created_by','JOSM'),(53275541,'created_by','JOSM'),(53275542,'created_by','JOSM'),(53275543,'created_by','JOSM'),(53275544,'created_by','JOSM'),(53275545,'created_by','JOSM'),(53275546,'created_by','JOSM'),(53275547,'created_by','JOSM'),(53275548,'created_by','JOSM'),(53275549,'created_by','JOSM'),(53275550,'created_by','JOSM'),(53275551,'created_by','JOSM'),(53275552,'created_by','JOSM'),(53275554,'created_by','JOSM'),(53275555,'created_by','JOSM'),(53275556,'created_by','JOSM'),(53275557,'created_by','JOSM'),(53275558,'created_by','JOSM'),(53275559,'created_by','JOSM'),(53275560,'created_by','JOSM'),(53275561,'created_by','JOSM'),(53275562,'created_by','JOSM'),(53275563,'created_by','JOSM'),(53275565,'created_by','JOSM'),(53275567,'created_by','JOSM'),(53275568,'created_by','JOSM'),(53275569,'created_by','JOSM'),(53275570,'created_by','JOSM'),(53275572,'created_by','JOSM'),(53275573,'created_by','JOSM'),(53275574,'created_by','JOSM'),(53275575,'created_by','JOSM'),(53275576,'created_by','JOSM'),(53275577,'created_by','JOSM'),(53275578,'created_by','JOSM'),(53275579,'created_by','JOSM'),(53275580,'created_by','JOSM'),(53275581,'created_by','JOSM'),(53275582,'created_by','JOSM'),(53275583,'created_by','JOSM'),(53275584,'created_by','JOSM'),(53275585,'created_by','JOSM'),(53275586,'created_by','JOSM'),(53275587,'created_by','JOSM'),(53275588,'created_by','JOSM'),(53275589,'created_by','JOSM'),(53275590,'created_by','JOSM'),(53275591,'created_by','JOSM'),(53275592,'created_by','JOSM'),(53275593,'created_by','JOSM'),(53275594,'created_by','JOSM'),(53275595,'created_by','JOSM'),(53275596,'created_by','JOSM'),(53275597,'created_by','JOSM'),(53275598,'created_by','JOSM'),(53275599,'created_by','JOSM'),(53275600,'created_by','JOSM'),(53275601,'created_by','JOSM'),(53275602,'created_by','JOSM'),(53275603,'created_by','JOSM'),(53275604,'created_by','JOSM'),(53275605,'created_by','JOSM'),(53275606,'created_by','JOSM'),(53275607,'created_by','JOSM'),(53275608,'created_by','JOSM'),(53275609,'created_by','JOSM'),(53275610,'created_by','JOSM'),(53275611,'created_by','JOSM'),(53275612,'created_by','JOSM'),(53275613,'created_by','JOSM'),(53275614,'created_by','JOSM'),(53275615,'created_by','JOSM'),(53275616,'created_by','JOSM'),(53275617,'created_by','JOSM'),(53275618,'created_by','JOSM'),(53275619,'created_by','JOSM'),(53275620,'created_by','JOSM'),(53275621,'created_by','JOSM'),(53275622,'created_by','JOSM'),(53275623,'created_by','JOSM'),(53275624,'created_by','JOSM'),(53275625,'created_by','JOSM'),(53275626,'created_by','JOSM'),(53275627,'created_by','JOSM'),(53275628,'created_by','JOSM'),(53275629,'created_by','JOSM'),(53275630,'created_by','JOSM'),(53275631,'created_by','JOSM'),(53275632,'created_by','JOSM'),(53275633,'created_by','JOSM'),(53275634,'created_by','JOSM'),(53275635,'created_by','JOSM'),(53275636,'created_by','JOSM'),(53275637,'created_by','JOSM'),(53275638,'created_by','JOSM'),(53275639,'created_by','JOSM'),(53275640,'created_by','JOSM'),(53275642,'created_by','JOSM'),(53275643,'created_by','JOSM'),(53275644,'created_by','JOSM'),(53275645,'created_by','JOSM'),(53275646,'created_by','JOSM'),(53275647,'created_by','JOSM'),(53275648,'created_by','JOSM'),(53275649,'created_by','JOSM'),(53275650,'created_by','JOSM'),(53275651,'created_by','JOSM'),(53275652,'created_by','JOSM'),(53275653,'created_by','JOSM'),(53275654,'created_by','JOSM'),(53275655,'created_by','JOSM'),(53275656,'created_by','JOSM'),(53275657,'created_by','JOSM'),(53275658,'created_by','JOSM'),(53275659,'created_by','JOSM'),(53275660,'created_by','JOSM'),(53275661,'created_by','JOSM'),(53275662,'created_by','JOSM'),(53275663,'created_by','JOSM'),(53275664,'created_by','JOSM'),(53275665,'created_by','JOSM'),(53275666,'created_by','JOSM'),(53275667,'created_by','JOSM'),(53275668,'created_by','JOSM'),(53275669,'created_by','JOSM'),(53275670,'created_by','JOSM'),(53277160,'created_by','JOSM'),(53277161,'created_by','JOSM'),(53277162,'created_by','JOSM'),(53277163,'created_by','JOSM'),(53277164,'created_by','JOSM'),(53277165,'created_by','JOSM'),(53277166,'created_by','JOSM'),(53277167,'created_by','JOSM'),(53277168,'created_by','JOSM'),(53277169,'created_by','JOSM'),(53277170,'created_by','JOSM'),(53277171,'created_by','JOSM'),(53277172,'created_by','JOSM'),(53277173,'created_by','JOSM'),(53277174,'created_by','JOSM'),(53277175,'created_by','JOSM'),(53277176,'created_by','JOSM'),(53277177,'created_by','JOSM'),(53277178,'created_by','JOSM'),(53277179,'created_by','JOSM'),(53277180,'created_by','JOSM'),(53277181,'created_by','JOSM'),(53277182,'created_by','JOSM'),(53277183,'created_by','JOSM'),(53277184,'created_by','JOSM'),(53277185,'created_by','JOSM'),(53277186,'created_by','JOSM'),(53277187,'created_by','JOSM'),(53277189,'created_by','JOSM'),(53277190,'created_by','JOSM'),(53277191,'created_by','JOSM'),(53277192,'created_by','JOSM'),(53277193,'created_by','JOSM'),(53277194,'created_by','JOSM'),(53277195,'created_by','JOSM'),(53277196,'created_by','JOSM'),(53277197,'created_by','JOSM'),(53277198,'created_by','JOSM'),(53277199,'created_by','JOSM'),(53277200,'created_by','JOSM'),(53277201,'created_by','JOSM'),(53277202,'created_by','JOSM'),(53277203,'created_by','JOSM'),(53277204,'created_by','JOSM'),(53277205,'created_by','JOSM'),(53277206,'created_by','JOSM'),(53277207,'created_by','JOSM'),(53277208,'created_by','JOSM'),(53277209,'created_by','JOSM'),(53277210,'created_by','JOSM'),(53277211,'created_by','JOSM'),(53277212,'created_by','JOSM'),(53277213,'created_by','JOSM'),(53277214,'created_by','JOSM'),(53277215,'created_by','JOSM'),(53277216,'created_by','JOSM'),(53277217,'created_by','JOSM'),(53277218,'created_by','JOSM'),(53277219,'created_by','JOSM'),(53277220,'created_by','JOSM'),(53277221,'created_by','JOSM'),(53277222,'created_by','JOSM'),(53277223,'created_by','JOSM'),(53277224,'created_by','JOSM'),(53277225,'created_by','JOSM'),(53277226,'created_by','JOSM'),(53277227,'created_by','JOSM'),(53277228,'created_by','JOSM'),(53277229,'created_by','JOSM'),(53277230,'created_by','JOSM'),(53277231,'created_by','JOSM'),(53277232,'created_by','JOSM'),(53277233,'created_by','JOSM'),(53277234,'created_by','JOSM'),(53277235,'created_by','JOSM'),(53277236,'created_by','JOSM'),(53277237,'created_by','JOSM'),(53277238,'created_by','JOSM'),(53277239,'created_by','JOSM'),(53277240,'created_by','JOSM'),(53277241,'created_by','JOSM'),(53277242,'created_by','JOSM'),(53277243,'created_by','JOSM'),(53277244,'created_by','JOSM'),(53277245,'created_by','JOSM'),(53277246,'created_by','JOSM'),(53277247,'created_by','JOSM'),(53277248,'created_by','JOSM'),(53277249,'created_by','JOSM'),(53277250,'created_by','JOSM'),(53277251,'created_by','JOSM'),(53277252,'created_by','JOSM'),(53277253,'created_by','JOSM'),(53277254,'created_by','JOSM'),(53277255,'created_by','JOSM'),(53277256,'created_by','JOSM'),(53277257,'created_by','JOSM'),(53277258,'created_by','JOSM'),(53277259,'created_by','JOSM'),(53277260,'created_by','JOSM'),(53277261,'created_by','JOSM'),(53277262,'created_by','JOSM'),(53277263,'created_by','JOSM'),(53277264,'created_by','JOSM'),(53277265,'created_by','JOSM'),(53277266,'created_by','JOSM'),(53277267,'created_by','JOSM'),(53277268,'created_by','JOSM'),(53277269,'created_by','JOSM'),(53277270,'created_by','JOSM'),(53277271,'created_by','JOSM'),(53277272,'created_by','JOSM'),(53277273,'created_by','JOSM'),(53277274,'created_by','JOSM'),(53277275,'created_by','JOSM'),(53277276,'created_by','JOSM'),(53277277,'created_by','JOSM'),(53277278,'created_by','JOSM'),(53277279,'created_by','JOSM'),(53277280,'created_by','JOSM'),(53277281,'created_by','JOSM'),(53277282,'created_by','JOSM'),(53277283,'created_by','JOSM'),(53277284,'created_by','JOSM'),(53277285,'created_by','JOSM'),(53277286,'created_by','JOSM'),(53277287,'created_by','JOSM'),(53277288,'created_by','JOSM'),(53277289,'created_by','JOSM'),(53277290,'created_by','JOSM'),(53277291,'created_by','JOSM'),(53277292,'created_by','JOSM'),(53277293,'created_by','JOSM'),(53277294,'created_by','JOSM'),(53277295,'created_by','JOSM'),(53277296,'created_by','JOSM'),(53277297,'created_by','JOSM'),(53277298,'created_by','JOSM'),(53277299,'created_by','JOSM'),(53277300,'created_by','JOSM'),(53277301,'created_by','JOSM'),(53277302,'created_by','JOSM'),(53277303,'created_by','JOSM'),(53277304,'created_by','JOSM'),(53277305,'created_by','JOSM'),(53277306,'created_by','JOSM'),(53277307,'created_by','JOSM'),(53277308,'created_by','JOSM'),(53277309,'created_by','JOSM'),(53277310,'created_by','JOSM'),(53277311,'created_by','JOSM'),(53277312,'created_by','JOSM'),(53277313,'created_by','JOSM'),(53278142,'created_by','JOSM'),(53278144,'created_by','JOSM'),(53278146,'created_by','JOSM'),(53278147,'created_by','JOSM'),(53278148,'created_by','JOSM'),(53278149,'created_by','JOSM'),(53278150,'created_by','JOSM'),(53278151,'created_by','JOSM'),(53278152,'created_by','JOSM'),(53278153,'created_by','JOSM'),(53278154,'created_by','JOSM'),(53278155,'created_by','JOSM'),(53278156,'created_by','JOSM'),(53278157,'created_by','JOSM'),(53278158,'created_by','JOSM'),(53278159,'created_by','JOSM'),(53278160,'created_by','JOSM'),(53278161,'created_by','JOSM'),(53278162,'created_by','JOSM'),(53278163,'created_by','JOSM'),(53278164,'created_by','JOSM'),(53278165,'created_by','JOSM'),(53278166,'created_by','JOSM'),(53278167,'created_by','JOSM'),(53278168,'created_by','JOSM'),(53278173,'created_by','JOSM'),(53278175,'aerialway','station'),(53278176,'created_by','JOSM'),(53278177,'created_by','JOSM'),(53278178,'created_by','JOSM'),(53278179,'created_by','JOSM'),(53278180,'created_by','JOSM'),(53278181,'created_by','JOSM'),(53278182,'created_by','JOSM'),(53278183,'created_by','JOSM'),(53278185,'created_by','JOSM'),(53278186,'created_by','JOSM'),(53278188,'created_by','JOSM'),(53278190,'created_by','JOSM'),(53278192,'created_by','JOSM'),(53278194,'created_by','JOSM'),(53278196,'created_by','JOSM'),(53278197,'created_by','JOSM'),(53278199,'created_by','JOSM'),(53278200,'created_by','JOSM'),(53278201,'created_by','JOSM'),(53278202,'created_by','JOSM'),(53278203,'created_by','JOSM'),(53278204,'created_by','JOSM'),(53278205,'created_by','JOSM'),(53278206,'created_by','JOSM'),(53278207,'created_by','JOSM'),(53278208,'created_by','JOSM'),(53278210,'created_by','JOSM'),(53278211,'created_by','JOSM'),(53278212,'created_by','JOSM'),(53278213,'created_by','JOSM'),(53278214,'created_by','JOSM'),(53278215,'created_by','JOSM'),(53278216,'created_by','JOSM'),(53278217,'created_by','JOSM'),(53278218,'created_by','JOSM'),(53278219,'created_by','JOSM'),(53278220,'created_by','JOSM'),(53278221,'created_by','JOSM'),(53278222,'created_by','JOSM'),(53278223,'created_by','JOSM'),(53278224,'created_by','JOSM'),(53278226,'created_by','JOSM'),(53278232,'created_by','JOSM'),(53278233,'created_by','JOSM'),(53278234,'created_by','JOSM'),(53278235,'created_by','JOSM'),(53278236,'created_by','JOSM'),(53278237,'created_by','JOSM'),(53278238,'created_by','JOSM'),(53278239,'created_by','JOSM'),(53278240,'created_by','JOSM'),(53278241,'created_by','JOSM'),(53278242,'created_by','JOSM'),(53278252,'created_by','JOSM'),(53278253,'created_by','JOSM'),(53278255,'created_by','JOSM'),(53278256,'created_by','JOSM'),(53278257,'created_by','JOSM'),(53278258,'created_by','JOSM'),(53278259,'created_by','JOSM'),(53278261,'created_by','JOSM'),(53278263,'created_by','JOSM'),(53278264,'created_by','JOSM'),(53278265,'created_by','JOSM'),(53278267,'created_by','JOSM'),(53278268,'created_by','JOSM'),(53278269,'created_by','JOSM'),(53278271,'created_by','JOSM'),(53278272,'created_by','JOSM'),(53278273,'created_by','JOSM'),(53278274,'created_by','JOSM'),(53278275,'created_by','JOSM'),(53278276,'created_by','JOSM'),(53278277,'created_by','JOSM'),(53278278,'created_by','JOSM'),(53278280,'created_by','JOSM'),(53278282,'created_by','JOSM'),(53278283,'created_by','JOSM'),(53278285,'created_by','JOSM'),(53278286,'created_by','JOSM'),(53278287,'created_by','JOSM'),(53278289,'created_by','JOSM'),(53278290,'created_by','JOSM'),(53278291,'created_by','JOSM'),(53278292,'created_by','JOSM'),(53278293,'created_by','JOSM'),(53278294,'created_by','JOSM'),(53278296,'created_by','JOSM'),(53278298,'created_by','JOSM'),(53278299,'created_by','JOSM'),(53278301,'created_by','JOSM'),(53278302,'created_by','JOSM'),(53278304,'created_by','JOSM'),(53278305,'created_by','JOSM'),(53278306,'created_by','JOSM'),(53278308,'created_by','JOSM'),(53278309,'created_by','JOSM'),(53278311,'created_by','JOSM'),(53278312,'created_by','JOSM'),(53278314,'created_by','JOSM'),(53278315,'created_by','JOSM'),(53278316,'created_by','JOSM'),(53278317,'created_by','JOSM'),(53278319,'created_by','JOSM'),(53278321,'created_by','JOSM'),(53278324,'created_by','JOSM'),(53278327,'created_by','JOSM'),(53278328,'created_by','JOSM'),(53278330,'created_by','JOSM'),(53278332,'created_by','JOSM'),(53278333,'created_by','JOSM'),(53278336,'created_by','JOSM'),(53278337,'created_by','JOSM'),(53278338,'created_by','JOSM'),(53278341,'created_by','JOSM'),(53278342,'created_by','JOSM'),(53278343,'created_by','JOSM'),(53278346,'created_by','JOSM'),(53278347,'created_by','JOSM'),(53278348,'created_by','JOSM'),(53278350,'created_by','JOSM'),(53278351,'created_by','JOSM'),(53278353,'created_by','JOSM'),(53278355,'created_by','JOSM'),(53278356,'created_by','JOSM'),(53278358,'created_by','JOSM'),(53278360,'created_by','JOSM'),(53278361,'created_by','JOSM'),(53278362,'created_by','JOSM'),(53278364,'created_by','JOSM'),(53278366,'created_by','JOSM'),(53278367,'created_by','JOSM'),(53278368,'created_by','JOSM'),(53278369,'created_by','JOSM'),(53278371,'created_by','JOSM'),(53278374,'created_by','JOSM'),(53278375,'created_by','JOSM'),(53278376,'created_by','JOSM'),(53278377,'created_by','JOSM'),(53278379,'created_by','JOSM'),(53278383,'created_by','JOSM'),(53278387,'created_by','JOSM'),(53278390,'created_by','JOSM'),(53278395,'created_by','JOSM'),(53278401,'created_by','JOSM'),(53278404,'created_by','JOSM'),(53278409,'created_by','JOSM'),(53278412,'created_by','JOSM'),(53278418,'created_by','JOSM'),(53278420,'created_by','JOSM'),(53278423,'created_by','JOSM'),(53278426,'created_by','JOSM'),(53278429,'created_by','JOSM'),(53281369,'created_by','JOSM'),(53281374,'created_by','JOSM'),(53281378,'created_by','JOSM'),(53281382,'created_by','JOSM'),(53281386,'created_by','JOSM'),(53281388,'created_by','JOSM'),(53281393,'created_by','JOSM'),(53281395,'created_by','JOSM'),(53281399,'created_by','JOSM'),(53281402,'created_by','JOSM'),(53281403,'created_by','JOSM'),(53282932,'created_by','JOSM'),(53282936,'created_by','JOSM'),(53282940,'created_by','JOSM'),(53282941,'created_by','JOSM'),(53282943,'created_by','JOSM'),(53282946,'created_by','JOSM'),(53282948,'created_by','JOSM'),(53282950,'created_by','JOSM'),(53282952,'created_by','JOSM'),(53282953,'created_by','JOSM'),(53282957,'created_by','JOSM'),(53282958,'created_by','JOSM'),(53282959,'created_by','JOSM'),(53282960,'created_by','JOSM'),(53282963,'created_by','JOSM'),(53282966,'created_by','JOSM'),(53282968,'created_by','JOSM'),(53282970,'created_by','JOSM'),(53282972,'created_by','JOSM'),(53282974,'created_by','JOSM'),(53282976,'created_by','JOSM'),(53282979,'created_by','JOSM'),(53282983,'created_by','JOSM'),(53282985,'created_by','JOSM'),(53282987,'created_by','JOSM'),(53282989,'created_by','JOSM'),(53282991,'created_by','JOSM'),(53282996,'created_by','JOSM'),(53282998,'created_by','JOSM'),(53283003,'created_by','JOSM'),(53283007,'created_by','JOSM'),(53283011,'created_by','JOSM'),(53288119,'created_by','JOSM'),(53288123,'created_by','JOSM'),(53288126,'created_by','JOSM'),(53288128,'created_by','JOSM'),(53288129,'created_by','JOSM'),(53288131,'created_by','JOSM'),(53288134,'created_by','JOSM'),(53288136,'created_by','JOSM'),(53288138,'created_by','JOSM'),(53288140,'created_by','JOSM'),(53288141,'created_by','JOSM'),(53288143,'created_by','JOSM'),(53288147,'created_by','JOSM'),(53288148,'created_by','JOSM'),(53288150,'created_by','JOSM'),(53288152,'created_by','JOSM'),(53288157,'created_by','JOSM'),(53288160,'created_by','JOSM'),(53288161,'created_by','JOSM'),(53288164,'created_by','JOSM'),(53288166,'created_by','JOSM'),(53288168,'created_by','JOSM'),(53288171,'created_by','JOSM'),(53288173,'created_by','JOSM'),(53288174,'created_by','JOSM'),(53288176,'created_by','JOSM'),(53288178,'created_by','JOSM'),(53288180,'created_by','JOSM'),(53288182,'created_by','JOSM'),(53288184,'created_by','JOSM'),(53288187,'created_by','JOSM'),(53288189,'created_by','JOSM'),(53288191,'created_by','JOSM'),(53288194,'created_by','JOSM'),(53288196,'created_by','JOSM'),(53288198,'created_by','JOSM'),(53288199,'created_by','JOSM'),(53288201,'created_by','JOSM'),(53288203,'created_by','JOSM'),(53288206,'created_by','JOSM'),(53288209,'created_by','JOSM'),(53288210,'created_by','JOSM'),(53288213,'created_by','JOSM'),(53288216,'created_by','JOSM'),(53288219,'created_by','JOSM'),(53288220,'created_by','JOSM'),(53288223,'created_by','JOSM'),(53288225,'created_by','JOSM'),(53288227,'created_by','JOSM'),(53288228,'created_by','JOSM'),(53288229,'created_by','JOSM'),(53288231,'created_by','JOSM'),(53288235,'created_by','JOSM'),(53288238,'created_by','JOSM'),(53288239,'created_by','JOSM'),(53288242,'created_by','JOSM'),(53288245,'created_by','JOSM'),(53288247,'created_by','JOSM'),(53288250,'created_by','JOSM'),(53288253,'created_by','JOSM'),(53288255,'created_by','JOSM'),(53288257,'created_by','JOSM'),(53288259,'created_by','JOSM'),(53288261,'created_by','JOSM'),(53288262,'created_by','JOSM'),(53288263,'created_by','JOSM'),(53288266,'created_by','JOSM'),(53288269,'created_by','JOSM'),(53288271,'created_by','JOSM'),(53288273,'created_by','JOSM'),(53288276,'created_by','JOSM'),(53288278,'created_by','JOSM'),(53288280,'created_by','JOSM'),(53288281,'created_by','JOSM'),(53288282,'created_by','JOSM'),(53288286,'created_by','JOSM'),(53288290,'created_by','JOSM'),(53288292,'created_by','JOSM'),(53288294,'created_by','JOSM'),(53288296,'created_by','JOSM'),(53288298,'created_by','JOSM'),(53288300,'created_by','JOSM'),(53288302,'created_by','JOSM'),(53288303,'created_by','JOSM'),(53288305,'created_by','JOSM'),(53288308,'created_by','JOSM'),(53288309,'created_by','JOSM'),(53288310,'created_by','JOSM'),(53288313,'created_by','JOSM'),(53288317,'created_by','JOSM'),(53288318,'created_by','JOSM'),(53288321,'created_by','JOSM'),(53288323,'created_by','JOSM'),(53288326,'created_by','JOSM'),(53288329,'created_by','JOSM'),(53288332,'created_by','JOSM'),(53288334,'created_by','JOSM'),(53288336,'created_by','JOSM'),(53288338,'created_by','JOSM'),(53288339,'created_by','JOSM'),(53288343,'created_by','JOSM'),(53288346,'created_by','JOSM'),(53288348,'created_by','JOSM'),(53288349,'created_by','JOSM'),(53288350,'created_by','JOSM'),(53288351,'created_by','JOSM'),(53288352,'created_by','JOSM'),(53288353,'created_by','JOSM'),(53288354,'created_by','JOSM'),(53288355,'created_by','JOSM'),(53288356,'created_by','JOSM'),(53288357,'created_by','JOSM'),(53288358,'created_by','JOSM'),(53288360,'created_by','JOSM'),(53288364,'created_by','JOSM'),(53288366,'created_by','JOSM'),(53288368,'created_by','JOSM'),(53288370,'created_by','JOSM'),(53288373,'created_by','JOSM'),(53288375,'created_by','JOSM'),(53288378,'created_by','JOSM'),(53288381,'created_by','JOSM'),(53288383,'created_by','JOSM'),(53288388,'created_by','JOSM'),(53288391,'created_by','JOSM'),(53288393,'created_by','JOSM'),(53288394,'created_by','JOSM'),(53288396,'created_by','JOSM'),(53288399,'created_by','JOSM'),(53288402,'created_by','JOSM'),(53288403,'created_by','JOSM'),(53288404,'created_by','JOSM'),(53288407,'created_by','JOSM'),(53288410,'created_by','JOSM'),(53288413,'created_by','JOSM'),(53288419,'created_by','JOSM'),(53292901,'created_by','JOSM'),(53292938,'created_by','JOSM'),(53292997,'created_by','JOSM'),(53293001,'created_by','JOSM'),(53293003,'created_by','JOSM'),(53293007,'created_by','JOSM'),(53293010,'created_by','JOSM'),(53293011,'created_by','JOSM'),(53293015,'created_by','JOSM'),(53293017,'created_by','JOSM'),(53293018,'created_by','JOSM'),(53293022,'created_by','JOSM'),(53293025,'created_by','JOSM'),(53293027,'created_by','JOSM'),(53293029,'created_by','JOSM'),(53293032,'created_by','JOSM'),(53293034,'created_by','JOSM'),(53293037,'created_by','JOSM'),(53293039,'created_by','JOSM'),(53293043,'created_by','JOSM'),(53293046,'created_by','JOSM'),(53293058,'created_by','JOSM'),(53293060,'created_by','JOSM'),(53293062,'created_by','JOSM'),(53293063,'created_by','JOSM'),(53293066,'created_by','JOSM'),(53293067,'created_by','JOSM'),(53293069,'created_by','JOSM'),(53293073,'created_by','JOSM'),(53293076,'created_by','JOSM'),(53293077,'created_by','JOSM'),(53293080,'created_by','JOSM'),(53293082,'created_by','JOSM'),(53293083,'created_by','JOSM'),(53293087,'created_by','JOSM'),(53293089,'created_by','JOSM'),(53293092,'created_by','JOSM'),(53293095,'created_by','JOSM'),(53293097,'created_by','JOSM'),(53293098,'created_by','JOSM'),(53293102,'created_by','JOSM'),(53293105,'created_by','JOSM'),(53293108,'created_by','JOSM'),(53293109,'created_by','JOSM'),(53293111,'created_by','JOSM'),(53293114,'created_by','JOSM'),(53293117,'created_by','JOSM'),(53293119,'created_by','JOSM'),(53293123,'created_by','JOSM'),(53293124,'created_by','JOSM'),(53293127,'created_by','JOSM'),(53293130,'created_by','JOSM'),(53293132,'created_by','JOSM'),(53293136,'created_by','JOSM'),(53293137,'created_by','JOSM'),(53293142,'created_by','JOSM'),(53293144,'created_by','JOSM'),(53293147,'created_by','JOSM'),(53293148,'created_by','JOSM'),(53293150,'created_by','JOSM'),(53293153,'created_by','JOSM'),(53293155,'created_by','JOSM'),(53293157,'created_by','JOSM'),(53293158,'created_by','JOSM'),(53293162,'created_by','JOSM'),(53293164,'created_by','JOSM'),(53293167,'created_by','JOSM'),(53293169,'created_by','JOSM'),(53293172,'created_by','JOSM'),(53293174,'created_by','JOSM'),(53293177,'created_by','JOSM'),(53293179,'created_by','JOSM'),(53293183,'created_by','JOSM'),(53293185,'created_by','JOSM'),(53293188,'created_by','JOSM'),(53293189,'created_by','JOSM'),(53293192,'created_by','JOSM'),(53293193,'created_by','JOSM'),(53293197,'created_by','JOSM'),(53293198,'created_by','JOSM'),(53293200,'created_by','JOSM'),(53293202,'created_by','JOSM'),(53293205,'created_by','JOSM'),(53293212,'created_by','JOSM'),(53293217,'created_by','JOSM'),(53293220,'created_by','JOSM'),(53293232,'created_by','JOSM'),(53293500,'created_by','JOSM'),(53293505,'created_by','JOSM'),(53293507,'created_by','JOSM'),(53293510,'created_by','JOSM'),(53294141,'created_by','JOSM'),(53294144,'created_by','JOSM'),(53294147,'created_by','JOSM'),(53294149,'created_by','JOSM'),(53294152,'created_by','JOSM'),(53294154,'created_by','JOSM'),(53294157,'created_by','JOSM'),(53294160,'created_by','JOSM'),(53294162,'created_by','JOSM'),(53294165,'created_by','JOSM'),(53294166,'created_by','JOSM'),(53294168,'created_by','JOSM'),(53294169,'created_by','JOSM'),(53294170,'created_by','JOSM'),(53294171,'created_by','JOSM'),(53294174,'created_by','JOSM'),(53294177,'created_by','JOSM'),(53294180,'created_by','JOSM'),(53294181,'created_by','JOSM'),(53294184,'created_by','JOSM'),(53294186,'created_by','JOSM'),(53294189,'created_by','JOSM'),(53294192,'created_by','JOSM'),(53294194,'created_by','JOSM'),(53294195,'created_by','JOSM'),(53294197,'created_by','JOSM'),(53294199,'created_by','JOSM'),(53294202,'created_by','JOSM'),(53294205,'created_by','JOSM'),(53294207,'created_by','JOSM'),(53294209,'created_by','JOSM'),(53294212,'created_by','JOSM'),(53294213,'created_by','JOSM'),(53294215,'created_by','JOSM'),(53294218,'created_by','JOSM'),(53294219,'created_by','JOSM'),(53294221,'created_by','JOSM'),(53294223,'created_by','JOSM'),(53294226,'created_by','JOSM'),(53294228,'created_by','JOSM'),(53294231,'created_by','JOSM'),(53294233,'created_by','JOSM'),(53294235,'created_by','JOSM'),(53294236,'created_by','JOSM'),(53294239,'created_by','JOSM'),(53294241,'created_by','JOSM'),(53294244,'created_by','JOSM'),(53294245,'created_by','JOSM'),(53294248,'created_by','JOSM'),(53294251,'created_by','JOSM'),(53294253,'created_by','JOSM'),(53294255,'created_by','JOSM'),(53294258,'created_by','JOSM'),(53294260,'created_by','JOSM'),(53294262,'created_by','JOSM'),(53294264,'created_by','JOSM'),(53294267,'created_by','JOSM'),(53294268,'created_by','JOSM'),(53294270,'created_by','JOSM'),(53294273,'created_by','JOSM'),(53294277,'created_by','JOSM'),(53294279,'created_by','JOSM'),(53294284,'created_by','JOSM'),(53294285,'created_by','JOSM'),(53294290,'created_by','JOSM'),(53294293,'created_by','JOSM'),(53294297,'created_by','JOSM'),(53294300,'created_by','JOSM'),(53294304,'created_by','JOSM'),(53294308,'created_by','JOSM'),(53294311,'created_by','JOSM'),(53294314,'created_by','JOSM'),(53294317,'created_by','JOSM'),(53294320,'created_by','JOSM'),(53294323,'created_by','JOSM'),(53294327,'created_by','JOSM'),(53294331,'created_by','JOSM'),(53294335,'created_by','JOSM'),(53294337,'created_by','JOSM'),(53294341,'created_by','JOSM'),(53294344,'created_by','JOSM'),(53294347,'created_by','JOSM'),(53294350,'created_by','JOSM'),(53294352,'created_by','JOSM'),(53294354,'created_by','JOSM'),(53294357,'created_by','JOSM'),(53294362,'created_by','JOSM'),(53294364,'created_by','JOSM'),(53294366,'created_by','JOSM'),(53294371,'created_by','JOSM'),(53294374,'created_by','JOSM'),(53294377,'created_by','JOSM'),(53294382,'created_by','JOSM'),(53294385,'created_by','JOSM'),(53294389,'created_by','JOSM'),(53294392,'created_by','JOSM'),(53294394,'created_by','JOSM'),(53294396,'created_by','JOSM'),(53294401,'created_by','JOSM'),(53294404,'created_by','JOSM'),(53294409,'created_by','JOSM'),(53294411,'created_by','JOSM'),(53294416,'created_by','JOSM'),(53294418,'created_by','JOSM'),(53294420,'created_by','JOSM'),(53294423,'created_by','JOSM'),(53294425,'created_by','JOSM'),(53294429,'created_by','JOSM'),(53294430,'created_by','JOSM'),(53294433,'created_by','JOSM'),(53294434,'created_by','JOSM'),(53294436,'created_by','JOSM'),(53294443,'created_by','JOSM'),(53294444,'created_by','JOSM'),(53294448,'created_by','JOSM'),(53294450,'created_by','JOSM'),(53294455,'created_by','JOSM'),(53294458,'created_by','JOSM'),(53294463,'created_by','JOSM'),(53294466,'created_by','JOSM'),(53294469,'created_by','JOSM'),(53294474,'created_by','JOSM'),(53294475,'created_by','JOSM'),(53294479,'created_by','JOSM'),(53294483,'created_by','JOSM'),(53294487,'created_by','JOSM'),(53294490,'created_by','JOSM'),(53294493,'created_by','JOSM'),(53294496,'created_by','JOSM'),(53294500,'created_by','JOSM'),(53294503,'created_by','JOSM'),(53294508,'created_by','JOSM'),(53294512,'created_by','JOSM'),(53294515,'created_by','JOSM'),(53294520,'created_by','JOSM'),(53294523,'created_by','JOSM'),(53294526,'created_by','JOSM'),(53294530,'created_by','JOSM'),(53294531,'created_by','JOSM'),(53294534,'created_by','JOSM'),(53294537,'created_by','JOSM'),(53294540,'created_by','JOSM'),(53294541,'created_by','JOSM'),(53294545,'created_by','JOSM'),(53294548,'created_by','JOSM'),(53294552,'created_by','JOSM'),(53294557,'created_by','JOSM'),(53294560,'created_by','JOSM'),(53294562,'created_by','JOSM'),(53294566,'created_by','JOSM'),(53294570,'created_by','JOSM'),(53294573,'created_by','JOSM'),(53294577,'created_by','JOSM'),(53294581,'created_by','JOSM'),(53294998,'created_by','JOSM'),(53295002,'created_by','JOSM'),(53295004,'created_by','JOSM'),(53295006,'created_by','JOSM'),(53295010,'created_by','JOSM'),(53295011,'created_by','JOSM'),(53295014,'created_by','JOSM'),(53295016,'created_by','JOSM'),(53295019,'created_by','JOSM'),(53295022,'created_by','JOSM'),(53295026,'created_by','JOSM'),(53295029,'created_by','JOSM'),(53295033,'created_by','JOSM'),(53295035,'created_by','JOSM'),(53295038,'created_by','JOSM'),(53295040,'created_by','JOSM'),(53295043,'created_by','JOSM'),(53295045,'created_by','JOSM'),(53295047,'created_by','JOSM'),(53295051,'created_by','JOSM'),(53295054,'created_by','JOSM'),(53295057,'created_by','JOSM'),(53295059,'created_by','JOSM'),(53295063,'created_by','JOSM'),(53295067,'created_by','JOSM'),(53295071,'created_by','JOSM'),(53295073,'created_by','JOSM'),(53295077,'created_by','JOSM'),(53295079,'created_by','JOSM'),(53295083,'created_by','JOSM'),(53295085,'created_by','JOSM'),(53295090,'created_by','JOSM'),(53295093,'created_by','JOSM'),(53295097,'created_by','JOSM'),(53295102,'created_by','JOSM'),(53295103,'created_by','JOSM'),(53295107,'created_by','JOSM'),(53295110,'created_by','JOSM'),(53295113,'created_by','JOSM'),(53295117,'created_by','JOSM'),(53295122,'created_by','JOSM'),(53295125,'created_by','JOSM'),(53295128,'created_by','JOSM'),(53295132,'created_by','JOSM'),(53295133,'created_by','JOSM'),(53295137,'created_by','JOSM'),(53295141,'created_by','JOSM'),(53295143,'created_by','JOSM'),(53295147,'created_by','JOSM'),(53295149,'created_by','JOSM'),(53295153,'created_by','JOSM'),(53295157,'created_by','JOSM'),(53295158,'created_by','JOSM'),(53295161,'created_by','JOSM'),(53295165,'created_by','JOSM'),(53295169,'created_by','JOSM'),(53295172,'created_by','JOSM'),(53295175,'created_by','JOSM'),(53295178,'created_by','JOSM'),(53295182,'created_by','JOSM'),(53295186,'created_by','JOSM'),(53295188,'created_by','JOSM'),(53295190,'created_by','JOSM'),(53295193,'created_by','JOSM'),(53295197,'created_by','JOSM'),(53295202,'created_by','JOSM'),(53295208,'created_by','JOSM'),(53295211,'created_by','JOSM'),(53295218,'created_by','JOSM'),(53295222,'created_by','JOSM'),(53295224,'created_by','JOSM'),(53295228,'created_by','JOSM'),(53295233,'created_by','JOSM'),(53295236,'created_by','JOSM'),(53295241,'created_by','JOSM'),(53295243,'created_by','JOSM'),(53295245,'created_by','JOSM'),(53295249,'created_by','JOSM'),(53295251,'created_by','JOSM'),(53295253,'created_by','JOSM'),(53295257,'created_by','JOSM'),(53306569,'created_by','JOSM'),(53306573,'created_by','JOSM'),(53306575,'created_by','JOSM'),(53306579,'created_by','JOSM'),(53306582,'created_by','JOSM'),(53306585,'created_by','JOSM'),(53306588,'created_by','JOSM'),(53306590,'created_by','JOSM'),(53306592,'created_by','JOSM'),(53306595,'created_by','JOSM'),(53306597,'created_by','JOSM'),(53306600,'created_by','JOSM'),(53306695,'created_by','JOSM'),(53306696,'created_by','JOSM'),(53306764,'created_by','JOSM'),(53306767,'created_by','JOSM'),(53306769,'created_by','JOSM'),(53306771,'created_by','JOSM'),(53306774,'created_by','JOSM'),(53306775,'created_by','JOSM'),(53306778,'created_by','JOSM'),(53306780,'created_by','JOSM'),(53306781,'created_by','JOSM'),(53306782,'created_by','JOSM'),(53306786,'created_by','JOSM'),(53306788,'created_by','JOSM'),(53306789,'created_by','JOSM'),(53306790,'created_by','JOSM'),(53306791,'created_by','JOSM'),(53306792,'created_by','JOSM'),(53306794,'created_by','JOSM'),(53306795,'created_by','JOSM'),(53306796,'created_by','JOSM'),(53306799,'created_by','JOSM'),(53306800,'created_by','JOSM'),(53306803,'created_by','JOSM'),(53306804,'created_by','JOSM'),(53306806,'created_by','JOSM'),(53306808,'created_by','JOSM'),(53306810,'created_by','JOSM'),(53306813,'created_by','JOSM'),(53306814,'created_by','JOSM'),(53306817,'created_by','JOSM'),(53306819,'created_by','JOSM'),(53306821,'created_by','JOSM'),(53306823,'created_by','JOSM'),(53306825,'created_by','JOSM'),(53306828,'created_by','JOSM'),(53306831,'created_by','JOSM'),(53306833,'created_by','JOSM'),(53306836,'created_by','JOSM'),(53306838,'created_by','JOSM'),(53306841,'created_by','JOSM'),(53306843,'created_by','JOSM'),(53306845,'created_by','JOSM'),(53306846,'created_by','JOSM'),(53306848,'created_by','JOSM'),(53306849,'created_by','JOSM'),(53306852,'created_by','JOSM'),(53306853,'created_by','JOSM'),(53306856,'created_by','JOSM'),(53306858,'created_by','JOSM'),(53306862,'created_by','JOSM'),(53306863,'created_by','JOSM'),(53306866,'created_by','JOSM'),(53306869,'created_by','JOSM'),(53306871,'created_by','JOSM'),(53306873,'created_by','JOSM'),(53306874,'created_by','JOSM'),(53306875,'created_by','JOSM'),(53306876,'created_by','JOSM'),(53306878,'created_by','JOSM'),(53306881,'created_by','JOSM'),(53306882,'created_by','JOSM'),(53306885,'created_by','JOSM'),(53306886,'created_by','JOSM'),(53306887,'created_by','JOSM'),(53306888,'created_by','JOSM'),(53306889,'created_by','JOSM'),(53306892,'created_by','JOSM'),(53306893,'created_by','JOSM'),(53306897,'created_by','JOSM'),(53306899,'created_by','JOSM'),(53306901,'created_by','JOSM'),(53306904,'created_by','JOSM'),(53306906,'created_by','JOSM'),(53306907,'created_by','JOSM'),(53306910,'created_by','JOSM'),(53306963,'created_by','JOSM'),(53306966,'created_by','JOSM'),(53306970,'created_by','JOSM'),(53306973,'created_by','JOSM'),(53306975,'created_by','JOSM'),(53306978,'created_by','JOSM'),(53306979,'created_by','JOSM'),(53306983,'created_by','JOSM'),(53306984,'created_by','JOSM'),(53306988,'created_by','JOSM'),(53306989,'created_by','JOSM'),(53306991,'created_by','JOSM'),(53306992,'created_by','JOSM'),(53306994,'created_by','JOSM'),(53309350,'created_by','JOSM'),(53309352,'created_by','JOSM'),(53309354,'created_by','JOSM'),(53309356,'created_by','JOSM'),(53309360,'created_by','JOSM'),(53309365,'created_by','JOSM'),(53309368,'created_by','JOSM'),(53309369,'created_by','JOSM'),(53309370,'created_by','JOSM'),(53309371,'created_by','JOSM'),(53309374,'created_by','JOSM'),(53309376,'created_by','JOSM'),(53309379,'created_by','JOSM'),(53309379,'highway','turning_circle'),(53309380,'created_by','JOSM'),(53309384,'created_by','JOSM'),(53309386,'created_by','JOSM'),(53309389,'created_by','JOSM'),(53309392,'created_by','JOSM'),(53309393,'created_by','JOSM'),(53309395,'created_by','JOSM'),(53309397,'created_by','JOSM'),(53309398,'created_by','JOSM'),(53309400,'created_by','JOSM'),(53309402,'created_by','JOSM'),(53309405,'created_by','JOSM'),(53309407,'created_by','JOSM'),(53309409,'created_by','JOSM'),(53309412,'created_by','JOSM'),(53309414,'created_by','JOSM'),(53309417,'created_by','JOSM'),(53309419,'created_by','JOSM'),(53309421,'created_by','JOSM'),(53309423,'created_by','JOSM'),(53309425,'created_by','JOSM'),(53309427,'created_by','JOSM'),(53309431,'created_by','JOSM'),(53309433,'created_by','JOSM'),(53309436,'created_by','JOSM'),(53309438,'created_by','JOSM'),(53309440,'created_by','JOSM'),(53309443,'created_by','JOSM'),(53309446,'created_by','JOSM'),(53309449,'created_by','JOSM'),(53309453,'created_by','JOSM'),(53309457,'created_by','JOSM'),(53309460,'created_by','JOSM'),(53309462,'created_by','JOSM'),(53309464,'created_by','JOSM'),(53309466,'created_by','JOSM'),(53309469,'created_by','JOSM'),(53309473,'created_by','JOSM'),(53309476,'created_by','JOSM'),(53309477,'created_by','JOSM'),(53309480,'created_by','JOSM'),(53309482,'created_by','JOSM'),(53309483,'created_by','JOSM'),(53309485,'created_by','JOSM'),(53315413,'created_by','JOSM'),(53315705,'created_by','JOSM'),(53315884,'created_by','JOSM'),(53315943,'created_by','JOSM'),(53315948,'created_by','JOSM'),(53315952,'created_by','JOSM'),(53315955,'created_by','JOSM'),(53316065,'created_by','JOSM'),(53316068,'created_by','JOSM'),(53316074,'created_by','JOSM'),(53316105,'created_by','JOSM'),(53319479,'created_by','JOSM'),(53319482,'created_by','JOSM'),(53319484,'created_by','JOSM'),(53319487,'created_by','JOSM'),(53319489,'created_by','JOSM'),(53319514,'created_by','JOSM'),(53319515,'created_by','JOSM'),(53319517,'created_by','JOSM'),(53319520,'created_by','JOSM'),(53319521,'created_by','JOSM'),(53319523,'created_by','JOSM'),(53319525,'created_by','JOSM'),(53319529,'created_by','JOSM'),(53319532,'created_by','JOSM'),(53319535,'created_by','JOSM'),(53319536,'created_by','JOSM'),(53319538,'created_by','JOSM'),(53319539,'created_by','JOSM'),(53319541,'created_by','JOSM'),(53319543,'created_by','JOSM'),(53319545,'created_by','JOSM'),(53319547,'created_by','JOSM'),(53319548,'created_by','JOSM'),(53319551,'created_by','JOSM'),(53319552,'created_by','JOSM'),(53319581,'created_by','JOSM'),(53319582,'created_by','JOSM'),(53319584,'created_by','JOSM'),(53319587,'created_by','JOSM'),(53319589,'created_by','JOSM'),(53319592,'created_by','JOSM'),(53319593,'created_by','JOSM'),(53319596,'created_by','JOSM'),(53319598,'created_by','JOSM'),(53319600,'created_by','JOSM'),(53319601,'created_by','JOSM'),(53319603,'created_by','JOSM'),(53319605,'created_by','JOSM'),(53319607,'created_by','JOSM'),(53319609,'created_by','JOSM'),(53319610,'created_by','JOSM'),(53319611,'created_by','JOSM'),(53319612,'created_by','JOSM'),(53319613,'created_by','JOSM'),(53319616,'created_by','JOSM'),(53319617,'created_by','JOSM'),(53319619,'created_by','JOSM'),(53319621,'created_by','JOSM'),(53319624,'created_by','JOSM'),(53319625,'created_by','JOSM'),(53319627,'created_by','JOSM'),(53319629,'created_by','JOSM'),(53319631,'created_by','JOSM'),(53319632,'created_by','JOSM'),(53319634,'created_by','JOSM'),(53319636,'created_by','JOSM'),(53319638,'created_by','JOSM'),(53319639,'created_by','JOSM'),(53319642,'created_by','JOSM'),(53319643,'created_by','JOSM'),(53319645,'created_by','JOSM'),(53319646,'created_by','JOSM'),(53319648,'created_by','JOSM'),(53319649,'created_by','JOSM'),(53319651,'created_by','JOSM'),(53319652,'created_by','JOSM'),(53319657,'created_by','JOSM'),(53319658,'created_by','JOSM'),(53319659,'created_by','JOSM'),(53319661,'created_by','JOSM'),(53319663,'created_by','JOSM'),(53319664,'created_by','JOSM'),(53319665,'created_by','JOSM'),(53319666,'created_by','JOSM'),(53319667,'created_by','JOSM'),(53319669,'created_by','JOSM'),(53319670,'created_by','JOSM'),(53319672,'created_by','JOSM'),(53319675,'created_by','JOSM'),(53319678,'created_by','JOSM'),(53319681,'created_by','JOSM'),(53319682,'created_by','JOSM'),(53319684,'created_by','JOSM'),(53319686,'created_by','JOSM'),(53319688,'created_by','JOSM'),(53319690,'created_by','JOSM'),(53319693,'created_by','JOSM'),(53319695,'created_by','JOSM'),(53319697,'created_by','JOSM'),(53319700,'created_by','JOSM'),(53319701,'created_by','JOSM'),(53319702,'created_by','JOSM'),(53319703,'created_by','JOSM'),(53319749,'created_by','JOSM'),(53319750,'created_by','JOSM'),(53319752,'created_by','JOSM'),(53319753,'created_by','JOSM'),(53319755,'created_by','JOSM'),(53319756,'created_by','JOSM'),(53319758,'created_by','JOSM'),(53319759,'created_by','JOSM'),(53319761,'created_by','JOSM'),(53319765,'created_by','JOSM'),(53319768,'created_by','JOSM'),(53319770,'created_by','JOSM'),(53319773,'created_by','JOSM'),(53319774,'created_by','JOSM'),(53319777,'created_by','JOSM'),(53319778,'created_by','JOSM'),(53319781,'created_by','JOSM'),(53319782,'created_by','JOSM'),(53319784,'created_by','JOSM'),(53319786,'created_by','JOSM'),(53319789,'created_by','JOSM'),(53319790,'created_by','JOSM'),(53319793,'created_by','JOSM'),(53319796,'created_by','JOSM'),(53319797,'created_by','JOSM'),(53319800,'created_by','JOSM'),(53319801,'created_by','JOSM'),(53319804,'created_by','JOSM'),(53319806,'created_by','JOSM'),(53319807,'created_by','JOSM'),(53319809,'created_by','JOSM'),(53319811,'created_by','JOSM'),(53319813,'created_by','JOSM'),(53319815,'created_by','JOSM'),(53319816,'created_by','JOSM'),(53319817,'created_by','JOSM'),(53319818,'created_by','JOSM'),(53319819,'created_by','JOSM'),(53319820,'created_by','JOSM'),(53319821,'created_by','JOSM'),(53319822,'created_by','JOSM'),(53319823,'created_by','JOSM'),(53319826,'created_by','JOSM'),(53325709,'created_by','JOSM'),(53325711,'created_by','JOSM'),(53325715,'created_by','JOSM'),(53325718,'created_by','JOSM'),(53325720,'created_by','JOSM'),(53325722,'created_by','JOSM'),(53325723,'created_by','JOSM'),(53325724,'created_by','JOSM'),(53325725,'created_by','JOSM'),(53325726,'created_by','JOSM'),(53325729,'created_by','JOSM'),(53325732,'created_by','JOSM'),(53325735,'created_by','JOSM'),(53325736,'created_by','JOSM'),(53325739,'created_by','JOSM'),(53325742,'created_by','JOSM'),(53325743,'created_by','JOSM'),(53325746,'created_by','JOSM'),(53325748,'created_by','JOSM'),(53325750,'created_by','JOSM'),(53325752,'created_by','JOSM'),(53325792,'created_by','JOSM'),(53325795,'created_by','JOSM'),(53325798,'created_by','JOSM'),(53325801,'created_by','JOSM'),(53325802,'created_by','JOSM'),(53325805,'created_by','JOSM'),(53325807,'created_by','JOSM'),(53325809,'created_by','JOSM'),(53325813,'created_by','JOSM'),(53325815,'created_by','JOSM'),(53325817,'created_by','JOSM'),(53325820,'created_by','JOSM'),(53325823,'created_by','JOSM'),(53325827,'created_by','JOSM'),(53325829,'created_by','JOSM'),(53325840,'created_by','JOSM'),(53325843,'created_by','JOSM'),(53325846,'created_by','JOSM'),(53325848,'created_by','JOSM'),(53325850,'created_by','JOSM'),(53327622,'created_by','JOSM'),(53327629,'created_by','JOSM'),(53327630,'created_by','JOSM'),(53327633,'created_by','JOSM'),(53327636,'created_by','JOSM'),(53327637,'created_by','JOSM'),(53327639,'created_by','JOSM'),(53327642,'created_by','JOSM'),(53327646,'created_by','JOSM'),(53327649,'created_by','JOSM'),(53327652,'created_by','JOSM'),(53327654,'created_by','JOSM'),(53327657,'created_by','JOSM'),(53327661,'created_by','JOSM'),(53327664,'created_by','JOSM'),(53327667,'created_by','JOSM'),(53327669,'created_by','JOSM'),(53327672,'created_by','JOSM'),(53327675,'created_by','JOSM'),(53327678,'created_by','JOSM'),(53327682,'created_by','JOSM'),(53327685,'created_by','JOSM'),(53327686,'created_by','JOSM'),(53327689,'created_by','JOSM'),(53327693,'created_by','JOSM'),(53327696,'created_by','JOSM'),(53327697,'created_by','JOSM'),(53327700,'created_by','JOSM'),(53327703,'created_by','JOSM'),(53327705,'created_by','JOSM'),(53327706,'created_by','JOSM'),(53327708,'created_by','JOSM'),(53327710,'created_by','JOSM'),(53327712,'created_by','JOSM'),(53327716,'created_by','JOSM'),(53327717,'created_by','JOSM'),(53327720,'created_by','JOSM'),(53327721,'created_by','JOSM'),(53327724,'created_by','JOSM'),(53327726,'created_by','JOSM'),(53327728,'created_by','JOSM'),(53327730,'created_by','JOSM'),(53327733,'created_by','JOSM'),(53327734,'created_by','JOSM'),(53327735,'created_by','JOSM'),(53327736,'created_by','JOSM'),(53327737,'created_by','JOSM'),(53327738,'created_by','JOSM'),(53327739,'created_by','JOSM'),(53327812,'highway','mini_roundabout'),(53327814,'created_by','JOSM'),(53327815,'created_by','JOSM'),(53327818,'created_by','JOSM'),(53327821,'created_by','JOSM'),(53327824,'created_by','JOSM'),(53327826,'created_by','JOSM'),(53327830,'created_by','JOSM'),(53327833,'created_by','JOSM'),(53327836,'created_by','JOSM'),(53327838,'created_by','JOSM'),(53327844,'created_by','JOSM'),(53327851,'created_by','JOSM'),(53327853,'created_by','JOSM'),(53327855,'created_by','JOSM'),(53327873,'created_by','JOSM'),(53327875,'created_by','JOSM'),(53327877,'created_by','JOSM'),(53327879,'created_by','JOSM'),(53327880,'created_by','JOSM'),(53327882,'created_by','JOSM'),(53330450,'created_by','JOSM'),(53330453,'created_by','JOSM'),(53334410,'created_by','JOSM'),(53334413,'created_by','JOSM'),(53334414,'created_by','JOSM'),(53334417,'created_by','JOSM'),(53334419,'created_by','JOSM'),(53334421,'created_by','JOSM'),(53334422,'created_by','JOSM'),(53334423,'created_by','JOSM'),(53334424,'created_by','JOSM'),(53334427,'created_by','JOSM'),(53334428,'created_by','JOSM'),(53334431,'created_by','JOSM'),(53334432,'created_by','JOSM'),(53334433,'created_by','JOSM'),(53334437,'created_by','JOSM'),(53334441,'created_by','JOSM'),(53334442,'created_by','JOSM'),(53334444,'created_by','JOSM'),(53334448,'created_by','JOSM'),(53335700,'created_by','JOSM'),(53335702,'created_by','JOSM'),(53335703,'created_by','JOSM'),(53335707,'created_by','JOSM'),(53335710,'created_by','JOSM'),(53335714,'created_by','JOSM'),(53335715,'created_by','JOSM'),(53335717,'created_by','JOSM'),(53335718,'created_by','JOSM'),(53335719,'created_by','JOSM'),(53335720,'created_by','JOSM'),(53335721,'created_by','JOSM'),(53335722,'created_by','JOSM'),(53335723,'created_by','JOSM'),(53335724,'created_by','JOSM'),(53335727,'created_by','JOSM'),(53335730,'created_by','JOSM'),(53335733,'created_by','JOSM'),(53335738,'created_by','JOSM'),(53335740,'created_by','JOSM'),(53335742,'created_by','JOSM'),(53335743,'created_by','JOSM'),(53335744,'created_by','JOSM'),(53335745,'created_by','JOSM'),(53335746,'created_by','JOSM'),(53335747,'created_by','JOSM'),(53335750,'created_by','JOSM'),(53335752,'created_by','JOSM'),(53335755,'created_by','JOSM'),(53335756,'created_by','JOSM'),(53335759,'created_by','JOSM'),(53335762,'created_by','JOSM'),(53335764,'created_by','JOSM'),(53335766,'created_by','JOSM'),(53335768,'created_by','JOSM'),(53335771,'created_by','JOSM'),(53335776,'created_by','JOSM'),(53335779,'created_by','JOSM'),(53335782,'created_by','JOSM'),(53335783,'created_by','JOSM'),(53343318,'created_by','JOSM'),(53343339,'created_by','JOSM'),(53343344,'created_by','JOSM'),(53343348,'created_by','JOSM'),(53343353,'created_by','JOSM'),(53343358,'created_by','JOSM'),(53343364,'created_by','JOSM'),(53343367,'created_by','JOSM'),(53343377,'created_by','JOSM'),(53343553,'created_by','JOSM'),(53344982,'created_by','JOSM'),(53350051,'created_by','JOSM'),(53351880,'created_by','JOSM'),(53352405,'created_by','JOSM'),(53352410,'created_by','JOSM'),(53352414,'created_by','JOSM'),(53352419,'created_by','JOSM'),(53352422,'created_by','JOSM'),(53352426,'created_by','JOSM'),(53352429,'created_by','JOSM'),(53352435,'created_by','JOSM'),(53352441,'created_by','JOSM'),(53352444,'created_by','JOSM'),(53352447,'created_by','JOSM'),(53352452,'created_by','JOSM'),(53352461,'created_by','JOSM'),(53352483,'created_by','JOSM'),(53352488,'created_by','JOSM'),(53352494,'created_by','JOSM'),(53352499,'created_by','JOSM'),(53352505,'created_by','JOSM'),(53352508,'created_by','JOSM'),(53352511,'created_by','JOSM'),(53352516,'created_by','JOSM'),(53352521,'created_by','JOSM'),(53352527,'created_by','JOSM'),(53352530,'created_by','JOSM'),(53352537,'created_by','JOSM'),(53352541,'created_by','JOSM'),(53352546,'created_by','JOSM'),(53352552,'created_by','JOSM'),(53352557,'created_by','JOSM'),(53352561,'created_by','JOSM'),(53352568,'created_by','JOSM'),(53352574,'created_by','JOSM'),(53352578,'created_by','JOSM'),(53352584,'created_by','JOSM'),(53352587,'created_by','JOSM'),(53352594,'created_by','JOSM'),(53352599,'created_by','JOSM'),(53352605,'created_by','JOSM'),(53352619,'created_by','JOSM'),(53352632,'created_by','JOSM'),(53352636,'created_by','JOSM'),(53352642,'created_by','JOSM'),(53352645,'created_by','JOSM'),(53352648,'created_by','JOSM'),(53352650,'created_by','JOSM'),(53352704,'created_by','JOSM'),(53352708,'created_by','JOSM'),(53352723,'created_by','JOSM'),(53352737,'created_by','JOSM'),(53352766,'created_by','JOSM'),(53352774,'created_by','JOSM'),(53352779,'created_by','JOSM'),(53352796,'created_by','JOSM'),(53352802,'created_by','JOSM'),(53352807,'created_by','JOSM'),(53352812,'created_by','JOSM'),(53352849,'created_by','JOSM'),(53352853,'created_by','JOSM'),(53352860,'created_by','JOSM'),(53352863,'created_by','JOSM'),(53352868,'created_by','JOSM'),(53352871,'created_by','JOSM'),(53352873,'created_by','JOSM'),(53352876,'created_by','JOSM'),(53352878,'created_by','JOSM'),(53352883,'created_by','JOSM'),(53352887,'created_by','JOSM'),(53352890,'created_by','JOSM'),(53352894,'created_by','JOSM'),(53352896,'created_by','JOSM'),(53352899,'created_by','JOSM'),(53352904,'created_by','JOSM'),(53352906,'created_by','JOSM'),(53352907,'created_by','JOSM'),(53352912,'created_by','JOSM'),(53352934,'created_by','JOSM'),(53352938,'created_by','JOSM'),(53352942,'created_by','JOSM'),(53352946,'created_by','JOSM'),(53352948,'created_by','JOSM'),(53352951,'created_by','JOSM'),(53352954,'created_by','JOSM'),(53352957,'created_by','JOSM'),(53352960,'created_by','JOSM'),(53352963,'created_by','JOSM'),(53352966,'created_by','JOSM'),(53352969,'created_by','JOSM'),(53352974,'created_by','JOSM'),(53352975,'created_by','JOSM'),(53353016,'created_by','JOSM'),(53353021,'created_by','JOSM'),(53353024,'created_by','JOSM'),(53353034,'created_by','JOSM'),(53353040,'created_by','JOSM'),(53353043,'created_by','JOSM'),(53353047,'created_by','JOSM'),(53353051,'created_by','JOSM'),(53353055,'created_by','JOSM'),(53353086,'created_by','JOSM'),(53353092,'created_by','JOSM'),(53353108,'created_by','JOSM');
INSERT INTO `current_node_tags` VALUES (53353111,'created_by','JOSM'),(53353121,'created_by','JOSM'),(53353126,'created_by','JOSM'),(53353132,'created_by','JOSM'),(53353141,'created_by','JOSM'),(53353144,'created_by','JOSM'),(53353148,'created_by','JOSM'),(53353151,'created_by','JOSM'),(53353155,'created_by','JOSM'),(53353160,'created_by','JOSM'),(53353163,'created_by','JOSM'),(53353167,'created_by','JOSM'),(53353170,'created_by','JOSM'),(53353174,'created_by','JOSM'),(53353179,'created_by','JOSM'),(53353181,'created_by','JOSM'),(53353183,'created_by','JOSM'),(53353186,'created_by','JOSM'),(53353189,'created_by','JOSM'),(53353193,'created_by','JOSM'),(53353198,'created_by','JOSM'),(53353199,'created_by','JOSM'),(53353203,'created_by','JOSM'),(53353205,'created_by','JOSM'),(53353208,'created_by','JOSM'),(53353211,'created_by','JOSM'),(53353223,'created_by','JOSM'),(53353237,'created_by','JOSM'),(53353302,'created_by','JOSM'),(53353307,'created_by','JOSM'),(53353314,'created_by','JOSM'),(53353319,'created_by','JOSM'),(53353324,'created_by','JOSM'),(53353328,'created_by','JOSM'),(53353333,'created_by','JOSM'),(53353340,'created_by','JOSM'),(53353343,'created_by','JOSM'),(53353345,'created_by','JOSM'),(53353350,'created_by','JOSM'),(53353359,'created_by','JOSM'),(53353366,'created_by','JOSM'),(53353369,'created_by','JOSM'),(53353372,'created_by','JOSM'),(53353375,'created_by','JOSM'),(53353383,'created_by','JOSM'),(53353388,'created_by','JOSM'),(53353391,'created_by','JOSM'),(53353393,'created_by','JOSM'),(53353395,'created_by','JOSM'),(53353404,'created_by','JOSM'),(53353407,'created_by','JOSM'),(53353413,'created_by','JOSM'),(53353421,'created_by','JOSM'),(53353427,'created_by','JOSM'),(53353431,'created_by','JOSM'),(53353435,'created_by','JOSM'),(53368899,'created_by','JOSM'),(53368914,'created_by','JOSM'),(53368932,'created_by','JOSM'),(53368942,'created_by','JOSM'),(53368953,'created_by','JOSM'),(53368973,'created_by','JOSM'),(53368998,'created_by','JOSM'),(53369007,'created_by','JOSM'),(53369015,'created_by','JOSM'),(53369038,'created_by','JOSM'),(53370808,'created_by','JOSM'),(53370819,'created_by','JOSM'),(53370838,'created_by','JOSM'),(53370844,'created_by','JOSM'),(53370871,'created_by','JOSM'),(53370880,'created_by','JOSM'),(53370887,'created_by','JOSM'),(53370890,'created_by','JOSM'),(53370895,'created_by','JOSM'),(53370900,'created_by','JOSM'),(53370906,'created_by','JOSM'),(53370914,'created_by','JOSM'),(53370920,'created_by','JOSM'),(53370935,'created_by','JOSM'),(53370942,'created_by','JOSM'),(53370949,'created_by','JOSM'),(53370956,'created_by','JOSM'),(53370959,'created_by','JOSM'),(53371037,'created_by','JOSM'),(53371050,'created_by','JOSM'),(53371067,'created_by','JOSM'),(53371073,'created_by','JOSM'),(53371079,'created_by','JOSM'),(53371084,'created_by','JOSM'),(53371089,'created_by','JOSM'),(53371093,'created_by','JOSM'),(53371101,'created_by','JOSM'),(53371106,'created_by','JOSM'),(53371115,'created_by','JOSM'),(53371121,'created_by','JOSM'),(53371129,'created_by','JOSM'),(53371134,'created_by','JOSM'),(53371138,'created_by','JOSM'),(53371141,'created_by','JOSM'),(53371144,'created_by','JOSM'),(53371154,'created_by','JOSM'),(53371160,'created_by','JOSM'),(53371174,'created_by','JOSM'),(53371181,'created_by','JOSM'),(53371551,'created_by','JOSM'),(53371691,'created_by','JOSM'),(53371748,'created_by','JOSM'),(53371756,'created_by','JOSM'),(53371761,'created_by','JOSM'),(53371763,'created_by','JOSM'),(53371771,'created_by','JOSM'),(53371778,'created_by','JOSM'),(53371784,'created_by','JOSM'),(53371787,'created_by','JOSM'),(53371793,'created_by','JOSM'),(53371799,'created_by','JOSM'),(53371804,'created_by','JOSM'),(53371810,'created_by','JOSM'),(53371816,'created_by','JOSM'),(53371823,'created_by','JOSM'),(53371827,'created_by','JOSM'),(53371833,'created_by','JOSM'),(53371840,'created_by','JOSM'),(53371845,'created_by','JOSM'),(53371850,'created_by','JOSM'),(53371856,'created_by','JOSM'),(53371859,'created_by','JOSM'),(53371862,'created_by','JOSM'),(53371868,'created_by','JOSM'),(53371873,'created_by','JOSM'),(53371881,'created_by','JOSM'),(53371890,'created_by','JOSM'),(53371908,'created_by','JOSM'),(53371942,'created_by','JOSM'),(53371951,'created_by','JOSM'),(53371955,'created_by','JOSM'),(53371958,'created_by','JOSM'),(53371963,'created_by','JOSM'),(53371969,'created_by','JOSM'),(53371993,'created_by','JOSM'),(53371998,'created_by','JOSM'),(53372005,'created_by','JOSM'),(53372015,'created_by','JOSM'),(53372021,'created_by','JOSM'),(53372044,'created_by','JOSM'),(53372056,'created_by','JOSM'),(53372063,'created_by','JOSM'),(53372072,'created_by','JOSM'),(53372078,'created_by','JOSM'),(53372086,'created_by','JOSM'),(53372094,'created_by','JOSM'),(53372108,'created_by','JOSM'),(53372121,'created_by','JOSM'),(53372132,'created_by','JOSM'),(53372138,'created_by','JOSM'),(53372143,'created_by','JOSM'),(53372151,'created_by','JOSM'),(53372163,'created_by','JOSM'),(53372180,'created_by','JOSM'),(53372190,'created_by','JOSM'),(53372197,'created_by','JOSM'),(53372208,'created_by','JOSM'),(53372217,'created_by','JOSM'),(53372225,'created_by','JOSM'),(53372232,'created_by','JOSM'),(53372242,'created_by','JOSM'),(53372246,'created_by','JOSM'),(53372255,'created_by','JOSM'),(53372261,'created_by','JOSM'),(53372271,'created_by','JOSM'),(53372278,'created_by','JOSM'),(53372284,'created_by','JOSM'),(53372290,'created_by','JOSM'),(53372297,'created_by','JOSM'),(53372305,'created_by','JOSM'),(53372352,'created_by','JOSM'),(53372357,'created_by','JOSM'),(53372365,'created_by','JOSM'),(53372381,'created_by','JOSM'),(53372404,'created_by','JOSM'),(53372410,'created_by','JOSM'),(53372412,'created_by','JOSM'),(53372413,'created_by','JOSM'),(53372418,'created_by','JOSM'),(53372422,'created_by','JOSM'),(53372427,'created_by','JOSM'),(53372432,'created_by','JOSM'),(53372437,'created_by','JOSM'),(53372442,'created_by','JOSM'),(53372446,'created_by','JOSM'),(53372456,'created_by','JOSM'),(53372458,'created_by','JOSM'),(53372462,'created_by','JOSM'),(53372466,'created_by','JOSM'),(53372476,'created_by','JOSM'),(53372487,'created_by','JOSM'),(53372493,'created_by','JOSM'),(53372501,'created_by','JOSM'),(53372509,'created_by','JOSM'),(53372513,'created_by','JOSM'),(53372518,'created_by','JOSM'),(53372522,'created_by','JOSM'),(53372527,'created_by','JOSM'),(53372535,'created_by','JOSM'),(53372541,'created_by','JOSM'),(53372544,'created_by','JOSM'),(53372549,'created_by','JOSM'),(53372555,'created_by','JOSM'),(53372562,'created_by','JOSM'),(53372568,'created_by','JOSM'),(53372577,'created_by','JOSM'),(53372587,'created_by','JOSM'),(53372608,'created_by','JOSM'),(53372614,'created_by','JOSM'),(53372629,'created_by','JOSM'),(53372637,'created_by','JOSM'),(53372777,'created_by','JOSM'),(53372794,'created_by','JOSM'),(53372806,'created_by','JOSM'),(53372815,'created_by','JOSM'),(53372828,'created_by','JOSM'),(53372832,'created_by','JOSM'),(53372838,'created_by','JOSM'),(53372843,'created_by','JOSM'),(53372852,'created_by','JOSM'),(53372858,'created_by','JOSM'),(53372863,'created_by','JOSM'),(53372873,'created_by','JOSM'),(53372879,'created_by','JOSM'),(53372887,'created_by','JOSM'),(53372892,'created_by','JOSM'),(53372903,'created_by','JOSM'),(53372912,'created_by','JOSM'),(53372917,'created_by','JOSM'),(53372927,'created_by','JOSM'),(53372935,'created_by','JOSM'),(53372942,'created_by','JOSM'),(53372956,'created_by','JOSM'),(53372965,'created_by','JOSM'),(53372978,'created_by','JOSM'),(53372982,'created_by','JOSM'),(53372991,'created_by','JOSM'),(53373005,'created_by','JOSM'),(53373016,'created_by','JOSM'),(53373029,'created_by','JOSM'),(53373035,'created_by','JOSM'),(53373049,'created_by','JOSM'),(53373068,'created_by','JOSM'),(53373079,'created_by','JOSM'),(53373094,'created_by','JOSM'),(53373107,'created_by','JOSM'),(53373114,'created_by','JOSM'),(53373121,'created_by','JOSM'),(53373130,'created_by','JOSM'),(53373163,'created_by','JOSM'),(53373182,'created_by','JOSM'),(53373197,'created_by','JOSM'),(53373203,'created_by','JOSM'),(53373215,'created_by','JOSM'),(53373224,'created_by','JOSM'),(53373230,'created_by','JOSM'),(53373233,'created_by','JOSM'),(53373241,'created_by','JOSM'),(53373246,'created_by','JOSM'),(53373251,'created_by','JOSM'),(53373259,'created_by','JOSM'),(53373266,'created_by','JOSM'),(53373270,'created_by','JOSM'),(53373275,'created_by','JOSM'),(53373280,'created_by','JOSM'),(53373289,'created_by','JOSM'),(53373297,'created_by','JOSM'),(53373303,'created_by','JOSM'),(53373308,'created_by','JOSM'),(53373311,'created_by','JOSM'),(53373318,'created_by','JOSM'),(53373327,'created_by','JOSM'),(53373335,'created_by','JOSM'),(53373343,'created_by','JOSM'),(53373348,'created_by','JOSM'),(53373356,'created_by','JOSM'),(53373365,'created_by','JOSM'),(53373376,'created_by','JOSM'),(53373382,'created_by','JOSM'),(53373386,'created_by','JOSM'),(53373392,'created_by','JOSM'),(53373399,'created_by','JOSM'),(53373402,'created_by','JOSM'),(53373406,'created_by','JOSM'),(53373410,'created_by','JOSM'),(53373416,'created_by','JOSM'),(53373457,'created_by','JOSM'),(53373463,'created_by','JOSM'),(53373467,'created_by','JOSM'),(53373472,'created_by','JOSM'),(53373475,'created_by','JOSM'),(53373479,'created_by','JOSM'),(53373480,'created_by','JOSM'),(53373484,'created_by','JOSM'),(53373499,'created_by','JOSM'),(53373501,'created_by','JOSM'),(53373507,'created_by','JOSM'),(53373512,'created_by','JOSM'),(53373516,'created_by','JOSM'),(53373521,'created_by','JOSM'),(53373529,'created_by','JOSM'),(53373532,'created_by','JOSM'),(53373536,'created_by','JOSM'),(53373543,'created_by','JOSM'),(53373545,'created_by','JOSM'),(53373549,'created_by','JOSM'),(53374387,'created_by','JOSM'),(53374403,'created_by','JOSM'),(53374521,'created_by','JOSM'),(53374531,'created_by','JOSM'),(53374534,'created_by','JOSM'),(53374537,'created_by','JOSM'),(53374542,'created_by','JOSM'),(53374635,'created_by','JOSM'),(53374797,'created_by','JOSM'),(53374856,'created_by','JOSM'),(53374862,'created_by','JOSM'),(53374867,'created_by','JOSM'),(53374883,'created_by','JOSM'),(53374887,'created_by','JOSM'),(53374892,'created_by','JOSM'),(53374894,'created_by','JOSM'),(53374897,'created_by','JOSM'),(53374901,'created_by','JOSM'),(53374925,'created_by','JOSM'),(53374929,'created_by','JOSM'),(53375001,'created_by','JOSM'),(53375004,'created_by','JOSM'),(53375007,'created_by','JOSM'),(53375010,'created_by','JOSM'),(53375014,'created_by','JOSM'),(53375016,'created_by','JOSM'),(53375019,'created_by','JOSM'),(53375022,'created_by','JOSM'),(53375026,'created_by','JOSM'),(53375056,'created_by','JOSM'),(53375086,'created_by','JOSM'),(53375126,'created_by','JOSM'),(53375501,'created_by','JOSM'),(53376238,'created_by','JOSM'),(53376244,'created_by','JOSM'),(53376247,'created_by','JOSM'),(53376253,'created_by','JOSM'),(53376257,'created_by','JOSM'),(53376264,'created_by','JOSM'),(53376267,'created_by','JOSM'),(53376272,'created_by','JOSM'),(53376275,'created_by','JOSM'),(53376314,'created_by','JOSM'),(53376323,'created_by','JOSM'),(53376331,'created_by','JOSM'),(53376354,'created_by','JOSM'),(53376363,'created_by','JOSM'),(53376376,'created_by','JOSM'),(53376378,'created_by','JOSM'),(53376383,'created_by','JOSM'),(53376386,'created_by','JOSM'),(53376390,'created_by','JOSM'),(53376392,'created_by','JOSM'),(53376394,'created_by','JOSM'),(53376397,'created_by','JOSM'),(53376399,'created_by','JOSM'),(53376401,'created_by','JOSM'),(53376405,'created_by','JOSM'),(53376408,'created_by','JOSM'),(53376414,'created_by','JOSM'),(53376419,'created_by','JOSM'),(53376421,'created_by','JOSM'),(53376423,'created_by','JOSM'),(53376428,'created_by','JOSM'),(53376431,'created_by','JOSM'),(53376435,'created_by','JOSM'),(53376437,'created_by','JOSM'),(53376438,'created_by','JOSM'),(53376440,'created_by','JOSM'),(53376442,'created_by','JOSM'),(53376444,'created_by','JOSM'),(53376448,'created_by','JOSM'),(53376451,'created_by','JOSM'),(53376626,'created_by','JOSM'),(53376629,'created_by','JOSM'),(53376632,'created_by','JOSM'),(53376634,'created_by','JOSM'),(53376637,'created_by','JOSM'),(53376658,'created_by','JOSM'),(53376660,'created_by','JOSM'),(53376663,'created_by','JOSM'),(53376664,'created_by','JOSM'),(53376666,'created_by','JOSM'),(53376670,'created_by','JOSM'),(53376674,'created_by','JOSM'),(53376677,'created_by','JOSM'),(53376682,'created_by','JOSM'),(53376683,'created_by','JOSM'),(53376686,'created_by','JOSM'),(53376689,'created_by','JOSM'),(53376692,'created_by','JOSM'),(53376695,'created_by','JOSM'),(53376699,'created_by','JOSM'),(53376702,'created_by','JOSM'),(53376704,'created_by','JOSM'),(53376709,'created_by','JOSM'),(53376715,'created_by','JOSM'),(53376719,'created_by','JOSM'),(53376723,'created_by','JOSM'),(53376729,'created_by','JOSM'),(53376733,'created_by','JOSM'),(53376737,'created_by','JOSM'),(53376740,'created_by','JOSM'),(53376743,'created_by','JOSM'),(53376746,'created_by','JOSM'),(53376748,'created_by','JOSM'),(53376750,'created_by','JOSM'),(53376751,'created_by','JOSM'),(53376753,'created_by','JOSM'),(53376754,'created_by','JOSM'),(53376756,'created_by','JOSM'),(53376757,'created_by','JOSM'),(53376761,'created_by','JOSM'),(53376764,'created_by','JOSM'),(53376766,'created_by','JOSM'),(53376768,'created_by','JOSM'),(53376771,'created_by','JOSM'),(53376772,'created_by','JOSM'),(53376775,'created_by','JOSM'),(53376777,'created_by','JOSM'),(53376780,'created_by','JOSM'),(53376782,'created_by','JOSM'),(53376784,'created_by','JOSM'),(53376788,'created_by','JOSM'),(53376797,'created_by','JOSM'),(53376799,'created_by','JOSM'),(53376802,'created_by','JOSM'),(53376806,'created_by','JOSM'),(53376810,'created_by','JOSM'),(53376814,'created_by','JOSM'),(53376816,'created_by','JOSM'),(53376820,'created_by','JOSM'),(53376827,'created_by','JOSM'),(53376830,'created_by','JOSM'),(53376834,'created_by','JOSM'),(53376837,'created_by','JOSM'),(53376840,'created_by','JOSM'),(53376847,'created_by','JOSM'),(53376853,'created_by','JOSM'),(53376856,'created_by','JOSM'),(53376859,'created_by','JOSM'),(53376862,'created_by','JOSM'),(53376864,'created_by','JOSM'),(53376873,'created_by','JOSM'),(53376881,'created_by','JOSM'),(53376883,'created_by','JOSM'),(53376887,'created_by','JOSM'),(53376891,'created_by','JOSM'),(53376895,'created_by','JOSM'),(53376898,'created_by','JOSM'),(53376899,'created_by','JOSM'),(53376955,'created_by','JOSM'),(53376959,'created_by','JOSM'),(53376962,'created_by','JOSM'),(53376964,'created_by','JOSM'),(53376968,'created_by','JOSM'),(53376972,'created_by','JOSM'),(53376975,'created_by','JOSM'),(53376979,'created_by','JOSM'),(53376983,'created_by','JOSM'),(53376987,'created_by','JOSM'),(53376989,'created_by','JOSM'),(53376996,'created_by','JOSM'),(53377001,'created_by','JOSM'),(53377006,'created_by','JOSM'),(53377009,'created_by','JOSM'),(53377015,'created_by','JOSM'),(53377018,'created_by','JOSM'),(53377021,'created_by','JOSM'),(53377027,'created_by','JOSM'),(53377032,'created_by','JOSM'),(53377035,'created_by','JOSM'),(53377040,'created_by','JOSM'),(53377045,'created_by','JOSM'),(53377047,'created_by','JOSM'),(53377049,'created_by','JOSM'),(53377051,'created_by','JOSM'),(53377053,'created_by','JOSM'),(53377058,'created_by','JOSM'),(53377061,'created_by','JOSM'),(53377065,'created_by','JOSM'),(53377068,'created_by','JOSM'),(53377070,'created_by','JOSM'),(53377077,'created_by','JOSM'),(53377080,'created_by','JOSM'),(53377090,'created_by','JOSM'),(53377093,'created_by','JOSM'),(53377098,'created_by','JOSM'),(53377104,'created_by','JOSM'),(53377113,'created_by','JOSM'),(53377119,'created_by','JOSM'),(53377124,'created_by','JOSM'),(53377128,'created_by','JOSM'),(53377133,'created_by','JOSM'),(53377138,'created_by','JOSM'),(53377141,'created_by','JOSM'),(53377146,'created_by','JOSM'),(53377151,'created_by','JOSM'),(53377156,'created_by','JOSM'),(53377163,'created_by','JOSM'),(53377168,'created_by','JOSM'),(53377175,'created_by','JOSM'),(53377178,'created_by','JOSM'),(53377180,'created_by','JOSM'),(53377183,'created_by','JOSM'),(53377186,'created_by','JOSM'),(53377191,'created_by','JOSM'),(53377195,'created_by','JOSM'),(53380473,'created_by','JOSM'),(53380480,'created_by','JOSM'),(53380485,'created_by','JOSM'),(53380489,'created_by','JOSM'),(53380491,'created_by','JOSM'),(53380499,'created_by','JOSM'),(53380503,'created_by','JOSM'),(53381711,'created_by','JOSM'),(53381723,'created_by','JOSM'),(53381733,'created_by','JOSM'),(53381738,'created_by','JOSM'),(53381779,'created_by','JOSM'),(53381787,'created_by','JOSM'),(53381798,'created_by','JOSM'),(53381809,'created_by','JOSM'),(53381818,'created_by','JOSM'),(53381825,'created_by','JOSM'),(53381829,'created_by','JOSM'),(53381832,'created_by','JOSM'),(53381834,'created_by','JOSM'),(53381837,'created_by','JOSM'),(53381842,'created_by','JOSM'),(53381844,'created_by','JOSM'),(53381850,'created_by','JOSM'),(53381892,'created_by','JOSM'),(53381925,'created_by','JOSM'),(53381944,'created_by','JOSM'),(53381947,'created_by','JOSM'),(53381978,'created_by','JOSM'),(53381995,'created_by','JOSM'),(53382002,'created_by','JOSM'),(53382009,'created_by','JOSM'),(53382019,'created_by','JOSM'),(53382028,'created_by','JOSM'),(53382033,'created_by','JOSM'),(53382041,'created_by','JOSM'),(53382044,'created_by','JOSM'),(53382047,'created_by','JOSM'),(53382052,'created_by','JOSM'),(53382055,'created_by','JOSM'),(53382059,'created_by','JOSM'),(53382064,'created_by','JOSM'),(53382089,'created_by','JOSM'),(53382106,'created_by','JOSM'),(53382126,'created_by','JOSM'),(53382156,'created_by','JOSM'),(53382223,'created_by','JOSM'),(53382318,'created_by','JOSM'),(53382504,'created_by','JOSM'),(53382509,'created_by','JOSM'),(53382959,'created_by','JOSM'),(53383168,'created_by','JOSM'),(53383242,'created_by','JOSM'),(53383258,'created_by','JOSM'),(53383280,'created_by','JOSM'),(53383286,'created_by','JOSM'),(53383289,'created_by','JOSM'),(53383297,'created_by','JOSM'),(53383310,'created_by','JOSM'),(53383321,'created_by','JOSM'),(53383324,'created_by','JOSM'),(53383336,'created_by','JOSM'),(53383341,'created_by','JOSM'),(53383350,'created_by','JOSM'),(53383356,'created_by','JOSM'),(53383364,'created_by','JOSM'),(53383369,'created_by','JOSM'),(53383373,'created_by','JOSM'),(53383379,'created_by','JOSM'),(53383384,'created_by','JOSM'),(53383388,'created_by','JOSM'),(53383393,'created_by','JOSM'),(53383398,'created_by','JOSM'),(53383403,'created_by','JOSM'),(53383409,'created_by','JOSM'),(53383415,'created_by','JOSM'),(53383419,'created_by','JOSM'),(53383424,'created_by','JOSM'),(53383429,'created_by','JOSM'),(53383434,'created_by','JOSM'),(53383440,'created_by','JOSM'),(53383445,'created_by','JOSM'),(53383451,'created_by','JOSM'),(53383455,'created_by','JOSM'),(53383459,'created_by','JOSM'),(53383468,'created_by','JOSM'),(53383474,'created_by','JOSM'),(53383480,'created_by','JOSM'),(53383487,'created_by','JOSM'),(53383494,'created_by','JOSM'),(53383497,'created_by','JOSM'),(53383499,'created_by','JOSM'),(53383505,'created_by','JOSM'),(53383508,'created_by','JOSM'),(53383523,'created_by','JOSM'),(53383556,'created_by','JOSM'),(53383559,'created_by','JOSM'),(53383561,'created_by','JOSM'),(53383562,'created_by','JOSM'),(53383566,'created_by','JOSM'),(53383579,'created_by','JOSM'),(53383582,'created_by','JOSM'),(53383584,'created_by','JOSM'),(53383597,'created_by','JOSM'),(53383600,'created_by','JOSM'),(53383603,'created_by','JOSM'),(53383605,'created_by','JOSM'),(53383606,'created_by','JOSM'),(53383610,'created_by','JOSM'),(53383612,'created_by','JOSM'),(53383614,'created_by','JOSM'),(53383617,'created_by','JOSM'),(53383620,'created_by','JOSM'),(53383622,'created_by','JOSM'),(53383624,'created_by','JOSM'),(53383626,'created_by','JOSM'),(53383628,'created_by','JOSM'),(53383631,'created_by','JOSM'),(53383634,'created_by','JOSM'),(53383636,'created_by','JOSM'),(53383639,'created_by','JOSM'),(53383643,'created_by','JOSM'),(53383646,'created_by','JOSM'),(53383670,'created_by','JOSM'),(53383680,'created_by','JOSM'),(53383685,'created_by','JOSM'),(53383688,'created_by','JOSM'),(53383691,'created_by','JOSM'),(53383694,'created_by','JOSM'),(53383698,'created_by','JOSM'),(53383728,'created_by','JOSM'),(53383735,'created_by','JOSM'),(53383739,'created_by','JOSM'),(53383762,'created_by','JOSM'),(53383772,'created_by','JOSM'),(53383793,'created_by','JOSM'),(53383842,'created_by','JOSM'),(53383953,'created_by','JOSM'),(53383956,'created_by','JOSM'),(53383958,'created_by','JOSM'),(53383961,'created_by','JOSM'),(53383970,'created_by','JOSM'),(53383987,'created_by','JOSM'),(53383990,'created_by','JOSM'),(53384000,'created_by','JOSM'),(53384003,'created_by','JOSM'),(53384008,'created_by','JOSM'),(53384011,'created_by','JOSM'),(53384013,'created_by','JOSM'),(53384016,'created_by','JOSM'),(53384020,'created_by','JOSM'),(53384024,'created_by','JOSM'),(53384026,'created_by','JOSM'),(53384030,'created_by','JOSM'),(53384033,'created_by','JOSM'),(53384036,'created_by','JOSM'),(53384038,'created_by','JOSM'),(53384040,'created_by','JOSM'),(53384065,'created_by','JOSM'),(53384068,'created_by','JOSM'),(53384120,'created_by','JOSM'),(53384283,'created_by','JOSM'),(53384287,'created_by','JOSM'),(53384302,'created_by','JOSM'),(53384325,'created_by','JOSM'),(53384330,'created_by','JOSM'),(53384332,'created_by','JOSM'),(53384335,'created_by','JOSM'),(53384338,'created_by','JOSM'),(53384375,'created_by','JOSM'),(53385461,'created_by','JOSM'),(53385467,'created_by','JOSM'),(53385484,'created_by','JOSM'),(53385511,'created_by','JOSM'),(53387182,'created_by','JOSM'),(53388340,'created_by','JOSM'),(53388543,'created_by','JOSM'),(53389302,'created_by','JOSM'),(53389827,'created_by','JOSM'),(53390266,'created_by','JOSM'),(53390450,'created_by','JOSM'),(53390493,'created_by','JOSM'),(53390505,'created_by','JOSM'),(53390513,'created_by','JOSM'),(53390521,'created_by','JOSM'),(53390534,'created_by','JOSM'),(53390548,'created_by','JOSM'),(53390624,'created_by','JOSM'),(53390658,'created_by','JOSM'),(53390732,'created_by','JOSM'),(53390740,'created_by','JOSM'),(53390749,'created_by','JOSM'),(53390776,'created_by','JOSM'),(53390786,'created_by','JOSM'),(53392096,'created_by','JOSM'),(53392102,'created_by','JOSM'),(53392109,'created_by','JOSM'),(53392116,'created_by','JOSM'),(53392136,'created_by','JOSM'),(53392141,'created_by','JOSM'),(53392147,'created_by','JOSM'),(53392151,'created_by','JOSM'),(53392160,'created_by','JOSM'),(53392164,'created_by','JOSM'),(53392166,'created_by','JOSM'),(53392168,'created_by','JOSM'),(53392180,'created_by','JOSM'),(53392185,'created_by','JOSM'),(53392195,'created_by','JOSM'),(53392200,'created_by','JOSM'),(53392203,'created_by','JOSM'),(53392207,'created_by','JOSM'),(53392208,'created_by','JOSM'),(53392215,'created_by','JOSM'),(53392222,'created_by','JOSM'),(53392224,'created_by','JOSM'),(53392227,'created_by','JOSM'),(53392235,'created_by','JOSM'),(53392239,'created_by','JOSM'),(58957648,'capital','yes'),(58957648,'is_in','Andorra'),(58957648,'name','Andorra la Vella'),(58957648,'name:an','Andorra la Biella'),(58957648,'name:ar','?????? ?? ????'),(58957648,'name:bg','?????? ?? ????'),(58957648,'name:ca','Andorra la Vella'),(58957648,'name:es','Andorra la Vieja'),(58957648,'name:fr','Andorre-la-Vieille'),(58957648,'name:he','?????? ?? ???'),(58957648,'name:is','Andorra la Vella'),(58957648,'name:ja','??????????'),(58957648,'name:ko','??????'),(58957648,'name:la','Andorra Vetus'),(58957648,'name:lt','Andora'),(58957648,'name:lv','Andora la Velja'),(58957648,'name:oc','Andòrra la Vièlha'),(58957648,'name:pl','Andora'),(58957648,'name:pt','Andorra-a-Velha'),(58957648,'name:ru','???????-??-?????'),(58957648,'name:sr','?????? ?? ????'),(58957648,'name:zh','????'),(58957648,'place','town'),(58957648,'population','24678'),(58957648,'wikipedia:fr','Andorre-la-Vieille'),(58963219,'created_by','Potlatch 0.4a'),(58963219,'is_in','Andorra'),(58963219,'name','Ordino'),(58963219,'place','town'),(64796296,'created_by','JOSM'),(64796297,'created_by','JOSM'),(64796301,'created_by','JOSM'),(64796302,'created_by','JOSM'),(64796303,'created_by','JOSM'),(64796304,'created_by','JOSM'),(64796308,'created_by','JOSM'),(64796309,'created_by','JOSM'),(64796310,'created_by','JOSM'),(64796311,'created_by','JOSM'),(64796315,'created_by','JOSM'),(64796316,'created_by','JOSM'),(64796317,'created_by','JOSM'),(64796318,'created_by','JOSM'),(64796322,'created_by','JOSM'),(64796323,'created_by','JOSM'),(64796324,'created_by','JOSM'),(64796325,'created_by','JOSM'),(64796329,'created_by','JOSM'),(64796330,'created_by','JOSM'),(64796331,'created_by','JOSM'),(64796332,'created_by','JOSM'),(64796335,'created_by','JOSM'),(64796337,'created_by','JOSM'),(64796338,'created_by','JOSM'),(64796339,'created_by','JOSM'),(64796340,'created_by','JOSM'),(64796344,'created_by','JOSM'),(64796345,'created_by','JOSM'),(64796346,'created_by','JOSM'),(64796349,'created_by','JOSM'),(64796351,'created_by','JOSM'),(64796352,'created_by','JOSM'),(64796353,'created_by','JOSM'),(64796356,'created_by','JOSM'),(64796358,'created_by','JOSM'),(64796359,'created_by','JOSM'),(64796360,'created_by','JOSM'),(64796363,'created_by','JOSM'),(64796365,'created_by','JOSM'),(64796366,'created_by','JOSM'),(64796367,'created_by','JOSM'),(64796368,'created_by','JOSM'),(64796372,'created_by','JOSM'),(64796373,'created_by','JOSM'),(64796374,'created_by','JOSM'),(64796375,'created_by','JOSM'),(64796376,'created_by','JOSM'),(64796377,'created_by','JOSM'),(64796381,'created_by','JOSM'),(64796382,'created_by','JOSM'),(64796383,'created_by','JOSM'),(64796385,'created_by','JOSM'),(64796388,'created_by','JOSM'),(64798267,'created_by','JOSM'),(64798268,'created_by','JOSM'),(64798270,'created_by','JOSM'),(64798271,'created_by','JOSM'),(64798274,'created_by','JOSM'),(64798275,'created_by','JOSM'),(64798277,'created_by','JOSM'),(64798278,'created_by','JOSM'),(64798280,'created_by','JOSM'),(64798282,'created_by','JOSM'),(64798283,'created_by','JOSM'),(64798285,'created_by','JOSM'),(64798286,'created_by','JOSM'),(64798289,'created_by','JOSM'),(64798290,'created_by','JOSM'),(64798291,'created_by','JOSM'),(64798293,'created_by','JOSM'),(64798295,'created_by','JOSM'),(64798297,'created_by','JOSM'),(64798298,'created_by','JOSM'),(64798300,'created_by','JOSM'),(64798301,'created_by','JOSM'),(64798304,'created_by','JOSM'),(64798305,'created_by','JOSM'),(64798306,'created_by','JOSM'),(64798308,'created_by','JOSM'),(64798310,'created_by','JOSM'),(64798312,'created_by','JOSM'),(64798313,'created_by','JOSM'),(64798315,'created_by','JOSM'),(64798316,'created_by','JOSM'),(64798319,'created_by','JOSM'),(64798320,'created_by','JOSM'),(64798321,'created_by','JOSM'),(64798323,'created_by','JOSM'),(64798324,'created_by','JOSM'),(64798327,'created_by','JOSM'),(64798328,'created_by','JOSM'),(64798329,'created_by','JOSM'),(64798331,'created_by','JOSM'),(64798333,'created_by','JOSM'),(64798335,'created_by','JOSM'),(64798336,'created_by','JOSM'),(64798337,'created_by','JOSM'),(64798339,'created_by','JOSM'),(64798342,'created_by','JOSM'),(64798343,'created_by','JOSM'),(64798344,'created_by','JOSM'),(64798345,'created_by','JOSM'),(64798347,'created_by','JOSM'),(64798350,'created_by','JOSM'),(64798351,'created_by','JOSM'),(64798352,'created_by','JOSM'),(64801605,'created_by','JOSM'),(64801639,'created_by','JOSM'),(64801640,'created_by','JOSM'),(64801644,'created_by','JOSM'),(64801645,'created_by','JOSM'),(64801646,'created_by','JOSM'),(64801648,'created_by','JOSM'),(64801651,'created_by','JOSM'),(64801652,'created_by','JOSM'),(64801654,'created_by','JOSM'),(64801657,'created_by','JOSM'),(64801659,'created_by','JOSM'),(64801660,'created_by','JOSM'),(64801663,'created_by','JOSM'),(64801667,'created_by','JOSM'),(64801670,'created_by','JOSM'),(64801672,'created_by','JOSM'),(64801673,'created_by','JOSM'),(64801675,'created_by','JOSM'),(64801678,'created_by','JOSM'),(64801679,'created_by','JOSM'),(64801681,'created_by','JOSM'),(64801684,'created_by','JOSM'),(64801685,'created_by','JOSM'),(64801686,'created_by','JOSM'),(64801688,'created_by','JOSM'),(64801690,'created_by','JOSM'),(64801693,'created_by','JOSM'),(64801694,'created_by','JOSM'),(64801695,'created_by','JOSM'),(64801697,'created_by','JOSM'),(64801702,'created_by','JOSM'),(64801703,'created_by','JOSM'),(64801704,'created_by','JOSM'),(64801705,'created_by','JOSM'),(64801709,'created_by','JOSM'),(64801710,'created_by','JOSM'),(64801711,'created_by','JOSM'),(64801712,'created_by','JOSM'),(64801714,'created_by','JOSM'),(64801717,'created_by','JOSM'),(64801718,'created_by','JOSM'),(64801719,'created_by','JOSM'),(64801721,'created_by','JOSM'),(64801724,'created_by','JOSM'),(64801725,'created_by','JOSM'),(64801729,'created_by','JOSM'),(64801739,'created_by','JOSM'),(64801740,'created_by','JOSM'),(64801741,'created_by','JOSM'),(64801745,'created_by','JOSM'),(64801746,'created_by','JOSM'),(64801747,'created_by','JOSM'),(64801748,'created_by','JOSM'),(64801751,'created_by','JOSM'),(64801753,'created_by','JOSM'),(64801754,'created_by','JOSM'),(64801758,'created_by','JOSM'),(64801759,'created_by','JOSM'),(64801761,'created_by','JOSM'),(64801762,'created_by','JOSM'),(64801766,'created_by','JOSM'),(64801770,'created_by','JOSM'),(64801773,'created_by','JOSM'),(64801774,'created_by','JOSM'),(64801778,'created_by','JOSM'),(64801779,'created_by','JOSM'),(64801780,'created_by','JOSM'),(64801785,'created_by','JOSM'),(64801795,'created_by','JOSM'),(64801802,'created_by','JOSM'),(64801803,'created_by','JOSM'),(64801804,'created_by','JOSM'),(64801805,'created_by','JOSM'),(64801809,'created_by','JOSM'),(64801810,'created_by','JOSM'),(64801811,'created_by','JOSM'),(64801812,'created_by','JOSM'),(64801816,'created_by','JOSM'),(64801817,'created_by','JOSM'),(64801818,'created_by','JOSM'),(64801819,'created_by','JOSM'),(64803147,'created_by','JOSM'),(64803150,'created_by','JOSM'),(64803152,'created_by','JOSM'),(64803153,'created_by','JOSM'),(64803154,'created_by','JOSM'),(64803157,'created_by','JOSM'),(64803159,'created_by','JOSM'),(64803160,'created_by','JOSM'),(64803161,'created_by','JOSM'),(64803162,'created_by','JOSM'),(64803165,'created_by','JOSM'),(64803167,'created_by','JOSM'),(64803168,'created_by','JOSM'),(64803169,'created_by','JOSM'),(64803172,'created_by','JOSM'),(64803174,'created_by','JOSM'),(64803175,'created_by','JOSM'),(64803176,'created_by','JOSM'),(64803177,'created_by','JOSM'),(64803180,'created_by','JOSM'),(64803182,'created_by','JOSM'),(64803183,'created_by','JOSM'),(64803184,'created_by','JOSM'),(64803185,'created_by','JOSM'),(64803188,'created_by','JOSM'),(64803190,'created_by','JOSM'),(64803191,'created_by','JOSM'),(64803192,'created_by','JOSM'),(64803195,'created_by','JOSM'),(64803197,'created_by','JOSM'),(64803198,'created_by','JOSM'),(64803199,'created_by','JOSM'),(64840709,'created_by','JOSM'),(64840717,'created_by','JOSM'),(64840721,'created_by','JOSM'),(64840726,'created_by','JOSM'),(64840730,'created_by','JOSM'),(64840732,'created_by','JOSM'),(64840738,'created_by','JOSM'),(64840741,'created_by','JOSM'),(64840744,'created_by','JOSM'),(64840746,'created_by','JOSM'),(64840750,'created_by','JOSM'),(64840753,'created_by','JOSM'),(64840755,'created_by','JOSM'),(64840758,'created_by','JOSM'),(64840759,'created_by','JOSM'),(64840761,'created_by','JOSM'),(64840762,'created_by','JOSM'),(64840767,'created_by','JOSM'),(64840769,'created_by','JOSM'),(64840773,'created_by','JOSM'),(64840778,'created_by','JOSM'),(64840781,'created_by','JOSM'),(64840785,'created_by','JOSM'),(64840790,'created_by','JOSM'),(64840792,'created_by','JOSM'),(64840793,'created_by','JOSM'),(64840797,'created_by','JOSM'),(64840799,'created_by','JOSM'),(64840802,'created_by','JOSM'),(64840806,'created_by','JOSM'),(64840812,'created_by','JOSM'),(64840816,'created_by','JOSM'),(64840820,'created_by','JOSM'),(64840823,'created_by','JOSM'),(64840828,'created_by','JOSM'),(64840832,'created_by','JOSM'),(64840836,'created_by','JOSM'),(64840839,'created_by','JOSM'),(64840843,'created_by','JOSM'),(64840848,'created_by','JOSM'),(64840849,'created_by','JOSM'),(64840854,'created_by','JOSM'),(64840858,'created_by','JOSM'),(64840861,'created_by','JOSM'),(64840865,'created_by','JOSM'),(64840868,'created_by','JOSM'),(64840872,'created_by','JOSM'),(64840877,'created_by','JOSM'),(64840882,'created_by','JOSM'),(64840886,'created_by','JOSM'),(64840890,'created_by','JOSM'),(64840895,'created_by','JOSM'),(64840899,'created_by','JOSM'),(64840903,'created_by','JOSM'),(64840907,'created_by','JOSM'),(64840911,'created_by','JOSM'),(64840916,'created_by','JOSM'),(64840918,'created_by','JOSM'),(64840922,'created_by','JOSM'),(64840923,'created_by','JOSM'),(64840926,'created_by','JOSM'),(64840929,'created_by','JOSM'),(64840932,'created_by','JOSM'),(64840933,'created_by','JOSM'),(64840934,'created_by','JOSM'),(64840936,'created_by','JOSM'),(64840940,'created_by','JOSM'),(64840946,'created_by','JOSM'),(64840950,'created_by','JOSM'),(64840954,'created_by','JOSM'),(64840959,'created_by','JOSM'),(64840961,'created_by','JOSM'),(64840965,'created_by','JOSM'),(64840968,'created_by','JOSM'),(64840971,'created_by','JOSM'),(64840975,'created_by','JOSM'),(64840979,'created_by','JOSM'),(64840982,'created_by','JOSM'),(64840985,'created_by','JOSM'),(64840987,'created_by','JOSM'),(64840992,'created_by','JOSM'),(64840996,'created_by','JOSM'),(64840997,'created_by','JOSM'),(64840998,'created_by','JOSM'),(64841000,'created_by','JOSM'),(64841005,'created_by','JOSM'),(64841007,'created_by','JOSM'),(64841008,'created_by','JOSM'),(64841013,'created_by','JOSM'),(64841018,'created_by','JOSM'),(64841023,'created_by','JOSM'),(64841026,'created_by','JOSM'),(64841028,'created_by','JOSM'),(64841033,'created_by','JOSM'),(64841037,'created_by','JOSM'),(64841039,'created_by','JOSM'),(64841042,'created_by','JOSM'),(64841046,'created_by','JOSM'),(64841049,'created_by','JOSM'),(64841051,'created_by','JOSM'),(64841053,'created_by','JOSM'),(64841057,'created_by','JOSM'),(64841061,'created_by','JOSM'),(64841066,'created_by','JOSM'),(64841070,'created_by','JOSM'),(64841074,'created_by','JOSM'),(64841080,'created_by','JOSM'),(64841084,'created_by','JOSM'),(64841088,'created_by','JOSM'),(64841091,'created_by','JOSM'),(64841092,'created_by','JOSM'),(64841094,'created_by','JOSM'),(64841097,'created_by','JOSM'),(64841099,'created_by','JOSM'),(64841100,'created_by','JOSM'),(64841101,'created_by','JOSM'),(64841105,'created_by','JOSM'),(64841106,'created_by','JOSM'),(64841108,'created_by','JOSM'),(64841109,'created_by','JOSM'),(64841113,'created_by','JOSM'),(64841115,'created_by','JOSM'),(64841118,'created_by','JOSM'),(64841119,'created_by','JOSM'),(64841120,'created_by','JOSM'),(64841123,'created_by','JOSM'),(64841125,'created_by','JOSM'),(64841128,'created_by','JOSM'),(64841129,'created_by','JOSM'),(64841132,'created_by','JOSM'),(64841134,'created_by','JOSM'),(64841136,'created_by','JOSM'),(64841139,'created_by','JOSM'),(64841145,'created_by','JOSM'),(64841148,'created_by','JOSM'),(64841151,'created_by','JOSM'),(64841154,'created_by','JOSM'),(64841158,'created_by','JOSM'),(64841162,'created_by','JOSM'),(64841165,'created_by','JOSM'),(64841166,'created_by','JOSM'),(64841169,'created_by','JOSM'),(64841177,'created_by','JOSM'),(64841180,'created_by','JOSM'),(64841183,'created_by','JOSM'),(64841185,'created_by','JOSM'),(64841188,'created_by','JOSM'),(64841191,'created_by','JOSM'),(64841194,'created_by','JOSM'),(64841197,'created_by','JOSM'),(64841198,'created_by','JOSM'),(64841202,'created_by','JOSM'),(64841205,'created_by','JOSM'),(64841208,'created_by','JOSM'),(64841211,'created_by','JOSM'),(64841215,'created_by','JOSM'),(64841220,'created_by','JOSM'),(64841224,'created_by','JOSM'),(64841229,'created_by','JOSM'),(64841233,'created_by','JOSM'),(64841236,'created_by','JOSM'),(64841238,'created_by','JOSM'),(64841243,'created_by','JOSM'),(64841245,'created_by','JOSM'),(64841248,'created_by','JOSM'),(64841254,'created_by','JOSM'),(64841257,'created_by','JOSM'),(64841260,'created_by','JOSM'),(64841263,'created_by','JOSM'),(64841266,'created_by','JOSM'),(64841268,'created_by','JOSM'),(64841271,'created_by','JOSM'),(64841274,'created_by','JOSM'),(64841278,'created_by','JOSM'),(64841281,'created_by','JOSM'),(64841282,'created_by','JOSM'),(64841286,'created_by','JOSM'),(64841290,'created_by','JOSM'),(64841293,'created_by','JOSM'),(64841297,'created_by','JOSM'),(64841301,'created_by','JOSM'),(64841307,'created_by','JOSM'),(64841311,'created_by','JOSM'),(64841315,'created_by','JOSM'),(64841316,'created_by','JOSM'),(64841319,'created_by','JOSM'),(64841321,'created_by','JOSM'),(64841324,'created_by','JOSM'),(64841329,'created_by','JOSM'),(64841333,'created_by','JOSM'),(64841337,'created_by','JOSM'),(64841341,'created_by','JOSM'),(64841344,'created_by','JOSM'),(64841346,'created_by','JOSM'),(64841351,'created_by','JOSM'),(64841356,'created_by','JOSM'),(64841360,'created_by','JOSM'),(64841365,'created_by','JOSM'),(64841367,'created_by','JOSM'),(64841370,'created_by','JOSM'),(64841373,'created_by','JOSM'),(64841375,'created_by','JOSM'),(64841376,'created_by','JOSM'),(64841379,'created_by','JOSM'),(64841383,'created_by','JOSM'),(64841386,'created_by','JOSM'),(64841388,'created_by','JOSM'),(64841390,'created_by','JOSM'),(64841393,'created_by','JOSM'),(64841396,'created_by','JOSM'),(64841399,'created_by','JOSM'),(64841407,'created_by','JOSM'),(64841415,'created_by','JOSM'),(64841424,'created_by','JOSM'),(64841431,'created_by','JOSM'),(64841433,'created_by','JOSM'),(64841434,'created_by','JOSM'),(64841436,'created_by','JOSM'),(64841439,'created_by','JOSM'),(64841441,'created_by','JOSM'),(64841444,'created_by','JOSM'),(64841446,'created_by','JOSM'),(64841451,'created_by','JOSM'),(64841452,'created_by','JOSM'),(64841454,'created_by','JOSM'),(64841456,'created_by','JOSM'),(64841461,'created_by','JOSM'),(64841463,'created_by','JOSM'),(64841468,'created_by','JOSM'),(64841472,'created_by','JOSM'),(64841473,'created_by','JOSM'),(64841478,'created_by','JOSM'),(64841481,'created_by','JOSM'),(64841483,'created_by','JOSM'),(64841487,'created_by','JOSM'),(64841488,'created_by','JOSM'),(64841491,'created_by','JOSM'),(64841497,'created_by','JOSM'),(64841499,'created_by','JOSM'),(64841502,'created_by','JOSM'),(64841507,'created_by','JOSM'),(64841511,'created_by','JOSM'),(64841514,'created_by','JOSM'),(64841518,'created_by','JOSM'),(64841521,'created_by','JOSM'),(64841525,'created_by','JOSM'),(64841529,'created_by','JOSM'),(64841532,'created_by','JOSM'),(64841537,'created_by','JOSM'),(64841541,'created_by','JOSM'),(64841547,'created_by','JOSM'),(64841550,'created_by','JOSM'),(64841551,'created_by','JOSM'),(64841553,'created_by','JOSM'),(64841557,'created_by','JOSM'),(64841561,'created_by','JOSM'),(64841566,'created_by','JOSM'),(64841570,'created_by','JOSM'),(64841573,'created_by','JOSM'),(64841579,'created_by','JOSM'),(64841582,'created_by','JOSM'),(64841584,'created_by','JOSM'),(64841587,'created_by','JOSM'),(64841591,'created_by','JOSM'),(64841597,'created_by','JOSM'),(64841600,'created_by','JOSM'),(64841603,'created_by','JOSM'),(64841606,'created_by','JOSM'),(64841612,'created_by','JOSM'),(64841617,'created_by','JOSM'),(64841620,'created_by','JOSM'),(64841623,'created_by','JOSM'),(64841627,'created_by','JOSM'),(64841630,'created_by','JOSM'),(64841635,'created_by','JOSM'),(64841638,'created_by','JOSM'),(64841640,'created_by','JOSM'),(64841645,'created_by','JOSM'),(64841649,'created_by','JOSM'),(64841652,'created_by','JOSM'),(64841654,'created_by','JOSM'),(64954372,'created_by','JOSM'),(64954372,'gns:ADM1','00'),(64954372,'gns:N:xx:FULL_NAME','Aixàs'),(64954372,'gns:N:xx:FULL_NAME_ND','Aixas'),(64954372,'gns:N:xx:NT','N'),(64954372,'gns:N:xx:SORT_NAME','AIXAS'),(64954372,'gns:RC','1'),(64954372,'gns:UFI','-1394392'),(64954372,'gns:UNI','-2001996'),(64954372,'name','Aixàs'),(64954372,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954372,'place','hamlet'),(64954372,'source','gns_an'),(64954377,'created_by','Potlatch 0.10f'),(64954377,'gns:ADM1','00'),(64954377,'gns:N:xx:FULL_NAME','Aubinyà'),(64954377,'gns:N:xx:FULL_NAME_ND','Aubinya'),(64954377,'gns:N:xx:NT','N'),(64954377,'gns:N:xx:SORT_NAME','AUBINYA'),(64954377,'gns:RC','1'),(64954377,'gns:UFI','-1394528'),(64954377,'gns:UNI','-2002172'),(64954377,'gns:V:xx:FULL_NAME','Auvinya'),(64954377,'gns:V:xx:FULL_NAME_ND','Auvinya'),(64954377,'gns:V:xx:MODIFY_DATE','1993-12-23'),(64954377,'gns:V:xx:NT','V'),(64954377,'gns:V:xx:SORT_NAME','AUVINYA'),(64954377,'name','Aubinyà'),(64954377,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954377,'place','village'),(64954377,'source','gns_an'),(64954382,'created_by','Potlatch 0.8a'),(64954382,'gns:ADM1','00'),(64954382,'gns:N:xx:FULL_NAME','Juberri'),(64954382,'gns:N:xx:FULL_NAME_ND','Juberri'),(64954382,'gns:N:xx:NT','N'),(64954382,'gns:N:xx:SORT_NAME','JUBERRI'),(64954382,'gns:RC','1'),(64954382,'gns:UFI','-1395814'),(64954382,'gns:UNI','-2003564'),(64954382,'gns:V:xx:FULL_NAME','Juverri'),(64954382,'gns:V:xx:FULL_NAME_ND','Juverri'),(64954382,'gns:V:xx:NT','V'),(64954382,'gns:V:xx:SORT_NAME','JUVERRI'),(64954382,'name','Juberri'),(64954382,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954382,'place','village'),(64954382,'source','gns_an'),(64954385,'created_by','Potlatch 0.8a'),(64954385,'gns:ADM1','00'),(64954385,'gns:N:xx:FULL_NAME','Nagol'),(64954385,'gns:N:xx:FULL_NAME_ND','Nagol'),(64954385,'gns:N:xx:NT','N'),(64954385,'gns:N:xx:SORT_NAME','NAGOL'),(64954385,'gns:RC','1'),(64954385,'gns:UFI','-1396263'),(64954385,'gns:UNI','-2004023'),(64954385,'name','Nagol'),(64954385,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954385,'place','village'),(64954385,'source','gns_an'),(64954389,'created_by','Potlatch 0.10f'),(64954389,'gns:ADM1','00'),(64954389,'gns:N:xx:FULL_NAME','Anyós'),(64954389,'gns:N:xx:FULL_NAME_ND','Anyos'),(64954389,'gns:N:xx:NT','N'),(64954389,'gns:N:xx:SORT_NAME','ANYOS'),(64954389,'gns:RC','1'),(64954389,'gns:UFI','-1394459'),(64954389,'gns:UNI','-2002089'),(64954389,'name','Anyós'),(64954389,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954389,'place','hamlet'),(64954389,'source','gns_an'),(64954396,'created_by','Potlatch 0.8a'),(64954396,'gns:ADM1','00'),(64954396,'gns:N:xx:FULL_NAME','Els Vilars'),(64954396,'gns:N:xx:FULL_NAME_ND','Els Vilars'),(64954396,'gns:N:xx:NT','N'),(64954396,'gns:N:xx:SORT_NAME','ELSVILARS'),(64954396,'gns:RC','1'),(64954396,'gns:UFI','-1395318'),(64954396,'gns:UNI','-2003021'),(64954396,'name','Els Vilars'),(64954396,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954396,'place','hamlet'),(64954396,'source','gns_an'),(64954400,'created_by','JOSM'),(64954400,'gns:ADM1','00'),(64954400,'gns:N:xx:FULL_NAME','Bixessarri'),(64954400,'gns:N:xx:FULL_NAME_ND','Bixessarri'),(64954400,'gns:N:xx:NT','N'),(64954400,'gns:N:xx:SORT_NAME','BIXESSARRI'),(64954400,'gns:RC','1'),(64954400,'gns:UFI','-1394629'),(64954400,'gns:UNI','-2005085'),(64954400,'gns:V:xx:FULL_NAME','Vixesarri'),(64954400,'gns:V:xx:FULL_NAME_ND','Vixesarri'),(64954400,'gns:V:xx:MODIFY_DATE','1993-12-23'),(64954400,'gns:V:xx:NT','V'),(64954400,'gns:V:xx:SORT_NAME','VIXESARRI'),(64954400,'name','Bixessarri'),(64954400,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954400,'place','village'),(64954400,'source','gns_an'),(64954404,'created_by','Potlatch 0.8a'),(64954404,'gns:ADM1','00'),(64954404,'gns:N:xx:FULL_NAME','El Tarter'),(64954404,'gns:N:xx:FULL_NAME_ND','El Tarter'),(64954404,'gns:N:xx:NT','N'),(64954404,'gns:N:xx:SORT_NAME','ELTARTER'),(64954404,'gns:RC','1'),(64954404,'gns:UFI','-1395312'),(64954404,'gns:UNI','-2003015'),(64954404,'name','El Tarter'),(64954404,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954404,'place','village'),(64954404,'source','gns_an'),(64954409,'created_by','Potlatch 0.8a'),(64954409,'gns:ADM1','00'),(64954409,'gns:N:xx:FULL_NAME','Prats'),(64954409,'gns:N:xx:FULL_NAME_ND','Prats'),(64954409,'gns:N:xx:NT','N'),(64954409,'gns:N:xx:SORT_NAME','PRATS'),(64954409,'gns:RC','1'),(64954409,'gns:UFI','-1396638'),(64954409,'gns:UNI','-2004442'),(64954409,'name','Prats'),(64954409,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954409,'place','village'),(64954409,'source','gns_an'),(64954415,'created_by','Potlatch 0.9c'),(64954415,'gns:ADM1','00'),(64954415,'gns:N:xx:FULL_NAME','Sispony'),(64954415,'gns:N:xx:FULL_NAME_ND','Sispony'),(64954415,'gns:N:xx:NT','N'),(64954415,'gns:N:xx:SORT_NAME','SISPONY'),(64954415,'gns:RC','1'),(64954415,'gns:UFI','-1396951'),(64954415,'gns:UNI','-2004800'),(64954415,'name','Sispony'),(64954415,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954415,'place','hamlet'),(64954415,'source','gns_an'),(64954417,'created_by','Potlatch 0.8a'),(64954417,'gns:ADM1','00'),(64954417,'gns:N:xx:FULL_NAME','Els Plans'),(64954417,'gns:N:xx:FULL_NAME_ND','Els Plans'),(64954417,'gns:N:xx:NT','N'),(64954417,'gns:N:xx:SORT_NAME','ELSPLANS'),(64954417,'gns:RC','1'),(64954417,'gns:UFI','-1395303'),(64954417,'gns:UNI','-2003006'),(64954417,'name','Els Plans'),(64954417,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954417,'place','hamlet'),(64954417,'source','gns_an'),(64954422,'created_by','Potlatch 0.8a'),(64954422,'gns:ADM1','00'),(64954422,'gns:N:xx:FULL_NAME','L’Aldosa'),(64954422,'gns:N:xx:FULL_NAME_ND','L\'Aldosa'),(64954422,'gns:N:xx:NT','N'),(64954422,'gns:N:xx:SORT_NAME','LALDOSA'),(64954422,'gns:RC','1'),(64954422,'gns:UFI','-1395874'),(64954422,'gns:UNI','-2003610'),(64954422,'name','L’Aldosa de Canillo'),(64954422,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954422,'place','hamlet'),(64954422,'source','gns_an'),(64954429,'created_by','Potlatch 0.8a'),(64954429,'gns:ADM1','00'),(64954429,'gns:N:xx:FULL_NAME','Sant Pere'),(64954429,'gns:N:xx:FULL_NAME_ND','Sant Pere'),(64954429,'gns:N:xx:NT','N'),(64954429,'gns:N:xx:SORT_NAME','SANTPERE'),(64954429,'gns:RC','1'),(64954429,'gns:UFI','-1396873'),(64954429,'gns:UNI','-2004705'),(64954429,'name','Sant Pere'),(64954429,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954429,'place','village'),(64954429,'source','gns_an'),(64954433,'created_by','Potlatch 0.8a'),(64954433,'gns:N:xx:FULL_NAME','Canillo'),(64954433,'gns:N:xx:FULL_NAME_ND','Canillo'),(64954433,'name','Canillo'),(64954433,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954433,'place','town'),(64954433,'source','gns_an'),(64954435,'created_by','Potlatch 0.9a'),(64954435,'gns:ADM1','00'),(64954435,'gns:N:xx:FULL_NAME','Sornás'),(64954435,'gns:N:xx:FULL_NAME_ND','Sornas'),(64954435,'gns:N:xx:NT','N'),(64954435,'gns:N:xx:SORT_NAME','SORNAS'),(64954435,'gns:RC','1'),(64954435,'gns:UFI','-1397041'),(64954435,'gns:UNI','-2004894'),(64954435,'name','Sornás'),(64954435,'note','Experimental import of Andorrian places and POIs from GNS Dataset - corrected by user 3ld'),(64954435,'place','village'),(64954435,'source','gns_an'),(64954441,'created_by','Potlatch 0.8c'),(64954441,'gns:ADM1','00'),(64954441,'gns:N:xx:FULL_NAME','Sant Joan de Caselles'),(64954441,'gns:N:xx:FULL_NAME_ND','Sant Joan de Caselles'),(64954441,'gns:N:xx:NT','N'),(64954441,'gns:N:xx:SORT_NAME','SANTJOANDECASELLES'),(64954441,'gns:RC','1'),(64954441,'gns:UFI','-1396861'),(64954441,'gns:UNI','-2004686'),(64954441,'gns:V:xx:FULL_NAME','Sant Joan de Casellas'),(64954441,'gns:V:xx:FULL_NAME_ND','Sant Joan de Casellas'),(64954441,'gns:V:xx:MODIFY_DATE','1993-12-23'),(64954441,'gns:V:xx:NT','V'),(64954441,'gns:V:xx:SORT_NAME','SANTJOANDECASELLAS'),(64954441,'name','Sant Joan de Caselles'),(64954441,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954441,'place','hamlet'),(64954441,'source','gns_an'),(64954447,'created_by','Potlatch 0.9c'),(64954447,'gns:ADM1','00'),(64954447,'gns:N:xx:FULL_NAME','L’Aldosa'),(64954447,'gns:N:xx:FULL_NAME_ND','L\'Aldosa'),(64954447,'gns:N:xx:NT','N'),(64954447,'gns:N:xx:SORT_NAME','LALDOSA'),(64954447,'gns:RC','1'),(64954447,'gns:UFI','-1395873'),(64954447,'gns:UNI','-2003609'),(64954447,'name','L’Aldosa'),(64954447,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954447,'place','hamlet'),(64954447,'source','gns_an'),(64954451,'created_by','Potlatch 0.8a'),(64954451,'gns:ADM1','00'),(64954451,'gns:N:xx:FULL_NAME','El Serrat'),(64954451,'gns:N:xx:FULL_NAME_ND','El Serrat'),(64954451,'gns:N:xx:NT','N'),(64954451,'gns:N:xx:SORT_NAME','ELSERRAT'),(64954451,'gns:RC','1'),(64954451,'gns:UFI','-1395275'),(64954451,'gns:UNI','-2003810'),(64954451,'gns:V:xx:FULL_NAME','Lo Serrat'),(64954451,'gns:V:xx:FULL_NAME_ND','Lo Serrat'),(64954451,'gns:V:xx:MODIFY_DATE','1993-12-23'),(64954451,'gns:V:xx:NT','V'),(64954451,'gns:V:xx:SORT_NAME','LOSERRAT'),(64954451,'name','El Serrat'),(64954451,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954451,'place','village'),(64954451,'source','gns_an'),(64954457,'created_by','Potlatch 0.8a'),(64954457,'gns:ADM1','00'),(64954457,'gns:N:xx:FULL_NAME','Ransol'),(64954457,'gns:N:xx:FULL_NAME_ND','Ransol'),(64954457,'gns:N:xx:NT','N'),(64954457,'gns:N:xx:SORT_NAME','RANSOL'),(64954457,'gns:RC','1'),(64954457,'gns:UFI','-1396705'),(64954457,'gns:UNI','-2004518'),(64954457,'name','Ransol'),(64954457,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954457,'place','village'),(64954457,'source','gns_an'),(64954460,'created_by','Potlatch 0.9a'),(64954460,'gns:ADM1','00'),(64954460,'gns:N:xx:FULL_NAME','El Pui'),(64954460,'gns:N:xx:FULL_NAME_ND','El Pui'),(64954460,'gns:N:xx:NT','N'),(64954460,'gns:N:xx:SORT_NAME','ELPUI'),(64954460,'gns:RC','1'),(64954460,'gns:UFI','-1395245'),(64954460,'gns:UNI','-2002947'),(64954460,'name','El Pui'),(64954460,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954460,'place','hamlet'),(64954460,'source','gns_an'),(64954464,'created_by','Potlatch 0.10b'),(64954464,'gns:ADM1','00'),(64954464,'gns:N:xx:FULL_NAME','Vila'),(64954464,'gns:N:xx:FULL_NAME_ND','Vila'),(64954464,'gns:N:xx:NT','N'),(64954464,'gns:N:xx:SORT_NAME','VILA'),(64954464,'gns:RC','1'),(64954464,'gns:UFI','-1397198'),(64954464,'gns:UNI','-2005072'),(64954464,'gns:V:xx:FULL_NAME','Casas Vila'),(64954464,'gns:V:xx:FULL_NAME_ND','Casas Vila'),(64954464,'gns:V:xx:MODIFY_DATE','1993-12-23'),(64954464,'gns:V:xx:NT','V'),(64954464,'gns:V:xx:SORT_NAME','CASASVILA'),(64954464,'name','Vila'),(64954464,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954464,'place','village'),(64954464,'source','gns_an'),(64954467,'created_by','Potlatch 0.9c'),(64954467,'gns:ADM1','00'),(64954467,'gns:N:xx:FULL_NAME','Erts'),(64954467,'gns:N:xx:FULL_NAME_ND','Erts'),(64954467,'gns:N:xx:SORT_NAME','ERTS'),(64954467,'gns:RC','1'),(64954467,'gns:UFI','-1395403'),(64954467,'gns:UNI','-2003119'),(64954467,'gns:V:xx:FULL_NAME','Erez'),(64954467,'gns:V:xx:FULL_NAME_ND','Erez'),(64954467,'gns:V:xx:MODIFY_DATE','1993-12-23'),(64954467,'gns:V:xx:SORT_NAME','EREZ'),(64954467,'name','Erts'),(64954467,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954467,'place','village'),(64954467,'source','gns_an'),(64954472,'created_by','Potlatch 0.9a'),(64954472,'gns:ADM1','00'),(64954472,'gns:N:xx:FULL_NAME','Ansalonga'),(64954472,'gns:N:xx:FULL_NAME_ND','Ansalonga'),(64954472,'gns:N:xx:NT','N'),(64954472,'gns:N:xx:SORT_NAME','ANSALONGA'),(64954472,'gns:RC','1'),(64954472,'gns:UFI','-1394456'),(64954472,'gns:UNI','-2002086'),(64954472,'name','Ansalonga'),(64954472,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954472,'place','village'),(64954472,'source','gns_an'),(64954477,'created_by','Potlatch 0.8a'),(64954477,'gns:ADM1','00'),(64954477,'gns:N:xx:FULL_NAME','Engordany'),(64954477,'gns:N:xx:FULL_NAME_ND','Engordany'),(64954477,'gns:N:xx:NT','N'),(64954477,'gns:N:xx:SORT_NAME','ENGORDANY'),(64954477,'gns:RC','1'),(64954477,'gns:UFI','-1395364'),(64954477,'gns:UNI','-2003073'),(64954477,'name','Engordany'),(64954477,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954477,'place','village'),(64954477,'source','gns_an'),(64954483,'created_by','Potlatch 0.10f'),(64954483,'gns:ADM1','00'),(64954483,'gns:N:xx:FULL_NAME','Arinsal'),(64954483,'gns:N:xx:FULL_NAME_ND','Arinsal'),(64954483,'gns:N:xx:NT','N'),(64954483,'gns:N:xx:SORT_NAME','ARINSAL'),(64954483,'gns:RC','1'),(64954483,'gns:UFI','-1394484'),(64954483,'gns:UNI','-2002121'),(64954483,'name','Arinsal'),(64954483,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954483,'place','village'),(64954483,'source','gns_an'),(64954486,'created_by','Potlatch 0.8a'),(64954486,'gns:N:xx:FULL_NAME_ND','Sant Julia de Loria'),(64954486,'gns:V:xx:FULL_NAME','Sant Juliá'),(64954486,'gns:V:xx:FULL_NAME_ND','Sant Julia'),(64954486,'gns:V:xx:MODIFY_DATE','2004-05-05'),(64954486,'name','Sant Julià de Lòria'),(64954486,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954486,'place','town'),(64954486,'source','gns_an'),(64954492,'created_by','Potlatch 0.8a'),(64954492,'gns:ADM1','00'),(64954492,'gns:N:xx:FULL_NAME','Les Bons'),(64954492,'gns:N:xx:FULL_NAME_ND','Les Bons'),(64954492,'gns:N:xx:NT','N'),(64954492,'gns:N:xx:SORT_NAME','LESBONS'),(64954492,'gns:RC','1'),(64954492,'gns:UFI','-1395948'),(64954492,'gns:UNI','-2003690'),(64954492,'gns:V:xx:FULL_NAME','Els Bons'),(64954492,'gns:V:xx:FULL_NAME_ND','Els Bons'),(64954492,'gns:V:xx:MODIFY_DATE','1993-12-23'),(64954492,'gns:V:xx:NT','V'),(64954492,'gns:V:xx:SORT_NAME','ELSBONS'),(64954492,'name','Les Bons'),(64954492,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954492,'place','hamlet'),(64954492,'source','gns_an'),(64954503,'created_by','Potlatch 0.9c'),(64954503,'gns:ADM1','00'),(64954503,'gns:N:xx:FULL_NAME','Puiol del Piu'),(64954503,'gns:N:xx:FULL_NAME_ND','Puiol del Piu'),(64954503,'gns:N:xx:NT','N'),(64954503,'gns:N:xx:SORT_NAME','PUIOLDELPIU'),(64954503,'gns:RC','1'),(64954503,'gns:UFI','-1396654'),(64954503,'gns:UNI','-2004458'),(64954503,'name','Puiol del Piu'),(64954503,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954503,'place','hamlet'),(64954503,'source','gns_an'),(64954508,'created_by','Potlatch 0.10f'),(64954508,'gns:ADM1','00'),(64954508,'gns:N:xx:FULL_NAME','Fontaneda'),(64954508,'gns:N:xx:FULL_NAME_ND','Fontaneda'),(64954508,'gns:N:xx:NT','N'),(64954508,'gns:N:xx:SORT_NAME','FONTANEDA'),(64954508,'gns:RC','1'),(64954508,'gns:UFI','-1395576'),(64954508,'gns:UNI','-2003297'),(64954508,'name','Fontaneda'),(64954508,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954508,'place','village'),(64954508,'source','gns_an'),(64954512,'created_by','Potlatch 0.9c'),(64954512,'gns:ADM1','00'),(64954512,'gns:N:xx:FULL_NAME','Santa Coloma'),(64954512,'gns:N:xx:FULL_NAME_ND','Santa Coloma'),(64954512,'gns:N:xx:NT','N'),(64954512,'gns:N:xx:SORT_NAME','SANTACOLOMA'),(64954512,'gns:RC','1'),(64954512,'gns:UFI','-1396846'),(64954512,'gns:UNI','-2004669'),(64954512,'name','Santa Coloma'),(64954512,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954512,'place','village'),(64954512,'source','gns_an'),(64954515,'created_by','Potlatch 0.8a'),(64954515,'gns:ADM1','00'),(64954515,'gns:N:xx:FULL_NAME','Pal'),(64954515,'gns:N:xx:FULL_NAME_ND','Pal'),(64954515,'gns:N:xx:NT','N'),(64954515,'gns:N:xx:SORT_NAME','PAL'),(64954515,'gns:RC','1'),(64954515,'gns:UFI','-1396388'),(64954515,'gns:UNI','-2004163'),(64954515,'name','Pal'),(64954515,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954515,'place','village'),(64954515,'source','gns_an'),(64954521,'created_by','Potlatch 0.8a'),(64954521,'gns:ADM1','00'),(64954521,'gns:N:xx:FULL_NAME','Xixerella'),(64954521,'gns:N:xx:FULL_NAME_ND','Xixerella'),(64954521,'gns:N:xx:NT','N'),(64954521,'gns:N:xx:SORT_NAME','XIXERELLA'),(64954521,'gns:RC','1'),(64954521,'gns:UFI','-1397214'),(64954521,'gns:UNI','-2005091'),(64954521,'name','Xixerella'),(64954521,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954521,'place','village'),(64954521,'source','gns_an'),(64954525,'created_by','Potlatch 0.8a'),(64954525,'gns:ADM1','00'),(64954525,'gns:N:xx:FULL_NAME','Aixovall'),(64954525,'gns:N:xx:FULL_NAME_ND','Aixovall'),(64954525,'gns:N:xx:NT','N'),(64954525,'gns:N:xx:SORT_NAME','AIXOVALL'),(64954525,'gns:RC','1'),(64954525,'gns:UFI','-1394403'),(64954525,'gns:UNI','-2002009'),(64954525,'name','Aixovall'),(64954525,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954525,'place','village'),(64954525,'source','gns_an'),(64954531,'created_by','Potlatch 0.9c'),(64954531,'gns:ADM1','00'),(64954531,'gns:N:xx:FULL_NAME','Llorts'),(64954531,'gns:N:xx:FULL_NAME_ND','Llorts'),(64954531,'gns:N:xx:NT','N'),(64954531,'gns:N:xx:SORT_NAME','LLORTS'),(64954531,'gns:RC','1'),(64954531,'gns:UFI','-1396036'),(64954531,'gns:UNI','-2003809'),(64954531,'gns:V:xx:FULL_NAME','Lors'),(64954531,'gns:V:xx:FULL_NAME_ND','Lors'),(64954531,'gns:V:xx:MODIFY_DATE','1993-12-23'),(64954531,'gns:V:xx:NT','V'),(64954531,'gns:V:xx:SORT_NAME','LORS'),(64954531,'name','Llorts'),(64954531,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954531,'place','village'),(64954531,'source','gns_an'),(64954538,'created_by','Potlatch 0.9c'),(64954538,'gns:ADM1','00'),(64954538,'gns:N:xx:FULL_NAME','Soldeu'),(64954538,'gns:N:xx:FULL_NAME_ND','Soldeu'),(64954538,'gns:N:xx:NT','N'),(64954538,'gns:N:xx:SORT_NAME','SOLDEU'),(64954538,'gns:RC','1'),(64954538,'gns:UFI','-1397029'),(64954538,'gns:UNI','-2004879'),(64954538,'name','Soldeu'),(64954538,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954538,'place','village'),(64954538,'source','gns_an'),(64954542,'created_by','Potlatch 0.9c'),(64954542,'gns:ADM1','00'),(64954542,'gns:N:xx:FULL_NAME','Mas de Ribafeta'),(64954542,'gns:N:xx:FULL_NAME_ND','Mas de Ribafeta'),(64954542,'gns:N:xx:NT','N'),(64954542,'gns:N:xx:SORT_NAME','MASDERIBAFETA'),(64954542,'gns:RC','1'),(64954542,'gns:UFI','-1396119'),(64954542,'gns:UNI','-2003869'),(64954542,'name','Mas de Ribafeta'),(64954542,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954542,'place','hamlet'),(64954542,'source','gns_an'),(64954546,'created_by','Potlatch 0.9c'),(64954546,'gns:ADM1','00'),(64954546,'gns:N:xx:FULL_NAME','La Cortinada'),(64954546,'gns:N:xx:FULL_NAME_ND','La Cortinada'),(64954546,'gns:N:xx:NT','N'),(64954546,'gns:N:xx:SORT_NAME','LACORTINADA'),(64954546,'gns:RC','1'),(64954546,'gns:UFI','-1395860'),(64954546,'gns:UNI','-2003596'),(64954546,'name','La Cortinada'),(64954546,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954546,'place','village'),(64954546,'source','gns_an'),(64954554,'created_by','Potlatch 0.8a'),(64954554,'gns:ADM1','00'),(64954554,'gns:N:xx:FULL_NAME','Llumeneres'),(64954554,'gns:N:xx:FULL_NAME_ND','Llumeneres'),(64954554,'gns:N:xx:NT','N'),(64954554,'gns:N:xx:SORT_NAME','LLUMENERES'),(64954554,'gns:RC','1'),(64954554,'gns:UFI','-1396056'),(64954554,'gns:UNI','-2003801'),(64954554,'name','Llumeneres'),(64954554,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954554,'place','village'),(64954554,'source','gns_an'),(64954560,'created_by','Potlatch 0.8c'),(64954560,'gns:ADM1','00'),(64954560,'gns:N:xx:FULL_NAME','Arans'),(64954560,'gns:N:xx:FULL_NAME_ND','Arans'),(64954560,'gns:N:xx:NT','N'),(64954560,'gns:N:xx:SORT_NAME','ARANS'),(64954560,'gns:RC','1'),(64954560,'gns:UFI','-1394461'),(64954560,'gns:UNI','-2002092'),(64954560,'name','Arans'),(64954560,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954560,'place','village'),(64954560,'source','gns_an'),(64954563,'created_by','Potlatch 0.8b'),(64954563,'gns:ADM1','04'),(64954563,'gns:V:xx:FULL_NAME','La Maçana'),(64954563,'gns:V:xx:FULL_NAME_ND','La Macana'),(64954563,'name','La Massana'),(64954563,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954563,'place','town'),(64954563,'source','gns_an'),(64954565,'created_by','Potlatch 0.8c'),(64954565,'gns:ADM1','00'),(64954565,'gns:N:xx:FULL_NAME','Escàs'),(64954565,'gns:N:xx:FULL_NAME_ND','Escas'),(64954565,'gns:N:xx:NT','N'),(64954565,'gns:N:xx:SORT_NAME','ESCAS'),(64954565,'gns:RC','1'),(64954565,'gns:UFI','-1395411'),(64954565,'gns:UNI','-2003129'),(64954565,'name','Escàs'),(64954565,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954565,'place','hamlet'),(64954565,'source','gns_an'),(64954570,'created_by','Potlatch 0.9a'),(64954570,'gns:ADM1','00'),(64954570,'gns:N:xx:FULL_NAME','Segudet'),(64954570,'gns:N:xx:FULL_NAME_ND','Segudet'),(64954570,'gns:N:xx:NT','N'),(64954570,'gns:N:xx:SORT_NAME','SEGUDET'),(64954570,'gns:RC','1'),(64954570,'gns:UFI','-1396896'),(64954570,'gns:UNI','-2004734'),(64954570,'name','Segudet'),(64954570,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954570,'place','village'),(64954570,'source','gns_an'),(64954584,'created_by','Potlatch 0.8a'),(64954584,'gns:ADM1','03'),(64954584,'gns:N:xx:FULL_NAME','Encamp'),(64954584,'gns:N:xx:FULL_NAME_ND','Encamp'),(64954584,'gns:RC','1'),(64954584,'gns:UFI','-1395326'),(64954584,'gns:UNI','-2003031'),(64954584,'name','Encamp'),(64954584,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954584,'place','town'),(64954584,'source','gns_an'),(64954589,'created_by','Potlatch 0.8b'),(64954589,'gns:ADM1','08'),(64954589,'gns:N:xx:FULL_NAME','Les Escaldes'),(64954589,'gns:N:xx:FULL_NAME_ND','Les Escaldes'),(64954589,'gns:N:xx:NT','N'),(64954589,'gns:N:xx:SHORT_FORM','Escaldes'),(64954589,'gns:N:xx:SORT_NAME','LESESCALDES'),(64954589,'gns:RC','1'),(64954589,'gns:UFI','-1395964'),(64954589,'gns:UNI','-2003706'),(64954589,'gns:V:xx:FULL_NAME','Las Escadas'),(64954589,'gns:V:xx:FULL_NAME_ND','Las Escadas'),(64954589,'gns:V:xx:MODIFY_DATE','2004-05-05'),(64954589,'gns:V:xx:NT','V'),(64954589,'gns:V:xx:SORT_NAME','LASESCADAS'),(64954589,'name','Les Escaldes'),(64954589,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954589,'place','town'),(64954589,'source','gns_an'),(64954593,'created_by','Potlatch 0.8a'),(64954593,'gns:ADM1','00'),(64954593,'gns:N:xx:FULL_NAME','Aixirivall'),(64954593,'gns:N:xx:FULL_NAME_ND','Aixirivall'),(64954593,'gns:N:xx:NT','N'),(64954593,'gns:N:xx:SORT_NAME','AIXIRIVALL'),(64954593,'gns:RC','1'),(64954593,'gns:UFI','-1394397'),(64954593,'gns:UNI','-2150077'),(64954593,'gns:V:xx:FULL_NAME','Eixirivall'),(64954593,'gns:V:xx:FULL_NAME_ND','Eixirivall'),(64954593,'gns:V:xx:MODIFY_DATE','1993-12-23'),(64954593,'gns:V:xx:NT','V'),(64954593,'gns:V:xx:SORT_NAME','EIXIRIVALL'),(64954593,'name','Aixirivall'),(64954593,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954593,'place','village'),(64954593,'source','gns_an'),(64954598,'created_by','Potlatch 0.8a'),(64954598,'gns:ADM1','00'),(64954598,'gns:N:xx:FULL_NAME','Certers'),(64954598,'gns:N:xx:FULL_NAME_ND','Certers'),(64954598,'gns:N:xx:NT','N'),(64954598,'gns:N:xx:SORT_NAME','CERTERS'),(64954598,'gns:RC','1'),(64954598,'gns:UFI','-1394910');
INSERT INTO `current_node_tags` VALUES (64954598,'gns:UNI','-2004772'),(64954598,'gns:V:xx:FULL_NAME','Sertes'),(64954598,'gns:V:xx:FULL_NAME_ND','Sertes'),(64954598,'gns:V:xx:MODIFY_DATE','1993-12-23'),(64954598,'gns:V:xx:NT','V'),(64954598,'gns:V:xx:SORT_NAME','SERTES'),(64954598,'name','Certers'),(64954598,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954598,'place','village'),(64954598,'source','gns_an'),(64954601,'created_by','Potlatch 0.8a'),(64954601,'gns:ADM1','00'),(64954601,'gns:N:xx:FULL_NAME','Meritxell'),(64954601,'gns:N:xx:FULL_NAME_ND','Meritxell'),(64954601,'gns:N:xx:NT','N'),(64954601,'gns:N:xx:SORT_NAME','MERITXELL'),(64954601,'gns:RC','1'),(64954601,'gns:UFI','-1396155'),(64954601,'gns:UNI','-2004711'),(64954601,'gns:V:xx:FULL_NAME','Santuari de Meritxell'),(64954601,'gns:V:xx:FULL_NAME_ND','Santuari de Meritxell'),(64954601,'gns:V:xx:MODIFY_DATE','1993-12-23'),(64954601,'gns:V:xx:NT','V'),(64954601,'gns:V:xx:SORT_NAME','SANTUARIDEMERITXELL'),(64954601,'name','Meritxell'),(64954601,'note','Experimental import of Andorrian places and POIs from GNS Dataset'),(64954601,'place','village'),(64954601,'source','gns_an'),(148874198,'capital_city','Andorra la Vella'),(148874198,'country_code_iso3166_1_alpha_2','AD'),(148874198,'is_in:continent','Europe'),(148874198,'name','Andorra'),(148874198,'name:ar','??????'),(148874198,'name:be','??????'),(148874198,'name:bg','??????'),(148874198,'name:br','Andorra'),(148874198,'name:ca','Andorra'),(148874198,'name:el','???????'),(148874198,'name:eo','Andoro'),(148874198,'name:eu','Andorra'),(148874198,'name:fa','??????'),(148874198,'name:fi','Andorra'),(148874198,'name:fr','Andorre'),(148874198,'name:ga','Andóra'),(148874198,'name:haw','‘Anakola'),(148874198,'name:he','??????'),(148874198,'name:hr','Andora'),(148874198,'name:hu','Andorra'),(148874198,'name:hy','???????'),(148874198,'name:is','Andorra'),(148874198,'name:it','Andorra'),(148874198,'name:ja','????'),(148874198,'name:ka','??????'),(148874198,'name:ko','???'),(148874198,'name:lt','Andora'),(148874198,'name:lv','Andora'),(148874198,'name:mn','???????'),(148874198,'name:oc','Andòrra'),(148874198,'name:pl','Andora'),(148874198,'name:pt','Andorra'),(148874198,'name:ru','???????'),(148874198,'name:sco','Andorrae'),(148874198,'name:sk','Andorra'),(148874198,'name:sl','Andora'),(148874198,'name:sv','Andorra'),(148874198,'name:tg','???????'),(148874198,'name:th','???????????????'),(148874198,'name:uk','??????'),(148874198,'name:zh','???'),(148874198,'name:zh_pinyin','?ndào?r'),(148874198,'official_name:cy','Tywysogaeth Andorra'),(148874198,'official_name:el','?????????? ??? ????????'),(148874198,'official_name:fi','Andorran ruhtinaskunta'),(148874198,'official_name:fr','Principauté d\'Andorre'),(148874198,'official_name:id','Kepangeranan Andorra'),(148874198,'official_name:ja','??????'),(148874198,'official_name:la','Principatus Andorrae'),(148874198,'official_name:lt','Andoros Kunigaikštyst?'),(148874198,'official_name:lv','Andoras Firstiste'),(148874198,'official_name:pt','Principado de Andorra'),(148874198,'official_name:sk','Andorrské kniežatstvo'),(148874198,'official_name:sv','Furstendömet Andorra'),(148874198,'official_name:vi','Công qu?c Andorra'),(148874198,'place','country'),(148874198,'population','94609'),(148874198,'wikipedia:fr','Andorre'),(206332846,'ele','2408'),(206332846,'mountain_pass','yes'),(206332846,'name','Port d\'Envalira'),(206332846,'wikipedia','http://de.wikipedia.org/wiki/Port_d%E2%80%99Envalira'),(247045686,'created_by','JOSM'),(247045688,'created_by','JOSM'),(247045690,'created_by','JOSM'),(247045691,'created_by','JOSM'),(247045693,'created_by','JOSM'),(247045695,'created_by','JOSM'),(247045696,'created_by','JOSM'),(247045698,'created_by','JOSM'),(247045700,'created_by','JOSM'),(247045701,'created_by','JOSM'),(247045703,'created_by','JOSM'),(247045712,'created_by','JOSM'),(247045718,'created_by','JOSM'),(247045724,'created_by','JOSM'),(247045732,'created_by','JOSM'),(247045739,'created_by','JOSM'),(247045741,'created_by','JOSM'),(247045742,'created_by','JOSM'),(247045744,'created_by','JOSM'),(247046008,'created_by','JOSM'),(247046009,'created_by','JOSM'),(247046010,'created_by','JOSM'),(247046011,'created_by','JOSM'),(247046012,'created_by','JOSM'),(247046013,'created_by','JOSM'),(247046014,'created_by','JOSM'),(247046015,'created_by','JOSM'),(247046016,'created_by','JOSM'),(247046017,'created_by','JOSM'),(247046018,'created_by','JOSM'),(247046019,'created_by','JOSM'),(247046020,'created_by','JOSM'),(247046021,'created_by','JOSM'),(247046022,'created_by','JOSM'),(247046023,'created_by','JOSM'),(247046024,'created_by','JOSM'),(247046025,'created_by','JOSM'),(247046026,'created_by','JOSM'),(247046027,'created_by','JOSM'),(247046028,'created_by','JOSM'),(247046029,'created_by','JOSM'),(247046030,'created_by','JOSM'),(247046031,'created_by','JOSM'),(247046032,'created_by','JOSM'),(247046033,'created_by','JOSM'),(247046034,'created_by','JOSM'),(247046035,'created_by','JOSM'),(247046036,'created_by','JOSM'),(247046037,'created_by','JOSM'),(247046038,'created_by','JOSM'),(247046039,'created_by','JOSM'),(247046040,'created_by','JOSM'),(247046041,'created_by','JOSM'),(247046042,'created_by','JOSM'),(247046043,'created_by','JOSM'),(247046044,'created_by','JOSM'),(247046045,'created_by','JOSM'),(247046046,'created_by','JOSM'),(247046047,'created_by','JOSM'),(247046048,'created_by','JOSM'),(247046072,'created_by','JOSM'),(247046073,'created_by','JOSM'),(247046074,'created_by','JOSM'),(247046075,'created_by','JOSM'),(247046076,'created_by','JOSM'),(247046077,'created_by','JOSM'),(247046078,'created_by','JOSM'),(247046079,'created_by','JOSM'),(258355185,'created_by','Potlatch 0.8a'),(258355185,'is_in','La Massana'),(258355185,'name','Super Pal'),(258355185,'place','hamlet'),(258356188,'created_by','Potlatch 0.8a'),(258356188,'name','Vallnord: Sector Pal'),(258356188,'sport','skiing'),(258356379,'created_by','Potlatch 0.8a'),(258356379,'name','Vallnord: Sector Arinsal'),(258356379,'sport','skiing'),(258357981,'created_by','Potlatch 0.8a'),(258357981,'name','Vallnord: Sector Arcalis'),(258357981,'sport','skiing'),(258361905,'created_by','Potlatch 0.8a'),(258361905,'is_in','Encamp'),(258361905,'name','Grau Roig'),(258361905,'place','village'),(258823161,'created_by','JOSM'),(259475446,'highway','mini_roundabout'),(259476084,'amenity','fuel'),(259476084,'created_by','Potlatch 0.8b'),(259476084,'operator','ESSO'),(260996387,'highway','mini_roundabout'),(262464083,'highway','traffic_signals'),(262466673,'created_by','Potlatch 0.8c'),(262466673,'name','el Vilar'),(262466673,'place','hamlet'),(262472865,'name','Coll d\'Ordino'),(262472865,'tourism','viewpoint'),(262473157,'created_by','Potlatch 0.9a'),(262473157,'description','Looks like Totem Poles'),(262473157,'name','Estructures Autogeneradores'),(262473157,'tourism','artwork'),(262473680,'created_by','Potlatch 0.8c'),(262473680,'is_in','Canillo'),(262473680,'name','el Forn'),(262473680,'place','hamlet'),(262892996,'created_by','JOSM'),(262892997,'created_by','JOSM'),(262892998,'created_by','JOSM'),(262892999,'created_by','JOSM'),(262893000,'created_by','JOSM'),(262893001,'created_by','JOSM'),(262893002,'created_by','JOSM'),(262893003,'created_by','JOSM'),(264053391,'created_by','Potlatch 0.9a'),(264053391,'name','Lloc de Repos de Redort'),(264053391,'tourism','picnic_site'),(264272401,'amenity','parking'),(264331306,'highway','speed_camera'),(264465123,'created_by','JOSM'),(264465125,'created_by','JOSM'),(264465125,'highway','mini_roundabout'),(264465126,'created_by','JOSM'),(264465127,'created_by','JOSM'),(264465128,'created_by','JOSM'),(264465129,'created_by','JOSM'),(264465130,'created_by','JOSM'),(264496511,'created_by','Potlatch 0.9a'),(264496511,'is_in','la Massana'),(264496511,'name','el Cortalet'),(264496511,'place','hamlet'),(264496540,'created_by','Potlatch 0.9a'),(264496540,'is_in','la Massana'),(264496540,'name','el Bosquet'),(264496540,'place','hamlet'),(264932311,'created_by','JOSM'),(264932314,'created_by','JOSM'),(264932315,'created_by','JOSM'),(264932316,'created_by','JOSM'),(264932317,'created_by','JOSM'),(264932318,'created_by','JOSM'),(264932319,'created_by','JOSM'),(264932321,'created_by','JOSM'),(264932322,'created_by','JOSM'),(264932325,'created_by','JOSM'),(264932326,'created_by','JOSM'),(264932327,'created_by','JOSM'),(264932328,'created_by','JOSM'),(264932329,'created_by','JOSM'),(264932330,'created_by','JOSM'),(264932340,'created_by','JOSM'),(264932341,'created_by','JOSM'),(264932342,'created_by','JOSM'),(264932343,'created_by','JOSM'),(264932344,'created_by','JOSM'),(264932345,'created_by','JOSM'),(264932347,'created_by','JOSM'),(264932348,'created_by','JOSM'),(264932349,'created_by','JOSM'),(264932350,'created_by','JOSM'),(264932351,'created_by','JOSM'),(264932352,'created_by','JOSM'),(264932353,'created_by','JOSM'),(264932354,'created_by','JOSM'),(264932355,'created_by','JOSM'),(264932356,'created_by','JOSM'),(264932357,'created_by','JOSM'),(264932359,'created_by','JOSM'),(264932360,'created_by','JOSM'),(264932361,'created_by','JOSM'),(264932362,'created_by','JOSM'),(264932363,'created_by','JOSM'),(264932364,'created_by','JOSM'),(264932365,'created_by','JOSM'),(264932366,'created_by','JOSM'),(264932367,'created_by','JOSM'),(264932368,'created_by','JOSM'),(264932370,'created_by','JOSM'),(264932371,'created_by','JOSM'),(264932372,'created_by','JOSM'),(264932373,'created_by','JOSM'),(264932374,'created_by','JOSM'),(264932375,'created_by','JOSM'),(264932376,'created_by','JOSM'),(264932377,'created_by','JOSM'),(264932379,'created_by','JOSM'),(264932380,'created_by','JOSM'),(264932381,'created_by','JOSM'),(264932382,'created_by','JOSM'),(264932383,'created_by','JOSM'),(264932384,'created_by','JOSM'),(264932386,'created_by','JOSM'),(264932387,'created_by','JOSM'),(264932388,'created_by','JOSM'),(264932390,'created_by','JOSM'),(264932393,'created_by','JOSM'),(264932395,'created_by','JOSM'),(264932396,'created_by','JOSM'),(264932397,'created_by','JOSM'),(264932398,'created_by','JOSM'),(264932399,'created_by','JOSM'),(264932400,'created_by','JOSM'),(264932401,'created_by','JOSM'),(264932402,'created_by','JOSM'),(264932404,'created_by','JOSM'),(264932405,'created_by','JOSM'),(264932406,'created_by','JOSM'),(264932407,'created_by','JOSM'),(264932408,'created_by','JOSM'),(264932409,'created_by','JOSM'),(264932410,'created_by','JOSM'),(264932411,'created_by','JOSM'),(264932412,'created_by','JOSM'),(264932414,'created_by','JOSM'),(264932415,'created_by','JOSM'),(264932416,'created_by','JOSM'),(264932417,'created_by','JOSM'),(264932420,'created_by','JOSM'),(264932427,'created_by','JOSM'),(264932428,'created_by','JOSM'),(264932429,'created_by','JOSM'),(264932430,'created_by','JOSM'),(264932431,'created_by','JOSM'),(264932432,'created_by','JOSM'),(264932433,'created_by','JOSM'),(264932435,'created_by','JOSM'),(264932436,'created_by','JOSM'),(264932437,'created_by','JOSM'),(264932438,'created_by','JOSM'),(264932439,'created_by','JOSM'),(264932440,'created_by','JOSM'),(264932441,'created_by','JOSM'),(264932442,'created_by','JOSM'),(264932444,'created_by','JOSM'),(264932445,'created_by','JOSM'),(264932446,'created_by','JOSM'),(264932447,'created_by','JOSM'),(264932448,'created_by','JOSM'),(264932449,'created_by','JOSM'),(264932450,'created_by','JOSM'),(264932451,'created_by','JOSM'),(264932452,'created_by','JOSM'),(264932453,'created_by','JOSM'),(264932454,'created_by','JOSM'),(264932456,'created_by','JOSM'),(264932457,'created_by','JOSM'),(264932458,'created_by','JOSM'),(264932459,'created_by','JOSM'),(264932460,'created_by','JOSM'),(264932461,'created_by','JOSM'),(264932462,'created_by','JOSM'),(264932463,'created_by','JOSM'),(264932464,'created_by','JOSM'),(264932465,'created_by','JOSM'),(264932466,'created_by','JOSM'),(264932467,'created_by','JOSM'),(264932469,'created_by','JOSM'),(264932470,'created_by','JOSM'),(264932471,'created_by','JOSM'),(264932472,'created_by','JOSM'),(264932473,'created_by','JOSM'),(264932474,'created_by','JOSM'),(264932475,'created_by','JOSM'),(264932476,'created_by','JOSM'),(264932477,'created_by','JOSM'),(264932478,'created_by','JOSM'),(264932479,'created_by','JOSM'),(264932481,'created_by','JOSM'),(264932482,'created_by','JOSM'),(264932483,'created_by','JOSM'),(264932484,'created_by','JOSM'),(264932486,'created_by','JOSM'),(264932487,'created_by','JOSM'),(264932488,'created_by','JOSM'),(264932489,'created_by','JOSM'),(264932490,'created_by','JOSM'),(264932491,'created_by','JOSM'),(264932492,'created_by','JOSM'),(264932493,'created_by','JOSM'),(264932495,'created_by','JOSM'),(264932496,'created_by','JOSM'),(264932497,'created_by','JOSM'),(264932498,'created_by','JOSM'),(264932499,'created_by','JOSM'),(264932500,'created_by','JOSM'),(264932501,'created_by','JOSM'),(264932529,'created_by','JOSM'),(264932531,'created_by','JOSM'),(264932532,'created_by','JOSM'),(264932534,'created_by','JOSM'),(264932535,'created_by','JOSM'),(264932536,'created_by','JOSM'),(264932537,'created_by','JOSM'),(264932538,'created_by','JOSM'),(264932539,'created_by','JOSM'),(264932540,'created_by','JOSM'),(264932541,'created_by','JOSM'),(264932543,'created_by','JOSM'),(264932544,'created_by','JOSM'),(264932545,'created_by','JOSM'),(264932546,'created_by','JOSM'),(264932547,'created_by','JOSM'),(264932548,'created_by','JOSM'),(264932549,'created_by','JOSM'),(264932550,'created_by','JOSM'),(264932551,'created_by','JOSM'),(264932567,'created_by','JOSM'),(264932568,'created_by','JOSM'),(264932569,'created_by','JOSM'),(264932570,'created_by','JOSM'),(264932572,'created_by','JOSM'),(264932573,'created_by','JOSM'),(264932574,'created_by','JOSM'),(264932575,'created_by','JOSM'),(264932576,'created_by','JOSM'),(264932577,'created_by','JOSM'),(264932578,'created_by','JOSM'),(264932579,'created_by','JOSM'),(264932581,'created_by','JOSM'),(264932582,'created_by','JOSM'),(264932583,'created_by','JOSM'),(264932584,'created_by','JOSM'),(264932585,'created_by','JOSM'),(264932586,'created_by','JOSM'),(264932587,'created_by','JOSM'),(264932589,'created_by','JOSM'),(264932590,'created_by','JOSM'),(264932591,'created_by','JOSM'),(264932592,'created_by','JOSM'),(264932593,'created_by','JOSM'),(264932594,'created_by','JOSM'),(264932595,'created_by','JOSM'),(264932596,'created_by','JOSM'),(264932598,'created_by','JOSM'),(264932599,'created_by','JOSM'),(264932600,'created_by','JOSM'),(264932601,'created_by','JOSM'),(264932602,'created_by','JOSM'),(264932603,'created_by','JOSM'),(264932604,'created_by','JOSM'),(264932605,'created_by','JOSM'),(264932606,'created_by','JOSM'),(264932608,'created_by','JOSM'),(264932609,'created_by','JOSM'),(264932610,'created_by','JOSM'),(264932611,'created_by','JOSM'),(264932612,'created_by','JOSM'),(264932613,'created_by','JOSM'),(264932614,'created_by','JOSM'),(264932615,'created_by','JOSM'),(264932616,'created_by','JOSM'),(264932617,'created_by','JOSM'),(264932619,'created_by','JOSM'),(264932620,'created_by','JOSM'),(264932621,'created_by','JOSM'),(264932622,'created_by','JOSM'),(264932623,'created_by','JOSM'),(264932624,'created_by','JOSM'),(264932625,'created_by','JOSM'),(264932626,'created_by','JOSM'),(264932627,'created_by','JOSM'),(264932628,'created_by','JOSM'),(264932629,'created_by','JOSM'),(264932631,'created_by','JOSM'),(264932632,'created_by','JOSM'),(264932633,'created_by','JOSM'),(264932634,'created_by','JOSM'),(264932635,'created_by','JOSM'),(264932636,'created_by','JOSM'),(264932637,'created_by','JOSM'),(264932638,'created_by','JOSM'),(264932639,'created_by','JOSM'),(264932641,'created_by','JOSM'),(264932642,'created_by','JOSM'),(264932643,'created_by','JOSM'),(264932644,'created_by','JOSM'),(264932645,'created_by','JOSM'),(264932646,'created_by','JOSM'),(264932647,'created_by','JOSM'),(264932649,'created_by','JOSM'),(264932650,'created_by','JOSM'),(264932651,'created_by','JOSM'),(264932652,'created_by','JOSM'),(264932653,'created_by','JOSM'),(264932654,'created_by','JOSM'),(264932655,'created_by','JOSM'),(264932656,'created_by','JOSM'),(264932657,'created_by','JOSM'),(264932658,'created_by','JOSM'),(264932659,'created_by','JOSM'),(264932660,'created_by','JOSM'),(264932661,'created_by','JOSM'),(264932662,'created_by','JOSM'),(264932663,'created_by','JOSM'),(264932665,'created_by','JOSM'),(264932666,'created_by','JOSM'),(264932667,'created_by','JOSM'),(264932668,'created_by','JOSM'),(264932669,'created_by','JOSM'),(264932670,'created_by','JOSM'),(264932671,'created_by','JOSM'),(264932672,'created_by','JOSM'),(264932673,'created_by','JOSM'),(264932675,'created_by','JOSM'),(264932676,'created_by','JOSM'),(264932677,'created_by','JOSM'),(264932678,'created_by','JOSM'),(264932679,'created_by','JOSM'),(264932680,'created_by','JOSM'),(264932681,'created_by','JOSM'),(264932682,'created_by','JOSM'),(264932684,'created_by','JOSM'),(264932685,'created_by','JOSM'),(264932686,'created_by','JOSM'),(264932687,'created_by','JOSM'),(264932688,'created_by','JOSM'),(264932689,'created_by','JOSM'),(264932690,'created_by','JOSM'),(264932691,'created_by','JOSM'),(264932693,'created_by','JOSM'),(264932694,'created_by','JOSM'),(264932695,'created_by','JOSM'),(264932696,'created_by','JOSM'),(264932697,'created_by','JOSM'),(264932698,'created_by','JOSM'),(264932699,'created_by','JOSM'),(264932701,'created_by','JOSM'),(264932702,'created_by','JOSM'),(264932703,'created_by','JOSM'),(264932704,'created_by','JOSM'),(264932705,'created_by','JOSM'),(264932706,'created_by','JOSM'),(264932707,'created_by','JOSM'),(264932708,'created_by','JOSM'),(264932710,'created_by','JOSM'),(264932711,'created_by','JOSM'),(264932712,'created_by','JOSM'),(264932713,'created_by','JOSM'),(264932714,'created_by','JOSM'),(264932715,'created_by','JOSM'),(264932716,'created_by','JOSM'),(264932717,'created_by','JOSM'),(264932718,'created_by','JOSM'),(264932719,'created_by','JOSM'),(264932720,'created_by','JOSM'),(264932722,'created_by','JOSM'),(264932723,'created_by','JOSM'),(264932724,'created_by','JOSM'),(264932725,'created_by','JOSM'),(264932726,'created_by','JOSM'),(264932727,'created_by','JOSM'),(264932728,'created_by','JOSM'),(264932729,'created_by','JOSM'),(264932731,'created_by','JOSM'),(264932732,'created_by','JOSM'),(264932733,'created_by','JOSM'),(264932734,'created_by','JOSM'),(264932735,'created_by','JOSM'),(264932736,'created_by','JOSM'),(264932737,'created_by','JOSM'),(264932738,'created_by','JOSM'),(264932739,'created_by','JOSM'),(264932740,'created_by','JOSM'),(264932742,'created_by','JOSM'),(264932743,'created_by','JOSM'),(264932744,'created_by','JOSM'),(264932745,'created_by','JOSM'),(264932746,'created_by','JOSM'),(264932747,'created_by','JOSM'),(264932748,'created_by','JOSM'),(264932749,'created_by','JOSM'),(264932750,'created_by','JOSM'),(264932752,'created_by','JOSM'),(264932753,'created_by','JOSM'),(264932754,'created_by','JOSM'),(264932755,'created_by','JOSM'),(264932756,'created_by','JOSM'),(264932757,'created_by','JOSM'),(264932759,'created_by','JOSM'),(264932760,'created_by','JOSM'),(264932761,'created_by','JOSM'),(264932762,'created_by','JOSM'),(264932763,'created_by','JOSM'),(264932764,'created_by','JOSM'),(264932765,'created_by','JOSM'),(264932766,'created_by','JOSM'),(264932767,'created_by','JOSM'),(264932769,'created_by','JOSM'),(264932770,'created_by','JOSM'),(264932771,'created_by','JOSM'),(264932772,'created_by','JOSM'),(264932773,'created_by','JOSM'),(264932774,'created_by','JOSM'),(264932775,'created_by','JOSM'),(264932776,'created_by','JOSM'),(264932777,'created_by','JOSM'),(264932779,'created_by','JOSM'),(264932780,'created_by','JOSM'),(264932781,'created_by','JOSM'),(264932782,'created_by','JOSM'),(264932783,'created_by','JOSM'),(264932784,'created_by','JOSM'),(264932785,'created_by','JOSM'),(264932786,'created_by','JOSM'),(264932787,'created_by','JOSM'),(264932788,'created_by','JOSM'),(264932789,'created_by','JOSM'),(264932791,'created_by','JOSM'),(264932792,'created_by','JOSM'),(264932793,'created_by','JOSM'),(264932794,'created_by','JOSM'),(264932795,'created_by','JOSM'),(264932796,'created_by','JOSM'),(264932797,'created_by','JOSM'),(264932798,'created_by','JOSM'),(264932800,'created_by','JOSM'),(264932801,'created_by','JOSM'),(264932802,'created_by','JOSM'),(264932803,'created_by','JOSM'),(264932804,'created_by','JOSM'),(264932805,'created_by','JOSM'),(264932806,'created_by','JOSM'),(264932807,'created_by','JOSM'),(264932808,'created_by','JOSM'),(264932809,'created_by','JOSM'),(264932811,'created_by','JOSM'),(264932812,'created_by','JOSM'),(264932813,'created_by','JOSM'),(264932814,'created_by','JOSM'),(264932815,'created_by','JOSM'),(264932816,'created_by','JOSM'),(264932817,'created_by','JOSM'),(264932818,'created_by','JOSM'),(264932820,'created_by','JOSM'),(264932821,'created_by','JOSM'),(264932822,'created_by','JOSM'),(264932823,'created_by','JOSM'),(264932824,'created_by','JOSM'),(264932825,'created_by','JOSM'),(264932826,'created_by','JOSM'),(264932827,'created_by','JOSM'),(264932828,'created_by','JOSM'),(264932829,'created_by','JOSM'),(264932831,'created_by','JOSM'),(264932832,'created_by','JOSM'),(264932833,'created_by','JOSM'),(264932834,'created_by','JOSM'),(264932835,'created_by','JOSM'),(264932836,'created_by','JOSM'),(264932837,'created_by','JOSM'),(264932838,'created_by','JOSM'),(264932839,'created_by','JOSM'),(264932840,'created_by','JOSM'),(264932841,'created_by','JOSM'),(264932842,'created_by','JOSM'),(264932843,'created_by','JOSM'),(264932844,'created_by','JOSM'),(264932846,'created_by','JOSM'),(264932847,'created_by','JOSM'),(264932848,'created_by','JOSM'),(264932849,'created_by','JOSM'),(264932850,'created_by','JOSM'),(264932851,'created_by','JOSM'),(264932852,'created_by','JOSM'),(264932853,'created_by','JOSM'),(264932855,'created_by','JOSM'),(264932856,'created_by','JOSM'),(264932857,'created_by','JOSM'),(264932858,'created_by','JOSM'),(264932859,'created_by','JOSM'),(264932860,'created_by','JOSM'),(264932861,'created_by','JOSM'),(264932862,'created_by','JOSM'),(264932864,'created_by','JOSM'),(264932865,'created_by','JOSM'),(264932866,'created_by','JOSM'),(264932867,'created_by','JOSM'),(264932868,'created_by','JOSM'),(264932869,'created_by','JOSM'),(264932870,'created_by','JOSM'),(264932871,'created_by','JOSM'),(266324553,'created_by','Potlatch 0.9a'),(266324553,'is_in','Ordino'),(266324553,'name','Mas d\'en Soler'),(266324553,'place','hamlet'),(266324699,'building','water mill'),(266324699,'created_by','Potlatch 0.9a'),(266324699,'name','Moli de Mas d\'en Soler'),(266331736,'amenity','parking'),(266331736,'created_by','Potlatch 0.9a'),(266331970,'amenity','parking'),(266331970,'created_by','Potlatch 0.9a'),(266338686,'amenity','parking'),(266338686,'created_by','Potlatch 0.9a'),(266619909,'highway','turning_circle'),(266622062,'highway','turning_circle'),(266622086,'amenity','parking'),(266622086,'created_by','Potlatch 0.9a'),(266622595,'amenity','parking'),(266622595,'created_by','Potlatch 0.9a'),(268092455,'highway','turning_circle'),(268093053,'highway','mini_roundabout'),(268096174,'created_by','Potlatch 0.9c'),(268096174,'name','Hotel Xalet Besoli'),(268096174,'tourism','hotel'),(268123183,'highway','turning_circle'),(271938772,'created_by','JOSM'),(271938773,'created_by','JOSM'),(271938774,'created_by','JOSM'),(271938778,'created_by','JOSM'),(271939031,'amenity','fuel'),(271939031,'name','bp'),(271939031,'operator','BP'),(271939032,'created_by','JOSM'),(271939033,'created_by','JOSM'),(271939034,'created_by','JOSM'),(276993930,'ele','2360'),(276993930,'mountain_pass','yes'),(276993930,'name','Port de Siguer'),(276993930,'wikipedia','fr:Port_de_Siguer'),(277000148,'place_name','Plaça del Poble'),(277003684,'highway','turning_circle'),(277377767,'created_by','Potlatch 0.9c'),(277377767,'ele','2746'),(277377767,'name','Pic Oest de Casamanya'),(277377767,'natural','peak'),(277377889,'created_by','Potlatch 0.9c'),(277377889,'ele','2757'),(277377889,'name','Pic Est de Casamanya'),(277377889,'natural','peak'),(277377892,'created_by','Potlatch 0.9c'),(277377892,'ele','2731'),(277377892,'name','Pic Mig de Casamanya'),(277377892,'natural','peak'),(277378560,'created_by','Potlatch 0.9c'),(277378560,'ele','2550'),(277378560,'mountain_pass','yes'),(277378560,'name','Col d\'Arenys'),(278752636,'created_by','Potlatch 0.9c'),(278752636,'name','Hotel Nordic'),(278752636,'tourism','hotel'),(281694408,'created_by','Potlatch 0.10'),(281694408,'name','Hotel la Coma'),(281694408,'tourism','hotel'),(283678401,'amenity','parking'),(283678401,'created_by','Potlatch 0.10b'),(283680492,'amenity','arts_centre'),(283680492,'created_by','Potlatch 0.10b'),(283680492,'name','Auditori Nacional d\'Andorra'),(287401324,'highway','mini_roundabout'),(292503717,'amenity','fuel'),(292503717,'operator','Gasopas'),(316961244,'highway','mini_roundabout'),(316961410,'highway','mini_roundabout'),(316961518,'highway','mini_roundabout'),(316985105,'created_by','Potlatch 0.10f'),(316985105,'is_in','Ordino'),(316985105,'name','Les Salines'),(316985105,'place','hamlet'),(321651109,'ele','2642'),(321651109,'name','Pic Negre'),(321651109,'natural','peak'),(321679779,'name','Collada de Mitjana'),(321679779,'natural','land'),(321683609,'barrier','kissing_gate'),(321683609,'bicycle','yes'),(323130871,'aerialway','station'),(323130873,'aerialway','station'),(337743301,'amenity','parking'),(337743301,'created_by','Potlatch 0.10f'),(337743301,'operator','Parc central'),(337745019,'amenity','parking'),(337745019,'created_by','Potlatch 0.10f'),(337745019,'operator','Hipermercat Andorra 2000'),(337775428,'barrier','entrance'),(338420702,'barrier','garage door'),(339066904,'created_by','Potlatch 0.10f'),(339066904,'natural','peak'),(339066905,'created_by','Potlatch 0.10f'),(339066905,'natural','peak'),(364104064,'name','Camping Xixerella'),(364104064,'tourism','camp_site'),(367680434,'amenity','parking'),(367680434,'parking','surface'),(370902435,'highway','turning_circle'),(370903030,'highway','turning_circle'),(370903796,'highway','turning_circle'),(370909282,'highway','turning_circle'),(370911870,'amenity','place_of_worship'),(370911870,'created_by','Potlatch 0.10f'),(370911870,'denomination','roman_catholic'),(370911870,'name','Sant Cristofol d\'Anyos'),(370911870,'religion','christian'),(385582153,'amenity','parking'),(385582153,'operator','Aparcement Comunal Tobira'),(394816282,'highway','turning_circle'),(394820724,'highway','turning_circle'),(394832428,'highway','turning_circle'),(394840157,'amenity','place_of_worship'),(394840157,'denomination','roman_catholic'),(394840157,'name','Sant Romà d\'Auvinyà'),(394840157,'religion','christian'),(394841036,'highway','turning_circle'),(394847593,'highway','gate'),(441154305,'barrier','fence'),(441154308,'highway','turning_circle'),(442879444,'amenity','parking'),(442879444,'name','Parking Comunal de l\'Aldosa'),(442881217,'name','Hotel Magic Ski'),(442881217,'tourism','hotel'),(442881670,'name','Hotel Font'),(442881670,'tourism','hotel'),(442881710,'name','Hotel Magic'),(442881710,'tourism','hotel'),(442881842,'name','Hotel Marco Polo'),(442881842,'tourism','hotel'),(442881998,'amenity','parking'),(442881998,'name','Les Fontetes'),(442882169,'amenity','theatre'),(442882169,'name','Les Fontetes'),(442882272,'name','Hotel Burna'),(442882272,'tourism','hotel'),(442882442,'name','Compra Be'),(442882442,'shop','supermarket'),(442882581,'name','Residential de l\'Aldosa'),(442882581,'tourism','hotel'),(444324773,'amenity','parking'),(444324773,'name','Les Pardines'),(458761736,'building','Borda'),(458761736,'name','Borda de Sedornet'),(458762722,'ele','1934'),(458762722,'name','Roc de Castell'),(458762722,'natural','peak'),(458765074,'amenity','parking'),(470343766,'tourism','viewpoint'),(470364200,'amenity','parking'),(470364488,'amenity','parking'),(482150309,'ele','2570'),(482150309,'name','Pic del\'Hortell'),(482150309,'natural','peak'),(485578146,'ele','2526'),(485578146,'mountain_pass','yes'),(485578146,'name','Col de l\'Homme Mort'),(521134858,'amenity','restaurant'),(521134858,'name','Surf'),(521135636,'amenity','fast_food'),(521143390,'shop','supermarket'),(521144650,'shop','supermarket'),(521146418,'amenity','bar'),(521146418,'name','Red X'),(521153185,'aerialway','station'),(521153185,'man_made','Uphill Terminal'),(521153188,'aerialway','station'),(521153188,'man_made','Downhill Terminal'),(522787948,'amenity','restaurant'),(522787954,'amenity','bar'),(522787964,'amenity','fast_food'),(522787974,'amenity','hospital'),(522787985,'amenity','restaurant'),(522788283,'highway','bus_stop'),(522788287,'tourism','hotel'),(522800785,'amenity','bank'),(522800785,'atm','yes'),(522800788,'amenity','atm'),(529940889,'amenity','school'),(529941178,'name','Casa d\'Areny-Plandolit'),(529941178,'tourism','museum'),(529943807,'amenity','place_of_worship'),(535384824,'highway','speed_camera'),(567007523,'aerialway','station'),(567007523,'FIXME','Needs survey of correct position and full extent'),(567007523,'source','Estimate based on local knowledge'),(590463652,'name','Hotel St. Gothard'),(590463652,'tourism','hotel'),(590463653,'name','Apartments St. Moritz'),(590463653,'tourism','hotel'),(590463654,'name','St. Moritz Ski Hire'),(590463654,'shop','sports'),(590463655,'amenity','pharmacy'),(590463655,'dispensing','yes'),(590463656,'name','Hotel Solana'),(590463656,'tourism','hotel'),(590463659,'name','Hotel Princesa Parc'),(590463659,'tourism','hotel'),(590463661,'name','Hotel Xalet Verdu'),(590463661,'tourism','hotel'),(590463663,'name','Hotel Patagonia'),(590463663,'tourism','hotel'),(590463666,'highway','bus_stop'),(590463666,'name','Central Bus Stop'),(590463666,'name:en','Central Bus Stop'),(590463669,'name','Hotel Ayma'),(590463669,'tourism','hotel'),(590538923,'name','Resedencia Daina'),(590538923,'tourism','hotel'),(590538926,'name','Hotel Arinsal'),(590538926,'tourism','hotel'),(593870539,'amenity','restaurant'),(593870539,'ele','1926'),(593870539,'name','Restaurant Panoramix'),(593870540,'ele','1966'),(593870540,'name','Esports Rossell'),(593870540,'shop','sports'),(593870541,'amenity','atm'),(593870541,'ele','1935'),(593870542,'ele','1923'),(593870542,'name','Pic Negre'),(593870542,'shop','sports'),(593870542,'ski_hire','yes'),(593870543,'ele','1912'),(593870543,'name','Lift Pass Office'),(593870543,'shop','lift_pass'),(593870544,'ele','1923'),(593870544,'FIXME','Position is suspect'),(593870544,'name','Top of Chair lift'),(593870545,'ele','1935'),(593870545,'FIXME','Need a proper name'),(593870545,'name','Souvenir Shop at the Top of Gondola'),(593870545,'shop','gift'),(593870546,'ele','1482'),(593870546,'name','Shop 5150 (ski/sport shop)'),(593870547,'ele','1409'),(593870547,'name','Supermarket Nou'),(593870547,'shop','supermarket'),(593870548,'amenity','restaurant'),(593870548,'ele','1423'),(593870548,'internet_access','yes'),(593870548,'name','Restaurant Granja Del Poble (Internet Café)'),(593870549,'amenity','bar'),(593870549,'ele','1430'),(593870549,'name','Bar El Bosc'),(593870550,'amenity','restaurant'),(593870550,'ele','1422'),(593870550,'name','Restaurant Timotea'),(593870551,'amenity','atm'),(593870551,'ele','1430'),(593870552,'ele','1926'),(593870552,'name','Ski School'),(593870552,'shop','ski_school'),(593870553,'amenity','bar'),(593870553,'ele','146'),(593870553,'name','Bar/Restaurant 360'),(593870554,'amenity','bar'),(593870554,'ele','1461'),(593870554,'name','Black Bull Bar'),(593870555,'amenity','atm'),(593870555,'ele','1442'),(593870556,'amenity','restaurant'),(593870556,'ele','1474'),(593870556,'name','Restaurant/Bar Mollies'),(593870557,'amenity','atm'),(593870557,'ele','1476'),(593870558,'amenity','restaurant'),(593870558,'ele','1477'),(593870558,'name','Restaurant/Bar Ciscos'),(593870559,'amenity','bar'),(593870559,'ele','1515'),(593870559,'name','Cau Bar'),(593870560,'amenity','bar'),(593870560,'ele','1524'),(593870560,'name','Bar Quo Vadis'),(613344821,'man_made','Downhill Terminal'),(613344822,'man_made','Uphill Terminal'),(613344823,'man_made','Downhill Terminal'),(613344824,'man_made','Uphill Terminal'),(613344825,'man_made','Downhill Terminal'),(613344827,'man_made','Uphill Terminal'),(620937074,'amenity','restaurant'),(620937074,'building','yes'),(620937074,'name','Steak House'),(621473071,'amenity','restaurant'),(621473071,'name','Cubil'),(621473074,'ele','2560'),(621473074,'name','Tosa de Llosada'),(621473074,'natural','peak'),(621473077,'ele','2502'),(621473077,'name','Cortals'),(621473077,'natural','peak'),(621473079,'amenity','restaurant'),(621473079,'name','Solanelles'),(621473081,'ele','2467'),(621473081,'name','Tosa de Espiolets'),(621473081,'natural','peak'),(623510069,'ele','2528'),(623510069,'mountain_pass','yes'),(623510069,'name','Col Blanc'),(663075945,'man_made','Uphill Terminal'),(663075946,'man_made','Downhill Terminal'),(663078911,'man_made','Uphill Terminal'),(663078912,'man_made','Downhill Terminal'),(663080312,'man_made','Uphill Terminal'),(663080313,'man_made','Downhill Terminal'),(663084327,'man_made','Uphill Terminal'),(663084328,'man_made','Downhill Terminal'),(663086638,'man_made','Downhill Terminal'),(663086639,'man_made','Uphill Terminal'),(663092389,'man_made','Uphill Terminal'),(663092390,'man_made','Downhill Terminal'),(663093429,'man_made','Uphill Terminal'),(663093430,'man_made','Downhill Terminal'),(663095052,'man_made','Downhill Terminal'),(663339197,'man_made','Uphill Terminal'),(663339199,'man_made','Downhill Terminal'),(663345420,'man_made','Uphill Terminal'),(663345421,'man_made','Downhill Terminal'),(663372539,'man_made','Uphill Terminal'),(663372540,'man_made','Downhill Terminal'),(663373401,'aerialway','station'),(663373401,'man_made','Uphill Terminal'),(663373402,'aerialway','station'),(663373402,'man_made','Downhill Terminal'),(663802644,'man_made','Uphill Terminal'),(663802645,'man_made','Downhill Terminal'),(663803593,'man_made','Uphill Terminal'),(663803594,'man_made','Downhill Terminal'),(663952666,'man_made','Downhill Terminal'),(663952667,'man_made','Uphill Terminal'),(663953196,'historic','monument'),(663953196,'name','Monument L\'Anella d\'Ordino'),(664116090,'man_made','Downhill Terminal'),(664116091,'aerialway','station'),(664116091,'man_made','Uphill Terminal'),(664116161,'aerialway','station'),(664116161,'man_made','Downhill Terminal'),(664192679,'aerialway','pylon'),(664192680,'aerialway','pylon'),(664192681,'aerialway','pylon'),(664195007,'man_made','Downhill Terminal'),(664195008,'man_made','Uphill Terminal'),(664205614,'aerialway','station'),(664205614,'man_made','Uphill Terminal'),(664205619,'aerialway','pylon'),(664205621,'aerialway','pylon'),(664205624,'aerialway','pylon'),(664205627,'aerialway','pylon'),(664205630,'aerialway','pylon'),(664205633,'aerialway','pylon'),(664205635,'aerialway','pylon'),(664205638,'aerialway','station'),(664205638,'man_made','Downhill Terminal'),(664205641,'aerialway','pylon'),(664205644,'aerialway','pylon'),(664225476,'aerialway','pylon'),(664225514,'aerialway','pylon'),(664225516,'aerialway','pylon'),(664225519,'aerialway','pylon'),(664225521,'aerialway','pylon'),(664225523,'aerialway','pylon'),(664225525,'aerialway','pylon'),(664225527,'aerialway','pylon'),(664225529,'aerialway','pylon'),(664225531,'aerialway','pylon'),(664236924,'aerialway','pylon'),(664236925,'aerialway','pylon'),(664236926,'aerialway','pylon'),(664236927,'aerialway','pylon'),(664236928,'aerialway','pylon'),(664605824,'aerialway','station'),(666793593,'ele','2447'),(666793593,'information','guidepost'),(666793593,'name','Collada D\'Enradort'),(666793593,'tourism','information'),(666793594,'amenity','restaurant'),(666793594,'name','Roc De Les Bruixes'),(666793595,'amenity','fast_food'),(666793596,'amenity','toilets'),(666793597,'ele','2000'),(666793597,'information','guidepost'),(666793597,'name','El Forn'),(666793597,'tourism','information'),(666793598,'amenity','fast_food'),(666793599,'amenity','toilets'),(666793600,'ele','2560'),(666793600,'information','guidepost'),(666793600,'name','Tosa De La Llosada'),(666793600,'tourism','information'),(666793601,'amenity','hospital'),(666793602,'amenity','hospital'),(666793603,'ele','2465'),(666793603,'information','guidepost'),(666793603,'name','Portella'),(666793603,'tourism','information'),(666793604,'ele','2458'),(666793604,'information','guidepost'),(666793604,'name','C. De Les Solanelles'),(666793604,'tourism','information'),(666793605,'ele','2502'),(666793605,'information','guidepost'),(666793605,'name','Cortals'),(666793605,'tourism','information'),(666793606,'amenity','fast_food'),(666793607,'amenity','hospital'),(666793608,'amenity','toilets'),(666793609,'amenity','toilets'),(666793610,'amenity','hospital'),(666793611,'ele','2467'),(666793611,'information','guidepost'),(666793611,'name','Tossa Dels Espiolets'),(666793611,'tourism','information'),(666793612,'amenity','fast_food'),(666793613,'ele','2100'),(666793613,'information','guidepost'),(666793613,'name','Riba Escorxada'),(666793613,'tourism','information'),(666793614,'amenity','restaurant'),(666793614,'name','El Mercal Del Pi'),(666793615,'amenity','toilets'),(666793616,'amenity','restaurant'),(666793616,'name','Gall De Bosc'),(666793617,'amenity','fast_food'),(666793618,'ele','2250'),(666793618,'information','guidepost'),(666793618,'name','Espiolets'),(666793618,'tourism','information'),(666793619,'amenity','fast_food'),(666793620,'ele','2150'),(666793620,'information','guidepost'),(666793620,'name','Pla De Les Pedres'),(666793620,'tourism','information'),(666793621,'amenity','toilets'),(666793622,'amenity','fast_food'),(666793623,'amenity','toilets'),(669985285,'description','Mire Duralumin - Point vu en place en 1948'),(669985285,'man_made','survey_point'),(669985285,'note','Ne pas déplacer ce point, cf. - Do not move this node, see - http://wiki.openstreetmap.org/wiki/WikiProject_France/Repères_Géodésiques#Permanence_des_rep.C3.A8res'),(669985285,'ref','0902401 -'),(669985285,'source','©IGN 2010 dans le cadre de la cartographie réglementaire'),(669985285,'url','http://ancien-geodesie.ign.fr/fiche_point.asp?num_site=0902401&no_ptg=02&numero_f50=2149'),(669985286,'description','Repère I - Point vu en place en 1948'),(669985286,'man_made','survey_point'),(669985286,'note','Ne pas déplacer ce point, cf. - Do not move this node, see - http://wiki.openstreetmap.org/wiki/WikiProject_France/Repères_Géodésiques#Permanence_des_rep.C3.A8res'),(669985286,'ref','0902401 -'),(669985286,'source','©IGN 2010 dans le cadre de la cartographie réglementaire'),(669985286,'url','http://ancien-geodesie.ign.fr/fiche_point.asp?num_site=0902401&no_ptg=04&numero_f50=2149'),(669985287,'description','Repère II - Point vu en place en 1948'),(669985287,'man_made','survey_point'),(669985287,'note','Ne pas déplacer ce point, cf. - Do not move this node, see - http://wiki.openstreetmap.org/wiki/WikiProject_France/Repères_Géodésiques#Permanence_des_rep.C3.A8res'),(669985287,'ref','0902401 -'),(669985287,'source','©IGN 2010 dans le cadre de la cartographie réglementaire'),(669985287,'url','http://ancien-geodesie.ign.fr/fiche_point.asp?num_site=0902401&no_ptg=05&numero_f50=2149'),(669985289,'description','Repère III - Point vu en place en 1948'),(669985289,'man_made','survey_point'),(669985289,'note','Ne pas déplacer ce point, cf. - Do not move this node, see - http://wiki.openstreetmap.org/wiki/WikiProject_France/Repères_Géodésiques#Permanence_des_rep.C3.A8res'),(669985289,'ref','0902401 -'),(669985289,'source','©IGN 2010 dans le cadre de la cartographie réglementaire'),(669985289,'url','http://ancien-geodesie.ign.fr/fiche_point.asp?num_site=0902401&no_ptg=06&numero_f50=2149'),(669985291,'description','Borne en granit gravée IGN - Point vu en place en 1950'),(669985291,'ele','2912.38'),(669985291,'man_made','survey_point'),(669985291,'note','Ne pas déplacer ce point, cf. - Do not move this node, see - http://wiki.openstreetmap.org/wiki/WikiProject_France/Repères_Géodésiques#Permanence_des_rep.C3.A8res'),(669985291,'ref','0902401 - 1'),(669985291,'source','©IGN 2010 dans le cadre de la cartographie réglementaire'),(669985291,'url','http://ancien-geodesie.ign.fr/fiche_point.asp?num_site=0902401&no_ptg=01&numero_f50=2149'),(669985299,'description','Borne en granit gravée IGN - Point vu en place en 1950'),(669985299,'ele','2594.87'),(669985299,'man_made','survey_point'),(669985299,'note','Ne pas déplacer ce point, cf. - Do not move this node, see - http://wiki.openstreetmap.org/wiki/WikiProject_France/Repères_Géodésiques#Permanence_des_rep.C3.A8res'),(669985299,'ref','0902407 - 1'),(669985299,'source','©IGN 2010 dans le cadre de la cartographie réglementaire'),(669985299,'url','http://ancien-geodesie.ign.fr/fiche_point.asp?num_site=0902407&no_ptg=01&numero_f50=2149'),(669985301,'description','Rocher : Repère : Rivet en fer scellé - Point vu en place en 1950'),(669985301,'ele','2594.99'),(669985301,'man_made','survey_point'),(669985301,'note','Ne pas déplacer ce point, cf. - Do not move this node, see - http://wiki.openstreetmap.org/wiki/WikiProject_France/Repères_Géodésiques#Permanence_des_rep.C3.A8res'),(669985301,'ref','0902407 - A'),(669985301,'source','©IGN 2010 dans le cadre de la cartographie réglementaire'),(669985301,'url','http://ancien-geodesie.ign.fr/fiche_point.asp?num_site=0902407&no_ptg=03&numero_f50=2149'),(669985341,'description','Borne en granit gravée IGN - Point vu en place en 1950'),(669985341,'ele','2913.56'),(669985341,'man_made','survey_point'),(669985341,'note','Ne pas déplacer ce point, cf. - Do not move this node, see - http://wiki.openstreetmap.org/wiki/WikiProject_France/Repères_Géodésiques#Permanence_des_rep.C3.A8res'),(669985341,'ref','0903004 - 1'),(669985341,'source','©IGN 2010 dans le cadre de la cartographie réglementaire'),(669985341,'url','http://ancien-geodesie.ign.fr/fiche_point.asp?num_site=0903004&no_ptg=01&numero_f50=2149'),(669985348,'description','Borne en granit gravée IGN - Point vu en place en 1950'),(669985348,'ele','2804.65'),(669985348,'man_made','survey_point'),(669985348,'note','Ne pas déplacer ce point, cf. - Do not move this node, see - http://wiki.openstreetmap.org/wiki/WikiProject_France/Repères_Géodésiques#Permanence_des_rep.C3.A8res'),(669985348,'ref','0903008 - 1'),(669985348,'source','©IGN 2010 dans le cadre de la cartographie réglementaire'),(669985348,'url','http://ancien-geodesie.ign.fr/fiche_point.asp?num_site=0903008&no_ptg=01&numero_f50=2149'),(669985685,'description','Rocher : Repère en bronze scellé - Point vu en place en 1950'),(669985685,'ele','2810.7'),(669985685,'man_made','survey_point'),(669985685,'note','Ne pas déplacer ce point, cf. - Do not move this node, see - http://wiki.openstreetmap.org/wiki/WikiProject_France/Repères_Géodésiques#Permanence_des_rep.C3.A8res'),(669985685,'ref','0913901 - 1'),(669985685,'source','©IGN 2010 dans le cadre de la cartographie réglementaire'),(669985685,'url','http://ancien-geodesie.ign.fr/fiche_point.asp?num_site=0913901&no_ptg=01&numero_f50=2149'),(669985690,'description','Rocher : Croix gravée - Point vu en place en 1948'),(669985690,'man_made','survey_point'),(669985690,'note','Ne pas déplacer ce point, cf. - Do not move this node, see - http://wiki.openstreetmap.org/wiki/WikiProject_France/Repères_Géodésiques#Permanence_des_rep.C3.A8res'),(669985690,'ref','0913901 - 2'),(669985690,'source','©IGN 2010 dans le cadre de la cartographie réglementaire'),(669985690,'url','http://ancien-geodesie.ign.fr/fiche_point.asp?num_site=0913901&no_ptg=02&numero_f50=2149'),(669986979,'description','Borne en granit gravée IGN - Point vu en place en 1950'),(669986979,'ele','2902.82'),(669986979,'man_made','survey_point'),(669986979,'note','Ne pas déplacer ce point, cf. - Do not move this node, see - http://wiki.openstreetmap.org/wiki/WikiProject_France/Repères_Géodésiques#Permanence_des_rep.C3.A8res'),(669986979,'ref','0929501 - 1'),(669986979,'source','©IGN 2010 dans le cadre de la cartographie réglementaire'),(669986979,'url','http://ancien-geodesie.ign.fr/fiche_point.asp?num_site=0929501&no_ptg=01&numero_f50=2149'),(669986980,'description','Repère en bronze scellé - Point vu en place en 1950'),(669986980,'ele','2902.66'),(669986980,'man_made','survey_point'),(669986980,'note','Ne pas déplacer ce point, cf. - Do not move this node, see - http://wiki.openstreetmap.org/wiki/WikiProject_France/Repères_Géodésiques#Permanence_des_rep.C3.A8res'),(669986980,'ref','0929501 - A'),(669986980,'source','©IGN 2010 dans le cadre de la cartographie réglementaire'),(669986980,'url','http://ancien-geodesie.ign.fr/fiche_point.asp?num_site=0929501&no_ptg=03&numero_f50=2149'),(669986981,'description','Rivet en fer scellé au N.E - Point vu en place en 1950'),(669986981,'ele','2902.92'),(669986981,'man_made','survey_point'),(669986981,'note','Ne pas déplacer ce point, cf. - Do not move this node, see - http://wiki.openstreetmap.org/wiki/WikiProject_France/Repères_Géodésiques#Permanence_des_rep.C3.A8res'),(669986981,'ref','0929501 - B'),(669986981,'source','©IGN 2010 dans le cadre de la cartographie réglementaire'),(669986981,'url','http://ancien-geodesie.ign.fr/fiche_point.asp?num_site=0929501&no_ptg=04&numero_f50=2149'),(669986982,'description','Rivet en fer scellé au N.O - Point vu en place en 1950'),(669986982,'ele','2902.11'),(669986982,'man_made','survey_point'),(669986982,'note','Ne pas déplacer ce point, cf. - Do not move this node, see - http://wiki.openstreetmap.org/wiki/WikiProject_France/Repères_Géodésiques#Permanence_des_rep.C3.A8res'),(669986982,'ref','0929501 - C'),(669986982,'source','©IGN 2010 dans le cadre de la cartographie réglementaire'),(669986982,'url','http://ancien-geodesie.ign.fr/fiche_point.asp?num_site=0929501&no_ptg=05&numero_f50=2149'),(796044564,'name','River'),(796044564,'shop','supermarket'),(796044575,'name','Punt de Trobada'),(796044575,'shop','supermarket'),(820950476,'name','Hotel Himalaya'),(820950476,'tourism','hotel'),(820952919,'name','Hotel'),(820952919,'tourism','hotel'),(820954183,'name','Hotel Bruxelles'),(820954183,'tourism','hotel'),(821006310,'amenity','restaurant'),(821006310,'name','Bruxellles Restaurant'),(894259010,'man_made','tower'),(894259010,'name','Torre dals Morus'),(894259010,'tourism','viewpoint'),(894259394,'amenity','place_of_worship'),(894259394,'religion','christian'),(894259503,'amenity','place_of_worship'),(894259503,'name','Santa Romà de les Bons'),(894259503,'religion','christian'),(894259507,'amenity','restaurant'),(894259507,'name','La Dama del Llac'),(894259507,'phone','+376828206'),(894259529,'amenity','restaurant'),(894259529,'name','Camp del FIXME'),(894259529,'tourism','hotel'),(894263141,'amenity','parking'),(894263144,'historic','church'),(894263144,'name','Sant Joan de Caselles'),(894263144,'tourism','attraction'),(895601487,'highway','bus_stop'),(895601487,'shelter','no'),(895601494,'amenity','restaurant'),(895601494,'name','Borda del Tremat'),(895604180,'amenity','restaurant'),(895604180,'name','L\'era del Rossell'),(899525861,'amenity','shelter'),(899525861,'ele','2218'),(899525861,'fireplace','yes'),(899525861,'name','Refuge de Coms de Jan - andorre'),(899525861,'note','98'),(899525861,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899525869,'amenity','shelter'),(899525869,'ele','2030'),(899525869,'fireplace','no'),(899525869,'name','Cabane Estany   - andorre'),(899525869,'note','583'),(899525869,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899525876,'amenity','shelter'),(899525876,'ele','2250'),(899525876,'name','Cabane Setut - andorre'),(899525876,'note','593'),(899525876,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899525898,'amenity','shelter'),(899525898,'name','Cabane Banyell planells de rialp - andorre'),(899525898,'note','579'),(899525898,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899525904,'amenity','shelter'),(899525904,'ele','2280'),(899525904,'name','Refuge Claror - andorre'),(899525904,'note','580'),(899525904,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899525912,'amenity','shelter'),(899525912,'ele','2220'),(899525912,'fireplace','yes'),(899525912,'name','Refuge de l Angonella - andorre'),(899525912,'note','10'),(899525912,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899525929,'amenity','shelter'),(899525929,'ele','2394'),(899525929,'fireplace','yes'),(899525929,'name','Cabane de l Estany de Juclar - andorre'),(899525929,'note','183'),(899525929,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899525940,'amenity','shelter'),(899525940,'name','Cabane Estall Serrer - Andorre'),(899525940,'note','1129'),(899525940,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899525948,'amenity','shelter'),(899525948,'ele','2220'),(899525948,'fireplace','no'),(899525948,'name','Cabane Fonts - andorre'),(899525948,'note','584'),(899525948,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899525953,'amenity','shelter'),(899525953,'name','Cabane Riu dels Orris - andorre'),(899525953,'note','591'),(899525953,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899525975,'amenity','shelter'),(899525975,'ele','2240'),(899525975,'fireplace','yes'),(899525975,'name','Cabane Portella - andorre'),(899525975,'note','589'),(899525975,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899525984,'ele','2250'),(899525984,'name','Refuge de La Coma Pedrosa - andorre'),(899525984,'note','96'),(899525984,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899525984,'tourism','alpine_hut'),(899525989,'amenity','shelter'),(899525989,'name','Cabane Vall del Riu - andorre'),(899525989,'note','592'),(899525989,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526014,'amenity','shelter'),(899526014,'ele','1980'),(899526014,'fireplace','yes'),(899526014,'name','Cabane Borda Sorteny - andorre'),(899526014,'note','594'),(899526014,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526022,'amenity','shelter'),(899526022,'ele','2260'),(899526022,'fireplace','no'),(899526022,'name','Cabane de La Coma Pedrosa - andorre'),(899526022,'note','95'),(899526022,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526028,'amenity','shelter'),(899526028,'ele','2629'),(899526028,'fireplace','no'),(899526028,'name','Cabane de l Estany Forcat - Andorre'),(899526028,'note','968'),(899526028,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526049,'amenity','shelter'),(899526049,'ele','1830'),(899526049,'fireplace','yes'),(899526049,'name','Refuge de Fontverd - andorre'),(899526049,'note','143'),(899526049,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526058,'amenity','shelter'),(899526058,'ele','1838'),(899526058,'fireplace','yes'),(899526058,'name','Cabane Arcalis ou Pleta castellar - andorre'),(899526058,'note','578'),(899526058,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526069,'amenity','shelter'),(899526069,'ele','2250'),(899526069,'fireplace','yes'),(899526069,'name','Cabane de Sorda - andorre'),(899526069,'note','303'),(899526069,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526084,'amenity','shelter'),(899526084,'ele','2480'),(899526084,'name','Cabane Estany  Illa - andorre'),(899526084,'note','585'),(899526084,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526090,'amenity','shelter'),(899526090,'ele','2480'),(899526090,'fireplace','yes'),(899526090,'name','Cabane Ensagents - andorre'),(899526090,'note','581'),(899526090,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526097,'amenity','shelter'),(899526097,'name','Refuge Prat Primer - andorre'),(899526097,'note','590'),(899526097,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526119,'amenity','shelter'),(899526119,'ele','2200'),(899526119,'fireplace','yes'),(899526119,'name','Cabanes de Perafita - andorre'),(899526119,'note','248'),(899526119,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526127,'amenity','shelter'),(899526127,'name','Cabane Riba Escorxada - andorre'),(899526127,'note','582'),(899526127,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526136,'amenity','shelter'),(899526136,'name','Cabane Estanya - Andorre'),(899526136,'note','1132'),(899526136,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526171,'amenity','shelter'),(899526171,'ele','2020'),(899526171,'fireplace','yes'),(899526171,'name','Refuge de Rialp - andorre'),(899526171,'note','287'),(899526171,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526182,'amenity','shelter'),(899526182,'ele','2200'),(899526182,'fireplace','yes'),(899526182,'name','Cabane de La Farga - andorre'),(899526182,'note','140'),(899526182,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526219,'amenity','shelter'),(899526219,'ele','2250'),(899526219,'fireplace','yes'),(899526219,'name','Refuge des Agols - andorre'),(899526219,'note','5'),(899526219,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526225,'amenity','shelter'),(899526225,'ele','2010'),(899526225,'fireplace','yes'),(899526225,'name','Refuge de Coma Obaga - andorre'),(899526225,'note','94'),(899526225,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526237,'amenity','shelter'),(899526237,'ele','2150'),(899526237,'fireplace','yes'),(899526237,'name','Pla de les Pedres - Andorre'),(899526237,'note','985'),(899526237,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526263,'amenity','shelter'),(899526263,'ele','2190'),(899526263,'fireplace','yes'),(899526263,'name','Cabane Pleta Serrera - Andorre'),(899526263,'note','967'),(899526263,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526271,'amenity','shelter'),(899526271,'name','Cabane del Serrat de la  Barracota - Andorre'),(899526271,'note','1131'),(899526271,'source','Association \"Refuges et cabanes des Pyrénées\"'),(899526282,'amenity','shelter'),(899526282,'ele','2180'),(899526282,'fireplace','yes'),(899526282,'name','Refuge de Siscaro - andorre'),(899526282,'note','301'),(899526282,'source','Association \"Refuges et cabanes des Pyrénées\"'),(901125108,'ele','2946'),(901125108,'name','Pic de Coma Pedrosa'),(901125108,'natural','peak'),(901125108,'note','Pic de Coma Pedrosa'),(901170351,'ele','2914'),(901170351,'name','Pic de Medecourbe'),(901170351,'natural','peak');
INSERT INTO `current_nodes` VALUES (625022,425128450,15513604,232546,1,'2008-04-23 11:33:55',3310491548,4),(625023,425131024,15516715,232546,1,'2008-04-23 11:31:12',3310491548,3),(625024,425132796,15520491,232546,1,'2008-04-23 11:31:12',3310491548,3),(625025,425141739,15526900,427965,1,'2007-09-14 19:57:45',3310491548,1),(625026,425144463,15526776,2762,1,'2006-03-14 15:46:56',3310491548,1),(625027,425152372,15529780,2762,1,'2006-03-14 15:46:57',3310491549,1),(625028,425165907,15535741,427965,1,'2007-09-14 19:57:45',3310491549,1),(625029,425170402,15539651,2762,1,'2006-03-14 15:47:00',3310491549,1),(625030,425179485,15552163,232546,1,'2008-04-23 11:29:32',3310491594,2),(625031,425192920,15567756,427965,1,'2007-09-14 19:57:45',3310491594,1),(625032,425212467,15586896,427965,1,'2007-09-14 19:57:45',3310491595,1),(625033,425219426,15596166,427965,1,'2007-09-14 19:57:45',3310491595,1),(625034,425226005,15608611,427965,1,'2007-09-14 19:56:23',3310491617,1),(625035,425239988,15622907,2762,1,'2006-03-14 15:49:10',3310491620,1),(625036,425245931,15631270,427965,1,'2007-09-14 19:56:23',3310491620,1),(625037,425248714,15641570,427965,1,'2007-09-14 19:56:23',3310491620,1),(625038,425250612,15644488,427965,1,'2007-09-14 19:56:22',3310491620,1),(625039,425252761,15648066,2895121,1,'2009-10-19 19:23:45',3310491620,3),(625040,425261618,15667319,427965,1,'2007-09-14 19:56:23',3310491623,1),(625041,425270725,15679480,188228,1,'2008-06-16 19:35:06',3310491623,2),(625042,425273129,15685402,188228,1,'2008-06-16 19:35:26',3310491623,2),(625043,425275912,15690552,188228,1,'2008-06-16 19:35:55',3310491623,2),(625044,425285020,15692440,188228,1,'2008-06-16 19:38:21',3310491623,2),(625045,425288309,15691496,188228,1,'2008-06-16 19:38:45',3310491634,2),(625046,425291915,15695616,188228,1,'2008-06-16 19:39:37',3310491634,2),(625047,425291472,15702311,188228,1,'2008-06-16 19:39:37',3310491634,2),(625048,425291219,15707117,188228,1,'2008-06-16 19:39:37',3310491634,2),(625049,425291851,15710207,188228,1,'2008-06-16 19:39:37',3310491634,2),(625050,425298176,15719305,188228,1,'2008-06-16 19:41:22',3310491640,2),(625051,425311524,15728774,427965,1,'2007-09-14 19:56:23',3310491640,1),(625052,425320693,15738617,188228,1,'2008-06-16 20:02:41',3310491641,2),(625053,425323793,15745827,188228,1,'2008-06-16 20:02:41',3310491641,2),(625054,425326386,15756470,188228,1,'2008-06-16 20:02:41',3310491641,2),(625055,425327840,15765225,188228,1,'2008-06-16 20:02:41',3310491641,2),(625056,425329807,15783839,2762,1,'2006-03-14 15:49:36',3310491643,1),(625057,425333918,15797143,2762,1,'2006-03-14 15:49:37',3310491643,1),(625058,425341250,15806451,427965,1,'2007-09-14 19:56:23',3310491643,1),(625059,425350548,15813489,427965,1,'2007-09-14 19:56:23',3310491646,1),(625060,425359216,15819888,2762,1,'2006-03-14 15:49:41',3310491646,1),(625061,425363959,15826325,2762,1,'2006-03-14 15:49:42',3310493012,1),(625062,425371549,15837483,2762,1,'2006-03-14 15:49:45',3310493013,1),(625063,425368509,15847220,427965,1,'2007-09-14 19:56:23',3310493012,1),(625064,425362311,15850224,427965,1,'2007-09-14 19:56:23',3310493012,1),(625065,425349978,15857091,427965,1,'2007-09-14 19:56:23',3310493012,1),(625066,425347069,15857778,427965,1,'2007-09-14 19:51:34',3310493012,1),(625067,425340875,15851645,2762,1,'2006-03-14 15:49:54',3310493009,1),(625068,425335499,15850358,2762,1,'2006-03-14 15:49:57',3310493009,1),(625069,425335874,15855718,427965,1,'2007-09-14 19:56:23',3310493009,1),(625070,425342456,15863662,2762,1,'2006-03-14 15:49:59',3310493012,1),(625071,425220944,15598655,427965,1,'2007-09-14 19:56:23',3310491595,1),(625072,425372177,15843959,427965,1,'2007-09-14 19:56:23',3310493013,1),(625073,425349219,15876918,427965,1,'2007-09-14 19:51:17',3310493014,1),(625074,425356746,15884728,427965,1,'2007-09-14 19:51:17',3310493014,1),(625075,425363959,15888124,2762,1,'2006-03-14 15:52:08',3310493014,1),(625076,425370217,15893140,427965,1,'2007-09-14 19:51:17',3310493015,1),(625077,425375466,15904727,427965,1,'2007-09-14 19:51:17',3310493015,1),(625078,425396209,15917516,427965,1,'2007-09-14 19:51:17',3310493015,1),(625079,425402596,15919147,427965,1,'2007-09-14 19:51:17',3310503938,1),(625080,425404557,15920777,427965,1,'2007-09-14 19:51:17',3310503938,1),(625081,425412339,15922456,2762,1,'2006-03-14 15:52:18',3310503938,1),(625082,425417078,15917773,427965,1,'2007-09-14 19:51:17',3310503938,1),(625083,425420240,15916142,427965,1,'2007-09-14 19:51:17',3310503938,1),(625084,425429789,15914941,427965,1,'2007-09-14 19:49:09',3310503939,1),(625085,425432825,15915456,427965,1,'2007-09-14 19:49:09',3310503939,1),(625086,425443161,15918083,427965,1,'2007-09-14 20:33:11',3310503939,1),(625087,425445535,15917344,427965,1,'2007-09-14 19:49:09',3310503939,1),(625088,425452175,15914855,427965,1,'2007-09-14 19:49:09',3310503942,1),(625089,425462925,15914598,427965,1,'2007-09-14 19:49:09',3310503942,1),(625090,425470576,15917516,427965,1,'2007-09-14 19:49:09',3310503942,1),(625091,425489988,15916314,427965,1,'2007-09-14 19:48:40',3310503943,1),(625198,425497074,15914076,5671401,1,'2010-09-03 18:06:00',3310503943,2),(625199,425513473,15905539,5671401,1,'2010-09-03 18:06:02',3310503954,2),(625200,425515861,15903207,5671401,1,'2010-09-03 18:06:01',3310503954,2),(625202,425524242,15892711,5671401,1,'2010-09-03 18:06:00',3310503954,2),(625203,425529637,15888124,2774,1,'2006-03-14 23:12:11',3310503954,1),(625204,425535071,15886788,427965,1,'2007-09-14 19:48:40',3310503955,1),(625205,425547555,15885554,426786,1,'2007-09-14 10:10:35',3310503955,1),(625206,425554498,15884953,454632,1,'2007-09-17 18:41:27',3310503955,1),(625207,425574843,15886836,2774,1,'2006-03-14 23:12:15',3310503958,1),(625208,425587673,15891681,427965,1,'2007-09-14 19:46:49',3310503958,1),(625209,425593493,15892415,2774,1,'2006-03-14 23:12:17',3310503959,1),(625210,425596654,15894132,2774,1,'2006-03-14 23:12:18',3310503959,1),(625211,425605438,15899920,427965,1,'2007-09-14 19:46:49',3310503959,1),(625243,425619375,15903578,426786,1,'2007-09-14 10:13:24',3310504002,1),(625244,425629553,15905981,426786,1,'2007-09-14 10:13:24',3310504002,1),(625245,425638755,15910869,427965,1,'2007-09-14 19:12:43',3310504002,1),(625246,425640145,15919232,427965,1,'2007-09-14 19:45:55',3310504002,1),(625247,425641347,15925460,427965,1,'2007-09-14 19:12:43',3310504002,1),(625248,425642513,15928641,426786,1,'2007-09-14 10:13:29',3310504002,1),(625249,425656076,15936017,427965,1,'2007-09-14 19:12:39',3310504009,1),(625250,425657088,15938077,427965,1,'2007-09-14 19:12:11',3310504009,1),(625251,425660438,15942369,427965,1,'2007-09-14 19:12:11',3310504009,1),(625252,425661414,15956622,426786,1,'2007-09-14 10:13:29',3310504009,1),(625254,425658292,15967517,2774,1,'2006-03-14 23:27:22',3310504009,1),(625256,425657530,15975671,427965,1,'2007-09-14 19:12:11',3310504009,1),(625257,425658380,15978852,426786,1,'2007-09-14 10:13:29',3310504009,1),(625259,425666345,15998593,426786,1,'2007-09-14 10:13:29',3310504011,1),(625260,425671275,16010266,426786,1,'2007-09-14 10:13:37',3310504011,1),(625261,425675167,16016956,427965,1,'2007-09-14 19:10:26',3310504014,1),(625263,425680378,16026316,426786,1,'2007-09-14 10:13:32',3310504014,1),(625264,425684522,16037383,427965,1,'2007-09-14 19:10:38',3310504014,1),(625265,425695079,16047254,427965,1,'2007-09-14 19:10:38',3310504036,1),(625266,425699377,16048198,427965,1,'2007-09-14 19:10:15',3310504037,1),(625267,425707721,16062532,427965,1,'2007-09-14 19:10:15',3310504037,1),(625268,425708858,16070085,427965,1,'2007-09-14 19:10:11',3310504037,1),(625269,425710375,16078067,427965,1,'2007-09-14 19:10:11',3310504037,1),(625270,425715495,16091199,427965,1,'2007-09-14 19:08:20',3310504037,1),(625271,425715559,16095319,427965,1,'2007-09-14 19:08:20',3310504039,1),(625272,425716218,16112147,426786,1,'2007-09-14 10:13:42',3310504039,1),(625273,425718747,16117039,426786,1,'2007-09-14 10:13:42',3310504039,1),(625274,425723902,16146131,427965,1,'2007-09-14 19:08:20',3310504039,1),(625275,425725699,16151801,426786,1,'2007-09-14 10:13:42',3310504045,1),(625276,425728101,16160040,426786,1,'2007-09-14 10:13:42',3310504056,1),(625277,425729084,16165137,427965,1,'2007-09-14 19:43:57',3310504056,1),(625293,425746312,16207325,495907,1,'2008-07-15 19:46:04',3310504058,2),(625294,425754781,16222517,495907,1,'2008-07-15 19:48:35',3310504059,3),(625295,425765336,16246378,495907,1,'2008-07-15 19:48:35',3310504059,2),(625296,425770772,16255219,495907,1,'2008-07-15 19:48:35',3310504059,2),(625297,425775133,16258480,495907,1,'2008-07-15 19:48:35',3310504059,2),(625298,425779620,16270840,495907,1,'2008-07-15 19:48:35',3310504145,2),(625299,425780442,16292898,495907,1,'2008-07-15 19:48:35',3310504145,2),(625300,425784044,16300366,495907,1,'2008-07-15 19:48:35',3310504148,2),(625301,425785561,16319334,495907,1,'2008-07-15 19:48:35',3310504150,2),(625302,425783033,16329119,495907,1,'2008-07-15 19:48:35',3310504150,2),(625303,425783602,16348946,495907,1,'2008-07-15 19:50:23',3310504150,2),(625304,425789795,16374952,495907,1,'2008-07-15 19:50:23',3310504156,2),(625305,425787963,16390316,495907,1,'2008-07-15 19:50:23',3310504156,2),(625306,425797064,16404478,495907,1,'2008-07-15 19:50:57',3310504156,2),(625307,425799781,16416409,495907,1,'2008-07-15 19:50:57',3310504156,2),(26609114,424993792,15130420,434787,1,'2007-09-15 15:33:35',3310491403,1),(45160875,425835415,14617491,110477,1,'2008-12-04 18:28:50',3310502109,5),(45160879,425822776,14579726,110477,1,'2008-12-04 18:28:50',3310502103,5),(45160885,425754519,14572859,110477,1,'2008-12-04 18:28:50',3310502099,5),(45160890,425726708,14524794,110477,1,'2008-12-04 18:28:50',3310502085,5),(45160893,425681197,14466429,110477,1,'2008-12-04 18:28:50',3310501998,5),(45160897,425951686,14751387,110477,1,'2008-12-04 18:28:48',3310502320,5),(45160899,425928939,14737654,110477,1,'2008-12-04 18:28:49',3310502309,5),(45160902,425901136,14734221,110477,1,'2008-12-04 18:28:49',3310502308,5),(45160904,425880560,14747220,110477,1,'2008-12-04 18:28:49',3310502305,4),(45160908,425855560,14719440,110477,1,'2008-12-04 18:28:49',3310502282,4),(45160910,425830560,14688890,110477,1,'2008-12-04 18:28:49',3310502111,4),(45160922,426499887,15166808,784366,1,'2008-11-23 16:35:10',3310503520,4),(45160924,426497362,15129042,784366,1,'2008-11-23 16:35:10',3310503498,4),(45160947,426014867,14706755,110477,1,'2008-12-04 18:28:48',3310502302,5),(45160950,425979486,14747954,110477,1,'2008-12-04 18:28:48',3310502321,6),(45160954,426411500,14765120,784366,1,'2008-11-23 16:35:10',3310503088,4),(45160958,426224900,14663107,784366,1,'2008-11-23 16:35:12',3310502364,7),(45160962,426464534,14957381,784366,1,'2008-11-23 16:35:10',3310503444,4),(45160967,426456958,14878416,784366,1,'2008-11-23 16:35:10',3310503100,4),(45160974,426497362,15091277,784366,1,'2008-11-23 16:35:10',3310503496,4),(45160977,426479685,15043211,784366,1,'2008-11-23 16:35:10',3310503447,4),(45161058,426561110,15547220,784366,1,'2008-11-23 16:35:09',3310503630,3),(45161062,426535206,15582609,784366,1,'2008-11-23 16:35:09',3310503627,4),(45161066,426530156,15622091,784366,1,'2008-11-23 16:35:08',3310503649,4),(45161067,426525738,15652990,784366,1,'2008-11-23 16:35:08',3310503649,4),(45161204,426483330,15230560,784366,1,'2008-11-23 16:35:10',3310503479,3),(45161208,426522220,15244440,784366,1,'2008-11-23 16:35:10',3310503522,3),(45161227,426295915,16118192,784366,1,'2008-11-23 16:35:05',3310504994,4),(45161231,426280127,16069269,784366,1,'2008-11-23 16:35:06',3310504992,4),(45161233,426273181,16014337,784366,1,'2008-11-23 16:35:07',3310504287,4),(45161238,426307913,15973138,784366,1,'2008-11-23 16:35:07',3310504969,4),(45161251,426355273,16260671,784366,1,'2008-11-23 16:35:05',3310505092,4),(45161256,426323069,16200589,784366,1,'2008-11-23 16:35:05',3310505001,4),(45161262,426307282,16167974,784366,1,'2008-11-23 16:35:05',3310505001,4),(45161265,426444299,15791177,784366,1,'2008-11-23 16:35:08',3310503614,4),(45161269,426475866,15751695,784366,1,'2008-11-23 16:35:08',3310503613,4),(45161277,426492911,15713929,784366,1,'2008-11-23 16:35:08',3310503613,4),(45161283,426513112,15675306,784366,1,'2008-11-23 16:35:08',3310503650,4),(45161289,426369164,15938806,784366,1,'2008-11-23 16:35:07',3310504973,4),(45161296,426391895,15890741,784366,1,'2008-11-23 16:35:07',3310504978,4),(45161302,426409574,15840101,784366,1,'2008-11-23 16:35:07',3310504976,4),(45161308,426429778,15815210,784366,1,'2008-11-23 16:35:08',3310503611,4),(45161330,426308330,16950000,784366,1,'2008-11-23 16:35:01',3310505505,3),(45161333,426291670,16991670,784366,1,'2008-11-23 16:35:00',3310505506,3),(45161344,426327780,16911110,784366,1,'2008-11-23 16:35:01',3310505483,3),(45181716,426174178,14623441,4133451,1,'2010-03-15 12:47:53',3310502360,4),(51110488,424847502,14917003,592895,1,'2008-07-25 21:28:01',3310490863,5),(51110489,424844591,14912196,592895,1,'2008-07-25 21:28:01',3310490863,2),(51110491,424844528,14910994,592895,1,'2008-07-25 21:28:01',3310490863,2),(51110493,424843895,14910308,592895,1,'2008-07-25 21:28:01',3310490863,2),(51110495,424842888,14910345,592895,1,'2008-07-25 21:28:01',3310490863,2),(51110496,424842445,14910775,592895,1,'2008-07-25 21:28:01',3310490863,2),(51110498,424842122,14912883,592895,1,'2008-07-25 21:28:02',3310490863,3),(51110499,424842882,14913913,592895,1,'2008-07-25 21:28:02',3310490863,3),(51110501,424843831,14914084,592895,1,'2008-07-25 21:28:02',3310490863,3),(51110502,424849275,14919320,592895,1,'2008-07-25 22:02:15',3310490874,7),(51111214,424677313,14916363,508959,1,'2007-09-24 18:39:54',3310490811,1),(51111216,424681373,14917652,508959,1,'2007-09-24 18:39:54',3310490811,1),(51111218,424685366,14919282,508959,1,'2007-09-24 18:39:54',3310490814,1),(51111220,424689157,14920253,434787,1,'2007-09-15 15:24:53',3310490814,1),(51111222,424693209,14921408,508959,1,'2007-09-24 18:39:54',3310490814,1),(51111223,424697434,14923825,434787,1,'2007-09-15 15:24:53',3310490814,1),(51111226,424700374,14926036,508959,1,'2007-09-24 18:39:54',3310490814,1),(51111228,424702667,14927482,508959,1,'2007-09-24 18:39:54',3310490814,1),(51111229,424704976,14928559,508959,1,'2007-09-24 18:39:54',3310490814,1),(51111231,424707140,14928726,434787,1,'2007-09-15 15:24:52',3310490814,1),(51111232,424710217,14926263,508959,1,'2007-09-24 18:39:54',3310490814,1),(51111234,424712653,14924229,508959,1,'2007-09-24 18:39:54',3310490815,1),(51111236,424715202,14923357,508959,1,'2007-09-24 18:39:54',3310490815,1),(51111238,424717599,14924075,508959,1,'2007-09-24 18:39:54',3310490815,1),(51111239,424721813,14926893,508959,1,'2007-09-24 18:39:54',3310490815,1),(51111241,424725420,14929417,508959,1,'2007-09-24 18:39:54',3310490815,1),(51111244,424730160,14929298,508959,1,'2007-09-24 18:39:54',3310490815,1),(51111245,424732120,14924517,508959,1,'2007-09-24 18:39:54',3310490815,1),(51111247,424734485,14916877,508959,1,'2007-09-24 18:39:54',3310490815,1),(51111248,424736992,14910081,434787,1,'2007-09-15 15:24:50',3310490815,1),(51111250,424740856,14906846,508959,1,'2007-09-24 18:39:54',3310490858,1),(51111251,424743955,14904108,508959,1,'2007-09-24 18:39:54',3310490858,1),(51111253,424747340,14904050,434787,1,'2007-09-15 15:24:51',3310490858,1),(51111254,424750434,14904726,508959,1,'2007-09-24 18:39:54',3310490858,1),(51111256,424753143,14905178,508959,1,'2007-09-24 18:39:54',3310490858,1),(51111257,424756886,14903817,508959,1,'2007-09-24 18:39:54',3310490858,1),(51111259,424760469,14903137,434787,1,'2007-09-15 15:24:49',3310490858,1),(51111260,424763119,14903020,508959,1,'2007-09-24 18:39:54',3310490858,1),(51111262,424767085,14903025,434787,1,'2007-09-15 15:24:50',3310490859,1),(51111263,424772493,14902004,508959,1,'2007-09-24 18:39:54',3310490859,1),(51111265,424777773,14899603,508959,1,'2007-09-24 18:39:54',3310490859,1),(51111266,424784717,14892353,434787,1,'2007-09-15 15:24:47',3310490859,1),(51111268,424790334,14886523,508959,1,'2007-09-24 18:39:54',3310490857,1),(51111270,424793845,14884688,434787,1,'2007-09-15 15:24:48',3310490860,1),(51111271,424799476,14884529,508959,1,'2007-09-24 18:39:54',3310490860,1),(51111273,424804414,14885945,508959,1,'2007-09-24 18:39:54',3310490860,1),(51118071,425403068,17242365,206510,1,'2008-12-06 20:13:39',3310504578,2),(51118073,425405092,17245369,206510,1,'2008-12-06 20:13:39',3310504578,2),(51118074,425407052,17247172,206510,1,'2008-12-06 20:13:39',3310504578,2),(51118076,425408633,17248116,206510,1,'2008-12-06 20:13:39',3310504578,2),(51118077,425410910,17248631,426786,1,'2007-09-14 10:14:01',3310504578,1),(51118078,425413313,17248030,426786,1,'2007-09-14 10:14:01',3310504578,1),(51118080,425414451,17247258,426786,1,'2007-09-14 10:14:01',3310504578,1),(51118081,425415716,17246743,426786,1,'2007-09-14 10:14:01',3310504578,1),(51118082,425416285,17246914,426786,1,'2007-09-14 10:14:01',3310504578,1),(51118083,425416791,17247429,426786,1,'2007-09-14 10:14:01',3310504578,1),(51118085,425416791,17248631,426786,1,'2007-09-14 10:14:01',3310504578,1),(51118086,425416538,17249833,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118087,425415842,17250605,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118088,425414704,17250948,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118090,425412933,17251034,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118091,425410783,17251721,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118092,425408886,17253266,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118094,425406799,17254639,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118095,425404712,17255326,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118096,425402689,17254811,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118097,425401044,17253609,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118099,425398009,17250176,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118100,425396112,17247258,426786,1,'2007-09-14 10:14:01',3310493655,1),(51118102,425395606,17245284,426786,1,'2007-09-14 10:14:01',3310493655,1),(51118103,425394467,17243996,426786,1,'2007-09-14 10:14:01',3310493655,1),(51118104,425393392,17243739,426786,1,'2007-09-14 10:14:01',3310493655,1),(51118105,425392570,17244597,426786,1,'2007-09-14 10:14:01',3310493655,1),(51118106,425392507,17246228,426786,1,'2007-09-14 10:14:01',3310493655,1),(51118107,425393456,17248373,426786,1,'2007-09-14 10:14:01',3310493655,1),(51118108,425394784,17250863,426786,1,'2007-09-14 10:14:01',3310493661,1),(51118110,425397313,17254982,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118111,425399527,17258416,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118113,425402183,17260476,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118114,425404523,17261248,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118115,425407305,17262106,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118117,425409582,17262965,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118118,425412111,17264252,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118119,425413756,17265969,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118121,425415842,17268200,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118122,425417297,17270174,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118123,425419321,17271805,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118124,425422609,17273264,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118125,425426719,17275153,426786,1,'2007-09-14 10:14:01',3310504585,1),(51118127,425429439,17276698,426786,1,'2007-09-14 10:14:01',3310504585,1),(51118128,425431399,17276869,426786,1,'2007-09-14 10:14:01',3310504585,1),(51118129,425432790,17276354,206510,1,'2008-12-06 20:11:10',3310504585,2),(51118130,425433865,17275496,206510,1,'2008-12-06 20:11:10',3310504585,2),(51118131,425434877,17275582,206510,1,'2008-12-06 20:11:11',3310504585,2),(51118132,425435446,17276869,206510,1,'2008-12-06 20:11:11',3310504585,2),(51118133,425435446,17278157,206510,1,'2008-12-06 20:11:11',3310504585,2),(51118134,425434814,17278929,206510,1,'2008-12-06 20:11:11',3310504585,2),(51118135,425433612,17279444,206510,1,'2008-12-06 20:11:32',3310504585,4),(51118136,425431905,17279444,206510,1,'2008-12-06 20:11:32',3310504585,3),(51118137,425428490,17279444,206510,1,'2008-12-06 20:11:33',3310504585,3),(51118138,425424506,17279015,206510,1,'2008-12-06 20:11:33',3310504584,3),(51118140,425420269,17278157,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118141,425417423,17277384,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118142,425414262,17275925,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118143,425410151,17274552,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118144,425407368,17273865,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118145,425405471,17273865,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118146,425402878,17274294,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118148,425400918,17275668,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118149,425398894,17277213,426786,1,'2007-09-14 10:14:01',3310504584,1),(51118150,425396618,17278500,426786,1,'2007-09-14 10:14:01',3310493661,1),(51118151,425393582,17278157,426786,1,'2007-09-14 10:14:01',3310493661,1),(51118152,425389788,17276183,426786,1,'2007-09-14 10:14:01',3310493661,1),(51118153,425384981,17273522,426786,1,'2007-09-14 10:14:01',3310493661,1),(51118155,425380491,17271204,426786,1,'2007-09-14 10:14:01',3310493661,1),(51118156,425377708,17268629,426786,1,'2007-09-14 10:14:01',3310493661,1),(51118157,425376127,17266741,206510,1,'2008-12-06 20:10:04',3310493661,2),(51118159,425374862,17266655,206510,1,'2008-12-06 20:10:04',3310493661,2),(51118160,425374103,17267514,206510,1,'2008-12-06 20:10:04',3310493661,2),(51118161,425373850,17269316,206510,1,'2008-12-06 20:10:04',3310493661,2),(51118162,425374483,17270689,206510,1,'2008-12-06 20:10:04',3310493661,2),(51118164,425375684,17271719,206510,1,'2008-12-06 20:10:15',3310493661,4),(51118165,425376886,17273436,206510,1,'2008-12-06 20:10:15',3310493661,3),(51118166,425378024,17276783,206510,1,'2008-12-06 20:10:15',3310493661,3),(51118168,425378973,17279272,206510,1,'2008-12-06 20:10:15',3310493661,3),(51118169,425380807,17282448,206510,1,'2008-12-06 20:10:24',3310493661,4),(51118170,425383590,17285452,206510,1,'2008-12-06 20:10:24',3310493661,2),(51118171,425388143,17290173,206510,1,'2008-12-06 20:10:24',3310493661,2),(51118173,425391242,17292405,206510,1,'2008-12-06 20:10:24',3310493661,2),(51118174,425393961,17293263,206510,1,'2008-12-06 20:10:24',3310493661,2),(51118176,425397629,17293349,206510,1,'2008-12-06 20:10:24',3310504584,2),(51118177,425400728,17293950,206510,1,'2008-12-06 20:10:24',3310504584,2),(51118178,425404270,17295151,206510,1,'2008-12-06 20:10:24',3310504584,2),(51118179,425408760,17296954,206510,1,'2008-12-06 20:10:24',3310504584,2),(51118180,425411732,17297984,206510,1,'2008-12-06 20:10:24',3310504584,2),(51118181,425416918,17298842,206510,1,'2008-12-06 20:10:24',3310504584,2),(51118182,425420965,17299614,206510,1,'2008-12-06 20:10:24',3310504584,2),(51118183,425426467,17301503,206510,1,'2008-12-06 20:10:24',3310504585,2),(51118184,425435257,17304249,206510,1,'2008-12-06 20:10:24',3310504587,2),(51118185,425438608,17305365,206510,1,'2008-12-06 20:10:24',3310504587,2),(51118186,425443351,17305708,206510,1,'2008-12-06 20:10:24',3310504587,2),(51118187,425448030,17305708,206510,1,'2008-12-06 20:10:24',3310504587,2),(51118188,425452899,17306223,206510,1,'2008-12-06 20:10:24',3310504590,2),(51118189,425458338,17307682,206510,1,'2008-12-06 20:10:24',3310504590,2),(51118190,425462574,17308970,206510,1,'2008-12-06 20:10:24',3310504590,2),(51118191,425468012,17310000,206510,1,'2008-12-06 20:09:53',3310504590,4),(51118192,425471048,17312060,206510,1,'2008-12-06 20:09:53',3310504590,4),(51118193,425473703,17315236,206510,1,'2008-12-06 20:09:53',3310504590,4),(51118194,425479711,17320557,206510,1,'2008-12-06 20:09:53',3310504591,4),(51118205,425475600,17321930,206510,1,'2008-12-06 20:09:05',3310504590,3),(51118206,425471237,17319956,206510,1,'2008-12-06 20:09:05',3310504590,3),(51118207,425468771,17318583,206510,1,'2008-12-06 20:09:05',3310504590,3),(51118208,425465610,17317124,206510,1,'2008-12-06 20:09:05',3310504590,3),(51118209,425462258,17317381,206510,1,'2008-12-06 20:09:05',3310504590,3),(51118210,425457199,17318755,206510,1,'2008-12-06 20:09:05',3310504590,3),(51118211,425453532,17319699,206510,1,'2008-12-06 20:09:06',3310504590,3),(51118263,425394594,17232066,206510,1,'2008-12-06 20:13:38',3310493655,2),(51118641,425405408,17190352,206510,1,'2008-12-06 20:14:08',3310504576,4),(51118642,425402815,17192755,206510,1,'2008-12-06 20:14:08',3310504576,4),(51118653,425397575,17209422,206510,1,'2008-12-06 20:14:04',3310504578,5),(51118654,425395542,17205458,206510,1,'2008-12-06 20:14:04',3310493655,5),(51118655,425391558,17199965,206510,1,'2008-12-06 20:13:34',3310493655,2),(51118656,425387068,17193785,206510,1,'2008-12-06 20:13:35',3310493653,2),(51118658,425383843,17191725,206510,1,'2008-12-06 20:13:35',3310493653,2),(51118659,425380364,17191554,206510,1,'2008-12-06 20:13:35',3310493653,2),(51118661,425378214,17192927,206510,1,'2008-12-06 20:13:35',3310493653,2),(51118662,425376507,17194815,206510,1,'2008-12-06 20:13:36',3310493655,2),(51118663,425375368,17198248,206510,1,'2008-12-06 20:13:36',3310493655,2),(51118664,425375115,17202540,206510,1,'2008-12-06 20:13:37',3310493655,2),(51118666,425375874,17206488,206510,1,'2008-12-06 20:13:37',3310493655,2),(51118667,425377202,17210093,206510,1,'2008-12-06 20:13:37',3310493655,2),(51118668,425380301,17214728,206510,1,'2008-12-06 20:13:38',3310493655,2),(51118669,425384159,17219534,206510,1,'2008-12-06 20:13:38',3310493655,2),(51118671,425388649,17224856,206510,1,'2008-12-06 20:13:38',3310493655,2),(51119058,425419447,17109585,426786,1,'2007-09-14 10:13:57',3310504490,1),(51119060,425417993,17114220,426786,1,'2007-09-14 10:13:57',3310504490,1),(51119061,425415716,17116795,426786,1,'2007-09-14 10:13:57',3310504490,1),(51119062,425412681,17117653,206510,1,'2008-12-06 20:15:08',3310504490,6),(51119064,425410341,17116967,206510,1,'2008-12-06 20:15:08',3310504490,6),(51119065,425408380,17115336,206510,1,'2008-12-06 20:15:09',3310504490,6),(51119066,425406989,17114821,206510,1,'2008-12-06 20:15:09',3310504490,6),(51119067,425406357,17114907,206510,1,'2008-12-06 20:15:09',3310504490,6),(51119069,425405851,17115937,206510,1,'2008-12-06 20:15:09',3310504490,6),(51119070,425405724,17117138,206510,1,'2008-12-06 20:15:09',3310504490,6),(51119071,425405914,17118254,206510,1,'2008-12-06 20:15:09',3310504490,6),(51119072,425406989,17119284,206510,1,'2008-12-06 20:15:09',3310504490,6),(51119073,425409708,17120829,206510,1,'2008-12-06 20:15:09',3310504490,6),(51119075,425413439,17122803,206510,1,'2008-12-06 20:15:09',3310504490,6),(51119076,425417360,17125121,206510,1,'2008-12-06 20:15:10',3310504490,6),(51119077,425419637,17126494,206510,1,'2008-12-06 20:15:10',3310504490,6),(51119078,425421660,17126494,206510,1,'2008-12-06 20:15:10',3310504490,6),(51119079,425423241,17125292,206510,1,'2008-12-06 20:15:10',3310504490,6),(51119081,425424190,17123490,206510,1,'2008-12-06 20:15:10',3310504490,6),(51119082,425424633,17122116,206510,1,'2008-12-06 20:15:10',3310504491,6),(51119083,425424822,17119198,206510,1,'2008-12-06 20:15:11',3310504491,6),(51119085,425424316,17116795,206510,1,'2008-12-06 20:15:11',3310504490,6),(51119086,425424822,17115593,206510,1,'2008-12-06 20:15:11',3310504491,6),(51119088,425425455,17114993,206510,1,'2008-12-06 20:15:11',3310504491,6),(51119089,425426340,17114993,206510,1,'2008-12-06 20:15:11',3310504491,6),(51119090,425426783,17116194,206510,1,'2008-12-06 20:15:11',3310504491,6),(51119091,425426593,17117911,206510,1,'2008-12-06 20:15:12',3310504491,6),(51119093,425426467,17120400,206510,1,'2008-12-06 20:15:12',3310504491,6),(51119094,425426467,17123061,206510,1,'2008-12-06 20:15:12',3310504491,6),(51119096,425426467,17124434,206510,1,'2008-12-06 20:15:12',3310504491,6),(51119097,425426467,17127009,206510,1,'2008-12-06 20:15:12',3310504491,6),(51119098,425425265,17130442,206510,1,'2008-12-06 20:15:12',3310504491,6),(51119099,425423621,17133618,206510,1,'2008-12-06 20:15:12',3310504490,6),(51119101,425421660,17136364,206510,1,'2008-12-06 20:15:12',3310504490,6),(51119102,425418499,17139368,206510,1,'2008-12-06 20:15:12',3310504576,6),(51119103,425415526,17140570,206510,1,'2008-12-06 20:15:13',3310504576,6),(51119104,425412807,17140484,206510,1,'2008-12-06 20:15:13',3310504576,6),(51119105,425407432,17138939,206510,1,'2008-12-06 20:15:13',3310504576,8),(51119106,425404459,17136708,206510,1,'2008-12-06 20:15:03',3310504490,7),(51119107,425403321,17135420,206510,1,'2008-12-06 20:15:03',3310504490,7),(51119108,425402056,17135163,206510,1,'2008-12-06 20:15:03',3310504490,7),(51119109,425401424,17135935,206510,1,'2008-12-06 20:15:04',3310504490,7),(51119110,425401234,17137223,206510,1,'2008-12-06 20:15:04',3310504490,7),(51119111,425401740,17138853,206510,1,'2008-12-06 20:15:04',3310504490,7),(51119112,425404396,17141686,206510,1,'2008-12-06 20:15:04',3310504576,8),(51119113,425405787,17144175,206510,1,'2008-12-06 20:14:56',3310504576,5),(51119114,425407368,17147866,206510,1,'2008-12-06 20:14:56',3310504576,5),(51119116,425408949,17151299,206510,1,'2008-12-06 20:14:56',3310504576,5),(51119117,425410973,17156449,206510,1,'2008-12-06 20:14:56',3310504576,5),(51119118,425412301,17159796,206510,1,'2008-12-06 20:14:56',3310504576,5),(51119119,425414198,17161770,206510,1,'2008-12-06 20:14:57',3310504576,5),(51119120,425416728,17162800,206510,1,'2008-12-06 20:14:57',3310504576,5),(51119121,425419763,17162371,206510,1,'2008-12-06 20:14:57',3310504576,6),(51119123,425422293,17161169,206510,1,'2008-12-06 20:14:16',3310504576,5),(51119124,425423178,17161770,206510,1,'2008-12-06 20:14:17',3310504576,5),(51119125,425423747,17162800,206510,1,'2008-12-06 20:14:17',3310504576,5),(51119126,425423558,17164431,206510,1,'2008-12-06 20:14:17',3310504576,5),(51119127,425421913,17167864,206510,1,'2008-12-06 20:14:17',3310504576,6),(51119128,425416222,17179709,206510,1,'2008-12-06 20:14:08',3310504576,4),(51119129,425414325,17183314,206510,1,'2008-12-06 20:14:08',3310504576,4),(51119130,425411732,17185975,206510,1,'2008-12-06 20:14:08',3310504576,4),(51119131,425408191,17188635,206510,1,'2008-12-06 20:14:08',3310504576,4),(51119407,425483947,17055169,426786,1,'2007-09-14 10:13:57',3310504493,1),(51119409,425479900,17055169,426786,1,'2007-09-14 10:13:57',3310504493,1),(51119410,425476169,17055169,426786,1,'2007-09-14 10:13:57',3310504492,1),(51119411,425473071,17056284,426786,1,'2007-09-14 10:13:57',3310504492,1),(51119413,425470162,17058430,426786,1,'2007-09-14 10:13:57',3310504492,1),(51119414,425466811,17060833,426786,1,'2007-09-14 10:13:57',3310504492,1),(51119416,425463902,17063580,426786,1,'2007-09-14 10:13:57',3310504492,1),(51119417,425461246,17067099,426786,1,'2007-09-14 10:13:57',3310504492,1),(51119419,425457832,17070961,426786,1,'2007-09-14 10:13:57',3310504492,1),(51119420,425452963,17074824,426786,1,'2007-09-14 10:13:57',3310504492,1),(51119421,425447967,17077999,426786,1,'2007-09-14 10:13:57',3310504489,1),(51119422,425443477,17079888,426786,1,'2007-09-14 10:13:57',3310504489,1),(51119424,425440315,17080918,426786,1,'2007-09-14 10:13:57',3310504489,1),(51119425,425435257,17083664,426786,1,'2007-09-14 10:13:57',3310504489,1),(51119426,425431715,17086497,426786,1,'2007-09-14 10:13:57',3310504491,1),(51119427,425428996,17089930,426786,1,'2007-09-14 10:13:57',3310504491,1),(51119428,425426846,17092934,426786,1,'2007-09-14 10:13:57',3310504491,1),(51119430,425424822,17096024,426786,1,'2007-09-14 10:13:57',3310504491,1),(51119431,425422546,17099715,426786,1,'2007-09-14 10:13:57',3310504490,1),(51119432,425421028,17102890,426786,1,'2007-09-14 10:13:57',3310504490,1),(51119433,425420016,17107010,426786,1,'2007-09-14 10:13:57',3310504490,1),(51119435,425419004,17112246,426786,1,'2007-09-14 10:13:57',3310504490,1),(51119541,425476233,17041436,426786,1,'2007-09-14 10:13:57',3310504492,1),(51119542,425480406,17042036,426786,1,'2007-09-14 10:13:57',3310504493,1),(51119543,425484200,17043925,426786,1,'2007-09-14 10:13:57',3310504493,1),(51119545,425486856,17044182,426786,1,'2007-09-14 10:13:57',3310504493,1),(51119546,425489701,17043581,426786,1,'2007-09-14 10:13:57',3310504493,1),(51119547,425492863,17041350,426786,1,'2007-09-14 10:13:57',3310504493,1),(51119548,425495708,17038517,426786,1,'2007-09-14 10:13:57',3310504493,1),(51119550,425497289,17036887,426786,1,'2007-09-14 10:13:57',3310504493,1),(51119551,425498111,17036543,426786,1,'2007-09-14 10:13:57',3310504493,1),(51119553,425498996,17037058,426786,1,'2007-09-14 10:13:57',3310504493,1),(51119554,425498996,17038260,426786,1,'2007-09-14 10:13:57',3310504493,1),(51119555,425498617,17039633,426786,1,'2007-09-14 10:13:57',3310504493,1),(51119556,425496088,17042723,426786,1,'2007-09-14 10:13:57',3310504493,1),(51119558,425493369,17045813,426786,1,'2007-09-14 10:13:57',3310504493,1),(51119559,425490333,17049675,426786,1,'2007-09-14 10:13:57',3310504493,1),(51119560,425487109,17053109,426786,1,'2007-09-14 10:13:57',3310504493,1),(51119613,425465483,17042809,426786,1,'2007-09-14 10:13:55',3310504492,1),(51119614,425465926,17042723,426786,1,'2007-09-14 10:13:55',3310504492,1),(51119615,425467759,17042122,426786,1,'2007-09-14 10:13:55',3310504492,1),(51119616,425470795,17041350,426786,1,'2007-09-14 10:13:55',3310504492,1),(51119617,425473703,17041264,426786,1,'2007-09-14 10:13:55',3310504492,1),(51119951,425431652,17035342,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119952,425429945,17034569,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119953,425428996,17034912,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119954,425428300,17035857,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119956,425428490,17037144,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119957,425429502,17038346,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119958,425432790,17038947,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119959,425436648,17038775,426786,1,'2007-09-14 09:57:16',3310504489,1),(51119960,425439240,17038517,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119961,425441138,17037659,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119962,425442529,17037230,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119964,425443288,17037487,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119965,425443920,17038689,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119966,425443541,17039891,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119968,425442592,17041006,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119969,425440379,17041092,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119970,425437280,17041779,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119972,425434434,17043152,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119973,425428680,17046156,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119974,425426340,17047015,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119976,425424190,17047272,426786,1,'2007-09-14 10:13:55',3310504488,1),(51119977,425422356,17047015,426786,1,'2007-09-14 10:13:55',3310504488,1),(51119978,425421091,17047530,426786,1,'2007-09-14 10:13:55',3310504488,1),(51119979,425420522,17048645,426786,1,'2007-09-14 10:13:55',3310504488,1),(51119980,425420522,17050019,426786,1,'2007-09-14 10:13:55',3310504488,1),(51119981,425421471,17051220,426786,1,'2007-09-14 09:57:16',3310504488,1),(51119983,425422609,17051220,426786,1,'2007-09-14 09:57:16',3310504488,1),(51119984,425424063,17050362,426786,1,'2007-09-14 10:13:55',3310504488,1),(51119986,425425518,17050019,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119987,425427478,17049933,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119988,425430387,17050448,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119989,425435889,17050705,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119990,425438355,17050448,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119991,425442971,17049075,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119992,425448410,17047701,426786,1,'2007-09-14 10:13:55',3310504489,1),(51119993,425453089,17046500,426786,1,'2007-09-14 10:13:55',3310504492,1),(51119994,425458464,17044783,426786,1,'2007-09-14 10:13:55',3310504492,1),(51120868,425564816,16896382,426786,1,'2007-09-14 10:13:53',3310504478,1),(51120869,425556470,16903677,426786,1,'2007-09-14 10:13:55',3310504475,1),(51120871,425547871,16911316,426786,1,'2007-09-14 10:13:55',3310504475,1),(51120872,425540095,16918698,426786,1,'2007-09-14 10:13:55',3310504475,1),(51120873,425533203,16927195,426786,1,'2007-09-14 10:13:55',3310504496,1),(51120874,425529093,16933117,426786,1,'2007-09-14 10:13:55',3310504496,1),(51120876,425522932,16942897,427965,1,'2007-09-14 18:53:33',3310504496,1),(51120877,425514713,16955514,427965,1,'2007-09-14 18:53:55',3310504496,1),(51120878,425507659,16965990,426786,1,'2007-09-14 10:13:55',3310504496,1),(51120879,425504244,16971312,426786,1,'2007-09-14 10:13:55',3310504485,1),(51120881,425501462,16976118,426786,1,'2007-09-14 10:13:55',3310504487,1),(51120882,425499059,16980410,426786,1,'2007-09-14 10:13:55',3310504487,1),(51120883,425497289,16984101,426786,1,'2007-09-14 10:13:55',3310504487,1),(51120884,425494444,16988306,426786,1,'2007-09-14 10:13:55',3310504487,1),(51120885,425490903,16992855,426786,1,'2007-09-14 10:13:55',3310504487,1),(51120887,425486160,16997490,426786,1,'2007-09-14 10:13:55',3310504487,1),(51120888,425482366,16999894,426786,1,'2007-09-14 10:13:55',3310504487,1),(51120889,425480216,17000924,426786,1,'2007-09-14 10:13:55',3310504487,1),(51120890,425476739,17002297,426786,1,'2007-09-14 10:13:55',3310504486,1),(51120891,425470731,17006245,427965,1,'2007-09-14 20:50:22',3310504486,1),(51120892,425465104,17010107,426786,1,'2007-09-14 10:13:55',3310504486,1),(51120893,425459602,17014485,426786,1,'2007-09-14 10:13:55',3310504486,1),(51120895,425454101,17019549,426786,1,'2007-09-14 10:13:55',3310504486,1),(51120896,425449232,17024870,426786,1,'2007-09-14 10:13:55',3310504483,1),(51120897,425443288,17030707,426786,1,'2007-09-14 10:13:55',3310504489,1),(51120898,425439430,17033797,426786,1,'2007-09-14 10:13:55',3310504489,1),(51120899,425435762,17034998,426786,1,'2007-09-14 10:13:55',3310504489,1),(51120900,425433739,17035427,426786,1,'2007-09-14 10:13:55',3310504489,1),(51120956,425577713,16883593,426786,1,'2007-09-14 10:13:53',3310504478,1),(51120957,425575311,16887112,426786,1,'2007-09-14 10:13:53',3310504478,1),(51120959,425571454,16891489,426786,1,'2007-09-14 10:13:53',3310504478,1),(51121326,425650035,16796647,426786,1,'2007-09-14 10:13:53',3310504515,1),(51121327,425647064,16796647,426786,1,'2007-09-14 10:13:53',3310504515,1),(51121329,425645484,16797333,426786,1,'2007-09-14 10:13:53',3310504515,1),(51121330,425643271,16798706,426786,1,'2007-09-14 10:13:53',3310504514,1),(51121331,425640300,16801196,426786,1,'2007-09-14 10:13:53',3310504514,1),(51121332,425620380,16821803,198831,1,'2008-04-20 16:24:55',3310504520,2),(51121334,425615329,16827803,426786,1,'2007-09-14 10:13:53',3310504477,1),(51121335,425612168,16831751,426786,1,'2007-09-14 10:13:53',3310504477,1),(51121337,425609576,16836300,426786,1,'2007-09-14 10:13:53',3310504477,1),(51121338,425605657,16843682,426786,1,'2007-09-14 10:13:53',3310504477,1),(51121339,425601990,16848917,426786,1,'2007-09-14 10:13:53',3310504477,1),(51121341,425595795,16857758,426786,1,'2007-09-14 10:13:53',3310504477,1),(51121342,425588967,16866856,426786,1,'2007-09-14 10:13:53',3310504478,1),(51121362,425658253,16794501,426786,1,'2007-09-14 10:00:01',3310504515,1),(51121363,425654208,16796217,426786,1,'2007-09-14 10:13:53',3310504515,1),(51121951,425832890,16630135,426786,1,'2007-09-14 10:13:53',3310504189,1),(51121953,425835797,16632452,426786,1,'2007-09-14 10:13:53',3310504189,1),(51121955,425837440,16634770,426786,1,'2007-09-14 10:13:53',3310504360,1),(51121956,425838136,16636744,426786,1,'2007-09-14 10:13:53',3310504360,1),(51121957,425838325,16638546,426786,1,'2007-09-14 10:13:53',3310504360,1),(51121958,425838136,16640606,426786,1,'2007-09-14 10:13:53',3310504360,1),(51121959,425836998,16643353,426786,1,'2007-09-14 10:13:53',3310504360,1),(51121960,425835292,16645155,426786,1,'2007-09-14 10:13:53',3310504191,1),(51121962,425832827,16646014,426786,1,'2007-09-14 10:13:53',3310504191,1),(51121964,425828782,16645584,426786,1,'2007-09-14 10:13:53',3310504191,1),(51121965,425823537,16644469,426786,1,'2007-09-14 10:13:53',3310504189,1),(51121967,425818481,16644297,426786,1,'2007-09-14 10:13:53',3310504189,1),(51121968,425814879,16644469,426786,1,'2007-09-14 10:13:53',3310504189,1),(51121970,425812667,16643954,426786,1,'2007-09-14 10:13:53',3310504189,1),(51121972,425808180,16642237,426786,1,'2007-09-14 10:13:53',3310504188,1),(51121973,425797689,16638031,426786,1,'2007-09-14 10:13:53',3310504188,1),(51121974,425793075,16637087,426786,1,'2007-09-14 10:13:53',3310504188,1),(51121976,425791242,16637001,426786,1,'2007-09-14 10:13:53',3310504188,1),(51121977,425789030,16636486,426786,1,'2007-09-14 10:13:53',3310504188,1),(51121979,425787766,16635628,426786,1,'2007-09-14 10:13:53',3310504188,1),(51121981,425786502,16633997,426786,1,'2007-09-14 10:13:53',3310504188,1),(51121982,425783096,16631673,495907,1,'2008-07-15 20:10:14',3310504188,2),(51121984,425780315,16630815,495907,1,'2008-07-15 20:10:14',3310504185,2),(51121985,425778103,16630987,495907,1,'2008-07-15 20:10:14',3310504185,2),(51121987,425776649,16631931,495907,1,'2008-07-15 20:10:14',3310504185,2),(51121988,425774816,16637510,495907,1,'2008-07-15 20:10:14',3310504185,2),(51121989,425774683,16642838,426786,1,'2007-09-14 10:13:53',3310504185,1),(51121991,425773110,16648925,495907,1,'2008-07-15 20:10:14',3310504187,2),(51121992,425772029,16653567,426786,1,'2007-09-14 10:13:53',3310504187,1),(51121993,425770891,16658974,426786,1,'2007-09-14 10:13:53',3310504187,1),(51121995,425769311,16664639,426786,1,'2007-09-14 10:13:53',3310504187,1),(51121997,425767921,16671248,426786,1,'2007-09-14 10:13:53',3310504187,1),(51121998,425767169,16677507,495907,1,'2008-07-15 20:17:56',3310504187,2),(51122000,425766979,16680254,495907,1,'2008-07-15 20:18:38',3310504187,3),(51122001,425765329,16685667,426786,1,'2007-09-14 10:13:53',3310504187,1),(51122003,425761790,16693221,426786,1,'2007-09-14 10:13:53',3310504187,1),(51122005,425759135,16700774,426786,1,'2007-09-14 10:13:53',3310504529,1),(51122006,425757176,16706953,426786,1,'2007-09-14 10:13:53',3310504529,1),(51122007,425754648,16715193,426786,1,'2007-09-14 10:13:53',3310504529,1),(51122009,425752632,16720251,495907,1,'2008-07-15 20:26:14',3310504528,2),(51122010,425750736,16724885,495907,1,'2008-07-15 20:26:14',3310504528,2),(51122012,425747576,16728834,495907,1,'2008-07-15 20:26:14',3310504528,2),(51122014,425744914,16731244,426786,1,'2007-09-14 10:13:53',3310504528,1),(51122015,425743777,16733818,426786,1,'2007-09-14 10:13:53',3310504528,1),(51122016,425742646,16737588,495907,1,'2008-07-15 20:26:14',3310504528,2),(51122018,425739359,16742996,495907,1,'2008-07-15 20:26:14',3310504528,2),(51122020,425734359,16746178,426786,1,'2007-09-14 10:13:53',3310504528,1),(51122022,425731205,16749090,495907,1,'2008-07-15 20:26:14',3310504528,2),(51122023,425727027,16753045,426786,1,'2007-09-14 10:13:53',3310504528,1),(51122025,425722476,16759224,426786,1,'2007-09-14 10:13:53',3310504519,1),(51122027,425719884,16763430,426786,1,'2007-09-14 10:13:53',3310504519,1),(51122028,425716408,16767464,426786,1,'2007-09-14 10:13:53',3310504519,1),(51122029,425712742,16770554,426786,1,'2007-09-14 10:13:53',3310504519,1),(51122030,425708444,16773386,426786,1,'2007-09-14 10:13:53',3310504519,1),(51122032,425705978,16775189,426786,1,'2007-09-14 10:13:53',3310504519,1),(51122033,425701491,16778965,426786,1,'2007-09-14 10:13:53',3310504519,1),(51122034,425697572,16781798,426786,1,'2007-09-14 10:13:53',3310504518,1),(51122036,425693589,16783257,426786,1,'2007-09-14 10:13:53',3310504518,1),(51122038,425685309,16785489,426786,1,'2007-09-14 10:13:53',3310504518,1),(51122039,425680568,16786089,426786,1,'2007-09-14 10:13:53',3310504518,1),(51122041,425675953,16786261,426786,1,'2007-09-14 10:13:53',3310504518,1),(51122042,425672350,16786433,426786,1,'2007-09-14 10:13:53',3310504518,1),(51122044,425670201,16787205,426786,1,'2007-09-14 10:13:53',3310504515,1),(51122045,425667040,16789179,426786,1,'2007-09-14 10:13:53',3310504515,1),(51122790,425796748,16433231,495907,1,'2008-07-15 19:51:34',3310504158,2),(51122791,425797127,16441128,495907,1,'2008-07-15 19:51:34',3310504158,2),(51122792,425798833,16452114,495907,1,'2008-07-15 19:52:43',3310504158,2),(51122793,425800350,16458637,495907,1,'2008-07-15 19:52:43',3310504158,2),(51122795,425801867,16463616,495907,1,'2008-07-15 19:52:43',3310504158,2),(51122796,425803889,16470825,495907,1,'2008-07-15 19:52:43',3310504158,2),(51122797,425804205,16474001,495907,1,'2008-07-15 19:52:43',3310504158,2),(51122798,425804016,16477949,495907,1,'2008-07-15 19:52:43',3310504158,2),(51122800,425801361,16483528,495907,1,'2008-07-15 19:52:43',3310504180,2),(51122801,425798264,16491339,495907,1,'2008-07-15 19:52:43',3310504180,2),(51122802,425796242,16495115,495907,1,'2008-07-15 19:52:43',3310504180,2),(51122803,425794409,16496660,495907,1,'2008-07-15 19:52:54',3310504180,2),(51122804,425791059,16498119,495907,1,'2008-07-15 19:53:29',3310504180,2),(51122805,425789045,16498969,443749,1,'2007-09-17 01:56:34',3310504180,1),(51122806,425787710,16500523,495907,1,'2008-07-15 19:53:29',3310504180,2),(51122807,425787204,16504900,495907,1,'2008-07-15 19:53:29',3310504180,2),(51122808,425786193,16510050,495907,1,'2008-07-15 19:53:29',3310504180,2),(51122809,425782963,16517697,426786,1,'2007-09-14 10:13:53',3310504180,1),(51122810,425781193,16522675,426786,1,'2007-09-14 10:13:53',3310504177,1),(51122811,425780814,16525851,426786,1,'2007-09-14 10:13:53',3310504177,1),(51122812,425780119,16530142,426786,1,'2007-09-14 10:13:53',3310504177,1),(51122814,425778602,16534691,426786,1,'2007-09-14 10:13:53',3310504179,1),(51122815,425776516,16543188,426786,1,'2007-09-14 10:13:53',3310504179,1),(51122816,425775631,16547738,426786,1,'2007-09-14 10:13:53',3310504179,1),(51122817,425776011,16554003,426786,1,'2007-09-14 10:13:53',3310504179,1),(51122819,425776516,16557951,426786,1,'2007-09-14 10:13:53',3310504179,1),(51122820,425777970,16562243,426786,1,'2007-09-14 10:13:53',3310504179,1),(51122821,425779803,16567049,426786,1,'2007-09-14 10:13:53',3310504179,1),(51122822,425782141,16570912,426786,1,'2007-09-14 10:13:53',3310504182,1),(51122823,425787829,16577950,426786,1,'2007-09-14 10:13:53',3310504182,1),(51122824,425794655,16589194,426786,1,'2007-09-14 10:13:53',3310504182,1),(51122825,425800722,16598034,426786,1,'2007-09-14 10:13:53',3310504188,1),(51122826,425805083,16604042,426786,1,'2007-09-14 10:13:53',3310504188,1),(51122827,425808306,16607819,426786,1,'2007-09-14 10:13:53',3310504188,1),(51122828,425815069,16615200,426786,1,'2007-09-14 10:13:53',3310504189,1),(51122829,425822842,16622496,426786,1,'2007-09-14 10:13:53',3310504189,1),(51122830,425827898,16626187,426786,1,'2007-09-14 10:13:53',3310504189,1),(51123230,425784676,16355040,495907,1,'2008-07-15 19:50:23',3310504150,2),(51123231,425785435,16358130,495907,1,'2008-07-15 19:50:23',3310504150,2),(51123232,425787836,16367142,495907,1,'2008-07-15 19:50:23',3310504150,2),(51123233,425789100,16371433,495907,1,'2008-07-15 19:50:23',3310504156,2),(51123235,425788595,16383707,495907,1,'2008-07-15 19:50:23',3310504156,2),(51123236,425788974,16392548,495907,1,'2008-07-15 19:50:23',3310504156,2),(51123237,425792324,16398384,495907,1,'2008-07-15 19:50:57',3310504156,2),(51123238,425799149,16408941,495907,1,'2008-07-15 19:50:57',3310504156,2),(51123262,425782654,16338217,495907,1,'2008-07-15 19:49:01',3310504150,2),(51123907,425757309,16225006,495907,1,'2008-07-15 19:48:35',3310504059,2),(51123908,425758953,16227924,495907,1,'2008-07-15 19:48:35',3310504059,2),(51123909,425760090,16232302,495907,1,'2008-07-15 19:48:35',3310504059,2),(51123910,425762555,16236937,495907,1,'2008-07-15 19:48:35',3310504059,2),(51123911,425764135,16242172,495907,1,'2008-07-15 19:48:35',3310504059,2),(51123912,425766853,16249897,495907,1,'2008-07-15 19:48:35',3310504059,2),(51123913,425769192,16253760,495907,1,'2008-07-15 19:48:35',3310504059,2),(51123914,425773237,16257107,495907,1,'2008-07-15 19:48:35',3310504059,2),(51123916,425777218,16260540,495907,1,'2008-07-15 19:48:35',3310504145,2),(51123917,425778735,16262943,495907,1,'2008-07-15 19:48:35',3310504145,2),(51123918,425779241,16266205,495907,1,'2008-07-15 19:48:35',3310504145,2),(51123919,425778293,16279680,495907,1,'2008-07-15 19:48:35',3310504145,2),(51123920,425777850,16283972,495907,1,'2008-07-15 19:48:35',3310504145,2),(51123921,425778230,16287233,495907,1,'2008-07-15 19:48:35',3310504145,2),(51123922,425782401,16296847,495907,1,'2008-07-15 19:48:35',3310504148,2),(51123924,425785940,16304743,495907,1,'2008-07-15 19:48:35',3310504148,2),(51123925,425786762,16307232,495907,1,'2008-07-15 19:48:35',3310504148,2),(51123926,425786762,16311609,495907,1,'2008-07-15 19:48:35',3310504148,2),(51124044,425742519,16192305,495907,1,'2008-07-15 19:46:04',3310504056,2),(51124045,425744036,16197540,495907,1,'2008-07-15 19:46:04',3310504056,2),(51124046,425747576,16211788,495907,1,'2008-07-15 19:46:04',3310504058,2),(51124047,425748903,16215136,495907,1,'2008-07-15 19:46:04',3310504058,2),(51124048,425752000,16219084,495907,1,'2008-07-15 19:46:04',3310504058,2),(51124483,425719948,16120301,426786,1,'2007-09-14 10:07:07',3310504039,1),(51124484,425720390,16123734,426786,1,'2007-09-14 10:13:42',3310504039,1),(51124485,425720643,16132574,426786,1,'2007-09-14 10:13:42',3310504039,1),(51124486,425730566,16170683,426786,1,'2007-09-14 10:13:43',3310504056,1),(51124487,425732083,16175833,426786,1,'2007-09-14 10:13:43',3310504056,1),(51124488,425734548,16180983,426786,1,'2007-09-14 10:13:43',3310504056,1),(51124489,425737273,16183807,495907,1,'2008-07-15 19:46:04',3310504056,2),(51124490,425741066,16189129,495907,1,'2008-07-15 19:46:04',3310504056,2),(51124700,425722448,16140895,427965,1,'2007-09-14 19:08:20',3310504039,1),(51124890,425714168,16086307,427965,1,'2007-09-14 19:10:11',3310504037,1),(51124891,425714954,16089058,426786,1,'2007-09-14 10:13:42',3310504037,1),(51124892,425714891,16099959,426786,1,'2007-09-14 10:13:42',3310504039,1),(51124893,425714701,16104508,426786,1,'2007-09-14 10:13:42',3310504039,1),(51124895,425714891,16108284,426786,1,'2007-09-14 10:13:42',3310504039,1),(51124975,425712461,16083560,427965,1,'2007-09-14 19:10:11',3310504037,1),(51125152,425686067,16041508,426786,1,'2007-09-14 10:13:32',3310504036,1),(51125154,425687367,16043821,427965,1,'2007-09-14 19:10:38',3310504036,1),(51125155,425689074,16045280,427965,1,'2007-09-14 19:10:38',3310504036,1),(51125157,425690275,16045795,427965,1,'2007-09-14 19:10:38',3310504036,1),(51125159,425706204,16056781,427965,1,'2007-09-14 19:10:15',3310504037,1),(51125330,425673582,16014218,4963967,1,'2010-06-11 20:09:43',3310504014,2),(51125332,425673300,16012680,4963967,1,'2010-06-11 20:09:44',3310504014,2),(51125333,425672568,16012572,4963967,1,'2010-06-11 20:09:44',3310504014,2),(51125335,425672111,16013104,4963967,1,'2010-06-11 20:09:44',3310504014,2),(51125337,425672022,16013842,4963967,1,'2010-06-11 20:09:44',3310504014,2),(51125340,425672157,16014294,4963967,1,'2010-06-11 20:09:44',3310504014,2),(51125342,425672441,16014646,4963967,1,'2010-06-11 20:09:44',3310504014,2),(51125344,425673377,16014542,4963967,1,'2010-06-11 20:09:43',3310504014,2),(51125414,425672344,16012736,4963967,1,'2010-06-11 20:09:44',3310504014,2),(51125478,425667491,16001936,4963967,1,'2010-06-11 20:09:47',3310504011,3),(51125724,425640237,15923319,426786,1,'2007-09-14 10:13:29',3310504002,1),(51125727,425643461,15930357,426786,1,'2007-09-14 10:13:29',3310504002,1),(51125728,425644662,15932074,426786,1,'2007-09-14 10:13:29',3310504009,1),(51125730,425646369,15932675,426786,1,'2007-09-14 10:13:29',3310504009,1),(51125731,425648680,15933013,427965,1,'2007-09-14 19:12:39',3310504009,1),(51125733,425662145,15945630,427965,1,'2007-09-14 19:12:11',3310504009,1),(51125734,425662714,15949922,427965,1,'2007-09-14 19:12:11',3310504009,1),(51125737,425660023,15962286,426786,1,'2007-09-14 10:13:29',3310504009,1),(51125738,425657116,15971814,426786,1,'2007-09-14 10:13:29',3310504009,1),(51125784,425640237,15914994,426786,1,'2007-09-14 10:13:29',3310504002,1),(51125788,425639858,15920830,426786,1,'2007-09-14 10:13:29',3310504002,1),(51125904,425634611,15908900,426786,1,'2007-09-14 10:13:29',3310504002,1),(51125905,425637139,15909501,426786,1,'2007-09-14 10:13:29',3310504002,1),(51126211,425538008,15886498,426786,1,'2007-09-14 10:13:24',3310503955,1),(51126212,425542308,15885640,426786,1,'2007-09-14 10:13:24',3310503955,1),(51126213,425558654,15885844,427965,1,'2007-09-14 19:46:49',3310503955,1),(51126214,425561499,15886703,427965,1,'2007-09-14 19:46:49',3310503955,1),(51126215,425565511,15886326,426786,1,'2007-09-14 10:13:24',3310503958,1),(51126216,425570632,15885897,426786,1,'2007-09-14 10:13:24',3310503958,1),(51126217,425581886,15888987,426786,1,'2007-09-14 10:13:24',3310503958,1),(51126218,425610180,15902238,427965,1,'2007-09-14 19:46:49',3310503959,1),(51126219,425614697,15902377,426786,1,'2007-09-14 10:13:24',3310503959,1),(51126221,425624117,15903836,426786,1,'2007-09-14 10:13:24',3310504002,1),(51126223,425627151,15904265,426786,1,'2007-09-14 10:13:24',3310504002,1),(51126225,425631007,15906926,426786,1,'2007-09-14 10:13:24',3310504002,1),(51126226,425632967,15908213,426786,1,'2007-09-14 10:13:24',3310504002,1),(51342421,425512942,16950536,427965,1,'2007-09-14 18:53:33',3310504496,1),(51342422,425504912,16959033,427965,1,'2007-09-14 18:58:59',3310504485,1),(51342559,425516167,16953283,427965,1,'2007-09-14 18:53:55',3310504496,1),(51342838,425522057,16951184,4963942,1,'2010-06-11 20:05:26',3310504496,2),(51342839,425521906,16948762,4963942,1,'2010-06-11 20:05:26',3310504496,2),(51342840,425520694,16946985,4963942,1,'2010-06-11 20:05:26',3310504496,2),(51342841,425519615,16946553,4963942,1,'2010-06-11 20:05:26',3310504496,2),(51342842,425518210,16946903,4963942,1,'2010-06-11 20:05:26',3310504496,2),(51342843,425516971,16948509,4963942,1,'2010-06-11 20:05:27',3310504496,2),(51342844,425516703,16951028,4963942,1,'2010-06-11 20:05:27',3310504496,2),(51342845,425517700,16953208,4963942,1,'2010-06-11 20:05:27',3310504496,2),(51342846,425519270,16953996,4963942,1,'2010-06-11 20:05:27',3310504496,2),(51342847,425520545,16953656,4963942,1,'2010-06-11 20:05:27',3310504496,2),(51342848,425521420,16952788,4963942,1,'2010-06-11 20:05:27',3310504496,2),(51342855,425517120,16952366,4963942,1,'2010-06-11 20:05:27',3310504496,2),(51342907,425519897,16944699,427965,1,'2007-09-14 18:53:33',3310504496,1),(51342909,425517179,16946674,427965,1,'2007-09-14 18:53:33',3310504496,1),(51342910,425514586,16949163,427965,1,'2007-09-14 18:53:33',3310504496,1),(51343029,425510366,16955036,4963942,1,'2010-06-11 20:05:25',3310504496,2),(51343031,425516645,16950279,4963942,1,'2010-06-11 20:05:25',3310504496,2),(51343103,425497577,16963582,427965,1,'2007-09-14 18:58:59',3310504485,1),(51344677,425475762,16980233,5107412,1,'2010-06-29 20:12:26',3310504486,2),(51344678,425460270,16997400,427965,1,'2007-09-14 19:00:20',3310504486,1),(51344679,425451733,17014651,427965,1,'2007-09-14 19:00:20',3310504483,1),(51344681,425444461,17058854,427965,1,'2007-09-14 19:00:20',3310504489,1),(51344682,425440667,17115932,427965,1,'2007-09-14 19:00:20',3310504491,1),(51344683,425439719,17156701,427965,1,'2007-09-14 19:00:20',3310504577,1),(51344685,425437505,17221933,427965,1,'2007-09-14 19:00:20',3310504579,1),(51344687,425438770,17256265,427965,1,'2007-09-14 19:00:20',3310504585,1),(51344688,425443829,17281585,427965,1,'2007-09-14 19:00:20',3310504585,1),(51344690,425456160,17311197,427965,1,'2007-09-14 19:00:20',3310504590,1),(51345073,425484931,16973195,427965,1,'2007-09-14 18:58:59',3310504485,1),(51347750,425703738,16051459,427965,1,'2007-09-14 19:10:15',3310504037,1),(51347752,425707025,16059785,427965,1,'2007-09-14 19:10:15',3310504037,1),(51347925,425702032,16049657,427965,1,'2007-09-14 19:10:15',3310504037,1),(51347926,425704813,16053348,427965,1,'2007-09-14 19:10:15',3310504037,1),(51348096,425739675,16186726,495907,1,'2008-07-15 19:46:04',3310504056,2),(51348165,425715495,16093002,427965,1,'2007-09-14 19:08:20',3310504037,1),(51348167,425715306,16097636,427965,1,'2007-09-14 19:08:20',3310504039,1),(51348517,425682563,16031118,427965,1,'2007-09-14 19:10:38',3310504014,1),(51348571,425721437,16137376,427965,1,'2007-09-14 19:08:20',3310504039,1),(51349842,425679655,16025024,427965,1,'2007-09-14 19:10:49',3310504014,1),(51350384,425657214,15974212,427965,1,'2007-09-14 19:12:11',3310504009,1),(51350385,425657151,15972924,427965,1,'2007-09-14 19:12:11',3310504009,1),(51350585,425662588,15947776,427965,1,'2007-09-14 19:12:11',3310504009,1),(51350698,425650640,15932927,427965,1,'2007-09-14 19:12:39',3310504009,1),(51350699,425652220,15933013,427965,1,'2007-09-14 19:12:39',3310504009,1),(51350700,425654180,15933442,427965,1,'2007-09-14 19:12:39',3310504009,1),(51350702,425655255,15934816,427965,1,'2007-09-14 19:12:28',3310504009,1),(51356383,424673865,14916718,508959,1,'2007-09-24 18:39:54',3310490811,1),(51356432,424524124,14849968,508959,1,'2007-09-24 18:39:54',3310490792,1),(51356433,424544964,14856697,508959,1,'2007-09-24 18:39:54',3310490792,1),(51356434,424548481,14856540,508959,1,'2007-09-24 18:39:54',3310490793,1),(51356435,424554163,14857905,508959,1,'2007-09-24 18:39:54',3310490793,1),(51356437,424563243,14860483,508959,1,'2007-09-24 18:39:54',3310490793,1),(51356438,424569706,14862543,434787,1,'2007-09-15 15:28:04',3310490793,1),(51356439,424574414,14863644,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356440,424578231,14863922,434787,1,'2007-09-15 15:28:04',3310490796,1),(51356442,424581638,14865079,434787,1,'2007-09-15 15:28:05',3310490796,1),(51356444,424585586,14868300,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356445,424587163,14870744,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356446,424588461,14872583,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356448,424590557,14874947,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356450,424592691,14875430,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356451,424594856,14875918,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356452,424596617,14876982,434787,1,'2007-09-15 15:28:07',3310490796,1),(51356454,424598915,14879348,434787,1,'2007-09-15 15:28:07',3310490796,1),(51356455,424601853,14883173,508959,1,'2007-09-24 18:39:54',3310490797,1),(51356457,424605273,14888784,508959,1,'2007-09-24 18:39:54',3310490799,1),(51356458,424607729,14892410,508959,1,'2007-09-24 18:39:54',3310490799,1),(51356460,424609389,14893912,434787,1,'2007-09-15 15:28:08',3310490799,1),(51356461,424612485,14896909,508959,1,'2007-09-24 18:39:54',3310490799,1),(51356462,424616981,14899987,434787,1,'2007-09-15 15:28:08',3310490799,1),(51356465,424621510,14900345,508959,1,'2007-09-24 18:39:54',3310490799,1),(51356466,424625060,14899441,508959,1,'2007-09-24 18:39:54',3310490799,1),(51356468,424634374,14896704,434787,1,'2007-09-15 15:10:21',3310490810,1),(51356469,424644835,14894490,508959,1,'2007-09-24 18:39:54',3310490810,1),(51356470,424648539,14894406,508959,1,'2007-09-24 18:39:54',3310490810,1),(51356471,424650615,14895452,508959,1,'2007-09-24 18:39:54',3310490810,1),(51356472,424653290,14897426,508959,1,'2007-09-24 18:39:54',3310490810,1),(51356473,424655245,14899686,508959,1,'2007-09-24 18:39:54',3310490810,1),(51356474,424657603,14899123,434787,1,'2007-09-15 15:10:22',3310490811,1),(51356475,424660066,14901118,434787,1,'2007-09-15 15:10:22',3310490811,1),(51356476,424662594,14903157,508959,1,'2007-09-24 18:39:54',3310490811,1),(51356477,424663789,14904882,508959,1,'2007-09-24 18:39:54',3310490811,1),(51356478,424664468,14908098,508959,1,'2007-09-24 18:39:54',3310490811,1),(51356479,424666182,14911657,508959,1,'2007-09-24 18:39:54',3310490811,1),(51356480,424667621,14914564,434787,1,'2007-09-15 15:10:12',3310490811,1),(51356481,424670475,14916739,434787,1,'2007-09-15 15:10:12',3310490811,1),(51356964,424522992,14851025,508959,1,'2007-09-24 18:39:54',3310490792,1),(51356965,424546433,14858880,508959,1,'2007-09-24 18:39:54',3310490793,1),(51356967,424550739,14859567,508959,1,'2007-09-24 18:39:54',3310490793,1),(51356968,424559288,14862742,508959,1,'2007-09-24 18:39:54',3310490793,1),(51356969,424568407,14864974,508959,1,'2007-09-24 18:39:54',3310490793,1),(51356970,424571573,14866347,508959,1,'2007-09-24 18:39:54',3310490793,1),(51356972,424575499,14866347,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356973,424577842,14866347,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356974,424579362,14866691,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356975,424581452,14867377,427965,1,'2007-09-14 19:33:57',3310490796,1),(51356977,424584618,14870296,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356978,424586264,14872012,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356979,424588670,14875531,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356981,424590887,14877076,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356982,424593103,14877334,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356983,424595129,14878364,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356985,424597536,14880767,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356986,424599499,14883342,508959,1,'2007-09-24 18:39:54',3310490796,1),(51356987,424602665,14888492,427965,1,'2007-09-14 19:33:57',3310490799,1),(51356988,424605261,14892268,508959,1,'2007-09-24 18:39:54',3310490799,1),(51356991,424607477,14895015,508959,1,'2007-09-24 18:39:54',3310490799,1),(51356992,424609883,14897590,508959,1,'2007-09-24 18:39:54',3310490799,1),(51356994,424612479,14899907,508959,1,'2007-09-24 18:39:54',3310490799,1),(51356995,424615075,14901795,508959,1,'2007-09-24 18:39:54',3310490799,1),(51356997,424617228,14902997,508959,1,'2007-09-24 18:39:54',3310490799,1),(51356998,424620648,14903083,508959,1,'2007-09-24 18:39:54',3310490799,1),(51356999,424624510,14901967,427965,1,'2007-09-14 19:33:57',3310490799,1),(51357000,424638630,14897933,508959,1,'2007-09-24 18:39:54',3310490810,1),(51357002,424644582,14896731,508959,1,'2007-09-24 18:39:54',3310490810,1),(51357003,424647368,14896302,508959,1,'2007-09-24 18:39:54',3310490810,1),(51357004,424649077,14896302,508959,1,'2007-09-24 18:39:54',3310490810,1),(51357006,424650534,14897246,427965,1,'2007-09-14 19:33:57',3310490810,1),(51357007,424653256,14900165,508959,1,'2007-09-24 18:39:54',3310490810,1),(51357008,424654459,14901452,508959,1,'2007-09-24 18:39:54',3310490810,1),(51357009,424658448,14903255,508959,1,'2007-09-24 18:39:54',3310490811,1),(51357010,424661867,14905229,508959,1,'2007-09-24 18:39:54',3310490811,1),(51357011,424663133,14907374,508959,1,'2007-09-24 18:39:54',3310490811,1),(51357012,424663640,14909434,508959,1,'2007-09-24 18:39:54',3310490811,1),(51357013,424662754,14910636,427965,1,'2007-09-14 19:33:57',3310490811,1),(51357015,424663830,14912181,427965,1,'2007-09-14 19:33:57',3310490811,1),(51357016,424665223,14914670,508959,1,'2007-09-24 18:39:54',3310490811,1),(51357018,424666362,14916902,427965,1,'2007-09-14 19:33:57',3310490811,1),(51357019,424669718,14918447,508959,1,'2007-09-24 18:39:54',3310490811,1),(51357255,424672757,14918876,427965,1,'2007-09-14 19:33:57',3310490811,1),(51357256,424675416,14918876,508959,1,'2007-09-24 18:39:54',3310490811,1),(51357259,424677632,14918447,508959,1,'2007-09-24 18:39:54',3310490811,1),(51357260,424680735,14919477,508959,1,'2007-09-24 18:39:54',3310490811,1),(51357261,424683457,14920764,508959,1,'2007-09-24 18:39:54',3310490814,1),(51357264,424687066,14921880,508959,1,'2007-09-24 18:39:54',3310490814,1),(51357265,424692954,14923940,508959,1,'2007-09-24 18:39:54',3310490814,1),(51357268,424696943,14925399,508959,1,'2007-09-24 18:39:54',3310490814,1),(51357269,424699665,14927115,508959,1,'2007-09-24 18:39:54',3310490814,1),(51357270,424700425,14928060,508959,1,'2007-09-24 18:39:54',3310490814,1),(51357272,424702831,14929519,427965,1,'2007-09-14 19:33:57',3310490814,1),(51357274,424705300,14930034,508959,1,'2007-09-24 18:39:54',3310490814,1),(51357275,424706946,14929776,508959,1,'2007-09-24 18:39:54',3310490814,1),(51357276,424708529,14929090,427965,1,'2007-09-14 19:33:57',3310490814,1),(51357277,424711251,14926772,508959,1,'2007-09-24 18:39:54',3310490815,1),(51357279,424713657,14925742,508959,1,'2007-09-24 18:39:54',3310490815,1),(51357281,424715430,14925914,427965,1,'2007-09-14 19:33:57',3310490815,1);
INSERT INTO `current_nodes` VALUES (51357282,424717772,14926858,508959,1,'2007-09-24 18:39:54',3310490815,1),(51357285,424721634,14929090,427965,1,'2007-09-14 19:33:57',3310490815,1),(51357287,424725369,14931836,508959,1,'2007-09-24 18:39:54',3310490815,1),(51357288,424727522,14932780,508959,1,'2007-09-24 18:39:54',3310490815,1),(51357291,424729674,14932523,508959,1,'2007-09-24 18:39:54',3310490815,1),(51357292,424731573,14930463,508959,1,'2007-09-24 18:39:54',3310490815,1),(51357293,424733852,14926000,427965,1,'2007-09-14 19:33:57',3310490815,1),(51357295,424735878,14919648,427965,1,'2007-09-14 19:33:57',3310490815,1),(51357297,424736575,14916816,427965,1,'2007-09-14 19:33:57',3310490815,1),(51357298,424737777,14912868,508959,1,'2007-09-24 18:39:54',3310490815,1),(51357300,424739170,14910378,427965,1,'2007-09-14 19:33:08',3310490858,1),(51357303,424742209,14907804,508959,1,'2007-09-24 18:39:54',3310490858,1),(51357305,424745817,14906173,508959,1,'2007-09-24 18:39:54',3310490858,1),(51357308,424748920,14906173,508959,1,'2007-09-24 18:39:54',3310490858,1),(51357309,424751578,14906859,427965,1,'2007-09-14 19:33:57',3310490858,1),(51357310,424753731,14906516,427965,1,'2007-09-14 19:33:57',3310490858,1),(51357312,424756516,14905229,508959,1,'2007-09-24 18:39:54',3310490858,1),(51357313,424759808,14904885,508959,1,'2007-09-24 18:39:54',3310490858,1),(51357315,424763480,14905143,508959,1,'2007-09-24 18:39:54',3310490858,1),(51357317,424766582,14905143,508959,1,'2007-09-24 18:39:54',3310490859,1),(51357319,424771646,14904370,427965,1,'2007-09-14 19:33:57',3310490859,1),(51357320,424775571,14902997,508959,1,'2007-09-24 18:39:54',3310490859,1),(51357323,424778926,14900508,508959,1,'2007-09-24 18:39:54',3310490859,1),(51357326,424784750,14894500,427965,1,'2007-09-14 19:33:57',3310490859,1),(51357328,424788358,14891410,508959,1,'2007-09-24 18:39:54',3310490859,1),(51357329,424792979,14888663,508959,1,'2007-09-24 18:39:54',3310490862,1),(51357330,424796714,14887633,508959,1,'2007-09-24 18:39:54',3310490862,1),(51357332,424800892,14887118,508959,1,'2007-09-24 18:39:54',3310490862,1),(51357335,424805006,14889007,508959,1,'2007-09-24 18:39:54',3310490862,1),(51357538,424807222,14890294,427965,1,'2007-09-14 19:33:57',3310490862,1),(51357539,424810260,14890466,508959,1,'2007-09-24 18:39:54',3310490862,1),(51357540,424814248,14889865,508959,1,'2007-09-24 18:39:54',3310490862,1),(51357542,424819059,14890208,508959,1,'2007-09-24 18:39:54',3310490862,1),(51357543,424823427,14892268,508959,1,'2007-09-24 18:39:54',3310490863,1),(51357544,424827225,14896045,508959,1,'2007-09-24 18:39:54',3310490863,1),(51357546,424833365,14902225,427965,1,'2007-09-14 19:33:57',3310490863,1),(51357547,424836086,14905314,508959,1,'2007-09-24 18:39:54',3310490863,1),(51357549,424838492,14910121,427965,1,'2007-09-14 19:33:57',3310490863,1),(51357550,424840264,14918962,508959,1,'2007-09-24 18:39:54',3310490863,1),(51357551,424843745,14925742,508959,1,'2007-09-24 18:39:54',3310490863,1),(51357552,424847733,14931235,508959,1,'2007-09-24 18:39:54',3310490863,1),(51357554,424852164,14938445,508959,1,'2007-09-24 18:39:54',3310490874,1),(51357556,424856911,14944539,508959,1,'2007-09-24 18:39:54',3310491216,1),(51357557,424861848,14949002,508959,1,'2007-09-24 18:39:54',3310491216,1),(51357558,424866912,14951491,508959,1,'2007-09-24 18:39:54',3310491216,1),(51357560,424870899,14951577,427965,1,'2007-09-14 19:33:57',3310491216,1),(51357561,424875456,14950633,508959,1,'2007-09-24 18:39:54',3310491217,1),(51357562,424879823,14949775,508959,1,'2007-09-24 18:39:54',3310491217,1),(51357564,424884444,14950461,427965,1,'2007-09-14 19:33:57',3310491217,1),(51357566,424887798,14952435,508959,1,'2007-09-24 18:39:54',3310491217,1),(51357567,424890796,14953824,592895,1,'2008-07-25 22:11:36',3310491217,2),(51357568,424894277,14956571,592895,1,'2008-07-25 22:11:36',3310491217,2),(51357570,424897735,14959044,508959,1,'2007-09-24 18:39:54',3310491217,1),(51357571,424899824,14958444,427965,1,'2007-09-14 19:33:57',3310491217,1),(51357573,424904191,14956813,508959,1,'2007-09-24 18:39:54',3310491220,1),(51357949,425040631,15202975,508959,1,'2007-09-24 18:39:54',3310491429,1),(51357951,425037783,15195079,427965,1,'2007-09-14 19:42:25',3310491428,1),(51357953,425037530,15191216,508959,1,'2007-09-24 18:39:54',3310491428,1),(51357954,425037595,15187055,508959,1,'2007-09-24 18:39:54',3310491428,1),(51357955,425038226,15177140,508959,1,'2007-09-24 18:39:54',3310491428,1),(51357956,425038543,15172420,508959,1,'2007-09-24 18:39:54',3310491428,1),(51357958,425038290,15167184,427965,1,'2007-09-14 19:42:25',3310491428,1),(51357959,425036897,15162206,508959,1,'2007-09-24 18:39:54',3310491428,1),(51357960,425034366,15158343,508959,1,'2007-09-24 18:39:54',3310491406,1),(51357962,425029178,15151305,508959,1,'2007-09-24 18:39:54',3310491406,1),(51357963,425026330,15146327,508959,1,'2007-09-24 18:39:54',3310491406,1),(51357965,425024052,15139718,508959,1,'2007-09-24 18:39:54',3310491406,1),(51357966,425022090,15136285,508959,1,'2007-09-24 18:39:54',3310491406,1),(51357967,425019053,15133109,427965,1,'2007-09-14 19:42:25',3310491406,1),(51357969,425016585,15130963,508959,1,'2007-09-24 18:39:54',3310491406,1),(51357971,425014244,15130105,508959,1,'2007-09-24 18:39:54',3310491406,1),(51357972,425011396,15127788,508959,1,'2007-09-24 18:39:54',3310491403,1),(51357973,425008738,15125213,427965,1,'2007-09-14 19:42:25',3310491403,1),(51357975,425003992,15122552,427965,1,'2007-09-14 19:42:25',3310491403,1),(51357977,424991716,15113196,427965,1,'2007-09-14 19:42:25',3310491403,1),(51357978,424986843,15109420,508959,1,'2007-09-24 18:39:54',3310491403,1),(51357980,424981148,15103755,508959,1,'2007-09-24 18:39:54',3310491400,1),(51357981,424977559,15096896,508959,1,'2007-09-24 18:39:54',3310491400,1),(51357983,424974056,15089381,508959,1,'2007-09-24 18:39:54',3310491400,1),(51357984,424970640,15082383,508959,1,'2007-09-24 18:39:54',3310491400,1),(51357986,424965473,15069081,434787,1,'2007-09-15 15:11:10',3310491400,1),(51357988,424961783,15058780,427965,1,'2007-09-14 19:42:25',3310491400,1),(51357989,424958659,15050069,508959,1,'2007-09-24 18:39:54',3310491394,1),(51357991,424955028,15043304,508959,1,'2007-09-24 18:39:54',3310491223,1),(51357993,424952670,15038524,508959,1,'2007-09-24 18:39:54',3310491223,1),(51357994,424952227,15035090,427965,1,'2007-09-14 19:42:25',3310491223,1),(51357995,424949948,15029855,508959,1,'2007-09-24 18:39:54',3310491223,1),(51357997,424947500,15024621,434787,1,'2007-09-15 15:11:11',3310491223,1),(51358000,424945075,15019898,508959,1,'2007-09-24 18:39:54',3310491223,1),(51358001,424941468,15011315,508959,1,'2007-09-24 18:39:54',3310491223,1),(51358002,424935582,15000587,508959,1,'2007-09-24 18:39:54',3310491223,1),(51358003,424928937,14992175,427965,1,'2007-09-14 19:42:25',3310491220,1),(51358004,424927798,14989257,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358005,424926722,14982734,427965,1,'2007-09-14 19:42:25',3310491220,1),(51358007,424926089,14976726,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358008,424924823,14973979,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358009,424922925,14972262,427965,1,'2007-09-14 19:42:25',3310491220,1),(51358011,424920140,14970717,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358013,424918115,14969859,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358015,424915773,14967971,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358016,424913431,14965053,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358018,424911912,14962392,427965,1,'2007-09-14 19:42:25',3310491220,1),(51358019,424910520,14959645,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358021,424909444,14958186,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358023,424907672,14957070,427965,1,'2007-09-14 19:42:25',3310491220,1),(51358025,424905836,14956641,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358396,425095390,15316725,437032,1,'2008-05-13 20:45:03',3310491449,2),(51358398,425091060,15305629,427965,1,'2007-09-14 19:42:25',3310491448,1),(51358399,425087581,15296273,427965,1,'2007-09-14 19:42:25',3310491448,1),(51358401,425086315,15292239,427965,1,'2007-09-14 19:42:25',3310491448,1),(51358402,425083847,15287261,508959,1,'2007-09-24 18:39:54',3310491448,1),(51358404,425081696,15284858,427965,1,'2007-09-14 19:42:25',3310491448,1),(51358405,425077586,15281470,434787,1,'2007-09-15 15:11:02',3310491448,1),(51358407,425070560,15276875,508959,1,'2007-09-24 18:39:54',3310491448,1),(51358408,425067460,15274301,508959,1,'2007-09-24 18:39:54',3310491437,1),(51358409,425066381,15271609,508959,1,'2007-09-24 18:39:54',3310491437,1),(51358411,425065941,15266576,508959,1,'2007-09-24 18:39:54',3310491431,1),(51358412,425065435,15261769,508959,1,'2007-09-24 18:39:54',3310491431,1),(51358414,425064486,15257907,508959,1,'2007-09-24 18:39:54',3310491431,1),(51358415,425063410,15254989,508959,1,'2007-09-24 18:39:54',3310491431,1),(51358417,425061638,15251727,427965,1,'2007-09-14 19:42:25',3310491431,1),(51358418,425059360,15249066,508959,1,'2007-09-24 18:39:54',3310491431,1),(51358419,425055501,15245290,508959,1,'2007-09-24 18:39:54',3310491431,1),(51358421,425051008,15240483,427965,1,'2007-09-14 19:42:25',3310491431,1),(51358423,425048793,15235333,427965,1,'2007-09-14 19:42:25',3310491431,1),(51358424,425047908,15230699,508959,1,'2007-09-24 18:39:54',3310491431,1),(51358425,425047022,15224519,508959,1,'2007-09-24 18:39:54',3310491431,1),(51358427,425046073,15217738,508959,1,'2007-09-24 18:39:54',3310491431,1),(51358428,425044576,15212201,434787,1,'2007-09-15 15:11:01',3310491429,1),(51358430,425042361,15206750,508959,1,'2007-09-24 18:39:54',3310491429,1),(51358786,424807359,14888329,508959,1,'2007-09-24 18:39:54',3310490862,1),(51358788,424810508,14888600,508959,1,'2007-09-24 18:39:54',3310490862,1),(51358789,424815115,14888495,508959,1,'2007-09-24 18:39:54',3310490862,1),(51358791,424820097,14889010,508959,1,'2007-09-24 18:39:54',3310490862,1),(51358792,424823126,14889979,434787,1,'2007-09-15 15:24:45',3310490863,1),(51358793,424826326,14892939,508959,1,'2007-09-24 18:39:54',3310490863,1),(51358794,424831694,14898426,508959,1,'2007-09-24 18:39:54',3310490863,1),(51358795,424835326,14901681,508959,1,'2007-09-24 18:39:54',3310490863,1),(51358797,424836907,14903618,434787,1,'2007-09-15 15:24:46',3310490863,1),(51358798,424838997,14907748,508959,1,'2007-09-24 18:39:54',3310490863,1),(51358800,424840307,14912216,434787,1,'2007-09-15 15:24:44',3310490863,1),(51358802,424841001,14916503,508959,1,'2007-09-24 18:39:54',3310490863,1),(51358803,424846760,14926540,508959,1,'2007-09-24 18:39:54',3310490863,1),(51358805,424851922,14934265,508959,1,'2007-09-24 18:39:54',3310490874,1),(51358806,424855121,14939196,508959,1,'2007-09-24 18:39:54',3310490874,1),(51358807,424858573,14943404,434787,1,'2007-09-15 15:24:45',3310491216,1),(51358809,424863437,14947382,508959,1,'2007-09-24 18:39:54',3310491216,1),(51358810,424867813,14949008,508959,1,'2007-09-24 18:39:54',3310491216,1),(51358811,424869754,14949399,508959,1,'2007-09-24 18:39:54',3310491216,1),(51358812,424875416,14949103,592895,1,'2008-07-25 22:29:55',3310491217,2),(51358813,424882315,14947987,592895,1,'2008-07-25 22:29:55',3310491217,2),(51358814,424885086,14947941,508959,1,'2007-09-24 18:39:54',3310491217,1),(51358815,424888109,14949771,508959,1,'2007-09-24 18:39:54',3310491217,1),(51358816,424892315,14952022,592895,1,'2008-07-25 22:11:36',3310491217,2),(51358818,424895416,14954682,592895,1,'2008-07-25 22:11:36',3310491217,2),(51358819,424898391,14956934,434787,1,'2007-09-15 15:24:42',3310491217,1),(51358820,424901548,14956557,508959,1,'2007-09-24 18:39:54',3310491217,1),(51358821,424904263,14955461,434787,1,'2007-09-15 15:24:42',3310491220,1),(51358823,424906583,14955100,434787,1,'2007-09-15 15:24:43',3310491220,1),(51358824,424909431,14955789,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358825,424912723,14959810,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358827,424914584,14963628,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358829,424916278,14965868,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358832,424918892,14967734,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358837,424920598,14968740,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358838,424922170,14968484,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358839,424925585,14971653,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358840,424927075,14974234,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358841,424928335,14983737,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358842,424929808,14989502,508959,1,'2007-09-24 18:39:54',3310491220,1),(51358843,424932360,14993695,434787,1,'2007-09-15 15:10:44',3310491221,1),(51358845,424935674,14997822,434787,1,'2007-09-15 15:10:44',3310491223,1),(51358847,424938099,15000654,508959,1,'2007-09-24 18:39:54',3310491223,1),(51358848,424940420,15004955,508959,1,'2007-09-24 18:39:54',3310491223,1),(51358849,424946769,15019369,434787,1,'2007-09-15 15:10:58',3310491223,1),(51358850,424953012,15032635,508959,1,'2007-09-24 18:39:54',3310491223,1),(51358851,424956723,15042711,508959,1,'2007-09-24 18:39:54',3310491223,1),(51358852,424960666,15048850,508959,1,'2007-09-24 18:39:54',3310491394,1),(51358853,424962230,15054326,508959,1,'2007-09-24 18:39:54',3310491400,1),(51358854,424966025,15064085,508959,1,'2007-09-24 18:39:54',3310491400,1),(51358856,424968725,15071603,508959,1,'2007-09-24 18:39:54',3310491400,1),(51358858,424973284,15083525,508959,1,'2007-09-24 18:39:54',3310491400,1),(51358859,424982739,15101487,434787,1,'2007-09-15 15:11:00',3310491400,1),(51358861,424985506,15105063,508959,1,'2007-09-24 18:39:54',3310491401,1),(51358862,424991858,15110266,508959,1,'2007-09-24 18:39:54',3310491403,1),(51358863,425000828,15117231,434787,1,'2007-09-15 15:10:59',3310491403,1),(51359239,425007692,15122468,508959,1,'2007-09-24 18:39:54',3310491403,1),(51359241,425014737,15127997,508959,1,'2007-09-24 18:39:54',3310491406,1),(51359242,425021234,15132846,508959,1,'2007-09-24 18:39:54',3310491406,1),(51359243,425024541,15135545,508959,1,'2007-09-24 18:39:54',3310491406,1),(51359245,425025197,15137161,434787,1,'2007-09-15 15:10:31',3310491406,1),(51359246,425027138,15143261,434787,1,'2007-09-15 15:10:31',3310491406,1),(51359247,425029522,15148736,508959,1,'2007-09-24 18:39:54',3310491406,1),(51359249,425032523,15153429,508959,1,'2007-09-24 18:39:54',3310491406,1),(51359251,425036736,15158791,508959,1,'2007-09-24 18:39:54',3310491406,1),(51359252,425039282,15165539,508959,1,'2007-09-24 18:39:54',3310491428,1),(51359253,425039685,15167906,508959,1,'2007-09-24 18:39:54',3310491428,1),(51359255,425039979,15174085,508959,1,'2007-09-24 18:39:54',3310491428,1),(51359256,425038654,15186787,508959,1,'2007-09-24 18:39:54',3310491428,1),(51359257,425042159,15203863,508959,1,'2007-09-24 18:39:54',3310491429,1),(51359259,425044641,15208435,508959,1,'2007-09-24 18:39:54',3310491429,1),(51359260,425046531,15213114,434787,1,'2007-09-15 15:10:28',3310491429,1),(51359261,425047604,15217315,508959,1,'2007-09-24 18:39:54',3310491431,1),(51359262,425048711,15223499,508959,1,'2007-09-24 18:39:54',3310491431,1),(51359264,425049470,15228651,508959,1,'2007-09-24 18:39:54',3310491431,1),(51359265,425050040,15232836,508959,1,'2007-09-24 18:39:54',3310491431,1),(51359266,425051115,15236386,434787,1,'2007-09-15 15:10:36',3310491431,1),(51359268,425052602,15239381,508959,1,'2007-09-24 18:39:54',3310491431,1),(51359269,425054907,15242401,508959,1,'2007-09-24 18:39:54',3310491431,1),(51359271,425056518,15243874,508959,1,'2007-09-24 18:39:54',3310491431,1),(51359272,425059344,15246029,508959,1,'2007-09-24 18:39:54',3310491431,1),(51359274,425063167,15250552,434787,1,'2007-09-15 15:10:35',3310491431,1),(51359275,425066240,15257991,508959,1,'2007-09-24 18:39:54',3310491431,1),(51359276,425066931,15259768,434787,1,'2007-09-15 15:10:35',3310491431,1),(51359278,425067287,15262695,508959,1,'2007-09-24 18:39:54',3310491431,1),(51359279,425067089,15266922,508959,1,'2007-09-24 18:39:54',3310491431,1),(51359280,425068591,15272474,434787,1,'2007-09-15 15:10:33',3310491448,1),(51359281,425070286,15274125,508959,1,'2007-09-24 18:39:54',3310491448,1),(51359283,425077223,15279009,434787,1,'2007-09-15 15:10:33',3310491448,1),(51359284,425082862,15283938,437032,1,'2008-05-13 20:45:03',3310491448,2),(51359285,425086981,15289800,508959,1,'2007-09-24 18:39:54',3310491448,1),(51359287,425088557,15294409,437032,1,'2008-05-13 21:07:22',3310491448,2),(51359288,425090012,15299903,437032,1,'2008-05-13 21:07:22',3310491448,2),(51359290,425093113,15307799,437032,1,'2008-05-13 21:07:22',3310491448,2),(51359291,425095355,15314062,508959,1,'2007-09-24 18:39:54',3310491449,1),(51359292,425097492,15319727,508959,1,'2007-09-24 18:39:54',3310491449,1),(51359293,425098355,15322401,434787,1,'2007-09-15 15:10:32',3310491449,1),(51359295,425099693,15327197,437032,1,'2008-05-13 20:45:03',3310491451,2),(51359296,425101085,15331059,437032,1,'2008-05-13 20:42:53',3310491451,2),(51359297,425104248,15336295,437032,1,'2008-05-13 20:42:53',3310491451,2),(51359299,425107440,15343992,508959,1,'2007-09-24 18:39:54',3310491451,1),(51359302,425111423,15349450,508959,1,'2007-09-24 18:39:54',3310491451,1),(51359303,425114417,15353498,508959,1,'2007-09-24 18:39:54',3310491451,1),(51359304,425115319,15356325,508959,1,'2007-09-24 18:39:54',3310491451,1),(51359305,425115892,15359671,508959,1,'2007-09-24 18:39:54',3310491451,1),(51359307,425113756,15368265,508959,1,'2007-09-24 18:39:54',3310491451,1),(51359308,425107442,15383028,508959,1,'2007-09-24 18:39:54',3310491537,1),(51359309,425105784,15387331,508959,1,'2007-09-24 18:39:54',3310491537,1),(51359310,425104745,15390684,508959,1,'2007-09-24 18:39:54',3310491537,1),(51359312,425104809,15399336,434787,1,'2007-09-15 15:10:40',3310491537,1),(51359313,425104758,15402274,508959,1,'2007-09-24 18:39:54',3310491537,1),(51359314,425104822,15405731,434787,1,'2007-09-15 15:10:40',3310491537,1),(51359316,425104267,15407546,508959,1,'2007-09-24 18:39:54',3310491537,1),(51359317,425103129,15410483,508959,1,'2007-09-24 18:39:54',3310491537,1),(51359318,425097966,15414794,508959,1,'2007-09-24 18:39:54',3310491537,1),(51359320,425094037,15418611,508959,1,'2007-09-24 18:39:54',3310491536,1),(51359322,425092583,15420925,508959,1,'2007-09-24 18:39:54',3310491536,1),(51359323,425091025,15424314,508959,1,'2007-09-24 18:39:54',3310491536,1),(51359324,425093554,15441457,508959,1,'2007-09-24 18:39:54',3310491538,1),(51359325,425095142,15448064,508959,1,'2007-09-24 18:39:54',3310491539,1),(51359327,425095691,15449511,434787,1,'2007-09-15 15:10:37',3310491539,1),(51359328,425097130,15451304,508959,1,'2007-09-24 18:39:54',3310491539,1),(51359330,425098139,15455925,508959,1,'2007-09-24 18:39:54',3310491539,1),(51359331,425098307,15457247,434787,1,'2007-09-15 15:10:43',3310491539,1),(51359357,425099696,15460021,508959,1,'2007-09-24 18:39:54',3310491539,1),(51359358,425102608,15460668,434787,1,'2007-09-15 15:10:43',3310491539,1),(51359756,425112338,15468030,188228,1,'2008-06-16 18:49:01',3310491539,2),(51359758,425109081,15461733,434787,1,'2007-09-15 15:10:07',3310491539,1),(51359760,425106246,15459942,508959,1,'2007-09-24 18:39:54',3310491539,1),(51359761,425103445,15461543,434787,1,'2007-09-15 15:10:09',3310491539,1),(51359762,425100281,15462216,508959,1,'2007-09-24 18:39:54',3310491539,1),(51359763,425098308,15460926,434787,1,'2007-09-15 15:10:08',3310491539,1),(51359764,425097180,15456850,508959,1,'2007-09-24 18:39:54',3310491539,1),(51359766,425095634,15451106,434787,1,'2007-09-15 15:10:07',3310491539,1),(51359769,425093055,15445630,508959,1,'2007-09-24 18:39:54',3310491538,1),(51359771,425090681,15432561,508959,1,'2007-09-24 18:39:54',3310491536,1),(51359772,425090436,15423686,434787,1,'2007-09-15 15:10:09',3310491536,1),(51359773,425090908,15420979,434787,1,'2007-09-15 15:10:09',3310491536,1),(51359774,425093121,15417933,434787,1,'2007-09-15 15:10:09',3310491536,1),(51359775,425098084,15413003,427965,1,'2007-09-14 19:42:25',3310491537,1),(51359776,425102133,15410085,427965,1,'2007-09-14 19:42:25',3310491537,1),(51359777,425103006,15407959,508959,1,'2007-09-24 18:39:54',3310491537,1),(51359778,425103905,15404077,508959,1,'2007-09-24 18:39:54',3310491537,1),(51359779,425103651,15392404,508959,1,'2007-09-24 18:39:54',3310491537,1),(51359780,425104031,15388713,508959,1,'2007-09-24 18:39:54',3310491537,1),(51359781,425106435,15382705,508959,1,'2007-09-24 18:39:54',3310491537,1),(51359782,425112762,15366139,508959,1,'2007-09-24 18:39:54',3310491451,1),(51359783,425114344,15360818,508959,1,'2007-09-24 18:39:54',3310491451,1),(51359784,425114066,15357167,434787,1,'2007-09-15 15:10:11',3310491451,1),(51359785,425112889,15354724,508959,1,'2007-09-24 18:39:54',3310491451,1),(51359786,425108333,15347943,508959,1,'2007-09-24 18:39:54',3310491451,1),(51359787,425103173,15337668,437032,1,'2008-05-13 20:42:53',3310491451,2),(51359788,425099946,15333291,437032,1,'2008-05-13 20:42:53',3310491451,2),(51359789,425098491,15328742,437032,1,'2008-05-13 20:45:03',3310491451,2),(51359790,425097542,15324279,437032,1,'2008-05-13 20:45:03',3310491449,2),(51359793,425096846,15321017,437032,1,'2008-05-13 20:45:03',3310491449,2),(51359948,425107582,15458743,508959,1,'2007-09-24 18:39:54',3310491539,1),(51359949,425108740,15459659,508959,1,'2007-09-24 18:39:54',3310491539,1),(51359951,425110946,15462365,188228,1,'2008-06-16 18:49:01',3310491539,2),(51359952,425113097,15466314,188228,1,'2008-06-16 18:49:29',3310491539,3),(51359953,425116007,15479017,188228,1,'2008-06-16 18:50:28',3310491539,3),(51360246,425115248,15481420,188228,1,'2008-06-16 18:50:28',3310491539,2),(51360952,425680412,16028409,427965,1,'2007-09-14 19:43:57',3310504014,1),(51360953,425682056,16033559,427965,1,'2007-09-14 19:43:57',3310504014,1),(51360955,425683510,16037850,427965,1,'2007-09-14 19:43:57',3310504014,1),(51360957,425685090,16041713,427965,1,'2007-09-14 19:43:57',3310504036,1),(51360958,425686165,16044374,427965,1,'2007-09-14 19:43:57',3310504036,1),(51360960,425688251,16046348,427965,1,'2007-09-14 19:43:57',3310504036,1),(51360961,425691158,16047549,427965,1,'2007-09-14 19:43:57',3310504036,1),(51360963,425694635,16048493,427965,1,'2007-09-14 19:43:57',3310504036,1),(51360964,425698175,16049266,427965,1,'2007-09-14 19:43:57',3310504036,1),(51360965,425700703,16049953,427965,1,'2007-09-14 19:43:57',3310504037,1),(51360967,425703168,16052527,427965,1,'2007-09-14 19:43:57',3310504037,1),(51360968,425704432,16055017,427965,1,'2007-09-14 19:43:57',3310504037,1),(51360969,425705949,16059566,427965,1,'2007-09-14 19:43:53',3310504037,1),(51360970,425706898,16064715,427965,1,'2007-09-14 19:43:57',3310504037,1),(51360971,425708604,16072440,427965,1,'2007-09-14 19:43:57',3310504037,1),(51360974,425709742,16078019,427965,1,'2007-09-14 19:43:57',3310504037,1),(51360975,425710501,16080766,427965,1,'2007-09-14 19:43:57',3310504037,1),(51360976,425711828,16083941,427965,1,'2007-09-14 19:43:57',3310504037,1),(51360979,425712966,16085916,427965,1,'2007-09-14 19:43:57',3310504037,1),(51360980,425713914,16088233,427965,1,'2007-09-14 19:43:57',3310504037,1),(51360981,425714419,16090465,427965,1,'2007-09-14 19:43:57',3310504037,1),(51360982,425714862,16093040,427965,1,'2007-09-14 19:43:57',3310504037,1),(51360984,425714609,16097159,427965,1,'2007-09-14 19:43:57',3310504039,1),(51360985,425713914,16102910,427965,1,'2007-09-14 19:43:57',3310504039,1),(51360986,425713787,16106687,427965,1,'2007-09-14 19:43:57',3310504039,1),(51360987,425714356,16110549,427965,1,'2007-09-14 19:43:57',3310504039,1),(51360988,425715620,16113553,427965,1,'2007-09-14 19:43:57',3310504039,1),(51360990,425717453,16116471,427965,1,'2007-09-14 19:43:57',3310504039,1),(51360991,425718781,16119390,427965,1,'2007-09-14 19:43:57',3310504039,1),(51360992,425719350,16121964,427965,1,'2007-09-14 19:43:57',3310504039,1),(51360993,425719603,16126428,427965,1,'2007-09-14 19:43:57',3310504039,1),(51360994,425719666,16132350,427965,1,'2007-09-14 19:43:57',3310504039,1),(51360995,425720614,16137671,427965,1,'2007-09-14 19:43:57',3310504039,1),(51360996,425722384,16144109,427965,1,'2007-09-14 19:43:57',3310504039,1),(51360998,425725544,16154151,427965,1,'2007-09-14 19:43:57',3310504045,1),(51361715,425639639,15913053,427965,1,'2007-09-14 19:45:55',3310504002,1),(51361716,425640524,15916657,427965,1,'2007-09-14 19:45:55',3310504002,1),(51361728,425628513,15904813,427965,1,'2007-09-14 19:46:49',3310504002,1),(51361816,425601455,15898376,427965,1,'2007-09-14 19:46:49',3310503959,1),(51361817,425608093,15901380,427965,1,'2007-09-14 19:46:49',3310503959,1),(51362009,425522479,15895040,5671401,1,'2010-09-03 18:06:01',3310503954,2),(51362011,425526123,15890270,5671401,1,'2010-09-03 18:06:00',3310503954,2),(51362012,425532415,15887046,427965,1,'2007-09-14 19:48:40',3310503954,1),(51362129,425511649,15906919,5671401,1,'2010-09-03 18:06:00',3310503954,2),(51362133,425517816,15901493,5671401,1,'2010-09-03 18:06:02',3310503954,2),(51362135,425519968,15898966,5671401,1,'2010-09-03 18:06:01',3310503954,2),(51362153,425506521,15909868,5671401,1,'2010-09-03 18:06:01',3310503943,2),(51362471,425459510,15913911,427965,1,'2007-09-14 19:49:09',3310503942,1),(51362474,425466592,15916057,427965,1,'2007-09-14 19:49:09',3310503942,1),(51362475,425475508,15918031,427965,1,'2007-09-14 19:49:09',3310503942,1),(51362477,425479745,15918374,427965,1,'2007-09-14 19:49:09',3310503943,1),(51362529,425439654,15917859,427965,1,'2007-09-14 19:49:09',3310503939,1),(51362531,425455779,15913739,427965,1,'2007-09-14 19:49:09',3310503942,1),(51362569,425422643,15915370,427965,1,'2007-09-14 19:51:17',3310503938,1),(51362570,425426627,15914855,427965,1,'2007-09-14 19:49:09',3310503939,1),(51362572,425436239,15917087,427965,1,'2007-09-14 19:49:09',3310503939,1),(51362612,425425173,15915627,427965,1,'2007-09-14 19:49:34',3310503939,1),(51362613,425429599,15915971,427965,1,'2007-09-14 19:49:34',3310503939,1),(51362614,425432445,15916228,427965,1,'2007-09-14 19:49:34',3310503939,1),(51362854,425433836,15917087,427965,1,'2007-09-14 19:49:34',3310503939,1),(51362856,425435607,15917945,427965,1,'2007-09-14 19:49:34',3310503939,1),(51362857,425437947,15918803,427965,1,'2007-09-14 19:49:34',3310503939,1),(51362858,425440666,15919147,427965,1,'2007-09-14 19:49:34',3310503939,1),(51362860,425443638,15919061,427965,1,'2007-09-14 19:49:34',3310503939,1),(51362861,425447495,15917859,427965,1,'2007-09-14 19:49:34',3310503939,1),(51362863,425451859,15916057,427965,1,'2007-09-14 19:49:34',3310503939,1),(51362864,425454704,15915112,427965,1,'2007-09-14 19:49:34',3310503942,1),(51362865,425457739,15914769,427965,1,'2007-09-14 19:49:34',3310503942,1),(51362867,425461660,15915370,427965,1,'2007-09-14 19:49:34',3310503942,1),(51362868,425465391,15916743,427965,1,'2007-09-14 19:49:34',3310503942,1),(51362870,425468047,15917945,427965,1,'2007-09-14 19:49:34',3310503942,1),(51362871,425471461,15918632,427965,1,'2007-09-14 19:49:34',3310503942,1),(51362872,425474307,15919147,427965,1,'2007-09-14 19:49:34',3310503942,1),(51362929,425406454,15922408,427965,1,'2007-09-14 19:51:17',3310503938,1),(51362931,425408098,15922923,427965,1,'2007-09-14 19:51:17',3310503938,1),(51362932,425410565,15923266,427965,1,'2007-09-14 19:51:17',3310503938,1),(51363022,425390989,15917139,427965,1,'2007-09-14 20:33:03',3310493015,1),(51363024,425399814,15917773,427965,1,'2007-09-14 19:51:17',3310503938,1),(51363076,425382422,15915542,427965,1,'2007-09-14 19:51:17',3310493015,1),(51363078,425385585,15916657,427965,1,'2007-09-14 19:51:17',3310493015,1),(51363079,425387925,15917087,427965,1,'2007-09-14 19:51:17',3310493015,1),(51363105,425372810,15898204,427965,1,'2007-09-14 19:51:17',3310493015,1),(51363107,425378059,15910563,427965,1,'2007-09-14 19:51:17',3310493015,1),(51363109,425380272,15913568,427965,1,'2007-09-14 19:51:17',3310493015,1),(51363149,425368888,15891337,427965,1,'2007-09-14 19:51:17',3310493014,1),(51363244,425338910,15849795,427965,1,'2007-09-14 19:56:23',3310493009,1),(51363246,425336950,15849624,427965,1,'2007-09-14 19:56:23',3310493009,1),(51363247,425333634,15851997,232546,1,'2008-04-23 11:34:50',3310493009,2),(51363248,425334862,15853572,427965,1,'2007-09-14 19:56:23',3310493009,1),(51363250,425339922,15859666,427965,1,'2007-09-14 19:56:23',3310493009,1),(51363414,425355228,15854087,427965,1,'2007-09-14 19:56:23',3310493012,1),(51363415,425345045,15856061,427965,1,'2007-09-14 19:56:23',3310493012,1),(51363565,425372430,15839667,427965,1,'2007-09-14 19:56:23',3310493013,1),(51363567,425372557,15841727,427965,1,'2007-09-14 19:56:23',3310493013,1),(51363568,425371165,15845847,427965,1,'2007-09-14 19:56:23',3310493013,1),(51363795,425337456,15802588,427965,1,'2007-09-14 19:56:23',3310491643,1),(51363797,425345361,15809712,427965,1,'2007-09-14 19:56:23',3310491646,1),(51363800,425355164,15816493,427965,1,'2007-09-14 19:56:23',3310491646,1),(51363884,425316773,15733495,427965,1,'2007-09-14 19:56:23',3310491641,1),(51364400,425305895,15725083,427965,1,'2007-09-14 19:56:23',3310491640,1),(51364728,425308045,15717015,427965,1,'2007-09-14 19:54:01',3310491640,1),(51364730,425306211,15722508,427965,1,'2007-09-14 19:54:01',3310491640,1),(51364732,425297735,15717530,427965,1,'2007-09-14 19:54:01',3310491640,1),(51364733,425299823,15712295,427965,1,'2007-09-14 19:54:01',3310491640,1),(51364894,425301530,15707488,427965,1,'2007-09-14 19:54:18',3310491634,1),(51364896,425300139,15711522,427965,1,'2007-09-14 19:54:18',3310491640,1),(51364898,425302988,15713193,198831,1,'2008-04-20 16:27:39',3310491640,2),(51364899,425304377,15709462,427965,1,'2007-09-14 19:54:18',3310491634,1),(51364998,425289574,15692183,188228,1,'2008-06-16 19:39:37',3310491634,2),(51365000,425290903,15693470,188228,1,'2008-06-16 19:39:37',3310491634,2),(51365004,425291219,15705057,188228,1,'2008-06-16 19:39:37',3310491634,2),(51365354,425281162,15693127,188228,1,'2008-06-16 19:38:21',3310491623,2),(51365356,425283249,15693213,188228,1,'2008-06-16 19:38:21',3310491623,2),(51365357,425286665,15691668,188228,1,'2008-06-16 19:38:45',3310491623,2),(51366010,425243211,15625434,427965,1,'2007-09-14 19:56:23',3310491620,1),(51366011,425244729,15628181,427965,1,'2007-09-14 19:56:23',3310491620,1),(51366015,425246500,15633674,427965,1,'2007-09-14 19:56:23',3310491620,1),(51366017,425247259,15638738,427965,1,'2007-09-14 19:56:23',3310491620,1),(51366022,425254405,15653473,188228,1,'2008-06-16 19:34:03',3310491620,2),(51366025,425256366,15658709,188228,1,'2008-06-16 19:34:03',3310491622,2),(51366028,425259213,15663515,188228,1,'2008-06-16 19:34:19',3310491622,2),(51366033,425268827,15676476,188228,1,'2008-06-16 19:35:06',3310491623,2),(51366035,425272180,15682570,188228,1,'2008-06-16 19:35:06',3310491623,2),(51366036,425273508,15686689,188228,1,'2008-06-16 19:35:26',3310491623,2),(51366037,425274267,15688664,188228,1,'2008-06-16 19:35:26',3310491623,2),(51366039,425278062,15692354,188228,1,'2008-06-16 19:35:55',3310491623,2),(51366154,425231888,15616078,2895121,1,'2009-10-19 19:23:28',3310491617,2),(51366157,425236632,15620198,427965,1,'2007-09-14 19:56:22',3310491620,1),(51366554,425173159,15543236,232546,1,'2008-04-23 11:29:32',3310491549,2),(51366556,425176322,15547099,232546,1,'2008-04-23 11:29:32',3310491551,2),(51366560,425182988,15557799,427965,1,'2007-09-14 19:57:45',3310491594,1),(51366562,425188279,15563664,232546,1,'2008-04-23 11:29:32',3310491594,2),(51366564,425205698,15578914,427965,1,'2007-09-14 19:57:45',3310491595,1),(51366769,425148382,15527329,427965,1,'2007-09-14 19:57:45',3310491548,1),(51366772,425150533,15528274,427965,1,'2007-09-14 19:57:45',3310491549,1),(51366773,425155468,15532565,427965,1,'2007-09-14 19:57:45',3310491549,1),(51366775,425158694,15533767,427965,1,'2007-09-14 19:57:45',3310491549,1),(51366776,425161858,15534711,427965,1,'2007-09-14 19:57:45',3310491549,1),(51366854,425134314,15523152,232546,1,'2008-04-23 11:31:12',3310491548,3),(51366858,425138806,15525727,232546,1,'2008-04-23 11:28:56',3310491548,2),(51366991,425123220,15508113,188228,1,'2008-06-16 18:55:07',3310491548,3),(51366992,425125416,15510163,427965,1,'2007-09-14 19:57:45',3310491548,1),(51367555,425122882,15503762,188228,1,'2008-06-16 18:51:17',3310491548,4),(51367558,425122081,15502792,188228,1,'2008-06-16 18:52:21',3310491545,4),(51367559,425121195,15503307,188228,1,'2008-06-16 18:52:21',3310491545,4),(51367563,425121630,15505152,188228,1,'2008-06-16 18:51:17',3310491545,3),(51367565,425122358,15505136,188228,1,'2008-06-16 18:51:17',3310491545,3),(51367748,425083963,15448487,840745,1,'2009-01-26 19:29:53',3310491538,2),(51367752,425083204,15451319,840745,1,'2009-01-26 19:29:53',3310491538,2),(51367755,425081179,15457499,840745,1,'2009-01-26 19:29:53',3310491538,2),(51367756,425080293,15461790,840745,1,'2009-01-26 19:29:53',3310491538,2),(51367760,425080293,15465138,840745,1,'2009-01-26 19:29:53',3310491538,2),(51367761,425081306,15469343,840745,1,'2009-01-26 19:29:53',3310491538,2),(51367762,425082571,15471403,840745,1,'2009-01-26 19:29:53',3310491538,2),(51367763,425084849,15473978,840745,1,'2009-01-26 19:29:53',3310491538,2),(51367764,425088456,15475523,840745,1,'2009-01-26 19:29:53',3310491538,2),(51367767,425097503,15479471,840745,1,'2009-01-26 19:29:53',3310491539,2),(51367769,425102059,15481102,840745,1,'2009-01-26 19:29:53',3310491539,2),(51367770,425106994,15483076,840745,1,'2009-01-26 19:29:53',3310491539,2),(51367772,425109145,15484278,840745,1,'2009-01-26 19:29:53',3310491539,2),(51367774,425110790,15485995,840745,1,'2009-01-26 19:29:53',3310491539,2),(51367776,425112245,15489771,840745,1,'2009-01-26 19:29:54',3310491539,2),(51367779,425113827,15492775,840745,1,'2009-01-26 19:29:54',3310491545,2),(51367783,425115978,15495608,840745,1,'2009-01-26 19:29:54',3310491545,2),(51367785,425117433,15498783,840745,1,'2009-01-26 19:29:54',3310491545,2),(51367787,425118369,15500716,840745,1,'2009-01-26 19:29:54',3310491545,3),(51367788,425119015,15501959,840745,1,'2009-01-26 19:29:54',3310491545,2),(51367806,425121006,15504251,840745,1,'2009-01-26 19:29:54',3310491545,5),(51367819,425122844,15504425,188228,1,'2008-06-16 18:51:17',3310491548,3),(51367842,425122696,15505700,427965,1,'2007-09-14 19:59:43',3310491548,1),(51369095,425029810,15154996,427965,1,'2007-09-14 20:01:57',3310491406,1),(51369096,425031392,15157571,427965,1,'2007-09-14 20:01:47',3310491406,1),(51369098,425033987,15161605,427965,1,'2007-09-14 20:01:47',3310491428,1),(51369101,425036455,15165982,427965,1,'2007-09-14 20:01:57',3310491428,1),(51369102,425037024,15171647,427965,1,'2007-09-14 20:01:57',3310491428,1),(51369103,425037024,15174136,427965,1,'2007-09-14 20:01:57',3310491428,1),(51369105,425037024,15176454,427965,1,'2007-09-14 20:01:57',3310491428,1),(51369106,425036201,15182977,427965,1,'2007-09-14 20:01:57',3310491428,1),(51369109,425036690,15195113,3916355,1,'2010-02-19 17:31:54',3310491428,6),(51369110,425038479,15200057,840745,1,'2009-01-26 20:00:22',3310491428,4),(51369112,425043984,15212674,840745,1,'2009-01-26 20:00:22',3310491429,4),(51369114,425045250,15216537,840745,1,'2009-01-26 20:00:23',3310491431,4),(51369115,425046009,15222030,840745,1,'2009-01-26 20:00:23',3310491431,4),(51369118,425046516,15230012,840745,1,'2009-01-26 20:00:23',3310491431,4),(51369120,425047212,15236363,840745,1,'2009-01-26 20:00:23',3310491431,4),(51369123,425049173,15247521,840745,1,'2009-01-26 20:00:23',3310491431,4),(51369125,425050807,15256082,840745,1,'2009-01-26 20:00:24',3310491431,4),(51369126,425052072,15265180,840745,1,'2009-01-26 20:00:24',3310491431,4),(51369129,425052992,15273228,3916355,1,'2010-02-19 17:34:12',3310491437,8),(51369131,425052684,15275616,3916355,1,'2010-02-19 17:34:13',3310491437,6),(51369132,425053211,15283462,840745,1,'2009-01-26 19:28:30',3310491437,2),(51369133,425054034,15288011,840745,1,'2009-01-26 19:28:30',3310491437,2),(51369134,425055489,15294963,840745,1,'2009-01-26 19:28:30',3310491437,2),(51369136,425057313,15304087,840745,1,'2009-01-26 19:28:31',3310491437,2),(51369139,425058512,15310033,840745,1,'2009-01-26 19:28:31',3310491437,2),(51369142,425062956,15329982,840745,1,'2009-01-26 19:29:52',3310491439,2),(51369145,425064158,15335904,840745,1,'2009-01-26 19:29:52',3310491439,2),(51369146,425067129,15351941,840745,1,'2009-01-26 19:29:52',3310491439,2),(51369147,425068335,15359051,840745,1,'2009-01-26 19:29:52',3310491450,2),(51369148,425069284,15366347,840745,1,'2009-01-26 19:29:52',3310491450,2),(51369150,425070802,15375874,840745,1,'2009-01-26 19:29:52',3310491450,2),(51369153,425072258,15385573,840745,1,'2009-01-26 19:29:52',3310491536,2),(51369155,425073080,15389778,840745,1,'2009-01-26 19:29:52',3310491536,2),(51369157,425074472,15397074,840745,1,'2009-01-26 19:29:52',3310491536,2),(51369159,425075168,15401795,840745,1,'2009-01-26 19:29:52',3310491536,2),(51369160,425075485,15406430,840745,1,'2009-01-26 19:29:52',3310491536,2),(51369162,425076371,15412180,840745,1,'2009-01-26 19:29:52',3310491536,2),(51369164,425078522,15419905,840745,1,'2009-01-26 19:29:52',3310491536,2),(51369165,425079787,15427630,840745,1,'2009-01-26 19:29:52',3310491536,2),(51369168,425080736,15432265,840745,1,'2009-01-26 19:29:52',3310491536,2),(51369170,425082002,15435011,840745,1,'2009-01-26 19:29:52',3310491536,2),(51369171,425083900,15440676,840745,1,'2009-01-26 19:29:52',3310491538,2),(51369173,425084216,15444453,840745,1,'2009-01-26 19:29:53',3310491538,2),(51369221,425036961,15168986,427965,1,'2007-09-14 20:01:57',3310491428,1),(51369359,425009751,15132594,427965,1,'2007-09-14 20:04:19',3310491403,1),(51369361,425006978,15138172,434787,1,'2007-09-15 14:31:20',3310491403,1),(51369362,425015130,15144868,427965,1,'2007-09-14 20:04:19',3310491406,1),(51369364,425017891,15138553,434787,1,'2007-09-15 14:31:20',3310491406,1),(51370189,425008232,15131135,427965,1,'2007-09-14 20:08:28',3310491403,1),(51370191,425007410,15131478,427965,1,'2007-09-14 20:08:28',3310491403,1),(51370193,425006207,15132422,427965,1,'2007-09-14 20:08:28',3310491403,1),(51370194,425005574,15133452,427965,1,'2007-09-14 20:08:28',3310491403,1),(51370196,425005258,15134997,427965,1,'2007-09-14 20:08:28',3310491403,1),(51370197,425005448,15137143,427965,1,'2007-09-14 20:08:28',3310491403,1),(51370198,425005828,15138688,427965,1,'2007-09-14 20:08:28',3310491403,1),(51370199,425007156,15140061,427965,1,'2007-09-14 20:08:28',3310491403,1),(51370201,425015320,15146327,427965,1,'2007-09-14 20:08:28',3310491406,1),(51370202,425016838,15146499,427965,1,'2007-09-14 20:08:28',3310491406,1),(51370203,425018104,15145812,427965,1,'2007-09-14 20:08:28',3310491406,1),(51370206,425019116,15144696,427965,1,'2007-09-14 20:08:28',3310491406,1),(51370208,425019812,15143580,427965,1,'2007-09-14 20:08:28',3310491406,1),(51370210,425019876,15141006,427965,1,'2007-09-14 20:08:28',3310491406,1),(51370211,425019559,15139461,427965,1,'2007-09-14 20:08:28',3310491406,1),(51370213,425018800,15138001,427965,1,'2007-09-14 20:08:28',3310491406,1),(51370260,425009624,15131049,427965,1,'2007-09-14 20:08:28',3310491403,1),(51371237,425021584,15139203,427965,1,'2007-09-14 20:05:51',3310491406,1),(51371240,425023229,15142035,427965,1,'2007-09-14 20:05:14',3310491406,1),(51371243,425025191,15147014,427965,1,'2007-09-14 20:05:14',3310491406,1),(51371246,425027659,15151563,427965,1,'2007-09-14 20:05:14',3310491406,1),(51371386,424939190,15008054,427965,1,'2007-09-14 20:05:52',3310491223,1),(51371387,424939140,15009063,592895,1,'2008-07-25 23:27:47',3310491223,2),(51371388,424939823,15011058,427965,1,'2007-09-14 20:05:51',3310491223,1),(51371389,424941617,15014249,592895,1,'2008-07-25 22:38:46',3310491223,3),(51371391,424944085,15020514,592895,1,'2008-07-25 22:38:46',3310491223,3),(51371392,424948009,15029269,592895,1,'2008-07-25 22:38:46',3310491223,3),(51371395,424949971,15033732,592895,1,'2008-07-25 22:35:39',3310491223,2),(51371400,424950961,15042729,427965,1,'2007-09-14 20:05:51',3310491223,1),(51371401,424950771,15045819,427965,1,'2007-09-14 20:05:51',3310491223,1),(51371402,424950708,15048223,427965,1,'2007-09-14 20:05:51',3310491223,1),(51371403,424951024,15050712,427965,1,'2007-09-14 20:05:51',3310491223,1),(51371404,424952037,15053716,427965,1,'2007-09-14 20:05:51',3310491229,1),(51371406,424955138,15058780,427965,1,'2007-09-14 20:05:51',3310491229,1),(51371408,424960201,15067449,427965,1,'2007-09-14 20:05:51',3310491400,1),(51371409,424965263,15074830,427965,1,'2007-09-14 20:05:51',3310491400,1),(51371411,424967162,15077662,427965,1,'2007-09-14 20:05:51',3310491400,1),(51371413,424972794,15090709,427965,1,'2007-09-14 20:05:51',3310491400,1),(51371415,424977857,15100751,427965,1,'2007-09-14 20:05:51',3310491400,1),(51371418,424981781,15106330,427965,1,'2007-09-14 20:05:51',3310491400,1),(51371421,424985577,15109591,427965,1,'2007-09-14 20:05:51',3310491403,1),(51371422,424989881,15113626,427965,1,'2007-09-14 20:05:31',3310491403,1),(51371423,424995260,15117230,427965,1,'2007-09-14 20:05:51',3310491403,1),(51371425,425005321,15125041,427965,1,'2007-09-14 20:05:51',3310491403,1),(51371428,425008675,15127616,427965,1,'2007-09-14 20:05:51',3310491403,1),(51371430,425019180,15136542,427965,1,'2007-09-14 20:05:51',3310491406,1),(51384482,424942193,14992314,427965,1,'2007-09-14 20:30:03',3310491221,1),(51384485,424941307,14995575,427965,1,'2007-09-14 20:30:03',3310491221,1),(51384487,424940927,14999008,427965,1,'2007-09-14 20:30:03',3310491223,1),(51384488,424940801,15003042,427965,1,'2007-09-14 20:30:03',3310491223,1),(51384490,424941094,15005147,462689,1,'2008-05-17 12:22:13',3310491223,3),(51384518,424941054,15004587,427965,1,'2007-09-14 20:30:03',3310491223,1),(51385251,424849718,14920951,592895,1,'2008-07-25 21:23:37',3310490874,3),(51385256,424852826,14923392,427965,1,'2007-09-14 20:30:03',3310490874,1),(51385259,424855484,14925022,427965,1,'2007-09-14 20:30:03',3310490874,1),(51385261,424860421,14926825,427965,1,'2007-09-14 20:30:03',3310490874,1),(51385264,424865801,14928885,427965,1,'2007-09-14 20:30:03',3310490874,1),(51385266,424888903,14941759,427965,1,'2007-09-14 20:30:03',3310491217,1),(51385267,424893903,14944592,427965,1,'2007-09-14 20:30:03',3310491217,1),(51385271,424902131,14949141,427965,1,'2007-09-14 20:30:03',3310491217,1),(51385273,424915226,14958974,592895,1,'2008-07-25 22:09:57',3310491220,2),(51385276,424927504,14971763,592895,1,'2008-07-25 22:09:57',3310491220,2),(51385277,424932630,14978543,592895,1,'2008-07-25 22:16:08',3310491221,2),(51385279,424934719,14981204,592895,1,'2008-07-25 22:16:08',3310491221,2),(51385284,424936428,14982921,592895,1,'2008-07-25 22:16:08',3310491221,2),(51385285,424938263,14983436,592895,1,'2008-07-25 22:16:08',3310491221,2),(51385287,424940288,14983521,592895,1,'2008-07-25 22:16:08',3310491221,2),(51385289,424942187,14983092,592895,1,'2008-07-25 22:16:08',3310491221,2),(51385290,424946019,14981546,592895,1,'2008-07-25 22:14:49',3310491221,2),(51385291,424948902,14980726,592895,1,'2008-07-25 22:14:49',3310491221,2),(51385292,424950484,14980898,592895,1,'2008-07-25 22:14:49',3310491221,2),(51385295,424951616,14981376,592895,1,'2008-07-25 22:15:37',3310491221,3),(51385296,424952376,14982577,592895,1,'2008-07-25 22:15:37',3310491221,3),(51385297,424952692,14983951,592895,1,'2008-07-25 22:15:37',3310491221,3),(51385298,424952313,14985324,592895,1,'2008-07-25 22:15:37',3310491221,3),(51385299,424951363,14986096,592895,1,'2008-07-25 22:15:37',3310491221,3),(51385300,424950098,14986697,592895,1,'2008-07-25 22:15:37',3310491221,3),(51385302,424944402,14988757,592895,1,'2008-07-25 22:16:28',3310491221,2),(51385304,424942952,14990597,427965,1,'2007-09-14 20:30:03',3310491221,1),(51385320,424842122,14911509,592895,1,'2008-07-25 21:28:02',3310490863,3),(51385334,424835945,14906979,439281,1,'2007-09-16 00:57:34',3310490863,1),(51385336,424840103,14909487,427965,1,'2007-09-14 20:30:34',3310490863,1),(51385349,424829931,14903460,439281,1,'2007-09-16 00:57:48',3310490863,1),(51385966,424686038,14926891,439281,1,'2007-09-16 00:57:42',3310490814,1),(51385967,424691989,14927235,439281,1,'2007-09-16 00:57:41',3310490814,1),(51385970,424697877,14927750,439281,1,'2007-09-16 00:57:43',3310490814,1),(51385971,424701613,14930067,439281,1,'2007-09-16 00:57:43',3310490814,1),(51385973,424705664,14930925,439281,1,'2007-09-16 00:57:44',3310490814,1),(51385974,424710983,14931440,439281,1,'2007-09-16 00:57:43',3310490815,1),(51385975,424714655,14932728,439281,1,'2007-09-16 00:57:43',3310490815,1),(51385976,424721809,14934702,439281,1,'2007-09-16 00:57:42',3310490815,1),(51385978,424727823,14934445,439281,1,'2007-09-16 00:57:42',3310490815,1),(51385979,424730039,14934187,439281,1,'2007-09-16 00:57:42',3310490815,1),(51385982,424732001,14932470,439281,1,'2007-09-16 00:57:42',3310490815,1),(51385983,424733711,14930325,439281,1,'2007-09-16 00:57:43',3310490815,1),(51385985,424736053,14924317,439281,1,'2007-09-16 00:57:44',3310490815,1),(51385986,424738459,14916935,439281,1,'2007-09-16 00:57:44',3310490858,1),(51385988,424741624,14912214,439281,1,'2007-09-16 00:57:44',3310490858,1),(51385990,424744156,14909725,439281,1,'2007-09-16 00:57:44',3310490858,1),(51385991,424748904,14907837,439281,1,'2007-09-16 00:57:44',3310490858,1),(51385994,424752893,14908524,439281,1,'2007-09-16 00:57:45',3310490858,1),(51385996,424756121,14908009,439281,1,'2007-09-16 00:57:45',3310490858,1),(51385997,424759033,14907150,439281,1,'2007-09-16 00:57:45',3310490858,1),(51386001,424770112,14906464,439281,1,'2007-09-16 00:57:46',3310490859,1),(51386002,424774036,14905262,439281,1,'2007-09-16 00:57:46',3310490859,1),(51386005,424779860,14902344,439281,1,'2007-09-16 00:57:45',3310490859,1),(51386008,424788533,14897280,439281,1,'2007-09-16 00:57:47',3310490859,1),(51386009,424793407,14894619,439281,1,'2007-09-16 00:57:47',3310490862,1),(51386011,424798091,14893246,439281,1,'2007-09-16 00:57:47',3310490862,1),(51386013,424800687,14893332,439281,1,'2007-09-16 00:57:46',3310490862,1),(51386014,424807080,14894190,439281,1,'2007-09-16 00:57:46',3310490862,1),(51386018,424812208,14895306,439281,1,'2007-09-16 00:57:48',3310490862,1),(51386019,424817461,14896765,439281,1,'2007-09-16 00:57:48',3310490862,1),(51386021,424825057,14900198,439281,1,'2007-09-16 00:57:47',3310490863,1),(51386271,424545848,14868288,439281,1,'2007-09-16 00:57:35',3310490793,1),(51386274,424555157,14864769,439281,1,'2007-09-16 00:57:37',3310490793,1),(51386275,424558576,14864512,439281,1,'2007-09-16 00:57:38',3310490793,1),(51386276,424565289,14865627,439281,1,'2007-09-16 00:57:37',3310490793,1),(51386279,424569911,14867687,439281,1,'2007-09-16 00:57:37',3310490793,1),(51386281,424575231,14870691,439281,1,'2007-09-16 00:57:38',3310490796,1),(51386282,424578460,14873352,439281,1,'2007-09-16 00:57:38',3310490796,1),(51386284,424581690,14878330,439281,1,'2007-09-16 00:57:38',3310490796,1),(51386286,424584413,14881764,439281,1,'2007-09-16 00:57:38',3310490796,1),(51386287,424585806,14882708,439281,1,'2007-09-16 00:57:38',3310490796,1),(51386289,424588845,14883995,439281,1,'2007-09-16 00:57:35',3310490796,1),(51386290,424591821,14886484,439281,1,'2007-09-16 00:57:36',3310490796,1),(51386294,424595051,14888802,439281,1,'2007-09-16 00:57:35',3310490798,1),(51386295,424603916,14894638,439281,1,'2007-09-16 00:57:35',3310490799,1),(51386296,424610850,14899397,443749,1,'2007-09-16 13:41:57',3310490799,1),(51386298,424615313,14903221,439281,1,'2007-09-16 00:57:37',3310490799,1),(51386301,424621575,14904388,439281,1,'2007-09-16 00:57:36',3310490799,1),(51386302,424622668,14904022,439281,1,'2007-09-16 00:57:36',3310490799,1),(51386304,424623862,14903545,439281,1,'2007-09-16 00:57:40',3310490799,1),(51386307,424632916,14901228,439281,1,'2007-09-16 00:57:40',3310490810,1),(51386309,424643427,14898052,439281,1,'2007-09-16 00:57:40',3310490810,1),(51386312,424647163,14897623,439281,1,'2007-09-16 00:57:41',3310490810,1),(51386315,424649885,14898310,439281,1,'2007-09-16 00:57:41',3310490810,1),(51386316,424652418,14900284,439281,1,'2007-09-16 00:57:41',3310490810,1),(51386319,424655710,14905348,439281,1,'2007-09-16 00:57:41',3310490811,1),(51386320,424660649,14913588,439281,1,'2007-09-16 00:57:39',3310490811,1),(51386324,424663751,14917021,439281,1,'2007-09-16 00:57:39',3310490811,1),(51386327,424667803,14919939,439281,1,'2007-09-16 00:57:39',3310490811,1),(51386330,424674578,14923029,439281,1,'2007-09-16 00:57:39',3310490811,1),(51386331,424679200,14925518,439281,1,'2007-09-16 00:57:39',3310490811,1),(51386333,424682176,14926548,439281,1,'2007-09-16 00:57:40',3310490811,1),(51386340,424533036,14870863,427965,1,'2007-09-14 20:32:06',3310490792,1),(51386342,424535949,14870863,427965,1,'2007-09-14 20:32:06',3310490792,1),(51386346,424539832,14870262,439281,1,'2007-09-16 00:57:41',3310490792,1),(51386455,424509858,14861508,427965,1,'2007-09-14 20:32:06',3310490109,1),(51386456,424520687,14866915,427965,1,'2007-09-14 20:32:06',3310490792,1),(51386457,424527020,14869490,427965,1,'2007-09-14 20:32:06',3310490792,1),(51386536,424496051,14842453,427965,1,'2007-09-14 20:32:17',3310490109,1),(51386538,424504665,14855499,427965,1,'2007-09-14 20:32:17',3310490109,1),(51386795,425247920,15640249,427965,1,'2007-09-14 20:32:48',3310491620,1),(51387092,425441896,15918083,427965,1,'2007-09-14 20:33:11',3310503939,1),(51389997,425436395,17314720,427965,1,'2007-09-14 20:38:56',3310504587,1),(51389999,425441137,17314120,427965,1,'2007-09-14 20:38:56',3310504587,1),(51390001,425447524,17312317,427965,1,'2007-09-14 20:38:56',3310504587,1),(51390003,425453089,17311030,427965,1,'2007-09-14 20:38:56',3310504590,1),(51390006,425456630,17310686,427965,1,'2007-09-14 20:38:56',3310504590,1),(51390008,425458907,17311459,427965,1,'2007-09-14 20:38:56',3310504590,1),(51390010,425460551,17311545,427965,1,'2007-09-14 20:38:56',3310504590,1),(51390012,425462384,17311287,427965,1,'2007-09-14 20:38:56',3310504590,1),(51390014,425463965,17310343,427965,1,'2007-09-14 20:38:56',3310504590,1),(51390016,425464977,17309485,206510,1,'2008-12-06 20:10:24',3310504590,5),(51391054,425460677,17308369,206510,1,'2008-12-06 20:10:24',3310504590,2),(51391055,425462068,17306137,427965,1,'2007-09-14 20:41:03',3310504590,1),(51391057,425463586,17304335,427965,1,'2007-09-14 20:41:03',3310504590,1),(51391058,425464914,17303391,427965,1,'2007-09-14 20:41:03',3310504588,1),(51391060,425467127,17303562,427965,1,'2007-09-14 20:41:03',3310504588,1),(51391063,425468392,17304850,427965,1,'2007-09-14 20:41:03',3310504590,1),(51391064,425469467,17306824,427965,1,'2007-09-14 20:41:03',3310504590,1),(51391065,425469720,17309056,427965,1,'2007-09-14 20:41:03',3310504590,1),(51391067,425469656,17310944,206510,1,'2008-12-06 20:09:53',3310504590,4),(51392412,425381756,17283564,206510,1,'2008-12-06 20:10:24',3310493661,2),(51392415,425381376,17284765,427965,1,'2007-09-14 20:47:30',3310493661,1),(51392416,425381629,17285795,427965,1,'2007-09-14 20:47:30',3310493661,1),(51392417,425383337,17287855,427965,1,'2007-09-14 20:47:30',3310493661,1),(51392418,425387764,17292319,427965,1,'2007-09-14 20:47:30',3310493661,1),(51392420,425390293,17294464,427965,1,'2007-09-14 20:43:47',3310493661,1),(51392422,425392823,17295666,427965,1,'2007-09-14 20:47:30',3310493661,1),(51392424,425395100,17295838,427965,1,'2007-09-14 20:47:30',3310493661,1),(51392426,425399906,17296524,427965,1,'2007-09-14 20:47:30',3310504584,1),(51392429,425407368,17299528,427965,1,'2007-09-14 20:47:30',3310504584,1),(51392430,425412997,17301502,427965,1,'2007-09-14 20:47:30',3310504584,1),(51392432,425417929,17304077,427965,1,'2007-09-14 20:47:30',3310504586,1),(51392434,425422356,17305279,427965,1,'2007-09-14 20:47:30',3310504586,1),(51392435,425424885,17305365,427965,1,'2007-09-14 20:47:30',3310504587,1),(51392436,425426530,17306481,427965,1,'2007-09-14 20:47:30',3310504587,1),(51392437,425426656,17307854,427965,1,'2007-09-14 20:47:30',3310504587,1),(51392439,425426403,17308970,427965,1,'2007-09-14 20:47:30',3310504587,1),(51392441,425425455,17309570,427965,1,'2007-09-14 20:47:30',3310504587,1),(51392442,425423557,17309056,427965,1,'2007-09-14 20:47:30',3310504586,1),(51392445,425420079,17308712,427965,1,'2007-09-14 20:47:30',3310504586,1),(51392447,425416411,17308197,427965,1,'2007-09-14 20:47:30',3310504586,1),(51396271,425470289,17005043,427965,1,'2007-09-14 20:51:38',3310504486,1),(51396360,425442212,17007361,427965,1,'2007-09-14 20:51:38',3310504483,1),(51396361,425443351,17007618,427965,1,'2007-09-14 20:51:38',3310504483,1),(51396363,425444679,17008305,427965,1,'2007-09-14 20:51:38',3310504483,1),(51396365,425446260,17010708,427965,1,'2007-09-14 20:51:38',3310504483,1),(51396367,425448157,17012081,427965,1,'2007-09-14 20:51:38',3310504483,1),(51396369,425450686,17012510,427965,1,'2007-09-14 20:51:38',3310504483,1),(51396370,425454290,17011051,427965,1,'2007-09-14 20:51:38',3310504486,1),(51396371,425456820,17009678,427965,1,'2007-09-14 20:51:38',3310504486,1),(51396373,425459412,17009335,427965,1,'2007-09-14 20:51:38',3310504486,1),(51396374,425463143,17008391,427965,1,'2007-09-14 20:51:38',3310504486,1),(51396375,425466178,17007618,427965,1,'2007-09-14 20:51:38',3310504486,1),(51396377,425469087,17005816,427965,1,'2007-09-14 20:51:38',3310504486,1),(51396378,425472186,17003327,427965,1,'2007-09-14 20:51:38',3310504486,1),(51396380,425474019,17002726,427965,1,'2007-09-14 20:51:38',3310504486,1),(51396399,425476296,17002640,427965,1,'2007-09-14 20:51:38',3310504486,1),(51396983,425353739,17018519,427965,1,'2007-09-14 20:51:38',3310493558,1),(51396985,425356964,17018690,427965,1,'2007-09-14 20:51:38',3310493558,1),(51396986,425361771,17017746,427965,1,'2007-09-14 20:51:38',3310493558,1),(51396989,425365376,17016716,427965,1,'2007-09-14 20:51:38',3310493558,1),(51396991,425368538,17014828,427965,1,'2007-09-14 20:51:38',3310493558,1),(51396992,425371637,17012940,427965,1,'2007-09-14 20:51:38',3310493559,1),(51396993,425375431,17012425,427965,1,'2007-09-14 20:51:38',3310493559,1),(51396996,425378594,17012167,427965,1,'2007-09-14 20:51:38',3310493559,1),(51396997,425381186,17012510,427965,1,'2007-09-14 20:51:38',3310493559,1),(51396999,425384032,17012940,427965,1,'2007-09-14 20:51:38',3310493559,1),(51397000,425386436,17012596,427965,1,'2007-09-14 20:51:38',3310493559,1),(51397003,425388965,17012339,427965,1,'2007-09-14 20:51:38',3310493559,1),(51397004,425392254,17012940,427965,1,'2007-09-14 20:51:38',3310493559,1),(51397005,425394467,17013283,427965,1,'2007-09-14 20:51:38',3310493559,1),(51397008,425395985,17012854,427965,1,'2007-09-14 20:51:38',3310493559,1),(51397009,425398198,17012167,427965,1,'2007-09-14 20:51:38',3310504482,1),(51397010,425400412,17011566,427965,1,'2007-09-14 20:51:38',3310504482,1),(51397012,425403637,17011566,427965,1,'2007-09-14 20:51:38',3310504482,1),(51397013,425406103,17012167,427965,1,'2007-09-14 20:51:38',3310504482,1),(51397015,425409076,17013197,427965,1,'2007-09-14 20:51:38',3310504482,1),(51397016,425412680,17014570,427965,1,'2007-09-14 20:51:38',3310504482,1),(51397017,425414767,17015600,427965,1,'2007-09-14 20:51:38',3310504482,1),(51397019,425417423,17015600,427965,1,'2007-09-14 20:51:38',3310504482,1),(51397021,425419953,17014828,427965,1,'2007-09-14 20:51:38',3310504482,1),(51397022,425421724,17013884,427965,1,'2007-09-14 20:51:38',3310504482,1),(51397024,425425265,17012253,427965,1,'2007-09-14 20:51:38',3310504483,1),(51397026,425429818,17010536,427965,1,'2007-09-14 20:51:38',3310504483,1),(51397027,425432600,17009421,427965,1,'2007-09-14 20:51:38',3310504483,1),(51397028,425434940,17008476,427965,1,'2007-09-14 20:51:38',3310504483,1),(51397029,425437659,17007618,427965,1,'2007-09-14 20:51:38',3310504483,1),(51397032,425439936,17007361,427965,1,'2007-09-14 20:51:38',3310504483,1),(51397034,425445501,17009506,427965,1,'2007-09-14 20:51:38',3310504483,1),(51397727,425607048,16810465,427965,1,'2007-09-14 20:53:59',3310504477,1),(51397729,425604519,16811409,427965,1,'2007-09-14 20:53:59',3310504477,1),(51397731,425603507,16813469,427965,1,'2007-09-14 20:53:59',3310504477,1),(51397732,425603570,16815357,427965,1,'2007-09-14 20:53:59',3310504477,1),(51397733,425604898,16818876,427965,1,'2007-09-14 20:53:59',3310504477,1),(51397734,425605530,16821881,427965,1,'2007-09-14 20:53:59',3310504477,1),(51397737,425605530,16824112,427965,1,'2007-09-14 20:53:59',3310504477,1),(51397738,425604772,16826859,427965,1,'2007-09-14 20:53:59',3310504477,1),(51397740,425603823,16828747,427965,1,'2007-09-14 20:53:59',3310504477,1),(51397742,425602369,16830464,427965,1,'2007-09-14 20:53:50',3310504477,1),(51397744,425600409,16831408,427965,1,'2007-09-14 20:53:59',3310504477,1),(51397748,425597565,16831064,427965,1,'2007-09-14 20:53:59',3310504477,1),(51397749,425594151,16829605,427965,1,'2007-09-14 20:53:59',3310504477,1),(51397752,425591875,16829262,427965,1,'2007-09-14 20:53:59',3310504477,1),(51397753,425588081,16830549,427965,1,'2007-09-14 20:53:59',3310504476,1),(51397756,425583087,16830893,427965,1,'2007-09-14 20:53:59',3310504476,1),(51397757,425580179,16832266,427965,1,'2007-09-14 20:53:59',3310504476,1),(51397758,425578219,16833725,427965,1,'2007-09-14 20:53:59',3310504476,1),(51397762,425576954,16835098,427965,1,'2007-09-14 20:53:59',3310504476,1),(51397764,425576322,16836472,427965,1,'2007-09-14 20:53:59',3310504476,1),(51397766,425576449,16838103,427965,1,'2007-09-14 20:53:59',3310504476,1),(51397769,425577334,16840162,427965,1,'2007-09-14 20:53:59',3310504476,1),(51397770,425577334,16843596,427965,1,'2007-09-14 20:53:59',3310504476,1),(51397771,425575690,16847029,427965,1,'2007-09-14 20:53:59',3310504476,1),(51397772,425572213,16850205,427965,1,'2007-09-14 20:53:59',3310504476,1),(51397773,425566522,16854496,427965,1,'2007-09-14 20:53:59',3310504476,1),(51397776,425563172,16858187,427965,1,'2007-09-14 20:53:59',3310504476,1),(51397777,425561528,16861105,427965,1,'2007-09-14 20:53:59',3310504473,1),(51397779,425561275,16864367,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397781,425561717,16867972,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397782,425562539,16871233,427965,1,'2007-09-14 20:53:59',3310504478,1),(51397783,425562919,16873121,427965,1,'2007-09-14 20:53:59',3310504478,1),(51397786,425562034,16874838,427965,1,'2007-09-14 20:53:59',3310504478,1),(51397788,425560769,16875525,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397790,425559125,16874838,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397791,425556723,16874237,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397794,425555205,16873036,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397795,425553688,16873036,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397796,425549642,16875525,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397798,425547618,16876812,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397799,425547113,16878100,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397802,425546923,16880503,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397803,425546101,16883164,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397806,425544584,16886254,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397808,425542687,16887026,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397810,425539968,16889343,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397813,425538956,16891060,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397814,425538514,16893892,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397815,425537882,16896210,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397816,425536870,16897755,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397818,425535795,16898527,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397819,425534847,16898098,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397821,425534720,16896811,427965,1,'2007-09-14 20:53:59',3310504475,1),(51397822,425533961,16895867,427965,1,'2007-09-14 20:53:59',3310504474,1),(51397824,425532950,16895094,427965,1,'2007-09-14 20:53:59',3310504474,1),(51397825,425531622,16895867,427965,1,'2007-09-14 20:53:59',3310504474,1),(51397826,425529346,16898527,427965,1,'2007-09-14 20:53:59',3310504474,1),(51397828,425528145,16902561,427965,1,'2007-09-14 20:53:59',3310504474,1),(51397829,425526754,16907454,427965,1,'2007-09-14 20:53:59',3310504474,1),(51397830,425524161,16912003,427965,1,'2007-09-14 20:53:59',3310504474,1),(51397831,425522264,16913719,427965,1,'2007-09-14 20:53:59',3310504474,1),(51397832,425521379,16915522,427965,1,'2007-09-14 20:53:59',3310504474,1),(51397834,425521379,16918612,427965,1,'2007-09-14 20:53:59',3310504474,1),(51397835,425520368,16920157,427965,1,'2007-09-14 20:53:59',3310504496,1),(51397837,425518534,16923247,427965,1,'2007-09-14 20:53:59',3310504496,1),(51398048,425631260,16788235,427965,1,'2007-09-14 20:53:59',3310504514,1),(51398049,425628415,16789866,427965,1,'2007-09-14 20:53:59',3310504514,1),(51398053,425626203,16793213,427965,1,'2007-09-14 20:53:59',3310504514,1),(51398054,425623990,16794071,427965,1,'2007-09-14 20:53:59',3310504514,1),(51398057,425622663,16796045,427965,1,'2007-09-14 20:53:50',3310504514,1),(51398058,425621145,16800080,427965,1,'2007-09-14 20:53:59',3310504514,1),(51398059,425619312,16802139,427965,1,'2007-09-14 20:53:59',3310504514,1),(51398060,425617289,16801796,427965,1,'2007-09-14 20:53:59',3310504514,1),(51398063,425615835,16802912,427965,1,'2007-09-14 20:53:59',3310504471,1),(51398065,425614444,16805916,427965,1,'2007-09-14 20:53:59',3310504471,1),(51398068,425611979,16807633,427965,1,'2007-09-14 20:53:59',3310504471,1),(51398069,425609323,16809178,427965,1,'2007-09-14 20:53:59',3310504471,1),(51398098,425639162,16782055,427965,1,'2007-09-14 20:53:59',3310504514,1),(51398099,425635622,16784802,427965,1,'2007-09-14 20:53:59',3310504514,1),(51399265,425055276,15279589,305941,1,'2009-02-09 21:25:15',3310491437,2),(51399266,425057238,15287914,305941,1,'2009-02-09 21:25:14',3310491437,2),(51399269,425058503,15291863,305941,1,'2009-02-09 21:25:14',3310491437,2),(51399270,425064768,15301047,305941,1,'2009-02-09 21:25:14',3310491437,2),(51399272,425068248,15306025,305941,1,'2009-02-09 21:25:14',3310491448,2),(51399273,425069070,15307226,305941,1,'2009-02-09 21:25:14',3310491448,2),(51399275,425072614,15316668,305941,1,'2009-02-09 21:25:14',3310491448,2),(51399277,425073373,15318299,305941,1,'2009-02-09 21:25:14',3310491448,2),(51399278,425082801,15326624,305941,1,'2009-02-09 21:25:14',3310491450,2),(51399285,425082862,15292505,443527,1,'2008-05-14 12:03:55',3310491448,2),(51399289,425062971,15310660,443749,1,'2007-09-16 21:50:10',3310491437,1),(51399292,425066578,15319296,443749,1,'2007-09-16 21:50:09',3310491437,1),(51399296,425073430,15281647,443527,1,'2008-05-14 12:03:55',3310491448,2),(51399299,425062047,15296841,305941,1,'2009-02-09 21:25:14',3310491437,2),(51399303,425073942,15300102,427965,1,'2007-09-14 21:15:41',3310491448,1),(51399304,425070336,15294352,427965,1,'2007-09-14 21:15:42',3310491448,1),(51399306,425067172,15289889,427965,1,'2007-09-14 21:15:40',3310491437,1),(51399308,425064261,15285168,427965,1,'2007-09-14 21:15:39',3310491437,1),(51399309,425058820,15292378,305941,1,'2009-02-09 21:25:14',3310491437,2),(51399320,425074408,15341741,104780,1,'2009-02-04 00:34:16',3310491450,5),(51399321,425065613,15341655,104780,1,'2009-02-04 00:34:16',3310491439,6),(51399325,425079574,15327053,427965,1,'2007-09-14 20:57:20',3310491450,1),(51399326,425075967,15325337,427965,1,'2007-09-14 20:57:20',3310491448,1),(51399327,425074132,15324307,427965,1,'2007-09-14 20:57:20',3310491448,1),(51399329,425072361,15322247,427965,1,'2007-09-14 20:57:20',3310491448,1),(51399335,425077233,15316582,427965,1,'2007-09-14 21:15:39',3310491448,1),(51399337,425075461,15312205,427965,1,'2007-09-14 21:15:39',3310491448,1),(51399339,425074702,15301476,427965,1,'2007-09-14 21:15:39',3310491448,1),(51399365,425070248,15326367,305941,1,'2009-02-09 21:23:21',3310491450,2),(51399367,425079913,15341311,305941,1,'2009-02-09 21:23:21',3310491450,6),(51399377,425077313,15285484,443527,1,'2008-05-14 12:03:55',3310491448,2),(51399380,425067235,15298214,427965,1,'2007-09-14 20:57:18',3310491437,1),(51399381,425058194,15307642,840745,1,'2009-01-26 19:28:31',3310491437,2),(51399398,425073942,15324049,427965,1,'2007-09-14 20:57:20',3310491448,1),(51399406,425081978,15315638,305941,1,'2009-02-09 21:17:59',3310491448,5),(51399409,425075588,15320273,305941,1,'2009-02-09 21:25:14',3310491448,2),(51399411,425071450,15328169,305941,1,'2009-02-09 21:23:21',3310491450,2),(51399601,425067727,15320781,3916355,1,'2010-02-19 17:34:16',3310491448,4),(51399602,425072804,15317269,305941,1,'2009-02-09 21:25:14',3310491448,3),(51400247,425088873,15288745,437032,1,'2008-05-13 21:23:13',3310491448,2),(51400250,425088116,15291348,427965,1,'2007-09-14 21:14:43',3310491448,1);
INSERT INTO `current_nodes` VALUES (51400253,425083498,15303690,305941,1,'2009-02-09 21:17:59',3310491448,6),(51400254,425082485,15308497,305941,1,'2009-02-09 21:17:59',3310491448,6),(51400256,425082737,15324478,305941,1,'2009-02-09 21:17:59',3310491448,5),(51400257,425083686,15334606,305941,1,'2009-02-09 21:17:59',3310491450,5),(51400259,425084889,15348683,305941,1,'2009-02-09 21:19:42',3310491450,5),(51400263,425086407,15368338,305941,1,'2009-02-09 21:20:12',3310491450,6),(51400264,425086724,15380011,305941,1,'2009-02-09 21:20:12',3310491450,2),(51400267,425086903,15397735,305941,1,'2009-02-09 21:21:16',3310491536,8),(51400269,425086966,15404516,305941,1,'2009-02-09 21:21:16',3310491536,5),(51400270,425088168,15417133,305941,1,'2009-02-09 21:21:16',3310491536,5),(51400272,425088991,15424600,305941,1,'2009-02-09 21:21:16',3310491536,6),(51400273,425090003,15433612,305941,1,'2009-02-09 21:20:30',3310491536,3),(51400276,425091205,15439534,305941,1,'2009-02-09 21:20:30',3310491538,3),(51400277,425091395,15442281,305941,1,'2009-02-09 21:20:30',3310491538,3),(51400280,425092534,15448633,305941,1,'2009-02-09 21:20:30',3310491538,3),(51400281,425094749,15455756,305941,1,'2009-02-09 21:20:30',3310491538,3),(51400283,425096710,15460477,188228,1,'2008-06-16 18:48:34',3310491539,2),(51400284,425097532,15462537,188228,1,'2008-06-16 18:48:34',3310491539,2),(51400285,425099620,15464425,188228,1,'2008-06-16 18:48:34',3310491539,2),(51400286,425102468,15464254,188228,1,'2008-06-16 18:48:34',3310491539,2),(51400290,425105831,15464297,427965,1,'2007-09-14 21:14:43',3310491539,1),(51400293,425109997,15465713,188228,1,'2008-06-16 18:49:46',3310491539,2),(51400296,425111705,15468717,188228,1,'2008-06-16 18:49:46',3310491539,2),(51400299,425113603,15477901,188228,1,'2008-06-16 18:49:46',3310491539,2),(51400301,425115818,15487686,188228,1,'2008-06-16 18:51:31',3310491539,2),(51400303,425117526,15495410,188228,1,'2008-06-16 18:51:31',3310491545,2),(51400305,425119614,15500131,188228,1,'2008-06-16 18:51:31',3310491545,2),(51400766,425098711,15387955,427965,1,'2007-09-14 22:14:55',3310491537,1),(51400768,425086713,15387264,305941,1,'2009-02-09 21:20:13',3310491536,3),(51400770,425081345,15387650,305941,1,'2009-02-09 21:22:13',3310491536,2),(51400772,425081282,15384731,305941,1,'2009-02-09 21:22:13',3310491536,2),(51400773,425081156,15381985,305941,1,'2009-02-09 21:22:13',3310491536,2),(51400777,425080776,15377779,305941,1,'2009-02-09 21:22:14',3310491450,2),(51400778,425079257,15374689,305941,1,'2009-02-09 21:22:14',3310491450,2),(51400779,425078118,15372114,305941,1,'2009-02-09 21:22:14',3310491450,2),(51400782,425077549,15368939,305941,1,'2009-02-09 21:22:14',3310491450,2),(51400784,425076853,15362759,305941,1,'2009-02-09 21:22:14',3310491450,2),(51400786,425076726,15358982,305941,1,'2009-02-09 21:22:14',3310491450,2),(51400787,425076542,15355927,305941,1,'2009-02-09 21:22:14',3310491450,3),(51400789,425076410,15353918,305941,1,'2009-02-09 21:22:14',3310491450,2),(51400791,425075081,15350142,305941,1,'2009-02-09 21:22:14',3310491450,2),(51400793,425072550,15344219,305941,1,'2009-02-09 21:22:14',3310491450,2),(51400794,425071245,15341826,305941,1,'2009-02-09 21:22:14',3310491450,6),(51400863,425072107,15374088,820251,1,'2009-03-16 23:49:41',3310491450,2),(51400866,425072361,15376749,820251,1,'2009-03-16 23:49:41',3310491450,2),(51400868,425072930,15377951,820251,1,'2009-03-16 23:49:41',3310491450,2),(51400869,425074259,15378809,820251,1,'2009-03-16 23:49:42',3310491450,2),(51400870,425080966,15378981,820251,1,'2009-03-16 23:50:05',3310491450,5),(51400871,425086724,15379238,820251,1,'2009-03-16 23:50:06',3310491450,4),(51400970,425070009,15370519,820251,1,'2009-03-16 23:49:40',3310491450,3),(51400971,425071665,15372372,820251,1,'2009-03-16 23:49:40',3310491450,2),(51401220,425081662,15417433,305941,1,'2009-02-09 21:22:13',3310491536,2),(51401223,425081662,15413914,305941,1,'2009-02-09 21:22:13',3310491536,2),(51401224,425082041,15409193,305941,1,'2009-02-09 21:22:13',3310491536,3),(51401226,425082801,15402155,305941,1,'2009-02-09 21:22:13',3310491536,2),(51401227,425082737,15398379,305941,1,'2009-02-09 21:22:13',3310491536,2),(51401228,425081598,15392113,305941,1,'2009-02-09 21:22:13',3310491536,2),(51401444,425118043,15406189,427965,1,'2007-09-14 21:07:01',3310491537,1),(51401446,425116840,15405417,427965,1,'2007-09-14 21:07:01',3310491537,1),(51401447,425114689,15407133,427965,1,'2007-09-14 21:07:01',3310491537,1),(51401449,425110577,15411511,427965,1,'2007-09-14 21:07:01',3310491537,1),(51401451,425108995,15412712,427965,1,'2007-09-14 21:07:01',3310491537,1),(51401452,425106844,15412712,427965,1,'2007-09-14 21:07:01',3310491537,1),(51401454,425103997,15410824,495907,1,'2008-07-15 17:43:20',3310491537,2),(51401456,425097163,15407820,305941,1,'2009-02-09 21:21:41',3310491537,2),(51401457,425093114,15407734,305941,1,'2009-02-09 21:21:41',3310491536,2),(51401461,425087029,15408550,305941,1,'2009-02-09 21:21:42',3310491536,6),(51402983,425026296,15134449,427965,1,'2007-09-14 21:03:11',3310491406,1),(51402986,425034775,15143719,427965,1,'2007-09-14 21:03:11',3310491406,1),(51402987,425047683,15159083,427965,1,'2007-09-14 21:03:11',3310491407,1),(51402989,425050657,15162430,427965,1,'2007-09-14 21:03:11',3310491429,1),(51402991,425053125,15166722,427965,1,'2007-09-14 21:03:11',3310491429,1),(51402994,425054074,15170155,427965,1,'2007-09-14 21:03:11',3310491429,1),(51402995,425054644,15175390,427965,1,'2007-09-14 21:03:11',3310491429,1),(51402997,425054391,15179081,427965,1,'2007-09-14 21:03:11',3310491429,1),(51403000,425054137,15180283,427965,1,'2007-09-14 21:03:11',3310491429,1),(51403223,425054783,15183030,3916355,1,'2010-02-19 17:32:02',3310491429,2),(51403224,425054605,15182206,3916355,1,'2010-02-19 17:32:03',3310491429,2),(51403225,425054014,15181631,3916355,1,'2010-02-19 17:32:03',3310491429,2),(51403226,425053319,15181700,3916355,1,'2010-02-19 17:32:03',3310491429,2),(51403228,425052823,15182315,3916355,1,'2010-02-19 17:32:03',3310491429,2),(51403229,425052737,15183403,3916355,1,'2010-02-19 17:32:04',3310491429,2),(51403231,425053054,15184070,3916355,1,'2010-02-19 17:32:04',3310491429,2),(51403232,425053932,15184392,3916355,1,'2010-02-19 17:32:04',3310491429,2),(51403234,425054653,15183684,3916355,1,'2010-02-19 17:32:04',3310491429,2),(51403654,425051100,15184918,427965,1,'2007-09-14 21:03:30',3310491429,1),(51403656,425048988,15186761,305941,1,'2009-02-09 21:34:26',3310491429,2),(51403657,425046924,15187493,427965,1,'2007-09-14 21:03:30',3310491429,1),(51403659,425043760,15188780,427965,1,'2007-09-14 21:03:30',3310491429,1),(51403661,425040976,15190239,427965,1,'2007-09-14 21:03:30',3310491429,1),(51403663,425037527,15192491,56648,1,'2008-06-05 20:30:42',3310491428,2),(51403665,425036530,15193235,3916355,1,'2010-02-19 17:31:53',3310491428,5),(51403850,425061477,15215130,305941,1,'2009-02-09 21:34:27',3310491429,2),(51403851,425059896,15211783,305941,1,'2009-02-09 21:34:27',3310491429,2),(51403852,425057934,15206375,305941,1,'2009-02-09 21:34:28',3310491429,2),(51403854,425056479,15202255,305941,1,'2009-02-09 21:34:28',3310491429,2),(51403857,425055150,15197277,305941,1,'2009-02-09 21:34:28',3310491429,2),(51403858,425054391,15192900,305941,1,'2009-02-09 21:34:28',3310491429,2),(51403859,425053568,15187664,305941,1,'2009-02-09 21:34:28',3310491429,2),(51403861,425053478,15184371,3916355,1,'2010-02-19 17:32:04',3310491429,3),(51404061,425062983,15216630,3916355,1,'2010-02-19 17:31:58',3310491431,2),(51404062,425063152,15217362,3916355,1,'2010-02-19 17:31:58',3310491431,2),(51404063,425062915,15218273,3916355,1,'2010-02-19 17:32:00',3310491431,2),(51404066,425062114,15218764,3916355,1,'2010-02-19 17:32:00',3310491431,2),(51404067,425061364,15218276,3916355,1,'2010-02-19 17:31:59',3310491431,2),(51404069,425061140,15217155,3916355,1,'2010-02-19 17:31:59',3310491431,2),(51404071,425061306,15216606,3916355,1,'2010-02-19 17:31:59',3310491431,2),(51404073,425061902,15216053,3916355,1,'2010-02-19 17:31:58',3310491429,3),(51404074,425062566,15216143,3916355,1,'2010-02-19 17:31:58',3310491429,2),(51404272,425049139,15220795,427965,1,'2007-09-14 21:04:29',3310491431,1),(51404274,425061173,15217807,3916355,1,'2010-02-19 17:31:59',3310491431,2),(51404282,425045975,15221396,56648,1,'2008-06-05 20:36:40',3310491431,2),(51404481,425070526,15254183,427965,1,'2007-09-14 21:14:20',3310491442,1),(51404482,425069893,15249720,427965,1,'2007-09-14 21:14:20',3310491442,1),(51404483,425068501,15244656,427965,1,'2007-09-14 21:14:20',3310491442,1),(51404484,425066483,15233915,443749,1,'2007-09-16 21:50:02',3310491431,1),(51404486,425062459,15218694,3916355,1,'2010-02-19 17:32:00',3310491431,2),(51404632,425072361,15273409,427965,1,'2007-09-14 21:14:20',3310491448,1),(51404633,425071475,15263539,427965,1,'2007-09-14 21:14:20',3310491442,1),(51404642,425072867,15280190,427965,1,'2007-09-14 21:06:19',3310491448,1),(51404720,425088873,15290461,820251,1,'2009-03-16 23:53:41',3310491448,3),(51404721,425086534,15287228,427965,1,'2007-09-14 21:05:05',3310491448,1),(51404723,425083244,15283108,427965,1,'2007-09-14 21:14:20',3310491448,1),(51404725,425079637,15279761,427965,1,'2007-09-14 21:14:20',3310491448,1),(51404726,425076663,15277271,427965,1,'2007-09-14 21:14:20',3310491448,1),(51404727,425073310,15275040,427965,1,'2007-09-14 21:14:20',3310491448,1),(51404882,425098102,15335079,188228,1,'2008-06-16 18:36:35',3310491451,5),(51404883,425096972,15330973,437032,1,'2008-05-13 21:27:14',3310491451,3),(51404884,425096529,15326510,437032,1,'2008-05-13 21:13:38',3310491451,3),(51404886,425094125,15317069,437032,1,'2008-05-13 21:13:33',3310491448,2),(51404887,425089063,15304366,437032,1,'2008-05-13 21:20:03',3310491448,2),(51404888,425085648,15297184,427965,1,'2007-09-14 21:14:43',3310491448,1),(51404889,425082484,15291519,427965,1,'2007-09-14 21:06:19',3310491448,1),(51404891,425078308,15286455,427965,1,'2007-09-14 21:06:19',3310491448,1),(51404893,425073816,15282250,427965,1,'2007-09-14 21:06:19',3310491448,1),(51404947,425087609,15308171,427965,1,'2007-09-14 21:05:39',3310491448,1),(51404949,425089887,15306454,427965,1,'2007-09-14 21:06:19',3310491448,1),(51405087,425082231,15318299,820251,1,'2009-03-16 23:48:44',3310491448,7),(51405091,425093809,15316210,820251,1,'2009-03-16 23:48:45',3310491448,4),(51405261,425098029,15337080,3916355,1,'2010-02-19 17:33:03',3310491451,8),(51405263,425098115,15338284,3916355,1,'2010-02-19 17:33:03',3310491451,7),(51405265,425098719,15339308,3916355,1,'2010-02-19 17:33:03',3310491451,4),(51405266,425099137,15339584,3916355,1,'2010-02-19 17:33:03',3310491451,5),(51405268,425100920,15338838,3916355,1,'2010-02-19 17:33:04',3310491451,4),(51405269,425101263,15337344,3916355,1,'2010-02-19 17:33:04',3310491451,4),(51405270,425101213,15336918,3916355,1,'2010-02-19 17:33:04',3310491451,5),(51405271,425100195,15335397,3916355,1,'2010-02-19 17:33:05',3310491451,4),(51405273,425099068,15335400,3916355,1,'2010-02-19 17:33:05',3310491451,4),(51405344,425098322,15336159,3916355,1,'2010-02-19 17:33:03',3310491451,6),(51405527,425122535,15354433,427965,1,'2007-09-14 21:14:20',3310491454,1),(51405528,425120573,15352717,427965,1,'2007-09-14 21:14:20',3310491451,1),(51405530,425117789,15348940,427965,1,'2007-09-14 21:14:20',3310491451,1),(51405533,425113993,15343275,427965,1,'2007-09-14 21:14:20',3310491451,1),(51405534,425111716,15339928,427965,1,'2007-09-14 21:14:20',3310491451,1),(51405536,425108615,15337353,427965,1,'2007-09-14 21:14:20',3310491451,1),(51405537,425105072,15333147,427965,1,'2007-09-14 21:14:20',3310491451,1),(51405539,425102984,15329113,820251,1,'2009-03-16 23:53:39',3310491451,2),(51405540,425098808,15315724,820251,1,'2009-03-16 23:53:39',3310491449,2),(51405542,425096467,15309973,820251,1,'2009-03-16 23:53:39',3310491449,2),(51405543,425094379,15306797,820251,1,'2009-03-16 23:53:39',3310491448,2),(51405544,425092861,15303707,820251,1,'2009-03-16 23:53:40',3310491448,2),(51405547,425091721,15298701,820251,1,'2009-03-16 23:53:40',3310491448,3),(51405548,425090582,15293980,820251,1,'2009-03-16 23:53:41',3310491448,3),(51405550,425089949,15291663,820251,1,'2009-03-16 23:53:41',3310491448,3),(51405712,425127534,15356133,462438,1,'2008-07-11 13:01:05',3310491454,2),(51405715,425126521,15360854,462438,1,'2008-07-11 13:01:05',3310491454,2),(51405716,425124876,15364459,462438,1,'2008-07-11 13:01:05',3310491454,2),(51405720,425119624,15371170,427965,1,'2007-09-14 21:08:08',3310491451,1),(51405722,425115575,15380612,427965,1,'2007-09-14 21:06:57',3310491451,1),(51405723,425113740,15385676,427965,1,'2007-09-14 21:08:08',3310491537,1),(51405725,425112095,15394001,427965,1,'2007-09-14 21:08:08',3310491537,1),(51405727,425110703,15399151,427965,1,'2007-09-14 21:08:08',3310491537,1),(51405728,425107603,15407219,427965,1,'2007-09-14 21:08:08',3310491537,1),(51405729,425106021,15412283,427965,1,'2007-09-14 21:08:08',3310491537,1),(51406111,425127908,15353934,3916355,1,'2010-02-19 17:33:23',3310491454,2),(51406112,425127611,15352872,3916355,1,'2010-02-19 17:33:23',3310491454,2),(51406113,425126716,15352574,3916355,1,'2010-02-19 17:33:23',3310491454,2),(51406114,425126071,15353400,3916355,1,'2010-02-19 17:33:23',3310491454,2),(51406115,425126374,15354811,3916355,1,'2010-02-19 17:33:24',3310491454,2),(51406116,425127246,15355036,3916355,1,'2010-02-19 17:33:24',3310491454,3),(51406117,425127563,15354807,3916355,1,'2010-02-19 17:33:24',3310491454,2),(51406244,425126062,15354183,3916355,1,'2010-02-19 17:33:23',3310491454,2),(51406783,425166695,15287855,432736,1,'2007-09-15 01:38:56',3310491453,1),(51406784,425165619,15291004,427965,1,'2007-09-14 21:36:14',3310491453,1),(51406785,425163342,15294609,427965,1,'2007-09-14 21:36:14',3310491453,1),(51406787,425161127,15298300,427965,1,'2007-09-14 21:36:14',3310491453,1),(51406789,425158723,15303536,427965,1,'2007-09-14 21:36:14',3310491453,1),(51406790,425156509,15307141,427965,1,'2007-09-14 21:36:14',3310491453,1),(51406791,425151321,15313749,427965,1,'2007-09-14 21:36:14',3310491453,1),(51406792,425146703,15318899,427965,1,'2007-09-14 21:36:14',3310491452,1),(51406793,425143793,15321560,427965,1,'2007-09-14 21:36:14',3310491452,1),(51406795,425141452,15323706,427965,1,'2007-09-14 21:36:14',3310491452,1),(51406797,425139427,15326967,427965,1,'2007-09-14 21:36:14',3310491454,1),(51406798,425138099,15330229,427965,1,'2007-09-14 21:36:14',3310491454,1),(51406800,425137213,15334177,427965,1,'2007-09-14 21:36:14',3310491454,1),(51406803,425136137,15338640,427965,1,'2007-09-14 21:36:14',3310491454,1),(51406805,425134682,15340100,427965,1,'2007-09-14 21:36:14',3310491454,1),(51406807,425132088,15342159,427965,1,'2007-09-14 21:08:51',3310491454,1),(51406808,425130253,15345249,427965,1,'2007-09-14 21:36:14',3310491454,1),(51406810,425127878,15350618,427965,1,'2007-09-14 22:12:31',3310491454,1),(51406811,425127268,15352595,3916355,1,'2010-02-19 17:33:23',3310491454,2),(51407218,425177702,15375290,427965,1,'2007-09-14 21:12:21',3310491498,1),(51407219,425174476,15382500,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407220,425172199,15388937,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407222,425169668,15393915,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407223,425168656,15398293,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407226,425167960,15400524,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407227,425167011,15402584,427965,1,'2007-09-14 21:09:37',3310491541,1),(51407228,425166062,15404215,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407231,425163974,15407047,427965,1,'2007-09-14 21:13:38',3310491541,1),(51407232,425161254,15410309,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407234,425159672,15413141,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407235,425158786,15414515,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407236,425158154,15414601,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407238,425157395,15413914,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407240,425157142,15412712,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407243,425157268,15411940,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407245,425158280,15410223,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407247,425159925,15407477,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407708,425161317,15404988,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407709,425161823,15401468,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407712,425162203,15396319,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407714,425162140,15392885,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407715,425162329,15388766,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407716,425162835,15385332,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407718,425164037,15380011,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407719,425165493,15374088,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407720,425166758,15370226,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407723,425167137,15369024,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407725,425166884,15367737,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407726,425166252,15367308,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407728,425165682,15367308,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407729,425164986,15367737,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407731,425163468,15371428,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407733,425161191,15377608,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407736,425159166,15381985,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407738,425157648,15384131,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407739,425156635,15384474,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407740,425155750,15384216,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407742,425155307,15383358,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407743,425155370,15381985,427965,1,'2007-09-14 21:12:21',3310491541,1),(51407744,425156382,15379753,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407746,425159103,15373230,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407747,425161697,15365591,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407749,425162582,15362330,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407751,425163342,15359669,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407753,425164227,15353232,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407754,425164227,15350485,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407756,425165366,15346794,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407759,425167201,15342503,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407760,425168150,15339241,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407764,425168592,15336495,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407765,425169415,15332804,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407766,425170743,15328770,427965,1,'2007-09-14 21:12:21',3310491455,1),(51407767,425172578,15324135,427965,1,'2007-09-14 21:12:21',3310491453,1),(51407769,425173970,15320788,427965,1,'2007-09-14 21:12:21',3310491453,1),(51407773,425174349,15318985,427965,1,'2007-09-14 21:12:21',3310491453,1),(51407774,425174349,15316668,427965,1,'2007-09-14 21:12:21',3310491453,1),(51407775,425174856,15312119,427965,1,'2007-09-14 21:12:21',3310491453,1),(51407778,425174919,15310059,427965,1,'2007-09-14 21:12:21',3310491453,1),(51407779,425174729,15309115,427965,1,'2007-09-14 21:12:21',3310491453,1),(51407781,425173654,15309115,427965,1,'2007-09-14 21:12:21',3310491453,1),(51407782,425173084,15309801,427965,1,'2007-09-14 21:12:21',3310491453,1),(51407784,425172578,15311518,427965,1,'2007-09-14 21:12:21',3310491453,1),(51407785,425171566,15318556,427965,1,'2007-09-14 21:12:21',3310491453,1),(51407786,425170743,15319328,427965,1,'2007-09-14 21:12:21',3310491453,1),(51407787,425169794,15319500,427965,1,'2007-09-14 21:12:21',3310491453,1),(51407789,425168909,15318728,427965,1,'2007-09-14 21:10:27',3310491453,1),(51407790,425168592,15317269,427965,1,'2007-09-14 21:12:21',3310491453,1),(51407791,425169225,15315037,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408269,425170427,15311604,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408270,425171566,15307827,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408271,425172768,15303364,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408274,425173780,15299931,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408275,425174729,15293579,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408278,425174919,15289116,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408279,425174856,15286026,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408280,425174666,15284825,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408281,425173780,15284825,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408282,425172831,15285855,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408283,425172515,15288687,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408284,425172325,15292721,427965,1,'2007-09-14 21:11:10',3310491453,1),(51408285,425169035,15300274,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408286,425165872,15304394,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408287,425164227,15308943,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408288,425162709,15311089,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408289,425160558,15313063,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408290,425150562,15326452,427965,1,'2007-09-14 21:12:21',3310491455,1),(51408292,425147652,15331001,427965,1,'2007-09-14 21:12:21',3310491454,1),(51408294,425146956,15333834,427965,1,'2007-09-14 21:12:21',3310491454,1),(51408296,425145880,15334263,427965,1,'2007-09-14 21:12:21',3310491454,1),(51408299,425145121,15333319,427965,1,'2007-09-14 21:12:21',3310491454,1),(51408300,425145121,15332203,427965,1,'2007-09-14 21:12:21',3310491454,1),(51408302,425145627,15329371,427965,1,'2007-09-14 21:12:21',3310491454,1),(51408305,425146766,15325165,427965,1,'2007-09-14 21:12:21',3310491452,1),(51408306,425149676,15320873,427965,1,'2007-09-14 21:12:21',3310491452,1),(51408307,425152460,15316410,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408310,425152776,15315294,427965,1,'2007-09-14 21:12:21',3310491453,1),(51408311,425151701,15313063,427965,1,'2007-09-14 21:36:14',3310491453,1),(51408485,425177702,15351086,427965,1,'2007-09-14 21:13:38',3310491498,1),(51408486,425176690,15357866,427965,1,'2007-09-14 21:13:38',3310491455,1),(51408490,425175362,15363531,427965,1,'2007-09-14 21:13:38',3310491455,1),(51408491,425173211,15370140,427965,1,'2007-09-14 21:13:38',3310491455,1),(51408492,425170237,15377865,427965,1,'2007-09-14 21:13:38',3310491455,1),(51408495,425168972,15382672,427965,1,'2007-09-14 21:13:38',3310491541,1),(51408496,425167454,15388165,427965,1,'2007-09-14 21:13:38',3310491541,1),(51408497,425166062,15392542,427965,1,'2007-09-14 21:13:38',3310491541,1),(51408498,425165809,15399494,427965,1,'2007-09-14 21:13:38',3310491541,1),(51408499,425164797,15404558,427965,1,'2007-09-14 21:13:38',3310491541,1),(51408872,425143729,15488415,427965,1,'2007-09-14 21:12:15',3310491542,1),(51408873,425145627,15486613,427965,1,'2007-09-14 21:12:15',3310491542,1),(51408874,425148348,15485153,427965,1,'2007-09-14 21:12:15',3310491542,1),(51408875,425149993,15484381,427965,1,'2007-09-14 21:12:15',3310491543,1),(51408876,425151321,15481634,427965,1,'2007-09-14 21:12:15',3310491543,1),(51408879,425152586,15477171,427965,1,'2007-09-14 21:12:15',3310491543,1),(51408880,425153789,15473051,427965,1,'2007-09-14 21:12:15',3310491543,1),(51408883,425154105,15470305,427965,1,'2007-09-14 21:12:15',3310491543,1),(51408884,425153725,15468245,427965,1,'2007-09-14 21:12:15',3310491543,1),(51408885,425154801,15464297,427965,1,'2007-09-14 21:12:15',3310491543,1),(51408887,425155686,15459490,427965,1,'2007-09-14 21:12:15',3310491543,1),(51408889,425156193,15454512,427965,1,'2007-09-14 21:12:15',3310491543,1),(51408891,425155497,15447216,427965,1,'2007-09-14 21:12:15',3310491543,1),(51408892,425154105,15443869,427965,1,'2007-09-14 21:12:15',3310491543,1),(51408893,425153472,15441637,427965,1,'2007-09-14 21:12:15',3310491543,1),(51408896,425153472,15439062,427965,1,'2007-09-14 21:12:15',3310491543,1),(51408897,425152840,15435114,427965,1,'2007-09-14 21:12:15',3310491541,1),(51408898,425152713,15431853,427965,1,'2007-09-14 21:12:15',3310491541,1),(51408900,425153346,15427904,427965,1,'2007-09-14 21:12:15',3310491541,1),(51408902,425153852,15422583,427965,1,'2007-09-14 21:12:15',3310491541,1),(51408904,425153725,15420008,427965,1,'2007-09-14 21:12:15',3310491541,1),(51408905,425153725,15417519,427965,1,'2007-09-14 21:12:15',3310491541,1),(51408906,425154548,15413141,427965,1,'2007-09-14 21:12:15',3310491541,1),(51408909,425154738,15409279,427965,1,'2007-09-14 21:12:15',3310491541,1),(51408910,425155370,15403614,427965,1,'2007-09-14 21:12:15',3310491541,1),(51408911,425156446,15400782,427965,1,'2007-09-14 21:12:15',3310491541,1),(51408912,425158027,15398121,427965,1,'2007-09-14 21:12:15',3310491541,1),(51408913,425158976,15395546,427965,1,'2007-09-14 21:12:15',3310491541,1),(51408914,425159672,15391340,427965,1,'2007-09-14 21:12:15',3310491541,1),(51408915,425160621,15387993,427965,1,'2007-09-14 21:12:15',3310491541,1),(51408916,425162076,15385161,427965,1,'2007-09-14 21:12:15',3310491541,1),(51408917,425163405,15383444,427965,1,'2007-09-14 21:12:15',3310491541,1),(51409632,425144805,15428076,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409633,425144425,15440779,427965,1,'2007-09-14 21:13:34',3310491542,1),(51409634,425144172,15443096,427965,1,'2007-09-14 21:13:34',3310491542,1),(51409635,425143729,15444212,427965,1,'2007-09-14 21:13:34',3310491542,1),(51409636,425142970,15444384,427965,1,'2007-09-14 21:13:34',3310491542,1),(51409638,425142148,15443354,427965,1,'2007-09-14 21:13:34',3310491542,1),(51409639,425141515,15440521,427965,1,'2007-09-14 21:13:34',3310491542,1),(51409640,425140946,15436487,427965,1,'2007-09-14 21:13:34',3310491542,1),(51409641,425141452,15415888,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409642,425141515,15407562,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409644,425141641,15404988,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409645,425141009,15403614,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409646,425140313,15403357,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409647,425139427,15404473,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409648,425138288,15408163,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409649,425136770,15414000,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409651,425135884,15417004,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409652,425134935,15419579,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409653,425133986,15420523,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409655,425132721,15420952,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409656,425132025,15421982,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409657,425132088,15424729,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409658,425132341,15430737,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409659,425132215,15432453,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409660,425131076,15434342,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409662,425130000,15434857,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409663,425128419,15434170,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409664,425124116,15433054,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409665,425123167,15431938,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409666,425122788,15429793,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409667,425123041,15425844,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409668,425123673,15420351,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409669,425123800,15417175,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409670,425123484,15415030,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409671,425123357,15412455,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409672,425123927,15400181,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409673,425124749,15398636,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409674,425125192,15396834,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409675,425125382,15394259,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409676,425125318,15392199,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409677,425124433,15391426,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409678,425123484,15391770,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409679,425122471,15394345,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409680,425122471,15394688,427965,1,'2007-09-14 21:13:34',3310491540,1),(51409972,425100136,15339582,3916355,1,'2010-02-19 17:33:04',3310491451,5),(51409974,425101401,15341187,437032,1,'2008-05-13 21:26:45',3310491451,2),(51409975,425107034,15348666,462438,1,'2008-07-11 13:00:24',3310491451,2),(51409976,425109882,15352614,462438,1,'2008-07-11 13:00:24',3310491451,2),(51409978,425111969,15355635,427965,1,'2007-09-14 21:14:09',3310491451,1),(51409979,425113550,15358982,427965,1,'2007-09-14 21:14:09',3310491451,1),(51409981,425118043,15362742,462438,1,'2008-07-11 13:01:48',3310491451,2),(51409983,425120321,15364716,462438,1,'2008-07-11 13:09:45',3310491451,3),(51410094,425104503,15332117,820251,1,'2009-03-16 23:53:39',3310491451,2),(51410095,425103807,15332890,427965,1,'2007-09-14 21:14:24',3310491451,1),(51410232,425076537,15355635,305941,1,'2009-02-09 21:22:14',3310491450,2),(51410233,425085268,15354605,305941,1,'2009-02-09 21:19:42',3310491450,5),(51410282,425077043,15364733,305941,1,'2009-02-09 21:22:14',3310491450,2),(51410286,425086028,15363703,305941,1,'2009-02-09 21:19:42',3310491450,5),(51410490,425075208,15308600,305941,1,'2009-02-09 21:27:05',3310491448,2),(51410491,425070462,15311003,305941,1,'2009-02-09 21:27:05',3310491448,3),(51410493,425064553,15314436,305941,1,'2009-02-09 21:27:05',3310491437,2),(51410494,425063439,15315209,305941,1,'2009-02-09 21:27:05',3310491437,2),(51410495,425060838,15317037,3916355,1,'2010-02-19 17:34:20',3310491437,4),(51410786,425057428,15279363,443749,1,'2007-09-16 21:49:53',3310491437,1),(51410787,425059073,15285340,427965,1,'2007-09-14 21:15:39',3310491437,1),(51410788,425061414,15289202,427965,1,'2007-09-14 21:15:39',3310491437,1),(51410790,425064515,15293579,427965,1,'2007-09-14 21:15:39',3310491437,1),(51410791,425067488,15298128,427965,1,'2007-09-14 21:15:39',3310491437,1),(51410792,425071158,15303192,427965,1,'2007-09-14 21:15:39',3310491448,1),(51411056,425069513,15329113,427965,1,'2007-09-14 21:16:04',3310491450,1),(51411057,425066729,15329971,427965,1,'2007-09-14 21:16:04',3310491439,1),(51411059,425069513,15340529,427965,1,'2007-09-14 21:16:04',3310491450,1),(51411060,425070399,15341473,427965,1,'2007-09-14 21:16:04',3310491450,1),(51411061,425075081,15341215,427965,1,'2007-09-14 21:16:04',3310491450,1),(51411062,425076600,15339670,427965,1,'2007-09-14 21:16:04',3310491450,1),(51412082,424997756,15233755,427965,1,'2007-09-14 21:22:31',3310491427,1),(51412083,424995858,15232554,427965,1,'2007-09-14 21:22:31',3310491427,1),(51412086,424994466,15232554,427965,1,'2007-09-14 21:22:31',3310491427,1),(51412087,424993580,15233498,427965,1,'2007-09-14 21:22:31',3310491427,1),(51412090,424993390,15235386,427965,1,'2007-09-14 21:22:31',3310491427,1),(51412091,424993390,15237360,427965,1,'2007-09-14 21:22:31',3310491427,1),(51412092,424993010,15239334,427965,1,'2007-09-14 21:22:31',3310491427,1),(51412093,424992378,15240364,427965,1,'2007-09-14 21:22:31',3310491427,1),(51412094,424991365,15240708,427965,1,'2007-09-14 21:22:31',3310491427,1),(51412095,424990479,15240021,427965,1,'2007-09-14 21:22:31',3310491427,1),(51412096,424988517,15238304,427965,1,'2007-09-14 21:22:31',3310491427,1),(51412099,424985670,15235214,427965,1,'2007-09-14 21:22:31',3310491427,1),(51412100,424981999,15230923,427965,1,'2007-09-14 21:22:31',3310491426,1),(51412102,424980101,15227404,427965,1,'2007-09-14 21:22:31',3310491426,1),(51412103,424979278,15223198,427965,1,'2007-09-14 21:22:31',3310491426,1),(51412105,424979088,15218735,427965,1,'2007-09-14 21:22:31',3310491426,1),(51412106,424979848,15215903,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412107,424979784,15214100,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412109,424978582,15213928,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412110,424975987,15214529,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412112,424973836,15214529,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412115,424967760,15214443,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412116,424967001,15213156,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412117,424967001,15211697,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412119,424967887,15210238,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412121,424969343,15208950,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412122,424971494,15206461,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412123,424972886,15203886,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412125,424973709,15202170,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412126,424974785,15199080,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412128,424975291,15197020,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412131,424977253,15192471,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412132,424979278,15187664,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412134,424979721,15183973,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412136,424979088,15176335,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412137,424978329,15170670,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412138,424977949,15165520,427965,1,'2007-09-14 21:22:31',3310491424,1),(51412141,424978012,15160027,427965,1,'2007-09-14 21:22:31',3310491402,1),(51412142,424978392,15154791,427965,1,'2007-09-14 21:22:31',3310491402,1),(51412143,424978202,15151615,427965,1,'2007-09-14 21:22:31',3310491402,1),(51412144,424976683,15146980,427965,1,'2007-09-14 21:22:31',3310491402,1),(51412147,424974152,15139857,427965,1,'2007-09-14 21:22:31',3310491402,1),(51412148,424972254,15135822,427965,1,'2007-09-14 21:22:31',3310491402,1),(51412150,424970355,15133076,427965,1,'2007-09-14 21:22:31',3310491402,1),(51412152,424969975,15132046,427965,1,'2007-09-14 21:22:31',3310491402,1),(51412154,424970482,15131188,427965,1,'2007-09-14 21:22:31',3310491402,1),(51412157,424971811,15131617,427965,1,'2007-09-14 21:22:31',3310491402,1),(51412158,424979848,15143032,427965,1,'2007-09-14 21:22:31',3310491402,1),(51412159,424981113,15145436,427965,1,'2007-09-14 21:22:31',3310491402,1),(51412161,424982379,15148783,427965,1,'2007-09-14 21:22:31',3310491402,1),(51412163,424985227,15163374,427965,1,'2007-09-14 21:22:31',3310491425,1),(51412164,424987631,15168181,427965,1,'2007-09-14 21:22:31',3310491425,1),(51412167,424991112,15171871,427965,1,'2007-09-14 21:17:45',3310491425,1),(51412168,424996807,15174618,427965,1,'2007-09-14 21:22:31',3310491425,1),(51412169,425001110,15176249,427965,1,'2007-09-14 21:22:31',3310491425,1),(51412170,425007185,15177708,427965,1,'2007-09-14 21:22:31',3310491425,1),(51412171,425008894,15178395,427965,1,'2007-09-14 21:22:31',3310491425,1),(51412173,425009716,15179253,427965,1,'2007-09-14 21:22:31',3310491425,1),(51412175,425009590,15181141,427965,1,'2007-09-14 21:22:31',3310491425,1),(51412176,425009084,15186892,427965,1,'2007-09-14 21:17:45',3310491425,1),(51412179,425009147,15189552,427965,1,'2007-09-14 21:22:31',3310491425,1),(51412180,425009590,15190926,427965,1,'2007-09-14 21:22:31',3310491425,1),(51412181,425010539,15192986,427965,1,'2007-09-14 21:22:31',3310491425,1),(51412183,425011678,15195475,427965,1,'2007-09-14 21:22:31',3310491425,1),(51412185,425012691,15197191,427965,1,'2007-09-14 21:22:31',3310491428,1),(51412187,425014020,15198050,427965,1,'2007-09-14 21:22:31',3310491428,1),(51412189,425014969,15198822,427965,1,'2007-09-14 21:22:31',3310491428,1),(51412192,425019651,15198994,427965,1,'2007-09-14 21:22:31',3310491428,1),(51412195,425022499,15199509,427965,1,'2007-09-14 21:22:31',3310491428,1),(51412196,425024397,15200796,427965,1,'2007-09-14 21:22:31',3310491428,1),(51412197,425026043,15202255,427965,1,'2007-09-14 21:22:31',3310491428,1),(51412198,425027498,15202255,427965,1,'2007-09-14 21:22:31',3310491428,1),(51412199,425028827,15201140,427965,1,'2007-09-14 21:22:31',3310491428,1),(51412200,425031105,15197792,427965,1,'2007-09-14 21:22:31',3310491428,1),(51412201,425032370,15195990,427965,1,'2007-09-14 21:22:31',3310491428,1),(51412202,425033952,15194874,427965,1,'2007-09-14 21:22:31',3310491428,1),(51412994,424991492,15306368,427965,1,'2007-09-14 21:22:31',3310491433,1),(51412995,424991871,15305596,427965,1,'2007-09-14 21:22:31',3310491433,1),(51412998,424993200,15305252,427965,1,'2007-09-14 21:22:31',3310491433,1),(51412999,424995478,15305338,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413000,424998706,15306454,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413001,425001553,15307055,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413004,425004528,15306454,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413005,425008388,15303364,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413006,425008767,15301991,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413007,425008767,15301476,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413008,425007881,15300875,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413009,425005540,15300102,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413011,425003768,15298472,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413013,425002123,15294953,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413014,425000794,15292893,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413017,424998073,15290833,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413018,424997440,15290489,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413020,424997313,15289459,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413021,424997313,15288601,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413023,424998010,15288000,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413024,424999465,15287914,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413026,425001806,15288344,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413027,425004654,15289202,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413028,425005287,15289116,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413029,425005856,15288344,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413031,425006173,15287228,427965,1,'2007-09-14 21:20:09',3310491433,1),(51413033,425006932,15284052,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413034,425007312,15281735,427965,1,'2007-09-14 21:20:09',3310491433,1),(51413035,425007818,15280190,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413037,425008451,15279246,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413038,425009337,15279246,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413039,425010286,15279846,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413041,425010856,15280619,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413042,425011678,15281134,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413043,425012754,15281048,427965,1,'2007-09-14 21:22:31',3310491436,1),(51413044,425014273,15280361,427965,1,'2007-09-14 21:22:31',3310491436,1),(51413047,425015791,15279761,427965,1,'2007-09-14 21:22:31',3310491436,1),(51413048,425016930,15279761,427965,1,'2007-09-14 21:22:31',3310491436,1),(51413050,425018512,15281820,427965,1,'2007-09-14 21:22:31',3310491436,1),(51413052,425019398,15282936,427965,1,'2007-09-14 21:22:31',3310491436,1),(51413053,425019968,15283623,427965,1,'2007-09-14 21:22:31',3310491436,1),(51413054,425021233,15283537,427965,1,'2007-09-14 21:22:31',3310491436,1),(51413055,425021676,15282679,427965,1,'2007-09-14 21:22:31',3310491436,1),(51413057,425021486,15280962,427965,1,'2007-09-14 21:22:31',3310491436,1),(51413058,425019272,15278816,427965,1,'2007-09-14 21:22:31',3310491436,1),(51413060,425017500,15277529,427965,1,'2007-09-14 21:22:31',3310491436,1),(51413061,425015348,15276413,427965,1,'2007-09-14 21:22:31',3310491436,1),(51413063,425013703,15275469,427965,1,'2007-09-14 21:22:31',3310491436,1),(51413065,425012374,15273409,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413066,425010856,15270062,427965,1,'2007-09-14 21:22:31',3310491427,1),(51413067,425008324,15264311,427965,1,'2007-09-14 21:22:31',3310491427,1),(51413068,425007059,15260964,427965,1,'2007-09-14 21:22:31',3310491427,1),(51413071,425004085,15258389,427965,1,'2007-09-14 21:22:31',3310491427,1),(51413072,425003135,15256157,427965,1,'2007-09-14 21:22:31',3310491427,1),(51413073,425003072,15254784,427965,1,'2007-09-14 21:22:31',3310491427,1),(51413074,425003705,15253926,427965,1,'2007-09-14 21:22:31',3310491427,1),(51413075,425004464,15253582,427965,1,'2007-09-14 21:22:31',3310491427,1),(51413078,425005224,15254269,427965,1,'2007-09-14 21:20:09',3310491427,1),(51413079,425007692,15257187,427965,1,'2007-09-14 21:22:31',3310491427,1),(51413082,425011045,15260964,427965,1,'2007-09-14 21:22:31',3310491427,1),(51413083,425012817,15262852,427965,1,'2007-09-14 21:22:31',3310491430,1),(51413084,425014716,15263195,427965,1,'2007-09-14 21:22:31',3310491430,1),(51413085,425016614,15263539,427965,1,'2007-09-14 21:22:31',3310491430,1),(51413086,425017753,15264826,427965,1,'2007-09-14 21:22:31',3310491430,1),(51413087,425019019,15266628,427965,1,'2007-09-14 21:22:31',3310491430,1),(51413090,425019715,15267401,427965,1,'2007-09-14 21:22:31',3310491430,1),(51413091,425020347,15267229,427965,1,'2007-09-14 21:22:31',3310491430,1),(51413093,425020664,15266113,427965,1,'2007-09-14 21:22:31',3310491430,1),(51413094,425020664,15265598,427965,1,'2007-09-14 21:22:31',3310491430,1),(51413096,425018512,15262938,427965,1,'2007-09-14 21:22:31',3310491430,1),(51413097,425015095,15258732,427965,1,'2007-09-14 21:22:31',3310491430,1),(51413099,425012374,15254526,427965,1,'2007-09-14 21:22:31',3310491427,1),(51413100,425008198,15246802,427965,1,'2007-09-14 21:22:31',3310491427,1),(51413103,425005160,15241223,427965,1,'2007-09-14 21:22:31',3310491427,1),(51413104,425001617,15237704,427965,1,'2007-09-14 21:22:31',3310491427,1),(51413411,424996048,15311003,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413412,424991935,15307827,427965,1,'2007-09-14 21:22:31',3310491433,1),(51413826,424977443,15275212,427965,1,'2007-09-14 21:22:30',3310491432,1),(51413827,424981683,15280018,427965,1,'2007-09-14 21:22:30',3310491432,1),(51413832,424984594,15283451,427965,1,'2007-09-14 21:22:30',3310491432,1),(51413833,424985859,15286884,427965,1,'2007-09-14 21:22:30',3310491433,1),(51413835,424986492,15288859,427965,1,'2007-09-14 21:22:30',3310491433,1),(51413854,424991618,15306883,427965,1,'2007-09-14 21:22:31',3310491433,1),(51414015,425027498,15348425,258874,1,'2008-10-11 17:23:03',3310491438,2),(51414017,425026802,15345593,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414018,425026992,15342846,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414019,425026928,15340786,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414020,425025536,15339413,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414021,425023511,15338211,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414022,425019651,15334177,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414023,425018765,15332546,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414024,425018006,15331259,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414025,425017120,15331173,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414027,425016614,15331946,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414028,425016741,15333061,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414030,425017880,15335550,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414031,425019651,15338383,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414032,425021044,15340271,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414033,425021486,15341387,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414034,425021613,15342760,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414036,425021297,15343275,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414040,425020158,15343275,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414041,425018133,15340958,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414044,425014652,15338555,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414045,425011995,15336151,427965,1,'2007-09-14 21:22:31',3310491435,1),(51414046,425011172,15334263,427965,1,'2007-09-14 21:22:31',3310491435,1),(51414049,425011045,15332375,427965,1,'2007-09-14 21:22:31',3310491435,1),(51414050,425010919,15331001,427965,1,'2007-09-14 21:22:31',3310491435,1),(51414051,425010539,15330143,427965,1,'2007-09-14 21:22:31',3310491435,1),(51414052,425009590,15329971,427965,1,'2007-09-14 21:22:31',3310491435,1),(51414053,425008894,15330486,427965,1,'2007-09-14 21:22:31',3310491435,1),(51414054,425008831,15331946,427965,1,'2007-09-14 21:22:31',3310491435,1),(51414055,425009527,15335293,427965,1,'2007-09-14 21:22:31',3310491435,1),(51414056,425010286,15339241,427965,1,'2007-09-14 21:22:31',3310491435,1),(51414057,425010919,15340615,427965,1,'2007-09-14 21:22:31',3310491435,1),(51414060,425012627,15342674,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414061,425015791,15345679,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414062,425016994,15346623,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414063,425017437,15347481,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414064,425017437,15348253,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414065,425017120,15349026,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414067,425016361,15349026,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414069,425014969,15348168,427965,1,'2007-09-14 21:22:31',3310491438,1),(51414070,425012184,15345335,427965,1,'2007-09-14 21:22:31',3310491435,1),(51414072,425009463,15343018,427965,1,'2007-09-14 21:22:31',3310491435,1),(51414074,425004717,15337868,427965,1,'2007-09-14 21:22:31',3310491435,1),(51414076,425003009,15333319,427965,1,'2007-09-14 21:22:31',3310491435,1),(51414077,425002376,15330830,427965,1,'2007-09-14 21:22:31',3310491435,1),(51414078,425001996,15328427,427965,1,'2007-09-14 21:22:31',3310491435,1),(51414079,425003135,15324307,427965,1,'2007-09-14 21:22:31',3310491433,1),(51414082,425004401,15319758,427965,1,'2007-09-14 21:22:31',3310491433,1),(51414083,425005477,15317784,427965,1,'2007-09-14 21:22:31',3310491433,1),(51414084,425006995,15316668,427965,1,'2007-09-14 21:22:31',3310491433,1),(51414085,425007059,15315809,427965,1,'2007-09-14 21:22:31',3310491433,1),(51414087,425006995,15314865,427965,1,'2007-09-14 21:22:31',3310491433,1),(51414089,425006173,15314350,427965,1,'2007-09-14 21:22:31',3310491433,1),(51414090,425003642,15314608,427965,1,'2007-09-14 21:22:31',3310491433,1),(51414091,425000984,15314436,427965,1,'2007-09-14 21:22:31',3310491433,1),(51414092,424998769,15313149,427965,1,'2007-09-14 21:22:31',3310491433,1),(51414167,425030725,15363617,258874,1,'2008-10-11 17:23:03',3310491438,2),(51414169,425029966,15358124,258874,1,'2008-10-11 17:23:03',3310491438,2),(51414257,425051670,15487213,258874,1,'2008-10-11 17:23:02',3310491527,2),(51414258,425052492,15482407,258874,1,'2008-10-11 17:23:02',3310491527,2),(51414259,425054960,15475283,258874,1,'2008-10-11 17:23:02',3310491527,2),(51414262,425060465,15462408,258874,1,'2008-10-11 17:23:02',3310491527,2),(51414263,425061098,15458546,258874,1,'2008-10-11 17:23:02',3310491527,2),(51414264,425061920,15449190,258874,1,'2008-10-11 17:23:02',3310491527,2),(51414266,425061477,15441895,258874,1,'2008-10-11 17:23:02',3310491527,2),(51414267,425060655,15437174,258874,1,'2008-10-11 17:23:02',3310491527,2),(51414269,425058567,15431252,258874,1,'2008-10-11 17:23:02',3310491525,2),(51414270,425056922,15426359,258874,1,'2008-10-11 17:23:02',3310491525,2),(51414271,425055783,15419407,258874,1,'2008-10-11 17:23:02',3310491525,2),(51414273,425054897,15410824,258874,1,'2008-10-11 17:23:02',3310491525,2),(51414274,425053758,15406447,258874,1,'2008-10-11 17:23:03',3310491525,2),(51414276,425050341,15402842,258874,1,'2008-10-11 17:23:03',3310491525,2),(51414277,425043697,15397606,258874,1,'2008-10-11 17:23:03',3310491525,2),(51414278,425040976,15395975,258874,1,'2008-10-11 17:23:03',3310491525,2),(51414279,425040280,15394430,258874,1,'2008-10-11 17:23:03',3310491525,2),(51414280,425039331,15391598,258874,1,'2008-10-11 17:23:03',3310491524,2),(51414283,425038192,15389624,258874,1,'2008-10-11 17:23:03',3310491524,2),(51414284,425035091,15387049,258874,1,'2008-10-11 17:23:03',3310491524,2),(51414285,425034016,15385161,258874,1,'2008-10-11 17:23:03',3310491524,2),(51414286,425033509,15382500,258874,1,'2008-10-11 17:23:03',3310491524,2),(51414288,425033509,15379152,258874,1,'2008-10-11 17:23:03',3310491438,2),(51414289,425033826,15377093,258874,1,'2008-10-11 17:23:03',3310491438,2),(51414290,425032687,15372458,258874,1,'2008-10-11 17:23:03',3310491438,2),(51414414,425048190,15385761,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414415,425051353,15388851,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414416,425052872,15391770,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414417,425054011,15394259,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414418,425054264,15396061,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414419,425054137,15397005,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414420,425053505,15397005,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414421,425052176,15396233,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414422,425051227,15394001,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414423,425050594,15392714,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414424,425050088,15391684,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414425,425049265,15391598,427965,1,'2007-09-14 21:23:23',3310491525,1),(51414426,425048822,15392971,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414428,425049518,15396748,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414429,425050784,15399494,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414430,425053631,15401640,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414431,425054960,15402928,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414432,425054580,15404644,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414433,425053441,15404644,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414434,425052366,15403700,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414436,425048949,15400696,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414437,425048443,15399323,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414438,425047810,15397778,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414439,425046987,15397949,427965,1,'2007-09-14 21:23:36',3310491525,1),(51414440,425046291,15399494,258874,1,'2008-10-11 17:23:03',3310491525,2),(51415013,425099898,15480136,2895121,1,'2009-10-19 19:18:49',3310491539,4),(51415016,425099062,15482922,258874,1,'2008-10-11 17:21:48',3310491539,2),(51415017,425097859,15483866,258874,1,'2008-10-11 17:21:48',3310491539,2),(51415018,425095645,15484467,258874,1,'2008-10-11 17:21:48',3310491539,2),(51415019,425092734,15484724,258874,1,'2008-10-11 17:21:48',3310491538,2),(51415021,425089191,15484638,258874,1,'2008-10-11 17:21:48',3310491538,2),(51415023,425085774,15483952,258874,1,'2008-10-11 17:21:48',3310491538,2),(51415024,425081978,15483952,258874,1,'2008-10-11 17:21:48',3310491538,2),(51415026,425077865,15484982,258874,1,'2008-10-11 17:21:48',3310491538,2),(51415027,425072550,15488587,258874,1,'2008-10-11 17:21:48',3310491538,2),(51415028,425065907,15492191,258874,1,'2008-10-11 17:21:48',3310491533,2),(51415030,425065021,15493393,258874,1,'2008-10-11 17:21:48',3310491533,2),(51415032,425064894,15494251,258874,1,'2008-10-11 17:21:48',3310491533,2),(51415033,425066033,15495196,258874,1,'2008-10-11 17:21:49',3310491533,2),(51415034,425067172,15495281,258874,1,'2008-10-11 17:21:49',3310491533,2),(51415035,425077043,15493050,258874,1,'2008-10-11 17:21:49',3310491544,2),(51415036,425078561,15492706,258874,1,'2008-10-11 17:21:49',3310491544,2),(51415039,425078941,15493565,258874,1,'2008-10-11 17:21:49',3310491544,2),(51415041,425078878,15494681,258874,1,'2008-10-11 17:21:49',3310491544,2),(51415042,425077486,15496054,258874,1,'2008-10-11 17:21:49',3310491544,2),(51415045,425074449,15498028,258874,1,'2008-10-11 17:21:49',3310491544,2),(51415046,425068627,15501461,258874,1,'2008-10-11 17:21:49',3310491544,2),(51415047,425060022,15507298,258874,1,'2008-10-11 17:21:49',3310491533,2),(51415048,425055276,15509615,258874,1,'2008-10-11 17:21:49',3310491533,2),(51415049,425050594,15511418,258874,1,'2008-10-11 17:21:49',3310491533,2),(51415050,425049518,15512791,258874,1,'2008-10-11 17:21:50',3310491533,2),(51415051,425047683,15515366,258874,1,'2008-10-11 17:21:50',3310491533,2),(51415052,425046418,15518112,258874,1,'2008-10-11 17:21:50',3310491533,2),(51415053,425044583,15520172,258874,1,'2008-10-11 17:21:50',3310491533,2),(51415055,425040849,15522747,258874,1,'2008-10-11 17:23:02',3310491533,3),(51415057,425040407,15521717,258874,1,'2008-10-11 17:23:02',3310491533,2),(51415059,425039964,15518885,258874,1,'2008-10-11 17:23:02',3310491532,2),(51415060,425040596,15515623,258874,1,'2008-10-11 17:23:02',3310491533,2),(51415061,425041735,15511332,258874,1,'2008-10-11 17:23:02',3310491533,2),(51415062,425043254,15507040,258874,1,'2008-10-11 17:23:02',3310491533,2),(51415066,425045532,15501290,258874,1,'2008-10-11 17:23:02',3310491533,2),(51415068,425048190,15495968,258874,1,'2008-10-11 17:23:02',3310491533,2),(51415069,425050341,15490647,258874,1,'2008-10-11 17:23:02',3310491527,2),(51415249,425040027,15523863,258874,1,'2008-10-11 17:21:50',3310491532,2),(51415251,425040090,15525065,258874,1,'2008-10-11 17:21:50',3310491533,2),(51415253,425040660,15525837,258874,1,'2008-10-11 17:21:50',3310491533,2),(51415255,425041419,15526009,258874,1,'2008-10-11 17:21:50',3310491533,2),(51415257,425043254,15525580,258874,1,'2008-10-11 17:21:50',3310491533,2),(51415258,425047810,15522490,258874,1,'2008-10-11 17:21:50',3310491533,2),(51415781,425049708,15521889,258874,1,'2008-10-11 17:21:50',3310491533,2),(51415783,425051860,15520773,258874,1,'2008-10-11 17:21:50',3310491533,2),(51415785,425054770,15520516,258874,1,'2008-10-11 17:21:50',3310491533,2),(51415788,425057428,15520001,258874,1,'2008-10-11 17:21:50',3310491533,2),(51415790,425060402,15519571,258874,1,'2008-10-11 17:21:50',3310491533,2),(51415795,425068311,15517855,258874,1,'2008-10-11 17:21:50',3310491544,2),(51415796,425075018,15517082,258874,1,'2008-10-11 17:21:50',3310491544,2),(51415798,425082358,15518112,258874,1,'2008-10-11 17:21:50',3310491544,2),(51416264,425064072,15504465,258874,1,'2008-10-11 17:21:49',3310491533,2),(51416291,425085711,15499573,427965,1,'2007-09-14 21:27:14',3310491544,1),(51416292,425086217,15500088,427965,1,'2007-09-14 21:27:14',3310491544,1),(51416294,425087673,15501290,427965,1,'2007-09-14 21:27:14',3310491544,1),(51416297,425088685,15503092,427965,1,'2007-09-14 21:27:14',3310491544,1),(51416298,425091595,15506268,427965,1,'2007-09-14 21:27:14',3310491544,1),(51416299,425090330,15507555,427965,1,'2007-09-14 21:27:14',3310491544,1),(51416340,425084193,15519142,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416343,425085521,15521631,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416345,425087293,15524635,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416349,425089001,15526180,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416351,425092798,15528155,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416352,425094316,15528841,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416353,425095392,15528841,427965,1,'2007-09-14 21:27:15',3310491545,1),(51416354,425095961,15527897,427965,1,'2007-09-14 21:27:15',3310491545,1),(51416356,425095012,15526438,427965,1,'2007-09-14 21:27:15',3310491545,1),(51416357,425092228,15524292,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416359,425090520,15522404,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416361,425089444,15519486,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416364,425088622,15517082,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416365,425087989,15515537,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416366,425086660,15514336,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416367,425082294,15512448,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416370,425078941,15511418,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416371,425076916,15511332,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416372,425076347,15510731,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416375,425076284,15510130,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416376,425076537,15509358,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416379,425077802,15509186,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416380,425080143,15509100,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416381,425084762,15509358,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416382,425088558,15510388,427965,1,'2007-09-14 21:27:15',3310491544,1),(51416727,425083244,15519314,258874,1,'2008-10-11 17:21:51',3310491544,2),(51416729,425083560,15521717,258874,1,'2008-10-11 17:21:51',3310491544,2),(51416731,425084193,15523777,258874,1,'2008-10-11 17:21:51',3310491544,2),(51416732,425085711,15526524,258874,1,'2008-10-11 17:21:51',3310491544,2),(51416733,425088432,15530472,258874,1,'2008-10-11 17:21:51',3310491544,2),(51416734,425091279,15533390,258874,1,'2008-10-11 17:21:51',3310491544,2),(51416735,425093051,15534592,258874,1,'2008-10-11 17:21:51',3310491544,2),(51416736,425093747,15535879,258874,1,'2008-10-11 17:21:51',3310491544,2),(51416737,425093367,15537853,258874,1,'2008-10-11 17:21:51',3310491544,2),(51416739,425092734,15538712,258874,1,'2008-10-11 17:21:51',3310491544,2),(51416740,425091406,15538540,258874,1,'2008-10-11 17:21:51',3310491544,2),(51416741,425089887,15537167,258874,1,'2008-10-11 17:21:51',3310491544,2),(51416743,425088305,15536137,258874,1,'2008-10-11 17:21:52',3310491544,2),(51416744,425087040,15534764,258874,1,'2008-10-11 17:21:52',3310491544,2),(51416746,425084636,15532789,258874,1,'2008-10-11 17:21:52',3310491544,2),(51416747,425082927,15530644,258874,1,'2008-10-11 17:21:52',3310491544,2),(51416748,425081725,15528240,258874,1,'2008-10-11 17:21:52',3310491544,2),(51416749,425080143,15527382,258874,1,'2008-10-11 17:21:52',3310491544,2),(51416750,425079194,15528069,258874,1,'2008-10-11 17:21:52',3310491544,2),(51416753,425078941,15529099,258874,1,'2008-10-11 17:21:52',3310491544,2),(51416754,425079131,15530129,258874,1,'2008-10-11 17:21:52',3310491544,2),(51416755,425081788,15534077,258874,1,'2008-10-11 17:21:52',3310491544,2),(51416756,425085332,15539913,258874,1,'2008-10-11 17:21:52',3310491544,2),(51416757,425086977,15543947,258874,1,'2008-10-11 17:21:52',3310491544,2),(51416758,425087609,15546951,258874,1,'2008-10-11 17:21:52',3310491546,2),(51416760,425087040,15551071,258874,1,'2008-10-11 17:21:52',3310491546,2),(51416761,425087483,15555706,258874,1,'2008-10-11 17:21:52',3310491546,2),(51416762,425088622,15558968,258874,1,'2008-10-11 17:21:52',3310491546,2),(51416763,425090963,15560684,258874,1,'2008-10-11 17:21:52',3310491546,2),(51416764,425093873,15560513,258874,1,'2008-10-11 17:21:52',3310491546,2),(51416765,425097480,15561028,258874,1,'2008-10-11 17:21:52',3310491547,2),(51416767,425101023,15564118,258874,1,'2008-10-11 17:21:52',3310491547,2),(51416768,425103807,15565748,258874,1,'2008-10-11 17:21:53',3310491547,2),(51416769,425106021,15566693,258874,1,'2008-10-11 17:21:53',3310491547,2),(51416770,425108932,15568066,258874,1,'2008-10-11 17:21:53',3310491547,2),(51416771,425111463,15569525,258874,1,'2008-10-11 17:21:53',3310491547,2),(51416772,425112412,15570383,258874,1,'2008-10-11 17:21:53',3310491547,2),(51416774,425112412,15571585,258874,1,'2008-10-11 17:21:53',3310491547,2),(51416775,425112222,15572958,258874,1,'2008-10-11 17:21:53',3310491547,2),(51416776,425111146,15573902,258874,1,'2008-10-11 17:21:53',3310491547,2),(51416779,425109501,15574074,258874,1,'2008-10-11 17:21:53',3310491547,2),(51416780,425106907,15574331,258874,1,'2008-10-11 17:21:53',3310491547,2),(51416781,425104882,15573559,258874,1,'2008-10-11 17:21:53',3310491547,2),(51416782,425103174,15572615,258874,1,'2008-10-11 17:21:53',3310491547,2),(51416783,425100833,15570383,258874,1,'2008-10-11 17:21:53',3310491547,2),(51416785,425099631,15570040,258874,1,'2008-10-11 17:21:53',3310491547,2),(51416786,425098935,15570641,258874,1,'2008-10-11 17:21:53',3310491547,2),(51416787,425098682,15571757,258874,1,'2008-10-11 17:21:53',3310491547,2),(51416789,425099188,15573216,258874,1,'2008-10-11 17:21:53',3310491547,2),(51416790,425101213,15575018,258874,1,'2008-10-11 17:21:53',3310491547,2),(51417251,425104819,15578194,258874,1,'2008-10-11 17:21:53',3310491547,2),(51417252,425110324,15583172,258874,1,'2008-10-11 17:21:53',3310491547,2),(51417253,425115259,15585747,258874,1,'2008-10-11 17:21:53',3310491547,2),(51417260,425120320,15587378,258874,1,'2008-10-11 17:21:53',3310491547,2),(51417263,425125192,15587807,258874,1,'2008-10-11 17:21:53',3310491550,2),(51417265,425127912,15589438,258874,1,'2008-10-11 17:21:53',3310491550,2),(51417268,425131202,15592871,258874,1,'2008-10-11 17:21:53',3310491550,2),(51417269,425134556,15596819,258874,1,'2008-10-11 17:21:53',3310491550,2),(51417272,425136390,15599480,258874,1,'2008-10-11 17:21:53',3310491550,2),(51417275,425136390,15600939,258874,1,'2008-10-11 17:21:53',3310491572,2),(51417277,425135315,15601540,258874,1,'2008-10-11 17:21:53',3310491572,2),(51417284,425133796,15600252,258874,1,'2008-10-11 17:21:53',3310491550,2),(51417285,425131898,15597677,258874,1,'2008-10-11 17:21:53',3310491550,2),(51417288,425129494,15595188,258874,1,'2008-10-11 17:21:53',3310491550,2),(51417289,425126900,15594673,258874,1,'2008-10-11 17:21:53',3310491550,2),(51417291,425122092,15595789,258874,1,'2008-10-11 17:21:54',3310491547,2),(51417294,425117410,15596819,258874,1,'2008-10-11 17:21:54',3310491547,2),(51417298,425113234,15596647,258874,1,'2008-10-11 17:21:54',3310491547,2),(51417398,425122661,15595617,258874,1,'2008-10-11 17:21:54',3310491550,2),(51417410,425093114,15576821,427965,1,'2007-09-14 21:29:02',3310491546,1),(51417414,425095329,15577336,427965,1,'2007-09-14 21:29:02',3310491547,1),(51417416,425097416,15579567,427965,1,'2007-09-14 21:29:02',3310491547,1),(51417419,425099188,15583000,427965,1,'2007-09-14 21:29:02',3310491547,1),(51417420,425101972,15585575,427965,1,'2007-09-14 21:29:02',3310491547,1),(51417421,425106717,15589352,427965,1,'2007-09-14 21:29:02',3310491547,1),(51417467,425089191,15584459,427965,1,'2007-09-14 21:29:01',3310491546,1),(51417468,425091342,15582485,427965,1,'2007-09-14 21:29:01',3310491546,1),(51417469,425093177,15581455,427965,1,'2007-09-14 21:29:01',3310491546,1),(51417472,425094443,15581284,427965,1,'2007-09-14 21:29:01',3310491546,1),(51417476,425095708,15582485,427965,1,'2007-09-14 21:29:01',3310491547,1),(51417481,425097290,15585232,427965,1,'2007-09-14 21:29:01',3310491547,1),(51417482,425098302,15586949,427965,1,'2007-09-14 21:29:01',3310491547,1),(51417484,425100200,15587893,427965,1,'2007-09-14 21:29:01',3310491547,1),(51417488,425103744,15586949,427965,1,'2007-09-14 21:29:01',3310491547,1),(51420037,425107856,15595446,258874,1,'2008-10-11 17:21:54',3310491547,2),(51420038,425104819,15594931,258874,1,'2008-10-11 17:21:54',3310491547,2),(51420040,425102794,15594588,258874,1,'2008-10-11 17:21:54',3310491547,2),(51420042,425101086,15595102,258874,1,'2008-10-11 17:21:54',3310491547,2),(51420044,425099441,15595188,258874,1,'2008-10-11 17:21:54',3310491547,2),(51420045,425098239,15594158,258874,1,'2008-10-11 17:21:54',3310491547,2),(51420046,425096974,15593729,258874,1,'2008-10-11 17:21:54',3310491547,2),(51420048,425095961,15593729,258874,1,'2008-10-11 17:21:54',3310491547,2),(51420050,425095012,15594588,258874,1,'2008-10-11 17:21:54',3310491547,2),(51420052,425094949,15595188,258874,1,'2008-10-11 17:21:54',3310491546,2),(51420054,425095392,15596390,258874,1,'2008-10-11 17:21:54',3310491547,2),(51420057,425096657,15596905,258874,1,'2008-10-11 17:21:54',3310491547,2),(51420058,425105452,15599823,258874,1,'2008-10-11 17:21:54',3310491547,2),(51420059,425114436,15603771,258874,1,'2008-10-11 17:21:54',3310491569,2),(51420061,425119688,15606003,258874,1,'2008-10-11 17:21:54',3310491569,2),(51420063,425121206,15607720,258874,1,'2008-10-11 17:21:54',3310491569,2),(51420066,425121522,15608750,258874,1,'2008-10-11 17:21:54',3310491569,2),(51420067,425121143,15612354,258874,1,'2008-10-11 17:21:54',3310491569,2),(51420068,425119434,15619478,258874,1,'2008-10-11 17:21:54',3310491569,2),(51420072,425118675,15621624,258874,1,'2008-10-11 17:21:54',3310491569,2),(51420073,425117283,15623169,258874,1,'2008-10-11 17:21:54',3310491569,2);
INSERT INTO `current_nodes` VALUES (51420076,425115828,15624113,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420078,425112981,15626774,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420079,425112158,15628147,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420081,425111526,15630722,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420084,425111589,15633898,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420451,425111589,15635357,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420452,425111399,15636559,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420453,425110450,15638361,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420454,425108426,15640164,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420456,425107666,15641279,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420457,425107160,15645142,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420458,425107350,15648833,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420461,425108362,15650721,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420462,425109375,15651407,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420464,425111083,15651407,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420465,425112854,15650807,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420466,425114942,15648833,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420467,425116777,15647631,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420469,425118422,15647288,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420471,425122282,15648318,258874,1,'2008-10-11 17:21:55',3310491569,2),(51420474,425127406,15650721,258874,1,'2008-10-11 17:21:55',3310491572,2),(51420475,425129494,15652180,258874,1,'2008-10-11 17:21:55',3310491572,2),(51420476,425131708,15652523,258874,1,'2008-10-11 17:21:55',3310491572,2),(51420477,425133733,15652008,258874,1,'2008-10-11 17:21:55',3310491572,2),(51420893,425136074,15651407,258874,1,'2008-10-11 17:21:56',3310491572,2),(51420894,425138541,15651751,258874,1,'2008-10-11 17:21:56',3310491572,2),(51420895,425142084,15653897,258874,1,'2008-10-11 17:21:56',3310491572,2),(51420896,425146829,15658188,258874,1,'2008-10-11 17:21:56',3310491574,2),(51420899,425148917,15660162,258874,1,'2008-10-11 17:21:56',3310491574,2),(51420900,425149550,15661364,258874,1,'2008-10-11 17:21:56',3310491574,2),(51420902,425150435,15662651,258874,1,'2008-10-11 17:21:56',3310491575,2),(51420906,425151384,15663252,258874,1,'2008-10-11 17:21:56',3310491575,2),(51420908,425152207,15662394,258874,1,'2008-10-11 17:21:56',3310491575,2),(51420910,425152207,15661535,258874,1,'2008-10-11 17:21:56',3310491575,2),(51420912,425152333,15660591,258874,1,'2008-10-11 17:21:56',3310491575,2),(51420914,425152017,15658875,258874,1,'2008-10-11 17:21:56',3310491575,2),(51420916,425151131,15655527,258874,1,'2008-10-11 17:21:56',3310491573,2),(51420919,425150246,15653210,258874,1,'2008-10-11 17:21:56',3310491573,2),(51420921,425149233,15651751,258874,1,'2008-10-11 17:21:56',3310491572,2),(51420922,425148411,15650034,258874,1,'2008-10-11 17:21:56',3310491572,2),(51420926,425148411,15648833,258874,1,'2008-10-11 17:21:57',3310491572,2),(51420928,425148980,15646858,258874,1,'2008-10-11 17:21:57',3310491572,2),(51420929,425149929,15646858,258874,1,'2008-10-11 17:21:57',3310491573,2),(51420932,425150562,15648318,258874,1,'2008-10-11 17:21:57',3310491573,2),(51420933,425150562,15649347,258874,1,'2008-10-11 17:21:57',3310491573,2),(51420935,425151195,15650892,258874,1,'2008-10-11 17:21:57',3310491573,2),(51420938,425151954,15652094,258874,1,'2008-10-11 17:21:57',3310491573,2),(51420939,425153852,15654926,258874,1,'2008-10-11 17:21:57',3310491573,2),(51420940,425156635,15659733,258874,1,'2008-10-11 17:21:57',3310491575,2),(51420942,425159925,15668402,258874,1,'2008-10-11 17:21:57',3310491575,2),(51420945,425163911,15679474,258874,1,'2008-10-11 17:21:57',3310491575,2),(51420946,425168213,15688658,258874,1,'2008-10-11 17:21:57',3310491575,2),(51420950,425171629,15695439,258874,1,'2008-10-11 17:21:57',3310491575,2),(51420951,425173211,15699902,258874,1,'2008-10-11 17:21:57',3310491575,2),(51420952,425173907,15704107,258874,1,'2008-10-11 17:21:57',3310491575,2),(51420955,425173907,15707283,258874,1,'2008-10-11 17:21:57',3310491575,2),(51420956,425174096,15710287,258874,1,'2008-10-11 17:21:57',3310491575,2),(51420957,425174919,15711832,258874,1,'2008-10-11 17:21:57',3310491581,2),(51420958,425176311,15711575,427965,1,'2007-09-14 21:33:37',3310491581,1),(51420961,425177007,15710716,427965,1,'2007-09-14 21:33:37',3310491581,1),(51420964,425177196,15709515,427965,1,'2007-09-14 21:33:37',3310491575,1),(51420967,425177196,15708142,427965,1,'2007-09-14 21:33:37',3310491575,1),(51420968,425176627,15704880,427965,1,'2007-09-14 21:33:37',3310491575,1),(51420969,425174982,15689602,427965,1,'2007-09-14 21:33:37',3310491575,1),(51420970,425174160,15684023,427965,1,'2007-09-14 21:33:37',3310491575,1),(51421275,424981620,15272207,427965,1,'2007-09-14 21:36:14',3310491432,1),(51421278,424985543,15278645,427965,1,'2007-09-14 21:36:14',3310491433,1),(51421280,424988138,15284138,427965,1,'2007-09-14 21:36:14',3310491433,1),(51421281,424988834,15286627,427965,1,'2007-09-14 21:36:14',3310491433,1),(51421284,424988201,15287743,427965,1,'2007-09-14 21:36:14',3310491433,1),(51421287,424985543,15290661,427965,1,'2007-09-14 21:36:14',3310491433,1),(51421289,424984277,15293579,427965,1,'2007-09-14 21:36:14',3310491432,1),(51421291,424983265,15297098,427965,1,'2007-09-14 21:36:14',3310491432,1),(51421294,424983391,15300703,427965,1,'2007-09-14 21:36:14',3310491432,1),(51421295,424984341,15303106,427965,1,'2007-09-14 21:36:14',3310491432,1),(51421296,424986302,15304651,427965,1,'2007-09-14 21:36:14',3310491433,1),(51421297,424989783,15306196,427965,1,'2007-09-14 21:36:14',3310491433,1),(51438191,425034634,15118277,434787,1,'2007-09-15 15:11:13',3310491406,1),(51438193,425031766,15121021,427965,1,'2007-09-14 22:01:04',3310491406,1),(51438194,425036892,15131063,427965,1,'2007-09-14 22:01:04',3310491406,1),(51438195,425039610,15128839,434787,1,'2007-09-15 15:11:13',3310491406,1),(51438631,425050895,15141671,697263,1,'2009-01-01 16:45:34',3310491407,4),(51438632,425045118,15136042,697263,1,'2009-01-01 16:45:34',3310491407,4),(51438634,425041973,15130428,697263,1,'2009-01-01 16:43:56',3310491407,4),(51438635,425037734,15123218,697263,1,'2009-01-01 16:43:56',3310491406,3),(51438636,425026091,15097469,697263,1,'2009-01-01 16:43:56',3310491404,3),(51438638,425023749,15088971,697263,1,'2009-01-01 16:43:56',3310491404,3),(51438639,425023180,15087083,697263,1,'2009-01-01 16:43:56',3310491404,3),(51438642,425022737,15086397,697263,1,'2009-01-01 16:43:56',3310491404,3),(51438643,425022168,15086826,697263,1,'2009-01-01 16:43:56',3310491404,3),(51438645,425022104,15087770,697263,1,'2009-01-01 16:43:56',3310491404,3),(51438646,425021768,15089951,697263,1,'2009-01-01 16:43:57',3310491404,2),(51438647,425021642,15094671,697263,1,'2009-01-01 16:43:57',3310491404,2),(51438648,425020376,15100164,697263,1,'2009-01-01 16:43:57',3310491404,2),(51438650,425019763,15101503,697263,1,'2009-01-01 16:43:57',3310491404,4),(51438651,425018687,15102104,697263,1,'2009-01-01 16:43:57',3310491404,4),(51438652,425018307,15101503,697263,1,'2009-01-01 16:43:57',3310491404,3),(51438654,425018181,15100559,697263,1,'2009-01-01 16:43:57',3310491404,3),(51438655,425018307,15098928,697263,1,'2009-01-01 16:43:57',3310491404,3),(51438656,425018940,15094379,697263,1,'2009-01-01 16:43:57',3310491404,3),(51438658,425019004,15091632,697263,1,'2009-01-01 16:43:58',3310491404,3),(51438659,425019193,15089658,697263,1,'2009-01-01 16:43:58',3310491404,3),(51438660,425018624,15088714,697263,1,'2009-01-01 16:43:58',3310491404,4),(51438661,425017548,15090774,697263,1,'2009-01-01 16:43:58',3310491404,4),(51438662,425016409,15093950,697263,1,'2009-01-01 16:43:58',3310491404,4),(51438663,425014744,15096388,697263,1,'2009-01-01 16:43:58',3310491404,2),(51438665,425012865,15100559,697263,1,'2009-01-01 16:43:58',3310491404,3),(51438666,425010524,15102876,697263,1,'2009-01-01 16:43:58',3310491401,3),(51438812,425019257,15102189,697263,1,'2009-01-01 16:43:57',3310491404,4),(51439215,424973694,15026229,592895,1,'2008-07-25 23:03:57',3310491394,2),(51439216,424956588,15041628,427965,1,'2007-09-14 22:02:35',3310491223,1),(51439552,424999703,15079273,592895,1,'2008-07-25 23:00:37',3310491401,2),(51439943,424934691,14952965,427965,1,'2007-09-14 22:03:20',3310491221,1),(51439944,424930577,14956570,427965,1,'2007-09-14 22:03:20',3310491221,1),(51439947,424927855,14958887,427965,1,'2007-09-14 22:03:20',3310491220,1),(51439949,424926463,14959488,427965,1,'2007-09-14 22:03:20',3310491220,1),(51439951,424925387,14959402,427965,1,'2007-09-14 22:03:20',3310491220,1),(51439953,424924185,14957685,427965,1,'2007-09-14 22:03:20',3310491220,1),(51439955,424923235,14956656,427965,1,'2007-09-14 22:03:20',3310491220,1),(51439959,424922033,14956656,427965,1,'2007-09-14 22:03:20',3310491220,1),(51439960,424921590,14957256,427965,1,'2007-09-14 22:03:20',3310491220,1),(51439962,424921400,14959745,427965,1,'2007-09-14 22:03:20',3310491220,1),(51439964,424922982,14962749,427965,1,'2007-09-14 22:03:20',3310491220,1),(51439967,424926083,14967985,427965,1,'2007-09-14 22:03:20',3310491220,1),(51440235,424982344,15092182,427965,1,'2007-09-14 22:03:39',3310491400,1),(51440320,425004639,15090259,592895,1,'2008-07-25 23:00:36',3310491401,2),(51440321,425002361,15085109,592895,1,'2008-07-25 23:00:36',3310491401,2),(51440620,424991520,15093384,427965,1,'2007-09-14 22:04:01',3310491401,1),(51440622,425001855,15083993,592895,1,'2008-07-25 23:00:36',3310491401,2),(51441228,425069732,15190029,427965,1,'2007-09-14 22:10:36',3310491440,1),(51441229,425064986,15184278,427965,1,'2007-09-14 22:10:36',3310491429,1),(51441230,425061000,15179987,427965,1,'2007-09-14 22:10:36',3310491429,1),(51441232,425060494,15178013,427965,1,'2007-09-14 22:10:36',3310491429,1),(51441233,425059734,15174065,427965,1,'2007-09-14 22:10:36',3310491429,1),(51441235,425058912,15170288,427965,1,'2007-09-14 22:04:53',3310491429,1),(51441237,425057773,15167370,427965,1,'2007-09-14 22:10:36',3310491429,1),(51441239,425054483,15161533,427965,1,'2007-09-14 22:10:36',3310491429,1),(51441242,425052901,15155439,427965,1,'2007-09-14 22:10:36',3310491407,1),(51441244,425051888,15152521,427965,1,'2007-09-14 22:10:36',3310491407,1),(51441246,425050623,15150547,427965,1,'2007-09-14 22:10:36',3310491407,1),(51441249,425048345,15149517,427965,1,'2007-09-14 22:10:36',3310491407,1),(51441250,425045624,15148573,427965,1,'2007-09-14 22:10:36',3310491407,1),(51441254,425043662,15146770,427965,1,'2007-09-14 22:10:36',3310491407,1),(51441258,425036449,15138874,427965,1,'2007-09-14 22:10:36',3310491406,1),(51441261,425032905,15135269,427965,1,'2007-09-14 22:10:36',3310491406,1),(51441262,425030058,15133896,427965,1,'2007-09-14 22:10:36',3310491406,1),(51441263,425027716,15131149,427965,1,'2007-09-14 22:10:36',3310491406,1),(51441266,425024046,15126514,427965,1,'2007-09-14 22:10:36',3310491406,1),(51441267,425014491,15113297,427965,1,'2007-09-14 22:10:36',3310491406,1),(51441269,425011960,15107803,427965,1,'2007-09-14 22:10:36',3310491403,1),(51441361,425067770,15182562,427965,1,'2007-09-14 22:05:47',3310491440,1),(51441364,425068973,15186338,427965,1,'2007-09-14 22:05:47',3310491440,1),(51441603,425086373,15281868,427965,1,'2007-09-14 22:10:36',3310491448,1),(51441607,425083842,15277061,427965,1,'2007-09-14 22:10:36',3310491448,1),(51441610,425083082,15273457,427965,1,'2007-09-14 22:10:36',3310491448,1),(51441611,425082829,15267706,427965,1,'2007-09-14 22:10:36',3310491442,1),(51441615,425081690,15260239,427965,1,'2007-09-14 22:10:36',3310491442,1),(51441616,425081058,15255346,427965,1,'2007-09-14 22:10:36',3310491442,1),(51441619,425078843,15247707,427965,1,'2007-09-14 22:11:20',3310491442,1),(51441621,425077787,15240634,592895,1,'2008-07-25 23:51:05',3310491442,2),(51441623,425077471,15233768,592895,1,'2008-07-25 23:51:05',3310491442,2),(51441625,425076502,15228825,427965,1,'2007-09-14 22:10:36',3310491442,1),(51441626,425075539,15223711,978767,1,'2009-04-26 22:36:08',3310491442,3),(51441629,425074351,15215178,427965,1,'2007-09-14 22:10:36',3310491440,1),(51441630,425073971,15206337,427965,1,'2007-09-14 22:10:36',3310491440,1),(51441632,425073971,15202303,427965,1,'2007-09-14 22:10:36',3310491440,1),(51441635,425073212,15198355,427965,1,'2007-09-14 22:10:36',3310491440,1),(51441636,425071883,15194149,427965,1,'2007-09-14 22:10:36',3310491440,1),(51441659,425088144,15284958,427965,1,'2007-09-14 22:10:36',3310491448,1),(51441848,425060766,15148967,697263,1,'2009-01-01 16:45:34',3310491407,4),(51441849,425061589,15150598,592895,1,'2008-07-26 00:12:08',3310491407,2),(51441850,425063677,15158065,592895,1,'2008-07-26 00:12:28',3310491407,3),(51441852,425063911,15161619,427965,1,'2007-09-14 22:05:47',3310491429,1),(51441853,425065385,15170339,592895,1,'2008-07-26 00:12:56',3310491429,2),(51441855,425066018,15175746,592895,1,'2008-07-26 00:12:56',3310491429,2),(51441857,425066631,15180159,427965,1,'2007-09-14 22:05:47',3310491429,1),(51442041,424944817,14981890,592895,1,'2008-07-25 22:14:49',3310491221,2),(51442271,424944627,14986954,592895,1,'2008-07-25 22:14:49',3310491221,2),(51442273,424945893,14987812,592895,1,'2008-07-25 22:14:49',3310491221,2),(51442278,424943804,14985237,592895,1,'2008-07-25 22:14:49',3310491221,2),(51442280,424943614,14983520,592895,1,'2008-07-25 22:14:49',3310491221,2),(51442282,424944058,14982576,592895,1,'2008-07-25 22:14:49',3310491221,2),(51442349,424944058,14985752,592895,1,'2008-07-25 22:14:49',3310491221,2),(51442351,424942855,14988670,427965,1,'2007-09-14 22:06:39',3310491221,1),(51442352,424942095,14992533,427965,1,'2007-09-14 22:06:39',3310491221,1),(51442529,424971163,15009235,592895,1,'2008-07-25 23:09:45',3310491394,2),(51442532,424976162,15021079,592895,1,'2008-07-25 23:09:45',3310491394,2),(51442533,424972808,15024598,592895,1,'2008-07-25 23:03:57',3310491394,2),(51442648,424960828,15025406,427965,1,'2007-09-14 22:07:10',3310491394,1),(51442649,424961144,15022230,427965,1,'2007-09-14 22:07:10',3310491394,1),(51442651,424965194,15019655,427965,1,'2007-09-14 22:07:10',3310491394,1),(51442653,424968821,15016445,592895,1,'2008-07-25 23:05:42',3310491394,2),(51442942,425045624,15270624,427965,1,'2007-09-14 22:07:46',3310491431,1),(51442943,425045244,15273199,427965,1,'2007-09-14 22:07:46',3310491437,1),(51442944,425045877,15275602,427965,1,'2007-09-14 22:07:46',3310491437,1),(51442946,425046320,15277147,427965,1,'2007-09-14 22:07:46',3310491437,1),(51442947,425047459,15277576,427965,1,'2007-09-14 22:07:46',3310491437,1),(51442949,425048092,15276031,427965,1,'2007-09-14 22:07:46',3310491437,1),(51442951,425048218,15274401,427965,1,'2007-09-14 22:07:46',3310491437,1),(51442952,425048408,15271826,427965,1,'2007-09-14 22:07:46',3310491437,1),(51442953,425049294,15268049,427965,1,'2007-09-14 22:07:46',3310491431,1),(51442955,425049294,15266418,427965,1,'2007-09-14 22:07:46',3310491431,1),(51442956,425048724,15264015,427965,1,'2007-09-14 22:07:46',3310491431,1),(51442957,425044738,15246677,427965,1,'2007-09-14 22:07:46',3310491431,1),(51442958,425044928,15243759,427965,1,'2007-09-14 22:07:46',3310491431,1),(51442959,425045751,15241528,427965,1,'2007-09-14 22:07:46',3310491431,1),(51442960,425047396,15240068,427965,1,'2007-09-14 22:07:46',3310491431,1),(51442961,425047902,15239725,840745,1,'2009-01-26 20:00:23',3310491431,4),(51443088,425051319,15231915,427965,1,'2007-09-14 22:07:53',3310491431,1),(51443089,425064480,15225992,427965,1,'2007-09-14 22:08:10',3310491431,1),(51443310,425073591,15250883,427965,1,'2007-09-14 22:08:08',3310491442,1),(51443312,425074857,15253801,427965,1,'2007-09-14 22:08:08',3310491442,1),(51443313,425077514,15257578,427965,1,'2007-09-14 22:08:08',3310491442,1),(51443314,425079602,15262384,427965,1,'2007-09-14 22:08:08',3310491442,1),(51443315,425080805,15267963,427965,1,'2007-09-14 22:08:08',3310491442,1),(51443317,425081248,15275860,427965,1,'2007-09-14 22:08:08',3310491448,1),(51443319,425081311,15281267,427965,1,'2007-09-14 22:08:08',3310491448,1),(51443662,425097066,15264616,427965,1,'2007-09-14 22:12:33',3310491443,1),(51443663,425098427,15268231,437032,1,'2008-05-13 20:39:16',3310491443,2),(51443665,425100009,15271321,437032,1,'2008-05-13 20:39:16',3310491449,2),(51443668,425102097,15275183,437032,1,'2008-05-13 20:39:16',3310491449,2),(51443669,425107475,15290032,437032,1,'2008-05-13 20:39:16',3310491449,2),(51443670,425108138,15293455,427965,1,'2007-09-14 22:12:33',3310491449,1),(51443671,425107568,15295515,427965,1,'2007-09-14 22:12:33',3310491449,1),(51443672,425105987,15296202,427965,1,'2007-09-14 22:12:33',3310491449,1),(51443673,425104152,15296373,427965,1,'2007-09-14 22:12:33',3310491449,1),(51443676,425101621,15293970,427965,1,'2007-09-14 22:12:33',3310491449,1),(51443678,425099723,15291910,427965,1,'2007-09-14 22:12:33',3310491449,1),(51443679,425097698,15290194,427965,1,'2007-09-14 22:12:33',3310491449,1),(51443680,425096116,15287876,427965,1,'2007-09-14 22:12:33',3310491449,1),(51443683,425092953,15285044,427965,1,'2007-09-14 22:12:33',3310491448,1),(51443685,425089157,15280409,427965,1,'2007-09-14 22:12:33',3310491448,1),(51443686,425087195,15278091,427965,1,'2007-09-14 22:12:33',3310491448,1),(51443687,425085993,15276031,427965,1,'2007-09-14 22:12:33',3310491448,1),(51443688,425085107,15273886,427965,1,'2007-09-14 22:12:33',3310491448,1),(51443690,425084917,15271654,427965,1,'2007-09-14 22:12:33',3310491448,1),(51443691,425084664,15267105,427965,1,'2007-09-14 22:12:33',3310491442,1),(51443692,425084221,15264187,427965,1,'2007-09-14 22:12:33',3310491442,1),(51443693,425083652,15260925,427965,1,'2007-09-14 22:12:33',3310491442,1),(51443694,425082640,15258179,427965,1,'2007-09-14 22:08:43',3310491442,1),(51443695,425081311,15257063,427965,1,'2007-09-14 22:12:33',3310491442,1),(51444358,425141733,15304613,427965,1,'2007-09-14 22:12:33',3310491452,1),(51444359,425138254,15302982,427965,1,'2007-09-14 22:12:33',3310491452,1),(51444362,425135786,15302725,427965,1,'2007-09-14 22:12:33',3310491452,1),(51444364,425132307,15303326,427965,1,'2007-09-14 22:12:33',3310491452,1),(51444365,425130029,15304527,427965,1,'2007-09-14 22:12:33',3310491452,1),(51444366,425126203,15308314,437032,1,'2008-05-13 20:27:32',3310491452,2),(51444368,425122723,15309344,437032,1,'2008-05-13 20:27:32',3310491452,2),(51444370,425121015,15309344,437032,1,'2008-05-13 20:27:32',3310491449,2),(51444371,425118990,15308228,437032,1,'2008-05-13 20:27:32',3310491449,2),(51444373,425116966,15305567,437032,1,'2008-05-13 20:27:32',3310491449,2),(51444374,425115287,15301609,427965,1,'2007-09-14 22:12:33',3310491449,1),(51444375,425114308,15297843,437032,1,'2008-05-13 20:27:32',3310491449,2),(51444377,425113136,15292253,427965,1,'2007-09-14 22:12:33',3310491449,1),(51444379,425113106,15288401,437032,1,'2008-05-13 20:27:32',3310491449,2),(51444381,425111744,15282469,427965,1,'2007-09-14 22:12:33',3310491449,1),(51444383,425108740,15274153,437032,1,'2008-05-13 20:27:32',3310491449,2),(51444384,425105514,15267888,437032,1,'2008-05-13 20:32:39',3310491443,2),(51444386,425104058,15265742,437032,1,'2008-05-13 20:32:39',3310491443,3),(51444387,425102667,15263167,437032,1,'2008-05-13 20:27:32',3310491443,2),(51444388,425101591,15259734,437032,1,'2008-05-13 20:27:32',3310491443,2),(51444391,425101115,15257235,427965,1,'2007-09-14 22:12:33',3310491443,1),(51444392,425101907,15252696,437032,1,'2008-05-13 20:27:51',3310491443,2),(51444393,425102190,15251312,427965,1,'2007-09-14 22:12:33',3310491443,1),(51444394,425101305,15240669,427965,1,'2007-09-14 22:12:33',3310491443,1),(51444395,425100735,15229511,427965,1,'2007-09-14 22:12:33',3310491443,1),(51444396,425097762,15229683,427965,1,'2007-09-14 22:12:33',3310491443,1),(51444397,425098521,15234318,427965,1,'2007-09-14 22:12:33',3310491443,1),(51444398,425098521,15238094,427965,1,'2007-09-14 22:12:33',3310491443,1),(51444399,425098204,15241871,427965,1,'2007-09-14 22:12:33',3310491443,1),(51444401,425097192,15248480,427965,1,'2007-09-14 22:12:33',3310491443,1),(51444403,425097572,15251656,427965,1,'2007-09-14 22:12:33',3310491443,1),(51444404,425097762,15255003,427965,1,'2007-09-14 22:12:33',3310491443,1),(51444405,425096812,15257063,427965,1,'2007-09-14 22:12:33',3310491443,1),(51444406,425097255,15259380,427965,1,'2007-09-14 22:12:33',3310491443,1),(51444408,425097731,15260335,437032,1,'2008-05-13 20:34:15',3310491443,2),(51444410,425096812,15261784,427965,1,'2007-09-14 22:12:33',3310491443,1),(51444411,425096529,15262995,437032,1,'2008-05-13 20:39:16',3310491443,2),(51444444,425106779,15269347,437032,1,'2008-05-13 20:32:39',3310491443,2),(51444468,425101211,15266257,437032,1,'2008-05-13 20:34:15',3310491443,2),(51444470,425103742,15270377,437032,1,'2008-05-13 20:34:15',3310491443,2),(51444471,425105261,15270034,437032,1,'2008-05-13 20:34:15',3310491443,2),(51444652,425092700,15227709,427965,1,'2007-09-14 22:10:22',3310491442,1),(51444653,425095484,15238266,427965,1,'2007-09-14 22:10:22',3310491443,1),(51444884,425089726,15217323,427965,1,'2007-09-14 22:10:34',3310491442,1),(51444885,425086436,15212345,427965,1,'2007-09-14 22:10:34',3310491440,1),(51444886,425082975,15216773,592895,1,'2008-07-25 23:51:45',3310491442,2),(51444888,425084051,15220035,592895,1,'2008-07-25 23:51:45',3310491442,2),(51444889,425085063,15225614,592895,1,'2008-07-25 23:51:45',3310491442,2),(51444891,425083798,15229562,592895,1,'2008-07-25 23:51:45',3310491442,2),(51444892,425082576,15232000,427965,1,'2007-09-14 22:10:22',3310491442,1),(51444894,425084095,15234489,427965,1,'2007-09-14 22:10:22',3310491442,1),(51444896,425089536,15226336,427965,1,'2007-09-14 22:10:22',3310491442,1),(51444897,425090169,15224962,427965,1,'2007-09-14 22:10:22',3310491442,1),(51444898,425090232,15223503,427965,1,'2007-09-14 22:10:22',3310491442,1),(51444899,425091118,15222473,427965,1,'2007-09-14 22:10:22',3310491442,1),(51444902,425091877,15223503,427965,1,'2007-09-14 22:10:22',3310491442,1),(51445067,425079476,15203161,427965,1,'2007-09-14 22:10:34',3310491440,1),(51445068,425077388,15201359,427965,1,'2007-09-14 22:10:34',3310491440,1),(51445069,425076312,15200586,427965,1,'2007-09-14 22:10:34',3310491440,1),(51445070,425075426,15201788,427965,1,'2007-09-14 22:10:34',3310491440,1),(51445071,425074920,15202904,427965,1,'2007-09-14 22:10:55',3310491440,1),(51445073,425073971,15203505,427965,1,'2007-09-14 22:10:34',3310491440,1),(51445113,425080931,15215693,427965,1,'2007-09-14 22:10:47',3310491440,1),(51445209,425077514,15210114,427965,1,'2007-09-14 22:10:47',3310491440,1),(51445210,425078843,15212946,427965,1,'2007-09-14 22:10:47',3310491440,1),(51445276,425074179,15191520,91018,1,'2008-06-07 20:24:45',3310491440,2),(51445277,425075869,15196209,427965,1,'2007-09-14 22:10:55',3310491440,1),(51445278,425075869,15198698,427965,1,'2007-09-14 22:10:55',3310491440,1),(51445766,425087575,15272083,427965,1,'2007-09-14 22:11:20',3310491448,1),(51445767,425087005,15263758,427965,1,'2007-09-14 22:11:20',3310491442,1),(51445769,425084095,15248566,427965,1,'2007-09-14 22:11:20',3310491442,1),(51445772,425082829,15245905,427965,1,'2007-09-14 22:11:20',3310491442,1),(51445774,425081564,15245733,427965,1,'2007-09-14 22:11:20',3310491442,1),(51445785,425087828,15278864,427965,1,'2007-09-14 22:12:33',3310491448,1),(51446293,425066378,15275259,427965,1,'2007-09-14 22:11:53',3310491437,1),(51446294,425071503,15279207,427965,1,'2007-09-14 22:11:53',3310491448,1),(51446295,425072199,15280323,427965,1,'2007-09-14 22:11:53',3310491448,1),(51446297,425072453,15281696,427965,1,'2007-09-14 22:11:53',3310491448,1),(51446298,425071630,15283499,427965,1,'2007-09-14 22:11:53',3310491448,1),(51446299,425069036,15286760,427965,1,'2007-09-14 22:11:53',3310491448,1),(51446300,425066062,15282125,427965,1,'2007-09-14 22:11:53',3310491437,1),(51446302,425064037,15285044,427965,1,'2007-09-14 22:11:53',3310491437,1),(51446303,425059481,15281954,427965,1,'2007-09-14 22:11:53',3310491437,1),(51446306,425058216,15275087,427965,1,'2007-09-14 22:11:53',3310491437,1),(51446307,425059102,15274658,427965,1,'2007-09-14 22:11:53',3310491437,1),(51446309,425057457,15271225,427965,1,'2007-09-14 22:11:53',3310491431,1),(51446312,425058469,15269423,427965,1,'2007-09-14 22:11:53',3310491431,1),(51446485,425104721,15317144,427965,1,'2007-09-14 22:12:31',3310491449,1),(51446486,425107632,15326500,427965,1,'2007-09-14 22:12:31',3310491451,1),(51446487,425109530,15330963,427965,1,'2007-09-14 22:12:31',3310491451,1),(51446490,425112061,15333967,427965,1,'2007-09-14 22:12:31',3310491451,1),(51446491,425115161,15336027,427965,1,'2007-09-14 22:12:31',3310491451,1),(51446492,425117122,15337400,427965,1,'2007-09-14 22:12:31',3310491451,1),(51446494,425119843,15342894,427965,1,'2007-09-14 22:12:31',3310491451,1),(51446496,425121298,15346842,427965,1,'2007-09-14 22:12:31',3310491451,1),(51446497,425122627,15348816,427965,1,'2007-09-14 22:12:31',3310491454,1),(51446498,425124968,15349846,427965,1,'2007-09-14 22:12:31',3310491454,1),(51446677,425101241,15294914,427965,1,'2007-09-14 22:12:31',3310491449,1),(51446679,425101241,15296974,427965,1,'2007-09-14 22:12:31',3310491449,1),(51446680,425101684,15301867,427965,1,'2007-09-14 22:12:31',3310491449,1),(51446682,425102001,15304356,427965,1,'2007-09-14 22:12:31',3310491449,1),(51446684,425101621,15306587,427965,1,'2007-09-14 22:12:31',3310491449,1),(51446687,425101621,15308905,427965,1,'2007-09-14 22:12:31',3310491449,1),(51446688,425101874,15310020,427965,1,'2007-09-14 22:12:31',3310491449,1),(51446690,425103140,15312510,427965,1,'2007-09-14 22:12:31',3310491449,1),(51446992,425054920,15291959,981792,1,'2009-04-27 01:35:55',3310491437,3),(51446997,425062961,15303326,981792,1,'2009-04-27 01:35:56',3310491437,2),(51447331,425060620,15306072,427965,1,'2007-09-14 22:13:13',3310491437,1),(51447714,425095698,15396877,188228,1,'2008-06-16 18:47:01',3310491537,2),(51447737,425095674,15407782,305941,1,'2009-02-09 21:21:41',3310491537,2),(51448127,425095381,15390697,188228,1,'2008-06-16 19:09:32',3310491537,6),(51448405,425111365,15396795,427965,1,'2007-09-14 22:14:55',3310491537,1),(51448408,425106556,15393019,427965,1,'2007-09-14 22:14:55',3310491537,1),(51448409,425100569,15388122,188228,1,'2008-06-16 19:09:56',3310491537,4),(51448537,425101241,15391216,427965,1,'2007-09-14 22:15:09',3310491537,1),(51448538,425101329,15393787,188228,1,'2008-06-16 18:39:09',3310491537,2),(51448539,425100506,15397048,188228,1,'2008-06-16 18:44:40',3310491537,3),(51448541,425099494,15399537,188228,1,'2008-06-16 18:45:06',3310491537,3),(51448824,425342004,15773420,427965,1,'2007-09-14 22:19:21',3310491643,1),(51448827,425338399,15774107,454632,1,'2007-09-17 19:59:14',3310491643,1),(51448828,425334608,15775868,188228,1,'2008-06-16 20:02:58',3310491643,2),(51448830,425329295,15778185,188228,1,'2008-06-16 20:02:41',3310491643,5),(51448926,425340296,15805349,427965,1,'2007-09-14 22:19:21',3310491643,1),(51448928,425340802,15803118,427965,1,'2007-09-14 22:19:21',3310491643,1),(51448929,425342699,15798998,427965,1,'2007-09-14 22:19:21',3310491646,1),(51448931,425344660,15796938,427965,1,'2007-09-14 22:19:21',3310491646,1),(51448934,425346874,15794191,427965,1,'2007-09-14 22:19:21',3310491646,1),(51448936,425347569,15792303,427965,1,'2007-09-14 22:19:21',3310491646,1),(51448937,425345609,15779343,427965,1,'2007-09-14 22:19:21',3310491646,1),(51448938,425345039,15775824,427965,1,'2007-09-14 22:19:21',3310491646,1),(51448940,425344524,15773962,188228,1,'2008-06-16 20:04:22',3310491646,2),(51449055,425361420,15790501,427965,1,'2007-09-14 22:16:28',3310491646,1),(51449056,425360661,15787497,427965,1,'2007-09-14 22:16:28',3310491646,1),(51449057,425359270,15782261,427965,1,'2007-09-14 22:16:28',3310491646,1),(51449058,425359017,15779943,427965,1,'2007-09-14 22:16:28',3310491646,1),(51449060,425359333,15778313,427965,1,'2007-09-14 22:16:28',3310491646,1),(51449062,425358764,15776510,427965,1,'2007-09-14 22:16:28',3310491646,1),(51449064,425356866,15766211,427965,1,'2007-09-14 22:16:28',3310491646,1),(51449130,425354526,15794191,427965,1,'2007-09-14 22:16:34',3310491646,1),(51449133,425355601,15792046,427965,1,'2007-09-14 22:16:34',3310491646,1),(51449134,425357372,15781059,427965,1,'2007-09-14 22:16:34',3310491646,1),(51449137,425356613,15778399,427965,1,'2007-09-14 22:16:34',3310491646,1),(51449139,425356866,15777369,427965,1,'2007-09-14 22:16:34',3310491646,1),(51449140,425357689,15775995,427965,1,'2007-09-14 22:16:34',3310491646,1),(51449148,425358700,15775480,427965,1,'2007-09-14 22:16:34',3310491646,1),(51449177,425347253,15793419,427965,1,'2007-09-14 22:19:21',3310491646,1),(51449178,425349024,15792131,427965,1,'2007-09-14 22:16:34',3310491646,1),(51449179,425351554,15792046,427965,1,'2007-09-14 22:16:34',3310491646,1),(51449552,425330999,15848093,427965,1,'2007-09-14 22:18:51',3310493009,1),(51449553,425327267,15843887,427965,1,'2007-09-14 22:18:51',3310493009,1),(51449672,425322966,15839167,427965,1,'2007-09-14 22:18:51',3310493009,1),(51449673,425320942,15836420,427965,1,'2007-09-14 22:18:51',3310493009,1),(51449675,425319171,15832644,427965,1,'2007-09-14 22:18:51',3310493009,1),(51449676,425317843,15828695,427965,1,'2007-09-14 22:18:51',3310493009,1),(51449997,425316452,15823460,427965,1,'2007-09-14 22:18:51',3310493009,1),(51449998,425316452,15817451,427965,1,'2007-09-14 22:18:51',3310491643,1),(51449999,425316894,15808353,427965,1,'2007-09-14 22:18:51',3310491643,1),(51450002,425317400,15796423,427965,1,'2007-09-14 22:18:51',3310491643,1),(51450003,425317780,15786037,427965,1,'2007-09-14 22:18:51',3310491643,1),(51450004,425317084,15774536,427965,1,'2007-09-14 22:18:51',3310491643,1),(51450007,425315250,15760117,427965,1,'2007-09-14 22:18:51',3310491641,1),(51450008,425313163,15751190,427965,1,'2007-09-14 22:18:51',3310491640,1),(51450009,425309874,15743122,427965,1,'2007-09-14 22:18:51',3310491640,1),(51450011,425307280,15738487,427965,1,'2007-09-14 22:18:51',3310491640,1),(51450013,425302094,15733852,427965,1,'2007-09-14 22:18:51',3310491640,1),(51450014,425296465,15730333,427965,1,'2007-09-14 22:18:51',3310491640,1),(51450016,425293935,15726900,427965,1,'2007-09-14 22:18:51',3310491640,1),(51450017,425292986,15724497,427965,1,'2007-09-14 22:18:51',3310491640,1),(51450019,425292610,15719563,188228,1,'2008-06-16 19:41:47',3310491640,2),(51450106,425295201,15715529,4963967,1,'2010-06-11 20:09:40',3310491640,4),(51450107,425294561,15713791,4963967,1,'2010-06-11 20:09:40',3310491640,4),(51450110,425293364,15713528,4963967,1,'2010-06-11 20:09:40',3310491640,3),(51450111,425292501,15714426,4963967,1,'2010-06-11 20:09:41',3310491640,4),(51450113,425292300,15715443,4963967,1,'2010-06-11 20:09:41',3310491640,4),(51450114,425292431,15716248,4963967,1,'2010-06-11 20:09:41',3310491640,5),(51450116,425293129,15717207,4963967,1,'2010-06-11 20:09:41',3310491640,3),(51450118,425294262,15717271,4963967,1,'2010-06-11 20:09:41',3310491640,4),(51450178,425292874,15713858,4963967,1,'2010-06-11 20:09:40',3310491640,3),(51450303,425295021,15716383,4963967,1,'2010-06-11 20:09:41',3310491640,4),(51450764,425350605,15769730,427965,1,'2007-09-14 22:19:20',3310491646,1),(51450766,425345988,15775738,427965,1,'2007-09-14 22:19:20',3310491646,1),(51450767,425345229,15776081,427965,1,'2007-09-14 22:19:20',3310491646,1),(51552405,425168593,15276498,432736,1,'2007-09-15 01:37:41',3310491453,1),(51552408,425167422,15280234,432736,1,'2007-09-15 01:37:41',3310491453,1),(51552410,425167010,15284761,432736,1,'2007-09-15 01:37:42',3310491453,1),(51552413,425171285,15269088,461502,1,'2008-05-16 19:07:44',3310491447,3),(51552416,425172740,15265397,461502,1,'2008-05-16 19:07:44',3310491447,3),(51552419,425174827,15260591,461502,1,'2008-05-16 19:07:44',3310491447,3),(51552422,425177674,15257072,461502,1,'2008-05-16 18:47:55',3310491490,2),(51552429,425184190,15248832,461502,1,'2008-05-16 18:47:55',3310491490,3),(51552432,425188492,15242137,461502,1,'2008-05-16 18:44:51',3310491490,3),(51552434,425190517,15239305,461502,1,'2008-05-16 18:44:51',3310491490,3),(51552437,425194122,15237674,461502,1,'2008-05-16 18:41:28',3310491490,2),(51552440,425197286,15237073,461502,1,'2008-05-16 18:41:28',3310491490,2),(51552442,425202577,15235835,463410,1,'2008-05-17 14:55:40',3310491490,3),(51552444,425205067,15234498,461502,1,'2008-05-16 18:39:56',3310491491,2),(51552445,425208040,15233211,461502,1,'2008-05-16 18:39:56',3310491491,2),(51552447,425210317,15232009,461502,1,'2008-05-16 18:39:56',3310491491,2),(51552451,425212025,15230979,461502,1,'2008-05-16 18:39:56',3310491491,2),(51552453,425214303,15228833,461502,1,'2008-05-16 18:39:56',3310491491,2),(51552456,425216517,15225744,461502,1,'2008-05-16 18:39:56',3310491491,2),(51552459,425218857,15222482,461502,1,'2008-05-16 18:39:56',3310491491,2),(51552462,425222083,15219478,461502,1,'2008-05-16 18:38:38',3310491491,2),(51552466,425239796,15210380,461502,1,'2008-05-16 18:36:34',3310491492,4),(51552468,425236949,15212268,461502,1,'2008-05-16 18:38:38',3310491492,2),(51552471,425226258,15217675,461502,1,'2008-05-16 18:38:38',3310491491,2),(51552473,425241187,15209436,461502,1,'2008-05-16 18:36:34',3310491492,5),(51552476,425242832,15208234,461502,1,'2008-05-16 18:36:34',3310491492,5),(51552477,425245172,15207118,461502,1,'2008-05-16 18:35:59',3310491492,5),(51552480,425249980,15206088,461502,1,'2008-05-16 18:36:10',3310491492,4),(51552483,425255814,15205593,2895121,1,'2009-10-19 19:12:50',3310491492,4),(51552486,425259742,15205290,370566,1,'2008-05-09 02:14:23',3310491492,3),(51552489,425261925,15204659,370566,1,'2008-05-09 02:14:24',3310491493,3),(51552492,425262708,15204389,370566,1,'2008-05-09 02:14:24',3310491493,3),(51552495,425263814,15203876,370566,1,'2008-05-09 02:14:24',3310491493,3),(51552497,425264815,15203452,370566,1,'2008-05-09 02:14:24',3310491493,3),(51552500,425265612,15203143,370566,1,'2008-05-09 02:14:24',3310491493,3),(51552504,425192225,15238275,461502,1,'2008-05-16 18:44:01',3310491490,2),(51552507,425275421,15203690,435967,1,'2007-09-15 21:59:37',3310491493,1),(51552509,425278761,15205568,435967,1,'2007-09-15 21:59:37',3310491493,1),(51552513,425282326,15207433,432736,1,'2007-09-15 01:37:50',3310491493,1),(51552516,425287981,15207617,432736,1,'2007-09-15 01:37:50',3310491504,1),(51552518,425292642,15206485,432736,1,'2007-09-15 01:37:50',3310491504,1),(51552546,425295024,15204854,432736,1,'2007-09-15 01:37:53',3310491504,1),(51552549,425296786,15203287,432736,1,'2007-09-15 01:37:54',3310491504,1),(51552550,425299234,15201395,432736,1,'2007-09-15 01:37:54',3310491504,1),(51552553,425301453,15199959,432736,1,'2007-09-15 01:37:54',3310491504,1),(51552555,425303998,15199176,432736,1,'2007-09-15 01:37:54',3310491504,1),(51552557,425306869,15198980,432736,1,'2007-09-15 01:37:54',3310491504,1),(51552559,425309937,15198915,432736,1,'2007-09-15 01:37:55',3310491504,1),(51552562,425311960,15198197,432736,1,'2007-09-15 01:37:55',3310491504,1),(51552565,425314570,15196109,432736,1,'2007-09-15 01:37:55',3310491504,1),(51552569,425317507,15195325,432736,1,'2007-09-15 01:37:55',3310491505,1),(51552572,425320749,15195933,432736,1,'2007-09-15 01:37:56',3310491505,1),(51552575,425325791,15197585,432736,1,'2007-09-15 01:37:56',3310491505,1),(51552578,425333039,15194999,174860,1,'2008-12-06 16:19:27',3310491505,2),(51552581,425335664,15193760,174860,1,'2008-12-06 16:19:27',3310491505,2),(51552583,425339370,15193578,174860,1,'2008-12-06 16:19:27',3310491505,2),(51552587,425342646,15195034,174860,1,'2008-12-06 16:19:27',3310491508,2),(51552589,425297692,15185080,432736,1,'2007-09-15 01:37:57',3310491504,1),(51552592,425300993,15197225,432736,1,'2007-09-15 01:37:57',3310491504,1),(51552595,425341214,15194076,174860,1,'2008-12-06 16:19:27',3310491505,2),(51552599,425337486,15193436,174860,1,'2008-12-06 16:19:27',3310491505,2),(51552602,425327765,15197347,210114,1,'2008-08-12 23:32:51',3310491505,3),(51552605,425331367,15195879,174860,1,'2008-12-06 16:19:27',3310491505,2),(51552608,425323729,15197335,432736,1,'2007-09-15 01:37:58',3310491505,1),(51552612,425345476,15197722,174860,1,'2008-12-06 16:19:27',3310491508,2),(51552615,425348423,15200579,174860,1,'2008-12-06 16:19:27',3310491508,2),(51552619,425352122,15204756,174860,1,'2008-12-06 16:19:27',3310491508,2),(51552622,425355525,15209011,174860,1,'2008-12-06 16:19:27',3310491508,2),(51552625,425358733,15212789,174860,1,'2008-12-06 16:19:27',3310491508,3),(51552628,425359568,15212579,174860,1,'2008-12-06 16:19:27',3310491508,2),(51552630,425360923,15211780,174860,1,'2008-12-06 16:19:27',3310491508,2),(51552633,425361408,15210760,174860,1,'2008-12-06 16:19:27',3310491508,2),(51552635,425363346,15207441,174860,1,'2008-12-06 16:19:27',3310491508,2),(51552637,425365396,15205062,174860,1,'2008-12-06 16:19:27',3310491508,2),(51552640,425368307,15202130,174860,1,'2008-12-06 16:19:27',3310491508,3),(51552643,425372987,15200070,174860,1,'2008-12-06 16:19:27',3310491509,3),(51552645,425378919,15197927,174860,1,'2008-12-06 16:19:27',3310491509,2),(51552648,425384398,15195975,174860,1,'2008-12-06 16:19:27',3310491509,2),(51552651,425390003,15194085,448710,1,'2008-05-14 17:04:23',3310491509,2),(51552653,425392021,15193528,174860,1,'2008-12-06 16:19:27',3310491509,2),(51552656,425356645,15211072,174860,1,'2008-12-06 16:19:27',3310491508,3),(51552659,425353966,15206879,174860,1,'2008-12-06 16:19:27',3310491508,2),(51552660,425362169,15209390,174860,1,'2008-12-06 16:19:27',3310491508,2),(51552664,425357531,15212274,174860,1,'2008-12-06 16:19:27',3310491508,3),(51552667,425366410,15203760,174860,1,'2008-12-06 16:19:27',3310491508,3),(51552671,425344861,15197138,174860,1,'2008-12-06 16:19:27',3310491508,2),(51552672,425397569,15192394,174860,1,'2008-12-06 16:19:27',3310502432,2),(51552675,425399694,15193183,174860,1,'2008-12-06 16:19:27',3310502432,2),(51552679,425402306,15194884,174860,1,'2008-12-06 16:19:27',3310502432,2),(51552682,425404674,15195491,174860,1,'2008-12-06 16:19:28',3310502432,2),(51552686,425406617,15195491,174860,1,'2008-12-06 16:19:28',3310502432,2),(51552688,425408986,15194580,174860,1,'2008-12-06 16:19:28',3310502432,2),(51552691,425410504,15192819,174860,1,'2008-12-06 16:19:28',3310502432,2),(51552693,425412387,15189054,174860,1,'2008-12-06 16:19:28',3310502432,2),(51552694,425414755,15184256,174860,1,'2008-12-06 16:19:28',3310502432,2),(51552699,425417084,15179091,174860,1,'2008-12-06 16:19:28',3310502432,2),(51552702,425418890,15177028,174860,1,'2008-12-06 16:19:28',3310502432,2),(51552705,425421262,15175222,174860,1,'2008-12-06 16:19:28',3310502432,2),(51552707,425428071,15171663,174860,1,'2008-12-06 16:19:28',3310502433,2),(51552709,425431887,15169910,174860,1,'2008-12-06 16:19:28',3310502433,2),(51552710,425433900,15167802,174860,1,'2008-12-06 16:19:28',3310502433,2),(51552711,425436391,15164544,174860,1,'2008-12-06 16:19:28',3310502433,3),(51552712,425440033,15160423,174860,1,'2008-12-06 16:19:28',3310502411,2),(51552715,425443099,15157356,174860,1,'2008-12-06 16:19:28',3310502411,2),(51552717,425446549,15154865,174860,1,'2008-12-06 16:19:28',3310502411,2),(51552720,425450191,15152660,174860,1,'2008-12-06 16:19:28',3310502411,2),(51552722,425453449,15151223,174860,1,'2008-12-06 16:19:28',3310502414,2),(51552723,425455366,15149786,174860,1,'2008-12-06 16:19:28',3310502414,2),(51552726,425456420,15147102,174860,1,'2008-12-06 16:19:28',3310502414,2),(51552727,425457187,15144802,174860,1,'2008-12-06 16:19:29',3310502414,2),(51552728,425460061,15140969,174860,1,'2008-12-06 16:19:29',3310502414,2),(51552731,425462656,15140044,174860,1,'2008-12-06 16:19:29',3310502414,2),(51552733,425465321,15139381,174860,1,'2008-12-06 16:19:29',3310502414,2),(51552736,425469214,15136948,432736,1,'2007-09-15 02:31:16',3310502414,1),(51552737,425471370,15135794,432736,1,'2007-09-15 01:38:10',3310502414,1),(51552740,425474743,15133705,432736,1,'2007-09-15 01:38:10',3310502414,1),(51552744,425476697,15134152,306164,1,'2008-05-01 17:04:02',3310502414,7),(51552747,425478423,15133628,432736,1,'2007-09-15 01:38:10',3310502414,1),(51552750,425481183,15132632,432736,1,'2007-09-15 01:38:11',3310502415,1),(51552755,425484786,15130102,432736,1,'2007-09-15 01:38:11',3310502415,1),(51552758,425491992,15123432,432736,1,'2007-09-15 01:38:11',3310502415,1),(51552761,425499921,15116558,306164,1,'2008-05-01 17:19:32',3310502415,2),(51552762,425508331,15105915,306164,1,'2008-05-01 17:19:32',3310502424,2),(51552764,425515989,15094683,432736,1,'2007-09-15 01:38:13',3310502424,1),(51552766,425519362,15089469,432736,1,'2007-09-15 01:38:14',3310502424,1),(51552768,425526415,15081803,432736,1,'2007-09-15 01:38:14',3310502424,1),(51552770,425529175,15078046,432736,1,'2007-09-15 01:38:15',3310502424,1),(51552773,425532699,15074437,432736,1,'2007-09-15 01:38:15',3310502424,1),(51552774,425536515,15070145,432736,1,'2007-09-15 01:38:15',3310502425,1),(51552777,425540012,15068078,432736,1,'2007-09-15 01:38:16',3310502425,1),(51552779,425543668,15066489,432736,1,'2007-09-15 01:38:16',3310502425,1),(51552782,425548756,15065853,432736,1,'2007-09-15 01:38:17',3310502425,1),(51552785,425552571,15064422,432736,1,'2007-09-15 01:38:17',3310502425,1),(51552787,425555591,15061719,432736,1,'2007-09-15 01:38:17',3310502425,1),(51552789,425560520,15058063,432736,1,'2007-09-15 01:38:17',3310502425,1),(51552791,425564812,15055361,432736,1,'2007-09-15 01:38:17',3310502428,1),(51552793,425566719,15052499,432736,1,'2007-09-15 01:38:18',3310502428,1),(51552797,425570535,15049479,432736,1,'2007-09-15 01:38:18',3310502422,1),(51552800,425573555,15047730,432736,1,'2007-09-15 01:38:18',3310502422,1),(51552802,425578642,15047412,432736,1,'2007-09-15 01:38:18',3310502422,1),(51552806,425584365,15047253,432736,1,'2007-09-15 01:38:19',3310502422,1),(51552807,425586909,15046776,432736,1,'2007-09-15 01:38:19',3310502422,1),(51552811,425588181,15045504,432736,1,'2007-09-15 01:38:19',3310502422,1),(51552814,425589875,15043383,432736,1,'2007-09-15 01:38:19',3310502423,1),(51552815,425593217,15039333,432736,1,'2007-09-15 01:38:19',3310502423,1),(51552818,425596862,15035788,432736,1,'2007-09-15 01:38:20',3310502423,1),(51552821,425600508,15032446,432736,1,'2007-09-15 01:38:20',3310502423,1),(51552823,425603343,15028902,432736,1,'2007-09-15 01:38:20',3310502423,1),(51552824,425605571,15026168,432736,1,'2007-09-15 01:38:20',3310502423,1),(51552825,425607394,15024345,432736,1,'2007-09-15 01:38:20',3310502423,1),(51552828,425610027,15022927,432736,1,'2007-09-15 01:38:20',3310502423,1),(51552830,425612458,15021712,432736,1,'2007-09-15 01:38:21',3310502423,1),(51552832,425613571,15019990,432736,1,'2007-09-15 01:38:21',3310502423,1),(51552835,425614078,15018370,432736,1,'2007-09-15 01:38:21',3310502423,1),(51552838,425613977,15016446,432736,1,'2007-09-15 01:38:21',3310502423,1),(51552841,425613774,15014320,432736,1,'2007-09-15 01:38:21',3310502423,1),(51552844,425613875,15012193,432736,1,'2007-09-15 01:38:21',3310502423,1),(51552847,425614382,15010066,432736,1,'2007-09-15 01:38:22',3310502423,1),(51552849,425615090,15008446,432736,1,'2007-09-15 01:38:22',3310502423,1),(51552851,425616508,15005104,432736,1,'2007-09-15 01:38:22',3310502423,1),(51552852,425617116,15002674,432736,1,'2007-09-15 01:38:22',3310502466,1),(51552854,425617318,14999433,432736,1,'2007-09-15 01:38:22',3310502466,1),(51552856,425616913,14992648,432736,1,'2007-09-15 01:38:22',3310502464,1),(51552859,425616103,14987889,432736,1,'2007-09-15 01:38:22',3310502421,1),(51552861,425615394,14984243,432736,1,'2007-09-15 01:38:23',3310502421,1),(51552863,425614787,14979484,432736,1,'2007-09-15 01:38:23',3310502421,1),(51552865,425614685,14976446,432736,1,'2007-09-15 01:38:23',3310502421,1),(51552868,425614709,14973998,432736,1,'2007-09-15 01:38:23',3310502421,1),(51552871,425614709,14972772,432736,1,'2007-09-15 01:38:23',3310502421,1),(51552873,425614787,14971490,432736,1,'2007-09-15 01:38:23',3310502421,1),(51552875,425614811,14966812,432736,1,'2007-09-15 01:41:47',3310502421,1),(51554685,425615950,14965540,432736,1,'2007-09-15 01:41:44',3310502421,1),(51554688,425615701,14965073,432736,1,'2007-09-15 01:41:44',3310502421,1),(51554691,425615355,14964827,432736,1,'2007-09-15 01:41:44',3310502421,1),(51554693,425614978,14964740,432736,1,'2007-09-15 01:41:44',3310502421,1),(51554694,425614598,14964796,432736,1,'2007-09-15 01:41:44',3310502421,1),(51554697,425614240,14965008,432736,1,'2007-09-15 01:41:44',3310502421,1),(51554700,425613989,14965352,432736,1,'2007-09-15 01:41:44',3310502421,1),(51554703,425613900,14965846,432736,1,'2007-09-15 01:41:44',3310502421,1),(51554705,425614040,14966305,432736,1,'2007-09-15 01:41:44',3310502421,1),(51554707,425614430,14966687,432736,1,'2007-09-15 01:41:45',3310502421,1),(51554710,425615160,14966796,432736,1,'2007-09-15 01:41:45',3310502421,1),(51554712,425615502,14966653,432736,1,'2007-09-15 01:41:45',3310502421,1),(51554715,425615734,14966448,432736,1,'2007-09-15 01:41:45',3310502421,1),(51554716,425615933,14966083,432736,1,'2007-09-15 01:41:45',3310502421,1),(51557999,425613611,14965020,370566,1,'2008-05-09 02:14:23',3310502421,2),(51558001,425612892,14964653,370566,1,'2008-05-09 02:14:23',3310502421,2),(51558003,425611587,14963476,432736,1,'2007-09-15 01:47:01',3310502421,1),(51558005,425610666,14962303,432736,1,'2007-09-15 01:47:01',3310502421,1),(51558007,425609681,14960502,432736,1,'2007-09-15 01:47:02',3310502421,1),(51558010,425608550,14958910,432736,1,'2007-09-15 01:47:02',3310502421,1),(51558014,425607712,14957695,432736,1,'2007-09-15 01:47:02',3310502421,1),(51558017,425606518,14956208,432736,1,'2007-09-15 01:47:02',3310502421,1),(51558021,425605345,14954846,432736,1,'2007-09-15 01:47:03',3310502421,1),(51558024,425604738,14953841,432736,1,'2007-09-15 01:47:03',3310502421,1),(51558026,425604319,14952730,432736,1,'2007-09-15 01:47:03',3310502421,1),(51558029,425602915,14950322,432736,1,'2007-09-15 01:47:04',3310502421,1),(51558031,425601282,14947960,432736,1,'2007-09-15 01:47:04',3310502421,1),(51558033,425599834,14946223,432736,1,'2007-09-15 01:47:04',3310502421,1),(51558036,425598314,14944413,432736,1,'2007-09-15 01:47:04',3310502421,1),(51558038,425597445,14943472,432736,1,'2007-09-15 01:47:05',3310502421,1),(51558040,425595563,14941481,432736,1,'2007-09-15 01:47:05',3310502079,1),(51558041,425594622,14941300,432736,1,'2007-09-15 01:47:05',3310502079,1),(51558043,425592052,14940830,432736,1,'2007-09-15 01:47:05',3310502079,1),(51558045,425590749,14940250,432736,1,'2007-09-15 01:47:05',3310502079,1),(51558047,425588794,14939527,432736,1,'2007-09-15 01:47:05',3310502078,1),(51558051,425585038,14937175,432736,1,'2007-09-15 01:47:05',3310502078,1),(51558054,425583837,14936095,432736,1,'2007-09-15 01:47:06',3310502078,1),(51558057,425580133,14934280,432736,1,'2007-09-15 01:47:06',3310502078,1),(51558059,425576994,14932907,432736,1,'2007-09-15 01:47:06',3310502078,1),(51558060,425575596,14932343,432736,1,'2007-09-15 01:47:07',3310502078,1),(51558063,425574345,14931607,432736,1,'2007-09-15 01:47:07',3310502078,1),(51558064,425573241,14930405,432736,1,'2007-09-15 01:47:08',3310502078,1),(51558067,425571917,14929203,432736,1,'2007-09-15 01:47:08',3310502078,1),(51558070,425569683,14927373,432736,1,'2007-09-15 01:47:09',3310502078,1),(51558071,425566632,14924932,432736,1,'2007-09-15 01:47:09',3310502078,1),(51558074,425563763,14922979,432736,1,'2007-09-15 01:47:10',3310502078,1),(51558075,425562237,14921453,432736,1,'2007-09-15 01:47:11',3310502078,1),(51558078,425561139,14919744,432736,1,'2007-09-15 01:47:11',3310502075,1),(51558083,425559857,14917425,432736,1,'2007-09-15 01:47:14',3310502075,1),(51558085,425558515,14915960,432736,1,'2007-09-15 01:47:15',3310502075,1),(51558086,425557050,14914068,432736,1,'2007-09-15 01:47:15',3310502075,1),(51558089,425554731,14912543,432736,1,'2007-09-15 01:47:16',3310502075,1),(51558091,425552534,14911688,432736,1,'2007-09-15 01:47:16',3310502075,1),(51558093,425551191,14910773,432736,1,'2007-09-15 01:47:16',3310502075,1),(51558095,425550520,14909552,432736,1,'2007-09-15 01:47:17',3310502075,1),(51558097,425549543,14908087,432736,1,'2007-09-15 01:47:17',3310502075,1),(51558099,425548750,14906806,432736,1,'2007-09-15 01:47:17',3310502075,1),(51558103,425547590,14905829,432736,1,'2007-09-15 01:47:17',3310502075,1),(51558105,425545454,14904853,432736,1,'2007-09-15 01:47:18',3310502075,1),(51558108,425543074,14903266,432736,1,'2007-09-15 01:47:18',3310502075,1),(51558111,425539290,14900703,432736,1,'2007-09-15 01:47:18',3310502075,1),(51558113,425536727,14898140,432736,1,'2007-09-15 01:47:18',3310502075,1),(51558115,425535811,14895698,432736,1,'2007-09-15 01:47:19',3310502075,1),(51558118,425535201,14892464,432736,1,'2007-09-15 01:47:19',3310502075,1),(51558121,425535018,14888680,432736,1,'2007-09-15 01:47:19',3310502075,1),(51558124,425534896,14884286,432736,1,'2007-09-15 01:47:19',3310502073,1),(51558125,425534896,14881234,432736,1,'2007-09-15 01:47:20',3310502073,1),(51558128,425534041,14878976,432736,1,'2007-09-15 01:47:20',3310502072,1),(51558131,425532150,14876291,432736,1,'2007-09-15 01:47:20',3310502072,1),(51558246,425530380,14874033,432736,1,'2007-09-15 01:47:38',3310502072,1),(51558248,425528488,14871225,432736,1,'2007-09-15 01:47:38',3310502072,1),(51558253,425527206,14869638,432736,1,'2007-09-15 01:47:39',3310502072,1),(51558257,425525924,14868967,432736,1,'2007-09-15 01:47:39',3310502072,1),(51558260,425524643,14869089,432736,1,'2007-09-15 01:47:39',3310502072,1),(51558262,425523300,14869699,432736,1,'2007-09-15 01:47:39',3310502072,1),(51558265,425520432,14871652,432736,1,'2007-09-15 01:47:39',3310502072,1),(51558268,425518479,14873117,432736,1,'2007-09-15 01:47:39',3310502072,1),(51558271,425516404,14874033,432736,1,'2007-09-15 01:47:39',3310502072,1),(51558273,425513535,14874826,432736,1,'2007-09-15 01:47:40',3310502072,1),(51558276,425510850,14875863,432736,1,'2007-09-15 01:47:40',3310502072,1),(51558279,425507982,14876474,432736,1,'2007-09-15 01:47:40',3310502072,1),(51558282,425505968,14877450,432736,1,'2007-09-15 01:47:40',3310502061,1),(51558284,425503832,14878793,432736,1,'2007-09-15 01:47:40',3310502061,1),(51558287,425502001,14879830,432736,1,'2007-09-15 01:47:41',3310502061,1),(51558293,425499376,14878854,432736,1,'2007-09-15 01:47:41',3310502061,1),(51558295,425498034,14876779,432736,1,'2007-09-15 01:47:41',3310502061,1),(51558298,425496935,14875192,432736,1,'2007-09-15 01:47:41',3310502061,1),(51558301,425495348,14873727,432736,1,'2007-09-15 01:47:41',3310502061,1),(51558304,425493639,14873422,432736,1,'2007-09-15 01:47:41',3310502061,1),(51558305,425491809,14873300,432736,1,'2007-09-15 01:47:42',3310502061,1),(51563059,425490386,14873969,432736,1,'2007-09-15 01:56:05',3310502061,1),(51563061,425489160,14874402,432736,1,'2007-09-15 01:56:05',3310502061,1),(51563063,425487862,14874402,432736,1,'2007-09-15 01:56:05',3310502061,1),(51563066,425485843,14874041,432736,1,'2007-09-15 01:56:05',3310502061,1),(51563071,425483968,14873392,432736,1,'2007-09-15 01:56:05',3310502061,1),(51563075,425481877,14872491,432736,1,'2007-09-15 01:56:05',3310502061,1),(51563076,425480795,14871589,432736,1,'2007-09-15 01:56:06',3310502061,1),(51563080,425479641,14869714,432736,1,'2007-09-15 01:56:06',3310502061,1),(51563083,425478740,14867587,432736,1,'2007-09-15 01:56:06',3310502060,1),(51563087,425477838,14864414,432736,1,'2007-09-15 01:56:06',3310502060,1),(51563090,425477442,14862431,432736,1,'2007-09-15 01:56:06',3310502060,1),(51563094,425477622,14859402,432736,1,'2007-09-15 01:56:06',3310502060,1),(51563098,425477910,14854535,432736,1,'2007-09-15 01:56:06',3310502060,1),(51563100,425478631,14852444,432736,1,'2007-09-15 01:56:07',3310502060,1),(51563103,425480388,14848465,432736,1,'2007-09-15 01:56:07',3310502061,1),(51563105,425482107,14845400,432736,1,'2007-09-15 01:56:07',3310502061,1),(51563108,425482930,14843381,432736,1,'2007-09-15 01:56:08',3310502061,1),(51563110,425482930,14841811,432736,1,'2007-09-15 01:56:08',3310502061,1),(51563113,425482332,14841362,432736,1,'2007-09-15 01:56:08',3310502061,1),(51563115,425481509,14841362,432736,1,'2007-09-15 01:56:08',3310502061,1),(51563118,425480462,14842035,432736,1,'2007-09-15 01:56:08',3310502061,1),(51563120,425479191,14843904,432736,1,'2007-09-15 01:56:08',3310502060,1),(51563122,425476948,14847717,432736,1,'2007-09-15 01:56:09',3310502060,1),(51563124,425474107,14852577,432736,1,'2007-09-15 01:56:09',3310502060,1),(51563127,425472238,14855792,432736,1,'2007-09-15 01:56:09',3310502060,1),(51563130,425471117,14855942,432736,1,'2007-09-15 01:56:09',3310502060,1),(51563134,425470220,14855493,432736,1,'2007-09-15 01:56:10',3310502060,1),(51563137,425469696,14853773,432736,1,'2007-09-15 01:56:10',3310502060,1),(51563140,425468724,14851306,432736,1,'2007-09-15 01:56:10',3310502060,1),(51563141,425467378,14848465,432736,1,'2007-09-15 01:56:10',3310502060,1),(51563145,425465584,14845998,432736,1,'2007-09-15 01:56:10',3310502060,1),(51563148,425462369,14843306,432736,1,'2007-09-15 01:56:11',3310502060,1),(51563152,425457808,14838073,432736,1,'2007-09-15 01:56:11',3310502060,1),(51563155,425455823,14835251,432736,1,'2007-09-15 01:56:11',3310502060,1),(51563159,425454700,14833228,432736,1,'2007-09-15 01:56:11',3310502060,1),(51563162,425453666,14830576,432736,1,'2007-09-15 01:56:11',3310502054,1),(51563164,425452947,14828329,432736,1,'2007-09-15 01:56:12',3310502054,1),(51563168,425452003,14826666,432736,1,'2007-09-15 01:56:12',3310502051,1),(51563170,425448767,14822666,432736,1,'2007-09-15 01:56:12',3310502051,1),(51563173,425445531,14818531,432736,1,'2007-09-15 01:56:12',3310502051,1),(51563176,425442136,14814890,432736,1,'2007-09-15 01:56:12',3310502051,1),(51563177,425439620,14812374,432736,1,'2007-09-15 01:56:12',3310502051,1),(51563179,425437667,14809702,432736,1,'2007-09-15 01:56:13',3310502051,1),(51563181,425437178,14808114,432736,1,'2007-09-15 01:56:13',3310502051,1),(51563185,425436751,14805915,432736,1,'2007-09-15 01:56:13',3310502051,1),(51563189,425436873,14803411,432736,1,'2007-09-15 01:56:13',3310502051,1),(51563192,425436995,14801548,432736,1,'2007-09-15 01:56:13',3310502051,1),(51563195,425436781,14799868,432736,1,'2007-09-15 01:56:13',3310502051,1),(51563197,425436415,14797517,432736,1,'2007-09-15 01:56:14',3310502051,1),(51563199,425436730,14795307,432736,1,'2007-09-15 01:56:14',3310502051,1),(51563200,425437489,14793027,432736,1,'2007-09-15 01:56:14',3310502051,1),(51563202,425439009,14789988,432736,1,'2007-09-15 01:56:15',3310502051,1),(51563205,425441289,14786340,432736,1,'2007-09-15 01:56:15',3310502051,1),(51563210,425444557,14782008,432736,1,'2007-09-15 01:56:15',3310502051,1),(51563214,425448356,14777905,432736,1,'2007-09-15 01:56:15',3310502051,1),(51563216,425451624,14773649,432736,1,'2007-09-15 01:56:16',3310502049,1),(51563224,425453220,14771217,432736,1,'2007-09-15 01:56:16',3310502052,1),(51563226,425454360,14768862,432736,1,'2007-09-15 01:56:17',3310502052,1),(51563230,425455044,14766582,432736,1,'2007-09-15 01:56:17',3310502052,1),(51563233,425455348,14763466,432736,1,'2007-09-15 01:56:17',3310502052,1),(51563236,425455272,14755791,432736,1,'2007-09-15 01:56:18',3310502052,1),(51563238,425455576,14751687,432736,1,'2007-09-15 01:56:18',3310502052,1),(51563242,425455804,14749180,432736,1,'2007-09-15 01:56:18',3310502052,1),(51563244,425455652,14748040,432736,1,'2007-09-15 01:56:18',3310502052,1),(51563247,425454968,14747204,432736,1,'2007-09-15 01:56:18',3310502052,1),(51563252,425453980,14746976,432736,1,'2007-09-15 01:56:18',3310502052,1),(51563255,425452992,14747356,432736,1,'2007-09-15 01:56:18',3310502052,1),(51563257,425452688,14748344,432736,1,'2007-09-15 01:56:18',3310502052,1),(51563261,425451776,14753131,432736,1,'2007-09-15 01:56:18',3310502049,1),(51563266,425450712,14756627,432736,1,'2007-09-15 01:56:19',3310502049,1),(51563268,425449876,14758755,432736,1,'2007-09-15 01:56:19',3310502049,1),(51563272,425449192,14759439,432736,1,'2007-09-15 01:56:19',3310502049,1),(51563276,425448432,14759439,432736,1,'2007-09-15 01:56:19',3310502049,1),(51563279,425447930,14758608,454632,1,'2007-09-18 01:05:24',3310502049,1),(51563281,425447293,14756095,454632,1,'2007-09-18 01:05:25',3310502049,1),(51563284,425445936,14753584,454632,1,'2007-09-18 01:05:25',3310502049,1),(51563374,425445623,14752524,454632,1,'2007-09-18 01:05:23',3310502049,1),(51563375,425446179,14750887,454632,1,'2007-09-18 01:05:24',3310502049,1),(51563437,425447639,14749147,454632,1,'2007-09-18 01:05:26',3310502049,1),(51563439,425448635,14747165,454632,1,'2007-09-18 01:05:26',3310502049,1),(51563440,425448727,14744889,454632,1,'2007-09-18 01:05:27',3310502049,1),(51563441,425447927,14741960,454632,1,'2007-09-18 01:05:27',3310502049,1),(51563442,425447087,14739832,454632,1,'2007-09-18 01:05:27',3310502049,1),(51563443,425445697,14736641,432736,1,'2007-09-15 01:56:37',3310502049,1),(51563447,425444537,14733981,454632,1,'2007-09-18 01:05:28',3310502049,1),(51563450,425443797,14730257,432736,1,'2007-09-15 01:56:37',3310502049,1),(51563451,425443265,14725318,432736,1,'2007-09-15 01:56:37',3310502049,1),(51563453,425443341,14720454,432736,1,'2007-09-15 01:56:37',3310502027,1),(51563454,425443265,14716503,432736,1,'2007-09-15 01:56:38',3310502027,1),(51563456,425443417,14713615,432736,1,'2007-09-15 01:56:38',3310502027,1),(51563458,425443949,14710727,432736,1,'2007-09-15 01:56:38',3310502027,1),(51563460,425445241,14707080,432736,1,'2007-09-15 01:56:38',3310502027,1),(51563462,425445317,14706320,432736,1,'2007-09-15 01:56:38',3310502027,1),(51563463,425444937,14705940,432736,1,'2007-09-15 01:56:39',3310502027,1),(51563466,425444025,14706168,432736,1,'2007-09-15 01:56:39',3310502027,1),(51563470,425442505,14710575,432736,1,'2007-09-15 01:56:39',3310502027,1),(51563472,425440073,14718783,432736,1,'2007-09-15 01:56:39',3310502027,1),(51563474,425438705,14722430,432736,1,'2007-09-15 01:56:39',3310502049,1),(51563477,425438303,14723457,454632,1,'2007-09-18 01:05:25',3310502049,1),(51563480,425437624,14723636,454632,1,'2007-09-18 01:05:25',3310502049,1),(51563481,425436585,14722602,454632,1,'2007-09-18 01:05:26',3310502049,1),(51563484,425435058,14719922,432736,1,'2007-09-15 01:56:40',3310502027,1),(51563485,425433462,14715971,432736,1,'2007-09-15 01:56:40',3310502027,1),(51563488,425430498,14712095,432736,1,'2007-09-15 01:56:40',3310502027,1),(51563490,425427154,14708068,432736,1,'2007-09-15 01:56:40',3310502027,1),(51563492,425424799,14705940,432736,1,'2007-09-15 01:56:40',3310502027,1),(51563494,425422731,14704068,454632,1,'2007-09-18 01:05:26',3310502026,1),(51563496,425420619,14701000,432736,1,'2007-09-15 01:56:41',3310502026,1),(51563499,425417579,14696897,432736,1,'2007-09-15 01:56:41',3310502026,1),(51581574,425470132,15141850,183661,1,'2008-04-18 18:23:07',3310502414,3),(51581577,425470921,15143853,432736,1,'2007-09-15 02:29:01',3310502414,1),(51581580,425471103,15147070,432736,1,'2007-09-15 02:29:01',3310502414,1),(51581582,425469343,15151986,432736,1,'2007-09-15 02:29:01',3310502414,1),(51581587,425464002,15161091,432736,1,'2007-09-15 02:29:01',3310502414,1),(51581590,425461756,15165279,432736,1,'2007-09-15 02:29:02',3310502436,1),(51581593,425460421,15168010,432736,1,'2007-09-15 02:29:02',3310502436,1),(51581596,425458357,15170195,432736,1,'2007-09-15 02:29:02',3310502436,1),(51581598,425456597,15172259,432736,1,'2007-09-15 02:29:02',3310502436,1),(51581602,425455687,15174565,432736,1,'2007-09-15 02:29:03',3310502436,1),(51581607,425455019,15178510,432736,1,'2007-09-15 02:29:03',3310502436,1),(51581611,425454291,15182334,432736,1,'2007-09-15 02:29:03',3310502436,1),(51581613,425454169,15190103,432736,1,'2007-09-15 02:29:03',3310502436,1),(51581617,425454898,15195141,432736,1,'2007-09-15 02:29:03',3310502436,1),(51581620,425456476,15201332,432736,1,'2007-09-15 02:29:04',3310502436,1),(51581622,425458789,15205416,501202,1,'2008-05-22 22:30:34',3310502436,2),(51581625,425460603,15208312,432736,1,'2007-09-15 02:29:04',3310502436,1),(51581628,425463516,15212135,432736,1,'2007-09-15 02:29:04',3310502436,1),(51581633,425473080,15216230,498434,1,'2008-05-22 19:58:22',3310502436,3),(51581643,425475546,15217346,498434,1,'2008-05-22 19:53:32',3310502438,2),(51581645,425478690,15218508,432736,1,'2007-09-15 02:29:05',3310502438,1),(51581650,425483607,15223789,432736,1,'2007-09-15 02:29:06',3310502439,1),(51581654,425485852,15226217,432736,1,'2007-09-15 02:29:06',3310502439,1),(51581657,425488280,15228766,432736,1,'2007-09-15 02:29:06',3310502439,1),(51581661,425490587,15232286,432736,1,'2007-09-15 02:29:06',3310502439,1),(51581663,425491558,15235564,432736,1,'2007-09-15 02:29:06',3310502439,1),(51581667,425492347,15239691,432736,1,'2007-09-15 02:29:07',3310502439,1),(51581670,425494228,15244668,432736,1,'2007-09-15 02:29:07',3310502439,1),(51581675,425496717,15248735,4804396,1,'2010-05-25 17:58:16',3310502439,2),(51581679,425467065,15138495,174860,1,'2008-12-06 16:19:29',3310502414,2),(51581686,425499422,15254440,725665,1,'2009-03-02 22:17:22',3310502439,5),(51581690,425502895,15259401,725665,1,'2009-03-02 22:17:22',3310502439,5),(51581692,425505871,15261386,725665,1,'2009-03-02 22:17:22',3310502439,5),(51581695,425509415,15262803,725665,1,'2009-03-02 22:17:22',3310502450,5),(51581699,425515499,15263968,725665,1,'2009-03-02 22:29:56',3310502450,17),(51581702,425517832,15264320,725665,1,'2009-03-02 22:29:56',3310502450,11),(51581705,425519975,15266205,725665,1,'2009-03-02 22:29:56',3310502450,11),(51581708,425523944,15271379,725665,1,'2009-03-02 22:29:54',3310502456,11),(51581711,425526637,15275135,725665,1,'2009-03-02 22:29:54',3310502456,11),(51581715,425530677,15279742,725665,1,'2009-03-02 22:29:54',3310502456,11),(51581724,425542387,15289732,725665,1,'2009-03-02 22:27:38',3310502457,13),(51581727,425547120,15293562,725665,1,'2009-03-02 22:27:38',3310502457,12),(51581729,425550167,15298877,725665,1,'2009-03-02 22:27:38',3310502457,12),(51581732,425550805,15299941,725665,1,'2009-03-02 22:27:39',3310502457,12),(51581737,425552718,15304760,725665,1,'2009-03-02 22:27:39',3310502457,12),(51581739,425554175,15307955,725665,1,'2009-03-02 22:27:40',3310502457,12),(51581743,425555969,15312333,725665,1,'2009-03-02 22:27:41',3310502457,14),(51581745,425556791,15316195,725665,1,'2009-03-02 22:27:41',3310502457,14),(51581748,425556791,15320916,725665,1,'2009-03-02 22:27:41',3310502457,14),(51581751,425556814,15328970,1684788,1,'2009-06-30 11:19:39',3310502459,3),(51581754,425556779,15329603,1684788,1,'2009-06-30 11:19:38',3310502459,3),(51581757,425556649,15329884,1684788,1,'2009-06-30 11:19:39',3310502459,3),(51581759,425556393,15330134,1684788,1,'2009-06-30 11:19:39',3310502459,3),(51581762,425555947,15330198,1684788,1,'2009-06-30 11:19:38',3310502459,4),(51581766,425555555,15329902,1684788,1,'2009-06-30 11:19:38',3310502459,3),(51581769,425555444,15329694,1684788,1,'2009-06-30 11:19:39',3310502459,3),(51581772,425555355,15329212,1684788,1,'2009-06-30 11:19:38',3310502459,3),(51581776,425555573,15328506,1684788,1,'2009-06-30 11:19:38',3310502459,3),(51581778,425555693,15328375,1684788,1,'2009-06-30 11:19:39',3310502459,5),(51581782,425556376,15328289,1684788,1,'2009-06-30 11:19:39',3310502459,15),(51581783,425556737,15328714,1684788,1,'2009-06-30 11:19:39',3310502459,3),(51581786,425558133,15329365,432736,1,'2007-09-15 02:29:15',3310502459,1),(51581788,425557504,15329452,432736,1,'2007-09-15 02:29:15',3310502459,1),(51581791,425556831,15329335,1684788,1,'2009-06-30 11:19:38',3310502459,3),(51581795,425559126,15328531,615859,1,'2008-07-28 13:58:34',3310502459,2),(51581796,425559856,15327943,432736,1,'2007-09-15 02:29:16',3310502459,1),(51581799,425561199,15327227,432736,1,'2007-09-15 02:29:16',3310502459,1),(51581803,425562871,15326571,432736,1,'2007-09-15 02:29:16',3310502462,1),(51581807,425565221,15326355,432736,1,'2007-09-15 02:29:17',3310502462,1),(51581810,425569705,15326046,432736,1,'2007-09-15 02:29:17',3310502460,1),(51581813,425573292,15325303,432736,1,'2007-09-15 02:29:17',3310502460,1),(51581814,425581843,15325544,432736,1,'2007-09-15 02:29:17',3310502460,1),(51581818,425585075,15324929,432736,1,'2007-09-15 02:29:18',3310502460,1),(51581821,425587614,15323698,432736,1,'2007-09-15 02:29:18',3310502460,1),(51581823,425590153,15321543,432736,1,'2007-09-15 02:29:18',3310502461,1),(51581826,425593847,15318004,432736,1,'2007-09-15 02:29:18',3310502461,1),(51581828,425597925,15314387,432736,1,'2007-09-15 02:29:18',3310502461,1),(51581829,425601388,15312233,432736,1,'2007-09-15 02:29:18',3310502461,1),(51581832,425606004,15310155,432736,1,'2007-09-15 02:29:19',3310502461,1);
INSERT INTO `current_nodes` VALUES (51581835,425608544,15308001,432736,1,'2007-09-15 02:29:19',3310502461,1),(51581837,425610236,15305692,432736,1,'2007-09-15 02:29:19',3310502461,1),(51581840,425611852,15302691,432736,1,'2007-09-15 02:29:19',3310502461,1),(51581843,425613314,15299767,432736,1,'2007-09-15 02:29:20',3310502461,1),(51581846,425615161,15297459,432736,1,'2007-09-15 02:29:20',3310502461,1),(51581849,425617085,15295920,432736,1,'2007-09-15 02:29:20',3310502504,1),(51581852,425619393,15294612,432736,1,'2007-09-15 02:29:20',3310502504,1),(51581854,425621701,15293150,432736,1,'2007-09-15 02:29:20',3310502504,1),(51581857,425623933,15291149,432736,1,'2007-09-15 02:29:21',3310502504,1),(51581861,425625703,15288918,432736,1,'2007-09-15 02:29:21',3310502504,1),(51581863,425628019,15284841,498434,1,'2008-05-22 17:49:55',3310502504,2),(51581868,425630990,15279348,498434,1,'2008-05-22 17:49:55',3310502504,2),(51581874,425633203,15273168,498434,1,'2008-05-22 17:50:41',3310502504,2),(51581876,425635478,15266130,498434,1,'2008-05-22 17:50:41',3310502498,2),(51581877,425637501,15261495,498434,1,'2008-05-22 17:50:41',3310502498,2),(51581881,425639630,15257293,432736,1,'2007-09-15 02:29:23',3310502498,1),(51581883,425643016,15253215,432736,1,'2007-09-15 02:29:23',3310502498,1),(51581886,425646478,15248675,432736,1,'2007-09-15 02:29:23',3310502499,1),(51581888,425648633,15245751,432736,1,'2007-09-15 02:29:23',3310502499,1),(51581890,425654019,15242134,432736,1,'2007-09-15 02:29:23',3310502499,1),(51581895,425660559,15238056,432736,1,'2007-09-15 02:29:24',3310502499,1),(51581898,425667408,15234824,432736,1,'2007-09-15 02:29:24',3310502499,1),(51581902,425674179,15231516,432736,1,'2007-09-15 02:29:24',3310502502,1),(51581904,425676564,15228746,432736,1,'2007-09-15 02:29:24',3310502502,1),(51581906,425678642,15224129,432736,1,'2007-09-15 02:29:24',3310502502,1),(51581910,425682127,15219558,498434,1,'2008-05-22 17:32:10',3310502502,2),(51581912,425685857,15215696,498434,1,'2008-05-22 17:32:10',3310502500,2),(51581914,425688701,15212778,498434,1,'2008-05-22 17:32:10',3310502500,2),(51581916,425692492,15211048,432736,1,'2007-09-15 02:29:25',3310502500,1),(51581922,425697879,15210663,432736,1,'2007-09-15 02:29:26',3310502500,1),(51581923,425702572,15209894,432736,1,'2007-09-15 02:29:26',3310502501,1),(51581926,425706112,15209663,432736,1,'2007-09-15 02:29:26',3310502501,1),(51581928,425710113,15207970,432736,1,'2007-09-15 02:29:26',3310502501,1),(51581931,425713345,15205354,432736,1,'2007-09-15 02:29:26',3310502501,1),(51581932,425716961,15201968,432736,1,'2007-09-15 02:29:26',3310502501,1),(51581936,425719424,15197813,432736,1,'2007-09-15 02:29:27',3310502501,1),(51581939,425722117,15194273,432736,1,'2007-09-15 02:29:27',3310502501,1),(51581941,425725887,15190118,432736,1,'2007-09-15 02:29:27',3310502501,1),(51581944,425729965,15187502,432736,1,'2007-09-15 02:29:27',3310502512,1),(51581946,425736660,15184886,432736,1,'2007-09-15 02:29:27',3310502512,1),(51581951,425743200,15182578,432736,1,'2007-09-15 02:29:27',3310502512,1),(51581955,425749894,15180577,432736,1,'2007-09-15 02:29:28',3310502512,1),(51581958,425752741,15181270,432736,1,'2007-09-15 02:29:28',3310502512,1),(51581960,425755896,15184424,432736,1,'2007-09-15 02:29:28',3310502513,1),(51581962,425759091,15186665,440632,1,'2008-07-09 16:35:09',3310502513,2),(51581964,425761667,15187194,432736,1,'2007-09-15 02:29:29',3310502513,1),(51581967,425763745,15186271,432736,1,'2007-09-15 02:29:29',3310502513,1),(51581970,425764745,15183963,432736,1,'2007-09-15 02:29:29',3310502513,1),(51581973,425766977,15179884,432736,1,'2007-09-15 02:29:29',3310502513,1),(51581976,425769593,15174729,432736,1,'2007-09-15 02:29:30',3310502513,1),(51581979,425773209,15173190,432736,1,'2007-09-15 02:29:30',3310502513,1),(51581980,425775518,15174498,432736,1,'2007-09-15 02:29:30',3310502513,1),(51581983,425779057,15178730,432736,1,'2007-09-15 02:29:30',3310502513,1),(51581986,425780844,15180962,432736,1,'2007-09-15 02:29:30',3310502513,1),(51581990,425784602,15185299,432736,1,'2007-09-15 02:29:31',3310502516,1),(51581993,425787782,15187539,432736,1,'2007-09-15 02:29:31',3310502516,1),(51581995,425790167,15188479,432736,1,'2007-09-15 02:29:31',3310502516,1),(51581997,425795431,15187817,513066,1,'2008-05-24 16:28:02',3310502516,2),(51582003,425799539,15189362,513066,1,'2008-05-24 16:28:02',3310502516,2),(51582007,425802165,15191225,432736,1,'2007-09-15 02:29:32',3310502516,1),(51582009,425803972,15192237,432736,1,'2007-09-15 02:29:33',3310502516,1),(51582013,425806430,15193105,432736,1,'2007-09-15 02:29:33',3310502516,1),(51582019,425808381,15193249,432736,1,'2007-09-15 02:29:33',3310502516,1),(51582023,425810839,15193105,432736,1,'2007-09-15 02:29:34',3310502517,1),(51582027,425813305,15192368,352026,1,'2008-05-06 16:36:31',3310502517,2),(51582031,425817160,15190566,352026,1,'2008-05-06 16:36:31',3310502517,2),(51582034,425821535,15190503,432736,1,'2007-09-15 02:29:34',3310502517,1),(51582038,425830787,15193538,432736,1,'2007-09-15 02:29:35',3310502517,1),(51582045,425837737,15195491,435967,1,'2007-09-15 21:59:03',3310502688,1),(51582060,425840038,15197007,432736,1,'2007-09-15 02:29:37',3310502688,1),(51582066,425842722,15199558,435967,1,'2007-09-15 21:59:03',3310502688,1),(51582074,425846110,15203946,432736,1,'2007-09-15 02:29:37',3310502688,1),(51582077,425847844,15205464,432736,1,'2007-09-15 02:29:37',3310502688,1),(51582082,425851097,15207994,432736,1,'2007-09-15 02:29:38',3310502688,1),(51582085,425854855,15209976,435967,1,'2007-09-15 21:59:10',3310502688,1),(51582086,425856697,15211289,435967,1,'2007-09-15 21:59:09',3310502688,1),(51582089,425860338,15212121,435967,1,'2007-09-15 21:59:10',3310502688,1),(51582090,425863817,15212041,432736,1,'2007-09-15 02:29:38',3310502688,1),(51582091,425867070,15211246,432736,1,'2007-09-15 02:29:39',3310502689,1),(51582093,425870250,15210812,432736,1,'2007-09-15 02:29:39',3310502689,1),(51582096,425872057,15211174,432736,1,'2007-09-15 02:29:39',3310502689,1),(51582098,425873385,15212163,435967,1,'2007-09-15 21:59:05',3310502689,1),(51582101,425874975,15214562,435967,1,'2007-09-15 21:59:06',3310502689,1),(51582102,425877705,15219839,435967,1,'2007-09-15 21:59:05',3310502691,1),(51582105,425881022,15224055,435967,1,'2007-09-15 21:59:07',3310502691,1),(51582107,425884875,15229067,435967,1,'2007-09-15 21:59:06',3310502691,1),(51582110,425889608,15233427,435967,1,'2007-09-15 21:59:08',3310502691,1),(51582111,425891465,15235636,435967,1,'2007-09-15 21:59:09',3310502691,1),(51582113,425894380,15237198,435967,1,'2007-09-15 21:59:15',3310502694,1),(51582116,425897654,15239013,435967,1,'2007-09-15 21:59:15',3310502694,1),(51582118,425901652,15243324,435967,1,'2007-09-15 21:59:15',3310502694,1),(51582121,425904772,15245312,435967,1,'2007-09-15 21:59:16',3310502694,1),(51582123,425909626,15247243,435967,1,'2007-09-15 21:59:16',3310502694,1),(51582125,425915915,15249707,435967,1,'2007-09-15 21:59:16',3310502694,1),(51582128,425918736,15251628,56648,1,'2008-06-05 18:37:38',3310502694,2),(51582132,425920822,15251628,56648,1,'2008-06-05 18:37:38',3310502695,2),(51582133,425923096,15251371,56648,1,'2008-06-05 18:37:38',3310502695,2),(51582135,425926572,15252830,56648,1,'2008-06-05 18:37:38',3310502695,2),(51582137,425929541,15254461,56648,1,'2008-06-05 18:37:38',3310502695,2),(51582139,425932473,15255248,435967,1,'2007-09-15 21:59:14',3310502695,1),(51582143,425934977,15256527,435967,1,'2007-09-15 21:59:15',3310502695,1),(51582146,425936373,15258720,435967,1,'2007-09-15 21:59:31',3310502695,1),(51582148,425938392,15264027,435967,1,'2007-09-15 21:59:29',3310502695,1),(51582150,425938832,15266168,435967,1,'2007-09-15 21:59:29',3310502695,1),(51582153,425939438,15267609,435967,1,'2007-09-15 21:59:32',3310502695,1),(51582156,425940764,15268783,435967,1,'2007-09-15 21:59:32',3310502695,1),(51582159,425942732,15269466,435967,1,'2007-09-15 21:59:31',3310502695,1),(51582162,425944423,15268806,435967,1,'2007-09-15 21:59:17',3310502695,1),(51582166,425946020,15267969,435967,1,'2007-09-15 21:59:17',3310502695,1),(51582167,425948782,15267011,435967,1,'2007-09-15 21:59:17',3310502706,1),(51582170,425951566,15265521,435967,1,'2007-09-15 21:59:29',3310502706,1),(51582173,425953590,15264708,435967,1,'2007-09-15 21:59:18',3310502706,1),(51582175,425956698,15264472,435967,1,'2007-09-15 21:59:17',3310502706,1),(51582178,425958822,15265032,435967,1,'2007-09-15 21:59:33',3310502706,1),(51582181,425960439,15265447,56648,1,'2008-06-05 18:53:05',3310502706,2),(51582184,425962145,15267507,56648,1,'2008-06-05 19:06:55',3310502706,5),(51582186,425962777,15270082,56648,1,'2008-06-05 18:53:05',3310502706,2),(51582188,425964409,15272714,435967,1,'2007-09-15 21:59:33',3310502712,1),(51582191,425972497,15280633,435967,1,'2007-09-15 21:59:33',3310502712,1),(51582194,425975611,15283712,435967,1,'2007-09-15 21:59:32',3310502713,1),(51582198,425981100,15289995,56648,1,'2008-06-05 19:06:55',3310502713,2),(51582201,425983737,15293894,435967,1,'2007-09-15 21:59:33',3310502713,1),(51582204,425985949,15299244,435967,1,'2007-09-15 21:59:32',3310502713,1),(51582207,425987720,15305229,435967,1,'2007-09-15 21:59:33',3310502713,1),(51582209,425989506,15308460,435967,1,'2007-09-15 21:58:20',3310502713,1),(51582211,425993658,15313825,435967,1,'2007-09-15 21:58:20',3310502713,1),(51582213,425998449,15322111,206510,1,'2008-12-06 19:38:06',3310502713,4),(51582216,426002768,15330406,206510,1,'2008-12-06 19:38:06',3310502718,4),(51582218,426004930,15334815,206510,1,'2008-12-06 19:38:07',3310502718,4),(51582221,426007287,15337885,206510,1,'2008-12-06 19:38:07',3310502718,4),(51582224,426010195,15341353,206510,1,'2008-12-06 19:38:07',3310502718,4),(51582227,426012957,15342897,206510,1,'2008-12-06 19:38:07',3310502718,4),(51582229,426014627,15344049,206510,1,'2008-12-06 19:38:07',3310502718,4),(51582231,426015698,15345743,206510,1,'2008-12-06 19:38:07',3310502718,4),(51582233,426017471,15348577,206510,1,'2008-12-06 19:38:07',3310502718,4),(51582234,426018707,15350336,206510,1,'2008-12-06 19:38:07',3310502718,4),(51582237,426022777,15352858,206510,1,'2008-12-06 19:38:07',3310502718,4),(51582239,426028754,15356287,206510,1,'2008-12-06 19:38:07',3310502718,4),(51582241,426032887,15357920,206510,1,'2008-12-06 19:38:07',3310502719,4),(51582242,426036089,15359446,206510,1,'2008-12-06 19:38:07',3310502719,4),(51582245,426038695,15360438,206510,1,'2008-12-06 19:38:07',3310502719,4),(51582247,426042532,15360564,206510,1,'2008-12-06 19:38:07',3310502719,4),(51582251,426046307,15360880,206510,1,'2008-12-06 19:38:07',3310502719,4),(51582253,426048947,15361306,206510,1,'2008-12-06 19:38:07',3310502719,4),(51582256,426051752,15362430,206510,1,'2008-12-06 19:38:07',3310502719,4),(51582258,426055484,15365163,206510,1,'2008-12-06 19:38:07',3310502719,4),(51582261,426060694,15368337,206510,1,'2008-12-06 19:38:07',3310502762,4),(51582264,426065421,15371269,206510,1,'2008-12-06 19:38:08',3310502762,4),(51582267,426070148,15373270,206510,1,'2008-12-06 19:38:08',3310502762,4),(51582270,426073252,15374167,206510,1,'2008-12-06 19:38:08',3310502762,4),(51582271,426077237,15373982,206510,1,'2008-12-06 19:38:08',3310502762,4),(51582274,426083085,15373396,206510,1,'2008-12-06 19:38:08',3310502762,4),(51582279,426086501,15374486,206510,1,'2008-12-06 19:38:08',3310502763,4),(51582282,426087795,15375728,206510,1,'2008-12-06 19:38:08',3310502763,4),(51582284,426089966,15377742,206510,1,'2008-12-06 19:38:08',3310502763,4),(51582287,426091985,15379862,206510,1,'2008-12-06 19:38:08',3310502763,4),(51582290,426093173,15381725,206510,1,'2008-12-06 19:38:08',3310502849,4),(51582293,426094880,15382865,206510,1,'2008-12-06 19:38:08',3310502849,4),(51582294,426096636,15383072,206510,1,'2008-12-06 19:38:08',3310502849,4),(51582297,426100029,15383823,206510,1,'2008-12-06 19:38:08',3310502849,4),(51582300,426102682,15384595,206510,1,'2008-12-06 19:38:08',3310502849,4),(51582303,426108081,15386953,206510,1,'2008-12-06 19:38:08',3310502849,4),(51582306,426111647,15389437,206510,1,'2008-12-06 19:38:09',3310502852,4),(51582308,426114394,15390890,206510,1,'2008-12-06 19:38:09',3310502852,4),(51582309,426117453,15390474,206510,1,'2008-12-06 19:38:09',3310502852,4),(51582311,426122521,15389130,206510,1,'2008-12-06 19:38:09',3310502852,4),(51582313,426126820,15387886,206510,1,'2008-12-06 19:38:09',3310502852,4),(51582315,426130235,15387421,206510,1,'2008-12-06 19:38:09',3310502852,4),(51582316,426139807,15386696,206510,1,'2008-12-06 19:38:09',3310502853,4),(51582318,426146535,15386177,206510,1,'2008-12-06 19:38:09',3310502853,4),(51582320,426149847,15385609,206510,1,'2008-12-06 19:38:09',3310502853,4),(51582323,426154919,15384781,206510,1,'2008-12-06 19:38:09',3310502853,4),(51582326,426158335,15384173,206510,1,'2008-12-06 19:38:09',3310502853,4),(51582329,426161543,15384179,206510,1,'2008-12-06 19:38:09',3310502853,4),(51582332,426162921,15384989,206510,1,'2008-12-06 19:38:09',3310502853,4),(51582335,426164492,15387970,206510,1,'2008-12-06 19:38:09',3310502853,4),(51582338,426166519,15390702,206510,1,'2008-12-06 19:38:09',3310502864,4),(51582339,426168281,15392203,206510,1,'2008-12-06 19:38:09',3310502864,4),(51582342,426170270,15393065,206510,1,'2008-12-06 19:38:09',3310502864,4),(51582345,426172108,15392620,206510,1,'2008-12-06 19:38:09',3310502864,4),(51582346,426172942,15392024,206510,1,'2008-12-06 19:38:09',3310502864,4),(51582349,426173539,15391309,206510,1,'2008-12-06 19:38:09',3310502864,4),(51582352,426174135,15389401,206510,1,'2008-12-06 19:38:10',3310502864,4),(51582355,426174850,15387254,206510,1,'2008-12-06 19:38:10',3310502864,4),(51582357,426174969,15384273,206510,1,'2008-12-06 19:38:10',3310502864,4),(51582360,426175566,15382008,206510,1,'2008-12-06 19:38:10',3310502864,4),(51582362,426176504,15380393,206510,1,'2008-12-06 19:38:10',3310502778,4),(51582365,426178845,15377504,206510,1,'2008-12-06 19:38:10',3310502778,4),(51582368,426181393,15374073,206510,1,'2008-12-06 19:38:10',3310502778,4),(51582371,426184021,15370832,206510,1,'2008-12-06 19:38:10',3310502778,4),(51582373,426185392,15369174,206510,1,'2008-12-06 19:38:10',3310502778,4),(51582377,426186878,15368416,206510,1,'2008-12-06 19:38:10',3310502778,4),(51582380,426187533,15368443,206510,1,'2008-12-06 19:38:11',3310502778,4),(51582383,426188178,15368811,206510,1,'2008-12-06 19:38:11',3310502778,4),(51582385,426188324,15370003,206510,1,'2008-12-06 19:38:11',3310502778,4),(51582388,426187918,15371755,206510,1,'2008-12-06 19:38:11',3310502778,4),(51582392,426186113,15375244,206510,1,'2008-12-06 19:38:11',3310502778,4),(51582395,426184389,15378073,206510,1,'2008-12-06 19:38:11',3310502778,4),(51582399,426184270,15380458,206510,1,'2008-12-06 19:38:11',3310502778,4),(51582403,426184270,15384273,206510,1,'2008-12-06 19:38:11',3310502864,4),(51582405,426184746,15388447,206510,1,'2008-12-06 19:38:11',3310502864,4),(51582407,426186789,15392550,206510,1,'2008-12-06 19:38:11',3310502864,4),(51582410,426188941,15394913,206510,1,'2008-12-06 19:38:11',3310502864,4),(51582413,426190616,15397141,206510,1,'2008-12-06 19:38:11',3310502864,4),(51582415,426191841,15397803,206510,1,'2008-12-06 19:38:11',3310502864,4),(51582418,426192584,15396697,206510,1,'2008-12-06 19:38:11',3310502864,4),(51582421,426192297,15394751,206510,1,'2008-12-06 19:38:12',3310502864,4),(51582424,426191744,15392788,206510,1,'2008-12-06 19:38:12',3310502864,4),(51582426,426191386,15390869,206510,1,'2008-12-06 19:38:12',3310502864,4),(51582429,426191956,15388523,206510,1,'2008-12-06 19:38:12',3310502864,4),(51582432,426192726,15386946,206510,1,'2008-12-06 19:38:12',3310502864,4),(51582435,426193387,15385071,206510,1,'2008-12-06 19:38:12',3310502864,4),(51582437,426194097,15384513,206510,1,'2008-12-06 19:38:12',3310502865,4),(51582439,426194877,15384220,206510,1,'2008-12-06 19:38:12',3310502865,4),(51582441,426195240,15385358,206510,1,'2008-12-06 19:38:12',3310502865,4),(51582444,426194714,15386285,206510,1,'2008-12-06 19:38:12',3310502865,4),(51582446,426194286,15387174,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582448,426193868,15388573,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582451,426194115,15389789,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582453,426194995,15391049,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582455,426196383,15393064,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582459,426197922,15395531,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582462,426199294,15398344,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582463,426200248,15401682,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582465,426200606,15404306,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582469,426201083,15407287,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582472,426202156,15410745,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582474,426203453,15414051,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582476,426204302,15416826,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582479,426204581,15419629,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582482,426205684,15423980,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582483,426206640,15427136,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582486,426207094,15428375,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582489,426208100,15428666,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582492,426208720,15427898,206510,1,'2008-12-06 19:38:13',3310502865,4),(51582495,426208368,15425123,206510,1,'2008-12-06 19:38:14',3310502865,4),(51582496,426207880,15422311,206510,1,'2008-12-06 19:38:14',3310502865,4),(51582499,426207760,15420641,206510,1,'2008-12-06 19:38:14',3310502865,4),(51582501,426207999,15418137,206510,1,'2008-12-06 19:38:14',3310502865,4),(51582502,426208476,15415395,206510,1,'2008-12-06 19:38:14',3310502865,4),(51582504,426208714,15413249,206510,1,'2008-12-06 19:38:14',3310502865,4),(51582506,426208714,15410983,206510,1,'2008-12-06 19:38:14',3310502865,4),(51582508,426208237,15408360,206510,1,'2008-12-06 19:38:14',3310502865,4),(51582509,426207641,15404663,206510,1,'2008-12-06 19:38:14',3310502865,4),(51582510,426207045,15401086,206510,1,'2008-12-06 19:38:14',3310502865,4),(51582512,426206926,15397748,206510,1,'2008-12-06 19:38:14',3310502865,4),(51582516,426206806,15394051,206510,1,'2008-12-06 19:38:14',3310502865,4),(51582518,426206449,15390593,206510,1,'2008-12-06 19:38:14',3310502865,4),(51582521,426206449,15387612,206510,1,'2008-12-06 19:38:14',3310502865,4),(51582523,426207641,15384035,206510,1,'2008-12-06 19:38:14',3310502865,4),(51582525,426209072,15379265,206510,1,'2008-12-06 19:38:14',3310502779,4),(51582527,426217740,15364049,206510,1,'2008-12-06 19:38:14',3310502779,4),(51582530,426227492,15346850,206510,1,'2008-12-06 19:38:14',3310502782,4),(51587693,425555805,15331384,1684788,1,'2009-06-30 11:19:39',3310502459,3),(51587694,425555327,15332479,1684788,1,'2009-06-30 11:19:39',3310502459,3),(51587703,425553935,15331764,1684788,1,'2009-06-30 11:19:39',3310502459,3),(51587705,425554323,15330268,1684788,1,'2009-06-30 11:19:38',3310502459,4),(51587707,425554719,15330070,1684788,1,'2009-06-30 11:19:39',3310502459,3),(51587715,425553941,15330926,1684788,1,'2009-06-30 11:19:39',3310502459,3),(51587721,425554390,15332498,1684788,1,'2009-06-30 11:19:39',3310502459,3),(51587723,425554962,15332645,1684788,1,'2009-06-30 11:19:39',3310502459,3),(51587726,425555647,15332069,1684788,1,'2009-06-30 11:19:38',3310502459,3),(51587729,425555709,15330791,1684788,1,'2009-06-30 11:19:39',3310502459,4),(51587732,425555298,15330212,1684788,1,'2009-06-30 11:19:39',3310502459,4),(51589112,425553377,15329156,498434,1,'2008-05-22 18:27:07',3310502459,2),(51589115,425552555,15328555,498434,1,'2008-05-22 18:27:07',3310502459,2),(51589117,425551607,15327782,498434,1,'2008-05-22 18:27:07',3310502459,2),(51589119,425550595,15326838,498434,1,'2008-05-22 18:27:07',3310502459,2),(51589122,425549204,15325723,498434,1,'2008-05-22 18:27:07',3310502457,2),(51589125,425548192,15324864,498434,1,'2008-05-22 18:27:07',3310502457,2),(51589128,425546754,15323865,432736,1,'2007-09-15 02:41:19',3310502457,1),(51589130,425545351,15322641,432736,1,'2007-09-15 02:41:19',3310502457,1),(51589133,425542940,15321462,432736,1,'2007-09-15 02:41:19',3310502457,1),(51589136,425540877,15320172,432736,1,'2007-09-15 02:41:19',3310502457,1),(51589138,425539459,15319312,432736,1,'2007-09-15 02:41:20',3310502457,1),(51589142,425538255,15319140,432736,1,'2007-09-15 02:41:20',3310502457,1),(51589144,425537352,15319484,432736,1,'2007-09-15 02:41:20',3310502457,1),(51589146,425536837,15320258,432736,1,'2007-09-15 02:41:20',3310502457,1),(51589149,425536708,15321247,432736,1,'2007-09-15 02:41:20',3310502457,1),(51589152,425537352,15322536,432736,1,'2007-09-15 02:41:20',3310502457,1),(51589155,425537825,15324599,432736,1,'2007-09-15 02:41:20',3310502457,1),(51589157,425538470,15327823,432736,1,'2007-09-15 02:41:21',3310502459,1),(51589158,425538728,15331004,432736,1,'2007-09-15 02:41:21',3310502459,1),(51589160,425539373,15333755,432736,1,'2007-09-15 02:41:21',3310502459,1),(51589161,425539502,15335346,432736,1,'2007-09-15 02:41:21',3310502459,1),(51589162,425539545,15336721,432736,1,'2007-09-15 02:41:21',3310502459,1),(51589163,425538943,15337839,432736,1,'2007-09-15 02:41:21',3310502459,1),(51589165,425538126,15338355,432736,1,'2007-09-15 02:41:22',3310502459,1),(51589169,425537137,15338355,432736,1,'2007-09-15 02:41:22',3310502459,1),(51589172,425536321,15337710,432736,1,'2007-09-15 02:41:22',3310502459,1),(51589174,425535332,15336506,432736,1,'2007-09-15 02:41:22',3310502459,1),(51589177,425533413,15333574,432736,1,'2007-09-15 02:41:22',3310502458,1),(51589180,425531530,15331521,432736,1,'2007-09-15 02:41:22',3310502458,1),(51589183,425529705,15330266,432736,1,'2007-09-15 02:41:22',3310502458,1),(51589185,425527708,15329581,432736,1,'2007-09-15 02:41:23',3310502458,1),(51589187,425525426,15328783,432736,1,'2007-09-15 02:41:23',3310502458,1),(51589190,425523886,15327185,432736,1,'2007-09-15 02:41:23',3310502458,1),(51589192,425522403,15325189,432736,1,'2007-09-15 02:41:23',3310502456,1),(51589194,425521319,15321253,432736,1,'2007-09-15 02:41:23',3310502456,1),(51589196,425520463,15317887,432736,1,'2007-09-15 02:41:24',3310502456,1),(51589198,425519265,15314521,432736,1,'2007-09-15 02:41:24',3310502456,1),(51589201,425518182,15311441,432736,1,'2007-09-15 02:41:24',3310502456,1),(51589203,425516870,15308532,432736,1,'2007-09-15 02:41:24',3310502456,1),(51589205,425515272,15307162,432736,1,'2007-09-15 02:41:24',3310502456,1),(51589208,425512477,15305907,432736,1,'2007-09-15 02:41:25',3310502456,1),(51589210,425511507,15304710,432736,1,'2007-09-15 02:41:25',3310502456,1),(51589213,425511336,15303226,432736,1,'2007-09-15 02:41:25',3310502456,1),(51589215,425511393,15300431,432736,1,'2007-09-15 02:41:25',3310502456,1),(51589217,425510880,15298206,432736,1,'2007-09-15 02:41:25',3310502456,1),(51589220,425509796,15294898,432736,1,'2007-09-15 02:41:26',3310502456,1),(51589223,425508826,15292103,432736,1,'2007-09-15 02:41:26',3310502456,1),(51589226,425508427,15289878,432736,1,'2007-09-15 02:41:26',3310502456,1),(51589229,425508256,15287653,432736,1,'2007-09-15 02:41:26',3310502456,1),(51589230,425507914,15285257,432736,1,'2007-09-15 02:41:26',3310502456,1),(51589233,425506830,15284744,432736,1,'2007-09-15 02:41:26',3310502445,1),(51589236,425505917,15284744,432736,1,'2007-09-15 02:41:27',3310502445,1),(51589238,425505232,15285885,432736,1,'2007-09-15 02:41:27',3310502445,1),(51589243,425504833,15288452,432736,1,'2007-09-15 02:41:27',3310502445,1),(51589247,425504662,15291133,432736,1,'2007-09-15 02:41:27',3310502445,1),(51589249,425503806,15293186,432736,1,'2007-09-15 02:41:27',3310502445,1),(51589252,425503350,15295126,432736,1,'2007-09-15 02:41:28',3310502445,1),(51589254,425503122,15297065,432736,1,'2007-09-15 02:41:28',3310502445,1),(51589256,425503350,15299804,432736,1,'2007-09-15 02:41:28',3310502445,1),(51589259,425504263,15304025,432736,1,'2007-09-15 02:41:28',3310502445,1),(51589262,425504890,15306649,432736,1,'2007-09-15 02:41:28',3310502445,1),(51589263,425504947,15309501,432736,1,'2007-09-15 02:41:29',3310502445,1),(51589267,425504719,15312411,432736,1,'2007-09-15 02:41:29',3310502445,1),(51589270,425504776,15316974,432736,1,'2007-09-15 02:41:29',3310502445,1),(51589273,425504719,15321367,432736,1,'2007-09-15 02:41:29',3310502445,1),(51589275,425504605,15323021,432736,1,'2007-09-15 02:41:29',3310502445,1),(51589278,425505862,15329177,432736,1,'2007-09-15 02:41:29',3310502447,1),(51589281,425506848,15332135,432736,1,'2007-09-15 02:41:30',3310502447,1),(51589284,425507834,15334763,432736,1,'2007-09-15 02:41:30',3310502458,1),(51589288,425507751,15337803,432736,1,'2007-09-15 02:41:30',3310502458,1),(51589290,425506154,15340352,434787,1,'2007-09-15 13:10:20',3310502447,1),(51589293,425505908,15344788,434787,1,'2007-09-15 13:10:20',3310502447,1),(51589296,425505826,15347170,434787,1,'2007-09-15 13:10:19',3310502447,1),(51589297,425506976,15351524,434787,1,'2007-09-15 13:10:19',3310502447,1),(51589299,425509933,15358506,434787,1,'2007-09-15 13:10:19',3310502458,1),(51589302,425512726,15364010,434787,1,'2007-09-15 13:10:19',3310502458,1),(51589304,425514697,15368363,434787,1,'2007-09-15 13:10:19',3310502458,1),(51589307,425515683,15372799,434787,1,'2007-09-15 13:10:18',3310502458,1),(51589310,425516587,15379453,434787,1,'2007-09-15 13:10:19',3310502458,1),(51589313,425517819,15385449,434787,1,'2007-09-15 13:10:21',3310502544,1),(51589315,425519051,15390542,434787,1,'2007-09-15 13:10:21',3310502544,1),(51589320,425520612,15395143,434787,1,'2007-09-15 13:10:21',3310502544,1),(51589325,425523651,15399496,434787,1,'2007-09-15 13:10:21',3310502544,1),(51589328,425526608,15403193,434787,1,'2007-09-15 13:10:21',3310502544,1),(51589334,425529894,15406068,434787,1,'2007-09-15 13:10:21',3310502544,1),(51589337,425532687,15407136,434787,1,'2007-09-15 13:10:20',3310502544,1),(51589338,425535809,15407793,434787,1,'2007-09-15 13:10:20',3310502545,1),(51589340,425537944,15410339,434787,1,'2007-09-15 13:10:20',3310502545,1),(51589342,425539341,15412968,434787,1,'2007-09-15 13:10:20',3310502545,1),(51589344,425540737,15413543,434787,1,'2007-09-15 13:10:23',3310502545,1),(51589348,425542462,15412968,434787,1,'2007-09-15 13:10:23',3310502545,1),(51589352,425544762,15411243,434787,1,'2007-09-15 13:10:23',3310502545,1),(51589354,425546980,15409354,434787,1,'2007-09-15 13:10:23',3310502545,1),(51589357,425549116,15408532,434787,1,'2007-09-15 13:10:22',3310502545,1),(51589360,425550513,15408532,434787,1,'2007-09-15 13:10:22',3310502545,1),(51589363,425551663,15409436,434787,1,'2007-09-15 13:10:22',3310502545,1),(51589366,425552402,15411489,434787,1,'2007-09-15 13:10:22',3310502545,1),(51589368,425553141,15415432,434787,1,'2007-09-15 13:10:22',3310502545,1),(51589370,425554866,15423400,434787,1,'2007-09-15 13:10:21',3310502545,1),(51590535,425555649,15427255,434787,1,'2007-09-15 13:10:15',3310502545,1),(51590538,425555931,15430557,434787,1,'2007-09-15 13:10:15',3310502545,1),(51590542,425555891,15433214,434787,1,'2007-09-15 13:10:15',3310502545,1),(51590544,425556253,15435832,434787,1,'2007-09-15 13:10:15',3310502545,1),(51590546,425557421,15438570,434787,1,'2007-09-15 13:10:15',3310502547,1),(51590549,425558790,15441348,434787,1,'2007-09-15 13:10:16',3310502547,1),(51590551,425559394,15443160,434787,1,'2007-09-15 13:10:16',3310502547,1),(51590553,425559796,15446220,434787,1,'2007-09-15 13:10:16',3310502547,1),(51590557,425559149,15451087,434787,1,'2007-09-15 13:10:16',3310502547,1),(51590560,425559149,15453258,434787,1,'2007-09-15 13:10:16',3310502547,1),(51590563,425559817,15454845,434787,1,'2007-09-15 13:10:16',3310502547,1),(51590564,425562406,15457767,434787,1,'2007-09-15 13:10:16',3310502550,1),(51590567,425564910,15459854,434787,1,'2007-09-15 13:10:17',3310502550,1),(51590572,425565411,15461107,434787,1,'2007-09-15 13:10:17',3310502550,1),(51590575,425565411,15462526,434787,1,'2007-09-15 13:10:17',3310502550,1),(51590578,425564409,15463361,434787,1,'2007-09-15 13:10:17',3310502550,1),(51590580,425563408,15463194,434787,1,'2007-09-15 13:10:17',3310502550,1),(51590582,425562155,15461607,434787,1,'2007-09-15 13:10:17',3310502550,1),(51590585,425559901,15459270,434787,1,'2007-09-15 13:10:17',3310502547,1),(51590588,425557730,15457433,434787,1,'2007-09-15 13:10:18',3310502547,1),(51590589,425556645,15457266,434787,1,'2007-09-15 13:10:18',3310502547,1),(51590592,425556227,15458184,434787,1,'2007-09-15 13:10:10',3310502547,1),(51590595,425556227,15459353,434787,1,'2007-09-15 13:10:10',3310502547,1),(51590598,425556979,15460439,434787,1,'2007-09-15 13:10:10',3310502547,1),(51590600,425558899,15462442,434787,1,'2007-09-15 13:10:11',3310502547,1),(51590603,425560318,15464279,434787,1,'2007-09-15 13:10:11',3310502547,1),(51590606,425561738,15467202,434787,1,'2007-09-15 13:10:11',3310502547,1),(51590608,425562239,15470458,434787,1,'2007-09-15 13:10:11',3310502550,1),(51590611,425562656,15472378,434787,1,'2007-09-15 13:10:11',3310502550,1),(51590613,425563241,15474298,434787,1,'2007-09-15 13:10:11',3310502550,1),(51590616,425564409,15475551,434787,1,'2007-09-15 13:10:12',3310502550,1),(51590619,425566747,15476970,434787,1,'2007-09-15 13:10:12',3310502550,1),(51590622,425568751,15477889,434787,1,'2007-09-15 13:10:12',3310502550,1),(51590623,425570671,15479466,434787,1,'2007-09-15 13:10:12',3310502550,1),(51590626,425572897,15481055,434787,1,'2007-09-15 13:10:13',3310502550,1),(51590630,425574397,15482596,434787,1,'2007-09-15 13:10:13',3310502550,1),(51590631,425576139,15485138,434787,1,'2007-09-15 13:10:12',3310502550,1),(51590633,425577846,15488576,434787,1,'2007-09-15 13:10:13',3310502550,1),(51590634,425578080,15490476,434787,1,'2007-09-15 13:10:14',3310502550,1),(51590635,425578362,15491882,434787,1,'2007-09-15 13:10:14',3310502556,1),(51590636,425577975,15492667,434787,1,'2007-09-15 13:10:13',3310502556,1),(51590637,425577424,15493142,434787,1,'2007-09-15 13:10:13',3310502556,1),(51590638,425576700,15493147,434787,1,'2007-09-15 13:10:13',3310502556,1),(51590643,425575865,15491984,434787,1,'2007-09-15 13:10:14',3310502556,1),(51590645,425574926,15489191,434787,1,'2007-09-15 13:10:14',3310502550,1),(51590646,425573626,15487597,434787,1,'2007-09-15 13:10:14',3310502550,1),(51590648,425571256,15486405,434787,1,'2007-09-15 13:10:15',3310502550,1),(51590650,425566831,15484401,434787,1,'2007-09-15 13:10:15',3310502550,1),(51590653,425563074,15482481,434787,1,'2007-09-15 13:10:14',3310502550,1),(51590654,425559817,15480978,434787,1,'2007-09-15 13:10:15',3310502547,1),(51590657,425556895,15479559,434787,1,'2007-09-15 13:10:10',3310502547,1),(51590660,425555225,15478223,434787,1,'2007-09-15 13:10:10',3310502547,1),(51590663,425554004,15475980,434787,1,'2007-09-15 13:10:10',3310502547,1),(51590665,425551946,15471252,434787,1,'2007-09-15 13:10:10',3310502547,1),(51590668,425550521,15467294,434787,1,'2007-09-15 13:10:09',3310502547,1),(51590669,425548451,15463735,434787,1,'2007-09-15 13:10:09',3310502547,1),(51590671,425545923,15461443,434787,1,'2007-09-15 13:10:09',3310502547,1),(51590673,425543447,15459673,434787,1,'2007-09-15 13:10:08',3310502547,1),(51590676,425542796,15458654,434787,1,'2007-09-15 13:10:08',3310502547,1),(51590679,425543116,15457358,434787,1,'2007-09-15 13:10:08',3310502547,1),(51590680,425544224,15455495,434787,1,'2007-09-15 13:10:08',3310502547,1),(51590683,425544446,15453984,434787,1,'2007-09-15 13:10:08',3310502547,1),(51590686,425544705,15451695,434787,1,'2007-09-15 13:10:08',3310502547,1),(51590687,425544581,15447293,434787,1,'2007-09-15 13:10:07',3310502547,1),(51590690,425544377,15443187,434787,1,'2007-09-15 13:10:07',3310502547,1),(51590691,425543168,15441111,434787,1,'2007-09-15 13:10:07',3310502547,1),(51590693,425541616,15440484,434787,1,'2007-09-15 13:10:07',3310502547,1),(51590695,425540029,15440233,434787,1,'2007-09-15 13:10:07',3310502547,1),(51590699,425538102,15441760,434787,1,'2007-09-15 13:10:07',3310502547,1),(51590702,425535516,15443699,434787,1,'2007-09-15 13:10:06',3310502547,1),(51590705,425533208,15444899,434787,1,'2007-09-15 13:10:06',3310502546,1),(51590707,425531699,15444426,434787,1,'2007-09-15 13:10:06',3310502546,1),(51590708,425530689,15442764,434787,1,'2007-09-15 13:10:06',3310502546,1),(51590711,425530258,15440917,434787,1,'2007-09-15 13:10:06',3310502546,1),(51590714,425529310,15438406,434787,1,'2007-09-15 13:10:06',3310502546,1),(51590716,425527691,15437371,434787,1,'2007-09-15 13:10:05',3310502546,1),(51590719,425523974,15436804,434787,1,'2007-09-15 13:10:05',3310502546,1),(51590722,425520899,15437298,434787,1,'2007-09-15 13:10:05',3310502546,1),(51590725,425518624,15437688,434787,1,'2007-09-15 13:10:05',3310502546,1),(51590728,425516244,15437408,434787,1,'2007-09-15 13:10:04',3310502546,1),(51590730,425514311,15436915,434787,1,'2007-09-15 13:10:04',3310502546,1),(51929590,425512717,15436876,434787,1,'2007-09-15 13:06:23',3310502546,1),(51929593,425510506,15436823,434787,1,'2007-09-15 13:06:23',3310502546,1),(51929595,425509454,15436297,434787,1,'2007-09-15 13:06:23',3310502546,1),(51929598,425508717,15435139,434787,1,'2007-09-15 13:06:23',3310502544,1),(51929600,425508349,15432245,434787,1,'2007-09-15 13:06:23',3310502544,1),(51929603,425507770,15430140,434787,1,'2007-09-15 13:06:23',3310502544,1),(51929607,425507349,15429140,434787,1,'2007-09-15 13:06:23',3310502544,1),(51929610,425506349,15428140,434787,1,'2007-09-15 13:06:24',3310502533,1),(51929614,425505454,15427509,434787,1,'2007-09-15 13:06:24',3310502533,1),(51929617,425504507,15426561,434787,1,'2007-09-15 13:06:24',3310502533,1),(51929619,425503139,15425140,434787,1,'2007-09-15 13:06:24',3310502533,1),(51929620,425501981,15424562,434787,1,'2007-09-15 13:06:25',3310502533,1),(51929623,425500718,15424562,434787,1,'2007-09-15 13:06:25',3310502533,1),(51929625,425498823,15424456,434787,1,'2007-09-15 13:06:25',3310502533,1),(51929626,425497297,15424088,434787,1,'2007-09-15 13:06:25',3310502533,1),(51929628,425496455,15423667,434787,1,'2007-09-15 13:06:25',3310502533,1),(51929630,425495824,15422772,434787,1,'2007-09-15 13:06:26',3310502533,1),(51929632,425495403,15421246,434787,1,'2007-09-15 13:06:26',3310502533,1),(51929634,425494982,15419457,434787,1,'2007-09-15 13:06:26',3310502533,1),(51929636,425494455,15416194,434787,1,'2007-09-15 13:06:26',3310502533,1),(51929638,425494245,15413826,434787,1,'2007-09-15 13:06:26',3310502533,1),(51929640,425494140,15411984,434787,1,'2007-09-15 13:06:27',3310502533,1),(51929642,425493929,15410037,434787,1,'2007-09-15 13:06:27',3310502533,1),(51929644,425493508,15409090,434787,1,'2007-09-15 13:06:27',3310502533,1),(51929645,425492666,15408932,434787,1,'2007-09-15 13:06:27',3310502533,1),(51929647,425492456,15409353,434787,1,'2007-09-15 13:06:27',3310502533,1),(51929649,425492403,15410300,434787,1,'2007-09-15 13:06:27',3310502533,1),(51929650,425492350,15411931,434787,1,'2007-09-15 13:06:28',3310502533,1),(51929653,425492350,15413615,434787,1,'2007-09-15 13:06:28',3310502533,1),(51929656,425492666,15418878,434787,1,'2007-09-15 13:06:28',3310502533,1),(51929657,425493192,15421930,434787,1,'2007-09-15 13:06:28',3310502533,1),(51929660,425494455,15427614,434787,1,'2007-09-15 13:06:28',3310502533,1),(51929661,425494719,15428456,434787,1,'2007-09-15 13:06:28',3310502533,1),(51929663,425495297,15428877,434787,1,'2007-09-15 13:06:29',3310502533,1),(51929665,425496087,15429140,434787,1,'2007-09-15 13:06:29',3310502533,1),(51929667,425497876,15429298,434787,1,'2007-09-15 13:06:29',3310502533,1),(51929670,425499297,15429351,434787,1,'2007-09-15 13:06:29',3310502533,1),(51929671,425500455,15429666,434787,1,'2007-09-15 13:06:29',3310502533,1),(51929673,425501718,15430982,434787,1,'2007-09-15 13:06:29',3310502533,1),(51929675,425502770,15432298,434787,1,'2007-09-15 13:06:29',3310502533,1),(51929677,425503454,15433666,434787,1,'2007-09-15 13:06:29',3310502533,1),(51929678,425503981,15436297,434787,1,'2007-09-15 13:06:30',3310502535,1),(51929680,425504191,15438560,434787,1,'2007-09-15 13:06:30',3310502535,1),(51929682,425503981,15442875,434787,1,'2007-09-15 13:06:30',3310502535,1),(51929684,425504297,15444612,434787,1,'2007-09-15 13:06:30',3310502535,1),(51929687,425505612,15446086,434787,1,'2007-09-15 13:06:30',3310502535,1),(51929689,425507244,15446507,434787,1,'2007-09-15 13:06:30',3310502546,1),(51929690,425509454,15446664,434787,1,'2007-09-15 13:06:31',3310502546,1),(51929693,425511612,15447349,434787,1,'2007-09-15 13:06:31',3310502546,1),(51929696,425513980,15448769,434787,1,'2007-09-15 13:06:31',3310502546,1),(51929700,425516032,15450243,434787,1,'2007-09-15 13:06:31',3310502546,1),(51929702,425518084,15451559,434787,1,'2007-09-15 13:06:31',3310502546,1),(51929704,425518663,15452348,434787,1,'2007-09-15 13:06:31',3310502546,1),(51929707,425518769,15453927,434787,1,'2007-09-15 13:06:32',3310502546,1),(51929709,425519453,15456505,434787,1,'2007-09-15 13:06:32',3310502546,1),(51929711,425520453,15458768,434787,1,'2007-09-15 13:06:32',3310502546,1),(51929713,425521716,15460821,434787,1,'2007-09-15 13:06:32',3310502546,1),(51929715,425522768,15463663,434787,1,'2007-09-15 13:06:32',3310502546,1),(51929717,425523610,15466399,434787,1,'2007-09-15 13:06:32',3310502546,1),(51929720,425524400,15469136,434787,1,'2007-09-15 13:06:32',3310502546,1),(51929722,425525242,15471451,434787,1,'2007-09-15 13:06:33',3310502546,1),(51929725,425525978,15473030,434787,1,'2007-09-15 13:06:33',3310502546,1),(51929728,425527136,15474819,434787,1,'2007-09-15 13:06:33',3310502546,1),(51929731,425528820,15476661,434787,1,'2007-09-15 13:06:33',3310502546,1),(51929734,425531136,15478608,434787,1,'2007-09-15 13:06:33',3310502546,1),(51929736,425532767,15480135,434787,1,'2007-09-15 13:06:33',3310502546,1),(51929739,425533571,15481367,434787,1,'2007-09-15 13:06:33',3310502546,1),(51929741,425534577,15483092,434787,1,'2007-09-15 13:06:34',3310502547,1),(51929743,425535382,15485018,434787,1,'2007-09-15 13:06:34',3310502547,1),(51929746,425535899,15488008,434787,1,'2007-09-15 13:06:34',3310502547,1),(51929749,425536647,15490653,434787,1,'2007-09-15 13:06:34',3310502547,1),(51929752,425537653,15492492,434787,1,'2007-09-15 13:06:34',3310502553,1),(51929754,425538544,15493815,434787,1,'2007-09-15 13:06:34',3310502553,1),(51929757,425539320,15495425,434787,1,'2007-09-15 13:06:34',3310502553,1),(51929760,425539953,15497983,434787,1,'2007-09-15 13:06:35',3310502553,1),(51929762,425540355,15500542,434787,1,'2007-09-15 13:06:35',3310502553,1),(51929764,425541116,15503323,434787,1,'2007-09-15 13:06:35',3310502553,1),(51929767,425541564,15505265,434787,1,'2007-09-15 13:06:35',3310502553,1),(51929770,425542722,15508142,434787,1,'2007-09-15 13:06:35',3310502553,1),(51929771,425544366,15511056,434787,1,'2007-09-15 13:06:36',3310502553,1),(51929773,425546085,15513820,434787,1,'2007-09-15 13:06:36',3310502553,1),(51929775,425547579,15516585,434787,1,'2007-09-15 13:06:36',3310502553,1),(51929777,425549148,15519424,434787,1,'2007-09-15 13:06:37',3310502553,1),(51929780,425550456,15521927,434787,1,'2007-09-15 13:06:37',3310502553,1),(51929782,425550941,15523982,434787,1,'2007-09-15 13:06:37',3310502553,1),(51929784,425550904,15526037,434787,1,'2007-09-15 13:06:37',3310502553,1),(51929785,425550493,15527606,434787,1,'2007-09-15 13:06:37',3310502553,1),(51929786,425549335,15531790,434787,1,'2007-09-15 13:06:37',3310502553,1),(51929788,425548364,15536049,434787,1,'2007-09-15 13:06:37',3310502553,1),(51929790,425547841,15539710,434787,1,'2007-09-15 13:06:37',3310502553,1),(51929793,425547392,15544342,434787,1,'2007-09-15 13:06:37',3310502553,1),(51929796,425547654,15546175,434787,1,'2007-09-15 13:06:38',3310502555,1),(51929797,425548102,15548132,434787,1,'2007-09-15 13:06:38',3310502555,1),(51929800,425548178,15549921,434787,1,'2007-09-15 13:06:38',3310502555,1),(51929802,425547874,15551597,434787,1,'2007-09-15 13:06:38',3310502555,1),(51929805,425547645,15553310,434787,1,'2007-09-15 13:06:38',3310502555,1),(51929807,425547836,15554681,434787,1,'2007-09-15 13:06:38',3310502555,1),(51929810,425548064,15555519,434787,1,'2007-09-15 13:06:38',3310502555,1),(51929812,425548826,15556470,434787,1,'2007-09-15 13:06:38',3310502555,1),(51929814,425549701,15557346,434787,1,'2007-09-15 13:06:39',3310502555,1),(51929818,425551415,15557879,434787,1,'2007-09-15 13:06:39',3310502555,1),(51929820,425553547,15557841,434787,1,'2007-09-15 13:06:39',3310502555,1),(51929823,425554804,15557499,434787,1,'2007-09-15 13:06:39',3310502555,1),(51929825,425556822,15556889,434787,1,'2007-09-15 13:06:39',3310502555,1),(51929827,425558307,15556699,434787,1,'2007-09-15 13:06:40',3310502555,1),(51929829,425560210,15556965,434787,1,'2007-09-15 13:06:40',3310502555,1),(51929833,425561162,15558146,434787,1,'2007-09-15 13:06:40',3310502555,1),(51929834,425561924,15561306,434787,1,'2007-09-15 13:06:40',3310502558,1),(51929837,425562305,15563439,434787,1,'2007-09-15 13:06:40',3310502558,1),(51929840,425562343,15565799,434787,1,'2007-09-15 13:06:40',3310502558,1),(51929842,425562305,15567589,434787,1,'2007-09-15 13:06:41',3310502558,1),(51929844,425561581,15570445,434787,1,'2007-09-15 13:06:41',3310502555,1),(51929846,425560858,15574100,434787,1,'2007-09-15 13:06:41',3310502555,1),(51929848,425560858,15576346,434787,1,'2007-09-15 13:06:41',3310502555,1),(51929852,425561048,15579773,434787,1,'2007-09-15 13:06:41',3310502555,1),(51929854,425561391,15583543,434787,1,'2007-09-15 13:06:41',3310502555,1),(51929858,425561543,15586056,434787,1,'2007-09-15 13:06:41',3310502555,1),(51929860,425561467,15587541,434787,1,'2007-09-15 13:06:42',3310502555,1),(51929862,425561162,15589331,434787,1,'2007-09-15 13:06:42',3310502555,1),(51929864,425560627,15593102,434787,1,'2007-09-15 13:06:42',3310502555,1),(51929866,425560510,15595469,434787,1,'2007-09-15 13:06:42',3310502555,1),(51929869,425560006,15599156,434787,1,'2007-09-15 13:06:42',3310502555,1),(51929872,425559812,15602416,434787,1,'2007-09-15 13:06:43',3310502577,1),(51929873,425559695,15605443,434787,1,'2007-09-15 13:06:43',3310502577,1),(51929875,425559307,15610954,434787,1,'2007-09-15 13:06:43',3310502577,1),(51929878,425559152,15613865,434787,1,'2007-09-15 13:06:43',3310502577,1),(51929880,425559152,15616853,434787,1,'2007-09-15 13:06:43',3310502577,1),(51929883,425559152,15618405,434787,1,'2007-09-15 13:06:43',3310502577,1),(51929886,425558919,15619492,434787,1,'2007-09-15 13:06:43',3310502577,1),(51929889,425558609,15620035,434787,1,'2007-09-15 13:06:43',3310502577,1),(51929892,425558065,15620462,434787,1,'2007-09-15 13:06:44',3310502577,1),(51929893,425557367,15620462,434787,1,'2007-09-15 13:06:44',3310502577,1),(51929896,425556862,15620151,434787,1,'2007-09-15 13:06:44',3310502577,1),(51929899,425556513,15619453,434787,1,'2007-09-15 13:06:44',3310502577,1),(51929902,425556358,15618483,434787,1,'2007-09-15 13:06:44',3310502577,1),(51929905,425556241,15617241,434787,1,'2007-09-15 13:06:44',3310502577,1),(51929907,425556435,15615611,434787,1,'2007-09-15 13:06:44',3310502577,1),(51929909,425556591,15614136,434787,1,'2007-09-15 13:06:44',3310502577,1),(51929910,425556707,15612429,434787,1,'2007-09-15 13:06:45',3310502577,1),(51929913,425556629,15611226,434787,1,'2007-09-15 13:06:45',3310502577,1),(51929915,425556358,15610178,434787,1,'2007-09-15 13:06:45',3310502577,1),(51929916,425556086,15609324,434787,1,'2007-09-15 13:06:45',3310502577,1),(51929918,425555387,15608548,434787,1,'2007-09-15 13:06:45',3310502577,1),(51929920,425554107,15607616,434787,1,'2007-09-15 13:06:45',3310502577,1),(51929922,425553137,15606530,434787,1,'2007-09-15 13:06:45',3310502577,1),(51929923,425552360,15606025,434787,1,'2007-09-15 13:06:45',3310502577,1),(51929925,425551662,15605288,434787,1,'2007-09-15 13:06:46',3310502577,1),(51929927,425551274,15604356,434787,1,'2007-09-15 13:06:46',3310502577,1),(51929930,425550847,15602533,434787,1,'2007-09-15 13:06:46',3310502577,1),(51929933,425550614,15600709,434787,1,'2007-09-15 13:06:46',3310502555,1),(51929936,425550653,15597992,434787,1,'2007-09-15 13:06:46',3310502555,1),(51929938,425550342,15596595,434787,1,'2007-09-15 13:06:46',3310502555,1),(51929939,425549683,15594344,434787,1,'2007-09-15 13:06:47',3310502555,1),(51929942,425549101,15591317,434787,1,'2007-09-15 13:06:47',3310502555,1),(51929943,425548596,15588988,434787,1,'2007-09-15 13:06:47',3310502555,1),(51929946,425547859,15585418,434787,1,'2007-09-15 13:06:47',3310502555,1),(51929949,425546500,15581266,434787,1,'2007-09-15 13:06:47',3310502555,1),(51929950,425545491,15579519,434787,1,'2007-09-15 13:06:47',3310502555,1),(51929953,425543706,15577346,434787,1,'2007-09-15 13:06:48',3310502555,1),(51929955,425540679,15573620,434787,1,'2007-09-15 13:06:48',3310502555,1),(51929957,425538584,15571796,434787,1,'2007-09-15 13:06:48',3310502555,1),(51929960,425537342,15570749,434787,1,'2007-09-15 13:06:48',3310502555,1),(51929964,425536100,15569119,434787,1,'2007-09-15 13:06:49',3310502555,1),(51929966,425534664,15566907,434787,1,'2007-09-15 13:06:49',3310502555,1),(51929968,425532723,15562094,434787,1,'2007-09-15 13:06:49',3310502554,1),(51929971,425531404,15559145,434787,1,'2007-09-15 13:06:49',3310502554,1),(51929974,425530356,15556816,434787,1,'2007-09-15 13:06:49',3310502554,1),(51929975,425529075,15552470,434787,1,'2007-09-15 13:06:49',3310502554,1),(51929978,425528804,15549986,434787,1,'2007-09-15 13:06:50',3310502554,1),(51929980,425528299,15546105,434787,1,'2007-09-15 13:06:50',3310502554,1),(51929983,425528338,15542768,434787,1,'2007-09-15 13:06:50',3310502552,1),(51929986,425528571,15540168,434787,1,'2007-09-15 13:06:50',3310502552,1),(51929988,425528843,15535588,434787,1,'2007-09-15 13:06:50',3310502552,1),(51929990,425528726,15533609,434787,1,'2007-09-15 13:06:50',3310502552,1),(51929993,425528338,15530660,434787,1,'2007-09-15 13:06:51',3310502552,1),(51929999,425527484,15527594,434787,1,'2007-09-15 13:06:51',3310502552,1),(51930002,425526553,15525265,434787,1,'2007-09-15 13:06:51',3310502552,1),(51930009,425525117,15522626,434787,1,'2007-09-15 13:06:51',3310502552,1),(51930014,425524302,15521074,434787,1,'2007-09-15 13:06:51',3310502552,1),(51930018,425523371,15520065,434787,1,'2007-09-15 13:06:51',3310502552,1),(51930020,425522439,15519716,434787,1,'2007-09-15 13:06:51',3310502552,1),(51930022,425521663,15520065,434787,1,'2007-09-15 13:06:52',3310502552,1),(51930024,425521508,15520725,434787,1,'2007-09-15 13:06:52',3310502552,1),(51930026,425521663,15521656,434787,1,'2007-09-15 13:06:52',3310502552,1),(51930027,425522439,15522820,864892,1,'2009-03-28 17:17:44',3310502552,2),(51930029,425523293,15524023,434787,1,'2007-09-15 13:06:52',3310502552,1),(51930031,425524186,15525731,434787,1,'2007-09-15 13:06:53',3310502552,1),(51930033,425524186,15526818,434787,1,'2007-09-15 13:06:53',3310502552,1),(51930035,425524030,15528215,434787,1,'2007-09-15 13:06:53',3310502552,1),(51930037,425523759,15529495,434787,1,'2007-09-15 13:06:54',3310502552,1),(51930040,425523409,15530892,434787,1,'2007-09-15 13:06:54',3310502552,1),(51930043,425522711,15532212,434787,1,'2007-09-15 13:06:54',3310502552,1),(51930044,425521974,15533415,434787,1,'2007-09-15 13:06:54',3310502552,1),(51930047,425521197,15535278,434787,1,'2007-09-15 13:06:54',3310502552,1),(51930048,425520809,15536636,434787,1,'2007-09-15 13:06:54',3310502552,1),(51930050,425520128,15539582,434787,1,'2007-09-15 13:06:54',3310502552,1),(51930052,425519834,15542059,434787,1,'2007-09-15 13:06:54',3310502552,1),(51930053,425519582,15544663,434787,1,'2007-09-15 13:06:54',3310502552,1),(51930055,425519414,15547561,434787,1,'2007-09-15 13:06:54',3310502554,1),(51930058,425519540,15550752,434787,1,'2007-09-15 13:06:55',3310502554,1),(51930062,425519960,15554364,434787,1,'2007-09-15 13:06:55',3310502554,1),(51930063,425520212,15557639,434787,1,'2007-09-15 13:06:55',3310502554,1),(51930066,425521010,15561041,434787,1,'2007-09-15 13:06:55',3310502554,1),(51930068,425521723,15563182,434787,1,'2007-09-15 13:06:56',3310502554,1),(51930071,425522437,15567592,434787,1,'2007-09-15 13:06:56',3310502554,1),(51930073,425523697,15571329,434787,1,'2007-09-15 13:06:56',3310502554,1),(51930076,425525251,15573681,434787,1,'2007-09-15 13:06:56',3310502554,1),(51930079,425525839,15575486,434787,1,'2007-09-15 13:06:56',3310502554,1),(51930080,425526007,15578930,434787,1,'2007-09-15 13:06:56',3310502554,1),(51930082,425526217,15582289,434787,1,'2007-09-15 13:06:57',3310502554,1),(51930085,425526763,15588127,434787,1,'2007-09-15 13:06:57',3310502554,1),(51930088,425526427,15590898,434787,1,'2007-09-15 13:06:57',3310502554,1),(51930092,425525839,15592662,434787,1,'2007-09-15 13:06:57',3310502554,1),(51930094,425524831,15594384,434787,1,'2007-09-15 13:06:57',3310502554,1),(51930096,425523790,15596926,434787,1,'2007-09-15 13:06:57',3310502554,1),(51930098,425523067,15598833,434787,1,'2007-09-15 13:06:57',3310502554,1),(51930099,425522168,15600914,434787,1,'2007-09-15 13:06:57',3310502576,1),(51930102,425521379,15602777,434787,1,'2007-09-15 13:06:58',3310502576,1),(51930104,425520371,15606371,434787,1,'2007-09-15 13:06:58',3310502576,1),(51930107,425520152,15608409,434787,1,'2007-09-15 13:06:58',3310502576,1),(51930108,425520086,15612354,434787,1,'2007-09-15 13:06:58',3310502576,1),(51930110,425519867,15616539,434787,1,'2007-09-15 13:06:58',3310502576,1),(51930112,425519495,15618511,434787,1,'2007-09-15 13:06:59',3310502576,1),(51930113,425519254,15620571,434787,1,'2007-09-15 13:06:59',3310502576,1),(51930115,425519012,15622806,434787,1,'2007-09-15 13:06:59',3310502576,1),(51930118,425518793,15624866,434787,1,'2007-09-15 13:06:59',3310502576,1),(51930119,425518749,15628833,434787,1,'2007-09-15 13:06:59',3310502576,1),(51930121,425518991,15630958,434787,1,'2007-09-15 13:06:59',3310502576,1),(51930124,425519341,15633216,434787,1,'2007-09-15 13:06:59',3310502576,1),(51930125,425520486,15635878,434787,1,'2007-09-15 13:07:00',3310502576,1),(51930127,425522535,15640424,434787,1,'2007-09-15 13:07:00',3310502576,1),(51930129,425525608,15646378,434787,1,'2007-09-15 13:07:00',3310502576,1),(51930132,425527016,15648555,434787,1,'2007-09-15 13:07:00',3310502576,1),(51930134,425528779,15650840,434787,1,'2007-09-15 13:07:00',3310502576,1),(51930136,425530254,15653140,434787,1,'2007-09-15 13:07:00',3310502576,1),(51930138,425531209,15655526,434787,1,'2007-09-15 13:07:00',3310502576,1),(51930141,425532076,15658996,434787,1,'2007-09-15 13:07:00',3310502578,1),(51930143,425533248,15662901,434787,1,'2007-09-15 13:07:01',3310502578,1),(51930145,425534332,15666241,434787,1,'2007-09-15 13:07:01',3310502578,1),(51930148,425536371,15670883,434787,1,'2007-09-15 13:07:01',3310502579,1),(51930149,425538280,15673877,434787,1,'2007-09-15 13:07:01',3310502579,1),(51930152,425540319,15676089,434787,1,'2007-09-15 13:07:01',3310502579,1),(51930153,425542749,15678649,434787,1,'2007-09-15 13:07:01',3310502579,1),(51930156,425544744,15681209,434787,1,'2007-09-15 13:07:01',3310502579,1),(51930158,425546827,15685937,434787,1,'2007-09-15 13:07:02',3310502579,1),(51930160,425548041,15690319,434787,1,'2007-09-15 13:07:02',3310502579,1),(51930163,425549560,15696263,434787,1,'2007-09-15 13:07:02',3310502579,1),(51930165,425550731,15700905,434787,1,'2007-09-15 13:07:02',3310502579,1),(51930167,425551729,15704245,434787,1,'2007-09-15 13:07:02',3310502579,1),(51930169,425553074,15707716,864892,1,'2009-03-28 17:18:56',3310502579,3),(51930171,425554245,15710362,434787,1,'2007-09-15 13:07:02',3310502579,1),(51930173,425557152,15713703,434787,1,'2007-09-15 13:07:02',3310502585,1),(51930175,425558942,15715267,434787,1,'2007-09-15 13:07:02',3310502585,1),(51930177,425560396,15716555,864892,1,'2009-03-28 14:31:35',3310502585,2),(51930178,425561102,15718133,434787,1,'2007-09-15 13:07:02',3310502585,1),(51930181,425561143,15719545,434787,1,'2007-09-15 13:07:03',3310502585,1),(51930184,425560977,15720874,434787,1,'2007-09-15 13:07:03',3310502585,1),(51930186,425560556,15722893,1258067,1,'2009-05-20 09:21:27',3310502585,5),(51930188,425559565,15725900,434787,1,'2007-09-15 13:07:03',3310502585,1),(51930191,425558983,15727769,434787,1,'2007-09-15 13:07:03',3310502585,1),(51930193,425558859,15728890,434787,1,'2007-09-15 13:07:03',3310502585,1),(51930195,425558983,15730136,434787,1,'2007-09-15 13:07:04',3310502585,1),(51930198,425559648,15732005,434787,1,'2007-09-15 13:07:04',3310502585,1),(51930199,425561434,15734580,434787,1,'2007-09-15 13:07:04',3310502585,1),(51930202,425566293,15742596,538211,1,'2007-09-30 15:36:23',3310502588,1),(51930206,425568762,15746342,434787,1,'2007-09-15 13:07:05',3310502588,1),(51930208,425570088,15748839,434787,1,'2007-09-15 13:07:05',3310502588,1),(51930211,425571766,15752194,434787,1,'2007-09-15 13:07:05',3310502588,1),(51930213,425573131,15755003,434787,1,'2007-09-15 13:07:05',3310502588,1),(51930216,425574497,15756992,434787,1,'2007-09-15 13:07:05',3310502588,1),(51930219,425576174,15758085,434787,1,'2007-09-15 13:07:05',3310502588,1),(51930222,425577618,15758787,434787,1,'2007-09-15 13:07:05',3310502588,1),(51930223,425579764,15758943,434787,1,'2007-09-15 13:07:06',3310502588,1),(51930226,425581090,15758826,434787,1,'2007-09-15 13:07:06',3310502588,1),(51930228,425582572,15758163,434787,1,'2007-09-15 13:07:06',3310502588,1),(51930230,425585186,15756758,434787,1,'2007-09-15 13:07:06',3310502588,1),(51930232,425587098,15756017,434787,1,'2007-09-15 13:07:06',3310502588,1),(51930235,425589868,15755393,434787,1,'2007-09-15 13:07:06',3310502589,1),(51930238,425593036,15754768,434787,1,'2007-09-15 13:07:06',3310502589,1),(51930241,425595625,15753473,434787,1,'2007-09-15 13:07:07',3310502589,1),(51930242,425599314,15751532,434787,1,'2007-09-15 13:07:07',3310502589,1),(51930245,425603520,15749137,434787,1,'2007-09-15 13:07:07',3310502589,1),(51930247,425605462,15748037,434787,1,'2007-09-15 13:07:07',3310502589,1),(51930250,425606886,15747584,434787,1,'2007-09-15 13:07:07',3310502589,1),(51930252,425608633,15747390,434787,1,'2007-09-15 13:07:07',3310502589,1),(51930253,425610316,15747714,434787,1,'2007-09-15 13:07:07',3310502589,1),(51930255,425611998,15748684,434787,1,'2007-09-15 13:07:08',3310502589,1),(51930257,425613616,15749267,434787,1,'2007-09-15 13:07:08',3310502589,1),(51930259,425615299,15749267,434787,1,'2007-09-15 13:07:08',3310502589,1),(51930262,425617370,15749137,434787,1,'2007-09-15 13:07:08',3310502632,1),(51930264,425619376,15748814,434787,1,'2007-09-15 13:07:08',3310502632,1),(51930267,425622159,15747908,434787,1,'2007-09-15 13:07:08',3310502632,1),(51930270,425625201,15745837,434787,1,'2007-09-15 13:07:09',3310502632,1),(51930272,425628178,15744478,434787,1,'2007-09-15 13:07:09',3310502632,1),(51930275,425630313,15743442,434787,1,'2007-09-15 13:07:09',3310502632,1),(51930278,425633381,15742692,434787,1,'2007-09-15 13:07:09',3310502632,1),(51930280,425635193,15742743,434787,1,'2007-09-15 13:07:09',3310502632,1),(51930282,425637059,15743369,437032,1,'2008-05-13 19:37:07',3310502632,2),(51930284,425638134,15744914,437032,1,'2008-05-13 19:37:07',3310502632,2),(51930288,425638703,15746974,437032,1,'2008-05-13 19:37:07',3310502632,2),(51930291,425638869,15749060,434787,1,'2007-09-15 13:07:10',3310502632,1),(51930293,425639076,15750872,434787,1,'2007-09-15 13:07:10',3310502632,1),(51930297,425640112,15754289,434787,1,'2007-09-15 13:07:10',3310502632,1),(51930299,425640836,15755946,434787,1,'2007-09-15 13:07:10',3310502632,1),(51930302,425641613,15757965,434787,1,'2007-09-15 13:07:11',3310502632,1),(51930305,425642545,15759156,434787,1,'2007-09-15 13:07:11',3310502632,1),(51930307,425643425,15759984,434787,1,'2007-09-15 13:07:11',3310502632,1),(51930309,425644823,15760605,434787,1,'2007-09-15 13:07:11',3310502633,1),(51930311,425646117,15760709,434787,1,'2007-09-15 13:07:11',3310502633,1),(51930312,425647360,15761071,434787,1,'2007-09-15 13:07:11',3310502633,1),(51930313,425649793,15762159,434787,1,'2007-09-15 13:07:12',3310502633,1),(51930314,425652279,15764074,434787,1,'2007-09-15 13:07:12',3310502633,1),(51930315,425654526,15765306,434787,1,'2007-09-15 13:07:12',3310502633,1),(51930319,425656949,15767419,434787,1,'2007-09-15 13:07:12',3310502635,1),(51930321,425659372,15769469,434787,1,'2007-09-15 13:07:13',3310502635,1),(51930324,425661360,15771954,434787,1,'2007-09-15 13:07:13',3310502635,1),(51930326,425663286,15775682,434787,1,'2007-09-15 13:07:13',3310502635,1),(51930328,425664404,15778851,434787,1,'2007-09-15 13:07:13',3310502635,1),(51930331,425664901,15782268,434787,1,'2007-09-15 13:07:13',3310502635,1),(51930332,425665274,15798545,434787,1,'2007-09-15 13:07:13',3310502635,1),(51930334,425660760,15801808,434787,1,'2007-09-15 13:07:13',3310502635,1),(51930336,425660200,15800179,434787,1,'2007-09-15 13:07:13',3310502635,1),(51930338,425659894,15798652,434787,1,'2007-09-15 13:07:14',3310502635,1),(51930340,425659818,15797660,434787,1,'2007-09-15 13:07:14',3310502635,1),(51930343,425659589,15796362,434787,1,'2007-09-15 13:07:14',3310502635,1),(51930345,425659309,15795293,434787,1,'2007-09-15 13:07:14',3310502635,1),(51930348,425659080,15794224,434787,1,'2007-09-15 13:07:14',3310502635,1),(51930349,425658978,15792850,434787,1,'2007-09-15 13:07:14',3310502635,1),(51930352,425658927,15791323,434787,1,'2007-09-15 13:07:14',3310502635,1),(51930354,425658902,15790254,434787,1,'2007-09-15 13:07:14',3310502635,1),(51930357,425658902,15789135,434787,1,'2007-09-15 13:07:14',3310502635,1),(51930359,425658978,15787837,434787,1,'2007-09-15 13:07:15',3310502635,1),(51930360,425659385,15786513,434787,1,'2007-09-15 13:07:15',3310502635,1),(51930362,425659742,15785317,434787,1,'2007-09-15 13:07:15',3310502635,1),(51930364,425660047,15783714,434787,1,'2007-09-15 13:07:15',3310502635,1),(51930365,425660276,15781831,434787,1,'2007-09-15 13:07:15',3310502635,1),(51930368,425660327,15780533,434787,1,'2007-09-15 13:07:16',3310502635,1),(51930371,425660403,15778472,434787,1,'2007-09-15 13:07:16',3310502635,1),(51930373,425660251,15777199,434787,1,'2007-09-15 13:07:16',3310502635,1),(51930376,425659742,15775673,434787,1,'2007-09-15 13:07:16',3310502635,1),(51930378,425659131,15774604,434787,1,'2007-09-15 13:07:16',3310502635,1),(51930380,425658571,15773357,434787,1,'2007-09-15 13:07:16',3310502635,1),(51930382,425658251,15772251,434787,1,'2007-09-15 13:07:17',3310502635,1),(51930384,425657916,15770024,434787,1,'2007-09-15 13:07:17',3310502635,1),(51930386,425658476,15768715,434787,1,'2007-09-15 13:07:17',3310502635,1),(51930388,425657921,15771127,434787,1,'2007-09-15 13:07:17',3310502635,1),(51930390,425658047,15769441,434787,1,'2007-09-15 13:07:18',3310502635,1),(51930396,425657910,15770462,434787,1,'2007-09-15 13:07:18',3310502635,1),(51930403,425665313,15802579,434787,1,'2007-09-15 13:07:18',3310502635,1),(51930405,425665313,15805560,434787,1,'2007-09-15 13:07:18',3310502635,1),(51930408,425665384,15810174,434787,1,'2007-09-15 13:07:18',3310502635,1),(51930410,425665417,15814775,434787,1,'2007-09-15 13:07:18',3310502635,1),(51930412,425665580,15818267,434787,1,'2007-09-15 13:07:18',3310502635,1),(51930413,425666212,15822738,434787,1,'2007-09-15 13:07:19',3310504001,1),(51930415,425667372,15828204,434787,1,'2007-09-15 13:07:19',3310504001,1),(51930416,425668152,15832605,434787,1,'2007-09-15 13:07:19',3310504001,1),(51930417,425668807,15836191,434787,1,'2007-09-15 13:07:19',3310504001,1),(51930418,425669373,15839249,434787,1,'2007-09-15 13:07:19',3310504001,1),(51930420,425669864,15841930,434787,1,'2007-09-15 13:07:19',3310504001,1),(51930422,425670279,15843780,434787,1,'2007-09-15 13:07:19',3310504001,1),(51930424,425671902,15847555,434787,1,'2007-09-15 13:07:19',3310504004,1),(51930426,425672922,15849065,434787,1,'2007-09-15 13:07:20',3310504004,1),(51930428,425674545,15850688,434787,1,'2007-09-15 13:07:20',3310504004,1),(51930429,425676546,15851897,434787,1,'2007-09-15 13:07:20',3310504004,1),(51930433,425678434,15853180,434787,1,'2007-09-15 13:07:20',3310504004,1),(51930437,425679755,15854464,434787,1,'2007-09-15 13:07:20',3310504004,1),(51930439,425681722,15856542,434787,1,'2007-09-15 13:07:21',3310504004,1),(51930441,425684729,15860375,434787,1,'2007-09-15 13:07:21',3310504004,1),(51930443,425687058,15864133,434787,1,'2007-09-15 13:07:21',3310504004,1),(51930445,425688787,15868191,434787,1,'2007-09-15 13:07:21',3310504004,1),(51930447,425690033,15873362,437032,1,'2008-05-13 19:30:42',3310504004,4),(51930448,425691107,15875679,437032,1,'2008-05-13 19:30:42',3310504006,2),(51930449,425692620,15877210,434787,1,'2007-09-15 13:07:21',3310504006,1),(51930450,425694348,15877961,434787,1,'2007-09-15 13:07:21',3310504006,1),(51930453,425696002,15877961,434787,1,'2007-09-15 13:07:22',3310504006,1),(51930455,425697204,15877285,434787,1,'2007-09-15 13:07:22',3310504006,1),(51930457,425698332,15875932,434787,1,'2007-09-15 13:07:22',3310504006,1),(51930458,425701488,15873602,434787,1,'2007-09-15 13:07:22',3310504005,1),(51930461,425704269,15871724,434787,1,'2007-09-15 13:07:22',3310504005,1),(51930462,425706824,15869920,434787,1,'2007-09-15 13:07:23',3310504005,1),(51930465,425710582,15868342,434787,1,'2007-09-15 13:07:23',3310504005,1),(51930467,425713438,15867214,434787,1,'2007-09-15 13:07:23',3310504005,1),(51930469,425716294,15866162,434787,1,'2007-09-15 13:07:23',3310504005,1),(51930470,425718398,15865411,434787,1,'2007-09-15 13:07:23',3310504005,1),(51930473,425720202,15864809,434787,1,'2007-09-15 13:07:23',3310504005,1),(51930475,425722306,15864885,434787,1,'2007-09-15 13:07:24',3310504005,1),(51930478,425724485,15865411,434787,1,'2007-09-15 13:07:24',3310504005,1),(51930481,425725809,15865656,434787,1,'2007-09-15 13:07:24',3310504005,1),(51930483,425727317,15865471,434787,1,'2007-09-15 13:07:24',3310504016,1),(51930485,425728795,15865102,434787,1,'2007-09-15 13:07:25',3310504016,1),(51930488,425730519,15864548,434787,1,'2007-09-15 13:07:25',3310504016,1),(51930492,425731996,15864271,434787,1,'2007-09-15 13:07:25',3310504016,1),(51930495,425733597,15864332,434787,1,'2007-09-15 13:07:25',3310504016,1),(51930497,425735136,15864455,434787,1,'2007-09-15 13:07:25',3310504016,1),(51930500,425735752,15864763,434787,1,'2007-09-15 13:07:25',3310504016,1),(51930503,425736183,15865656,434787,1,'2007-09-15 13:07:25',3310504016,1),(51930505,425735998,15866425,434787,1,'2007-09-15 13:07:26',3310504016,1),(51930507,425735475,15866887,434787,1,'2007-09-15 13:07:26',3310504016,1),(51930509,425734736,15867010,434787,1,'2007-09-15 13:07:26',3310504016,1),(51930511,425733720,15867472,434787,1,'2007-09-15 13:07:26',3310504016,1),(51930513,425730888,15868765,434787,1,'2007-09-15 13:07:26',3310504016,1),(51930517,425729133,15870304,434787,1,'2007-09-15 13:07:26',3310504016,1),(51930519,425724393,15874398,434787,1,'2007-09-15 13:07:27',3310504005,1),(51930521,425719006,15879262,434787,1,'2007-09-15 13:07:27',3310504007,1),(51930524,425714758,15883695,434787,1,'2007-09-15 13:07:27',3310504007,1),(51930527,425712695,15885665,434787,1,'2007-09-15 13:07:27',3310504007,1),(51930531,425711864,15885819,434787,1,'2007-09-15 13:07:27',3310504007,1),(51930534,425711002,15885819,434787,1,'2007-09-15 13:07:28',3310504007,1),(51930537,425710048,15885542,434787,1,'2007-09-15 13:07:28',3310504007,1),(51930540,425708742,15885117,434787,1,'2007-09-15 13:07:28',3310504007,1),(51930542,425707227,15885117,434787,1,'2007-09-15 13:07:28',3310504007,1),(51930544,425705909,15885644,434787,1,'2007-09-15 13:07:29',3310504007,1),(51930548,425704252,15886547,434787,1,'2007-09-15 13:07:29',3310504007,1),(51930553,425702407,15888053,434787,1,'2007-09-15 13:07:29',3310504007,1),(51930556,425700713,15889484,434787,1,'2007-09-15 13:07:29',3310504007,1),(51930560,425699621,15890764,434787,1,'2007-09-15 13:07:29',3310504007,1),(51930563,425698680,15892459,434787,1,'2007-09-15 13:07:29',3310504006,1),(51930565,425696496,15896826,434787,1,'2007-09-15 13:07:30',3310504006,1),(51930567,425692430,15905749,434787,1,'2007-09-15 13:07:30',3310504006,1),(51930569,425691414,15907707,434787,1,'2007-09-15 13:07:30',3310504006,1),(51930572,425690548,15908610,434787,1,'2007-09-15 13:07:30',3310504006,1),(51930573,425689682,15909137,434787,1,'2007-09-15 13:07:30',3310504006,1),(51930576,425688552,15909928,434787,1,'2007-09-15 13:07:30',3310504006,1),(51930579,425687837,15911095,434787,1,'2007-09-15 13:07:30',3310504006,1),(51930582,425687988,15912187,434787,1,'2007-09-15 13:07:31',3310504006,1),(51930583,425688439,15913015,434787,1,'2007-09-15 13:07:31',3310504006,1),(51930586,425689305,15913053,434787,1,'2007-09-15 13:07:31',3310504006,1),(51930588,425690322,15912375,434787,1,'2007-09-15 13:07:31',3310504006,1),(51930590,425691602,15910982,434787,1,'2007-09-15 13:07:31',3310504006,1);
INSERT INTO `current_nodes` VALUES (51930593,425693334,15908384,434787,1,'2007-09-15 13:07:31',3310504006,1),(51930595,425694953,15906125,434787,1,'2007-09-15 13:07:32',3310504006,1),(51930597,425696082,15904168,434787,1,'2007-09-15 13:07:32',3310504006,1),(51930599,425697325,15901457,434787,1,'2007-09-15 13:07:32',3310504006,1),(51930602,425699094,15898332,434787,1,'2007-09-15 13:07:32',3310504006,1),(51930604,425700525,15896976,434787,1,'2007-09-15 13:07:33',3310504007,1),(51930606,425701880,15895809,434787,1,'2007-09-15 13:07:33',3310504007,1),(51930609,425703085,15895470,434787,1,'2007-09-15 13:07:33',3310504007,1),(51930611,425704252,15895621,434787,1,'2007-09-15 13:07:33',3310504007,1),(51930614,425707565,15897541,434787,1,'2007-09-15 13:07:33',3310504007,1),(51930616,425711293,15900060,434787,1,'2007-09-15 13:07:33',3310504007,1),(51930619,425713002,15901342,434787,1,'2007-09-15 13:07:33',3310504007,1),(51930621,425714406,15903294,434787,1,'2007-09-15 13:07:33',3310504007,1),(51930623,425715397,15905109,434787,1,'2007-09-15 13:07:34',3310504007,1),(51930626,425713666,15902132,434787,1,'2007-09-15 13:07:34',3310504007,1),(51930628,425712390,15900781,434787,1,'2007-09-15 13:07:34',3310504007,1),(51930630,425711914,15900460,434787,1,'2007-09-15 13:07:34',3310504007,1),(51930633,425716700,15907497,434787,1,'2007-09-15 13:07:34',3310504007,1),(51930636,425717966,15909572,434787,1,'2007-09-15 13:07:35',3310504007,1),(51930638,425719092,15910838,434787,1,'2007-09-15 13:07:35',3310504007,1),(51930640,425720393,15911752,434787,1,'2007-09-15 13:07:35',3310504007,1),(51930641,425721835,15912209,434787,1,'2007-09-15 13:07:35',3310504007,1),(51930643,425723875,15912385,434787,1,'2007-09-15 13:07:35',3310504007,1),(51930645,425725387,15912209,434787,1,'2007-09-15 13:07:35',3310504007,1),(51930648,425726441,15912264,370566,1,'2008-05-09 02:14:25',3310504007,2),(51930650,425727452,15912797,370566,1,'2008-05-09 02:14:25',3310504018,2),(51930652,425728025,15914003,434787,1,'2007-09-15 13:07:36',3310504018,1),(51930653,425727893,15916092,434787,1,'2007-09-15 13:07:36',3310504018,1),(51930656,425727467,15920407,434787,1,'2007-09-15 13:07:36',3310504018,1),(51930657,425726677,15923446,434787,1,'2007-09-15 13:07:36',3310504007,1),(51930661,425725158,15927336,434787,1,'2007-09-15 13:07:37',3310504007,1),(51930663,425723335,15931104,434787,1,'2007-09-15 13:07:37',3310504013,1),(51930665,425723031,15933778,434787,1,'2007-09-15 13:07:37',3310504013,1),(51930668,425722788,15937424,434787,1,'2007-09-15 13:07:38',3310504013,1),(51930671,425722328,15939716,434787,1,'2007-09-15 13:07:38',3310504013,1),(51930674,425721432,15943132,434787,1,'2007-09-15 13:07:38',3310504013,1),(51930676,425720816,15945093,434787,1,'2007-09-15 13:07:38',3310504013,1),(51930680,425720592,15946213,434787,1,'2007-09-15 13:07:39',3310504013,1),(51930682,425720592,15947949,434787,1,'2007-09-15 13:07:39',3310504013,1),(51930684,425721040,15950526,434787,1,'2007-09-15 13:07:39',3310504013,1),(51930686,425721936,15952206,434787,1,'2007-09-15 13:07:40',3310504013,1),(51930687,425723336,15953158,434787,1,'2007-09-15 13:07:40',3310504013,1),(51930689,425724792,15954502,434787,1,'2007-09-15 13:07:40',3310504013,1),(51930691,425725632,15956015,434787,1,'2007-09-15 13:07:40',3310504013,1),(51930692,425725969,15957471,434787,1,'2007-09-15 13:07:40',3310504013,1),(51930695,425725969,15960215,434787,1,'2007-09-15 13:07:40',3310504013,1),(51930697,425725576,15963520,434787,1,'2007-09-15 13:07:40',3310504013,1),(51930699,425724848,15968785,434787,1,'2007-09-15 13:07:40',3310504013,1),(51930702,425724456,15973490,434787,1,'2007-09-15 13:07:41',3310504013,1),(51930705,425724344,15976290,434787,1,'2007-09-15 13:07:41',3310504013,1),(51930706,425724120,15979819,434787,1,'2007-09-15 13:07:41',3310504013,1),(51930709,425724120,15984132,434787,1,'2007-09-15 13:07:41',3310504013,1),(51930712,425724232,15989004,434787,1,'2007-09-15 13:07:41',3310504015,1),(51930713,425724568,15998022,434787,1,'2007-09-15 13:07:41',3310504015,1),(51930716,425724736,16003791,434787,1,'2007-09-15 13:07:42',3310504015,1),(51930718,425725240,16009392,434787,1,'2007-09-15 13:07:42',3310504015,1),(51930721,425725913,16012585,434787,1,'2007-09-15 13:07:42',3310504015,1),(51930723,425726473,16016113,434787,1,'2007-09-15 13:07:42',3310504015,1),(51930726,425726753,16019474,434787,1,'2007-09-15 13:07:42',3310504026,1),(51930727,425726753,16022722,434787,1,'2007-09-15 13:07:42',3310504026,1),(51930729,425726193,16024011,434787,1,'2007-09-15 13:07:42',3310504015,1),(51930731,425725296,16024683,434787,1,'2007-09-15 13:07:43',3310504015,1),(51930732,425724120,16024571,434787,1,'2007-09-15 13:07:43',3310504015,1),(51930734,425723448,16023787,434787,1,'2007-09-15 13:07:43',3310504015,1),(51930736,425723448,16022498,434787,1,'2007-09-15 13:07:43',3310504015,1),(51930738,425723784,16020034,434787,1,'2007-09-15 13:07:43',3310504015,1),(51930741,425724232,16016841,434787,1,'2007-09-15 13:07:43',3310504015,1),(51930743,425724232,16014937,434787,1,'2007-09-15 13:07:44',3310504015,1),(51930745,425723728,16012977,434787,1,'2007-09-15 13:07:44',3310504015,1),(51930748,425723056,16010736,434787,1,'2007-09-15 13:07:44',3310504015,1),(51930750,425722496,16009056,434787,1,'2007-09-15 13:07:44',3310504015,1),(51930751,425721936,16006368,434787,1,'2007-09-15 13:07:44',3310504015,1),(51930754,425721376,16003287,434787,1,'2007-09-15 13:07:45',3310504015,1),(51930756,425720928,15998022,434787,1,'2007-09-15 13:07:45',3310504015,1),(51930758,425720480,15993485,434787,1,'2007-09-15 13:07:45',3310504015,1),(51930761,425719583,15985756,434787,1,'2007-09-15 13:07:45',3310504015,1),(51930762,425718631,15980155,434787,1,'2007-09-15 13:07:45',3310504013,1),(51930765,425718183,15976290,434787,1,'2007-09-15 13:07:45',3310504013,1),(51930768,425717735,15972538,434787,1,'2007-09-15 13:07:45',3310504013,1),(51930769,425717399,15967833,434787,1,'2007-09-15 13:07:46',3310504013,1),(51930771,425717231,15965984,434787,1,'2007-09-15 13:07:46',3310504013,1),(51930775,425716783,15964416,434787,1,'2007-09-15 13:07:46',3310504013,1),(51930777,425715887,15963240,434787,1,'2007-09-15 13:07:46',3310504013,1),(51930779,425714767,15962288,434787,1,'2007-09-15 13:07:46',3310504013,1),(51930781,425713366,15961896,434787,1,'2007-09-15 13:07:46',3310504013,1),(51930783,425712134,15961560,434787,1,'2007-09-15 13:07:47',3310504013,1),(51930786,425710678,15960551,434787,1,'2007-09-15 13:07:47',3310504013,1),(51930788,425709782,15959095,434787,1,'2007-09-15 13:07:47',3310504013,1),(51930790,425708998,15957527,434787,1,'2007-09-15 13:07:47',3310504013,1),(51930793,425708942,15955903,434787,1,'2007-09-15 13:07:47',3310504013,1),(51930794,425708885,15953774,434787,1,'2007-09-15 13:07:48',3310504013,1),(51930797,425708942,15950582,434787,1,'2007-09-15 13:07:48',3310504013,1),(51930800,425708998,15947445,434787,1,'2007-09-15 13:07:48',3310504013,1),(51930802,425709345,15944891,434787,1,'2007-09-15 13:07:48',3310504013,1),(51930806,425709927,15942919,434787,1,'2007-09-15 13:07:48',3310504013,1),(51930807,425710107,15941889,434787,1,'2007-09-15 13:07:49',3310504013,1),(51930808,425710107,15941306,434787,1,'2007-09-15 13:07:49',3310504013,1),(51930809,425709927,15940500,434787,1,'2007-09-15 13:07:49',3310504013,1),(51930812,425709300,15940231,434787,1,'2007-09-15 13:07:49',3310504013,1),(51930814,425708942,15940589,434787,1,'2007-09-15 13:07:49',3310504013,1),(51930815,425708493,15941172,434787,1,'2007-09-15 13:07:49',3310504013,1),(51930816,425707911,15942740,434787,1,'2007-09-15 13:07:50',3310504013,1),(51930818,425707552,15945473,434787,1,'2007-09-15 13:07:50',3310504013,1),(51930821,425707597,15948924,434787,1,'2007-09-15 13:07:50',3310504013,1),(51930823,425707328,15951164,434787,1,'2007-09-15 13:07:50',3310504013,1),(51930826,425706522,15953539,434787,1,'2007-09-15 13:07:50',3310504013,1),(51930828,425705715,15957796,434787,1,'2007-09-15 13:07:50',3310504013,1),(51930830,425706119,15959946,434787,1,'2007-09-15 13:07:50',3310504013,1),(51930831,425707463,15962635,434787,1,'2007-09-15 13:07:51',3310504013,1),(51930834,425708942,15965458,434787,1,'2007-09-15 13:07:51',3310504013,1),(51930836,425710286,15966488,434787,1,'2007-09-15 13:07:51',3310504013,1),(51930839,425711899,15967340,434787,1,'2007-09-15 13:07:51',3310504013,1),(51930840,425712437,15968505,434787,1,'2007-09-15 13:07:51',3310504013,1),(51930843,425712481,15970073,434787,1,'2007-09-15 13:07:51',3310504013,1),(51930844,425711630,15982306,434787,1,'2007-09-15 13:07:51',3310504013,1),(51930847,425710913,15988803,434787,1,'2007-09-15 13:07:52',3310504015,1),(51930850,425710107,15993597,434787,1,'2007-09-15 13:07:52',3310504015,1),(51930851,425709031,15998885,434787,1,'2007-09-15 13:07:52',3310504015,1),(51930854,425707866,16003993,434787,1,'2007-09-15 13:07:52',3310504015,1),(51930855,425707060,16005292,434787,1,'2007-09-15 13:07:52',3310504015,1),(51930858,425706074,16005651,434787,1,'2007-09-15 13:07:52',3310504015,1),(51930859,425705088,16005471,434787,1,'2007-09-15 13:07:52',3310504015,1),(51930862,425704416,16004710,434787,1,'2007-09-15 13:07:52',3310504015,1),(51930864,425704416,16003545,434787,1,'2007-09-15 13:07:53',3310504015,1),(51930865,425704954,16001752,434787,1,'2007-09-15 13:07:53',3310504015,1),(51930866,425706432,15997585,434787,1,'2007-09-15 13:07:53',3310504015,1),(51930867,425706791,15996286,434787,1,'2007-09-15 13:07:53',3310504015,1),(51930869,425706880,15993866,434787,1,'2007-09-15 13:07:53',3310504015,1),(51930871,425706880,15989161,434787,1,'2007-09-15 13:07:53',3310504015,1),(51930873,425706567,15982261,434787,1,'2007-09-15 13:07:53',3310504013,1),(51930876,425706746,15980334,434787,1,'2007-09-15 13:07:53',3310504013,1),(51930879,425707060,15978004,434787,1,'2007-09-15 13:07:54',3310504013,1),(51930882,425707328,15976391,434787,1,'2007-09-15 13:07:54',3310504013,1),(51930883,425707328,15975181,434787,1,'2007-09-15 13:07:54',3310504013,1),(51930885,425707149,15974509,434787,1,'2007-09-15 13:07:54',3310504013,1),(51930887,425706611,15974195,434787,1,'2007-09-15 13:07:54',3310504013,1),(51930889,425705895,15974733,434787,1,'2007-09-15 13:07:54',3310504013,1),(51930891,425705402,15975360,434787,1,'2007-09-15 13:07:55',3310504013,1),(51930893,425704685,15977377,434787,1,'2007-09-15 13:07:55',3310504013,1),(51930895,425703878,15979079,434787,1,'2007-09-15 13:07:55',3310504013,1),(51930896,425703475,15981275,434787,1,'2007-09-15 13:07:55',3310504013,1),(51930898,425703565,15983560,434787,1,'2007-09-15 13:07:55',3310504013,1),(51930900,425703385,15987055,434787,1,'2007-09-15 13:07:55',3310504015,1),(51930901,425702982,15990057,434787,1,'2007-09-15 13:07:55',3310504015,1),(51930905,425702534,15991312,434787,1,'2007-09-15 13:07:56',3310504015,1),(51930907,425701996,15992387,434787,1,'2007-09-15 13:07:56',3310504015,1),(51930908,425701279,15993194,434787,1,'2007-09-15 13:07:56',3310504015,1),(51930909,425700338,15993508,434787,1,'2007-09-15 13:07:56',3310504015,1),(51930911,425699621,15993508,434787,1,'2007-09-15 13:07:56',3310504015,1),(51930913,425698680,15993328,434787,1,'2007-09-15 13:07:56',3310504014,1),(51930915,425697381,15993418,434787,1,'2007-09-15 13:07:57',3310504014,1),(51930918,425696485,15993732,434787,1,'2007-09-15 13:07:57',3310504014,1),(51930920,425695021,15994415,434787,1,'2007-09-15 13:07:57',3310504014,1),(51930923,425693368,15996113,434787,1,'2007-09-15 13:07:57',3310504014,1),(51930926,425691446,15999286,434787,1,'2007-09-15 13:07:57',3310504014,1),(51930928,425689480,16001654,434787,1,'2007-09-15 13:07:58',3310504014,1),(51930930,425687621,16004067,434787,1,'2007-09-15 13:07:58',3310504014,1),(51930932,425686156,16005568,434787,1,'2007-09-15 13:07:58',3310504014,1),(51930935,425684976,16006069,434787,1,'2007-09-15 13:07:58',3310504014,1),(51930937,425684154,16005818,434787,1,'2007-09-15 13:07:58',3310504014,1),(51930940,425683689,16005139,434787,1,'2007-09-15 13:07:58',3310504014,1),(51930942,425683618,16004174,434787,1,'2007-09-15 13:07:58',3310504014,1),(51930944,425683904,16003388,434787,1,'2007-09-15 13:07:59',3310504014,1),(51930947,425684297,16002851,434787,1,'2007-09-15 13:07:59',3310504014,1),(51930950,425685012,16002315,434787,1,'2007-09-15 13:07:59',3310504014,1),(51930952,425686299,16001707,434787,1,'2007-09-15 13:08:00',3310504014,1),(51930953,425687550,16000456,434787,1,'2007-09-15 13:08:00',3310504014,1),(51930954,425688408,15999026,434787,1,'2007-09-15 13:08:00',3310504014,1),(51930956,425689016,15997167,434787,1,'2007-09-15 13:08:00',3310504014,1),(51930958,425689194,15995916,434787,1,'2007-09-15 13:08:00',3310504014,1),(51930961,425689051,15994236,434787,1,'2007-09-15 13:08:00',3310504014,1),(51930962,425688837,15992413,434787,1,'2007-09-15 13:08:00',3310504014,1),(51930965,425688765,15990161,434787,1,'2007-09-15 13:08:01',3310504014,1),(51930967,425689266,15988159,434787,1,'2007-09-15 13:08:01',3310504014,1),(51930968,425690267,15986944,434787,1,'2007-09-15 13:08:01',3310504014,1),(51930971,425692161,15986121,434787,1,'2007-09-15 13:08:01',3310504014,1),(51930973,425693698,15985335,434787,1,'2007-09-15 13:08:01',3310504012,1),(51930974,425694664,15984549,434787,1,'2007-09-15 13:08:01',3310504012,1),(51930975,425696094,15983154,434787,1,'2007-09-15 13:08:01',3310504012,1),(51930976,425696523,15981188,434787,1,'2007-09-15 13:08:01',3310504012,1),(51930978,425696594,15979437,434787,1,'2007-09-15 13:08:02',3310504012,1),(51930981,425696594,15978078,434787,1,'2007-09-15 13:08:02',3310504012,1),(51930983,425695700,15976291,434787,1,'2007-09-15 13:08:02',3310504012,1),(51930984,425694092,15974897,434787,1,'2007-09-15 13:08:02',3310504012,1),(51930985,425691625,15972716,434787,1,'2007-09-15 13:08:03',3310504012,1),(51930986,425688908,15970571,434787,1,'2007-09-15 13:08:03',3310504012,1),(51930987,425687872,15970214,434787,1,'2007-09-15 13:08:03',3310504012,1),(51930990,425686334,15969856,434787,1,'2007-09-15 13:08:03',3310504012,1),(51930992,425684404,15969606,434787,1,'2007-09-15 13:08:03',3310504012,1),(51930995,425683046,15969034,434787,1,'2007-09-15 13:08:03',3310504012,1),(51930998,425681473,15967926,434787,1,'2007-09-15 13:08:04',3310504012,1),(51930999,425679578,15966210,434787,1,'2007-09-15 13:08:04',3310504012,1),(51931002,425677969,15963672,434787,1,'2007-09-15 13:08:04',3310504012,1),(51931005,425677183,15961741,434787,1,'2007-09-15 13:08:04',3310504012,1),(51931006,425676611,15958667,434787,1,'2007-09-15 13:08:04',3310504012,1),(51931009,425675949,15955049,434787,1,'2007-09-15 13:08:04',3310504012,1),(51931012,425675405,15951906,434787,1,'2007-09-15 13:08:04',3310504012,1),(51931014,425674317,15948219,434787,1,'2007-09-15 13:08:05',3310504012,1),(51931018,425672927,15946285,434787,1,'2007-09-15 13:08:05',3310504012,1),(51931020,425670872,15944049,434787,1,'2007-09-15 13:08:05',3310504009,1),(51931023,425668998,15941269,434787,1,'2007-09-15 13:08:05',3310504009,1),(51931025,425666097,15936554,434787,1,'2007-09-15 13:08:05',3310504009,1),(51931026,425664163,15933895,434787,1,'2007-09-15 13:08:05',3310504009,1),(51931029,425662350,15932263,434787,1,'2007-09-15 13:08:06',3310504009,1),(51931032,425660597,15930571,434787,1,'2007-09-15 13:08:06',3310504009,1),(51931036,425658723,15927911,434787,1,'2007-09-15 13:08:06',3310504003,1),(51931037,425657575,15925856,434787,1,'2007-09-15 13:08:06',3310504003,1),(51931040,425656047,15924149,434787,1,'2007-09-15 13:08:06',3310504003,1),(51931043,425654593,15922819,434787,1,'2007-09-15 13:08:06',3310504003,1),(51931045,425652488,15920745,434787,1,'2007-09-15 13:08:07',3310504003,1),(51931047,425651374,15919322,434787,1,'2007-09-15 13:08:07',3310504003,1),(51931050,425649951,15916568,434787,1,'2007-09-15 13:08:07',3310504003,1),(51931053,425649239,15915918,434787,1,'2007-09-15 13:08:07',3310504003,1),(51931055,425648651,15915887,434787,1,'2007-09-15 13:08:07',3310504003,1),(51931057,425648311,15916413,434787,1,'2007-09-15 13:08:07',3310504003,1),(51931060,425648125,15916939,434787,1,'2007-09-15 13:08:07',3310504003,1),(51931062,425648342,15917991,434787,1,'2007-09-15 13:08:08',3310504003,1),(51931065,425649115,15919446,434787,1,'2007-09-15 13:08:08',3310504003,1),(51931066,425651405,15922726,434787,1,'2007-09-15 13:08:08',3310504003,1),(51931069,425653045,15924242,434787,1,'2007-09-15 13:08:08',3310504003,1),(51931070,425654221,15926377,434787,1,'2007-09-15 13:08:08',3310504003,1),(51931073,425657409,15931948,434787,1,'2007-09-15 13:08:09',3310504009,1),(51931076,425663258,15940767,434787,1,'2007-09-15 13:08:09',3310504009,1),(51931077,425665764,15944976,434787,1,'2007-09-15 13:08:09',3310504009,1),(51931080,425666754,15948504,434787,1,'2007-09-15 13:08:09',3310504009,1),(51931084,425667219,15952557,434787,1,'2007-09-15 13:08:09',3310504009,1),(51931087,425666909,15955312,434787,1,'2007-09-15 13:08:09',3310504009,1),(51931090,425664485,15961121,434787,1,'2007-09-15 13:08:09',3310504009,1),(51931093,425662908,15963986,434787,1,'2007-09-15 13:08:09',3310504009,1),(51931095,425661936,15966089,434787,1,'2007-09-15 13:08:09',3310504009,1),(51931097,425661200,15966772,434787,1,'2007-09-15 13:08:10',3310504009,1),(51931099,425660648,15966956,434787,1,'2007-09-15 13:08:10',3310504009,1),(51931101,425660043,15966825,434787,1,'2007-09-15 13:08:10',3310504009,1),(51931103,425659386,15966510,434787,1,'2007-09-15 13:08:11',3310504009,1),(51931105,425658680,15966344,434787,1,'2007-09-15 13:08:11',3310504009,1),(51951640,426315393,14854723,434787,1,'2007-09-15 13:47:46',3310503081,1),(51951645,426316435,14864695,434787,1,'2007-09-15 13:47:46',3310503081,1),(51951647,426317923,14873922,434787,1,'2007-09-15 13:47:46',3310503081,1),(51951648,426320453,14882704,434787,1,'2007-09-15 13:47:46',3310503081,1),(51951650,426324025,14890443,434787,1,'2007-09-15 13:47:47',3310503083,1),(51951652,426327597,14897438,434787,1,'2007-09-15 13:47:47',3310503083,1),(51951654,426329681,14902350,434787,1,'2007-09-15 13:47:47',3310503083,1),(51951657,426329830,14905326,434787,1,'2007-09-15 13:47:47',3310503083,1),(51951658,426328342,14910833,434787,1,'2007-09-15 13:47:47',3310503083,1),(51951661,426327449,14919466,434787,1,'2007-09-15 13:47:48',3310503083,1),(51951665,426327151,14929586,434787,1,'2007-09-15 13:47:48',3310503083,1),(51951667,426326556,14935688,434787,1,'2007-09-15 13:47:48',3310503083,1),(51951670,426325514,14945660,434787,1,'2007-09-15 13:47:48',3310503425,1),(51951673,426324770,14954144,434787,1,'2007-09-15 13:47:48',3310503425,1),(51951676,426322984,14959353,434787,1,'2007-09-15 13:47:48',3310503425,1),(51951678,426321198,14961139,434787,1,'2007-09-15 13:47:49',3310503425,1),(51951680,426319147,14962559,434787,1,'2007-09-15 13:47:49',3310503425,1),(51951682,426317197,14963534,434787,1,'2007-09-15 13:47:49',3310503425,1),(51951684,426315185,14964144,434787,1,'2007-09-15 13:47:49',3310503425,1),(51951686,426313112,14963900,434787,1,'2007-09-15 13:47:49',3310503425,1),(51951689,426311588,14963230,434787,1,'2007-09-15 13:47:49',3310503425,1),(51951690,426310918,14962315,434787,1,'2007-09-15 13:47:49',3310503425,1),(51951692,426308113,14960608,434787,1,'2007-09-15 13:47:50',3310503425,1),(51951694,426306163,14959511,434787,1,'2007-09-15 13:47:50',3310503425,1),(51951696,426304334,14957499,434787,1,'2007-09-15 13:47:50',3310503425,1),(51951700,426302078,14954085,434787,1,'2007-09-15 13:47:50',3310503424,1),(51951701,426300066,14950976,434787,1,'2007-09-15 13:47:51',3310503424,1),(51951703,426298298,14947745,434787,1,'2007-09-15 13:47:51',3310503424,1),(51951706,426296287,14944270,434787,1,'2007-09-15 13:47:51',3310503424,1),(51951709,426293787,14940186,434787,1,'2007-09-15 13:47:51',3310503082,1),(51951711,426290678,14936894,434787,1,'2007-09-15 13:47:51',3310503082,1),(51951713,426288118,14934212,434787,1,'2007-09-15 13:47:51',3310503082,1),(51951716,426285740,14932931,434787,1,'2007-09-15 13:47:51',3310503082,1),(51951719,426283850,14932261,434787,1,'2007-09-15 13:47:52',3310503082,1),(51951723,426282326,14932261,434787,1,'2007-09-15 13:47:52',3310503082,1),(51951726,426280985,14932444,434787,1,'2007-09-15 13:47:52',3310503082,1),(51951729,426279339,14933785,434787,1,'2007-09-15 13:47:52',3310503082,1),(51951731,426278059,14933724,434787,1,'2007-09-15 13:47:52',3310503082,1),(51951734,426276718,14933480,434787,1,'2007-09-15 13:47:52',3310503082,1),(51951736,426275377,14932017,434787,1,'2007-09-15 13:47:52',3310502399,1),(51951739,426274096,14931590,434787,1,'2007-09-15 13:47:53',3310502399,1),(51951741,426272938,14931895,434787,1,'2007-09-15 13:47:53',3310502399,1),(51951744,426272572,14932992,434787,1,'2007-09-15 13:47:53',3310502399,1),(51951747,426272572,14933541,434787,1,'2007-09-15 13:47:53',3310502399,1),(51951748,426273548,14934699,434787,1,'2007-09-15 13:47:53',3310502399,1),(51951751,426275072,14935553,434787,1,'2007-09-15 13:47:54',3310502399,1),(51951755,426278730,14937382,434787,1,'2007-09-15 13:47:54',3310503082,1),(51951758,426281351,14939088,434787,1,'2007-09-15 13:47:54',3310503082,1),(51951761,426284399,14941466,434787,1,'2007-09-15 13:47:54',3310503082,1),(51951763,426286411,14943783,434787,1,'2007-09-15 13:47:54',3310503424,1),(51951766,426287813,14945002,434787,1,'2007-09-15 13:47:54',3310503424,1),(51951769,426289703,14946038,434787,1,'2007-09-15 13:47:55',3310503424,1),(51951772,426290251,14946953,434787,1,'2007-09-15 13:47:55',3310503424,1),(51951775,426290068,14948233,434787,1,'2007-09-15 13:47:55',3310503424,1),(51951777,426289215,14948599,434787,1,'2007-09-15 13:47:55',3310503424,1),(51951780,426287996,14947928,434787,1,'2007-09-15 13:47:55',3310503424,1),(51951784,426286655,14947014,434787,1,'2007-09-15 13:47:55',3310503424,1),(51951785,426285070,14945733,434787,1,'2007-09-15 13:47:55',3310503424,1),(51951788,426282387,14944209,434787,1,'2007-09-15 13:47:56',3310503424,1),(51951790,426280254,14942685,434787,1,'2007-09-15 13:47:56',3310503424,1),(51951793,426279034,14941954,434787,1,'2007-09-15 13:47:56',3310503424,1),(51951796,426277937,14942015,434787,1,'2007-09-15 13:47:56',3310503424,1),(51951799,426277388,14942563,434787,1,'2007-09-15 13:47:56',3310503424,1),(51951801,426277205,14943661,434787,1,'2007-09-15 13:47:57',3310503424,1),(51951805,426277510,14944453,434787,1,'2007-09-15 13:47:57',3310503424,1),(51951808,426278181,14945490,434787,1,'2007-09-15 13:47:57',3310503424,1),(51951810,426279644,14946160,434787,1,'2007-09-15 13:47:58',3310503424,1),(51951813,426281656,14946770,434787,1,'2007-09-15 13:47:58',3310503424,1),(51951816,426282997,14948416,434787,1,'2007-09-15 13:47:58',3310503424,1),(51951817,426284765,14950549,434787,1,'2007-09-15 13:47:58',3310503424,1),(51951819,426288057,14952866,434787,1,'2007-09-15 13:47:58',3310503424,1),(51951821,426291532,14955183,434787,1,'2007-09-15 13:47:58',3310503424,1),(51951824,426293482,14956646,434787,1,'2007-09-15 13:47:58',3310503424,1),(51951827,426294153,14957743,434787,1,'2007-09-15 13:47:59',3310503424,1),(51951830,426294214,14958901,434787,1,'2007-09-15 13:47:59',3310503424,1),(51951833,426293665,14959877,434787,1,'2007-09-15 13:47:59',3310503424,1),(51951836,426292812,14960120,434787,1,'2007-09-15 13:47:59',3310503424,1),(51951838,426291775,14959694,434787,1,'2007-09-15 13:47:59',3310503424,1),(51951840,426290068,14958596,434787,1,'2007-09-15 13:47:59',3310503424,1),(51951843,426288910,14957987,434787,1,'2007-09-15 13:48:00',3310503424,1),(51951846,426287569,14957499,434787,1,'2007-09-15 13:48:00',3310503424,1),(51951848,426286106,14958170,434787,1,'2007-09-15 13:48:00',3310503424,1),(51951851,426284399,14958901,434787,1,'2007-09-15 13:48:00',3310503424,1),(51951854,426282753,14959267,434787,1,'2007-09-15 13:48:00',3310503424,1),(51951857,426280863,14959694,434787,1,'2007-09-15 13:48:00',3310503424,1),(51951858,426279888,14960425,434787,1,'2007-09-15 13:48:01',3310503424,1),(51951859,426279522,14961584,434787,1,'2007-09-15 13:48:01',3310503424,1),(51951861,426279949,14962559,434787,1,'2007-09-15 13:48:01',3310503424,1),(51951864,426281229,14963778,434787,1,'2007-09-15 13:48:01',3310503424,1),(51951865,426282814,14964266,434787,1,'2007-09-15 13:48:01',3310503424,1),(51951868,426285496,14964022,434787,1,'2007-09-15 13:48:02',3310503424,1),(51951872,426288423,14963839,434787,1,'2007-09-15 13:48:02',3310503424,1),(51951874,426290495,14964144,434787,1,'2007-09-15 13:48:02',3310503424,1),(51951876,426292873,14964876,434787,1,'2007-09-15 13:48:02',3310503424,1),(51951879,426296287,14966826,434787,1,'2007-09-15 13:48:02',3310503424,1),(51951882,426298542,14968655,434787,1,'2007-09-15 13:48:02',3310503424,1),(51951885,426298725,14969509,434787,1,'2007-09-15 13:48:02',3310503424,1),(51951886,426298542,14970423,434787,1,'2007-09-15 13:48:03',3310503424,1),(51951889,426297933,14971033,434787,1,'2007-09-15 13:48:03',3310503424,1),(51951892,426296652,14971094,434787,1,'2007-09-15 13:48:03',3310503424,1),(51951895,426295494,14970667,434787,1,'2007-09-15 13:48:03',3310503424,1),(51951898,426294275,14970545,434787,1,'2007-09-15 13:48:03',3310503424,1),(51951900,426293178,14970484,434787,1,'2007-09-15 13:48:03',3310503424,1),(51951903,426291410,14970972,434787,1,'2007-09-15 13:48:04',3310503424,1),(51951905,426289764,14971581,434787,1,'2007-09-15 13:48:04',3310503424,1),(51951908,426286411,14974203,434787,1,'2007-09-15 13:48:04',3310503424,1),(51951911,426284033,14975361,434787,1,'2007-09-15 13:48:04',3310503424,1),(51951914,426282448,14976580,434787,1,'2007-09-15 13:48:04',3310503424,1),(51951917,426282448,14978531,434787,1,'2007-09-15 13:48:04',3310503424,1),(51951920,426282936,14979506,434787,1,'2007-09-15 13:48:04',3310503424,1),(51951922,426284033,14979811,434787,1,'2007-09-15 13:48:05',3310503424,1),(51951924,426284826,14979263,434787,1,'2007-09-15 13:48:05',3310503424,1),(51951927,426286167,14977678,434787,1,'2007-09-15 13:48:05',3310503424,1),(51951930,426287569,14977190,434787,1,'2007-09-15 13:48:05',3310503424,1),(51951933,426291288,14977495,434787,1,'2007-09-15 13:48:05',3310503424,1),(51951935,426294458,14977190,434787,1,'2007-09-15 13:48:05',3310503424,1),(51951937,426298725,14976580,434787,1,'2007-09-15 13:48:05',3310503424,1),(51951938,426300737,14976215,434787,1,'2007-09-15 13:48:05',3310503424,1),(51951941,426301712,14976215,434787,1,'2007-09-15 13:48:06',3310503424,1),(51951944,426302383,14976824,434787,1,'2007-09-15 13:48:06',3310503424,1),(51951947,426302627,14978165,434787,1,'2007-09-15 13:48:06',3310503424,1),(51951950,426302383,14979263,434787,1,'2007-09-15 13:48:06',3310503424,1),(51951953,426301164,14980055,434787,1,'2007-09-15 13:48:06',3310503424,1),(51951956,426298237,14982067,434787,1,'2007-09-15 13:48:06',3310503424,1),(51951957,426294336,14985237,434787,1,'2007-09-15 13:48:07',3310503424,1),(51951960,426292080,14987614,434787,1,'2007-09-15 13:48:07',3310503424,1),(51951963,426291044,14989321,434787,1,'2007-09-15 13:48:07',3310503424,1),(51951965,426291227,14990419,434787,1,'2007-09-15 13:48:07',3310503424,1),(51951966,426292080,14990845,434787,1,'2007-09-15 13:48:07',3310503424,1),(51951969,426292995,14990845,434787,1,'2007-09-15 13:48:07',3310503424,1),(51951970,426297567,14988590,434787,1,'2007-09-15 13:48:07',3310503424,1),(51951973,426301468,14986212,434787,1,'2007-09-15 13:48:07',3310503424,1),(51951975,426304456,14983957,434787,1,'2007-09-15 13:48:08',3310503425,1),(51951978,426306406,14982494,434787,1,'2007-09-15 13:48:08',3310503425,1),(51951980,426307066,14981746,434787,1,'2007-09-15 13:48:08',3310503425,1),(51951983,426307952,14981999,434787,1,'2007-09-15 13:48:08',3310503425,1),(51951985,426308459,14983076,434787,1,'2007-09-15 13:48:08',3310503425,1),(51951988,426307952,14984406,434787,1,'2007-09-15 13:48:09',3310503425,1),(51951989,426306432,14985989,434787,1,'2007-09-15 13:48:09',3310503425,1),(51951992,426303773,14989662,434787,1,'2007-09-15 13:48:09',3310503425,1),(51951995,426301936,14992575,434787,1,'2007-09-15 13:48:09',3310503424,1),(51951999,426300606,14994222,434787,1,'2007-09-15 13:48:09',3310503424,1),(51952002,426299213,14994412,434787,1,'2007-09-15 13:48:09',3310503424,1),(51952005,426297820,14994348,434787,1,'2007-09-15 13:48:10',3310503424,1),(51952009,426297060,14994855,434787,1,'2007-09-15 13:48:10',3310503424,1),(51952013,426296933,14995805,434787,1,'2007-09-15 13:48:10',3310503424,1),(51952014,426296933,14996881,434787,1,'2007-09-15 13:48:10',3310503426,1),(51952017,426297440,14998021,434787,1,'2007-09-15 13:48:11',3310503426,1),(51952019,426298390,14998021,434787,1,'2007-09-15 13:48:11',3310503426,1),(51952022,426299656,14998021,434787,1,'2007-09-15 13:48:11',3310503426,1),(51952025,426300859,14997325,434787,1,'2007-09-15 13:48:11',3310503426,1),(51952028,426302189,14996438,434787,1,'2007-09-15 13:48:11',3310503424,1),(51952029,426304976,14993652,434787,1,'2007-09-15 13:48:12',3310503425,1),(51952031,426306749,14992068,434787,1,'2007-09-15 13:48:12',3310503425,1),(51952034,426308142,14992005,434787,1,'2007-09-15 13:48:12',3310503425,1),(51952037,426310422,14992005,434787,1,'2007-09-15 13:48:12',3310503425,1),(51952039,426314665,14992448,434787,1,'2007-09-15 13:48:12',3310503425,1),(51952042,426317388,14992702,434787,1,'2007-09-15 13:48:12',3310503425,1),(51952045,426318781,14993525,434787,1,'2007-09-15 13:48:13',3310503425,1),(51952046,426321061,14996058,434787,1,'2007-09-15 13:48:13',3310503425,1),(51952048,426323784,14998021,434787,1,'2007-09-15 13:48:13',3310503427,1),(51952050,426326381,14999414,434787,1,'2007-09-15 13:48:13',3310503427,1),(51952053,426327584,14999984,434787,1,'2007-09-15 13:48:14',3310503427,1),(51952055,426327710,15000998,434787,1,'2007-09-15 13:48:14',3310503427,1),(51952058,426327520,15001884,434787,1,'2007-09-15 13:48:14',3310503427,1),(51952060,426326824,15002264,434787,1,'2007-09-15 13:48:14',3310503427,1),(51952063,426325747,15002201,434787,1,'2007-09-15 13:48:14',3310503427,1),(51952065,426324354,15001504,434787,1,'2007-09-15 13:48:14',3310503427,1),(51952068,426322644,15000491,434787,1,'2007-09-15 13:48:15',3310503427,1),(51952069,426320998,14999668,434787,1,'2007-09-15 13:48:15',3310503427,1),(51952073,426319288,14999794,434787,1,'2007-09-15 13:48:15',3310503427,1),(51952075,426317578,15001251,434787,1,'2007-09-15 13:48:15',3310503427,1),(51952078,426316501,15003214,434787,1,'2007-09-15 13:48:15',3310503427,1),(51952080,426316438,15005431,434787,1,'2007-09-15 13:48:15',3310503427,1),(51952083,426316248,15007710,434787,1,'2007-09-15 13:48:16',3310503427,1),(51952084,426315551,15009737,434787,1,'2007-09-15 13:48:16',3310503427,1),(51952087,426314348,15010623,434787,1,'2007-09-15 13:48:16',3310503427,1),(51952090,426312765,15011320,434787,1,'2007-09-15 13:48:16',3310503427,1),(51952093,426311499,15011510,434787,1,'2007-09-15 13:48:17',3310503427,1),(51952096,426310485,15012713,434787,1,'2007-09-15 13:48:17',3310503427,1),(51952099,426309979,15014170,434787,1,'2007-09-15 13:48:17',3310503427,1),(51952101,426310295,15017273,434787,1,'2007-09-15 13:48:17',3310503427,1),(51952103,426311688,15023289,434787,1,'2007-09-15 13:48:18',3310503427,1),(51952105,426315108,15035448,434787,1,'2007-09-15 13:48:18',3310503427,1),(51952107,426319035,15047670,434787,1,'2007-09-15 13:48:18',3310503427,1),(51952110,426320382,15052106,434787,1,'2007-09-15 13:48:18',3310503433,1),(51952111,426321322,15056879,434787,1,'2007-09-15 13:48:18',3310503433,1),(51952113,426321595,15061937,434787,1,'2007-09-15 13:48:18',3310503433,1),(51952115,426321284,15068162,434787,1,'2007-09-15 13:48:18',3310503433,1),(51952118,426320894,15070886,434787,1,'2007-09-15 13:48:19',3310503433,1),(51952120,426320468,15072599,434787,1,'2007-09-15 13:48:19',3310503433,1),(51952122,426320023,15073775,434787,1,'2007-09-15 13:48:19',3310503433,1),(51952125,426319453,15074759,434787,1,'2007-09-15 13:48:19',3310503433,1),(51952126,426318327,15075959,434787,1,'2007-09-15 13:48:19',3310503433,1),(51952128,426317200,15077122,434787,1,'2007-09-15 13:48:19',3310503433,1),(51952132,426316097,15078850,434787,1,'2007-09-15 13:48:19',3310503433,1),(51952136,426315620,15080251,434787,1,'2007-09-15 13:48:19',3310503433,1),(51952139,426314548,15083946,434787,1,'2007-09-15 13:48:20',3310503433,1),(51952141,426313833,15087402,434787,1,'2007-09-15 13:48:20',3310503433,1),(51952145,426313415,15089578,434787,1,'2007-09-15 13:48:20',3310503433,1),(51952148,426313535,15091127,434787,1,'2007-09-15 13:48:20',3310503433,1),(51952150,426313773,15092647,434787,1,'2007-09-15 13:48:20',3310503433,1),(51952152,426313684,15094137,434787,1,'2007-09-15 13:48:20',3310503433,1),(51952155,426313445,15095001,434787,1,'2007-09-15 13:48:21',3310503433,1),(51952157,426313088,15096879,434787,1,'2007-09-15 13:48:21',3310503433,1),(51952159,426313117,15097951,434787,1,'2007-09-15 13:48:21',3310503433,1),(51952161,426313356,15098547,434787,1,'2007-09-15 13:48:21',3310503433,1),(51952163,426313803,15099143,434787,1,'2007-09-15 13:48:21',3310503433,1),(51952167,426314429,15099441,434787,1,'2007-09-15 13:48:21',3310503433,1),(51952170,426315054,15099352,434787,1,'2007-09-15 13:48:21',3310503433,1),(51952172,426315620,15098935,434787,1,'2007-09-15 13:48:22',3310503433,1),(51952176,426316216,15098130,434787,1,'2007-09-15 13:48:22',3310503433,1),(51952177,426316514,15097147,434787,1,'2007-09-15 13:48:22',3310503433,1),(51952180,426316604,15096342,434787,1,'2007-09-15 13:48:22',3310503433,1),(51952183,426316485,15095329,434787,1,'2007-09-15 13:48:22',3310503433,1),(51952185,426316276,15094197,434787,1,'2007-09-15 13:48:23',3310503433,1),(51952187,426316127,15092737,434787,1,'2007-09-15 13:48:23',3310503433,1),(51952190,426316097,15091425,434787,1,'2007-09-15 13:48:23',3310503433,1),(51952192,426316365,15089965,434787,1,'2007-09-15 13:48:23',3310503433,1),(51952193,426317468,15086747,434787,1,'2007-09-15 13:48:23',3310503433,1),(51952195,426318392,15084542,434787,1,'2007-09-15 13:48:23',3310503433,1),(51952196,426319375,15083231,434787,1,'2007-09-15 13:48:23',3310503433,1),(51952199,426320508,15081979,434787,1,'2007-09-15 13:48:23',3310503433,1),(51952201,426321253,15080578,434787,1,'2007-09-15 13:48:24',3310503433,1),(51952204,426321878,15079655,434787,1,'2007-09-15 13:48:24',3310503433,1),(51952205,426322504,15079178,434787,1,'2007-09-15 13:48:24',3310503433,1),(51952207,426323309,15079327,434787,1,'2007-09-15 13:48:24',3310503433,1),(51952210,426323964,15080161,434787,1,'2007-09-15 13:48:24',3310503433,1),(51952213,426324143,15081025,434787,1,'2007-09-15 13:48:24',3310503433,1),(51952215,426323786,15082158,434787,1,'2007-09-15 13:48:24',3310503433,1),(51952217,426323130,15082933,434787,1,'2007-09-15 13:48:24',3310503433,1),(51952220,426322415,15083350,434787,1,'2007-09-15 13:48:24',3310503433,1),(51952223,426321372,15084274,434787,1,'2007-09-15 13:48:24',3310503433,1),(51952226,426320835,15085138,434787,1,'2007-09-15 13:48:25',3310503433,1),(51952230,426320180,15087164,434787,1,'2007-09-15 13:48:25',3310503433,1),(51952233,426319763,15089488,434787,1,'2007-09-15 13:48:25',3310503433,1),(51952236,426319763,15093213,434787,1,'2007-09-15 13:48:25',3310503433,1),(51952238,426319733,15096372,434787,1,'2007-09-15 13:48:25',3310503433,1),(51952240,426319554,15097415,434787,1,'2007-09-15 13:48:25',3310503433,1),(51952243,426319345,15098488,434787,1,'2007-09-15 13:48:25',3310503433,1),(51952246,426318839,15099650,434787,1,'2007-09-15 13:48:26',3310503433,1),(51952248,426318451,15100365,434787,1,'2007-09-15 13:48:26',3310503433,1),(51952250,426317913,15102097,434787,1,'2007-09-15 13:48:26',3310503433,1),(51952252,426317655,15103488,434787,1,'2007-09-15 13:48:26',3310503433,1),(51952255,426317758,15104930,434787,1,'2007-09-15 13:48:26',3310503433,1),(51952256,426318119,15106629,434787,1,'2007-09-15 13:48:26',3310503435,1),(51952259,426318953,15109101,434787,1,'2007-09-15 13:48:26',3310503435,1),(51952261,426319777,15111243,206510,1,'2008-12-06 19:38:24',3310503435,4),(51952264,426320395,15113096,206510,1,'2008-12-06 19:38:24',3310503435,4),(51952267,426320395,15114662,206510,1,'2008-12-06 19:38:24',3310503435,4),(51952269,426320106,15115857,206510,1,'2008-12-06 19:38:24',3310503435,4),(51952271,426319340,15117298,206510,1,'2008-12-06 19:38:23',3310503435,4),(51952274,426318220,15119638,206510,1,'2008-12-06 19:38:23',3310503435,4),(51952276,426317629,15121487,206510,1,'2008-12-06 19:38:23',3310503435,4),(51952279,426317283,15122903,206510,1,'2008-12-06 19:38:23',3310503435,4),(51952280,426317126,15124193,206510,1,'2008-12-06 19:38:23',3310503435,4),(51952284,426316811,15126760,206510,1,'2008-12-06 19:38:23',3310503435,4),(51952287,426317000,15128422,206510,1,'2008-12-06 19:38:23',3310503435,4),(51952290,426317604,15129554,206510,1,'2008-12-06 19:38:23',3310503435,4),(51952292,426318850,15130423,206510,1,'2008-12-06 19:38:23',3310503435,4),(51952295,426319832,15131442,206510,1,'2008-12-06 19:38:23',3310503435,4),(51952297,426320814,15133254,206510,1,'2008-12-06 19:38:23',3310503435,4),(51952300,426321191,15135067,206510,1,'2008-12-06 19:38:23',3310503435,4),(51952303,426321304,15137068,206510,1,'2008-12-06 19:38:23',3310503435,4),(51952305,426321113,15138218,206510,1,'2008-12-06 19:38:23',3310503435,4),(51952306,426320411,15140322,206510,1,'2008-12-06 19:38:23',3310503435,4),(51952307,426319643,15142293,206510,1,'2008-12-06 19:38:23',3310503435,4),(51952311,426318741,15145634,206510,1,'2008-12-06 19:38:23',3310503435,4),(51952316,426317806,15149442,206510,1,'2008-12-06 19:38:22',3310503435,4),(51952320,426317438,15151680,206510,1,'2008-12-06 19:38:22',3310503435,4),(51952323,426315915,15158197,206510,1,'2008-12-06 19:38:22',3310503435,4),(51952325,426315248,15161445,206510,1,'2008-12-06 19:38:22',3310503457,4),(51952328,426314332,15163485,206510,1,'2008-12-06 19:38:22',3310503457,4),(51952330,426313166,15166567,206510,1,'2008-12-06 19:38:22',3310503457,4),(51952333,426312417,15169731,206510,1,'2008-12-06 19:38:22',3310503457,4),(51952335,426311841,15173744,206510,1,'2008-12-06 19:38:22',3310503457,4),(51952338,426311290,15176408,206510,1,'2008-12-06 19:38:22',3310503457,4),(51952341,426310922,15179025,206510,1,'2008-12-06 19:38:21',3310503457,4),(51952343,426310417,15182699,206510,1,'2008-12-06 19:38:21',3310503457,4),(51952345,426308993,15188899,206510,1,'2008-12-06 19:38:21',3310503457,4),(51952347,426307715,15193479,206510,1,'2008-12-06 19:38:21',3310503457,4),(51952350,426306561,15197161,206510,1,'2008-12-06 19:38:21',3310503457,4),(51952351,426305242,15200514,206510,1,'2008-12-06 19:38:21',3310503457,4),(51952354,426304198,15205075,206510,1,'2008-12-06 19:38:21',3310503457,4),(51952359,426303813,15207438,206510,1,'2008-12-06 19:38:21',3310503457,4),(51952362,426303264,15210241,206510,1,'2008-12-06 19:38:20',3310503456,4),(51952365,426302219,15212165,206510,1,'2008-12-06 19:38:20',3310503456,4),(51952367,426301450,15213374,206510,1,'2008-12-06 19:38:20',3310503456,4),(51952369,426300296,15215297,206510,1,'2008-12-06 19:38:20',3310503456,4),(51952373,426298922,15218155,206510,1,'2008-12-06 19:38:20',3310503458,4),(51952376,426297493,15221475,206510,1,'2008-12-06 19:38:20',3310503458,4),(51952378,426296570,15224200,206510,1,'2008-12-06 19:38:20',3310503458,4),(51952382,426295602,15226443,206510,1,'2008-12-06 19:38:20',3310503458,4),(51952385,426294899,15228157,206510,1,'2008-12-06 19:38:20',3310503458,4),(51952388,426293844,15229564,206510,1,'2008-12-06 19:38:20',3310503458,4),(51952390,426292877,15230312,206510,1,'2008-12-06 19:38:19',3310503458,4),(51952394,426290546,15232598,206510,1,'2008-12-06 19:38:19',3310503458,4),(51952396,426289051,15233961,206510,1,'2008-12-06 19:38:19',3310503458,4),(51952399,426287688,15234840,206510,1,'2008-12-06 19:38:19',3310503458,4),(51952403,426286809,15235368,206510,1,'2008-12-06 19:38:19',3310503458,4),(51952405,426284303,15236379,206510,1,'2008-12-06 19:38:19',3310503458,4),(51952408,426282940,15236555,206510,1,'2008-12-06 19:38:19',3310503458,4),(51952411,426280522,15236643,206510,1,'2008-12-06 19:38:19',3310503458,4),(51952413,426278192,15236775,206510,1,'2008-12-06 19:38:19',3310503458,4),(51952416,426276786,15237483,206510,1,'2008-12-06 19:38:19',3310503458,4),(51952418,426275755,15238583,206510,1,'2008-12-06 19:38:19',3310502775,4),(51952420,426274994,15239418,206510,1,'2008-12-06 19:38:19',3310502775,4),(51952423,426273239,15240830,206510,1,'2008-12-06 19:38:18',3310502775,4),(51952426,426270378,15241749,206510,1,'2008-12-06 19:38:18',3310502775,4),(51952429,426269857,15242589,206510,1,'2008-12-06 19:38:18',3310502775,4),(51952430,426269486,15244293,206510,1,'2008-12-06 19:38:18',3310502775,4),(51952433,426271331,15241100,206510,1,'2008-12-06 19:38:18',3310502775,4),(51952436,426274047,15240347,206510,1,'2008-12-06 19:38:19',3310502775,4),(51952439,426276260,15238044,206510,1,'2008-12-06 19:38:19',3310503458,4),(51952441,426268912,15245824,206510,1,'2008-12-06 19:38:18',3310502775,4),(51952444,426268254,15246937,206510,1,'2008-12-06 19:38:18',3310502775,4),(51952446,426267318,15248101,206510,1,'2008-12-06 19:38:18',3310502775,4),(51952449,426266280,15249543,206510,1,'2008-12-06 19:38:18',3310502775,4),(51952452,426265774,15251795,206510,1,'2008-12-06 19:38:17',3310502775,4),(51952455,426265470,15253491,206510,1,'2008-12-06 19:38:17',3310502775,4),(51952457,426264737,15257590,206510,1,'2008-12-06 19:38:17',3310502775,4),(51952460,426263952,15260146,206510,1,'2008-12-06 19:38:17',3310502775,4),(51952463,426263674,15261537,206510,1,'2008-12-06 19:38:17',3310502775,4),(51952465,426263396,15264245,206510,1,'2008-12-06 19:38:17',3310502775,4),(51952468,426263214,15265846,206510,1,'2008-12-06 19:38:17',3310502775,4),(51952472,426262923,15267777,206510,1,'2008-12-06 19:38:16',3310502775,4),(51952475,426262340,15268943,206510,1,'2008-12-06 19:38:16',3310502775,4),(51952478,426261429,15270437,206510,1,'2008-12-06 19:38:16',3310502775,4),(51952481,426260372,15271494,206510,1,'2008-12-06 19:38:16',3310502781,4),(51952484,426258405,15272441,206510,1,'2008-12-06 19:38:16',3310502781,4),(51952487,426256838,15273206,206510,1,'2008-12-06 19:38:16',3310502781,4),(51952490,426255708,15274044,206510,1,'2008-12-06 19:38:16',3310502781,4),(51952492,426254433,15275174,206510,1,'2008-12-06 19:38:16',3310502781,4),(51952495,426252538,15278636,206510,1,'2008-12-06 19:38:16',3310502781,4),(51952498,426248034,15284558,206510,1,'2008-12-06 19:38:15',3310502780,4),(51952500,426247147,15285928,206510,1,'2008-12-06 19:38:15',3310502780,4),(51952502,426246543,15287298,206510,1,'2008-12-06 19:38:15',3310502780,4),(51952504,426245938,15290965,206510,1,'2008-12-06 19:38:15',3310502780,4),(51952506,426245737,15295841,206510,1,'2008-12-06 19:38:15',3310502780,4),(51952508,426245737,15297856,206510,1,'2008-12-06 19:38:15',3310502780,4),(51952510,426245547,15301341,206510,1,'2008-12-06 19:38:15',3310502780,4),(51952512,426245162,15303579,206510,1,'2008-12-06 19:38:15',3310502780,4),(51952513,426244274,15306356,206510,1,'2008-12-06 19:38:15',3310502780,4),(51952515,426242808,15310099,206510,1,'2008-12-06 19:38:15',3310502780,4),(51952517,426240416,15316696,206510,1,'2008-12-06 19:38:15',3310502780,4),(51952520,426238410,15323640,206510,1,'2008-12-06 19:38:15',3310502780,4),(51952523,426236751,15327960,206510,1,'2008-12-06 19:38:15',3310502782,4),(51952524,426233935,15333863,206510,1,'2008-12-06 19:38:15',3310502782,4),(51952525,426231158,15339650,206510,1,'2008-12-06 19:38:15',3310502782,4),(51952527,426228573,15344356,206510,1,'2008-12-06 19:38:15',3310502782,4),(51952530,426225872,15350915,434787,1,'2007-09-15 13:48:43',3310502782,1),(51952532,426222284,15360907,434787,1,'2007-09-15 13:48:43',3310502782,1),(51952534,426221089,15363607,434787,1,'2007-09-15 13:48:43',3310502779,1),(51952536,426219584,15366462,434787,1,'2007-09-15 13:48:43',3310502779,1),(51952539,426218423,15369541,434787,1,'2007-09-15 13:48:43',3310502779,1),(51952542,426216338,15375927,434787,1,'2007-09-15 13:48:43',3310502779,1),(51952545,426214802,15381518,434787,1,'2007-09-15 13:48:44',3310502865,1),(51952546,426213450,15386125,434787,1,'2007-09-15 13:48:44',3310502865,1),(51952549,426213512,15388030,434787,1,'2007-09-15 13:48:44',3310502865,1),(51952552,426214863,15392515,434787,1,'2007-09-15 13:48:44',3310502865,1),(51952556,426216461,15396385,434787,1,'2007-09-15 13:48:44',3310502865,1),(51952559,426217321,15400686,434787,1,'2007-09-15 13:48:45',3310502865,1),(51952562,426219594,15404618,434787,1,'2007-09-15 13:48:45',3310502865,1),(51952566,426220786,15407370,434787,1,'2007-09-15 13:48:45',3310502865,1),(51952570,426223245,15411389,434787,1,'2007-09-15 13:48:45',3310502868,1),(51952573,426225645,15414989,434787,1,'2007-09-15 13:48:45',3310502868,1),(51952575,426227385,15419608,434787,1,'2007-09-15 13:48:46',3310502868,1),(51952578,426228645,15424648,434787,1,'2007-09-15 13:48:46',3310502868,1),(51952580,426232065,15431547,434787,1,'2007-09-15 13:48:46',3310502868,1),(51952583,426235124,15438026,434787,1,'2007-09-15 13:48:46',3310502870,1),(51952584,426236467,15441568,434787,1,'2007-09-15 13:48:46',3310502870,1),(51952586,426237902,15443817,434787,1,'2007-09-15 13:48:46',3310502870,1),(51952590,426239957,15445601,434787,1,'2007-09-15 13:48:47',3310502870,1),(51952594,426241818,15448005,434787,1,'2007-09-15 13:48:47',3310502870,1),(51952597,426245231,15453124,434787,1,'2007-09-15 13:48:47',3310502870,1),(51952599,426248333,15458204,434787,1,'2007-09-15 13:48:47',3310502870,1),(51952601,426251965,15463806,434787,1,'2007-09-15 13:48:47',3310502871,1),(51952604,426254231,15468023,434787,1,'2007-09-15 13:48:47',3310502871,1),(51952605,426255993,15473939,434787,1,'2007-09-15 13:48:47',3310502871,1),(51952608,426257126,15482059,434787,1,'2007-09-15 13:48:48',3310502871,1),(51952610,426258007,15495402,434787,1,'2007-09-15 13:48:48',3310502877,1),(51952613,426258766,15499341,434787,1,'2007-09-15 13:48:48',3310502877,1),(51952615,426259769,15502392,434787,1,'2007-09-15 13:48:48',3310502877,1),(51952618,426260815,15506402,434787,1,'2007-09-15 13:48:48',3310502877,1),(51952620,426261861,15511894,434787,1,'2007-09-15 13:48:49',3310502877,1),(51952623,426262341,15515076,434787,1,'2007-09-15 13:48:49',3310502877,1),(51952627,426262079,15516428,434787,1,'2007-09-15 13:48:49',3310502877,1),(51952630,426261643,15517256,434787,1,'2007-09-15 13:48:49',3310502877,1),(51952632,426259900,15519130,434787,1,'2007-09-15 13:48:49',3310502877,1),(51952634,426259028,15519522,434787,1,'2007-09-15 13:48:50',3310502877,1),(51952635,426257415,15519653,434787,1,'2007-09-15 13:48:50',3310502877,1),(51952638,426254582,15519392,434787,1,'2007-09-15 13:48:50',3310502877,1),(51952640,426251313,15518912,434787,1,'2007-09-15 13:48:50',3310502877,1),(51952643,426249046,15518302,434787,1,'2007-09-15 13:48:50',3310502877,1),(51952647,426247303,15517604,434787,1,'2007-09-15 13:48:51',3310502876,1),(51952649,426244949,15517561,434787,1,'2007-09-15 13:48:51',3310502876,1),(51952652,426241331,15517910,434787,1,'2007-09-15 13:48:51',3310502876,1),(51952653,426238759,15518084,434787,1,'2007-09-15 13:48:51',3310502876,1),(51952656,426237059,15517866,434787,1,'2007-09-15 13:48:52',3310502876,1),(51952659,426234749,15517735,434787,1,'2007-09-15 13:48:52',3310502876,1),(51952662,426232438,15517110,434787,1,'2007-09-15 13:48:52',3310502876,1),(51952665,426231265,15516684,434787,1,'2007-09-15 13:48:52',3310502876,1),(51952667,426229826,15516791,434787,1,'2007-09-15 13:48:52',3310502876,1),(51952668,426228280,15517697,434787,1,'2007-09-15 13:48:52',3310502876,1),(51952671,426225401,15520469,434787,1,'2007-09-15 13:48:53',3310502876,1),(51952672,426221829,15523561,434787,1,'2007-09-15 13:48:53',3310502876,1),(51952675,426221259,15524255,434787,1,'2007-09-15 13:48:53',3310502876,1),(51952677,426221189,15525227,434787,1,'2007-09-15 13:48:53',3310502876,1),(51952682,426221583,15525690,434787,1,'2007-09-15 13:48:53',3310502876,1),(51952684,426222162,15525883,434787,1,'2007-09-15 13:48:54',3310502876,1),(51952686,426223002,15525267,434787,1,'2007-09-15 13:48:54',3310502876,1),(51952689,426224122,15524627,434787,1,'2007-09-15 13:48:54',3310502876,1),(51952690,426225987,15522868,434787,1,'2007-09-15 13:48:55',3310502876,1),(51952692,426227188,15522081,434787,1,'2007-09-15 13:48:55',3310502876,1),(51952694,426227974,15521393,434787,1,'2007-09-15 13:48:55',3310502876,1),(51952695,426229137,15520623,434787,1,'2007-09-15 13:48:55',3310502876,1),(51952699,426229923,15520640,434787,1,'2007-09-15 13:48:55',3310502876,1),(51952701,426230463,15520885,434787,1,'2007-09-15 13:48:55',3310502876,1),(51952702,426230693,15521459,434787,1,'2007-09-15 13:48:55',3310502876,1),(51952705,426230611,15521835,434787,1,'2007-09-15 13:48:55',3310502876,1),(51952706,426230316,15522245,434787,1,'2007-09-15 13:48:55',3310502876,1),(51952709,426229726,15522556,434787,1,'2007-09-15 13:48:56',3310502876,1),(51952712,426228989,15522752,434787,1,'2007-09-15 13:48:56',3310502876,1),(51952714,426226942,15524472,434787,1,'2007-09-15 13:48:56',3310502876,1),(51952715,426225779,15526077,434787,1,'2007-09-15 13:48:56',3310502876,1),(51952717,426223542,15528266,434787,1,'2007-09-15 13:48:57',3310502876,1),(51952719,426221830,15530222,434787,1,'2007-09-15 13:48:57',3310502876,1),(51952722,426221138,15531567,434787,1,'2007-09-15 13:48:57',3310502876,1),(51952724,426220485,15533441,434787,1,'2007-09-15 13:48:57',3310502873,1),(51952727,426219630,15536579,434787,1,'2007-09-15 13:48:57',3310502873,1),(51952729,426218570,15539147,434787,1,'2007-09-15 13:48:57',3310502873,1),(51952732,426217551,15540410,434787,1,'2007-09-15 13:48:57',3310502873,1),(51952733,426215595,15542937,434787,1,'2007-09-15 13:48:58',3310502873,1),(51952737,426214699,15544485,434787,1,'2007-09-15 13:48:58',3310502873,1),(51952740,426213517,15547053,434787,1,'2007-09-15 13:48:58',3310502875,1),(51952742,426213272,15547908,434787,1,'2007-09-15 13:48:58',3310502875,1),(51952745,426213354,15548683,434787,1,'2007-09-15 13:48:58',3310502875,1),(51952748,426213680,15549375,434787,1,'2007-09-15 13:48:58',3310502875,1),(51952751,426214291,15549579,434787,1,'2007-09-15 13:48:58',3310502875,1),(51952754,426215106,15549538,434787,1,'2007-09-15 13:48:58',3310502875,1),(51952756,426215554,15548846,434787,1,'2007-09-15 13:48:59',3310502875,1),(51952758,426216044,15547582,434787,1,'2007-09-15 13:48:59',3310502875,1),(51952761,426217592,15545789,434787,1,'2007-09-15 13:48:59',3310502873,1),(51952764,426218855,15544811,434787,1,'2007-09-15 13:48:59',3310502873,1),(51952767,426220241,15543344,434787,1,'2007-09-15 13:48:59',3310502873,1),(51952770,426221464,15541959,434787,1,'2007-09-15 13:49:00',3310502876,1),(51952772,426222645,15539758,434787,1,'2007-09-15 13:49:00',3310502876,1),(51952775,426223460,15536865,434787,1,'2007-09-15 13:49:00',3310502876,1),(51952777,426223949,15534786,434787,1,'2007-09-15 13:49:00',3310502876,1),(51952780,426225009,15533401,434787,1,'2007-09-15 13:49:00',3310502876,1),(51952782,426226395,15532137,434787,1,'2007-09-15 13:49:00',3310502876,1),(51952784,426227495,15531241,434787,1,'2007-09-15 13:49:00',3310502876,1),(51952786,426228391,15531322,434787,1,'2007-09-15 13:49:00',3310502876,1),(51952788,426229125,15532137,434787,1,'2007-09-15 13:49:01',3310502876,1),(51952790,426229451,15533971,434787,1,'2007-09-15 13:49:01',3310502876,1),(51952792,426229247,15534786,434787,1,'2007-09-15 13:49:01',3310502876,1),(51952795,426228269,15536335,434787,1,'2007-09-15 13:49:01',3310502876,1),(51952797,426226802,15538291,434787,1,'2007-09-15 13:49:01',3310502876,1),(51952800,426225743,15541103,434787,1,'2007-09-15 13:49:01',3310502876,1),(51952802,426224968,15544485,434787,1,'2007-09-15 13:49:01',3310502876,1),(51952804,426224072,15547338,434787,1,'2007-09-15 13:49:01',3310502878,1),(51952807,426222808,15548927,434787,1,'2007-09-15 13:49:01',3310502878,1),(51952811,426221545,15551332,434787,1,'2007-09-15 13:49:02',3310502878,1),(51952813,426220445,15553410,434787,1,'2007-09-15 13:49:02',3310502875,1),(51952815,426219100,15555488,434787,1,'2007-09-15 13:49:02',3310502875,1),(51952818,426217674,15557526,434787,1,'2007-09-15 13:49:02',3310502875,1),(51952820,426216533,15560134,434787,1,'2007-09-15 13:49:02',3310502875,1),(51952824,426216084,15562335,434787,1,'2007-09-15 13:49:02',3310502875,1),(51952827,426216125,15565717,434787,1,'2007-09-15 13:49:02',3310502875,1),(51952829,426215658,15568442,434787,1,'2007-09-15 13:49:03',3310502875,1),(51952831,426215107,15571455,434787,1,'2007-09-15 13:49:03',3310502875,1),(51952832,426214850,15573917,434787,1,'2007-09-15 13:49:03',3310502875,1),(51952834,426214556,15576563,434787,1,'2007-09-15 13:49:03',3310502875,1),(51952837,426213968,15579282,434787,1,'2007-09-15 13:49:03',3310502875,1),(51952840,426213012,15581524,434787,1,'2007-09-15 13:49:04',3310502875,1),(51952842,426212865,15583729,434787,1,'2007-09-15 13:49:04',3310502875,1),(51952844,426213123,15584243,864892,1,'2009-03-28 14:44:22',3310502875,2),(51952849,426225483,15349535,206510,1,'2008-12-06 19:38:14',3310502782,4),(51956993,426313401,14846734,434787,1,'2007-09-15 13:55:14',3310503081,1),(51956997,426312311,14842100,434787,1,'2007-09-15 13:55:15',3310503081,1),(51956999,426311857,14838465,434787,1,'2007-09-15 13:55:15',3310503081,1),(51957002,426312584,14834286,434787,1,'2007-09-15 13:55:15',3310503081,1),(51957005,426314128,14829924,434787,1,'2007-09-15 13:55:15',3310503075,1),(51957008,426315673,14826108,434787,1,'2007-09-15 13:55:15',3310503075,1),(51957009,426316582,14822201,434787,1,'2007-09-15 13:55:15',3310503075,1),(51957013,426316582,14818657,434787,1,'2007-09-15 13:55:16',3310503075,1),(51957016,426315673,14813933,434787,1,'2007-09-15 13:55:16',3310503075,1),(51957018,426313947,14811207,864892,1,'2009-03-28 14:33:30',3310503075,3),(51957020,426312402,14805846,434787,1,'2007-09-15 13:55:16',3310503075,1),(51957022,426312311,14801212,434787,1,'2007-09-15 13:55:16',3310503075,1),(51957024,426312311,14793125,434787,1,'2007-09-15 13:55:16',3310503075,1),(51957025,426311938,14787679,434787,1,'2007-09-15 13:55:16',3310503075,1),(51957027,426311742,14784336,434787,1,'2007-09-15 13:55:16',3310503075,1),(51957030,426311545,14782173,434787,1,'2007-09-15 13:55:17',3310503075,1),(51957031,426310562,14780010,434787,1,'2007-09-15 13:55:17',3310503075,1),(51957034,426309284,14778535,434787,1,'2007-09-15 13:55:17',3310503075,1),(51957037,426306924,14778339,434787,1,'2007-09-15 13:55:17',3310503075,1),(51957040,426304171,14778830,434787,1,'2007-09-15 13:55:17',3310503075,1),(51957042,426302598,14779322,434787,1,'2007-09-15 13:55:17',3310503074,1),(51957045,426301123,14780895,434787,1,'2007-09-15 13:55:18',3310503074,1),(51957048,426299648,14784730,434787,1,'2007-09-15 13:55:18',3310503074,1),(51957050,426296895,14790236,434787,1,'2007-09-15 13:55:18',3310503074,1),(51957052,426295322,14792300,434787,1,'2007-09-15 13:55:18',3310503074,1),(51957055,426292667,14795053,434787,1,'2007-09-15 13:55:18',3310503074,1),(51957057,426290504,14797315,434787,1,'2007-09-15 13:55:18',3310503074,1),(51957060,426288931,14799576,434787,1,'2007-09-15 13:55:18',3310503074,1),(51957063,426287358,14802329,434787,1,'2007-09-15 13:55:18',3310503074,1),(51957064,426286965,14806360,434787,1,'2007-09-15 13:55:19',3310503074,1),(51957066,426287063,14808916,434787,1,'2007-09-15 13:55:19',3310503074,1),(51957069,426286571,14810391,434787,1,'2007-09-15 13:55:19',3310503074,1),(51957072,426285392,14810391,434787,1,'2007-09-15 13:55:19',3310503074,1),(51957075,426284197,14805596,434787,1,'2007-09-15 13:55:19',3310503074,1),(51957077,426283754,14802825,434787,1,'2007-09-15 13:55:19',3310503074,1),(51957080,426282978,14799944,434787,1,'2007-09-15 13:55:19',3310503074,1),(51957082,426282535,14797506,434787,1,'2007-09-15 13:55:20',3310503074,1),(51957085,426281316,14795733,434787,1,'2007-09-15 13:55:20',3310503074,1),(51957087,426279986,14794292,434787,1,'2007-09-15 13:55:20',3310503074,1),(51957090,426278434,14792408,434787,1,'2007-09-15 13:55:20',3310503074,1),(51957092,426277437,14789970,434787,1,'2007-09-15 13:55:20',3310503074,1),(51957094,426276772,14788861,434787,1,'2007-09-15 13:55:20',3310503074,1),(51957098,426275885,14787864,434787,1,'2007-09-15 13:55:20',3310502391,1),(51957101,426274666,14788640,434787,1,'2007-09-15 13:55:21',3310502391,1),(51957103,426274888,14792851,434787,1,'2007-09-15 13:55:21',3310502391,1),(51957105,426276107,14800498,434787,1,'2007-09-15 13:55:21',3310503074,1),(51957110,426275996,14802382,434787,1,'2007-09-15 13:55:21',3310502391,1),(51957112,426274445,14803158,434787,1,'2007-09-15 13:55:21',3310502391,1),(51957115,426273780,14802160,434787,1,'2007-09-15 13:55:21',3310502391,1),(51957117,426273115,14798060,434787,1,'2007-09-15 13:55:22',3310502391,1),(51957119,426271342,14794070,434787,1,'2007-09-15 13:55:22',3310502391,1),(51957121,426270123,14792740,434787,1,'2007-09-15 13:55:22',3310502391,1),(51957125,426268904,14791078,434787,1,'2007-09-15 13:55:22',3310502391,1),(51957128,426268571,14789416,434787,1,'2007-09-15 13:55:22',3310502391,1),(51957131,426268349,14786312,434787,1,'2007-09-15 13:55:22',3310502391,1),(51957134,426268904,14783542,434787,1,'2007-09-15 13:55:23',3310502391,1),(51957135,426268904,14782323,434787,1,'2007-09-15 13:55:23',3310502391,1),(51957138,426267684,14781436,434787,1,'2007-09-15 13:55:23',3310502391,1),(51957141,426266244,14781990,434787,1,'2007-09-15 13:55:23',3310502391,1),(51957143,426265357,14783209,434787,1,'2007-09-15 13:55:23',3310502391,1),(51957144,426265357,14787975,434787,1,'2007-09-15 13:55:23',3310502391,1),(51957146,426267130,14800055,434787,1,'2007-09-15 13:55:24',3310502391,1),(51957147,426267684,14802493,434787,1,'2007-09-15 13:55:24',3310502391,1),(51957151,426267574,14804488,434787,1,'2007-09-15 13:55:24',3310502391,1),(51957153,426266576,14804931,434787,1,'2007-09-15 13:55:24',3310502391,1),(51957155,426265357,14804377,434787,1,'2007-09-15 13:55:24',3310502391,1),(51957157,426264581,14802493,434787,1,'2007-09-15 13:55:24',3310502391,1),(51957160,426263141,14799611,434787,1,'2007-09-15 13:55:25',3310502391,1),(51957162,426261589,14797284,434787,1,'2007-09-15 13:55:25',3310502391,1),(51957164,426259262,14794846,434787,1,'2007-09-15 13:55:25',3310502391,1),(51957166,426255715,14793959,434787,1,'2007-09-15 13:55:25',3310502391,1),(51957168,426244744,14793405,434787,1,'2007-09-15 13:55:25',3310502390,1),(51957170,426240205,14793093,434787,1,'2007-09-15 13:55:25',3310502390,1),(51957172,426236087,14792740,434787,1,'2007-09-15 13:55:25',3310502390,1),(51957174,426230557,14791564,434787,1,'2007-09-15 13:55:25',3310502390,1),(51972980,425123655,15354572,434787,1,'2007-09-15 14:19:30',3310491454,1),(51972984,425125217,15354238,434787,1,'2007-09-15 14:19:30',3310491454,1),(51972990,425134816,15344759,434787,1,'2007-09-15 14:19:30',3310491454,1),(51972993,425134312,15348285,434787,1,'2007-09-15 14:19:30',3310491454,1),(51972999,425133682,15353890,434787,1,'2007-09-15 14:19:31',3310491454,1),(51973000,425133115,15357858,434787,1,'2007-09-15 14:19:31',3310491454,1),(51973004,425132171,15360692,434787,1,'2007-09-15 14:19:31',3310491454,1),(51973007,425130282,15365289,434787,1,'2007-09-15 14:19:31',3310491454,1),(51973010,425129148,15369193,434787,1,'2007-09-15 14:19:31',3310491454,1),(51973014,425128077,15374420,434787,1,'2007-09-15 14:19:31',3310491454,1),(51973017,425127133,15379836,434787,1,'2007-09-15 14:19:32',3310491454,1),(51973021,425126566,15384874,434787,1,'2007-09-15 14:19:32',3310491540,1),(51973026,425125936,15386701,434787,1,'2007-09-15 14:19:32',3310491540,1),(51973027,425124551,15388842,434787,1,'2007-09-15 14:19:32',3310491540,1),(51973030,425122913,15391928,434787,1,'2007-09-15 14:19:33',3310491540,1),(51973033,425122851,15393143,495907,1,'2008-07-15 17:35:47',3310491540,2),(51973038,425121762,15397763,434787,1,'2007-09-15 14:19:33',3310491537,1),(51973045,425121120,15400066,434787,1,'2007-09-15 14:19:33',3310491537,1),(51973049,425119384,15403766,434787,1,'2007-09-15 14:19:34',3310491537,1),(51973052,425118364,15405654,434787,1,'2007-09-15 14:19:34',3310491537,1),(51973055,425118175,15406296,434787,1,'2007-09-15 14:19:34',3310491537,1),(51973058,425117498,15408946,434787,1,'2007-09-15 14:19:34',3310491537,1),(51973061,425116997,15410749,434787,1,'2007-09-15 14:19:34',3310491537,1),(51973066,425116863,15412720,434787,1,'2007-09-15 14:19:35',3310491537,1),(51973069,425116663,15414591,434787,1,'2007-09-15 14:19:35',3310491537,1),(51973073,425115994,15415726,434787,1,'2007-09-15 14:19:35',3310491537,1),(51973078,425114792,15417230,434787,1,'2007-09-15 14:19:35',3310491537,1),(51973082,425113523,15418098,434787,1,'2007-09-15 14:19:35',3310491537,1),(51973084,425111084,15418332,434787,1,'2007-09-15 14:19:36',3310491537,1),(51973088,425108746,15418332,434787,1,'2007-09-15 14:19:36',3310491537,1),(51973091,425102934,15418465,434787,1,'2007-09-15 14:19:36',3310491537,1),(51973096,425100815,15418808,434787,1,'2007-09-15 14:19:36',3310491537,1),(51973099,425096382,15420508,434787,1,'2007-09-15 14:19:37',3310491537,1),(51973102,425172985,15674698,434787,1,'2007-09-15 14:19:37',3310491575,1),(51973105,425172136,15668758,434787,1,'2007-09-15 14:19:37',3310491575,1),(51973108,425170121,15661758,434787,1,'2007-09-15 14:19:38',3310491575,1),(51973112,425169909,15659318,434787,1,'2007-09-15 14:19:38',3310491575,1),(51973113,425170333,15658046,434787,1,'2007-09-15 14:19:38',3310491575,1),(51973117,425171076,15658046,434787,1,'2007-09-15 14:19:38',3310491575,1),(51973120,425172242,15658576,434787,1,'2007-09-15 14:19:38',3310491575,1),(51973122,425173833,15661121,434787,1,'2007-09-15 14:19:38',3310491575,1),(51973125,425182557,15679190,5671401,1,'2010-09-03 18:06:01',3310491618,2),(51973128,425189743,15692411,434787,1,'2007-09-15 14:19:39',3310491618,1),(51973131,425196637,15702381,434787,1,'2007-09-15 14:19:39',3310491618,1),(51973135,425206714,15711714,434787,1,'2007-09-15 14:19:39',3310491625,1),(51973138,425218911,15720730,434787,1,'2007-09-15 14:19:39',3310491625,1),(51973141,425223260,15723594,434787,1,'2007-09-15 14:19:39',3310491625,1),(51973144,425224108,15725715,434787,1,'2007-09-15 14:19:40',3310491625,1),(51973147,425224214,15728367,434787,1,'2007-09-15 14:19:40',3310491625,1),(51973150,425227714,15737382,434787,1,'2007-09-15 14:19:40',3310491625,1),(51973154,425231108,15744807,434787,1,'2007-09-15 14:19:41',3310491625,1),(51973156,425237048,15752125,434787,1,'2007-09-15 14:19:41',3310491628,1),(51973158,425240973,15755307,434787,1,'2007-09-15 14:19:41',3310491628,1),(51973161,425244791,15757853,434787,1,'2007-09-15 14:19:41',3310491628,1),(51973163,425245003,15760080,434787,1,'2007-09-15 14:19:42',3310491628,1),(51973166,425244048,15762095,434787,1,'2007-09-15 14:19:42',3310491628,1),(51973170,425244367,15766338,434787,1,'2007-09-15 14:19:42',3310491630,1),(51973172,425245003,15770899,434787,1,'2007-09-15 14:19:43',3310491630,1),(51973175,425246700,15773338,434787,1,'2007-09-15 14:19:43',3310491630,1),(51973177,425246700,15774611,434787,1,'2007-09-15 14:19:43',3310491630,1),(51973179,425246700,15778111,434787,1,'2007-09-15 14:19:43',3310491630,1),(51973183,425247655,15782990,434787,1,'2007-09-15 14:19:43',3310491630,1),(51973186,425248415,15785554,434787,1,'2007-09-15 14:19:44',3310491630,1),(51973190,425248495,15787626,434787,1,'2007-09-15 14:19:44',3310491630,1),(51973193,425248495,15788822,434787,1,'2007-09-15 14:19:44',3310491630,1),(51973196,425249052,15790575,434787,1,'2007-09-15 14:19:44',3310491630,1),(51973198,425250647,15793524,434787,1,'2007-09-15 14:19:45',3310491630,1),(51973201,425254074,15798466,434787,1,'2007-09-15 14:19:45',3310491630,1),(51973203,425254711,15799900,434787,1,'2007-09-15 14:19:45',3310491630,1),(51973206,425254472,15801973,434787,1,'2007-09-15 14:19:45',3310491630,1),(51973208,425253595,15803886,434787,1,'2007-09-15 14:19:45',3310491630,1),(51973210,425252798,15806277,434787,1,'2007-09-15 14:19:45',3310491630,1),(51973213,425251922,15807871,434787,1,'2007-09-15 14:19:45',3310491630,1),(51973215,425252081,15809305,434787,1,'2007-09-15 14:19:46',3310491630,1),(51973219,425252639,15810341,434787,1,'2007-09-15 14:19:46',3310491630,1),(51973221,425254313,15811776,434787,1,'2007-09-15 14:19:46',3310491630,1),(51973223,425257581,15812892,434787,1,'2007-09-15 14:19:46',3310491630,1),(51973225,425259254,15813211,434787,1,'2007-09-15 14:19:47',3310491630,1),(51973228,425260290,15814725,434787,1,'2007-09-15 14:19:47',3310491631,1),(51973234,425260609,15817355,434787,1,'2007-09-15 14:19:47',3310491631,1),(51973237,425261167,15819746,434787,1,'2007-09-15 14:19:47',3310491631,1),(51973241,425262841,15822616,434787,1,'2007-09-15 14:19:48',3310492997,1),(51973243,425264515,15826601,434787,1,'2007-09-15 14:19:48',3310492997,1),(51973247,425265391,15827876,434787,1,'2007-09-15 14:19:48',3310492997,1),(51973249,425267145,15829071,434787,1,'2007-09-15 14:19:48',3310492997,1);
INSERT INTO `current_nodes` VALUES (51973253,425269456,15830108,434787,1,'2007-09-15 14:19:49',3310492997,1),(51973256,425270811,15830745,434787,1,'2007-09-15 14:19:49',3310492997,1),(51973260,425272565,15832499,434787,1,'2007-09-15 14:19:49',3310492997,1),(51973264,425275035,15836404,434787,1,'2007-09-15 14:19:49',3310492997,1),(51973268,425278781,15843498,434787,1,'2007-09-15 14:19:50',3310492997,1),(51973269,425280854,15847961,434787,1,'2007-09-15 14:19:50',3310492997,1),(51973273,425282607,15853142,434787,1,'2007-09-15 14:19:50',3310492997,1),(51973276,425284440,15855931,434787,1,'2007-09-15 14:19:50',3310492997,1),(51973278,425285158,15857525,434787,1,'2007-09-15 14:19:50',3310492997,1),(51973281,425285795,15862068,434787,1,'2007-09-15 14:19:50',3310492997,1),(51973284,425287150,15868046,434787,1,'2007-09-15 14:19:51',3310492997,1),(51973287,425287947,15870676,434787,1,'2007-09-15 14:19:51',3310493008,1),(51973290,425288251,15872645,434787,1,'2007-09-15 14:19:51',3310493008,1),(51973293,425288342,15875745,434787,1,'2007-09-15 14:19:51',3310493010,1),(51973296,425287658,15878844,434787,1,'2007-09-15 14:19:52',3310493010,1),(51973300,425286701,15882627,434787,1,'2007-09-15 14:19:52',3310492999,1),(51973302,425285789,15884815,434787,1,'2007-09-15 14:19:52',3310492999,1),(51973306,425284696,15886592,434787,1,'2007-09-15 14:19:52',3310492999,1),(51973310,425284058,15889373,434787,1,'2007-09-15 14:19:52',3310492999,1),(51973313,425283738,15891925,434787,1,'2007-09-15 14:19:53',3310492999,1),(51973316,425283602,15892791,434787,1,'2007-09-15 14:19:53',3310492999,1),(51973320,425283602,15893566,434787,1,'2007-09-15 14:19:53',3310492999,1),(51973324,425283738,15894249,434787,1,'2007-09-15 14:19:53',3310492999,1),(51973326,425284103,15894705,434787,1,'2007-09-15 14:19:53',3310492999,1),(51973327,425285862,15897161,434787,1,'2007-09-15 14:19:53',3310492999,1),(51973329,425286986,15898231,434787,1,'2007-09-15 14:19:53',3310492999,1),(51973334,425287949,15899515,434787,1,'2007-09-15 14:19:54',3310493010,1),(51973336,425287949,15900639,434787,1,'2007-09-15 14:19:54',3310493010,1),(51973339,425287628,15901495,434787,1,'2007-09-15 14:19:54',3310493010,1),(51973341,425286986,15904332,434787,1,'2007-09-15 14:19:54',3310492999,1),(51973344,425286665,15906205,434787,1,'2007-09-15 14:19:54',3310492999,1),(51973346,425286611,15907971,434787,1,'2007-09-15 14:19:54',3310492999,1),(51973348,425286183,15911289,434787,1,'2007-09-15 14:19:55',3310492999,1),(51973351,425285916,15913322,434787,1,'2007-09-15 14:19:55',3310492999,1),(51973352,425286504,15915088,434787,1,'2007-09-15 14:19:55',3310492999,1),(51973353,425287468,15916908,434787,1,'2007-09-15 14:19:55',3310493010,1),(51973354,425288163,15919584,434787,1,'2007-09-15 14:19:55',3310493010,1),(51973356,425288913,15921617,434787,1,'2007-09-15 14:19:56',3310493010,1),(51973357,425289287,15923276,434787,1,'2007-09-15 14:19:56',3310493010,1),(51973359,425289287,15924079,434787,1,'2007-09-15 14:19:56',3310493010,1),(51973361,425288805,15924935,434787,1,'2007-09-15 14:19:56',3310493010,1),(51973362,425288110,15925577,434787,1,'2007-09-15 14:19:56',3310493010,1),(51973363,425286986,15926434,434787,1,'2007-09-15 14:19:56',3310492999,1),(51973364,425285755,15926701,434787,1,'2007-09-15 14:19:56',3310492999,1),(51973366,425284899,15926701,434787,1,'2007-09-15 14:19:56',3310492999,1),(51973369,425284310,15926648,434787,1,'2007-09-15 14:19:57',3310492999,1),(51973370,425283347,15927236,434787,1,'2007-09-15 14:19:57',3310492999,1),(51973373,425281848,15928681,434787,1,'2007-09-15 14:19:57',3310492999,1),(51973375,425280082,15929805,434787,1,'2007-09-15 14:19:57',3310492999,1),(51973378,425278691,15930554,434787,1,'2007-09-15 14:19:57',3310493005,1),(51973380,425277618,15931249,434787,1,'2007-09-15 14:19:58',3310493005,1),(51973384,425276528,15932813,434787,1,'2007-09-15 14:19:58',3310493005,1),(51973387,425275770,15934045,434787,1,'2007-09-15 14:19:58',3310493005,1),(51973390,425274680,15934945,434787,1,'2007-09-15 14:19:58',3310493005,1),(51973394,425272690,15935893,434787,1,'2007-09-15 14:19:59',3310493005,1),(51973396,425271790,15936461,434787,1,'2007-09-15 14:19:59',3310493005,1),(51973398,425271127,15937693,434787,1,'2007-09-15 14:19:59',3310493005,1),(51973400,425271079,15939399,434787,1,'2007-09-15 14:20:00',3310493005,1),(51973403,425271695,15940773,434787,1,'2007-09-15 14:20:00',3310493005,1),(51973405,425272927,15942479,434787,1,'2007-09-15 14:20:00',3310493005,1),(51973407,425273875,15943332,434787,1,'2007-09-15 14:20:00',3310493005,1),(51973409,425274207,15944706,434787,1,'2007-09-15 14:20:00',3310493005,1),(51973413,425274017,15947549,434787,1,'2007-09-15 14:20:00',3310493005,1),(51973416,425273922,15950013,434787,1,'2007-09-15 14:20:01',3310493005,1),(51973417,425273638,15951576,434787,1,'2007-09-15 14:20:01',3310493005,1),(51973419,425273259,15953567,434787,1,'2007-09-15 14:20:01',3310493005,1),(51973424,425272975,15955035,434787,1,'2007-09-15 14:20:01',3310493005,1),(51973426,425272674,15957022,434787,1,'2007-09-15 14:20:01',3310493005,1),(51973428,425273157,15958905,434787,1,'2007-09-15 14:20:01',3310493005,1),(51973430,425274268,15959871,434787,1,'2007-09-15 14:20:02',3310493005,1),(51973432,425275668,15959630,434787,1,'2007-09-15 14:20:02',3310493005,1),(51973436,425276972,15958422,434787,1,'2007-09-15 14:20:02',3310493005,1),(51973439,425279387,15957650,434787,1,'2007-09-15 14:20:02',3310493005,1),(51973441,425280787,15957312,434787,1,'2007-09-15 14:20:02',3310493005,1),(51973444,425282864,15956008,434787,1,'2007-09-15 14:20:02',3310493005,1),(51973448,425284892,15953835,434787,1,'2007-09-15 14:20:02',3310493005,1),(51973451,425286921,15951372,434787,1,'2007-09-15 14:20:03',3310493005,1),(51973454,425288128,15950261,434787,1,'2007-09-15 14:20:03',3310493016,1),(51973456,425289480,15950068,434787,1,'2007-09-15 14:20:03',3310493016,1),(51973459,425291750,15950792,434787,1,'2007-09-15 14:20:03',3310493016,1),(51973462,425292861,15951854,434787,1,'2007-09-15 14:20:03',3310493016,1),(51973467,425294213,15954462,434787,1,'2007-09-15 14:20:03',3310493016,1),(51973470,425295614,15958326,434787,1,'2007-09-15 14:20:03',3310493016,1),(51973471,425296000,15961079,434787,1,'2007-09-15 14:20:03',3310493016,1),(51973475,425297062,15963590,434787,1,'2007-09-15 14:20:04',3310493016,1),(51973478,425299546,15966920,434787,1,'2007-09-15 14:20:04',3310493016,1),(51973481,425301843,15969430,434787,1,'2007-09-15 14:20:04',3310493016,1),(51973484,425303605,15971727,434787,1,'2007-09-15 14:20:04',3310493016,1),(51973487,425303659,15974664,434787,1,'2007-09-15 14:20:04',3310493016,1),(51973489,425302590,15979258,434787,1,'2007-09-15 14:20:05',3310493016,1),(51973491,425301576,15983584,434787,1,'2007-09-15 14:20:05',3310493016,1),(51973494,425301309,15988337,434787,1,'2007-09-15 14:20:05',3310493018,1),(51973497,425301736,15993785,434787,1,'2007-09-15 14:20:05',3310493018,1),(51973499,425302911,15999072,434787,1,'2007-09-15 14:20:05',3310493018,1),(51973501,425303754,16001564,1882243,1,'2009-07-20 12:44:02',3310493018,2),(51973504,425305368,16002769,434787,1,'2007-09-15 14:20:06',3310493018,1),(51973507,425308242,16003952,434787,1,'2007-09-15 14:20:06',3310493018,1),(51973511,425311750,16005165,434787,1,'2007-09-15 14:20:06',3310493018,1),(51973514,425330006,15871191,434787,1,'2007-09-15 14:20:06',3310493009,1),(51973516,425335160,15876009,434787,1,'2007-09-15 14:20:07',3310493011,1),(51973519,425340650,15880378,434787,1,'2007-09-15 14:20:07',3310493011,1),(51973521,425342779,15881162,434787,1,'2007-09-15 14:20:07',3310493014,1),(51973523,425345131,15880938,434787,1,'2007-09-15 14:20:07',3310493014,1),(51973526,425347269,15881092,434787,1,'2007-09-15 14:20:07',3310493014,1),(51973528,425348130,15881150,434787,1,'2007-09-15 14:20:08',3310493014,1),(51973529,425348818,15882354,434787,1,'2007-09-15 14:20:08',3310493014,1),(51973532,425349851,15883387,434787,1,'2007-09-15 14:20:08',3310493014,1),(51973534,425351055,15883387,434787,1,'2007-09-15 14:20:09',3310493014,1),(51973538,425352775,15881569,434787,1,'2007-09-15 14:20:09',3310493014,1),(51973541,425328132,15869606,434787,1,'2007-09-15 14:20:09',3310493009,1),(51973544,425327290,15869044,434787,1,'2007-09-15 14:20:09',3310493009,1),(51973546,425325700,15868577,434787,1,'2007-09-15 14:20:09',3310493009,1),(51973548,425323969,15868062,434787,1,'2007-09-15 14:20:09',3310493009,1),(51973550,425322566,15867782,434787,1,'2007-09-15 14:20:10',3310493009,1),(51973554,425321630,15867220,434787,1,'2007-09-15 14:20:10',3310493009,1),(51973557,425320788,15865583,434787,1,'2007-09-15 14:20:10',3310493009,1),(51973559,425319853,15865022,434787,1,'2007-09-15 14:20:10',3310493009,1),(51973561,425318684,15864648,434787,1,'2007-09-15 14:20:10',3310493009,1),(51973562,425317888,15865302,434787,1,'2007-09-15 14:20:10',3310493009,1),(51973564,425317608,15865817,434787,1,'2007-09-15 14:20:10',3310493009,1),(51973567,425317655,15866940,434787,1,'2007-09-15 14:20:11',3310493009,1),(51973570,425318263,15868062,434787,1,'2007-09-15 14:20:11',3310493009,1),(51973571,425320461,15869840,434787,1,'2007-09-15 14:20:11',3310493009,1),(51973575,425322285,15871570,434787,1,'2007-09-15 14:20:11',3310493009,1),(51973577,425323174,15873254,434787,1,'2007-09-15 14:20:11',3310493009,1),(51973579,425323501,15875078,434787,1,'2007-09-15 14:20:11',3310493009,1),(51973582,425323267,15878773,434787,1,'2007-09-15 14:20:11',3310493011,1),(51973587,425322893,15882702,434787,1,'2007-09-15 14:20:12',3310493011,1),(51973590,425323127,15884901,434787,1,'2007-09-15 14:20:12',3310493011,1),(51973591,425323875,15886818,434787,1,'2007-09-15 14:20:12',3310493011,1),(51973594,425325793,15889297,434787,1,'2007-09-15 14:20:12',3310493011,1),(51973596,425327056,15893180,434787,1,'2007-09-15 14:20:12',3310493011,1),(51973598,425327009,15898371,434787,1,'2007-09-15 14:20:13',3310493011,1),(51973599,425326775,15902862,434787,1,'2007-09-15 14:20:13',3310493011,1),(51973602,425326214,15905247,434787,1,'2007-09-15 14:20:13',3310493011,1),(51973604,425325045,15908054,434787,1,'2007-09-15 14:20:13',3310493011,1),(51973606,425323127,15911281,434787,1,'2007-09-15 14:20:13',3310493011,1),(51973608,425320367,15916333,434787,1,'2007-09-15 14:20:13',3310493011,1),(51973611,425318309,15919513,434787,1,'2007-09-15 14:20:14',3310493011,1),(51973614,425317795,15921805,434787,1,'2007-09-15 14:20:14',3310493011,1),(51973617,425318356,15925126,434787,1,'2007-09-15 14:20:14',3310493011,1),(51973619,425319385,15927231,434787,1,'2007-09-15 14:20:14',3310493011,1),(51973621,425320508,15927886,434787,1,'2007-09-15 14:20:14',3310493011,1),(51973622,425322051,15927839,434787,1,'2007-09-15 14:20:14',3310493011,1),(51973624,425323221,15927278,434787,1,'2007-09-15 14:20:14',3310493011,1),(51973627,425325466,15926389,434787,1,'2007-09-15 14:20:14',3310493011,1),(51973631,425328616,15925170,434787,1,'2007-09-15 14:20:14',3310493011,1),(51973633,425330139,15925215,434787,1,'2007-09-15 14:20:15',3310493011,1),(51973636,425331950,15925525,434787,1,'2007-09-15 14:20:15',3310493011,1),(51973639,425333812,15925474,434787,1,'2007-09-15 14:20:15',3310493011,1),(51973643,425335674,15924853,434787,1,'2007-09-15 14:20:15',3310493011,1),(51973646,425337278,15923870,434787,1,'2007-09-15 14:20:15',3310493011,1),(51973648,425338726,15922939,434787,1,'2007-09-15 14:20:16',3310493011,1),(51973651,425340226,15922473,434787,1,'2007-09-15 14:20:16',3310493011,1),(51973653,425341778,15922939,434787,1,'2007-09-15 14:20:16',3310493011,1),(51973657,425342864,15924129,434787,1,'2007-09-15 14:20:16',3310493014,1),(51973660,425344313,15926922,434787,1,'2007-09-15 14:20:16',3310493014,1),(51973663,425345864,15928784,434787,1,'2007-09-15 14:20:16',3310493014,1),(51973667,425348089,15930543,434787,1,'2007-09-15 14:20:17',3310493020,1),(51973669,425349434,15931940,434787,1,'2007-09-15 14:20:17',3310493020,1),(51973673,425350934,15933440,434787,1,'2007-09-15 14:20:17',3310493020,1),(51973676,425351554,15934785,434787,1,'2007-09-15 14:20:17',3310493020,1),(51973679,425351192,15935923,434787,1,'2007-09-15 14:20:17',3310493020,1),(51973681,425350365,15936233,434787,1,'2007-09-15 14:20:18',3310493020,1),(51973683,425349175,15935923,434787,1,'2007-09-15 14:20:18',3310493020,1),(51973686,425347675,15935198,434787,1,'2007-09-15 14:20:18',3310493020,1),(51973688,425346899,15934629,434787,1,'2007-09-15 14:20:18',3310493020,1),(51973691,425345451,15933285,434787,1,'2007-09-15 14:20:18',3310493020,1),(51973694,425343123,15932095,434787,1,'2007-09-15 14:20:19',3310493020,1),(51973696,425341416,15930853,434787,1,'2007-09-15 14:20:19',3310493017,1),(51973699,425340381,15930595,434787,1,'2007-09-15 14:20:19',3310493017,1),(51973703,425339709,15930646,434787,1,'2007-09-15 14:20:19',3310493017,1),(51973705,425339347,15931681,434787,1,'2007-09-15 14:20:19',3310493017,1),(51973708,425339347,15932612,434787,1,'2007-09-15 14:20:19',3310493017,1),(51973711,425340278,15933595,434787,1,'2007-09-15 14:20:19',3310493017,1),(51973714,425341519,15933957,434787,1,'2007-09-15 14:20:20',3310493017,1),(51973717,425342450,15934733,434787,1,'2007-09-15 14:20:20',3310493020,1),(51973720,425342709,15936078,434787,1,'2007-09-15 14:20:20',3310493020,1),(51973722,425342864,15937630,434787,1,'2007-09-15 14:20:20',3310493020,1),(51973725,425343226,15939906,434787,1,'2007-09-15 14:20:20',3310493020,1),(51973728,425343899,15941147,434787,1,'2007-09-15 14:20:20',3310493020,1),(51973730,425345244,15942647,434787,1,'2007-09-15 14:20:20',3310493020,1),(51973731,425345606,15944406,434787,1,'2007-09-15 14:20:21',3310493020,1),(51973733,425346227,15946837,434787,1,'2007-09-15 14:20:21',3310493020,1),(51973736,425346692,15948130,434787,1,'2007-09-15 14:20:21',3310493020,1),(51973739,425347623,15949372,434787,1,'2007-09-15 14:20:21',3310493020,1),(51973741,425349382,15950510,434787,1,'2007-09-15 14:20:21',3310493020,1),(51973744,425351299,15951569,434787,1,'2007-09-15 14:20:21',3310493020,1),(51973747,425353320,15952816,434787,1,'2007-09-15 14:20:22',3310493020,1),(51973749,425353965,15953976,434787,1,'2007-09-15 14:20:22',3310493020,1),(51973751,425353922,15954793,434787,1,'2007-09-15 14:20:22',3310493020,1),(51973753,425353363,15955911,434787,1,'2007-09-15 14:20:22',3310493020,1),(51973755,425352589,15956083,434787,1,'2007-09-15 14:20:22',3310493020,1),(51973757,425351342,15955825,434787,1,'2007-09-15 14:20:22',3310493020,1),(51973759,425349967,15955524,434787,1,'2007-09-15 14:20:22',3310493020,1),(51973764,425348806,15955524,434787,1,'2007-09-15 14:20:23',3310493020,1),(51973766,425347817,15955524,434787,1,'2007-09-15 14:20:23',3310493020,1),(51973769,425346829,15955438,434787,1,'2007-09-15 14:20:23',3310493020,1),(51973770,425345668,15955051,434787,1,'2007-09-15 14:20:23',3310493020,1),(51973771,425344851,15954363,434787,1,'2007-09-15 14:20:23',3310493020,1),(51973777,425343820,15952988,434787,1,'2007-09-15 14:20:24',3310493020,1),(51973782,425343261,15951354,434787,1,'2007-09-15 14:20:24',3310493020,1),(51973784,425342100,15949850,434787,1,'2007-09-15 14:20:24',3310493017,1),(51973786,425341111,15949033,434787,1,'2007-09-15 14:20:24',3310493017,1),(51973790,425339908,15949033,434787,1,'2007-09-15 14:20:25',3310493017,1),(51973792,425339263,15949420,434787,1,'2007-09-15 14:20:25',3310493017,1),(51973796,425338403,15950365,434787,1,'2007-09-15 14:20:25',3310493017,1),(51973799,425336984,15952257,434787,1,'2007-09-15 14:20:25',3310493017,1),(51973802,425335480,15954320,434787,1,'2007-09-15 14:20:25',3310493017,1),(51973803,425333416,15956857,434787,1,'2007-09-15 14:20:25',3310493017,1),(51973807,425331783,15958361,434787,1,'2007-09-15 14:20:25',3310493017,1),(51973809,425330364,15959780,434787,1,'2007-09-15 14:20:26',3310493017,1),(51973812,425328774,15960554,434787,1,'2007-09-15 14:20:26',3310493017,1),(51973815,425327312,15962058,434787,1,'2007-09-15 14:20:26',3310493017,1),(51973817,425327183,15963348,434787,1,'2007-09-15 14:20:26',3310493017,1),(51973818,425327699,15963864,434787,1,'2007-09-15 14:20:26',3310493017,1),(51973820,425328215,15963907,434787,1,'2007-09-15 14:20:27',3310493017,1),(51973831,425329075,15963348,434787,1,'2007-09-15 14:20:27',3310493017,1),(51973834,425329934,15962617,434787,1,'2007-09-15 14:20:28',3310493017,1),(51973836,425332471,15961456,434787,1,'2007-09-15 14:20:28',3310493017,1),(51973839,425335136,15960726,434787,1,'2007-09-15 14:20:28',3310493017,1),(51973842,425337285,15960683,434787,1,'2007-09-15 14:20:28',3310493017,1),(51973844,425339177,15960339,434787,1,'2007-09-15 14:20:29',3310493017,1),(51973846,425340037,15960339,434787,1,'2007-09-15 14:20:29',3310493017,1),(51973848,425340595,15960897,434787,1,'2007-09-15 14:20:29',3310493017,1),(51973849,425340595,15961413,434787,1,'2007-09-15 14:20:29',3310493017,1),(51973851,425340166,15962488,434787,1,'2007-09-15 14:20:29',3310493017,1),(51973852,425338790,15963434,434787,1,'2007-09-15 14:20:30',3310493017,1),(51973855,425335738,15965411,434787,1,'2007-09-15 14:20:30',3310493017,1),(51973858,425333674,15966486,434787,1,'2007-09-15 14:20:30',3310493017,1),(51973860,425331977,15968116,434787,1,'2007-09-15 14:20:30',3310493017,1),(51973862,425330897,15969454,434787,1,'2007-09-15 14:20:30',3310493017,1),(51973865,425329714,15970483,434787,1,'2007-09-15 14:20:30',3310493017,1),(51973868,425328531,15971306,434787,1,'2007-09-15 14:20:30',3310493017,1),(51973871,425327399,15971460,434787,1,'2007-09-15 14:20:31',3310493017,1),(51973874,425325753,15971100,434787,1,'2007-09-15 14:20:31',3310493017,1),(51973877,425324569,15971100,434787,1,'2007-09-15 14:20:31',3310493017,1),(51973878,425323849,15971100,434787,1,'2007-09-15 14:20:31',3310493017,1),(51973881,425322769,15971512,434787,1,'2007-09-15 14:20:31',3310493017,1),(51973883,425322255,15972540,434787,1,'2007-09-15 14:20:31',3310493017,1),(51973884,425319991,15974547,434787,1,'2007-09-15 14:20:32',3310493017,1),(51973887,425317882,15977170,434787,1,'2007-09-15 14:20:32',3310493017,1),(51973890,425316801,15978662,434787,1,'2007-09-15 14:20:32',3310493017,1),(51973891,425315978,15981183,434787,1,'2007-09-15 14:20:32',3310493017,1),(51973894,425314898,15986379,434787,1,'2007-09-15 14:20:32',3310493019,1),(51973897,425313252,15996050,434787,1,'2007-09-15 14:20:32',3310493018,1),(51973898,425312840,16003355,434787,1,'2007-09-15 14:20:32',3310493018,1),(51973901,425310101,16004909,434787,1,'2007-09-15 14:20:32',3310493018,1),(51973903,425312684,16004829,434787,1,'2007-09-15 14:20:32',3310493018,1),(51973905,425313146,16005443,434787,1,'2007-09-15 14:20:33',3310493018,1),(51973907,425313715,16005991,434787,1,'2007-09-15 14:20:33',3310493018,1),(51973910,425314432,16006328,434787,1,'2007-09-15 14:20:33',3310493018,1),(51973913,425315169,16006371,434787,1,'2007-09-15 14:20:33',3310493019,1),(51973915,425315822,16006118,434787,1,'2007-09-15 14:20:33',3310493019,1),(51973917,425316433,16005359,434787,1,'2007-09-15 14:20:33',3310493019,1),(51973920,425316855,16004348,434787,1,'2007-09-15 14:20:33',3310493019,1),(51973922,425317465,16002883,434787,1,'2007-09-15 14:20:34',3310493019,1),(51973924,425317978,16001806,434787,1,'2007-09-15 14:20:34',3310493019,1),(51973927,425318799,16000472,434787,1,'2007-09-15 14:20:34',3310493019,1),(51973929,425320030,15998779,434787,1,'2007-09-15 14:20:34',3310493019,1),(51973931,425321664,15996067,434787,1,'2007-09-15 14:20:34',3310493019,1),(51973934,425323293,15993703,434787,1,'2007-09-15 14:20:35',3310493019,1),(51973937,425324317,15992154,434787,1,'2007-09-15 14:20:35',3310493019,1),(51973939,425325237,15990683,434787,1,'2007-09-15 14:20:35',3310493019,1),(51973941,425325893,15989501,434787,1,'2007-09-15 14:20:35',3310493019,1),(51973942,425326550,15988056,434787,1,'2007-09-15 14:20:35',3310493019,1),(51973947,425327128,15986375,434787,1,'2007-09-15 14:20:35',3310493019,1),(51973950,425327811,15984563,434787,1,'2007-09-15 14:20:35',3310493017,1),(51973952,425328336,15983591,434787,1,'2007-09-15 14:20:35',3310493017,1),(51973953,425328756,15983065,434787,1,'2007-09-15 14:20:35',3310493017,1),(51973955,425329255,15982855,434787,1,'2007-09-15 14:20:36',3310493017,1),(51973958,425329912,15982776,434787,1,'2007-09-15 14:20:36',3310493017,1),(51973962,425330464,15983197,434787,1,'2007-09-15 14:20:36',3310493017,1),(51973963,425330674,15983591,434787,1,'2007-09-15 14:20:36',3310493017,1),(51973967,425330569,15984274,434787,1,'2007-09-15 14:20:36',3310493017,1),(51973968,425330227,15985298,434787,1,'2007-09-15 14:20:37',3310493017,1),(51973972,425329623,15986060,434787,1,'2007-09-15 14:20:37',3310493019,1),(51973975,425329098,15986848,434787,1,'2007-09-15 14:20:37',3310493019,1),(51973977,425328730,15987531,434787,1,'2007-09-15 14:20:37',3310493019,1),(51973981,425328179,15988949,434787,1,'2007-09-15 14:20:37',3310493019,1),(51973983,425327443,15992548,434787,1,'2007-09-15 14:20:37',3310493019,1),(51973986,425326998,15994611,434787,1,'2007-09-15 14:20:37',3310493019,1),(51973989,425326213,15998271,434787,1,'2007-09-15 14:20:38',3310493019,1),(51973992,425325625,16002389,434787,1,'2007-09-15 14:20:38',3310493019,1),(51973995,425325205,16006217,434787,1,'2007-09-15 14:20:38',3310493019,1),(51973998,425324849,16008127,434787,1,'2007-09-15 14:20:38',3310493019,1),(51974002,425324851,16012092,434787,1,'2007-09-15 14:20:38',3310493019,1),(51974005,425324697,16016774,434787,1,'2007-09-15 14:20:39',3310493019,1),(51974008,425324467,16021762,434787,1,'2007-09-15 14:20:39',3310493019,1),(51974011,425324390,16026136,434787,1,'2007-09-15 14:20:39',3310493019,1),(51974013,425324007,16033657,434787,1,'2007-09-15 14:20:39',3310493019,1),(51974015,425323393,16040180,434787,1,'2007-09-15 14:20:39',3310493019,1),(51974019,425321781,16047700,434787,1,'2007-09-15 14:20:40',3310493041,1),(51974023,425320476,16052689,434787,1,'2007-09-15 14:20:40',3310493041,1),(51974024,425319556,16056219,434787,1,'2007-09-15 14:20:40',3310493041,1),(51974028,425318711,16058598,434787,1,'2007-09-15 14:20:40',3310493041,1),(51974031,425317100,16061821,434787,1,'2007-09-15 14:20:40',3310493041,1),(51974035,425315181,16065044,434787,1,'2007-09-15 14:20:40',3310493041,1),(51974039,425313186,16068114,434787,1,'2007-09-15 14:20:41',3310493040,1),(51974040,425311805,16069725,434787,1,'2007-09-15 14:20:41',3310493040,1),(51974042,425310347,16070953,434787,1,'2007-09-15 14:20:41',3310493040,1),(51974044,425305972,16073255,434787,1,'2007-09-15 14:20:41',3310493040,1),(51974046,425301752,16075558,434787,1,'2007-09-15 14:20:41',3310493040,1),(51974049,425300140,16076632,434787,1,'2007-09-15 14:20:41',3310493040,1),(51974050,425299603,16077399,434787,1,'2007-09-15 14:20:41',3310493040,1),(51974053,425299833,16078397,434787,1,'2007-09-15 14:20:42',3310493040,1),(51974055,425300447,16079088,434787,1,'2007-09-15 14:20:42',3310493040,1),(51974057,425301521,16078934,434787,1,'2007-09-15 14:20:42',3310493040,1),(51974059,425302826,16078320,434787,1,'2007-09-15 14:20:42',3310493040,1),(51974060,425305896,16078244,434787,1,'2007-09-15 14:20:42',3310493040,1),(51974065,425309047,16078913,434787,1,'2007-09-15 14:20:42',3310493040,1),(51974068,425311216,16079542,434787,1,'2007-09-15 14:20:42',3310493040,1),(51974072,425312159,16079730,434787,1,'2007-09-15 14:20:43',3310493040,1),(51974074,425313416,16079793,434787,1,'2007-09-15 14:20:43',3310493040,1),(51974078,425314453,16079322,434787,1,'2007-09-15 14:20:43',3310493040,1),(51974083,425315459,16078882,434787,1,'2007-09-15 14:20:43',3310493041,1),(51974085,425316245,16079164,434787,1,'2007-09-15 14:20:43',3310493041,1),(51974086,425316339,16079793,434787,1,'2007-09-15 14:20:44',3310493041,1),(51974088,425316119,16080516,434787,1,'2007-09-15 14:20:44',3310493041,1),(51974089,425315522,16081176,434787,1,'2007-09-15 14:20:44',3310493041,1),(51974090,425314391,16081836,434787,1,'2007-09-15 14:20:44',3310493040,1),(51974095,425312662,16082936,434787,1,'2007-09-15 14:20:44',3310493040,1),(51974097,425311153,16083156,434787,1,'2007-09-15 14:20:44',3310493040,1),(51974100,425309456,16083156,434787,1,'2007-09-15 14:20:44',3310493040,1),(51974103,425308544,16083628,434787,1,'2007-09-15 14:20:45',3310493040,1),(51974107,425308167,16084382,434787,1,'2007-09-15 14:20:45',3310493040,1),(51974108,425308167,16085263,434787,1,'2007-09-15 14:20:45',3310493040,1),(51974112,425308638,16085828,434787,1,'2007-09-15 14:20:45',3310493040,1),(51974115,425309676,16086111,434787,1,'2007-09-15 14:20:45',3310493040,1),(51974119,425311122,16085891,434787,1,'2007-09-15 14:20:46',3310493040,1),(51974122,425314988,16084980,434787,1,'2007-09-15 14:20:46',3310493041,1),(51974126,425317314,16083848,434787,1,'2007-09-15 14:20:46',3310493041,1),(51974129,425319640,16082182,434787,1,'2007-09-15 14:20:46',3310493041,1),(51974131,425323266,16078703,434787,1,'2007-09-15 14:20:46',3310493041,1),(51974133,425325384,16076313,434787,1,'2007-09-15 14:20:46',3310493041,1),(51974134,425327883,16072565,434787,1,'2007-09-15 14:20:46',3310493041,1),(51974137,425330924,16067677,434787,1,'2007-09-15 14:20:47',3310493041,1),(51974140,425332825,16064363,434787,1,'2007-09-15 14:20:47',3310493041,1),(51974143,425334944,16060344,434787,1,'2007-09-15 14:20:47',3310493041,1),(51974147,425336736,16055836,434787,1,'2007-09-15 14:20:47',3310493041,1),(51974149,425338855,16050024,434787,1,'2007-09-15 14:20:47',3310493041,1),(51974152,425340267,16045515,434787,1,'2007-09-15 14:20:47',3310493041,1),(51974153,425341136,16041876,434787,1,'2007-09-15 14:20:48',3310493041,1),(51974155,425341896,16040084,434787,1,'2007-09-15 14:20:48',3310493019,1),(51974158,425342820,16039812,434787,1,'2007-09-15 14:20:48',3310493022,1),(51974161,425343634,16040192,434787,1,'2007-09-15 14:20:48',3310493022,1),(51974164,425343852,16041496,434787,1,'2007-09-15 14:20:48',3310493044,1),(51974165,425343526,16043288,434787,1,'2007-09-15 14:20:48',3310493044,1),(51974167,425342983,16046982,434787,1,'2007-09-15 14:20:48',3310493044,1),(51974169,425342385,16051110,434787,1,'2007-09-15 14:20:48',3310493044,1),(51974172,425339778,16061430,434787,1,'2007-09-15 14:20:49',3310493041,1),(51974174,425338148,16067731,434787,1,'2007-09-15 14:20:49',3310493041,1),(51974176,425336899,16074792,434787,1,'2007-09-15 14:20:49',3310493041,1),(51974181,425336114,16080316,434787,1,'2007-09-15 14:20:49',3310493041,1),(51974183,425335363,16085666,434787,1,'2007-09-15 14:20:49',3310493041,1),(51974185,425335014,16090363,434787,1,'2007-09-15 14:20:50',3310493041,1),(51974187,425334945,16093261,434787,1,'2007-09-15 14:20:50',3310493041,1),(51974190,425334669,16098644,434787,1,'2007-09-15 14:20:50',3310493043,1),(51974191,425334738,16104579,434787,1,'2007-09-15 14:20:50',3310493043,1),(51974193,425335083,16110100,434787,1,'2007-09-15 14:20:50',3310493043,1),(51974195,425335980,16114171,434787,1,'2007-09-15 14:20:50',3310493043,1),(51974197,425337085,16120451,434787,1,'2007-09-15 14:20:50',3310493043,1),(51974199,425338120,16126110,434787,1,'2007-09-15 14:20:51',3310493043,1),(51974202,425339086,16131907,434787,1,'2007-09-15 14:20:51',3310493043,1),(51974204,425340259,16134874,434787,1,'2007-09-15 14:20:51',3310493043,1),(51974206,425341915,16136807,434787,1,'2007-09-15 14:20:51',3310493043,1),(51974208,425344262,16137773,434787,1,'2007-09-15 14:20:51',3310493046,1),(51974211,425345711,16137773,434787,1,'2007-09-15 14:20:51',3310493046,1),(51974213,425347298,16137428,434787,1,'2007-09-15 14:20:52',3310493046,1),(51974215,425348402,16137014,434787,1,'2007-09-15 14:20:52',3310493046,1),(51974217,425349851,16136876,434787,1,'2007-09-15 14:20:52',3310493046,1),(51974220,425350818,16137635,434787,1,'2007-09-15 14:20:52',3310493046,1),(51974223,425351232,16139015,434787,1,'2007-09-15 14:20:52',3310493046,1),(51974226,425351439,16141706,434787,1,'2007-09-15 14:20:52',3310493046,1),(51974229,425351313,16145218,434787,1,'2007-09-15 14:20:52',3310493046,1),(51974231,425351387,16150567,434787,1,'2007-09-15 14:20:53',3310493052,1),(51974233,425351020,16158553,434787,1,'2007-09-15 14:20:53',3310493052,1),(51974236,425350874,16161337,434787,1,'2007-09-15 14:20:53',3310493052,1),(51974239,425350874,16163315,434787,1,'2007-09-15 14:20:53',3310493052,1),(51974242,425351313,16165660,434787,1,'2007-09-15 14:20:53',3310493052,1),(51974244,425352925,16170056,434787,1,'2007-09-15 14:20:53',3310493052,1),(51974247,425355416,16175038,434787,1,'2007-09-15 14:20:53',3310493052,1),(51974249,425356882,16179361,434787,1,'2007-09-15 14:20:53',3310493052,1),(51974251,425357688,16184636,434787,1,'2007-09-15 14:20:54',3310493052,1),(51974253,425357907,16188299,434787,1,'2007-09-15 14:20:54',3310493052,1),(51974256,425357907,16191230,434787,1,'2007-09-15 14:20:54',3310493052,1),(51974258,425357468,16196065,434787,1,'2007-09-15 14:20:54',3310493052,1),(51974261,425356515,16202952,434787,1,'2007-09-15 14:20:54',3310493052,1),(51974264,425356002,16208448,434787,1,'2007-09-15 14:20:54',3310493054,1),(51974266,425355416,16214455,434787,1,'2007-09-15 14:20:54',3310493054,1),(51974275,425354317,16218705,434787,1,'2007-09-15 14:20:55',3310493054,1),(51974278,425352705,16225885,434787,1,'2007-09-15 14:20:55',3310493054,1),(51974279,425351973,16231453,434787,1,'2007-09-15 14:20:55',3310493054,1),(51974281,425351826,16235483,434787,1,'2007-09-15 14:20:55',3310493054,1),(51974284,425351387,16238560,434787,1,'2007-09-15 14:20:55',3310493054,1),(51974286,425350947,16241711,434787,1,'2007-09-15 14:20:55',3310493054,1),(51974289,425350947,16245374,434787,1,'2007-09-15 14:20:55',3310493054,1),(51974291,425351680,16247865,434787,1,'2007-09-15 14:20:56',3310493054,1),(51974292,425352779,16250136,434787,1,'2007-09-15 14:20:56',3310493054,1),(51974293,425354171,16252115,434787,1,'2007-09-15 14:20:56',3310493054,1),(51974296,425356515,16254020,434787,1,'2007-09-15 14:20:56',3310493054,1),(51974298,425357688,16255558,434787,1,'2007-09-15 14:20:57',3310493054,1),(51974300,425358787,16259295,434787,1,'2007-09-15 14:20:57',3310493054,1),(51974301,425359519,16261786,434787,1,'2007-09-15 14:20:57',3310493140,1),(51974305,425360179,16264204,434787,1,'2007-09-15 14:20:57',3310493140,1),(51974308,425361497,16265596,434787,1,'2007-09-15 14:20:57',3310493140,1),(51974309,425362816,16266109,434787,1,'2007-09-15 14:20:57',3310493140,1),(51974313,425364355,16266402,434787,1,'2007-09-15 14:20:58',3310493140,1),(51974316,425366626,16265962,434787,1,'2007-09-15 14:20:58',3310493140,1),(51974319,425368165,16265156,434787,1,'2007-09-15 14:20:58',3310493140,1),(51974321,425370143,16263398,434787,1,'2007-09-15 14:20:58',3310493141,1),(51974323,425371828,16261566,434787,1,'2007-09-15 14:20:58',3310493141,1),(51974326,425373074,16258782,434787,1,'2007-09-15 14:20:59',3310493055,1),(51974328,425373953,16255558,434787,1,'2007-09-15 14:20:59',3310493055,1),(51974331,425375418,16251089,434787,1,'2007-09-15 14:20:59',3310493055,1),(51974334,425376371,16248085,434787,1,'2007-09-15 14:20:59',3310493055,1),(51974337,425378276,16245667,434787,1,'2007-09-15 14:20:59',3310493055,1),(51974339,425380840,16243689,434787,1,'2007-09-15 14:20:59',3310493055,1),(51974341,425383404,16239586,434787,1,'2007-09-15 14:21:00',3310493055,1),(51974345,425383990,16237535,434787,1,'2007-09-15 14:21:00',3310493055,1),(51974349,425384210,16234091,434787,1,'2007-09-15 14:21:00',3310493055,1),(51974353,425384283,16230061,434787,1,'2007-09-15 14:21:00',3310493055,1),(51974357,425384283,16225958,434787,1,'2007-09-15 14:21:00',3310493055,1),(51974360,425384283,16224933,434787,1,'2007-09-15 14:21:00',3310493055,1),(51974363,425383990,16223101,434787,1,'2007-09-15 14:21:00',3310493055,1),(51974365,425384137,16222222,434787,1,'2007-09-15 14:21:01',3310493055,1),(51974368,425384650,16221709,434787,1,'2007-09-15 14:21:01',3310493055,1),(51974371,425385236,16221929,434787,1,'2007-09-15 14:21:01',3310493055,1),(51974373,425385529,16222735,434787,1,'2007-09-15 14:21:01',3310493055,1),(51974374,425385456,16225006,434787,1,'2007-09-15 14:21:01',3310493055,1),(51974376,425385529,16228816,434787,1,'2007-09-15 14:21:02',3310493055,1),(51974378,425385969,16231600,434787,1,'2007-09-15 14:21:02',3310493055,1),(51974383,425387068,16234897,434787,1,'2007-09-15 14:21:02',3310493055,1),(51974385,425387434,16237461,434787,1,'2007-09-15 14:21:02',3310493055,1),(51974388,425387800,16242956,434787,1,'2007-09-15 14:21:02',3310493055,1),(51974391,425387874,16247865,434787,1,'2007-09-15 14:21:02',3310493055,1),(51974394,425387214,16256437,434787,1,'2007-09-15 14:21:02',3310493055,1),(51974395,425387068,16261639,434787,1,'2007-09-15 14:21:03',3310493141,1),(51974397,425387338,16264267,434787,1,'2007-09-15 14:21:03',3310493141,1),(51974400,425387707,16270816,434787,1,'2007-09-15 14:21:03',3310493141,1),(51974402,425387707,16276166,434787,1,'2007-09-15 14:21:03',3310493141,1),(51974404,425387430,16281332,434787,1,'2007-09-15 14:21:03',3310493141,1),(51974405,425387615,16285667,434787,1,'2007-09-15 14:21:03',3310493141,1),(51974408,425387984,16292493,434787,1,'2007-09-15 14:21:04',3310493141,1),(51974411,425388630,16298027,434787,1,'2007-09-15 14:21:04',3310493141,1),(51974414,425389367,16302270,434787,1,'2007-09-15 14:21:04',3310493141,1),(51974416,425390013,16306329,434787,1,'2007-09-15 14:21:04',3310493141,1),(51974419,425390659,16310019,434787,1,'2007-09-15 14:21:04',3310493141,1),(51974422,425390198,16313155,434787,1,'2007-09-15 14:21:04',3310493141,1),(51974424,425389736,16314907,434787,1,'2007-09-15 14:21:04',3310493141,1),(51974428,425388630,16317767,434787,1,'2007-09-15 14:21:05',3310493143,1),(51974430,425387338,16320811,434787,1,'2007-09-15 14:21:05',3310493143,1),(51974432,425386877,16322748,434787,1,'2007-09-15 14:21:05',3310493143,1),(51974436,425386692,16325699,434787,1,'2007-09-15 14:21:05',3310493143,1),(51974439,425387258,16328597,434787,1,'2007-09-15 14:21:05',3310493143,1),(51974442,425388261,16332064,434787,1,'2007-09-15 14:21:06',3310493143,1),(51974445,425388563,16334592,434787,1,'2007-09-15 14:21:06',3310493143,1),(51974446,425388449,16337913,434787,1,'2007-09-15 14:21:06',3310493143,1),(51974451,425388630,16340181,434787,1,'2007-09-15 14:21:06',3310493143,1),(51974452,425388826,16341451,434787,1,'2007-09-15 14:21:06',3310493143,1),(51974454,425390025,16342039,434787,1,'2007-09-15 14:21:06',3310493143,1),(51974455,425391108,16340973,434787,1,'2007-09-15 14:21:07',3310493143,1),(51974456,425391363,16338890,434787,1,'2007-09-15 14:21:07',3310493143,1),(51974458,425391673,16334647,434787,1,'2007-09-15 14:21:07',3310493143,1),(51974462,425392411,16330680,434787,1,'2007-09-15 14:21:07',3310493143,1),(51974466,425393518,16326991,434787,1,'2007-09-15 14:21:07',3310493143,1),(51974469,425394994,16321733,434787,1,'2007-09-15 14:21:08',3310493143,1),(51974472,425395640,16317767,434787,1,'2007-09-15 14:21:08',3310493143,1),(51974475,425395640,16314446,434787,1,'2007-09-15 14:21:08',3310493141,1),(51974478,425395363,16306698,434787,1,'2007-09-15 14:21:08',3310493141,1),(51974481,425389262,16342039,434787,1,'2007-09-15 14:21:08',3310493143,1),(51974484,425390870,16341610,434787,1,'2007-09-15 14:21:09',3310493143,1),(52002189,425104877,15459263,508959,1,'2007-09-24 18:39:54',3310491539,1),(52002192,425109756,15460923,434787,1,'2007-09-15 15:09:48',3310491539,1),(52002196,425111768,15463739,188228,1,'2008-06-16 18:49:29',3310491539,3),(52002198,425108183,15459222,434787,1,'2007-09-15 15:09:48',3310491539,1),(52002202,425106603,15458834,508959,1,'2007-09-24 18:39:54',3310491539,1),(52002204,425098579,15459191,434787,1,'2007-09-15 15:09:49',3310491539,1),(52002206,425101297,15460794,508959,1,'2007-09-24 18:39:54',3310491539,1),(52002209,425104144,15459928,434787,1,'2007-09-15 15:09:49',3310491539,1),(52002211,425105525,15458928,508959,1,'2007-09-24 18:39:54',3310491539,1),(52002212,425106971,15458859,508959,1,'2007-09-24 18:39:54',3310491539,1),(52002214,425109112,15460059,508959,1,'2007-09-24 18:39:54',3310491539,1),(52002216,425110138,15461553,508959,1,'2007-09-24 18:39:54',3310491539,1),(52002219,425110313,15463739,188228,1,'2008-06-16 18:49:01',3310491539,2),(52002220,425107983,15460208,434787,1,'2007-09-15 15:09:50',3310491539,1),(52002222,425107277,15459617,508959,1,'2007-09-24 18:39:54',3310491539,1),(52002223,425105502,15460425,508959,1,'2007-09-24 18:39:54',3310491539,1),(52002226,425104673,15461243,508959,1,'2007-09-24 18:39:54',3310491539,1),(52002229,425099318,15461965,508959,1,'2007-09-24 18:39:54',3310491539,1),(52002231,425102030,15462096,508959,1,'2007-09-24 18:39:54',3310491539,1),(52002235,425067515,15270951,508959,1,'2007-09-24 18:39:54',3310491431,1),(52002238,425067087,15269869,434787,1,'2007-09-15 15:09:52',3310491431,1),(52002241,425067153,15264746,508959,1,'2007-09-24 18:39:54',3310491431,1),(52002244,425065171,15254581,508959,1,'2007-09-24 18:39:54',3310491431,1),(52002247,425061389,15248466,434787,1,'2007-09-15 15:09:53',3310491431,1),(52002248,425057445,15247192,508959,1,'2007-09-24 18:39:54',3310491431,1),(52002251,425060890,15250852,508959,1,'2007-09-24 18:39:54',3310491431,1),(52002253,425062718,15253714,434787,1,'2007-09-15 15:09:54',3310491431,1),(52002256,425040750,15200351,508959,1,'2007-09-24 18:39:54',3310491429,1),(52002258,425039231,15196247,508959,1,'2007-09-24 18:39:54',3310491428,1),(52002259,425038923,15193100,508959,1,'2007-09-24 18:39:54',3310491428,1),(52002261,425039811,15170198,508959,1,'2007-09-24 18:39:54',3310491428,1),(52002264,425037770,15165326,434787,1,'2007-09-15 15:09:55',3310491428,1),(52002266,425038411,15169701,508959,1,'2007-09-24 18:39:54',3310491428,1),(52002269,425036006,15160845,434787,1,'2007-09-15 15:09:55',3310491406,1),(52002272,425038104,15161314,434787,1,'2007-09-15 15:09:56',3310491406,1),(52002275,425034794,15156277,508959,1,'2007-09-24 18:39:54',3310491406,1),(52002278,425032742,15156139,508959,1,'2007-09-24 18:39:54',3310491406,1),(52002281,424978626,15094146,508959,1,'2007-09-24 18:39:54',3310491400,1),(52009103,424727970,14930747,508959,1,'2007-09-24 18:39:54',3310490815,1),(52009105,424729083,14930328,508959,1,'2007-09-24 18:39:54',3310490815,1),(52009107,424726445,14930313,508959,1,'2007-09-24 18:39:54',3310490815,1),(52009108,424721680,14922054,434787,1,'2007-09-15 15:24:23',3310490815,1),(52009109,424723033,14923441,434787,1,'2007-09-15 15:24:23',3310490815,1),(52009111,424724285,14924422,434787,1,'2007-09-15 15:24:23',3310490815,1),(52009114,424725333,14924997,434787,1,'2007-09-15 15:24:24',3310490815,1),(52009117,424726822,14925099,434787,1,'2007-09-15 15:24:24',3310490815,1),(52009118,424727769,14924794,434787,1,'2007-09-15 15:24:24',3310490815,1),(52009120,424728683,14923644,434787,1,'2007-09-15 15:24:24',3310490815,1),(52009122,424730002,14922765,434787,1,'2007-09-15 15:24:24',3310490815,1),(52009124,424731423,14921783,434787,1,'2007-09-15 15:24:25',3310490815,1),(52009126,424732693,14921298,434787,1,'2007-09-15 15:24:25',3310490815,1),(52009127,424735483,14922359,434787,1,'2007-09-15 15:24:25',3310490815,1),(52009129,424736510,14922913,439281,1,'2007-09-16 00:57:34',3310490815,1),(52009130,424757255,14866933,434787,1,'2007-09-15 15:24:26',3310490856,1),(52009134,424758499,14871947,434787,1,'2007-09-15 15:24:26',3310490856,1),(52009137,424759782,14877971,434787,1,'2007-09-15 15:24:26',3310490856,1),(52009140,424760637,14882402,434787,1,'2007-09-15 15:24:26',3310490856,1),(52009143,424762152,14889670,434787,1,'2007-09-15 15:24:27',3310490858,1),(52009144,424763085,14893635,434787,1,'2007-09-15 15:24:27',3310490858,1),(52009147,424763707,14896472,434787,1,'2007-09-15 15:24:27',3310490858,1),(52009150,424764096,14898843,434787,1,'2007-09-15 15:24:27',3310490858,1),(52009151,424763979,14902691,434787,1,'2007-09-15 15:24:28',3310490858,1),(52009154,424763901,14905372,434787,1,'2007-09-15 15:24:28',3310490858,1),(52009156,424763921,14906675,439281,1,'2007-09-16 00:57:34',3310490858,1),(52009157,424767930,14870633,434787,1,'2007-09-15 15:24:28',3310490857,1),(52009159,424759333,14874206,434787,1,'2007-09-15 15:24:28',3310490856,1),(52009161,424761630,14882458,434787,1,'2007-09-15 15:24:29',3310490856,1),(52009164,424770177,14878581,434787,1,'2007-09-15 15:24:29',3310490857,1),(52009168,424759474,14886019,434787,1,'2007-09-15 15:24:29',3310490856,1),(52009171,424758852,14886712,370566,1,'2008-05-09 02:14:21',3310490858,2),(52009174,424758881,14887758,434787,1,'2007-09-15 15:24:29',3310490858,1),(52009176,424758770,14890608,434787,1,'2007-09-15 15:24:29',3310490858,1),(52009179,424758511,14893198,434787,1,'2007-09-15 15:24:30',3310490858,1),(52009182,424758252,14895270,434787,1,'2007-09-15 15:24:30',3310490858,1),(52009184,424757475,14896047,434787,1,'2007-09-15 15:24:30',3310490858,1),(52009186,424755884,14896528,434787,1,'2007-09-15 15:24:30',3310490858,1),(52009189,424750851,14898601,434787,1,'2007-09-15 15:24:30',3310490858,1),(52009192,424747891,14900044,434787,1,'2007-09-15 15:24:30',3310490858,1),(52009194,424746226,14900821,434787,1,'2007-09-15 15:24:31',3310490858,1),(52009196,424743191,14903411,434787,1,'2007-09-15 15:24:31',3310490858,1),(52009197,424761317,14885508,434787,1,'2007-09-15 15:24:31',3310490856,1),(52011225,424539336,14857205,434787,1,'2007-09-15 15:27:57',3310490792,1),(52011227,424530186,14853952,508959,1,'2007-09-24 18:39:54',3310490792,1),(52011231,424542623,14857218,508959,1,'2007-09-24 18:39:54',3310490792,1),(52011234,424535770,14856367,434787,1,'2007-09-15 15:27:58',3310490792,1),(52011238,424525709,14851274,434787,1,'2007-09-15 15:27:58',3310490792,1),(52011242,424543885,14858714,508959,1,'2007-09-24 18:39:54',3310490792,1),(52011244,424540853,14858477,508959,1,'2007-09-24 18:39:54',3310490792,1),(52011249,424537160,14857946,508959,1,'2007-09-24 18:39:54',3310490792,1),(52011253,424533176,14856682,508959,1,'2007-09-24 18:39:54',3310490792,1),(52011256,424529142,14854856,508959,1,'2007-09-24 18:39:54',3310490792,1),(52011259,424525949,14853411,508959,1,'2007-09-24 18:39:54',3310490792,1),(52031003,425116007,15485111,188228,1,'2008-06-16 18:50:28',3310491539,2),(52031013,425116830,15488286,188228,1,'2008-06-16 18:52:01',3310491539,3),(52031030,425117716,15492664,188228,1,'2008-06-16 18:52:01',3310491545,2),(52031034,425118665,15495239,188228,1,'2008-06-16 18:52:01',3310491545,2),(52031036,425119595,15497880,434787,1,'2007-09-15 16:14:23',3310491545,1),(52031039,425121516,15500056,508959,1,'2007-09-24 18:39:54',3310491545,1),(52031041,425122962,15501502,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031043,425126336,15503109,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031046,425129454,15505198,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031050,425130578,15508154,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031054,425131349,15512107,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031056,425132249,15516060,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031059,425133053,15518245,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031076,425133817,15520466,434787,1,'2007-09-15 16:14:27',3310491548,1),(52031077,425134735,15522628,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031080,425135919,15523339,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031082,425136956,15524228,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031084,425137578,15525205,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031086,425139385,15527959,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031089,425141132,15529410,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031092,425141783,15529707,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031095,425142879,15529262,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031099,425143827,15528285,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031100,425145244,15528216,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031105,425147203,15528552,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031109,425148891,15529322,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031114,425150846,15530714,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031117,425152001,15533172,434787,1,'2007-09-15 16:14:31',3310491549,1),(52031121,425153067,15535808,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031125,425153837,15537792,434787,1,'2007-09-15 16:14:32',3310491549,1),(52031129,425154607,15538503,434787,1,'2007-09-15 16:14:32',3310491549,1),(52031131,425155999,15538947,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031136,425160086,15538858,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031141,425161967,15538663,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031147,425165787,15534984,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031151,425166542,15534984,434787,1,'2007-09-15 16:14:33',3310491549,1),(52031153,425167485,15535928,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031156,425173569,15541021,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031158,425178899,15545832,508959,1,'2007-09-24 18:39:54',3310491592,1),(52031164,425183521,15550171,508959,1,'2007-09-24 18:39:54',3310491594,1),(52031171,425185974,15552058,508959,1,'2007-09-24 18:39:54',3310491594,1),(52031174,425188049,15555218,508959,1,'2007-09-24 18:39:54',3310491594,1),(52031178,425190266,15560595,508959,1,'2007-09-24 18:39:54',3310491594,1),(52031186,425192577,15564321,434787,1,'2007-09-15 16:14:35',3310491594,1),(52031190,425195925,15567245,508959,1,'2007-09-24 18:39:54',3310491594,1),(52031198,425199651,15568848,508959,1,'2007-09-24 18:39:54',3310491594,1),(52031205,425203094,15569697,508959,1,'2007-09-24 18:39:54',3310491594,1),(52031212,425205547,15570924,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031218,425207622,15573423,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031221,425209414,15574414,434787,1,'2007-09-15 16:14:38',3310491595,1),(52031224,425211537,15575593,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031227,425213562,15576830,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031232,425215518,15579764,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031235,425216876,15583458,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031240,425217908,15586501,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031244,425218778,15588837,434787,1,'2007-09-15 16:14:39',3310491595,1),(52031247,425219538,15590522,434787,1,'2007-09-15 16:14:39',3310491595,1),(52031250,425221223,15592206,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031255,425223016,15593945,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031260,425224548,15596343,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031262,425226557,15601096,434787,1,'2007-09-15 16:14:40',3310491617,1),(52031267,425228321,15606142,434787,1,'2007-09-15 16:14:40',3310491617,1),(52031272,425229654,15608318,508959,1,'2007-09-24 18:39:54',3310491617,1),(52031275,425231476,15610199,508959,1,'2007-09-24 18:39:54',3310491617,1),(52031281,425235298,15612374,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031285,425237062,15613609,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031290,425238296,15616137,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031295,425239707,15618548,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031299,425242000,15620840,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031307,425245528,15623251,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031309,425249114,15625309,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031314,425251877,15627778,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031320,425253641,15630424,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031325,425254641,15633246,434787,1,'2007-09-15 16:14:43',3310491620,1),(52031329,425255111,15636715,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031335,425254699,15641594,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031340,425253641,15645651,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031346,425253406,15647826,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031351,425253773,15649696,188228,1,'2008-06-16 19:33:39',3310491620,2),(52031355,425254848,15653130,188228,1,'2008-06-16 19:33:39',3310491620,2),(52031357,425256176,15656563,188228,1,'2008-06-16 19:33:39',3310491622,2),(52031361,425259023,15662056,188228,1,'2008-06-16 19:34:11',3310491622,2),(52031364,425260731,15664459,188228,1,'2008-06-16 19:34:30',3310491623,2),(52031367,425262695,15666464,434787,1,'2007-09-15 16:14:45',3310491623,1),(52031369,425264988,15667522,508959,1,'2007-09-24 18:39:54',3310491623,1),(52031373,425268281,15668522,434787,1,'2007-09-15 16:14:45',3310491623,1),(52031381,425271044,15669991,508959,1,'2007-09-24 18:39:54',3310491623,1),(52031384,425272337,15672696,508959,1,'2007-09-24 18:39:54',3310491623,1),(52031410,425273807,15678046,508959,1,'2007-09-24 18:39:54',3310491623,1),(52031414,425274572,15683631,508959,1,'2007-09-24 18:39:54',3310491623,1),(52031418,425275924,15686630,508959,1,'2007-09-24 18:39:54',3310491623,1),(52031424,425277746,15688864,508959,1,'2007-09-24 18:39:54',3310491623,1),(52031426,425280333,15689687,508959,1,'2007-09-24 18:39:54',3310491623,1),(52031429,425284037,15689687,508959,1,'2007-09-24 18:39:54',3310491623,1),(52031433,425286624,15689570,508959,1,'2007-09-24 18:39:54',3310491623,1),(52031438,425289623,15689687,508959,1,'2007-09-24 18:39:54',3310491634,1),(52031441,425290975,15690687,508959,1,'2007-09-24 18:39:54',3310491634,1),(52031446,425291915,15692803,508959,1,'2007-09-24 18:39:54',3310491634,1),(52031449,425292739,15696037,508959,1,'2007-09-24 18:39:54',3310491634,1),(52031456,425294326,15698800,508959,1,'2007-09-24 18:39:54',3310491634,1),(52031461,425296972,15702916,508959,1,'2007-09-24 18:39:54',3310491634,1),(52031464,425300264,15706032,508959,1,'2007-09-24 18:39:54',3310491634,1),(52031467,425304380,15708618,508959,1,'2007-09-24 18:39:54',3310491634,1),(52031471,425307084,15710500,508959,1,'2007-09-24 18:39:54',3310491634,1),(52031477,425308965,15712616,434787,1,'2007-09-15 16:14:50',3310491640,1),(52031481,425311376,15716320,508959,1,'2007-09-24 18:39:54',3310491640,1),(52031483,425314492,15721553,434787,1,'2007-09-15 16:14:51',3310491640,1),(52031486,425316726,15724963,508959,1,'2007-09-24 18:39:54',3310491641,1),(52031491,425319019,15727079,508959,1,'2007-09-24 18:39:54',3310491641,1),(52031494,425321253,15729196,434787,1,'2007-09-15 16:14:51',3310491641,1),(52031498,425323605,15731548,508959,1,'2007-09-24 18:39:54',3310491641,1),(52031500,425325075,15733723,508959,1,'2007-09-24 18:39:54',3310491641,1),(52031504,425325780,15734899,508959,1,'2007-09-24 18:39:54',3310491641,1),(52031507,425326368,15736545,434787,1,'2007-09-15 16:14:52',3310491641,1),(52031512,425326074,15739661,508959,1,'2007-09-24 18:39:54',3310491641,1),(52031514,425326309,15744659,434787,1,'2007-09-15 16:14:52',3310491641,1),(52031517,425327074,15748480,508959,1,'2007-09-24 18:39:54',3310491641,1),(52031521,425328014,15755065,434787,1,'2007-09-15 16:14:52',3310491641,1),(52031523,425328661,15759357,508959,1,'2007-09-24 18:39:54',3310491641,1),(52031527,425329131,15764825,508959,1,'2007-09-24 18:39:54',3310491641,1),(52031529,425330307,15770763,508959,1,'2007-09-24 18:39:54',3310491643,1),(52031532,425331718,15773761,508959,1,'2007-09-24 18:39:54',3310491643,1),(52031535,425332659,15776054,508959,1,'2007-09-24 18:39:54',3310491643,1),(52031540,425334188,15778994,508959,1,'2007-09-24 18:39:54',3310491643,1),(52031545,425334834,15781522,434787,1,'2007-09-15 16:14:54',3310491643,1),(52031550,425335716,15786578,508959,1,'2007-09-24 18:39:54',3310491643,1),(52031552,425335834,15790282,508959,1,'2007-09-24 18:39:54',3310491643,1),(52031554,425336363,15793692,434787,1,'2007-09-15 16:14:54',3310491643,1),(52031560,425336598,15796690,434787,1,'2007-09-15 16:14:54',3310491643,1),(52031562,425337010,15798748,434787,1,'2007-09-15 16:14:54',3310491643,1),(52031567,425338127,15800630,434787,1,'2007-09-15 16:14:55',3310491643,1),(52031572,425339714,15802158,508959,1,'2007-09-24 18:39:54',3310491643,1),(52031576,425343359,15803922,508959,1,'2007-09-24 18:39:54',3310491646,1),(52031580,425346534,15805627,508959,1,'2007-09-24 18:39:54',3310491646,1),(52031581,425349709,15807450,508959,1,'2007-09-24 18:39:54',3310491646,1),(52031587,425352590,15809978,434787,1,'2007-09-15 16:14:56',3310491646,1),(52031590,425357646,15815504,508959,1,'2007-09-24 18:39:54',3310491646,1),(52031592,425361468,15819267,508959,1,'2007-09-24 18:39:54',3310491646,1),(52031595,425365348,15823676,508959,1,'2007-09-24 18:39:54',3310493012,1),(52031600,425369169,15827204,434787,1,'2007-09-15 16:14:57',3310493012,1),(52031604,425373050,15830261,434787,1,'2007-09-15 16:14:57',3310493013,1),(52031608,425375225,15832143,508959,1,'2007-09-24 18:39:54',3310493013,1),(52031611,425376695,15834494,508959,1,'2007-09-24 18:39:54',3310493013,1),(52031614,425377048,15836434,508959,1,'2007-09-24 18:39:54',3310493013,1),(52031616,425377048,15838610,508959,1,'2007-09-24 18:39:54',3310493013,1),(52031617,425377048,15840668,508959,1,'2007-09-24 18:39:54',3310493013,1),(52031620,425376813,15842608,508959,1,'2007-09-24 18:39:54',3310493013,1),(52031621,425375931,15844842,508959,1,'2007-09-24 18:39:54',3310493013,1),(52031626,425375225,15846547,508959,1,'2007-09-24 18:39:54',3310493013,1),(52031627,425375108,15848605,508959,1,'2007-09-24 18:39:54',3310493013,1),(52031631,425375049,15851133,508959,1,'2007-09-24 18:39:54',3310493013,1),(52031634,425375872,15852661,434787,1,'2007-09-15 16:14:59',3310493013,1),(52031636,425376813,15854543,508959,1,'2007-09-24 18:39:54',3310493013,1),(52031642,425377459,15856718,434787,1,'2007-09-15 16:15:00',3310493013,1),(52031645,425377577,15858305,508959,1,'2007-09-24 18:39:54',3310493013,1),(52031648,425377988,15860716,508959,1,'2007-09-24 18:39:54',3310493013,1),(52031652,425378576,15862186,508959,1,'2007-09-24 18:39:54',3310493013,1),(52031656,425379929,15864361,508959,1,'2007-09-24 18:39:54',3310493013,1),(52031658,425380693,15867712,508959,1,'2007-09-24 18:39:54',3310493013,1),(52031660,425381046,15870828,434787,1,'2007-09-15 16:15:02',3310493013,1),(52031665,425381398,15872945,434787,1,'2007-09-15 16:15:02',3310493013,1),(52031668,425382222,15874121,508959,1,'2007-09-24 18:39:54',3310493013,1),(52031671,425383927,15875885,508959,1,'2007-09-24 18:39:54',3310493015,1),(52031676,425385808,15878119,508959,1,'2007-09-24 18:39:54',3310493015,1),(52031678,425387101,15881235,508959,1,'2007-09-24 18:39:54',3310493015,1),(52031681,425387572,15883586,508959,1,'2007-09-24 18:39:54',3310493015,1),(52031686,425387866,15887584,508959,1,'2007-09-24 18:39:54',3310493015,1),(52031688,425387983,15893405,508959,1,'2007-09-24 18:39:54',3310493015,1),(52031691,425388454,15895110,508959,1,'2007-09-24 18:39:54',3310493015,1),(52031695,425389982,15898520,434787,1,'2007-09-15 16:15:04',3310493015,1),(52031700,425392158,15901695,508959,1,'2007-09-24 18:39:54',3310493015,1),(52031702,425395097,15903929,434787,1,'2007-09-15 16:15:04',3310493015,1),(52031705,425400036,15906045,434787,1,'2007-09-15 16:15:05',3310503938,1),(52031709,425404622,15907221,508959,1,'2007-09-24 18:39:54',3310503938,1),(52031712,425407914,15907045,508959,1,'2007-09-24 18:39:54',3310503938,1),(52031715,425411736,15906281,508959,1,'2007-09-24 18:39:54',3310503938,1),(52031717,425414381,15905575,508959,1,'2007-09-24 18:39:54',3310503938,1),(52031720,425416263,15905163,508959,1,'2007-09-24 18:39:54',3310503938,1),(52031723,425417791,15906104,508959,1,'2007-09-24 18:39:54',3310503938,1),(52031726,425117209,15484939,188228,1,'2008-06-16 18:50:28',3310491539,2),(52031730,425118412,15489745,188228,1,'2008-06-16 18:50:28',3310491539,3),(52031732,425119108,15493007,188228,1,'2008-06-16 18:52:01',3310491545,3),(52031736,425119740,15494380,188228,1,'2008-06-16 18:52:01',3310491545,3),(52031739,425120876,15497601,508959,1,'2007-09-24 18:39:54',3310491545,1),(52031742,425124337,15500196,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031744,425126729,15501621,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031746,425129070,15502995,434787,1,'2007-09-15 16:15:08',3310491548,1),(52031747,425130495,15504726,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031749,425131310,15507372,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031751,425132277,15512157,434787,1,'2007-09-15 16:15:09',3310491548,1),(52031756,425133142,15515567,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031758,425134262,15519078,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031761,425135279,15521318,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031764,425137213,15522946,434787,1,'2007-09-15 16:15:09',3310491548,1),(52031767,425138333,15524626,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031771,425140725,15527476,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031774,425141590,15528290,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031777,425142965,15528138,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031782,425143932,15527527,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031785,425145662,15527476,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031789,425147901,15527985,508959,1,'2007-09-24 18:39:54',3310491548,1),(52031794,425150039,15529054,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031798,425151871,15530428,434787,1,'2007-09-15 16:15:12',3310491549,1),(52031803,425152838,15532158,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031805,425154009,15535467,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031809,425154925,15537248,434787,1,'2007-09-15 16:15:13',3310491549,1),(52031811,425155994,15537910,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031813,425157877,15537808,434787,1,'2007-09-15 16:15:13',3310491549,1),(52031815,425160523,15537553,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031821,425161694,15536841,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031823,425162661,15535823,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031827,425164188,15533940,434787,1,'2007-09-15 16:15:14',3310491549,1),(52031830,425165511,15533431,434787,1,'2007-09-15 16:15:14',3310491549,1),(52031832,425166580,15533380,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031834,425168005,15534500,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031838,425174520,15540658,508959,1,'2007-09-24 18:39:54',3310491549,1),(52031840,425179762,15544831,508959,1,'2007-09-24 18:39:54',3310491592,1),(52031844,425184037,15548343,508959,1,'2007-09-24 18:39:54',3310491594,1),(52031847,425186226,15550481,508959,1,'2007-09-24 18:39:54',3310491594,1),(52031850,425187600,15553127,508959,1,'2007-09-24 18:39:54',3310491594,1),(52031855,425190348,15558522,508959,1,'2007-09-24 18:39:54',3310491594,1),(52031858,425191773,15561525,508959,1,'2007-09-24 18:39:54',3310491594,1),(52031861,425193758,15563764,508959,1,'2007-09-24 18:39:54',3310491594,1),(52031865,425196099,15565698,508959,1,'2007-09-24 18:39:54',3310491594,1),(52031866,425198949,15567174,434787,1,'2007-09-15 16:15:17',3310491594,1),(52031868,425201901,15567887,508959,1,'2007-09-24 18:39:54',3310491594,1),(52031871,425204395,15568752,508959,1,'2007-09-24 18:39:54',3310491594,1),(52031872,425207551,15571653,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031874,425208467,15572722,434787,1,'2007-09-15 16:15:17',3310491595,1),(52031876,425209994,15573180,434787,1,'2007-09-15 16:15:17',3310491595,1),(52031881,425212284,15573943,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031884,425213913,15574859,434787,1,'2007-09-15 16:15:18',3310491595,1),(52031886,425215389,15576641,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031888,425216915,15579694,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031889,425218442,15584937,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031893,425219562,15588347,434787,1,'2007-09-15 16:15:19',3310491595,1),(52031894,425220274,15589823,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031899,425221394,15591044,434787,1,'2007-09-15 16:15:19',3310491595,1),(52031901,425223226,15592571,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031906,425224753,15594861,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031908,425226331,15597864,434787,1,'2007-09-15 16:15:19',3310491595,1),(52031911,425227247,15600562,508959,1,'2007-09-24 18:39:54',3310491595,1),(52031913,425229232,15605549,434787,1,'2007-09-15 16:15:20',3310491617,1),(52031915,425230606,15607432,434787,1,'2007-09-15 16:15:20',3310491617,1),(52031919,425232082,15609163,508959,1,'2007-09-24 18:39:54',3310491617,1),(52031921,425235645,15611250,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031925,425237477,15612522,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031927,425239207,15615626,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031930,425240378,15617764,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031933,425242567,15619596,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031936,425245926,15621683,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031938,425249641,15623872,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031943,425252491,15626823,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031946,425254680,15629775,434787,1,'2007-09-15 16:15:22',3310491620,1),(52031948,425255596,15633033,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031953,425256105,15636697,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031956,425255799,15641685,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031958,425254883,15645756,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031962,425254578,15647996,508959,1,'2007-09-24 18:39:54',3310491620,1),(52031966,425254680,15649624,434787,1,'2007-09-15 16:15:23',3310491620,1),(52031968,425255494,15652627,434787,1,'2007-09-15 16:15:24',3310491620,1),(52031973,425257021,15656292,508959,1,'2007-09-24 18:39:54',3310491622,1),(52031976,425259719,15661112,188228,1,'2008-06-16 19:34:11',3310491622,2),(52031980,425261500,15663570,508959,1,'2007-09-24 18:39:54',3310491623,1),(52031984,425263230,15665249,508959,1,'2007-09-24 18:39:54',3310491623,1),(52031987,425265266,15666165,508959,1,'2007-09-24 18:39:54',3310491623,1),(52031990,425268421,15666522,434787,1,'2007-09-15 16:15:25',3310491623,1),(52031992,425271679,15667998,434787,1,'2007-09-15 16:15:25',3310491623,1),(52031995,425273613,15671306,508959,1,'2007-09-24 18:39:54',3310491623,1),(52031998,425274783,15677668,434787,1,'2007-09-15 16:15:25',3310491623,1),(52032000,425275292,15683368,434787,1,'2007-09-15 16:15:25',3310491623,1),(52032003,425276310,15686167,434787,1,'2007-09-15 16:15:26',3310491623,1),(52032007,425277888,15688203,508959,1,'2007-09-24 18:39:54',3310491623,1),(52032010,425280280,15688458,508959,1,'2007-09-24 18:39:54',3310491623,1),(52032012,425284046,15688203,508959,1,'2007-09-24 18:39:54',3310491623,1),(52032017,425286642,15688152,508959,1,'2007-09-24 18:39:54',3310491623,1),(52032018,425289848,15688661,508959,1,'2007-09-24 18:39:54',3310491634,1),(52032021,425291884,15689628,508959,1,'2007-09-24 18:39:54',3310491634,1),(52032022,425292647,15691664,434787,1,'2007-09-15 16:15:27',3310491634,1),(52032026,425293716,15695430,434787,1,'2007-09-15 16:15:27',3310491634,1),(52032029,425295192,15698026,434787,1,'2007-09-15 16:15:27',3310491634,1),(52032033,425297941,15702047,434787,1,'2007-09-15 16:15:28',3310491634,1),(52032035,425300791,15705100,508959,1,'2007-09-24 18:39:54',3310491634,1),(52032039,425304659,15707340,508959,1,'2007-09-24 18:39:54',3310491634,1),(52032041,425307560,15709528,508959,1,'2007-09-24 18:39:54',3310491634,1),(52032044,425309443,15712175,508959,1,'2007-09-24 18:39:54',3310491640,1),(52032047,425312039,15715788,508959,1,'2007-09-24 18:39:54',3310491640,1),(52032048,425314940,15720980,434787,1,'2007-09-15 16:15:29',3310491641,1),(52032051,425317281,15723982,508959,1,'2007-09-24 18:39:54',3310491641,1),(52032054,425319673,15726324,508959,1,'2007-09-24 18:39:54',3310491641,1),(52032057,425321912,15728410,508959,1,'2007-09-24 18:39:54',3310491641,1),(52032060,425326136,15732380,508959,1,'2007-09-24 18:39:54',3310491641,1),(52032064,425326747,15734263,434787,1,'2007-09-15 16:15:30',3310491641,1),(52032067,425327307,15736401,508959,1,'2007-09-24 18:39:54',3310491641,1),(52032070,425327409,15739963,434787,1,'2007-09-15 16:15:30',3310491641,1),(52032071,425327918,15748158,434787,1,'2007-09-15 16:15:30',3310491641,1),(52032075,425328834,15754825,508959,1,'2007-09-24 18:39:54',3310491641,1),(52032076,425329496,15759456,508959,1,'2007-09-24 18:39:54',3310491641,1),(52032078,425330005,15764749,508959,1,'2007-09-24 18:39:54',3310491641,1),(52032081,425330972,15770195,434787,1,'2007-09-15 16:15:31',3310491643,1),(52032085,425332447,15772944,508959,1,'2007-09-24 18:39:54',3310491643,1),(52032087,425333465,15774776,508959,1,'2007-09-24 18:39:54',3310491643,1),(52032090,425334941,15778186,434787,1,'2007-09-15 16:15:32',3310491643,1),(52032092,425335756,15781290,434787,1,'2007-09-15 16:15:32',3310491643,1),(52032093,425336672,15786583,508959,1,'2007-09-24 18:39:54',3310491643,1),(52032098,425336926,15790095,508959,1,'2007-09-24 18:39:54',3310491643,1),(52032100,425337435,15793811,508959,1,'2007-09-24 18:39:54',3310491643,1),(52032103,425337537,15796610,508959,1,'2007-09-24 18:39:54',3310491643,1),(52032107,425338097,15798544,508959,1,'2007-09-24 18:39:54',3310491643,1);
INSERT INTO `current_nodes` VALUES (52032109,425338708,15799816,508959,1,'2007-09-24 18:39:54',3310491643,1),(52032112,425340234,15800987,508959,1,'2007-09-24 18:39:54',3310491643,1),(52032113,425343441,15802514,434787,1,'2007-09-15 16:15:33',3310491646,1),(52032116,425346851,15804193,434787,1,'2007-09-15 16:15:34',3310491646,1),(52032119,425349752,15805822,434787,1,'2007-09-15 16:15:34',3310491646,1),(52032122,425352449,15808265,434787,1,'2007-09-15 16:15:34',3310491646,1),(52032125,425354638,15810453,508959,1,'2007-09-24 18:39:54',3310491646,1),(52032127,425359167,15815085,508959,1,'2007-09-24 18:39:54',3310491646,1),(52032130,425363239,15819462,434787,1,'2007-09-15 16:15:35',3310491646,1),(52032133,425367565,15823533,508959,1,'2007-09-24 18:39:54',3310493012,1),(52032135,425370873,15826587,434787,1,'2007-09-15 16:15:35',3310493013,1),(52032137,425373673,15828725,508959,1,'2007-09-24 18:39:54',3310493013,1),(52032141,425376319,15831320,434787,1,'2007-09-15 16:15:36',3310493013,1),(52032145,425377642,15833153,508959,1,'2007-09-24 18:39:54',3310493013,1),(52032147,425378100,15836308,508959,1,'2007-09-24 18:39:54',3310493013,1),(52032150,425378050,15840685,434787,1,'2007-09-15 16:15:36',3310493013,1),(52032153,425377744,15843077,508959,1,'2007-09-24 18:39:54',3310493013,1),(52032158,425376828,15845775,508959,1,'2007-09-24 18:39:54',3310493013,1),(52032160,425376116,15847861,508959,1,'2007-09-24 18:39:54',3310493013,1),(52032162,425375810,15849643,434787,1,'2007-09-15 16:15:37',3310493013,1),(52032165,425376116,15851628,508959,1,'2007-09-24 18:39:54',3310493013,1),(52032168,425377083,15853154,508959,1,'2007-09-24 18:39:54',3310493013,1),(52032171,425378151,15855648,508959,1,'2007-09-24 18:39:54',3310493013,1),(52032174,425378660,15859007,508959,1,'2007-09-24 18:39:54',3310493013,1),(52032176,425379322,15861450,508959,1,'2007-09-24 18:39:54',3310493013,1),(52032179,425380594,15863028,434787,1,'2007-09-15 16:15:39',3310493013,1),(52032182,425381256,15864504,434787,1,'2007-09-15 16:15:39',3310493013,1),(52032183,425381867,15866184,508959,1,'2007-09-24 18:39:54',3310493013,1),(52032186,425382121,15867507,434787,1,'2007-09-15 16:15:39',3310493013,1),(52032187,425382070,15869899,508959,1,'2007-09-24 18:39:54',3310493013,1),(52032190,425382477,15872291,434787,1,'2007-09-15 16:15:40',3310493013,1),(52032192,425383750,15874378,508959,1,'2007-09-24 18:39:54',3310493013,1),(52032195,425385124,15875396,508959,1,'2007-09-24 18:39:54',3310493013,1),(52032197,425387007,15877482,508959,1,'2007-09-24 18:39:54',3310493015,1),(52032200,425387974,15879518,508959,1,'2007-09-24 18:39:54',3310493015,1),(52032204,425388636,15883488,508959,1,'2007-09-24 18:39:54',3310493015,1),(52032205,425389094,15887407,434787,1,'2007-09-15 16:15:41',3310493015,1),(52032208,425389145,15892954,434787,1,'2007-09-15 16:15:42',3310493015,1),(52032211,425389552,15894532,508959,1,'2007-09-24 18:39:54',3310493015,1),(52032212,425390824,15898044,434787,1,'2007-09-15 16:15:42',3310493015,1),(52032216,425392656,15900843,508959,1,'2007-09-24 18:39:54',3310493015,1),(52032219,425395303,15902726,508959,1,'2007-09-24 18:39:54',3310493015,1),(52032222,425400291,15904609,508959,1,'2007-09-24 18:39:54',3310503938,1),(52032225,425404515,15905424,508959,1,'2007-09-24 18:39:54',3310503938,1),(52032228,425407518,15905373,434787,1,'2007-09-15 16:15:43',3310503938,1),(52032233,425411233,15905067,508959,1,'2007-09-24 18:39:54',3310503938,1),(52032238,425414134,15904100,434787,1,'2007-09-15 16:15:43',3310503938,1),(52032241,425416374,15903795,434787,1,'2007-09-15 16:15:43',3310503938,1),(52032243,425418186,15904585,434787,1,'2007-09-15 16:15:43',3310503938,1),(52032246,425419679,15905500,508959,1,'2007-09-24 18:39:54',3310503938,1),(52032249,425419359,15906380,434787,1,'2007-09-15 16:15:44',3310503938,1),(52032250,425419510,15905965,508959,1,'2007-09-24 18:39:54',3310503938,1),(52163550,425556412,15336966,72964,1,'2008-08-05 20:37:35',3310502459,4),(52163556,425558372,15343575,72964,1,'2008-08-05 20:37:36',3310502459,4),(52163563,425559826,15346579,72964,1,'2008-08-05 20:37:36',3310502459,4),(52163574,425560910,15347910,72964,1,'2008-08-05 20:37:36',3310502459,3),(52163581,425562312,15347865,72964,1,'2008-08-05 20:37:36',3310502462,3),(52163588,425563036,15347322,435967,1,'2007-09-15 21:25:22',3310502462,1),(52163595,425563579,15346191,435967,1,'2007-09-15 21:25:23',3310502462,1),(52163602,425563669,15344834,435967,1,'2007-09-15 21:25:24',3310502462,1),(52163609,425563986,15343296,435967,1,'2007-09-15 21:25:24',3310502462,1),(52163613,425564710,15340718,435967,1,'2007-09-15 21:25:24',3310502462,1),(52163621,425566066,15337959,435967,1,'2007-09-15 21:25:25',3310502462,1),(52163631,425566790,15335561,435967,1,'2007-09-15 21:25:27',3310502462,1),(52163644,425566790,15333119,435967,1,'2007-09-15 21:25:29',3310502462,1),(52163664,425566428,15329229,435967,1,'2007-09-15 21:25:33',3310502462,1),(52164958,425566971,15327691,538211,1,'2007-09-30 15:36:21',3310502462,1),(52166749,425568147,15326605,198831,1,'2008-04-20 16:36:30',3310502462,2),(52166950,425568578,15326123,2836771,1,'2009-10-13 18:46:13',3310502460,2),(52166959,426369093,14912041,373445,1,'2008-05-09 19:04:04',3310503087,2),(52166976,426368531,14916137,373445,1,'2008-05-09 19:04:04',3310503087,2),(52166980,426368772,14921678,373445,1,'2008-05-09 19:04:04',3310503087,2),(52167010,426369174,14925051,373445,1,'2008-05-09 19:04:04',3310503087,2),(52167017,426368210,14927058,373445,1,'2008-05-09 19:04:04',3310503087,2),(52167025,426368772,14929146,373445,1,'2008-05-09 19:04:04',3310503087,2),(52167030,426368692,14932198,373445,1,'2008-05-09 19:04:04',3310503087,2),(52167039,426367969,14934527,373445,1,'2008-05-09 19:04:04',3310503087,2),(52167045,426366283,14936534,373445,1,'2008-05-09 19:04:04',3310503087,2),(52167049,426364998,14937819,373445,1,'2008-05-09 19:04:04',3310503087,2),(52167052,426364114,14939907,373445,1,'2008-05-09 19:04:04',3310503087,2),(52167062,426362910,14942477,373445,1,'2008-05-09 19:04:04',3310503429,2),(52167066,426361785,14943360,373445,1,'2008-05-09 19:04:04',3310503429,2),(52167070,426360179,14944324,373445,1,'2008-05-09 19:04:04',3310503429,2),(52167076,426358493,14945127,373445,1,'2008-05-09 19:04:04',3310503429,2),(52167082,426357208,14945689,373445,1,'2008-05-09 19:04:04',3310503428,2),(52167086,426354799,14944645,373445,1,'2008-05-09 19:04:04',3310503428,2),(52167105,426353032,14944484,373445,1,'2008-05-09 19:04:04',3310503428,2),(52167111,426351105,14944725,373445,1,'2008-05-09 19:04:04',3310503428,2),(52167122,426349258,14945930,373445,1,'2008-05-09 19:04:04',3310503428,2),(52167128,426346561,14926721,446582,1,'2008-05-15 01:25:41',3310503086,2),(52167136,426347555,14930060,446582,1,'2008-05-15 01:25:41',3310503086,2),(52167142,426347839,14934678,446582,1,'2008-05-15 01:25:41',3310503086,2),(52167150,426347129,14937165,446582,1,'2008-05-15 01:25:42',3310503086,2),(52167155,426346276,14941783,446582,1,'2008-05-15 01:25:41',3310503428,2),(52167165,426346561,14949314,373445,1,'2008-05-09 19:04:04',3310503428,2),(52167175,426346666,14950600,446582,1,'2008-05-15 01:25:41',3310503428,2),(52167179,426346640,14952527,435967,1,'2007-09-15 21:36:39',3310503428,1),(52167183,426346869,14956007,435967,1,'2007-09-15 21:36:39',3310503428,1),(52167190,426346594,14959213,435967,1,'2007-09-15 21:36:39',3310503428,1),(52167198,426346914,14961732,435967,1,'2007-09-15 21:36:40',3310503428,1),(52167208,426347143,14965762,435967,1,'2007-09-15 21:36:40',3310503428,1),(52167211,426346823,14967686,435967,1,'2007-09-15 21:36:40',3310503428,1),(52167218,426345678,14969930,435967,1,'2007-09-15 21:36:41',3310503428,1),(52167223,426343938,14971945,435967,1,'2007-09-15 21:36:41',3310503428,1),(52167232,426342839,14975059,435967,1,'2007-09-15 21:36:42',3310503428,1),(52167248,426342289,14977532,435967,1,'2007-09-15 21:36:42',3310503428,1),(52167254,426341785,14979089,435967,1,'2007-09-15 21:36:43',3310503428,1),(52167257,426340778,14979868,435967,1,'2007-09-15 21:36:43',3310503428,1),(52167262,426339770,14980738,435967,1,'2007-09-15 21:36:44',3310503428,1),(52167277,426339404,14981608,435967,1,'2007-09-15 21:36:46',3310503428,1),(52167279,426338854,14983760,435967,1,'2007-09-15 21:36:46',3310503428,1),(52167284,426338854,14985088,435967,1,'2007-09-15 21:36:46',3310503428,1),(52167289,426338671,14985913,435967,1,'2007-09-15 21:36:47',3310503428,1),(52167293,426337938,14986371,435967,1,'2007-09-15 21:36:47',3310503428,1),(52167300,426337343,14987241,435967,1,'2007-09-15 21:36:48',3310503428,1),(52167307,426336106,14988065,435967,1,'2007-09-15 21:36:49',3310503428,1),(52167309,426334961,14989577,435967,1,'2007-09-15 21:36:49',3310503428,1),(52167315,426333404,14991592,435967,1,'2007-09-15 21:36:49',3310503428,1),(52167320,426332717,14993149,435967,1,'2007-09-15 21:36:49',3310503428,1),(52167323,426333038,14994752,435967,1,'2007-09-15 21:36:50',3310503428,1),(52167329,426333862,14996904,435967,1,'2007-09-15 21:36:50',3310503430,1),(52167336,426333771,14999789,435967,1,'2007-09-15 21:36:50',3310503430,1),(52167345,426333725,15000888,435967,1,'2007-09-15 21:36:51',3310503430,1),(52167349,426333725,15002766,435967,1,'2007-09-15 21:36:51',3310503430,1),(52167353,426333725,15004048,435967,1,'2007-09-15 21:36:51',3310503430,1),(52167358,426333450,15004598,435967,1,'2007-09-15 21:36:52',3310503430,1),(52167363,426332855,15004964,435967,1,'2007-09-15 21:36:52',3310503430,1),(52167368,426332030,15004964,435967,1,'2007-09-15 21:36:52',3310503430,1),(52167372,426331252,15004827,435967,1,'2007-09-15 21:36:52',3310503430,1),(52167380,426330519,15005010,435967,1,'2007-09-15 21:36:52',3310503427,1),(52167387,426329786,15005514,435967,1,'2007-09-15 21:36:53',3310503427,1),(52167389,426328916,15006613,435967,1,'2007-09-15 21:36:53',3310503427,1),(52167390,426328596,15008124,435967,1,'2007-09-15 21:36:53',3310503427,1),(52167393,426328458,15010964,435967,1,'2007-09-15 21:36:54',3310503427,1),(52167396,426327909,15013483,435967,1,'2007-09-15 21:36:54',3310503427,1),(52167398,426327359,15016001,435967,1,'2007-09-15 21:36:54',3310503427,1),(52167402,426326260,15017971,435967,1,'2007-09-15 21:36:55',3310503427,1),(52167406,426325756,15021085,435967,1,'2007-09-15 21:36:55',3310503427,1),(52167421,426326077,15023787,435967,1,'2007-09-15 21:36:57',3310503427,1),(52167425,426326855,15026443,435967,1,'2007-09-15 21:36:58',3310503427,1),(52167428,426327588,15028733,435967,1,'2007-09-15 21:36:58',3310503427,1),(52167430,426327405,15030657,435967,1,'2007-09-15 21:36:58',3310503427,1),(52167433,426327222,15032443,435967,1,'2007-09-15 21:36:58',3310503427,1),(52167436,426326901,15035465,435967,1,'2007-09-15 21:36:58',3310503427,1),(52167438,426326718,15038946,435967,1,'2007-09-15 21:36:59',3310503427,1),(52167439,426326617,15042242,435967,1,'2007-09-15 21:36:59',3310503427,1),(52167444,426326617,15043829,435967,1,'2007-09-15 21:37:00',3310503427,1),(52167446,426325683,15045230,435967,1,'2007-09-15 21:37:00',3310503427,1),(52167453,426324983,15045976,435967,1,'2007-09-15 21:37:01',3310503427,1),(52167457,426325030,15046677,435967,1,'2007-09-15 21:37:01',3310503427,1),(52167470,426325450,15048030,435967,1,'2007-09-15 21:37:03',3310503427,1),(52167473,426327503,15049804,435967,1,'2007-09-15 21:37:03',3310503427,1),(52167477,426329044,15051251,435967,1,'2007-09-15 21:37:03',3310503427,1),(52167484,426329931,15052371,435967,1,'2007-09-15 21:37:04',3310503433,1),(52167487,426330024,15054005,435967,1,'2007-09-15 21:37:04',3310503433,1),(52167490,426329604,15055732,435967,1,'2007-09-15 21:37:04',3310503433,1),(52167496,426328810,15057552,435967,1,'2007-09-15 21:37:04',3310503433,1),(52167500,426328577,15059793,435967,1,'2007-09-15 21:37:04',3310503433,1),(52167503,426328297,15062780,435967,1,'2007-09-15 21:37:04',3310503433,1),(52167507,426328390,15066421,435967,1,'2007-09-15 21:37:05',3310503433,1),(52167511,426329137,15070389,435967,1,'2007-09-15 21:37:05',3310503433,1),(52167513,426329837,15073003,435967,1,'2007-09-15 21:37:05',3310503433,1),(52167517,426330211,15074496,435967,1,'2007-09-15 21:37:05',3310503433,1),(52167521,426329604,15076410,435967,1,'2007-09-15 21:37:06',3310503433,1),(52167525,426329511,15078837,435967,1,'2007-09-15 21:37:06',3310503433,1),(52167528,426329184,15080658,435967,1,'2007-09-15 21:37:06',3310503433,1),(52167530,426328530,15081871,435967,1,'2007-09-15 21:37:07',3310503433,1),(52167534,426327597,15082851,435967,1,'2007-09-15 21:37:07',3310503433,1),(52167535,426327177,15084345,435967,1,'2007-09-15 21:37:07',3310503433,1),(52167538,426326757,15086259,435967,1,'2007-09-15 21:37:07',3310503433,1),(52167540,426326290,15087846,435967,1,'2007-09-15 21:37:07',3310503433,1),(52167544,426326243,15090553,435967,1,'2007-09-15 21:37:07',3310503433,1),(52167547,426325636,15092093,435967,1,'2007-09-15 21:37:07',3310503433,1),(52167551,426325076,15093260,435967,1,'2007-09-15 21:37:07',3310503433,1),(52167557,426325076,15094707,435967,1,'2007-09-15 21:37:08',3310503433,1),(52167562,426324236,15095921,435967,1,'2007-09-15 21:37:08',3310503433,1),(52167568,426323116,15098068,435967,1,'2007-09-15 21:37:08',3310503433,1),(52167574,426322416,15101616,435967,1,'2007-09-15 21:37:09',3310503433,1),(52167579,426321669,15104556,435967,1,'2007-09-15 21:37:09',3310503433,1),(52167581,426320404,15107374,435967,1,'2007-09-15 21:37:09',3310503435,1),(52167585,426318081,15112579,435967,1,'2007-09-15 21:37:09',3310503435,1),(52167590,426316877,15115031,435967,1,'2007-09-15 21:37:10',3310503435,1),(52167593,426315973,15117999,435967,1,'2007-09-15 21:37:10',3310503435,1),(52167599,426314382,15124194,435967,1,'2007-09-15 21:37:10',3310503435,1),(52167604,426314167,15126990,435967,1,'2007-09-15 21:37:10',3310503435,1),(52167607,426314210,15130173,435967,1,'2007-09-15 21:37:10',3310503435,1),(52167614,426313995,15133056,435967,1,'2007-09-15 21:37:11',3310503435,1),(52167615,426313779,15137271,435967,1,'2007-09-15 21:37:11',3310503435,1),(52167619,426313693,15142261,435967,1,'2007-09-15 21:37:11',3310503435,1),(52167622,426313392,15146090,435967,1,'2007-09-15 21:37:11',3310503435,1),(52167627,426312962,15147897,435967,1,'2007-09-15 21:37:12',3310503435,1),(52167632,426312231,15152069,435967,1,'2007-09-15 21:37:12',3310503435,1),(52167636,426310897,15157188,435967,1,'2007-09-15 21:37:12',3310503435,1),(52167641,426310424,15159726,435967,1,'2007-09-15 21:37:12',3310503435,1),(52167645,426309994,15162351,435967,1,'2007-09-15 21:37:12',3310503457,1),(52167650,426308574,15166566,435967,1,'2007-09-15 21:37:12',3310503457,1),(52167655,426305821,15170739,435967,1,'2007-09-15 21:37:13',3310503457,1),(52167660,426304445,15172460,435967,1,'2007-09-15 21:37:13',3310503457,1),(52167664,426303756,15173621,435967,1,'2007-09-15 21:37:13',3310503457,1),(52167666,426303842,15175772,435967,1,'2007-09-15 21:37:13',3310503457,1),(52167669,426303885,15177622,435967,1,'2007-09-15 21:37:13',3310503457,1),(52167673,426303670,15180289,435967,1,'2007-09-15 21:37:14',3310503457,1),(52167677,426303068,15183687,435967,1,'2007-09-15 21:37:14',3310503456,1),(52167683,426302294,15187129,435967,1,'2007-09-15 21:37:14',3310503456,1),(52167687,426301562,15189064,435967,1,'2007-09-15 21:37:14',3310503456,1),(52167691,426300917,15190828,435967,1,'2007-09-15 21:37:15',3310503456,1),(52167695,426300229,15191818,435967,1,'2007-09-15 21:37:15',3310503456,1),(52167700,426299756,15193065,435967,1,'2007-09-15 21:37:15',3310503456,1),(52167702,426299067,15193409,435967,1,'2007-09-15 21:37:15',3310503456,1),(52167707,426298379,15194485,435967,1,'2007-09-15 21:37:16',3310503456,1),(52167710,426297605,15195990,435967,1,'2007-09-15 21:37:16',3310503456,1),(52167713,426296185,15196377,435967,1,'2007-09-15 21:37:16',3310503456,1),(52167714,426294766,15197453,435967,1,'2007-09-15 21:37:16',3310503456,1),(52167718,426294163,15198356,435967,1,'2007-09-15 21:37:17',3310503456,1),(52167721,426293303,15200249,435967,1,'2007-09-15 21:37:17',3310503456,1),(52167725,426293518,15202099,435967,1,'2007-09-15 21:37:17',3310503456,1),(52167727,426293733,15204121,435967,1,'2007-09-15 21:37:17',3310503456,1),(52167732,426293217,15206616,435967,1,'2007-09-15 21:37:18',3310503456,1),(52167736,426292443,15208724,435967,1,'2007-09-15 21:37:18',3310503456,1),(52167740,426291496,15210100,435967,1,'2007-09-15 21:37:18',3310503456,1),(52167744,426290120,15211219,435967,1,'2007-09-15 21:37:18',3310503456,1),(52167747,426288958,15212165,435967,1,'2007-09-15 21:37:19',3310503456,1),(52167752,426288270,15213455,435967,1,'2007-09-15 21:37:19',3310503456,1),(52167756,426287410,15215649,435967,1,'2007-09-15 21:37:19',3310503456,1),(52167758,426286807,15217886,435967,1,'2007-09-15 21:37:19',3310503458,1),(52167761,426286033,15219306,435967,1,'2007-09-15 21:37:20',3310503458,1),(52167765,426284743,15220381,435967,1,'2007-09-15 21:37:20',3310503458,1),(52167769,426282936,15221973,435967,1,'2007-09-15 21:37:20',3310503458,1),(52167773,426280484,15224038,435967,1,'2007-09-15 21:37:21',3310503458,1),(52167777,426278376,15226146,435967,1,'2007-09-15 21:37:21',3310503458,1),(52167781,426277817,15227436,435967,1,'2007-09-15 21:37:21',3310503458,1),(52167784,426276913,15228770,435967,1,'2007-09-15 21:37:21',3310503458,1),(52167787,426275451,15230103,435967,1,'2007-09-15 21:37:21',3310502775,1),(52167790,426273988,15231222,435967,1,'2007-09-15 21:37:22',3310502775,1),(52167795,426272440,15231996,435967,1,'2007-09-15 21:37:22',3310502775,1),(52167796,426271235,15231824,435967,1,'2007-09-15 21:37:22',3310502775,1),(52167799,426269772,15231179,435967,1,'2007-09-15 21:37:22',3310502775,1),(52167802,426268783,15231007,435967,1,'2007-09-15 21:37:23',3310502775,1),(52167805,426267794,15230706,435967,1,'2007-09-15 21:37:23',3310502775,1),(52167807,426266073,15229329,435967,1,'2007-09-15 21:37:23',3310502775,1),(52167811,426265256,15229587,435967,1,'2007-09-15 21:37:24',3310502775,1),(52167812,426264739,15229802,435967,1,'2007-09-15 21:37:24',3310502775,1),(52167815,426264051,15230275,435967,1,'2007-09-15 21:37:24',3310502775,1),(52167820,426263449,15230404,435967,1,'2007-09-15 21:37:25',3310502775,1),(52167825,426261986,15229845,435967,1,'2007-09-15 21:37:25',3310502775,1),(52167828,426261513,15229888,435967,1,'2007-09-15 21:37:26',3310502775,1),(52167834,426260868,15230017,435967,1,'2007-09-15 21:37:26',3310502775,1),(52167836,426260567,15231308,435967,1,'2007-09-15 21:37:27',3310502775,1),(52167839,426260093,15231996,435967,1,'2007-09-15 21:37:27',3310502775,1),(52167843,426259276,15233889,435967,1,'2007-09-15 21:37:27',3310502775,1),(52167847,426258416,15235265,435967,1,'2007-09-15 21:37:27',3310502775,1),(52167849,426256652,15237287,435967,1,'2007-09-15 21:37:28',3310502775,1),(52167853,426253383,15239180,435967,1,'2007-09-15 21:37:28',3310502775,1),(52167859,426247661,15244428,435967,1,'2007-09-15 21:37:28',3310502774,1),(52167860,426244994,15246794,435967,1,'2007-09-15 21:37:29',3310502774,1),(52167867,426243446,15248042,435967,1,'2007-09-15 21:37:29',3310502774,1),(52167872,426241897,15248472,435967,1,'2007-09-15 21:37:30',3310502774,1),(52167883,426240736,15248515,435967,1,'2007-09-15 21:37:32',3310502774,1),(52167887,426239015,15248214,435967,1,'2007-09-15 21:37:32',3310502774,1),(52167891,426237208,15247740,435967,1,'2007-09-15 21:37:32',3310502774,1),(52167896,426236219,15246665,435967,1,'2007-09-15 21:37:33',3310502774,1),(52167900,426235315,15245547,435967,1,'2007-09-15 21:37:33',3310502774,1),(52167906,426234498,15245245,435967,1,'2007-09-15 21:37:33',3310502774,1),(52167911,426233681,15245633,435967,1,'2007-09-15 21:37:34',3310502774,1),(52167916,426233423,15246622,435967,1,'2007-09-15 21:37:34',3310502774,1),(52167922,426233250,15247353,435967,1,'2007-09-15 21:37:34',3310502774,1),(52167924,426232433,15249289,435967,1,'2007-09-15 21:37:35',3310502774,1),(52167927,426231014,15250881,435967,1,'2007-09-15 21:37:35',3310502774,1),(52167930,426230368,15251096,435967,1,'2007-09-15 21:37:35',3310502774,1),(52167932,426229035,15252042,435967,1,'2007-09-15 21:37:35',3310502774,1),(52167937,426228217,15253247,435967,1,'2007-09-15 21:37:35',3310502774,1),(52167944,426226411,15254967,435967,1,'2007-09-15 21:37:36',3310502774,1),(52167948,426225292,15256430,435967,1,'2007-09-15 21:37:36',3310502774,1),(52167953,426224002,15257161,435967,1,'2007-09-15 21:37:36',3310502774,1),(52167958,426223098,15258366,435967,1,'2007-09-15 21:37:37',3310502774,1),(52167963,426221636,15259484,435967,1,'2007-09-15 21:37:37',3310502774,1),(52167967,426220990,15261377,435967,1,'2007-09-15 21:37:37',3310502771,1),(52167969,426219743,15263958,435967,1,'2007-09-15 21:37:37',3310502771,1),(52167970,426218323,15267916,435967,1,'2007-09-15 21:37:37',3310502771,1),(52167973,426217764,15268776,435967,1,'2007-09-15 21:37:38',3310502771,1),(52167977,426216861,15269981,435967,1,'2007-09-15 21:37:38',3310502771,1),(52167981,426216172,15270755,435967,1,'2007-09-15 21:37:38',3310502771,1),(52167986,426215312,15272175,435967,1,'2007-09-15 21:37:39',3310502777,1),(52167991,426214753,15274153,435967,1,'2007-09-15 21:37:39',3310502777,1),(52167995,426213979,15275530,435967,1,'2007-09-15 21:37:40',3310502777,1),(52168000,426213893,15277552,435967,1,'2007-09-15 21:37:40',3310502777,1),(52168004,426213720,15279961,435967,1,'2007-09-15 21:37:40',3310502777,1),(52168009,426213247,15281337,435967,1,'2007-09-15 21:37:40',3310502777,1),(52168013,426212602,15283359,435967,1,'2007-09-15 21:37:40',3310502777,1),(52168015,426211570,15285252,435967,1,'2007-09-15 21:37:41',3310502777,1),(52168018,426211225,15288392,435967,1,'2007-09-15 21:37:41',3310502777,1),(52168021,426211053,15289941,435967,1,'2007-09-15 21:37:41',3310502777,1),(52168025,426211139,15292307,435967,1,'2007-09-15 21:37:41',3310502777,1),(52168028,426211268,15294845,435967,1,'2007-09-15 21:37:41',3310502777,1),(52168033,426211268,15297426,435967,1,'2007-09-15 21:37:42',3310502777,1),(52168034,426211354,15301082,435967,1,'2007-09-15 21:37:42',3310502777,1),(52168038,426210451,15306890,435967,1,'2007-09-15 21:37:42',3310502777,1),(52168039,426210236,15310073,435967,1,'2007-09-15 21:37:42',3310502777,1),(52168043,426210064,15311880,435967,1,'2007-09-15 21:37:43',3310502777,1),(52168046,426210322,15313557,435967,1,'2007-09-15 21:37:43',3310502777,1),(52168049,426210881,15315751,435967,1,'2007-09-15 21:37:44',3310502777,1),(52168053,426211010,15316870,435967,1,'2007-09-15 21:37:44',3310502777,1),(52168055,426210924,15318720,435967,1,'2007-09-15 21:37:44',3310502777,1),(52168056,426210365,15320870,435967,1,'2007-09-15 21:37:44',3310502777,1),(52168060,426209677,15322849,435967,1,'2007-09-15 21:37:44',3310502777,1),(52168063,426208687,15325947,435967,1,'2007-09-15 21:37:45',3310502777,1),(52168065,426207612,15328226,435967,1,'2007-09-15 21:37:45',3310502779,1),(52168070,426206537,15329689,435967,1,'2007-09-15 21:37:45',3310502779,1),(52168071,426204988,15331324,435967,1,'2007-09-15 21:37:45',3310502779,1),(52168073,426204558,15332227,435967,1,'2007-09-15 21:37:45',3310502779,1),(52168077,426202665,15337690,435967,1,'2007-09-15 21:37:46',3310502779,1),(52168080,426200416,15340547,435967,1,'2007-09-15 21:37:46',3310502779,1),(52168084,426199310,15342700,435967,1,'2007-09-15 21:37:46',3310502779,1),(52168086,426198088,15344679,435967,1,'2007-09-15 21:37:46',3310502779,1),(52168090,426194772,15349275,435967,1,'2007-09-15 21:37:46',3310502779,1),(52168094,426191979,15352767,435967,1,'2007-09-15 21:37:47',3310502778,1),(52168096,426188895,15358178,435967,1,'2007-09-15 21:37:47',3310502778,1),(52168100,426187906,15359225,435967,1,'2007-09-15 21:37:47',3310502778,1),(52168101,426185695,15358760,435967,1,'2007-09-15 21:37:47',3310502778,1),(52168104,426184473,15359109,435967,1,'2007-09-15 21:37:48',3310502778,1),(52168108,426182902,15361145,435967,1,'2007-09-15 21:37:48',3310502778,1),(52168111,426178829,15366382,435967,1,'2007-09-15 21:37:48',3310502778,1),(52168115,426176618,15370921,435967,1,'2007-09-15 21:37:48',3310502778,1),(52168118,426175221,15373423,435967,1,'2007-09-15 21:37:49',3310502778,1),(52168121,426173708,15375866,435967,1,'2007-09-15 21:37:49',3310502778,1),(52168124,426171032,15380696,435967,1,'2007-09-15 21:37:49',3310502778,1),(52168127,426168879,15382209,435967,1,'2007-09-15 21:37:49',3310502864,1),(52168130,426166551,15382150,435967,1,'2007-09-15 21:37:50',3310502864,1),(52168135,426161664,15381336,435967,1,'2007-09-15 21:37:50',3310502853,1),(52168138,426158173,15380987,435967,1,'2007-09-15 21:37:50',3310502767,1),(52168143,426154682,15381394,435967,1,'2007-09-15 21:37:51',3310502853,1),(52168146,426148339,15381510,435967,1,'2007-09-15 21:37:51',3310502853,1),(52168149,426146536,15381452,435967,1,'2007-09-15 21:37:51',3310502853,1),(52168152,426144383,15380987,435967,1,'2007-09-15 21:37:51',3310502767,1),(52168156,426141590,15379707,435967,1,'2007-09-15 21:37:51',3310502767,1),(52168160,426135655,15377496,435967,1,'2007-09-15 21:37:52',3310502766,1),(52168163,426133171,15376614,435967,1,'2007-09-15 21:37:52',3310502766,1),(52168167,426132027,15376406,435967,1,'2007-09-15 21:37:52',3310502766,1),(52168171,426130468,15376926,435967,1,'2007-09-15 21:37:53',3310502766,1),(52168175,426128752,15377862,435967,1,'2007-09-15 21:37:53',3310502766,1),(52168178,426126360,15379474,435967,1,'2007-09-15 21:37:53',3310502766,1),(52168181,426123969,15380825,435967,1,'2007-09-15 21:37:53',3310502766,1),(52168186,426121265,15382229,435967,1,'2007-09-15 21:37:54',3310502852,1),(52168188,426117626,15384829,435967,1,'2007-09-15 21:37:54',3310502852,1),(52168191,426115234,15387324,435967,1,'2007-09-15 21:37:54',3310502852,1),(52168195,426113414,15388104,435967,1,'2007-09-15 21:37:55',3310502852,1),(52168198,426110711,15387116,435967,1,'2007-09-15 21:37:55',3310502849,1),(52168203,426109151,15386232,435967,1,'2007-09-15 21:37:56',3310502849,1),(52168207,426104004,15383373,435967,1,'2007-09-15 21:37:56',3310502849,1),(52168214,426101560,15382437,435967,1,'2007-09-15 21:37:57',3310502849,1),(52168217,426100001,15381553,435967,1,'2007-09-15 21:37:57',3310502849,1),(52168220,426097349,15381345,435967,1,'2007-09-15 21:37:57',3310502849,1),(52168225,426095997,15381137,435967,1,'2007-09-15 21:37:57',3310502849,1),(52168228,426085438,15373516,206510,1,'2008-12-06 19:38:08',3310502763,4),(52168231,426093922,15380702,435967,1,'2007-09-15 21:37:58',3310502763,1),(52168235,426092922,15379288,435967,1,'2007-09-15 21:37:58',3310502763,1),(52168237,426091749,15377082,435967,1,'2007-09-15 21:37:59',3310502763,1),(52168240,426090853,15375841,435967,1,'2007-09-15 21:37:59',3310502763,1),(52168243,426089026,15374565,435967,1,'2007-09-15 21:37:59',3310502763,1),(52168247,426087440,15373358,435967,1,'2007-09-15 21:38:00',3310502763,1),(52168248,426085819,15371565,435967,1,'2007-09-15 21:38:00',3310502763,1),(52168249,426084750,15370290,435967,1,'2007-09-15 21:38:00',3310502763,1),(52168251,426083992,15368393,435967,1,'2007-09-15 21:38:00',3310502763,1),(52168254,426083164,15366704,435967,1,'2007-09-15 21:38:00',3310502762,1),(52168256,426081958,15365531,435967,1,'2007-09-15 21:38:00',3310502762,1),(52168258,426080406,15365911,435967,1,'2007-09-15 21:38:01',3310502762,1),(52168261,426078855,15366256,435967,1,'2007-09-15 21:38:01',3310502762,1),(52168265,426077234,15366807,435967,1,'2007-09-15 21:38:01',3310502762,1),(52168270,426074717,15367049,435967,1,'2007-09-15 21:38:02',3310502762,1),(52168274,426073545,15367428,435967,1,'2007-09-15 21:38:02',3310502762,1),(52168278,426071855,15368910,435967,1,'2007-09-15 21:38:02',3310502762,1),(52168283,426069736,15370321,435967,1,'2007-09-15 21:38:03',3310502762,1),(52168286,426067806,15371036,435967,1,'2007-09-15 21:38:03',3310502762,1),(52168287,426066447,15370893,435967,1,'2007-09-15 21:38:03',3310502762,1),(52168291,426065160,15370250,435967,1,'2007-09-15 21:38:03',3310502762,1),(52168296,426064160,15368748,435967,1,'2007-09-15 21:38:04',3310502762,1),(52168298,426062515,15367032,435967,1,'2007-09-15 21:38:04',3310502762,1),(52168302,426061014,15364959,435967,1,'2007-09-15 21:38:04',3310502762,1),(52168305,426058583,15362814,435967,1,'2007-09-15 21:38:04',3310502762,1),(52168308,426055866,15360741,435967,1,'2007-09-15 21:38:05',3310502719,1),(52168309,426054150,15358811,435967,1,'2007-09-15 21:38:05',3310502719,1),(52168314,426053006,15356809,435967,1,'2007-09-15 21:38:05',3310502719,1),(52168316,426051722,15355729,435967,1,'2007-09-15 21:38:05',3310502719,1),(52168318,426050257,15354411,435967,1,'2007-09-15 21:38:05',3310502719,1),(52168321,426048759,15353361,435967,1,'2007-09-15 21:38:06',3310502719,1),(52168325,426046573,15353179,435967,1,'2007-09-15 21:38:06',3310502719,1),(52168326,426044326,15354333,435967,1,'2007-09-15 21:38:06',3310502719,1),(52168329,426041958,15355122,435967,1,'2007-09-15 21:38:06',3310502719,1),(52168333,426039468,15355972,435967,1,'2007-09-15 21:38:06',3310502719,1),(52168336,426037403,15356154,435967,1,'2007-09-15 21:38:07',3310502719,1),(52168338,426035035,15355304,435967,1,'2007-09-15 21:38:07',3310502719,1),(52168342,426032606,15353726,435967,1,'2007-09-15 21:38:07',3310502719,1),(52168346,426028598,15349414,435967,1,'2007-09-15 21:38:08',3310502718,1),(52168347,426025027,15344952,435967,1,'2007-09-15 21:38:08',3310502718,1),(52168348,426022953,15343175,435967,1,'2007-09-15 21:38:08',3310502718,1),(52168350,426021546,15342805,435967,1,'2007-09-15 21:38:08',3310502718,1),(52168356,426019176,15343249,435967,1,'2007-09-15 21:38:08',3310502718,1),(52168360,426016525,15342849,435967,1,'2007-09-15 21:38:09',3310502718,1),(52168362,426014575,15342094,435967,1,'2007-09-15 21:38:09',3310502718,1),(52168414,426013128,15340898,435967,1,'2007-09-15 21:38:14',3310502718,1),(52168416,426011178,15337816,435967,1,'2007-09-15 21:38:14',3310502718,1),(52168419,426009605,15335803,435967,1,'2007-09-15 21:38:14',3310502718,1),(52168423,426007403,15334230,435967,1,'2007-09-15 21:38:14',3310502718,1),(52168427,426006082,15332595,435967,1,'2007-09-15 21:38:15',3310502718,1),(52168429,426005579,15330456,435967,1,'2007-09-15 21:38:15',3310502718,1),(52168432,426004887,15326682,435967,1,'2007-09-15 21:38:16',3310502718,1),(52168436,426001679,15322844,435967,1,'2007-09-15 21:38:16',3310502716,1),(52168440,426000106,15320706,435967,1,'2007-09-15 21:38:16',3310502713,1),(52168442,425998533,15319196,435967,1,'2007-09-15 21:38:16',3310502713,1),(52168445,425997527,15318693,435967,1,'2007-09-15 21:38:16',3310502713,1),(52168447,425995703,15319322,435967,1,'2007-09-15 21:38:16',3310502713,1),(52168452,425994445,15319070,435967,1,'2007-09-15 21:38:17',3310502713,1),(52168455,425993816,15318378,435967,1,'2007-09-15 21:38:17',3310502713,1),(52168459,425993375,15316742,435967,1,'2007-09-15 21:38:17',3310502713,1),(52168461,425992494,15314855,435967,1,'2007-09-15 21:38:17',3310502713,1),(52168464,425991111,15313283,435967,1,'2007-09-15 21:38:17',3310502713,1),(52168468,425988594,15311333,435967,1,'2007-09-15 21:38:18',3310502713,1),(52168470,425985197,15309886,435967,1,'2007-09-15 21:38:18',3310502713,1),(52168474,425981863,15308628,435967,1,'2007-09-15 21:38:18',3310502713,1),(52168476,425979284,15306992,435967,1,'2007-09-15 21:38:18',3310502713,1),(52168479,425977586,15305042,435967,1,'2007-09-15 21:38:19',3310502713,1),(52168481,425972553,15297367,435967,1,'2007-09-15 21:38:19',3310502712,1),(52168484,425968968,15288749,435967,1,'2007-09-15 21:38:19',3310502712,1),(52168486,425967835,15286170,435967,1,'2007-09-15 21:38:19',3310502712,1),(52168489,425966577,15284723,435967,1,'2007-09-15 21:38:19',3310502712,1),(52168492,425964879,15283402,435967,1,'2007-09-15 21:38:19',3310502712,1),(52168495,425963117,15283088,435967,1,'2007-09-15 21:38:19',3310502712,1),(52168497,425961167,15282773,435967,1,'2007-09-15 21:38:20',3310502712,1),(52168502,425958588,15282773,435967,1,'2007-09-15 21:38:20',3310502712,1),(52168506,425957078,15282396,435967,1,'2007-09-15 21:38:20',3310502712,1),(52168509,425955757,15281955,435967,1,'2007-09-15 21:38:20',3310502712,1),(52168512,425953996,15281138,435967,1,'2007-09-15 21:38:20',3310502712,1),(52168516,425953052,15280194,435967,1,'2007-09-15 21:38:21',3310502712,1),(52168519,425952738,15278810,435967,1,'2007-09-15 21:38:21',3310502712,1),(52168521,425951668,15277175,435967,1,'2007-09-15 21:38:21',3310502712,1),(52168523,425950033,15275854,435967,1,'2007-09-15 21:38:21',3310502712,1),(52168529,425948272,15275413,435967,1,'2007-09-15 21:38:21',3310502712,1),(52168531,425944812,15273652,435967,1,'2007-09-15 21:38:21',3310502701,1),(52168534,425943176,15272771,435967,1,'2007-09-15 21:38:22',3310502701,1),(52168537,425940786,15272520,435967,1,'2007-09-15 21:38:22',3310502701,1),(52168541,425938521,15272268,435967,1,'2007-09-15 21:38:22',3310502701,1),(52168543,425936131,15270947,435967,1,'2007-09-15 21:38:22',3310502695,1),(52168547,425933614,15268682,435967,1,'2007-09-15 21:38:22',3310502695,1),(52168549,425931035,15267172,435967,1,'2007-09-15 21:38:22',3310502695,1),(52168553,425928330,15266481,435967,1,'2007-09-15 21:38:23',3310502695,1),(52168555,425926129,15266229,435967,1,'2007-09-15 21:38:23',3310502695,1),(52168558,425924304,15266984,435967,1,'2007-09-15 21:38:23',3310502695,1),(52168561,425922228,15268745,435967,1,'2007-09-15 21:38:23',3310502695,1),(52168565,425920782,15270003,435967,1,'2007-09-15 21:38:23',3310502695,1),(52168568,425919586,15269060,435967,1,'2007-09-15 21:38:24',3310502695,1),(52168569,425917699,15266669,435967,1,'2007-09-15 21:38:24',3310502694,1),(52168572,425915686,15264090,435967,1,'2007-09-15 21:38:24',3310502694,1),(52168576,425913799,15262077,435967,1,'2007-09-15 21:38:24',3310502694,1),(52168579,425912510,15259992,435967,1,'2007-09-15 21:38:24',3310502694,1),(52168582,425911461,15257943,435967,1,'2007-09-15 21:38:25',3310502694,1),(52168586,425910413,15255370,435967,1,'2007-09-15 21:38:25',3310502694,1),(52168589,425908793,15252177,435967,1,'2007-09-15 21:38:25',3310502694,1),(52168592,425907507,15250986,435967,1,'2007-09-15 21:38:25',3310502694,1),(52168595,425906125,15249699,435967,1,'2007-09-15 21:38:25',3310502694,1),(52168596,425903074,15248155,435967,1,'2007-09-15 21:38:25',3310502694,1),(52168600,425898160,15245335,435967,1,'2007-09-15 21:38:26',3310502694,1),(52168604,425895904,15243885,435967,1,'2007-09-15 21:38:26',3310502694,1),(52168607,425893729,15243160,435967,1,'2007-09-15 21:38:26',3310502694,1),(52168612,425890507,15242193,435967,1,'2007-09-15 21:38:27',3310502691,1),(52168613,425888251,15241468,435967,1,'2007-09-15 21:38:27',3310502691,1),(52168616,425886801,15240502,435967,1,'2007-09-15 21:38:27',3310502691,1),(52168622,425885512,15238488,435967,1,'2007-09-15 21:38:27',3310502691,1),(52168626,425884464,15237199,435967,1,'2007-09-15 21:38:27',3310502691,1),(52168631,425883739,15235990,435967,1,'2007-09-15 21:38:28',3310502691,1),(52168635,425882853,15234782,435967,1,'2007-09-15 21:38:28',3310502691,1),(52168638,425880839,15234298,435967,1,'2007-09-15 21:38:28',3310502691,1),(52168640,425878986,15233654,435967,1,'2007-09-15 21:38:28',3310502691,1),(52168644,425877617,15232929,435967,1,'2007-09-15 21:38:28',3310502691,1),(52168648,425876569,15231317,435967,1,'2007-09-15 21:38:29',3310502691,1),(52168654,425875039,15230028,435967,1,'2007-09-15 21:38:29',3310502691,1),(52168657,425871091,15229384,435967,1,'2007-09-15 21:38:29',3310502691,1),(52168660,425865049,15228739,435967,1,'2007-09-15 21:38:30',3310502691,1),(52168663,425863518,15228337,435967,1,'2007-09-15 21:38:30',3310502690,1),(52168665,425862874,15227209,435967,1,'2007-09-15 21:38:30',3310502690,1),(52168668,425861262,15224067,435967,1,'2007-09-15 21:38:30',3310502690,1),(52168671,425859329,15222375,435967,1,'2007-09-15 21:38:30',3310502690,1),(52168674,425857234,15220522,435967,1,'2007-09-15 21:38:30',3310502690,1),(52168676,425854495,15219797,435967,1,'2007-09-15 21:38:31',3310502690,1),(52168679,425851937,15218315,435967,1,'2007-09-15 21:38:31',3310502690,1),(52168682,425848482,15216923,435967,1,'2007-09-15 21:38:31',3310502690,1),(52168686,425844512,15214293,435967,1,'2007-09-15 21:38:31',3310502688,1),(52168687,425841728,15212591,435967,1,'2007-09-15 21:38:32',3310502688,1),(52168690,425840026,15211767,435967,1,'2007-09-15 21:38:32',3310502688,1),(52168693,425838170,15210942,435967,1,'2007-09-15 21:38:32',3310502688,1),(52168695,425836004,15210632,435967,1,'2007-09-15 21:38:32',3310502517,1),(52168698,425833633,15210632,435967,1,'2007-09-15 21:38:33',3310502517,1),(52168700,425831313,15210581,435967,1,'2007-09-15 21:38:33',3310502517,1),(52168702,425828631,15209653,435967,1,'2007-09-15 21:38:33',3310502517,1),(52168703,425826981,15208518,435967,1,'2007-09-15 21:38:33',3310502517,1),(52168705,425825538,15207023,435967,1,'2007-09-15 21:38:33',3310502517,1),(52168708,425823408,15206122,19873,1,'2008-06-02 18:30:23',3310502517,2),(52168710,425821386,15205092,19873,1,'2008-06-02 18:30:23',3310502517,2),(52168712,425819490,15204062,19873,1,'2008-06-02 18:30:23',3310502517,2),(52168714,425816309,15203104,435967,1,'2007-09-15 21:38:34',3310502517,1),(52168717,425814762,15202950,435967,1,'2007-09-15 21:38:34',3310502517,1),(52168720,425812545,15202898,435967,1,'2007-09-15 21:38:35',3310502517,1),(52168722,425810792,15202640,435967,1,'2007-09-15 21:38:35',3310502517,1),(52168725,425808575,15201455,435967,1,'2007-09-15 21:38:35',3310502516,1),(52168727,425805790,15199392,435967,1,'2007-09-15 21:38:35',3310502516,1),(52168729,425802748,15196608,435967,1,'2007-09-15 21:38:36',3310502516,1),(52168732,425800634,15194906,435967,1,'2007-09-15 21:38:36',3310502516,1),(52168734,425798056,15193721,435967,1,'2007-09-15 21:38:36',3310502516,1),(52168736,425795736,15192792,435967,1,'2007-09-15 21:38:36',3310502516,1),(52168739,425793261,15192689,435967,1,'2007-09-15 21:38:36',3310502516,1),(52168741,425791818,15193205,435967,1,'2007-09-15 21:38:36',3310502516,1),(52168744,425789652,15193927,435967,1,'2007-09-15 21:38:36',3310502516,1),(52168745,425786765,15193617,435967,1,'2007-09-15 21:38:37',3310502516,1),(52168747,425784702,15191864,435967,1,'2007-09-15 21:38:37',3310502516,1),(52168750,425783568,15190421,435967,1,'2007-09-15 21:38:37',3310502516,1),(52168770,425782640,15188668,435967,1,'2007-09-15 21:38:39',3310502516,1),(52168772,425781299,15185316,435967,1,'2007-09-15 21:38:39',3310502513,1),(52168773,425780113,15182532,435967,1,'2007-09-15 21:38:39',3310502513,1),(52168774,425779154,15180712,498434,1,'2008-05-22 17:13:55',3310502513,2),(52168777,425777587,15179129,435967,1,'2007-09-15 21:38:40',3310502513,1),(52168779,425775267,15176706,435967,1,'2007-09-15 21:38:40',3310502513,1),(52168782,425773978,15175881,435967,1,'2007-09-15 21:38:40',3310502513,1),(52168786,425771142,15176448,435967,1,'2007-09-15 21:38:40',3310502513,1),(52168788,425770369,15177582,435967,1,'2007-09-15 21:38:41',3310502513,1),(52168789,425768873,15181243,435967,1,'2007-09-15 21:38:41',3310502513,1),(52168790,425768461,15183305,435967,1,'2007-09-15 21:38:41',3310502513,1),(52168794,425767327,15184749,435967,1,'2007-09-15 21:38:41',3310502513,1),(52168796,425765780,15186915,435967,1,'2007-09-15 21:38:41',3310502513,1),(52168799,425763717,15187894,435967,1,'2007-09-15 21:38:41',3310502513,1),(52168802,425761810,15188410,435967,1,'2007-09-15 21:38:42',3310502513,1),(52168805,425759541,15187894,435967,1,'2007-09-15 21:38:42',3310502513,1),(52168808,425757736,15186657,435967,1,'2007-09-15 21:38:42',3310502513,1),(52168810,425755004,15184749,435967,1,'2007-09-15 21:38:42',3310502513,1),(52168813,425752735,15183099,435967,1,'2007-09-15 21:38:43',3310502512,1),(52168816,425751188,15182223,435967,1,'2007-09-15 21:38:43',3310502512,1),(52168819,425749487,15182223,435967,1,'2007-09-15 21:38:43',3310502512,1),(52168821,425747837,15182635,435967,1,'2007-09-15 21:38:43',3310502512,1),(52168824,425746135,15183821,435967,1,'2007-09-15 21:38:44',3310502512,1),(52168828,425743300,15186399,435967,1,'2007-09-15 21:38:44',3310502512,1),(52168829,425742011,15187791,435967,1,'2007-09-15 21:38:44',3310502512,1),(52168830,425739897,15190214,435967,1,'2007-09-15 21:38:44',3310502512,1),(52168834,425737783,15191452,435967,1,'2007-09-15 21:38:44',3310502512,1),(52168836,425735669,15192328,435967,1,'2007-09-15 21:38:45',3310502512,1),(52168838,425731286,15192638,435967,1,'2007-09-15 21:38:45',3310502512,1),(52168842,425729894,15192328,435967,1,'2007-09-15 21:38:45',3310502512,1),(52168845,425728811,15192380,435967,1,'2007-09-15 21:38:45',3310502512,1),(52168846,425727780,15193617,435967,1,'2007-09-15 21:38:45',3310502512,1),(52168849,425727161,15194803,435967,1,'2007-09-15 21:38:45',3310502512,1),(52168851,425725047,15198877,435967,1,'2007-09-15 21:38:46',3310502501,1),(52168854,425723604,15201248,435967,1,'2007-09-15 21:38:46',3310502501,1),(52168856,425722057,15203311,435967,1,'2007-09-15 21:38:46',3310502501,1),(52168858,425720355,15204187,435967,1,'2007-09-15 21:38:46',3310502501,1),(52168859,425718293,15205115,435967,1,'2007-09-15 21:38:46',3310502501,1),(52168862,425716695,15206456,435967,1,'2007-09-15 21:38:46',3310502501,1),(52168865,425715199,15208879,435967,1,'2007-09-15 21:38:47',3310502501,1),(52168866,425713446,15210581,435967,1,'2007-09-15 21:38:47',3310502501,1),(52168867,425710817,15212540,435967,1,'2007-09-15 21:38:47',3310502501,1),(52168870,425708754,15215118,435967,1,'2007-09-15 21:38:47',3310502501,1),(52168873,425707001,15216510,435967,1,'2007-09-15 21:38:47',3310502503,1),(52168875,425705455,15217232,435967,1,'2007-09-15 21:38:47',3310502503,1),(52168878,425703547,15217696,435967,1,'2007-09-15 21:38:47',3310502503,1),(52168881,425700866,15218366,435967,1,'2007-09-15 21:38:48',3310502503,1),(52168883,425699938,15218366,435967,1,'2007-09-15 21:38:48',3310502503,1),(52168886,425696792,15217438,435967,1,'2007-09-15 21:38:49',3310502502,1),(52168889,425694327,15215782,498434,1,'2008-05-22 17:35:14',3310502500,2),(52168892,425692101,15214963,435967,1,'2007-09-15 21:38:49',3310502500,1),(52168895,425690193,15214551,435967,1,'2007-09-15 21:38:49',3310502500,1),(52168899,425689162,15214912,435967,1,'2007-09-15 21:38:49',3310502500,1),(52168901,425687821,15216562,435967,1,'2007-09-15 21:38:50',3310502502,1),(52168904,425685037,15221099,435967,1,'2007-09-15 21:38:50',3310502502,1),(52168905,425683542,15223832,435967,1,'2007-09-15 21:38:50',3310502502,1),(52168909,425681685,15225894,435967,1,'2007-09-15 21:38:51',3310502502,1),(52168912,425679881,15228420,435967,1,'2007-09-15 21:38:51',3310502502,1),(52168914,425678643,15231102,435967,1,'2007-09-15 21:38:51',3310502502,1),(52168917,425678437,15234247,435967,1,'2007-09-15 21:38:51',3310502502,1),(52168919,425678437,15236979,435967,1,'2007-09-15 21:38:52',3310502502,1),(52168920,425678076,15238681,435967,1,'2007-09-15 21:38:52',3310502502,1),(52168921,425677200,15240485,435967,1,'2007-09-15 21:38:52',3310502502,1),(52168924,425675962,15242135,435967,1,'2007-09-15 21:38:52',3310502502,1),(52168926,425673642,15244249,435967,1,'2007-09-15 21:38:52',3310502502,1),(52168929,425671477,15245641,435967,1,'2007-09-15 21:38:52',3310502499,1),(52168931,425669105,15246157,435967,1,'2007-09-15 21:38:53',3310502499,1),(52168933,425665960,15246260,435967,1,'2007-09-15 21:38:53',3310502499,1),(52168936,425663897,15247034,435967,1,'2007-09-15 21:38:53',3310502499,1),(52168939,425661783,15247188,435967,1,'2007-09-15 21:38:53',3310502499,1),(52168943,425660082,15247807,435967,1,'2007-09-15 21:38:54',3310502499,1),(52168945,425658019,15249766,435967,1,'2007-09-15 21:38:54',3310502499,1),(52168946,425656576,15252138,435967,1,'2007-09-15 21:38:54',3310502499,1),(52168948,425655132,15254252,435967,1,'2007-09-15 21:38:54',3310502499,1),(52168952,425653998,15255850,435967,1,'2007-09-15 21:38:54',3310502499,1),(52168955,425653224,15257861,435967,1,'2007-09-15 21:38:55',3310502499,1),(52168959,425652142,15259769,435967,1,'2007-09-15 21:38:55',3310502499,1),(52168961,425650956,15261831,435967,1,'2007-09-15 21:38:55',3310502499,1),(52168964,425649306,15263172,435967,1,'2007-09-15 21:38:55',3310502499,1),(52168965,425647295,15263172,435967,1,'2007-09-15 21:38:56',3310502499,1),(52168967,425644975,15261831,435967,1,'2007-09-15 21:38:56',3310502499,1),(52168969,425642809,15261367,435967,1,'2007-09-15 21:38:56',3310502498,1),(52168972,425640695,15261109,435967,1,'2007-09-15 21:38:56',3310502498,1),(52168974,425639148,15261625,435967,1,'2007-09-15 21:38:56',3310502498,1),(52168976,425638639,15262611,498434,1,'2008-05-22 17:49:21',3310502498,2),(52168981,425638007,15263641,498434,1,'2008-05-22 17:49:21',3310502498,2),(52168984,425637691,15264757,498434,1,'2008-05-22 17:49:21',3310502498,2),(52168987,425637501,15266302,498434,1,'2008-05-22 17:49:21',3310502498,2),(52168989,425636996,15269735,498434,1,'2008-05-22 17:49:21',3310502498,2),(52168992,425634846,15272653,498434,1,'2008-05-22 17:49:21',3310502504,2),(52168995,425632507,15277202,498434,1,'2008-05-22 17:52:10',3310502504,3),(52169000,425631432,15277288,498434,1,'2008-05-22 17:49:21',3310502504,2),(52169003,425629915,15277632,498434,1,'2008-05-22 17:52:10',3310502504,2),(52169006,425627805,15280496,435967,1,'2007-09-15 21:39:00',3310502504,1),(52169008,425626310,15284879,435967,1,'2007-09-15 21:39:01',3310502504,1),(52169011,425624866,15287457,435967,1,'2007-09-15 21:39:01',3310502504,1),(52169014,425623835,15288642,435967,1,'2007-09-15 21:39:01',3310502504,1),(52169016,425622134,15289416,435967,1,'2007-09-15 21:39:01',3310502504,1),(52169018,425619556,15290911,435967,1,'2007-09-15 21:39:02',3310502504,1),(52169021,425616926,15290860,435967,1,'2007-09-15 21:39:02',3310502504,1),(52169022,425615070,15290860,435967,1,'2007-09-15 21:39:02',3310502461,1),(52169024,425613626,15291685,435967,1,'2007-09-15 21:39:02',3310502461,1),(52169028,425612389,15293541,435967,1,'2007-09-15 21:39:03',3310502461,1),(52169032,425610945,15295706,435967,1,'2007-09-15 21:39:03',3310502461,1),(52169034,425609398,15298078,435967,1,'2007-09-15 21:39:04',3310502461,1),(52169036,425607851,15302048,435967,1,'2007-09-15 21:39:04',3310502461,1),(52169041,425606305,15304265,435967,1,'2007-09-15 21:39:04',3310502461,1),(52169044,425604345,15305606,435967,1,'2007-09-15 21:39:05',3310502461,1),(52169045,425600169,15308132,435967,1,'2007-09-15 21:39:05',3310502461,1),(52169048,425593982,15312154,435967,1,'2007-09-15 21:39:05',3310502461,1),(52169052,425590424,15314577,435967,1,'2007-09-15 21:39:06',3310502461,1),(52169054,425588723,15316433,435967,1,'2007-09-15 21:39:06',33