#ifndef METALANG99_UINT_DIV_H
#define METALANG99_UINT_DIV_H

#include <metalang99/lang.h>
#include <metalang99/maybe.h>
#include <metalang99/priv/util.h>
#include <metalang99/priv/variadics/get.h>

#define METALANG99_div_IMPL(x, y)                                                                  \
    METALANG99_call(                                                                               \
        METALANG99_matchWithArgs,                                                                  \
        METALANG99_divChecked_IMPL(x, y),                                                          \
        v(METALANG99_PRIV_div_, x, y))
#define METALANG99_PRIV_div_nothing_IMPL(x, y)   METALANG99_PRIV_div_ERROR(x, y)
#define METALANG99_PRIV_div_just_IMPL(n, _x, _y) v(n)
#define METALANG99_PRIV_div_ERROR(x, y)          METALANG99_fatal(METALANG99_div, x is not divisible by y)

#define METALANG99_divChecked_IMPL(x, y)                                                           \
    METALANG99_PRIV_UNPARENTHESIZE(                                                                \
        METALANG99_PRIV_VARIADICS_SND(METALANG99_PRIV_div_##x##_##y(), (METALANG99_nothing())))

#define METALANG99_PRIV_div_0_1() ~, (METALANG99_just(v(0)))

#define METALANG99_PRIV_div_1_1() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_2_1() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_2_2() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_3_1() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_3_3() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_4_1() ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_4_2() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_4_4() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_5_1() ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_5_5() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_6_1() ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_6_3() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_6_2() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_6_6() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_7_1() ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_7_7() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_8_1() ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_8_4() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_8_2() ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_8_8() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_9_1() ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_9_3() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_9_9() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_10_1()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_10_5()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_10_2()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_10_10() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_11_1()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_11_11() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_12_1()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_12_6()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_12_4()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_12_3()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_12_2()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_12_12() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_13_1()  ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_13_13() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_14_1()  ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_14_7()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_14_2()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_14_14() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_15_1()  ~, (METALANG99_just(v(15)))
#define METALANG99_PRIV_div_15_5()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_15_3()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_15_15() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_16_1()  ~, (METALANG99_just(v(16)))
#define METALANG99_PRIV_div_16_8()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_16_4()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_16_2()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_16_16() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_17_1()  ~, (METALANG99_just(v(17)))
#define METALANG99_PRIV_div_17_17() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_18_1()  ~, (METALANG99_just(v(18)))
#define METALANG99_PRIV_div_18_9()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_18_6()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_18_3()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_18_2()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_18_18() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_19_1()  ~, (METALANG99_just(v(19)))
#define METALANG99_PRIV_div_19_19() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_20_1()  ~, (METALANG99_just(v(20)))
#define METALANG99_PRIV_div_20_10() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_20_5()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_20_4()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_20_2()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_20_20() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_21_1()  ~, (METALANG99_just(v(21)))
#define METALANG99_PRIV_div_21_7()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_21_3()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_21_21() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_22_1()  ~, (METALANG99_just(v(22)))
#define METALANG99_PRIV_div_22_11() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_22_2()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_22_22() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_23_1()  ~, (METALANG99_just(v(23)))
#define METALANG99_PRIV_div_23_23() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_24_1()  ~, (METALANG99_just(v(24)))
#define METALANG99_PRIV_div_24_12() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_24_8()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_24_6()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_24_4()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_24_3()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_24_2()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_24_24() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_25_1()  ~, (METALANG99_just(v(25)))
#define METALANG99_PRIV_div_25_5()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_25_25() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_26_1()  ~, (METALANG99_just(v(26)))
#define METALANG99_PRIV_div_26_13() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_26_2()  ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_26_26() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_27_1()  ~, (METALANG99_just(v(27)))
#define METALANG99_PRIV_div_27_9()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_27_3()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_27_27() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_28_1()  ~, (METALANG99_just(v(28)))
#define METALANG99_PRIV_div_28_14() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_28_7()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_28_4()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_28_2()  ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_28_28() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_29_1()  ~, (METALANG99_just(v(29)))
#define METALANG99_PRIV_div_29_29() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_30_1()  ~, (METALANG99_just(v(30)))
#define METALANG99_PRIV_div_30_15() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_30_10() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_30_6()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_30_5()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_30_3()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_30_2()  ~, (METALANG99_just(v(15)))
#define METALANG99_PRIV_div_30_30() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_31_1()  ~, (METALANG99_just(v(31)))
#define METALANG99_PRIV_div_31_31() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_32_1()  ~, (METALANG99_just(v(32)))
#define METALANG99_PRIV_div_32_16() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_32_8()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_32_4()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_32_2()  ~, (METALANG99_just(v(16)))
#define METALANG99_PRIV_div_32_32() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_33_1()  ~, (METALANG99_just(v(33)))
#define METALANG99_PRIV_div_33_11() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_33_3()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_33_33() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_34_1()  ~, (METALANG99_just(v(34)))
#define METALANG99_PRIV_div_34_17() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_34_2()  ~, (METALANG99_just(v(17)))
#define METALANG99_PRIV_div_34_34() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_35_1()  ~, (METALANG99_just(v(35)))
#define METALANG99_PRIV_div_35_7()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_35_5()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_35_35() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_36_1()  ~, (METALANG99_just(v(36)))
#define METALANG99_PRIV_div_36_18() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_36_12() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_36_9()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_36_6()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_36_4()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_36_3()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_36_2()  ~, (METALANG99_just(v(18)))
#define METALANG99_PRIV_div_36_36() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_37_1()  ~, (METALANG99_just(v(37)))
#define METALANG99_PRIV_div_37_37() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_38_1()  ~, (METALANG99_just(v(38)))
#define METALANG99_PRIV_div_38_19() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_38_2()  ~, (METALANG99_just(v(19)))
#define METALANG99_PRIV_div_38_38() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_39_1()  ~, (METALANG99_just(v(39)))
#define METALANG99_PRIV_div_39_13() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_39_3()  ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_39_39() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_40_1()  ~, (METALANG99_just(v(40)))
#define METALANG99_PRIV_div_40_20() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_40_10() ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_40_8()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_40_5()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_40_4()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_40_2()  ~, (METALANG99_just(v(20)))
#define METALANG99_PRIV_div_40_40() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_41_1()  ~, (METALANG99_just(v(41)))
#define METALANG99_PRIV_div_41_41() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_42_1()  ~, (METALANG99_just(v(42)))
#define METALANG99_PRIV_div_42_21() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_42_14() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_42_7()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_42_6()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_42_3()  ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_42_2()  ~, (METALANG99_just(v(21)))
#define METALANG99_PRIV_div_42_42() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_43_1()  ~, (METALANG99_just(v(43)))
#define METALANG99_PRIV_div_43_43() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_44_1()  ~, (METALANG99_just(v(44)))
#define METALANG99_PRIV_div_44_22() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_44_11() ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_44_4()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_44_2()  ~, (METALANG99_just(v(22)))
#define METALANG99_PRIV_div_44_44() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_45_1()  ~, (METALANG99_just(v(45)))
#define METALANG99_PRIV_div_45_15() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_45_9()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_45_5()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_45_3()  ~, (METALANG99_just(v(15)))
#define METALANG99_PRIV_div_45_45() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_46_1()  ~, (METALANG99_just(v(46)))
#define METALANG99_PRIV_div_46_23() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_46_2()  ~, (METALANG99_just(v(23)))
#define METALANG99_PRIV_div_46_46() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_47_1()  ~, (METALANG99_just(v(47)))
#define METALANG99_PRIV_div_47_47() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_48_1()  ~, (METALANG99_just(v(48)))
#define METALANG99_PRIV_div_48_24() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_48_16() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_48_12() ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_48_8()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_48_6()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_48_4()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_48_3()  ~, (METALANG99_just(v(16)))
#define METALANG99_PRIV_div_48_2()  ~, (METALANG99_just(v(24)))
#define METALANG99_PRIV_div_48_48() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_49_1()  ~, (METALANG99_just(v(49)))
#define METALANG99_PRIV_div_49_7()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_49_49() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_50_1()  ~, (METALANG99_just(v(50)))
#define METALANG99_PRIV_div_50_25() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_50_10() ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_50_5()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_50_2()  ~, (METALANG99_just(v(25)))
#define METALANG99_PRIV_div_50_50() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_51_1()  ~, (METALANG99_just(v(51)))
#define METALANG99_PRIV_div_51_17() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_51_3()  ~, (METALANG99_just(v(17)))
#define METALANG99_PRIV_div_51_51() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_52_1()  ~, (METALANG99_just(v(52)))
#define METALANG99_PRIV_div_52_26() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_52_13() ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_52_4()  ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_52_2()  ~, (METALANG99_just(v(26)))
#define METALANG99_PRIV_div_52_52() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_53_1()  ~, (METALANG99_just(v(53)))
#define METALANG99_PRIV_div_53_53() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_54_1()  ~, (METALANG99_just(v(54)))
#define METALANG99_PRIV_div_54_27() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_54_18() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_54_9()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_54_6()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_54_3()  ~, (METALANG99_just(v(18)))
#define METALANG99_PRIV_div_54_2()  ~, (METALANG99_just(v(27)))
#define METALANG99_PRIV_div_54_54() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_55_1()  ~, (METALANG99_just(v(55)))
#define METALANG99_PRIV_div_55_11() ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_55_5()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_55_55() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_56_1()  ~, (METALANG99_just(v(56)))
#define METALANG99_PRIV_div_56_28() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_56_14() ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_56_8()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_56_7()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_56_4()  ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_56_2()  ~, (METALANG99_just(v(28)))
#define METALANG99_PRIV_div_56_56() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_57_1()  ~, (METALANG99_just(v(57)))
#define METALANG99_PRIV_div_57_19() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_57_3()  ~, (METALANG99_just(v(19)))
#define METALANG99_PRIV_div_57_57() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_58_1()  ~, (METALANG99_just(v(58)))
#define METALANG99_PRIV_div_58_29() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_58_2()  ~, (METALANG99_just(v(29)))
#define METALANG99_PRIV_div_58_58() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_59_1()  ~, (METALANG99_just(v(59)))
#define METALANG99_PRIV_div_59_59() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_60_1()  ~, (METALANG99_just(v(60)))
#define METALANG99_PRIV_div_60_30() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_60_20() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_60_15() ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_60_12() ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_60_10() ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_60_6()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_60_5()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_60_4()  ~, (METALANG99_just(v(15)))
#define METALANG99_PRIV_div_60_3()  ~, (METALANG99_just(v(20)))
#define METALANG99_PRIV_div_60_2()  ~, (METALANG99_just(v(30)))
#define METALANG99_PRIV_div_60_60() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_61_1()  ~, (METALANG99_just(v(61)))
#define METALANG99_PRIV_div_61_61() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_62_1()  ~, (METALANG99_just(v(62)))
#define METALANG99_PRIV_div_62_31() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_62_2()  ~, (METALANG99_just(v(31)))
#define METALANG99_PRIV_div_62_62() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_63_1()  ~, (METALANG99_just(v(63)))
#define METALANG99_PRIV_div_63_21() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_63_9()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_63_7()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_63_3()  ~, (METALANG99_just(v(21)))
#define METALANG99_PRIV_div_63_63() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_64_1()  ~, (METALANG99_just(v(64)))
#define METALANG99_PRIV_div_64_32() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_64_16() ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_64_8()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_64_4()  ~, (METALANG99_just(v(16)))
#define METALANG99_PRIV_div_64_2()  ~, (METALANG99_just(v(32)))
#define METALANG99_PRIV_div_64_64() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_65_1()  ~, (METALANG99_just(v(65)))
#define METALANG99_PRIV_div_65_13() ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_65_5()  ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_65_65() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_66_1()  ~, (METALANG99_just(v(66)))
#define METALANG99_PRIV_div_66_33() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_66_22() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_66_11() ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_66_6()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_66_3()  ~, (METALANG99_just(v(22)))
#define METALANG99_PRIV_div_66_2()  ~, (METALANG99_just(v(33)))
#define METALANG99_PRIV_div_66_66() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_67_1()  ~, (METALANG99_just(v(67)))
#define METALANG99_PRIV_div_67_67() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_68_1()  ~, (METALANG99_just(v(68)))
#define METALANG99_PRIV_div_68_34() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_68_17() ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_68_4()  ~, (METALANG99_just(v(17)))
#define METALANG99_PRIV_div_68_2()  ~, (METALANG99_just(v(34)))
#define METALANG99_PRIV_div_68_68() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_69_1()  ~, (METALANG99_just(v(69)))
#define METALANG99_PRIV_div_69_23() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_69_3()  ~, (METALANG99_just(v(23)))
#define METALANG99_PRIV_div_69_69() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_70_1()  ~, (METALANG99_just(v(70)))
#define METALANG99_PRIV_div_70_35() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_70_14() ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_70_10() ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_70_7()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_70_5()  ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_70_2()  ~, (METALANG99_just(v(35)))
#define METALANG99_PRIV_div_70_70() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_71_1()  ~, (METALANG99_just(v(71)))
#define METALANG99_PRIV_div_71_71() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_72_1()  ~, (METALANG99_just(v(72)))
#define METALANG99_PRIV_div_72_36() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_72_24() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_72_18() ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_72_12() ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_72_9()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_72_8()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_72_6()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_72_4()  ~, (METALANG99_just(v(18)))
#define METALANG99_PRIV_div_72_3()  ~, (METALANG99_just(v(24)))
#define METALANG99_PRIV_div_72_2()  ~, (METALANG99_just(v(36)))
#define METALANG99_PRIV_div_72_72() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_73_1()  ~, (METALANG99_just(v(73)))
#define METALANG99_PRIV_div_73_73() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_74_1()  ~, (METALANG99_just(v(74)))
#define METALANG99_PRIV_div_74_37() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_74_2()  ~, (METALANG99_just(v(37)))
#define METALANG99_PRIV_div_74_74() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_75_1()  ~, (METALANG99_just(v(75)))
#define METALANG99_PRIV_div_75_25() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_75_15() ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_75_5()  ~, (METALANG99_just(v(15)))
#define METALANG99_PRIV_div_75_3()  ~, (METALANG99_just(v(25)))
#define METALANG99_PRIV_div_75_75() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_76_1()  ~, (METALANG99_just(v(76)))
#define METALANG99_PRIV_div_76_38() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_76_19() ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_76_4()  ~, (METALANG99_just(v(19)))
#define METALANG99_PRIV_div_76_2()  ~, (METALANG99_just(v(38)))
#define METALANG99_PRIV_div_76_76() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_77_1()  ~, (METALANG99_just(v(77)))
#define METALANG99_PRIV_div_77_11() ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_77_7()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_77_77() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_78_1()  ~, (METALANG99_just(v(78)))
#define METALANG99_PRIV_div_78_39() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_78_26() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_78_13() ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_78_6()  ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_78_3()  ~, (METALANG99_just(v(26)))
#define METALANG99_PRIV_div_78_2()  ~, (METALANG99_just(v(39)))
#define METALANG99_PRIV_div_78_78() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_79_1()  ~, (METALANG99_just(v(79)))
#define METALANG99_PRIV_div_79_79() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_80_1()  ~, (METALANG99_just(v(80)))
#define METALANG99_PRIV_div_80_40() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_80_20() ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_80_16() ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_80_10() ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_80_8()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_80_5()  ~, (METALANG99_just(v(16)))
#define METALANG99_PRIV_div_80_4()  ~, (METALANG99_just(v(20)))
#define METALANG99_PRIV_div_80_2()  ~, (METALANG99_just(v(40)))
#define METALANG99_PRIV_div_80_80() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_81_1()  ~, (METALANG99_just(v(81)))
#define METALANG99_PRIV_div_81_27() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_81_9()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_81_3()  ~, (METALANG99_just(v(27)))
#define METALANG99_PRIV_div_81_81() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_82_1()  ~, (METALANG99_just(v(82)))
#define METALANG99_PRIV_div_82_41() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_82_2()  ~, (METALANG99_just(v(41)))
#define METALANG99_PRIV_div_82_82() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_83_1()  ~, (METALANG99_just(v(83)))
#define METALANG99_PRIV_div_83_83() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_84_1()  ~, (METALANG99_just(v(84)))
#define METALANG99_PRIV_div_84_42() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_84_28() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_84_21() ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_84_14() ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_84_12() ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_84_7()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_84_6()  ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_84_4()  ~, (METALANG99_just(v(21)))
#define METALANG99_PRIV_div_84_3()  ~, (METALANG99_just(v(28)))
#define METALANG99_PRIV_div_84_2()  ~, (METALANG99_just(v(42)))
#define METALANG99_PRIV_div_84_84() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_85_1()  ~, (METALANG99_just(v(85)))
#define METALANG99_PRIV_div_85_17() ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_85_5()  ~, (METALANG99_just(v(17)))
#define METALANG99_PRIV_div_85_85() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_86_1()  ~, (METALANG99_just(v(86)))
#define METALANG99_PRIV_div_86_43() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_86_2()  ~, (METALANG99_just(v(43)))
#define METALANG99_PRIV_div_86_86() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_87_1()  ~, (METALANG99_just(v(87)))
#define METALANG99_PRIV_div_87_29() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_87_3()  ~, (METALANG99_just(v(29)))
#define METALANG99_PRIV_div_87_87() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_88_1()  ~, (METALANG99_just(v(88)))
#define METALANG99_PRIV_div_88_44() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_88_22() ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_88_11() ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_88_8()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_88_4()  ~, (METALANG99_just(v(22)))
#define METALANG99_PRIV_div_88_2()  ~, (METALANG99_just(v(44)))
#define METALANG99_PRIV_div_88_88() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_89_1()  ~, (METALANG99_just(v(89)))
#define METALANG99_PRIV_div_89_89() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_90_1()  ~, (METALANG99_just(v(90)))
#define METALANG99_PRIV_div_90_45() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_90_30() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_90_18() ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_90_15() ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_90_10() ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_90_9()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_90_6()  ~, (METALANG99_just(v(15)))
#define METALANG99_PRIV_div_90_5()  ~, (METALANG99_just(v(18)))
#define METALANG99_PRIV_div_90_3()  ~, (METALANG99_just(v(30)))
#define METALANG99_PRIV_div_90_2()  ~, (METALANG99_just(v(45)))
#define METALANG99_PRIV_div_90_90() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_91_1()  ~, (METALANG99_just(v(91)))
#define METALANG99_PRIV_div_91_13() ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_91_7()  ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_91_91() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_92_1()  ~, (METALANG99_just(v(92)))
#define METALANG99_PRIV_div_92_46() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_92_23() ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_92_4()  ~, (METALANG99_just(v(23)))
#define METALANG99_PRIV_div_92_2()  ~, (METALANG99_just(v(46)))
#define METALANG99_PRIV_div_92_92() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_93_1()  ~, (METALANG99_just(v(93)))
#define METALANG99_PRIV_div_93_31() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_93_3()  ~, (METALANG99_just(v(31)))
#define METALANG99_PRIV_div_93_93() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_94_1()  ~, (METALANG99_just(v(94)))
#define METALANG99_PRIV_div_94_47() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_94_2()  ~, (METALANG99_just(v(47)))
#define METALANG99_PRIV_div_94_94() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_95_1()  ~, (METALANG99_just(v(95)))
#define METALANG99_PRIV_div_95_19() ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_95_5()  ~, (METALANG99_just(v(19)))
#define METALANG99_PRIV_div_95_95() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_96_1()  ~, (METALANG99_just(v(96)))
#define METALANG99_PRIV_div_96_48() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_96_32() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_96_24() ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_96_16() ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_96_12() ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_96_8()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_96_6()  ~, (METALANG99_just(v(16)))
#define METALANG99_PRIV_div_96_4()  ~, (METALANG99_just(v(24)))
#define METALANG99_PRIV_div_96_3()  ~, (METALANG99_just(v(32)))
#define METALANG99_PRIV_div_96_2()  ~, (METALANG99_just(v(48)))
#define METALANG99_PRIV_div_96_96() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_97_1()  ~, (METALANG99_just(v(97)))
#define METALANG99_PRIV_div_97_97() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_98_1()  ~, (METALANG99_just(v(98)))
#define METALANG99_PRIV_div_98_49() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_98_14() ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_98_7()  ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_98_2()  ~, (METALANG99_just(v(49)))
#define METALANG99_PRIV_div_98_98() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_99_1()  ~, (METALANG99_just(v(99)))
#define METALANG99_PRIV_div_99_33() ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_99_11() ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_99_9()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_99_3()  ~, (METALANG99_just(v(33)))
#define METALANG99_PRIV_div_99_99() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_100_1()   ~, (METALANG99_just(v(100)))
#define METALANG99_PRIV_div_100_50()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_100_25()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_100_20()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_100_10()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_100_5()   ~, (METALANG99_just(v(20)))
#define METALANG99_PRIV_div_100_4()   ~, (METALANG99_just(v(25)))
#define METALANG99_PRIV_div_100_2()   ~, (METALANG99_just(v(50)))
#define METALANG99_PRIV_div_100_100() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_101_1()   ~, (METALANG99_just(v(101)))
#define METALANG99_PRIV_div_101_101() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_102_1()   ~, (METALANG99_just(v(102)))
#define METALANG99_PRIV_div_102_51()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_102_34()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_102_17()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_102_6()   ~, (METALANG99_just(v(17)))
#define METALANG99_PRIV_div_102_3()   ~, (METALANG99_just(v(34)))
#define METALANG99_PRIV_div_102_2()   ~, (METALANG99_just(v(51)))
#define METALANG99_PRIV_div_102_102() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_103_1()   ~, (METALANG99_just(v(103)))
#define METALANG99_PRIV_div_103_103() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_104_1()   ~, (METALANG99_just(v(104)))
#define METALANG99_PRIV_div_104_52()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_104_26()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_104_13()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_104_8()   ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_104_4()   ~, (METALANG99_just(v(26)))
#define METALANG99_PRIV_div_104_2()   ~, (METALANG99_just(v(52)))
#define METALANG99_PRIV_div_104_104() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_105_1()   ~, (METALANG99_just(v(105)))
#define METALANG99_PRIV_div_105_35()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_105_21()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_105_15()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_105_7()   ~, (METALANG99_just(v(15)))
#define METALANG99_PRIV_div_105_5()   ~, (METALANG99_just(v(21)))
#define METALANG99_PRIV_div_105_3()   ~, (METALANG99_just(v(35)))
#define METALANG99_PRIV_div_105_105() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_106_1()   ~, (METALANG99_just(v(106)))
#define METALANG99_PRIV_div_106_53()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_106_2()   ~, (METALANG99_just(v(53)))
#define METALANG99_PRIV_div_106_106() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_107_1()   ~, (METALANG99_just(v(107)))
#define METALANG99_PRIV_div_107_107() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_108_1()   ~, (METALANG99_just(v(108)))
#define METALANG99_PRIV_div_108_54()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_108_36()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_108_27()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_108_18()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_108_12()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_108_9()   ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_108_6()   ~, (METALANG99_just(v(18)))
#define METALANG99_PRIV_div_108_4()   ~, (METALANG99_just(v(27)))
#define METALANG99_PRIV_div_108_3()   ~, (METALANG99_just(v(36)))
#define METALANG99_PRIV_div_108_2()   ~, (METALANG99_just(v(54)))
#define METALANG99_PRIV_div_108_108() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_109_1()   ~, (METALANG99_just(v(109)))
#define METALANG99_PRIV_div_109_109() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_110_1()   ~, (METALANG99_just(v(110)))
#define METALANG99_PRIV_div_110_55()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_110_22()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_110_11()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_110_10()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_110_5()   ~, (METALANG99_just(v(22)))
#define METALANG99_PRIV_div_110_2()   ~, (METALANG99_just(v(55)))
#define METALANG99_PRIV_div_110_110() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_111_1()   ~, (METALANG99_just(v(111)))
#define METALANG99_PRIV_div_111_37()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_111_3()   ~, (METALANG99_just(v(37)))
#define METALANG99_PRIV_div_111_111() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_112_1()   ~, (METALANG99_just(v(112)))
#define METALANG99_PRIV_div_112_56()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_112_28()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_112_16()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_112_14()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_112_8()   ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_112_7()   ~, (METALANG99_just(v(16)))
#define METALANG99_PRIV_div_112_4()   ~, (METALANG99_just(v(28)))
#define METALANG99_PRIV_div_112_2()   ~, (METALANG99_just(v(56)))
#define METALANG99_PRIV_div_112_112() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_113_1()   ~, (METALANG99_just(v(113)))
#define METALANG99_PRIV_div_113_113() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_114_1()   ~, (METALANG99_just(v(114)))
#define METALANG99_PRIV_div_114_57()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_114_38()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_114_19()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_114_6()   ~, (METALANG99_just(v(19)))
#define METALANG99_PRIV_div_114_3()   ~, (METALANG99_just(v(38)))
#define METALANG99_PRIV_div_114_2()   ~, (METALANG99_just(v(57)))
#define METALANG99_PRIV_div_114_114() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_115_1()   ~, (METALANG99_just(v(115)))
#define METALANG99_PRIV_div_115_23()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_115_5()   ~, (METALANG99_just(v(23)))
#define METALANG99_PRIV_div_115_115() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_116_1()   ~, (METALANG99_just(v(116)))
#define METALANG99_PRIV_div_116_58()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_116_29()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_116_4()   ~, (METALANG99_just(v(29)))
#define METALANG99_PRIV_div_116_2()   ~, (METALANG99_just(v(58)))
#define METALANG99_PRIV_div_116_116() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_117_1()   ~, (METALANG99_just(v(117)))
#define METALANG99_PRIV_div_117_39()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_117_13()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_117_9()   ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_117_3()   ~, (METALANG99_just(v(39)))
#define METALANG99_PRIV_div_117_117() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_118_1()   ~, (METALANG99_just(v(118)))
#define METALANG99_PRIV_div_118_59()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_118_2()   ~, (METALANG99_just(v(59)))
#define METALANG99_PRIV_div_118_118() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_119_1()   ~, (METALANG99_just(v(119)))
#define METALANG99_PRIV_div_119_17()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_119_7()   ~, (METALANG99_just(v(17)))
#define METALANG99_PRIV_div_119_119() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_120_1()   ~, (METALANG99_just(v(120)))
#define METALANG99_PRIV_div_120_60()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_120_40()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_120_30()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_120_24()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_120_20()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_120_15()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_120_12()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_120_10()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_120_8()   ~, (METALANG99_just(v(15)))
#define METALANG99_PRIV_div_120_6()   ~, (METALANG99_just(v(20)))
#define METALANG99_PRIV_div_120_5()   ~, (METALANG99_just(v(24)))
#define METALANG99_PRIV_div_120_4()   ~, (METALANG99_just(v(30)))
#define METALANG99_PRIV_div_120_3()   ~, (METALANG99_just(v(40)))
#define METALANG99_PRIV_div_120_2()   ~, (METALANG99_just(v(60)))
#define METALANG99_PRIV_div_120_120() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_121_1()   ~, (METALANG99_just(v(121)))
#define METALANG99_PRIV_div_121_11()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_121_121() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_122_1()   ~, (METALANG99_just(v(122)))
#define METALANG99_PRIV_div_122_61()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_122_2()   ~, (METALANG99_just(v(61)))
#define METALANG99_PRIV_div_122_122() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_123_1()   ~, (METALANG99_just(v(123)))
#define METALANG99_PRIV_div_123_41()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_123_3()   ~, (METALANG99_just(v(41)))
#define METALANG99_PRIV_div_123_123() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_124_1()   ~, (METALANG99_just(v(124)))
#define METALANG99_PRIV_div_124_62()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_124_31()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_124_4()   ~, (METALANG99_just(v(31)))
#define METALANG99_PRIV_div_124_2()   ~, (METALANG99_just(v(62)))
#define METALANG99_PRIV_div_124_124() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_125_1()   ~, (METALANG99_just(v(125)))
#define METALANG99_PRIV_div_125_25()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_125_5()   ~, (METALANG99_just(v(25)))
#define METALANG99_PRIV_div_125_125() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_126_1()   ~, (METALANG99_just(v(126)))
#define METALANG99_PRIV_div_126_63()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_126_42()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_126_21()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_126_18()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_126_14()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_126_9()   ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_126_7()   ~, (METALANG99_just(v(18)))
#define METALANG99_PRIV_div_126_6()   ~, (METALANG99_just(v(21)))
#define METALANG99_PRIV_div_126_3()   ~, (METALANG99_just(v(42)))
#define METALANG99_PRIV_div_126_2()   ~, (METALANG99_just(v(63)))
#define METALANG99_PRIV_div_126_126() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_127_1()   ~, (METALANG99_just(v(127)))
#define METALANG99_PRIV_div_127_127() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_128_1()   ~, (METALANG99_just(v(128)))
#define METALANG99_PRIV_div_128_64()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_128_32()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_128_16()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_128_8()   ~, (METALANG99_just(v(16)))
#define METALANG99_PRIV_div_128_4()   ~, (METALANG99_just(v(32)))
#define METALANG99_PRIV_div_128_2()   ~, (METALANG99_just(v(64)))
#define METALANG99_PRIV_div_128_128() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_129_1()   ~, (METALANG99_just(v(129)))
#define METALANG99_PRIV_div_129_43()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_129_3()   ~, (METALANG99_just(v(43)))
#define METALANG99_PRIV_div_129_129() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_130_1()   ~, (METALANG99_just(v(130)))
#define METALANG99_PRIV_div_130_65()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_130_26()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_130_13()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_130_10()  ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_130_5()   ~, (METALANG99_just(v(26)))
#define METALANG99_PRIV_div_130_2()   ~, (METALANG99_just(v(65)))
#define METALANG99_PRIV_div_130_130() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_131_1()   ~, (METALANG99_just(v(131)))
#define METALANG99_PRIV_div_131_131() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_132_1()   ~, (METALANG99_just(v(132)))
#define METALANG99_PRIV_div_132_66()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_132_44()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_132_33()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_132_22()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_132_12()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_132_11()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_132_6()   ~, (METALANG99_just(v(22)))
#define METALANG99_PRIV_div_132_4()   ~, (METALANG99_just(v(33)))
#define METALANG99_PRIV_div_132_3()   ~, (METALANG99_just(v(44)))
#define METALANG99_PRIV_div_132_2()   ~, (METALANG99_just(v(66)))
#define METALANG99_PRIV_div_132_132() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_133_1()   ~, (METALANG99_just(v(133)))
#define METALANG99_PRIV_div_133_19()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_133_7()   ~, (METALANG99_just(v(19)))
#define METALANG99_PRIV_div_133_133() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_134_1()   ~, (METALANG99_just(v(134)))
#define METALANG99_PRIV_div_134_67()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_134_2()   ~, (METALANG99_just(v(67)))
#define METALANG99_PRIV_div_134_134() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_135_1()   ~, (METALANG99_just(v(135)))
#define METALANG99_PRIV_div_135_45()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_135_27()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_135_15()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_135_9()   ~, (METALANG99_just(v(15)))
#define METALANG99_PRIV_div_135_5()   ~, (METALANG99_just(v(27)))
#define METALANG99_PRIV_div_135_3()   ~, (METALANG99_just(v(45)))
#define METALANG99_PRIV_div_135_135() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_136_1()   ~, (METALANG99_just(v(136)))
#define METALANG99_PRIV_div_136_68()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_136_34()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_136_17()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_136_8()   ~, (METALANG99_just(v(17)))
#define METALANG99_PRIV_div_136_4()   ~, (METALANG99_just(v(34)))
#define METALANG99_PRIV_div_136_2()   ~, (METALANG99_just(v(68)))
#define METALANG99_PRIV_div_136_136() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_137_1()   ~, (METALANG99_just(v(137)))
#define METALANG99_PRIV_div_137_137() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_138_1()   ~, (METALANG99_just(v(138)))
#define METALANG99_PRIV_div_138_69()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_138_46()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_138_23()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_138_6()   ~, (METALANG99_just(v(23)))
#define METALANG99_PRIV_div_138_3()   ~, (METALANG99_just(v(46)))
#define METALANG99_PRIV_div_138_2()   ~, (METALANG99_just(v(69)))
#define METALANG99_PRIV_div_138_138() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_139_1()   ~, (METALANG99_just(v(139)))
#define METALANG99_PRIV_div_139_139() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_140_1()   ~, (METALANG99_just(v(140)))
#define METALANG99_PRIV_div_140_70()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_140_35()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_140_28()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_140_20()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_140_14()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_140_10()  ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_140_7()   ~, (METALANG99_just(v(20)))
#define METALANG99_PRIV_div_140_5()   ~, (METALANG99_just(v(28)))
#define METALANG99_PRIV_div_140_4()   ~, (METALANG99_just(v(35)))
#define METALANG99_PRIV_div_140_2()   ~, (METALANG99_just(v(70)))
#define METALANG99_PRIV_div_140_140() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_141_1()   ~, (METALANG99_just(v(141)))
#define METALANG99_PRIV_div_141_47()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_141_3()   ~, (METALANG99_just(v(47)))
#define METALANG99_PRIV_div_141_141() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_142_1()   ~, (METALANG99_just(v(142)))
#define METALANG99_PRIV_div_142_71()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_142_2()   ~, (METALANG99_just(v(71)))
#define METALANG99_PRIV_div_142_142() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_143_1()   ~, (METALANG99_just(v(143)))
#define METALANG99_PRIV_div_143_13()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_143_11()  ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_143_143() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_144_1()   ~, (METALANG99_just(v(144)))
#define METALANG99_PRIV_div_144_72()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_144_48()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_144_36()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_144_24()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_144_18()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_144_16()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_144_12()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_144_9()   ~, (METALANG99_just(v(16)))
#define METALANG99_PRIV_div_144_8()   ~, (METALANG99_just(v(18)))
#define METALANG99_PRIV_div_144_6()   ~, (METALANG99_just(v(24)))
#define METALANG99_PRIV_div_144_4()   ~, (METALANG99_just(v(36)))
#define METALANG99_PRIV_div_144_3()   ~, (METALANG99_just(v(48)))
#define METALANG99_PRIV_div_144_2()   ~, (METALANG99_just(v(72)))
#define METALANG99_PRIV_div_144_144() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_145_1()   ~, (METALANG99_just(v(145)))
#define METALANG99_PRIV_div_145_29()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_145_5()   ~, (METALANG99_just(v(29)))
#define METALANG99_PRIV_div_145_145() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_146_1()   ~, (METALANG99_just(v(146)))
#define METALANG99_PRIV_div_146_73()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_146_2()   ~, (METALANG99_just(v(73)))
#define METALANG99_PRIV_div_146_146() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_147_1()   ~, (METALANG99_just(v(147)))
#define METALANG99_PRIV_div_147_49()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_147_21()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_147_7()   ~, (METALANG99_just(v(21)))
#define METALANG99_PRIV_div_147_3()   ~, (METALANG99_just(v(49)))
#define METALANG99_PRIV_div_147_147() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_148_1()   ~, (METALANG99_just(v(148)))
#define METALANG99_PRIV_div_148_74()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_148_37()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_148_4()   ~, (METALANG99_just(v(37)))
#define METALANG99_PRIV_div_148_2()   ~, (METALANG99_just(v(74)))
#define METALANG99_PRIV_div_148_148() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_149_1()   ~, (METALANG99_just(v(149)))
#define METALANG99_PRIV_div_149_149() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_150_1()   ~, (METALANG99_just(v(150)))
#define METALANG99_PRIV_div_150_75()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_150_50()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_150_30()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_150_25()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_150_15()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_150_10()  ~, (METALANG99_just(v(15)))
#define METALANG99_PRIV_div_150_6()   ~, (METALANG99_just(v(25)))
#define METALANG99_PRIV_div_150_5()   ~, (METALANG99_just(v(30)))
#define METALANG99_PRIV_div_150_3()   ~, (METALANG99_just(v(50)))
#define METALANG99_PRIV_div_150_2()   ~, (METALANG99_just(v(75)))
#define METALANG99_PRIV_div_150_150() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_151_1()   ~, (METALANG99_just(v(151)))
#define METALANG99_PRIV_div_151_151() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_152_1()   ~, (METALANG99_just(v(152)))
#define METALANG99_PRIV_div_152_76()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_152_38()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_152_19()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_152_8()   ~, (METALANG99_just(v(19)))
#define METALANG99_PRIV_div_152_4()   ~, (METALANG99_just(v(38)))
#define METALANG99_PRIV_div_152_2()   ~, (METALANG99_just(v(76)))
#define METALANG99_PRIV_div_152_152() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_153_1()   ~, (METALANG99_just(v(153)))
#define METALANG99_PRIV_div_153_51()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_153_17()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_153_9()   ~, (METALANG99_just(v(17)))
#define METALANG99_PRIV_div_153_3()   ~, (METALANG99_just(v(51)))
#define METALANG99_PRIV_div_153_153() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_154_1()   ~, (METALANG99_just(v(154)))
#define METALANG99_PRIV_div_154_77()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_154_22()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_154_14()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_154_11()  ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_154_7()   ~, (METALANG99_just(v(22)))
#define METALANG99_PRIV_div_154_2()   ~, (METALANG99_just(v(77)))
#define METALANG99_PRIV_div_154_154() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_155_1()   ~, (METALANG99_just(v(155)))
#define METALANG99_PRIV_div_155_31()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_155_5()   ~, (METALANG99_just(v(31)))
#define METALANG99_PRIV_div_155_155() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_156_1()   ~, (METALANG99_just(v(156)))
#define METALANG99_PRIV_div_156_78()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_156_52()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_156_39()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_156_26()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_156_13()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_156_12()  ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_156_6()   ~, (METALANG99_just(v(26)))
#define METALANG99_PRIV_div_156_4()   ~, (METALANG99_just(v(39)))
#define METALANG99_PRIV_div_156_3()   ~, (METALANG99_just(v(52)))
#define METALANG99_PRIV_div_156_2()   ~, (METALANG99_just(v(78)))
#define METALANG99_PRIV_div_156_156() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_157_1()   ~, (METALANG99_just(v(157)))
#define METALANG99_PRIV_div_157_157() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_158_1()   ~, (METALANG99_just(v(158)))
#define METALANG99_PRIV_div_158_79()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_158_2()   ~, (METALANG99_just(v(79)))
#define METALANG99_PRIV_div_158_158() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_159_1()   ~, (METALANG99_just(v(159)))
#define METALANG99_PRIV_div_159_53()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_159_3()   ~, (METALANG99_just(v(53)))
#define METALANG99_PRIV_div_159_159() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_160_1()   ~, (METALANG99_just(v(160)))
#define METALANG99_PRIV_div_160_80()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_160_40()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_160_32()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_160_20()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_160_16()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_160_10()  ~, (METALANG99_just(v(16)))
#define METALANG99_PRIV_div_160_8()   ~, (METALANG99_just(v(20)))
#define METALANG99_PRIV_div_160_5()   ~, (METALANG99_just(v(32)))
#define METALANG99_PRIV_div_160_4()   ~, (METALANG99_just(v(40)))
#define METALANG99_PRIV_div_160_2()   ~, (METALANG99_just(v(80)))
#define METALANG99_PRIV_div_160_160() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_161_1()   ~, (METALANG99_just(v(161)))
#define METALANG99_PRIV_div_161_23()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_161_7()   ~, (METALANG99_just(v(23)))
#define METALANG99_PRIV_div_161_161() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_162_1()   ~, (METALANG99_just(v(162)))
#define METALANG99_PRIV_div_162_81()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_162_54()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_162_27()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_162_18()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_162_9()   ~, (METALANG99_just(v(18)))
#define METALANG99_PRIV_div_162_6()   ~, (METALANG99_just(v(27)))
#define METALANG99_PRIV_div_162_3()   ~, (METALANG99_just(v(54)))
#define METALANG99_PRIV_div_162_2()   ~, (METALANG99_just(v(81)))
#define METALANG99_PRIV_div_162_162() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_163_1()   ~, (METALANG99_just(v(163)))
#define METALANG99_PRIV_div_163_163() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_164_1()   ~, (METALANG99_just(v(164)))
#define METALANG99_PRIV_div_164_82()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_164_41()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_164_4()   ~, (METALANG99_just(v(41)))
#define METALANG99_PRIV_div_164_2()   ~, (METALANG99_just(v(82)))
#define METALANG99_PRIV_div_164_164() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_165_1()   ~, (METALANG99_just(v(165)))
#define METALANG99_PRIV_div_165_55()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_165_33()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_165_15()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_165_11()  ~, (METALANG99_just(v(15)))
#define METALANG99_PRIV_div_165_5()   ~, (METALANG99_just(v(33)))
#define METALANG99_PRIV_div_165_3()   ~, (METALANG99_just(v(55)))
#define METALANG99_PRIV_div_165_165() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_166_1()   ~, (METALANG99_just(v(166)))
#define METALANG99_PRIV_div_166_83()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_166_2()   ~, (METALANG99_just(v(83)))
#define METALANG99_PRIV_div_166_166() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_167_1()   ~, (METALANG99_just(v(167)))
#define METALANG99_PRIV_div_167_167() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_168_1()   ~, (METALANG99_just(v(168)))
#define METALANG99_PRIV_div_168_84()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_168_56()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_168_42()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_168_28()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_168_24()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_168_21()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_168_14()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_168_12()  ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_168_8()   ~, (METALANG99_just(v(21)))
#define METALANG99_PRIV_div_168_7()   ~, (METALANG99_just(v(24)))
#define METALANG99_PRIV_div_168_6()   ~, (METALANG99_just(v(28)))
#define METALANG99_PRIV_div_168_4()   ~, (METALANG99_just(v(42)))
#define METALANG99_PRIV_div_168_3()   ~, (METALANG99_just(v(56)))
#define METALANG99_PRIV_div_168_2()   ~, (METALANG99_just(v(84)))
#define METALANG99_PRIV_div_168_168() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_169_1()   ~, (METALANG99_just(v(169)))
#define METALANG99_PRIV_div_169_13()  ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_169_169() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_170_1()   ~, (METALANG99_just(v(170)))
#define METALANG99_PRIV_div_170_85()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_170_34()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_170_17()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_170_10()  ~, (METALANG99_just(v(17)))
#define METALANG99_PRIV_div_170_5()   ~, (METALANG99_just(v(34)))
#define METALANG99_PRIV_div_170_2()   ~, (METALANG99_just(v(85)))
#define METALANG99_PRIV_div_170_170() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_171_1()   ~, (METALANG99_just(v(171)))
#define METALANG99_PRIV_div_171_57()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_171_19()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_171_9()   ~, (METALANG99_just(v(19)))
#define METALANG99_PRIV_div_171_3()   ~, (METALANG99_just(v(57)))
#define METALANG99_PRIV_div_171_171() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_172_1()   ~, (METALANG99_just(v(172)))
#define METALANG99_PRIV_div_172_86()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_172_43()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_172_4()   ~, (METALANG99_just(v(43)))
#define METALANG99_PRIV_div_172_2()   ~, (METALANG99_just(v(86)))
#define METALANG99_PRIV_div_172_172() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_173_1()   ~, (METALANG99_just(v(173)))
#define METALANG99_PRIV_div_173_173() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_174_1()   ~, (METALANG99_just(v(174)))
#define METALANG99_PRIV_div_174_87()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_174_58()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_174_29()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_174_6()   ~, (METALANG99_just(v(29)))
#define METALANG99_PRIV_div_174_3()   ~, (METALANG99_just(v(58)))
#define METALANG99_PRIV_div_174_2()   ~, (METALANG99_just(v(87)))
#define METALANG99_PRIV_div_174_174() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_175_1()   ~, (METALANG99_just(v(175)))
#define METALANG99_PRIV_div_175_35()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_175_25()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_175_7()   ~, (METALANG99_just(v(25)))
#define METALANG99_PRIV_div_175_5()   ~, (METALANG99_just(v(35)))
#define METALANG99_PRIV_div_175_175() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_176_1()   ~, (METALANG99_just(v(176)))
#define METALANG99_PRIV_div_176_88()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_176_44()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_176_22()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_176_16()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_176_11()  ~, (METALANG99_just(v(16)))
#define METALANG99_PRIV_div_176_8()   ~, (METALANG99_just(v(22)))
#define METALANG99_PRIV_div_176_4()   ~, (METALANG99_just(v(44)))
#define METALANG99_PRIV_div_176_2()   ~, (METALANG99_just(v(88)))
#define METALANG99_PRIV_div_176_176() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_177_1()   ~, (METALANG99_just(v(177)))
#define METALANG99_PRIV_div_177_59()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_177_3()   ~, (METALANG99_just(v(59)))
#define METALANG99_PRIV_div_177_177() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_178_1()   ~, (METALANG99_just(v(178)))
#define METALANG99_PRIV_div_178_89()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_178_2()   ~, (METALANG99_just(v(89)))
#define METALANG99_PRIV_div_178_178() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_179_1()   ~, (METALANG99_just(v(179)))
#define METALANG99_PRIV_div_179_179() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_180_1()   ~, (METALANG99_just(v(180)))
#define METALANG99_PRIV_div_180_90()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_180_60()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_180_45()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_180_36()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_180_30()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_180_20()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_180_18()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_180_15()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_180_12()  ~, (METALANG99_just(v(15)))
#define METALANG99_PRIV_div_180_10()  ~, (METALANG99_just(v(18)))
#define METALANG99_PRIV_div_180_9()   ~, (METALANG99_just(v(20)))
#define METALANG99_PRIV_div_180_6()   ~, (METALANG99_just(v(30)))
#define METALANG99_PRIV_div_180_5()   ~, (METALANG99_just(v(36)))
#define METALANG99_PRIV_div_180_4()   ~, (METALANG99_just(v(45)))
#define METALANG99_PRIV_div_180_3()   ~, (METALANG99_just(v(60)))
#define METALANG99_PRIV_div_180_2()   ~, (METALANG99_just(v(90)))
#define METALANG99_PRIV_div_180_180() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_181_1()   ~, (METALANG99_just(v(181)))
#define METALANG99_PRIV_div_181_181() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_182_1()   ~, (METALANG99_just(v(182)))
#define METALANG99_PRIV_div_182_91()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_182_26()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_182_14()  ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_182_13()  ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_182_7()   ~, (METALANG99_just(v(26)))
#define METALANG99_PRIV_div_182_2()   ~, (METALANG99_just(v(91)))
#define METALANG99_PRIV_div_182_182() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_183_1()   ~, (METALANG99_just(v(183)))
#define METALANG99_PRIV_div_183_61()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_183_3()   ~, (METALANG99_just(v(61)))
#define METALANG99_PRIV_div_183_183() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_184_1()   ~, (METALANG99_just(v(184)))
#define METALANG99_PRIV_div_184_92()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_184_46()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_184_23()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_184_8()   ~, (METALANG99_just(v(23)))
#define METALANG99_PRIV_div_184_4()   ~, (METALANG99_just(v(46)))
#define METALANG99_PRIV_div_184_2()   ~, (METALANG99_just(v(92)))
#define METALANG99_PRIV_div_184_184() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_185_1()   ~, (METALANG99_just(v(185)))
#define METALANG99_PRIV_div_185_37()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_185_5()   ~, (METALANG99_just(v(37)))
#define METALANG99_PRIV_div_185_185() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_186_1()   ~, (METALANG99_just(v(186)))
#define METALANG99_PRIV_div_186_93()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_186_62()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_186_31()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_186_6()   ~, (METALANG99_just(v(31)))
#define METALANG99_PRIV_div_186_3()   ~, (METALANG99_just(v(62)))
#define METALANG99_PRIV_div_186_2()   ~, (METALANG99_just(v(93)))
#define METALANG99_PRIV_div_186_186() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_187_1()   ~, (METALANG99_just(v(187)))
#define METALANG99_PRIV_div_187_17()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_187_11()  ~, (METALANG99_just(v(17)))
#define METALANG99_PRIV_div_187_187() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_188_1()   ~, (METALANG99_just(v(188)))
#define METALANG99_PRIV_div_188_94()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_188_47()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_188_4()   ~, (METALANG99_just(v(47)))
#define METALANG99_PRIV_div_188_2()   ~, (METALANG99_just(v(94)))
#define METALANG99_PRIV_div_188_188() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_189_1()   ~, (METALANG99_just(v(189)))
#define METALANG99_PRIV_div_189_63()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_189_27()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_189_21()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_189_9()   ~, (METALANG99_just(v(21)))
#define METALANG99_PRIV_div_189_7()   ~, (METALANG99_just(v(27)))
#define METALANG99_PRIV_div_189_3()   ~, (METALANG99_just(v(63)))
#define METALANG99_PRIV_div_189_189() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_190_1()   ~, (METALANG99_just(v(190)))
#define METALANG99_PRIV_div_190_95()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_190_38()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_190_19()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_190_10()  ~, (METALANG99_just(v(19)))
#define METALANG99_PRIV_div_190_5()   ~, (METALANG99_just(v(38)))
#define METALANG99_PRIV_div_190_2()   ~, (METALANG99_just(v(95)))
#define METALANG99_PRIV_div_190_190() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_191_1()   ~, (METALANG99_just(v(191)))
#define METALANG99_PRIV_div_191_191() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_192_1()   ~, (METALANG99_just(v(192)))
#define METALANG99_PRIV_div_192_96()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_192_64()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_192_48()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_192_32()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_192_24()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_192_16()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_192_12()  ~, (METALANG99_just(v(16)))
#define METALANG99_PRIV_div_192_8()   ~, (METALANG99_just(v(24)))
#define METALANG99_PRIV_div_192_6()   ~, (METALANG99_just(v(32)))
#define METALANG99_PRIV_div_192_4()   ~, (METALANG99_just(v(48)))
#define METALANG99_PRIV_div_192_3()   ~, (METALANG99_just(v(64)))
#define METALANG99_PRIV_div_192_2()   ~, (METALANG99_just(v(96)))
#define METALANG99_PRIV_div_192_192() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_193_1()   ~, (METALANG99_just(v(193)))
#define METALANG99_PRIV_div_193_193() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_194_1()   ~, (METALANG99_just(v(194)))
#define METALANG99_PRIV_div_194_97()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_194_2()   ~, (METALANG99_just(v(97)))
#define METALANG99_PRIV_div_194_194() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_195_1()   ~, (METALANG99_just(v(195)))
#define METALANG99_PRIV_div_195_65()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_195_39()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_195_15()  ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_195_13()  ~, (METALANG99_just(v(15)))
#define METALANG99_PRIV_div_195_5()   ~, (METALANG99_just(v(39)))
#define METALANG99_PRIV_div_195_3()   ~, (METALANG99_just(v(65)))
#define METALANG99_PRIV_div_195_195() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_196_1()   ~, (METALANG99_just(v(196)))
#define METALANG99_PRIV_div_196_98()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_196_49()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_196_28()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_196_14()  ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_196_7()   ~, (METALANG99_just(v(28)))
#define METALANG99_PRIV_div_196_4()   ~, (METALANG99_just(v(49)))
#define METALANG99_PRIV_div_196_2()   ~, (METALANG99_just(v(98)))
#define METALANG99_PRIV_div_196_196() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_197_1()   ~, (METALANG99_just(v(197)))
#define METALANG99_PRIV_div_197_197() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_198_1()   ~, (METALANG99_just(v(198)))
#define METALANG99_PRIV_div_198_99()  ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_198_66()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_198_33()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_198_22()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_198_18()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_198_11()  ~, (METALANG99_just(v(18)))
#define METALANG99_PRIV_div_198_9()   ~, (METALANG99_just(v(22)))
#define METALANG99_PRIV_div_198_6()   ~, (METALANG99_just(v(33)))
#define METALANG99_PRIV_div_198_3()   ~, (METALANG99_just(v(66)))
#define METALANG99_PRIV_div_198_2()   ~, (METALANG99_just(v(99)))
#define METALANG99_PRIV_div_198_198() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_199_1()   ~, (METALANG99_just(v(199)))
#define METALANG99_PRIV_div_199_199() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_200_1()   ~, (METALANG99_just(v(200)))
#define METALANG99_PRIV_div_200_100() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_200_50()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_200_40()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_200_25()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_200_20()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_200_10()  ~, (METALANG99_just(v(20)))
#define METALANG99_PRIV_div_200_8()   ~, (METALANG99_just(v(25)))
#define METALANG99_PRIV_div_200_5()   ~, (METALANG99_just(v(40)))
#define METALANG99_PRIV_div_200_4()   ~, (METALANG99_just(v(50)))
#define METALANG99_PRIV_div_200_2()   ~, (METALANG99_just(v(100)))
#define METALANG99_PRIV_div_200_200() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_201_1()   ~, (METALANG99_just(v(201)))
#define METALANG99_PRIV_div_201_67()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_201_3()   ~, (METALANG99_just(v(67)))
#define METALANG99_PRIV_div_201_201() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_202_1()   ~, (METALANG99_just(v(202)))
#define METALANG99_PRIV_div_202_101() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_202_2()   ~, (METALANG99_just(v(101)))
#define METALANG99_PRIV_div_202_202() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_203_1()   ~, (METALANG99_just(v(203)))
#define METALANG99_PRIV_div_203_29()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_203_7()   ~, (METALANG99_just(v(29)))
#define METALANG99_PRIV_div_203_203() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_204_1()   ~, (METALANG99_just(v(204)))
#define METALANG99_PRIV_div_204_102() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_204_68()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_204_51()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_204_34()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_204_17()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_204_12()  ~, (METALANG99_just(v(17)))
#define METALANG99_PRIV_div_204_6()   ~, (METALANG99_just(v(34)))
#define METALANG99_PRIV_div_204_4()   ~, (METALANG99_just(v(51)))
#define METALANG99_PRIV_div_204_3()   ~, (METALANG99_just(v(68)))
#define METALANG99_PRIV_div_204_2()   ~, (METALANG99_just(v(102)))
#define METALANG99_PRIV_div_204_204() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_205_1()   ~, (METALANG99_just(v(205)))
#define METALANG99_PRIV_div_205_41()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_205_5()   ~, (METALANG99_just(v(41)))
#define METALANG99_PRIV_div_205_205() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_206_1()   ~, (METALANG99_just(v(206)))
#define METALANG99_PRIV_div_206_103() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_206_2()   ~, (METALANG99_just(v(103)))
#define METALANG99_PRIV_div_206_206() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_207_1()   ~, (METALANG99_just(v(207)))
#define METALANG99_PRIV_div_207_69()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_207_23()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_207_9()   ~, (METALANG99_just(v(23)))
#define METALANG99_PRIV_div_207_3()   ~, (METALANG99_just(v(69)))
#define METALANG99_PRIV_div_207_207() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_208_1()   ~, (METALANG99_just(v(208)))
#define METALANG99_PRIV_div_208_104() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_208_52()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_208_26()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_208_16()  ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_208_13()  ~, (METALANG99_just(v(16)))
#define METALANG99_PRIV_div_208_8()   ~, (METALANG99_just(v(26)))
#define METALANG99_PRIV_div_208_4()   ~, (METALANG99_just(v(52)))
#define METALANG99_PRIV_div_208_2()   ~, (METALANG99_just(v(104)))
#define METALANG99_PRIV_div_208_208() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_209_1()   ~, (METALANG99_just(v(209)))
#define METALANG99_PRIV_div_209_19()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_209_11()  ~, (METALANG99_just(v(19)))
#define METALANG99_PRIV_div_209_209() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_210_1()   ~, (METALANG99_just(v(210)))
#define METALANG99_PRIV_div_210_105() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_210_70()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_210_42()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_210_35()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_210_30()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_210_21()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_210_15()  ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_210_14()  ~, (METALANG99_just(v(15)))
#define METALANG99_PRIV_div_210_10()  ~, (METALANG99_just(v(21)))
#define METALANG99_PRIV_div_210_7()   ~, (METALANG99_just(v(30)))
#define METALANG99_PRIV_div_210_6()   ~, (METALANG99_just(v(35)))
#define METALANG99_PRIV_div_210_5()   ~, (METALANG99_just(v(42)))
#define METALANG99_PRIV_div_210_3()   ~, (METALANG99_just(v(70)))
#define METALANG99_PRIV_div_210_2()   ~, (METALANG99_just(v(105)))
#define METALANG99_PRIV_div_210_210() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_211_1()   ~, (METALANG99_just(v(211)))
#define METALANG99_PRIV_div_211_211() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_212_1()   ~, (METALANG99_just(v(212)))
#define METALANG99_PRIV_div_212_106() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_212_53()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_212_4()   ~, (METALANG99_just(v(53)))
#define METALANG99_PRIV_div_212_2()   ~, (METALANG99_just(v(106)))
#define METALANG99_PRIV_div_212_212() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_213_1()   ~, (METALANG99_just(v(213)))
#define METALANG99_PRIV_div_213_71()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_213_3()   ~, (METALANG99_just(v(71)))
#define METALANG99_PRIV_div_213_213() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_214_1()   ~, (METALANG99_just(v(214)))
#define METALANG99_PRIV_div_214_107() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_214_2()   ~, (METALANG99_just(v(107)))
#define METALANG99_PRIV_div_214_214() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_215_1()   ~, (METALANG99_just(v(215)))
#define METALANG99_PRIV_div_215_43()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_215_5()   ~, (METALANG99_just(v(43)))
#define METALANG99_PRIV_div_215_215() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_216_1()   ~, (METALANG99_just(v(216)))
#define METALANG99_PRIV_div_216_108() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_216_72()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_216_54()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_216_36()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_216_27()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_216_24()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_216_18()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_216_12()  ~, (METALANG99_just(v(18)))
#define METALANG99_PRIV_div_216_9()   ~, (METALANG99_just(v(24)))
#define METALANG99_PRIV_div_216_8()   ~, (METALANG99_just(v(27)))
#define METALANG99_PRIV_div_216_6()   ~, (METALANG99_just(v(36)))
#define METALANG99_PRIV_div_216_4()   ~, (METALANG99_just(v(54)))
#define METALANG99_PRIV_div_216_3()   ~, (METALANG99_just(v(72)))
#define METALANG99_PRIV_div_216_2()   ~, (METALANG99_just(v(108)))
#define METALANG99_PRIV_div_216_216() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_217_1()   ~, (METALANG99_just(v(217)))
#define METALANG99_PRIV_div_217_31()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_217_7()   ~, (METALANG99_just(v(31)))
#define METALANG99_PRIV_div_217_217() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_218_1()   ~, (METALANG99_just(v(218)))
#define METALANG99_PRIV_div_218_109() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_218_2()   ~, (METALANG99_just(v(109)))
#define METALANG99_PRIV_div_218_218() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_219_1()   ~, (METALANG99_just(v(219)))
#define METALANG99_PRIV_div_219_73()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_219_3()   ~, (METALANG99_just(v(73)))
#define METALANG99_PRIV_div_219_219() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_220_1()   ~, (METALANG99_just(v(220)))
#define METALANG99_PRIV_div_220_110() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_220_55()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_220_44()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_220_22()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_220_20()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_220_11()  ~, (METALANG99_just(v(20)))
#define METALANG99_PRIV_div_220_10()  ~, (METALANG99_just(v(22)))
#define METALANG99_PRIV_div_220_5()   ~, (METALANG99_just(v(44)))
#define METALANG99_PRIV_div_220_4()   ~, (METALANG99_just(v(55)))
#define METALANG99_PRIV_div_220_2()   ~, (METALANG99_just(v(110)))
#define METALANG99_PRIV_div_220_220() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_221_1()   ~, (METALANG99_just(v(221)))
#define METALANG99_PRIV_div_221_17()  ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_221_13()  ~, (METALANG99_just(v(17)))
#define METALANG99_PRIV_div_221_221() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_222_1()   ~, (METALANG99_just(v(222)))
#define METALANG99_PRIV_div_222_111() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_222_74()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_222_37()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_222_6()   ~, (METALANG99_just(v(37)))
#define METALANG99_PRIV_div_222_3()   ~, (METALANG99_just(v(74)))
#define METALANG99_PRIV_div_222_2()   ~, (METALANG99_just(v(111)))
#define METALANG99_PRIV_div_222_222() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_223_1()   ~, (METALANG99_just(v(223)))
#define METALANG99_PRIV_div_223_223() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_224_1()   ~, (METALANG99_just(v(224)))
#define METALANG99_PRIV_div_224_112() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_224_56()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_224_32()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_224_28()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_224_16()  ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_224_14()  ~, (METALANG99_just(v(16)))
#define METALANG99_PRIV_div_224_8()   ~, (METALANG99_just(v(28)))
#define METALANG99_PRIV_div_224_7()   ~, (METALANG99_just(v(32)))
#define METALANG99_PRIV_div_224_4()   ~, (METALANG99_just(v(56)))
#define METALANG99_PRIV_div_224_2()   ~, (METALANG99_just(v(112)))
#define METALANG99_PRIV_div_224_224() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_225_1()   ~, (METALANG99_just(v(225)))
#define METALANG99_PRIV_div_225_75()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_225_45()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_225_25()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_225_15()  ~, (METALANG99_just(v(15)))
#define METALANG99_PRIV_div_225_9()   ~, (METALANG99_just(v(25)))
#define METALANG99_PRIV_div_225_5()   ~, (METALANG99_just(v(45)))
#define METALANG99_PRIV_div_225_3()   ~, (METALANG99_just(v(75)))
#define METALANG99_PRIV_div_225_225() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_226_1()   ~, (METALANG99_just(v(226)))
#define METALANG99_PRIV_div_226_113() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_226_2()   ~, (METALANG99_just(v(113)))
#define METALANG99_PRIV_div_226_226() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_227_1()   ~, (METALANG99_just(v(227)))
#define METALANG99_PRIV_div_227_227() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_228_1()   ~, (METALANG99_just(v(228)))
#define METALANG99_PRIV_div_228_114() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_228_76()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_228_57()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_228_38()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_228_19()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_228_12()  ~, (METALANG99_just(v(19)))
#define METALANG99_PRIV_div_228_6()   ~, (METALANG99_just(v(38)))
#define METALANG99_PRIV_div_228_4()   ~, (METALANG99_just(v(57)))
#define METALANG99_PRIV_div_228_3()   ~, (METALANG99_just(v(76)))
#define METALANG99_PRIV_div_228_2()   ~, (METALANG99_just(v(114)))
#define METALANG99_PRIV_div_228_228() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_229_1()   ~, (METALANG99_just(v(229)))
#define METALANG99_PRIV_div_229_229() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_230_1()   ~, (METALANG99_just(v(230)))
#define METALANG99_PRIV_div_230_115() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_230_46()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_230_23()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_230_10()  ~, (METALANG99_just(v(23)))
#define METALANG99_PRIV_div_230_5()   ~, (METALANG99_just(v(46)))
#define METALANG99_PRIV_div_230_2()   ~, (METALANG99_just(v(115)))
#define METALANG99_PRIV_div_230_230() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_231_1()   ~, (METALANG99_just(v(231)))
#define METALANG99_PRIV_div_231_77()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_231_33()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_231_21()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_231_11()  ~, (METALANG99_just(v(21)))
#define METALANG99_PRIV_div_231_7()   ~, (METALANG99_just(v(33)))
#define METALANG99_PRIV_div_231_3()   ~, (METALANG99_just(v(77)))
#define METALANG99_PRIV_div_231_231() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_232_1()   ~, (METALANG99_just(v(232)))
#define METALANG99_PRIV_div_232_116() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_232_58()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_232_29()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_232_8()   ~, (METALANG99_just(v(29)))
#define METALANG99_PRIV_div_232_4()   ~, (METALANG99_just(v(58)))
#define METALANG99_PRIV_div_232_2()   ~, (METALANG99_just(v(116)))
#define METALANG99_PRIV_div_232_232() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_233_1()   ~, (METALANG99_just(v(233)))
#define METALANG99_PRIV_div_233_233() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_234_1()   ~, (METALANG99_just(v(234)))
#define METALANG99_PRIV_div_234_117() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_234_78()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_234_39()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_234_26()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_234_18()  ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_234_13()  ~, (METALANG99_just(v(18)))
#define METALANG99_PRIV_div_234_9()   ~, (METALANG99_just(v(26)))
#define METALANG99_PRIV_div_234_6()   ~, (METALANG99_just(v(39)))
#define METALANG99_PRIV_div_234_3()   ~, (METALANG99_just(v(78)))
#define METALANG99_PRIV_div_234_2()   ~, (METALANG99_just(v(117)))
#define METALANG99_PRIV_div_234_234() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_235_1()   ~, (METALANG99_just(v(235)))
#define METALANG99_PRIV_div_235_47()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_235_5()   ~, (METALANG99_just(v(47)))
#define METALANG99_PRIV_div_235_235() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_236_1()   ~, (METALANG99_just(v(236)))
#define METALANG99_PRIV_div_236_118() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_236_59()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_236_4()   ~, (METALANG99_just(v(59)))
#define METALANG99_PRIV_div_236_2()   ~, (METALANG99_just(v(118)))
#define METALANG99_PRIV_div_236_236() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_237_1()   ~, (METALANG99_just(v(237)))
#define METALANG99_PRIV_div_237_79()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_237_3()   ~, (METALANG99_just(v(79)))
#define METALANG99_PRIV_div_237_237() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_238_1()   ~, (METALANG99_just(v(238)))
#define METALANG99_PRIV_div_238_119() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_238_34()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_238_17()  ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_238_14()  ~, (METALANG99_just(v(17)))
#define METALANG99_PRIV_div_238_7()   ~, (METALANG99_just(v(34)))
#define METALANG99_PRIV_div_238_2()   ~, (METALANG99_just(v(119)))
#define METALANG99_PRIV_div_238_238() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_239_1()   ~, (METALANG99_just(v(239)))
#define METALANG99_PRIV_div_239_239() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_240_1()   ~, (METALANG99_just(v(240)))
#define METALANG99_PRIV_div_240_120() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_240_80()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_240_60()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_240_48()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_240_40()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_240_30()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_240_24()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_240_20()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_240_16()  ~, (METALANG99_just(v(15)))
#define METALANG99_PRIV_div_240_15()  ~, (METALANG99_just(v(16)))
#define METALANG99_PRIV_div_240_12()  ~, (METALANG99_just(v(20)))
#define METALANG99_PRIV_div_240_10()  ~, (METALANG99_just(v(24)))
#define METALANG99_PRIV_div_240_8()   ~, (METALANG99_just(v(30)))
#define METALANG99_PRIV_div_240_6()   ~, (METALANG99_just(v(40)))
#define METALANG99_PRIV_div_240_5()   ~, (METALANG99_just(v(48)))
#define METALANG99_PRIV_div_240_4()   ~, (METALANG99_just(v(60)))
#define METALANG99_PRIV_div_240_3()   ~, (METALANG99_just(v(80)))
#define METALANG99_PRIV_div_240_2()   ~, (METALANG99_just(v(120)))
#define METALANG99_PRIV_div_240_240() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_241_1()   ~, (METALANG99_just(v(241)))
#define METALANG99_PRIV_div_241_241() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_242_1()   ~, (METALANG99_just(v(242)))
#define METALANG99_PRIV_div_242_121() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_242_22()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_242_11()  ~, (METALANG99_just(v(22)))
#define METALANG99_PRIV_div_242_2()   ~, (METALANG99_just(v(121)))
#define METALANG99_PRIV_div_242_242() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_243_1()   ~, (METALANG99_just(v(243)))
#define METALANG99_PRIV_div_243_81()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_243_27()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_243_9()   ~, (METALANG99_just(v(27)))
#define METALANG99_PRIV_div_243_3()   ~, (METALANG99_just(v(81)))
#define METALANG99_PRIV_div_243_243() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_244_1()   ~, (METALANG99_just(v(244)))
#define METALANG99_PRIV_div_244_122() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_244_61()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_244_4()   ~, (METALANG99_just(v(61)))
#define METALANG99_PRIV_div_244_2()   ~, (METALANG99_just(v(122)))
#define METALANG99_PRIV_div_244_244() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_245_1()   ~, (METALANG99_just(v(245)))
#define METALANG99_PRIV_div_245_49()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_245_35()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_245_7()   ~, (METALANG99_just(v(35)))
#define METALANG99_PRIV_div_245_5()   ~, (METALANG99_just(v(49)))
#define METALANG99_PRIV_div_245_245() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_246_1()   ~, (METALANG99_just(v(246)))
#define METALANG99_PRIV_div_246_123() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_246_82()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_246_41()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_246_6()   ~, (METALANG99_just(v(41)))
#define METALANG99_PRIV_div_246_3()   ~, (METALANG99_just(v(82)))
#define METALANG99_PRIV_div_246_2()   ~, (METALANG99_just(v(123)))
#define METALANG99_PRIV_div_246_246() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_247_1()   ~, (METALANG99_just(v(247)))
#define METALANG99_PRIV_div_247_19()  ~, (METALANG99_just(v(13)))
#define METALANG99_PRIV_div_247_13()  ~, (METALANG99_just(v(19)))
#define METALANG99_PRIV_div_247_247() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_248_1()   ~, (METALANG99_just(v(248)))
#define METALANG99_PRIV_div_248_124() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_248_62()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_248_31()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_248_8()   ~, (METALANG99_just(v(31)))
#define METALANG99_PRIV_div_248_4()   ~, (METALANG99_just(v(62)))
#define METALANG99_PRIV_div_248_2()   ~, (METALANG99_just(v(124)))
#define METALANG99_PRIV_div_248_248() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_249_1()   ~, (METALANG99_just(v(249)))
#define METALANG99_PRIV_div_249_83()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_249_3()   ~, (METALANG99_just(v(83)))
#define METALANG99_PRIV_div_249_249() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_250_1()   ~, (METALANG99_just(v(250)))
#define METALANG99_PRIV_div_250_125() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_250_50()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_250_25()  ~, (METALANG99_just(v(10)))
#define METALANG99_PRIV_div_250_10()  ~, (METALANG99_just(v(25)))
#define METALANG99_PRIV_div_250_5()   ~, (METALANG99_just(v(50)))
#define METALANG99_PRIV_div_250_2()   ~, (METALANG99_just(v(125)))
#define METALANG99_PRIV_div_250_250() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_251_1()   ~, (METALANG99_just(v(251)))
#define METALANG99_PRIV_div_251_251() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_252_1()   ~, (METALANG99_just(v(252)))
#define METALANG99_PRIV_div_252_126() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_252_84()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_252_63()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_252_42()  ~, (METALANG99_just(v(6)))
#define METALANG99_PRIV_div_252_36()  ~, (METALANG99_just(v(7)))
#define METALANG99_PRIV_div_252_28()  ~, (METALANG99_just(v(9)))
#define METALANG99_PRIV_div_252_21()  ~, (METALANG99_just(v(12)))
#define METALANG99_PRIV_div_252_18()  ~, (METALANG99_just(v(14)))
#define METALANG99_PRIV_div_252_14()  ~, (METALANG99_just(v(18)))
#define METALANG99_PRIV_div_252_12()  ~, (METALANG99_just(v(21)))
#define METALANG99_PRIV_div_252_9()   ~, (METALANG99_just(v(28)))
#define METALANG99_PRIV_div_252_7()   ~, (METALANG99_just(v(36)))
#define METALANG99_PRIV_div_252_6()   ~, (METALANG99_just(v(42)))
#define METALANG99_PRIV_div_252_4()   ~, (METALANG99_just(v(63)))
#define METALANG99_PRIV_div_252_3()   ~, (METALANG99_just(v(84)))
#define METALANG99_PRIV_div_252_2()   ~, (METALANG99_just(v(126)))
#define METALANG99_PRIV_div_252_252() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_253_1()   ~, (METALANG99_just(v(253)))
#define METALANG99_PRIV_div_253_23()  ~, (METALANG99_just(v(11)))
#define METALANG99_PRIV_div_253_11()  ~, (METALANG99_just(v(23)))
#define METALANG99_PRIV_div_253_253() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_254_1()   ~, (METALANG99_just(v(254)))
#define METALANG99_PRIV_div_254_127() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_254_2()   ~, (METALANG99_just(v(127)))
#define METALANG99_PRIV_div_254_254() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_255_1()   ~, (METALANG99_just(v(255)))
#define METALANG99_PRIV_div_255_85()  ~, (METALANG99_just(v(3)))
#define METALANG99_PRIV_div_255_51()  ~, (METALANG99_just(v(5)))
#define METALANG99_PRIV_div_255_17()  ~, (METALANG99_just(v(15)))
#define METALANG99_PRIV_div_255_15()  ~, (METALANG99_just(v(17)))
#define METALANG99_PRIV_div_255_5()   ~, (METALANG99_just(v(51)))
#define METALANG99_PRIV_div_255_3()   ~, (METALANG99_just(v(85)))
#define METALANG99_PRIV_div_255_255() ~, (METALANG99_just(v(1)))

#define METALANG99_PRIV_div_256_1()   ~, (METALANG99_just(v(256)))
#define METALANG99_PRIV_div_256_128() ~, (METALANG99_just(v(2)))
#define METALANG99_PRIV_div_256_64()  ~, (METALANG99_just(v(4)))
#define METALANG99_PRIV_div_256_32()  ~, (METALANG99_just(v(8)))
#define METALANG99_PRIV_div_256_16()  ~, (METALANG99_just(v(16)))
#define METALANG99_PRIV_div_256_8()   ~, (METALANG99_just(v(32)))
#define METALANG99_PRIV_div_256_4()   ~, (METALANG99_just(v(64)))
#define METALANG99_PRIV_div_256_2()   ~, (METALANG99_just(v(128)))
#define METALANG99_PRIV_div_256_256() ~, (METALANG99_just(v(1)))

#endif // METALANG99_UINT_DIV_H
