/*
 * Copyright 1999-2006 University of Chicago
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.globus.ftp.dc;
import org.globus.ftp.DataSource;
import org.globus.ftp.DataSink;
import org.globus.ftp.vanilla.BasicServerControlChannel;

public class GridFTPTransferThreadFactory implements TransferThreadFactory {

    public TransferThread
	getTransferSinkThread(DataChannel dataChannel,
			      SocketBox socketBox,
			      DataSink sink,
			      BasicServerControlChannel localControlChannel,
			      TransferContext context) throws Exception {

	return new GridFTPTransferSinkThread((GridFTPDataChannel) dataChannel,
					     socketBox,
					     sink,
					     localControlChannel,
					     (EBlockParallelTransferContext)context);
    }

    public TransferThread
	getTransferSourceThread(DataChannel dataChannel,
				SocketBox socketBox,
				DataSource source,
				BasicServerControlChannel localControlChannel,
				TransferContext context) throws Exception {

	return new GridFTPTransferSourceThread((GridFTPDataChannel) dataChannel,
					       socketBox,
					       source,
					       localControlChannel,
					       (EBlockParallelTransferContext)context);
    }

}

