/*!
 * \file
 * \ingroup db
 * \brief Database support for modules.
 *
 * Database support functions for modules.
 *
 * @cond
 * WARNING:
 * This file was autogenerated from the XML source file
 * ../../modules/userblacklist/kamailio-userblacklist.xml.
 * It can be regenerated by running 'make modules' in the db/schema
 * directory of the source code. You need to have xsltproc and
 * docbook-xsl stylesheets installed.
 * ALL CHANGES DONE HERE WILL BE LOST IF THE FILE IS REGENERATED
 * @endcond
 */

#ifndef db_userblacklist_h
#define db_userblacklist_h


/* necessary includes */
#include "../../lib/srdb1/db.h"
#include "../../core/str.h"
#include "../../core/ut.h"

#include <string.h>


/* database variables */

extern str userblacklist_db_url;
extern db1_con_t * userblacklist_dbh;
extern db_func_t userblacklist_dbf;

#define userblacklist_DB_URL { "db_url", PARAM_STR, &userblacklist_db_url },

#define userblacklist_DB_TABLE { "userblacklist_table", PARAM_STR, &userblacklist_table },

extern str userblacklist_table;

/* column names */
extern str userblacklist_id_col;
extern str userblacklist_username_col;
extern str userblacklist_domain_col;
extern str userblacklist_prefix_col;
extern str userblacklist_whitelist_col;
#define userblacklist_DB_COLS \
{ "userblacklist_id_col", PARAM_STR, &userblacklist_id_col }, \
{ "userblacklist_username_col", PARAM_STR, &userblacklist_username_col }, \
{ "userblacklist_domain_col", PARAM_STR, &userblacklist_domain_col }, \
{ "userblacklist_prefix_col", PARAM_STR, &userblacklist_prefix_col }, \
{ "userblacklist_whitelist_col", PARAM_STR, &userblacklist_whitelist_col }, \

/* table version */
extern const unsigned int userblacklist_version;

#define globalblacklist_DB_TABLE { "globalblacklist_table", PARAM_STR, &globalblacklist_table },

extern str globalblacklist_table;

/* column names */
extern str globalblacklist_id_col;
extern str globalblacklist_prefix_col;
extern str globalblacklist_whitelist_col;
extern str globalblacklist_description_col;
#define globalblacklist_DB_COLS \
{ "globalblacklist_id_col", PARAM_STR, &globalblacklist_id_col }, \
{ "globalblacklist_prefix_col", PARAM_STR, &globalblacklist_prefix_col }, \
{ "globalblacklist_whitelist_col", PARAM_STR, &globalblacklist_whitelist_col }, \
{ "globalblacklist_description_col", PARAM_STR, &globalblacklist_description_col }, \

/* table version */
extern const unsigned int globalblacklist_version;


/*
 * Closes the DB connection.
 */
void userblacklist_db_close(void);

/*!
 * Initialises the DB API, check the table version and closes the connection.
 * This should be called from the mod_init function.
 *
 * \return 0 means ok, -1 means an error occurred.
 */
int userblacklist_db_init(void);

/*!
 * Initialize the DB connection without checking the table version and DB URL.
 * This should be called from child_init. An already existing database
 * connection will be closed, and a new one created.
 *
 * \return 0 means ok, -1 means an error occurred.
 */
int userblacklist_db_open(void);

#endif
