/*
  Copyright © 2010 Harald Sitter <apachelogger@ubuntu.com>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation; either version 2 of
  the License or (at your option) version 3 or any later version
  accepted by the membership of KDE e.V. (or its successor approved
  by the membership of KDE e.V.), which shall act as a proxy
  defined in Section 14 of version 3 of the license.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "Prober.h"

#include <QtCore/QFile>
#include <QtCore/QTextStream>

#include <QtGui/QPaintEngine>

#include "EngineProbe.h"

Prober::Prober(QObject *parent) :
    QObject(parent)
{
    EngineProbe *probe = new EngineProbe;
    connect(probe, SIGNAL(engineType(int)), SLOT(gotType(int)));
    probe->show();
}

void Prober::gotType(int type)
{
    QPaintEngine::Type type_ = static_cast<QPaintEngine::Type>(type);
    QFile file;
    file.open(stdout, QIODevice::WriteOnly);
    QTextStream out(&file);
    out << "\n\nThe graphics engine in use seems to be:\n";
    out << "----->>>>>  ";
    switch(type_)
    {
    case QPaintEngine::X11 :
        out << "X11"; break;
    case QPaintEngine::Windows :
        out << "Windows"; break;
    case QPaintEngine::QuickDraw :
        out << "QuickDraw"; break;
    case QPaintEngine::CoreGraphics :
        out << "CoreGraphics"; break;
    case QPaintEngine::MacPrinter :
        out << "MacPrinter"; break;
    case QPaintEngine::QWindowSystem :
        out << "QWindowSystem"; break;
    case QPaintEngine::PostScript :
        out << "PostScript"; break;
    case QPaintEngine::OpenGL :
        out << "OpenGL"; break;
    case QPaintEngine::Picture :
        out << "Picture"; break;
    case QPaintEngine::SVG :
        out << "SVG"; break;
    case QPaintEngine::Raster :
        out << "Raster"; break;
    case QPaintEngine::Direct3D :
        out << "Direct3D"; break;
    case QPaintEngine::Pdf :
        out << "Pdf"; break;
    case QPaintEngine::OpenVG :
        out << "OpenVG"; break;
    case QPaintEngine::OpenGL2 :
        out << "OpenGL2"; break;
    case QPaintEngine::PaintBuffer :
        out << "PaintBuffer"; break;
    default:
        out << "Unknown"; break;
    }
    out << "  <<<<<-----\n\n\n";
    file.close();
}
