/*
    This file is part of Akonadi Contact.

    Copyright (c) 2009 Tobias Koenig <tokoe@kde.org>

    This library is free software; you can redistribute it and/or modify it
    under the terms of the GNU Library General Public License as published by
    the Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This library is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
    License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to the
    Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
    02110-1301, USA.
*/

#include "secrecyeditwidget.h"

#include <QVBoxLayout>

#include <kcontacts/addressee.h>
#include <kcontacts/secrecy.h>
#include <KComboBox>

SecrecyEditWidget::SecrecyEditWidget(QWidget *parent)
    : QWidget(parent)
{
    QVBoxLayout *layout = new QVBoxLayout(this);
    layout->setMargin(0);

    mSecrecyCombo = new KComboBox(this);
    layout->addWidget(mSecrecyCombo);

    const KContacts::Secrecy::TypeList list = KContacts::Secrecy::typeList();
    KContacts::Secrecy::TypeList::ConstIterator it;

    // (*it) is the type enum, which is also used as the index in the combo
    KContacts::Secrecy::TypeList::ConstIterator end(list.constEnd());
    for (it = list.constBegin(); it != end; ++it) {
        mSecrecyCombo->insertItem(*it, KContacts::Secrecy::typeLabel(*it));
    }
}

SecrecyEditWidget::~SecrecyEditWidget()
{
}

void SecrecyEditWidget::setReadOnly(bool readOnly)
{
    mSecrecyCombo->setEnabled(!readOnly);
}

void SecrecyEditWidget::loadContact(const KContacts::Addressee &contact)
{
    if (contact.secrecy().type() != KContacts::Secrecy::Invalid) {
        mSecrecyCombo->setCurrentIndex(contact.secrecy().type());
    }
}

void SecrecyEditWidget::storeContact(KContacts::Addressee &contact) const
{
    KContacts::Secrecy secrecy;
    secrecy.setType((KContacts::Secrecy::Type)mSecrecyCombo->currentIndex());

    contact.setSecrecy(secrecy);
}
