
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQNetworkConfigurationManager.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QNetworkConfigurationManager>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QNetworkConfiguration>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtNetworkCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QNetworkConfigurationManager

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QNetworkConfigurationManager::staticMetaObject);
}


// QList<QNetworkConfiguration> QNetworkConfigurationManager::allConfigurations(QFlags<QNetworkConfiguration::StateFlag> flags)


static void _init_f_allConfigurations_c4334 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags", true, "0");
  decl->add_arg<QFlags<QNetworkConfiguration::StateFlag> > (argspec_0);
  decl->set_return<QList<QNetworkConfiguration> > ();
}

static void _call_f_allConfigurations_c4334 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QNetworkConfiguration::StateFlag> arg1 = args ? gsi::arg_reader<QFlags<QNetworkConfiguration::StateFlag> >() (args, heap) : gsi::arg_maker<QFlags<QNetworkConfiguration::StateFlag> >() (0, heap);
  ret.write<QList<QNetworkConfiguration> > ((QList<QNetworkConfiguration>)((QNetworkConfigurationManager *)cls)->allConfigurations (arg1));
}


// QFlags<QNetworkConfigurationManager::Capability> QNetworkConfigurationManager::capabilities()


static void _init_f_capabilities_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QNetworkConfigurationManager::Capability> > ();
}

static void _call_f_capabilities_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QNetworkConfigurationManager::Capability> > ((QFlags<QNetworkConfigurationManager::Capability>)((QNetworkConfigurationManager *)cls)->capabilities ());
}


// QNetworkConfiguration QNetworkConfigurationManager::configurationFromIdentifier(const QString &identifier)


static void _init_f_configurationFromIdentifier_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("identifier");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QNetworkConfiguration > ();
}

static void _call_f_configurationFromIdentifier_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QNetworkConfiguration > ((QNetworkConfiguration)((QNetworkConfigurationManager *)cls)->configurationFromIdentifier (arg1));
}


// QNetworkConfiguration QNetworkConfigurationManager::defaultConfiguration()


static void _init_f_defaultConfiguration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkConfiguration > ();
}

static void _call_f_defaultConfiguration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QNetworkConfiguration > ((QNetworkConfiguration)((QNetworkConfigurationManager *)cls)->defaultConfiguration ());
}


// bool QNetworkConfigurationManager::isOnline()


static void _init_f_isOnline_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isOnline_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QNetworkConfigurationManager *)cls)->isOnline ());
}


// void QNetworkConfigurationManager::updateConfigurations()


static void _init_f_updateConfigurations_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_updateConfigurations_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkConfigurationManager *)cls)->updateConfigurations ();
}


// static QString QNetworkConfigurationManager::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QNetworkConfigurationManager::tr (arg1, arg2, arg3));
}


// static QString QNetworkConfigurationManager::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QNetworkConfigurationManager::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QNetworkConfigurationManager () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("allConfigurations", "@brief Method QList<QNetworkConfiguration> QNetworkConfigurationManager::allConfigurations(QFlags<QNetworkConfiguration::StateFlag> flags)\n", true, &_init_f_allConfigurations_c4334, &_call_f_allConfigurations_c4334);
  methods += new qt_gsi::GenericMethod ("capabilities", "@brief Method QFlags<QNetworkConfigurationManager::Capability> QNetworkConfigurationManager::capabilities()\n", true, &_init_f_capabilities_c0, &_call_f_capabilities_c0);
  methods += new qt_gsi::GenericMethod ("configurationFromIdentifier", "@brief Method QNetworkConfiguration QNetworkConfigurationManager::configurationFromIdentifier(const QString &identifier)\n", true, &_init_f_configurationFromIdentifier_c2025, &_call_f_configurationFromIdentifier_c2025);
  methods += new qt_gsi::GenericMethod ("defaultConfiguration", "@brief Method QNetworkConfiguration QNetworkConfigurationManager::defaultConfiguration()\n", true, &_init_f_defaultConfiguration_c0, &_call_f_defaultConfiguration_c0);
  methods += new qt_gsi::GenericMethod ("isOnline?", "@brief Method bool QNetworkConfigurationManager::isOnline()\n", true, &_init_f_isOnline_c0, &_call_f_isOnline_c0);
  methods += new qt_gsi::GenericMethod ("updateConfigurations", "@brief Method void QNetworkConfigurationManager::updateConfigurations()\n", false, &_init_f_updateConfigurations_0, &_call_f_updateConfigurations_0);
  methods += gsi::qt_signal<const QNetworkConfiguration & > ("configurationAdded(const QNetworkConfiguration &)", "configurationAdded", gsi::arg("config"), "@brief Signal declaration for QNetworkConfigurationManager::configurationAdded(const QNetworkConfiguration &config)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QNetworkConfiguration & > ("configurationChanged(const QNetworkConfiguration &)", "configurationChanged", gsi::arg("config"), "@brief Signal declaration for QNetworkConfigurationManager::configurationChanged(const QNetworkConfiguration &config)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QNetworkConfiguration & > ("configurationRemoved(const QNetworkConfiguration &)", "configurationRemoved", gsi::arg("config"), "@brief Signal declaration for QNetworkConfigurationManager::configurationRemoved(const QNetworkConfiguration &config)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QNetworkConfigurationManager::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QNetworkConfigurationManager::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("onlineStateChanged(bool)", "onlineStateChanged", gsi::arg("isOnline"), "@brief Signal declaration for QNetworkConfigurationManager::onlineStateChanged(bool isOnline)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("updateCompleted()", "updateCompleted", "@brief Signal declaration for QNetworkConfigurationManager::updateCompleted()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QNetworkConfigurationManager::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QNetworkConfigurationManager::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QNetworkConfigurationManager> decl_QNetworkConfigurationManager (qtdecl_QObject (), "QtNetwork", "QNetworkConfigurationManager_Native",
  methods_QNetworkConfigurationManager (),
  "@hide\n@alias QNetworkConfigurationManager");

GSI_QTNETWORK_PUBLIC gsi::Class<QNetworkConfigurationManager> &qtdecl_QNetworkConfigurationManager () { return decl_QNetworkConfigurationManager; }

}


class QNetworkConfigurationManager_Adaptor : public QNetworkConfigurationManager, public qt_gsi::QtObjectBase
{
public:

  virtual ~QNetworkConfigurationManager_Adaptor();

  //  [adaptor ctor] QNetworkConfigurationManager::QNetworkConfigurationManager(QObject *parent)
  QNetworkConfigurationManager_Adaptor() : QNetworkConfigurationManager()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QNetworkConfigurationManager::QNetworkConfigurationManager(QObject *parent)
  QNetworkConfigurationManager_Adaptor(QObject *parent) : QNetworkConfigurationManager(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QNetworkConfigurationManager::isSignalConnected(const QMetaMethod &signal)
  bool fp_QNetworkConfigurationManager_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QNetworkConfigurationManager::isSignalConnected(signal);
  }

  //  [expose] int QNetworkConfigurationManager::receivers(const char *signal)
  int fp_QNetworkConfigurationManager_receivers_c1731 (const char *signal) const {
    return QNetworkConfigurationManager::receivers(signal);
  }

  //  [expose] QObject *QNetworkConfigurationManager::sender()
  QObject * fp_QNetworkConfigurationManager_sender_c0 () const {
    return QNetworkConfigurationManager::sender();
  }

  //  [expose] int QNetworkConfigurationManager::senderSignalIndex()
  int fp_QNetworkConfigurationManager_senderSignalIndex_c0 () const {
    return QNetworkConfigurationManager::senderSignalIndex();
  }

  //  [emitter impl] void QNetworkConfigurationManager::configurationAdded(const QNetworkConfiguration &config)
  void emitter_QNetworkConfigurationManager_configurationAdded_3508(const QNetworkConfiguration &config)
  {
    emit QNetworkConfigurationManager::configurationAdded(config);
  }

  //  [emitter impl] void QNetworkConfigurationManager::configurationChanged(const QNetworkConfiguration &config)
  void emitter_QNetworkConfigurationManager_configurationChanged_3508(const QNetworkConfiguration &config)
  {
    emit QNetworkConfigurationManager::configurationChanged(config);
  }

  //  [emitter impl] void QNetworkConfigurationManager::configurationRemoved(const QNetworkConfiguration &config)
  void emitter_QNetworkConfigurationManager_configurationRemoved_3508(const QNetworkConfiguration &config)
  {
    emit QNetworkConfigurationManager::configurationRemoved(config);
  }

  //  [emitter impl] void QNetworkConfigurationManager::destroyed(QObject *)
  void emitter_QNetworkConfigurationManager_destroyed_1302(QObject *arg1)
  {
    emit QNetworkConfigurationManager::destroyed(arg1);
  }

  //  [adaptor impl] bool QNetworkConfigurationManager::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QNetworkConfigurationManager::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QNetworkConfigurationManager_Adaptor, bool, QEvent *>(&QNetworkConfigurationManager_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QNetworkConfigurationManager::event(arg1);
    }
  }

  //  [adaptor impl] bool QNetworkConfigurationManager::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QNetworkConfigurationManager::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QNetworkConfigurationManager_Adaptor, bool, QObject *, QEvent *>(&QNetworkConfigurationManager_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QNetworkConfigurationManager::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QNetworkConfigurationManager::objectNameChanged(const QString &objectName)
  void emitter_QNetworkConfigurationManager_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QNetworkConfigurationManager::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QNetworkConfigurationManager::onlineStateChanged(bool isOnline)
  void emitter_QNetworkConfigurationManager_onlineStateChanged_864(bool isOnline)
  {
    emit QNetworkConfigurationManager::onlineStateChanged(isOnline);
  }

  //  [emitter impl] void QNetworkConfigurationManager::updateCompleted()
  void emitter_QNetworkConfigurationManager_updateCompleted_0()
  {
    emit QNetworkConfigurationManager::updateCompleted();
  }

  //  [adaptor impl] void QNetworkConfigurationManager::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QNetworkConfigurationManager::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QNetworkConfigurationManager_Adaptor, QChildEvent *>(&QNetworkConfigurationManager_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QNetworkConfigurationManager::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QNetworkConfigurationManager::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QNetworkConfigurationManager::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QNetworkConfigurationManager_Adaptor, QEvent *>(&QNetworkConfigurationManager_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QNetworkConfigurationManager::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QNetworkConfigurationManager::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QNetworkConfigurationManager::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QNetworkConfigurationManager_Adaptor, const QMetaMethod &>(&QNetworkConfigurationManager_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QNetworkConfigurationManager::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QNetworkConfigurationManager::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QNetworkConfigurationManager::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QNetworkConfigurationManager_Adaptor, QTimerEvent *>(&QNetworkConfigurationManager_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QNetworkConfigurationManager::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QNetworkConfigurationManager_Adaptor::~QNetworkConfigurationManager_Adaptor() { }

//  Constructor QNetworkConfigurationManager::QNetworkConfigurationManager(QObject *parent) (adaptor class)

static void _init_ctor_QNetworkConfigurationManager_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QNetworkConfigurationManager_Adaptor> ();
}

static void _call_ctor_QNetworkConfigurationManager_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QNetworkConfigurationManager_Adaptor *> (new QNetworkConfigurationManager_Adaptor (arg1));
}


// void QNetworkConfigurationManager::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkConfigurationManager_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkConfigurationManager_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QNetworkConfigurationManager::configurationAdded(const QNetworkConfiguration &config)

static void _init_emitter_configurationAdded_3508 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("config");
  decl->add_arg<const QNetworkConfiguration & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_configurationAdded_3508 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkConfiguration &arg1 = gsi::arg_reader<const QNetworkConfiguration & >() (args, heap);
  ((QNetworkConfigurationManager_Adaptor *)cls)->emitter_QNetworkConfigurationManager_configurationAdded_3508 (arg1);
}


// emitter void QNetworkConfigurationManager::configurationChanged(const QNetworkConfiguration &config)

static void _init_emitter_configurationChanged_3508 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("config");
  decl->add_arg<const QNetworkConfiguration & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_configurationChanged_3508 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkConfiguration &arg1 = gsi::arg_reader<const QNetworkConfiguration & >() (args, heap);
  ((QNetworkConfigurationManager_Adaptor *)cls)->emitter_QNetworkConfigurationManager_configurationChanged_3508 (arg1);
}


// emitter void QNetworkConfigurationManager::configurationRemoved(const QNetworkConfiguration &config)

static void _init_emitter_configurationRemoved_3508 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("config");
  decl->add_arg<const QNetworkConfiguration & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_configurationRemoved_3508 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkConfiguration &arg1 = gsi::arg_reader<const QNetworkConfiguration & >() (args, heap);
  ((QNetworkConfigurationManager_Adaptor *)cls)->emitter_QNetworkConfigurationManager_configurationRemoved_3508 (arg1);
}


// void QNetworkConfigurationManager::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkConfigurationManager_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkConfigurationManager_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QNetworkConfigurationManager::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QNetworkConfigurationManager_Adaptor *)cls)->emitter_QNetworkConfigurationManager_destroyed_1302 (arg1);
}


// void QNetworkConfigurationManager::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkConfigurationManager_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkConfigurationManager_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QNetworkConfigurationManager::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QNetworkConfigurationManager_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkConfigurationManager_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QNetworkConfigurationManager::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QNetworkConfigurationManager_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkConfigurationManager_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QNetworkConfigurationManager::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QNetworkConfigurationManager_Adaptor *)cls)->fp_QNetworkConfigurationManager_isSignalConnected_c2394 (arg1));
}


// emitter void QNetworkConfigurationManager::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QNetworkConfigurationManager_Adaptor *)cls)->emitter_QNetworkConfigurationManager_objectNameChanged_4567 (arg1);
}


// emitter void QNetworkConfigurationManager::onlineStateChanged(bool isOnline)

static void _init_emitter_onlineStateChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("isOnline");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_onlineStateChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QNetworkConfigurationManager_Adaptor *)cls)->emitter_QNetworkConfigurationManager_onlineStateChanged_864 (arg1);
}


// exposed int QNetworkConfigurationManager::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QNetworkConfigurationManager_Adaptor *)cls)->fp_QNetworkConfigurationManager_receivers_c1731 (arg1));
}


// exposed QObject *QNetworkConfigurationManager::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QNetworkConfigurationManager_Adaptor *)cls)->fp_QNetworkConfigurationManager_sender_c0 ());
}


// exposed int QNetworkConfigurationManager::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QNetworkConfigurationManager_Adaptor *)cls)->fp_QNetworkConfigurationManager_senderSignalIndex_c0 ());
}


// void QNetworkConfigurationManager::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkConfigurationManager_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkConfigurationManager_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QNetworkConfigurationManager::updateCompleted()

static void _init_emitter_updateCompleted_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_updateCompleted_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QNetworkConfigurationManager_Adaptor *)cls)->emitter_QNetworkConfigurationManager_updateCompleted_0 ();
}


namespace gsi
{

gsi::Class<QNetworkConfigurationManager> &qtdecl_QNetworkConfigurationManager ();

static gsi::Methods methods_QNetworkConfigurationManager_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QNetworkConfigurationManager::QNetworkConfigurationManager(QObject *parent)\nThis method creates an object of class QNetworkConfigurationManager.", &_init_ctor_QNetworkConfigurationManager_Adaptor_1302, &_call_ctor_QNetworkConfigurationManager_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QNetworkConfigurationManager::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_configurationAdded", "@brief Emitter for signal void QNetworkConfigurationManager::configurationAdded(const QNetworkConfiguration &config)\nCall this method to emit this signal.", false, &_init_emitter_configurationAdded_3508, &_call_emitter_configurationAdded_3508);
  methods += new qt_gsi::GenericMethod ("emit_configurationChanged", "@brief Emitter for signal void QNetworkConfigurationManager::configurationChanged(const QNetworkConfiguration &config)\nCall this method to emit this signal.", false, &_init_emitter_configurationChanged_3508, &_call_emitter_configurationChanged_3508);
  methods += new qt_gsi::GenericMethod ("emit_configurationRemoved", "@brief Emitter for signal void QNetworkConfigurationManager::configurationRemoved(const QNetworkConfiguration &config)\nCall this method to emit this signal.", false, &_init_emitter_configurationRemoved_3508, &_call_emitter_configurationRemoved_3508);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QNetworkConfigurationManager::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QNetworkConfigurationManager::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QNetworkConfigurationManager::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QNetworkConfigurationManager::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QNetworkConfigurationManager::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QNetworkConfigurationManager::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QNetworkConfigurationManager::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("emit_onlineStateChanged", "@brief Emitter for signal void QNetworkConfigurationManager::onlineStateChanged(bool isOnline)\nCall this method to emit this signal.", false, &_init_emitter_onlineStateChanged_864, &_call_emitter_onlineStateChanged_864);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QNetworkConfigurationManager::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QNetworkConfigurationManager::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QNetworkConfigurationManager::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QNetworkConfigurationManager::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_updateCompleted", "@brief Emitter for signal void QNetworkConfigurationManager::updateCompleted()\nCall this method to emit this signal.", false, &_init_emitter_updateCompleted_0, &_call_emitter_updateCompleted_0);
  return methods;
}

gsi::Class<QNetworkConfigurationManager_Adaptor> decl_QNetworkConfigurationManager_Adaptor (qtdecl_QNetworkConfigurationManager (), "QtNetwork", "QNetworkConfigurationManager",
  methods_QNetworkConfigurationManager_Adaptor (),
  "@qt\n@brief Binding of QNetworkConfigurationManager");

}


//  Implementation of the enum wrapper class for QNetworkConfigurationManager::Capability
namespace qt_gsi
{

static gsi::Enum<QNetworkConfigurationManager::Capability> decl_QNetworkConfigurationManager_Capability_Enum ("QtNetwork", "QNetworkConfigurationManager_Capability",
    gsi::enum_const ("CanStartAndStopInterfaces", QNetworkConfigurationManager::CanStartAndStopInterfaces, "@brief Enum constant QNetworkConfigurationManager::CanStartAndStopInterfaces") +
    gsi::enum_const ("DirectConnectionRouting", QNetworkConfigurationManager::DirectConnectionRouting, "@brief Enum constant QNetworkConfigurationManager::DirectConnectionRouting") +
    gsi::enum_const ("SystemSessionSupport", QNetworkConfigurationManager::SystemSessionSupport, "@brief Enum constant QNetworkConfigurationManager::SystemSessionSupport") +
    gsi::enum_const ("ApplicationLevelRoaming", QNetworkConfigurationManager::ApplicationLevelRoaming, "@brief Enum constant QNetworkConfigurationManager::ApplicationLevelRoaming") +
    gsi::enum_const ("ForcedRoaming", QNetworkConfigurationManager::ForcedRoaming, "@brief Enum constant QNetworkConfigurationManager::ForcedRoaming") +
    gsi::enum_const ("DataStatistics", QNetworkConfigurationManager::DataStatistics, "@brief Enum constant QNetworkConfigurationManager::DataStatistics") +
    gsi::enum_const ("NetworkSessionRequired", QNetworkConfigurationManager::NetworkSessionRequired, "@brief Enum constant QNetworkConfigurationManager::NetworkSessionRequired"),
  "@qt\n@brief This class represents the QNetworkConfigurationManager::Capability enum");

static gsi::QFlagsClass<QNetworkConfigurationManager::Capability > decl_QNetworkConfigurationManager_Capability_Enums ("QtNetwork", "QNetworkConfigurationManager_QFlags_Capability",
  "@qt\n@brief This class represents the QFlags<QNetworkConfigurationManager::Capability> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QNetworkConfigurationManager> inject_QNetworkConfigurationManager_Capability_Enum_in_parent (decl_QNetworkConfigurationManager_Capability_Enum.defs ());
static gsi::ClassExt<QNetworkConfigurationManager> decl_QNetworkConfigurationManager_Capability_Enum_as_child (decl_QNetworkConfigurationManager_Capability_Enum, "Capability");
static gsi::ClassExt<QNetworkConfigurationManager> decl_QNetworkConfigurationManager_Capability_Enums_as_child (decl_QNetworkConfigurationManager_Capability_Enums, "QFlags_Capability");

}

