
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPlainTextEdit.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QPlainTextEdit>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMenu>
#include <QMetaMethod>
#include <QMimeData>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPagedPaintDevice>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QPointF>
#include <QRect>
#include <QRectF>
#include <QRegExp>
#include <QRegion>
#include <QResizeEvent>
#include <QScrollBar>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QStyleOptionFrame>
#include <QTabletEvent>
#include <QTextBlock>
#include <QTextCharFormat>
#include <QTextCursor>
#include <QTextDocument>
#include <QThread>
#include <QTimerEvent>
#include <QUrl>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPlainTextEdit

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QPlainTextEdit::staticMetaObject);
}


// QString QPlainTextEdit::anchorAt(const QPoint &pos)


static void _init_f_anchorAt_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_anchorAt_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QString > ((QString)((QPlainTextEdit *)cls)->anchorAt (arg1));
}


// void QPlainTextEdit::appendHtml(const QString &html)


static void _init_f_appendHtml_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("html");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_appendHtml_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->appendHtml (arg1);
}


// void QPlainTextEdit::appendPlainText(const QString &text)


static void _init_f_appendPlainText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_appendPlainText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->appendPlainText (arg1);
}


// bool QPlainTextEdit::backgroundVisible()


static void _init_f_backgroundVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_backgroundVisible_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPlainTextEdit *)cls)->backgroundVisible ());
}


// int QPlainTextEdit::blockCount()


static void _init_f_blockCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_blockCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPlainTextEdit *)cls)->blockCount ());
}


// bool QPlainTextEdit::canPaste()


static void _init_f_canPaste_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canPaste_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPlainTextEdit *)cls)->canPaste ());
}


// void QPlainTextEdit::centerCursor()


static void _init_f_centerCursor_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_centerCursor_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->centerCursor ();
}


// bool QPlainTextEdit::centerOnScroll()


static void _init_f_centerOnScroll_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_centerOnScroll_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPlainTextEdit *)cls)->centerOnScroll ());
}


// void QPlainTextEdit::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->clear ();
}


// void QPlainTextEdit::copy()


static void _init_f_copy_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_copy_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->copy ();
}


// QMenu *QPlainTextEdit::createStandardContextMenu()


static void _init_f_createStandardContextMenu_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMenu * > ();
}

static void _call_f_createStandardContextMenu_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMenu * > ((QMenu *)((QPlainTextEdit *)cls)->createStandardContextMenu ());
}


// QMenu *QPlainTextEdit::createStandardContextMenu(const QPoint &position)


static void _init_f_createStandardContextMenu_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QMenu * > ();
}

static void _call_f_createStandardContextMenu_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QMenu * > ((QMenu *)((QPlainTextEdit *)cls)->createStandardContextMenu (arg1));
}


// QTextCharFormat QPlainTextEdit::currentCharFormat()


static void _init_f_currentCharFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextCharFormat > ();
}

static void _call_f_currentCharFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextCharFormat > ((QTextCharFormat)((QPlainTextEdit *)cls)->currentCharFormat ());
}


// QTextCursor QPlainTextEdit::cursorForPosition(const QPoint &pos)


static void _init_f_cursorForPosition_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QTextCursor > ();
}

static void _call_f_cursorForPosition_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QTextCursor > ((QTextCursor)((QPlainTextEdit *)cls)->cursorForPosition (arg1));
}


// QRect QPlainTextEdit::cursorRect(const QTextCursor &cursor)


static void _init_f_cursorRect_c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_cursorRect_c2453 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = gsi::arg_reader<const QTextCursor & >() (args, heap);
  ret.write<QRect > ((QRect)((QPlainTextEdit *)cls)->cursorRect (arg1));
}


// QRect QPlainTextEdit::cursorRect()


static void _init_f_cursorRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_cursorRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QPlainTextEdit *)cls)->cursorRect ());
}


// int QPlainTextEdit::cursorWidth()


static void _init_f_cursorWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_cursorWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPlainTextEdit *)cls)->cursorWidth ());
}


// void QPlainTextEdit::cut()


static void _init_f_cut_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_cut_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->cut ();
}


// QTextDocument *QPlainTextEdit::document()


static void _init_f_document_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextDocument * > ();
}

static void _call_f_document_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextDocument * > ((QTextDocument *)((QPlainTextEdit *)cls)->document ());
}


// QString QPlainTextEdit::documentTitle()


static void _init_f_documentTitle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_documentTitle_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QPlainTextEdit *)cls)->documentTitle ());
}


// void QPlainTextEdit::ensureCursorVisible()


static void _init_f_ensureCursorVisible_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_ensureCursorVisible_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->ensureCursorVisible ();
}


// QList<QTextEdit::ExtraSelection> QPlainTextEdit::extraSelections()


static void _init_f_extraSelections_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QTextEdit::ExtraSelection> > ();
}

static void _call_f_extraSelections_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QTextEdit::ExtraSelection> > ((QList<QTextEdit::ExtraSelection>)((QPlainTextEdit *)cls)->extraSelections ());
}


// bool QPlainTextEdit::find(const QString &exp, QFlags<QTextDocument::FindFlag> options)


static void _init_f_find_5261 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("exp");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("options", true, "0");
  decl->add_arg<QFlags<QTextDocument::FindFlag> > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_find_5261 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QFlags<QTextDocument::FindFlag> arg2 = args ? gsi::arg_reader<QFlags<QTextDocument::FindFlag> >() (args, heap) : gsi::arg_maker<QFlags<QTextDocument::FindFlag> >() (0, heap);
  ret.write<bool > ((bool)((QPlainTextEdit *)cls)->find (arg1, arg2));
}


// bool QPlainTextEdit::find(const QRegExp &exp, QFlags<QTextDocument::FindFlag> options)


static void _init_f_find_5217 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("exp");
  decl->add_arg<const QRegExp & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("options", true, "0");
  decl->add_arg<QFlags<QTextDocument::FindFlag> > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_find_5217 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegExp &arg1 = gsi::arg_reader<const QRegExp & >() (args, heap);
  QFlags<QTextDocument::FindFlag> arg2 = args ? gsi::arg_reader<QFlags<QTextDocument::FindFlag> >() (args, heap) : gsi::arg_maker<QFlags<QTextDocument::FindFlag> >() (0, heap);
  ret.write<bool > ((bool)((QPlainTextEdit *)cls)->find (arg1, arg2));
}


// QVariant QPlainTextEdit::inputMethodQuery(Qt::InputMethodQuery property)


static void _init_f_inputMethodQuery_c2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("property");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_inputMethodQuery_c2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QPlainTextEdit *)cls)->inputMethodQuery (qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref()));
}


// QVariant QPlainTextEdit::inputMethodQuery(Qt::InputMethodQuery query, QVariant argument)


static void _init_f_inputMethodQuery_c3554 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("argument");
  decl->add_arg<QVariant > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_inputMethodQuery_c3554 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap);
  QVariant arg2 = gsi::arg_reader<QVariant >() (args, heap);
  ret.write<QVariant > ((QVariant)((QPlainTextEdit *)cls)->inputMethodQuery (qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref(), arg2));
}


// void QPlainTextEdit::insertPlainText(const QString &text)


static void _init_f_insertPlainText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertPlainText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->insertPlainText (arg1);
}


// bool QPlainTextEdit::isReadOnly()


static void _init_f_isReadOnly_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isReadOnly_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPlainTextEdit *)cls)->isReadOnly ());
}


// bool QPlainTextEdit::isUndoRedoEnabled()


static void _init_f_isUndoRedoEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isUndoRedoEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPlainTextEdit *)cls)->isUndoRedoEnabled ());
}


// QPlainTextEdit::LineWrapMode QPlainTextEdit::lineWrapMode()


static void _init_f_lineWrapMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPlainTextEdit::LineWrapMode>::target_type > ();
}

static void _call_f_lineWrapMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPlainTextEdit::LineWrapMode>::target_type > ((qt_gsi::Converter<QPlainTextEdit::LineWrapMode>::target_type)qt_gsi::CppToQtAdaptor<QPlainTextEdit::LineWrapMode>(((QPlainTextEdit *)cls)->lineWrapMode ()));
}


// QVariant QPlainTextEdit::loadResource(int type, const QUrl &name)


static void _init_f_loadResource_2360 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name");
  decl->add_arg<const QUrl & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_loadResource_2360 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QUrl &arg2 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QPlainTextEdit *)cls)->loadResource (arg1, arg2));
}


// int QPlainTextEdit::maximumBlockCount()


static void _init_f_maximumBlockCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maximumBlockCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPlainTextEdit *)cls)->maximumBlockCount ());
}


// void QPlainTextEdit::mergeCurrentCharFormat(const QTextCharFormat &modifier)


static void _init_f_mergeCurrentCharFormat_2814 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("modifier");
  decl->add_arg<const QTextCharFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mergeCurrentCharFormat_2814 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCharFormat &arg1 = gsi::arg_reader<const QTextCharFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->mergeCurrentCharFormat (arg1);
}


// void QPlainTextEdit::moveCursor(QTextCursor::MoveOperation operation, QTextCursor::MoveMode mode)


static void _init_f_moveCursor_5424 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("operation");
  decl->add_arg<const qt_gsi::Converter<QTextCursor::MoveOperation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QTextCursor::MoveAnchor");
  decl->add_arg<const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_moveCursor_5424 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTextCursor::MoveOperation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QTextCursor::MoveOperation>::target_type & >() (args, heap);
  const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QTextCursor::MoveMode>(heap, QTextCursor::MoveAnchor), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->moveCursor (qt_gsi::QtToCppAdaptor<QTextCursor::MoveOperation>(arg1).cref(), qt_gsi::QtToCppAdaptor<QTextCursor::MoveMode>(arg2).cref());
}


// bool QPlainTextEdit::overwriteMode()


static void _init_f_overwriteMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_overwriteMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPlainTextEdit *)cls)->overwriteMode ());
}


// void QPlainTextEdit::paste()


static void _init_f_paste_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_paste_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->paste ();
}


// QString QPlainTextEdit::placeholderText()


static void _init_f_placeholderText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_placeholderText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QPlainTextEdit *)cls)->placeholderText ());
}


// void QPlainTextEdit::print(QPagedPaintDevice *printer)


static void _init_f_print_c2284 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("printer");
  decl->add_arg<QPagedPaintDevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_print_c2284 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPagedPaintDevice *arg1 = gsi::arg_reader<QPagedPaintDevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->print (arg1);
}


// void QPlainTextEdit::redo()


static void _init_f_redo_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_redo_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->redo ();
}


// void QPlainTextEdit::selectAll()


static void _init_f_selectAll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_selectAll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->selectAll ();
}


// void QPlainTextEdit::setBackgroundVisible(bool visible)


static void _init_f_setBackgroundVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackgroundVisible_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setBackgroundVisible (arg1);
}


// void QPlainTextEdit::setCenterOnScroll(bool enabled)


static void _init_f_setCenterOnScroll_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCenterOnScroll_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setCenterOnScroll (arg1);
}


// void QPlainTextEdit::setCurrentCharFormat(const QTextCharFormat &format)


static void _init_f_setCurrentCharFormat_2814 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextCharFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentCharFormat_2814 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCharFormat &arg1 = gsi::arg_reader<const QTextCharFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setCurrentCharFormat (arg1);
}


// void QPlainTextEdit::setCursorWidth(int width)


static void _init_f_setCursorWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCursorWidth_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setCursorWidth (arg1);
}


// void QPlainTextEdit::setDocument(QTextDocument *document)


static void _init_f_setDocument_1955 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("document");
  decl->add_arg<QTextDocument * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDocument_1955 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextDocument *arg1 = gsi::arg_reader<QTextDocument * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setDocument (arg1);
}


// void QPlainTextEdit::setDocumentTitle(const QString &title)


static void _init_f_setDocumentTitle_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDocumentTitle_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setDocumentTitle (arg1);
}


// void QPlainTextEdit::setExtraSelections(const QList<QTextEdit::ExtraSelection> &selections)


static void _init_f_setExtraSelections_4386 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selections");
  decl->add_arg<const QList<QTextEdit::ExtraSelection> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setExtraSelections_4386 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QTextEdit::ExtraSelection> &arg1 = gsi::arg_reader<const QList<QTextEdit::ExtraSelection> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setExtraSelections (arg1);
}


// void QPlainTextEdit::setLineWrapMode(QPlainTextEdit::LineWrapMode mode)


static void _init_f_setLineWrapMode_3135 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QPlainTextEdit::LineWrapMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLineWrapMode_3135 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPlainTextEdit::LineWrapMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPlainTextEdit::LineWrapMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setLineWrapMode (qt_gsi::QtToCppAdaptor<QPlainTextEdit::LineWrapMode>(arg1).cref());
}


// void QPlainTextEdit::setMaximumBlockCount(int maximum)


static void _init_f_setMaximumBlockCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maximum");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumBlockCount_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setMaximumBlockCount (arg1);
}


// void QPlainTextEdit::setOverwriteMode(bool overwrite)


static void _init_f_setOverwriteMode_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("overwrite");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOverwriteMode_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setOverwriteMode (arg1);
}


// void QPlainTextEdit::setPlaceholderText(const QString &placeholderText)


static void _init_f_setPlaceholderText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("placeholderText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPlaceholderText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setPlaceholderText (arg1);
}


// void QPlainTextEdit::setPlainText(const QString &text)


static void _init_f_setPlainText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPlainText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setPlainText (arg1);
}


// void QPlainTextEdit::setReadOnly(bool ro)


static void _init_f_setReadOnly_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ro");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadOnly_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setReadOnly (arg1);
}


// void QPlainTextEdit::setTabChangesFocus(bool b)


static void _init_f_setTabChangesFocus_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabChangesFocus_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setTabChangesFocus (arg1);
}


// void QPlainTextEdit::setTabStopWidth(int width)


static void _init_f_setTabStopWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabStopWidth_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setTabStopWidth (arg1);
}


// void QPlainTextEdit::setTextCursor(const QTextCursor &cursor)


static void _init_f_setTextCursor_2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextCursor_2453 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = gsi::arg_reader<const QTextCursor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setTextCursor (arg1);
}


// void QPlainTextEdit::setTextInteractionFlags(QFlags<Qt::TextInteractionFlag> flags)


static void _init_f_setTextInteractionFlags_3396 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<Qt::TextInteractionFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextInteractionFlags_3396 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::TextInteractionFlag> arg1 = gsi::arg_reader<QFlags<Qt::TextInteractionFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setTextInteractionFlags (arg1);
}


// void QPlainTextEdit::setUndoRedoEnabled(bool enable)


static void _init_f_setUndoRedoEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUndoRedoEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setUndoRedoEnabled (arg1);
}


// void QPlainTextEdit::setWordWrapMode(QTextOption::WrapMode policy)


static void _init_f_setWordWrapMode_2486 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<QTextOption::WrapMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWordWrapMode_2486 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTextOption::WrapMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QTextOption::WrapMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->setWordWrapMode (qt_gsi::QtToCppAdaptor<QTextOption::WrapMode>(arg1).cref());
}


// bool QPlainTextEdit::tabChangesFocus()


static void _init_f_tabChangesFocus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_tabChangesFocus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPlainTextEdit *)cls)->tabChangesFocus ());
}


// int QPlainTextEdit::tabStopWidth()


static void _init_f_tabStopWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_tabStopWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPlainTextEdit *)cls)->tabStopWidth ());
}


// QTextCursor QPlainTextEdit::textCursor()


static void _init_f_textCursor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextCursor > ();
}

static void _call_f_textCursor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextCursor > ((QTextCursor)((QPlainTextEdit *)cls)->textCursor ());
}


// QFlags<Qt::TextInteractionFlag> QPlainTextEdit::textInteractionFlags()


static void _init_f_textInteractionFlags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::TextInteractionFlag> > ();
}

static void _call_f_textInteractionFlags_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::TextInteractionFlag> > ((QFlags<Qt::TextInteractionFlag>)((QPlainTextEdit *)cls)->textInteractionFlags ());
}


// QString QPlainTextEdit::toPlainText()


static void _init_f_toPlainText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toPlainText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QPlainTextEdit *)cls)->toPlainText ());
}


// void QPlainTextEdit::undo()


static void _init_f_undo_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_undo_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->undo ();
}


// QTextOption::WrapMode QPlainTextEdit::wordWrapMode()


static void _init_f_wordWrapMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTextOption::WrapMode>::target_type > ();
}

static void _call_f_wordWrapMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTextOption::WrapMode>::target_type > ((qt_gsi::Converter<QTextOption::WrapMode>::target_type)qt_gsi::CppToQtAdaptor<QTextOption::WrapMode>(((QPlainTextEdit *)cls)->wordWrapMode ()));
}


// void QPlainTextEdit::zoomIn(int range)


static void _init_f_zoomIn_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("range", true, "1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_zoomIn_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (1, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->zoomIn (arg1);
}


// void QPlainTextEdit::zoomOut(int range)


static void _init_f_zoomOut_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("range", true, "1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_zoomOut_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (1, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit *)cls)->zoomOut (arg1);
}


// static QString QPlainTextEdit::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QPlainTextEdit::tr (arg1, arg2, arg3));
}


// static QString QPlainTextEdit::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QPlainTextEdit::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QPlainTextEdit () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("anchorAt", "@brief Method QString QPlainTextEdit::anchorAt(const QPoint &pos)\n", true, &_init_f_anchorAt_c1916, &_call_f_anchorAt_c1916);
  methods += new qt_gsi::GenericMethod ("appendHtml", "@brief Method void QPlainTextEdit::appendHtml(const QString &html)\n", false, &_init_f_appendHtml_2025, &_call_f_appendHtml_2025);
  methods += new qt_gsi::GenericMethod ("appendPlainText", "@brief Method void QPlainTextEdit::appendPlainText(const QString &text)\n", false, &_init_f_appendPlainText_2025, &_call_f_appendPlainText_2025);
  methods += new qt_gsi::GenericMethod (":backgroundVisible", "@brief Method bool QPlainTextEdit::backgroundVisible()\n", true, &_init_f_backgroundVisible_c0, &_call_f_backgroundVisible_c0);
  methods += new qt_gsi::GenericMethod (":blockCount", "@brief Method int QPlainTextEdit::blockCount()\n", true, &_init_f_blockCount_c0, &_call_f_blockCount_c0);
  methods += new qt_gsi::GenericMethod ("canPaste", "@brief Method bool QPlainTextEdit::canPaste()\n", true, &_init_f_canPaste_c0, &_call_f_canPaste_c0);
  methods += new qt_gsi::GenericMethod ("centerCursor", "@brief Method void QPlainTextEdit::centerCursor()\n", false, &_init_f_centerCursor_0, &_call_f_centerCursor_0);
  methods += new qt_gsi::GenericMethod (":centerOnScroll", "@brief Method bool QPlainTextEdit::centerOnScroll()\n", true, &_init_f_centerOnScroll_c0, &_call_f_centerOnScroll_c0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QPlainTextEdit::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("copy", "@brief Method void QPlainTextEdit::copy()\n", false, &_init_f_copy_0, &_call_f_copy_0);
  methods += new qt_gsi::GenericMethod ("createStandardContextMenu", "@brief Method QMenu *QPlainTextEdit::createStandardContextMenu()\n", false, &_init_f_createStandardContextMenu_0, &_call_f_createStandardContextMenu_0);
  methods += new qt_gsi::GenericMethod ("createStandardContextMenu", "@brief Method QMenu *QPlainTextEdit::createStandardContextMenu(const QPoint &position)\n", false, &_init_f_createStandardContextMenu_1916, &_call_f_createStandardContextMenu_1916);
  methods += new qt_gsi::GenericMethod (":currentCharFormat", "@brief Method QTextCharFormat QPlainTextEdit::currentCharFormat()\n", true, &_init_f_currentCharFormat_c0, &_call_f_currentCharFormat_c0);
  methods += new qt_gsi::GenericMethod ("cursorForPosition", "@brief Method QTextCursor QPlainTextEdit::cursorForPosition(const QPoint &pos)\n", true, &_init_f_cursorForPosition_c1916, &_call_f_cursorForPosition_c1916);
  methods += new qt_gsi::GenericMethod ("cursorRect", "@brief Method QRect QPlainTextEdit::cursorRect(const QTextCursor &cursor)\n", true, &_init_f_cursorRect_c2453, &_call_f_cursorRect_c2453);
  methods += new qt_gsi::GenericMethod ("cursorRect", "@brief Method QRect QPlainTextEdit::cursorRect()\n", true, &_init_f_cursorRect_c0, &_call_f_cursorRect_c0);
  methods += new qt_gsi::GenericMethod (":cursorWidth", "@brief Method int QPlainTextEdit::cursorWidth()\n", true, &_init_f_cursorWidth_c0, &_call_f_cursorWidth_c0);
  methods += new qt_gsi::GenericMethod ("cut", "@brief Method void QPlainTextEdit::cut()\n", false, &_init_f_cut_0, &_call_f_cut_0);
  methods += new qt_gsi::GenericMethod (":document", "@brief Method QTextDocument *QPlainTextEdit::document()\n", true, &_init_f_document_c0, &_call_f_document_c0);
  methods += new qt_gsi::GenericMethod (":documentTitle", "@brief Method QString QPlainTextEdit::documentTitle()\n", true, &_init_f_documentTitle_c0, &_call_f_documentTitle_c0);
  methods += new qt_gsi::GenericMethod ("ensureCursorVisible", "@brief Method void QPlainTextEdit::ensureCursorVisible()\n", false, &_init_f_ensureCursorVisible_0, &_call_f_ensureCursorVisible_0);
  methods += new qt_gsi::GenericMethod (":extraSelections", "@brief Method QList<QTextEdit::ExtraSelection> QPlainTextEdit::extraSelections()\n", true, &_init_f_extraSelections_c0, &_call_f_extraSelections_c0);
  methods += new qt_gsi::GenericMethod ("find", "@brief Method bool QPlainTextEdit::find(const QString &exp, QFlags<QTextDocument::FindFlag> options)\n", false, &_init_f_find_5261, &_call_f_find_5261);
  methods += new qt_gsi::GenericMethod ("find", "@brief Method bool QPlainTextEdit::find(const QRegExp &exp, QFlags<QTextDocument::FindFlag> options)\n", false, &_init_f_find_5217, &_call_f_find_5217);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Method QVariant QPlainTextEdit::inputMethodQuery(Qt::InputMethodQuery property)\nThis is a reimplementation of QWidget::inputMethodQuery", true, &_init_f_inputMethodQuery_c2420, &_call_f_inputMethodQuery_c2420);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Method QVariant QPlainTextEdit::inputMethodQuery(Qt::InputMethodQuery query, QVariant argument)\n", true, &_init_f_inputMethodQuery_c3554, &_call_f_inputMethodQuery_c3554);
  methods += new qt_gsi::GenericMethod ("insertPlainText", "@brief Method void QPlainTextEdit::insertPlainText(const QString &text)\n", false, &_init_f_insertPlainText_2025, &_call_f_insertPlainText_2025);
  methods += new qt_gsi::GenericMethod ("isReadOnly?|:readOnly", "@brief Method bool QPlainTextEdit::isReadOnly()\n", true, &_init_f_isReadOnly_c0, &_call_f_isReadOnly_c0);
  methods += new qt_gsi::GenericMethod ("isUndoRedoEnabled?|:undoRedoEnabled", "@brief Method bool QPlainTextEdit::isUndoRedoEnabled()\n", true, &_init_f_isUndoRedoEnabled_c0, &_call_f_isUndoRedoEnabled_c0);
  methods += new qt_gsi::GenericMethod (":lineWrapMode", "@brief Method QPlainTextEdit::LineWrapMode QPlainTextEdit::lineWrapMode()\n", true, &_init_f_lineWrapMode_c0, &_call_f_lineWrapMode_c0);
  methods += new qt_gsi::GenericMethod ("loadResource", "@brief Method QVariant QPlainTextEdit::loadResource(int type, const QUrl &name)\n", false, &_init_f_loadResource_2360, &_call_f_loadResource_2360);
  methods += new qt_gsi::GenericMethod (":maximumBlockCount", "@brief Method int QPlainTextEdit::maximumBlockCount()\n", true, &_init_f_maximumBlockCount_c0, &_call_f_maximumBlockCount_c0);
  methods += new qt_gsi::GenericMethod ("mergeCurrentCharFormat", "@brief Method void QPlainTextEdit::mergeCurrentCharFormat(const QTextCharFormat &modifier)\n", false, &_init_f_mergeCurrentCharFormat_2814, &_call_f_mergeCurrentCharFormat_2814);
  methods += new qt_gsi::GenericMethod ("moveCursor", "@brief Method void QPlainTextEdit::moveCursor(QTextCursor::MoveOperation operation, QTextCursor::MoveMode mode)\n", false, &_init_f_moveCursor_5424, &_call_f_moveCursor_5424);
  methods += new qt_gsi::GenericMethod (":overwriteMode", "@brief Method bool QPlainTextEdit::overwriteMode()\n", true, &_init_f_overwriteMode_c0, &_call_f_overwriteMode_c0);
  methods += new qt_gsi::GenericMethod ("paste", "@brief Method void QPlainTextEdit::paste()\n", false, &_init_f_paste_0, &_call_f_paste_0);
  methods += new qt_gsi::GenericMethod (":placeholderText", "@brief Method QString QPlainTextEdit::placeholderText()\n", true, &_init_f_placeholderText_c0, &_call_f_placeholderText_c0);
  methods += new qt_gsi::GenericMethod ("print", "@brief Method void QPlainTextEdit::print(QPagedPaintDevice *printer)\n", true, &_init_f_print_c2284, &_call_f_print_c2284);
  methods += new qt_gsi::GenericMethod ("redo", "@brief Method void QPlainTextEdit::redo()\n", false, &_init_f_redo_0, &_call_f_redo_0);
  methods += new qt_gsi::GenericMethod ("selectAll", "@brief Method void QPlainTextEdit::selectAll()\n", false, &_init_f_selectAll_0, &_call_f_selectAll_0);
  methods += new qt_gsi::GenericMethod ("setBackgroundVisible|backgroundVisible=", "@brief Method void QPlainTextEdit::setBackgroundVisible(bool visible)\n", false, &_init_f_setBackgroundVisible_864, &_call_f_setBackgroundVisible_864);
  methods += new qt_gsi::GenericMethod ("setCenterOnScroll|centerOnScroll=", "@brief Method void QPlainTextEdit::setCenterOnScroll(bool enabled)\n", false, &_init_f_setCenterOnScroll_864, &_call_f_setCenterOnScroll_864);
  methods += new qt_gsi::GenericMethod ("setCurrentCharFormat|currentCharFormat=", "@brief Method void QPlainTextEdit::setCurrentCharFormat(const QTextCharFormat &format)\n", false, &_init_f_setCurrentCharFormat_2814, &_call_f_setCurrentCharFormat_2814);
  methods += new qt_gsi::GenericMethod ("setCursorWidth|cursorWidth=", "@brief Method void QPlainTextEdit::setCursorWidth(int width)\n", false, &_init_f_setCursorWidth_767, &_call_f_setCursorWidth_767);
  methods += new qt_gsi::GenericMethod ("setDocument|document=", "@brief Method void QPlainTextEdit::setDocument(QTextDocument *document)\n", false, &_init_f_setDocument_1955, &_call_f_setDocument_1955);
  methods += new qt_gsi::GenericMethod ("setDocumentTitle|documentTitle=", "@brief Method void QPlainTextEdit::setDocumentTitle(const QString &title)\n", false, &_init_f_setDocumentTitle_2025, &_call_f_setDocumentTitle_2025);
  methods += new qt_gsi::GenericMethod ("setExtraSelections|extraSelections=", "@brief Method void QPlainTextEdit::setExtraSelections(const QList<QTextEdit::ExtraSelection> &selections)\n", false, &_init_f_setExtraSelections_4386, &_call_f_setExtraSelections_4386);
  methods += new qt_gsi::GenericMethod ("setLineWrapMode|lineWrapMode=", "@brief Method void QPlainTextEdit::setLineWrapMode(QPlainTextEdit::LineWrapMode mode)\n", false, &_init_f_setLineWrapMode_3135, &_call_f_setLineWrapMode_3135);
  methods += new qt_gsi::GenericMethod ("setMaximumBlockCount|maximumBlockCount=", "@brief Method void QPlainTextEdit::setMaximumBlockCount(int maximum)\n", false, &_init_f_setMaximumBlockCount_767, &_call_f_setMaximumBlockCount_767);
  methods += new qt_gsi::GenericMethod ("setOverwriteMode|overwriteMode=", "@brief Method void QPlainTextEdit::setOverwriteMode(bool overwrite)\n", false, &_init_f_setOverwriteMode_864, &_call_f_setOverwriteMode_864);
  methods += new qt_gsi::GenericMethod ("setPlaceholderText|placeholderText=", "@brief Method void QPlainTextEdit::setPlaceholderText(const QString &placeholderText)\n", false, &_init_f_setPlaceholderText_2025, &_call_f_setPlaceholderText_2025);
  methods += new qt_gsi::GenericMethod ("setPlainText|plainText=", "@brief Method void QPlainTextEdit::setPlainText(const QString &text)\n", false, &_init_f_setPlainText_2025, &_call_f_setPlainText_2025);
  methods += new qt_gsi::GenericMethod ("setReadOnly|readOnly=", "@brief Method void QPlainTextEdit::setReadOnly(bool ro)\n", false, &_init_f_setReadOnly_864, &_call_f_setReadOnly_864);
  methods += new qt_gsi::GenericMethod ("setTabChangesFocus|tabChangesFocus=", "@brief Method void QPlainTextEdit::setTabChangesFocus(bool b)\n", false, &_init_f_setTabChangesFocus_864, &_call_f_setTabChangesFocus_864);
  methods += new qt_gsi::GenericMethod ("setTabStopWidth|tabStopWidth=", "@brief Method void QPlainTextEdit::setTabStopWidth(int width)\n", false, &_init_f_setTabStopWidth_767, &_call_f_setTabStopWidth_767);
  methods += new qt_gsi::GenericMethod ("setTextCursor|textCursor=", "@brief Method void QPlainTextEdit::setTextCursor(const QTextCursor &cursor)\n", false, &_init_f_setTextCursor_2453, &_call_f_setTextCursor_2453);
  methods += new qt_gsi::GenericMethod ("setTextInteractionFlags|textInteractionFlags=", "@brief Method void QPlainTextEdit::setTextInteractionFlags(QFlags<Qt::TextInteractionFlag> flags)\n", false, &_init_f_setTextInteractionFlags_3396, &_call_f_setTextInteractionFlags_3396);
  methods += new qt_gsi::GenericMethod ("setUndoRedoEnabled|undoRedoEnabled=", "@brief Method void QPlainTextEdit::setUndoRedoEnabled(bool enable)\n", false, &_init_f_setUndoRedoEnabled_864, &_call_f_setUndoRedoEnabled_864);
  methods += new qt_gsi::GenericMethod ("setWordWrapMode|wordWrapMode=", "@brief Method void QPlainTextEdit::setWordWrapMode(QTextOption::WrapMode policy)\n", false, &_init_f_setWordWrapMode_2486, &_call_f_setWordWrapMode_2486);
  methods += new qt_gsi::GenericMethod (":tabChangesFocus", "@brief Method bool QPlainTextEdit::tabChangesFocus()\n", true, &_init_f_tabChangesFocus_c0, &_call_f_tabChangesFocus_c0);
  methods += new qt_gsi::GenericMethod (":tabStopWidth", "@brief Method int QPlainTextEdit::tabStopWidth()\n", true, &_init_f_tabStopWidth_c0, &_call_f_tabStopWidth_c0);
  methods += new qt_gsi::GenericMethod (":textCursor", "@brief Method QTextCursor QPlainTextEdit::textCursor()\n", true, &_init_f_textCursor_c0, &_call_f_textCursor_c0);
  methods += new qt_gsi::GenericMethod (":textInteractionFlags", "@brief Method QFlags<Qt::TextInteractionFlag> QPlainTextEdit::textInteractionFlags()\n", true, &_init_f_textInteractionFlags_c0, &_call_f_textInteractionFlags_c0);
  methods += new qt_gsi::GenericMethod ("toPlainText", "@brief Method QString QPlainTextEdit::toPlainText()\n", true, &_init_f_toPlainText_c0, &_call_f_toPlainText_c0);
  methods += new qt_gsi::GenericMethod ("undo", "@brief Method void QPlainTextEdit::undo()\n", false, &_init_f_undo_0, &_call_f_undo_0);
  methods += new qt_gsi::GenericMethod (":wordWrapMode", "@brief Method QTextOption::WrapMode QPlainTextEdit::wordWrapMode()\n", true, &_init_f_wordWrapMode_c0, &_call_f_wordWrapMode_c0);
  methods += new qt_gsi::GenericMethod ("zoomIn", "@brief Method void QPlainTextEdit::zoomIn(int range)\n", false, &_init_f_zoomIn_767, &_call_f_zoomIn_767);
  methods += new qt_gsi::GenericMethod ("zoomOut", "@brief Method void QPlainTextEdit::zoomOut(int range)\n", false, &_init_f_zoomOut_767, &_call_f_zoomOut_767);
  methods += gsi::qt_signal<int > ("blockCountChanged(int)", "blockCountChanged", gsi::arg("newBlockCount"), "@brief Signal declaration for QPlainTextEdit::blockCountChanged(int newBlockCount)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("copyAvailable(bool)", "copyAvailable", gsi::arg("b"), "@brief Signal declaration for QPlainTextEdit::copyAvailable(bool b)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("cursorPositionChanged()", "cursorPositionChanged", "@brief Signal declaration for QPlainTextEdit::cursorPositionChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QPlainTextEdit::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QPlainTextEdit::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("modificationChanged(bool)", "modificationChanged", gsi::arg("arg1"), "@brief Signal declaration for QPlainTextEdit::modificationChanged(bool)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QPlainTextEdit::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("redoAvailable(bool)", "redoAvailable", gsi::arg("b"), "@brief Signal declaration for QPlainTextEdit::redoAvailable(bool b)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("selectionChanged()", "selectionChanged", "@brief Signal declaration for QPlainTextEdit::selectionChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("textChanged()", "textChanged", "@brief Signal declaration for QPlainTextEdit::textChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("undoAvailable(bool)", "undoAvailable", gsi::arg("b"), "@brief Signal declaration for QPlainTextEdit::undoAvailable(bool b)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QRect &, int > ("updateRequest(const QRect &, int)", "updateRequest", gsi::arg("rect"), gsi::arg("dy"), "@brief Signal declaration for QPlainTextEdit::updateRequest(const QRect &rect, int dy)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QPlainTextEdit::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QPlainTextEdit::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QPlainTextEdit::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPlainTextEdit::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPlainTextEdit::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QAbstractScrollArea> &qtdecl_QAbstractScrollArea ();

qt_gsi::QtNativeClass<QPlainTextEdit> decl_QPlainTextEdit (qtdecl_QAbstractScrollArea (), "QtWidgets", "QPlainTextEdit_Native",
  methods_QPlainTextEdit (),
  "@hide\n@alias QPlainTextEdit");

GSI_QTWIDGETS_PUBLIC gsi::Class<QPlainTextEdit> &qtdecl_QPlainTextEdit () { return decl_QPlainTextEdit; }

}


class QPlainTextEdit_Adaptor : public QPlainTextEdit, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPlainTextEdit_Adaptor();

  //  [adaptor ctor] QPlainTextEdit::QPlainTextEdit(QWidget *parent)
  QPlainTextEdit_Adaptor() : QPlainTextEdit()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPlainTextEdit::QPlainTextEdit(QWidget *parent)
  QPlainTextEdit_Adaptor(QWidget *parent) : QPlainTextEdit(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPlainTextEdit::QPlainTextEdit(const QString &text, QWidget *parent)
  QPlainTextEdit_Adaptor(const QString &text) : QPlainTextEdit(text)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPlainTextEdit::QPlainTextEdit(const QString &text, QWidget *parent)
  QPlainTextEdit_Adaptor(const QString &text, QWidget *parent) : QPlainTextEdit(text, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] QRectF QPlainTextEdit::blockBoundingGeometry(const QTextBlock &block)
  QRectF fp_QPlainTextEdit_blockBoundingGeometry_c2306 (const QTextBlock &block) const {
    return QPlainTextEdit::blockBoundingGeometry(block);
  }

  //  [expose] QRectF QPlainTextEdit::blockBoundingRect(const QTextBlock &block)
  QRectF fp_QPlainTextEdit_blockBoundingRect_c2306 (const QTextBlock &block) const {
    return QPlainTextEdit::blockBoundingRect(block);
  }

  //  [expose] QPointF QPlainTextEdit::contentOffset()
  QPointF fp_QPlainTextEdit_contentOffset_c0 () const {
    return QPlainTextEdit::contentOffset();
  }

  //  [expose] void QPlainTextEdit::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QPlainTextEdit_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QPlainTextEdit::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QPlainTextEdit::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QPlainTextEdit_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QPlainTextEdit::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] void QPlainTextEdit::drawFrame(QPainter *)
  void fp_QPlainTextEdit_drawFrame_1426 (QPainter *arg1) {
    QPlainTextEdit::drawFrame(arg1);
  }

  //  [expose] QTextBlock QPlainTextEdit::firstVisibleBlock()
  QTextBlock fp_QPlainTextEdit_firstVisibleBlock_c0 () const {
    return QPlainTextEdit::firstVisibleBlock();
  }

  //  [expose] bool QPlainTextEdit::focusNextChild()
  bool fp_QPlainTextEdit_focusNextChild_0 () {
    return QPlainTextEdit::focusNextChild();
  }

  //  [expose] bool QPlainTextEdit::focusPreviousChild()
  bool fp_QPlainTextEdit_focusPreviousChild_0 () {
    return QPlainTextEdit::focusPreviousChild();
  }

  //  [expose] QAbstractTextDocumentLayout::PaintContext QPlainTextEdit::getPaintContext()
  QAbstractTextDocumentLayout::PaintContext fp_QPlainTextEdit_getPaintContext_c0 () const {
    return QPlainTextEdit::getPaintContext();
  }

  //  [expose] void QPlainTextEdit::initStyleOption(QStyleOptionFrame *option)
  void fp_QPlainTextEdit_initStyleOption_c2356 (QStyleOptionFrame *option) const {
    QPlainTextEdit::initStyleOption(option);
  }

  //  [expose] bool QPlainTextEdit::isSignalConnected(const QMetaMethod &signal)
  bool fp_QPlainTextEdit_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QPlainTextEdit::isSignalConnected(signal);
  }

  //  [expose] int QPlainTextEdit::receivers(const char *signal)
  int fp_QPlainTextEdit_receivers_c1731 (const char *signal) const {
    return QPlainTextEdit::receivers(signal);
  }

  //  [expose] QObject *QPlainTextEdit::sender()
  QObject * fp_QPlainTextEdit_sender_c0 () const {
    return QPlainTextEdit::sender();
  }

  //  [expose] int QPlainTextEdit::senderSignalIndex()
  int fp_QPlainTextEdit_senderSignalIndex_c0 () const {
    return QPlainTextEdit::senderSignalIndex();
  }

  //  [expose] void QPlainTextEdit::setViewportMargins(int left, int top, int right, int bottom)
  void fp_QPlainTextEdit_setViewportMargins_2744 (int left, int top, int right, int bottom) {
    QPlainTextEdit::setViewportMargins(left, top, right, bottom);
  }

  //  [expose] void QPlainTextEdit::setViewportMargins(const QMargins &margins)
  void fp_QPlainTextEdit_setViewportMargins_2115 (const QMargins &margins) {
    QPlainTextEdit::setViewportMargins(margins);
  }

  //  [expose] void QPlainTextEdit::updateMicroFocus()
  void fp_QPlainTextEdit_updateMicroFocus_0 () {
    QPlainTextEdit::updateMicroFocus();
  }

  //  [expose] QMargins QPlainTextEdit::viewportMargins()
  QMargins fp_QPlainTextEdit_viewportMargins_c0 () const {
    return QPlainTextEdit::viewportMargins();
  }

  //  [expose] void QPlainTextEdit::zoomInF(float range)
  void fp_QPlainTextEdit_zoomInF_970 (float range) {
    QPlainTextEdit::zoomInF(range);
  }

  //  [emitter impl] void QPlainTextEdit::blockCountChanged(int newBlockCount)
  void emitter_QPlainTextEdit_blockCountChanged_767(int newBlockCount)
  {
    emit QPlainTextEdit::blockCountChanged(newBlockCount);
  }

  //  [emitter impl] void QPlainTextEdit::copyAvailable(bool b)
  void emitter_QPlainTextEdit_copyAvailable_864(bool b)
  {
    emit QPlainTextEdit::copyAvailable(b);
  }

  //  [emitter impl] void QPlainTextEdit::cursorPositionChanged()
  void emitter_QPlainTextEdit_cursorPositionChanged_0()
  {
    emit QPlainTextEdit::cursorPositionChanged();
  }

  //  [emitter impl] void QPlainTextEdit::customContextMenuRequested(const QPoint &pos)
  void emitter_QPlainTextEdit_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QPlainTextEdit::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QPlainTextEdit::destroyed(QObject *)
  void emitter_QPlainTextEdit_destroyed_1302(QObject *arg1)
  {
    emit QPlainTextEdit::destroyed(arg1);
  }

  //  [adaptor impl] bool QPlainTextEdit::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QPlainTextEdit::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QPlainTextEdit_Adaptor, bool>(&QPlainTextEdit_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QPlainTextEdit::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QPlainTextEdit::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QPlainTextEdit::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QPlainTextEdit_Adaptor, int, int>(&QPlainTextEdit_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QPlainTextEdit::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QPlainTextEdit::inputMethodQuery(Qt::InputMethodQuery property)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & property) const
  {
    return QPlainTextEdit::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(property).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery property) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QPlainTextEdit_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QPlainTextEdit_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(property));
    } else {
      return QPlainTextEdit::inputMethodQuery(property);
    }
  }

  //  [adaptor impl] QVariant QPlainTextEdit::loadResource(int type, const QUrl &name)
  QVariant cbs_loadResource_2360_0(int type, const QUrl &name)
  {
    return QPlainTextEdit::loadResource(type, name);
  }

  virtual QVariant loadResource(int type, const QUrl &name)
  {
    if (cb_loadResource_2360_0.can_issue()) {
      return cb_loadResource_2360_0.issue<QPlainTextEdit_Adaptor, QVariant, int, const QUrl &>(&QPlainTextEdit_Adaptor::cbs_loadResource_2360_0, type, name);
    } else {
      return QPlainTextEdit::loadResource(type, name);
    }
  }

  //  [adaptor impl] QSize QPlainTextEdit::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QPlainTextEdit::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QPlainTextEdit_Adaptor, QSize>(&QPlainTextEdit_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QPlainTextEdit::minimumSizeHint();
    }
  }

  //  [emitter impl] void QPlainTextEdit::modificationChanged(bool)
  void emitter_QPlainTextEdit_modificationChanged_864(bool arg1)
  {
    emit QPlainTextEdit::modificationChanged(arg1);
  }

  //  [emitter impl] void QPlainTextEdit::objectNameChanged(const QString &objectName)
  void emitter_QPlainTextEdit_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QPlainTextEdit::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QPaintEngine *QPlainTextEdit::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QPlainTextEdit::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QPlainTextEdit_Adaptor, QPaintEngine *>(&QPlainTextEdit_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QPlainTextEdit::paintEngine();
    }
  }

  //  [emitter impl] void QPlainTextEdit::redoAvailable(bool b)
  void emitter_QPlainTextEdit_redoAvailable_864(bool b)
  {
    emit QPlainTextEdit::redoAvailable(b);
  }

  //  [emitter impl] void QPlainTextEdit::selectionChanged()
  void emitter_QPlainTextEdit_selectionChanged_0()
  {
    emit QPlainTextEdit::selectionChanged();
  }

  //  [adaptor impl] void QPlainTextEdit::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QPlainTextEdit::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QPlainTextEdit_Adaptor, bool>(&QPlainTextEdit_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QPlainTextEdit::setVisible(visible);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::setupViewport(QWidget *viewport)
  void cbs_setupViewport_1315_0(QWidget *viewport)
  {
    QPlainTextEdit::setupViewport(viewport);
  }

  virtual void setupViewport(QWidget *viewport)
  {
    if (cb_setupViewport_1315_0.can_issue()) {
      cb_setupViewport_1315_0.issue<QPlainTextEdit_Adaptor, QWidget *>(&QPlainTextEdit_Adaptor::cbs_setupViewport_1315_0, viewport);
    } else {
      QPlainTextEdit::setupViewport(viewport);
    }
  }

  //  [adaptor impl] QSize QPlainTextEdit::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QPlainTextEdit::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QPlainTextEdit_Adaptor, QSize>(&QPlainTextEdit_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QPlainTextEdit::sizeHint();
    }
  }

  //  [emitter impl] void QPlainTextEdit::textChanged()
  void emitter_QPlainTextEdit_textChanged_0()
  {
    emit QPlainTextEdit::textChanged();
  }

  //  [emitter impl] void QPlainTextEdit::undoAvailable(bool b)
  void emitter_QPlainTextEdit_undoAvailable_864(bool b)
  {
    emit QPlainTextEdit::undoAvailable(b);
  }

  //  [emitter impl] void QPlainTextEdit::updateRequest(const QRect &rect, int dy)
  void emitter_QPlainTextEdit_updateRequest_2451(const QRect &rect, int dy)
  {
    emit QPlainTextEdit::updateRequest(rect, dy);
  }

  //  [emitter impl] void QPlainTextEdit::windowIconChanged(const QIcon &icon)
  void emitter_QPlainTextEdit_windowIconChanged_1787(const QIcon &icon)
  {
    emit QPlainTextEdit::windowIconChanged(icon);
  }

  //  [emitter impl] void QPlainTextEdit::windowIconTextChanged(const QString &iconText)
  void emitter_QPlainTextEdit_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QPlainTextEdit::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QPlainTextEdit::windowTitleChanged(const QString &title)
  void emitter_QPlainTextEdit_windowTitleChanged_2025(const QString &title)
  {
    emit QPlainTextEdit::windowTitleChanged(title);
  }

  //  [adaptor impl] void QPlainTextEdit::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QPlainTextEdit::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QPlainTextEdit_Adaptor, QActionEvent *>(&QPlainTextEdit_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QPlainTextEdit::actionEvent(arg1);
    }
  }

  //  [adaptor impl] bool QPlainTextEdit::canInsertFromMimeData(const QMimeData *source)
  bool cbs_canInsertFromMimeData_c2168_0(const QMimeData *source) const
  {
    return QPlainTextEdit::canInsertFromMimeData(source);
  }

  virtual bool canInsertFromMimeData(const QMimeData *source) const
  {
    if (cb_canInsertFromMimeData_c2168_0.can_issue()) {
      return cb_canInsertFromMimeData_c2168_0.issue<QPlainTextEdit_Adaptor, bool, const QMimeData *>(&QPlainTextEdit_Adaptor::cbs_canInsertFromMimeData_c2168_0, source);
    } else {
      return QPlainTextEdit::canInsertFromMimeData(source);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::changeEvent(QEvent *e)
  void cbs_changeEvent_1217_0(QEvent *e)
  {
    QPlainTextEdit::changeEvent(e);
  }

  virtual void changeEvent(QEvent *e)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QPlainTextEdit_Adaptor, QEvent *>(&QPlainTextEdit_Adaptor::cbs_changeEvent_1217_0, e);
    } else {
      QPlainTextEdit::changeEvent(e);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QPlainTextEdit::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QPlainTextEdit_Adaptor, QChildEvent *>(&QPlainTextEdit_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QPlainTextEdit::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QPlainTextEdit::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QPlainTextEdit_Adaptor, QCloseEvent *>(&QPlainTextEdit_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QPlainTextEdit::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::contextMenuEvent(QContextMenuEvent *e)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *e)
  {
    QPlainTextEdit::contextMenuEvent(e);
  }

  virtual void contextMenuEvent(QContextMenuEvent *e)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QPlainTextEdit_Adaptor, QContextMenuEvent *>(&QPlainTextEdit_Adaptor::cbs_contextMenuEvent_2363_0, e);
    } else {
      QPlainTextEdit::contextMenuEvent(e);
    }
  }

  //  [adaptor impl] QMimeData *QPlainTextEdit::createMimeDataFromSelection()
  QMimeData * cbs_createMimeDataFromSelection_c0_0() const
  {
    return QPlainTextEdit::createMimeDataFromSelection();
  }

  virtual QMimeData * createMimeDataFromSelection() const
  {
    if (cb_createMimeDataFromSelection_c0_0.can_issue()) {
      return cb_createMimeDataFromSelection_c0_0.issue<QPlainTextEdit_Adaptor, QMimeData *>(&QPlainTextEdit_Adaptor::cbs_createMimeDataFromSelection_c0_0);
    } else {
      return QPlainTextEdit::createMimeDataFromSelection();
    }
  }

  //  [adaptor impl] void QPlainTextEdit::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QPlainTextEdit::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QPlainTextEdit_Adaptor, QEvent *>(&QPlainTextEdit_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QPlainTextEdit::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QPlainTextEdit::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QPlainTextEdit_Adaptor, const QMetaMethod &>(&QPlainTextEdit_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QPlainTextEdit::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::doSetTextCursor(const QTextCursor &cursor)
  void cbs_doSetTextCursor_2453_0(const QTextCursor &cursor)
  {
    QPlainTextEdit::doSetTextCursor(cursor);
  }

  virtual void doSetTextCursor(const QTextCursor &cursor)
  {
    if (cb_doSetTextCursor_2453_0.can_issue()) {
      cb_doSetTextCursor_2453_0.issue<QPlainTextEdit_Adaptor, const QTextCursor &>(&QPlainTextEdit_Adaptor::cbs_doSetTextCursor_2453_0, cursor);
    } else {
      QPlainTextEdit::doSetTextCursor(cursor);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::dragEnterEvent(QDragEnterEvent *e)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *e)
  {
    QPlainTextEdit::dragEnterEvent(e);
  }

  virtual void dragEnterEvent(QDragEnterEvent *e)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QPlainTextEdit_Adaptor, QDragEnterEvent *>(&QPlainTextEdit_Adaptor::cbs_dragEnterEvent_2109_0, e);
    } else {
      QPlainTextEdit::dragEnterEvent(e);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::dragLeaveEvent(QDragLeaveEvent *e)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *e)
  {
    QPlainTextEdit::dragLeaveEvent(e);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *e)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QPlainTextEdit_Adaptor, QDragLeaveEvent *>(&QPlainTextEdit_Adaptor::cbs_dragLeaveEvent_2092_0, e);
    } else {
      QPlainTextEdit::dragLeaveEvent(e);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::dragMoveEvent(QDragMoveEvent *e)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *e)
  {
    QPlainTextEdit::dragMoveEvent(e);
  }

  virtual void dragMoveEvent(QDragMoveEvent *e)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QPlainTextEdit_Adaptor, QDragMoveEvent *>(&QPlainTextEdit_Adaptor::cbs_dragMoveEvent_2006_0, e);
    } else {
      QPlainTextEdit::dragMoveEvent(e);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::dropEvent(QDropEvent *e)
  void cbs_dropEvent_1622_0(QDropEvent *e)
  {
    QPlainTextEdit::dropEvent(e);
  }

  virtual void dropEvent(QDropEvent *e)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QPlainTextEdit_Adaptor, QDropEvent *>(&QPlainTextEdit_Adaptor::cbs_dropEvent_1622_0, e);
    } else {
      QPlainTextEdit::dropEvent(e);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QPlainTextEdit::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QPlainTextEdit_Adaptor, QEvent *>(&QPlainTextEdit_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QPlainTextEdit::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QPlainTextEdit::event(QEvent *e)
  bool cbs_event_1217_0(QEvent *e)
  {
    return QPlainTextEdit::event(e);
  }

  virtual bool event(QEvent *e)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QPlainTextEdit_Adaptor, bool, QEvent *>(&QPlainTextEdit_Adaptor::cbs_event_1217_0, e);
    } else {
      return QPlainTextEdit::event(e);
    }
  }

  //  [adaptor impl] bool QPlainTextEdit::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QPlainTextEdit::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QPlainTextEdit_Adaptor, bool, QObject *, QEvent *>(&QPlainTextEdit_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QPlainTextEdit::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::focusInEvent(QFocusEvent *e)
  void cbs_focusInEvent_1729_0(QFocusEvent *e)
  {
    QPlainTextEdit::focusInEvent(e);
  }

  virtual void focusInEvent(QFocusEvent *e)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QPlainTextEdit_Adaptor, QFocusEvent *>(&QPlainTextEdit_Adaptor::cbs_focusInEvent_1729_0, e);
    } else {
      QPlainTextEdit::focusInEvent(e);
    }
  }

  //  [adaptor impl] bool QPlainTextEdit::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QPlainTextEdit::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QPlainTextEdit_Adaptor, bool, bool>(&QPlainTextEdit_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QPlainTextEdit::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::focusOutEvent(QFocusEvent *e)
  void cbs_focusOutEvent_1729_0(QFocusEvent *e)
  {
    QPlainTextEdit::focusOutEvent(e);
  }

  virtual void focusOutEvent(QFocusEvent *e)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QPlainTextEdit_Adaptor, QFocusEvent *>(&QPlainTextEdit_Adaptor::cbs_focusOutEvent_1729_0, e);
    } else {
      QPlainTextEdit::focusOutEvent(e);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QPlainTextEdit::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QPlainTextEdit_Adaptor, QHideEvent *>(&QPlainTextEdit_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QPlainTextEdit::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QPlainTextEdit::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QPlainTextEdit_Adaptor, QPainter *>(&QPlainTextEdit_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QPlainTextEdit::initPainter(painter);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QPlainTextEdit::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QPlainTextEdit_Adaptor, QInputMethodEvent *>(&QPlainTextEdit_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QPlainTextEdit::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::insertFromMimeData(const QMimeData *source)
  void cbs_insertFromMimeData_2168_0(const QMimeData *source)
  {
    QPlainTextEdit::insertFromMimeData(source);
  }

  virtual void insertFromMimeData(const QMimeData *source)
  {
    if (cb_insertFromMimeData_2168_0.can_issue()) {
      cb_insertFromMimeData_2168_0.issue<QPlainTextEdit_Adaptor, const QMimeData *>(&QPlainTextEdit_Adaptor::cbs_insertFromMimeData_2168_0, source);
    } else {
      QPlainTextEdit::insertFromMimeData(source);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::keyPressEvent(QKeyEvent *e)
  void cbs_keyPressEvent_1514_0(QKeyEvent *e)
  {
    QPlainTextEdit::keyPressEvent(e);
  }

  virtual void keyPressEvent(QKeyEvent *e)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QPlainTextEdit_Adaptor, QKeyEvent *>(&QPlainTextEdit_Adaptor::cbs_keyPressEvent_1514_0, e);
    } else {
      QPlainTextEdit::keyPressEvent(e);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::keyReleaseEvent(QKeyEvent *e)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *e)
  {
    QPlainTextEdit::keyReleaseEvent(e);
  }

  virtual void keyReleaseEvent(QKeyEvent *e)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QPlainTextEdit_Adaptor, QKeyEvent *>(&QPlainTextEdit_Adaptor::cbs_keyReleaseEvent_1514_0, e);
    } else {
      QPlainTextEdit::keyReleaseEvent(e);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QPlainTextEdit::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QPlainTextEdit_Adaptor, QEvent *>(&QPlainTextEdit_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QPlainTextEdit::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QPlainTextEdit::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QPlainTextEdit::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QPlainTextEdit_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QPlainTextEdit_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QPlainTextEdit::metric(arg1);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::mouseDoubleClickEvent(QMouseEvent *e)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *e)
  {
    QPlainTextEdit::mouseDoubleClickEvent(e);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *e)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QPlainTextEdit_Adaptor, QMouseEvent *>(&QPlainTextEdit_Adaptor::cbs_mouseDoubleClickEvent_1738_0, e);
    } else {
      QPlainTextEdit::mouseDoubleClickEvent(e);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::mouseMoveEvent(QMouseEvent *e)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *e)
  {
    QPlainTextEdit::mouseMoveEvent(e);
  }

  virtual void mouseMoveEvent(QMouseEvent *e)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QPlainTextEdit_Adaptor, QMouseEvent *>(&QPlainTextEdit_Adaptor::cbs_mouseMoveEvent_1738_0, e);
    } else {
      QPlainTextEdit::mouseMoveEvent(e);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::mousePressEvent(QMouseEvent *e)
  void cbs_mousePressEvent_1738_0(QMouseEvent *e)
  {
    QPlainTextEdit::mousePressEvent(e);
  }

  virtual void mousePressEvent(QMouseEvent *e)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QPlainTextEdit_Adaptor, QMouseEvent *>(&QPlainTextEdit_Adaptor::cbs_mousePressEvent_1738_0, e);
    } else {
      QPlainTextEdit::mousePressEvent(e);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::mouseReleaseEvent(QMouseEvent *e)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *e)
  {
    QPlainTextEdit::mouseReleaseEvent(e);
  }

  virtual void mouseReleaseEvent(QMouseEvent *e)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QPlainTextEdit_Adaptor, QMouseEvent *>(&QPlainTextEdit_Adaptor::cbs_mouseReleaseEvent_1738_0, e);
    } else {
      QPlainTextEdit::mouseReleaseEvent(e);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QPlainTextEdit::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QPlainTextEdit_Adaptor, QMoveEvent *>(&QPlainTextEdit_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QPlainTextEdit::moveEvent(arg1);
    }
  }

  //  [adaptor impl] bool QPlainTextEdit::nativeEvent(const QByteArray &eventType, void *message, long int *result)
  bool cbs_nativeEvent_4678_0(const QByteArray &eventType, void *message, long int *result)
  {
    return QPlainTextEdit::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, long int *result)
  {
    if (cb_nativeEvent_4678_0.can_issue()) {
      return cb_nativeEvent_4678_0.issue<QPlainTextEdit_Adaptor, bool, const QByteArray &, void *, long int *>(&QPlainTextEdit_Adaptor::cbs_nativeEvent_4678_0, eventType, message, result);
    } else {
      return QPlainTextEdit::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::paintEvent(QPaintEvent *e)
  void cbs_paintEvent_1725_0(QPaintEvent *e)
  {
    QPlainTextEdit::paintEvent(e);
  }

  virtual void paintEvent(QPaintEvent *e)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QPlainTextEdit_Adaptor, QPaintEvent *>(&QPlainTextEdit_Adaptor::cbs_paintEvent_1725_0, e);
    } else {
      QPlainTextEdit::paintEvent(e);
    }
  }

  //  [adaptor impl] QPaintDevice *QPlainTextEdit::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QPlainTextEdit::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QPlainTextEdit_Adaptor, QPaintDevice *, QPoint *>(&QPlainTextEdit_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QPlainTextEdit::redirected(offset);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::resizeEvent(QResizeEvent *e)
  void cbs_resizeEvent_1843_0(QResizeEvent *e)
  {
    QPlainTextEdit::resizeEvent(e);
  }

  virtual void resizeEvent(QResizeEvent *e)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QPlainTextEdit_Adaptor, QResizeEvent *>(&QPlainTextEdit_Adaptor::cbs_resizeEvent_1843_0, e);
    } else {
      QPlainTextEdit::resizeEvent(e);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::scrollContentsBy(int dx, int dy)
  void cbs_scrollContentsBy_1426_0(int dx, int dy)
  {
    QPlainTextEdit::scrollContentsBy(dx, dy);
  }

  virtual void scrollContentsBy(int dx, int dy)
  {
    if (cb_scrollContentsBy_1426_0.can_issue()) {
      cb_scrollContentsBy_1426_0.issue<QPlainTextEdit_Adaptor, int, int>(&QPlainTextEdit_Adaptor::cbs_scrollContentsBy_1426_0, dx, dy);
    } else {
      QPlainTextEdit::scrollContentsBy(dx, dy);
    }
  }

  //  [adaptor impl] QPainter *QPlainTextEdit::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QPlainTextEdit::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QPlainTextEdit_Adaptor, QPainter *>(&QPlainTextEdit_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QPlainTextEdit::sharedPainter();
    }
  }

  //  [adaptor impl] void QPlainTextEdit::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QPlainTextEdit::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QPlainTextEdit_Adaptor, QShowEvent *>(&QPlainTextEdit_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QPlainTextEdit::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QPlainTextEdit::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QPlainTextEdit_Adaptor, QTabletEvent *>(&QPlainTextEdit_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QPlainTextEdit::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QPlainTextEdit::timerEvent(QTimerEvent *e)
  void cbs_timerEvent_1730_0(QTimerEvent *e)
  {
    QPlainTextEdit::timerEvent(e);
  }

  virtual void timerEvent(QTimerEvent *e)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QPlainTextEdit_Adaptor, QTimerEvent *>(&QPlainTextEdit_Adaptor::cbs_timerEvent_1730_0, e);
    } else {
      QPlainTextEdit::timerEvent(e);
    }
  }

  //  [adaptor impl] bool QPlainTextEdit::viewportEvent(QEvent *)
  bool cbs_viewportEvent_1217_0(QEvent *arg1)
  {
    return QPlainTextEdit::viewportEvent(arg1);
  }

  virtual bool viewportEvent(QEvent *arg1)
  {
    if (cb_viewportEvent_1217_0.can_issue()) {
      return cb_viewportEvent_1217_0.issue<QPlainTextEdit_Adaptor, bool, QEvent *>(&QPlainTextEdit_Adaptor::cbs_viewportEvent_1217_0, arg1);
    } else {
      return QPlainTextEdit::viewportEvent(arg1);
    }
  }

  //  [adaptor impl] QSize QPlainTextEdit::viewportSizeHint()
  QSize cbs_viewportSizeHint_c0_0() const
  {
    return QPlainTextEdit::viewportSizeHint();
  }

  virtual QSize viewportSizeHint() const
  {
    if (cb_viewportSizeHint_c0_0.can_issue()) {
      return cb_viewportSizeHint_c0_0.issue<QPlainTextEdit_Adaptor, QSize>(&QPlainTextEdit_Adaptor::cbs_viewportSizeHint_c0_0);
    } else {
      return QPlainTextEdit::viewportSizeHint();
    }
  }

  //  [adaptor impl] void QPlainTextEdit::wheelEvent(QWheelEvent *e)
  void cbs_wheelEvent_1718_0(QWheelEvent *e)
  {
    QPlainTextEdit::wheelEvent(e);
  }

  virtual void wheelEvent(QWheelEvent *e)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QPlainTextEdit_Adaptor, QWheelEvent *>(&QPlainTextEdit_Adaptor::cbs_wheelEvent_1718_0, e);
    } else {
      QPlainTextEdit::wheelEvent(e);
    }
  }

  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_loadResource_2360_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_setupViewport_1315_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_canInsertFromMimeData_c2168_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_createMimeDataFromSelection_c0_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_doSetTextCursor_2453_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_insertFromMimeData_2168_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_4678_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_scrollContentsBy_1426_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_viewportEvent_1217_0;
  gsi::Callback cb_viewportSizeHint_c0_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QPlainTextEdit_Adaptor::~QPlainTextEdit_Adaptor() { }

//  Constructor QPlainTextEdit::QPlainTextEdit(QWidget *parent) (adaptor class)

static void _init_ctor_QPlainTextEdit_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QPlainTextEdit_Adaptor> ();
}

static void _call_ctor_QPlainTextEdit_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  ret.write<QPlainTextEdit_Adaptor *> (new QPlainTextEdit_Adaptor (arg1));
}


//  Constructor QPlainTextEdit::QPlainTextEdit(const QString &text, QWidget *parent) (adaptor class)

static void _init_ctor_QPlainTextEdit_Adaptor_3232 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return_new<QPlainTextEdit_Adaptor> ();
}

static void _call_ctor_QPlainTextEdit_Adaptor_3232 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QWidget *arg2 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  ret.write<QPlainTextEdit_Adaptor *> (new QPlainTextEdit_Adaptor (arg1, arg2));
}


// void QPlainTextEdit::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// exposed QRectF QPlainTextEdit::blockBoundingGeometry(const QTextBlock &block)

static void _init_fp_blockBoundingGeometry_c2306 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_fp_blockBoundingGeometry_c2306 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextBlock &arg1 = gsi::arg_reader<const QTextBlock & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_blockBoundingGeometry_c2306 (arg1));
}


// exposed QRectF QPlainTextEdit::blockBoundingRect(const QTextBlock &block)

static void _init_fp_blockBoundingRect_c2306 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_fp_blockBoundingRect_c2306 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextBlock &arg1 = gsi::arg_reader<const QTextBlock & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_blockBoundingRect_c2306 (arg1));
}


// emitter void QPlainTextEdit::blockCountChanged(int newBlockCount)

static void _init_emitter_blockCountChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newBlockCount");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_blockCountChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QPlainTextEdit_Adaptor *)cls)->emitter_QPlainTextEdit_blockCountChanged_767 (arg1);
}


// bool QPlainTextEdit::canInsertFromMimeData(const QMimeData *source)

static void _init_cbs_canInsertFromMimeData_c2168_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("source");
  decl->add_arg<const QMimeData * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_canInsertFromMimeData_c2168_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  ret.write<bool > ((bool)((QPlainTextEdit_Adaptor *)cls)->cbs_canInsertFromMimeData_c2168_0 (arg1));
}

static void _set_callback_cbs_canInsertFromMimeData_c2168_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_canInsertFromMimeData_c2168_0 = cb;
}


// void QPlainTextEdit::changeEvent(QEvent *e)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QPlainTextEdit::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QPlainTextEdit::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// exposed QPointF QPlainTextEdit::contentOffset()

static void _init_fp_contentOffset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_fp_contentOffset_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_contentOffset_c0 ());
}


// void QPlainTextEdit::contextMenuEvent(QContextMenuEvent *e)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// emitter void QPlainTextEdit::copyAvailable(bool b)

static void _init_emitter_copyAvailable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_copyAvailable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QPlainTextEdit_Adaptor *)cls)->emitter_QPlainTextEdit_copyAvailable_864 (arg1);
}


// exposed void QPlainTextEdit::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_create_2208 (arg1, arg2, arg3);
}


// QMimeData *QPlainTextEdit::createMimeDataFromSelection()

static void _init_cbs_createMimeDataFromSelection_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_createMimeDataFromSelection_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMimeData * > ((QMimeData *)((QPlainTextEdit_Adaptor *)cls)->cbs_createMimeDataFromSelection_c0_0 ());
}

static void _set_callback_cbs_createMimeDataFromSelection_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_createMimeDataFromSelection_c0_0 = cb;
}


// emitter void QPlainTextEdit::cursorPositionChanged()

static void _init_emitter_cursorPositionChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_cursorPositionChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QPlainTextEdit_Adaptor *)cls)->emitter_QPlainTextEdit_cursorPositionChanged_0 ();
}


// emitter void QPlainTextEdit::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QPlainTextEdit_Adaptor *)cls)->emitter_QPlainTextEdit_customContextMenuRequested_1916 (arg1);
}


// void QPlainTextEdit::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QPlainTextEdit::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_destroy_1620 (arg1, arg2);
}


// emitter void QPlainTextEdit::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QPlainTextEdit_Adaptor *)cls)->emitter_QPlainTextEdit_destroyed_1302 (arg1);
}


// void QPlainTextEdit::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QPlainTextEdit::doSetTextCursor(const QTextCursor &cursor)

static void _init_cbs_doSetTextCursor_2453_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_doSetTextCursor_2453_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = args.read<const QTextCursor & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_doSetTextCursor_2453_0 (arg1);
}

static void _set_callback_cbs_doSetTextCursor_2453_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_doSetTextCursor_2453_0 = cb;
}


// void QPlainTextEdit::dragEnterEvent(QDragEnterEvent *e)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QPlainTextEdit::dragLeaveEvent(QDragLeaveEvent *e)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QPlainTextEdit::dragMoveEvent(QDragMoveEvent *e)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// exposed void QPlainTextEdit::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_drawFrame_1426 (arg1);
}


// void QPlainTextEdit::dropEvent(QDropEvent *e)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QPlainTextEdit::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}


// bool QPlainTextEdit::event(QEvent *e)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPlainTextEdit_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QPlainTextEdit::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPlainTextEdit_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed QTextBlock QPlainTextEdit::firstVisibleBlock()

static void _init_fp_firstVisibleBlock_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextBlock > ();
}

static void _call_fp_firstVisibleBlock_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextBlock > ((QTextBlock)((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_firstVisibleBlock_c0 ());
}


// void QPlainTextEdit::focusInEvent(QFocusEvent *e)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QPlainTextEdit::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_focusNextChild_0 ());
}


// bool QPlainTextEdit::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QPlainTextEdit_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QPlainTextEdit::focusOutEvent(QFocusEvent *e)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QPlainTextEdit::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_focusPreviousChild_0 ());
}


// exposed QAbstractTextDocumentLayout::PaintContext QPlainTextEdit::getPaintContext()

static void _init_fp_getPaintContext_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractTextDocumentLayout::PaintContext > ();
}

static void _call_fp_getPaintContext_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractTextDocumentLayout::PaintContext > ((QAbstractTextDocumentLayout::PaintContext)((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_getPaintContext_c0 ());
}


// bool QPlainTextEdit::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPlainTextEdit_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QPlainTextEdit::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QPlainTextEdit_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QPlainTextEdit::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QPlainTextEdit::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// exposed void QPlainTextEdit::initStyleOption(QStyleOptionFrame *option)

static void _init_fp_initStyleOption_c2356 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionFrame * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_initStyleOption_c2356 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyleOptionFrame *arg1 = gsi::arg_reader<QStyleOptionFrame * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_initStyleOption_c2356 (arg1);
}


// void QPlainTextEdit::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QPlainTextEdit::inputMethodQuery(Qt::InputMethodQuery property)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("property");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QPlainTextEdit_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// void QPlainTextEdit::insertFromMimeData(const QMimeData *source)

static void _init_cbs_insertFromMimeData_2168_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("source");
  decl->add_arg<const QMimeData * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_insertFromMimeData_2168_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_insertFromMimeData_2168_0 (arg1);
}

static void _set_callback_cbs_insertFromMimeData_2168_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_insertFromMimeData_2168_0 = cb;
}


// exposed bool QPlainTextEdit::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_isSignalConnected_c2394 (arg1));
}


// void QPlainTextEdit::keyPressEvent(QKeyEvent *e)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QPlainTextEdit::keyReleaseEvent(QKeyEvent *e)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QPlainTextEdit::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// QVariant QPlainTextEdit::loadResource(int type, const QUrl &name)

static void _init_cbs_loadResource_2360_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name");
  decl->add_arg<const QUrl & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_loadResource_2360_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const QUrl &arg2 = args.read<const QUrl & > (heap);
  ret.write<QVariant > ((QVariant)((QPlainTextEdit_Adaptor *)cls)->cbs_loadResource_2360_0 (arg1, arg2));
}

static void _set_callback_cbs_loadResource_2360_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_loadResource_2360_0 = cb;
}


// int QPlainTextEdit::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QPlainTextEdit_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QPlainTextEdit::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QPlainTextEdit_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// emitter void QPlainTextEdit::modificationChanged(bool)

static void _init_emitter_modificationChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_modificationChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QPlainTextEdit_Adaptor *)cls)->emitter_QPlainTextEdit_modificationChanged_864 (arg1);
}


// void QPlainTextEdit::mouseDoubleClickEvent(QMouseEvent *e)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QPlainTextEdit::mouseMoveEvent(QMouseEvent *e)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QPlainTextEdit::mousePressEvent(QMouseEvent *e)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QPlainTextEdit::mouseReleaseEvent(QMouseEvent *e)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QPlainTextEdit::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QPlainTextEdit::nativeEvent(const QByteArray &eventType, void *message, long int *result)

static void _init_cbs_nativeEvent_4678_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<long int * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_4678_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  long int *arg3 = args.read<long int * > (heap);
  ret.write<bool > ((bool)((QPlainTextEdit_Adaptor *)cls)->cbs_nativeEvent_4678_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_4678_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_nativeEvent_4678_0 = cb;
}


// emitter void QPlainTextEdit::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QPlainTextEdit_Adaptor *)cls)->emitter_QPlainTextEdit_objectNameChanged_4567 (arg1);
}


// QPaintEngine *QPlainTextEdit::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QPlainTextEdit_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QPlainTextEdit::paintEvent(QPaintEvent *e)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QPlainTextEdit::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_receivers_c1731 (arg1));
}


// QPaintDevice *QPlainTextEdit::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QPlainTextEdit_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// emitter void QPlainTextEdit::redoAvailable(bool b)

static void _init_emitter_redoAvailable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_redoAvailable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QPlainTextEdit_Adaptor *)cls)->emitter_QPlainTextEdit_redoAvailable_864 (arg1);
}


// void QPlainTextEdit::resizeEvent(QResizeEvent *e)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// void QPlainTextEdit::scrollContentsBy(int dx, int dy)

static void _init_cbs_scrollContentsBy_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollContentsBy_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_scrollContentsBy_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollContentsBy_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_scrollContentsBy_1426_0 = cb;
}


// emitter void QPlainTextEdit::selectionChanged()

static void _init_emitter_selectionChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_selectionChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QPlainTextEdit_Adaptor *)cls)->emitter_QPlainTextEdit_selectionChanged_0 ();
}


// exposed QObject *QPlainTextEdit::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_sender_c0 ());
}


// exposed int QPlainTextEdit::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_senderSignalIndex_c0 ());
}


// exposed void QPlainTextEdit::setViewportMargins(int left, int top, int right, int bottom)

static void _init_fp_setViewportMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_setViewportMargins_2744 (arg1, arg2, arg3, arg4);
}


// exposed void QPlainTextEdit::setViewportMargins(const QMargins &margins)

static void _init_fp_setViewportMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2115 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMargins &arg1 = gsi::arg_reader<const QMargins & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_setViewportMargins_2115 (arg1);
}


// void QPlainTextEdit::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// void QPlainTextEdit::setupViewport(QWidget *viewport)

static void _init_cbs_setupViewport_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setupViewport_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_setupViewport_1315_0 (arg1);
}

static void _set_callback_cbs_setupViewport_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_setupViewport_1315_0 = cb;
}


// QPainter *QPlainTextEdit::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QPlainTextEdit_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QPlainTextEdit::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QPlainTextEdit::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QPlainTextEdit_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QPlainTextEdit::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// emitter void QPlainTextEdit::textChanged()

static void _init_emitter_textChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_textChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QPlainTextEdit_Adaptor *)cls)->emitter_QPlainTextEdit_textChanged_0 ();
}


// void QPlainTextEdit::timerEvent(QTimerEvent *e)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QPlainTextEdit::undoAvailable(bool b)

static void _init_emitter_undoAvailable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_undoAvailable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QPlainTextEdit_Adaptor *)cls)->emitter_QPlainTextEdit_undoAvailable_864 (arg1);
}


// exposed void QPlainTextEdit::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_updateMicroFocus_0 ();
}


// emitter void QPlainTextEdit::updateRequest(const QRect &rect, int dy)

static void _init_emitter_updateRequest_2451 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_updateRequest_2451 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ((QPlainTextEdit_Adaptor *)cls)->emitter_QPlainTextEdit_updateRequest_2451 (arg1, arg2);
}


// bool QPlainTextEdit::viewportEvent(QEvent *)

static void _init_cbs_viewportEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_viewportEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPlainTextEdit_Adaptor *)cls)->cbs_viewportEvent_1217_0 (arg1));
}

static void _set_callback_cbs_viewportEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_viewportEvent_1217_0 = cb;
}


// exposed QMargins QPlainTextEdit::viewportMargins()

static void _init_fp_viewportMargins_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMargins > ();
}

static void _call_fp_viewportMargins_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMargins > ((QMargins)((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_viewportMargins_c0 ());
}


// QSize QPlainTextEdit::viewportSizeHint()

static void _init_cbs_viewportSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_viewportSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QPlainTextEdit_Adaptor *)cls)->cbs_viewportSizeHint_c0_0 ());
}

static void _set_callback_cbs_viewportSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_viewportSizeHint_c0_0 = cb;
}


// void QPlainTextEdit::wheelEvent(QWheelEvent *e)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextEdit_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QPlainTextEdit::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QPlainTextEdit_Adaptor *)cls)->emitter_QPlainTextEdit_windowIconChanged_1787 (arg1);
}


// emitter void QPlainTextEdit::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QPlainTextEdit_Adaptor *)cls)->emitter_QPlainTextEdit_windowIconTextChanged_2025 (arg1);
}


// emitter void QPlainTextEdit::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QPlainTextEdit_Adaptor *)cls)->emitter_QPlainTextEdit_windowTitleChanged_2025 (arg1);
}


// exposed void QPlainTextEdit::zoomInF(float range)

static void _init_fp_zoomInF_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("range");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_zoomInF_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextEdit_Adaptor *)cls)->fp_QPlainTextEdit_zoomInF_970 (arg1);
}


namespace gsi
{

gsi::Class<QPlainTextEdit> &qtdecl_QPlainTextEdit ();

static gsi::Methods methods_QPlainTextEdit_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPlainTextEdit::QPlainTextEdit(QWidget *parent)\nThis method creates an object of class QPlainTextEdit.", &_init_ctor_QPlainTextEdit_Adaptor_1315, &_call_ctor_QPlainTextEdit_Adaptor_1315);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPlainTextEdit::QPlainTextEdit(const QString &text, QWidget *parent)\nThis method creates an object of class QPlainTextEdit.", &_init_ctor_QPlainTextEdit_Adaptor_3232, &_call_ctor_QPlainTextEdit_Adaptor_3232);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QPlainTextEdit::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*blockBoundingGeometry", "@brief Method QRectF QPlainTextEdit::blockBoundingGeometry(const QTextBlock &block)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_blockBoundingGeometry_c2306, &_call_fp_blockBoundingGeometry_c2306);
  methods += new qt_gsi::GenericMethod ("*blockBoundingRect", "@brief Method QRectF QPlainTextEdit::blockBoundingRect(const QTextBlock &block)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_blockBoundingRect_c2306, &_call_fp_blockBoundingRect_c2306);
  methods += new qt_gsi::GenericMethod ("emit_blockCountChanged", "@brief Emitter for signal void QPlainTextEdit::blockCountChanged(int newBlockCount)\nCall this method to emit this signal.", false, &_init_emitter_blockCountChanged_767, &_call_emitter_blockCountChanged_767);
  methods += new qt_gsi::GenericMethod ("*canInsertFromMimeData", "@brief Virtual method bool QPlainTextEdit::canInsertFromMimeData(const QMimeData *source)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canInsertFromMimeData_c2168_0, &_call_cbs_canInsertFromMimeData_c2168_0);
  methods += new qt_gsi::GenericMethod ("*canInsertFromMimeData", "@hide", true, &_init_cbs_canInsertFromMimeData_c2168_0, &_call_cbs_canInsertFromMimeData_c2168_0, &_set_callback_cbs_canInsertFromMimeData_c2168_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QPlainTextEdit::changeEvent(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QPlainTextEdit::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QPlainTextEdit::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contentOffset", "@brief Method QPointF QPlainTextEdit::contentOffset()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_contentOffset_c0, &_call_fp_contentOffset_c0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QPlainTextEdit::contextMenuEvent(QContextMenuEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("emit_copyAvailable", "@brief Emitter for signal void QPlainTextEdit::copyAvailable(bool b)\nCall this method to emit this signal.", false, &_init_emitter_copyAvailable_864, &_call_emitter_copyAvailable_864);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QPlainTextEdit::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("*createMimeDataFromSelection", "@brief Virtual method QMimeData *QPlainTextEdit::createMimeDataFromSelection()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_createMimeDataFromSelection_c0_0, &_call_cbs_createMimeDataFromSelection_c0_0);
  methods += new qt_gsi::GenericMethod ("*createMimeDataFromSelection", "@hide", true, &_init_cbs_createMimeDataFromSelection_c0_0, &_call_cbs_createMimeDataFromSelection_c0_0, &_set_callback_cbs_createMimeDataFromSelection_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_cursorPositionChanged", "@brief Emitter for signal void QPlainTextEdit::cursorPositionChanged()\nCall this method to emit this signal.", false, &_init_emitter_cursorPositionChanged_0, &_call_emitter_cursorPositionChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QPlainTextEdit::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QPlainTextEdit::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QPlainTextEdit::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QPlainTextEdit::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QPlainTextEdit::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*doSetTextCursor", "@brief Virtual method void QPlainTextEdit::doSetTextCursor(const QTextCursor &cursor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_doSetTextCursor_2453_0, &_call_cbs_doSetTextCursor_2453_0);
  methods += new qt_gsi::GenericMethod ("*doSetTextCursor", "@hide", false, &_init_cbs_doSetTextCursor_2453_0, &_call_cbs_doSetTextCursor_2453_0, &_set_callback_cbs_doSetTextCursor_2453_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QPlainTextEdit::dragEnterEvent(QDragEnterEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QPlainTextEdit::dragLeaveEvent(QDragLeaveEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QPlainTextEdit::dragMoveEvent(QDragMoveEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*drawFrame", "@brief Method void QPlainTextEdit::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QPlainTextEdit::dropEvent(QDropEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QPlainTextEdit::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QPlainTextEdit::event(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QPlainTextEdit::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*firstVisibleBlock", "@brief Method QTextBlock QPlainTextEdit::firstVisibleBlock()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_firstVisibleBlock_c0, &_call_fp_firstVisibleBlock_c0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QPlainTextEdit::focusInEvent(QFocusEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QPlainTextEdit::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QPlainTextEdit::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QPlainTextEdit::focusOutEvent(QFocusEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QPlainTextEdit::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("*getPaintContext", "@brief Method QAbstractTextDocumentLayout::PaintContext QPlainTextEdit::getPaintContext()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_getPaintContext_c0, &_call_fp_getPaintContext_c0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QPlainTextEdit::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QPlainTextEdit::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QPlainTextEdit::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QPlainTextEdit::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@brief Method void QPlainTextEdit::initStyleOption(QStyleOptionFrame *option)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_initStyleOption_c2356, &_call_fp_initStyleOption_c2356);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QPlainTextEdit::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QPlainTextEdit::inputMethodQuery(Qt::InputMethodQuery property)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*insertFromMimeData", "@brief Virtual method void QPlainTextEdit::insertFromMimeData(const QMimeData *source)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertFromMimeData_2168_0, &_call_cbs_insertFromMimeData_2168_0);
  methods += new qt_gsi::GenericMethod ("*insertFromMimeData", "@hide", false, &_init_cbs_insertFromMimeData_2168_0, &_call_cbs_insertFromMimeData_2168_0, &_set_callback_cbs_insertFromMimeData_2168_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QPlainTextEdit::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QPlainTextEdit::keyPressEvent(QKeyEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QPlainTextEdit::keyReleaseEvent(QKeyEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QPlainTextEdit::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("loadResource", "@brief Virtual method QVariant QPlainTextEdit::loadResource(int type, const QUrl &name)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_loadResource_2360_0, &_call_cbs_loadResource_2360_0);
  methods += new qt_gsi::GenericMethod ("loadResource", "@hide", false, &_init_cbs_loadResource_2360_0, &_call_cbs_loadResource_2360_0, &_set_callback_cbs_loadResource_2360_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QPlainTextEdit::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QPlainTextEdit::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_modificationChanged", "@brief Emitter for signal void QPlainTextEdit::modificationChanged(bool)\nCall this method to emit this signal.", false, &_init_emitter_modificationChanged_864, &_call_emitter_modificationChanged_864);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QPlainTextEdit::mouseDoubleClickEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QPlainTextEdit::mouseMoveEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QPlainTextEdit::mousePressEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QPlainTextEdit::mouseReleaseEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QPlainTextEdit::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QPlainTextEdit::nativeEvent(const QByteArray &eventType, void *message, long int *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0, &_set_callback_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QPlainTextEdit::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QPlainTextEdit::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QPlainTextEdit::paintEvent(QPaintEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QPlainTextEdit::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QPlainTextEdit::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("emit_redoAvailable", "@brief Emitter for signal void QPlainTextEdit::redoAvailable(bool b)\nCall this method to emit this signal.", false, &_init_emitter_redoAvailable_864, &_call_emitter_redoAvailable_864);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QPlainTextEdit::resizeEvent(QResizeEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@brief Virtual method void QPlainTextEdit::scrollContentsBy(int dx, int dy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@hide", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0, &_set_callback_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("emit_selectionChanged", "@brief Emitter for signal void QPlainTextEdit::selectionChanged()\nCall this method to emit this signal.", false, &_init_emitter_selectionChanged_0, &_call_emitter_selectionChanged_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QPlainTextEdit::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QPlainTextEdit::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QPlainTextEdit::setViewportMargins(int left, int top, int right, int bottom)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2744, &_call_fp_setViewportMargins_2744);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QPlainTextEdit::setViewportMargins(const QMargins &margins)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2115, &_call_fp_setViewportMargins_2115);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QPlainTextEdit::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setupViewport", "@brief Virtual method void QPlainTextEdit::setupViewport(QWidget *viewport)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setupViewport_1315_0, &_call_cbs_setupViewport_1315_0);
  methods += new qt_gsi::GenericMethod ("setupViewport", "@hide", false, &_init_cbs_setupViewport_1315_0, &_call_cbs_setupViewport_1315_0, &_set_callback_cbs_setupViewport_1315_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QPlainTextEdit::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QPlainTextEdit::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QPlainTextEdit::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QPlainTextEdit::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("emit_textChanged", "@brief Emitter for signal void QPlainTextEdit::textChanged()\nCall this method to emit this signal.", false, &_init_emitter_textChanged_0, &_call_emitter_textChanged_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QPlainTextEdit::timerEvent(QTimerEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_undoAvailable", "@brief Emitter for signal void QPlainTextEdit::undoAvailable(bool b)\nCall this method to emit this signal.", false, &_init_emitter_undoAvailable_864, &_call_emitter_undoAvailable_864);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QPlainTextEdit::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("emit_updateRequest", "@brief Emitter for signal void QPlainTextEdit::updateRequest(const QRect &rect, int dy)\nCall this method to emit this signal.", false, &_init_emitter_updateRequest_2451, &_call_emitter_updateRequest_2451);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@brief Virtual method bool QPlainTextEdit::viewportEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@hide", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0, &_set_callback_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportMargins", "@brief Method QMargins QPlainTextEdit::viewportMargins()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_viewportMargins_c0, &_call_fp_viewportMargins_c0);
  methods += new qt_gsi::GenericMethod ("*viewportSizeHint", "@brief Virtual method QSize QPlainTextEdit::viewportSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_viewportSizeHint_c0_0, &_call_cbs_viewportSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*viewportSizeHint", "@hide", true, &_init_cbs_viewportSizeHint_c0_0, &_call_cbs_viewportSizeHint_c0_0, &_set_callback_cbs_viewportSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QPlainTextEdit::wheelEvent(QWheelEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QPlainTextEdit::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QPlainTextEdit::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QPlainTextEdit::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  methods += new qt_gsi::GenericMethod ("*zoomInF", "@brief Method void QPlainTextEdit::zoomInF(float range)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_zoomInF_970, &_call_fp_zoomInF_970);
  return methods;
}

gsi::Class<QPlainTextEdit_Adaptor> decl_QPlainTextEdit_Adaptor (qtdecl_QPlainTextEdit (), "QtWidgets", "QPlainTextEdit",
  methods_QPlainTextEdit_Adaptor (),
  "@qt\n@brief Binding of QPlainTextEdit");

}


//  Implementation of the enum wrapper class for QPlainTextEdit::LineWrapMode
namespace qt_gsi
{

static gsi::Enum<QPlainTextEdit::LineWrapMode> decl_QPlainTextEdit_LineWrapMode_Enum ("QtWidgets", "QPlainTextEdit_LineWrapMode",
    gsi::enum_const ("NoWrap", QPlainTextEdit::NoWrap, "@brief Enum constant QPlainTextEdit::NoWrap") +
    gsi::enum_const ("WidgetWidth", QPlainTextEdit::WidgetWidth, "@brief Enum constant QPlainTextEdit::WidgetWidth"),
  "@qt\n@brief This class represents the QPlainTextEdit::LineWrapMode enum");

static gsi::QFlagsClass<QPlainTextEdit::LineWrapMode > decl_QPlainTextEdit_LineWrapMode_Enums ("QtWidgets", "QPlainTextEdit_QFlags_LineWrapMode",
  "@qt\n@brief This class represents the QFlags<QPlainTextEdit::LineWrapMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPlainTextEdit> inject_QPlainTextEdit_LineWrapMode_Enum_in_parent (decl_QPlainTextEdit_LineWrapMode_Enum.defs ());
static gsi::ClassExt<QPlainTextEdit> decl_QPlainTextEdit_LineWrapMode_Enum_as_child (decl_QPlainTextEdit_LineWrapMode_Enum, "LineWrapMode");
static gsi::ClassExt<QPlainTextEdit> decl_QPlainTextEdit_LineWrapMode_Enums_as_child (decl_QPlainTextEdit_LineWrapMode_Enums, "QFlags_LineWrapMode");

}

