
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAudioDecoder.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAudioDecoder>
#include <QAudioBuffer>
#include <QAudioFormat>
#include <QChildEvent>
#include <QEvent>
#include <QIODevice>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include <QUrl>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAudioDecoder

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAudioDecoder::staticMetaObject);
}


// QAudioFormat QAudioDecoder::audioFormat()


static void _init_f_audioFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioFormat > ();
}

static void _call_f_audioFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioFormat > ((QAudioFormat)((QAudioDecoder *)cls)->audioFormat ());
}


// bool QAudioDecoder::bufferAvailable()


static void _init_f_bufferAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_bufferAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAudioDecoder *)cls)->bufferAvailable ());
}


// void QAudioDecoder::bufferAvailableChanged(bool)


static void _init_f_bufferAvailableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_bufferAvailableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->bufferAvailableChanged (arg1);
}


// void QAudioDecoder::bufferReady()


static void _init_f_bufferReady_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_bufferReady_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->bufferReady ();
}


// qint64 QAudioDecoder::duration()


static void _init_f_duration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_duration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAudioDecoder *)cls)->duration ());
}


// void QAudioDecoder::durationChanged(qint64 duration)


static void _init_f_durationChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("duration");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_durationChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->durationChanged (arg1);
}


// QAudioDecoder::Error QAudioDecoder::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAudioDecoder::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAudioDecoder::Error>::target_type > ((qt_gsi::Converter<QAudioDecoder::Error>::target_type)qt_gsi::CppToQtAdaptor<QAudioDecoder::Error>(((QAudioDecoder *)cls)->error ()));
}


// void QAudioDecoder::error(QAudioDecoder::Error error)


static void _init_f_error_2347 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<const qt_gsi::Converter<QAudioDecoder::Error>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_error_2347 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAudioDecoder::Error>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAudioDecoder::Error>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->error (qt_gsi::QtToCppAdaptor<QAudioDecoder::Error>(arg1).cref());
}


// QString QAudioDecoder::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAudioDecoder *)cls)->errorString ());
}


// void QAudioDecoder::finished()


static void _init_f_finished_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_finished_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->finished ();
}


// void QAudioDecoder::formatChanged(const QAudioFormat &format)


static void _init_f_formatChanged_2509 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QAudioFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_formatChanged_2509 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioFormat &arg1 = gsi::arg_reader<const QAudioFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->formatChanged (arg1);
}


// bool QAudioDecoder::isDecoding()


static void _init_f_isDecoding_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDecoding_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAudioDecoder *)cls)->isDecoding ());
}


// void QAudioDecoder::isDecodingChanged(bool)


static void _init_f_isDecodingChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_isDecodingChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->isDecodingChanged (arg1);
}


// bool QAudioDecoder::isSupported()


static void _init_f_isSupported_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSupported_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAudioDecoder *)cls)->isSupported ());
}


// qint64 QAudioDecoder::position()


static void _init_f_position_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_position_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAudioDecoder *)cls)->position ());
}


// void QAudioDecoder::positionChanged(qint64 position)


static void _init_f_positionChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_positionChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->positionChanged (arg1);
}


// QAudioBuffer QAudioDecoder::read()


static void _init_f_read_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioBuffer > ();
}

static void _call_f_read_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioBuffer > ((QAudioBuffer)((QAudioDecoder *)cls)->read ());
}


// void QAudioDecoder::setAudioFormat(const QAudioFormat &format)


static void _init_f_setAudioFormat_2509 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QAudioFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAudioFormat_2509 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioFormat &arg1 = gsi::arg_reader<const QAudioFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->setAudioFormat (arg1);
}


// void QAudioDecoder::setSource(const QUrl &fileName)


static void _init_f_setSource_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSource_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->setSource (arg1);
}


// void QAudioDecoder::setSourceDevice(QIODevice *device)


static void _init_f_setSourceDevice_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSourceDevice_1447 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->setSourceDevice (arg1);
}


// QUrl QAudioDecoder::source()


static void _init_f_source_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QUrl > ();
}

static void _call_f_source_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QUrl > ((QUrl)((QAudioDecoder *)cls)->source ());
}


// void QAudioDecoder::sourceChanged()


static void _init_f_sourceChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_sourceChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->sourceChanged ();
}


// QIODevice *QAudioDecoder::sourceDevice()


static void _init_f_sourceDevice_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_f_sourceDevice_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIODevice * > ((QIODevice *)((QAudioDecoder *)cls)->sourceDevice ());
}


// void QAudioDecoder::start()


static void _init_f_start_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_start_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->start ();
}


// void QAudioDecoder::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->stop ();
}


// static QString QAudioDecoder::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAudioDecoder::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QAudioDecoder () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":audioFormat", "@brief Method QAudioFormat QAudioDecoder::audioFormat()\n", true, &_init_f_audioFormat_c0, &_call_f_audioFormat_c0);
  methods += new qt_gsi::GenericMethod (":bufferAvailable", "@brief Method bool QAudioDecoder::bufferAvailable()\n", true, &_init_f_bufferAvailable_c0, &_call_f_bufferAvailable_c0);
  methods += new qt_gsi::GenericMethod ("bufferAvailableChanged", "@brief Method void QAudioDecoder::bufferAvailableChanged(bool)\n", false, &_init_f_bufferAvailableChanged_864, &_call_f_bufferAvailableChanged_864);
  methods += new qt_gsi::GenericMethod ("bufferReady", "@brief Method void QAudioDecoder::bufferReady()\n", false, &_init_f_bufferReady_0, &_call_f_bufferReady_0);
  methods += new qt_gsi::GenericMethod ("duration", "@brief Method qint64 QAudioDecoder::duration()\n", true, &_init_f_duration_c0, &_call_f_duration_c0);
  methods += new qt_gsi::GenericMethod ("durationChanged", "@brief Method void QAudioDecoder::durationChanged(qint64 duration)\n", false, &_init_f_durationChanged_986, &_call_f_durationChanged_986);
  methods += new qt_gsi::GenericMethod (":error", "@brief Method QAudioDecoder::Error QAudioDecoder::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("error_sig", "@brief Method void QAudioDecoder::error(QAudioDecoder::Error error)\n", false, &_init_f_error_2347, &_call_f_error_2347);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QAudioDecoder::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("finished", "@brief Method void QAudioDecoder::finished()\n", false, &_init_f_finished_0, &_call_f_finished_0);
  methods += new qt_gsi::GenericMethod ("formatChanged", "@brief Method void QAudioDecoder::formatChanged(const QAudioFormat &format)\n", false, &_init_f_formatChanged_2509, &_call_f_formatChanged_2509);
  methods += new qt_gsi::GenericMethod ("isDecoding?", "@brief Method bool QAudioDecoder::isDecoding()\n", true, &_init_f_isDecoding_c0, &_call_f_isDecoding_c0);
  methods += new qt_gsi::GenericMethod ("isDecodingChanged?", "@brief Method void QAudioDecoder::isDecodingChanged(bool)\n", false, &_init_f_isDecodingChanged_864, &_call_f_isDecodingChanged_864);
  methods += new qt_gsi::GenericMethod ("isSupported?", "@brief Method bool QAudioDecoder::isSupported()\n", true, &_init_f_isSupported_c0, &_call_f_isSupported_c0);
  methods += new qt_gsi::GenericMethod ("position", "@brief Method qint64 QAudioDecoder::position()\n", true, &_init_f_position_c0, &_call_f_position_c0);
  methods += new qt_gsi::GenericMethod ("positionChanged", "@brief Method void QAudioDecoder::positionChanged(qint64 position)\n", false, &_init_f_positionChanged_986, &_call_f_positionChanged_986);
  methods += new qt_gsi::GenericMethod ("read", "@brief Method QAudioBuffer QAudioDecoder::read()\n", true, &_init_f_read_c0, &_call_f_read_c0);
  methods += new qt_gsi::GenericMethod ("setAudioFormat|audioFormat=", "@brief Method void QAudioDecoder::setAudioFormat(const QAudioFormat &format)\n", false, &_init_f_setAudioFormat_2509, &_call_f_setAudioFormat_2509);
  methods += new qt_gsi::GenericMethod ("setSource", "@brief Method void QAudioDecoder::setSource(const QUrl &fileName)\n", false, &_init_f_setSource_1701, &_call_f_setSource_1701);
  methods += new qt_gsi::GenericMethod ("setSourceDevice|sourceDevice=", "@brief Method void QAudioDecoder::setSourceDevice(QIODevice *device)\n", false, &_init_f_setSourceDevice_1447, &_call_f_setSourceDevice_1447);
  methods += new qt_gsi::GenericMethod ("source", "@brief Method QUrl QAudioDecoder::source()\n", true, &_init_f_source_c0, &_call_f_source_c0);
  methods += new qt_gsi::GenericMethod ("sourceChanged", "@brief Method void QAudioDecoder::sourceChanged()\n", false, &_init_f_sourceChanged_0, &_call_f_sourceChanged_0);
  methods += new qt_gsi::GenericMethod (":sourceDevice", "@brief Method QIODevice *QAudioDecoder::sourceDevice()\n", true, &_init_f_sourceDevice_c0, &_call_f_sourceDevice_c0);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method void QAudioDecoder::start()\n", false, &_init_f_start_0, &_call_f_start_0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QAudioDecoder::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAudioDecoder::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QAudioDecoder> decl_QAudioDecoder (qtdecl_QObject (), "QtMultimedia", "QAudioDecoder_Native",
  methods_QAudioDecoder (),
  "@hide\n@alias QAudioDecoder");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QAudioDecoder> &qtdecl_QAudioDecoder () { return decl_QAudioDecoder; }

}


class QAudioDecoder_Adaptor : public QAudioDecoder, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAudioDecoder_Adaptor();

  //  [adaptor ctor] QAudioDecoder::QAudioDecoder(QObject *parent)
  QAudioDecoder_Adaptor() : QAudioDecoder()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAudioDecoder::QAudioDecoder(QObject *parent)
  QAudioDecoder_Adaptor(QObject *parent) : QAudioDecoder(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QAudioDecoder::isSignalConnected(const QMetaMethod &signal)
  bool fp_QAudioDecoder_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QAudioDecoder::isSignalConnected(signal);
  }

  //  [expose] int QAudioDecoder::receivers(const char *signal)
  int fp_QAudioDecoder_receivers_c1731 (const char *signal) const {
    return QAudioDecoder::receivers(signal);
  }

  //  [expose] QObject *QAudioDecoder::sender()
  QObject * fp_QAudioDecoder_sender_c0 () const {
    return QAudioDecoder::sender();
  }

  //  [expose] int QAudioDecoder::senderSignalIndex()
  int fp_QAudioDecoder_senderSignalIndex_c0 () const {
    return QAudioDecoder::senderSignalIndex();
  }

  //  [adaptor impl] bool QAudioDecoder::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QAudioDecoder::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAudioDecoder_Adaptor, bool, QEvent *>(&QAudioDecoder_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QAudioDecoder::event(_event);
    }
  }

  //  [adaptor impl] bool QAudioDecoder::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QAudioDecoder::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAudioDecoder_Adaptor, bool, QObject *, QEvent *>(&QAudioDecoder_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QAudioDecoder::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QAudioDecoder::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QAudioDecoder::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAudioDecoder_Adaptor, QChildEvent *>(&QAudioDecoder_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QAudioDecoder::childEvent(event);
    }
  }

  //  [adaptor impl] void QAudioDecoder::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QAudioDecoder::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAudioDecoder_Adaptor, QEvent *>(&QAudioDecoder_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QAudioDecoder::customEvent(event);
    }
  }

  //  [adaptor impl] void QAudioDecoder::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QAudioDecoder::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QAudioDecoder_Adaptor, const QMetaMethod &>(&QAudioDecoder_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QAudioDecoder::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAudioDecoder::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QAudioDecoder::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAudioDecoder_Adaptor, QTimerEvent *>(&QAudioDecoder_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QAudioDecoder::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAudioDecoder_Adaptor::~QAudioDecoder_Adaptor() { }

//  Constructor QAudioDecoder::QAudioDecoder(QObject *parent) (adaptor class)

static void _init_ctor_QAudioDecoder_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QAudioDecoder_Adaptor> ();
}

static void _call_ctor_QAudioDecoder_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QAudioDecoder_Adaptor *> (new QAudioDecoder_Adaptor (arg1));
}


// void QAudioDecoder::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoder_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QAudioDecoder::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoder_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QAudioDecoder::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoder_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QAudioDecoder::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAudioDecoder_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoder_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QAudioDecoder::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAudioDecoder_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoder_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QAudioDecoder::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QAudioDecoder_Adaptor *)cls)->fp_QAudioDecoder_isSignalConnected_c2394 (arg1));
}


// exposed int QAudioDecoder::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QAudioDecoder_Adaptor *)cls)->fp_QAudioDecoder_receivers_c1731 (arg1));
}


// exposed QObject *QAudioDecoder::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAudioDecoder_Adaptor *)cls)->fp_QAudioDecoder_sender_c0 ());
}


// exposed int QAudioDecoder::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAudioDecoder_Adaptor *)cls)->fp_QAudioDecoder_senderSignalIndex_c0 ());
}


// void QAudioDecoder::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoder_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QAudioDecoder> &qtdecl_QAudioDecoder ();

static gsi::Methods methods_QAudioDecoder_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAudioDecoder::QAudioDecoder(QObject *parent)\nThis method creates an object of class QAudioDecoder.", &_init_ctor_QAudioDecoder_Adaptor_1302, &_call_ctor_QAudioDecoder_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAudioDecoder::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAudioDecoder::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAudioDecoder::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QAudioDecoder::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAudioDecoder::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QAudioDecoder::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QAudioDecoder::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QAudioDecoder::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QAudioDecoder::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAudioDecoder::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QAudioDecoder_Adaptor> decl_QAudioDecoder_Adaptor (qtdecl_QAudioDecoder (), "QtMultimedia", "QAudioDecoder",
  methods_QAudioDecoder_Adaptor (),
  "@qt\n@brief Binding of QAudioDecoder");

}


//  Implementation of the enum wrapper class for QAudioDecoder::Error
namespace qt_gsi
{

static gsi::Enum<QAudioDecoder::Error> decl_QAudioDecoder_Error_Enum ("QtMultimedia", "QAudioDecoder_Error",
    gsi::enum_const ("NoError", QAudioDecoder::NoError, "@brief Enum constant QAudioDecoder::NoError") +
    gsi::enum_const ("ResourceError", QAudioDecoder::ResourceError, "@brief Enum constant QAudioDecoder::ResourceError") +
    gsi::enum_const ("FormatError", QAudioDecoder::FormatError, "@brief Enum constant QAudioDecoder::FormatError") +
    gsi::enum_const ("AccessDeniedError", QAudioDecoder::AccessDeniedError, "@brief Enum constant QAudioDecoder::AccessDeniedError") +
    gsi::enum_const ("NotSupportedError", QAudioDecoder::NotSupportedError, "@brief Enum constant QAudioDecoder::NotSupportedError"),
  "@qt\n@brief This class represents the QAudioDecoder::Error enum");

static gsi::QFlagsClass<QAudioDecoder::Error > decl_QAudioDecoder_Error_Enums ("QtMultimedia", "QAudioDecoder_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QAudioDecoder::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAudioDecoder> inject_QAudioDecoder_Error_Enum_in_parent (decl_QAudioDecoder_Error_Enum.defs ());
static gsi::ClassExt<QAudioDecoder> decl_QAudioDecoder_Error_Enum_as_child (decl_QAudioDecoder_Error_Enum, "Error");
static gsi::ClassExt<QAudioDecoder> decl_QAudioDecoder_Error_Enums_as_child (decl_QAudioDecoder_Error_Enums, "QFlags_Error");

}

