/*****************************************************************************
 * Copyright (C) 2008-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "profileipsecoptions.h"

#include <QtGui/QCheckBox>
#include <QtGui/QGroupBox>
#include <QtGui/QLabel>
#include <QtGui/QWhatsThis>

#include <kcombobox.h>
#include <klineedit.h>
#include <klocale.h>

#include "widgetnotifyhelper.h"

ProfileIpsecOptions::ProfileIpsecOptions(QWidget *parent) : QWidget(parent)
{
    setupUi(this);
    WidgetNotifyHelper h;
    h.setupChangedAction(this);
    dialogModified = false;
	
	connect(LocalIdTypeCombobox, SIGNAL(textChanged(const QString&)), this, SLOT(localIDTypeToggled(const QString&))); 
	connect(RemoteIdTypeCombobox, SIGNAL(textChanged(const QString&)), this, SLOT(remoteIDTypeToggled(const QString&)));
	connect(PerfectForwardSecurityCheckbox, SIGNAL(toggled(bool)), this, SLOT(usePfsToogled(bool)));
	
	IkeHelpActiveLabel->setToolTip(i18n("<h1>IPSec IKE algorithms</h1>"
										"<p>You have to specify the IKE values in the following format:"
										"\n<nobr>&lt;encryption algorithm&gt;-&lt;authentication algorithm&gt;"
										"</nobr>\nor\n<nobr>&lt;encryption algorithm&gt;-&lt;authentication algorithm&gt;-&lt;diffie hellman group&gt;</nobr></p>"));
	EspHelpActiveLabel->setToolTip(i18n("<h1>IPSec ESP algorithms</h1>"
										"<nobr>You have to specify the ESP values in the following format:"
										"\n<b>&lt;encryption algorithm&gt;-&lt;authentication algorithm&gt;"));
}

ProfileIpsecOptions::~ProfileIpsecOptions()
{
}

void ProfileIpsecOptions::useRightNextHopToggled(bool)
{
    if (UseRightNextHopCheckBox->isChecked())
        RightNextHopLineEdit->setEnabled(true);
    else
        RightNextHopLineEdit->setEnabled(false);
}

void ProfileIpsecOptions::useLeftNextHopToggled(bool)
{
    if (UseLeftNextHopCheckBox->isChecked())
        LeftNextHopLineEdit->setEnabled(true);
    else
        LeftNextHopLineEdit->setEnabled(false);
}

void ProfileIpsecOptions::dialogChanged()
{
    dialogModified = true;
}

void ProfileIpsecOptions::useIkeToggled(bool)
{
    if (UseCustomIkeCheckBox->isChecked())
        IkeGroupBox->setEnabled(true);
    else
        IkeGroupBox->setEnabled(false);
}

void ProfileIpsecOptions::useEspToogled(bool)
{
    if (UseCustomEspCheckBox->isChecked())
        EspGroupBox->setEnabled(true);
    else
        EspGroupBox->setEnabled(false);
}

void ProfileIpsecOptions::localIDTypeToggled(const QString& text)
{
    if (text == "asn1dn" || text == i18n("Certificate ID")) {
        LocalIDLineEdit->setDisabled(true);
        LocalIDLabel->setDisabled(true);
    } else {
        LocalIDLineEdit->setDisabled(false);
        LocalIDLabel->setDisabled(false);
    }
}

void ProfileIpsecOptions::remoteIDTypeToggled(const QString& text)
{
	if (text == "asn1dn" || text == i18n("Certificate ID"))
	{
		RemoteIDLineEdit->setDisabled(true);
		RemoteIDLabel->setDisabled(true);
	}
	else
	{
		RemoteIDLineEdit->setDisabled(false);
		RemoteIDLabel->setDisabled(false);
	}
}

void ProfileIpsecOptions::ikeHelpClicked(int, int)
{
    QWhatsThis::showText(QCursor::pos(),
                         i18n("<h1>IPSec IKE algorithms</h1>"
                              "<p>You have to specify the IKE values in the following format:"
                              "\n<nobr>&lt;encryption algorithm&gt;-&lt;authentication algorithm&gt;"
                              "</nobr>\nor\n<nobr>&lt;encryption algorithm&gt;-&lt;authentication algorithm&gt;-&lt;diffie hellman group&gt;</nobr></p>"),
                         (QWidget *)IkeHelpActiveLabel);
}


void ProfileIpsecOptions::espHelpClicked(int, int)
{
    QWhatsThis::showText(QCursor::pos(),
                         i18n("<h1>IPSec ESP algorithms</h1>"
                              "<nobr>You have to specify the ESP values in the following format:"
                              "\n<b>&lt;encryption algorithm&gt;-&lt;authentication algorithm&gt;"
                              "</nobr>\nor\n<nobr>&lt;encryption algorithm&gt;-&lt;authentication algorithm&gt;</nobr></p>"),
                         (QWidget *)EspHelpActiveLabel);
}


void ProfileIpsecOptions::usePfsToogled(bool)
{
	if (PerfectForwardSecurityCheckbox->isChecked())
		PerfectForwardSecrecyCombobox->setEnabled(true);
	else
		PerfectForwardSecrecyCombobox->setEnabled(false);
}



